#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Kentucky Route Zero
# send your bug reports to contact@dotslashplay.it
###

script_version=20241224.2

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='kentucky-route-zero'
GAME_NAME='Kentucky Route Zero'

ARCHIVE_BASE_0_NAME='KentuckyRouteZero_Linux_v27.zip'
ARCHIVE_BASE_0_MD5='19cb27f6aa0cd98f9122ae4240cdd2a1'
ARCHIVE_BASE_0_SIZE='1786819'
ARCHIVE_BASE_0_VERSION='27-humble1'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/kentucky-route-zero'

ARCHIVE_BASE_MULTIARCH_0_NAME='KentuckyRouteZero_Linux_v17.zip'
ARCHIVE_BASE_MULTIARCH_0_MD5='36c7b89c223d5c77d4d44b7ccf72f241'
ARCHIVE_BASE_MULTIARCH_0_SIZE='690000'
ARCHIVE_BASE_MULTIARCH_0_VERSION='17-humble1'

UNITY3D_NAME='KentuckyRouteZero'
UNITY3D_PLUGINS_MULTIARCH='
ScreenSelector.so'

CONTENT_PATH_DEFAULT='KentuckyRouteZero'
CONTENT_PATH_DEFAULT_MULTIARCH='.'
CONTENT_DOC_DATA_FILES='
README.txt
RELEASE_NOTES.txt'

FAKE_HOME_PERSISTENT_DIRECTORIES_MULTIARCH='
Documents/KentuckyRouteZero'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'
PACKAGES_LIST_MULTIARCH='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1'
PKG_BIN_DEPENDENCIES_LIBRARIES_MULTIARCH='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libGLU.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES_MULTIARCH="$PKG_BIN_DEPENDENCIES_LIBRARIES_MULTIARCH"
PKG_BIN32_DEPENDENCIES_LIBRARIES_MULTIARCH="$PKG_BIN_DEPENDENCIES_LIBRARIES_MULTIARCH"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

case "$(current_archive)" in
	('ARCHIVE_BASE_MULTIARCH_'*)
		launchers_generation 'PKG_BIN64'
		launchers_generation 'PKG_BIN32'
	;;
	(*)
		launchers_generation 'PKG_BIN'
	;;
esac

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
