/*
 * utils/BtException.h is part of Brewtarget, and is copyright the following
 * authors 2021:
 * - Matt Young <mfsy@yahoo.com>
 *
 * Brewtarget is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Brewtarget is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef UTILS_BTEXCEPTION_H
#define UTILS_BTEXCEPTION_H
#pragma once

#include <stdexcept>

#include <QString>

/**
 * \class BtException is a specialisation of \c std::runtime_error that allows us (a) to construct exceptions with
 *                    \c QString instead of \c std::string and (b) to have a stack trace of the location from which the
 *                    exception was thrown
 */
class BtException : public std::runtime_error {
public:
   BtException(QString const & what_arg);
   ~BtException();

   QString const & getStackTrace() const;
private:
   QString stackTrace;
};
#endif
