/*  =========================================================================
    zlistx - extended generic list container

    Copyright (c) the Contributors as noted in the AUTHORS file.
    This file is part of CZMQ, the high-level C binding for 0MQ:
    http://czmq.zeromq.org.

    This Source Code Form is subject to the terms of the Mozilla Public
    License, v. 2.0. If a copy of the MPL was not distributed with this
    file, You can obtain one at http://mozilla.org/MPL/2.0/.
    =========================================================================
*/

#ifndef __ZLISTX_H_INCLUDED__
#define __ZLISTX_H_INCLUDED__

#ifdef __cplusplus
extern "C" {
#endif

//  @warning THE FOLLOWING @INTERFACE BLOCK IS AUTO-GENERATED BY ZPROJECT
//  @warning Please edit the model at "api/zlistx.api" to make changes.
//  @interface
//  This is a stable class, and may not change except for emergencies. It
//  is provided in stable builds.
//  This class has draft methods, which may change over time. They are not
//  in stable releases, by default. Use --enable-drafts to enable.
// Destroy an item
typedef void (zlistx_destructor_fn) (
    void **item);

// Duplicate an item
typedef void * (zlistx_duplicator_fn) (
    const void *item);

// Compare two items, for sorting
typedef int (zlistx_comparator_fn) (
    const void *item1, const void *item2);

//  Create a new, empty list.
CZMQ_EXPORT zlistx_t *
    zlistx_new (void);

//  Destroy a list. If an item destructor was specified, all items in the
//  list are automatically destroyed as well.
CZMQ_EXPORT void
    zlistx_destroy (zlistx_t **self_p);

//  Add an item to the head of the list. Calls the item duplicator, if any,
//  on the item. Resets cursor to list head. Returns an item handle on
//  success, NULL if memory was exhausted.
CZMQ_EXPORT void *
    zlistx_add_start (zlistx_t *self, void *item);

//  Add an item to the tail of the list. Calls the item duplicator, if any,
//  on the item. Resets cursor to list head. Returns an item handle on
//  success, NULL if memory was exhausted.
CZMQ_EXPORT void *
    zlistx_add_end (zlistx_t *self, void *item);

//  Return the number of items in the list
CZMQ_EXPORT size_t
    zlistx_size (zlistx_t *self);

//  Return first item in the list, or null, leaves the cursor
CZMQ_EXPORT void *
    zlistx_head (zlistx_t *self);

//  Return last item in the list, or null, leaves the cursor
CZMQ_EXPORT void *
    zlistx_tail (zlistx_t *self);

//  Return the item at the head of list. If the list is empty, returns NULL.
//  Leaves cursor pointing at the head item, or NULL if the list is empty.
CZMQ_EXPORT void *
    zlistx_first (zlistx_t *self);

//  Return the next item. At the end of the list (or in an empty list),
//  returns NULL. Use repeated zlistx_next () calls to work through the list
//  from zlistx_first (). First time, acts as zlistx_first().
CZMQ_EXPORT void *
    zlistx_next (zlistx_t *self);

//  Return the previous item. At the start of the list (or in an empty list),
//  returns NULL. Use repeated zlistx_prev () calls to work through the list
//  backwards from zlistx_last (). First time, acts as zlistx_last().
CZMQ_EXPORT void *
    zlistx_prev (zlistx_t *self);

//  Return the item at the tail of list. If the list is empty, returns NULL.
//  Leaves cursor pointing at the tail item, or NULL if the list is empty.
CZMQ_EXPORT void *
    zlistx_last (zlistx_t *self);

//  Returns the value of the item at the cursor, or NULL if the cursor is
//  not pointing to an item.
CZMQ_EXPORT void *
    zlistx_item (zlistx_t *self);

//  Returns the handle of the item at the cursor, or NULL if the cursor is
//  not pointing to an item.
CZMQ_EXPORT void *
    zlistx_cursor (zlistx_t *self);

//  Returns the item associated with the given list handle, or NULL if passed
//  in handle is NULL. Asserts that the passed in handle points to a list element.
CZMQ_EXPORT void *
    zlistx_handle_item (void *handle);

//  Find an item in the list, searching from the start. Uses the item
//  comparator, if any, else compares item values directly. Returns the
//  item handle found, or NULL. Sets the cursor to the found item, if any.
CZMQ_EXPORT void *
    zlistx_find (zlistx_t *self, void *item);

//  Detach an item from the list, using its handle. The item is not modified,
//  and the caller is responsible for destroying it if necessary. If handle is
//  null, detaches the first item on the list. Returns item that was detached,
//  or null if none was. If cursor was at item, moves cursor to previous item,
//  so you can detach items while iterating forwards through a list.
CZMQ_EXPORT void *
    zlistx_detach (zlistx_t *self, void *handle);

//  Detach item at the cursor, if any, from the list. The item is not modified,
//  and the caller is responsible for destroying it as necessary. Returns item
//  that was detached, or null if none was. Moves cursor to previous item, so
//  you can detach items while iterating forwards through a list.
CZMQ_EXPORT void *
    zlistx_detach_cur (zlistx_t *self);

//  Delete an item, using its handle. Calls the item destructor if any is
//  set. If handle is null, deletes the first item on the list. Returns 0
//  if an item was deleted, -1 if not. If cursor was at item, moves cursor
//  to previous item, so you can delete items while iterating forwards
//  through a list.
CZMQ_EXPORT int
    zlistx_delete (zlistx_t *self, void *handle);

//  Move an item to the start of the list, via its handle.
CZMQ_EXPORT void
    zlistx_move_start (zlistx_t *self, void *handle);

//  Move an item to the end of the list, via its handle.
CZMQ_EXPORT void
    zlistx_move_end (zlistx_t *self, void *handle);

//  Remove all items from the list, and destroy them if the item destructor
//  is set.
CZMQ_EXPORT void
    zlistx_purge (zlistx_t *self);

//  Sort the list. If an item comparator was set, calls that to compare
//  items, otherwise compares on item value. The sort is not stable, so may
//  reorder equal items.
CZMQ_EXPORT void
    zlistx_sort (zlistx_t *self);

//  Create a new node and insert it into a sorted list. Calls the item
//  duplicator, if any, on the item. If low_value is true, starts searching
//  from the start of the list, otherwise searches from the end. Use the item
//  comparator, if any, to find where to place the new node. Returns a handle
//  to the new node, or NULL if memory was exhausted. Resets the cursor to the
//  list head.
CZMQ_EXPORT void *
    zlistx_insert (zlistx_t *self, void *item, bool low_value);

//  Move an item, specified by handle, into position in a sorted list. Uses
//  the item comparator, if any, to determine the new location. If low_value
//  is true, starts searching from the start of the list, otherwise searches
//  from the end.
CZMQ_EXPORT void
    zlistx_reorder (zlistx_t *self, void *handle, bool low_value);

//  Make a copy of the list; items are duplicated if you set a duplicator
//  for the list, otherwise not. Copying a null reference returns a null
//  reference.
CZMQ_EXPORT zlistx_t *
    zlistx_dup (zlistx_t *self);

//  Set a user-defined deallocator for list items; by default items are not
//  freed when the list is destroyed.
CZMQ_EXPORT void
    zlistx_set_destructor (zlistx_t *self, zlistx_destructor_fn destructor);

//  Set a user-defined duplicator for list items; by default items are not
//  copied when the list is duplicated.
CZMQ_EXPORT void
    zlistx_set_duplicator (zlistx_t *self, zlistx_duplicator_fn duplicator);

//  Set a user-defined comparator for zlistx_find and zlistx_sort; the method
//  must return -1, 0, or 1 depending on whether item1 is less than, equal to,
//  or greater than, item2.
CZMQ_EXPORT void
    zlistx_set_comparator (zlistx_t *self, zlistx_comparator_fn comparator);

//  Self test of this class.
CZMQ_EXPORT void
    zlistx_test (bool verbose);

#ifdef CZMQ_BUILD_DRAFT_API
//  *** Draft method, for development use, may change without warning ***
//  Unpack binary frame into a new list. Packed data must follow format
//  defined by zlistx_pack. List is set to autofree. An empty frame
//  unpacks to an empty list.
CZMQ_EXPORT zlistx_t *
    zlistx_unpack (zframe_t *frame);

//  *** Draft method, for development use, may change without warning ***
//  Serialize list to a binary frame that can be sent in a message.
//  The packed format is compatible with the 'strings' type implemented by zproto:
//
//     ; A list of strings
//     list            = list-count *longstr
//     list-count      = number-4
//
//     ; Strings are always length + text contents
//     longstr         = number-4 *VCHAR
//
//     ; Numbers are unsigned integers in network byte order
//     number-4        = 4OCTET
//  Caller owns return value and must destroy it when done.
CZMQ_EXPORT zframe_t *
    zlistx_pack (zlistx_t *self);

#endif // CZMQ_BUILD_DRAFT_API
//  @end


#ifdef __cplusplus
}
#endif

#endif
