import java.io.Reader;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

import org.apache.derby.optional.api.LuceneIndexDescriptor;
import org.apache.derby.optional.api.LuceneUtils;

/**
 * Vacuous extension of the default Lucene analyzer. Used
 * to test that Analyzers can be loaded from jar files in the
 * database. Build this class with Java 6 and put the source and
 * class into java/testing/org/apache/derbyTesting/functionTests/tests/lang/myLuceneClasses.jar
 */
public  class   MyAnalyzer  extends Analyzer
{
    public  MyAnalyzer()
    {}
    
    protected TokenStreamComponents createComponents
        ( String fieldName, Reader reader )
    {
        StandardTokenizer source = new StandardTokenizer( LuceneUtils.currentVersion(), reader );
        StandardFilter filter = new StandardFilter( LuceneUtils.currentVersion(), source );
        return new TokenStreamComponents( source, filter );
    }

    public static LuceneIndexDescriptor    makeMyIndexDescriptor()
    {
        return new MyIndexDescriptor();
    }

    public static class MyIndexDescriptor extends LuceneUtils.DefaultIndexDescriptor
    {
        public  MyIndexDescriptor() { super(); }
        
        public Analyzer getAnalyzer()   { return new MyAnalyzer(); }
    }
}
