/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.BaseInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.logging.Level;

final class AsciiFilteredUnicodeInputStream
extends InputStream {
    private final Reader containedReader;
    private final Charset asciiCharSet;
    private final byte[] bSingleByte = new byte[1];

    static AsciiFilteredUnicodeInputStream MakeAsciiFilteredUnicodeInputStream(BaseInputStream baseInputStream, Reader reader) throws SQLServerException {
        if (baseInputStream.logger.isLoggable(Level.FINE)) {
            baseInputStream.logger.fine(baseInputStream.toLogString() + " wrapping in AsciiFilteredInputStream");
        }
        return new AsciiFilteredUnicodeInputStream(reader);
    }

    private AsciiFilteredUnicodeInputStream(Reader reader) throws SQLServerException {
        this.containedReader = reader;
        this.asciiCharSet = Charset.forName("US-ASCII");
    }

    public void close() throws IOException {
        this.containedReader.close();
    }

    public long skip(long l) throws IOException {
        return this.containedReader.skip(l);
    }

    public int available() throws IOException {
        return 0;
    }

    public int read() throws IOException {
        int n = this.read(this.bSingleByte);
        return -1 == n ? -1 : this.bSingleByte[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        char[] cArray = new char[n2];
        int n3 = this.containedReader.read(cArray);
        if (n3 > 0) {
            if (n3 < n2) {
                n2 = n3;
            }
            ByteBuffer byteBuffer = this.asciiCharSet.encode(CharBuffer.wrap(cArray));
            byteBuffer.get(byArray, n, n2);
        }
        return n3;
    }

    public boolean markSupported() {
        return this.containedReader.markSupported();
    }

    public void mark(int n) {
        try {
            this.containedReader.mark(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reset() throws IOException {
        this.containedReader.reset();
    }
}

