# Copyright (C) 2023 Collabora Limited
#
# Author: Igor Ponomarev <igor.ponomarev@collabora.com>
#
# SPDX-License-Identifier: GPL-2.0-or-later

# Generated by Django 2.2.26 on 2023-06-29 10:37

from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("lava_scheduler_app", "0057_dt_permissions_worker_master_version"),
    ]

    operations = [
        migrations.AddIndex(
            model_name="testjob",
            index=models.Index(
                fields=["-submit_time"], name="lava_schedu_submit__1a8a33_idx"
            ),
        ),
        migrations.AlterField(
            model_name="testjob",
            name="submit_time",
            field=models.DateTimeField(auto_now_add=True, verbose_name="Submit time"),
        ),
        migrations.AddIndex(
            model_name="testjob",
            index=models.Index(
                fields=["-start_time"], name="lava_schedu_start_t_b7d703_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="testjob",
            index=models.Index(
                fields=["-end_time"], name="lava_schedu_end_tim_cdac7b_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="testjob",
            index=models.Index(
                fields=["requested_device_type", "-submit_time"],
                name="device_type_jobs_index",
            ),
        ),
        migrations.AddIndex(
            model_name="testjob",
            index=models.Index(
                fields=["actual_device", "-submit_time"], name="device_jobs_index"
            ),
        ),
        migrations.AddIndex(
            model_name="testjob",
            index=models.Index(
                condition=models.Q(
                    models.Q(_negated=True, state=5), ("actual_device__isnull", False)
                ),
                fields=["actual_device"],
                name="current_job_prefetch_index",
            ),
        ),
        migrations.AddIndex(
            model_name="testjob",
            index=models.Index(
                condition=models.Q(state=0),
                fields=["requested_device_type", "id"],
                name="job_queued_per_device_type_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="testjob",
            index=models.Index(
                condition=models.Q(health_check=True),
                fields=["requested_device_type", "-submit_time", "id", "health"],
                name="health_checks_count_idx",
            ),
        ),
    ]
