/***********************************************************************************

    Copyright (C) 2007-2020 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_WIDGET_CALENDAR_HEADER
#define LIFEOGRAPH_WIDGET_CALENDAR_HEADER


#include <gtkmm/drawingarea.h>
#include <gtkmm/builder.h>

#include "../helpers.hpp"
#include "calendar.hpp"


namespace LIFEO
{

using namespace HELPERS;


class WidgetCalendar : public Gtk::DrawingArea, public Calendar
{
    public:
        WidgetCalendar();

        void                        update() override
        {
            if( Glib::RefPtr< Gdk::Window > window = get_window() )
                window->invalidate( false );
        }

        void                        set_editable( bool );

        void                        set_selected_day_from_coords( int, int );

        void                        show_Po( int, int );

        SignalVoid                  signal_month_changed()
        { return m_Sg_month_changed; }
        SignalVoidDate              signal_day_selected()
        { return m_Sg_day_selected; }
        SignalVoidDateUstring       signal_day_add()
        { return m_Sg_day_add; }
        SignalVoid                  signal_chapter_add()
        { return m_Sg_chapter_add; }

    protected:
        void                        on_size_allocate( Gtk::Allocation& ) override;
        bool                        on_scroll_event( GdkEventScroll* ) override;
        bool                        on_button_press_event( GdkEventButton* ) override;
        //bool                        on_button_release_event( GdkEventButton* ) override;
        bool                        on_motion_notify_event( GdkEventMotion* ) override;
        bool                        on_leave_notify_event( GdkEventCrossing* ) override;
        bool                        on_draw( const Cairo::RefPtr< Cairo::Context >& ) override;

        // DRAG SOURCE METHODS
        void                        on_drag_begin(
                                        const Glib::RefPtr< Gdk::DragContext >& ) override;
        void                        on_drag_data_get( const Glib::RefPtr< Gdk::DragContext >&,
                                                      Gtk::SelectionData&, guint, guint ) override;
        void                        on_drag_end(
                                        const Glib::RefPtr< Gdk::DragContext >& ) override;

        // DRAG TARGET METHODS
        bool                        on_drag_motion( const Glib::RefPtr< Gdk::DragContext >&,
                                                    int, int, guint ) override;
        bool                        on_drag_drop( const Glib::RefPtr< Gdk::DragContext >&,
                                                  int x, int y, guint time ) override;
        void                        on_drag_data_received( const Glib::RefPtr< Gdk::DragContext >&,
                                                           int, int, const Gtk::SelectionData&,
                                                           guint, guint ) override;

        Glib::RefPtr< Gtk::Builder >
                                    m_builder;
        Gtk::Popover*               m_Po_day;
        Gtk::Box*                   m_Bx_add;

        SignalVoid                  m_Sg_month_changed;
        SignalVoidDate              m_Sg_day_selected;
        SignalVoidDateUstring       m_Sg_day_add;
        SignalVoid                  m_Sg_chapter_add;

        bool                        m_flag_editable{ false };
        bool                        m_flag_expect_drag_data{ false };
};

} // end of namespace LIFEO

#endif
