/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.caliper.model.NewInstrumentSpec;
import com.google.caliper.model.NewMeasurement;
import com.google.caliper.model.NewRun;
import com.google.caliper.model.NewScenario;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.UUID;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class NewTrial {
    private final UUID id;
    private final NewRun run;
    private final NewInstrumentSpec instrumentSpec;
    private final NewScenario scenario;
    private final ImmutableList<NewMeasurement> measurements;

    private NewTrial(Builder builder) {
        this.id = builder.id;
        this.run = builder.run;
        this.instrumentSpec = builder.instrumentSpec;
        this.scenario = builder.scenario;
        this.measurements = builder.measurementsBuilder.build();
    }

    public UUID id() {
        return this.id;
    }

    public NewRun run() {
        return this.run;
    }

    public NewInstrumentSpec instrumentSpec() {
        return this.instrumentSpec;
    }

    public NewScenario scenario() {
        return this.scenario;
    }

    public ImmutableList<NewMeasurement> measurements() {
        return this.measurements;
    }

    public static final class Builder {
        private final UUID id;
        private NewRun run;
        private NewInstrumentSpec instrumentSpec;
        private NewScenario scenario;
        private final ImmutableList.Builder<NewMeasurement> measurementsBuilder = ImmutableList.builder();

        public Builder(UUID id) {
            this.id = (UUID)Preconditions.checkNotNull((Object)id);
        }

        public Builder run(NewRun.Builder runBuilder) {
            return this.run(runBuilder.build());
        }

        public Builder run(NewRun run) {
            this.run = (NewRun)Preconditions.checkNotNull((Object)run);
            return this;
        }

        public Builder instrumentSpec(NewInstrumentSpec.Builder instrumentSpecBuilder) {
            return this.instrumentSpec(instrumentSpecBuilder.build());
        }

        public Builder instrumentSpec(NewInstrumentSpec instrumentSpec) {
            this.instrumentSpec = (NewInstrumentSpec)Preconditions.checkNotNull((Object)instrumentSpec);
            return this;
        }

        public Builder scenario(NewScenario.Builder scenarioBuilder) {
            return this.scenario(scenarioBuilder.build());
        }

        public Builder scenario(NewScenario scenario) {
            this.scenario = (NewScenario)Preconditions.checkNotNull((Object)scenario);
            return this;
        }

        public Builder addMeasurement(NewMeasurement.Builder measurementBuilder) {
            return this.addMeasurement(measurementBuilder.build());
        }

        public Builder addMeasurement(NewMeasurement measurement) {
            this.measurementsBuilder.add((Object)measurement);
            return this;
        }

        public Builder addAllMeasurements(Iterable<NewMeasurement> measurements) {
            this.measurementsBuilder.addAll(measurements);
            return this;
        }

        public NewTrial build() {
            Preconditions.checkState((this.run != null ? 1 : 0) != 0);
            Preconditions.checkState((this.instrumentSpec != null ? 1 : 0) != 0);
            Preconditions.checkState((this.scenario != null ? 1 : 0) != 0);
            return new NewTrial(this);
        }
    }
}

