/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.api.Benchmark;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.caliper.runner.BenchmarkClass;
import com.google.caliper.runner.BenchmarkMethod;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.UserCodeException;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

abstract class AllocationInstrument
extends Instrument {
    AllocationInstrument() {
    }

    @Override
    public boolean isBenchmarkMethod(Method method) {
        return Instrument.isTimeMethod(method);
    }

    @Override
    public BenchmarkMethod createBenchmarkMethod(BenchmarkClass benchmarkClass, Method method) throws InvalidBenchmarkException {
        return Instrument.createBenchmarkMethodFromTimeMethod(benchmarkClass, method);
    }

    @Override
    public void dryRun(Benchmark benchmark, BenchmarkMethod benchmarkMethod) throws UserCodeException {
        Method m = benchmarkMethod.method();
        try {
            m.invoke((Object)benchmark, 1);
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (InvocationTargetException e) {
            Throwable userException = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)userException, SkipThisScenarioException.class);
            throw new UserCodeException(userException);
        }
    }

    @Override
    Iterable<String> getExtraCommandLineArgs() {
        String agentJar = (String)this.options.get((Object)"allocationAgentJar");
        if (agentJar == null || !new File(agentJar).exists()) {
            throw new IllegalStateException("Can't find required allocationinstrumenter agent jar");
        }
        return Iterables.concat(super.getExtraCommandLineArgs(), (Iterable)ImmutableList.of((Object)("-javaagent:" + agentJar)));
    }
}

