# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Communicator(Object):
    r"""
    Communicator - Used to send/receive messages in a multiprocess
    environment.
    
    Superclass: Object
    
    This is an abstract class which contains functionality for sending
    and receiving inter-process messages. It contains methods for
    marshaling an object into a string (currently used by the MPI
    communicator but not the shared memory communicator).
    
    @warning
    Communication between systems with different IdTypes is not
    supported. All machines have to have the same IdType.
    
    @sa
    MPICommunicator
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCommunicator, obj, update, **traits)
    
    number_of_processes = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        Set the number of processes you will be using.  This defaults to
        the maximum number available.  If you set this to a value higher
        than the default, you will get an error.
        """
    )

    def _number_of_processes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfProcesses,
                        self.number_of_processes)

    def _get_count(self):
        return self._vtk_obj.GetCount()
    count = traits.Property(_get_count, desc=\
        r"""
        Returns the number of words received by the most recent
        Receive(). Note that this is not the number of bytes received,
        but the number of items of the data-type received by the most
        recent Receive() eg. if Receive(int*,..) was used, then this
        returns the number of ints received; if Receive(double*,..) was
        used, then this returns the number of doubles received etc. The
        return value is valid only after a successful Receive().
        """
    )

    def get_left_child_processor(self, *args):
        """
        get_left_child_processor(pid:int) -> int
        C++: static int get_left_child_processor(int pid)"""
        ret = self._wrap_call(self._vtk_obj.GetLeftChildProcessor, *args)
        return ret

    def _get_local_process_id(self):
        return self._vtk_obj.GetLocalProcessId()
    local_process_id = traits.Property(_get_local_process_id, desc=\
        r"""
        Tells you which process [0, num_process) you are in.
        """
    )

    def get_parent_processor(self, *args):
        """
        get_parent_processor(pid:int) -> int
        C++: static int get_parent_processor(int pid)
        Some helper functions when dealing with heap tree - based
        algorithms - we don't need a function for getting the right
        processor since it is 1 + theleft_processor
        """
        ret = self._wrap_call(self._vtk_obj.GetParentProcessor, *args)
        return ret

    def all_gather(self, *args):
        """
        all_gather(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int) -> int
        C++: int all_gather(const int *sendBuffer, int *recvBuffer,
            IdType length)
        all_gather(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int) -> int
        C++: int all_gather(const long *sendBuffer, long *recvBuffer,
            IdType length)
        all_gather(self, sendBuffer:str, recvBuffer:str, length:int) -> int
        C++: int all_gather(const char *sendBuffer, char *recvBuffer,
            IdType length)
        all_gather(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
            length:int) -> int
        C++: int all_gather(const double *sendBuffer, double *recvBuffer,
            IdType length)
        all_gather(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int) -> int
        C++: int all_gather(const long long *sendBuffer,
            long long *recvBuffer, IdType length)
        all_gather(self, sendBuffer:DataArray, recvBuffer:DataArray)
            -> int
        C++: int all_gather(DataArray *sendBuffer,
            DataArray *recvBuffer)
        Same as gather except that the result ends up on all processes.
        """
        my_args = deref_array(args, [(('int', Ellipsis), ['int', Ellipsis], 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int'), ('string', 'string', 'int'), (('float', Ellipsis), 'tuple', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int'), ('vtkDataArray', 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.AllGather, *my_args)
        return ret

    def all_gather_v(self, *args):
        """
        all_gather_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...])
            -> int
        C++: int all_gather_v(const int *sendBuffer, int *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets)
        all_gather_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...])
            -> int
        C++: int all_gather_v(const long *sendBuffer, long *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets)
        all_gather_v(self, sendBuffer:str, recvBuffer:str, sendLength:int,
            recvLengths:[int, ...], offsets:[int, ...]) -> int
        C++: int all_gather_v(const char *sendBuffer, char *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets)
        all_gather_v(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
             sendLength:int, recvLengths:[int, ...], offsets:[int, ...])
            -> int
        C++: int all_gather_v(const double *sendBuffer, double *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets)
        all_gather_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...])
            -> int
        C++: int all_gather_v(const long long *sendBuffer,
            long long *recvBuffer, IdType sendLength,
            IdType *recvLengths, IdType *offsets)
        all_gather_v(self, sendBuffer:DataArray, recvBuffer:DataArray,
             recvLengths:[int, ...], offsets:[int, ...]) -> int
        C++: int all_gather_v(DataArray *sendBuffer,
            DataArray *recvBuffer, IdType *recvLengths,
            IdType *offsets)
        all_gather_v(self, sendBuffer:DataArray, recvBuffer:DataArray)
             -> int
        C++: int all_gather_v(DataArray *sendBuffer,
            DataArray *recvBuffer)
        Same as GatherV except that the result is placed in all
        processes.
        """
        my_args = deref_array(args, [(('int', Ellipsis), ['int', Ellipsis], 'int', ['int', Ellipsis], ['int', Ellipsis]), (('int', Ellipsis), ['int', Ellipsis], 'int', ['int', Ellipsis], ['int', Ellipsis]), ('string', 'string', 'int', ['int', Ellipsis], ['int', Ellipsis]), (('float', Ellipsis), 'tuple', 'int', ['int', Ellipsis], ['int', Ellipsis]), (('int', Ellipsis), ['int', Ellipsis], 'int', ['int', Ellipsis], ['int', Ellipsis]), ('vtkDataArray', 'vtkDataArray', ['int', Ellipsis], ['int', Ellipsis]), ('vtkDataArray', 'vtkDataArray')])
        ret = self._wrap_call(self._vtk_obj.AllGatherV, *my_args)
        return ret

    def all_gather_v_void_array(self, *args):
        """
        all_gather_v_void_array(self, sendBuffer:Pointer, recvBuffer:Pointer,
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...],
            type:int) -> int
        C++: virtual int all_gather_v_void_array(const void *sendBuffer,
            void *recvBuffer, IdType sendLength,
            IdType *recvLengths, IdType *offsets, int type)"""
        ret = self._wrap_call(self._vtk_obj.AllGatherVVoidArray, *args)
        return ret

    def all_gather_void_array(self, *args):
        """
        all_gather_void_array(self, sendBuffer:Pointer, recvBuffer:Pointer,
            length:int, type:int) -> int
        C++: virtual int all_gather_void_array(const void *sendBuffer,
            void *recvBuffer, IdType length, int type)"""
        ret = self._wrap_call(self._vtk_obj.AllGatherVoidArray, *args)
        return ret

    def all_reduce(self, *args):
        """
        all_reduce(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, operation:int) -> int
        C++: int all_reduce(const int *sendBuffer, int *recvBuffer,
            IdType length, int operation)
        all_reduce(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, operation:int) -> int
        C++: int all_reduce(const long *sendBuffer, long *recvBuffer,
            IdType length, int operation)
        all_reduce(self, sendBuffer:str, recvBuffer:str, length:int,
            operation:int) -> int
        C++: int all_reduce(const char *sendBuffer, char *recvBuffer,
            IdType length, int operation)
        all_reduce(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
            length:int, operation:int) -> int
        C++: int all_reduce(const double *sendBuffer, double *recvBuffer,
            IdType length, int operation)
        all_reduce(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, operation:int) -> int
        C++: int all_reduce(const long long *sendBuffer,
            long long *recvBuffer, IdType length, int operation)
        all_reduce(self, sendBuffer:DataArray, recvBuffer:DataArray,
            operation:int) -> int
        C++: int all_reduce(DataArray *sendBuffer,
            DataArray *recvBuffer, int operation)
        Same as Reduce except that the result is placed in all of the
        processes.
        """
        my_args = deref_array(args, [(('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), ('string', 'string', 'int', 'int'), (('float', Ellipsis), 'tuple', 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), ('vtkDataArray', 'vtkDataArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.AllReduce, *my_args)
        return ret

    def all_reduce_void_array(self, *args):
        """
        all_reduce_void_array(self, sendBuffer:Pointer, recvBuffer:Pointer,
            length:int, type:int, operation:int) -> int
        C++: virtual int all_reduce_void_array(const void *sendBuffer,
            void *recvBuffer, IdType length, int type, int operation)"""
        ret = self._wrap_call(self._vtk_obj.AllReduceVoidArray, *args)
        return ret

    def barrier(self):
        """
        barrier(self) -> None
        C++: virtual void barrier()
        Will block the processes until all other processes reach the
        Barrier function.
        """
        ret = self._vtk_obj.Barrier()
        return ret
        

    def broadcast(self, *args):
        """
        broadcast(self, data:[int, ...], length:int, srcProcessId:int)
            -> int
        C++: int broadcast(int *data, IdType length, int srcProcessId)
        broadcast(self, data:[int, ...], length:int, srcProcessId:int)
            -> int
        C++: int broadcast(long *data, IdType length, int srcProcessId)
        broadcast(self, data:str, length:int, srcProcessId:int) -> int
        C++: int broadcast(char *data, IdType length, int srcProcessId)
        broadcast(self, data:[float, ...], length:int, srcProcessId:int)
            -> int
        C++: int broadcast(double *data, IdType length,
            int srcProcessId)
        broadcast(self, data:[int, ...], length:int, srcProcessId:int)
            -> int
        C++: int broadcast(long long *data, IdType length,
            int srcProcessId)
        broadcast(self, data:DataObject, srcProcessId:int) -> int
        C++: int broadcast(DataObject *data, int srcProcessId)
        broadcast(self, data:DataArray, srcProcessId:int) -> int
        C++: int broadcast(DataArray *data, int srcProcessId)
        broadcast(self, stream:MultiProcessStream, srcProcessId:int)
            -> int
        C++: int broadcast(MultiProcessStream &stream,
            int srcProcessId)
        Broadcast sends the array in the process with id srcprocess_id to
        all of the other processes.  All processes must call these method
        with the same arguments in order for it to complete.
        """
        my_args = deref_array(args, [(['int', Ellipsis], 'int', 'int'), (['int', Ellipsis], 'int', 'int'), ('string', 'int', 'int'), ('tuple', 'int', 'int'), (['int', Ellipsis], 'int', 'int'), ('vtkDataObject', 'int'), ('vtkDataArray', 'int'), ('vtkMultiProcessStream', 'int')])
        ret = self._wrap_call(self._vtk_obj.Broadcast, *my_args)
        return ret

    def broadcast_void_array(self, *args):
        """
        broadcast_void_array(self, data:Pointer, length:int, type:int,
            srcProcessId:int) -> int
        C++: virtual int broadcast_void_array(void *data, IdType length,
            int type, int srcProcessId)
        Subclasses should reimplement these if they have a more efficient
        implementation.
        """
        ret = self._wrap_call(self._vtk_obj.BroadcastVoidArray, *args)
        return ret

    def gather(self, *args):
        """
        gather(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, destProcessId:int) -> int
        C++: int gather(const int *sendBuffer, int *recvBuffer,
            IdType length, int destProcessId)
        gather(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, destProcessId:int) -> int
        C++: int gather(const long *sendBuffer, long *recvBuffer,
            IdType length, int destProcessId)
        gather(self, sendBuffer:str, recvBuffer:str, length:int,
            destProcessId:int) -> int
        C++: int gather(const char *sendBuffer, char *recvBuffer,
            IdType length, int destProcessId)
        gather(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
            length:int, destProcessId:int) -> int
        C++: int gather(const double *sendBuffer, double *recvBuffer,
            IdType length, int destProcessId)
        gather(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, destProcessId:int) -> int
        C++: int gather(const long long *sendBuffer,
            long long *recvBuffer, IdType length, int destProcessId)
        gather(self, sendBuffer:DataArray, recvBuffer:DataArray,
            destProcessId:int) -> int
        C++: int gather(DataArray *sendBuffer,
            DataArray *recvBuffer, int destProcessId)
        Gather collects arrays in the process with id destprocess_id. 
        Each process (including the destination) sends the contents of
        its send buffer to the destination process.  The destination
        process receives the messages and stores them in rank order.  The
        length argument (which must be the same on all processes) is the
        length of the sendBuffers.  The recvBuffer (on the destination
        process) must be of length length*numProcesses.  Gather is the
        inverse operation of Scatter.
        """
        my_args = deref_array(args, [(('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), ('string', 'string', 'int', 'int'), (('float', Ellipsis), 'tuple', 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), ('vtkDataArray', 'vtkDataArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.Gather, *my_args)
        return ret

    def gather_v(self, *args):
        """
        gather_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...],
            destProcessId:int) -> int
        C++: int gather_v(const int *sendBuffer, int *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets, int destProcessId)
        gather_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...],
            destProcessId:int) -> int
        C++: int gather_v(const long *sendBuffer, long *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets, int destProcessId)
        gather_v(self, sendBuffer:str, recvBuffer:str, sendLength:int,
            recvLengths:[int, ...], offsets:[int, ...], destProcessId:int)
             -> int
        C++: int gather_v(const char *sendBuffer, char *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets, int destProcessId)
        gather_v(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...],
            destProcessId:int) -> int
        C++: int gather_v(const double *sendBuffer, double *recvBuffer,
            IdType sendLength, IdType *recvLengths,
            IdType *offsets, int destProcessId)
        gather_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...],
            destProcessId:int) -> int
        C++: int gather_v(const long long *sendBuffer,
            long long *recvBuffer, IdType sendLength,
            IdType *recvLengths, IdType *offsets, int destProcessId)
        gather_v(self, sendBuffer:DataArray, recvBuffer:DataArray,
            recvLengths:[int, ...], offsets:[int, ...], destProcessId:int)
             -> int
        C++: int gather_v(DataArray *sendBuffer,
            DataArray *recvBuffer, IdType *recvLengths,
            IdType *offsets, int destProcessId)
        GatherV is the vector variant of Gather.  It extends the
        functionality of Gather by allowing a varying count of data from
        each process. GatherV collects arrays in the  ...
         [Truncated]
        """
        my_args = deref_array(args, [(('int', Ellipsis), ['int', Ellipsis], 'int', ['int', Ellipsis], ['int', Ellipsis], 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', ['int', Ellipsis], ['int', Ellipsis], 'int'), ('string', 'string', 'int', ['int', Ellipsis], ['int', Ellipsis], 'int'), (('float', Ellipsis), 'tuple', 'int', ['int', Ellipsis], ['int', Ellipsis], 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', ['int', Ellipsis], ['int', Ellipsis], 'int'), ('vtkDataArray', 'vtkDataArray', ['int', Ellipsis], ['int', Ellipsis], 'int')])
        ret = self._wrap_call(self._vtk_obj.GatherV, *my_args)
        return ret

    def gather_v_void_array(self, *args):
        """
        gather_v_void_array(self, sendBuffer:Pointer, recvBuffer:Pointer,
            sendLength:int, recvLengths:[int, ...], offsets:[int, ...],
            type:int, destProcessId:int) -> int
        C++: virtual int gather_v_void_array(const void *sendBuffer,
            void *recvBuffer, IdType sendLength,
            IdType *recvLengths, IdType *offsets, int type,
            int destProcessId)"""
        ret = self._wrap_call(self._vtk_obj.GatherVVoidArray, *args)
        return ret

    def gather_void_array(self, *args):
        """
        gather_void_array(self, sendBuffer:Pointer, recvBuffer:Pointer,
            length:int, type:int, destProcessId:int) -> int
        C++: virtual int gather_void_array(const void *sendBuffer,
            void *recvBuffer, IdType length, int type,
            int destProcessId)"""
        ret = self._wrap_call(self._vtk_obj.GatherVoidArray, *args)
        return ret

    def marshal_data_object(self, *args):
        """
        marshal_data_object(object:DataObject, buffer:CharArray)
            -> int
        C++: static int marshal_data_object(DataObject *object,
            CharArray *buffer)
        Convert a data object into a string that can be transmitted and
        vice versa. Returns 1 for success and 0 for failure. WARNING:
        This will only work for types that have a DataWriter class.
        """
        my_args = deref_array(args, [('vtkDataObject', 'vtkCharArray')])
        ret = self._wrap_call(self._vtk_obj.MarshalDataObject, *my_args)
        return ret

    def receive(self, *args):
        """
        receive(self, data:DataObject, remoteHandle:int, tag:int)
            -> int
        C++: int receive(DataObject *data, int remoteHandle, int tag)
        receive(self, data:DataArray, remoteHandle:int, tag:int) -> int
        C++: int receive(DataArray *data, int remoteHandle, int tag)
        receive(self, data:[int, ...], maxlength:int, remoteHandle:int,
            tag:int) -> int
        C++: int receive(int *data, IdType maxlength, int remoteHandle,
             int tag)
        receive(self, data:[int, ...], maxlength:int, remoteHandle:int,
            tag:int) -> int
        C++: int receive(long *data, IdType maxlength,
            int remoteHandle, int tag)
        receive(self, data:str, maxlength:int, remoteHandle:int, tag:int)
            -> int
        C++: int receive(char *data, IdType maxlength,
            int remoteHandle, int tag)
        receive(self, data:[float, ...], maxlength:int, remoteHandle:int,
            tag:int) -> int
        C++: int receive(double *data, IdType maxlength,
            int remoteHandle, int tag)
        receive(self, data:[int, ...], maxlength:int, remoteHandle:int,
            tag:int) -> int
        C++: int receive(long long *data, IdType maxlength,
            int remoteHandle, int tag)
        receive(self, stream:MultiProcessStream, remoteId:int, tag:int)
             -> int
        C++: int receive(MultiProcessStream &stream, int remoteId,
            int tag)
        This method receives a data object from a corresponding send. It
        blocks until the receive is finished.
        """
        my_args = deref_array(args, [('vtkDataObject', 'int', 'int'), ('vtkDataArray', 'int', 'int'), (['int', Ellipsis], 'int', 'int', 'int'), (['int', Ellipsis], 'int', 'int', 'int'), ('string', 'int', 'int', 'int'), ('tuple', 'int', 'int', 'int'), (['int', Ellipsis], 'int', 'int', 'int'), ('vtkMultiProcessStream', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.Receive, *my_args)
        return ret

    def receive_data_object(self, *args):
        """
        receive_data_object(self, remoteHandle:int, tag:int)
            -> DataObject
        C++: DataObject *receive_data_object(int remoteHandle, int tag)
        The caller does not have to know the data type before this call
        is made. It returns the newly created object.
        """
        ret = self._wrap_call(self._vtk_obj.ReceiveDataObject, *args)
        return wrap_vtk(ret)

    def receive_void_array(self, *args):
        """
        receive_void_array(self, data:Pointer, maxlength:int, type:int,
            remoteHandle:int, tag:int) -> int
        C++: virtual int receive_void_array(void *data, IdType maxlength,
             int type, int remoteHandle, int tag)
        Subclasses have to supply this method to receive various arrays
        of data. The type arg is one of the VTK type constants recognized
        by the TemplateMacro (VTK_FLOAT, VTK_INT, etc.).  maxlength is
        measured in number of values (as opposed to number of bytes) and
        is the maxmum length of the data to receive.  If the maxlength is
        less than the length of the message sent by the sender, an error
        will be flagged. Once a message is received, use the get_count()
        method to determine the actual size of the data received.
        """
        ret = self._wrap_call(self._vtk_obj.ReceiveVoidArray, *args)
        return ret

    def reduce(self, *args):
        """
        reduce(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, operation:int, destProcessId:int) -> int
        C++: int reduce(const int *sendBuffer, int *recvBuffer,
            IdType length, int operation, int destProcessId)
        reduce(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, operation:int, destProcessId:int) -> int
        C++: int reduce(const long *sendBuffer, long *recvBuffer,
            IdType length, int operation, int destProcessId)
        reduce(self, sendBuffer:str, recvBuffer:str, length:int,
            operation:int, destProcessId:int) -> int
        C++: int reduce(const char *sendBuffer, char *recvBuffer,
            IdType length, int operation, int destProcessId)
        reduce(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
            length:int, operation:int, destProcessId:int) -> int
        C++: int reduce(const double *sendBuffer, double *recvBuffer,
            IdType length, int operation, int destProcessId)
        reduce(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, operation:int, destProcessId:int) -> int
        C++: int reduce(const long long *sendBuffer,
            long long *recvBuffer, IdType length, int operation,
            int destProcessId)
        reduce(self, sendBuffer:DataArray, recvBuffer:DataArray,
            operation:int, destProcessId:int) -> int
        C++: int reduce(DataArray *sendBuffer,
            DataArray *recvBuffer, int operation, int destProcessId)
        Reduce an array to the given destination process.  This version
        of Reduce takes an identifier defined in the
        Communicator::StandardOperations enum to define the operation.
        """
        my_args = deref_array(args, [(('int', Ellipsis), ['int', Ellipsis], 'int', 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int', 'int'), ('string', 'string', 'int', 'int', 'int'), (('float', Ellipsis), 'tuple', 'int', 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int', 'int'), ('vtkDataArray', 'vtkDataArray', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.Reduce, *my_args)
        return ret

    def reduce_void_array(self, *args):
        """
        reduce_void_array(self, sendBuffer:Pointer, recvBuffer:Pointer,
            length:int, type:int, operation:int, destProcessId:int) -> int
        C++: virtual int reduce_void_array(const void *sendBuffer,
            void *recvBuffer, IdType length, int type, int operation,
            int destProcessId)"""
        ret = self._wrap_call(self._vtk_obj.ReduceVoidArray, *args)
        return ret

    def scatter(self, *args):
        """
        scatter(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, srcProcessId:int) -> int
        C++: int scatter(const int *sendBuffer, int *recvBuffer,
            IdType length, int srcProcessId)
        scatter(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, srcProcessId:int) -> int
        C++: int scatter(const long *sendBuffer, long *recvBuffer,
            IdType length, int srcProcessId)
        scatter(self, sendBuffer:str, recvBuffer:str, length:int,
            srcProcessId:int) -> int
        C++: int scatter(const char *sendBuffer, char *recvBuffer,
            IdType length, int srcProcessId)
        scatter(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
            length:int, srcProcessId:int) -> int
        C++: int scatter(const double *sendBuffer, double *recvBuffer,
            IdType length, int srcProcessId)
        scatter(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            length:int, srcProcessId:int) -> int
        C++: int scatter(const long long *sendBuffer,
            long long *recvBuffer, IdType length, int srcProcessId)
        scatter(self, sendBuffer:DataArray, recvBuffer:DataArray,
            srcProcessId:int) -> int
        C++: int scatter(DataArray *sendBuffer,
            DataArray *recvBuffer, int srcProcessId)
        Scatter takes an array in the process with id srcprocess_id and
        distributes it.  Each process (including the source) receives a
        portion of the send buffer.  Process 0 receives the first length
        values, process 1 receives the second length values, and so on. 
        Scatter is the inverse operation of Gather.
        """
        my_args = deref_array(args, [(('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), ('string', 'string', 'int', 'int'), (('float', Ellipsis), 'tuple', 'int', 'int'), (('int', Ellipsis), ['int', Ellipsis], 'int', 'int'), ('vtkDataArray', 'vtkDataArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.Scatter, *my_args)
        return ret

    def scatter_v(self, *args):
        """
        scatter_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLengths:[int, ...], offsets:[int, ...], recvLength:int,
            srcProcessId:int) -> int
        C++: int scatter_v(const int *sendBuffer, int *recvBuffer,
            IdType *sendLengths, IdType *offsets,
            IdType recvLength, int srcProcessId)
        scatter_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLengths:[int, ...], offsets:[int, ...], recvLength:int,
            srcProcessId:int) -> int
        C++: int scatter_v(const long *sendBuffer, long *recvBuffer,
            IdType *sendLengths, IdType *offsets,
            IdType recvLength, int srcProcessId)
        scatter_v(self, sendBuffer:str, recvBuffer:str, sendLengths:[int,
            ...], offsets:[int, ...], recvLength:int, srcProcessId:int)
            -> int
        C++: int scatter_v(const char *sendBuffer, char *recvBuffer,
            IdType *sendLengths, IdType *offsets,
            IdType recvLength, int srcProcessId)
        scatter_v(self, sendBuffer:(float, ...), recvBuffer:[float, ...],
            sendLengths:[int, ...], offsets:[int, ...], recvLength:int,
            srcProcessId:int) -> int
        C++: int scatter_v(const double *sendBuffer, double *recvBuffer,
            IdType *sendLengths, IdType *offsets,
            IdType recvLength, int srcProcessId)
        scatter_v(self, sendBuffer:(int, ...), recvBuffer:[int, ...],
            sendLengths:[int, ...], offsets:[int, ...], recvLength:int,
            srcProcessId:int) -> int
        C++: int scatter_v(const long long *sendBuffer,
            long long *recvBuffer, IdType *sendLengths,
            IdType *offsets, IdType recvLength, int srcProcessId)
        ScatterV is the vector variant of Scatter.  It extends the
        functionality of Scatter by allowing a varying count of data to
        each process. ScatterV takes an array in the process with id
        srcprocess_id and distributes it.  Each process (including the
        source) receives a portion of the send buffer defined by the
        sendLengths and offsets arrays.
        """
        ret = self._wrap_call(self._vtk_obj.ScatterV, *args)
        return ret

    def scatter_v_void_array(self, *args):
        """
        scatter_v_void_array(self, sendBuffer:Pointer, recvBuffer:Pointer,
            sendLengths:[int, ...], offsets:[int, ...], recvLength:int,
            type:int, srcProcessId:int) -> int
        C++: virtual int scatter_v_void_array(const void *sendBuffer,
            void *recvBuffer, IdType *sendLengths, IdType *offsets,
            IdType recvLength, int type, int srcProcessId)"""
        ret = self._wrap_call(self._vtk_obj.ScatterVVoidArray, *args)
        return ret

    def scatter_void_array(self, *args):
        """
        scatter_void_array(self, sendBuffer:Pointer, recvBuffer:Pointer,
            length:int, type:int, srcProcessId:int) -> int
        C++: virtual int scatter_void_array(const void *sendBuffer,
            void *recvBuffer, IdType length, int type,
            int srcProcessId)"""
        ret = self._wrap_call(self._vtk_obj.ScatterVoidArray, *args)
        return ret

    def send(self, *args):
        """
        send(self, data:DataObject, remoteHandle:int, tag:int) -> int
        C++: int send(DataObject *data, int remoteHandle, int tag)
        send(self, data:DataArray, remoteHandle:int, tag:int) -> int
        C++: int send(DataArray *data, int remoteHandle, int tag)
        send(self, data:(int, ...), length:int, remoteHandle:int, tag:int)
             -> int
        C++: int send(const int *data, IdType length, int remoteHandle,
             int tag)
        send(self, data:(int, ...), length:int, remoteHandle:int, tag:int)
             -> int
        C++: int send(const long *data, IdType length,
            int remoteHandle, int tag)
        send(self, data:str, length:int, remoteHandle:int, tag:int) -> int
        C++: int send(const char *data, IdType length,
            int remoteHandle, int tag)
        send(self, data:(float, ...), length:int, remoteHandle:int,
            tag:int) -> int
        C++: int send(const double *data, IdType length,
            int remoteHandle, int tag)
        send(self, data:(int, ...), length:int, remoteHandle:int, tag:int)
             -> int
        C++: int send(const long long *data, IdType length,
            int remoteHandle, int tag)
        send(self, stream:MultiProcessStream, remoteId:int, tag:int)
            -> int
        C++: int send(const MultiProcessStream &stream, int remoteId,
            int tag)
        This method sends a data object to a destination. Tag eliminates
        ambiguity and is used to match sends to receives.
        """
        my_args = deref_array(args, [('vtkDataObject', 'int', 'int'), ('vtkDataArray', 'int', 'int'), (('int', Ellipsis), 'int', 'int', 'int'), (('int', Ellipsis), 'int', 'int', 'int'), ('string', 'int', 'int', 'int'), ('tuple', 'int', 'int', 'int'), (('int', Ellipsis), 'int', 'int', 'int'), ('vtkMultiProcessStream', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.Send, *my_args)
        return ret

    def send_void_array(self, *args):
        """
        send_void_array(self, data:Pointer, length:int, type:int,
            remoteHandle:int, tag:int) -> int
        C++: virtual int send_void_array(const void *data, IdType length,
             int type, int remoteHandle, int tag)
        Subclasses have to supply this method to send various arrays of
        data. The type arg is one of the VTK type constants recognized by
        the TemplateMacro (VTK_FLOAT, VTK_INT, etc.).  length is
        measured in number of values (as opposed to number of bytes).
        """
        ret = self._wrap_call(self._vtk_obj.SendVoidArray, *args)
        return ret

    def set_use_copy(self, *args):
        """
        set_use_copy(useCopy:int) -> None
        C++: static void set_use_copy(int useCopy)"""
        ret = self._wrap_call(self._vtk_obj.SetUseCopy, *args)
        return ret

    def un_marshal_data_object(self, *args):
        """
        un_marshal_data_object(buffer:CharArray, object:DataObject)
            -> int
        C++: static int un_marshal_data_object(CharArray *buffer,
            DataObject *object)
        un_marshal_data_object(buffer:CharArray)
            -> SmartPointer_I13vtkDataObjectE
        C++: static SmartPointer<vtkDataObject> un_marshal_data_object(
            CharArray *buffer)"""
        my_args = deref_array(args, [('vtkCharArray', 'vtkDataObject'), ['vtkCharArray']])
        ret = self._wrap_call(self._vtk_obj.UnMarshalDataObject, *my_args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('number_of_processes',
    'GetNumberOfProcesses'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'number_of_processes'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Communicator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Communicator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['number_of_processes']),
            title='Edit Communicator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Communicator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

