# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.xml_writer import XMLWriter


class XMLHyperTreeGridWriter(XMLWriter):
    r"""
    XMLHyperTreeGridWriter - Write VTK XML hyper_tree_grid files.
    
    Superclass: XMLWriter
    
    XMLHyperTreeGridWriter writes the VTK XML hyper_tree_grid file
    format. The standard extension for this writer's file format is
    "htg".
    
    Note for developers: The VTK XML hyper_tree_grid file format is
    versioned. Any evolution of the format must lead to:
    - a move to a higher major version number, X+1.0, if the evolution is
      incompatible with the previous versions either at the level of the
      description of the information or the semantic understanding made
      by the reader;
    - a move to a higher minor version number, X.y+1, if its consists of
      adding information without calling into question the general
      interpretation.
    
    Version 0.0 (P. Fasel and D. de_marle) ... Version 1.0 (J-B Lekien
    CEA, DAM, DIF, F-91297 Arpajon, France)
    - writing by hyper_tree description and fields;
    - saving the minimal tree (a hidden refined node becomes a hidden
      leaf node);
    - saving the tree by level of refinement (course in width);
    - the last null values in the binary description of the tree or mask
      (if defined) may not / are not explicitly described. The size of
      the table given elsewhere is authentic;
    - all fields are copied to be saved in the implicit order, so even if
    an explicit global index map exists, it disappears;
    - writing in this version requires more memory and CPU;
    - reading of a part is accelerated (non iterative construction of the
    tree) and consumes potentially less memory (suppression of the global
    index map explicit);
    - expanded possibility at the reader level, today these options allow
    to accelerate the obtaining of a result which will be less precise
      and to allow the loading of a part of a mesh which would not hold
      in memory:
    - loading by limiting the maximum level to load;
    - loading by selecting (differentes description possibilities are
      offered) the HTs to take into account.
    
    The default version of the VTK XML hyper_tree_grid file format is the
    latest version, now version 1.0.
    
    For developpers: To ensure the durability of this storage format over
    time, at least, the drive must continue to support playback of
    previous format.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXMLHyperTreeGridWriter, obj, update, **traits)
    
    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get/Set the writer's input.
        """
    )

    def set_data_set_major_version(self, *args):
        """
        set_data_set_major_version(self, _arg:int) -> None
        C++: virtual void set_data_set_major_version(int _arg)
        Methods to define the file's major and minor version numbers.
        Major version incremented since v0.1 hypertreegrid data readers
        cannot read the files written by this new reader. A version is
        defined by defect, so there is no need to call this function. The
        default choice is usually the best choice.
        """
        ret = self._wrap_call(self._vtk_obj.SetDataSetMajorVersion, *args)
        return ret

    def set_data_set_minor_version(self, *args):
        """
        set_data_set_minor_version(self, _arg:int) -> None
        C++: virtual void set_data_set_minor_version(int _arg)"""
        ret = self._wrap_call(self._vtk_obj.SetDataSetMinorVersion, *args)
        return ret

    _updateable_traits_ = \
    (('encode_appended_data', 'GetEncodeAppendedData'),
    ('write_to_output_string', 'GetWriteToOutputString'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('byte_order',
    'GetByteOrder'), ('data_mode', 'GetDataMode'), ('header_type',
    'GetHeaderType'), ('id_type', 'GetIdType'), ('number_of_time_steps',
    'GetNumberOfTimeSteps'), ('block_size', 'GetBlockSize'),
    ('compression_level', 'GetCompressionLevel'), ('file_name',
    'GetFileName'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'encode_appended_data',
    'global_warning_display', 'release_data_flag',
    'write_to_output_string', 'byte_order', 'data_mode', 'header_type',
    'id_type', 'block_size', 'compression_level', 'file_name',
    'number_of_time_steps', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(XMLHyperTreeGridWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit XMLHyperTreeGridWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['encode_appended_data', 'write_to_output_string'],
            ['byte_order', 'data_mode', 'header_type', 'id_type'], ['block_size',
            'compression_level', 'file_name', 'number_of_time_steps']),
            title='Edit XMLHyperTreeGridWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit XMLHyperTreeGridWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

