/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Service_H
#define Service_H

#include <string>
#include <ostream>

using namespace std;

class IconObject;
class Action;
class Task;

class Service
{
public:
    Service(const string&);
    virtual ~Service();

    string name();
    virtual Task* task(const Action&, IconObject*) = 0;
    static Service* find(const string&);

protected:
    string name_;
    virtual void print(ostream&) const;

private:
    // No copy allowed
    Service(const Service&);
    Service& operator=(const Service&);

    friend ostream& operator<<(ostream& s, const Service& p)
    {
        p.print(s);
        return s;
    }
};

inline void destroy(Service**) {}

#endif
