; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "MiniZinc IDE"
#define MyAppPublisher "Data61 and Monash University"
#define MyAppURL "http://www.minizinc.org"
#define MyAppExeName "MiniZincIDE.exe"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{80FFFA5B-5C33-442E-8C26-A8CD257EFD97}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
;AppVerName={#MyAppName} {#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
LicenseFile={#MyAppDirectory}\resources\misc\COMBINED_LICENSE.txt
DefaultDirName={autopf}\MiniZinc
DefaultGroupName={#MyAppName}
AllowNoIcons=yes
OutputBaseFilename=MiniZincIDE-{#MyAppVersion}-bundled-setup-{#MyAppArch}
Compression=lzma
SolidCompression=yes
ChangesAssociations=yes
ArchitecturesInstallIn64BitMode={#MyApp64Bit}
ArchitecturesAllowed={#MyAppArchitectures}
DisableDirPage=no
PrivilegesRequiredOverridesAllowed=dialog

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "{#MyAppDirectory}\ide\*"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs createallsubdirs

Source: "{#MyAppDirectory}\vendor\openssl\*.dll"; DestDir: "{app}"; Flags: ignoreversion

Source: "{#MyAppDirectory}\minizinc\bin\*.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#MyAppDirectory}\minizinc\share\minizinc\*"; DestDir: "{app}\share\minizinc"; Flags: ignoreversion recursesubdirs createallsubdirs

Source: "{#MyAppDirectory}\vendor\gecode_gist\bin\fzn-gecode.exe"; DestDir: "{app}\bin"; DestName: "fzn-gecode.exe"; Flags: ignoreversion
Source: "{#MyAppDirectory}\vendor\gecode_gist\share\minizinc\*"; DestDir: "{app}\share\minizinc\"; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "{#MyAppDirectory}\resources\misc\win-gecode-qt.conf"; DestDir: "{app}\bin"; DestName: "qt.conf"; Flags: ignoreversion

Source: "{#MyAppDirectory}\vendor\chuffed\bin\fzn-chuffed.exe"; DestDir:"{app}\bin"; Flags: ignoreversion
Source: "{#MyAppDirectory}\vendor\chuffed\share\minizinc\*"; DestDir: "{app}\share\minizinc\"; Flags: ignoreversion recursesubdirs createallsubdirs

Source: "{#MyAppDirectory}\vendor\or-tools\bin\fzn-cp-sat.exe"; DestDir:"{app}\bin"; Flags: ignoreversion
Source: "{#MyAppDirectory}\vendor\or-tools\share\minizinc\*"; DestDir: "{app}\share\minizinc\"; Flags: ignoreversion recursesubdirs createallsubdirs

Source: "{#MyAppDirectory}\vendor\highs\bin\highs.dll"; DestDir:"{app}\bin"; Flags: ignoreversion

Source: "{#MyAppDirectory}\globalizer\bin\minizinc-globalizer.exe"; DestDir:"{app}\bin"; Flags: ignoreversion
Source: "{#MyAppDirectory}\globalizer\share\minizinc\*"; DestDir: "{app}\share\minizinc\"; Flags: ignoreversion recursesubdirs createallsubdirs

Source: "{#MyAppDirectory}\findMUS\bin\findMUS.exe"; DestDir:"{app}\bin"; Flags: ignoreversion
Source: "{#MyAppDirectory}\findMUS\share\minizinc\*"; DestDir: "{app}\share\minizinc\"; Flags: ignoreversion recursesubdirs createallsubdirs

Source: "{#MyAppDirectory}\mzn-analyse\bin\mzn-analyse.exe"; DestDir:"{app}\bin"; Flags: ignoreversion

Source: "{#MyMSVCRedist}\*.dll"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#MyUCRTRedist}\*.dll"; DestDir: "{app}"; Flags: ignoreversion
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{group}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"
Name: "{commondesktop}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; Tasks: desktopicon

[Run]
Filename: "{app}\{#MyAppExeName}"; Description: "{cm:LaunchProgram,{#StringChange(MyAppName, '&', '&&')}}"; Flags: nowait postinstall skipifsilent

[Registry]
Root: HKA; Subkey: "Software\Classes\.mzp"; ValueType: string; ValueName: ""; ValueData: "MiniZincProjectFile"; Flags: uninsdeletevalue;
Root: HKA; Subkey: "Software\Classes\MiniZincProjectFile"; ValueType: string; ValueName: ""; ValueData: "MiniZinc project"; Flags: uninsdeletevalue;
Root: HKA; Subkey: "Software\Classes\MiniZincProjectFile\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\{#MyAppExeName},0"
Root: HKA; Subkey: "Software\Classes\MiniZincProjectFile\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\{#MyAppExeName}"" ""%1"""

Root: HKA; Subkey: "Software\Classes\.mzn"; ValueType: string; ValueName: ""; ValueData: "MiniZincModelFile"; Flags: uninsdeletevalue;
Root: HKA; Subkey: "Software\Classes\MiniZincModelFile"; ValueType: string; ValueName: ""; ValueData: "MiniZinc model"; Flags: uninsdeletevalue;
Root: HKA; Subkey: "Software\Classes\MiniZincModelFile\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\{#MyAppExeName},0"
Root: HKA; Subkey: "Software\Classes\MiniZincModelFile\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\{#MyAppExeName}"" ""%1"""

Root: HKA; Subkey: "Software\Classes\.dzn"; ValueType: string; ValueName: ""; ValueData: "MiniZincDataFile"; Flags: uninsdeletevalue;
Root: HKA; Subkey: "Software\Classes\MiniZincDataFile"; ValueType: string; ValueName: ""; ValueData: "MiniZinc data"; Flags: uninsdeletevalue;
Root: HKA; Subkey: "Software\Classes\MiniZincDataFile\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\{#MyAppExeName},0"
Root: HKA; Subkey: "Software\Classes\MiniZincDataFile\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\{#MyAppExeName}"" ""%1"""

Root: HKA; Subkey: "Software\Classes\.fzn"; ValueType: string; ValueName: ""; ValueData: "MiniZincFlatZincFile"; Flags: uninsdeletevalue;
Root: HKA; Subkey: "Software\Classes\MiniZincFlatZincFile"; ValueType: string; ValueName: ""; ValueData: "FlatZinc instance"; Flags: uninsdeletevalue;
Root: HKA; Subkey: "Software\Classes\MiniZincFlatZincFile\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\{#MyAppExeName},0"
Root: HKA; Subkey: "Software\Classes\MiniZincFlatZincFile\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\{#MyAppExeName}"" ""%1"""

[InstallDelete]
; These are old files from previous MiniZincIDE installers that can be removed
Type: files; Name: "{app}\GecodeDriver-6-1-0-r-x64.dll"
Type: files; Name: "{app}\GecodeDriver-6-1-0-r-x64.pdb"
Type: files; Name: "{app}\GecodeFlatZinc-6-1-0-r-x64.dll"
Type: files; Name: "{app}\GecodeFlatZinc-6-1-0-r-x64.pdb"
Type: files; Name: "{app}\GecodeFloat-6-1-0-r-x64.dll"
Type: files; Name: "{app}\GecodeFloat-6-1-0-r-x64.pdb"
Type: files; Name: "{app}\GecodeGist-6-1-0-r-x64.dll"
Type: files; Name: "{app}\GecodeGist-6-1-0-r-x64.pdb"
Type: files; Name: "{app}\GecodeInt-6-1-0-r-x64.dll"
Type: files; Name: "{app}\GecodeInt-6-1-0-r-x64.pdb"
Type: files; Name: "{app}\GecodeKernel-6-1-0-r-x64.dll"
Type: files; Name: "{app}\GecodeKernel-6-1-0-r-x64.pdb"
Type: files; Name: "{app}\GecodeMinimodel-6-1-0-r-x64.dll"
Type: files; Name: "{app}\GecodeMinimodel-6-1-0-r-x64.pdb"
Type: files; Name: "{app}\GecodeSearch-6-1-0-r-x64.dll"
Type: files; Name: "{app}\GecodeSearch-6-1-0-r-x64.pdb"
Type: files; Name: "{app}\GecodeSet-6-1-0-r-x64.dll"
Type: files; Name: "{app}\GecodeSet-6-1-0-r-x64.pdb"
Type: files; Name: "{app}\GecodeSupport-6-1-0-r-x64.dll"
Type: files; Name: "{app}\GecodeSupport-6-1-0-r-x64.pdb"
Type: files; Name: "{app}\Qt5Multimedia.dll"
Type: files; Name: "{app}\Qt5MultimediaWidgets.dll"
Type: files; Name: "{app}\Qt5OpenGL.dll"
Type: files; Name: "{app}\Qt5Sensors.dll"
Type: files; Name: "{app}\Qt5WebEngine.dll"
Type: files; Name: "{app}\Qt5WebKit.dll"
Type: files; Name: "{app}\Qt5WebKitWidgets.dll"
Type: files; Name: "{app}\Qt5WebSockets.dll"
Type: files; Name: "{app}\Qt5WebView.dll"
Type: files; Name: "{app}\bin\fzn-gecode-gist.bat"
Type: files; Name: "{app}\bin\mzn-gecode.bat"
Type: files; Name: "{app}\findMUS.exe"
Type: files; Name: "{app}\mzn-analyse.exe"
Type: files; Name: "{app}\flatzinc.exe"
Type: files; Name: "{app}\fzn-chuffed.exe"
Type: files; Name: "{app}\fzn-gecode-gist.bat"
Type: files; Name: "{app}\fzn-gecode.exe"
Type: files; Name: "{app}\icudt53.dll"
Type: files; Name: "{app}\icudtl.dat"
Type: files; Name: "{app}\icuin53.dll"
Type: files; Name: "{app}\icuuc53.dll"
Type: files; Name: "{app}\libcrypto-1_1-x64.dll"
Type: files; Name: "{app}\libeay32.dll"
Type: files; Name: "{app}\libssl-1_1-x64.dll"
Type: files; Name: "{app}\minizinc-globalizer.exe"
Type: files; Name: "{app}\msvcp120.dll"
Type: files; Name: "{app}\msvcr120.dll"
Type: files; Name: "{app}\mzn-cbc.exe"
Type: files; Name: "{app}\mzn-chuffed.bat"
Type: files; Name: "{app}\mzn-fzn.exe"
Type: files; Name: "{app}\mzn-g12fd.bat"
Type: files; Name: "{app}\mzn-g12lazy.bat"
Type: files; Name: "{app}\mzn-g12mip.bat"
Type: files; Name: "{app}\mzn-gecode,1.bat"
Type: files; Name: "{app}\mzn-gecode,2.bat"
Type: files; Name: "{app}\mzn-gecode.bat"
Type: files; Name: "{app}\mzn-gurobi.exe"
Type: files; Name: "{app}\mzn2fzn.exe"
Type: files; Name: "{app}\mzn2fzn_test.exe"
Type: files; Name: "{app}\mzncmd.bat"
Type: files; Name: "{app}\position\qtposition_geoclue.dll"
Type: files; Name: "{app}\qtwebengine_devtools_resources.pak"
Type: files; Name: "{app}\qtwebengine_resources.pak"
Type: files; Name: "{app}\qtwebengine_resources_100p.pak"
Type: files; Name: "{app}\qtwebengine_resources_200p.pak"
Type: files; Name: "{app}\share\examples\functions\warehouses.mzn"
Type: files; Name: "{app}\share\examples\new_syntax\array_index_set.mzn"
Type: files; Name: "{app}\share\examples\new_syntax\extended_let.mzn"
Type: files; Name: "{app}\share\examples\new_syntax\var_if.mzn"
Type: files; Name: "{app}\share\examples\option_types\compatible_assignment_opt.mzn"
Type: files; Name: "{app}\share\examples\option_types\extended_comprehensions.mzn"
Type: files; Name: "{app}\share\examples\option_types\fjsp.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\all_different_int.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\arg_max_bool.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\at_least_int.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\at_most_int.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\circuit.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\cost_regular.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\count.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\cumulative.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\disjunctive.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\disjunctive_strict.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\distribute.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\exactly_int.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\global_cardinality_low_up.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\inverse.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\maximum_int.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\minimum_int.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\nvalue.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\regular.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\subcircuit.mzn"
Type: files; Name: "{app}\share\minizinc\chuffed\table_int.mzn"
Type: files; Name: "{app}\share\minizinc\geas\all_different_int.mzn"
Type: files; Name: "{app}\share\minizinc\geas\alldifferent_except_0.mzn"
Type: files; Name: "{app}\share\minizinc\geas\cumulative.mzn"
Type: files; Name: "{app}\share\minizinc\geas\disjunctive.mzn"
Type: files; Name: "{app}\share\minizinc\geas\global_cardinality.mzn"
Type: files; Name: "{app}\share\minizinc\geas\inverse.mzn"
Type: files; Name: "{app}\share\minizinc\geas\table_int.mzn"
Type: files; Name: "{app}\share\minizinc\geas\value_precede_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\all_different_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\all_different_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\all_different_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\all_equal_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\all_equal_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\all_equal_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\alldifferent_except_0.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\among,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\among,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\among.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\arg_max_bool.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\arg_max_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\arg_max_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\arg_max_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\arg_min_bool.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\arg_min_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\arg_min_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\arg_min_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\at_least_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\at_least_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\at_least_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\at_least_set,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\at_least_set,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\at_least_set.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\at_most_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\at_most_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\at_most_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\at_most_set,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\at_most_set,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\at_most_set.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\bin_packing,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\bin_packing,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\bin_packing.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\bin_packing_capa,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\bin_packing_capa,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\bin_packing_capa.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\bin_packing_load,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\bin_packing_load,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\bin_packing_load.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\circuit,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\circuit,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\circuit.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\count,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\count,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\count.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\cumulative,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\cumulative,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\cumulative.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\decreasing_bool,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\decreasing_bool,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\decreasing_bool.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\decreasing_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\decreasing_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\decreasing_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\diffn,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\diffn,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\diffn.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\disjoint,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\disjoint,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\disjoint.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\disjunctive_strict.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\distribute,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\distribute,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\distribute.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\exactly_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\exactly_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\exactly_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\exactly_set,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\exactly_set,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\exactly_set.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\gecode,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\gecode,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\global_cardinality,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\global_cardinality,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\global_cardinality.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\global_cardinality_closed,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\global_cardinality_closed,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\global_cardinality_closed.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\global_cardinality_low_up,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\global_cardinality_low_up,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\global_cardinality_low_up.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\global_cardinality_low_up_closed,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\global_cardinality_low_up_closed,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\global_cardinality_low_up_closed.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\increasing_bool,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\increasing_bool,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\increasing_bool.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\increasing_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\increasing_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\increasing_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\int_set_channel,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\int_set_channel,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\int_set_channel.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\inverse,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\inverse,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\inverse.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\inverse_set,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\inverse_set,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\inverse_set.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\lex_less_bool,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\lex_less_bool,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\lex_less_bool.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\lex_less_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\lex_less_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\lex_less_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\lex_lesseq_bool,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\lex_lesseq_bool,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\lex_lesseq_bool.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\lex_lesseq_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\lex_lesseq_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\lex_lesseq_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\link_set_to_booleans,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\link_set_to_booleans,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\link_set_to_booleans.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\maximum_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\maximum_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\maximum_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\member_bool,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\member_bool,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\member_bool.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\member_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\member_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\member_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\minimum_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\minimum_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\minimum_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\nvalue,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\nvalue,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\nvalue.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\partition_set,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\partition_set,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\partition_set.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\precedence.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\range,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\range,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\range.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\redefinitions,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\redefinitions,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\redefinitions-2.0,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\redefinitions-2.0,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\regular,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\regular,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\regular.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\roots,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\roots,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\roots.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\sort,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\sort,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\sort.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\sum_pred,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\sum_pred,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\sum_pred.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\table_bool,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\table_bool,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\table_bool.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\table_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\table_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\table_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\value_precede_int,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\value_precede_int,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\value_precede_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\value_precede_set,1.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\value_precede_set,2.mzn"
Type: files; Name: "{app}\share\minizinc\gecode\value_precede_set.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\all_different_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\all_equal_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\among.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\arg_max_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\arg_min_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\at_least_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\at_least_set.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\at_most_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\at_most_set.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\bin_packing.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\bin_packing_capa.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\bin_packing_load.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\circuit.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\count.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\cumulative.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\decreasing_bool.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\decreasing_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\diffn.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\disjoint.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\distribute.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\exactly_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\exactly_set.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\fzn_all_different_int_reif.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\global_cardinality.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\global_cardinality_closed.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\global_cardinality_low_up.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\global_cardinality_low_up_closed.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\increasing_bool.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\increasing_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\int_set_channel.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\inverse.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\inverse_set.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\lex_less_bool.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\lex_less_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\lex_lesseq_bool.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\lex_lesseq_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\link_set_to_booleans.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\maximum_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\member_bool.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\member_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\minimum_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\nvalue.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\partition_set.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\range.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\regular.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\roots.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\sort.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\sum_pred.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\table_bool.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\table_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\value_precede_int.mzn"
Type: files; Name: "{app}\share\minizinc\gecode_presolver\value_precede_set.mzn"
Type: files; Name: "{app}\share\minizinc\linear\all_different_int.mzn"
Type: files; Name: "{app}\share\minizinc\linear\alldifferent_except_0.mzn"
Type: files; Name: "{app}\share\minizinc\linear\circuit.mzn"
Type: files; Name: "{app}\share\minizinc\linear\cumulative.mzn"
Type: files; Name: "{app}\share\minizinc\linear\if_then_else_float.mzn"
Type: files; Name: "{app}\share\minizinc\linear\if_then_else_int.mzn"
Type: files; Name: "{app}\share\minizinc\linear\inverse.mzn"
Type: files; Name: "{app}\share\minizinc\linear\lex_less_bool.mzn"
Type: files; Name: "{app}\share\minizinc\linear\lex_lesseq_bool.mzn"
Type: files; Name: "{app}\share\minizinc\linear\regular.mzn"
Type: files; Name: "{app}\share\minizinc\linear\sliding_sum.mzn"
Type: files; Name: "{app}\share\minizinc\linear\subcircuit.mzn"
Type: files; Name: "{app}\share\minizinc\linear\table_int.mzn"
Type: files; Name: "{app}\share\minizinc\linear_new\CHANGELOG.txt"
Type: files; Name: "{app}\share\minizinc\linear_new\all_different_int.mzn"
Type: files; Name: "{app}\share\minizinc\linear_new\alldifferent_except_0.mzn"
Type: files; Name: "{app}\share\minizinc\linear_new\circuit.mzn"
Type: files; Name: "{app}\share\minizinc\linear_new\cumulative.mzn"
Type: files; Name: "{app}\share\minizinc\linear_new\domain_encodings.mzn"
Type: files; Name: "{app}\share\minizinc\linear_new\inverse.mzn"
Type: files; Name: "{app}\share\minizinc\linear_new\lex_lesseq_bool.mzn"
Type: files; Name: "{app}\share\minizinc\linear_new\redefinitions-2.0.2.mzn"
Type: files; Name: "{app}\share\minizinc\linear_new\redefinitions-2.0.mzn"
Type: files; Name: "{app}\share\minizinc\linear_new\redefinitions.mzn"
Type: files; Name: "{app}\share\minizinc\linear_new\regular.mzn"
Type: files; Name: "{app}\share\minizinc\linear_new\subcircuit.mzn"
Type: files; Name: "{app}\share\minizinc\linear_new\subcircuit_wDummy.mzn"
Type: files; Name: "{app}\share\minizinc\linear_new\table_int.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\README__SCIP.txt"
Type: files; Name: "{app}\share\minizinc\linear_scip\all_different_int.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\alldifferent_except_0.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\circuit.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\cumulative.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\domain_encodings.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_all_different_int.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_alldifferent_except_0.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_circuit.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_cumulative.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_if_then_else_float.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_if_then_else_int.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_inverse.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_inverse_in_range.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_inverse_in_range_reif.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_inverse_reif.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_lex_less_bool_reif.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_lex_lesseq_bool.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_lex_lesseq_bool_reif.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_regular.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_sliding_sum.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_subcircuit.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\fzn_table_int.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\if_then_else_float.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\if_then_else_int.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\inverse.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\lex_less_bool.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\lex_lesseq_bool.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\options.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\redefinitions-2.0.2.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\redefinitions-2.0.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\redefinitions-2.2.1.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\redefinitions.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\redefs_bool_imp.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\redefs_bool_reifs.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\redefs_lin_halfreifs.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\redefs_lin_imp.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\redefs_lin_reifs.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\regular.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\sliding_sum.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\subcircuit.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\subcircuit_wDummy.mzn"
Type: files; Name: "{app}\share\minizinc\linear_scip\table_int.mzn"
Type: files; Name: "{app}\share\minizinc\nosets\redefinitions.mzn"
Type: files; Name: "{app}\share\minizinc\std\builtins.mzn"
Type: files; Name: "{app}\share\minizinc\std\stdlib_new.mzn"
Type: files; Name: "{app}\solns2dzn.exe"
Type: files; Name: "{app}\solns2out.exe"
Type: files; Name: "{app}\ssleay32.dll"
Type: files; Name: "{app}\vccorlib120.dll"
Type: files; Name: "{app}\bin\fzn-gecode-gist.bat"
