local helpers = require('test.functional.helpers')(after_each)
local clear, nvim, eq = helpers.clear, helpers.nvim, helpers.eq

describe('TabNewEntered', function()
  describe('au TabNewEntered', function()
    describe('with * as <afile>', function()
      it('matches when entering any new tab', function()
        clear()
        nvim('command', 'au! TabNewEntered * echom "tabnewentered:".tabpagenr().":".bufnr("")')
        eq("tabnewentered:2:2", nvim('command_output', 'tabnew'))
        eq("tabnewentered:3:3", nvim('command_output', 'tabnew test.x2'))
     end)
    end)
    describe('with FILE as <afile>', function()
      it('matches when opening a new tab for FILE', function()
        nvim('command', 'au! TabNewEntered Xtest-tabnewentered echom "tabnewentered:match"')
        eq('tabnewentered:4:4\ntabnewentered:match',
          nvim('command_output', 'tabnew Xtest-tabnewentered'))
     end)
    end)
    describe('with CTRL-W T', function()
      it('works when opening a new tab with CTRL-W T', function()
        clear()
        nvim('command', 'au! TabNewEntered * echom "entered"')
        nvim('command', 'tabnew test.x2')
        nvim('command', 'split')
        eq('entered', nvim('command_output', 'execute "normal \\<C-W>T"'))
      end)
    end)
  end)
end)
