function addOperation (type, key, value, options) {
  var operation = {
    type: type,
    key: key,
    value: value,
    options: options
  }

  if (options && options.prefix) {
    operation.prefix = options.prefix
    delete options.prefix
  }

  this._operations.push(operation)

  return this
}

function Batch(sdb) {
  this._operations = []
  this._sdb = sdb

  this.put = addOperation.bind(this, 'put')
  this.del = addOperation.bind(this, 'del')
}

var B = Batch.prototype


B.clear = function () {
  this._operations = []
}

B.write = function (cb) {
  this._sdb.batch(this._operations, cb)
}

module.exports = Batch
