/**
* @license Apache-2.0
*
* Copyright (c) 2020 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var setReadOnly = require( '@stdlib/utils/define-nonenumerable-read-only-property' );
var abs2 = require( './abs2.native.js' );
var ndarray = require( './ndarray.native.js' );
var setProps = require( './props.js' );


// MAIN //

setReadOnly( abs2, 'ndarray', ndarray );
setProps( abs2, false );
setProps( abs2.ndarray, true );


// EXPORTS //

module.exports = abs2;
