/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.controls.errorbarwizard;

import info.monitorenter.gui.chart.IErrorBarPainter;
import info.monitorenter.gui.chart.IErrorBarPolicy;
import info.monitorenter.gui.chart.events.ErrorBarPainterActionEdit;
import info.monitorenter.gui.chart.events.ErrorBarPolicyActionAddPainter;
import info.monitorenter.gui.chart.events.ErrorBarPolicyActionRemovePainter;
import info.monitorenter.util.FileUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorBarPaintersPanel
extends JPanel
implements PropertyChangeListener {
    private JButton m_addButton;

    public ErrorBarPaintersPanel(IErrorBarPolicy<?> errorBarPolicy) {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        for (IErrorBarPainter painter : errorBarPolicy.getErrorBarPainters()) {
            this.add((Component)new ErrorBarPainterConfigurablePanel(painter, errorBarPolicy), gbc);
            ++gbc.gridy;
        }
        this.m_addButton = new JButton(new ErrorBarPolicyActionAddPainter(errorBarPolicy, "Add"));
        this.add((Component)this.m_addButton, gbc);
        errorBarPolicy.addPropertyChangeListener("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if ("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER".equals(property)) {
            IErrorBarPainter oldPainter = (IErrorBarPainter)evt.getOldValue();
            IErrorBarPainter newPainter = (IErrorBarPainter)evt.getNewValue();
            if (oldPainter == null) {
                IErrorBarPolicy errorBarPolicy = (IErrorBarPolicy)evt.getSource();
                GridBagLayout layout = (GridBagLayout)this.getLayout();
                GridBagConstraints gbc = layout.getConstraints(this.m_addButton);
                ++gbc.gridy;
                layout.setConstraints(this.m_addButton, gbc);
                --gbc.gridy;
                this.add((Component)new ErrorBarPainterConfigurablePanel(newPainter, errorBarPolicy), gbc);
                Container parent = this.getParent();
                if (parent != null) {
                    ((Component)parent).invalidate();
                    ((Component)parent).validate();
                    parent.repaint(400L);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ErrorBarPainterConfigurablePanel
    extends JPanel
    implements PropertyChangeListener {
        private IErrorBarPainter m_errorBarPainter;

        public ErrorBarPainterConfigurablePanel(IErrorBarPainter errorBarPainter, IErrorBarPolicy<?> errorBarPolicy) {
            this.m_errorBarPainter = errorBarPainter;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.gridy = 0;
            gbc.insets = new Insets(2, 2, 2, 2);
            String painterName = FileUtil.cutExtension(errorBarPainter.getClass().getName()).getValue();
            JButton editButton = new JButton(new ErrorBarPainterActionEdit(errorBarPainter, "Edit", this));
            this.add((Component)new JLabel(painterName), gbc);
            gbc.gridx = 1;
            this.add((Component)editButton, gbc);
            gbc.gridx = 2;
            JButton removeButton = new JButton(new ErrorBarPolicyActionRemovePainter(errorBarPolicy, "Remove", errorBarPainter));
            this.add((Component)removeButton, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            errorBarPolicy.addPropertyChangeListener("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if ("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER".equals(property)) {
                IErrorBarPolicy errorBarPolicy = (IErrorBarPolicy)evt.getSource();
                IErrorBarPainter oldValue = (IErrorBarPainter)evt.getOldValue();
                IErrorBarPainter newValue = (IErrorBarPainter)evt.getNewValue();
                if (oldValue == this.m_errorBarPainter && newValue == null) {
                    Container parent = this.getParent();
                    ErrorBarPaintersPanel.this.remove(this);
                    errorBarPolicy.removePropertyChangeListener("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER", this);
                    if (parent != null && (parent = parent.getParent()) != null) {
                        ((Component)parent).invalidate();
                        ((Component)parent).validate();
                        parent.repaint(500L);
                    }
                }
            }
        }
    }
}

