// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQDMULL_4S_4H_H_TRACE_AARCH64_H_
#define VIXL_SIM_SQDMULL_4S_4H_H_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_sqdmull_4S_4H_H[] = {
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0xffff82fc, 0xffff81fe, 0xffcd3366, 0xffab55aa,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0xffff82fc, 0xffff81fe, 0xffcd3366, 0xffab55aa,
  0xffff83f8, 0xffff82fc, 0xffcd99cc, 0xffac0054,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0xffff82fc, 0xffff81fe, 0xffcd3366, 0xffab55aa,
  0xffff83f8, 0xffff82fc, 0xffcd99cc, 0xffac0054,
  0xffff84f4, 0xffff83fa, 0xffce0032, 0xffacaafe,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0xffff82fc, 0xffff81fe, 0xffcd3366, 0xffab55aa,
  0xffff83f8, 0xffff82fc, 0xffcd99cc, 0xffac0054,
  0xffff84f4, 0xffff83fa, 0xffce0032, 0xffacaafe,
  0xfffff040, 0xfffff020, 0xfff999a0, 0xfff55560,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0xffff82fc, 0xffff81fe, 0xffcd3366, 0xffab55aa,
  0xffff83f8, 0xffff82fc, 0xffcd99cc, 0xffac0054,
  0xffff84f4, 0xffff83fa, 0xffce0032, 0xffacaafe,
  0xfffff040, 0xfffff020, 0xfff999a0, 0xfff55560,
  0xfffffd0c, 0xfffffd06, 0xfffeccce, 0xfffe0002,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0xffff82fc, 0xffff81fe, 0xffcd3366, 0xffab55aa,
  0xffff83f8, 0xffff82fc, 0xffcd99cc, 0xffac0054,
  0xffff84f4, 0xffff83fa, 0xffce0032, 0xffacaafe,
  0xfffff040, 0xfffff020, 0xfff999a0, 0xfff55560,
  0xfffffd0c, 0xfffffd06, 0xfffeccce, 0xfffe0002,
  0xfffffe08, 0xfffffe04, 0xffff3334, 0xfffeaaac,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0xffff82fc, 0xffff81fe, 0xffcd3366, 0xffab55aa,
  0xffff83f8, 0xffff82fc, 0xffcd99cc, 0xffac0054,
  0xffff84f4, 0xffff83fa, 0xffce0032, 0xffacaafe,
  0xfffff040, 0xfffff020, 0xfff999a0, 0xfff55560,
  0xfffffd0c, 0xfffffd06, 0xfffeccce, 0xfffe0002,
  0xfffffe08, 0xfffffe04, 0xffff3334, 0xfffeaaac,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x00000000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x00000000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x00000000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00000000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00000000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x00000000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x00000000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00000000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00000000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x00000000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00000000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00000000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0x00000000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00000000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00000000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0x00000000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0x00000000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00000000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0x00000000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0x00000000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0x00000000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0x00000000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0x00000000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0x00000000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0x00000000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0x00000000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0x00000000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0x00000000,
  0x007efd06, 0x007efe04, 0x007eff02, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0x00000000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0x00000000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0x00000000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0x00000000,
  0x007efd06, 0x007efe04, 0x007eff02, 0x00000000,
  0x3331ccce, 0x33323334, 0x3332999a, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00000000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0x00000000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0x00000000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0x00000000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0x00000000,
  0x007efd06, 0x007efe04, 0x007eff02, 0x00000000,
  0x3331ccce, 0x33323334, 0x3332999a, 0x00000000,
  0x55530002, 0x5553aaac, 0x55545556, 0x00000000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0x00000000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0x00000000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0x00000000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0x00000000,
  0x007efd06, 0x007efe04, 0x007eff02, 0x00000000,
  0x3331ccce, 0x33323334, 0x3332999a, 0x00000000,
  0x55530002, 0x5553aaac, 0x55545556, 0x00000000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x00000000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0x00000000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0x00000000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0x00000000,
  0x007efd06, 0x007efe04, 0x007eff02, 0x00000000,
  0x3331ccce, 0x33323334, 0x3332999a, 0x00000000,
  0x55530002, 0x5553aaac, 0x55545556, 0x00000000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x00000000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x00000000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0x00000000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0x00000000,
  0x007efd06, 0x007efe04, 0x007eff02, 0x00000000,
  0x3331ccce, 0x33323334, 0x3332999a, 0x00000000,
  0x55530002, 0x5553aaac, 0x55545556, 0x00000000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x00000000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x00000000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x00000000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0x00000000,
  0x007efd06, 0x007efe04, 0x007eff02, 0x00000000,
  0x3331ccce, 0x33323334, 0x3332999a, 0x00000000,
  0x55530002, 0x5553aaac, 0x55545556, 0x00000000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x00000000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x00000000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x00000000,
  0x80030000, 0x80020000, 0x80010000, 0x00000000,
  0x007efd06, 0x007efe04, 0x007eff02, 0x00000000,
  0x3331ccce, 0x33323334, 0x3332999a, 0x00000000,
  0x55530002, 0x5553aaac, 0x55545556, 0x00000000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x00000000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x00000000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x00000000,
  0x80030000, 0x80020000, 0x80010000, 0x00000000,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x00000000,
  0x3331ccce, 0x33323334, 0x3332999a, 0x00000000,
  0x55530002, 0x5553aaac, 0x55545556, 0x00000000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x00000000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x00000000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x00000000,
  0x80030000, 0x80020000, 0x80010000, 0x00000000,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x00000000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x00000000,
  0x55530002, 0x5553aaac, 0x55545556, 0x00000000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x00000000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x00000000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x00000000,
  0x80030000, 0x80020000, 0x80010000, 0x00000000,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x00000000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x00000000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x00000000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x00000000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x00000000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x00000000,
  0x80030000, 0x80020000, 0x80010000, 0x00000000,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x00000000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x00000000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x00000000,
  0xff800300, 0xff800200, 0xff800100, 0x00000000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x00000000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x00000000,
  0x80030000, 0x80020000, 0x80010000, 0x00000000,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x00000000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x00000000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x00000000,
  0xff800300, 0xff800200, 0xff800100, 0x00000000,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x00000000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x00000000,
  0x80030000, 0x80020000, 0x80010000, 0x00000000,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x00000000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x00000000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x00000000,
  0xff800300, 0xff800200, 0xff800100, 0x00000000,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x00000000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x00000000,
  0x80030000, 0x80020000, 0x80010000, 0x00000000,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x00000000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x00000000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x00000000,
  0xff800300, 0xff800200, 0xff800100, 0x00000000,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x00000000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x00000000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x00000000,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x00000000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x00000000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x00000000,
  0xff800300, 0xff800200, 0xff800100, 0x00000000,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x00000000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x00000000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x00000000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00000000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x00000000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x00000000,
  0xff800300, 0xff800200, 0xff800100, 0x00000000,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x00000000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x00000000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x00000000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00000000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00000000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x00000000,
  0xff800300, 0xff800200, 0xff800100, 0x00000000,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x00000000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x00000000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x00000000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00000000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00000000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00000000,
  0xff800300, 0xff800200, 0xff800100, 0x00000000,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x00000000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x00000000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x00000000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00000000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00000000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00000000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00000000,
  0xff8101fc, 0xff8100fe, 0x00000000, 0xffffff02,
  0xff8201f8, 0xff8200fc, 0x00000000, 0xffffff04,
  0xff8301f4, 0xff8300fa, 0x00000000, 0xffffff06,
  0xfff00040, 0xfff00020, 0x00000000, 0xffffffe0,
  0xfffd000c, 0xfffd0006, 0x00000000, 0xfffffffa,
  0xfffe0008, 0xfffe0004, 0x00000000, 0xfffffffc,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xff8201f8, 0xff8200fc, 0x00000000, 0xffffff04,
  0xff8301f4, 0xff8300fa, 0x00000000, 0xffffff06,
  0xfff00040, 0xfff00020, 0x00000000, 0xffffffe0,
  0xfffd000c, 0xfffd0006, 0x00000000, 0xfffffffa,
  0xfffe0008, 0xfffe0004, 0x00000000, 0xfffffffc,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0xff8301f4, 0xff8300fa, 0x00000000, 0xffffff06,
  0xfff00040, 0xfff00020, 0x00000000, 0xffffffe0,
  0xfffd000c, 0xfffd0006, 0x00000000, 0xfffffffa,
  0xfffe0008, 0xfffe0004, 0x00000000, 0xfffffffc,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0x0001fff8, 0x0001fffc, 0x00000000, 0x00000004,
  0xfff00040, 0xfff00020, 0x00000000, 0xffffffe0,
  0xfffd000c, 0xfffd0006, 0x00000000, 0xfffffffa,
  0xfffe0008, 0xfffe0004, 0x00000000, 0xfffffffc,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0x0001fff8, 0x0001fffc, 0x00000000, 0x00000004,
  0x000fffc0, 0x000fffe0, 0x00000000, 0x00000020,
  0xfffd000c, 0xfffd0006, 0x00000000, 0xfffffffa,
  0xfffe0008, 0xfffe0004, 0x00000000, 0xfffffffc,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0x0001fff8, 0x0001fffc, 0x00000000, 0x00000004,
  0x000fffc0, 0x000fffe0, 0x00000000, 0x00000020,
  0x007cfe0c, 0x007cff06, 0x00000000, 0x000000fa,
  0xfffe0008, 0xfffe0004, 0x00000000, 0xfffffffc,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0x0001fff8, 0x0001fffc, 0x00000000, 0x00000004,
  0x000fffc0, 0x000fffe0, 0x00000000, 0x00000020,
  0x007cfe0c, 0x007cff06, 0x00000000, 0x000000fa,
  0x007dfe08, 0x007dff04, 0x00000000, 0x000000fc,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0x0001fff8, 0x0001fffc, 0x00000000, 0x00000004,
  0x000fffc0, 0x000fffe0, 0x00000000, 0x00000020,
  0x007cfe0c, 0x007cff06, 0x00000000, 0x000000fa,
  0x007dfe08, 0x007dff04, 0x00000000, 0x000000fc,
  0x007efe04, 0x007eff02, 0x00000000, 0x000000fe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0x0001fff8, 0x0001fffc, 0x00000000, 0x00000004,
  0x000fffc0, 0x000fffe0, 0x00000000, 0x00000020,
  0x007cfe0c, 0x007cff06, 0x00000000, 0x000000fa,
  0x007dfe08, 0x007dff04, 0x00000000, 0x000000fc,
  0x007efe04, 0x007eff02, 0x00000000, 0x000000fe,
  0x33323334, 0x3332999a, 0x00000000, 0x00006666,
  0x0000fffc, 0x0000fffe, 0x00000000, 0x00000002,
  0x0001fff8, 0x0001fffc, 0x00000000, 0x00000004,
  0x000fffc0, 0x000fffe0, 0x00000000, 0x00000020,
  0x007cfe0c, 0x007cff06, 0x00000000, 0x000000fa,
  0x007dfe08, 0x007dff04, 0x00000000, 0x000000fc,
  0x007efe04, 0x007eff02, 0x00000000, 0x000000fe,
  0x33323334, 0x3332999a, 0x00000000, 0x00006666,
  0x5553aaac, 0x55545556, 0x00000000, 0x0000aaaa,
  0x0001fff8, 0x0001fffc, 0x00000000, 0x00000004,
  0x000fffc0, 0x000fffe0, 0x00000000, 0x00000020,
  0x007cfe0c, 0x007cff06, 0x00000000, 0x000000fa,
  0x007dfe08, 0x007dff04, 0x00000000, 0x000000fc,
  0x007efe04, 0x007eff02, 0x00000000, 0x000000fe,
  0x33323334, 0x3332999a, 0x00000000, 0x00006666,
  0x5553aaac, 0x55545556, 0x00000000, 0x0000aaaa,
  0x7ffb000c, 0x7ffc0006, 0x00000000, 0x0000fffa,
  0x000fffc0, 0x000fffe0, 0x00000000, 0x00000020,
  0x007cfe0c, 0x007cff06, 0x00000000, 0x000000fa,
  0x007dfe08, 0x007dff04, 0x00000000, 0x000000fc,
  0x007efe04, 0x007eff02, 0x00000000, 0x000000fe,
  0x33323334, 0x3332999a, 0x00000000, 0x00006666,
  0x5553aaac, 0x55545556, 0x00000000, 0x0000aaaa,
  0x7ffb000c, 0x7ffc0006, 0x00000000, 0x0000fffa,
  0x7ffc0008, 0x7ffd0004, 0x00000000, 0x0000fffc,
  0x007cfe0c, 0x007cff06, 0x00000000, 0x000000fa,
  0x007dfe08, 0x007dff04, 0x00000000, 0x000000fc,
  0x007efe04, 0x007eff02, 0x00000000, 0x000000fe,
  0x33323334, 0x3332999a, 0x00000000, 0x00006666,
  0x5553aaac, 0x55545556, 0x00000000, 0x0000aaaa,
  0x7ffb000c, 0x7ffc0006, 0x00000000, 0x0000fffa,
  0x7ffc0008, 0x7ffd0004, 0x00000000, 0x0000fffc,
  0x7ffd0004, 0x7ffe0002, 0x00000000, 0x0000fffe,
  0x007dfe08, 0x007dff04, 0x00000000, 0x000000fc,
  0x007efe04, 0x007eff02, 0x00000000, 0x000000fe,
  0x33323334, 0x3332999a, 0x00000000, 0x00006666,
  0x5553aaac, 0x55545556, 0x00000000, 0x0000aaaa,
  0x7ffb000c, 0x7ffc0006, 0x00000000, 0x0000fffa,
  0x7ffc0008, 0x7ffd0004, 0x00000000, 0x0000fffc,
  0x7ffd0004, 0x7ffe0002, 0x00000000, 0x0000fffe,
  0x80020000, 0x80010000, 0x00000000, 0xffff0000,
  0x007efe04, 0x007eff02, 0x00000000, 0x000000fe,
  0x33323334, 0x3332999a, 0x00000000, 0x00006666,
  0x5553aaac, 0x55545556, 0x00000000, 0x0000aaaa,
  0x7ffb000c, 0x7ffc0006, 0x00000000, 0x0000fffa,
  0x7ffc0008, 0x7ffd0004, 0x00000000, 0x0000fffc,
  0x7ffd0004, 0x7ffe0002, 0x00000000, 0x0000fffe,
  0x80020000, 0x80010000, 0x00000000, 0xffff0000,
  0x8002fffc, 0x8001fffe, 0x00000000, 0xffff0002,
  0x33323334, 0x3332999a, 0x00000000, 0x00006666,
  0x5553aaac, 0x55545556, 0x00000000, 0x0000aaaa,
  0x7ffb000c, 0x7ffc0006, 0x00000000, 0x0000fffa,
  0x7ffc0008, 0x7ffd0004, 0x00000000, 0x0000fffc,
  0x7ffd0004, 0x7ffe0002, 0x00000000, 0x0000fffe,
  0x80020000, 0x80010000, 0x00000000, 0xffff0000,
  0x8002fffc, 0x8001fffe, 0x00000000, 0xffff0002,
  0xaaab5558, 0xaaaaaaac, 0x00000000, 0xffff5554,
  0x5553aaac, 0x55545556, 0x00000000, 0x0000aaaa,
  0x7ffb000c, 0x7ffc0006, 0x00000000, 0x0000fffa,
  0x7ffc0008, 0x7ffd0004, 0x00000000, 0x0000fffc,
  0x7ffd0004, 0x7ffe0002, 0x00000000, 0x0000fffe,
  0x80020000, 0x80010000, 0x00000000, 0xffff0000,
  0x8002fffc, 0x8001fffe, 0x00000000, 0xffff0002,
  0xaaab5558, 0xaaaaaaac, 0x00000000, 0xffff5554,
  0xccccccd0, 0xcccc6668, 0x00000000, 0xffff9998,
  0x7ffb000c, 0x7ffc0006, 0x00000000, 0x0000fffa,
  0x7ffc0008, 0x7ffd0004, 0x00000000, 0x0000fffc,
  0x7ffd0004, 0x7ffe0002, 0x00000000, 0x0000fffe,
  0x80020000, 0x80010000, 0x00000000, 0xffff0000,
  0x8002fffc, 0x8001fffe, 0x00000000, 0xffff0002,
  0xaaab5558, 0xaaaaaaac, 0x00000000, 0xffff5554,
  0xccccccd0, 0xcccc6668, 0x00000000, 0xffff9998,
  0xff800200, 0xff800100, 0x00000000, 0xffffff00,
  0x7ffc0008, 0x7ffd0004, 0x00000000, 0x0000fffc,
  0x7ffd0004, 0x7ffe0002, 0x00000000, 0x0000fffe,
  0x80020000, 0x80010000, 0x00000000, 0xffff0000,
  0x8002fffc, 0x8001fffe, 0x00000000, 0xffff0002,
  0xaaab5558, 0xaaaaaaac, 0x00000000, 0xffff5554,
  0xccccccd0, 0xcccc6668, 0x00000000, 0xffff9998,
  0xff800200, 0xff800100, 0x00000000, 0xffffff00,
  0xff8101fc, 0xff8100fe, 0x00000000, 0xffffff02,
  0x7ffd0004, 0x7ffe0002, 0x00000000, 0x0000fffe,
  0x80020000, 0x80010000, 0x00000000, 0xffff0000,
  0x8002fffc, 0x8001fffe, 0x00000000, 0xffff0002,
  0xaaab5558, 0xaaaaaaac, 0x00000000, 0xffff5554,
  0xccccccd0, 0xcccc6668, 0x00000000, 0xffff9998,
  0xff800200, 0xff800100, 0x00000000, 0xffffff00,
  0xff8101fc, 0xff8100fe, 0x00000000, 0xffffff02,
  0xff8201f8, 0xff8200fc, 0x00000000, 0xffffff04,
  0x80020000, 0x80010000, 0x00000000, 0xffff0000,
  0x8002fffc, 0x8001fffe, 0x00000000, 0xffff0002,
  0xaaab5558, 0xaaaaaaac, 0x00000000, 0xffff5554,
  0xccccccd0, 0xcccc6668, 0x00000000, 0xffff9998,
  0xff800200, 0xff800100, 0x00000000, 0xffffff00,
  0xff8101fc, 0xff8100fe, 0x00000000, 0xffffff02,
  0xff8201f8, 0xff8200fc, 0x00000000, 0xffffff04,
  0xff8301f4, 0xff8300fa, 0x00000000, 0xffffff06,
  0x8002fffc, 0x8001fffe, 0x00000000, 0xffff0002,
  0xaaab5558, 0xaaaaaaac, 0x00000000, 0xffff5554,
  0xccccccd0, 0xcccc6668, 0x00000000, 0xffff9998,
  0xff800200, 0xff800100, 0x00000000, 0xffffff00,
  0xff8101fc, 0xff8100fe, 0x00000000, 0xffffff02,
  0xff8201f8, 0xff8200fc, 0x00000000, 0xffffff04,
  0xff8301f4, 0xff8300fa, 0x00000000, 0xffffff06,
  0xfff00040, 0xfff00020, 0x00000000, 0xffffffe0,
  0xaaab5558, 0xaaaaaaac, 0x00000000, 0xffff5554,
  0xccccccd0, 0xcccc6668, 0x00000000, 0xffff9998,
  0xff800200, 0xff800100, 0x00000000, 0xffffff00,
  0xff8101fc, 0xff8100fe, 0x00000000, 0xffffff02,
  0xff8201f8, 0xff8200fc, 0x00000000, 0xffffff04,
  0xff8301f4, 0xff8300fa, 0x00000000, 0xffffff06,
  0xfff00040, 0xfff00020, 0x00000000, 0xffffffe0,
  0xfffd000c, 0xfffd0006, 0x00000000, 0xfffffffa,
  0xccccccd0, 0xcccc6668, 0x00000000, 0xffff9998,
  0xff800200, 0xff800100, 0x00000000, 0xffffff00,
  0xff8101fc, 0xff8100fe, 0x00000000, 0xffffff02,
  0xff8201f8, 0xff8200fc, 0x00000000, 0xffffff04,
  0xff8301f4, 0xff8300fa, 0x00000000, 0xffffff06,
  0xfff00040, 0xfff00020, 0x00000000, 0xffffffe0,
  0xfffd000c, 0xfffd0006, 0x00000000, 0xfffffffa,
  0xfffe0008, 0xfffe0004, 0x00000000, 0xfffffffc,
  0xff800200, 0xff800100, 0x00000000, 0xffffff00,
  0xff8101fc, 0xff8100fe, 0x00000000, 0xffffff02,
  0xff8201f8, 0xff8200fc, 0x00000000, 0xffffff04,
  0xff8301f4, 0xff8300fa, 0x00000000, 0xffffff06,
  0xfff00040, 0xfff00020, 0x00000000, 0xffffffe0,
  0xfffd000c, 0xfffd0006, 0x00000000, 0xfffffffa,
  0xfffe0008, 0xfffe0004, 0x00000000, 0xfffffffc,
  0xffff0004, 0xffff0002, 0x00000000, 0xfffffffe,
  0xff8100fe, 0x00000000, 0xffffff02, 0xfffffe04,
  0xff8200fc, 0x00000000, 0xffffff04, 0xfffffe08,
  0xff8300fa, 0x00000000, 0xffffff06, 0xfffffe0c,
  0xfff00020, 0x00000000, 0xffffffe0, 0xffffffc0,
  0xfffd0006, 0x00000000, 0xfffffffa, 0xfffffff4,
  0xfffe0004, 0x00000000, 0xfffffffc, 0xfffffff8,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xff8200fc, 0x00000000, 0xffffff04, 0xfffffe08,
  0xff8300fa, 0x00000000, 0xffffff06, 0xfffffe0c,
  0xfff00020, 0x00000000, 0xffffffe0, 0xffffffc0,
  0xfffd0006, 0x00000000, 0xfffffffa, 0xfffffff4,
  0xfffe0004, 0x00000000, 0xfffffffc, 0xfffffff8,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0xff8300fa, 0x00000000, 0xffffff06, 0xfffffe0c,
  0xfff00020, 0x00000000, 0xffffffe0, 0xffffffc0,
  0xfffd0006, 0x00000000, 0xfffffffa, 0xfffffff4,
  0xfffe0004, 0x00000000, 0xfffffffc, 0xfffffff8,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0x0001fffc, 0x00000000, 0x00000004, 0x00000008,
  0xfff00020, 0x00000000, 0xffffffe0, 0xffffffc0,
  0xfffd0006, 0x00000000, 0xfffffffa, 0xfffffff4,
  0xfffe0004, 0x00000000, 0xfffffffc, 0xfffffff8,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0x0001fffc, 0x00000000, 0x00000004, 0x00000008,
  0x000fffe0, 0x00000000, 0x00000020, 0x00000040,
  0xfffd0006, 0x00000000, 0xfffffffa, 0xfffffff4,
  0xfffe0004, 0x00000000, 0xfffffffc, 0xfffffff8,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0x0001fffc, 0x00000000, 0x00000004, 0x00000008,
  0x000fffe0, 0x00000000, 0x00000020, 0x00000040,
  0x007cff06, 0x00000000, 0x000000fa, 0x000001f4,
  0xfffe0004, 0x00000000, 0xfffffffc, 0xfffffff8,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0x0001fffc, 0x00000000, 0x00000004, 0x00000008,
  0x000fffe0, 0x00000000, 0x00000020, 0x00000040,
  0x007cff06, 0x00000000, 0x000000fa, 0x000001f4,
  0x007dff04, 0x00000000, 0x000000fc, 0x000001f8,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0x0001fffc, 0x00000000, 0x00000004, 0x00000008,
  0x000fffe0, 0x00000000, 0x00000020, 0x00000040,
  0x007cff06, 0x00000000, 0x000000fa, 0x000001f4,
  0x007dff04, 0x00000000, 0x000000fc, 0x000001f8,
  0x007eff02, 0x00000000, 0x000000fe, 0x000001fc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0x0001fffc, 0x00000000, 0x00000004, 0x00000008,
  0x000fffe0, 0x00000000, 0x00000020, 0x00000040,
  0x007cff06, 0x00000000, 0x000000fa, 0x000001f4,
  0x007dff04, 0x00000000, 0x000000fc, 0x000001f8,
  0x007eff02, 0x00000000, 0x000000fe, 0x000001fc,
  0x3332999a, 0x00000000, 0x00006666, 0x0000cccc,
  0x0000fffe, 0x00000000, 0x00000002, 0x00000004,
  0x0001fffc, 0x00000000, 0x00000004, 0x00000008,
  0x000fffe0, 0x00000000, 0x00000020, 0x00000040,
  0x007cff06, 0x00000000, 0x000000fa, 0x000001f4,
  0x007dff04, 0x00000000, 0x000000fc, 0x000001f8,
  0x007eff02, 0x00000000, 0x000000fe, 0x000001fc,
  0x3332999a, 0x00000000, 0x00006666, 0x0000cccc,
  0x55545556, 0x00000000, 0x0000aaaa, 0x00015554,
  0x0001fffc, 0x00000000, 0x00000004, 0x00000008,
  0x000fffe0, 0x00000000, 0x00000020, 0x00000040,
  0x007cff06, 0x00000000, 0x000000fa, 0x000001f4,
  0x007dff04, 0x00000000, 0x000000fc, 0x000001f8,
  0x007eff02, 0x00000000, 0x000000fe, 0x000001fc,
  0x3332999a, 0x00000000, 0x00006666, 0x0000cccc,
  0x55545556, 0x00000000, 0x0000aaaa, 0x00015554,
  0x7ffc0006, 0x00000000, 0x0000fffa, 0x0001fff4,
  0x000fffe0, 0x00000000, 0x00000020, 0x00000040,
  0x007cff06, 0x00000000, 0x000000fa, 0x000001f4,
  0x007dff04, 0x00000000, 0x000000fc, 0x000001f8,
  0x007eff02, 0x00000000, 0x000000fe, 0x000001fc,
  0x3332999a, 0x00000000, 0x00006666, 0x0000cccc,
  0x55545556, 0x00000000, 0x0000aaaa, 0x00015554,
  0x7ffc0006, 0x00000000, 0x0000fffa, 0x0001fff4,
  0x7ffd0004, 0x00000000, 0x0000fffc, 0x0001fff8,
  0x007cff06, 0x00000000, 0x000000fa, 0x000001f4,
  0x007dff04, 0x00000000, 0x000000fc, 0x000001f8,
  0x007eff02, 0x00000000, 0x000000fe, 0x000001fc,
  0x3332999a, 0x00000000, 0x00006666, 0x0000cccc,
  0x55545556, 0x00000000, 0x0000aaaa, 0x00015554,
  0x7ffc0006, 0x00000000, 0x0000fffa, 0x0001fff4,
  0x7ffd0004, 0x00000000, 0x0000fffc, 0x0001fff8,
  0x7ffe0002, 0x00000000, 0x0000fffe, 0x0001fffc,
  0x007dff04, 0x00000000, 0x000000fc, 0x000001f8,
  0x007eff02, 0x00000000, 0x000000fe, 0x000001fc,
  0x3332999a, 0x00000000, 0x00006666, 0x0000cccc,
  0x55545556, 0x00000000, 0x0000aaaa, 0x00015554,
  0x7ffc0006, 0x00000000, 0x0000fffa, 0x0001fff4,
  0x7ffd0004, 0x00000000, 0x0000fffc, 0x0001fff8,
  0x7ffe0002, 0x00000000, 0x0000fffe, 0x0001fffc,
  0x80010000, 0x00000000, 0xffff0000, 0xfffe0000,
  0x007eff02, 0x00000000, 0x000000fe, 0x000001fc,
  0x3332999a, 0x00000000, 0x00006666, 0x0000cccc,
  0x55545556, 0x00000000, 0x0000aaaa, 0x00015554,
  0x7ffc0006, 0x00000000, 0x0000fffa, 0x0001fff4,
  0x7ffd0004, 0x00000000, 0x0000fffc, 0x0001fff8,
  0x7ffe0002, 0x00000000, 0x0000fffe, 0x0001fffc,
  0x80010000, 0x00000000, 0xffff0000, 0xfffe0000,
  0x8001fffe, 0x00000000, 0xffff0002, 0xfffe0004,
  0x3332999a, 0x00000000, 0x00006666, 0x0000cccc,
  0x55545556, 0x00000000, 0x0000aaaa, 0x00015554,
  0x7ffc0006, 0x00000000, 0x0000fffa, 0x0001fff4,
  0x7ffd0004, 0x00000000, 0x0000fffc, 0x0001fff8,
  0x7ffe0002, 0x00000000, 0x0000fffe, 0x0001fffc,
  0x80010000, 0x00000000, 0xffff0000, 0xfffe0000,
  0x8001fffe, 0x00000000, 0xffff0002, 0xfffe0004,
  0xaaaaaaac, 0x00000000, 0xffff5554, 0xfffeaaa8,
  0x55545556, 0x00000000, 0x0000aaaa, 0x00015554,
  0x7ffc0006, 0x00000000, 0x0000fffa, 0x0001fff4,
  0x7ffd0004, 0x00000000, 0x0000fffc, 0x0001fff8,
  0x7ffe0002, 0x00000000, 0x0000fffe, 0x0001fffc,
  0x80010000, 0x00000000, 0xffff0000, 0xfffe0000,
  0x8001fffe, 0x00000000, 0xffff0002, 0xfffe0004,
  0xaaaaaaac, 0x00000000, 0xffff5554, 0xfffeaaa8,
  0xcccc6668, 0x00000000, 0xffff9998, 0xffff3330,
  0x7ffc0006, 0x00000000, 0x0000fffa, 0x0001fff4,
  0x7ffd0004, 0x00000000, 0x0000fffc, 0x0001fff8,
  0x7ffe0002, 0x00000000, 0x0000fffe, 0x0001fffc,
  0x80010000, 0x00000000, 0xffff0000, 0xfffe0000,
  0x8001fffe, 0x00000000, 0xffff0002, 0xfffe0004,
  0xaaaaaaac, 0x00000000, 0xffff5554, 0xfffeaaa8,
  0xcccc6668, 0x00000000, 0xffff9998, 0xffff3330,
  0xff800100, 0x00000000, 0xffffff00, 0xfffffe00,
  0x7ffd0004, 0x00000000, 0x0000fffc, 0x0001fff8,
  0x7ffe0002, 0x00000000, 0x0000fffe, 0x0001fffc,
  0x80010000, 0x00000000, 0xffff0000, 0xfffe0000,
  0x8001fffe, 0x00000000, 0xffff0002, 0xfffe0004,
  0xaaaaaaac, 0x00000000, 0xffff5554, 0xfffeaaa8,
  0xcccc6668, 0x00000000, 0xffff9998, 0xffff3330,
  0xff800100, 0x00000000, 0xffffff00, 0xfffffe00,
  0xff8100fe, 0x00000000, 0xffffff02, 0xfffffe04,
  0x7ffe0002, 0x00000000, 0x0000fffe, 0x0001fffc,
  0x80010000, 0x00000000, 0xffff0000, 0xfffe0000,
  0x8001fffe, 0x00000000, 0xffff0002, 0xfffe0004,
  0xaaaaaaac, 0x00000000, 0xffff5554, 0xfffeaaa8,
  0xcccc6668, 0x00000000, 0xffff9998, 0xffff3330,
  0xff800100, 0x00000000, 0xffffff00, 0xfffffe00,
  0xff8100fe, 0x00000000, 0xffffff02, 0xfffffe04,
  0xff8200fc, 0x00000000, 0xffffff04, 0xfffffe08,
  0x80010000, 0x00000000, 0xffff0000, 0xfffe0000,
  0x8001fffe, 0x00000000, 0xffff0002, 0xfffe0004,
  0xaaaaaaac, 0x00000000, 0xffff5554, 0xfffeaaa8,
  0xcccc6668, 0x00000000, 0xffff9998, 0xffff3330,
  0xff800100, 0x00000000, 0xffffff00, 0xfffffe00,
  0xff8100fe, 0x00000000, 0xffffff02, 0xfffffe04,
  0xff8200fc, 0x00000000, 0xffffff04, 0xfffffe08,
  0xff8300fa, 0x00000000, 0xffffff06, 0xfffffe0c,
  0x8001fffe, 0x00000000, 0xffff0002, 0xfffe0004,
  0xaaaaaaac, 0x00000000, 0xffff5554, 0xfffeaaa8,
  0xcccc6668, 0x00000000, 0xffff9998, 0xffff3330,
  0xff800100, 0x00000000, 0xffffff00, 0xfffffe00,
  0xff8100fe, 0x00000000, 0xffffff02, 0xfffffe04,
  0xff8200fc, 0x00000000, 0xffffff04, 0xfffffe08,
  0xff8300fa, 0x00000000, 0xffffff06, 0xfffffe0c,
  0xfff00020, 0x00000000, 0xffffffe0, 0xffffffc0,
  0xaaaaaaac, 0x00000000, 0xffff5554, 0xfffeaaa8,
  0xcccc6668, 0x00000000, 0xffff9998, 0xffff3330,
  0xff800100, 0x00000000, 0xffffff00, 0xfffffe00,
  0xff8100fe, 0x00000000, 0xffffff02, 0xfffffe04,
  0xff8200fc, 0x00000000, 0xffffff04, 0xfffffe08,
  0xff8300fa, 0x00000000, 0xffffff06, 0xfffffe0c,
  0xfff00020, 0x00000000, 0xffffffe0, 0xffffffc0,
  0xfffd0006, 0x00000000, 0xfffffffa, 0xfffffff4,
  0xcccc6668, 0x00000000, 0xffff9998, 0xffff3330,
  0xff800100, 0x00000000, 0xffffff00, 0xfffffe00,
  0xff8100fe, 0x00000000, 0xffffff02, 0xfffffe04,
  0xff8200fc, 0x00000000, 0xffffff04, 0xfffffe08,
  0xff8300fa, 0x00000000, 0xffffff06, 0xfffffe0c,
  0xfff00020, 0x00000000, 0xffffffe0, 0xffffffc0,
  0xfffd0006, 0x00000000, 0xfffffffa, 0xfffffff4,
  0xfffe0004, 0x00000000, 0xfffffffc, 0xfffffff8,
  0xff800100, 0x00000000, 0xffffff00, 0xfffffe00,
  0xff8100fe, 0x00000000, 0xffffff02, 0xfffffe04,
  0xff8200fc, 0x00000000, 0xffffff04, 0xfffffe08,
  0xff8300fa, 0x00000000, 0xffffff06, 0xfffffe0c,
  0xfff00020, 0x00000000, 0xffffffe0, 0xffffffc0,
  0xfffd0006, 0x00000000, 0xfffffffa, 0xfffffff4,
  0xfffe0004, 0x00000000, 0xfffffffc, 0xfffffff8,
  0xffff0002, 0x00000000, 0xfffffffe, 0xfffffffc,
  0x00000000, 0xffffff02, 0xfffffe04, 0xfffff020,
  0x00000000, 0xffffff04, 0xfffffe08, 0xfffff040,
  0x00000000, 0xffffff06, 0xfffffe0c, 0xfffff060,
  0x00000000, 0xffffffe0, 0xffffffc0, 0xfffffe00,
  0x00000000, 0xfffffffa, 0xfffffff4, 0xffffffa0,
  0x00000000, 0xfffffffc, 0xfffffff8, 0xffffffc0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0xffffff04, 0xfffffe08, 0xfffff040,
  0x00000000, 0xffffff06, 0xfffffe0c, 0xfffff060,
  0x00000000, 0xffffffe0, 0xffffffc0, 0xfffffe00,
  0x00000000, 0xfffffffa, 0xfffffff4, 0xffffffa0,
  0x00000000, 0xfffffffc, 0xfffffff8, 0xffffffc0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0xffffff06, 0xfffffe0c, 0xfffff060,
  0x00000000, 0xffffffe0, 0xffffffc0, 0xfffffe00,
  0x00000000, 0xfffffffa, 0xfffffff4, 0xffffffa0,
  0x00000000, 0xfffffffc, 0xfffffff8, 0xffffffc0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0x00000004, 0x00000008, 0x00000040,
  0x00000000, 0xffffffe0, 0xffffffc0, 0xfffffe00,
  0x00000000, 0xfffffffa, 0xfffffff4, 0xffffffa0,
  0x00000000, 0xfffffffc, 0xfffffff8, 0xffffffc0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0x00000004, 0x00000008, 0x00000040,
  0x00000000, 0x00000020, 0x00000040, 0x00000200,
  0x00000000, 0xfffffffa, 0xfffffff4, 0xffffffa0,
  0x00000000, 0xfffffffc, 0xfffffff8, 0xffffffc0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0x00000004, 0x00000008, 0x00000040,
  0x00000000, 0x00000020, 0x00000040, 0x00000200,
  0x00000000, 0x000000fa, 0x000001f4, 0x00000fa0,
  0x00000000, 0xfffffffc, 0xfffffff8, 0xffffffc0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0x00000004, 0x00000008, 0x00000040,
  0x00000000, 0x00000020, 0x00000040, 0x00000200,
  0x00000000, 0x000000fa, 0x000001f4, 0x00000fa0,
  0x00000000, 0x000000fc, 0x000001f8, 0x00000fc0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0x00000004, 0x00000008, 0x00000040,
  0x00000000, 0x00000020, 0x00000040, 0x00000200,
  0x00000000, 0x000000fa, 0x000001f4, 0x00000fa0,
  0x00000000, 0x000000fc, 0x000001f8, 0x00000fc0,
  0x00000000, 0x000000fe, 0x000001fc, 0x00000fe0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0x00000004, 0x00000008, 0x00000040,
  0x00000000, 0x00000020, 0x00000040, 0x00000200,
  0x00000000, 0x000000fa, 0x000001f4, 0x00000fa0,
  0x00000000, 0x000000fc, 0x000001f8, 0x00000fc0,
  0x00000000, 0x000000fe, 0x000001fc, 0x00000fe0,
  0x00000000, 0x00006666, 0x0000cccc, 0x00066660,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000000, 0x00000004, 0x00000008, 0x00000040,
  0x00000000, 0x00000020, 0x00000040, 0x00000200,
  0x00000000, 0x000000fa, 0x000001f4, 0x00000fa0,
  0x00000000, 0x000000fc, 0x000001f8, 0x00000fc0,
  0x00000000, 0x000000fe, 0x000001fc, 0x00000fe0,
  0x00000000, 0x00006666, 0x0000cccc, 0x00066660,
  0x00000000, 0x0000aaaa, 0x00015554, 0x000aaaa0,
  0x00000000, 0x00000004, 0x00000008, 0x00000040,
  0x00000000, 0x00000020, 0x00000040, 0x00000200,
  0x00000000, 0x000000fa, 0x000001f4, 0x00000fa0,
  0x00000000, 0x000000fc, 0x000001f8, 0x00000fc0,
  0x00000000, 0x000000fe, 0x000001fc, 0x00000fe0,
  0x00000000, 0x00006666, 0x0000cccc, 0x00066660,
  0x00000000, 0x0000aaaa, 0x00015554, 0x000aaaa0,
  0x00000000, 0x0000fffa, 0x0001fff4, 0x000fffa0,
  0x00000000, 0x00000020, 0x00000040, 0x00000200,
  0x00000000, 0x000000fa, 0x000001f4, 0x00000fa0,
  0x00000000, 0x000000fc, 0x000001f8, 0x00000fc0,
  0x00000000, 0x000000fe, 0x000001fc, 0x00000fe0,
  0x00000000, 0x00006666, 0x0000cccc, 0x00066660,
  0x00000000, 0x0000aaaa, 0x00015554, 0x000aaaa0,
  0x00000000, 0x0000fffa, 0x0001fff4, 0x000fffa0,
  0x00000000, 0x0000fffc, 0x0001fff8, 0x000fffc0,
  0x00000000, 0x000000fa, 0x000001f4, 0x00000fa0,
  0x00000000, 0x000000fc, 0x000001f8, 0x00000fc0,
  0x00000000, 0x000000fe, 0x000001fc, 0x00000fe0,
  0x00000000, 0x00006666, 0x0000cccc, 0x00066660,
  0x00000000, 0x0000aaaa, 0x00015554, 0x000aaaa0,
  0x00000000, 0x0000fffa, 0x0001fff4, 0x000fffa0,
  0x00000000, 0x0000fffc, 0x0001fff8, 0x000fffc0,
  0x00000000, 0x0000fffe, 0x0001fffc, 0x000fffe0,
  0x00000000, 0x000000fc, 0x000001f8, 0x00000fc0,
  0x00000000, 0x000000fe, 0x000001fc, 0x00000fe0,
  0x00000000, 0x00006666, 0x0000cccc, 0x00066660,
  0x00000000, 0x0000aaaa, 0x00015554, 0x000aaaa0,
  0x00000000, 0x0000fffa, 0x0001fff4, 0x000fffa0,
  0x00000000, 0x0000fffc, 0x0001fff8, 0x000fffc0,
  0x00000000, 0x0000fffe, 0x0001fffc, 0x000fffe0,
  0x00000000, 0xffff0000, 0xfffe0000, 0xfff00000,
  0x00000000, 0x000000fe, 0x000001fc, 0x00000fe0,
  0x00000000, 0x00006666, 0x0000cccc, 0x00066660,
  0x00000000, 0x0000aaaa, 0x00015554, 0x000aaaa0,
  0x00000000, 0x0000fffa, 0x0001fff4, 0x000fffa0,
  0x00000000, 0x0000fffc, 0x0001fff8, 0x000fffc0,
  0x00000000, 0x0000fffe, 0x0001fffc, 0x000fffe0,
  0x00000000, 0xffff0000, 0xfffe0000, 0xfff00000,
  0x00000000, 0xffff0002, 0xfffe0004, 0xfff00020,
  0x00000000, 0x00006666, 0x0000cccc, 0x00066660,
  0x00000000, 0x0000aaaa, 0x00015554, 0x000aaaa0,
  0x00000000, 0x0000fffa, 0x0001fff4, 0x000fffa0,
  0x00000000, 0x0000fffc, 0x0001fff8, 0x000fffc0,
  0x00000000, 0x0000fffe, 0x0001fffc, 0x000fffe0,
  0x00000000, 0xffff0000, 0xfffe0000, 0xfff00000,
  0x00000000, 0xffff0002, 0xfffe0004, 0xfff00020,
  0x00000000, 0xffff5554, 0xfffeaaa8, 0xfff55540,
  0x00000000, 0x0000aaaa, 0x00015554, 0x000aaaa0,
  0x00000000, 0x0000fffa, 0x0001fff4, 0x000fffa0,
  0x00000000, 0x0000fffc, 0x0001fff8, 0x000fffc0,
  0x00000000, 0x0000fffe, 0x0001fffc, 0x000fffe0,
  0x00000000, 0xffff0000, 0xfffe0000, 0xfff00000,
  0x00000000, 0xffff0002, 0xfffe0004, 0xfff00020,
  0x00000000, 0xffff5554, 0xfffeaaa8, 0xfff55540,
  0x00000000, 0xffff9998, 0xffff3330, 0xfff99980,
  0x00000000, 0x0000fffa, 0x0001fff4, 0x000fffa0,
  0x00000000, 0x0000fffc, 0x0001fff8, 0x000fffc0,
  0x00000000, 0x0000fffe, 0x0001fffc, 0x000fffe0,
  0x00000000, 0xffff0000, 0xfffe0000, 0xfff00000,
  0x00000000, 0xffff0002, 0xfffe0004, 0xfff00020,
  0x00000000, 0xffff5554, 0xfffeaaa8, 0xfff55540,
  0x00000000, 0xffff9998, 0xffff3330, 0xfff99980,
  0x00000000, 0xffffff00, 0xfffffe00, 0xfffff000,
  0x00000000, 0x0000fffc, 0x0001fff8, 0x000fffc0,
  0x00000000, 0x0000fffe, 0x0001fffc, 0x000fffe0,
  0x00000000, 0xffff0000, 0xfffe0000, 0xfff00000,
  0x00000000, 0xffff0002, 0xfffe0004, 0xfff00020,
  0x00000000, 0xffff5554, 0xfffeaaa8, 0xfff55540,
  0x00000000, 0xffff9998, 0xffff3330, 0xfff99980,
  0x00000000, 0xffffff00, 0xfffffe00, 0xfffff000,
  0x00000000, 0xffffff02, 0xfffffe04, 0xfffff020,
  0x00000000, 0x0000fffe, 0x0001fffc, 0x000fffe0,
  0x00000000, 0xffff0000, 0xfffe0000, 0xfff00000,
  0x00000000, 0xffff0002, 0xfffe0004, 0xfff00020,
  0x00000000, 0xffff5554, 0xfffeaaa8, 0xfff55540,
  0x00000000, 0xffff9998, 0xffff3330, 0xfff99980,
  0x00000000, 0xffffff00, 0xfffffe00, 0xfffff000,
  0x00000000, 0xffffff02, 0xfffffe04, 0xfffff020,
  0x00000000, 0xffffff04, 0xfffffe08, 0xfffff040,
  0x00000000, 0xffff0000, 0xfffe0000, 0xfff00000,
  0x00000000, 0xffff0002, 0xfffe0004, 0xfff00020,
  0x00000000, 0xffff5554, 0xfffeaaa8, 0xfff55540,
  0x00000000, 0xffff9998, 0xffff3330, 0xfff99980,
  0x00000000, 0xffffff00, 0xfffffe00, 0xfffff000,
  0x00000000, 0xffffff02, 0xfffffe04, 0xfffff020,
  0x00000000, 0xffffff04, 0xfffffe08, 0xfffff040,
  0x00000000, 0xffffff06, 0xfffffe0c, 0xfffff060,
  0x00000000, 0xffff0002, 0xfffe0004, 0xfff00020,
  0x00000000, 0xffff5554, 0xfffeaaa8, 0xfff55540,
  0x00000000, 0xffff9998, 0xffff3330, 0xfff99980,
  0x00000000, 0xffffff00, 0xfffffe00, 0xfffff000,
  0x00000000, 0xffffff02, 0xfffffe04, 0xfffff020,
  0x00000000, 0xffffff04, 0xfffffe08, 0xfffff040,
  0x00000000, 0xffffff06, 0xfffffe0c, 0xfffff060,
  0x00000000, 0xffffffe0, 0xffffffc0, 0xfffffe00,
  0x00000000, 0xffff5554, 0xfffeaaa8, 0xfff55540,
  0x00000000, 0xffff9998, 0xffff3330, 0xfff99980,
  0x00000000, 0xffffff00, 0xfffffe00, 0xfffff000,
  0x00000000, 0xffffff02, 0xfffffe04, 0xfffff020,
  0x00000000, 0xffffff04, 0xfffffe08, 0xfffff040,
  0x00000000, 0xffffff06, 0xfffffe0c, 0xfffff060,
  0x00000000, 0xffffffe0, 0xffffffc0, 0xfffffe00,
  0x00000000, 0xfffffffa, 0xfffffff4, 0xffffffa0,
  0x00000000, 0xffff9998, 0xffff3330, 0xfff99980,
  0x00000000, 0xffffff00, 0xfffffe00, 0xfffff000,
  0x00000000, 0xffffff02, 0xfffffe04, 0xfffff020,
  0x00000000, 0xffffff04, 0xfffffe08, 0xfffff040,
  0x00000000, 0xffffff06, 0xfffffe0c, 0xfffff060,
  0x00000000, 0xffffffe0, 0xffffffc0, 0xfffffe00,
  0x00000000, 0xfffffffa, 0xfffffff4, 0xffffffa0,
  0x00000000, 0xfffffffc, 0xfffffff8, 0xffffffc0,
  0x00000000, 0xffffff00, 0xfffffe00, 0xfffff000,
  0x00000000, 0xffffff02, 0xfffffe04, 0xfffff020,
  0x00000000, 0xffffff04, 0xfffffe08, 0xfffff040,
  0x00000000, 0xffffff06, 0xfffffe0c, 0xfffff060,
  0x00000000, 0xffffffe0, 0xffffffc0, 0xfffffe00,
  0x00000000, 0xfffffffa, 0xfffffff4, 0xffffffa0,
  0x00000000, 0xfffffffc, 0xfffffff8, 0xffffffc0,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xffffffe0,
  0xffffff02, 0xfffffe04, 0xfffff020, 0xffff83fa,
  0xffffff04, 0xfffffe08, 0xfffff040, 0xffff84f4,
  0xffffff06, 0xfffffe0c, 0xfffff060, 0xffff85ee,
  0xffffffe0, 0xffffffc0, 0xfffffe00, 0xfffff060,
  0xfffffffa, 0xfffffff4, 0xffffffa0, 0xfffffd12,
  0xfffffffc, 0xfffffff8, 0xffffffc0, 0xfffffe0c,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff04, 0xfffffe08, 0xfffff040, 0xffff84f4,
  0xffffff06, 0xfffffe0c, 0xfffff060, 0xffff85ee,
  0xffffffe0, 0xffffffc0, 0xfffffe00, 0xfffff060,
  0xfffffffa, 0xfffffff4, 0xffffffa0, 0xfffffd12,
  0xfffffffc, 0xfffffff8, 0xffffffc0, 0xfffffe0c,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0xffffff06, 0xfffffe0c, 0xfffff060, 0xffff85ee,
  0xffffffe0, 0xffffffc0, 0xfffffe00, 0xfffff060,
  0xfffffffa, 0xfffffff4, 0xffffffa0, 0xfffffd12,
  0xfffffffc, 0xfffffff8, 0xffffffc0, 0xfffffe0c,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000004, 0x00000008, 0x00000040, 0x000001f4,
  0xffffffe0, 0xffffffc0, 0xfffffe00, 0xfffff060,
  0xfffffffa, 0xfffffff4, 0xffffffa0, 0xfffffd12,
  0xfffffffc, 0xfffffff8, 0xffffffc0, 0xfffffe0c,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000004, 0x00000008, 0x00000040, 0x000001f4,
  0x00000020, 0x00000040, 0x00000200, 0x00000fa0,
  0xfffffffa, 0xfffffff4, 0xffffffa0, 0xfffffd12,
  0xfffffffc, 0xfffffff8, 0xffffffc0, 0xfffffe0c,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000004, 0x00000008, 0x00000040, 0x000001f4,
  0x00000020, 0x00000040, 0x00000200, 0x00000fa0,
  0x000000fa, 0x000001f4, 0x00000fa0, 0x00007a12,
  0xfffffffc, 0xfffffff8, 0xffffffc0, 0xfffffe0c,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000004, 0x00000008, 0x00000040, 0x000001f4,
  0x00000020, 0x00000040, 0x00000200, 0x00000fa0,
  0x000000fa, 0x000001f4, 0x00000fa0, 0x00007a12,
  0x000000fc, 0x000001f8, 0x00000fc0, 0x00007b0c,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000004, 0x00000008, 0x00000040, 0x000001f4,
  0x00000020, 0x00000040, 0x00000200, 0x00000fa0,
  0x000000fa, 0x000001f4, 0x00000fa0, 0x00007a12,
  0x000000fc, 0x000001f8, 0x00000fc0, 0x00007b0c,
  0x000000fe, 0x000001fc, 0x00000fe0, 0x00007c06,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000004, 0x00000008, 0x00000040, 0x000001f4,
  0x00000020, 0x00000040, 0x00000200, 0x00000fa0,
  0x000000fa, 0x000001f4, 0x00000fa0, 0x00007a12,
  0x000000fc, 0x000001f8, 0x00000fc0, 0x00007b0c,
  0x000000fe, 0x000001fc, 0x00000fe0, 0x00007c06,
  0x00006666, 0x0000cccc, 0x00066660, 0x0031ffce,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000004, 0x00000008, 0x00000040, 0x000001f4,
  0x00000020, 0x00000040, 0x00000200, 0x00000fa0,
  0x000000fa, 0x000001f4, 0x00000fa0, 0x00007a12,
  0x000000fc, 0x000001f8, 0x00000fc0, 0x00007b0c,
  0x000000fe, 0x000001fc, 0x00000fe0, 0x00007c06,
  0x00006666, 0x0000cccc, 0x00066660, 0x0031ffce,
  0x0000aaaa, 0x00015554, 0x000aaaa0, 0x00535502,
  0x00000004, 0x00000008, 0x00000040, 0x000001f4,
  0x00000020, 0x00000040, 0x00000200, 0x00000fa0,
  0x000000fa, 0x000001f4, 0x00000fa0, 0x00007a12,
  0x000000fc, 0x000001f8, 0x00000fc0, 0x00007b0c,
  0x000000fe, 0x000001fc, 0x00000fe0, 0x00007c06,
  0x00006666, 0x0000cccc, 0x00066660, 0x0031ffce,
  0x0000aaaa, 0x00015554, 0x000aaaa0, 0x00535502,
  0x0000fffa, 0x0001fff4, 0x000fffa0, 0x007cfd12,
  0x00000020, 0x00000040, 0x00000200, 0x00000fa0,
  0x000000fa, 0x000001f4, 0x00000fa0, 0x00007a12,
  0x000000fc, 0x000001f8, 0x00000fc0, 0x00007b0c,
  0x000000fe, 0x000001fc, 0x00000fe0, 0x00007c06,
  0x00006666, 0x0000cccc, 0x00066660, 0x0031ffce,
  0x0000aaaa, 0x00015554, 0x000aaaa0, 0x00535502,
  0x0000fffa, 0x0001fff4, 0x000fffa0, 0x007cfd12,
  0x0000fffc, 0x0001fff8, 0x000fffc0, 0x007cfe0c,
  0x000000fa, 0x000001f4, 0x00000fa0, 0x00007a12,
  0x000000fc, 0x000001f8, 0x00000fc0, 0x00007b0c,
  0x000000fe, 0x000001fc, 0x00000fe0, 0x00007c06,
  0x00006666, 0x0000cccc, 0x00066660, 0x0031ffce,
  0x0000aaaa, 0x00015554, 0x000aaaa0, 0x00535502,
  0x0000fffa, 0x0001fff4, 0x000fffa0, 0x007cfd12,
  0x0000fffc, 0x0001fff8, 0x000fffc0, 0x007cfe0c,
  0x0000fffe, 0x0001fffc, 0x000fffe0, 0x007cff06,
  0x000000fc, 0x000001f8, 0x00000fc0, 0x00007b0c,
  0x000000fe, 0x000001fc, 0x00000fe0, 0x00007c06,
  0x00006666, 0x0000cccc, 0x00066660, 0x0031ffce,
  0x0000aaaa, 0x00015554, 0x000aaaa0, 0x00535502,
  0x0000fffa, 0x0001fff4, 0x000fffa0, 0x007cfd12,
  0x0000fffc, 0x0001fff8, 0x000fffc0, 0x007cfe0c,
  0x0000fffe, 0x0001fffc, 0x000fffe0, 0x007cff06,
  0xffff0000, 0xfffe0000, 0xfff00000, 0xff830000,
  0x000000fe, 0x000001fc, 0x00000fe0, 0x00007c06,
  0x00006666, 0x0000cccc, 0x00066660, 0x0031ffce,
  0x0000aaaa, 0x00015554, 0x000aaaa0, 0x00535502,
  0x0000fffa, 0x0001fff4, 0x000fffa0, 0x007cfd12,
  0x0000fffc, 0x0001fff8, 0x000fffc0, 0x007cfe0c,
  0x0000fffe, 0x0001fffc, 0x000fffe0, 0x007cff06,
  0xffff0000, 0xfffe0000, 0xfff00000, 0xff830000,
  0xffff0002, 0xfffe0004, 0xfff00020, 0xff8300fa,
  0x00006666, 0x0000cccc, 0x00066660, 0x0031ffce,
  0x0000aaaa, 0x00015554, 0x000aaaa0, 0x00535502,
  0x0000fffa, 0x0001fff4, 0x000fffa0, 0x007cfd12,
  0x0000fffc, 0x0001fff8, 0x000fffc0, 0x007cfe0c,
  0x0000fffe, 0x0001fffc, 0x000fffe0, 0x007cff06,
  0xffff0000, 0xfffe0000, 0xfff00000, 0xff830000,
  0xffff0002, 0xfffe0004, 0xfff00020, 0xff8300fa,
  0xffff5554, 0xfffeaaa8, 0xfff55540, 0xffacaa04,
  0x0000aaaa, 0x00015554, 0x000aaaa0, 0x00535502,
  0x0000fffa, 0x0001fff4, 0x000fffa0, 0x007cfd12,
  0x0000fffc, 0x0001fff8, 0x000fffc0, 0x007cfe0c,
  0x0000fffe, 0x0001fffc, 0x000fffe0, 0x007cff06,
  0xffff0000, 0xfffe0000, 0xfff00000, 0xff830000,
  0xffff0002, 0xfffe0004, 0xfff00020, 0xff8300fa,
  0xffff5554, 0xfffeaaa8, 0xfff55540, 0xffacaa04,
  0xffff9998, 0xffff3330, 0xfff99980, 0xffcdff38,
  0x0000fffa, 0x0001fff4, 0x000fffa0, 0x007cfd12,
  0x0000fffc, 0x0001fff8, 0x000fffc0, 0x007cfe0c,
  0x0000fffe, 0x0001fffc, 0x000fffe0, 0x007cff06,
  0xffff0000, 0xfffe0000, 0xfff00000, 0xff830000,
  0xffff0002, 0xfffe0004, 0xfff00020, 0xff8300fa,
  0xffff5554, 0xfffeaaa8, 0xfff55540, 0xffacaa04,
  0xffff9998, 0xffff3330, 0xfff99980, 0xffcdff38,
  0xffffff00, 0xfffffe00, 0xfffff000, 0xffff8300,
  0x0000fffc, 0x0001fff8, 0x000fffc0, 0x007cfe0c,
  0x0000fffe, 0x0001fffc, 0x000fffe0, 0x007cff06,
  0xffff0000, 0xfffe0000, 0xfff00000, 0xff830000,
  0xffff0002, 0xfffe0004, 0xfff00020, 0xff8300fa,
  0xffff5554, 0xfffeaaa8, 0xfff55540, 0xffacaa04,
  0xffff9998, 0xffff3330, 0xfff99980, 0xffcdff38,
  0xffffff00, 0xfffffe00, 0xfffff000, 0xffff8300,
  0xffffff02, 0xfffffe04, 0xfffff020, 0xffff83fa,
  0x0000fffe, 0x0001fffc, 0x000fffe0, 0x007cff06,
  0xffff0000, 0xfffe0000, 0xfff00000, 0xff830000,
  0xffff0002, 0xfffe0004, 0xfff00020, 0xff8300fa,
  0xffff5554, 0xfffeaaa8, 0xfff55540, 0xffacaa04,
  0xffff9998, 0xffff3330, 0xfff99980, 0xffcdff38,
  0xffffff00, 0xfffffe00, 0xfffff000, 0xffff8300,
  0xffffff02, 0xfffffe04, 0xfffff020, 0xffff83fa,
  0xffffff04, 0xfffffe08, 0xfffff040, 0xffff84f4,
  0xffff0000, 0xfffe0000, 0xfff00000, 0xff830000,
  0xffff0002, 0xfffe0004, 0xfff00020, 0xff8300fa,
  0xffff5554, 0xfffeaaa8, 0xfff55540, 0xffacaa04,
  0xffff9998, 0xffff3330, 0xfff99980, 0xffcdff38,
  0xffffff00, 0xfffffe00, 0xfffff000, 0xffff8300,
  0xffffff02, 0xfffffe04, 0xfffff020, 0xffff83fa,
  0xffffff04, 0xfffffe08, 0xfffff040, 0xffff84f4,
  0xffffff06, 0xfffffe0c, 0xfffff060, 0xffff85ee,
  0xffff0002, 0xfffe0004, 0xfff00020, 0xff8300fa,
  0xffff5554, 0xfffeaaa8, 0xfff55540, 0xffacaa04,
  0xffff9998, 0xffff3330, 0xfff99980, 0xffcdff38,
  0xffffff00, 0xfffffe00, 0xfffff000, 0xffff8300,
  0xffffff02, 0xfffffe04, 0xfffff020, 0xffff83fa,
  0xffffff04, 0xfffffe08, 0xfffff040, 0xffff84f4,
  0xffffff06, 0xfffffe0c, 0xfffff060, 0xffff85ee,
  0xffffffe0, 0xffffffc0, 0xfffffe00, 0xfffff060,
  0xffff5554, 0xfffeaaa8, 0xfff55540, 0xffacaa04,
  0xffff9998, 0xffff3330, 0xfff99980, 0xffcdff38,
  0xffffff00, 0xfffffe00, 0xfffff000, 0xffff8300,
  0xffffff02, 0xfffffe04, 0xfffff020, 0xffff83fa,
  0xffffff04, 0xfffffe08, 0xfffff040, 0xffff84f4,
  0xffffff06, 0xfffffe0c, 0xfffff060, 0xffff85ee,
  0xffffffe0, 0xffffffc0, 0xfffffe00, 0xfffff060,
  0xfffffffa, 0xfffffff4, 0xffffffa0, 0xfffffd12,
  0xffff9998, 0xffff3330, 0xfff99980, 0xffcdff38,
  0xffffff00, 0xfffffe00, 0xfffff000, 0xffff8300,
  0xffffff02, 0xfffffe04, 0xfffff020, 0xffff83fa,
  0xffffff04, 0xfffffe08, 0xfffff040, 0xffff84f4,
  0xffffff06, 0xfffffe0c, 0xfffff060, 0xffff85ee,
  0xffffffe0, 0xffffffc0, 0xfffffe00, 0xfffff060,
  0xfffffffa, 0xfffffff4, 0xffffffa0, 0xfffffd12,
  0xfffffffc, 0xfffffff8, 0xffffffc0, 0xfffffe0c,
  0xffffff00, 0xfffffe00, 0xfffff000, 0xffff8300,
  0xffffff02, 0xfffffe04, 0xfffff020, 0xffff83fa,
  0xffffff04, 0xfffffe08, 0xfffff040, 0xffff84f4,
  0xffffff06, 0xfffffe0c, 0xfffff060, 0xffff85ee,
  0xffffffe0, 0xffffffc0, 0xfffffe00, 0xfffff060,
  0xfffffffa, 0xfffffff4, 0xffffffa0, 0xfffffd12,
  0xfffffffc, 0xfffffff8, 0xffffffc0, 0xfffffe0c,
  0xfffffffe, 0xfffffffc, 0xffffffe0, 0xffffff06,
  0xfffffe04, 0xfffff020, 0xffff83fa, 0xffff82fc,
  0xfffffe08, 0xfffff040, 0xffff84f4, 0xffff83f8,
  0xfffffe0c, 0xfffff060, 0xffff85ee, 0xffff84f4,
  0xffffffc0, 0xfffffe00, 0xfffff060, 0xfffff040,
  0xfffffff4, 0xffffffa0, 0xfffffd12, 0xfffffd0c,
  0xfffffff8, 0xffffffc0, 0xfffffe0c, 0xfffffe08,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xfffffe08, 0xfffff040, 0xffff84f4, 0xffff83f8,
  0xfffffe0c, 0xfffff060, 0xffff85ee, 0xffff84f4,
  0xffffffc0, 0xfffffe00, 0xfffff060, 0xfffff040,
  0xfffffff4, 0xffffffa0, 0xfffffd12, 0xfffffd0c,
  0xfffffff8, 0xffffffc0, 0xfffffe0c, 0xfffffe08,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0xfffffe0c, 0xfffff060, 0xffff85ee, 0xffff84f4,
  0xffffffc0, 0xfffffe00, 0xfffff060, 0xfffff040,
  0xfffffff4, 0xffffffa0, 0xfffffd12, 0xfffffd0c,
  0xfffffff8, 0xffffffc0, 0xfffffe0c, 0xfffffe08,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000008, 0x00000040, 0x000001f4, 0x000001f8,
  0xffffffc0, 0xfffffe00, 0xfffff060, 0xfffff040,
  0xfffffff4, 0xffffffa0, 0xfffffd12, 0xfffffd0c,
  0xfffffff8, 0xffffffc0, 0xfffffe0c, 0xfffffe08,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000008, 0x00000040, 0x000001f4, 0x000001f8,
  0x00000040, 0x00000200, 0x00000fa0, 0x00000fc0,
  0xfffffff4, 0xffffffa0, 0xfffffd12, 0xfffffd0c,
  0xfffffff8, 0xffffffc0, 0xfffffe0c, 0xfffffe08,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000008, 0x00000040, 0x000001f4, 0x000001f8,
  0x00000040, 0x00000200, 0x00000fa0, 0x00000fc0,
  0x000001f4, 0x00000fa0, 0x00007a12, 0x00007b0c,
  0xfffffff8, 0xffffffc0, 0xfffffe0c, 0xfffffe08,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000008, 0x00000040, 0x000001f4, 0x000001f8,
  0x00000040, 0x00000200, 0x00000fa0, 0x00000fc0,
  0x000001f4, 0x00000fa0, 0x00007a12, 0x00007b0c,
  0x000001f8, 0x00000fc0, 0x00007b0c, 0x00007c08,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000008, 0x00000040, 0x000001f4, 0x000001f8,
  0x00000040, 0x00000200, 0x00000fa0, 0x00000fc0,
  0x000001f4, 0x00000fa0, 0x00007a12, 0x00007b0c,
  0x000001f8, 0x00000fc0, 0x00007b0c, 0x00007c08,
  0x000001fc, 0x00000fe0, 0x00007c06, 0x00007d04,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000008, 0x00000040, 0x000001f4, 0x000001f8,
  0x00000040, 0x00000200, 0x00000fa0, 0x00000fc0,
  0x000001f4, 0x00000fa0, 0x00007a12, 0x00007b0c,
  0x000001f8, 0x00000fc0, 0x00007b0c, 0x00007c08,
  0x000001fc, 0x00000fe0, 0x00007c06, 0x00007d04,
  0x0000cccc, 0x00066660, 0x0031ffce, 0x00326634,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000008, 0x00000040, 0x000001f4, 0x000001f8,
  0x00000040, 0x00000200, 0x00000fa0, 0x00000fc0,
  0x000001f4, 0x00000fa0, 0x00007a12, 0x00007b0c,
  0x000001f8, 0x00000fc0, 0x00007b0c, 0x00007c08,
  0x000001fc, 0x00000fe0, 0x00007c06, 0x00007d04,
  0x0000cccc, 0x00066660, 0x0031ffce, 0x00326634,
  0x00015554, 0x000aaaa0, 0x00535502, 0x0053ffac,
  0x00000008, 0x00000040, 0x000001f4, 0x000001f8,
  0x00000040, 0x00000200, 0x00000fa0, 0x00000fc0,
  0x000001f4, 0x00000fa0, 0x00007a12, 0x00007b0c,
  0x000001f8, 0x00000fc0, 0x00007b0c, 0x00007c08,
  0x000001fc, 0x00000fe0, 0x00007c06, 0x00007d04,
  0x0000cccc, 0x00066660, 0x0031ffce, 0x00326634,
  0x00015554, 0x000aaaa0, 0x00535502, 0x0053ffac,
  0x0001fff4, 0x000fffa0, 0x007cfd12, 0x007dfd0c,
  0x00000040, 0x00000200, 0x00000fa0, 0x00000fc0,
  0x000001f4, 0x00000fa0, 0x00007a12, 0x00007b0c,
  0x000001f8, 0x00000fc0, 0x00007b0c, 0x00007c08,
  0x000001fc, 0x00000fe0, 0x00007c06, 0x00007d04,
  0x0000cccc, 0x00066660, 0x0031ffce, 0x00326634,
  0x00015554, 0x000aaaa0, 0x00535502, 0x0053ffac,
  0x0001fff4, 0x000fffa0, 0x007cfd12, 0x007dfd0c,
  0x0001fff8, 0x000fffc0, 0x007cfe0c, 0x007dfe08,
  0x000001f4, 0x00000fa0, 0x00007a12, 0x00007b0c,
  0x000001f8, 0x00000fc0, 0x00007b0c, 0x00007c08,
  0x000001fc, 0x00000fe0, 0x00007c06, 0x00007d04,
  0x0000cccc, 0x00066660, 0x0031ffce, 0x00326634,
  0x00015554, 0x000aaaa0, 0x00535502, 0x0053ffac,
  0x0001fff4, 0x000fffa0, 0x007cfd12, 0x007dfd0c,
  0x0001fff8, 0x000fffc0, 0x007cfe0c, 0x007dfe08,
  0x0001fffc, 0x000fffe0, 0x007cff06, 0x007dff04,
  0x000001f8, 0x00000fc0, 0x00007b0c, 0x00007c08,
  0x000001fc, 0x00000fe0, 0x00007c06, 0x00007d04,
  0x0000cccc, 0x00066660, 0x0031ffce, 0x00326634,
  0x00015554, 0x000aaaa0, 0x00535502, 0x0053ffac,
  0x0001fff4, 0x000fffa0, 0x007cfd12, 0x007dfd0c,
  0x0001fff8, 0x000fffc0, 0x007cfe0c, 0x007dfe08,
  0x0001fffc, 0x000fffe0, 0x007cff06, 0x007dff04,
  0xfffe0000, 0xfff00000, 0xff830000, 0xff820000,
  0x000001fc, 0x00000fe0, 0x00007c06, 0x00007d04,
  0x0000cccc, 0x00066660, 0x0031ffce, 0x00326634,
  0x00015554, 0x000aaaa0, 0x00535502, 0x0053ffac,
  0x0001fff4, 0x000fffa0, 0x007cfd12, 0x007dfd0c,
  0x0001fff8, 0x000fffc0, 0x007cfe0c, 0x007dfe08,
  0x0001fffc, 0x000fffe0, 0x007cff06, 0x007dff04,
  0xfffe0000, 0xfff00000, 0xff830000, 0xff820000,
  0xfffe0004, 0xfff00020, 0xff8300fa, 0xff8200fc,
  0x0000cccc, 0x00066660, 0x0031ffce, 0x00326634,
  0x00015554, 0x000aaaa0, 0x00535502, 0x0053ffac,
  0x0001fff4, 0x000fffa0, 0x007cfd12, 0x007dfd0c,
  0x0001fff8, 0x000fffc0, 0x007cfe0c, 0x007dfe08,
  0x0001fffc, 0x000fffe0, 0x007cff06, 0x007dff04,
  0xfffe0000, 0xfff00000, 0xff830000, 0xff820000,
  0xfffe0004, 0xfff00020, 0xff8300fa, 0xff8200fc,
  0xfffeaaa8, 0xfff55540, 0xffacaa04, 0xffabff58,
  0x00015554, 0x000aaaa0, 0x00535502, 0x0053ffac,
  0x0001fff4, 0x000fffa0, 0x007cfd12, 0x007dfd0c,
  0x0001fff8, 0x000fffc0, 0x007cfe0c, 0x007dfe08,
  0x0001fffc, 0x000fffe0, 0x007cff06, 0x007dff04,
  0xfffe0000, 0xfff00000, 0xff830000, 0xff820000,
  0xfffe0004, 0xfff00020, 0xff8300fa, 0xff8200fc,
  0xfffeaaa8, 0xfff55540, 0xffacaa04, 0xffabff58,
  0xffff3330, 0xfff99980, 0xffcdff38, 0xffcd98d0,
  0x0001fff4, 0x000fffa0, 0x007cfd12, 0x007dfd0c,
  0x0001fff8, 0x000fffc0, 0x007cfe0c, 0x007dfe08,
  0x0001fffc, 0x000fffe0, 0x007cff06, 0x007dff04,
  0xfffe0000, 0xfff00000, 0xff830000, 0xff820000,
  0xfffe0004, 0xfff00020, 0xff8300fa, 0xff8200fc,
  0xfffeaaa8, 0xfff55540, 0xffacaa04, 0xffabff58,
  0xffff3330, 0xfff99980, 0xffcdff38, 0xffcd98d0,
  0xfffffe00, 0xfffff000, 0xffff8300, 0xffff8200,
  0x0001fff8, 0x000fffc0, 0x007cfe0c, 0x007dfe08,
  0x0001fffc, 0x000fffe0, 0x007cff06, 0x007dff04,
  0xfffe0000, 0xfff00000, 0xff830000, 0xff820000,
  0xfffe0004, 0xfff00020, 0xff8300fa, 0xff8200fc,
  0xfffeaaa8, 0xfff55540, 0xffacaa04, 0xffabff58,
  0xffff3330, 0xfff99980, 0xffcdff38, 0xffcd98d0,
  0xfffffe00, 0xfffff000, 0xffff8300, 0xffff8200,
  0xfffffe04, 0xfffff020, 0xffff83fa, 0xffff82fc,
  0x0001fffc, 0x000fffe0, 0x007cff06, 0x007dff04,
  0xfffe0000, 0xfff00000, 0xff830000, 0xff820000,
  0xfffe0004, 0xfff00020, 0xff8300fa, 0xff8200fc,
  0xfffeaaa8, 0xfff55540, 0xffacaa04, 0xffabff58,
  0xffff3330, 0xfff99980, 0xffcdff38, 0xffcd98d0,
  0xfffffe00, 0xfffff000, 0xffff8300, 0xffff8200,
  0xfffffe04, 0xfffff020, 0xffff83fa, 0xffff82fc,
  0xfffffe08, 0xfffff040, 0xffff84f4, 0xffff83f8,
  0xfffe0000, 0xfff00000, 0xff830000, 0xff820000,
  0xfffe0004, 0xfff00020, 0xff8300fa, 0xff8200fc,
  0xfffeaaa8, 0xfff55540, 0xffacaa04, 0xffabff58,
  0xffff3330, 0xfff99980, 0xffcdff38, 0xffcd98d0,
  0xfffffe00, 0xfffff000, 0xffff8300, 0xffff8200,
  0xfffffe04, 0xfffff020, 0xffff83fa, 0xffff82fc,
  0xfffffe08, 0xfffff040, 0xffff84f4, 0xffff83f8,
  0xfffffe0c, 0xfffff060, 0xffff85ee, 0xffff84f4,
  0xfffe0004, 0xfff00020, 0xff8300fa, 0xff8200fc,
  0xfffeaaa8, 0xfff55540, 0xffacaa04, 0xffabff58,
  0xffff3330, 0xfff99980, 0xffcdff38, 0xffcd98d0,
  0xfffffe00, 0xfffff000, 0xffff8300, 0xffff8200,
  0xfffffe04, 0xfffff020, 0xffff83fa, 0xffff82fc,
  0xfffffe08, 0xfffff040, 0xffff84f4, 0xffff83f8,
  0xfffffe0c, 0xfffff060, 0xffff85ee, 0xffff84f4,
  0xffffffc0, 0xfffffe00, 0xfffff060, 0xfffff040,
  0xfffeaaa8, 0xfff55540, 0xffacaa04, 0xffabff58,
  0xffff3330, 0xfff99980, 0xffcdff38, 0xffcd98d0,
  0xfffffe00, 0xfffff000, 0xffff8300, 0xffff8200,
  0xfffffe04, 0xfffff020, 0xffff83fa, 0xffff82fc,
  0xfffffe08, 0xfffff040, 0xffff84f4, 0xffff83f8,
  0xfffffe0c, 0xfffff060, 0xffff85ee, 0xffff84f4,
  0xffffffc0, 0xfffffe00, 0xfffff060, 0xfffff040,
  0xfffffff4, 0xffffffa0, 0xfffffd12, 0xfffffd0c,
  0xffff3330, 0xfff99980, 0xffcdff38, 0xffcd98d0,
  0xfffffe00, 0xfffff000, 0xffff8300, 0xffff8200,
  0xfffffe04, 0xfffff020, 0xffff83fa, 0xffff82fc,
  0xfffffe08, 0xfffff040, 0xffff84f4, 0xffff83f8,
  0xfffffe0c, 0xfffff060, 0xffff85ee, 0xffff84f4,
  0xffffffc0, 0xfffffe00, 0xfffff060, 0xfffff040,
  0xfffffff4, 0xffffffa0, 0xfffffd12, 0xfffffd0c,
  0xfffffff8, 0xffffffc0, 0xfffffe0c, 0xfffffe08,
  0xfffffe00, 0xfffff000, 0xffff8300, 0xffff8200,
  0xfffffe04, 0xfffff020, 0xffff83fa, 0xffff82fc,
  0xfffffe08, 0xfffff040, 0xffff84f4, 0xffff83f8,
  0xfffffe0c, 0xfffff060, 0xffff85ee, 0xffff84f4,
  0xffffffc0, 0xfffffe00, 0xfffff060, 0xfffff040,
  0xfffffff4, 0xffffffa0, 0xfffffd12, 0xfffffd0c,
  0xfffffff8, 0xffffffc0, 0xfffffe0c, 0xfffffe08,
  0xfffffffc, 0xffffffe0, 0xffffff06, 0xffffff04,
  0xfffff020, 0xffff83fa, 0xffff82fc, 0xffff81fe,
  0xfffff040, 0xffff84f4, 0xffff83f8, 0xffff82fc,
  0xfffff060, 0xffff85ee, 0xffff84f4, 0xffff83fa,
  0xfffffe00, 0xfffff060, 0xfffff040, 0xfffff020,
  0xffffffa0, 0xfffffd12, 0xfffffd0c, 0xfffffd06,
  0xffffffc0, 0xfffffe0c, 0xfffffe08, 0xfffffe04,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xfffff040, 0xffff84f4, 0xffff83f8, 0xffff82fc,
  0xfffff060, 0xffff85ee, 0xffff84f4, 0xffff83fa,
  0xfffffe00, 0xfffff060, 0xfffff040, 0xfffff020,
  0xffffffa0, 0xfffffd12, 0xfffffd0c, 0xfffffd06,
  0xffffffc0, 0xfffffe0c, 0xfffffe08, 0xfffffe04,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0xfffff060, 0xffff85ee, 0xffff84f4, 0xffff83fa,
  0xfffffe00, 0xfffff060, 0xfffff040, 0xfffff020,
  0xffffffa0, 0xfffffd12, 0xfffffd0c, 0xfffffd06,
  0xffffffc0, 0xfffffe0c, 0xfffffe08, 0xfffffe04,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x00000040, 0x000001f4, 0x000001f8, 0x000001fc,
  0xfffffe00, 0xfffff060, 0xfffff040, 0xfffff020,
  0xffffffa0, 0xfffffd12, 0xfffffd0c, 0xfffffd06,
  0xffffffc0, 0xfffffe0c, 0xfffffe08, 0xfffffe04,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x00000040, 0x000001f4, 0x000001f8, 0x000001fc,
  0x00000200, 0x00000fa0, 0x00000fc0, 0x00000fe0,
  0xffffffa0, 0xfffffd12, 0xfffffd0c, 0xfffffd06,
  0xffffffc0, 0xfffffe0c, 0xfffffe08, 0xfffffe04,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x00000040, 0x000001f4, 0x000001f8, 0x000001fc,
  0x00000200, 0x00000fa0, 0x00000fc0, 0x00000fe0,
  0x00000fa0, 0x00007a12, 0x00007b0c, 0x00007c06,
  0xffffffc0, 0xfffffe0c, 0xfffffe08, 0xfffffe04,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x00000040, 0x000001f4, 0x000001f8, 0x000001fc,
  0x00000200, 0x00000fa0, 0x00000fc0, 0x00000fe0,
  0x00000fa0, 0x00007a12, 0x00007b0c, 0x00007c06,
  0x00000fc0, 0x00007b0c, 0x00007c08, 0x00007d04,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x00000040, 0x000001f4, 0x000001f8, 0x000001fc,
  0x00000200, 0x00000fa0, 0x00000fc0, 0x00000fe0,
  0x00000fa0, 0x00007a12, 0x00007b0c, 0x00007c06,
  0x00000fc0, 0x00007b0c, 0x00007c08, 0x00007d04,
  0x00000fe0, 0x00007c06, 0x00007d04, 0x00007e02,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x00000040, 0x000001f4, 0x000001f8, 0x000001fc,
  0x00000200, 0x00000fa0, 0x00000fc0, 0x00000fe0,
  0x00000fa0, 0x00007a12, 0x00007b0c, 0x00007c06,
  0x00000fc0, 0x00007b0c, 0x00007c08, 0x00007d04,
  0x00000fe0, 0x00007c06, 0x00007d04, 0x00007e02,
  0x00066660, 0x0031ffce, 0x00326634, 0x0032cc9a,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x00000040, 0x000001f4, 0x000001f8, 0x000001fc,
  0x00000200, 0x00000fa0, 0x00000fc0, 0x00000fe0,
  0x00000fa0, 0x00007a12, 0x00007b0c, 0x00007c06,
  0x00000fc0, 0x00007b0c, 0x00007c08, 0x00007d04,
  0x00000fe0, 0x00007c06, 0x00007d04, 0x00007e02,
  0x00066660, 0x0031ffce, 0x00326634, 0x0032cc9a,
  0x000aaaa0, 0x00535502, 0x0053ffac, 0x0054aa56,
  0x00000040, 0x000001f4, 0x000001f8, 0x000001fc,
  0x00000200, 0x00000fa0, 0x00000fc0, 0x00000fe0,
  0x00000fa0, 0x00007a12, 0x00007b0c, 0x00007c06,
  0x00000fc0, 0x00007b0c, 0x00007c08, 0x00007d04,
  0x00000fe0, 0x00007c06, 0x00007d04, 0x00007e02,
  0x00066660, 0x0031ffce, 0x00326634, 0x0032cc9a,
  0x000aaaa0, 0x00535502, 0x0053ffac, 0x0054aa56,
  0x000fffa0, 0x007cfd12, 0x007dfd0c, 0x007efd06,
  0x00000200, 0x00000fa0, 0x00000fc0, 0x00000fe0,
  0x00000fa0, 0x00007a12, 0x00007b0c, 0x00007c06,
  0x00000fc0, 0x00007b0c, 0x00007c08, 0x00007d04,
  0x00000fe0, 0x00007c06, 0x00007d04, 0x00007e02,
  0x00066660, 0x0031ffce, 0x00326634, 0x0032cc9a,
  0x000aaaa0, 0x00535502, 0x0053ffac, 0x0054aa56,
  0x000fffa0, 0x007cfd12, 0x007dfd0c, 0x007efd06,
  0x000fffc0, 0x007cfe0c, 0x007dfe08, 0x007efe04,
  0x00000fa0, 0x00007a12, 0x00007b0c, 0x00007c06,
  0x00000fc0, 0x00007b0c, 0x00007c08, 0x00007d04,
  0x00000fe0, 0x00007c06, 0x00007d04, 0x00007e02,
  0x00066660, 0x0031ffce, 0x00326634, 0x0032cc9a,
  0x000aaaa0, 0x00535502, 0x0053ffac, 0x0054aa56,
  0x000fffa0, 0x007cfd12, 0x007dfd0c, 0x007efd06,
  0x000fffc0, 0x007cfe0c, 0x007dfe08, 0x007efe04,
  0x000fffe0, 0x007cff06, 0x007dff04, 0x007eff02,
  0x00000fc0, 0x00007b0c, 0x00007c08, 0x00007d04,
  0x00000fe0, 0x00007c06, 0x00007d04, 0x00007e02,
  0x00066660, 0x0031ffce, 0x00326634, 0x0032cc9a,
  0x000aaaa0, 0x00535502, 0x0053ffac, 0x0054aa56,
  0x000fffa0, 0x007cfd12, 0x007dfd0c, 0x007efd06,
  0x000fffc0, 0x007cfe0c, 0x007dfe08, 0x007efe04,
  0x000fffe0, 0x007cff06, 0x007dff04, 0x007eff02,
  0xfff00000, 0xff830000, 0xff820000, 0xff810000,
  0x00000fe0, 0x00007c06, 0x00007d04, 0x00007e02,
  0x00066660, 0x0031ffce, 0x00326634, 0x0032cc9a,
  0x000aaaa0, 0x00535502, 0x0053ffac, 0x0054aa56,
  0x000fffa0, 0x007cfd12, 0x007dfd0c, 0x007efd06,
  0x000fffc0, 0x007cfe0c, 0x007dfe08, 0x007efe04,
  0x000fffe0, 0x007cff06, 0x007dff04, 0x007eff02,
  0xfff00000, 0xff830000, 0xff820000, 0xff810000,
  0xfff00020, 0xff8300fa, 0xff8200fc, 0xff8100fe,
  0x00066660, 0x0031ffce, 0x00326634, 0x0032cc9a,
  0x000aaaa0, 0x00535502, 0x0053ffac, 0x0054aa56,
  0x000fffa0, 0x007cfd12, 0x007dfd0c, 0x007efd06,
  0x000fffc0, 0x007cfe0c, 0x007dfe08, 0x007efe04,
  0x000fffe0, 0x007cff06, 0x007dff04, 0x007eff02,
  0xfff00000, 0xff830000, 0xff820000, 0xff810000,
  0xfff00020, 0xff8300fa, 0xff8200fc, 0xff8100fe,
  0xfff55540, 0xffacaa04, 0xffabff58, 0xffab54ac,
  0x000aaaa0, 0x00535502, 0x0053ffac, 0x0054aa56,
  0x000fffa0, 0x007cfd12, 0x007dfd0c, 0x007efd06,
  0x000fffc0, 0x007cfe0c, 0x007dfe08, 0x007efe04,
  0x000fffe0, 0x007cff06, 0x007dff04, 0x007eff02,
  0xfff00000, 0xff830000, 0xff820000, 0xff810000,
  0xfff00020, 0xff8300fa, 0xff8200fc, 0xff8100fe,
  0xfff55540, 0xffacaa04, 0xffabff58, 0xffab54ac,
  0xfff99980, 0xffcdff38, 0xffcd98d0, 0xffcd3268,
  0x000fffa0, 0x007cfd12, 0x007dfd0c, 0x007efd06,
  0x000fffc0, 0x007cfe0c, 0x007dfe08, 0x007efe04,
  0x000fffe0, 0x007cff06, 0x007dff04, 0x007eff02,
  0xfff00000, 0xff830000, 0xff820000, 0xff810000,
  0xfff00020, 0xff8300fa, 0xff8200fc, 0xff8100fe,
  0xfff55540, 0xffacaa04, 0xffabff58, 0xffab54ac,
  0xfff99980, 0xffcdff38, 0xffcd98d0, 0xffcd3268,
  0xfffff000, 0xffff8300, 0xffff8200, 0xffff8100,
  0x000fffc0, 0x007cfe0c, 0x007dfe08, 0x007efe04,
  0x000fffe0, 0x007cff06, 0x007dff04, 0x007eff02,
  0xfff00000, 0xff830000, 0xff820000, 0xff810000,
  0xfff00020, 0xff8300fa, 0xff8200fc, 0xff8100fe,
  0xfff55540, 0xffacaa04, 0xffabff58, 0xffab54ac,
  0xfff99980, 0xffcdff38, 0xffcd98d0, 0xffcd3268,
  0xfffff000, 0xffff8300, 0xffff8200, 0xffff8100,
  0xfffff020, 0xffff83fa, 0xffff82fc, 0xffff81fe,
  0x000fffe0, 0x007cff06, 0x007dff04, 0x007eff02,
  0xfff00000, 0xff830000, 0xff820000, 0xff810000,
  0xfff00020, 0xff8300fa, 0xff8200fc, 0xff8100fe,
  0xfff55540, 0xffacaa04, 0xffabff58, 0xffab54ac,
  0xfff99980, 0xffcdff38, 0xffcd98d0, 0xffcd3268,
  0xfffff000, 0xffff8300, 0xffff8200, 0xffff8100,
  0xfffff020, 0xffff83fa, 0xffff82fc, 0xffff81fe,
  0xfffff040, 0xffff84f4, 0xffff83f8, 0xffff82fc,
  0xfff00000, 0xff830000, 0xff820000, 0xff810000,
  0xfff00020, 0xff8300fa, 0xff8200fc, 0xff8100fe,
  0xfff55540, 0xffacaa04, 0xffabff58, 0xffab54ac,
  0xfff99980, 0xffcdff38, 0xffcd98d0, 0xffcd3268,
  0xfffff000, 0xffff8300, 0xffff8200, 0xffff8100,
  0xfffff020, 0xffff83fa, 0xffff82fc, 0xffff81fe,
  0xfffff040, 0xffff84f4, 0xffff83f8, 0xffff82fc,
  0xfffff060, 0xffff85ee, 0xffff84f4, 0xffff83fa,
  0xfff00020, 0xff8300fa, 0xff8200fc, 0xff8100fe,
  0xfff55540, 0xffacaa04, 0xffabff58, 0xffab54ac,
  0xfff99980, 0xffcdff38, 0xffcd98d0, 0xffcd3268,
  0xfffff000, 0xffff8300, 0xffff8200, 0xffff8100,
  0xfffff020, 0xffff83fa, 0xffff82fc, 0xffff81fe,
  0xfffff040, 0xffff84f4, 0xffff83f8, 0xffff82fc,
  0xfffff060, 0xffff85ee, 0xffff84f4, 0xffff83fa,
  0xfffffe00, 0xfffff060, 0xfffff040, 0xfffff020,
  0xfff55540, 0xffacaa04, 0xffabff58, 0xffab54ac,
  0xfff99980, 0xffcdff38, 0xffcd98d0, 0xffcd3268,
  0xfffff000, 0xffff8300, 0xffff8200, 0xffff8100,
  0xfffff020, 0xffff83fa, 0xffff82fc, 0xffff81fe,
  0xfffff040, 0xffff84f4, 0xffff83f8, 0xffff82fc,
  0xfffff060, 0xffff85ee, 0xffff84f4, 0xffff83fa,
  0xfffffe00, 0xfffff060, 0xfffff040, 0xfffff020,
  0xffffffa0, 0xfffffd12, 0xfffffd0c, 0xfffffd06,
  0xfff99980, 0xffcdff38, 0xffcd98d0, 0xffcd3268,
  0xfffff000, 0xffff8300, 0xffff8200, 0xffff8100,
  0xfffff020, 0xffff83fa, 0xffff82fc, 0xffff81fe,
  0xfffff040, 0xffff84f4, 0xffff83f8, 0xffff82fc,
  0xfffff060, 0xffff85ee, 0xffff84f4, 0xffff83fa,
  0xfffffe00, 0xfffff060, 0xfffff040, 0xfffff020,
  0xffffffa0, 0xfffffd12, 0xfffffd0c, 0xfffffd06,
  0xffffffc0, 0xfffffe0c, 0xfffffe08, 0xfffffe04,
  0xfffff000, 0xffff8300, 0xffff8200, 0xffff8100,
  0xfffff020, 0xffff83fa, 0xffff82fc, 0xffff81fe,
  0xfffff040, 0xffff84f4, 0xffff83f8, 0xffff82fc,
  0xfffff060, 0xffff85ee, 0xffff84f4, 0xffff83fa,
  0xfffffe00, 0xfffff060, 0xfffff040, 0xfffff020,
  0xffffffa0, 0xfffffd12, 0xfffffd0c, 0xfffffd06,
  0xffffffc0, 0xfffffe0c, 0xfffffe08, 0xfffffe04,
  0xffffffe0, 0xffffff06, 0xffffff04, 0xffffff02,
  0xffff83fa, 0xffff82fc, 0xffff81fe, 0xffcd3366,
  0xffff84f4, 0xffff83f8, 0xffff82fc, 0xffcd99cc,
  0xffff85ee, 0xffff84f4, 0xffff83fa, 0xffce0032,
  0xfffff060, 0xfffff040, 0xfffff020, 0xfff999a0,
  0xfffffd12, 0xfffffd0c, 0xfffffd06, 0xfffeccce,
  0xfffffe0c, 0xfffffe08, 0xfffffe04, 0xffff3334,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff84f4, 0xffff83f8, 0xffff82fc, 0xffcd99cc,
  0xffff85ee, 0xffff84f4, 0xffff83fa, 0xffce0032,
  0xfffff060, 0xfffff040, 0xfffff020, 0xfff999a0,
  0xfffffd12, 0xfffffd0c, 0xfffffd06, 0xfffeccce,
  0xfffffe0c, 0xfffffe08, 0xfffffe04, 0xffff3334,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0xffff85ee, 0xffff84f4, 0xffff83fa, 0xffce0032,
  0xfffff060, 0xfffff040, 0xfffff020, 0xfff999a0,
  0xfffffd12, 0xfffffd0c, 0xfffffd06, 0xfffeccce,
  0xfffffe0c, 0xfffffe08, 0xfffffe04, 0xffff3334,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000001f4, 0x000001f8, 0x000001fc, 0x0000cccc,
  0xfffff060, 0xfffff040, 0xfffff020, 0xfff999a0,
  0xfffffd12, 0xfffffd0c, 0xfffffd06, 0xfffeccce,
  0xfffffe0c, 0xfffffe08, 0xfffffe04, 0xffff3334,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000001f4, 0x000001f8, 0x000001fc, 0x0000cccc,
  0x00000fa0, 0x00000fc0, 0x00000fe0, 0x00066660,
  0xfffffd12, 0xfffffd0c, 0xfffffd06, 0xfffeccce,
  0xfffffe0c, 0xfffffe08, 0xfffffe04, 0xffff3334,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000001f4, 0x000001f8, 0x000001fc, 0x0000cccc,
  0x00000fa0, 0x00000fc0, 0x00000fe0, 0x00066660,
  0x00007a12, 0x00007b0c, 0x00007c06, 0x0031ffce,
  0xfffffe0c, 0xfffffe08, 0xfffffe04, 0xffff3334,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000001f4, 0x000001f8, 0x000001fc, 0x0000cccc,
  0x00000fa0, 0x00000fc0, 0x00000fe0, 0x00066660,
  0x00007a12, 0x00007b0c, 0x00007c06, 0x0031ffce,
  0x00007b0c, 0x00007c08, 0x00007d04, 0x00326634,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000001f4, 0x000001f8, 0x000001fc, 0x0000cccc,
  0x00000fa0, 0x00000fc0, 0x00000fe0, 0x00066660,
  0x00007a12, 0x00007b0c, 0x00007c06, 0x0031ffce,
  0x00007b0c, 0x00007c08, 0x00007d04, 0x00326634,
  0x00007c06, 0x00007d04, 0x00007e02, 0x0032cc9a,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000001f4, 0x000001f8, 0x000001fc, 0x0000cccc,
  0x00000fa0, 0x00000fc0, 0x00000fe0, 0x00066660,
  0x00007a12, 0x00007b0c, 0x00007c06, 0x0031ffce,
  0x00007b0c, 0x00007c08, 0x00007d04, 0x00326634,
  0x00007c06, 0x00007d04, 0x00007e02, 0x0032cc9a,
  0x0031ffce, 0x00326634, 0x0032cc9a, 0x147ab852,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000001f4, 0x000001f8, 0x000001fc, 0x0000cccc,
  0x00000fa0, 0x00000fc0, 0x00000fe0, 0x00066660,
  0x00007a12, 0x00007b0c, 0x00007c06, 0x0031ffce,
  0x00007b0c, 0x00007c08, 0x00007d04, 0x00326634,
  0x00007c06, 0x00007d04, 0x00007e02, 0x0032cc9a,
  0x0031ffce, 0x00326634, 0x0032cc9a, 0x147ab852,
  0x00535502, 0x0053ffac, 0x0054aa56, 0x2221ddde,
  0x000001f4, 0x000001f8, 0x000001fc, 0x0000cccc,
  0x00000fa0, 0x00000fc0, 0x00000fe0, 0x00066660,
  0x00007a12, 0x00007b0c, 0x00007c06, 0x0031ffce,
  0x00007b0c, 0x00007c08, 0x00007d04, 0x00326634,
  0x00007c06, 0x00007d04, 0x00007e02, 0x0032cc9a,
  0x0031ffce, 0x00326634, 0x0032cc9a, 0x147ab852,
  0x00535502, 0x0053ffac, 0x0054aa56, 0x2221ddde,
  0x007cfd12, 0x007dfd0c, 0x007efd06, 0x3331ccce,
  0x00000fa0, 0x00000fc0, 0x00000fe0, 0x00066660,
  0x00007a12, 0x00007b0c, 0x00007c06, 0x0031ffce,
  0x00007b0c, 0x00007c08, 0x00007d04, 0x00326634,
  0x00007c06, 0x00007d04, 0x00007e02, 0x0032cc9a,
  0x0031ffce, 0x00326634, 0x0032cc9a, 0x147ab852,
  0x00535502, 0x0053ffac, 0x0054aa56, 0x2221ddde,
  0x007cfd12, 0x007dfd0c, 0x007efd06, 0x3331ccce,
  0x007cfe0c, 0x007dfe08, 0x007efe04, 0x33323334,
  0x00007a12, 0x00007b0c, 0x00007c06, 0x0031ffce,
  0x00007b0c, 0x00007c08, 0x00007d04, 0x00326634,
  0x00007c06, 0x00007d04, 0x00007e02, 0x0032cc9a,
  0x0031ffce, 0x00326634, 0x0032cc9a, 0x147ab852,
  0x00535502, 0x0053ffac, 0x0054aa56, 0x2221ddde,
  0x007cfd12, 0x007dfd0c, 0x007efd06, 0x3331ccce,
  0x007cfe0c, 0x007dfe08, 0x007efe04, 0x33323334,
  0x007cff06, 0x007dff04, 0x007eff02, 0x3332999a,
  0x00007b0c, 0x00007c08, 0x00007d04, 0x00326634,
  0x00007c06, 0x00007d04, 0x00007e02, 0x0032cc9a,
  0x0031ffce, 0x00326634, 0x0032cc9a, 0x147ab852,
  0x00535502, 0x0053ffac, 0x0054aa56, 0x2221ddde,
  0x007cfd12, 0x007dfd0c, 0x007efd06, 0x3331ccce,
  0x007cfe0c, 0x007dfe08, 0x007efe04, 0x33323334,
  0x007cff06, 0x007dff04, 0x007eff02, 0x3332999a,
  0xff830000, 0xff820000, 0xff810000, 0xcccd0000,
  0x00007c06, 0x00007d04, 0x00007e02, 0x0032cc9a,
  0x0031ffce, 0x00326634, 0x0032cc9a, 0x147ab852,
  0x00535502, 0x0053ffac, 0x0054aa56, 0x2221ddde,
  0x007cfd12, 0x007dfd0c, 0x007efd06, 0x3331ccce,
  0x007cfe0c, 0x007dfe08, 0x007efe04, 0x33323334,
  0x007cff06, 0x007dff04, 0x007eff02, 0x3332999a,
  0xff830000, 0xff820000, 0xff810000, 0xcccd0000,
  0xff8300fa, 0xff8200fc, 0xff8100fe, 0xcccd6666,
  0x0031ffce, 0x00326634, 0x0032cc9a, 0x147ab852,
  0x00535502, 0x0053ffac, 0x0054aa56, 0x2221ddde,
  0x007cfd12, 0x007dfd0c, 0x007efd06, 0x3331ccce,
  0x007cfe0c, 0x007dfe08, 0x007efe04, 0x33323334,
  0x007cff06, 0x007dff04, 0x007eff02, 0x3332999a,
  0xff830000, 0xff820000, 0xff810000, 0xcccd0000,
  0xff8300fa, 0xff8200fc, 0xff8100fe, 0xcccd6666,
  0xffacaa04, 0xffabff58, 0xffab54ac, 0xddddbbbc,
  0x00535502, 0x0053ffac, 0x0054aa56, 0x2221ddde,
  0x007cfd12, 0x007dfd0c, 0x007efd06, 0x3331ccce,
  0x007cfe0c, 0x007dfe08, 0x007efe04, 0x33323334,
  0x007cff06, 0x007dff04, 0x007eff02, 0x3332999a,
  0xff830000, 0xff820000, 0xff810000, 0xcccd0000,
  0xff8300fa, 0xff8200fc, 0xff8100fe, 0xcccd6666,
  0xffacaa04, 0xffabff58, 0xffab54ac, 0xddddbbbc,
  0xffcdff38, 0xffcd98d0, 0xffcd3268, 0xeb84e148,
  0x007cfd12, 0x007dfd0c, 0x007efd06, 0x3331ccce,
  0x007cfe0c, 0x007dfe08, 0x007efe04, 0x33323334,
  0x007cff06, 0x007dff04, 0x007eff02, 0x3332999a,
  0xff830000, 0xff820000, 0xff810000, 0xcccd0000,
  0xff8300fa, 0xff8200fc, 0xff8100fe, 0xcccd6666,
  0xffacaa04, 0xffabff58, 0xffab54ac, 0xddddbbbc,
  0xffcdff38, 0xffcd98d0, 0xffcd3268, 0xeb84e148,
  0xffff8300, 0xffff8200, 0xffff8100, 0xffcccd00,
  0x007cfe0c, 0x007dfe08, 0x007efe04, 0x33323334,
  0x007cff06, 0x007dff04, 0x007eff02, 0x3332999a,
  0xff830000, 0xff820000, 0xff810000, 0xcccd0000,
  0xff8300fa, 0xff8200fc, 0xff8100fe, 0xcccd6666,
  0xffacaa04, 0xffabff58, 0xffab54ac, 0xddddbbbc,
  0xffcdff38, 0xffcd98d0, 0xffcd3268, 0xeb84e148,
  0xffff8300, 0xffff8200, 0xffff8100, 0xffcccd00,
  0xffff83fa, 0xffff82fc, 0xffff81fe, 0xffcd3366,
  0x007cff06, 0x007dff04, 0x007eff02, 0x3332999a,
  0xff830000, 0xff820000, 0xff810000, 0xcccd0000,
  0xff8300fa, 0xff8200fc, 0xff8100fe, 0xcccd6666,
  0xffacaa04, 0xffabff58, 0xffab54ac, 0xddddbbbc,
  0xffcdff38, 0xffcd98d0, 0xffcd3268, 0xeb84e148,
  0xffff8300, 0xffff8200, 0xffff8100, 0xffcccd00,
  0xffff83fa, 0xffff82fc, 0xffff81fe, 0xffcd3366,
  0xffff84f4, 0xffff83f8, 0xffff82fc, 0xffcd99cc,
  0xff830000, 0xff820000, 0xff810000, 0xcccd0000,
  0xff8300fa, 0xff8200fc, 0xff8100fe, 0xcccd6666,
  0xffacaa04, 0xffabff58, 0xffab54ac, 0xddddbbbc,
  0xffcdff38, 0xffcd98d0, 0xffcd3268, 0xeb84e148,
  0xffff8300, 0xffff8200, 0xffff8100, 0xffcccd00,
  0xffff83fa, 0xffff82fc, 0xffff81fe, 0xffcd3366,
  0xffff84f4, 0xffff83f8, 0xffff82fc, 0xffcd99cc,
  0xffff85ee, 0xffff84f4, 0xffff83fa, 0xffce0032,
  0xff8300fa, 0xff8200fc, 0xff8100fe, 0xcccd6666,
  0xffacaa04, 0xffabff58, 0xffab54ac, 0xddddbbbc,
  0xffcdff38, 0xffcd98d0, 0xffcd3268, 0xeb84e148,
  0xffff8300, 0xffff8200, 0xffff8100, 0xffcccd00,
  0xffff83fa, 0xffff82fc, 0xffff81fe, 0xffcd3366,
  0xffff84f4, 0xffff83f8, 0xffff82fc, 0xffcd99cc,
  0xffff85ee, 0xffff84f4, 0xffff83fa, 0xffce0032,
  0xfffff060, 0xfffff040, 0xfffff020, 0xfff999a0,
  0xffacaa04, 0xffabff58, 0xffab54ac, 0xddddbbbc,
  0xffcdff38, 0xffcd98d0, 0xffcd3268, 0xeb84e148,
  0xffff8300, 0xffff8200, 0xffff8100, 0xffcccd00,
  0xffff83fa, 0xffff82fc, 0xffff81fe, 0xffcd3366,
  0xffff84f4, 0xffff83f8, 0xffff82fc, 0xffcd99cc,
  0xffff85ee, 0xffff84f4, 0xffff83fa, 0xffce0032,
  0xfffff060, 0xfffff040, 0xfffff020, 0xfff999a0,
  0xfffffd12, 0xfffffd0c, 0xfffffd06, 0xfffeccce,
  0xffcdff38, 0xffcd98d0, 0xffcd3268, 0xeb84e148,
  0xffff8300, 0xffff8200, 0xffff8100, 0xffcccd00,
  0xffff83fa, 0xffff82fc, 0xffff81fe, 0xffcd3366,
  0xffff84f4, 0xffff83f8, 0xffff82fc, 0xffcd99cc,
  0xffff85ee, 0xffff84f4, 0xffff83fa, 0xffce0032,
  0xfffff060, 0xfffff040, 0xfffff020, 0xfff999a0,
  0xfffffd12, 0xfffffd0c, 0xfffffd06, 0xfffeccce,
  0xfffffe0c, 0xfffffe08, 0xfffffe04, 0xffff3334,
  0xffff8300, 0xffff8200, 0xffff8100, 0xffcccd00,
  0xffff83fa, 0xffff82fc, 0xffff81fe, 0xffcd3366,
  0xffff84f4, 0xffff83f8, 0xffff82fc, 0xffcd99cc,
  0xffff85ee, 0xffff84f4, 0xffff83fa, 0xffce0032,
  0xfffff060, 0xfffff040, 0xfffff020, 0xfff999a0,
  0xfffffd12, 0xfffffd0c, 0xfffffd06, 0xfffeccce,
  0xfffffe0c, 0xfffffe08, 0xfffffe04, 0xffff3334,
  0xffffff06, 0xffffff04, 0xffffff02, 0xffff999a,
  0xffff82fc, 0xffff81fe, 0xffcd3366, 0xffab55aa,
  0xffff83f8, 0xffff82fc, 0xffcd99cc, 0xffac0054,
  0xffff84f4, 0xffff83fa, 0xffce0032, 0xffacaafe,
  0xfffff040, 0xfffff020, 0xfff999a0, 0xfff55560,
  0xfffffd0c, 0xfffffd06, 0xfffeccce, 0xfffe0002,
  0xfffffe08, 0xfffffe04, 0xffff3334, 0xfffeaaac,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff83f8, 0xffff82fc, 0xffcd99cc, 0xffac0054,
  0xffff84f4, 0xffff83fa, 0xffce0032, 0xffacaafe,
  0xfffff040, 0xfffff020, 0xfff999a0, 0xfff55560,
  0xfffffd0c, 0xfffffd06, 0xfffeccce, 0xfffe0002,
  0xfffffe08, 0xfffffe04, 0xffff3334, 0xfffeaaac,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0xffff84f4, 0xffff83fa, 0xffce0032, 0xffacaafe,
  0xfffff040, 0xfffff020, 0xfff999a0, 0xfff55560,
  0xfffffd0c, 0xfffffd06, 0xfffeccce, 0xfffe0002,
  0xfffffe08, 0xfffffe04, 0xffff3334, 0xfffeaaac,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0xfffff040, 0xfffff020, 0xfff999a0, 0xfff55560,
  0xfffffd0c, 0xfffffd06, 0xfffeccce, 0xfffe0002,
  0xfffffe08, 0xfffffe04, 0xffff3334, 0xfffeaaac,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0xfffffd0c, 0xfffffd06, 0xfffeccce, 0xfffe0002,
  0xfffffe08, 0xfffffe04, 0xffff3334, 0xfffeaaac,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0xfffffe08, 0xfffffe04, 0xffff3334, 0xfffeaaac,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x000001f8, 0x000001fc, 0x0000cccc, 0x00015554,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x00000fc0, 0x00000fe0, 0x00066660, 0x000aaaa0,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x00007b0c, 0x00007c06, 0x0031ffce, 0x00535502,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0x00007c08, 0x00007d04, 0x00326634, 0x0053ffac,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0x00007d04, 0x00007e02, 0x0032cc9a, 0x0054aa56,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0x00326634, 0x0032cc9a, 0x147ab852, 0x2221ddde,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0x0053ffac, 0x0054aa56, 0x2221ddde, 0x38e31c72,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0x007dfd0c, 0x007efd06, 0x3331ccce, 0x55530002,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0x007dfe08, 0x007efe04, 0x33323334, 0x5553aaac,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0xffff82fc, 0xffff81fe, 0xffcd3366, 0xffab55aa,
  0x007dff04, 0x007eff02, 0x3332999a, 0x55545556,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0xffff82fc, 0xffff81fe, 0xffcd3366, 0xffab55aa,
  0xffff83f8, 0xffff82fc, 0xffcd99cc, 0xffac0054,
  0xff820000, 0xff810000, 0xcccd0000, 0xaaab0000,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0xffff82fc, 0xffff81fe, 0xffcd3366, 0xffab55aa,
  0xffff83f8, 0xffff82fc, 0xffcd99cc, 0xffac0054,
  0xffff84f4, 0xffff83fa, 0xffce0032, 0xffacaafe,
  0xff8200fc, 0xff8100fe, 0xcccd6666, 0xaaabaaaa,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0xffff82fc, 0xffff81fe, 0xffcd3366, 0xffab55aa,
  0xffff83f8, 0xffff82fc, 0xffcd99cc, 0xffac0054,
  0xffff84f4, 0xffff83fa, 0xffce0032, 0xffacaafe,
  0xfffff040, 0xfffff020, 0xfff999a0, 0xfff55560,
  0xffabff58, 0xffab54ac, 0xddddbbbc, 0xc71c38e4,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0xffff82fc, 0xffff81fe, 0xffcd3366, 0xffab55aa,
  0xffff83f8, 0xffff82fc, 0xffcd99cc, 0xffac0054,
  0xffff84f4, 0xffff83fa, 0xffce0032, 0xffacaafe,
  0xfffff040, 0xfffff020, 0xfff999a0, 0xfff55560,
  0xfffffd0c, 0xfffffd06, 0xfffeccce, 0xfffe0002,
  0xffcd98d0, 0xffcd3268, 0xeb84e148, 0xdddd7778,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0xffff82fc, 0xffff81fe, 0xffcd3366, 0xffab55aa,
  0xffff83f8, 0xffff82fc, 0xffcd99cc, 0xffac0054,
  0xffff84f4, 0xffff83fa, 0xffce0032, 0xffacaafe,
  0xfffff040, 0xfffff020, 0xfff999a0, 0xfff55560,
  0xfffffd0c, 0xfffffd06, 0xfffeccce, 0xfffe0002,
  0xfffffe08, 0xfffffe04, 0xffff3334, 0xfffeaaac,
  0xffff8200, 0xffff8100, 0xffcccd00, 0xffaaab00,
  0xffff82fc, 0xffff81fe, 0xffcd3366, 0xffab55aa,
  0xffff83f8, 0xffff82fc, 0xffcd99cc, 0xffac0054,
  0xffff84f4, 0xffff83fa, 0xffce0032, 0xffacaafe,
  0xfffff040, 0xfffff020, 0xfff999a0, 0xfff55560,
  0xfffffd0c, 0xfffffd06, 0xfffeccce, 0xfffe0002,
  0xfffffe08, 0xfffffe04, 0xffff3334, 0xfffeaaac,
  0xffffff04, 0xffffff02, 0xffff999a, 0xffff5556,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x000001fc, 0x0000cccc, 0x00015554, 0x0001fff4,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x00000fe0, 0x00066660, 0x000aaaa0, 0x000fffa0,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x00007c06, 0x0031ffce, 0x00535502, 0x007cfd12,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0x00007d04, 0x00326634, 0x0053ffac, 0x007dfd0c,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0x00007e02, 0x0032cc9a, 0x0054aa56, 0x007efd06,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0x0032cc9a, 0x147ab852, 0x2221ddde, 0x3331ccce,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0x0054aa56, 0x2221ddde, 0x38e31c72, 0x55530002,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0x007efd06, 0x3331ccce, 0x55530002, 0x7ffa0012,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0x007efe04, 0x33323334, 0x5553aaac, 0x7ffb000c,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0x007eff02, 0x3332999a, 0x55545556, 0x7ffc0006,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xff810000, 0xcccd0000, 0xaaab0000, 0x80030000,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xff8100fe, 0xcccd6666, 0xaaabaaaa, 0x8003fffa,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xffab54ac, 0xddddbbbc, 0xc71c38e4, 0xaaac0004,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xffcd3268, 0xeb84e148, 0xdddd7778, 0xcccd3338,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffff8100, 0xffcccd00, 0xffaaab00, 0xff800300,
  0xffff81fe, 0xffcd3366, 0xffab55aa, 0xff8102fa,
  0xffff82fc, 0xffcd99cc, 0xffac0054, 0xff8202f4,
  0xffff83fa, 0xffce0032, 0xffacaafe, 0xff8302ee,
  0xfffff020, 0xfff999a0, 0xfff55560, 0xfff00060,
  0xfffffd06, 0xfffeccce, 0xfffe0002, 0xfffd0012,
  0xfffffe04, 0xffff3334, 0xfffeaaac, 0xfffe000c,
  0xffffff02, 0xffff999a, 0xffff5556, 0xffff0006,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x0000cccc, 0x00015554, 0x0001fff4, 0x0001fff8,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x00066660, 0x000aaaa0, 0x000fffa0, 0x000fffc0,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x0031ffce, 0x00535502, 0x007cfd12, 0x007cfe0c,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0x00326634, 0x0053ffac, 0x007dfd0c, 0x007dfe08,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0x0032cc9a, 0x0054aa56, 0x007efd06, 0x007efe04,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0x147ab852, 0x2221ddde, 0x3331ccce, 0x33323334,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0x2221ddde, 0x38e31c72, 0x55530002, 0x5553aaac,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0x3331ccce, 0x55530002, 0x7ffa0012, 0x7ffb000c,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0x33323334, 0x5553aaac, 0x7ffb000c, 0x7ffc0008,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0x3332999a, 0x55545556, 0x7ffc0006, 0x7ffd0004,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xcccd0000, 0xaaab0000, 0x80030000, 0x80020000,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xcccd6666, 0xaaabaaaa, 0x8003fffa, 0x8002fffc,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xddddbbbc, 0xc71c38e4, 0xaaac0004, 0xaaab5558,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xeb84e148, 0xdddd7778, 0xcccd3338, 0xccccccd0,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffcccd00, 0xffaaab00, 0xff800300, 0xff800200,
  0xffcd3366, 0xffab55aa, 0xff8102fa, 0xff8101fc,
  0xffcd99cc, 0xffac0054, 0xff8202f4, 0xff8201f8,
  0xffce0032, 0xffacaafe, 0xff8302ee, 0xff8301f4,
  0xfff999a0, 0xfff55560, 0xfff00060, 0xfff00040,
  0xfffeccce, 0xfffe0002, 0xfffd0012, 0xfffd000c,
  0xffff3334, 0xfffeaaac, 0xfffe000c, 0xfffe0008,
  0xffff999a, 0xffff5556, 0xffff0006, 0xffff0004,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x00015554, 0x0001fff4, 0x0001fff8, 0x0001fffc,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x000aaaa0, 0x000fffa0, 0x000fffc0, 0x000fffe0,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x00535502, 0x007cfd12, 0x007cfe0c, 0x007cff06,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0x0053ffac, 0x007dfd0c, 0x007dfe08, 0x007dff04,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0x0054aa56, 0x007efd06, 0x007efe04, 0x007eff02,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0x2221ddde, 0x3331ccce, 0x33323334, 0x3332999a,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0x38e31c72, 0x55530002, 0x5553aaac, 0x55545556,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0x55530002, 0x7ffa0012, 0x7ffb000c, 0x7ffc0006,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0x5553aaac, 0x7ffb000c, 0x7ffc0008, 0x7ffd0004,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0x55545556, 0x7ffc0006, 0x7ffd0004, 0x7ffe0002,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xaaab0000, 0x80030000, 0x80020000, 0x80010000,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xaaabaaaa, 0x8003fffa, 0x8002fffc, 0x8001fffe,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xc71c38e4, 0xaaac0004, 0xaaab5558, 0xaaaaaaac,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xdddd7778, 0xcccd3338, 0xccccccd0, 0xcccc6668,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffaaab00, 0xff800300, 0xff800200, 0xff800100,
  0xffab55aa, 0xff8102fa, 0xff8101fc, 0xff8100fe,
  0xffac0054, 0xff8202f4, 0xff8201f8, 0xff8200fc,
  0xffacaafe, 0xff8302ee, 0xff8301f4, 0xff8300fa,
  0xfff55560, 0xfff00060, 0xfff00040, 0xfff00020,
  0xfffe0002, 0xfffd0012, 0xfffd000c, 0xfffd0006,
  0xfffeaaac, 0xfffe000c, 0xfffe0008, 0xfffe0004,
  0xffff5556, 0xffff0006, 0xffff0004, 0xffff0002,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x007f0000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x007e0000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x007d0000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00100000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00030000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00020000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x007e0000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x007d0000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00100000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00030000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00020000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x007d0000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00100000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00030000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00020000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0xfffe0000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00100000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00030000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00020000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0xfffe0000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0xfff00000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00030000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00020000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0xfffe0000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0xfff00000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0xff830000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00020000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0xfffe0000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0xfff00000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0xff830000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0xff820000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0xfffe0000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0xfff00000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0xff830000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0xff820000,
  0x007efd06, 0x007efe04, 0x007eff02, 0xff810000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0xfffe0000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0xfff00000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0xff830000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0xff820000,
  0x007efd06, 0x007efe04, 0x007eff02, 0xff810000,
  0x3331ccce, 0x33323334, 0x3332999a, 0xcccd0000,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0xffff0000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0xfffe0000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0xfff00000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0xff830000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0xff820000,
  0x007efd06, 0x007efe04, 0x007eff02, 0xff810000,
  0x3331ccce, 0x33323334, 0x3332999a, 0xcccd0000,
  0x55530002, 0x5553aaac, 0x55545556, 0xaaab0000,
  0x0001fff4, 0x0001fff8, 0x0001fffc, 0xfffe0000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0xfff00000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0xff830000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0xff820000,
  0x007efd06, 0x007efe04, 0x007eff02, 0xff810000,
  0x3331ccce, 0x33323334, 0x3332999a, 0xcccd0000,
  0x55530002, 0x5553aaac, 0x55545556, 0xaaab0000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x80030000,
  0x000fffa0, 0x000fffc0, 0x000fffe0, 0xfff00000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0xff830000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0xff820000,
  0x007efd06, 0x007efe04, 0x007eff02, 0xff810000,
  0x3331ccce, 0x33323334, 0x3332999a, 0xcccd0000,
  0x55530002, 0x5553aaac, 0x55545556, 0xaaab0000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x80030000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x80020000,
  0x007cfd12, 0x007cfe0c, 0x007cff06, 0xff830000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0xff820000,
  0x007efd06, 0x007efe04, 0x007eff02, 0xff810000,
  0x3331ccce, 0x33323334, 0x3332999a, 0xcccd0000,
  0x55530002, 0x5553aaac, 0x55545556, 0xaaab0000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x80030000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x80020000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x80010000,
  0x007dfd0c, 0x007dfe08, 0x007dff04, 0xff820000,
  0x007efd06, 0x007efe04, 0x007eff02, 0xff810000,
  0x3331ccce, 0x33323334, 0x3332999a, 0xcccd0000,
  0x55530002, 0x5553aaac, 0x55545556, 0xaaab0000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x80030000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x80020000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x80010000,
  0x80030000, 0x80020000, 0x80010000, 0x7fffffff,
  0x007efd06, 0x007efe04, 0x007eff02, 0xff810000,
  0x3331ccce, 0x33323334, 0x3332999a, 0xcccd0000,
  0x55530002, 0x5553aaac, 0x55545556, 0xaaab0000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x80030000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x80020000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x80010000,
  0x80030000, 0x80020000, 0x80010000, 0x7fffffff,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x7fff0000,
  0x3331ccce, 0x33323334, 0x3332999a, 0xcccd0000,
  0x55530002, 0x5553aaac, 0x55545556, 0xaaab0000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x80030000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x80020000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x80010000,
  0x80030000, 0x80020000, 0x80010000, 0x7fffffff,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x7fff0000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x55560000,
  0x55530002, 0x5553aaac, 0x55545556, 0xaaab0000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x80030000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x80020000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x80010000,
  0x80030000, 0x80020000, 0x80010000, 0x7fffffff,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x7fff0000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x55560000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x33340000,
  0x7ffa0012, 0x7ffb000c, 0x7ffc0006, 0x80030000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x80020000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x80010000,
  0x80030000, 0x80020000, 0x80010000, 0x7fffffff,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x7fff0000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x55560000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x33340000,
  0xff800300, 0xff800200, 0xff800100, 0x00800000,
  0x7ffb000c, 0x7ffc0008, 0x7ffd0004, 0x80020000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x80010000,
  0x80030000, 0x80020000, 0x80010000, 0x7fffffff,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x7fff0000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x55560000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x33340000,
  0xff800300, 0xff800200, 0xff800100, 0x00800000,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x007f0000,
  0x7ffc0006, 0x7ffd0004, 0x7ffe0002, 0x80010000,
  0x80030000, 0x80020000, 0x80010000, 0x7fffffff,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x7fff0000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x55560000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x33340000,
  0xff800300, 0xff800200, 0xff800100, 0x00800000,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x007f0000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x007e0000,
  0x80030000, 0x80020000, 0x80010000, 0x7fffffff,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x7fff0000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x55560000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x33340000,
  0xff800300, 0xff800200, 0xff800100, 0x00800000,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x007f0000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x007e0000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x007d0000,
  0x8003fffa, 0x8002fffc, 0x8001fffe, 0x7fff0000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x55560000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x33340000,
  0xff800300, 0xff800200, 0xff800100, 0x00800000,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x007f0000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x007e0000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x007d0000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00100000,
  0xaaac0004, 0xaaab5558, 0xaaaaaaac, 0x55560000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x33340000,
  0xff800300, 0xff800200, 0xff800100, 0x00800000,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x007f0000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x007e0000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x007d0000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00100000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00030000,
  0xcccd3338, 0xccccccd0, 0xcccc6668, 0x33340000,
  0xff800300, 0xff800200, 0xff800100, 0x00800000,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x007f0000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x007e0000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x007d0000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00100000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00030000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00020000,
  0xff800300, 0xff800200, 0xff800100, 0x00800000,
  0xff8102fa, 0xff8101fc, 0xff8100fe, 0x007f0000,
  0xff8202f4, 0xff8201f8, 0xff8200fc, 0x007e0000,
  0xff8302ee, 0xff8301f4, 0xff8300fa, 0x007d0000,
  0xfff00060, 0xfff00040, 0xfff00020, 0x00100000,
  0xfffd0012, 0xfffd000c, 0xfffd0006, 0x00030000,
  0xfffe000c, 0xfffe0008, 0xfffe0004, 0x00020000,
  0xffff0006, 0xffff0004, 0xffff0002, 0x00010000,
  0xff8101fc, 0xff8100fe, 0x007f0000, 0x007eff02,
  0xff8201f8, 0xff8200fc, 0x007e0000, 0x007dff04,
  0xff8301f4, 0xff8300fa, 0x007d0000, 0x007cff06,
  0xfff00040, 0xfff00020, 0x00100000, 0x000fffe0,
  0xfffd000c, 0xfffd0006, 0x00030000, 0x0002fffa,
  0xfffe0008, 0xfffe0004, 0x00020000, 0x0001fffc,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xff8201f8, 0xff8200fc, 0x007e0000, 0x007dff04,
  0xff8301f4, 0xff8300fa, 0x007d0000, 0x007cff06,
  0xfff00040, 0xfff00020, 0x00100000, 0x000fffe0,
  0xfffd000c, 0xfffd0006, 0x00030000, 0x0002fffa,
  0xfffe0008, 0xfffe0004, 0x00020000, 0x0001fffc,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0xff8301f4, 0xff8300fa, 0x007d0000, 0x007cff06,
  0xfff00040, 0xfff00020, 0x00100000, 0x000fffe0,
  0xfffd000c, 0xfffd0006, 0x00030000, 0x0002fffa,
  0xfffe0008, 0xfffe0004, 0x00020000, 0x0001fffc,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0x0001fff8, 0x0001fffc, 0xfffe0000, 0xfffe0004,
  0xfff00040, 0xfff00020, 0x00100000, 0x000fffe0,
  0xfffd000c, 0xfffd0006, 0x00030000, 0x0002fffa,
  0xfffe0008, 0xfffe0004, 0x00020000, 0x0001fffc,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0x0001fff8, 0x0001fffc, 0xfffe0000, 0xfffe0004,
  0x000fffc0, 0x000fffe0, 0xfff00000, 0xfff00020,
  0xfffd000c, 0xfffd0006, 0x00030000, 0x0002fffa,
  0xfffe0008, 0xfffe0004, 0x00020000, 0x0001fffc,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0x0001fff8, 0x0001fffc, 0xfffe0000, 0xfffe0004,
  0x000fffc0, 0x000fffe0, 0xfff00000, 0xfff00020,
  0x007cfe0c, 0x007cff06, 0xff830000, 0xff8300fa,
  0xfffe0008, 0xfffe0004, 0x00020000, 0x0001fffc,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0x0001fff8, 0x0001fffc, 0xfffe0000, 0xfffe0004,
  0x000fffc0, 0x000fffe0, 0xfff00000, 0xfff00020,
  0x007cfe0c, 0x007cff06, 0xff830000, 0xff8300fa,
  0x007dfe08, 0x007dff04, 0xff820000, 0xff8200fc,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0x0001fff8, 0x0001fffc, 0xfffe0000, 0xfffe0004,
  0x000fffc0, 0x000fffe0, 0xfff00000, 0xfff00020,
  0x007cfe0c, 0x007cff06, 0xff830000, 0xff8300fa,
  0x007dfe08, 0x007dff04, 0xff820000, 0xff8200fc,
  0x007efe04, 0x007eff02, 0xff810000, 0xff8100fe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0x0001fff8, 0x0001fffc, 0xfffe0000, 0xfffe0004,
  0x000fffc0, 0x000fffe0, 0xfff00000, 0xfff00020,
  0x007cfe0c, 0x007cff06, 0xff830000, 0xff8300fa,
  0x007dfe08, 0x007dff04, 0xff820000, 0xff8200fc,
  0x007efe04, 0x007eff02, 0xff810000, 0xff8100fe,
  0x33323334, 0x3332999a, 0xcccd0000, 0xcccd6666,
  0x0000fffc, 0x0000fffe, 0xffff0000, 0xffff0002,
  0x0001fff8, 0x0001fffc, 0xfffe0000, 0xfffe0004,
  0x000fffc0, 0x000fffe0, 0xfff00000, 0xfff00020,
  0x007cfe0c, 0x007cff06, 0xff830000, 0xff8300fa,
  0x007dfe08, 0x007dff04, 0xff820000, 0xff8200fc,
  0x007efe04, 0x007eff02, 0xff810000, 0xff8100fe,
  0x33323334, 0x3332999a, 0xcccd0000, 0xcccd6666,
  0x5553aaac, 0x55545556, 0xaaab0000, 0xaaabaaaa,
  0x0001fff8, 0x0001fffc, 0xfffe0000, 0xfffe0004,
  0x000fffc0, 0x000fffe0, 0xfff00000, 0xfff00020,
  0x007cfe0c, 0x007cff06, 0xff830000, 0xff8300fa,
  0x007dfe08, 0x007dff04, 0xff820000, 0xff8200fc,
  0x007efe04, 0x007eff02, 0xff810000, 0xff8100fe,
  0x33323334, 0x3332999a, 0xcccd0000, 0xcccd6666,
  0x5553aaac, 0x55545556, 0xaaab0000, 0xaaabaaaa,
  0x7ffb000c, 0x7ffc0006, 0x80030000, 0x8003fffa,
  0x000fffc0, 0x000fffe0, 0xfff00000, 0xfff00020,
  0x007cfe0c, 0x007cff06, 0xff830000, 0xff8300fa,
  0x007dfe08, 0x007dff04, 0xff820000, 0xff8200fc,
  0x007efe04, 0x007eff02, 0xff810000, 0xff8100fe,
  0x33323334, 0x3332999a, 0xcccd0000, 0xcccd6666,
  0x5553aaac, 0x55545556, 0xaaab0000, 0xaaabaaaa,
  0x7ffb000c, 0x7ffc0006, 0x80030000, 0x8003fffa,
  0x7ffc0008, 0x7ffd0004, 0x80020000, 0x8002fffc,
  0x007cfe0c, 0x007cff06, 0xff830000, 0xff8300fa,
  0x007dfe08, 0x007dff04, 0xff820000, 0xff8200fc,
  0x007efe04, 0x007eff02, 0xff810000, 0xff8100fe,
  0x33323334, 0x3332999a, 0xcccd0000, 0xcccd6666,
  0x5553aaac, 0x55545556, 0xaaab0000, 0xaaabaaaa,
  0x7ffb000c, 0x7ffc0006, 0x80030000, 0x8003fffa,
  0x7ffc0008, 0x7ffd0004, 0x80020000, 0x8002fffc,
  0x7ffd0004, 0x7ffe0002, 0x80010000, 0x8001fffe,
  0x007dfe08, 0x007dff04, 0xff820000, 0xff8200fc,
  0x007efe04, 0x007eff02, 0xff810000, 0xff8100fe,
  0x33323334, 0x3332999a, 0xcccd0000, 0xcccd6666,
  0x5553aaac, 0x55545556, 0xaaab0000, 0xaaabaaaa,
  0x7ffb000c, 0x7ffc0006, 0x80030000, 0x8003fffa,
  0x7ffc0008, 0x7ffd0004, 0x80020000, 0x8002fffc,
  0x7ffd0004, 0x7ffe0002, 0x80010000, 0x8001fffe,
  0x80020000, 0x80010000, 0x7fffffff, 0x7fff0000,
  0x007efe04, 0x007eff02, 0xff810000, 0xff8100fe,
  0x33323334, 0x3332999a, 0xcccd0000, 0xcccd6666,
  0x5553aaac, 0x55545556, 0xaaab0000, 0xaaabaaaa,
  0x7ffb000c, 0x7ffc0006, 0x80030000, 0x8003fffa,
  0x7ffc0008, 0x7ffd0004, 0x80020000, 0x8002fffc,
  0x7ffd0004, 0x7ffe0002, 0x80010000, 0x8001fffe,
  0x80020000, 0x80010000, 0x7fffffff, 0x7fff0000,
  0x8002fffc, 0x8001fffe, 0x7fff0000, 0x7ffe0002,
  0x33323334, 0x3332999a, 0xcccd0000, 0xcccd6666,
  0x5553aaac, 0x55545556, 0xaaab0000, 0xaaabaaaa,
  0x7ffb000c, 0x7ffc0006, 0x80030000, 0x8003fffa,
  0x7ffc0008, 0x7ffd0004, 0x80020000, 0x8002fffc,
  0x7ffd0004, 0x7ffe0002, 0x80010000, 0x8001fffe,
  0x80020000, 0x80010000, 0x7fffffff, 0x7fff0000,
  0x8002fffc, 0x8001fffe, 0x7fff0000, 0x7ffe0002,
  0xaaab5558, 0xaaaaaaac, 0x55560000, 0x55555554,
  0x5553aaac, 0x55545556, 0xaaab0000, 0xaaabaaaa,
  0x7ffb000c, 0x7ffc0006, 0x80030000, 0x8003fffa,
  0x7ffc0008, 0x7ffd0004, 0x80020000, 0x8002fffc,
  0x7ffd0004, 0x7ffe0002, 0x80010000, 0x8001fffe,
  0x80020000, 0x80010000, 0x7fffffff, 0x7fff0000,
  0x8002fffc, 0x8001fffe, 0x7fff0000, 0x7ffe0002,
  0xaaab5558, 0xaaaaaaac, 0x55560000, 0x55555554,
  0xccccccd0, 0xcccc6668, 0x33340000, 0x33339998,
  0x7ffb000c, 0x7ffc0006, 0x80030000, 0x8003fffa,
  0x7ffc0008, 0x7ffd0004, 0x80020000, 0x8002fffc,
  0x7ffd0004, 0x7ffe0002, 0x80010000, 0x8001fffe,
  0x80020000, 0x80010000, 0x7fffffff, 0x7fff0000,
  0x8002fffc, 0x8001fffe, 0x7fff0000, 0x7ffe0002,
  0xaaab5558, 0xaaaaaaac, 0x55560000, 0x55555554,
  0xccccccd0, 0xcccc6668, 0x33340000, 0x33339998,
  0xff800200, 0xff800100, 0x00800000, 0x007fff00,
  0x7ffc0008, 0x7ffd0004, 0x80020000, 0x8002fffc,
  0x7ffd0004, 0x7ffe0002, 0x80010000, 0x8001fffe,
  0x80020000, 0x80010000, 0x7fffffff, 0x7fff0000,
  0x8002fffc, 0x8001fffe, 0x7fff0000, 0x7ffe0002,
  0xaaab5558, 0xaaaaaaac, 0x55560000, 0x55555554,
  0xccccccd0, 0xcccc6668, 0x33340000, 0x33339998,
  0xff800200, 0xff800100, 0x00800000, 0x007fff00,
  0xff8101fc, 0xff8100fe, 0x007f0000, 0x007eff02,
  0x7ffd0004, 0x7ffe0002, 0x80010000, 0x8001fffe,
  0x80020000, 0x80010000, 0x7fffffff, 0x7fff0000,
  0x8002fffc, 0x8001fffe, 0x7fff0000, 0x7ffe0002,
  0xaaab5558, 0xaaaaaaac, 0x55560000, 0x55555554,
  0xccccccd0, 0xcccc6668, 0x33340000, 0x33339998,
  0xff800200, 0xff800100, 0x00800000, 0x007fff00,
  0xff8101fc, 0xff8100fe, 0x007f0000, 0x007eff02,
  0xff8201f8, 0xff8200fc, 0x007e0000, 0x007dff04,
  0x80020000, 0x80010000, 0x7fffffff, 0x7fff0000,
  0x8002fffc, 0x8001fffe, 0x7fff0000, 0x7ffe0002,
  0xaaab5558, 0xaaaaaaac, 0x55560000, 0x55555554,
  0xccccccd0, 0xcccc6668, 0x33340000, 0x33339998,
  0xff800200, 0xff800100, 0x00800000, 0x007fff00,
  0xff8101fc, 0xff8100fe, 0x007f0000, 0x007eff02,
  0xff8201f8, 0xff8200fc, 0x007e0000, 0x007dff04,
  0xff8301f4, 0xff8300fa, 0x007d0000, 0x007cff06,
  0x8002fffc, 0x8001fffe, 0x7fff0000, 0x7ffe0002,
  0xaaab5558, 0xaaaaaaac, 0x55560000, 0x55555554,
  0xccccccd0, 0xcccc6668, 0x33340000, 0x33339998,
  0xff800200, 0xff800100, 0x00800000, 0x007fff00,
  0xff8101fc, 0xff8100fe, 0x007f0000, 0x007eff02,
  0xff8201f8, 0xff8200fc, 0x007e0000, 0x007dff04,
  0xff8301f4, 0xff8300fa, 0x007d0000, 0x007cff06,
  0xfff00040, 0xfff00020, 0x00100000, 0x000fffe0,
  0xaaab5558, 0xaaaaaaac, 0x55560000, 0x55555554,
  0xccccccd0, 0xcccc6668, 0x33340000, 0x33339998,
  0xff800200, 0xff800100, 0x00800000, 0x007fff00,
  0xff8101fc, 0xff8100fe, 0x007f0000, 0x007eff02,
  0xff8201f8, 0xff8200fc, 0x007e0000, 0x007dff04,
  0xff8301f4, 0xff8300fa, 0x007d0000, 0x007cff06,
  0xfff00040, 0xfff00020, 0x00100000, 0x000fffe0,
  0xfffd000c, 0xfffd0006, 0x00030000, 0x0002fffa,
  0xccccccd0, 0xcccc6668, 0x33340000, 0x33339998,
  0xff800200, 0xff800100, 0x00800000, 0x007fff00,
  0xff8101fc, 0xff8100fe, 0x007f0000, 0x007eff02,
  0xff8201f8, 0xff8200fc, 0x007e0000, 0x007dff04,
  0xff8301f4, 0xff8300fa, 0x007d0000, 0x007cff06,
  0xfff00040, 0xfff00020, 0x00100000, 0x000fffe0,
  0xfffd000c, 0xfffd0006, 0x00030000, 0x0002fffa,
  0xfffe0008, 0xfffe0004, 0x00020000, 0x0001fffc,
  0xff800200, 0xff800100, 0x00800000, 0x007fff00,
  0xff8101fc, 0xff8100fe, 0x007f0000, 0x007eff02,
  0xff8201f8, 0xff8200fc, 0x007e0000, 0x007dff04,
  0xff8301f4, 0xff8300fa, 0x007d0000, 0x007cff06,
  0xfff00040, 0xfff00020, 0x00100000, 0x000fffe0,
  0xfffd000c, 0xfffd0006, 0x00030000, 0x0002fffa,
  0xfffe0008, 0xfffe0004, 0x00020000, 0x0001fffc,
  0xffff0004, 0xffff0002, 0x00010000, 0x0000fffe,
  0xff8100fe, 0x007f0000, 0x007eff02, 0x0054ab54,
  0xff8200fc, 0x007e0000, 0x007dff04, 0x005400a8,
  0xff8300fa, 0x007d0000, 0x007cff06, 0x005355fc,
  0xfff00020, 0x00100000, 0x000fffe0, 0x000aaac0,
  0xfffd0006, 0x00030000, 0x0002fffa, 0x00020004,
  0xfffe0004, 0x00020000, 0x0001fffc, 0x00015558,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xff8200fc, 0x007e0000, 0x007dff04, 0x005400a8,
  0xff8300fa, 0x007d0000, 0x007cff06, 0x005355fc,
  0xfff00020, 0x00100000, 0x000fffe0, 0x000aaac0,
  0xfffd0006, 0x00030000, 0x0002fffa, 0x00020004,
  0xfffe0004, 0x00020000, 0x0001fffc, 0x00015558,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0xff8300fa, 0x007d0000, 0x007cff06, 0x005355fc,
  0xfff00020, 0x00100000, 0x000fffe0, 0x000aaac0,
  0xfffd0006, 0x00030000, 0x0002fffa, 0x00020004,
  0xfffe0004, 0x00020000, 0x0001fffc, 0x00015558,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0x0001fffc, 0xfffe0000, 0xfffe0004, 0xfffeaaa8,
  0xfff00020, 0x00100000, 0x000fffe0, 0x000aaac0,
  0xfffd0006, 0x00030000, 0x0002fffa, 0x00020004,
  0xfffe0004, 0x00020000, 0x0001fffc, 0x00015558,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0x0001fffc, 0xfffe0000, 0xfffe0004, 0xfffeaaa8,
  0x000fffe0, 0xfff00000, 0xfff00020, 0xfff55540,
  0xfffd0006, 0x00030000, 0x0002fffa, 0x00020004,
  0xfffe0004, 0x00020000, 0x0001fffc, 0x00015558,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0x0001fffc, 0xfffe0000, 0xfffe0004, 0xfffeaaa8,
  0x000fffe0, 0xfff00000, 0xfff00020, 0xfff55540,
  0x007cff06, 0xff830000, 0xff8300fa, 0xffacaa04,
  0xfffe0004, 0x00020000, 0x0001fffc, 0x00015558,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0x0001fffc, 0xfffe0000, 0xfffe0004, 0xfffeaaa8,
  0x000fffe0, 0xfff00000, 0xfff00020, 0xfff55540,
  0x007cff06, 0xff830000, 0xff8300fa, 0xffacaa04,
  0x007dff04, 0xff820000, 0xff8200fc, 0xffabff58,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0x0001fffc, 0xfffe0000, 0xfffe0004, 0xfffeaaa8,
  0x000fffe0, 0xfff00000, 0xfff00020, 0xfff55540,
  0x007cff06, 0xff830000, 0xff8300fa, 0xffacaa04,
  0x007dff04, 0xff820000, 0xff8200fc, 0xffabff58,
  0x007eff02, 0xff810000, 0xff8100fe, 0xffab54ac,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0x0001fffc, 0xfffe0000, 0xfffe0004, 0xfffeaaa8,
  0x000fffe0, 0xfff00000, 0xfff00020, 0xfff55540,
  0x007cff06, 0xff830000, 0xff8300fa, 0xffacaa04,
  0x007dff04, 0xff820000, 0xff8200fc, 0xffabff58,
  0x007eff02, 0xff810000, 0xff8100fe, 0xffab54ac,
  0x3332999a, 0xcccd0000, 0xcccd6666, 0xddddbbbc,
  0x0000fffe, 0xffff0000, 0xffff0002, 0xffff5554,
  0x0001fffc, 0xfffe0000, 0xfffe0004, 0xfffeaaa8,
  0x000fffe0, 0xfff00000, 0xfff00020, 0xfff55540,
  0x007cff06, 0xff830000, 0xff8300fa, 0xffacaa04,
  0x007dff04, 0xff820000, 0xff8200fc, 0xffabff58,
  0x007eff02, 0xff810000, 0xff8100fe, 0xffab54ac,
  0x3332999a, 0xcccd0000, 0xcccd6666, 0xddddbbbc,
  0x55545556, 0xaaab0000, 0xaaabaaaa, 0xc71c38e4,
  0x0001fffc, 0xfffe0000, 0xfffe0004, 0xfffeaaa8,
  0x000fffe0, 0xfff00000, 0xfff00020, 0xfff55540,
  0x007cff06, 0xff830000, 0xff8300fa, 0xffacaa04,
  0x007dff04, 0xff820000, 0xff8200fc, 0xffabff58,
  0x007eff02, 0xff810000, 0xff8100fe, 0xffab54ac,
  0x3332999a, 0xcccd0000, 0xcccd6666, 0xddddbbbc,
  0x55545556, 0xaaab0000, 0xaaabaaaa, 0xc71c38e4,
  0x7ffc0006, 0x80030000, 0x8003fffa, 0xaaac0004,
  0x000fffe0, 0xfff00000, 0xfff00020, 0xfff55540,
  0x007cff06, 0xff830000, 0xff8300fa, 0xffacaa04,
  0x007dff04, 0xff820000, 0xff8200fc, 0xffabff58,
  0x007eff02, 0xff810000, 0xff8100fe, 0xffab54ac,
  0x3332999a, 0xcccd0000, 0xcccd6666, 0xddddbbbc,
  0x55545556, 0xaaab0000, 0xaaabaaaa, 0xc71c38e4,
  0x7ffc0006, 0x80030000, 0x8003fffa, 0xaaac0004,
  0x7ffd0004, 0x80020000, 0x8002fffc, 0xaaab5558,
  0x007cff06, 0xff830000, 0xff8300fa, 0xffacaa04,
  0x007dff04, 0xff820000, 0xff8200fc, 0xffabff58,
  0x007eff02, 0xff810000, 0xff8100fe, 0xffab54ac,
  0x3332999a, 0xcccd0000, 0xcccd6666, 0xddddbbbc,
  0x55545556, 0xaaab0000, 0xaaabaaaa, 0xc71c38e4,
  0x7ffc0006, 0x80030000, 0x8003fffa, 0xaaac0004,
  0x7ffd0004, 0x80020000, 0x8002fffc, 0xaaab5558,
  0x7ffe0002, 0x80010000, 0x8001fffe, 0xaaaaaaac,
  0x007dff04, 0xff820000, 0xff8200fc, 0xffabff58,
  0x007eff02, 0xff810000, 0xff8100fe, 0xffab54ac,
  0x3332999a, 0xcccd0000, 0xcccd6666, 0xddddbbbc,
  0x55545556, 0xaaab0000, 0xaaabaaaa, 0xc71c38e4,
  0x7ffc0006, 0x80030000, 0x8003fffa, 0xaaac0004,
  0x7ffd0004, 0x80020000, 0x8002fffc, 0xaaab5558,
  0x7ffe0002, 0x80010000, 0x8001fffe, 0xaaaaaaac,
  0x80010000, 0x7fffffff, 0x7fff0000, 0x55560000,
  0x007eff02, 0xff810000, 0xff8100fe, 0xffab54ac,
  0x3332999a, 0xcccd0000, 0xcccd6666, 0xddddbbbc,
  0x55545556, 0xaaab0000, 0xaaabaaaa, 0xc71c38e4,
  0x7ffc0006, 0x80030000, 0x8003fffa, 0xaaac0004,
  0x7ffd0004, 0x80020000, 0x8002fffc, 0xaaab5558,
  0x7ffe0002, 0x80010000, 0x8001fffe, 0xaaaaaaac,
  0x80010000, 0x7fffffff, 0x7fff0000, 0x55560000,
  0x8001fffe, 0x7fff0000, 0x7ffe0002, 0x55555554,
  0x3332999a, 0xcccd0000, 0xcccd6666, 0xddddbbbc,
  0x55545556, 0xaaab0000, 0xaaabaaaa, 0xc71c38e4,
  0x7ffc0006, 0x80030000, 0x8003fffa, 0xaaac0004,
  0x7ffd0004, 0x80020000, 0x8002fffc, 0xaaab5558,
  0x7ffe0002, 0x80010000, 0x8001fffe, 0xaaaaaaac,
  0x80010000, 0x7fffffff, 0x7fff0000, 0x55560000,
  0x8001fffe, 0x7fff0000, 0x7ffe0002, 0x55555554,
  0xaaaaaaac, 0x55560000, 0x55555554, 0x38e471c8,
  0x55545556, 0xaaab0000, 0xaaabaaaa, 0xc71c38e4,
  0x7ffc0006, 0x80030000, 0x8003fffa, 0xaaac0004,
  0x7ffd0004, 0x80020000, 0x8002fffc, 0xaaab5558,
  0x7ffe0002, 0x80010000, 0x8001fffe, 0xaaaaaaac,
  0x80010000, 0x7fffffff, 0x7fff0000, 0x55560000,
  0x8001fffe, 0x7fff0000, 0x7ffe0002, 0x55555554,
  0xaaaaaaac, 0x55560000, 0x55555554, 0x38e471c8,
  0xcccc6668, 0x33340000, 0x33339998, 0x2222eef0,
  0x7ffc0006, 0x80030000, 0x8003fffa, 0xaaac0004,
  0x7ffd0004, 0x80020000, 0x8002fffc, 0xaaab5558,
  0x7ffe0002, 0x80010000, 0x8001fffe, 0xaaaaaaac,
  0x80010000, 0x7fffffff, 0x7fff0000, 0x55560000,
  0x8001fffe, 0x7fff0000, 0x7ffe0002, 0x55555554,
  0xaaaaaaac, 0x55560000, 0x55555554, 0x38e471c8,
  0xcccc6668, 0x33340000, 0x33339998, 0x2222eef0,
  0xff800100, 0x00800000, 0x007fff00, 0x00555600,
  0x7ffd0004, 0x80020000, 0x8002fffc, 0xaaab5558,
  0x7ffe0002, 0x80010000, 0x8001fffe, 0xaaaaaaac,
  0x80010000, 0x7fffffff, 0x7fff0000, 0x55560000,
  0x8001fffe, 0x7fff0000, 0x7ffe0002, 0x55555554,
  0xaaaaaaac, 0x55560000, 0x55555554, 0x38e471c8,
  0xcccc6668, 0x33340000, 0x33339998, 0x2222eef0,
  0xff800100, 0x00800000, 0x007fff00, 0x00555600,
  0xff8100fe, 0x007f0000, 0x007eff02, 0x0054ab54,
  0x7ffe0002, 0x80010000, 0x8001fffe, 0xaaaaaaac,
  0x80010000, 0x7fffffff, 0x7fff0000, 0x55560000,
  0x8001fffe, 0x7fff0000, 0x7ffe0002, 0x55555554,
  0xaaaaaaac, 0x55560000, 0x55555554, 0x38e471c8,
  0xcccc6668, 0x33340000, 0x33339998, 0x2222eef0,
  0xff800100, 0x00800000, 0x007fff00, 0x00555600,
  0xff8100fe, 0x007f0000, 0x007eff02, 0x0054ab54,
  0xff8200fc, 0x007e0000, 0x007dff04, 0x005400a8,
  0x80010000, 0x7fffffff, 0x7fff0000, 0x55560000,
  0x8001fffe, 0x7fff0000, 0x7ffe0002, 0x55555554,
  0xaaaaaaac, 0x55560000, 0x55555554, 0x38e471c8,
  0xcccc6668, 0x33340000, 0x33339998, 0x2222eef0,
  0xff800100, 0x00800000, 0x007fff00, 0x00555600,
  0xff8100fe, 0x007f0000, 0x007eff02, 0x0054ab54,
  0xff8200fc, 0x007e0000, 0x007dff04, 0x005400a8,
  0xff8300fa, 0x007d0000, 0x007cff06, 0x005355fc,
  0x8001fffe, 0x7fff0000, 0x7ffe0002, 0x55555554,
  0xaaaaaaac, 0x55560000, 0x55555554, 0x38e471c8,
  0xcccc6668, 0x33340000, 0x33339998, 0x2222eef0,
  0xff800100, 0x00800000, 0x007fff00, 0x00555600,
  0xff8100fe, 0x007f0000, 0x007eff02, 0x0054ab54,
  0xff8200fc, 0x007e0000, 0x007dff04, 0x005400a8,
  0xff8300fa, 0x007d0000, 0x007cff06, 0x005355fc,
  0xfff00020, 0x00100000, 0x000fffe0, 0x000aaac0,
  0xaaaaaaac, 0x55560000, 0x55555554, 0x38e471c8,
  0xcccc6668, 0x33340000, 0x33339998, 0x2222eef0,
  0xff800100, 0x00800000, 0x007fff00, 0x00555600,
  0xff8100fe, 0x007f0000, 0x007eff02, 0x0054ab54,
  0xff8200fc, 0x007e0000, 0x007dff04, 0x005400a8,
  0xff8300fa, 0x007d0000, 0x007cff06, 0x005355fc,
  0xfff00020, 0x00100000, 0x000fffe0, 0x000aaac0,
  0xfffd0006, 0x00030000, 0x0002fffa, 0x00020004,
  0xcccc6668, 0x33340000, 0x33339998, 0x2222eef0,
  0xff800100, 0x00800000, 0x007fff00, 0x00555600,
  0xff8100fe, 0x007f0000, 0x007eff02, 0x0054ab54,
  0xff8200fc, 0x007e0000, 0x007dff04, 0x005400a8,
  0xff8300fa, 0x007d0000, 0x007cff06, 0x005355fc,
  0xfff00020, 0x00100000, 0x000fffe0, 0x000aaac0,
  0xfffd0006, 0x00030000, 0x0002fffa, 0x00020004,
  0xfffe0004, 0x00020000, 0x0001fffc, 0x00015558,
  0xff800100, 0x00800000, 0x007fff00, 0x00555600,
  0xff8100fe, 0x007f0000, 0x007eff02, 0x0054ab54,
  0xff8200fc, 0x007e0000, 0x007dff04, 0x005400a8,
  0xff8300fa, 0x007d0000, 0x007cff06, 0x005355fc,
  0xfff00020, 0x00100000, 0x000fffe0, 0x000aaac0,
  0xfffd0006, 0x00030000, 0x0002fffa, 0x00020004,
  0xfffe0004, 0x00020000, 0x0001fffc, 0x00015558,
  0xffff0002, 0x00010000, 0x0000fffe, 0x0000aaac,
  0x007f0000, 0x007eff02, 0x0054ab54, 0x0032cd98,
  0x007e0000, 0x007dff04, 0x005400a8, 0x00326730,
  0x007d0000, 0x007cff06, 0x005355fc, 0x003200c8,
  0x00100000, 0x000fffe0, 0x000aaac0, 0x00066680,
  0x00030000, 0x0002fffa, 0x00020004, 0x00013338,
  0x00020000, 0x0001fffc, 0x00015558, 0x0000ccd0,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x007e0000, 0x007dff04, 0x005400a8, 0x00326730,
  0x007d0000, 0x007cff06, 0x005355fc, 0x003200c8,
  0x00100000, 0x000fffe0, 0x000aaac0, 0x00066680,
  0x00030000, 0x0002fffa, 0x00020004, 0x00013338,
  0x00020000, 0x0001fffc, 0x00015558, 0x0000ccd0,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0x007d0000, 0x007cff06, 0x005355fc, 0x003200c8,
  0x00100000, 0x000fffe0, 0x000aaac0, 0x00066680,
  0x00030000, 0x0002fffa, 0x00020004, 0x00013338,
  0x00020000, 0x0001fffc, 0x00015558, 0x0000ccd0,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0xfffe0000, 0xfffe0004, 0xfffeaaa8, 0xffff3330,
  0x00100000, 0x000fffe0, 0x000aaac0, 0x00066680,
  0x00030000, 0x0002fffa, 0x00020004, 0x00013338,
  0x00020000, 0x0001fffc, 0x00015558, 0x0000ccd0,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0xfffe0000, 0xfffe0004, 0xfffeaaa8, 0xffff3330,
  0xfff00000, 0xfff00020, 0xfff55540, 0xfff99980,
  0x00030000, 0x0002fffa, 0x00020004, 0x00013338,
  0x00020000, 0x0001fffc, 0x00015558, 0x0000ccd0,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0xfffe0000, 0xfffe0004, 0xfffeaaa8, 0xffff3330,
  0xfff00000, 0xfff00020, 0xfff55540, 0xfff99980,
  0xff830000, 0xff8300fa, 0xffacaa04, 0xffcdff38,
  0x00020000, 0x0001fffc, 0x00015558, 0x0000ccd0,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0xfffe0000, 0xfffe0004, 0xfffeaaa8, 0xffff3330,
  0xfff00000, 0xfff00020, 0xfff55540, 0xfff99980,
  0xff830000, 0xff8300fa, 0xffacaa04, 0xffcdff38,
  0xff820000, 0xff8200fc, 0xffabff58, 0xffcd98d0,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0xfffe0000, 0xfffe0004, 0xfffeaaa8, 0xffff3330,
  0xfff00000, 0xfff00020, 0xfff55540, 0xfff99980,
  0xff830000, 0xff8300fa, 0xffacaa04, 0xffcdff38,
  0xff820000, 0xff8200fc, 0xffabff58, 0xffcd98d0,
  0xff810000, 0xff8100fe, 0xffab54ac, 0xffcd3268,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0xfffe0000, 0xfffe0004, 0xfffeaaa8, 0xffff3330,
  0xfff00000, 0xfff00020, 0xfff55540, 0xfff99980,
  0xff830000, 0xff8300fa, 0xffacaa04, 0xffcdff38,
  0xff820000, 0xff8200fc, 0xffabff58, 0xffcd98d0,
  0xff810000, 0xff8100fe, 0xffab54ac, 0xffcd3268,
  0xcccd0000, 0xcccd6666, 0xddddbbbc, 0xeb84e148,
  0xffff0000, 0xffff0002, 0xffff5554, 0xffff9998,
  0xfffe0000, 0xfffe0004, 0xfffeaaa8, 0xffff3330,
  0xfff00000, 0xfff00020, 0xfff55540, 0xfff99980,
  0xff830000, 0xff8300fa, 0xffacaa04, 0xffcdff38,
  0xff820000, 0xff8200fc, 0xffabff58, 0xffcd98d0,
  0xff810000, 0xff8100fe, 0xffab54ac, 0xffcd3268,
  0xcccd0000, 0xcccd6666, 0xddddbbbc, 0xeb84e148,
  0xaaab0000, 0xaaabaaaa, 0xc71c38e4, 0xdddd7778,
  0xfffe0000, 0xfffe0004, 0xfffeaaa8, 0xffff3330,
  0xfff00000, 0xfff00020, 0xfff55540, 0xfff99980,
  0xff830000, 0xff8300fa, 0xffacaa04, 0xffcdff38,
  0xff820000, 0xff8200fc, 0xffabff58, 0xffcd98d0,
  0xff810000, 0xff8100fe, 0xffab54ac, 0xffcd3268,
  0xcccd0000, 0xcccd6666, 0xddddbbbc, 0xeb84e148,
  0xaaab0000, 0xaaabaaaa, 0xc71c38e4, 0xdddd7778,
  0x80030000, 0x8003fffa, 0xaaac0004, 0xcccd3338,
  0xfff00000, 0xfff00020, 0xfff55540, 0xfff99980,
  0xff830000, 0xff8300fa, 0xffacaa04, 0xffcdff38,
  0xff820000, 0xff8200fc, 0xffabff58, 0xffcd98d0,
  0xff810000, 0xff8100fe, 0xffab54ac, 0xffcd3268,
  0xcccd0000, 0xcccd6666, 0xddddbbbc, 0xeb84e148,
  0xaaab0000, 0xaaabaaaa, 0xc71c38e4, 0xdddd7778,
  0x80030000, 0x8003fffa, 0xaaac0004, 0xcccd3338,
  0x80020000, 0x8002fffc, 0xaaab5558, 0xccccccd0,
  0xff830000, 0xff8300fa, 0xffacaa04, 0xffcdff38,
  0xff820000, 0xff8200fc, 0xffabff58, 0xffcd98d0,
  0xff810000, 0xff8100fe, 0xffab54ac, 0xffcd3268,
  0xcccd0000, 0xcccd6666, 0xddddbbbc, 0xeb84e148,
  0xaaab0000, 0xaaabaaaa, 0xc71c38e4, 0xdddd7778,
  0x80030000, 0x8003fffa, 0xaaac0004, 0xcccd3338,
  0x80020000, 0x8002fffc, 0xaaab5558, 0xccccccd0,
  0x80010000, 0x8001fffe, 0xaaaaaaac, 0xcccc6668,
  0xff820000, 0xff8200fc, 0xffabff58, 0xffcd98d0,
  0xff810000, 0xff8100fe, 0xffab54ac, 0xffcd3268,
  0xcccd0000, 0xcccd6666, 0xddddbbbc, 0xeb84e148,
  0xaaab0000, 0xaaabaaaa, 0xc71c38e4, 0xdddd7778,
  0x80030000, 0x8003fffa, 0xaaac0004, 0xcccd3338,
  0x80020000, 0x8002fffc, 0xaaab5558, 0xccccccd0,
  0x80010000, 0x8001fffe, 0xaaaaaaac, 0xcccc6668,
  0x7fffffff, 0x7fff0000, 0x55560000, 0x33340000,
  0xff810000, 0xff8100fe, 0xffab54ac, 0xffcd3268,
  0xcccd0000, 0xcccd6666, 0xddddbbbc, 0xeb84e148,
  0xaaab0000, 0xaaabaaaa, 0xc71c38e4, 0xdddd7778,
  0x80030000, 0x8003fffa, 0xaaac0004, 0xcccd3338,
  0x80020000, 0x8002fffc, 0xaaab5558, 0xccccccd0,
  0x80010000, 0x8001fffe, 0xaaaaaaac, 0xcccc6668,
  0x7fffffff, 0x7fff0000, 0x55560000, 0x33340000,
  0x7fff0000, 0x7ffe0002, 0x55555554, 0x33339998,
  0xcccd0000, 0xcccd6666, 0xddddbbbc, 0xeb84e148,
  0xaaab0000, 0xaaabaaaa, 0xc71c38e4, 0xdddd7778,
  0x80030000, 0x8003fffa, 0xaaac0004, 0xcccd3338,
  0x80020000, 0x8002fffc, 0xaaab5558, 0xccccccd0,
  0x80010000, 0x8001fffe, 0xaaaaaaac, 0xcccc6668,
  0x7fffffff, 0x7fff0000, 0x55560000, 0x33340000,
  0x7fff0000, 0x7ffe0002, 0x55555554, 0x33339998,
  0x55560000, 0x55555554, 0x38e471c8, 0x2222eef0,
  0xaaab0000, 0xaaabaaaa, 0xc71c38e4, 0xdddd7778,
  0x80030000, 0x8003fffa, 0xaaac0004, 0xcccd3338,
  0x80020000, 0x8002fffc, 0xaaab5558, 0xccccccd0,
  0x80010000, 0x8001fffe, 0xaaaaaaac, 0xcccc6668,
  0x7fffffff, 0x7fff0000, 0x55560000, 0x33340000,
  0x7fff0000, 0x7ffe0002, 0x55555554, 0x33339998,
  0x55560000, 0x55555554, 0x38e471c8, 0x2222eef0,
  0x33340000, 0x33339998, 0x2222eef0, 0x147b8520,
  0x80030000, 0x8003fffa, 0xaaac0004, 0xcccd3338,
  0x80020000, 0x8002fffc, 0xaaab5558, 0xccccccd0,
  0x80010000, 0x8001fffe, 0xaaaaaaac, 0xcccc6668,
  0x7fffffff, 0x7fff0000, 0x55560000, 0x33340000,
  0x7fff0000, 0x7ffe0002, 0x55555554, 0x33339998,
  0x55560000, 0x55555554, 0x38e471c8, 0x2222eef0,
  0x33340000, 0x33339998, 0x2222eef0, 0x147b8520,
  0x00800000, 0x007fff00, 0x00555600, 0x00333400,
  0x80020000, 0x8002fffc, 0xaaab5558, 0xccccccd0,
  0x80010000, 0x8001fffe, 0xaaaaaaac, 0xcccc6668,
  0x7fffffff, 0x7fff0000, 0x55560000, 0x33340000,
  0x7fff0000, 0x7ffe0002, 0x55555554, 0x33339998,
  0x55560000, 0x55555554, 0x38e471c8, 0x2222eef0,
  0x33340000, 0x33339998, 0x2222eef0, 0x147b8520,
  0x00800000, 0x007fff00, 0x00555600, 0x00333400,
  0x007f0000, 0x007eff02, 0x0054ab54, 0x0032cd98,
  0x80010000, 0x8001fffe, 0xaaaaaaac, 0xcccc6668,
  0x7fffffff, 0x7fff0000, 0x55560000, 0x33340000,
  0x7fff0000, 0x7ffe0002, 0x55555554, 0x33339998,
  0x55560000, 0x55555554, 0x38e471c8, 0x2222eef0,
  0x33340000, 0x33339998, 0x2222eef0, 0x147b8520,
  0x00800000, 0x007fff00, 0x00555600, 0x00333400,
  0x007f0000, 0x007eff02, 0x0054ab54, 0x0032cd98,
  0x007e0000, 0x007dff04, 0x005400a8, 0x00326730,
  0x7fffffff, 0x7fff0000, 0x55560000, 0x33340000,
  0x7fff0000, 0x7ffe0002, 0x55555554, 0x33339998,
  0x55560000, 0x55555554, 0x38e471c8, 0x2222eef0,
  0x33340000, 0x33339998, 0x2222eef0, 0x147b8520,
  0x00800000, 0x007fff00, 0x00555600, 0x00333400,
  0x007f0000, 0x007eff02, 0x0054ab54, 0x0032cd98,
  0x007e0000, 0x007dff04, 0x005400a8, 0x00326730,
  0x007d0000, 0x007cff06, 0x005355fc, 0x003200c8,
  0x7fff0000, 0x7ffe0002, 0x55555554, 0x33339998,
  0x55560000, 0x55555554, 0x38e471c8, 0x2222eef0,
  0x33340000, 0x33339998, 0x2222eef0, 0x147b8520,
  0x00800000, 0x007fff00, 0x00555600, 0x00333400,
  0x007f0000, 0x007eff02, 0x0054ab54, 0x0032cd98,
  0x007e0000, 0x007dff04, 0x005400a8, 0x00326730,
  0x007d0000, 0x007cff06, 0x005355fc, 0x003200c8,
  0x00100000, 0x000fffe0, 0x000aaac0, 0x00066680,
  0x55560000, 0x55555554, 0x38e471c8, 0x2222eef0,
  0x33340000, 0x33339998, 0x2222eef0, 0x147b8520,
  0x00800000, 0x007fff00, 0x00555600, 0x00333400,
  0x007f0000, 0x007eff02, 0x0054ab54, 0x0032cd98,
  0x007e0000, 0x007dff04, 0x005400a8, 0x00326730,
  0x007d0000, 0x007cff06, 0x005355fc, 0x003200c8,
  0x00100000, 0x000fffe0, 0x000aaac0, 0x00066680,
  0x00030000, 0x0002fffa, 0x00020004, 0x00013338,
  0x33340000, 0x33339998, 0x2222eef0, 0x147b8520,
  0x00800000, 0x007fff00, 0x00555600, 0x00333400,
  0x007f0000, 0x007eff02, 0x0054ab54, 0x0032cd98,
  0x007e0000, 0x007dff04, 0x005400a8, 0x00326730,
  0x007d0000, 0x007cff06, 0x005355fc, 0x003200c8,
  0x00100000, 0x000fffe0, 0x000aaac0, 0x00066680,
  0x00030000, 0x0002fffa, 0x00020004, 0x00013338,
  0x00020000, 0x0001fffc, 0x00015558, 0x0000ccd0,
  0x00800000, 0x007fff00, 0x00555600, 0x00333400,
  0x007f0000, 0x007eff02, 0x0054ab54, 0x0032cd98,
  0x007e0000, 0x007dff04, 0x005400a8, 0x00326730,
  0x007d0000, 0x007cff06, 0x005355fc, 0x003200c8,
  0x00100000, 0x000fffe0, 0x000aaac0, 0x00066680,
  0x00030000, 0x0002fffa, 0x00020004, 0x00013338,
  0x00020000, 0x0001fffc, 0x00015558, 0x0000ccd0,
  0x00010000, 0x0000fffe, 0x0000aaac, 0x00006668,
  0x007eff02, 0x0054ab54, 0x0032cd98, 0x00007f00,
  0x007dff04, 0x005400a8, 0x00326730, 0x00007e00,
  0x007cff06, 0x005355fc, 0x003200c8, 0x00007d00,
  0x000fffe0, 0x000aaac0, 0x00066680, 0x00001000,
  0x0002fffa, 0x00020004, 0x00013338, 0x00000300,
  0x0001fffc, 0x00015558, 0x0000ccd0, 0x00000200,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x007dff04, 0x005400a8, 0x00326730, 0x00007e00,
  0x007cff06, 0x005355fc, 0x003200c8, 0x00007d00,
  0x000fffe0, 0x000aaac0, 0x00066680, 0x00001000,
  0x0002fffa, 0x00020004, 0x00013338, 0x00000300,
  0x0001fffc, 0x00015558, 0x0000ccd0, 0x00000200,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0x007cff06, 0x005355fc, 0x003200c8, 0x00007d00,
  0x000fffe0, 0x000aaac0, 0x00066680, 0x00001000,
  0x0002fffa, 0x00020004, 0x00013338, 0x00000300,
  0x0001fffc, 0x00015558, 0x0000ccd0, 0x00000200,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0xfffe0004, 0xfffeaaa8, 0xffff3330, 0xfffffe00,
  0x000fffe0, 0x000aaac0, 0x00066680, 0x00001000,
  0x0002fffa, 0x00020004, 0x00013338, 0x00000300,
  0x0001fffc, 0x00015558, 0x0000ccd0, 0x00000200,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0xfffe0004, 0xfffeaaa8, 0xffff3330, 0xfffffe00,
  0xfff00020, 0xfff55540, 0xfff99980, 0xfffff000,
  0x0002fffa, 0x00020004, 0x00013338, 0x00000300,
  0x0001fffc, 0x00015558, 0x0000ccd0, 0x00000200,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0xfffe0004, 0xfffeaaa8, 0xffff3330, 0xfffffe00,
  0xfff00020, 0xfff55540, 0xfff99980, 0xfffff000,
  0xff8300fa, 0xffacaa04, 0xffcdff38, 0xffff8300,
  0x0001fffc, 0x00015558, 0x0000ccd0, 0x00000200,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0xfffe0004, 0xfffeaaa8, 0xffff3330, 0xfffffe00,
  0xfff00020, 0xfff55540, 0xfff99980, 0xfffff000,
  0xff8300fa, 0xffacaa04, 0xffcdff38, 0xffff8300,
  0xff8200fc, 0xffabff58, 0xffcd98d0, 0xffff8200,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0xfffe0004, 0xfffeaaa8, 0xffff3330, 0xfffffe00,
  0xfff00020, 0xfff55540, 0xfff99980, 0xfffff000,
  0xff8300fa, 0xffacaa04, 0xffcdff38, 0xffff8300,
  0xff8200fc, 0xffabff58, 0xffcd98d0, 0xffff8200,
  0xff8100fe, 0xffab54ac, 0xffcd3268, 0xffff8100,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0xfffe0004, 0xfffeaaa8, 0xffff3330, 0xfffffe00,
  0xfff00020, 0xfff55540, 0xfff99980, 0xfffff000,
  0xff8300fa, 0xffacaa04, 0xffcdff38, 0xffff8300,
  0xff8200fc, 0xffabff58, 0xffcd98d0, 0xffff8200,
  0xff8100fe, 0xffab54ac, 0xffcd3268, 0xffff8100,
  0xcccd6666, 0xddddbbbc, 0xeb84e148, 0xffcccd00,
  0xffff0002, 0xffff5554, 0xffff9998, 0xffffff00,
  0xfffe0004, 0xfffeaaa8, 0xffff3330, 0xfffffe00,
  0xfff00020, 0xfff55540, 0xfff99980, 0xfffff000,
  0xff8300fa, 0xffacaa04, 0xffcdff38, 0xffff8300,
  0xff8200fc, 0xffabff58, 0xffcd98d0, 0xffff8200,
  0xff8100fe, 0xffab54ac, 0xffcd3268, 0xffff8100,
  0xcccd6666, 0xddddbbbc, 0xeb84e148, 0xffcccd00,
  0xaaabaaaa, 0xc71c38e4, 0xdddd7778, 0xffaaab00,
  0xfffe0004, 0xfffeaaa8, 0xffff3330, 0xfffffe00,
  0xfff00020, 0xfff55540, 0xfff99980, 0xfffff000,
  0xff8300fa, 0xffacaa04, 0xffcdff38, 0xffff8300,
  0xff8200fc, 0xffabff58, 0xffcd98d0, 0xffff8200,
  0xff8100fe, 0xffab54ac, 0xffcd3268, 0xffff8100,
  0xcccd6666, 0xddddbbbc, 0xeb84e148, 0xffcccd00,
  0xaaabaaaa, 0xc71c38e4, 0xdddd7778, 0xffaaab00,
  0x8003fffa, 0xaaac0004, 0xcccd3338, 0xff800300,
  0xfff00020, 0xfff55540, 0xfff99980, 0xfffff000,
  0xff8300fa, 0xffacaa04, 0xffcdff38, 0xffff8300,
  0xff8200fc, 0xffabff58, 0xffcd98d0, 0xffff8200,
  0xff8100fe, 0xffab54ac, 0xffcd3268, 0xffff8100,
  0xcccd6666, 0xddddbbbc, 0xeb84e148, 0xffcccd00,
  0xaaabaaaa, 0xc71c38e4, 0xdddd7778, 0xffaaab00,
  0x8003fffa, 0xaaac0004, 0xcccd3338, 0xff800300,
  0x8002fffc, 0xaaab5558, 0xccccccd0, 0xff800200,
  0xff8300fa, 0xffacaa04, 0xffcdff38, 0xffff8300,
  0xff8200fc, 0xffabff58, 0xffcd98d0, 0xffff8200,
  0xff8100fe, 0xffab54ac, 0xffcd3268, 0xffff8100,
  0xcccd6666, 0xddddbbbc, 0xeb84e148, 0xffcccd00,
  0xaaabaaaa, 0xc71c38e4, 0xdddd7778, 0xffaaab00,
  0x8003fffa, 0xaaac0004, 0xcccd3338, 0xff800300,
  0x8002fffc, 0xaaab5558, 0xccccccd0, 0xff800200,
  0x8001fffe, 0xaaaaaaac, 0xcccc6668, 0xff800100,
  0xff8200fc, 0xffabff58, 0xffcd98d0, 0xffff8200,
  0xff8100fe, 0xffab54ac, 0xffcd3268, 0xffff8100,
  0xcccd6666, 0xddddbbbc, 0xeb84e148, 0xffcccd00,
  0xaaabaaaa, 0xc71c38e4, 0xdddd7778, 0xffaaab00,
  0x8003fffa, 0xaaac0004, 0xcccd3338, 0xff800300,
  0x8002fffc, 0xaaab5558, 0xccccccd0, 0xff800200,
  0x8001fffe, 0xaaaaaaac, 0xcccc6668, 0xff800100,
  0x7fff0000, 0x55560000, 0x33340000, 0x00800000,
  0xff8100fe, 0xffab54ac, 0xffcd3268, 0xffff8100,
  0xcccd6666, 0xddddbbbc, 0xeb84e148, 0xffcccd00,
  0xaaabaaaa, 0xc71c38e4, 0xdddd7778, 0xffaaab00,
  0x8003fffa, 0xaaac0004, 0xcccd3338, 0xff800300,
  0x8002fffc, 0xaaab5558, 0xccccccd0, 0xff800200,
  0x8001fffe, 0xaaaaaaac, 0xcccc6668, 0xff800100,
  0x7fff0000, 0x55560000, 0x33340000, 0x00800000,
  0x7ffe0002, 0x55555554, 0x33339998, 0x007fff00,
  0xcccd6666, 0xddddbbbc, 0xeb84e148, 0xffcccd00,
  0xaaabaaaa, 0xc71c38e4, 0xdddd7778, 0xffaaab00,
  0x8003fffa, 0xaaac0004, 0xcccd3338, 0xff800300,
  0x8002fffc, 0xaaab5558, 0xccccccd0, 0xff800200,
  0x8001fffe, 0xaaaaaaac, 0xcccc6668, 0xff800100,
  0x7fff0000, 0x55560000, 0x33340000, 0x00800000,
  0x7ffe0002, 0x55555554, 0x33339998, 0x007fff00,
  0x55555554, 0x38e471c8, 0x2222eef0, 0x00555600,
  0xaaabaaaa, 0xc71c38e4, 0xdddd7778, 0xffaaab00,
  0x8003fffa, 0xaaac0004, 0xcccd3338, 0xff800300,
  0x8002fffc, 0xaaab5558, 0xccccccd0, 0xff800200,
  0x8001fffe, 0xaaaaaaac, 0xcccc6668, 0xff800100,
  0x7fff0000, 0x55560000, 0x33340000, 0x00800000,
  0x7ffe0002, 0x55555554, 0x33339998, 0x007fff00,
  0x55555554, 0x38e471c8, 0x2222eef0, 0x00555600,
  0x33339998, 0x2222eef0, 0x147b8520, 0x00333400,
  0x8003fffa, 0xaaac0004, 0xcccd3338, 0xff800300,
  0x8002fffc, 0xaaab5558, 0xccccccd0, 0xff800200,
  0x8001fffe, 0xaaaaaaac, 0xcccc6668, 0xff800100,
  0x7fff0000, 0x55560000, 0x33340000, 0x00800000,
  0x7ffe0002, 0x55555554, 0x33339998, 0x007fff00,
  0x55555554, 0x38e471c8, 0x2222eef0, 0x00555600,
  0x33339998, 0x2222eef0, 0x147b8520, 0x00333400,
  0x007fff00, 0x00555600, 0x00333400, 0x00008000,
  0x8002fffc, 0xaaab5558, 0xccccccd0, 0xff800200,
  0x8001fffe, 0xaaaaaaac, 0xcccc6668, 0xff800100,
  0x7fff0000, 0x55560000, 0x33340000, 0x00800000,
  0x7ffe0002, 0x55555554, 0x33339998, 0x007fff00,
  0x55555554, 0x38e471c8, 0x2222eef0, 0x00555600,
  0x33339998, 0x2222eef0, 0x147b8520, 0x00333400,
  0x007fff00, 0x00555600, 0x00333400, 0x00008000,
  0x007eff02, 0x0054ab54, 0x0032cd98, 0x00007f00,
  0x8001fffe, 0xaaaaaaac, 0xcccc6668, 0xff800100,
  0x7fff0000, 0x55560000, 0x33340000, 0x00800000,
  0x7ffe0002, 0x55555554, 0x33339998, 0x007fff00,
  0x55555554, 0x38e471c8, 0x2222eef0, 0x00555600,
  0x33339998, 0x2222eef0, 0x147b8520, 0x00333400,
  0x007fff00, 0x00555600, 0x00333400, 0x00008000,
  0x007eff02, 0x0054ab54, 0x0032cd98, 0x00007f00,
  0x007dff04, 0x005400a8, 0x00326730, 0x00007e00,
  0x7fff0000, 0x55560000, 0x33340000, 0x00800000,
  0x7ffe0002, 0x55555554, 0x33339998, 0x007fff00,
  0x55555554, 0x38e471c8, 0x2222eef0, 0x00555600,
  0x33339998, 0x2222eef0, 0x147b8520, 0x00333400,
  0x007fff00, 0x00555600, 0x00333400, 0x00008000,
  0x007eff02, 0x0054ab54, 0x0032cd98, 0x00007f00,
  0x007dff04, 0x005400a8, 0x00326730, 0x00007e00,
  0x007cff06, 0x005355fc, 0x003200c8, 0x00007d00,
  0x7ffe0002, 0x55555554, 0x33339998, 0x007fff00,
  0x55555554, 0x38e471c8, 0x2222eef0, 0x00555600,
  0x33339998, 0x2222eef0, 0x147b8520, 0x00333400,
  0x007fff00, 0x00555600, 0x00333400, 0x00008000,
  0x007eff02, 0x0054ab54, 0x0032cd98, 0x00007f00,
  0x007dff04, 0x005400a8, 0x00326730, 0x00007e00,
  0x007cff06, 0x005355fc, 0x003200c8, 0x00007d00,
  0x000fffe0, 0x000aaac0, 0x00066680, 0x00001000,
  0x55555554, 0x38e471c8, 0x2222eef0, 0x00555600,
  0x33339998, 0x2222eef0, 0x147b8520, 0x00333400,
  0x007fff00, 0x00555600, 0x00333400, 0x00008000,
  0x007eff02, 0x0054ab54, 0x0032cd98, 0x00007f00,
  0x007dff04, 0x005400a8, 0x00326730, 0x00007e00,
  0x007cff06, 0x005355fc, 0x003200c8, 0x00007d00,
  0x000fffe0, 0x000aaac0, 0x00066680, 0x00001000,
  0x0002fffa, 0x00020004, 0x00013338, 0x00000300,
  0x33339998, 0x2222eef0, 0x147b8520, 0x00333400,
  0x007fff00, 0x00555600, 0x00333400, 0x00008000,
  0x007eff02, 0x0054ab54, 0x0032cd98, 0x00007f00,
  0x007dff04, 0x005400a8, 0x00326730, 0x00007e00,
  0x007cff06, 0x005355fc, 0x003200c8, 0x00007d00,
  0x000fffe0, 0x000aaac0, 0x00066680, 0x00001000,
  0x0002fffa, 0x00020004, 0x00013338, 0x00000300,
  0x0001fffc, 0x00015558, 0x0000ccd0, 0x00000200,
  0x007fff00, 0x00555600, 0x00333400, 0x00008000,
  0x007eff02, 0x0054ab54, 0x0032cd98, 0x00007f00,
  0x007dff04, 0x005400a8, 0x00326730, 0x00007e00,
  0x007cff06, 0x005355fc, 0x003200c8, 0x00007d00,
  0x000fffe0, 0x000aaac0, 0x00066680, 0x00001000,
  0x0002fffa, 0x00020004, 0x00013338, 0x00000300,
  0x0001fffc, 0x00015558, 0x0000ccd0, 0x00000200,
  0x0000fffe, 0x0000aaac, 0x00006668, 0x00000100,
  0x0054ab54, 0x0032cd98, 0x00007f00, 0x00007e02,
  0x005400a8, 0x00326730, 0x00007e00, 0x00007d04,
  0x005355fc, 0x003200c8, 0x00007d00, 0x00007c06,
  0x000aaac0, 0x00066680, 0x00001000, 0x00000fe0,
  0x00020004, 0x00013338, 0x00000300, 0x000002fa,
  0x00015558, 0x0000ccd0, 0x00000200, 0x000001fc,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x005400a8, 0x00326730, 0x00007e00, 0x00007d04,
  0x005355fc, 0x003200c8, 0x00007d00, 0x00007c06,
  0x000aaac0, 0x00066680, 0x00001000, 0x00000fe0,
  0x00020004, 0x00013338, 0x00000300, 0x000002fa,
  0x00015558, 0x0000ccd0, 0x00000200, 0x000001fc,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0x005355fc, 0x003200c8, 0x00007d00, 0x00007c06,
  0x000aaac0, 0x00066680, 0x00001000, 0x00000fe0,
  0x00020004, 0x00013338, 0x00000300, 0x000002fa,
  0x00015558, 0x0000ccd0, 0x00000200, 0x000001fc,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0xfffeaaa8, 0xffff3330, 0xfffffe00, 0xfffffe04,
  0x000aaac0, 0x00066680, 0x00001000, 0x00000fe0,
  0x00020004, 0x00013338, 0x00000300, 0x000002fa,
  0x00015558, 0x0000ccd0, 0x00000200, 0x000001fc,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0xfffeaaa8, 0xffff3330, 0xfffffe00, 0xfffffe04,
  0xfff55540, 0xfff99980, 0xfffff000, 0xfffff020,
  0x00020004, 0x00013338, 0x00000300, 0x000002fa,
  0x00015558, 0x0000ccd0, 0x00000200, 0x000001fc,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0xfffeaaa8, 0xffff3330, 0xfffffe00, 0xfffffe04,
  0xfff55540, 0xfff99980, 0xfffff000, 0xfffff020,
  0xffacaa04, 0xffcdff38, 0xffff8300, 0xffff83fa,
  0x00015558, 0x0000ccd0, 0x00000200, 0x000001fc,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0xfffeaaa8, 0xffff3330, 0xfffffe00, 0xfffffe04,
  0xfff55540, 0xfff99980, 0xfffff000, 0xfffff020,
  0xffacaa04, 0xffcdff38, 0xffff8300, 0xffff83fa,
  0xffabff58, 0xffcd98d0, 0xffff8200, 0xffff82fc,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0xfffeaaa8, 0xffff3330, 0xfffffe00, 0xfffffe04,
  0xfff55540, 0xfff99980, 0xfffff000, 0xfffff020,
  0xffacaa04, 0xffcdff38, 0xffff8300, 0xffff83fa,
  0xffabff58, 0xffcd98d0, 0xffff8200, 0xffff82fc,
  0xffab54ac, 0xffcd3268, 0xffff8100, 0xffff81fe,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0xfffeaaa8, 0xffff3330, 0xfffffe00, 0xfffffe04,
  0xfff55540, 0xfff99980, 0xfffff000, 0xfffff020,
  0xffacaa04, 0xffcdff38, 0xffff8300, 0xffff83fa,
  0xffabff58, 0xffcd98d0, 0xffff8200, 0xffff82fc,
  0xffab54ac, 0xffcd3268, 0xffff8100, 0xffff81fe,
  0xddddbbbc, 0xeb84e148, 0xffcccd00, 0xffcd3366,
  0xffff5554, 0xffff9998, 0xffffff00, 0xffffff02,
  0xfffeaaa8, 0xffff3330, 0xfffffe00, 0xfffffe04,
  0xfff55540, 0xfff99980, 0xfffff000, 0xfffff020,
  0xffacaa04, 0xffcdff38, 0xffff8300, 0xffff83fa,
  0xffabff58, 0xffcd98d0, 0xffff8200, 0xffff82fc,
  0xffab54ac, 0xffcd3268, 0xffff8100, 0xffff81fe,
  0xddddbbbc, 0xeb84e148, 0xffcccd00, 0xffcd3366,
  0xc71c38e4, 0xdddd7778, 0xffaaab00, 0xffab55aa,
  0xfffeaaa8, 0xffff3330, 0xfffffe00, 0xfffffe04,
  0xfff55540, 0xfff99980, 0xfffff000, 0xfffff020,
  0xffacaa04, 0xffcdff38, 0xffff8300, 0xffff83fa,
  0xffabff58, 0xffcd98d0, 0xffff8200, 0xffff82fc,
  0xffab54ac, 0xffcd3268, 0xffff8100, 0xffff81fe,
  0xddddbbbc, 0xeb84e148, 0xffcccd00, 0xffcd3366,
  0xc71c38e4, 0xdddd7778, 0xffaaab00, 0xffab55aa,
  0xaaac0004, 0xcccd3338, 0xff800300, 0xff8102fa,
  0xfff55540, 0xfff99980, 0xfffff000, 0xfffff020,
  0xffacaa04, 0xffcdff38, 0xffff8300, 0xffff83fa,
  0xffabff58, 0xffcd98d0, 0xffff8200, 0xffff82fc,
  0xffab54ac, 0xffcd3268, 0xffff8100, 0xffff81fe,
  0xddddbbbc, 0xeb84e148, 0xffcccd00, 0xffcd3366,
  0xc71c38e4, 0xdddd7778, 0xffaaab00, 0xffab55aa,
  0xaaac0004, 0xcccd3338, 0xff800300, 0xff8102fa,
  0xaaab5558, 0xccccccd0, 0xff800200, 0xff8101fc,
  0xffacaa04, 0xffcdff38, 0xffff8300, 0xffff83fa,
  0xffabff58, 0xffcd98d0, 0xffff8200, 0xffff82fc,
  0xffab54ac, 0xffcd3268, 0xffff8100, 0xffff81fe,
  0xddddbbbc, 0xeb84e148, 0xffcccd00, 0xffcd3366,
  0xc71c38e4, 0xdddd7778, 0xffaaab00, 0xffab55aa,
  0xaaac0004, 0xcccd3338, 0xff800300, 0xff8102fa,
  0xaaab5558, 0xccccccd0, 0xff800200, 0xff8101fc,
  0xaaaaaaac, 0xcccc6668, 0xff800100, 0xff8100fe,
  0xffabff58, 0xffcd98d0, 0xffff8200, 0xffff82fc,
  0xffab54ac, 0xffcd3268, 0xffff8100, 0xffff81fe,
  0xddddbbbc, 0xeb84e148, 0xffcccd00, 0xffcd3366,
  0xc71c38e4, 0xdddd7778, 0xffaaab00, 0xffab55aa,
  0xaaac0004, 0xcccd3338, 0xff800300, 0xff8102fa,
  0xaaab5558, 0xccccccd0, 0xff800200, 0xff8101fc,
  0xaaaaaaac, 0xcccc6668, 0xff800100, 0xff8100fe,
  0x55560000, 0x33340000, 0x00800000, 0x007f0000,
  0xffab54ac, 0xffcd3268, 0xffff8100, 0xffff81fe,
  0xddddbbbc, 0xeb84e148, 0xffcccd00, 0xffcd3366,
  0xc71c38e4, 0xdddd7778, 0xffaaab00, 0xffab55aa,
  0xaaac0004, 0xcccd3338, 0xff800300, 0xff8102fa,
  0xaaab5558, 0xccccccd0, 0xff800200, 0xff8101fc,
  0xaaaaaaac, 0xcccc6668, 0xff800100, 0xff8100fe,
  0x55560000, 0x33340000, 0x00800000, 0x007f0000,
  0x55555554, 0x33339998, 0x007fff00, 0x007eff02,
  0xddddbbbc, 0xeb84e148, 0xffcccd00, 0xffcd3366,
  0xc71c38e4, 0xdddd7778, 0xffaaab00, 0xffab55aa,
  0xaaac0004, 0xcccd3338, 0xff800300, 0xff8102fa,
  0xaaab5558, 0xccccccd0, 0xff800200, 0xff8101fc,
  0xaaaaaaac, 0xcccc6668, 0xff800100, 0xff8100fe,
  0x55560000, 0x33340000, 0x00800000, 0x007f0000,
  0x55555554, 0x33339998, 0x007fff00, 0x007eff02,
  0x38e471c8, 0x2222eef0, 0x00555600, 0x0054ab54,
  0xc71c38e4, 0xdddd7778, 0xffaaab00, 0xffab55aa,
  0xaaac0004, 0xcccd3338, 0xff800300, 0xff8102fa,
  0xaaab5558, 0xccccccd0, 0xff800200, 0xff8101fc,
  0xaaaaaaac, 0xcccc6668, 0xff800100, 0xff8100fe,
  0x55560000, 0x33340000, 0x00800000, 0x007f0000,
  0x55555554, 0x33339998, 0x007fff00, 0x007eff02,
  0x38e471c8, 0x2222eef0, 0x00555600, 0x0054ab54,
  0x2222eef0, 0x147b8520, 0x00333400, 0x0032cd98,
  0xaaac0004, 0xcccd3338, 0xff800300, 0xff8102fa,
  0xaaab5558, 0xccccccd0, 0xff800200, 0xff8101fc,
  0xaaaaaaac, 0xcccc6668, 0xff800100, 0xff8100fe,
  0x55560000, 0x33340000, 0x00800000, 0x007f0000,
  0x55555554, 0x33339998, 0x007fff00, 0x007eff02,
  0x38e471c8, 0x2222eef0, 0x00555600, 0x0054ab54,
  0x2222eef0, 0x147b8520, 0x00333400, 0x0032cd98,
  0x00555600, 0x00333400, 0x00008000, 0x00007f00,
  0xaaab5558, 0xccccccd0, 0xff800200, 0xff8101fc,
  0xaaaaaaac, 0xcccc6668, 0xff800100, 0xff8100fe,
  0x55560000, 0x33340000, 0x00800000, 0x007f0000,
  0x55555554, 0x33339998, 0x007fff00, 0x007eff02,
  0x38e471c8, 0x2222eef0, 0x00555600, 0x0054ab54,
  0x2222eef0, 0x147b8520, 0x00333400, 0x0032cd98,
  0x00555600, 0x00333400, 0x00008000, 0x00007f00,
  0x0054ab54, 0x0032cd98, 0x00007f00, 0x00007e02,
  0xaaaaaaac, 0xcccc6668, 0xff800100, 0xff8100fe,
  0x55560000, 0x33340000, 0x00800000, 0x007f0000,
  0x55555554, 0x33339998, 0x007fff00, 0x007eff02,
  0x38e471c8, 0x2222eef0, 0x00555600, 0x0054ab54,
  0x2222eef0, 0x147b8520, 0x00333400, 0x0032cd98,
  0x00555600, 0x00333400, 0x00008000, 0x00007f00,
  0x0054ab54, 0x0032cd98, 0x00007f00, 0x00007e02,
  0x005400a8, 0x00326730, 0x00007e00, 0x00007d04,
  0x55560000, 0x33340000, 0x00800000, 0x007f0000,
  0x55555554, 0x33339998, 0x007fff00, 0x007eff02,
  0x38e471c8, 0x2222eef0, 0x00555600, 0x0054ab54,
  0x2222eef0, 0x147b8520, 0x00333400, 0x0032cd98,
  0x00555600, 0x00333400, 0x00008000, 0x00007f00,
  0x0054ab54, 0x0032cd98, 0x00007f00, 0x00007e02,
  0x005400a8, 0x00326730, 0x00007e00, 0x00007d04,
  0x005355fc, 0x003200c8, 0x00007d00, 0x00007c06,
  0x55555554, 0x33339998, 0x007fff00, 0x007eff02,
  0x38e471c8, 0x2222eef0, 0x00555600, 0x0054ab54,
  0x2222eef0, 0x147b8520, 0x00333400, 0x0032cd98,
  0x00555600, 0x00333400, 0x00008000, 0x00007f00,
  0x0054ab54, 0x0032cd98, 0x00007f00, 0x00007e02,
  0x005400a8, 0x00326730, 0x00007e00, 0x00007d04,
  0x005355fc, 0x003200c8, 0x00007d00, 0x00007c06,
  0x000aaac0, 0x00066680, 0x00001000, 0x00000fe0,
  0x38e471c8, 0x2222eef0, 0x00555600, 0x0054ab54,
  0x2222eef0, 0x147b8520, 0x00333400, 0x0032cd98,
  0x00555600, 0x00333400, 0x00008000, 0x00007f00,
  0x0054ab54, 0x0032cd98, 0x00007f00, 0x00007e02,
  0x005400a8, 0x00326730, 0x00007e00, 0x00007d04,
  0x005355fc, 0x003200c8, 0x00007d00, 0x00007c06,
  0x000aaac0, 0x00066680, 0x00001000, 0x00000fe0,
  0x00020004, 0x00013338, 0x00000300, 0x000002fa,
  0x2222eef0, 0x147b8520, 0x00333400, 0x0032cd98,
  0x00555600, 0x00333400, 0x00008000, 0x00007f00,
  0x0054ab54, 0x0032cd98, 0x00007f00, 0x00007e02,
  0x005400a8, 0x00326730, 0x00007e00, 0x00007d04,
  0x005355fc, 0x003200c8, 0x00007d00, 0x00007c06,
  0x000aaac0, 0x00066680, 0x00001000, 0x00000fe0,
  0x00020004, 0x00013338, 0x00000300, 0x000002fa,
  0x00015558, 0x0000ccd0, 0x00000200, 0x000001fc,
  0x00555600, 0x00333400, 0x00008000, 0x00007f00,
  0x0054ab54, 0x0032cd98, 0x00007f00, 0x00007e02,
  0x005400a8, 0x00326730, 0x00007e00, 0x00007d04,
  0x005355fc, 0x003200c8, 0x00007d00, 0x00007c06,
  0x000aaac0, 0x00066680, 0x00001000, 0x00000fe0,
  0x00020004, 0x00013338, 0x00000300, 0x000002fa,
  0x00015558, 0x0000ccd0, 0x00000200, 0x000001fc,
  0x0000aaac, 0x00006668, 0x00000100, 0x000000fe,
  0x0032cd98, 0x00007f00, 0x00007e02, 0x00007d04,
  0x00326730, 0x00007e00, 0x00007d04, 0x00007c08,
  0x003200c8, 0x00007d00, 0x00007c06, 0x00007b0c,
  0x00066680, 0x00001000, 0x00000fe0, 0x00000fc0,
  0x00013338, 0x00000300, 0x000002fa, 0x000002f4,
  0x0000ccd0, 0x00000200, 0x000001fc, 0x000001f8,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00326730, 0x00007e00, 0x00007d04, 0x00007c08,
  0x003200c8, 0x00007d00, 0x00007c06, 0x00007b0c,
  0x00066680, 0x00001000, 0x00000fe0, 0x00000fc0,
  0x00013338, 0x00000300, 0x000002fa, 0x000002f4,
  0x0000ccd0, 0x00000200, 0x000001fc, 0x000001f8,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0x003200c8, 0x00007d00, 0x00007c06, 0x00007b0c,
  0x00066680, 0x00001000, 0x00000fe0, 0x00000fc0,
  0x00013338, 0x00000300, 0x000002fa, 0x000002f4,
  0x0000ccd0, 0x00000200, 0x000001fc, 0x000001f8,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0xffff3330, 0xfffffe00, 0xfffffe04, 0xfffffe08,
  0x00066680, 0x00001000, 0x00000fe0, 0x00000fc0,
  0x00013338, 0x00000300, 0x000002fa, 0x000002f4,
  0x0000ccd0, 0x00000200, 0x000001fc, 0x000001f8,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0xffff3330, 0xfffffe00, 0xfffffe04, 0xfffffe08,
  0xfff99980, 0xfffff000, 0xfffff020, 0xfffff040,
  0x00013338, 0x00000300, 0x000002fa, 0x000002f4,
  0x0000ccd0, 0x00000200, 0x000001fc, 0x000001f8,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0xffff3330, 0xfffffe00, 0xfffffe04, 0xfffffe08,
  0xfff99980, 0xfffff000, 0xfffff020, 0xfffff040,
  0xffcdff38, 0xffff8300, 0xffff83fa, 0xffff84f4,
  0x0000ccd0, 0x00000200, 0x000001fc, 0x000001f8,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0xffff3330, 0xfffffe00, 0xfffffe04, 0xfffffe08,
  0xfff99980, 0xfffff000, 0xfffff020, 0xfffff040,
  0xffcdff38, 0xffff8300, 0xffff83fa, 0xffff84f4,
  0xffcd98d0, 0xffff8200, 0xffff82fc, 0xffff83f8,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0xffff3330, 0xfffffe00, 0xfffffe04, 0xfffffe08,
  0xfff99980, 0xfffff000, 0xfffff020, 0xfffff040,
  0xffcdff38, 0xffff8300, 0xffff83fa, 0xffff84f4,
  0xffcd98d0, 0xffff8200, 0xffff82fc, 0xffff83f8,
  0xffcd3268, 0xffff8100, 0xffff81fe, 0xffff82fc,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0xffff3330, 0xfffffe00, 0xfffffe04, 0xfffffe08,
  0xfff99980, 0xfffff000, 0xfffff020, 0xfffff040,
  0xffcdff38, 0xffff8300, 0xffff83fa, 0xffff84f4,
  0xffcd98d0, 0xffff8200, 0xffff82fc, 0xffff83f8,
  0xffcd3268, 0xffff8100, 0xffff81fe, 0xffff82fc,
  0xeb84e148, 0xffcccd00, 0xffcd3366, 0xffcd99cc,
  0xffff9998, 0xffffff00, 0xffffff02, 0xffffff04,
  0xffff3330, 0xfffffe00, 0xfffffe04, 0xfffffe08,
  0xfff99980, 0xfffff000, 0xfffff020, 0xfffff040,
  0xffcdff38, 0xffff8300, 0xffff83fa, 0xffff84f4,
  0xffcd98d0, 0xffff8200, 0xffff82fc, 0xffff83f8,
  0xffcd3268, 0xffff8100, 0xffff81fe, 0xffff82fc,
  0xeb84e148, 0xffcccd00, 0xffcd3366, 0xffcd99cc,
  0xdddd7778, 0xffaaab00, 0xffab55aa, 0xffac0054,
  0xffff3330, 0xfffffe00, 0xfffffe04, 0xfffffe08,
  0xfff99980, 0xfffff000, 0xfffff020, 0xfffff040,
  0xffcdff38, 0xffff8300, 0xffff83fa, 0xffff84f4,
  0xffcd98d0, 0xffff8200, 0xffff82fc, 0xffff83f8,
  0xffcd3268, 0xffff8100, 0xffff81fe, 0xffff82fc,
  0xeb84e148, 0xffcccd00, 0xffcd3366, 0xffcd99cc,
  0xdddd7778, 0xffaaab00, 0xffab55aa, 0xffac0054,
  0xcccd3338, 0xff800300, 0xff8102fa, 0xff8202f4,
  0xfff99980, 0xfffff000, 0xfffff020, 0xfffff040,
  0xffcdff38, 0xffff8300, 0xffff83fa, 0xffff84f4,
  0xffcd98d0, 0xffff8200, 0xffff82fc, 0xffff83f8,
  0xffcd3268, 0xffff8100, 0xffff81fe, 0xffff82fc,
  0xeb84e148, 0xffcccd00, 0xffcd3366, 0xffcd99cc,
  0xdddd7778, 0xffaaab00, 0xffab55aa, 0xffac0054,
  0xcccd3338, 0xff800300, 0xff8102fa, 0xff8202f4,
  0xccccccd0, 0xff800200, 0xff8101fc, 0xff8201f8,
  0xffcdff38, 0xffff8300, 0xffff83fa, 0xffff84f4,
  0xffcd98d0, 0xffff8200, 0xffff82fc, 0xffff83f8,
  0xffcd3268, 0xffff8100, 0xffff81fe, 0xffff82fc,
  0xeb84e148, 0xffcccd00, 0xffcd3366, 0xffcd99cc,
  0xdddd7778, 0xffaaab00, 0xffab55aa, 0xffac0054,
  0xcccd3338, 0xff800300, 0xff8102fa, 0xff8202f4,
  0xccccccd0, 0xff800200, 0xff8101fc, 0xff8201f8,
  0xcccc6668, 0xff800100, 0xff8100fe, 0xff8200fc,
  0xffcd98d0, 0xffff8200, 0xffff82fc, 0xffff83f8,
  0xffcd3268, 0xffff8100, 0xffff81fe, 0xffff82fc,
  0xeb84e148, 0xffcccd00, 0xffcd3366, 0xffcd99cc,
  0xdddd7778, 0xffaaab00, 0xffab55aa, 0xffac0054,
  0xcccd3338, 0xff800300, 0xff8102fa, 0xff8202f4,
  0xccccccd0, 0xff800200, 0xff8101fc, 0xff8201f8,
  0xcccc6668, 0xff800100, 0xff8100fe, 0xff8200fc,
  0x33340000, 0x00800000, 0x007f0000, 0x007e0000,
  0xffcd3268, 0xffff8100, 0xffff81fe, 0xffff82fc,
  0xeb84e148, 0xffcccd00, 0xffcd3366, 0xffcd99cc,
  0xdddd7778, 0xffaaab00, 0xffab55aa, 0xffac0054,
  0xcccd3338, 0xff800300, 0xff8102fa, 0xff8202f4,
  0xccccccd0, 0xff800200, 0xff8101fc, 0xff8201f8,
  0xcccc6668, 0xff800100, 0xff8100fe, 0xff8200fc,
  0x33340000, 0x00800000, 0x007f0000, 0x007e0000,
  0x33339998, 0x007fff00, 0x007eff02, 0x007dff04,
  0xeb84e148, 0xffcccd00, 0xffcd3366, 0xffcd99cc,
  0xdddd7778, 0xffaaab00, 0xffab55aa, 0xffac0054,
  0xcccd3338, 0xff800300, 0xff8102fa, 0xff8202f4,
  0xccccccd0, 0xff800200, 0xff8101fc, 0xff8201f8,
  0xcccc6668, 0xff800100, 0xff8100fe, 0xff8200fc,
  0x33340000, 0x00800000, 0x007f0000, 0x007e0000,
  0x33339998, 0x007fff00, 0x007eff02, 0x007dff04,
  0x2222eef0, 0x00555600, 0x0054ab54, 0x005400a8,
  0xdddd7778, 0xffaaab00, 0xffab55aa, 0xffac0054,
  0xcccd3338, 0xff800300, 0xff8102fa, 0xff8202f4,
  0xccccccd0, 0xff800200, 0xff8101fc, 0xff8201f8,
  0xcccc6668, 0xff800100, 0xff8100fe, 0xff8200fc,
  0x33340000, 0x00800000, 0x007f0000, 0x007e0000,
  0x33339998, 0x007fff00, 0x007eff02, 0x007dff04,
  0x2222eef0, 0x00555600, 0x0054ab54, 0x005400a8,
  0x147b8520, 0x00333400, 0x0032cd98, 0x00326730,
  0xcccd3338, 0xff800300, 0xff8102fa, 0xff8202f4,
  0xccccccd0, 0xff800200, 0xff8101fc, 0xff8201f8,
  0xcccc6668, 0xff800100, 0xff8100fe, 0xff8200fc,
  0x33340000, 0x00800000, 0x007f0000, 0x007e0000,
  0x33339998, 0x007fff00, 0x007eff02, 0x007dff04,
  0x2222eef0, 0x00555600, 0x0054ab54, 0x005400a8,
  0x147b8520, 0x00333400, 0x0032cd98, 0x00326730,
  0x00333400, 0x00008000, 0x00007f00, 0x00007e00,
  0xccccccd0, 0xff800200, 0xff8101fc, 0xff8201f8,
  0xcccc6668, 0xff800100, 0xff8100fe, 0xff8200fc,
  0x33340000, 0x00800000, 0x007f0000, 0x007e0000,
  0x33339998, 0x007fff00, 0x007eff02, 0x007dff04,
  0x2222eef0, 0x00555600, 0x0054ab54, 0x005400a8,
  0x147b8520, 0x00333400, 0x0032cd98, 0x00326730,
  0x00333400, 0x00008000, 0x00007f00, 0x00007e00,
  0x0032cd98, 0x00007f00, 0x00007e02, 0x00007d04,
  0xcccc6668, 0xff800100, 0xff8100fe, 0xff8200fc,
  0x33340000, 0x00800000, 0x007f0000, 0x007e0000,
  0x33339998, 0x007fff00, 0x007eff02, 0x007dff04,
  0x2222eef0, 0x00555600, 0x0054ab54, 0x005400a8,
  0x147b8520, 0x00333400, 0x0032cd98, 0x00326730,
  0x00333400, 0x00008000, 0x00007f00, 0x00007e00,
  0x0032cd98, 0x00007f00, 0x00007e02, 0x00007d04,
  0x00326730, 0x00007e00, 0x00007d04, 0x00007c08,
  0x33340000, 0x00800000, 0x007f0000, 0x007e0000,
  0x33339998, 0x007fff00, 0x007eff02, 0x007dff04,
  0x2222eef0, 0x00555600, 0x0054ab54, 0x005400a8,
  0x147b8520, 0x00333400, 0x0032cd98, 0x00326730,
  0x00333400, 0x00008000, 0x00007f00, 0x00007e00,
  0x0032cd98, 0x00007f00, 0x00007e02, 0x00007d04,
  0x00326730, 0x00007e00, 0x00007d04, 0x00007c08,
  0x003200c8, 0x00007d00, 0x00007c06, 0x00007b0c,
  0x33339998, 0x007fff00, 0x007eff02, 0x007dff04,
  0x2222eef0, 0x00555600, 0x0054ab54, 0x005400a8,
  0x147b8520, 0x00333400, 0x0032cd98, 0x00326730,
  0x00333400, 0x00008000, 0x00007f00, 0x00007e00,
  0x0032cd98, 0x00007f00, 0x00007e02, 0x00007d04,
  0x00326730, 0x00007e00, 0x00007d04, 0x00007c08,
  0x003200c8, 0x00007d00, 0x00007c06, 0x00007b0c,
  0x00066680, 0x00001000, 0x00000fe0, 0x00000fc0,
  0x2222eef0, 0x00555600, 0x0054ab54, 0x005400a8,
  0x147b8520, 0x00333400, 0x0032cd98, 0x00326730,
  0x00333400, 0x00008000, 0x00007f00, 0x00007e00,
  0x0032cd98, 0x00007f00, 0x00007e02, 0x00007d04,
  0x00326730, 0x00007e00, 0x00007d04, 0x00007c08,
  0x003200c8, 0x00007d00, 0x00007c06, 0x00007b0c,
  0x00066680, 0x00001000, 0x00000fe0, 0x00000fc0,
  0x00013338, 0x00000300, 0x000002fa, 0x000002f4,
  0x147b8520, 0x00333400, 0x0032cd98, 0x00326730,
  0x00333400, 0x00008000, 0x00007f00, 0x00007e00,
  0x0032cd98, 0x00007f00, 0x00007e02, 0x00007d04,
  0x00326730, 0x00007e00, 0x00007d04, 0x00007c08,
  0x003200c8, 0x00007d00, 0x00007c06, 0x00007b0c,
  0x00066680, 0x00001000, 0x00000fe0, 0x00000fc0,
  0x00013338, 0x00000300, 0x000002fa, 0x000002f4,
  0x0000ccd0, 0x00000200, 0x000001fc, 0x000001f8,
  0x00333400, 0x00008000, 0x00007f00, 0x00007e00,
  0x0032cd98, 0x00007f00, 0x00007e02, 0x00007d04,
  0x00326730, 0x00007e00, 0x00007d04, 0x00007c08,
  0x003200c8, 0x00007d00, 0x00007c06, 0x00007b0c,
  0x00066680, 0x00001000, 0x00000fe0, 0x00000fc0,
  0x00013338, 0x00000300, 0x000002fa, 0x000002f4,
  0x0000ccd0, 0x00000200, 0x000001fc, 0x000001f8,
  0x00006668, 0x00000100, 0x000000fe, 0x000000fc,
  0x00007f00, 0x00007e02, 0x00007d04, 0x00007c06,
  0x00007e00, 0x00007d04, 0x00007c08, 0x00007b0c,
  0x00007d00, 0x00007c06, 0x00007b0c, 0x00007a12,
  0x00001000, 0x00000fe0, 0x00000fc0, 0x00000fa0,
  0x00000300, 0x000002fa, 0x000002f4, 0x000002ee,
  0x00000200, 0x000001fc, 0x000001f8, 0x000001f4,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00007e00, 0x00007d04, 0x00007c08, 0x00007b0c,
  0x00007d00, 0x00007c06, 0x00007b0c, 0x00007a12,
  0x00001000, 0x00000fe0, 0x00000fc0, 0x00000fa0,
  0x00000300, 0x000002fa, 0x000002f4, 0x000002ee,
  0x00000200, 0x000001fc, 0x000001f8, 0x000001f4,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0x00007d00, 0x00007c06, 0x00007b0c, 0x00007a12,
  0x00001000, 0x00000fe0, 0x00000fc0, 0x00000fa0,
  0x00000300, 0x000002fa, 0x000002f4, 0x000002ee,
  0x00000200, 0x000001fc, 0x000001f8, 0x000001f4,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0xfffffe00, 0xfffffe04, 0xfffffe08, 0xfffffe0c,
  0x00001000, 0x00000fe0, 0x00000fc0, 0x00000fa0,
  0x00000300, 0x000002fa, 0x000002f4, 0x000002ee,
  0x00000200, 0x000001fc, 0x000001f8, 0x000001f4,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0xfffffe00, 0xfffffe04, 0xfffffe08, 0xfffffe0c,
  0xfffff000, 0xfffff020, 0xfffff040, 0xfffff060,
  0x00000300, 0x000002fa, 0x000002f4, 0x000002ee,
  0x00000200, 0x000001fc, 0x000001f8, 0x000001f4,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0xfffffe00, 0xfffffe04, 0xfffffe08, 0xfffffe0c,
  0xfffff000, 0xfffff020, 0xfffff040, 0xfffff060,
  0xffff8300, 0xffff83fa, 0xffff84f4, 0xffff85ee,
  0x00000200, 0x000001fc, 0x000001f8, 0x000001f4,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0xfffffe00, 0xfffffe04, 0xfffffe08, 0xfffffe0c,
  0xfffff000, 0xfffff020, 0xfffff040, 0xfffff060,
  0xffff8300, 0xffff83fa, 0xffff84f4, 0xffff85ee,
  0xffff8200, 0xffff82fc, 0xffff83f8, 0xffff84f4,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0xfffffe00, 0xfffffe04, 0xfffffe08, 0xfffffe0c,
  0xfffff000, 0xfffff020, 0xfffff040, 0xfffff060,
  0xffff8300, 0xffff83fa, 0xffff84f4, 0xffff85ee,
  0xffff8200, 0xffff82fc, 0xffff83f8, 0xffff84f4,
  0xffff8100, 0xffff81fe, 0xffff82fc, 0xffff83fa,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0xfffffe00, 0xfffffe04, 0xfffffe08, 0xfffffe0c,
  0xfffff000, 0xfffff020, 0xfffff040, 0xfffff060,
  0xffff8300, 0xffff83fa, 0xffff84f4, 0xffff85ee,
  0xffff8200, 0xffff82fc, 0xffff83f8, 0xffff84f4,
  0xffff8100, 0xffff81fe, 0xffff82fc, 0xffff83fa,
  0xffcccd00, 0xffcd3366, 0xffcd99cc, 0xffce0032,
  0xffffff00, 0xffffff02, 0xffffff04, 0xffffff06,
  0xfffffe00, 0xfffffe04, 0xfffffe08, 0xfffffe0c,
  0xfffff000, 0xfffff020, 0xfffff040, 0xfffff060,
  0xffff8300, 0xffff83fa, 0xffff84f4, 0xffff85ee,
  0xffff8200, 0xffff82fc, 0xffff83f8, 0xffff84f4,
  0xffff8100, 0xffff81fe, 0xffff82fc, 0xffff83fa,
  0xffcccd00, 0xffcd3366, 0xffcd99cc, 0xffce0032,
  0xffaaab00, 0xffab55aa, 0xffac0054, 0xffacaafe,
  0xfffffe00, 0xfffffe04, 0xfffffe08, 0xfffffe0c,
  0xfffff000, 0xfffff020, 0xfffff040, 0xfffff060,
  0xffff8300, 0xffff83fa, 0xffff84f4, 0xffff85ee,
  0xffff8200, 0xffff82fc, 0xffff83f8, 0xffff84f4,
  0xffff8100, 0xffff81fe, 0xffff82fc, 0xffff83fa,
  0xffcccd00, 0xffcd3366, 0xffcd99cc, 0xffce0032,
  0xffaaab00, 0xffab55aa, 0xffac0054, 0xffacaafe,
  0xff800300, 0xff8102fa, 0xff8202f4, 0xff8302ee,
  0xfffff000, 0xfffff020, 0xfffff040, 0xfffff060,
  0xffff8300, 0xffff83fa, 0xffff84f4, 0xffff85ee,
  0xffff8200, 0xffff82fc, 0xffff83f8, 0xffff84f4,
  0xffff8100, 0xffff81fe, 0xffff82fc, 0xffff83fa,
  0xffcccd00, 0xffcd3366, 0xffcd99cc, 0xffce0032,
  0xffaaab00, 0xffab55aa, 0xffac0054, 0xffacaafe,
  0xff800300, 0xff8102fa, 0xff8202f4, 0xff8302ee,
  0xff800200, 0xff8101fc, 0xff8201f8, 0xff8301f4,
  0xffff8300, 0xffff83fa, 0xffff84f4, 0xffff85ee,
  0xffff8200, 0xffff82fc, 0xffff83f8, 0xffff84f4,
  0xffff8100, 0xffff81fe, 0xffff82fc, 0xffff83fa,
  0xffcccd00, 0xffcd3366, 0xffcd99cc, 0xffce0032,
  0xffaaab00, 0xffab55aa, 0xffac0054, 0xffacaafe,
  0xff800300, 0xff8102fa, 0xff8202f4, 0xff8302ee,
  0xff800200, 0xff8101fc, 0xff8201f8, 0xff8301f4,
  0xff800100, 0xff8100fe, 0xff8200fc, 0xff8300fa,
  0xffff8200, 0xffff82fc, 0xffff83f8, 0xffff84f4,
  0xffff8100, 0xffff81fe, 0xffff82fc, 0xffff83fa,
  0xffcccd00, 0xffcd3366, 0xffcd99cc, 0xffce0032,
  0xffaaab00, 0xffab55aa, 0xffac0054, 0xffacaafe,
  0xff800300, 0xff8102fa, 0xff8202f4, 0xff8302ee,
  0xff800200, 0xff8101fc, 0xff8201f8, 0xff8301f4,
  0xff800100, 0xff8100fe, 0xff8200fc, 0xff8300fa,
  0x00800000, 0x007f0000, 0x007e0000, 0x007d0000,
  0xffff8100, 0xffff81fe, 0xffff82fc, 0xffff83fa,
  0xffcccd00, 0xffcd3366, 0xffcd99cc, 0xffce0032,
  0xffaaab00, 0xffab55aa, 0xffac0054, 0xffacaafe,
  0xff800300, 0xff8102fa, 0xff8202f4, 0xff8302ee,
  0xff800200, 0xff8101fc, 0xff8201f8, 0xff8301f4,
  0xff800100, 0xff8100fe, 0xff8200fc, 0xff8300fa,
  0x00800000, 0x007f0000, 0x007e0000, 0x007d0000,
  0x007fff00, 0x007eff02, 0x007dff04, 0x007cff06,
  0xffcccd00, 0xffcd3366, 0xffcd99cc, 0xffce0032,
  0xffaaab00, 0xffab55aa, 0xffac0054, 0xffacaafe,
  0xff800300, 0xff8102fa, 0xff8202f4, 0xff8302ee,
  0xff800200, 0xff8101fc, 0xff8201f8, 0xff8301f4,
  0xff800100, 0xff8100fe, 0xff8200fc, 0xff8300fa,
  0x00800000, 0x007f0000, 0x007e0000, 0x007d0000,
  0x007fff00, 0x007eff02, 0x007dff04, 0x007cff06,
  0x00555600, 0x0054ab54, 0x005400a8, 0x005355fc,
  0xffaaab00, 0xffab55aa, 0xffac0054, 0xffacaafe,
  0xff800300, 0xff8102fa, 0xff8202f4, 0xff8302ee,
  0xff800200, 0xff8101fc, 0xff8201f8, 0xff8301f4,
  0xff800100, 0xff8100fe, 0xff8200fc, 0xff8300fa,
  0x00800000, 0x007f0000, 0x007e0000, 0x007d0000,
  0x007fff00, 0x007eff02, 0x007dff04, 0x007cff06,
  0x00555600, 0x0054ab54, 0x005400a8, 0x005355fc,
  0x00333400, 0x0032cd98, 0x00326730, 0x003200c8,
  0xff800300, 0xff8102fa, 0xff8202f4, 0xff8302ee,
  0xff800200, 0xff8101fc, 0xff8201f8, 0xff8301f4,
  0xff800100, 0xff8100fe, 0xff8200fc, 0xff8300fa,
  0x00800000, 0x007f0000, 0x007e0000, 0x007d0000,
  0x007fff00, 0x007eff02, 0x007dff04, 0x007cff06,
  0x00555600, 0x0054ab54, 0x005400a8, 0x005355fc,
  0x00333400, 0x0032cd98, 0x00326730, 0x003200c8,
  0x00008000, 0x00007f00, 0x00007e00, 0x00007d00,
  0xff800200, 0xff8101fc, 0xff8201f8, 0xff8301f4,
  0xff800100, 0xff8100fe, 0xff8200fc, 0xff8300fa,
  0x00800000, 0x007f0000, 0x007e0000, 0x007d0000,
  0x007fff00, 0x007eff02, 0x007dff04, 0x007cff06,
  0x00555600, 0x0054ab54, 0x005400a8, 0x005355fc,
  0x00333400, 0x0032cd98, 0x00326730, 0x003200c8,
  0x00008000, 0x00007f00, 0x00007e00, 0x00007d00,
  0x00007f00, 0x00007e02, 0x00007d04, 0x00007c06,
  0xff800100, 0xff8100fe, 0xff8200fc, 0xff8300fa,
  0x00800000, 0x007f0000, 0x007e0000, 0x007d0000,
  0x007fff00, 0x007eff02, 0x007dff04, 0x007cff06,
  0x00555600, 0x0054ab54, 0x005400a8, 0x005355fc,
  0x00333400, 0x0032cd98, 0x00326730, 0x003200c8,
  0x00008000, 0x00007f00, 0x00007e00, 0x00007d00,
  0x00007f00, 0x00007e02, 0x00007d04, 0x00007c06,
  0x00007e00, 0x00007d04, 0x00007c08, 0x00007b0c,
  0x00800000, 0x007f0000, 0x007e0000, 0x007d0000,
  0x007fff00, 0x007eff02, 0x007dff04, 0x007cff06,
  0x00555600, 0x0054ab54, 0x005400a8, 0x005355fc,
  0x00333400, 0x0032cd98, 0x00326730, 0x003200c8,
  0x00008000, 0x00007f00, 0x00007e00, 0x00007d00,
  0x00007f00, 0x00007e02, 0x00007d04, 0x00007c06,
  0x00007e00, 0x00007d04, 0x00007c08, 0x00007b0c,
  0x00007d00, 0x00007c06, 0x00007b0c, 0x00007a12,
  0x007fff00, 0x007eff02, 0x007dff04, 0x007cff06,
  0x00555600, 0x0054ab54, 0x005400a8, 0x005355fc,
  0x00333400, 0x0032cd98, 0x00326730, 0x003200c8,
  0x00008000, 0x00007f00, 0x00007e00, 0x00007d00,
  0x00007f00, 0x00007e02, 0x00007d04, 0x00007c06,
  0x00007e00, 0x00007d04, 0x00007c08, 0x00007b0c,
  0x00007d00, 0x00007c06, 0x00007b0c, 0x00007a12,
  0x00001000, 0x00000fe0, 0x00000fc0, 0x00000fa0,
  0x00555600, 0x0054ab54, 0x005400a8, 0x005355fc,
  0x00333400, 0x0032cd98, 0x00326730, 0x003200c8,
  0x00008000, 0x00007f00, 0x00007e00, 0x00007d00,
  0x00007f00, 0x00007e02, 0x00007d04, 0x00007c06,
  0x00007e00, 0x00007d04, 0x00007c08, 0x00007b0c,
  0x00007d00, 0x00007c06, 0x00007b0c, 0x00007a12,
  0x00001000, 0x00000fe0, 0x00000fc0, 0x00000fa0,
  0x00000300, 0x000002fa, 0x000002f4, 0x000002ee,
  0x00333400, 0x0032cd98, 0x00326730, 0x003200c8,
  0x00008000, 0x00007f00, 0x00007e00, 0x00007d00,
  0x00007f00, 0x00007e02, 0x00007d04, 0x00007c06,
  0x00007e00, 0x00007d04, 0x00007c08, 0x00007b0c,
  0x00007d00, 0x00007c06, 0x00007b0c, 0x00007a12,
  0x00001000, 0x00000fe0, 0x00000fc0, 0x00000fa0,
  0x00000300, 0x000002fa, 0x000002f4, 0x000002ee,
  0x00000200, 0x000001fc, 0x000001f8, 0x000001f4,
  0x00008000, 0x00007f00, 0x00007e00, 0x00007d00,
  0x00007f00, 0x00007e02, 0x00007d04, 0x00007c06,
  0x00007e00, 0x00007d04, 0x00007c08, 0x00007b0c,
  0x00007d00, 0x00007c06, 0x00007b0c, 0x00007a12,
  0x00001000, 0x00000fe0, 0x00000fc0, 0x00000fa0,
  0x00000300, 0x000002fa, 0x000002f4, 0x000002ee,
  0x00000200, 0x000001fc, 0x000001f8, 0x000001f4,
  0x00000100, 0x000000fe, 0x000000fc, 0x000000fa,
};
const unsigned kExpectedCount_NEON_sqdmull_4S_4H_H = 4608;

#endif  // VIXL_SIM_SQDMULL_4S_4H_H_TRACE_AARCH64_H_
