// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_FMAXNM_8H_TRACE_AARCH64_H_
#define VIXL_SIM_FMAXNM_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_fmaxnm_8H[] = {
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0x7f23, 0x7f23, 0x7f23, 0x7e01, 0x03ff, 0x03ff, 0x0001, 0x0400,
  0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0400, 0x37ff,
  0x7e01, 0x0012, 0x7f23, 0x7e01, 0x0012, 0x0400, 0x37ff, 0x3800,
  0x0012, 0x03ff, 0x7f23, 0x7e01, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x03ff, 0x0001, 0x7f23, 0x7e01, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x0001, 0x0000, 0x7f23, 0x7e01, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0000, 0x0400, 0x7f23, 0x7e01, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x7f23, 0x7e01, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x7f23, 0x7e01, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x7f23, 0x7e01, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x7f23, 0x7e01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x7f23, 0x7e01, 0x4900, 0x7bff, 0x7c00, 0x0000,
  0x3c00, 0x3c01, 0x7f23, 0x7e01, 0x7bff, 0x7c00, 0x0001, 0x0000,
  0x3c01, 0x3e00, 0x7f23, 0x7e01, 0x7c00, 0x03ff, 0x0001, 0x7f23,
  0x3e00, 0x4900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7f23, 0x7e01, 0x0012, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0x7e00, 0x7f23, 0x7e01, 0x7e01, 0x03ff, 0x03ff, 0x0001,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0x7f23, 0x7f23, 0x7f23, 0x7e01, 0x03ff, 0x03ff, 0x0001, 0x0000,
  0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0x7e01, 0x0012, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0x0012, 0x03ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0x03ff, 0x0001, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0x0001, 0x8000, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0x8000, 0x8400, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0x8400, 0xb7ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0xb7ff, 0xb800, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0xb800, 0xb801, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0xb801, 0xbbff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0xbbff, 0xbc00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0xbc00, 0xbc01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0xbc01, 0xbe00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0xff23,
  0xbe00, 0xc900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0xff23, 0xfe01,
  0xc900, 0xfbff, 0x7f23, 0x7e01, 0x0012, 0xff23, 0xfe01, 0x0000,
  0xfbff, 0xfc00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0x0001, 0x0000,
  0xfc00, 0x7e00, 0x7f23, 0x7e01, 0xfe01, 0x03ff, 0x0001, 0x0000,
  0x7e00, 0x7f23, 0x7e01, 0xfe01, 0x03ff, 0x0001, 0x0000, 0x0400,
  0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400,
  0xff23, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0400, 0x37ff,
  0xfe01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0400, 0x37ff, 0x3800,
  0x8012, 0x7f23, 0x7e01, 0x0012, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x83ff, 0x7f23, 0x7e01, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x8001, 0x7f23, 0x7e01, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0000, 0x7f23, 0x7e01, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x7f23, 0x7e01, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x7f23, 0x7e01, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x7f23, 0x7e01, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x7f23, 0x7e01, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x7f23, 0x7e01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x0400,
  0x3c00, 0x7f23, 0x7e01, 0x4900, 0x7bff, 0x7c00, 0x0000, 0x0400,
  0x3c01, 0x7f23, 0x7e01, 0x7bff, 0x7c00, 0x0001, 0x0000, 0x7f23,
  0x3e00, 0x7f23, 0x7e01, 0x7c00, 0x03ff, 0x0001, 0x7f23, 0x7e01,
  0x4900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x7f23, 0x7e01, 0x0400,
  0x7bff, 0x7f23, 0x7e01, 0x0012, 0x7f23, 0x7e01, 0x0012, 0x0400,
  0x7c00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0400,
  0x7e00, 0x7f23, 0x7e01, 0x7e01, 0x03ff, 0x03ff, 0x0001, 0x0400,
  0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400,
  0x7f23, 0x7f23, 0x7e01, 0x03ff, 0x03ff, 0x0001, 0x0000, 0x0400,
  0x7e01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400,
  0x0012, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400,
  0x03ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400,
  0x0001, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400,
  0x8000, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400,
  0x8400, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400,
  0xb7ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400,
  0xb800, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400,
  0xb801, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400,
  0xbbff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400,
  0xbc00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400,
  0xbc01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0xff23,
  0xbe00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0xff23, 0xfe01,
  0xc900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0xff23, 0xfe01, 0x0400,
  0xfbff, 0x7f23, 0x7e01, 0x0012, 0xff23, 0xfe01, 0x0000, 0x0400,
  0xfc00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0x0001, 0x0000, 0x0400,
  0x7f23, 0x7e01, 0xff23, 0xfe01, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0xfe01, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0400, 0x37ff, 0x3800,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x7f23, 0x7e01, 0x0012, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x7f23, 0x7e01, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x7f23, 0x7e01, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x7f23, 0x7e01, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x7f23, 0x7e01, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x7f23, 0x7e01, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x7f23, 0x7e01, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x7f23, 0x7e01, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x37ff,
  0x7f23, 0x7e01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x4900, 0x7bff, 0x7c00, 0x0000, 0x0400, 0x7f23,
  0x7f23, 0x7e01, 0x7bff, 0x7c00, 0x0001, 0x0000, 0x7f23, 0x7e01,
  0x7f23, 0x7e01, 0x7c00, 0x03ff, 0x0001, 0x7f23, 0x7e01, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x7f23, 0x7e01, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x7f23, 0x7e01, 0x0012, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x7e01, 0x03ff, 0x03ff, 0x0001, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x03ff, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0xff23,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0xff23, 0xfe01,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0xff23, 0xfe01, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0xff23, 0xfe01, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0xff23, 0xfe01, 0x0000, 0x0400, 0x37ff,
  0x7e01, 0x0012, 0xff23, 0xfe01, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0xff23, 0xfe01, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0xfe01, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x7e01, 0x0012, 0x03ff, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x7e01, 0x0012, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x7e01, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x7e01, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x7e01, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x7e01, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x7e01, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x7e01, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3800,
  0x7e01, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x37ff, 0x3800,
  0x7e01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x0400, 0x37ff, 0x7f23,
  0x7e01, 0x4900, 0x7bff, 0x7c00, 0x0000, 0x0400, 0x7f23, 0x7e01,
  0x7e01, 0x7bff, 0x7c00, 0x0001, 0x0000, 0x7f23, 0x7e01, 0x3800,
  0x7e01, 0x7c00, 0x03ff, 0x0001, 0x7f23, 0x7e01, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x7f23, 0x7e01, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x7f23, 0x7e01, 0x0012, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x7e01, 0x03ff, 0x03ff, 0x0001, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x03ff, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0xff23,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0xff23, 0xfe01,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0xff23, 0xfe01, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0xff23, 0xfe01, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0xff23, 0xfe01, 0x0400, 0x37ff, 0x3800,
  0x0012, 0x03ff, 0xff23, 0xfe01, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0012, 0xff23, 0xfe01, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0xff23, 0xfe01, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0xfe01, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0012, 0x03ff, 0x0001, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x0012, 0x03ff, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0012, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3801,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3800, 0x3801,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x37ff, 0x3800, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x0400, 0x37ff, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0x0000, 0x0400, 0x7f23, 0x7e01, 0x3801,
  0x7bff, 0x7c00, 0x0001, 0x0000, 0x7f23, 0x7e01, 0x3800, 0x3801,
  0x7c00, 0x03ff, 0x0001, 0x7f23, 0x7e01, 0x37ff, 0x3800, 0x3801,
  0x0012, 0x03ff, 0x7f23, 0x7e01, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0012, 0x7f23, 0x7e01, 0x0012, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x7e01, 0x03ff, 0x03ff, 0x0001, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x03ff, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0xff23,
  0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0xff23, 0xfe01,
  0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0xff23, 0xfe01, 0x3801,
  0x0012, 0x03ff, 0x0001, 0x0000, 0xff23, 0xfe01, 0x3800, 0x3801,
  0x0012, 0x03ff, 0x0001, 0xff23, 0xfe01, 0x37ff, 0x3800, 0x3801,
  0x03ff, 0x0001, 0xff23, 0xfe01, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0xff23, 0xfe01, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0xff23, 0xfe01, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0xfe01, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x03ff, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3bff,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3801, 0x3bff,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3800, 0x3801, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x37ff, 0x3800, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0x0400, 0x37ff, 0x7f23, 0x7e01, 0x3bff,
  0x7bff, 0x7c00, 0x0000, 0x0400, 0x7f23, 0x7e01, 0x3801, 0x3bff,
  0x7c00, 0x0001, 0x0000, 0x7f23, 0x7e01, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x7f23, 0x7e01, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x7f23, 0x7e01, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x7f23, 0x7e01, 0x0012, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x7e01, 0x0012, 0x03ff, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x03ff, 0x0001, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0xff23,
  0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0xff23, 0xfe01,
  0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0xff23, 0xfe01, 0x3bff,
  0x03ff, 0x0001, 0x0000, 0x0400, 0xff23, 0xfe01, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x0000, 0xff23, 0xfe01, 0x3800, 0x3801, 0x3bff,
  0x0001, 0x0000, 0xff23, 0xfe01, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0xff23, 0xfe01, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0xff23, 0xfe01, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0xfe01, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3bff, 0x3c00,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3801, 0x3bff, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3800, 0x3801, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0x37ff, 0x3800, 0x7f23, 0x7e01, 0x3c00,
  0x7bff, 0x7c00, 0x0400, 0x37ff, 0x7f23, 0x7e01, 0x3bff, 0x3c00,
  0x7c00, 0x0000, 0x0400, 0x7f23, 0x7e01, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x0000, 0x7f23, 0x7e01, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x7f23, 0x7e01, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x7f23, 0x7e01, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x7e01, 0x0012, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0012, 0x03ff, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x03ff, 0x0001, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0xff23,
  0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0xff23, 0xfe01,
  0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0xff23, 0xfe01, 0x3c00,
  0x0001, 0x0000, 0x0400, 0x37ff, 0xff23, 0xfe01, 0x3bff, 0x3c00,
  0x0001, 0x0000, 0x0400, 0xff23, 0xfe01, 0x3801, 0x3bff, 0x3c00,
  0x0000, 0x0400, 0xff23, 0xfe01, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0000, 0xff23, 0xfe01, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0xff23, 0xfe01, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0xfe01, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c01,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c00, 0x3c01,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3bff, 0x3c00, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3801, 0x3bff, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0x3800, 0x3801, 0x7f23, 0x7e01, 0x3c01,
  0x7bff, 0x7c00, 0x37ff, 0x3800, 0x7f23, 0x7e01, 0x3c00, 0x3c01,
  0x7c00, 0x0400, 0x37ff, 0x7f23, 0x7e01, 0x3bff, 0x3c00, 0x3c01,
  0x0000, 0x0400, 0x7f23, 0x7e01, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0000, 0x7f23, 0x7e01, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x7f23, 0x7e01, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x7e01, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0012, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x03ff, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0001, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0xff23,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0xff23, 0xfe01,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0xff23, 0xfe01, 0x3c01,
  0x0000, 0x0400, 0x37ff, 0x3800, 0xff23, 0xfe01, 0x3c00, 0x3c01,
  0x0000, 0x0400, 0x37ff, 0xff23, 0xfe01, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0xff23, 0xfe01, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0xff23, 0xfe01, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0xff23, 0xfe01, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0xfe01, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3e00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c01, 0x3e00,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c00, 0x3c01, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3bff, 0x3c00, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0x3801, 0x3bff, 0x7f23, 0x7e01, 0x3e00,
  0x7bff, 0x7c00, 0x3800, 0x3801, 0x7f23, 0x7e01, 0x3c01, 0x3e00,
  0x7c00, 0x37ff, 0x3800, 0x7f23, 0x7e01, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x7f23, 0x7e01, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x7f23, 0x7e01, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x7f23, 0x7e01, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x7e01, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0xff23,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0xff23, 0xfe01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0xff23, 0xfe01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0x3801, 0xff23, 0xfe01, 0x3c01, 0x3e00,
  0x0400, 0x37ff, 0x3800, 0xff23, 0xfe01, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0xff23, 0xfe01, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0xff23, 0xfe01, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0xff23, 0xfe01, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0xfe01, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x4900,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3e00, 0x4900,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c01, 0x3e00, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c00, 0x3c01, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0x3bff, 0x3c00, 0x7f23, 0x7e01, 0x4900,
  0x7bff, 0x7c00, 0x3801, 0x3bff, 0x7f23, 0x7e01, 0x3e00, 0x4900,
  0x7c00, 0x3800, 0x3801, 0x7f23, 0x7e01, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x7f23, 0x7e01, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x7f23, 0x7e01, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x7f23, 0x7e01, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x7e01, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0xff23,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0xff23, 0xfe01,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0xff23, 0xfe01, 0x4900,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0xff23, 0xfe01, 0x3e00, 0x4900,
  0x37ff, 0x3800, 0x3801, 0xff23, 0xfe01, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0xff23, 0xfe01, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0xff23, 0xfe01, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0xff23, 0xfe01, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0xfe01, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7bff,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x4900, 0x7bff,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3e00, 0x4900, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c01, 0x3e00, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0x3c00, 0x3c01, 0x7f23, 0x7e01, 0x7bff,
  0x7bff, 0x7c00, 0x3bff, 0x3c00, 0x7f23, 0x7e01, 0x4900, 0x7bff,
  0x7c00, 0x3801, 0x3bff, 0x7f23, 0x7e01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x7f23, 0x7e01, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x7f23, 0x7e01, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x7f23, 0x7e01, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x7e01, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0xff23,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0xff23, 0xfe01,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0xff23, 0xfe01, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0xff23, 0xfe01, 0x4900, 0x7bff,
  0x3800, 0x3801, 0x3bff, 0xff23, 0xfe01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0xff23, 0xfe01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0xff23, 0xfe01, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0xff23, 0xfe01, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0xfe01, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7c00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7bff, 0x7c00,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x4900, 0x7bff, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3e00, 0x4900, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0x3c01, 0x3e00, 0x7f23, 0x7e01, 0x7c00,
  0x7bff, 0x7c00, 0x3c00, 0x3c01, 0x7f23, 0x7e01, 0x7bff, 0x7c00,
  0x7c00, 0x3bff, 0x3c00, 0x7f23, 0x7e01, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x7f23, 0x7e01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x7f23, 0x7e01, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x7f23, 0x7e01, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x7e01, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0xff23,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0xff23, 0xfe01,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0xff23, 0xfe01, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0xff23, 0xfe01, 0x7bff, 0x7c00,
  0x3801, 0x3bff, 0x3c00, 0xff23, 0xfe01, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0xff23, 0xfe01, 0x4900, 0x7bff, 0x7c00, 0x0000,
  0x3bff, 0xff23, 0xfe01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x0400,
  0xff23, 0xfe01, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x37ff,
  0xfe01, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3800,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3801,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3bff,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c01,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3e00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x4900,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7bff,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7f23,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7c00, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7bff, 0x7c00, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x4900, 0x7bff, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0x3e00, 0x4900, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0x3c01, 0x3e00, 0x7f23, 0x7e01, 0x7c00, 0x03ff,
  0x7c00, 0x3c00, 0x3c01, 0x7f23, 0x7e01, 0x7bff, 0x7c00, 0x0001,
  0x3bff, 0x3c00, 0x7f23, 0x7e01, 0x4900, 0x7bff, 0x7c00, 0x8000,
  0x3bff, 0x7f23, 0x7e01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x8400,
  0x7f23, 0x7e01, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb7ff,
  0x7e01, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb800,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb801,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbbff,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc01,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbe00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xc900,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfbff,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfc00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7f23,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7f23,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xff23,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0xff23, 0xfe01,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0xff23, 0xfe01, 0x8012,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0xff23, 0xfe01, 0x7c00, 0x83ff,
  0x3bff, 0x3c00, 0x3c01, 0xff23, 0xfe01, 0x7bff, 0x7c00, 0x8001,
  0x3c00, 0x3c01, 0xff23, 0xfe01, 0x7bff, 0x7c00, 0x8001, 0x0000,
  0x3c00, 0xff23, 0xfe01, 0x4900, 0x7bff, 0x7c00, 0x0000, 0x0400,
  0xff23, 0xfe01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x0400, 0x37ff,
  0xfe01, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x37ff, 0x3800,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3800, 0x3801,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3801, 0x3bff,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3bff, 0x3c00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c00, 0x3c01,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c01, 0x3e00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3e00, 0x4900,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x4900, 0x7bff,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7bff, 0x7c00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7c00, 0x7e00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7f23, 0x7e00,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7c00, 0x7f23, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7bff, 0x7c00, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0x4900, 0x7bff, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0x3e00, 0x4900, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0x3c01, 0x3e00, 0x7f23, 0x7e01, 0x7c00, 0x03ff, 0x0001,
  0x3c00, 0x3c01, 0x7f23, 0x7e01, 0x7bff, 0x7c00, 0x0001, 0x8000,
  0x3c00, 0x7f23, 0x7e01, 0x4900, 0x7bff, 0x7c00, 0x8000, 0x8400,
  0x7f23, 0x7e01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x8400, 0xb7ff,
  0x7e01, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb7ff, 0xb800,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb800, 0xb801,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb801, 0xbbff,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbbff, 0xbc00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc00, 0xbc01,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc01, 0xbe00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbe00, 0xc900,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xc900, 0xfbff,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfbff, 0xfc00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfc00, 0x7e00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7f23, 0x7e00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7f23, 0xff23,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xff23, 0xfe01,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0xff23, 0xfe01, 0x8012,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0x3c00, 0x3c01, 0x3e00, 0xff23, 0xfe01, 0x7c00, 0x83ff, 0x8001,
  0x3c01, 0x3e00, 0xff23, 0xfe01, 0x7c00, 0x83ff, 0x8001, 0x7f23,
  0x3c01, 0xff23, 0xfe01, 0x7bff, 0x7c00, 0x8001, 0x0000, 0x7f23,
  0xff23, 0xfe01, 0x4900, 0x7bff, 0x7c00, 0x0000, 0x0400, 0x7f23,
  0xfe01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x0400, 0x37ff, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x37ff, 0x3800, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3800, 0x3801, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3801, 0x3bff, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3bff, 0x3c00, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c00, 0x3c01, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c01, 0x3e00, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3e00, 0x4900, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x4900, 0x7bff, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7bff, 0x7c00, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7c00, 0x7e00, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7c00, 0x7f23, 0x7f23, 0x7f23,
  0x4900, 0x7bff, 0x7c00, 0x7bff, 0x7c00, 0x7f23, 0x7e01, 0x7f23,
  0x7bff, 0x7c00, 0x4900, 0x7bff, 0x7f23, 0x7e01, 0x0012, 0x7f23,
  0x7c00, 0x3e00, 0x4900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x7f23,
  0x3c01, 0x3e00, 0x7f23, 0x7e01, 0x7c00, 0x03ff, 0x0001, 0x7f23,
  0x3c01, 0x7f23, 0x7e01, 0x7bff, 0x7c00, 0x0001, 0x8000, 0x7f23,
  0x7f23, 0x7e01, 0x4900, 0x7bff, 0x7c00, 0x8000, 0x8400, 0x7f23,
  0x7e01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x8400, 0xb7ff, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb7ff, 0xb800, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb800, 0xb801, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb801, 0xbbff, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbbff, 0xbc00, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc00, 0xbc01, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc01, 0xbe00, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbe00, 0xc900, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xc900, 0xfbff, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfbff, 0xfc00, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfc00, 0x7e00, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7f23, 0x7e00, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7f23, 0xff23, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xff23, 0xfe01, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0xff23, 0xfe01, 0x8012, 0x7f23,
  0x3c01, 0x3e00, 0x4900, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x7f23,
  0x3e00, 0x4900, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x7f23, 0x7e01,
  0x3e00, 0xff23, 0xfe01, 0x7c00, 0x83ff, 0x8001, 0x7f23, 0x7e01,
  0xff23, 0xfe01, 0x7bff, 0x7c00, 0x8001, 0x0000, 0x7f23, 0x7e01,
  0xfe01, 0x4900, 0x7bff, 0x7c00, 0x0000, 0x0400, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x0400, 0x37ff, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x37ff, 0x3800, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3800, 0x3801, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3801, 0x3bff, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3bff, 0x3c00, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c00, 0x3c01, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3c01, 0x3e00, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x3e00, 0x4900, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x4900, 0x7bff, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7bff, 0x7c00, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7c00, 0x7e00, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0x7c00, 0x7f23, 0x7f23, 0x7f23, 0x7e01,
  0x7bff, 0x7c00, 0x7bff, 0x7c00, 0x7f23, 0x7e01, 0x7f23, 0x7e01,
  0x7c00, 0x4900, 0x7bff, 0x7f23, 0x7e01, 0x0012, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x7f23, 0x7e01,
  0x3e00, 0x7f23, 0x7e01, 0x7c00, 0x03ff, 0x0001, 0x7f23, 0x7e01,
  0x7f23, 0x7e01, 0x7bff, 0x7c00, 0x0001, 0x8000, 0x7f23, 0x7e01,
  0x7e01, 0x4900, 0x7bff, 0x7c00, 0x8000, 0x8400, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x8400, 0xb7ff, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb7ff, 0xb800, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb800, 0xb801, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb801, 0xbbff, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbbff, 0xbc00, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc00, 0xbc01, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc01, 0xbe00, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbe00, 0xc900, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xc900, 0xfbff, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfbff, 0xfc00, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfc00, 0x7e00, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x7f23, 0xff23, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xff23, 0xfe01, 0x7f23, 0x7e01,
  0x3e00, 0x4900, 0x7bff, 0xff23, 0xfe01, 0x8012, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0xff23, 0xfe01, 0x8012, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x7f23, 0x7e01, 0x0400,
  0xff23, 0xfe01, 0x7c00, 0x83ff, 0x8001, 0x7f23, 0x7e01, 0x37ff,
  0xfe01, 0x7bff, 0x7c00, 0x8001, 0x0000, 0x7f23, 0x7e01, 0x3800,
  0x4900, 0x7bff, 0x7c00, 0x0000, 0x0400, 0x7f23, 0x7e01, 0x3801,
  0x4900, 0x7bff, 0x7c00, 0x0400, 0x37ff, 0x7f23, 0x7e01, 0x3bff,
  0x4900, 0x7bff, 0x7c00, 0x37ff, 0x3800, 0x7f23, 0x7e01, 0x3c00,
  0x4900, 0x7bff, 0x7c00, 0x3800, 0x3801, 0x7f23, 0x7e01, 0x3c01,
  0x4900, 0x7bff, 0x7c00, 0x3801, 0x3bff, 0x7f23, 0x7e01, 0x3e00,
  0x4900, 0x7bff, 0x7c00, 0x3bff, 0x3c00, 0x7f23, 0x7e01, 0x4900,
  0x4900, 0x7bff, 0x7c00, 0x3c00, 0x3c01, 0x7f23, 0x7e01, 0x7bff,
  0x4900, 0x7bff, 0x7c00, 0x3c01, 0x3e00, 0x7f23, 0x7e01, 0x7c00,
  0x4900, 0x7bff, 0x7c00, 0x3e00, 0x4900, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7c00, 0x4900, 0x7bff, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7c00, 0x7bff, 0x7c00, 0x7f23, 0x7e01, 0x7f23,
  0x4900, 0x7bff, 0x7c00, 0x7c00, 0x7e00, 0x7f23, 0x7e01, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0x7c00, 0x7f23, 0x7f23, 0x7f23, 0x7e01, 0x03ff,
  0x7c00, 0x7bff, 0x7c00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7f23, 0x7e01, 0x0012, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x7f23, 0x7e01, 0x0012,
  0x7f23, 0x7e01, 0x7c00, 0x03ff, 0x0001, 0x7f23, 0x7e01, 0x0012,
  0x7e01, 0x7bff, 0x7c00, 0x0001, 0x8000, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7c00, 0x8000, 0x8400, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7c00, 0x8400, 0xb7ff, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7c00, 0xb7ff, 0xb800, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7c00, 0xb800, 0xb801, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7c00, 0xb801, 0xbbff, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7c00, 0xbbff, 0xbc00, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7c00, 0xbc00, 0xbc01, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7c00, 0xbc01, 0xbe00, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7c00, 0xbe00, 0xc900, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7c00, 0xc900, 0xfbff, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7c00, 0xfbff, 0xfc00, 0x7f23, 0x7e01, 0xff23,
  0x4900, 0x7bff, 0x7c00, 0xfc00, 0x7e00, 0x7f23, 0x7e01, 0xfe01,
  0x4900, 0x7bff, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7c00, 0x7f23, 0xff23, 0x7f23, 0x7e01, 0x0012,
  0x4900, 0x7bff, 0x7c00, 0xff23, 0xfe01, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0xff23, 0xfe01, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7bff, 0xff23, 0xfe01, 0x8012, 0x7f23, 0x7e01, 0x0012, 0x0400,
  0xff23, 0xfe01, 0x8012, 0x83ff, 0x7f23, 0x7e01, 0x0400, 0x37ff,
  0xfe01, 0x7c00, 0x83ff, 0x8001, 0x7f23, 0x7e01, 0x37ff, 0x3800,
  0x7bff, 0x7c00, 0x8001, 0x0000, 0x7f23, 0x7e01, 0x3800, 0x3801,
  0x7bff, 0x7c00, 0x0000, 0x0400, 0x7f23, 0x7e01, 0x3801, 0x3bff,
  0x7bff, 0x7c00, 0x0400, 0x37ff, 0x7f23, 0x7e01, 0x3bff, 0x3c00,
  0x7bff, 0x7c00, 0x37ff, 0x3800, 0x7f23, 0x7e01, 0x3c00, 0x3c01,
  0x7bff, 0x7c00, 0x3800, 0x3801, 0x7f23, 0x7e01, 0x3c01, 0x3e00,
  0x7bff, 0x7c00, 0x3801, 0x3bff, 0x7f23, 0x7e01, 0x3e00, 0x4900,
  0x7bff, 0x7c00, 0x3bff, 0x3c00, 0x7f23, 0x7e01, 0x4900, 0x7bff,
  0x7bff, 0x7c00, 0x3c00, 0x3c01, 0x7f23, 0x7e01, 0x7bff, 0x7c00,
  0x7bff, 0x7c00, 0x3c01, 0x3e00, 0x7f23, 0x7e01, 0x7c00, 0x03ff,
  0x7bff, 0x7c00, 0x3e00, 0x4900, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7bff, 0x7c00, 0x4900, 0x7bff, 0x7f23, 0x7e01, 0x0012, 0x7f23,
  0x7bff, 0x7c00, 0x7bff, 0x7c00, 0x7f23, 0x7e01, 0x7f23, 0x7e01,
  0x7bff, 0x7c00, 0x7c00, 0x7e00, 0x7f23, 0x7e01, 0x7e01, 0x03ff,
  0x7bff, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0x7c00, 0x7f23, 0x7f23, 0x7f23, 0x7e01, 0x03ff, 0x03ff,
  0x7bff, 0x7c00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7bff, 0x7f23, 0x7e01, 0x0012, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7e01, 0x7c00, 0x03ff, 0x0001, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7bff, 0x7c00, 0x0001, 0x8000, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7bff, 0x7c00, 0x8000, 0x8400, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7bff, 0x7c00, 0x8400, 0xb7ff, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7bff, 0x7c00, 0xb7ff, 0xb800, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7bff, 0x7c00, 0xb800, 0xb801, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7bff, 0x7c00, 0xb801, 0xbbff, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7bff, 0x7c00, 0xbbff, 0xbc00, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7bff, 0x7c00, 0xbc00, 0xbc01, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7bff, 0x7c00, 0xbc01, 0xbe00, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7bff, 0x7c00, 0xbe00, 0xc900, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7bff, 0x7c00, 0xc900, 0xfbff, 0x7f23, 0x7e01, 0x0012, 0xff23,
  0x7bff, 0x7c00, 0xfbff, 0xfc00, 0x7f23, 0x7e01, 0xff23, 0xfe01,
  0x7bff, 0x7c00, 0xfc00, 0x7e00, 0x7f23, 0x7e01, 0xfe01, 0x03ff,
  0x7bff, 0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7bff, 0x7c00, 0x7f23, 0xff23, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0x7f23, 0xff23, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7c00, 0xff23, 0xfe01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0400,
  0xff23, 0xfe01, 0x8012, 0x7f23, 0x7e01, 0x0012, 0x0400, 0x37ff,
  0xfe01, 0x8012, 0x83ff, 0x7f23, 0x7e01, 0x0400, 0x37ff, 0x3800,
  0x7c00, 0x83ff, 0x8001, 0x7f23, 0x7e01, 0x37ff, 0x3800, 0x3801,
  0x7c00, 0x8001, 0x0000, 0x7f23, 0x7e01, 0x3800, 0x3801, 0x3bff,
  0x7c00, 0x0000, 0x0400, 0x7f23, 0x7e01, 0x3801, 0x3bff, 0x3c00,
  0x7c00, 0x0400, 0x37ff, 0x7f23, 0x7e01, 0x3bff, 0x3c00, 0x3c01,
  0x7c00, 0x37ff, 0x3800, 0x7f23, 0x7e01, 0x3c00, 0x3c01, 0x3e00,
  0x7c00, 0x3800, 0x3801, 0x7f23, 0x7e01, 0x3c01, 0x3e00, 0x4900,
  0x7c00, 0x3801, 0x3bff, 0x7f23, 0x7e01, 0x3e00, 0x4900, 0x7bff,
  0x7c00, 0x3bff, 0x3c00, 0x7f23, 0x7e01, 0x4900, 0x7bff, 0x7c00,
  0x7c00, 0x3c00, 0x3c01, 0x7f23, 0x7e01, 0x7bff, 0x7c00, 0x0001,
  0x7c00, 0x3c01, 0x3e00, 0x7f23, 0x7e01, 0x7c00, 0x03ff, 0x0001,
  0x7c00, 0x3e00, 0x4900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x7f23,
  0x7c00, 0x4900, 0x7bff, 0x7f23, 0x7e01, 0x0012, 0x7f23, 0x7e01,
  0x7c00, 0x7bff, 0x7c00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x0012,
  0x7c00, 0x7c00, 0x7e00, 0x7f23, 0x7e01, 0x7e01, 0x03ff, 0x03ff,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7c00, 0x7f23, 0x7f23, 0x7f23, 0x7e01, 0x03ff, 0x03ff, 0x0001,
  0x7c00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7f23, 0x7e01, 0x0012, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7e01, 0x0012, 0x03ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7c00, 0x03ff, 0x0001, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7c00, 0x0001, 0x8000, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7c00, 0x8000, 0x8400, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7c00, 0x8400, 0xb7ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7c00, 0xb7ff, 0xb800, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7c00, 0xb800, 0xb801, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7c00, 0xb801, 0xbbff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7c00, 0xbbff, 0xbc00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7c00, 0xbc00, 0xbc01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7c00, 0xbc01, 0xbe00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7c00, 0xbe00, 0xc900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0xff23,
  0x7c00, 0xc900, 0xfbff, 0x7f23, 0x7e01, 0x0012, 0xff23, 0xfe01,
  0x7c00, 0xfbff, 0xfc00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0x0001,
  0x7c00, 0xfc00, 0x7e00, 0x7f23, 0x7e01, 0xfe01, 0x03ff, 0x0001,
  0x7c00, 0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000,
  0x7f23, 0xff23, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0400,
  0xff23, 0xfe01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0400, 0x37ff,
  0xfe01, 0x8012, 0x7f23, 0x7e01, 0x0012, 0x0400, 0x37ff, 0x3800,
  0x8012, 0x83ff, 0x7f23, 0x7e01, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x83ff, 0x8001, 0x7f23, 0x7e01, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x8001, 0x0000, 0x7f23, 0x7e01, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0000, 0x0400, 0x7f23, 0x7e01, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x7f23, 0x7e01, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x7f23, 0x7e01, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x7f23, 0x7e01, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x7f23, 0x7e01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x7f23, 0x7e01, 0x4900, 0x7bff, 0x7c00, 0x8000,
  0x3c00, 0x3c01, 0x7f23, 0x7e01, 0x7bff, 0x7c00, 0x0001, 0x8000,
  0x3c01, 0x3e00, 0x7f23, 0x7e01, 0x7c00, 0x03ff, 0x0001, 0x7f23,
  0x3e00, 0x4900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7f23, 0x7e01, 0x0012, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0x7e00, 0x7f23, 0x7e01, 0x7e01, 0x03ff, 0x03ff, 0x0001,
  0x7f23, 0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0x7f23, 0x7f23, 0x7f23, 0x7e01, 0x03ff, 0x03ff, 0x0001, 0x8000,
  0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0x7e01, 0x0012, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0x0012, 0x03ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0x03ff, 0x0001, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0x0001, 0x8000, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0x8000, 0x8400, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0x8400, 0xb7ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0xb7ff, 0xb800, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0xb800, 0xb801, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0xb801, 0xbbff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0xbbff, 0xbc00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0xbc00, 0xbc01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0xbc01, 0xbe00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0xff23,
  0xbe00, 0xc900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0xff23, 0xfe01,
  0xc900, 0xfbff, 0x7f23, 0x7e01, 0x0012, 0xff23, 0xfe01, 0x8000,
  0xfbff, 0xfc00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0x0001, 0x8000,
  0xfc00, 0x7e00, 0x7f23, 0x7e01, 0xfe01, 0x03ff, 0x0001, 0x8000,
  0x7e00, 0x7f23, 0x7e01, 0xfe01, 0x03ff, 0x0001, 0x8000, 0x0000,
  0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400,
  0xff23, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0400, 0x37ff,
  0xfe01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0400, 0x37ff, 0x3800,
  0x8012, 0x7f23, 0x7e01, 0x0012, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x83ff, 0x7f23, 0x7e01, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x8001, 0x7f23, 0x7e01, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0000, 0x7f23, 0x7e01, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x7f23, 0x7e01, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x7f23, 0x7e01, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x7f23, 0x7e01, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x7f23, 0x7e01, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x7f23, 0x7e01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x8400,
  0x3c00, 0x7f23, 0x7e01, 0x4900, 0x7bff, 0x7c00, 0x8000, 0x8400,
  0x3c01, 0x7f23, 0x7e01, 0x7bff, 0x7c00, 0x0001, 0x8000, 0x7f23,
  0x3e00, 0x7f23, 0x7e01, 0x7c00, 0x03ff, 0x0001, 0x7f23, 0x7e01,
  0x4900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7f23, 0x7e01, 0x0012, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7e00, 0x7f23, 0x7e01, 0x7e01, 0x03ff, 0x03ff, 0x0001, 0x8000,
  0x7e00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x7f23, 0x7f23, 0x7e01, 0x03ff, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x7e01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x0012, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x03ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x0001, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x8000, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x8400, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0xb7ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0xb800, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0xb801, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0xbbff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0xbc00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0xbc01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0xff23,
  0xbe00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0xff23, 0xfe01,
  0xc900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0xff23, 0xfe01, 0x8012,
  0xfbff, 0x7f23, 0x7e01, 0x0012, 0xff23, 0xfe01, 0x8000, 0x83ff,
  0xfc00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0x0001, 0x8000, 0x8001,
  0x7f23, 0x7e01, 0xff23, 0xfe01, 0x0001, 0x8000, 0x8001, 0x0000,
  0x7f23, 0x7e01, 0xfe01, 0x03ff, 0x0001, 0x8000, 0x0000, 0x0400,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x0400, 0x37ff, 0x3800,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x7f23, 0x7e01, 0x0012, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x7f23, 0x7e01, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x7f23, 0x7e01, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x7f23, 0x7e01, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x7f23, 0x7e01, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x7f23, 0x7e01, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x7f23, 0x7e01, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x7f23, 0x7e01, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb7ff,
  0x7f23, 0x7e01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x8400, 0xb7ff,
  0x7f23, 0x7e01, 0x4900, 0x7bff, 0x7c00, 0x8000, 0x8400, 0x7f23,
  0x7f23, 0x7e01, 0x7bff, 0x7c00, 0x0001, 0x8000, 0x7f23, 0x7e01,
  0x7f23, 0x7e01, 0x7c00, 0x03ff, 0x0001, 0x7f23, 0x7e01, 0x0012,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7f23, 0x7e01, 0x0012, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7f23, 0x7e01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0x7f23, 0x7e01, 0x7e01, 0x03ff, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7f23, 0x7e01, 0x03ff, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xff23,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0xff23, 0xfe01,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0xff23, 0xfe01, 0x8012,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0x7f23, 0x7e01, 0x0012, 0xff23, 0xfe01, 0x8000, 0x83ff, 0x8001,
  0x7e01, 0x0012, 0xff23, 0xfe01, 0x8000, 0x83ff, 0x8001, 0x0000,
  0x7e01, 0xff23, 0xfe01, 0x0001, 0x8000, 0x8001, 0x0000, 0x0400,
  0x7e01, 0xfe01, 0x03ff, 0x0001, 0x8000, 0x0000, 0x0400, 0x37ff,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x7e01, 0x0012, 0x03ff, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x7e01, 0x0012, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x7e01, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x7e01, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x7e01, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x7e01, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x7e01, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x7e01, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb800,
  0x7e01, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb7ff, 0xb800,
  0x7e01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0x8400, 0xb7ff, 0x7f23,
  0x7e01, 0x4900, 0x7bff, 0x7c00, 0x8000, 0x8400, 0x7f23, 0x7e01,
  0x7e01, 0x7bff, 0x7c00, 0x0001, 0x8000, 0x7f23, 0x7e01, 0x0012,
  0x7e01, 0x7c00, 0x03ff, 0x0001, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7e01, 0x0012, 0x03ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x7e01, 0x0012, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0x7e01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x7e01, 0x7e01, 0x03ff, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x7e01, 0x03ff, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xff23,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xff23, 0xfe01,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0xff23, 0xfe01, 0x8012,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0x7e01, 0x0012, 0x03ff, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0x0012, 0x03ff, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000,
  0x0012, 0xff23, 0xfe01, 0x8000, 0x83ff, 0x8001, 0x0000, 0x0400,
  0xff23, 0xfe01, 0x0001, 0x8000, 0x8001, 0x0000, 0x0400, 0x37ff,
  0xfe01, 0x03ff, 0x0001, 0x8000, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x0012, 0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0012, 0x03ff, 0x0001, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x0012, 0x03ff, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0012, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb801,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb800, 0xb801,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb7ff, 0xb800, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0x8400, 0xb7ff, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0x8000, 0x8400, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0x0001, 0x8000, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0x03ff, 0x0001, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x0012, 0x03ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0x0012, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7e01, 0x03ff, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x03ff, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xff23,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xff23, 0xfe01,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xff23, 0xfe01, 0x8012,
  0x0012, 0x03ff, 0x0001, 0x8000, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0x0012, 0x03ff, 0x0001, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0x03ff, 0x0001, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000,
  0x03ff, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400,
  0xff23, 0xfe01, 0x8000, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff,
  0xfe01, 0x0001, 0x8000, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x03ff, 0x0001, 0x8000, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x03ff, 0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x03ff, 0x0001, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x03ff, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbbff,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb801, 0xbbff,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb800, 0xb801, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb7ff, 0xb800, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0x8400, 0xb7ff, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0x8000, 0x8400, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0x0001, 0x8000, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x03ff, 0x0001, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0x03ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x03ff, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xff23,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xff23, 0xfe01,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xff23, 0xfe01, 0x8012,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0x03ff, 0x0001, 0x8000, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0x0001, 0x8000, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000,
  0x0001, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400,
  0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff,
  0xfe01, 0x8000, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x0001, 0x8000, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x0001, 0x8000, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x0001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0001, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbbff, 0xbc00,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb801, 0xbbff, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb800, 0xb801, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0xb7ff, 0xb800, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0x8400, 0xb7ff, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0x8000, 0x8400, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x0001, 0x8000, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0x0001, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xff23,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xff23, 0xfe01,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xff23, 0xfe01, 0x8012,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0x0001, 0x8000, 0x8400, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0x8000, 0x8400, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000,
  0x8000, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400,
  0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff,
  0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x8000, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x8000, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x8000, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc01,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc00, 0xbc01,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbbff, 0xbc00, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xb801, 0xbbff, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0xb800, 0xb801, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0xb7ff, 0xb800, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0x8400, 0xb7ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x8000, 0x8400, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0x8000, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xff23,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xff23, 0xfe01,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xff23, 0xfe01, 0x8012,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0x8000, 0x8400, 0xb7ff, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0x8400, 0xb7ff, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000,
  0x8400, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400,
  0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff,
  0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbe00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc01, 0xbe00,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc00, 0xbc01, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbbff, 0xbc00, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0xb801, 0xbbff, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0xb800, 0xb801, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0xb7ff, 0xb800, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0x8400, 0xb7ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0x8400, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xff23,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xff23, 0xfe01,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xff23, 0xfe01, 0x8012,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0x8400, 0xb7ff, 0xb800, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0xb7ff, 0xb800, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000,
  0xb7ff, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400,
  0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff,
  0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xc900,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbe00, 0xc900,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc01, 0xbe00, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc00, 0xbc01, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0xbbff, 0xbc00, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0xb801, 0xbbff, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0xb800, 0xb801, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0xb7ff, 0xb800, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0xb7ff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xff23,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xff23, 0xfe01,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xff23, 0xfe01, 0x8012,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0xb7ff, 0xb800, 0xb801, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0xb800, 0xb801, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000,
  0xb800, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400,
  0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff,
  0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfbff,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xc900, 0xfbff,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbe00, 0xc900, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbc01, 0xbe00, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0xbc00, 0xbc01, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0xbbff, 0xbc00, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0xb801, 0xbbff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0xb800, 0xb801, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0xb800, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900,
  0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff,
  0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff,
  0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff,
  0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff,
  0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xff23,
  0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xff23, 0xfe01,
  0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xff23, 0xfe01, 0x8012,
  0xb800, 0xb801, 0xbbff, 0xbc00, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0xb800, 0xb801, 0xbbff, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0xb801, 0xbbff, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000,
  0xb801, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400,
  0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff,
  0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfc00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfbff, 0xfc00,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xc900, 0xfbff, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xbe00, 0xc900, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0xbc01, 0xbe00, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0xbc00, 0xbc01, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0xbbff, 0xbc00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0xb801, 0xbbff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0xb801, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900,
  0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff,
  0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00,
  0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00,
  0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00,
  0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xff23,
  0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xff23, 0xfe01,
  0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xff23, 0xfe01, 0x8012,
  0xb801, 0xbbff, 0xbc00, 0xbc01, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0xb801, 0xbbff, 0xbc00, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0xbbff, 0xbc00, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000,
  0xbbff, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400,
  0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff,
  0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xff23,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfc00, 0xff23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfbff, 0xfc00, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xc900, 0xfbff, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0xbe00, 0xc900, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0xbc01, 0xbe00, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0xbc00, 0xbc01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0xbbff, 0xbc00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0xbbff, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900,
  0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff,
  0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00,
  0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23,
  0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23,
  0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23,
  0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xff23, 0xfe01,
  0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xff23, 0xfe01, 0x8012,
  0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0xbbff, 0xbc00, 0xbc01, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0xbc00, 0xbc01, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000,
  0xbc00, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400,
  0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff,
  0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800,
  0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801,
  0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff,
  0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfe00,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xff23, 0xfe00,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfc00, 0xff23, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfbff, 0xfc00, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0xc900, 0xfbff, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0xbe00, 0xc900, 0x7f23, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0xbc01, 0xbe00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001,
  0xbc00, 0xbc01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000,
  0xbc00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900,
  0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff,
  0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00,
  0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00, 0xfe00,
  0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23, 0xfe00,
  0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23, 0xff23,
  0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23, 0xfe01,
  0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xff23, 0xfe01, 0x8012,
  0xbc00, 0xbc01, 0xbe00, 0xc900, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0xbc00, 0xbc01, 0xbe00, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0xbc01, 0xbe00, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0xff23,
  0xbc01, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0xff23,
  0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0xff23,
  0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0xff23,
  0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0xff23,
  0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0xff23,
  0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0xff23,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0xff23,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0xff23,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0xff23,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0xff23,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0xff23,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xff23,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfe00, 0xff23,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xff23, 0xfe00, 0xff23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfc00, 0xff23, 0x7f23, 0xff23,
  0x4900, 0x7bff, 0x7c00, 0xfbff, 0xfc00, 0x7f23, 0x7e01, 0xff23,
  0x7bff, 0x7c00, 0xc900, 0xfbff, 0x7f23, 0x7e01, 0x0012, 0xff23,
  0x7c00, 0xbe00, 0xc900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0xff23,
  0xbc01, 0xbe00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0xff23,
  0xbc01, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0xff23,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xff23,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xff23,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xff23,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xff23,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xff23,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xff23,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xff23,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xff23,
  0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xff23,
  0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xff23,
  0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23,
  0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00, 0xfe00, 0xff23,
  0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23, 0xfe00, 0xff23,
  0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23, 0xff23, 0xff23,
  0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23, 0xfe01, 0xff23,
  0xbc01, 0xbe00, 0xc900, 0xfbff, 0xff23, 0xfe01, 0x8012, 0xff23,
  0xbc01, 0xbe00, 0xc900, 0xff23, 0xfe01, 0x8012, 0x83ff, 0xff23,
  0xbe00, 0xc900, 0xff23, 0xfe01, 0x8012, 0x83ff, 0xff23, 0xfe01,
  0xbe00, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0xff23, 0xfe01,
  0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0xff23, 0xfe01,
  0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0xff23, 0xfe01,
  0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0xff23, 0xfe01,
  0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0xff23, 0xfe01,
  0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0xff23, 0xfe01,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0xff23, 0xfe01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0xff23, 0xfe01,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0xff23, 0xfe01,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0xff23, 0xfe01,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0xff23, 0xfe01,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0xff23, 0xfe01,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xff23, 0xfe01,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfe00, 0xff23, 0xfe01,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0x4900, 0x7bff, 0x7c00, 0xfc00, 0xff23, 0x7f23, 0xff23, 0xfe01,
  0x7bff, 0x7c00, 0xfbff, 0xfc00, 0x7f23, 0x7e01, 0xff23, 0xfe01,
  0x7c00, 0xc900, 0xfbff, 0x7f23, 0x7e01, 0x0012, 0xff23, 0xfe01,
  0xbe00, 0xc900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0xff23, 0xfe01,
  0xbe00, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0xff23, 0xfe01,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0xff23, 0xfe01,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xff23, 0xfe01,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xff23, 0xfe01,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xff23, 0xfe01,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xff23, 0xfe01,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xff23, 0xfe01,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xff23, 0xfe01,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xff23, 0xfe01,
  0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xff23, 0xfe01,
  0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xff23, 0xfe01,
  0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xff23, 0xfe01,
  0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23, 0xfe01,
  0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00, 0xfe00, 0xff23, 0xfe01,
  0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01,
  0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23, 0xff23, 0xff23, 0xfe01,
  0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23, 0xfe01, 0xff23, 0xfe01,
  0xbe00, 0xc900, 0xfbff, 0xff23, 0xfe01, 0x8012, 0xff23, 0xfe01,
  0xc900, 0xfbff, 0xff23, 0xfe01, 0x8012, 0xff23, 0xfe01, 0x0000,
  0xc900, 0xff23, 0xfe01, 0x8012, 0x83ff, 0xff23, 0xfe01, 0x0400,
  0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001, 0xff23, 0xfe01, 0x37ff,
  0xfe01, 0x8012, 0x83ff, 0x8001, 0x0000, 0xff23, 0xfe01, 0x3800,
  0x8012, 0x83ff, 0x8001, 0x0000, 0x0400, 0xff23, 0xfe01, 0x3801,
  0x83ff, 0x8001, 0x0000, 0x0400, 0x37ff, 0xff23, 0xfe01, 0x3bff,
  0x8001, 0x0000, 0x0400, 0x37ff, 0x3800, 0xff23, 0xfe01, 0x3c00,
  0x0000, 0x0400, 0x37ff, 0x3800, 0x3801, 0xff23, 0xfe01, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0x3bff, 0xff23, 0xfe01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0x3c00, 0xff23, 0xfe01, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0x3c01, 0xff23, 0xfe01, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0x3e00, 0xff23, 0xfe01, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0x4900, 0xff23, 0xfe01, 0x8012,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0x7bff, 0xff23, 0xfe01, 0x8012,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0x7c00, 0xff23, 0xfe01, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xfe00, 0xff23, 0xfe01, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0012,
  0x7bff, 0x7c00, 0xfc00, 0xff23, 0x7f23, 0xff23, 0xfe01, 0x03ff,
  0x7c00, 0xfbff, 0xfc00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0x0001,
  0xc900, 0xfbff, 0x7f23, 0x7e01, 0x0012, 0xff23, 0xfe01, 0x8000,
  0xc900, 0x7f23, 0x7e01, 0x0012, 0x03ff, 0xff23, 0xfe01, 0x8012,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0x0001, 0xff23, 0xfe01, 0x8012,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0x8000, 0xff23, 0xfe01, 0x8012,
  0x0012, 0x03ff, 0x0001, 0x8000, 0x8400, 0xff23, 0xfe01, 0x8012,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xb7ff, 0xff23, 0xfe01, 0x8012,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xb800, 0xff23, 0xfe01, 0x8012,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xb801, 0xff23, 0xfe01, 0x8012,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xbbff, 0xff23, 0xfe01, 0x8012,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xbc00, 0xff23, 0xfe01, 0x8012,
  0xb800, 0xb801, 0xbbff, 0xbc00, 0xbc01, 0xff23, 0xfe01, 0x8012,
  0xb801, 0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xff23, 0xfe01, 0x8012,
  0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xc900, 0xff23, 0xfe01, 0x8012,
  0xbc00, 0xbc01, 0xbe00, 0xc900, 0xfbff, 0xff23, 0xfe01, 0x8012,
  0xbc01, 0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23, 0xfe01, 0xff23,
  0xbe00, 0xc900, 0xfbff, 0xfc00, 0xfe00, 0xff23, 0xfe01, 0xfe01,
  0xc900, 0xfbff, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8012,
  0xc900, 0xfbff, 0xfc00, 0xff23, 0xff23, 0xff23, 0xfe01, 0x8012,
  0xc900, 0xfbff, 0xfc00, 0xff23, 0xfe01, 0xff23, 0xfe01, 0x8001,
  0xfbff, 0xfc00, 0xff23, 0xfe01, 0xff23, 0xfe01, 0x8001, 0x0000,
  0xfbff, 0xff23, 0xfe01, 0x8012, 0xff23, 0xfe01, 0x0000, 0x0400,
  0xff23, 0xfe01, 0x8012, 0x83ff, 0xff23, 0xfe01, 0x0400, 0x37ff,
  0xfe01, 0x8012, 0x83ff, 0x8001, 0xff23, 0xfe01, 0x37ff, 0x3800,
  0x8012, 0x83ff, 0x8001, 0x0000, 0xff23, 0xfe01, 0x3800, 0x3801,
  0x83ff, 0x8001, 0x0000, 0x0400, 0xff23, 0xfe01, 0x3801, 0x3bff,
  0x8001, 0x0000, 0x0400, 0x37ff, 0xff23, 0xfe01, 0x3bff, 0x3c00,
  0x0000, 0x0400, 0x37ff, 0x3800, 0xff23, 0xfe01, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0x3801, 0xff23, 0xfe01, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0x3bff, 0xff23, 0xfe01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0x3c00, 0xff23, 0xfe01, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0x3c01, 0xff23, 0xfe01, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0x3e00, 0xff23, 0xfe01, 0x7c00, 0x83ff,
  0x3c00, 0x3c01, 0x3e00, 0x4900, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0x3c01, 0x3e00, 0x4900, 0x7bff, 0xff23, 0xfe01, 0x8012, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0x7c00, 0xff23, 0xfe01, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0xfe00, 0xff23, 0xfe01, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0012, 0x03ff,
  0x7c00, 0xfc00, 0xff23, 0x7f23, 0xff23, 0xfe01, 0x03ff, 0x0001,
  0xfbff, 0xfc00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0x0001, 0x8000,
  0xfbff, 0x7f23, 0x7e01, 0x0012, 0xff23, 0xfe01, 0x8000, 0x83ff,
  0x7f23, 0x7e01, 0x0012, 0x03ff, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0x7e01, 0x0012, 0x03ff, 0x0001, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0x0012, 0x03ff, 0x0001, 0x8000, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0x03ff, 0x0001, 0x8000, 0x8400, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0x0001, 0x8000, 0x8400, 0xb7ff, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0x8000, 0x8400, 0xb7ff, 0xb800, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0x8400, 0xb7ff, 0xb800, 0xb801, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0xb7ff, 0xb800, 0xb801, 0xbbff, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0xb800, 0xb801, 0xbbff, 0xbc00, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0xb801, 0xbbff, 0xbc00, 0xbc01, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0xbbff, 0xbc00, 0xbc01, 0xbe00, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0xbc00, 0xbc01, 0xbe00, 0xc900, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0xbc01, 0xbe00, 0xc900, 0xfbff, 0xff23, 0xfe01, 0x8012, 0xff23,
  0xbe00, 0xc900, 0xfbff, 0xfc00, 0xff23, 0xfe01, 0xff23, 0xfe01,
  0xc900, 0xfbff, 0xfc00, 0xfe00, 0xff23, 0xfe01, 0xfe01, 0x8012,
  0xfbff, 0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8012, 0x83ff,
  0xfbff, 0xfc00, 0xff23, 0xff23, 0xff23, 0xfe01, 0x8012, 0x8001,
  0xfc00, 0xff23, 0xff23, 0xff23, 0xfe01, 0x8012, 0x8001, 0x0000,
  0xfc00, 0xff23, 0xfe01, 0xff23, 0xfe01, 0x8001, 0x0000, 0x0400,
  0xff23, 0xfe01, 0x8012, 0xff23, 0xfe01, 0x0000, 0x0400, 0x37ff,
  0xfe01, 0x8012, 0x83ff, 0xff23, 0xfe01, 0x0400, 0x37ff, 0x3800,
  0x8012, 0x83ff, 0x8001, 0xff23, 0xfe01, 0x37ff, 0x3800, 0x3801,
  0x83ff, 0x8001, 0x0000, 0xff23, 0xfe01, 0x3800, 0x3801, 0x3bff,
  0x8001, 0x0000, 0x0400, 0xff23, 0xfe01, 0x3801, 0x3bff, 0x3c00,
  0x0000, 0x0400, 0x37ff, 0xff23, 0xfe01, 0x3bff, 0x3c00, 0x3c01,
  0x0400, 0x37ff, 0x3800, 0xff23, 0xfe01, 0x3c00, 0x3c01, 0x3e00,
  0x37ff, 0x3800, 0x3801, 0xff23, 0xfe01, 0x3c01, 0x3e00, 0x4900,
  0x3800, 0x3801, 0x3bff, 0xff23, 0xfe01, 0x3e00, 0x4900, 0x7bff,
  0x3801, 0x3bff, 0x3c00, 0xff23, 0xfe01, 0x4900, 0x7bff, 0x7c00,
  0x3bff, 0x3c00, 0x3c01, 0xff23, 0xfe01, 0x7bff, 0x7c00, 0x8001,
  0x3c00, 0x3c01, 0x3e00, 0xff23, 0xfe01, 0x7c00, 0x83ff, 0x8001,
  0x3c01, 0x3e00, 0x4900, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x7f23,
  0x3e00, 0x4900, 0x7bff, 0xff23, 0xfe01, 0x8012, 0x7f23, 0x7e01,
  0x4900, 0x7bff, 0x7c00, 0xff23, 0xfe01, 0x7f23, 0x7e01, 0x0012,
  0x7bff, 0x7c00, 0xfe00, 0xff23, 0xfe01, 0x7e01, 0x0012, 0x03ff,
  0x7c00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x0012, 0x03ff, 0x0001,
  0xfc00, 0xff23, 0x7f23, 0xff23, 0xfe01, 0x03ff, 0x0001, 0x8000,
  0xfc00, 0x7f23, 0x7e01, 0xff23, 0xfe01, 0x0001, 0x8000, 0x8001,
  0x7f23, 0x7e01, 0x0012, 0xff23, 0xfe01, 0x8000, 0x83ff, 0x8001,
  0x7e01, 0x0012, 0x03ff, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0x0012, 0x03ff, 0x0001, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0x03ff, 0x0001, 0x8000, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0x0001, 0x8000, 0x8400, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0x8000, 0x8400, 0xb7ff, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0x8400, 0xb7ff, 0xb800, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0xb7ff, 0xb800, 0xb801, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0xb800, 0xb801, 0xbbff, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0xb801, 0xbbff, 0xbc00, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0xbbff, 0xbc00, 0xbc01, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0xbc00, 0xbc01, 0xbe00, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
  0xbc01, 0xbe00, 0xc900, 0xff23, 0xfe01, 0x8012, 0x83ff, 0xff23,
  0xbe00, 0xc900, 0xfbff, 0xff23, 0xfe01, 0x8012, 0xff23, 0xfe01,
  0xc900, 0xfbff, 0xfc00, 0xff23, 0xfe01, 0xff23, 0xfe01, 0x8001,
  0xfbff, 0xfc00, 0xfe00, 0xff23, 0xfe01, 0xfe01, 0x8012, 0x8001,
  0xfc00, 0xff23, 0xfe00, 0xff23, 0xfe01, 0x8012, 0x83ff, 0x8001,
};
const unsigned kExpectedCount_NEON_fmaxnm_8H = 1444;

#endif  // VIXL_SIM_FMAXNM_8H_TRACE_AARCH64_H_
