/*
    Sketch Elements: Chemistry molecular diagram drawing tool.
    
    (c) 2008 Dr. Alex M. Clark
    
    Released as GNUware, under the Gnu Public License (GPL)
    
    See www.gnu.org for details.
*/

package WIMSchem;

import java.util.*;
import java.io.*;

/*
    Static data class which contains all of the information for a single truetype font, suitable for partial embedding in an SVG document.
*/

public class SVGFont
{
    // fonts are from 32..127, where character 32 starts at index 0

    public final static String FONT_FAMILY="Verdana";
    public final static int FONT_ADV=1041;
    public final static int UNITS_PER_EM=2048;
    public final static String PANOSE_1="2 11 6 4 3 5 4 4 2 4";
    public final static int ASCENT=2059;
    public final static int DESCENT=-430;
    
    public final static int MISSING_HORZ=2048;
    public final static String MISSING_DATA="M256 0V1536H1792V0H256ZM384 128H1664V1408H384V128Z";

    public final static String[] UNICODE=
    {
    	" ","!","&quot;","#","$","%","&amp;","&apos;","(",")","*","+",",","-",".","/","0","1","2","3","4","5","6","7","8","9",":",";",
	"&lt;","=","&gt;","?","@","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z",
	"[","\\","]","^","_","`","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z",
	"{","|","}","~","&#x80;"
    };
    public final static String[] GLYPH_NAME=
    {
    	"space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quotesingle","parenleft","parenright","asterisk","plus",
	"comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less",
	"equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X",
	"Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","grave","a","b","c","d","e","f","g","h","i","j","k",
	"l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","Adieresis"
    };
    public final static int[] HORIZ_ADV_X=
    {
    	720,806,940,1676,1302,2204,1488,550,930,930,1302,1676,745,930,745,930,1302,1302,1302,1302,1302,1302,1302,1302,1302,1302,930,930,
	1676,1676,1676,1117,2048,1400,1404,1430,1578,1295,1177,1588,1539,862,931,1419,1140,1726,1532,1612,1235,1612,1424,1400,1262,1499,
	1400,2025,1403,1260,1403,930,930,930,1676,1302,1302,1230,1276,1067,1276,1220,720,1276,1296,562,705,1212,562,1992,1296,1243,1276,
	1276,874,1067,807,1296,1212,1676,1212,1212,1076,1300,930,1300,1676,1400
    };
    public final static String[] GLYPH_DATA=
    {
	"",
	"M515 1489L489 410H319L291 1489H515ZM505 0H301V211H505V0Z",
	"M772 1556L729 977H597L554 1556H772ZM386 1556L343 977H211L168 1556H386Z",
	"M1481 932H1148L1056 556H1364V421H1021L917 0H788L892 421H622L518 0H389L493 421H195V556H528L620 932H312V1067H655L760 1489H889L784 1067H1054L1159 1489H1288L1183 1067H1481V932ZM1022\n"
	    +"934H748L654 554H928L1022 934Z",
	"M1160 380Q1160 225 1039 123T722 1V-361H604V-4Q472 -3 356 21T155 85V283H171Q190 269 239 243T334 199Q386 180 455 164T604 144V577Q564 585 530 592T467 608Q304 649 233 731T162 935Q162 1083\n"
	    +"278 1185T604 1304V1576H722V1306Q823 1304 929 1282T1107 1231V1035H1093Q1018 1081 937 1116T722 1161V730Q752 725 787 717T848 703Q997 671 1078 593T1160 380ZM604 747V1160Q497 1152 424 1102T351 961Q351 870 405 824T604 747ZM971 354Q971 448 913 491T722\n"
	    +"560V146Q842 158 906 207T971 354Z",
	"M884 1076Q884 852 790 743T517 634Q335 634 242 743T149 1075Q149 1299 244 1408T517 1517Q698 1517 791 1407T884 1076ZM1575 1489L795 0H630L1410 1489H1575ZM2055 413Q2055 189 1960 80T1687\n"
	    +"-29Q1506 -29 1413 81T1320 412Q1320 636 1414 745T1687 854Q1869 854 1962 745T2055 413ZM706 1076Q706 1248 662 1316T517 1384Q415 1384 371 1316T327 1075Q327 902 371 835T517 767Q617 767 661 834T706 1076ZM1877 413Q1877 585 1833 653T1688 721Q1586 721\n"
	    +"1542 653T1498 412Q1498 239 1542 172T1688 104Q1788 104 1832 171T1877 413Z",
	"M792 1191Q792 1286 736 1340T591 1395Q499 1395 441 1334T383 1183Q383 1108 422 1050T593 913Q691 948 741 1015T792 1191ZM986 315L508 781Q477 766 446 742T384 675Q356 636 338 581T320\n"
	    +"457Q320 311 405 222T648 132Q741 132 832 177T986 315ZM1287 909V813Q1287 717 1262 597T1177 368L1555 0H1309L1080 224Q965 82 845 26T598 -31Q390 -31 253 90T115 409Q115 501 141 568T202 684Q237 731 289 772T394 845Q284 917 236 990T187 1174Q187 1241\n"
	    +"213 1301T293 1412Q343 1460 423 1490T601 1520Q774 1520 881 1433T988 1211Q988 1167 976 1112T935 1012Q903 963 844 918T691 841L1062 479Q1076 519 1083 567T1091 667Q1093 723 1093 792T1092 909H1287Z",
	"M386 1556L343 977H207L164 1556H386Z",
	"M783 -412H554Q377 -209 279 31T181 572Q181 873 279 1113T554 1556H783V1546Q702 1473 629 1378T492 1155Q432 1032 395 884T357 572Q357 401 393 259T492 -11Q552 -134 629 -233T783 -402V-412Z",
	"M749 572Q749 271 651 31T376 -412H147V-402Q224 -333 301 -234T438 -11Q500 117 536 259T573 572Q573 736 536 884T438 1155Q375 1282 302 1377T147 1546V1556H376Q553 1353 651 1113T749 572Z",
	"M1137 887L1073 777L711 990L717 630H588L593 990L232 776L167 886L548 1093L167 1300L232 1410L594 1197L588 1556H717L710 1197L1073 1409L1137 1299L757 1094L1137 887Z",
	"M1466 572H921V27H755V572H210V732H755V1277H921V732H1466V572Z",
	"M575 285L293 -370H147L321 285H575Z",
	"M777 561H153V742H777V561Z",
	"M492 0H253V285H492V0Z",
	"M860 1556L143 -304H-30L684 1556H860Z",
	"M1167 745Q1167 344 1042 157T652 -31Q384 -31 261 159T137 743Q137 1140 262 1329T652 1519Q920 1519 1043 1327T1167 745ZM904 291Q939 372 951 481T964 745Q964 897 952 1009T903 1199Q868 1276\n"
	    +"808 1315T652 1354Q558 1354 497 1315T399 1197Q365 1123 353 1004T340 743Q340 587 351 482T398 294Q431 216 491 175T652 134Q746 134 808 173T904 291Z",
	"M1084 0H278V152H588V1150H278V1286Q341 1286 413 1296T522 1327Q568 1352 594 1390T625 1494H780V152H1084V0Z",
	"M1169 0H161V209Q266 299 371 389T568 568Q760 754 831 863T902 1100Q902 1216 826 1281T612 1347Q521 1347 415 1315T208 1217H198V1427Q269 1462 387 1491T617 1520Q846 1520 976 1410T1106 1110Q1106\n"
	    +"1025 1085 952T1021 812Q982 750 930 690T802 557Q695 452 581 354T368 171H1169V0Z",
	"M1038 717Q1086 674 1117 609T1148 441Q1148 339 1111 254T1007 106Q932 36 831 3T608 -31Q484 -31 364 -2T167 63V272H182Q267 216 382 179T604 142Q667 142 738 163T853 225Q899 269 921 322T944\n"
	    +"456Q944 536 919 588T848 671Q803 702 739 713T601 725H511V891H581Q733 891 823 954T914 1140Q914 1194 891 1234T827 1301Q784 1327 735 1337T624 1347Q529 1347 422 1313T220 1217H210V1426Q281 1461 399 1490T629 1520Q738 1520 821 1500T971 1436Q1043 1388\n"
	    +"1080 1320T1117 1161Q1117 1037 1030 945T823 828V814Q871 806 933 781T1038 717Z",
	"M1203 419H982V0H790V419H77V649L798 1489H982V579H1203V419ZM790 579V1251L213 579H790Z",
	"M1157 473Q1157 369 1119 274T1015 114Q943 44 844 7T613 -31Q491 -31 378 -6T187 56V267H201Q283 215 393 179T609 142Q680 142 746 162T865 232Q909 275 931 335T954 474Q954 551 928 604T854 689Q802\n"
	    +"727 728 742T561 758Q473 758 392 746T251 722V1489H1147V1314H444V918Q487 922 532 924T610 926Q731 926 822 906T989 833Q1069 778 1113 691T1157 473Z",
	"M1191 483Q1191 256 1042 113T675 -31Q565 -31 475 3T316 104Q230 187 184 324T137 654Q137 852 179 1005T315 1277Q403 1390 542 1453T866 1517Q925 1517 965 1512T1046 1494V1303H1036Q1008 1318\n"
	    +"952 1331T836 1345Q621 1345 493 1211T344 847Q428 898 509 924T698 951Q793 951 865 934T1014 863Q1102 802 1146 709T1191 483ZM988 475Q988 568 961 629T870 735Q824 767 768 777T651 787Q566 787 493 767T343 705Q341 683 340 663T339 611Q339 453 371 362T461\n"
	    +"217Q507 173 560 153T677 132Q822 132 905 220T988 475Z",
	"M1173 1266L499 0H285L1002 1314H154V1489H1173V1266Z",
	"M1180 415Q1180 222 1030 94T651 -34Q409 -34 266 91T122 411Q122 535 194 635T397 795V801Q277 865 220 941T162 1131Q162 1299 300 1411T651 1523Q874 1523 1007 1416T1140 1144Q1140 1043 1077\n"
	    +"946T892 793V787Q1032 727 1106 639T1180 415ZM943 1142Q943 1249 861 1312T650 1376Q524 1376 444 1316T363 1154Q363 1082 403 1030T526 936Q563 918 632 889T768 841Q867 907 905 978T943 1142ZM974 396Q974 488 934 543T775 655Q728 677 672 696T523 749Q433\n"
	    +"700 379 616T324 426Q324 291 417 203T653 115Q799 115 886 190T974 396Z",
	"M1167 834Q1167 639 1123 480T988 209Q897 95 760 33T438 -29Q386 -29 340 -24T258 -6V185H268Q297 170 350 157T468 143Q689 143 814 275T960 641Q867 585 785 561T606 537Q514 537 440 555T290 625Q202\n"
	    +"686 158 780T113 1005Q113 1233 263 1376T629 1519Q737 1519 829 1486T990 1385Q1075 1302 1121 1172T1167 834ZM965 877Q965 1032 933 1126T845 1272Q798 1317 744 1336T627 1356Q483 1356 400 1266T316 1013Q316 918 343 858T434 753Q479 722 533 712T653 701Q731\n"
	    +"701 811 722T961 783Q962 804 963 824T965 877Z",
	"M585 832H346V1117H585V832ZM585 0H346V285H585V0Z",
	"M585 832H346V1117H585V832ZM658 285L376 -370H230L404 285H658Z",
	"M1408 77L254 590V714L1408 1227V1047L498 652L1408 257V77Z",
	"M1431 782H245V942H1431V782ZM1431 362H245V522H1431V362Z",
	"M1422 590L268 77V257L1178 652L268 1047V1227L1422 714V590Z",
	"M1005 1139Q1005 1041 970 965T878 829Q822 772 749 722T594 625V400H415V705Q480 742 555 786T679 875Q737 927 769 982T801 1124Q801 1237 725 1292T527 1348Q419 1348 323 1314T170 1245H160V1449Q230\n"
	    +"1476 337 1497T541 1519Q756 1519 880 1415T1005 1139ZM610 0H406V211H610V0Z",
	"M1870 663Q1870 524 1830 394T1714 157H1274L1247 273Q1173 213 1105 181T949 149Q781 149 681 276T580 631Q580 858 703 993T997 1128Q1070 1128 1126 1112T1247 1062V1110H1406V268H1649Q1691 343\n"
	    +"1712 455T1734 657Q1734 821 1689 955T1555 1185Q1467 1281 1337 1332T1042 1384Q882 1384 750 1326T522 1170Q426 1072 372 936T317 645Q317 480 369 344T516 110Q615 9 748 -42T1038 -94Q1124 -94 1215 -83T1391 -48V-190Q1294 -211 1210 -218T1037 -226Q851\n"
	    +"-226 692 -163T419 15Q304 130 240 291T176 647Q176 832 243 991T426 1268Q542 1385 701 1452T1041 1519Q1237 1519 1391 1457T1651 1283Q1757 1171 1813 1014T1870 663ZM1245 408V926Q1182 955 1132 967T1025 980Q896 980 823 890T750 634Q750 471 808 388T989\n"
	    +"304Q1056 304 1123 335T1245 408Z",
	"M1374 0H1163L1017 415H373L227 0H26L568 1489H832L1374 0ZM956 585L695 1316L433 585H956Z",
	"M1323 458Q1323 347 1281 262T1168 122Q1084 56 984 28T728 0H200V1489H641Q804 1489 885 1477T1040 1427Q1122 1384 1159 1317T1196 1155Q1196 1049 1142 975T998 855V847Q1149 816 1236 715T1323 458ZM990\n"
	    +"1129Q990 1183 972 1220T914 1280Q867 1307 800 1313T634 1320H398V890H654Q747 890 802 899T904 939Q951 969 970 1016T990 1129ZM1117 450Q1117 540 1090 593T992 683Q944 708 876 715T709 723H398V169H660Q790 169 873 182T1009 232Q1065 271 1091 321T1117\n"
	    +"450Z",
	"M1350 108Q1295 84 1251 63T1134 19Q1073 0 1002 -13T844 -27Q682 -27 550 18T319 161Q223 256 169 402T115 743Q115 927 167 1072T317 1317Q412 1414 546 1465T845 1516Q965 1516 1084 1487T1350 1385V1150H1335Q1212\n"
	    +"1253 1091 1300T832 1347Q719 1347 629 1311T467 1197Q398 1122 360 1008T321 743Q321 586 363 473T473 289Q543 215 636 180T834 144Q977 144 1102 193T1336 340H1350V108Z",
	"M1458 743Q1458 540 1370 375T1134 119Q1032 56 907 28T576 0H200V1489H572Q790 1489 918 1458T1136 1371Q1288 1276 1373 1118T1458 743ZM1251 746Q1251 921 1190 1041T1008 1230Q920 1280 821 1299T584\n"
	    +"1319H398V170H584Q727 170 833 191T1029 269Q1140 340 1195 456T1251 746Z",
	"M1181 0H200V1489H1181V1313H398V905H1181V729H398V176H1181V0Z",
	"M1151 1313H398V893H1045V717H398V0H200V1489H1151V1313Z",
	"M1442 110Q1320 54 1176 13T896 -29Q722 -29 577 19T330 163Q227 260 171 405T115 746Q115 1103 323 1309T896 1516Q1023 1516 1155 1486T1441 1382V1147H1423Q1392 1171 1333 1210T1217 1275Q1148 1306\n"
	    +"1061 1326T862 1347Q612 1347 467 1187T321 752Q321 463 473 303T887 142Q983 142 1078 161T1246 210V575H847V749H1442V110Z",
	"M1339 0H1141V729H398V0H200V1489H398V905H1141V1489H1339V0Z",
	"M725 0H137V152H332V1337H137V1489H725V1337H530V152H725V0Z",
	"M746 387Q746 191 627 85T306 -21Q258 -21 178 -13T44 8V193H55Q96 179 156 164T279 149Q371 149 425 170T506 230Q533 270 540 328T548 462V1331H233V1489H746V387Z",
	"M1397 0H1140L551 663L403 505V0H205V1489H403V712L1126 1489H1366L701 789L1397 0Z",
	"M1142 0H200V1489H398V176H1142V0Z",
	"M1526 0H1328V1283L914 410H796L385 1283V0H200V1489H470L867 660L1251 1489H1526V0Z",
	"M1336 0H1091L385 1332V0H200V1489H507L1151 273V1489H1336V0Z",
	"M1310 1318Q1401 1218 1449 1073T1498 744Q1498 560 1449 415T1310 172Q1218 71 1093 20T806 -31Q649 -31 521 21T302 172Q212 271 164 415T115 744Q115 926 163 1070T303 1318Q391 1416 521 1468T806\n"
	    +"1520Q966 1520 1093 1468T1310 1318ZM1292 744Q1292 1034 1162 1191T807 1349Q580 1349 451 1192T321 744Q321 451 453 296T807 140Q1029 140 1160 295T1292 744Z",
	"M1174 1039Q1174 940 1140 856T1043 709Q966 632 861 594T596 555H398V0H200V1489H604Q738 1489 831 1467T996 1396Q1081 1339 1127 1254T1174 1039ZM968 1034Q968 1111 941 1168T859 1261Q811 1292 750\n"
	    +"1305T594 1319H398V724H565Q685 724 760 745T882 814Q929 862 948 915T968 1034Z",
	"M1528 -365Q1468 -380 1410 -386T1290 -393Q1116 -393 1011 -298T896 -24Q872 -28 850 -29T806 -31Q649 -31 521 21T302 172Q212 271 164 415T115 744Q115 926 163 1070T303 1318Q391 1416 521 1468T806\n"
	    +"1520Q966 1520 1093 1468T1310 1318Q1401 1218 1449 1073T1498 744Q1498 471 1387 284T1087 22Q1091 -92 1141 -155T1323 -218Q1364 -218 1420 -206T1501 -183H1528V-365ZM1292 744Q1292 1034 1162 1191T807 1349Q580 1349 451 1192T321 744Q321 451 453 296T807\n"
	    +"140Q1029 140 1160 295T1292 744Z",
	"M1432 0H1175L677 592H398V0H200V1489H617Q752 1489 842 1472T1004 1409Q1085 1358 1130 1281T1176 1084Q1176 923 1095 815T872 651L1432 0ZM969 1070Q969 1134 947 1183T872 1267Q829 1296 770 1307T631\n"
	    +"1319H398V757H598Q692 757 762 773T881 835Q926 877 947 931T969 1070Z",
	"M1282 425Q1282 338 1242 253T1128 109Q1048 45 942 9T685 -27Q524 -27 396 3T134 92V340H148Q261 246 409 195T687 144Q871 144 973 213T1076 397Q1076 496 1028 543T880 616Q805 636 718 649T532 682Q334\n"
	    +"724 239 825T143 1090Q143 1277 301 1396T702 1516Q859 1516 990 1486T1222 1412V1178H1208Q1123 1250 985 1297T701 1345Q542 1345 446 1279T349 1109Q349 1016 397 963T566 882Q630 868 748 848T948 807Q1114 763 1198 674T1282 425Z",
	"M1262 1313H730V0H532V1313H0V1489H1262V1313Z",
	"M1321 598Q1321 436 1286 316T1169 115Q1092 39 989 4T749 -31Q609 -31 505 6T330 115Q249 197 214 313T178 598V1489H376V588Q376 467 392 397T448 270Q492 205 567 172T749 139Q856 139 931 171T1051\n"
	    +"270Q1090 327 1106 400T1123 583V1489H1321V598Z",
	"M1374 1489L832 0H568L26 1489H238L705 179L1172 1489H1374Z",
	"M1933 1489L1546 0H1323L1010 1236L704 0H486L92 1489H295L608 251L916 1489H1117L1428 239L1739 1489H1933Z",
	"M1336 1489L822 753L1335 0H1106L700 613L284 0H68L587 744L80 1489H308L709 884L1119 1489H1336Z",
	"M1254 1489L730 653V0H532V632L6 1489H225L632 823L1043 1489H1254Z",
	"M1288 0H126V184L1039 1313H160V1489H1266V1310L344 176H1288V0Z",
	"M759 -392H239V1556H759V1413H413V-249H759V-392Z",
	"M960 -304H787L70 1556H246L960 -304Z",
	"M691 -392H171V-249H517V1413H171V1556H691V-392Z",
	"M1490 684H1292L837 1311L383 682H186L775 1489H901L1490 684Z",
	"M1306 -300H-4V-180H1306V-300Z",
	"M762 1302H613L340 1676H583L762 1302Z",
	"M1053 0H866V119Q841 102 799 72T716 23Q669 0 608 -15T465 -31Q314 -31 209 69T104 324Q104 451 158 529T314 653Q416 698 559 714T866 738V767Q866 831 844 873T779 939Q739 962 683 970T566 978Q492\n"
	    +"978 401 959T213 902H203V1093Q258 1108 362 1126T567 1144Q685 1144 772 1125T924 1058Q987 1012 1020 939T1053 758V0ZM866 275V586Q780 581 664 571T479 542Q398 519 348 471T298 337Q298 241 356 193T533 144Q632 144 714 182T866 275Z",
	"M1168 567Q1168 427 1129 315T1022 127Q951 48 866 9T679 -31Q584 -31 513 -9T373 52L361 0H185V1556H373V1000Q452 1065 541 1106T741 1148Q939 1148 1053 996T1168 567ZM974 562Q974 762 908 865T695\n"
	    +"969Q613 969 529 934T373 842V202Q453 166 510 152T641 138Q797 138 885 240T974 562Z",
	"M1011 70Q917 25 833 0T653 -25Q532 -25 431 10T258 118Q185 190 145 300T105 557Q105 831 255 987T653 1143Q749 1143 841 1116T1011 1050V841H1001Q915 908 824 944T645 980Q485 980 393 873T300 557Q300\n"
	    +"355 390 247T645 138Q702 138 761 153T867 192Q908 213 944 236T1001 277H1011V70Z",
	"M1091 0H903V117Q822 47 734 8T543 -31Q343 -31 226 123T108 550Q108 692 148 803T258 992Q326 1068 416 1108T604 1148Q692 1148 760 1130T903 1072V1556H1091V0ZM903 275V916Q827 950 767 963T636 976Q478\n"
	    +"976 390 866T302 554Q302 355 370 252T588 148Q668 148 750 183T903 275Z",
	"M1120 539H297Q297 436 328 360T413 234Q465 186 536 162T694 138Q808 138 923 183T1088 273H1098V68Q1003 28 904 1T696 -26Q418 -26 262 124T106 552Q106 826 255 987T649 1148Q875 1148 997 1016T1120\n"
	    +"641V539ZM937 683Q936 831 863 912T639 993Q488 993 399 904T297 683H937Z",
	"M786 1374H776Q745 1383 695 1392T607 1402Q486 1402 432 1349T377 1155V1117H716V959H383V0H195V959H68V1117H195V1154Q195 1353 294 1459T580 1566Q643 1566 693 1560T786 1546V1374Z",
	"M1091 127Q1091 -157 962 -290T565 -423Q476 -423 392 -411T225 -375V-183H235Q281 -201 381 -227T581 -254Q677 -254 740 -231T838 -167Q873 -128 888 -73T903 50V152Q818 84 741 51T543 17Q343 17 226\n"
	    +"161T108 569Q108 713 148 817T259 998Q324 1069 417 1108T602 1148Q699 1148 764 1129T903 1069L915 1117H1091V127ZM903 307V916Q828 950 764 964T635 979Q480 979 391 875T302 573Q302 385 368 288T587 191Q669 191 751 222T903 307Z",
	"M1119 0H931V636Q931 713 922 780T889 886Q864 928 817 948T695 969Q618 969 534 931T373 834V0H185V1556H373V993Q461 1066 555 1107T748 1148Q929 1148 1024 1039T1119 725V0Z",
	"M387 1304H175V1499H387V1304ZM375 0H187V1117H375V0Z",
	"M533 1304H321V1499H533V1304ZM521 -27Q521 -223 421 -323T153 -423Q113 -423 48 -415T-62 -395V-216H-52Q-24 -227 23 -241T116 -255Q188 -255 232 -235T298 -175Q320 -135 326 -79T333 59V959H100V1117H521V-27Z",
	"M1199 0H951L503 489L381 373V0H193V1556H381V558L924 1117H1161L642 601L1199 0Z",
	"M375 0H187V1556H375V0Z",
	"M1815 0H1627V636Q1627 708 1621 775T1593 882Q1570 925 1527 947T1403 969Q1324 969 1245 930T1087 829Q1090 806 1092 776T1094 715V0H906V636Q906 710 900 776T872 883Q849 926 806 947T682 969Q605\n"
	    +"969 528 931T373 834V0H185V1117H373V993Q461 1066 548 1107T735 1148Q849 1148 928 1100T1047 967Q1161 1063 1255 1105T1456 1148Q1640 1148 1727 1037T1815 725V0Z",
	"M1119 0H931V636Q931 713 922 780T889 886Q864 928 817 948T695 969Q618 969 534 931T373 834V0H185V1117H373V993Q461 1066 555 1107T748 1148Q929 1148 1024 1039T1119 725V0Z",
	"M1137 558Q1137 285 997 127T622 -31Q385 -31 246 127T106 558Q106 831 245 989T622 1148Q857 1148 997 990T1137 558ZM943 558Q943 775 858 880T622 986Q469 986 385 881T300 558Q300 348 385 240T622\n"
	    +"131Q772 131 857 238T943 558Z",
	"M1168 572Q1168 436 1129 324T1019 133Q953 59 864 19T674 -22Q587 -22 517 -3T373 56V-412H185V1117H373V1000Q448 1063 541 1105T741 1148Q943 1148 1055 996T1168 572ZM974 567Q974 769 905 869T693\n"
	    +"969Q612 969 530 934T373 842V209Q453 173 510 160T641 147Q798 147 886 253T974 567Z",
	"M1091 -412H903V126Q816 51 730 15T544 -22Q345 -22 227 131T108 555Q108 699 149 809T259 995Q325 1068 414 1108T602 1148Q692 1148 761 1128T903 1069L915 1117H1091V-412ZM903 284V916Q825 951 765\n"
	    +"965T635 979Q472 979 387 869T302 564Q302 368 370 263T586 157Q668 157 750 192T903 284Z",
	"M882 912H872Q830 922 791 926T697 931Q610 931 529 893T373 793V0H185V1117H373V952Q485 1042 570 1079T745 1117Q794 1117 816 1115T882 1105V912Z",
	"M983 322Q983 169 857 71T511 -27Q387 -27 284 2T110 67V278H120Q209 211 318 172T527 132Q651 132 721 172T791 298Q791 364 753 398Q715 432 607 456Q567 465 503 477T385 503Q238 542 177 617T115\n"
	    +"803Q115 872 143 933T230 1042Q286 1089 372 1116T566 1144Q666 1144 768 1120T939 1060V859H929Q857 912 754 948T552 985Q449 985 378 946T307 828Q307 759 350 724Q392 689 486 667Q538 655 602 643T710 621Q841 591 912 518Q983 444 983 322Z",
	"M765 10Q712 -4 650 -13T538 -22Q367 -22 278 70T189 365V959H62V1117H189V1438H377V1117H765V959H377V450Q377 362 381 313T409 220Q431 180 469 162T587 143Q633 143 683 156T755 179H765V10Z",
	"M1111 0H923V124Q828 49 741 9T549 -31Q373 -31 275 76T177 392V1117H365V481Q365 396 373 336T407 232Q434 188 477 168T602 148Q675 148 761 186T923 283V1117H1111V0Z",
	"M1151 1117L699 0H510L61 1117H265L611 228L954 1117H1151Z",
	"M1590 1117L1299 0H1125L838 861L553 0H380L86 1117H282L487 252L766 1117H921L1207 252L1401 1117H1590Z",
	"M1152 0H915L598 429L279 0H60L496 557L64 1117H301L616 695L932 1117H1152L713 567L1152 0Z",
	"M1151 1117L499 -412H298L506 54L61 1117H265L608 289L954 1117H1151Z",
	"M995 0H93V139L744 960H107V1117H978V983L324 159H995V0Z",
	"M1113 -392H963Q784 -392 673 -293T561 -5V144Q561 313 478 408T224 504H173V660H224Q395 660 478 755T561 1020V1169Q561 1357 672 1456T963 1556H1113V1418H999Q863 1418 802 1355T740 1152V977Q740\n"
	    +"838 663 744T449 594V570Q586 515 663 421T740 187V12Q740 -128 801 -191T999 -254H1113V-392Z",
	"M552 -392H378V1556H552V-392Z",
	"M1127 504H1076Q905 504 822 409T739 144V-5Q739 -193 628 -292T337 -392H187V-254H301Q437 -254 498 -191T560 12V187Q560 326 637 420T851 570V594Q714 649 637 743T560 977V1152Q560 1292\n"
	    +"499 1355T301 1418H187V1556H337Q516 1556 627 1457T739 1169V1020Q739 851 822 756T1076 660H1127V504Z",
	"M1489 927Q1487 828 1467 732T1401 561Q1355 484 1290 440T1125 396Q1031 396 958 435T801 577Q699 702 653 734T557 766Q463 766 413 679T354 395H187Q189 495 209 589T274 761Q317 835 386\n"
	    +"880T551 926Q644 926 717 888T876 745Q956 647 1007 602T1119 556Q1222 556 1270 657T1322 927H1489Z",
	"M1374 0H1163L1017 415H373L227 0H26L568 1489H832L1374 0ZM956 585L695 1316L433 585H956ZM1005 1677H806V1872H1005V1677ZM592 1677H393V1872H592V1677Z"
    };
    public final static int[] KERN_G1=
    {
    	7,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,33,33,33,33,33,33,33,33,33,33,33,33,34,34,34,34,35,36,36,36,36,36,36,36,
	38,38,38,38,38,38,38,38,38,38,41,42,42,42,43,43,43,43,43,43,43,43,43,44,44,44,44,44,44,44,44,44,44,44,44,47,47,47,47,47,47,48,48,
	48,48,48,48,48,49,49,50,50,50,50,50,50,50,50,51,51,51,51,51,51,51,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,
	52,52,52,53,53,53,54,54,54,54,54,54,54,54,54,54,54,55,55,55,55,55,55,55,55,55,55,55,55,56,56,56,56,56,56,56,56,56,57,57,57,57,57,
	57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,58,58,58,58,58,58,58,58,58,58,65,65,65,66,66,66,67,67,69,70,70,70,70,70,70,70,70,70,
	70,70,70,72,72,72,75,75,75,77,77,77,78,78,78,79,79,79,79,79,80,80,80,82,82,82,82,84,84,86,86,86,86,86,86,87,87,87,87,88,88,88,88,
	88,88,89,89,89,89,89,89,89,89,89,89,90,90,90,90,90,90,90
    };
    public final static int[] KERN_G2=
    {
    	33,33,41,42,51,52,54,55,56,57,58,65,86,87,88,89,90,12,13,13,51,52,53,54,55,57,84,85,86,87,89,12,13,14,52,13,12,14,52,55,56,57,58,
	12,14,26,27,31,33,52,65,69,79,13,12,14,33,13,47,65,69,79,85,86,87,89,7,13,35,39,42,47,52,54,55,57,86,89,12,14,52,56,57,58,12,14,
	33,57,65,69,79,12,14,13,52,57,65,69,79,85,89,12,14,33,51,86,87,89,12,13,14,26,27,31,33,35,39,47,51,52,65,67,69,71,79,82,83,85,86,
	87,89,90,12,14,33,12,13,14,26,27,33,65,69,79,85,89,12,13,14,26,27,33,65,69,79,82,85,89,13,35,39,47,65,69,79,85,89,12,13,14,26,27,
	33,47,65,68,69,71,77,78,79,80,81,82,83,85,86,13,35,39,47,58,65,69,79,87,89,86,87,89,12,14,89,13,52,52,2,7,9,10,12,13,14,31,60,61,
	89,93,86,87,89,13,69,79,86,87,89,86,87,89,12,14,86,88,89,12,14,89,12,13,14,65,13,89,12,13,14,65,69,79,12,13,14,65,13,67,68,69,71,
	79,12,13,14,65,67,68,69,71,79,81,13,67,68,69,71,79,81
    };
    public final static int[] KERN_K=
    {
    	100,50,30,100,20,150,50,50,80,140,30,20,40,20,50,40,40,130,160,50,10,120,10,60,50,80,20,10,50,30,50,20,-10,20,60,50,50,50,50,20,
	10,20,20,300,300,60,60,-60,100,-30,100,50,50,30,20,20,10,110,20,60,70,70,50,80,70,80,120,160,20,20,-100,20,170,110,100,160,110,
	110,30,30,50,10,20,20,300,300,50,-20,50,50,50,30,30,100,60,20,40,50,50,20,55,20,20,20,22,30,20,30,290,150,290,200,200,-60,120,40,
	40,50,12,70,240,220,220,210,220,200,180,200,200,200,200,170,20,20,10,290,50,290,80,80,60,100,100,100,60,65,290,50,220,80,80,50,
	100,100,100,60,60,65,80,10,10,10,50,60,60,30,80,290,140,290,200,200,80,20,140,120,130,130,100,100,130,100,130,100,110,110,100,60,
	20,20,20,10,50,60,60,40,65,16,10,16,30,20,5,20,60,140,-60,-60,-100,-50,130,50,120,-110,-100,-100,10,-100,20,10,20,100,20,20,20,10,
	20,20,10,20,30,20,15,20,15,30,20,5,290,20,290,36,40,10,180,40,180,40,18,18,70,20,70,20,50,20,10,24,10,24,190,40,190,40,18,10,18,
	10,18,10,20,10,10,12,10,12,10
    };
}
