// SPDX-FileCopyrightText: Copyright 2022 yuzu Emulator Project
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "common/common_types.h"

namespace Tegra {

// https://github.com/NVIDIA/open-gpu-doc/blob/master/manuals/volta/gv100/dev_mmu.ref.txt
enum class PTEKind : u8 {
    INVALID = 0xff,
    PITCH = 0x00,
    Z16 = 0x01,
    Z16_2C = 0x02,
    Z16_MS2_2C = 0x03,
    Z16_MS4_2C = 0x04,
    Z16_MS8_2C = 0x05,
    Z16_MS16_2C = 0x06,
    Z16_2Z = 0x07,
    Z16_MS2_2Z = 0x08,
    Z16_MS4_2Z = 0x09,
    Z16_MS8_2Z = 0x0a,
    Z16_MS16_2Z = 0x0b,
    Z16_2CZ = 0x36,
    Z16_MS2_2CZ = 0x37,
    Z16_MS4_2CZ = 0x38,
    Z16_MS8_2CZ = 0x39,
    Z16_MS16_2CZ = 0x5f,
    Z16_4CZ = 0x0c,
    Z16_MS2_4CZ = 0x0d,
    Z16_MS4_4CZ = 0x0e,
    Z16_MS8_4CZ = 0x0f,
    Z16_MS16_4CZ = 0x10,
    S8Z24 = 0x11,
    S8Z24_1Z = 0x12,
    S8Z24_MS2_1Z = 0x13,
    S8Z24_MS4_1Z = 0x14,
    S8Z24_MS8_1Z = 0x15,
    S8Z24_MS16_1Z = 0x16,
    S8Z24_2CZ = 0x17,
    S8Z24_MS2_2CZ = 0x18,
    S8Z24_MS4_2CZ = 0x19,
    S8Z24_MS8_2CZ = 0x1a,
    S8Z24_MS16_2CZ = 0x1b,
    S8Z24_2CS = 0x1c,
    S8Z24_MS2_2CS = 0x1d,
    S8Z24_MS4_2CS = 0x1e,
    S8Z24_MS8_2CS = 0x1f,
    S8Z24_MS16_2CS = 0x20,
    S8Z24_4CSZV = 0x21,
    S8Z24_MS2_4CSZV = 0x22,
    S8Z24_MS4_4CSZV = 0x23,
    S8Z24_MS8_4CSZV = 0x24,
    S8Z24_MS16_4CSZV = 0x25,
    V8Z24_MS4_VC12 = 0x26,
    V8Z24_MS4_VC4 = 0x27,
    V8Z24_MS8_VC8 = 0x28,
    V8Z24_MS8_VC24 = 0x29,
    V8Z24_MS4_VC12_1ZV = 0x2e,
    V8Z24_MS4_VC4_1ZV = 0x2f,
    V8Z24_MS8_VC8_1ZV = 0x30,
    V8Z24_MS8_VC24_1ZV = 0x31,
    V8Z24_MS4_VC12_2CS = 0x32,
    V8Z24_MS4_VC4_2CS = 0x33,
    V8Z24_MS8_VC8_2CS = 0x34,
    V8Z24_MS8_VC24_2CS = 0x35,
    V8Z24_MS4_VC12_2CZV = 0x3a,
    V8Z24_MS4_VC4_2CZV = 0x3b,
    V8Z24_MS8_VC8_2CZV = 0x3c,
    V8Z24_MS8_VC24_2CZV = 0x3d,
    V8Z24_MS4_VC12_2ZV = 0x3e,
    V8Z24_MS4_VC4_2ZV = 0x3f,
    V8Z24_MS8_VC8_2ZV = 0x40,
    V8Z24_MS8_VC24_2ZV = 0x41,
    V8Z24_MS4_VC12_4CSZV = 0x42,
    V8Z24_MS4_VC4_4CSZV = 0x43,
    V8Z24_MS8_VC8_4CSZV = 0x44,
    V8Z24_MS8_VC24_4CSZV = 0x45,
    Z24S8 = 0x46,
    Z24S8_1Z = 0x47,
    Z24S8_MS2_1Z = 0x48,
    Z24S8_MS4_1Z = 0x49,
    Z24S8_MS8_1Z = 0x4a,
    Z24S8_MS16_1Z = 0x4b,
    Z24S8_2CS = 0x4c,
    Z24S8_MS2_2CS = 0x4d,
    Z24S8_MS4_2CS = 0x4e,
    Z24S8_MS8_2CS = 0x4f,
    Z24S8_MS16_2CS = 0x50,
    Z24S8_2CZ = 0x51,
    Z24S8_MS2_2CZ = 0x52,
    Z24S8_MS4_2CZ = 0x53,
    Z24S8_MS8_2CZ = 0x54,
    Z24S8_MS16_2CZ = 0x55,
    Z24S8_4CSZV = 0x56,
    Z24S8_MS2_4CSZV = 0x57,
    Z24S8_MS4_4CSZV = 0x58,
    Z24S8_MS8_4CSZV = 0x59,
    Z24S8_MS16_4CSZV = 0x5a,
    Z24V8_MS4_VC12 = 0x5b,
    Z24V8_MS4_VC4 = 0x5c,
    Z24V8_MS8_VC8 = 0x5d,
    Z24V8_MS8_VC24 = 0x5e,
    YUV_B8C1_2Y = 0x60,
    YUV_B8C2_2Y = 0x61,
    YUV_B10C1_2Y = 0x62,
    YUV_B10C2_2Y = 0x6b,
    YUV_B12C1_2Y = 0x6c,
    YUV_B12C2_2Y = 0x6d,
    Z24V8_MS4_VC12_1ZV = 0x63,
    Z24V8_MS4_VC4_1ZV = 0x64,
    Z24V8_MS8_VC8_1ZV = 0x65,
    Z24V8_MS8_VC24_1ZV = 0x66,
    Z24V8_MS4_VC12_2CS = 0x67,
    Z24V8_MS4_VC4_2CS = 0x68,
    Z24V8_MS8_VC8_2CS = 0x69,
    Z24V8_MS8_VC24_2CS = 0x6a,
    Z24V8_MS4_VC12_2CZV = 0x6f,
    Z24V8_MS4_VC4_2CZV = 0x70,
    Z24V8_MS8_VC8_2CZV = 0x71,
    Z24V8_MS8_VC24_2CZV = 0x72,
    Z24V8_MS4_VC12_2ZV = 0x73,
    Z24V8_MS4_VC4_2ZV = 0x74,
    Z24V8_MS8_VC8_2ZV = 0x75,
    Z24V8_MS8_VC24_2ZV = 0x76,
    Z24V8_MS4_VC12_4CSZV = 0x77,
    Z24V8_MS4_VC4_4CSZV = 0x78,
    Z24V8_MS8_VC8_4CSZV = 0x79,
    Z24V8_MS8_VC24_4CSZV = 0x7a,
    ZF32 = 0x7b,
    ZF32_1Z = 0x7c,
    ZF32_MS2_1Z = 0x7d,
    ZF32_MS4_1Z = 0x7e,
    ZF32_MS8_1Z = 0x7f,
    ZF32_MS16_1Z = 0x80,
    ZF32_2CS = 0x81,
    ZF32_MS2_2CS = 0x82,
    ZF32_MS4_2CS = 0x83,
    ZF32_MS8_2CS = 0x84,
    ZF32_MS16_2CS = 0x85,
    ZF32_2CZ = 0x86,
    ZF32_MS2_2CZ = 0x87,
    ZF32_MS4_2CZ = 0x88,
    ZF32_MS8_2CZ = 0x89,
    ZF32_MS16_2CZ = 0x8a,
    X8Z24_X16V8S8_MS4_VC12 = 0x8b,
    X8Z24_X16V8S8_MS4_VC4 = 0x8c,
    X8Z24_X16V8S8_MS8_VC8 = 0x8d,
    X8Z24_X16V8S8_MS8_VC24 = 0x8e,
    X8Z24_X16V8S8_MS4_VC12_1CS = 0x8f,
    X8Z24_X16V8S8_MS4_VC4_1CS = 0x90,
    X8Z24_X16V8S8_MS8_VC8_1CS = 0x91,
    X8Z24_X16V8S8_MS8_VC24_1CS = 0x92,
    X8Z24_X16V8S8_MS4_VC12_1ZV = 0x97,
    X8Z24_X16V8S8_MS4_VC4_1ZV = 0x98,
    X8Z24_X16V8S8_MS8_VC8_1ZV = 0x99,
    X8Z24_X16V8S8_MS8_VC24_1ZV = 0x9a,
    X8Z24_X16V8S8_MS4_VC12_1CZV = 0x9b,
    X8Z24_X16V8S8_MS4_VC4_1CZV = 0x9c,
    X8Z24_X16V8S8_MS8_VC8_1CZV = 0x9d,
    X8Z24_X16V8S8_MS8_VC24_1CZV = 0x9e,
    X8Z24_X16V8S8_MS4_VC12_2CS = 0x9f,
    X8Z24_X16V8S8_MS4_VC4_2CS = 0xa0,
    X8Z24_X16V8S8_MS8_VC8_2CS = 0xa1,
    X8Z24_X16V8S8_MS8_VC24_2CS = 0xa2,
    X8Z24_X16V8S8_MS4_VC12_2CSZV = 0xa3,
    X8Z24_X16V8S8_MS4_VC4_2CSZV = 0xa4,
    X8Z24_X16V8S8_MS8_VC8_2CSZV = 0xa5,
    X8Z24_X16V8S8_MS8_VC24_2CSZV = 0xa6,
    ZF32_X16V8S8_MS4_VC12 = 0xa7,
    ZF32_X16V8S8_MS4_VC4 = 0xa8,
    ZF32_X16V8S8_MS8_VC8 = 0xa9,
    ZF32_X16V8S8_MS8_VC24 = 0xaa,
    ZF32_X16V8S8_MS4_VC12_1CS = 0xab,
    ZF32_X16V8S8_MS4_VC4_1CS = 0xac,
    ZF32_X16V8S8_MS8_VC8_1CS = 0xad,
    ZF32_X16V8S8_MS8_VC24_1CS = 0xae,
    ZF32_X16V8S8_MS4_VC12_1ZV = 0xb3,
    ZF32_X16V8S8_MS4_VC4_1ZV = 0xb4,
    ZF32_X16V8S8_MS8_VC8_1ZV = 0xb5,
    ZF32_X16V8S8_MS8_VC24_1ZV = 0xb6,
    ZF32_X16V8S8_MS4_VC12_1CZV = 0xb7,
    ZF32_X16V8S8_MS4_VC4_1CZV = 0xb8,
    ZF32_X16V8S8_MS8_VC8_1CZV = 0xb9,
    ZF32_X16V8S8_MS8_VC24_1CZV = 0xba,
    ZF32_X16V8S8_MS4_VC12_2CS = 0xbb,
    ZF32_X16V8S8_MS4_VC4_2CS = 0xbc,
    ZF32_X16V8S8_MS8_VC8_2CS = 0xbd,
    ZF32_X16V8S8_MS8_VC24_2CS = 0xbe,
    ZF32_X16V8S8_MS4_VC12_2CSZV = 0xbf,
    ZF32_X16V8S8_MS4_VC4_2CSZV = 0xc0,
    ZF32_X16V8S8_MS8_VC8_2CSZV = 0xc1,
    ZF32_X16V8S8_MS8_VC24_2CSZV = 0xc2,
    ZF32_X24S8 = 0xc3,
    ZF32_X24S8_1CS = 0xc4,
    ZF32_X24S8_MS2_1CS = 0xc5,
    ZF32_X24S8_MS4_1CS = 0xc6,
    ZF32_X24S8_MS8_1CS = 0xc7,
    ZF32_X24S8_MS16_1CS = 0xc8,
    ZF32_X24S8_2CSZV = 0xce,
    ZF32_X24S8_MS2_2CSZV = 0xcf,
    ZF32_X24S8_MS4_2CSZV = 0xd0,
    ZF32_X24S8_MS8_2CSZV = 0xd1,
    ZF32_X24S8_MS16_2CSZV = 0xd2,
    ZF32_X24S8_2CS = 0xd3,
    ZF32_X24S8_MS2_2CS = 0xd4,
    ZF32_X24S8_MS4_2CS = 0xd5,
    ZF32_X24S8_MS8_2CS = 0xd6,
    ZF32_X24S8_MS16_2CS = 0xd7,
    S8 = 0x2a,
    S8_2S = 0x2b,
    GENERIC_16BX2 = 0xfe,
    C32_2C = 0xd8,
    C32_2CBR = 0xd9,
    C32_2CBA = 0xda,
    C32_2CRA = 0xdb,
    C32_2BRA = 0xdc,
    C32_MS2_2C = 0xdd,
    C32_MS2_2CBR = 0xde,
    C32_MS2_4CBRA = 0xcc,
    C32_MS4_2C = 0xdf,
    C32_MS4_2CBR = 0xe0,
    C32_MS4_2CBA = 0xe1,
    C32_MS4_2CRA = 0xe2,
    C32_MS4_2BRA = 0xe3,
    C32_MS4_4CBRA = 0x2c,
    C32_MS8_MS16_2C = 0xe4,
    C32_MS8_MS16_2CRA = 0xe5,
    C64_2C = 0xe6,
    C64_2CBR = 0xe7,
    C64_2CBA = 0xe8,
    C64_2CRA = 0xe9,
    C64_2BRA = 0xea,
    C64_MS2_2C = 0xeb,
    C64_MS2_2CBR = 0xec,
    C64_MS2_4CBRA = 0xcd,
    C64_MS4_2C = 0xed,
    C64_MS4_2CBR = 0xee,
    C64_MS4_2CBA = 0xef,
    C64_MS4_2CRA = 0xf0,
    C64_MS4_2BRA = 0xf1,
    C64_MS4_4CBRA = 0x2d,
    C64_MS8_MS16_2C = 0xf2,
    C64_MS8_MS16_2CRA = 0xf3,
    C128_2C = 0xf4,
    C128_2CR = 0xf5,
    C128_MS2_2C = 0xf6,
    C128_MS2_2CR = 0xf7,
    C128_MS4_2C = 0xf8,
    C128_MS4_2CR = 0xf9,
    C128_MS8_MS16_2C = 0xfa,
    C128_MS8_MS16_2CR = 0xfb,
    X8C24 = 0xfc,
    PITCH_NO_SWIZZLE = 0xfd,
    SMSKED_MESSAGE = 0xca,
    SMHOST_MESSAGE = 0xcb,
};

constexpr bool IsPitchKind(PTEKind kind) {
    return kind == PTEKind::PITCH || kind == PTEKind::PITCH_NO_SWIZZLE;
}

} // namespace Tegra
