/*
 * Decompiled with CFR 0.152.
 */
package com.highcharts.export.server;

import com.highcharts.export.converter.SVGConverterException;
import com.highcharts.export.server.ServerState;
import com.highcharts.export.server.TimeOut;
import com.highcharts.export.util.TempDir;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class Server {
    private Process process;
    private final int port;
    private final String host;
    private final int readTimeout;
    private final int connectTimeout;
    private final int maxTimeout;
    private ServerState state = ServerState.IDLE;
    protected static final Logger logger = Logger.getLogger("server");

    public Server(String exec, String script, String host, int port, int connectTimeout, int readTimeout, int maxTimeout) {
        this.port = port;
        this.host = host;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxTimeout = maxTimeout;
        try {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(exec);
            commands.add(TempDir.getPhantomJsDir().toAbsolutePath().toString() + "/" + script);
            commands.add("-host");
            commands.add(host);
            commands.add("-port");
            commands.add("" + port);
            logger.log(Level.FINE, commands.toString());
            this.process = new ProcessBuilder(commands).start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            String readLine = bufferedReader.readLine();
            if (readLine == null || !readLine.contains("ready")) {
                throw new RuntimeException("Error, PhantomJS couldnot start");
            }
            this.initialize();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (Server.this.process != null) {
                        logger.log(Level.WARNING, "Shutting down PhantomJS instance, kill process directly, {0}", this.toString());
                        try {
                            Server.this.process.getErrorStream().close();
                            Server.this.process.getInputStream().close();
                            Server.this.process.getOutputStream().close();
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "Error while shutting down process: {0}", e.getMessage());
                        }
                        Server.this.process.destroy();
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void initialize() {
        logger.log(Level.FINE, "Phantom server started on port {0}", this.port);
    }

    public String request(String params) throws SocketTimeoutException, SVGConverterException, TimeoutException {
        String response = "";
        Timer _timer = new Timer();
        try {
            URL url = new URL("http://" + this.host + ":" + this.port + "/");
            this.state = ServerState.BUSY;
            _timer.schedule((TimerTask)new TimeOut(this), this.maxTimeout);
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            connection.setConnectTimeout(this.connectTimeout);
            connection.setReadTimeout(this.readTimeout);
            OutputStream out = connection.getOutputStream();
            out.write(params.getBytes("utf-8"));
            out.close();
            InputStream in = connection.getInputStream();
            response = IOUtils.toString((InputStream)in, (String)"utf-8");
            in.close();
            _timer.cancel();
            this.state = ServerState.IDLE;
        }
        catch (SocketTimeoutException ste) {
            _timer.cancel();
            throw new SocketTimeoutException(ste.getMessage());
        }
        catch (Exception e) {
            if (this.state == ServerState.TIMEDOUT) {
                throw new TimeoutException(e.getMessage());
            }
            _timer.cancel();
            throw new SVGConverterException(e.getMessage());
        }
        return response;
    }

    public void cleanup() {
        try {
            this.process.getErrorStream().close();
            this.process.getInputStream().close();
            this.process.getOutputStream().close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error while shutting down process: {0}", e.getMessage());
        }
        this.process.destroy();
        this.process = null;
        logger.log(Level.FINE, "Destroyed phantomJS process running on port {0}", this.port);
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public ServerState getState() {
        return this.state;
    }

    public void setState(ServerState state) {
        this.state = state;
    }

    public String toString() {
        return this.getClass().getName() + "listening to port: " + this.port;
    }
}

