/*-
 * Copyright (C) 1996-2000 Specialix International.
 *
 * Download code for SX host cards.
 *
 * Redistribution and use in binary forms (this file is a binary form),
 * with or without modification, are permitted provided that the following
 * conditions are met:
 * 1. Redistributions in binary form must reproduce the above copyright
 *    notices, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 2. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Specialix International.
 * 3. The name of Specialix International may not be used to endorse or
 *    promote products derived from this software without specific prior
 *    written permission.
 * 4. No attempt is made to decompile, reverse engineer or otherwise
 *    discover the source code of the contents of this file. The source
 *    code is regarded as an unpublished trade secret held by Specialix
 *    International.
 *
 * THIS SOFTWARE IS PROVIDED BY ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHORS BE LIABLE.
 *
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/11/sys/dev/si/si3_t225.c 154082 2006-01-06 19:58:08Z jhb $");

#include <sys/param.h>
#include <sys/bus.h>
#include <dev/si/sivar.h>

/* SI3_T225.C Version, Bootstrap and Download Code Arrays... */

/* SI3_T225 embedded version... 

	Copyright (c) Specialix International Ltd 1996-1999.
	JET__.BIN Version 4.0.1 Created Jan 19 2000 @ 14:01:06

*/

unsigned char si3_t225_bootstrap[] =
{
	0x28,0x20,0x21,0x02,0x60,0x0a
};
int si3_t225_bsize = sizeof(si3_t225_bootstrap);

unsigned short si3_t225_bootloadaddr = 0x8000 - sizeof(si3_t225_bootstrap);

unsigned char si3_t225_download[] =
{
	0x00,0x00,0x14,0x51,0x00,0x00,0x00,0x00,	/* 0000: ...Q.... */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 0008: ........ */
	0x24,0xF2,0x21,0xF8,0x24,0xF2,0x21,0xFC,	/* 0010: $!$! */
	0x22,0xF9,0x25,0xF7,0x46,0x23,0xFC,0xD4,	/* 0018: "%F# */
	0x40,0x31,0xD1,0x21,0x20,0x20,0x20,0x40,	/* 0020: @1!   @ */
	0x71,0xF4,0xD2,0x23,0x4B,0xD3,0x73,0x72,	/* 0028: q#Ksr */
	0x71,0x24,0xFA,0x74,0x23,0xFC,0x2F,0x2F,	/* 0030: q$t#.. */
	0x2F,0x4E,0xF6,0x20,0x20,0x22,0x04,0x57,	/* 0038: .N  ".W */
	0x65,0x64,0x20,0x4A,0x61,0x6E,0x20,0x31,	/* 0040: ed Jan 1 */
	0x39,0x20,0x31,0x34,0x3A,0x30,0x31,0x3A,	/* 0048: 9 14:01: */
	0x30,0x39,0x20,0x32,0x30,0x30,0x30,0x0A,	/* 0050: 09 2000. */
	0x00,0x6A,0x65,0x74,0x2E,0x65,0x70,0x72,	/* 0058: .jet.epr */
	0x00,0x20,0x20,0x22,0xB0,0x21,0x12,0xDD,	/* 0060: .  "!. */
	0x24,0xF2,0x21,0xF8,0x24,0xF2,0x21,0xFC,	/* 0068: $!$! */
	0x22,0xF9,0x25,0xF8,0x40,0xDE,0x4B,0xDF,	/* 0070: "%@K */
	0x24,0xF2,0x7E,0x24,0xF2,0xFA,0xE0,0x1E,	/* 0078: $~$. */
	0x4B,0x22,0xF1,0x40,0x25,0xF4,0x22,0x46,	/* 0080: K"@%"F */
	0x21,0xFB,0xD0,0x24,0xF2,0xD1,0x24,0x4B,	/* 0088: !$$K */
	0x21,0xFB,0xD2,0x72,0x84,0x21,0xD0,0x72,	/* 0090: !r!r */
	0x30,0x21,0x70,0xF2,0x21,0xD1,0x21,0x71,	/* 0098: 0!p!!q */
	0xD2,0x1B,0xD3,0x7D,0xD4,0x40,0xD5,0x1C,	/* 00A0: .}@. */
	0xD6,0x19,0xD7,0x1A,0xD8,0x21,0x70,0xF6,	/* 00A8: ..!p */
	0x60,0xBC,0x7D,0x27,0x88,0xDD,0x22,0x40,	/* 00B0: `}'"@ */
	0x21,0xFB,0xD0,0x44,0x24,0xF2,0xFA,0xD1,	/* 00B8: !D$ */
	0x24,0xF2,0xD2,0x7B,0x83,0x60,0x4C,0x24,	/* 00C0: ${`L$ */
	0xF6,0x21,0x71,0xF2,0xD3,0x7D,0xD4,0x24,	/* 00C8: !q}$ */
	0xF2,0xD5,0x7A,0x7D,0xF2,0xD6,0x79,0x73,	/* 00D0: z}ys */
	0xF2,0xF6,0x21,0xF5,0x20,0x6E,0x03,0x00,	/* 00D8: ! n.. */
	0x00,0x20,0x61,0xBF,0x40,0xD1,0x40,0xDF,	/* 00E0: . a@@ */
	0x21,0x76,0x67,0x88,0xDE,0x40,0x21,0x74,	/* 00E8: !vg@!t */
	0xE0,0x10,0x23,0x24,0x94,0x28,0x45,0x71,	/* 00F0: .#$(Eq */
	0xF4,0x22,0x2B,0xAD,0x71,0x46,0x24,0xF0,	/* 00F8: "+qF$ */
	0x21,0xD0,0x71,0x23,0x4F,0x24,0xF6,0xD5,	/* 0100: !q#O$ */
	0x21,0x70,0xC0,0x23,0xAF,0x7F,0xA7,0x7D,	/* 0108: !p#} */
	0xD6,0x76,0x75,0xF2,0xDD,0x02,0x7E,0xD6,	/* 0110: vu.~ */
	0x75,0xA6,0x75,0x76,0x10,0x22,0x2F,0x94,	/* 0118: uuv.". */
	0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,	/* 0120: @DAr$ */
	0x74,0x24,0xF6,0x21,0xA7,0x11,0x72,0x21,	/* 0128: t$!.r! */
	0x72,0xFA,0x41,0xFB,0x75,0xAE,0x76,0x27,	/* 0130: rAuv' */
	0x88,0xD0,0x70,0x21,0x75,0xF2,0x72,0x21,	/* 0138: p!ur! */
	0x72,0xFA,0x75,0xFB,0x12,0x22,0x45,0x22,	/* 0140: ru."E" */
	0xF1,0x22,0x26,0x07,0x21,0x70,0xC2,0x22,	/* 0148: "&.!p" */
	0x25,0xA7,0x75,0xC0,0xA7,0x41,0xDF,0x40,	/* 0150: %uA@ */
	0xD4,0x22,0x24,0x0C,0x75,0xC9,0xA7,0x41,	/* 0158: "$.uɧA */
	0xDF,0x40,0xD4,0x22,0x24,0x02,0x75,0xC7,	/* 0160: @"$.u */
	0xA7,0x41,0xDF,0x40,0xD4,0x22,0x23,0x08,	/* 0168: A@"#. */
	0x75,0xC1,0xA7,0x40,0xDF,0x40,0xD4,0x22,	/* 0170: u@@" */
	0x22,0x0E,0x75,0xC2,0x22,0xA7,0x41,0xD0,	/* 0178: ".u"A */
	0x70,0x21,0xAF,0x10,0x22,0x2B,0x92,0x71,	/* 0180: p!."+q */
	0x28,0xC2,0xA4,0x70,0x81,0xD0,0x08,0x71,	/* 0188: (¤p.q */
	0x28,0xC3,0xA4,0x70,0x60,0x8F,0xD0,0x70,	/* 0190: (äp`p */
	0xA7,0x11,0x7C,0x21,0x72,0xFA,0x41,0xFB,	/* 0198: .|!rA */
	0x62,0x0E,0x22,0x20,0x03,0x75,0xC4,0xAC,	/* 01A0: b." .uĬ */
	0x1D,0x10,0x22,0x23,0x9D,0x7D,0x21,0x77,	/* 01A8: .."#}!w */
	0xE0,0x21,0x2F,0x04,0x75,0xC6,0xA9,0x21,	/* 01B0: !..uƩ! */
	0x79,0x10,0x22,0x22,0x9D,0x21,0x2E,0x08,	/* 01B8: y.""!.. */
	0x75,0xCB,0xA9,0x21,0x78,0x10,0x22,0x22,	/* 01C0: u˩!x."" */
	0x91,0x21,0x2D,0x0C,0x75,0xC8,0xAC,0x1D,	/* 01C8: !-.uȬ. */
	0x10,0x22,0x21,0x96,0x7D,0x21,0x78,0xE0,	/* 01D0: ."!}!x */
	0x21,0x2C,0x0D,0x75,0xCA,0xAC,0x1D,0x10,	/* 01D8: !,.uʬ.. */
	0x22,0x20,0x97,0x7D,0x21,0x79,0xE0,0x21,	/* 01E0: " }!y! */
	0x2B,0x0E,0x75,0xCC,0x2C,0xAB,0x40,0xD6,	/* 01E8: +.u,@ */
	0x40,0xDA,0x40,0xD8,0x7E,0xD7,0x41,0xD6,	/* 01F0: @@~A */
	0x10,0x22,0x23,0x9D,0x23,0x4F,0x71,0xF9,	/* 01F8: ."##Oq */
	0xC0,0xD6,0x76,0x22,0xA8,0x41,0x7A,0xF2,	/* 0200: v"Az */
	0xDA,0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,	/* 0208: @DAr$ */
	0xF1,0x74,0x24,0xF6,0xA7,0x11,0x72,0x21,	/* 0210: t$.r! */
	0x72,0xFA,0x41,0xFB,0x12,0x21,0x44,0x22,	/* 0218: rA.!D" */
	0xF1,0x10,0x22,0x21,0x94,0x23,0x4F,0x71,	/* 0220: ."!#Oq */
	0xF9,0xC0,0xD6,0x62,0x05,0x71,0x23,0x4F,	/* 0228: b.q#O */
	0x24,0xF6,0xD5,0x7A,0x40,0xF9,0x23,0xA3,	/* 0230: $z@# */
	0x75,0xA6,0x75,0x77,0x10,0x21,0x2D,0x94,	/* 0238: uuw.!- */
	0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,	/* 0240: @DAr$ */
	0x74,0x24,0xF6,0x21,0xA7,0x11,0x72,0x21,	/* 0248: t$!.r! */
	0x72,0xFA,0x41,0xFB,0x75,0xAE,0x77,0x27,	/* 0250: rAuw' */
	0x88,0xD0,0x70,0x21,0x75,0xF2,0x72,0x21,	/* 0258: p!ur! */
	0x72,0xFA,0x75,0xFB,0x12,0x22,0x45,0x22,	/* 0260: ru."E" */
	0xF1,0x24,0x0C,0x41,0xD6,0x76,0x21,0xAF,	/* 0268: $.Av! */
	0x75,0x77,0x10,0x21,0x29,0x9E,0x77,0x75,	/* 0270: uw.!)wu */
	0xF2,0xD7,0x78,0x75,0xF2,0xD8,0x10,0x21,	/* 0278: xu.! */
	0x2B,0x97,0x23,0x4F,0x71,0xF9,0xD6,0x71,	/* 0280: +#Oqq */
	0x23,0x4F,0x24,0xF6,0xD5,0x62,0x0E,0x40,	/* 0288: #O$b.@ */
	0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,0x74,	/* 0290: DAr$t */
	0x24,0xF6,0x21,0xA6,0x72,0x21,0x72,0xFA,	/* 0298: $!r!r */
	0x78,0xFE,0x78,0xAE,0x7E,0x27,0x88,0xD0,	/* 02A0: xx~' */
	0x70,0x21,0x75,0xF2,0x72,0x21,0x72,0xFA,	/* 02A8: p!ur!r */
	0x78,0xFB,0x12,0x22,0x44,0x22,0xF1,0x2E,	/* 02B0: x."D". */
	0x0F,0x75,0xCD,0x22,0xAC,0x40,0xD6,0x7A,	/* 02B8: .u"@z */
	0xD7,0x77,0x22,0xA1,0x10,0x21,0x27,0x91,	/* 02C0: w".!' */
	0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,	/* 02C8: @DAr$ */
	0x74,0x24,0xF6,0xA7,0x11,0x72,0x21,0x72,	/* 02D0: t$.r!r */
	0xFA,0x41,0xFB,0x12,0x21,0x44,0x22,0xF1,	/* 02D8: A.!D" */
	0x16,0x22,0x41,0x22,0xF1,0x40,0xDA,0x2B,	/* 02E0: ."A"@+ */
	0x0F,0x75,0xCE,0x2B,0xAB,0x40,0xD0,0x40,	/* 02E8: .u+@@ */
	0xD2,0x40,0xD3,0x41,0xD0,0x70,0x22,0xA7,	/* 02F0: @Ap" */
	0x73,0x72,0x46,0x23,0xF6,0xD2,0xD3,0x10,	/* 02F8: srF#. */
	0x21,0x23,0x96,0x71,0x23,0x4F,0x24,0xF6,	/* 0300: !#q#O$ */
	0x21,0xFD,0xD8,0xD9,0x40,0x72,0x78,0x23,	/* 0308: !@rx# */
	0xF7,0xD2,0x73,0x79,0x23,0xF7,0xD3,0x2C,	/* 0310: sy#, */
	0x40,0x71,0xF9,0xC0,0xD0,0x62,0x06,0x28,	/* 0318: @qb.( */
	0x20,0x40,0xD6,0x40,0xD7,0x73,0x77,0xF9,	/* 0320:  @@sw */
	0xC0,0xAB,0x73,0x77,0xF4,0xC0,0xA7,0x41,	/* 0328: swA */
	0x72,0x76,0x24,0xFF,0xF0,0xC0,0x27,0xA0,	/* 0330: rv$' */
	0x73,0x77,0xF9,0xC0,0xAB,0x73,0x77,0xF4,	/* 0338: swsw */
	0xC0,0xA7,0x41,0x72,0x76,0x24,0xFF,0xF0,	/* 0340: Arv$ */
	0xC0,0x25,0xAD,0x40,0x72,0x76,0x24,0xFF,	/* 0348: %@rv$ */
	0xD8,0x73,0x77,0x24,0xFF,0xD9,0x79,0x40,	/* 0350: sw$y@ */
	0xF9,0xC0,0xAC,0x79,0xC0,0xAA,0x41,0x78,	/* 0358: yAx */
	0x27,0x2F,0x2F,0x4F,0x24,0xFF,0xF0,0xC0,	/* 0360: '..O$ */
	0x21,0xAF,0x76,0xD0,0x2F,0x4F,0x70,0x24,	/* 0368: !v.Op$ */
	0xF2,0xF2,0x27,0x2F,0x2F,0x4F,0xF0,0x24,	/* 0370: '..O$ */
	0x94,0x40,0x76,0x27,0x2F,0x2F,0x4F,0x23,	/* 0378: @v'..O# */
	0xF7,0xD6,0x77,0x40,0x23,0xF7,0xD7,0x21,	/* 0380: w@#! */
	0x0D,0x76,0xDB,0x40,0x72,0x76,0x24,0xFF,	/* 0388: .v@rv$ */
	0xD8,0x73,0x77,0x24,0xFF,0xD9,0x78,0xD0,	/* 0390: sw$x */
	0x2F,0x4F,0x7B,0x24,0xF2,0xF2,0x70,0xF0,	/* 0398: .O{$p */
	0x21,0x9B,0x72,0xD6,0x73,0xD7,0x66,0x00,	/* 03A0: !rsf. */
	0x0A,0x75,0xDC,0x41,0x7C,0x24,0xF1,0x74,	/* 03A8: .uA|$t */
	0x24,0xFB,0xD4,0x10,0x28,0x93,0x62,0x23,	/* 03B0: $.(b# */
	0x0C,0x21,0xB1,0x22,0xF0,0x60,0xBE,0x41,	/* 03B8: .!"`A */
	0xD0,0x70,0xD1,0x75,0x73,0x23,0xFB,0x74,	/* 03C0: pus#t */
	0x71,0xF9,0x21,0xAB,0x70,0x74,0x71,0xF4,	/* 03C8: q!ptq */
	0xF9,0xA4,0x74,0x71,0xF4,0xD0,0x73,0x71,	/* 03D0: tqsq */
	0x73,0xF2,0x70,0x24,0xFA,0x71,0x70,0xF2,	/* 03D8: sp$qp */
	0xD1,0x70,0x70,0xF2,0xD0,0x61,0x00,0xB2,	/* 03E0: ppa. */
	0x22,0xF0,0x40,0xD3,0x40,0x72,0xE0,0x41,	/* 03E8: "@@rA */
	0xD3,0x73,0x21,0xAE,0x72,0x30,0x46,0x24,	/* 03F0: s!r0F$ */
	0xF1,0x72,0xE0,0x71,0x23,0x9B,0x71,0x31,	/* 03F8: rq#q1 */
	0x23,0x4F,0x24,0xF6,0x72,0x30,0xF2,0x72,	/* 0400: #O$r0r */
	0xE0,0x2C,0x40,0x71,0x31,0xF9,0xC0,0xD3,	/* 0408: ,@q1 */
	0x62,0x0F,0x22,0xF0,0x60,0xBE,0x74,0x27,	/* 0410: b."`t' */
	0x88,0xD0,0x73,0x21,0x34,0x30,0xD1,0x71,	/* 0418: s!40q */
	0x73,0x21,0x33,0xF2,0x70,0x73,0x21,0x35,	/* 0420: s!3ps!5 */
	0xF2,0x75,0x24,0xFA,0x73,0x21,0x34,0x30,	/* 0428: u$s!40 */
	0x75,0xF5,0x73,0x21,0x34,0xE0,0xB2,0x22,	/* 0430: us!4" */
	0xF0,0x71,0x21,0x34,0x30,0x71,0x21,0x33,	/* 0438: q!40q!3 */
	0xF2,0xF1,0x71,0xE1,0x71,0x21,0x34,0x30,	/* 0440: qq!40 */
	0x81,0x71,0x21,0x34,0xE0,0x22,0xF0,0x8A,	/* 0448: q!4" */
	0xF1,0x22,0x89,0x3C,0x00,0x00,0x07,0x00,	/* 0450: "<.... */
	0x00,0x08,0x00,0x00,0x00,0x81,0x00,0x80,	/* 0458: ...... */
	0xFF,0x7F,0xFF,0x7F,0xFA,0x8D,0xB6,0x8D,	/* 0460:  */
	0x7C,0x8D,0xFF,0x80,0x00,0x00,0x02,0x00,	/* 0468: |.... */
	0x01,0x00,0x6E,0x00,0xCC,0x4B,0xCD,0x4B,	/* 0470: ..n.KK */
	0x10,0x00,0x06,0x00,0x34,0x81,0x00,0x00,	/* 0478: ....4.. */
	0xFF,0x80,0x00,0x00,0xFF,0x80,0x00,0x00,	/* 0480: .... */
	0xFF,0x80,0xFF,0x80,0x62,0x8D,0x03,0x00,	/* 0488: b.. */
	0x3C,0x02,0x00,0x02,0x00,0x11,0x00,0xB2,	/* 0490: <...... */
	0x8D,0x02,0x00,0x12,0x00,0x7C,0x8D,0x02,	/* 0498: ....|. */
	0x00,0x13,0x00,0xFF,0x80,0x60,0xBC,0x21,	/* 04A0: ...`! */
	0xF5,0x00,0x00,0x00,0x00,0x22,0x4B,0x00,	/* 04A8: ...."K. */
	0x00,0x6C,0x3E,0xC6,0x02,0x06,0x00,0xC6,	/* 04B0: .l>... */
	0x83,0x00,0x00,0xFF,0x80,0x92,0x01,0xD0,	/* 04B8: ... */
	0x83,0x00,0x08,0x62,0x85,0xFF,0x80,0x62,	/* 04C0: ..bb */
	0x8D,0x04,0x00,0x04,0x00,0x20,0x02,0x00,	/* 04C8: .... .. */
	0x11,0x00,0xF6,0x8D,0x02,0x00,0x12,0x00,	/* 04D0: ...... */
	0xB6,0x8D,0x02,0x00,0x13,0x00,0xFF,0x80,	/* 04D8: .... */
	0x02,0x00,0x04,0x00,0xF2,0x8D,0x00,0x00,	/* 04E0: ...... */
	0x00,0x00,0x60,0xBC,0x21,0xF5,0x8A,0x34,	/* 04E8: ..`!4 */
	0x89,0x06,0xB2,0x8D,0x7C,0x8D,0xFF,0x80,	/* 04F0: .| */
	0x8A,0xCB,0x06,0x89,0x06,0xF6,0x8D,0xB6,	/* 04F8: .. */
	0x8D,0xFF,0x80,0x86,0xF1,0x22,0x8B,0xC4,	/* 0500: " */
	0xEC,0x22,0x85,0x60,0xBC,0x75,0xD3,0x73,	/* 0508: "`us */
	0x2A,0x36,0x2C,0x48,0xF4,0x75,0x2D,0x96,	/* 0510: *6,Hu- */
	0xA5,0x28,0x4E,0x75,0x2F,0x99,0x26,0x44,	/* 0518: (Nu.&D */
	0xD0,0x73,0x51,0x73,0x75,0x29,0x91,0xA5,	/* 0520: sQsu) */
	0x28,0x41,0x75,0x2E,0x9A,0x73,0x31,0xD0,	/* 0528: (Au.s1 */
	0x26,0x44,0xD1,0x40,0xD2,0x22,0x22,0x41,	/* 0530: &D@""A */
	0x21,0xFB,0x73,0x30,0x75,0x23,0x2F,0x24,	/* 0538: !s0u#.$ */
	0x96,0xA5,0x29,0x44,0x75,0x2D,0x90,0x2C,	/* 0540: )Du-, */
	0x48,0xD0,0x73,0x53,0x73,0x52,0x75,0x26,	/* 0548: HsSsRu& */
	0x97,0xA5,0x28,0x45,0x75,0x2C,0x90,0x73,	/* 0550: (Eu,s */
	0x33,0xD0,0x2C,0x48,0xD1,0x40,0xD2,0x22,	/* 0558: 3,H@" */
	0x22,0x41,0x21,0xFB,0x73,0x32,0x75,0x23,	/* 0560: "A!s2u# */
	0x2F,0x21,0x9C,0xA5,0x28,0x45,0x75,0x2A,	/* 0568: .!(Eu* */
	0x96,0x75,0x21,0x24,0x98,0x40,0xB4,0x22,	/* 0570: u!$@" */
	0xF0,0x03,0x00,0x02,0x00,0x01,0x00,0x00,	/* 0578: ....... */
	0x00,0xA4,0x00,0x71,0xD2,0x72,0x61,0x4F,	/* 0580: ..qraO */
	0x21,0xFB,0x44,0x24,0x24,0x2F,0x9A,0x22,	/* 0588: !D$$." */
	0xF0,0x60,0xBE,0x73,0x58,0xD0,0x41,0x74,	/* 0590: `sXAt */
	0x70,0x60,0x3E,0x24,0xFF,0xF0,0x21,0xA3,	/* 0598: p`>$! */
	0x70,0x30,0x74,0x70,0x30,0xF2,0x70,0xE0,	/* 05A0: p0tp0p */
	0x70,0x60,0x3E,0x74,0xF4,0x70,0x60,0xEE,	/* 05A8: p`>tp` */
	0xB2,0x22,0xF0,0x24,0xF2,0xB2,0x22,0xF0,	/* 05B0: "$" */
	0x60,0xBF,0x75,0xC0,0xA4,0x24,0x20,0x40,	/* 05B8: `u$ @ */
	0xD5,0x21,0x40,0x72,0x63,0x9B,0x73,0xE0,	/* 05C0: !@rcs */
	0x75,0x72,0x63,0x95,0x74,0xE0,0x73,0x30,	/* 05C8: urcts0 */
	0x24,0xF2,0xF4,0x21,0xA5,0x74,0x30,0x24,	/* 05D0: $!t0$ */
	0xF2,0xF4,0xAF,0x75,0xD0,0x2A,0x45,0x74,	/* 05D8: u*Et */
	0x30,0x72,0x24,0x28,0x2E,0x99,0x40,0xB1,	/* 05E0: 0r$(.@ */
	0x22,0xF0,0x41,0xB1,0x22,0xF0,0x60,0xBE,	/* 05E8: "A"` */
	0x73,0x58,0xD0,0x74,0x73,0x24,0x26,0x2A,	/* 05F0: sXts$&* */
	0x98,0x25,0xFA,0x70,0xE0,0x24,0xF2,0xF4,	/* 05F8: %p$ */
	0x21,0xA0,0x74,0x70,0xE1,0x74,0x70,0x60,	/* 0600: !tptp` */
	0xEE,0x70,0x31,0x70,0x60,0xEF,0x40,0xB2,	/* 0608: p1p`@ */
	0x22,0xF0,0x28,0x4E,0xB2,0x22,0xF0,0x72,	/* 0610: "(N"r */
	0x21,0x20,0x40,0xE0,0x71,0x23,0x2F,0x2C,	/* 0618: ! @q#., */
	0x99,0x22,0xF0,0x00,0x00,0x82,0x00,0x71,	/* 0620: "...q */
	0x58,0xD2,0x72,0x60,0x44,0x21,0xFB,0x41,	/* 0628: Xr`D!A */
	0x24,0x24,0x25,0x95,0x22,0xF0,0x20,0x43,	/* 0630: $$%" C */
	0x6F,0x70,0x79,0x72,0x69,0x67,0x68,0x74,	/* 0638: opyright */
	0x20,0x28,0x63,0x29,0x20,0x53,0x70,0x65,	/* 0640:  (c) Spe */
	0x63,0x69,0x61,0x6C,0x69,0x78,0x20,0x49,	/* 0648: cialix I */
	0x6E,0x74,0x65,0x72,0x6E,0x61,0x74,0x69,	/* 0650: nternati */
	0x6F,0x6E,0x61,0x6C,0x20,0x4C,0x74,0x64,	/* 0658: onal Ltd */
	0x20,0x31,0x39,0x39,0x36,0x2D,0x31,0x39,	/* 0660:  1996-19 */
	0x39,0x39,0x2E,0x0D,0x0A,0x4A,0x45,0x54,	/* 0668: 99...JET */
	0x5F,0x5F,0x2E,0x42,0x49,0x4E,0x20,0x56,	/* 0670: __.BIN V */
	0x65,0x72,0x73,0x69,0x6F,0x6E,0x20,0x34,	/* 0678: ersion 4 */
	0x2E,0x30,0x2E,0x31,0x20,0x43,0x72,0x65,	/* 0680: .0.1 Cre */
	0x61,0x74,0x65,0x64,0x20,0x4A,0x61,0x6E,	/* 0688: ated Jan */
	0x20,0x31,0x39,0x20,0x32,0x30,0x30,0x30,	/* 0690:  19 2000 */
	0x20,0x40,0x20,0x31,0x34,0x3A,0x30,0x31,	/* 0698:  @ 14:01 */
	0x3A,0x30,0x36,0x00,0x45,0x30,0x20,0xA2,	/* 06A0: :06.E0  */
	0x00,0x71,0x5A,0xD2,0x60,0x44,0x21,0xFB,	/* 06A8: .qZ`D! */
	0x72,0x42,0x24,0xFA,0x68,0x4F,0x21,0xFB,	/* 06B0: rB$hO! */
	0x72,0xE1,0x22,0xF0,0x20,0x60,0xBE,0x73,	/* 06B8: r" `s */
	0x5C,0xD1,0x40,0x71,0xE0,0x27,0x20,0x20,	/* 06C0: \@q'   */
	0x40,0xD0,0x40,0x40,0x73,0x24,0x27,0x2F,	/* 06C8: @@@s$'. */
	0x9E,0x21,0x20,0x40,0xD0,0x40,0x27,0x2E,	/* 06D0: ! @@'. */
	0x20,0x40,0x73,0x24,0x27,0x2F,0x90,0x24,	/* 06D8:  @s$'.$ */
	0x40,0x71,0x30,0x81,0x23,0xFB,0x71,0x60,	/* 06E0: @q0#q` */
	0x3E,0x71,0x30,0xE2,0x26,0x44,0x71,0x30,	/* 06E8: >q0&Dq0 */
	0xE1,0x73,0x22,0x2B,0x20,0x9D,0x71,0x30,	/* 06F0: s"+ q0 */
	0x23,0xFB,0x71,0x30,0xF1,0x41,0xF4,0xC0,	/* 06F8: #q0A */
	0x23,0xA9,0x71,0x60,0x34,0x73,0x24,0x28,	/* 0700: #q`4s$( */
	0x2A,0x9F,0x28,0x40,0x54,0xF1,0x2F,0x40,	/* 0708: *(@T.@ */
	0x24,0xF6,0x21,0xAC,0x41,0x71,0x27,0x37,	/* 0710: $!Aq'7 */
	0x40,0x24,0xFF,0xF0,0xC0,0xA5,0x71,0x27,	/* 0718: @$q' */
	0x36,0x21,0xA3,0x71,0x60,0x36,0x73,0x24,	/* 0720: 6!q`6s$ */
	0x28,0x27,0x90,0x73,0x22,0x2C,0x9C,0x0B,	/* 0728: ('s",. */
	0x73,0x22,0x24,0x29,0x9B,0x05,0x73,0x21,	/* 0730: s"$).s! */
	0x26,0x2C,0x90,0x21,0x20,0x40,0x30,0x41,	/* 0738: &,! @0A */
	0xF2,0x21,0x20,0x40,0xE0,0x60,0x04,0x00,	/* 0740: ! @`.. */
	0x00,0xFC,0x15,0x71,0x5C,0xD2,0x72,0x60,	/* 0748: ..q\r` */
	0x44,0x21,0xFB,0x41,0x24,0x23,0x23,0x91,	/* 0750: D!A$## */
	0x22,0xF0,0x20,0x60,0xBF,0x72,0x5D,0xD0,	/* 0758: " `r] */
	0x70,0x60,0x3F,0x31,0x21,0xA1,0x40,0x23,	/* 0760: p`?1!@# */
	0x2D,0x20,0x49,0x70,0x60,0x3F,0x31,0x21,	/* 0768: - Ip`?1! */
	0xFA,0x72,0x23,0x2E,0x26,0x9A,0x07,0x29,	/* 0770: r#.&.) */
	0x4C,0x72,0x23,0x2E,0x26,0x92,0x72,0x22,	/* 0778: Lr#.&r" */
	0x2D,0x2D,0x9A,0x62,0x0B,0x24,0xF2,0x58,	/* 0780: --b.$X */
	0x71,0x23,0x2C,0x28,0x92,0x71,0x22,0x2E,	/* 0788: q#,(q". */
	0x25,0x99,0x40,0x27,0x28,0x20,0x40,0xE0,	/* 0790: %@'( @ */
	0x61,0x0B,0x20,0x60,0xBF,0x41,0x73,0x23,	/* 0798: a. `As# */
	0x28,0x26,0xE6,0x43,0x73,0x23,0x28,0x26,	/* 07A0: (&Cs#(& */
	0xE8,0x40,0x73,0x23,0x28,0x27,0xE4,0x42,	/* 07A8: @s#('B */
	0x73,0x23,0x28,0x26,0xE8,0x40,0x73,0x23,	/* 07B0: s#(&@s# */
	0x28,0x27,0xE4,0x41,0x73,0x23,0x28,0x26,	/* 07B8: ('As#(& */
	0xE8,0x40,0x73,0x23,0x28,0x27,0xE4,0x40,	/* 07C0: @s#('@ */
	0x73,0x23,0x28,0x26,0xE8,0x40,0x73,0x23,	/* 07C8: s#(&@s# */
	0x28,0x27,0xE4,0x43,0x73,0x23,0x28,0x26,	/* 07D0: ('Cs#(& */
	0xE8,0x40,0x73,0x23,0x28,0x27,0xEA,0x42,	/* 07D8: @s#('B */
	0x73,0x23,0x28,0x26,0xE8,0x40,0x73,0x23,	/* 07E0: s#(&@s# */
	0x28,0x27,0xEA,0x41,0x73,0x23,0x28,0x26,	/* 07E8: ('As#(& */
	0xE8,0x40,0x73,0x23,0x28,0x27,0xEA,0x40,	/* 07F0: @s#('@ */
	0x73,0x23,0x28,0x26,0xE8,0x40,0x73,0x23,	/* 07F8: s#(&@s# */
	0x28,0x27,0xEA,0x44,0x73,0x23,0x28,0x26,	/* 0800: ('Ds#(& */
	0xE8,0x2A,0x48,0x73,0x23,0x28,0x26,0xED,	/* 0808: *Hs#(& */
	0x40,0x73,0x23,0x28,0x26,0xEE,0x40,0x73,	/* 0810: @s#(&@s */
	0x23,0x28,0x26,0xEF,0x41,0x73,0x23,0x28,	/* 0818: #(&As#( */
	0x26,0xEC,0x43,0x73,0x23,0x28,0x26,0xE6,	/* 0820: &Cs#(& */
	0x43,0x73,0x23,0x28,0x26,0xE6,0x43,0x73,	/* 0828: Cs#(&Cs */
	0x23,0x28,0x26,0xE6,0x44,0x73,0x23,0x28,	/* 0830: #(&Ds#( */
	0x26,0xE8,0x2A,0x48,0x73,0x23,0x28,0x26,	/* 0838: &*Hs#(& */
	0xED,0x22,0x40,0x73,0x23,0x28,0x26,0xEE,	/* 0840: "@s#(& */
	0x40,0x73,0x23,0x28,0x26,0xEF,0x43,0x73,	/* 0848: @s#(&Cs */
	0x23,0x28,0x26,0xE6,0x43,0x73,0x23,0x28,	/* 0850: #(&Cs#( */
	0x26,0xE6,0x43,0x73,0x23,0x28,0x26,0xE6,	/* 0858: &Cs#(& */
	0x40,0x73,0x23,0x28,0x26,0xEC,0x40,0xD0,	/* 0860: @s#(&@ */
	0x43,0x73,0x23,0x28,0x26,0xE6,0x70,0x81,	/* 0868: Cs#(&p */
	0xD0,0x21,0x40,0x70,0xF9,0xA2,0x60,0x00,	/* 0870: !@p`. */
	0x44,0x73,0x23,0x28,0x26,0xE8,0x40,0x73,	/* 0878: Ds#(&@s */
	0x23,0x28,0x26,0xED,0x22,0x40,0x73,0x23,	/* 0880: #(&"@s# */
	0x28,0x26,0xEE,0x43,0x73,0x23,0x28,0x26,	/* 0888: (&Cs#(& */
	0xEF,0x41,0x73,0x23,0x28,0x26,0xEC,0x43,	/* 0890: As#(&C */
	0x73,0x23,0x28,0x26,0xE6,0x43,0x73,0x23,	/* 0898: s#(&Cs# */
	0x28,0x26,0xE6,0x43,0x73,0x23,0x28,0x26,	/* 08A0: (&Cs#(& */
	0xE6,0x43,0x73,0x23,0x28,0x26,0xE6,0x40,	/* 08A8: Cs#(&@ */
	0x73,0x23,0x28,0x26,0xEC,0x40,0x73,0x23,	/* 08B0: s#(&@s# */
	0x28,0x26,0xE6,0x40,0x73,0x23,0x28,0x26,	/* 08B8: (&@s#(& */
	0xE8,0x26,0x44,0x72,0x23,0x2D,0x21,0x98,	/* 08C0: &Dr#-! */
	0xB1,0x22,0xF0,0x60,0xBE,0x40,0xD0,0x74,	/* 08C8: "`@t */
	0x31,0xD1,0x74,0x87,0xF1,0x74,0x32,0x27,	/* 08D0: 1tt2' */
	0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,0xFB,	/* 08D8: ..O$# */
	0x74,0x87,0xF1,0x71,0x23,0x28,0x27,0xEF,	/* 08E0: tq#(' */
	0x74,0x87,0xF1,0x43,0x24,0xF6,0x71,0x23,	/* 08E8: tC$q# */
	0x28,0x26,0xE8,0x71,0x23,0x28,0x26,0x3C,	/* 08F0: (&q#(&< */
	0x2F,0x4F,0x24,0xF6,0x74,0x21,0x53,0xF1,	/* 08F8: .O$t!S */
	0x24,0xF6,0x25,0xFA,0xD1,0x28,0x40,0x24,	/* 0900: $%(@$ */
	0xF6,0xA5,0x70,0x44,0x24,0xFB,0xD0,0x71,	/* 0908: pD$q */
	0x22,0x40,0x24,0xF6,0xA6,0x70,0x24,0x40,	/* 0910: "@$p$@ */
	0x24,0xFB,0xD0,0x71,0x21,0x40,0x24,0xF6,	/* 0918: $q!@$ */
	0xA6,0x70,0x22,0x40,0x24,0xFB,0xD0,0x71,	/* 0920: p"@$q */
	0x24,0x40,0x24,0xF6,0xA5,0x70,0x42,0x24,	/* 0928: $@$pB$ */
	0xFB,0xD0,0x70,0x74,0x5C,0x23,0xFB,0xB2,	/* 0930: pt\# */
	0x22,0xF0,0x60,0xBD,0x40,0xD2,0x72,0x44,	/* 0938: "`@rD */
	0xF8,0x75,0x23,0x28,0x27,0xEF,0x75,0x74,	/* 0940: u#('ut */
	0x61,0x25,0x90,0x72,0x21,0xA3,0x75,0x23,	/* 0948: a%r!u# */
	0x28,0x27,0x3F,0x2F,0x4F,0x24,0xF6,0x44,	/* 0950: ('?.O$D */
	0x24,0xF0,0xD1,0x75,0x23,0x28,0x27,0x3F,	/* 0958: $u#('? */
	0x0E,0x75,0x23,0x28,0x27,0x3F,0x47,0x24,	/* 0960: .u#('?G$ */
	0xF6,0xD1,0x75,0x23,0x28,0x27,0x3F,0x71,	/* 0968: u#('?q */
	0x45,0xF4,0xA7,0x40,0x75,0x23,0x28,0x24,	/* 0970: E@u#($ */
	0xEB,0x07,0x28,0x40,0x75,0x23,0x28,0x24,	/* 0978: .(@u#($ */
	0xEB,0x22,0x47,0x75,0x23,0x28,0x27,0xEE,	/* 0980: "Gu#(' */
	0x40,0xD0,0x70,0x75,0x23,0x28,0x26,0xE8,	/* 0988: @pu#(& */
	0x70,0xC0,0x22,0xA8,0x71,0x45,0xF4,0xC0,	/* 0990: p"qE */
	0x22,0xA2,0x40,0x75,0x23,0x28,0x27,0xE6,	/* 0998: "@u#(' */
	0x24,0x44,0x75,0x23,0x28,0x24,0x30,0x2F,	/* 09A0: $Du#($0. */
	0x4F,0x24,0xF6,0xF9,0xA8,0x24,0x42,0x75,	/* 09A8: O$$Bu */
	0x23,0x28,0x27,0xE2,0x07,0x21,0x4F,0x75,	/* 09B0: #('.!Ou */
	0x23,0x28,0x27,0xE2,0x70,0x81,0xD0,0x44,	/* 09B8: #('pD */
	0x70,0xF9,0xA3,0x20,0x63,0x04,0x40,0x75,	/* 09C0: p c.@u */
	0x23,0x28,0x21,0xE8,0x40,0x75,0x23,0x28,	/* 09C8: #(!@u#( */
	0x26,0xEC,0x40,0x75,0x23,0x28,0x26,0xED,	/* 09D0: &@u#(& */
	0x75,0x23,0x28,0x20,0x35,0x2F,0x4F,0x24,	/* 09D8: u#( 5.O$ */
	0xF6,0xAD,0x75,0x23,0x28,0x20,0x35,0x2F,	/* 09E0: u#( 5. */
	0x4F,0x24,0xF6,0xA3,0x20,0x60,0x03,0x72,	/* 09E8: O$ `.r */
	0x81,0xD2,0x42,0x72,0xF9,0xA2,0x6B,0x06,	/* 09F0: Brk. */
	0xB3,0x22,0xF0,0x60,0xBB,0x76,0x23,0x59,	/* 09F8: "`v#Y */
	0xD4,0x21,0x28,0x40,0xD1,0x41,0x27,0x28,	/* 0A00: !(@A'( */
	0x28,0x40,0xE0,0x74,0x62,0x33,0x87,0xF1,	/* 0A08: (@tb3 */
	0x81,0x74,0x62,0x33,0x87,0x23,0xFB,0x41,	/* 0A10: tb3#A */
	0x27,0x28,0x28,0x40,0xE0,0x71,0x21,0x37,	/* 0A18: '((@q!7 */
	0xD1,0x40,0x27,0x28,0x28,0x40,0xE0,0x71,	/* 0A20: @'((@q */
	0x57,0xF1,0x25,0xFA,0xD0,0xAD,0x70,0x74,	/* 0A28: W%Эpt */
	0xFA,0x30,0xD2,0x71,0x76,0x21,0x21,0x2D,	/* 0A30: 0qv!!- */
	0x99,0x62,0xA0,0x71,0x31,0xD3,0x71,0x34,	/* 0A38: bq1q4 */
	0xD2,0x70,0xC0,0x25,0xA1,0x72,0x41,0x24,	/* 0A40: p%rA$ */
	0xF6,0xC0,0x24,0xAA,0x71,0x8D,0xF1,0x71,	/* 0A48: $qq */
	0x56,0xF1,0xF4,0x24,0xA1,0x72,0x41,0x24,	/* 0A50: V$rA$ */
	0xFB,0x25,0xFA,0xD2,0x71,0xE4,0x71,0x87,	/* 0A58: %qq */
	0xF1,0x71,0x32,0x27,0x2F,0x2F,0x4F,0x24,	/* 0A60: q2'..O$ */
	0xF6,0x89,0x23,0xFB,0x71,0x87,0xF1,0x73,	/* 0A68: #qs */
	0x23,0x28,0x27,0xEF,0x71,0x87,0xF1,0x43,	/* 0A70: #('qC */
	0x24,0xF6,0x73,0x23,0x28,0x26,0xE8,0x73,	/* 0A78: $s#(&s */
	0x23,0x28,0x20,0x36,0x2F,0x4F,0x24,0xF6,	/* 0A80: #( 6.O$ */
	0x44,0x24,0xFB,0x73,0x23,0x28,0x20,0xE6,	/* 0A88: D$s#(  */
	0x41,0x71,0x22,0x89,0x23,0xFB,0x72,0x21,	/* 0A90: Aq"#r! */
	0x40,0x24,0xF6,0x2E,0xAC,0x72,0x28,0x40,	/* 0A98: @$.r(@ */
	0x24,0xF6,0x24,0xAA,0x71,0x87,0xF1,0x71,	/* 0AA0: $$qq */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,	/* 0AA8: 2'..O$ */
	0x23,0xFB,0x71,0x87,0xF1,0x73,0x23,0x28,	/* 0AB0: #qs#( */
	0x27,0xEF,0x71,0x87,0xF1,0x43,0x24,0xF6,	/* 0AB8: 'qC$ */
	0x73,0x23,0x28,0x26,0xE8,0x73,0x23,0x28,	/* 0AC0: s#(&s#( */
	0x20,0x35,0x2F,0x4F,0x24,0xF6,0xC0,0x2B,	/* 0AC8:  5.O$+ */
	0xA5,0x40,0xD0,0x21,0x20,0x40,0x71,0x76,	/* 0AD0: @! @qv */
	0x2D,0x28,0x9F,0x22,0x42,0x73,0x23,0x28,	/* 0AD8: -("Bs#( */
	0x20,0xE5,0x72,0x22,0x40,0x24,0xFB,0x6C,	/* 0AE0:  r"@$l */
	0x4F,0x24,0xF6,0xD2,0x29,0x08,0x41,0x71,	/* 0AE8: O$).Aq */
	0x55,0xF1,0x71,0x8B,0xF1,0xFC,0x2F,0x4F,	/* 0AF0: Uq.O */
	0x24,0xF6,0x24,0x40,0xF0,0x24,0xFF,0xF0,	/* 0AF8: $$@$ */
	0xC0,0x28,0xA3,0x71,0x87,0xF1,0x71,0x32,	/* 0B00: (qq2 */
	0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,	/* 0B08: '..O$# */
	0xFB,0x71,0x87,0xF1,0x73,0x23,0x28,0x27,	/* 0B10: qs#(' */
	0xEF,0x71,0x87,0xF1,0x43,0x24,0xF6,0x73,	/* 0B18: qC$s */
	0x23,0x28,0x26,0xE8,0x73,0x23,0x28,0x20,	/* 0B20: #(&s#(  */
	0x35,0x2F,0x4F,0x24,0xF6,0xC0,0x25,0xA6,	/* 0B28: 5.O$% */
	0x71,0x21,0x58,0xF1,0x48,0x24,0xF6,0x21,	/* 0B30: q!XH$! */
	0xA9,0x21,0x20,0x40,0xD0,0x21,0x20,0x40,	/* 0B38: ! @! @ */
	0x71,0x76,0x2D,0x22,0x95,0x22,0x41,0x73,	/* 0B40: qv-""As */
	0x23,0x28,0x20,0xE5,0x72,0x66,0x4F,0x24,	/* 0B48: #( rfO$ */
	0xF6,0xD2,0x71,0x23,0x81,0xF1,0x28,0x40,	/* 0B50: q#(@ */
	0x24,0xF6,0xAE,0x21,0x20,0x20,0x40,0xD0,	/* 0B58: $!  @ */
	0x21,0x20,0x20,0x40,0x71,0x76,0x2D,0x20,	/* 0B60: !  @qv-  */
	0x91,0x71,0x21,0x58,0xF1,0x24,0x40,0x24,	/* 0B68: q!X$@$ */
	0xF6,0xAE,0x22,0x20,0x20,0x40,0xD0,0x22,	/* 0B70: "  @" */
	0x20,0x20,0x40,0x71,0x76,0x2C,0x2E,0x9A,	/* 0B78:   @qv,. */
	0x72,0x61,0x4F,0x24,0xF6,0xD2,0x72,0x71,	/* 0B80: raO$rq */
	0xE4,0x71,0x22,0x50,0xF1,0x21,0x40,0x24,	/* 0B88: q"P!@$ */
	0xF6,0x22,0xA7,0x71,0x87,0xF1,0x71,0x32,	/* 0B90: "qq2 */
	0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,	/* 0B98: '..O$# */
	0xFB,0x71,0x87,0xF1,0x73,0x23,0x28,0x27,	/* 0BA0: qs#(' */
	0xEF,0x71,0x87,0xF1,0x43,0x24,0xF6,0x73,	/* 0BA8: qC$s */
	0x23,0x28,0x26,0xE8,0x71,0x76,0x23,0x27,	/* 0BB0: #(&qv#' */
	0x21,0x98,0x61,0x24,0x0E,0x60,0xBB,0x77,	/* 0BB8: !a$.`w */
	0x31,0xD1,0x77,0x34,0xD2,0x77,0x87,0xF1,	/* 0BC0: 1w4w */
	0x77,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 0BC8: w2'..O$ */
	0x89,0x23,0xFB,0x77,0x87,0xF1,0x71,0x23,	/* 0BD0: #wq# */
	0x28,0x27,0xEF,0x77,0x87,0xF1,0x43,0x24,	/* 0BD8: ('wC$ */
	0xF6,0x71,0x23,0x28,0x26,0xE8,0x77,0x21,	/* 0BE0: q#(&w! */
	0x8F,0xF1,0x23,0xA8,0x77,0x32,0x27,0x2F,	/* 0BE8: #w2'. */
	0x2F,0x4F,0x24,0xF6,0xD0,0x77,0x87,0xF1,	/* 0BF0: .O$w */
	0x43,0xF9,0x21,0xA2,0x70,0x21,0x8D,0xF1,	/* 0BF8: C!p! */
	0x81,0x70,0x21,0x8D,0x23,0xFB,0x22,0x44,	/* 0C00: p!#"D */
	0x71,0x23,0x28,0x27,0xEF,0x0E,0x70,0x5E,	/* 0C08: q#('.p^ */
	0xF1,0x81,0x70,0x5E,0x23,0xFB,0x48,0x71,	/* 0C10: p^#Hq */
	0x23,0x28,0x27,0xEF,0x40,0x77,0x21,0x8F,	/* 0C18: #('@w! */
	0x23,0xFB,0x25,0x00,0x77,0x21,0x58,0xF1,	/* 0C20: #%.w!X */
	0x42,0x24,0xF6,0xAB,0x71,0x23,0x28,0x20,	/* 0C28: B$q#(  */
	0x3B,0x44,0x24,0xF6,0xC0,0x23,0xA6,0x77,	/* 0C30: ;D$#w */
	0x21,0x59,0xF1,0x21,0x40,0x24,0xF6,0xAB,	/* 0C38: !Y!@$ */
	0x71,0x23,0x28,0x26,0x3C,0x24,0x40,0x24,	/* 0C40: q#(&<$@$ */
	0xF6,0x22,0xA2,0x77,0x21,0x58,0xF1,0x21,	/* 0C48: "w!X! */
	0x40,0x24,0xF6,0xAA,0x71,0x23,0x28,0x26,	/* 0C50: @$q#(& */
	0x3C,0x21,0x40,0x24,0xF6,0xAF,0x72,0x22,	/* 0C58: <!@$r" */
	0x20,0x40,0x24,0xF6,0xC0,0xA7,0x20,0x77,	/* 0C60:  @$ w */
	0x22,0x85,0xF1,0x21,0xA6,0x72,0x62,0x2F,	/* 0C68: "!rb. */
	0x4F,0x24,0xF6,0xD2,0x71,0x23,0x28,0x20,	/* 0C70: O$q#(  */
	0x35,0x2F,0x4F,0x24,0xF6,0x22,0xA9,0x40,	/* 0C78: 5.O$"@ */
	0xB5,0x22,0xF0,0x72,0x21,0x20,0x40,0x24,	/* 0C80: "r! @$ */
	0xFB,0x41,0x24,0xFB,0x77,0xE4,0x77,0x22,	/* 0C88: A$ww" */
	0x87,0xF1,0xAA,0x20,0x28,0x44,0x71,0x23,	/* 0C90:  (Dq# */
	0x28,0x20,0xE6,0x08,0x20,0x29,0x42,0x71,	/* 0C98: ( . )Bq */
	0x23,0x28,0x20,0xE6,0x41,0xB5,0x22,0xF0,	/* 0CA0: #( A" */
	0x77,0x22,0x85,0xF1,0x21,0xAD,0x77,0x22,	/* 0CA8: w"!w" */
	0x87,0xF1,0x25,0x20,0xA4,0x40,0x71,0x23,	/* 0CB0: % @q# */
	0x28,0x21,0xE5,0x40,0x71,0x23,0x28,0x21,	/* 0CB8: (!@q#(! */
	0xE6,0x21,0x48,0x71,0x23,0x28,0x20,0xE5,	/* 0CC0: !Hq#(  */
	0x24,0x2F,0x05,0x41,0x77,0x22,0x85,0x23,	/* 0CC8: $..Aw"# */
	0xFB,0x77,0x22,0x87,0xF1,0x22,0xAC,0x71,	/* 0CD0: w""q */
	0x23,0x28,0x24,0x30,0x2F,0x4F,0x24,0xF6,	/* 0CD8: #($0.O$ */
	0x24,0x42,0xF4,0xA8,0x21,0x4F,0x71,0x23,	/* 0CE0: $B!Oq# */
	0x28,0x27,0xE2,0x0D,0x40,0x71,0x23,0x28,	/* 0CE8: ('.@q#( */
	0x27,0xE6,0x24,0x42,0x71,0x23,0x28,0x27,	/* 0CF0: '$Bq#(' */
	0xE2,0x22,0x40,0x77,0x21,0x55,0x23,0xFB,	/* 0CF8: "@w!U# */
	0x22,0x26,0x02,0x71,0x23,0x28,0x24,0x30,	/* 0D00: "&.q#($0 */
	0x2F,0x4F,0x24,0xF6,0x24,0x42,0xF4,0xA7,	/* 0D08: .O$$B */
	0x2F,0x23,0x48,0x21,0xFB,0xD3,0x06,0x2E,	/* 0D10: .#H!.. */
	0x2F,0x49,0x21,0xFB,0xD3,0x77,0x5B,0xF1,	/* 0D18: .I!w[ */
	0x4F,0x24,0xF6,0xD0,0x77,0x53,0xF1,0x24,	/* 0D20: O$wS$ */
	0x48,0xF4,0xC0,0xAA,0x70,0x4F,0xF4,0xC0,	/* 0D28: HpO */
	0xA5,0x77,0x23,0x83,0xF1,0xD0,0x77,0x53,	/* 0D30: w#wS */
	0xF1,0x24,0x48,0xF4,0xC0,0xA9,0x41,0x21,	/* 0D38: $HA! */
	0x4E,0x70,0x24,0xFF,0xF0,0xC0,0xAF,0x77,	/* 0D40: Np$w */
	0x53,0xF1,0x24,0x48,0xF4,0xAD,0x41,0x70,	/* 0D48: S$HAp */
	0x4D,0x24,0xFF,0xF0,0xC0,0xA5,0x77,0x21,	/* 0D50: M$w! */
	0x5B,0xF1,0xD0,0x21,0x41,0x70,0xF9,0x21,	/* 0D58: [!Ap! */
	0xA0,0x70,0x22,0xAB,0x70,0x43,0xF4,0x22,	/* 0D60: p"pC" */
	0xA6,0x70,0x44,0xF4,0xC0,0x22,0xA7,0x21,	/* 0D68: pD"! */
	0x0E,0x21,0x43,0x70,0xF9,0xAE,0x70,0x21,	/* 0D70: .!Cpp! */
	0x41,0xF4,0x21,0xA3,0x70,0x21,0x42,0xF4,	/* 0D78: A!p!B */
	0xC0,0x21,0xA3,0x0B,0x70,0x21,0x43,0xF4,	/* 0D80: !.p!C */
	0xA6,0x70,0x21,0x44,0xF4,0xC0,0xA7,0x4C,	/* 0D88: p!DL */
	0x77,0x21,0x55,0x23,0xFB,0x07,0x22,0x40,	/* 0D90: w!U#."@ */
	0x77,0x21,0x55,0x23,0xFB,0x70,0x73,0x28,	/* 0D98: w!U#ps( */
	0xF1,0x30,0x71,0x23,0x28,0x27,0xE2,0x70,	/* 0DA0: 0q#('p */
	0x73,0x28,0xF1,0x31,0x71,0x23,0x28,0x27,	/* 0DA8: s(1q#(' */
	0xE6,0x77,0x22,0x8D,0xF1,0x2F,0x40,0x24,	/* 0DB0: w".@$ */
	0xF6,0x77,0x5B,0xF1,0x4F,0x24,0xF6,0x24,	/* 0DB8: w[O$$ */
	0xFB,0x77,0x22,0x8D,0x23,0xFB,0x77,0x23,	/* 0DC0: w"#w# */
	0x83,0xF1,0x77,0x21,0x5B,0x23,0xFB,0x77,	/* 0DC8: w![#w */
	0x5B,0xF1,0x44,0x24,0xF0,0xD0,0x77,0x53,	/* 0DD0: [D$wS */
	0xF1,0x24,0x48,0xF4,0xC0,0xAB,0x70,0x4F,	/* 0DD8: $HpO */
	0xF4,0xC0,0xA6,0x20,0x77,0x21,0x5A,0xF1,	/* 0DE0:  w!Z */
	0xD0,0x77,0x53,0xF1,0x24,0x48,0xF4,0xC0,	/* 0DE8: wS$H */
	0xAA,0x41,0x21,0x4E,0x70,0x24,0xFF,0xF0,	/* 0DF0: A!Np$ */
	0xC0,0x21,0xA0,0x77,0x53,0xF1,0x24,0x48,	/* 0DF8: !wS$H */
	0xF4,0xAE,0x41,0x70,0x4D,0x24,0xFF,0xF0,	/* 0E00: ApM$ */
	0xC0,0xA6,0x20,0x77,0x23,0x87,0xF1,0xD0,	/* 0E08:  w# */
	0x70,0x73,0x28,0xF1,0x30,0x71,0x23,0x28,	/* 0E10: ps(0q#( */
	0x27,0xE8,0x70,0x73,0x28,0xF1,0x31,0x71,	/* 0E18: 'ps(1q */
	0x23,0x28,0x27,0xEC,0x77,0x22,0x8D,0xF1,	/* 0E20: #('w" */
	0x4F,0x24,0xF6,0x77,0x5B,0xF1,0x2F,0x40,	/* 0E28: O$w[.@ */
	0x24,0xF6,0x24,0xFB,0x77,0x22,0x8D,0x23,	/* 0E30: $$w"# */
	0xFB,0x77,0x21,0x5A,0xF1,0x77,0x23,0x87,	/* 0E38: w!Zw# */
	0x23,0xFB,0x40,0x77,0x21,0xEC,0x40,0x77,	/* 0E40: #@w!@w */
	0x21,0xED,0x40,0x77,0x21,0xEE,0x40,0x77,	/* 0E48: !@w!@w */
	0x21,0xEF,0x77,0x21,0x8D,0xF1,0x71,0x23,	/* 0E50: !w!q# */
	0x28,0x21,0xEA,0x77,0x5F,0xF1,0x71,0x23,	/* 0E58: (!w_q# */
	0x28,0x21,0xEB,0x77,0x21,0x8B,0xF1,0x71,	/* 0E60: (!w!q */
	0x23,0x28,0x21,0xEC,0x77,0x5E,0xF1,0x71,	/* 0E68: #(!w^q */
	0x23,0x28,0x21,0xED,0x40,0x77,0x21,0x89,	/* 0E70: #(!@w! */
	0x23,0xFB,0x77,0x5A,0xF1,0x25,0xFA,0xD0,	/* 0E78: #wZ% */
	0x77,0x23,0x81,0x23,0xFB,0x70,0x43,0x24,	/* 0E80: w##pC$ */
	0xF6,0xD3,0x70,0x21,0x40,0x24,0xF6,0xC0,	/* 0E88: p!@$ */
	0x22,0xA0,0x70,0x48,0x24,0xF6,0xA9,0x20,	/* 0E90: "pH$  */
	0x73,0x22,0x40,0x24,0xFB,0xD3,0x07,0x20,	/* 0E98: s"@$.  */
	0x73,0x24,0x40,0x24,0xFB,0xD3,0x70,0x44,	/* 0EA0: s$@$pD */
	0x24,0xF6,0xA7,0x20,0x73,0x28,0x40,0x24,	/* 0EA8: $ s(@$ */
	0xFB,0xD3,0x77,0x5D,0xF1,0x28,0x40,0x24,	/* 0EB0: w](@$ */
	0xF6,0xA3,0x20,0x07,0x20,0x73,0x21,0x40,	/* 0EB8:  . s!@ */
	0x24,0xFB,0xD3,0x77,0x21,0x85,0xF1,0x25,	/* 0EC0: $w!% */
	0xFA,0xD0,0x77,0x21,0x59,0x23,0xFB,0x70,	/* 0EC8: w!Y#p */
	0x4F,0x24,0xF6,0x4F,0xF4,0xA3,0x20,0x06,	/* 0ED0: O$O . */
	0x20,0x73,0x48,0x24,0xFB,0xD3,0x73,0x71,	/* 0ED8:  sH$sq */
	0x23,0x28,0x20,0xE8,0x40,0xD3,0x70,0x28,	/* 0EE0: #( @p( */
	0x40,0x24,0xF6,0xA7,0x20,0x73,0x21,0x40,	/* 0EE8: @$ s!@ */
	0x24,0xFB,0xD3,0x73,0x71,0x23,0x28,0x20,	/* 0EF0: $sq#(  */
	0xE9,0x77,0x53,0xF1,0x24,0x48,0xF4,0xA9,	/* 0EF8: wS$H */
	0x20,0x48,0x71,0x23,0x28,0x20,0xEA,0x08,	/* 0F00:  Hq#( . */
	0x20,0x28,0x44,0x71,0x23,0x28,0x20,0xEA,	/* 0F08:  (Dq#(  */
	0x77,0x21,0x50,0xF1,0x25,0xFA,0xD0,0x77,	/* 0F10: w!P%w */
	0x22,0x81,0x23,0xFB,0x77,0x5D,0xF1,0x77,	/* 0F18: "#w]w */
	0x21,0x58,0x23,0xFB,0x70,0x28,0x40,0x24,	/* 0F20: !X#p(@$ */
	0xF6,0xA5,0x20,0x40,0xD3,0x21,0x06,0x70,	/* 0F28:  @!.p */
	0x48,0x24,0xF6,0xA5,0x20,0x42,0xD3,0x0D,	/* 0F30: H$ B. */
	0x20,0x70,0x44,0x24,0xF6,0xA5,0x20,0x44,	/* 0F38:  pD$ D */
	0xD3,0x03,0x20,0x43,0xD3,0x70,0x41,0x24,	/* 0F40: . CpA$ */
	0xF6,0xA9,0x20,0x73,0x21,0x48,0x24,0xFB,	/* 0F48:  s!H$ */
	0xD3,0x0D,0x20,0x70,0x42,0x24,0xF6,0xC0,	/* 0F50: . pB$ */
	0xA6,0x20,0x73,0x48,0x24,0xFB,0xD3,0x73,	/* 0F58:  sH$s */
	0x71,0x23,0x28,0x21,0xEE,0x40,0xD3,0x77,	/* 0F60: q#(!@w */
	0x5D,0xF1,0x44,0x24,0xF6,0x22,0xAB,0x77,	/* 0F68: ]D$"w */
	0x22,0x87,0xF1,0xAF,0x20,0x71,0x23,0x28,	/* 0F70: " q#( */
	0x24,0x30,0x2F,0x4F,0x24,0xF6,0x24,0x42,	/* 0F78: $0.O$$B */
	0xF4,0xAF,0x20,0x72,0x64,0x2F,0x4F,0x24,	/* 0F80:  rd.O$ */
	0xF6,0xD2,0x73,0x42,0x24,0xFB,0xD3,0x21,	/* 0F88: sB$! */
	0x00,0x72,0x24,0x20,0x40,0x24,0xFB,0xD2,	/* 0F90: .r$ @$ */
	0x08,0x20,0x72,0x64,0x2F,0x4F,0x24,0xF6,	/* 0F98: . rd.O$ */
	0xD2,0x77,0x21,0x51,0xF1,0x2F,0x4F,0xF4,	/* 0FA0: w!Q.O */
	0xAE,0x20,0x77,0x22,0x87,0xF1,0xC0,0xA7,	/* 0FA8:  w" */
	0x20,0x73,0x28,0x40,0x24,0xFB,0xD3,0x73,	/* 0FB0:  s(@$s */
	0x71,0x23,0x28,0x21,0xEF,0x77,0x22,0x87,	/* 0FB8: q#(!w" */
	0xF1,0x22,0xA9,0x77,0x22,0x87,0xF1,0x21,	/* 0FC0: "w"! */
	0x29,0xA5,0x71,0x23,0x28,0x24,0x30,0x2F,	/* 0FC8: )q#($0. */
	0x4F,0x24,0xF6,0x24,0x42,0xF4,0x21,0x28,	/* 0FD0: O$$B!( */
	0xA6,0x77,0x5D,0xF1,0x44,0x24,0xF6,0x21,	/* 0FD8: w]D$! */
	0x27,0xAD,0x72,0x24,0x20,0x40,0x24,0xFB,	/* 0FE0: 'r$ @$ */
	0xD2,0x21,0x27,0x03,0x40,0xD4,0x40,0xD3,	/* 0FE8: !'.@@ */
	0x40,0xD0,0x77,0x5D,0xF1,0x48,0x24,0xF6,	/* 0FF0: @w]H$ */
	0xA7,0x70,0x21,0x20,0x40,0x24,0xFB,0xD0,	/* 0FF8: p! @$ */
	0x77,0x5A,0xF1,0x28,0x40,0x24,0xF6,0xAA,	/* 1000: wZ(@$ */
	0x70,0x21,0x20,0x20,0x40,0x24,0xFB,0xD0,	/* 1008: p!  @$ */
	0x21,0x08,0x73,0x21,0x20,0x20,0x40,0x24,	/* 1010: !.s!  @$ */
	0xFB,0xD3,0x77,0x21,0x87,0xF1,0x41,0x24,	/* 1018: w!A$ */
	0xF6,0xA8,0x74,0x21,0x20,0x20,0x40,0x24,	/* 1020: t!  @$ */
	0xFB,0xD4,0x77,0x5D,0xF1,0x24,0x40,0x24,	/* 1028: w]$@$ */
	0xF6,0xAA,0x70,0x22,0x20,0x20,0x40,0x24,	/* 1030: p"  @$ */
	0xFB,0xD0,0x21,0x08,0x73,0x22,0x20,0x20,	/* 1038: !.s"   */
	0x40,0x24,0xFB,0xD3,0x77,0x21,0x87,0xF1,	/* 1040: @$w! */
	0x42,0x24,0xF6,0xA8,0x74,0x22,0x20,0x20,	/* 1048: B$t"   */
	0x40,0x24,0xFB,0xD4,0x77,0x5D,0xF1,0x42,	/* 1050: @$w]B */
	0x24,0xF6,0x21,0xA2,0x77,0x5D,0xF1,0x41,	/* 1058: $!w]A */
	0x24,0xF6,0xA6,0x70,0x42,0x24,0xFB,0xD0,	/* 1060: $pB$ */
	0x05,0x70,0x41,0x24,0xFB,0xD0,0x77,0x21,	/* 1068: .pA$w! */
	0x85,0xF1,0x21,0x40,0x24,0xF6,0xA6,0x70,	/* 1070: !@$p */
	0x21,0x40,0x24,0xFB,0xD0,0x77,0x5D,0xF1,	/* 1078: !@$w] */
	0x21,0x40,0x24,0xF6,0xA6,0x70,0x22,0x40,	/* 1080: !@$p"@ */
	0x24,0xFB,0xD0,0x23,0x21,0x23,0x43,0x77,	/* 1088: $#!#Cw */
	0x76,0x27,0x2D,0x96,0x74,0xD0,0x73,0x77,	/* 1090: v'-tsw */
	0x76,0x2A,0x2C,0x96,0x77,0x5D,0xF1,0x22,	/* 1098: v*,w]" */
	0x40,0x24,0xF6,0x23,0xAA,0x77,0x76,0x67,	/* 10A0: @$#wvg */
	0x22,0x91,0x77,0x21,0x85,0xF1,0x21,0x40,	/* 10A8: "w!!@ */
	0x24,0xF6,0xA4,0x2B,0x40,0xD0,0x03,0x2F,	/* 10B0: $+@.. */
	0x40,0xD0,0x77,0x21,0x53,0xF1,0x70,0x24,	/* 10B8: @w!Sp$ */
	0xF6,0x25,0xFA,0xD0,0x71,0x23,0x28,0x21,	/* 10C0: %q#(! */
	0xE6,0x71,0x23,0x28,0x21,0x35,0x4F,0x24,	/* 10C8: q#(!5O$ */
	0xF6,0x70,0x60,0x40,0x24,0xF6,0x24,0xFB,	/* 10D0: p`@$$ */
	0x71,0x23,0x28,0x21,0xE5,0x21,0x09,0x22,	/* 10D8: q#(!!." */
	0x44,0x77,0x5C,0x23,0xFB,0x40,0x71,0x23,	/* 10E0: Dw\#@q# */
	0x28,0x21,0xE6,0x71,0x23,0x28,0x21,0x35,	/* 10E8: (!q#(!5 */
	0x4F,0x24,0xF6,0x71,0x23,0x28,0x21,0xE5,	/* 10F0: O$q#(! */
	0x72,0x60,0x44,0x24,0xF6,0xD2,0x77,0x5D,	/* 10F8: r`D$w] */
	0xF1,0x42,0x24,0xF6,0xA5,0x72,0x42,0x24,	/* 1100: B$rB$ */
	0xFB,0xD2,0x77,0x5D,0xF1,0x48,0x24,0xF6,	/* 1108: w]H$ */
	0xA5,0x72,0x48,0x24,0xFB,0xD2,0x77,0x5D,	/* 1110: rH$w] */
	0xF1,0x41,0x24,0xF6,0xA5,0x72,0x41,0x24,	/* 1118: A$rA$ */
	0xFB,0xD2,0x72,0x62,0x2F,0x2F,0x4F,0x24,	/* 1120: rb..O$ */
	0xF6,0xD2,0x77,0x5D,0xF1,0x22,0x40,0x24,	/* 1128: w]"@$ */
	0xF6,0xA8,0x72,0x22,0x20,0x20,0x40,0x24,	/* 1130: r"  @$ */
	0xFB,0xD2,0x77,0x5A,0xF1,0x28,0x40,0x24,	/* 1138: wZ(@$ */
	0xF6,0xA5,0x72,0x48,0x24,0xFB,0xD2,0x77,	/* 1140: rH$w */
	0x5D,0xF1,0x24,0x40,0x24,0xF6,0xA5,0x72,	/* 1148: ]$@$r */
	0x48,0x24,0xFB,0xD2,0x72,0x48,0x24,0xF6,	/* 1150: H$rH$ */
	0xA6,0x72,0x6F,0x4F,0x24,0xF6,0xD2,0x71,	/* 1158: roO$q */
	0x23,0x28,0x24,0x30,0x2F,0x4F,0x24,0xF6,	/* 1160: #($0.O$ */
	0x24,0x42,0xF4,0xA5,0x76,0x21,0x5B,0xD3,	/* 1168: $Bv![ */
	0x03,0x76,0x5D,0xD3,0x77,0x5B,0xF1,0x44,	/* 1170: .v]w[D */
	0x24,0xF0,0xD0,0x77,0x53,0xF1,0x24,0x48,	/* 1178: $wS$H */
	0xF4,0xC0,0xAA,0x41,0x21,0x4E,0x70,0x24,	/* 1180: A!Np$ */
	0xFF,0xF0,0xC0,0x21,0xA8,0x77,0x53,0xF1,	/* 1188: !wS */
	0x24,0x48,0xF4,0xA7,0x41,0x70,0x4D,0x24,	/* 1190: $HApM$ */
	0xFF,0xF0,0xAA,0x70,0x73,0xFA,0x30,0x71,	/* 1198: ps0q */
	0x23,0x28,0x22,0xE1,0x06,0x48,0x71,0x23,	/* 11A0: #(".Hq# */
	0x28,0x22,0xE1,0x24,0x4E,0x71,0x23,0x28,	/* 11A8: ("$Nq#( */
	0x20,0xE5,0x72,0x77,0xE4,0x40,0xB5,0x22,	/* 11B0:  rw@" */
	0xF0,0x21,0x4A,0x71,0x23,0x28,0x20,0xE5,	/* 11B8: !Jq#(  */
	0x72,0x60,0x4E,0x24,0xF6,0x77,0xE4,0x29,	/* 11C0: r`N$w) */
	0x40,0x71,0x23,0x28,0x20,0xE6,0x40,0x77,	/* 11C8: @q#( @w */
	0x22,0x85,0x23,0xFB,0x77,0x57,0xF1,0x44,	/* 11D0: "#wWD */
	0xF4,0xA6,0x40,0x77,0x57,0x23,0xFB,0x03,	/* 11D8: @wW#. */
	0x77,0x76,0x98,0x41,0x76,0x28,0xE4,0x40,	/* 11E0: wvAv(@ */
	0xB5,0x22,0xF0,0x60,0xBF,0x73,0x31,0xD0,	/* 11E8: "`s1 */
	0x73,0x87,0xF1,0x73,0x32,0x27,0x2F,0x2F,	/* 11F0: ss2'.. */
	0x4F,0x24,0xF6,0x89,0x23,0xFB,0x73,0x87,	/* 11F8: O$#s */
	0xF1,0x70,0x23,0x28,0x27,0xEF,0x73,0x87,	/* 1200: p#('s */
	0xF1,0x43,0x24,0xF6,0x70,0x23,0x28,0x26,	/* 1208: C$p#(& */
	0xE8,0x70,0x23,0x28,0x26,0x3C,0x28,0x40,	/* 1210: p#(&<(@ */
	0x24,0xF6,0xA9,0x40,0x73,0x57,0x23,0xFB,	/* 1218: $@sW# */
	0x41,0x72,0x28,0xE4,0x40,0xB1,0x22,0xF0,	/* 1220: Ar(@" */
	0x60,0xBF,0x73,0x31,0xD0,0x73,0x87,0xF1,	/* 1228: `s1s */
	0x73,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 1230: s2'..O$ */
	0x89,0x23,0xFB,0x73,0x87,0xF1,0x70,0x23,	/* 1238: #sp# */
	0x28,0x27,0xEF,0x73,0x87,0xF1,0x43,0x24,	/* 1240: ('sC$ */
	0xF6,0x70,0x23,0x28,0x26,0xE8,0x73,0x72,	/* 1248: p#(&sr */
	0x22,0x28,0x95,0xA4,0x40,0xB1,0x22,0xF0,	/* 1250: "(@" */
	0x73,0x8D,0xF1,0x73,0x56,0xF1,0xF4,0xA4,	/* 1258: ssV */
	0x41,0xB1,0x22,0xF0,0x73,0x21,0x8F,0xF1,	/* 1260: A"s! */
	0xA8,0x73,0x72,0x2D,0x9C,0x40,0xB1,0x22,	/* 1268: sr-@" */
	0xF0,0x73,0x22,0x89,0xF1,0xC0,0xA9,0x73,	/* 1270: s"s */
	0x34,0x22,0x20,0x40,0x24,0xFB,0x73,0xE4,	/* 1278: 4" @$s */
	0x73,0x34,0x22,0x20,0x40,0x24,0xF6,0xA8,	/* 1280: s4" @$ */
	0x73,0x72,0x2B,0x9D,0x40,0xB1,0x22,0xF0,	/* 1288: sr+@" */
	0x73,0x34,0x21,0x20,0x40,0x24,0xFB,0x73,	/* 1290: s4! @$s */
	0xE4,0x73,0x22,0x87,0xF1,0xAF,0x73,0x34,	/* 1298: s"s4 */
	0x41,0x24,0xFB,0x73,0xE4,0x28,0x44,0x70,	/* 12A0: A$s(Dp */
	0x23,0x28,0x20,0xE6,0x0E,0x73,0x34,0x41,	/* 12A8: #( .s4A */
	0x24,0xFB,0x73,0xE4,0x29,0x42,0x70,0x23,	/* 12B0: $s)Bp# */
	0x28,0x20,0xE6,0x40,0xB1,0x22,0xF0,0x60,	/* 12B8: ( @"` */
	0xBE,0x74,0x31,0xD0,0x74,0x87,0xF1,0x74,	/* 12C0: t1tt */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,	/* 12C8: 2'..O$ */
	0x23,0xFB,0x74,0x87,0xF1,0x70,0x23,0x28,	/* 12D0: #tp#( */
	0x27,0xEF,0x74,0x87,0xF1,0x43,0x24,0xF6,	/* 12D8: 'tC$ */
	0x70,0x23,0x28,0x26,0xE8,0x74,0x23,0x85,	/* 12E0: p#(&t# */
	0xF1,0xD1,0x43,0x71,0xF9,0xAD,0x71,0x21,	/* 12E8: Cqq! */
	0xA0,0x71,0x41,0xF4,0x21,0xA1,0x71,0x42,	/* 12F0: qA!qB */
	0xF4,0xAD,0x06,0x71,0x43,0xF4,0x22,0xA3,	/* 12F8: .qC" */
	0x71,0x41,0x74,0x23,0x85,0x23,0xFB,0x74,	/* 1300: qAt##t */
	0x34,0x41,0x24,0xFB,0x74,0xE4,0x70,0x23,	/* 1308: 4A$tp# */
	0x28,0x20,0x36,0x2F,0x4F,0x24,0xF6,0x42,	/* 1310: ( 6.O$B */
	0x24,0xFB,0x70,0x23,0x28,0x20,0xE6,0x40,	/* 1318: $p#( @ */
	0xB2,0x22,0xF0,0x74,0x57,0xF1,0x4C,0xF4,	/* 1320: "tWL */
	0xC0,0xA6,0x21,0x42,0x74,0x57,0x23,0xFB,	/* 1328: !BtW# */
	0x40,0xB2,0x22,0xF0,0x72,0x71,0x21,0x29,	/* 1330: @"rq!) */
	0x9F,0xC0,0xA5,0x40,0x72,0x57,0x23,0xFB,	/* 1338: @rW# */
	0x40,0x22,0xF0,0x40,0x22,0xF0,0x41,0x22,	/* 1340: @"@"A" */
	0xF0,0x60,0xBD,0x75,0x31,0xD1,0x75,0x87,	/* 1348: `u1u */
	0xF1,0x75,0x32,0x27,0x2F,0x2F,0x4F,0x24,	/* 1350: u2'..O$ */
	0xF6,0x89,0x23,0xFB,0x75,0x87,0xF1,0x71,	/* 1358: #uq */
	0x23,0x28,0x27,0xEF,0x75,0x87,0xF1,0x43,	/* 1360: #('uC */
	0x24,0xF6,0x71,0x23,0x28,0x26,0xE8,0x75,	/* 1368: $q#(&u */
	0x74,0x21,0x26,0x94,0xA4,0x40,0xB3,0x22,	/* 1370: t!&@" */
	0xF0,0x71,0x23,0x28,0x20,0x35,0x2F,0x4F,	/* 1378: q#( 5.O */
	0x24,0xF6,0xA4,0x40,0xB3,0x22,0xF0,0x75,	/* 1380: $@"u */
	0x21,0x8F,0xF1,0xC0,0x24,0xAE,0x75,0x32,	/* 1388: !$u2 */
	0x27,0x2F,0x2F,0x4F,0x24,0xF6,0xD0,0x75,	/* 1390: '..O$u */
	0x34,0x22,0x20,0x40,0x24,0xF6,0x26,0xAE,	/* 1398: 4" @$& */
	0x75,0x87,0xF1,0x43,0xF9,0x21,0xAD,0x70,	/* 13A0: uC!p */
	0x21,0x8D,0xF1,0x60,0x8F,0x25,0xFA,0x70,	/* 13A8: !`%p */
	0x21,0x8D,0x23,0xFB,0x2F,0x4F,0x24,0xF6,	/* 13B0: !#.O$ */
	0xC0,0x22,0xA1,0x24,0x44,0x71,0x23,0x28,	/* 13B8: "$Dq#( */
	0x27,0xEF,0x21,0x08,0x70,0x5E,0xF1,0x60,	/* 13C0: '!.p^` */
	0x8F,0x25,0xFA,0x70,0x5E,0x23,0xFB,0x2F,	/* 13C8: %p^#. */
	0x4F,0x24,0xF6,0xC0,0xA7,0x21,0x40,0x71,	/* 13D0: O$!@q */
	0x23,0x28,0x27,0xEF,0x40,0x75,0x8D,0x23,	/* 13D8: #('@u# */
	0xFB,0x40,0x75,0x55,0x23,0xFB,0x40,0x75,	/* 13E0: @uU#@u */
	0x56,0x23,0xFB,0x40,0x75,0x8B,0x23,0xFB,	/* 13E8: V#@u# */
	0x40,0x75,0x22,0x89,0x23,0xFB,0x75,0x34,	/* 13F0: @u"#u4 */
	0x62,0x2F,0x4F,0x24,0xF6,0x75,0xE4,0x75,	/* 13F8: b.O$uu */
	0x22,0x87,0xF1,0x28,0xA2,0x21,0x44,0x71,	/* 1400: "(!Dq */
	0x23,0x28,0x20,0xE5,0x2A,0x08,0x75,0x22,	/* 1408: #( *.u" */
	0x89,0xF1,0x22,0xA8,0x75,0x34,0x21,0x20,	/* 1410: "u4!  */
	0x40,0x24,0xF6,0x22,0xAA,0x75,0x22,0x50,	/* 1418: @$"u"P */
	0xF1,0x41,0x24,0xF6,0x25,0xAD,0x21,0x48,	/* 1420: A$%!H */
	0x71,0x23,0x28,0x20,0xE5,0x75,0x22,0x50,	/* 1428: q#( u"P */
	0xF1,0x60,0x4E,0x24,0xF6,0x75,0x22,0x50,	/* 1430: `N$u"P */
	0x23,0xFB,0x24,0x07,0x75,0x34,0x22,0x20,	/* 1438: #$.u4"  */
	0x40,0x24,0xFB,0x75,0xE4,0x23,0x0C,0x75,	/* 1440: @$u#.u */
	0x34,0x21,0x20,0x40,0x24,0xFB,0x75,0xE4,	/* 1448: 4! @$u */
	0x40,0x75,0x8D,0x23,0xFB,0x40,0x75,0x56,	/* 1450: @u#@uV */
	0x23,0xFB,0x75,0x22,0x87,0xF1,0xAF,0x75,	/* 1458: #u"u */
	0x34,0x41,0x24,0xFB,0x75,0xE4,0x28,0x44,	/* 1460: 4A$u(D */
	0x71,0x23,0x28,0x20,0xE6,0x0E,0x75,0x34,	/* 1468: q#( .u4 */
	0x41,0x24,0xFB,0x75,0xE4,0x29,0x42,0x71,	/* 1470: A$u)Bq */
	0x23,0x28,0x20,0xE6,0x28,0x42,0x71,0x23,	/* 1478: #( (Bq# */
	0x28,0x20,0xE5,0x40,0xB3,0x22,0xF0,0x75,	/* 1480: ( @"u */
	0x21,0x87,0xF1,0x41,0x24,0xF6,0xC0,0xAB,	/* 1488: !A$ */
	0x40,0xD0,0x21,0x20,0x20,0x40,0x75,0x74,	/* 1490: @!  @ut */
	0x26,0x2C,0x97,0x75,0x21,0x87,0xF1,0x42,	/* 1498: &,u!B */
	0x24,0xF6,0xC0,0xAB,0x40,0xD0,0x22,0x20,	/* 14A0: $@"  */
	0x20,0x40,0x75,0x74,0x26,0x2B,0x93,0x28,	/* 14A8:  @ut&+( */
	0x40,0x71,0x23,0x28,0x20,0xE5,0x75,0x34,	/* 14B0: @q#( u4 */
	0x60,0x4E,0x24,0xF6,0x75,0xE4,0x40,0x71,	/* 14B8: `N$u@q */
	0x23,0x28,0x20,0xE6,0x41,0x75,0x21,0x8F,	/* 14C0: #( Au! */
	0x23,0xFB,0x21,0x40,0x75,0x57,0x23,0xFB,	/* 14C8: #!@uW# */
	0x41,0x74,0x28,0xE4,0x40,0xB3,0x22,0xF0,	/* 14D0: At(@" */
	0x60,0xBE,0x74,0x31,0xD0,0x74,0x87,0xF1,	/* 14D8: `t1t */
	0x74,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 14E0: t2'..O$ */
	0x89,0x23,0xFB,0x74,0x87,0xF1,0x70,0x23,	/* 14E8: #tp# */
	0x28,0x27,0xEF,0x74,0x87,0xF1,0x43,0x24,	/* 14F0: ('tC$ */
	0xF6,0x70,0x23,0x28,0x26,0xE8,0x74,0x23,	/* 14F8: p#(&t# */
	0x85,0xF1,0xD1,0x43,0x71,0xF9,0xA5,0x71,	/* 1500: Cqq */
	0x24,0xAD,0x71,0x0E,0x71,0x43,0xF4,0xAA,	/* 1508: $q.qC */
	0x71,0x44,0xF4,0x22,0xA6,0x71,0x45,0xF4,	/* 1510: qD"qE */
	0x22,0xA1,0x74,0x53,0xF1,0x24,0x48,0xF4,	/* 1518: "tS$H */
	0xC0,0x21,0xA2,0x70,0x23,0x28,0x20,0x35,	/* 1520: !p#( 5 */
	0x2F,0x4F,0x24,0xF6,0xC0,0xAD,0x28,0x42,	/* 1528: .O$(B */
	0x70,0x23,0x28,0x20,0xE5,0x44,0x74,0x23,	/* 1530: p#( Dt# */
	0x85,0x23,0xFB,0x74,0x34,0x41,0x24,0xFB,	/* 1538: #t4A$ */
	0x74,0xE4,0x70,0x23,0x28,0x20,0x36,0x2F,	/* 1540: tp#( 6. */
	0x4F,0x24,0xF6,0x42,0x24,0xFB,0x70,0x23,	/* 1548: O$B$p# */
	0x28,0x20,0xE6,0x41,0xB2,0x22,0xF0,0x40,	/* 1550: ( A"@ */
	0xB2,0x22,0xF0,0x60,0xBF,0x73,0x31,0xD0,	/* 1558: "`s1 */
	0x73,0x87,0xF1,0x73,0x32,0x27,0x2F,0x2F,	/* 1560: ss2'.. */
	0x4F,0x24,0xF6,0x89,0x23,0xFB,0x73,0x87,	/* 1568: O$#s */
	0xF1,0x70,0x23,0x28,0x27,0xEF,0x73,0x87,	/* 1570: p#('s */
	0xF1,0x43,0x24,0xF6,0x70,0x23,0x28,0x26,	/* 1578: C$p#(& */
	0xE8,0x73,0x22,0x87,0xF1,0xC0,0xAE,0x70,	/* 1580: s"p */
	0x23,0x28,0x20,0x3B,0x2F,0x4B,0x24,0xF6,	/* 1588: #( ;.K$ */
	0x70,0x23,0x28,0x20,0xEB,0x40,0x73,0x57,	/* 1590: p#( @sW */
	0x23,0xFB,0x41,0x72,0x28,0xE4,0x40,0xB1,	/* 1598: #Ar(@ */
	0x22,0xF0,0x60,0xBF,0x73,0x31,0xD0,0x73,	/* 15A0: "`s1s */
	0x87,0xF1,0x73,0x32,0x27,0x2F,0x2F,0x4F,	/* 15A8: s2'..O */
	0x24,0xF6,0x89,0x23,0xFB,0x73,0x87,0xF1,	/* 15B0: $#s */
	0x70,0x23,0x28,0x27,0xEF,0x73,0x87,0xF1,	/* 15B8: p#('s */
	0x43,0x24,0xF6,0x70,0x23,0x28,0x26,0xE8,	/* 15C0: C$p#(& */
	0x70,0x23,0x28,0x20,0x35,0x2F,0x4F,0x24,	/* 15C8: p#( 5.O$ */
	0xF6,0xA4,0x40,0xB1,0x22,0xF0,0x73,0x8D,	/* 15D0: @"s */
	0xF1,0x73,0x56,0x23,0xFB,0x28,0x42,0x70,	/* 15D8: sV#(Bp */
	0x23,0x28,0x20,0xE5,0x73,0x72,0x68,0x93,	/* 15E0: #( srh */
	0x40,0xB1,0x22,0xF0,0x72,0x8B,0xF1,0x72,	/* 15E8: @"rr */
	0x55,0x23,0xFB,0x41,0x71,0x28,0xE4,0x40,	/* 15F0: U#Aq(@ */
	0x72,0x57,0x23,0xFB,0x40,0x22,0xF0,0x60,	/* 15F8: rW#@"` */
	0xBF,0x73,0x31,0xD0,0x73,0x87,0xF1,0x73,	/* 1600: s1ss */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,	/* 1608: 2'..O$ */
	0x23,0xFB,0x73,0x87,0xF1,0x70,0x23,0x28,	/* 1610: #sp#( */
	0x27,0xEF,0x73,0x87,0xF1,0x43,0x24,0xF6,	/* 1618: 'sC$ */
	0x70,0x23,0x28,0x26,0xE8,0x73,0x22,0x87,	/* 1620: p#(&s" */
	0xF1,0xC0,0x21,0xA1,0x70,0x23,0x28,0x20,	/* 1628: !p#(  */
	0x3B,0x2F,0x4F,0x24,0xF6,0x44,0x24,0xFB,	/* 1630: ;.O$D$ */
	0x70,0x23,0x28,0x20,0xEB,0x41,0x72,0x28,	/* 1638: p#( Ar( */
	0xE4,0x40,0x73,0x57,0x23,0xFB,0x40,0xB1,	/* 1640: @sW#@ */
	0x22,0xF0,0x60,0xBF,0x73,0x31,0xD0,0x73,	/* 1648: "`s1s */
	0x87,0xF1,0x73,0x32,0x27,0x2F,0x2F,0x4F,	/* 1650: s2'..O */
	0x24,0xF6,0x89,0x23,0xFB,0x73,0x87,0xF1,	/* 1658: $#s */
	0x70,0x23,0x28,0x27,0xEF,0x73,0x87,0xF1,	/* 1660: p#('s */
	0x43,0x24,0xF6,0x70,0x23,0x28,0x26,0xE8,	/* 1668: C$p#(& */
	0x74,0x70,0x23,0x28,0x26,0xEF,0x4F,0x72,	/* 1670: tp#(&Or */
	0x22,0x2F,0x26,0x94,0x70,0x23,0x28,0x26,	/* 1678: ".&p#(& */
	0x3F,0x2F,0x4F,0x24,0xF6,0x75,0x24,0xF6,	/* 1680: ?.O$u$ */
	0x21,0xAE,0x40,0x70,0x23,0x28,0x26,0xEF,	/* 1688: !@p#(& */
	0x4F,0x72,0x22,0x2F,0x24,0x9A,0x70,0x23,	/* 1690: Or".$p# */
	0x28,0x26,0x3F,0x2F,0x4F,0x24,0xF6,0x75,	/* 1698: (&?.O$u */
	0x24,0xF6,0xA9,0x76,0x81,0xB1,0x22,0xF0,	/* 16A0: $v" */
	0x76,0xB1,0x22,0xF0,0x40,0xB1,0x22,0xF0,	/* 16A8: v"@" */
	0x60,0xBC,0x76,0x31,0xD2,0x40,0xD3,0x76,	/* 16B0: `v1@v */
	0x87,0xF1,0x76,0x32,0x27,0x2F,0x2F,0x4F,	/* 16B8: v2'..O */
	0x24,0xF6,0x89,0x23,0xFB,0x76,0x87,0xF1,	/* 16C0: $#v */
	0x72,0x23,0x28,0x27,0xEF,0x76,0x87,0xF1,	/* 16C8: r#('v */
	0x43,0x24,0xF6,0x72,0x23,0x28,0x26,0xE8,	/* 16D0: C$r#(& */
	0x76,0x22,0x87,0xF1,0xC0,0xA2,0x4E,0xD3,	/* 16D8: v"N */
	0x73,0xC0,0xAB,0x22,0x40,0xD0,0x49,0xD1,	/* 16E0: s"@I */
	0x41,0x76,0x75,0x6A,0x9D,0xD3,0x73,0xC0,	/* 16E8: Avujs */
	0xAB,0x21,0x40,0xD0,0x4B,0xD1,0x44,0x76,	/* 16F0: !@KDv */
	0x75,0x6B,0x9F,0xD3,0x72,0x23,0x28,0x26,	/* 16F8: ukr#(& */
	0x3F,0x28,0x40,0x24,0xF6,0x25,0xFA,0xD1,	/* 1700: ?(@$% */
	0xC0,0xA7,0x4E,0xD3,0x71,0x76,0x5C,0x23,	/* 1708: Nqv\# */
	0xFB,0x73,0xC0,0x23,0xAA,0x48,0xD0,0x42,	/* 1710: s#HB */
	0x72,0x23,0x28,0x26,0xEF,0x4F,0x75,0x22,	/* 1718: r#(&Ou" */
	0x2E,0x2B,0x9D,0x40,0x72,0x23,0x28,0x26,	/* 1720: .+@r#(& */
	0xEF,0x4F,0x75,0x22,0x2E,0x2B,0x91,0x72,	/* 1728: Ou".+r */
	0x23,0x28,0x26,0x3F,0x28,0x40,0x24,0xF6,	/* 1730: #(&?(@$ */
	0x25,0xFA,0xD1,0xAA,0x73,0xC0,0xA2,0x70,	/* 1738: %Ѫsp */
	0xD3,0x71,0x76,0x5C,0x23,0xFB,0x70,0x60,	/* 1740: qv\#p` */
	0x8F,0x25,0xFA,0xD0,0xA2,0x63,0x08,0x73,	/* 1748: %Тc.s */
	0xC0,0x23,0xAC,0x42,0x72,0x23,0x28,0x26,	/* 1750: #Br#(& */
	0xEF,0x4F,0x75,0x22,0x2E,0x28,0x91,0x40,	/* 1758: Ou".(@ */
	0x72,0x23,0x28,0x26,0xEF,0x22,0x27,0x21,	/* 1760: r#(&"'! */
	0x40,0xD0,0x72,0x23,0x28,0x26,0x3F,0x2F,	/* 1768: @r#(&?. */
	0x4F,0x24,0xF6,0x25,0xFA,0xD1,0x24,0x40,	/* 1770: O$%$@ */
	0x24,0xF6,0xC0,0xA9,0x70,0x60,0x8F,0x25,	/* 1778: $p`% */
	0xFA,0xD0,0xA2,0x61,0x05,0x70,0xC0,0xA7,	/* 1780: Тa.p */
	0x71,0x76,0x5C,0x23,0xFB,0x4D,0xD3,0x4F,	/* 1788: qv\#MO */
	0x75,0x22,0x2E,0x24,0x9B,0x42,0x72,0x23,	/* 1790: u".$Br# */
	0x28,0x26,0xEF,0x4F,0x75,0x22,0x2E,0x23,	/* 1798: (&Ou".# */
	0x9F,0x40,0x72,0x23,0x28,0x26,0xEF,0x28,	/* 17A0: @r#(&( */
	0x42,0x72,0x23,0x28,0x20,0xE5,0x73,0x76,	/* 17A8: Br#( sv */
	0x21,0x54,0x23,0xFB,0x73,0xA6,0x45,0x72,	/* 17B0: !T#sEr */
	0x23,0x28,0x26,0xEF,0x40,0x76,0x57,0x23,	/* 17B8: #(&@vW# */
	0xFB,0x40,0xB4,0x22,0xF0,0x21,0x40,0x72,	/* 17C0: @"!@r */
	0x71,0x9F,0x22,0xF0,0x42,0x72,0x71,0x99,	/* 17C8: q"Brq */
	0x22,0xF0,0x28,0x40,0x72,0x71,0x92,0x22,	/* 17D0: "(@rq" */
	0xF0,0x60,0xBF,0x73,0x31,0xD0,0x73,0x87,	/* 17D8: `s1s */
	0xF1,0x73,0x32,0x27,0x2F,0x2F,0x4F,0x24,	/* 17E0: s2'..O$ */
	0xF6,0x89,0x23,0xFB,0x73,0x87,0xF1,0x70,	/* 17E8: #sp */
	0x23,0x28,0x27,0xEF,0x73,0x87,0xF1,0x43,	/* 17F0: #('sC */
	0x24,0xF6,0x70,0x23,0x28,0x26,0xE8,0x74,	/* 17F8: $p#(&t */
	0x46,0x24,0xF6,0xA7,0x73,0x34,0x41,0x24,	/* 1800: F$s4A$ */
	0xFB,0x73,0xE4,0x70,0x23,0x28,0x20,0x36,	/* 1808: sp#( 6 */
	0x2F,0x4F,0x24,0xF6,0x74,0x24,0xFB,0x70,	/* 1810: .O$t$p */
	0x23,0x28,0x20,0xE6,0x41,0x72,0x28,0xE4,	/* 1818: #( Ar( */
	0x40,0x73,0x57,0x23,0xFB,0x40,0xB1,0x22,	/* 1820: @sW#@" */
	0xF0,0x60,0xBF,0x73,0x31,0xD0,0x73,0x87,	/* 1828: `s1s */
	0xF1,0x73,0x32,0x27,0x2F,0x2F,0x4F,0x24,	/* 1830: s2'..O$ */
	0xF6,0x89,0x23,0xFB,0x73,0x87,0xF1,0x70,	/* 1838: #sp */
	0x23,0x28,0x27,0xEF,0x73,0x87,0xF1,0x43,	/* 1840: #('sC */
	0x24,0xF6,0x70,0x23,0x28,0x26,0xE8,0x73,	/* 1848: $p#(&s */
	0x34,0x60,0x4E,0x24,0xF6,0x73,0xE4,0x40,	/* 1850: 4`N$s@ */
	0x70,0x23,0x28,0x20,0xE6,0x41,0x72,0x28,	/* 1858: p#( Ar( */
	0xE4,0x40,0x73,0x57,0x23,0xFB,0x40,0xB1,	/* 1860: @sW#@ */
	0x22,0xF0,0x60,0xBF,0x73,0x31,0xD0,0x73,	/* 1868: "`s1s */
	0x87,0xF1,0x73,0x32,0x27,0x2F,0x2F,0x4F,	/* 1870: s2'..O */
	0x24,0xF6,0x89,0x23,0xFB,0x73,0x87,0xF1,	/* 1878: $#s */
	0x70,0x23,0x28,0x27,0xEF,0x73,0x87,0xF1,	/* 1880: p#('s */
	0x43,0x24,0xF6,0x70,0x23,0x28,0x26,0xE8,	/* 1888: C$p#(& */
	0x74,0x41,0x24,0xF6,0x24,0xA8,0x75,0x41,	/* 1890: tA$$uA */
	0x24,0xF6,0x22,0xA6,0x70,0x23,0x28,0x20,	/* 1898: $"p#(  */
	0x39,0x2F,0x4F,0x24,0xF6,0x24,0x40,0x24,	/* 18A0: 9.O$$@$ */
	0xFB,0x70,0x23,0x28,0x20,0xE9,0x70,0x23,	/* 18A8: p#( p# */
	0x28,0x20,0x3A,0x2F,0x4F,0x24,0xF6,0x23,	/* 18B0: ( :.O$# */
	0x40,0x24,0xFB,0x70,0x23,0x28,0x20,0xEA,	/* 18B8: @$p#(  */
	0x21,0x0C,0x70,0x23,0x28,0x20,0x39,0x2B,	/* 18C0: !.p#( 9+ */
	0x4F,0x24,0xF6,0x70,0x23,0x28,0x20,0xE9,	/* 18C8: O$p#(  */
	0x70,0x23,0x28,0x20,0x3A,0x2C,0x4F,0x24,	/* 18D0: p#( :,O$ */
	0xF6,0x70,0x23,0x28,0x20,0xEA,0x74,0x42,	/* 18D8: p#( tB */
	0x24,0xF6,0x22,0xA7,0x75,0x42,0x24,0xF6,	/* 18E0: $"uB$ */
	0x21,0xA3,0x70,0x23,0x28,0x20,0x39,0x2F,	/* 18E8: !p#( 9. */
	0x4F,0x24,0xF6,0x28,0x40,0x24,0xFB,0x70,	/* 18F0: O$(@$p */
	0x23,0x28,0x20,0xE9,0x0E,0x70,0x23,0x28,	/* 18F8: #( .p#( */
	0x20,0x39,0x27,0x4F,0x24,0xF6,0x70,0x23,	/* 1900:  9'O$p# */
	0x28,0x20,0xE9,0x74,0x21,0x40,0x24,0xF6,	/* 1908: ( t!@$ */
	0x22,0xA7,0x75,0x21,0x40,0x24,0xF6,0x21,	/* 1910: "u!@$! */
	0xA2,0x70,0x23,0x28,0x20,0x39,0x2F,0x4F,	/* 1918: p#( 9.O */
	0x24,0xF6,0x42,0x24,0xFB,0x70,0x23,0x28,	/* 1920: $B$p#( */
	0x20,0xE9,0x0E,0x70,0x23,0x28,0x20,0x39,	/* 1928:  .p#( 9 */
	0x2F,0x4D,0x24,0xF6,0x70,0x23,0x28,0x20,	/* 1930: .M$p#(  */
	0xE9,0x74,0x22,0x40,0x24,0xF6,0xAD,0x73,	/* 1938: t"@$s */
	0x22,0x50,0xF1,0x21,0x40,0x24,0xFB,0x73,	/* 1940: "P!@$s */
	0x22,0x50,0x23,0xFB,0x73,0x53,0xF1,0x24,	/* 1948: "P#sS$ */
	0x48,0xF4,0x23,0xA8,0x74,0x21,0x20,0x20,	/* 1950: H#t!   */
	0x40,0x24,0xF6,0x21,0x2A,0xA0,0x73,0x21,	/* 1958: @$!*s! */
	0x52,0xF1,0x48,0x24,0xF6,0x21,0x27,0xAF,	/* 1960: RH$!' */
	0x75,0x21,0x20,0x20,0x40,0x24,0xF6,0x21,	/* 1968: u!  @$! */
	0x25,0xAF,0x70,0x23,0x28,0x21,0x35,0x2F,	/* 1970: %p#(!5. */
	0x40,0x24,0xF6,0x49,0x24,0xFB,0x70,0x23,	/* 1978: @$I$p# */
	0x28,0x21,0xE5,0x42,0x70,0x23,0x28,0x26,	/* 1980: (!Bp#(& */
	0xED,0x21,0x27,0x02,0x70,0x23,0x28,0x21,	/* 1988: !'.p#(! */
	0x35,0x2F,0x40,0x24,0xF6,0x4F,0x24,0xFB,	/* 1990: 5.@$O$ */
	0x70,0x23,0x28,0x21,0xE5,0x74,0x21,0x20,	/* 1998: p#(!t!  */
	0x40,0x24,0xF6,0x22,0xA9,0x75,0x21,0x20,	/* 19A0: @$"u!  */
	0x40,0x24,0xF6,0x21,0xA3,0x70,0x23,0x28,	/* 19A8: @$!p#( */
	0x21,0x3F,0x2F,0x4F,0x24,0xF6,0x48,0x24,	/* 19B0: !?.O$H$ */
	0xFB,0x70,0x23,0x28,0x21,0xEF,0x0F,0x20,	/* 19B8: p#(!.  */
	0x70,0x23,0x28,0x21,0x3F,0x2F,0x47,0x24,	/* 19C0: p#(!?.G$ */
	0xF6,0x70,0x23,0x28,0x21,0xEF,0x74,0x21,	/* 19C8: p#(!t! */
	0x20,0x20,0x40,0x24,0xF6,0x27,0xA7,0x73,	/* 19D0:   @$'s */
	0x21,0x52,0xF1,0x48,0x24,0xF6,0x23,0xA8,	/* 19D8: !RH$# */
	0x75,0x21,0x20,0x20,0x40,0x24,0xF6,0x21,	/* 19E0: u!  @$! */
	0xA6,0x70,0x23,0x28,0x21,0x3F,0x2F,0x4B,	/* 19E8: p#(!?.K */
	0x24,0xF6,0x70,0x23,0x28,0x21,0xEF,0x42,	/* 19F0: $p#(!B */
	0x70,0x23,0x28,0x26,0xED,0x24,0x0F,0x70,	/* 19F8: p#(&$.p */
	0x23,0x28,0x21,0x3F,0x2F,0x4F,0x24,0xF6,	/* 1A00: #(!?.O$ */
	0x44,0x24,0xFB,0x70,0x23,0x28,0x21,0xEF,	/* 1A08: D$p#(! */
	0x40,0x70,0x23,0x28,0x26,0xED,0x23,0x06,	/* 1A10: @p#(&#. */
	0x75,0x21,0x20,0x20,0x40,0x24,0xF6,0x21,	/* 1A18: u!  @$! */
	0xA9,0x70,0x23,0x28,0x20,0x39,0x2F,0x4F,	/* 1A20: p#( 9.O */
	0x24,0xF6,0x44,0x24,0xFB,0x70,0x23,0x28,	/* 1A28: $D$p#( */
	0x20,0xE9,0x41,0x70,0x23,0x28,0x26,0xEC,	/* 1A30:  Ap#(& */
	0x21,0x04,0x70,0x23,0x28,0x20,0x39,0x2F,	/* 1A38: !.p#( 9. */
	0x4B,0x24,0xF6,0x70,0x23,0x28,0x20,0xE9,	/* 1A40: K$p#(  */
	0x40,0x70,0x23,0x28,0x26,0xEC,0x74,0x22,	/* 1A48: @p#(&t" */
	0x20,0x20,0x40,0x24,0xF6,0x21,0x20,0xA7,	/* 1A50:   @$!  */
	0x73,0x21,0x52,0xF1,0x48,0x24,0xF6,0x23,	/* 1A58: s!RH$# */
	0xA8,0x75,0x22,0x20,0x20,0x40,0x24,0xF6,	/* 1A60: u"  @$ */
	0x21,0xA9,0x70,0x23,0x28,0x20,0x39,0x2F,	/* 1A68: !p#( 9. */
	0x4F,0x24,0xF6,0x44,0x24,0xFB,0x70,0x23,	/* 1A70: O$D$p# */
	0x28,0x20,0xE9,0x41,0x70,0x23,0x28,0x26,	/* 1A78: ( Ap#(& */
	0xEC,0x2D,0x0C,0x70,0x23,0x28,0x20,0x39,	/* 1A80: -.p#( 9 */
	0x2F,0x4B,0x24,0xF6,0x70,0x23,0x28,0x20,	/* 1A88: .K$p#(  */
	0xE9,0x40,0x70,0x23,0x28,0x26,0xEC,0x2C,	/* 1A90: @p#(&, */
	0x06,0x75,0x22,0x20,0x20,0x40,0x24,0xF6,	/* 1A98: .u"  @$ */
	0x21,0xA6,0x70,0x23,0x28,0x21,0x3F,0x2F,	/* 1AA0: !p#(!?. */
	0x4B,0x24,0xF6,0x70,0x23,0x28,0x21,0xEF,	/* 1AA8: K$p#(! */
	0x42,0x70,0x23,0x28,0x26,0xED,0x2A,0x07,	/* 1AB0: Bp#(&*. */
	0x70,0x23,0x28,0x21,0x3F,0x2F,0x4F,0x24,	/* 1AB8: p#(!?.O$ */
	0xF6,0x44,0x24,0xFB,0x70,0x23,0x28,0x21,	/* 1AC0: D$p#(! */
	0xEF,0x40,0x70,0x23,0x28,0x26,0xED,0x28,	/* 1AC8: @p#(&( */
	0x0E,0x70,0x23,0x28,0x21,0x35,0x2F,0x40,	/* 1AD0: .p#(!5.@ */
	0x24,0xF6,0x70,0x23,0x28,0x21,0xE5,0x40,	/* 1AD8: $p#(!@ */
	0x70,0x23,0x28,0x26,0xED,0x21,0x07,0x75,	/* 1AE0: p#(&!.u */
	0x21,0x20,0x20,0x40,0x24,0xF6,0xA9,0x20,	/* 1AE8: !  @$  */
	0x41,0x70,0x23,0x28,0x26,0xEC,0x07,0x20,	/* 1AF0: Ap#(&.  */
	0x40,0x70,0x23,0x28,0x26,0xEC,0x74,0x22,	/* 1AF8: @p#(&t" */
	0x20,0x20,0x40,0x24,0xF6,0x25,0xA8,0x73,	/* 1B00:   @$%s */
	0x21,0x52,0xF1,0x48,0x24,0xF6,0x21,0xA9,	/* 1B08: !RH$! */
	0x75,0x22,0x20,0x20,0x40,0x24,0xF6,0xA9,	/* 1B10: u"  @$ */
	0x20,0x41,0x70,0x23,0x28,0x26,0xEC,0x23,	/* 1B18:  Ap#(&# */
	0x0E,0x40,0x70,0x23,0x28,0x26,0xEC,0x23,	/* 1B20: .@p#(&# */
	0x06,0x75,0x22,0x20,0x20,0x40,0x24,0xF6,	/* 1B28: .u"  @$ */
	0x21,0xA9,0x70,0x23,0x28,0x21,0x35,0x2F,	/* 1B30: !p#(!5. */
	0x40,0x24,0xF6,0x49,0x24,0xFB,0x70,0x23,	/* 1B38: @$I$p# */
	0x28,0x21,0xE5,0x42,0x70,0x23,0x28,0x26,	/* 1B40: (!Bp#(& */
	0xED,0x21,0x04,0x70,0x23,0x28,0x21,0x35,	/* 1B48: !.p#(!5 */
	0x2F,0x40,0x24,0xF6,0x70,0x23,0x28,0x21,	/* 1B50: .@$p#(! */
	0xE5,0x40,0x70,0x23,0x28,0x26,0xED,0xB1,	/* 1B58: @p#(& */
	0x22,0xF0,0x60,0xBF,0x73,0x31,0xD0,0x73,	/* 1B60: "`s1s */
	0x87,0xF1,0x73,0x32,0x27,0x2F,0x2F,0x4F,	/* 1B68: s2'..O */
	0x24,0xF6,0x89,0x23,0xFB,0x73,0x87,0xF1,	/* 1B70: $#s */
	0x70,0x23,0x28,0x27,0xEF,0x73,0x87,0xF1,	/* 1B78: p#('s */
	0x43,0x24,0xF6,0x70,0x23,0x28,0x26,0xE8,	/* 1B80: C$p#(& */
	0x74,0x21,0x20,0x20,0x40,0x24,0xF6,0x23,	/* 1B88: t!  @$# */
	0xA9,0x73,0x21,0x52,0xF1,0x48,0x24,0xF6,	/* 1B90: s!RH$ */
	0x21,0xA9,0x75,0x21,0x20,0x20,0x40,0x24,	/* 1B98: !u!  @$ */
	0xF6,0xA9,0x20,0x42,0x70,0x23,0x28,0x26,	/* 1BA0:  Bp#(& */
	0xED,0x21,0x0F,0x40,0x70,0x23,0x28,0x26,	/* 1BA8: !.@p#(& */
	0xED,0x21,0x07,0x75,0x21,0x20,0x20,0x40,	/* 1BB0: !.u!  @ */
	0x24,0xF6,0xA9,0x20,0x41,0x70,0x23,0x28,	/* 1BB8: $ Ap#( */
	0x26,0xEC,0x07,0x20,0x40,0x70,0x23,0x28,	/* 1BC0: &. @p#( */
	0x26,0xEC,0x74,0x22,0x20,0x20,0x40,0x24,	/* 1BC8: &t"  @$ */
	0xF6,0x23,0xAC,0x73,0x21,0x52,0xF1,0x48,	/* 1BD0: #s!RH */
	0x24,0xF6,0x21,0xAB,0x75,0x22,0x20,0x20,	/* 1BD8: $!u"   */
	0x40,0x24,0xF6,0xAA,0x20,0x41,0x70,0x23,	/* 1BE0: @$ Ap# */
	0x28,0x26,0xEC,0xB1,0x22,0xF0,0x40,0x70,	/* 1BE8: (&"@p */
	0x23,0x28,0x26,0xEC,0xB1,0x22,0xF0,0x75,	/* 1BF0: #(&"u */
	0x22,0x20,0x20,0x40,0x24,0xF6,0xAA,0x20,	/* 1BF8: "  @$  */
	0x42,0x70,0x23,0x28,0x26,0xED,0xB1,0x22,	/* 1C00: Bp#(&" */
	0xF0,0x40,0x70,0x23,0x28,0x26,0xED,0xB1,	/* 1C08: @p#(& */
	0x22,0xF0,0x76,0xF6,0x20,0x82,0x00,0x04,	/* 1C10: "v .. */
	0x00,0x16,0x00,0x00,0x00,0x41,0x00,0x00,	/* 1C18: .....A.. */
	0x00,0x41,0x00,0x04,0x00,0x82,0x00,0x03,	/* 1C20: .A..... */
	0x00,0x41,0x00,0x03,0x00,0x82,0x00,0x02,	/* 1C28: .A..... */
	0x00,0x4E,0x00,0x02,0x00,0x41,0x00,0x02,	/* 1C30: .N...A.. */
	0x00,0x82,0x00,0x01,0x00,0x57,0x00,0x02,	/* 1C38: ....W.. */
	0x00,0x41,0x00,0x01,0x00,0x82,0x00,0x00,	/* 1C40: .A..... */
	0x00,0x2B,0x00,0x00,0x00,0xA3,0x00,0x04,	/* 1C48: .+..... */
	0x00,0x1B,0x00,0x00,0x00,0x51,0x00,0x00,	/* 1C50: .....Q.. */
	0x00,0x51,0x00,0x04,0x00,0xA3,0x00,0x03,	/* 1C58: .Q..... */
	0x00,0x51,0x00,0x03,0x00,0xA3,0x00,0x02,	/* 1C60: .Q..... */
	0x00,0x62,0x00,0x02,0x00,0x51,0x00,0x02,	/* 1C68: .b...Q.. */
	0x00,0xA3,0x00,0x01,0x00,0x6D,0x00,0x02,	/* 1C70: ....m.. */
	0x00,0x51,0x00,0x01,0x00,0xA3,0x00,0x00,	/* 1C78: .Q..... */
	0x00,0x36,0x00,0x00,0x00,0x36,0x00,0x05,	/* 1C80: .6...6.. */
	0x00,0x1B,0x00,0x05,0x00,0x0D,0x00,0x05,	/* 1C88: ........ */
	0x00,0xF4,0x00,0x04,0x00,0x6F,0x00,0x04,	/* 1C90: ....o.. */
	0x00,0x5B,0x00,0x04,0x00,0xF4,0x00,0x03,	/* 1C98: .[..... */
	0x00,0x6D,0x00,0x01,0x00,0x38,0x00,0x00,	/* 1CA0: .m...8.. */
	0x00,0x31,0x00,0x00,0x00,0x29,0x00,0x00,	/* 1CA8: .1...).. */
	0x00,0x62,0x00,0x05,0x00,0x53,0x00,0x05,	/* 1CB0: .b...S.. */
	0x00,0xD9,0x00,0x00,0x00,0x30,0x00,0x05,	/* 1CB8: ....0.. */
	0x00,0x6D,0x00,0x00,0x00,0xF0,0x00,0x01,	/* 1CC0: .m..... */
	0x00,0x01,0x00,0x0A,0x00,0x0A,0x00,0x0A,	/* 1CC8: ........ */
	0x00,0x0A,0x00,0x09,0x00,0x08,0x00,0x06,	/* 1CD0: ........ */
	0x00,0x0A,0x00,0x03,0x00,0x02,0x00,0x01,	/* 1CD8: ........ */
	0x00,0xF0,0x00,0x01,0x00,0x01,0x00,0x0A,	/* 1CE0: ....... */
	0x00,0x0A,0x00,0x0A,0x00,0x0A,0x00,0x09,	/* 1CE8: ........ */
	0x00,0x08,0x00,0x06,0x00,0x0A,0x00,0x03,	/* 1CF0: ........ */
	0x00,0x02,0x00,0x01,0x00,0x01,0x00,0x01,	/* 1CF8: ........ */
	0x00,0x01,0x00,0xF0,0x00,0x0A,0x00,0x0A,	/* 1D00: ....... */
	0x00,0x0A,0x00,0x06,0x00,0x01,0x00,0x01,	/* 1D08: ........ */
	0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x03,	/* 1D10: ........ */
	0x00,0x01,0x00,0x02,0x20,0x51,0x00,0x4F,	/* 1D18: .... Q.O */
	0x00,0x4D,0x00,0x4B,0x00,0x49,0x00,0x47,	/* 1D20: .M.K.I.G */
	0x00,0x45,0x00,0x43,0x00,0x41,0x00,0x3F,	/* 1D28: .E.C.A.? */
	0x00,0x3D,0x00,0x3B,0x00,0x39,0x00,0x37,	/* 1D30: .=.;.9.7 */
	0x00,0x35,0x00,0x33,0x00,0x31,0x00,0x2F,	/* 1D38: .5.3.1.. */
	0x00,0x2D,0x00,0x2C,0x00,0x02,0x0C,0x71,	/* 1D40: .-.,...q */
	0x5D,0xD2,0x68,0x47,0x21,0xFB,0x72,0x25,	/* 1D48: ]hG!r% */
	0x47,0x24,0xFA,0x65,0x2D,0x41,0x21,0xFB,	/* 1D50: G$e-A! */
	0x72,0x25,0xE2,0x65,0x27,0x42,0x21,0xFB,	/* 1D58: r%e'B! */
	0x72,0x25,0xE0,0x65,0x26,0x44,0x21,0xFB,	/* 1D60: r%e&D! */
	0x72,0x24,0xEE,0x65,0x25,0x45,0x21,0xFB,	/* 1D68: r$e%E! */
	0x72,0x24,0xEC,0x66,0x23,0x48,0x21,0xFB,	/* 1D70: r$f#H! */
	0x72,0x24,0xEA,0x67,0x27,0x4F,0x21,0xFB,	/* 1D78: r$g'O! */
	0x72,0x24,0xE8,0x67,0x26,0x44,0x21,0xFB,	/* 1D80: r$g&D! */
	0x72,0x24,0xE6,0x67,0x21,0x42,0x21,0xFB,	/* 1D88: r$g!B! */
	0x72,0x24,0xE4,0x68,0x2C,0x43,0x21,0xFB,	/* 1D90: r$h,C! */
	0x72,0x24,0xE2,0x6A,0x2A,0x49,0x21,0xFB,	/* 1D98: r$j*I! */
	0x72,0x24,0xE0,0x6A,0x29,0x4E,0x21,0xFB,	/* 1DA0: r$j)N! */
	0x72,0x23,0xEE,0x6A,0x29,0x43,0x21,0xFB,	/* 1DA8: r#j)C! */
	0x72,0x23,0xEC,0x6A,0x27,0x4C,0x21,0xFB,	/* 1DB0: r#j'L! */
	0x72,0x23,0xEA,0x6B,0x2F,0x4F,0x21,0xFB,	/* 1DB8: r#k.O! */
	0x72,0x23,0xE8,0x6B,0x26,0x40,0x21,0xFB,	/* 1DC0: r#k&@! */
	0x72,0x23,0xE6,0x61,0x2D,0x2E,0x4C,0x21,	/* 1DC8: r#a-.L! */
	0xFB,0x72,0x23,0xE4,0x6B,0x21,0x42,0x21,	/* 1DD0: r#k!B! */
	0xFB,0x72,0x23,0xE2,0x61,0x2D,0x2D,0x4B,	/* 1DD8: r#a--K */
	0x21,0xFB,0x72,0x23,0xE0,0x61,0x2D,0x2D,	/* 1DE0: !r#a-- */
	0x42,0x21,0xFB,0x72,0x22,0xEE,0x72,0x6D,	/* 1DE8: B!r"rm */
	0x4A,0x21,0xFB,0x21,0x44,0x22,0x2C,0x29,	/* 1DF0: J!!D",) */
	0x90,0x22,0xF0,0x60,0xBD,0x74,0x26,0x50,	/* 1DF8: "`t&P */
	0xD1,0x21,0x28,0x40,0xD0,0x71,0x65,0x3C,	/* 1E00: !(@qe< */
	0x87,0xF1,0x81,0x71,0x65,0x3C,0x87,0x23,	/* 1E08: qe<# */
	0xFB,0x74,0x2C,0x93,0x70,0x57,0xF1,0x25,	/* 1E10: t,pW% */
	0xFA,0xD2,0xAE,0x72,0x71,0x62,0x59,0xFA,	/* 1E18: ҮrqbY */
	0x30,0xD2,0x70,0x74,0x2B,0x21,0x9D,0x2A,	/* 1E20: 0pt+!* */
	0xA8,0x70,0x31,0xD2,0x70,0x34,0x41,0x24,	/* 1E28: p1p4A$ */
	0xF6,0xC0,0x24,0xA8,0x70,0x8D,0xF1,0x70,	/* 1E30: $pp */
	0x56,0xF1,0xF4,0x23,0xAF,0x70,0x34,0x41,	/* 1E38: V#p4A */
	0x24,0xFB,0x70,0xE4,0x70,0x87,0xF1,0x70,	/* 1E40: $ppp */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,	/* 1E48: 2'..O$ */
	0x23,0xFB,0x70,0x87,0xF1,0x72,0x23,0x28,	/* 1E50: #pr#( */
	0x27,0xEF,0x70,0x87,0xF1,0x43,0x24,0xF6,	/* 1E58: 'pC$ */
	0x72,0x23,0x28,0x26,0xE8,0x72,0x23,0x28,	/* 1E60: r#(&r#( */
	0x20,0x36,0x2F,0x4F,0x24,0xF6,0x44,0x24,	/* 1E68:  6.O$D$ */
	0xFB,0x72,0x23,0x28,0x20,0xE6,0x41,0x70,	/* 1E70: r#( Ap */
	0x22,0x89,0x23,0xFB,0x70,0x34,0x21,0x40,	/* 1E78: "#p4!@ */
	0x24,0xF6,0x21,0xAC,0x41,0x70,0x55,0xF1,	/* 1E80: $!ApU */
	0x70,0x8B,0xF1,0xFC,0x2F,0x4F,0x24,0xF6,	/* 1E88: p.O$ */
	0x22,0x40,0xF0,0x24,0xFF,0xF0,0xC0,0xA8,	/* 1E90: "@$ */
	0x70,0x34,0x61,0x4F,0x24,0xF6,0x70,0xE4,	/* 1E98: p4aO$p */
	0x70,0x22,0x50,0xF1,0x21,0x40,0x24,0xF6,	/* 1EA0: p"P!@$ */
	0x22,0xA7,0x70,0x87,0xF1,0x70,0x32,0x27,	/* 1EA8: "pp2' */
	0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,0xFB,	/* 1EB0: ..O$# */
	0x70,0x87,0xF1,0x72,0x23,0x28,0x27,0xEF,	/* 1EB8: pr#(' */
	0x70,0x87,0xF1,0x43,0x24,0xF6,0x72,0x23,	/* 1EC0: pC$r# */
	0x28,0x26,0xE8,0x70,0x74,0x22,0x24,0x20,	/* 1EC8: (&pt"$  */
	0x91,0x70,0x21,0x37,0xD0,0x6D,0x0E,0x60,	/* 1ED0: p!7m.` */
	0xB4,0x7D,0x26,0x50,0xD6,0x76,0x30,0xD4,	/* 1ED8: }&Pv0 */
	0x76,0x31,0xD1,0x74,0x33,0xD0,0x71,0x44,	/* 1EE0: v1t3qD */
	0xF8,0x70,0x23,0x28,0x27,0xEF,0x70,0x23,	/* 1EE8: p#('p# */
	0x28,0x26,0x37,0x2F,0x4F,0x24,0xF6,0x25,	/* 1EF0: (&7.O$% */
	0xFA,0xD3,0x41,0x24,0xF6,0x25,0x26,0xAC,	/* 1EF8: A$%& */
	0x70,0x23,0x28,0x26,0x3B,0x2F,0x4F,0x24,	/* 1F00: p#(&;.O$ */
	0xF6,0x25,0xFA,0xD2,0x43,0x24,0xF6,0x70,	/* 1F08: %C$p */
	0x23,0x28,0x26,0xE8,0x71,0x72,0x43,0x24,	/* 1F10: #(&qrC$ */
	0xF6,0x28,0xF1,0x74,0x55,0xFA,0x30,0xD5,	/* 1F18: (tU0 */
	0x70,0x23,0x28,0x24,0x33,0x47,0x24,0xF6,	/* 1F20: p#($3G$ */
	0x43,0xF4,0x2C,0xAF,0x40,0xD9,0x70,0x23,	/* 1F28: C,@p# */
	0x28,0x26,0x32,0x2F,0x4F,0x24,0xF6,0xD8,	/* 1F30: (&2.O$ */
	0x70,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 1F38: p#(&2.O$ */
	0xF6,0xDB,0x78,0x48,0x24,0xF6,0x21,0xA0,	/* 1F40: xH$! */
	0x75,0x21,0x89,0xF1,0x41,0x24,0xFB,0x75,	/* 1F48: u!A$u */
	0x21,0x89,0x23,0xFB,0x41,0x76,0x22,0xE4,	/* 1F50: !#Av" */
	0x78,0x47,0x24,0xF6,0xAD,0x75,0x21,0x50,	/* 1F58: xG$u!P */
	0xF1,0x28,0x40,0x24,0xF6,0xA4,0x41,0x76,	/* 1F60: (@$Av */
	0x22,0xE4,0x78,0x41,0x24,0xF6,0xA8,0x75,	/* 1F68: "xA$u */
	0x21,0x3E,0x41,0xF2,0x75,0x21,0xEE,0x78,	/* 1F70: !>Au!x */
	0x42,0x24,0xF6,0xAA,0x75,0x21,0x3C,0x41,	/* 1F78: B$u!<A */
	0xF2,0x75,0x21,0xEC,0x41,0xD9,0x78,0x44,	/* 1F80: u!AxD */
	0x24,0xF6,0xAA,0x75,0x21,0x3D,0x41,0xF2,	/* 1F88: $u!=A */
	0x75,0x21,0xED,0x41,0xD9,0x79,0x24,0x2C,	/* 1F90: u!Ay$, */
	0xA9,0x75,0x21,0x50,0xF1,0x24,0x40,0x24,	/* 1F98: u!P$@$ */
	0xF6,0xA5,0x75,0x22,0x8B,0xF1,0xDB,0x75,	/* 1FA0: u"u */
	0x55,0xF1,0xD8,0x75,0x8B,0xF1,0x25,0xFA,	/* 1FA8: Uu% */
	0xD9,0x78,0x81,0xFC,0x2F,0x4F,0x24,0xF6,	/* 1FB0: x.O$ */
	0x25,0xFA,0xDA,0x24,0x29,0xAC,0x7B,0x78,	/* 1FB8: %$){x */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 1FC0: .O$u+P */
	0x23,0xFB,0x78,0x81,0x75,0x55,0x23,0xFB,	/* 1FC8: #xuU# */
	0x79,0x78,0x81,0x81,0xFC,0x2F,0x4F,0x24,	/* 1FD0: yx.O$ */
	0xF6,0xD7,0x75,0x34,0x48,0x24,0xF6,0x24,	/* 1FD8: u4H$$ */
	0x28,0xA0,0x7A,0x21,0x4F,0xF9,0x24,0x27,	/* 1FE0: (z!O$' */
	0xA9,0x22,0x40,0x77,0xF9,0x24,0x27,0xA2,	/* 1FE8: "@w$' */
	0x75,0x34,0x21,0x40,0x24,0xFB,0x75,0xE4,	/* 1FF0: u4!@$u */
	0x24,0x26,0x07,0x75,0x34,0x21,0x40,0x24,	/* 1FF8: $&.u4!@$ */
	0xF6,0xC0,0x24,0x24,0xA5,0x75,0x22,0x87,	/* 2000: $$u" */
	0xF1,0xC0,0xAC,0x75,0x21,0x54,0xF1,0x41,	/* 2008: u!TA */
	0x24,0xFB,0x75,0x21,0x54,0x23,0xFB,0x75,	/* 2010: $u!T#u */
	0x55,0xF1,0xD8,0x75,0x8B,0xF1,0x25,0xFA,	/* 2018: Uu% */
	0xD9,0x78,0x81,0xFC,0x2F,0x4F,0x24,0xF6,	/* 2020: x.O$ */
	0xDA,0x70,0x23,0x28,0x20,0x3E,0x2F,0x4F,	/* 2028: p#( >.O */
	0x24,0xF6,0xD7,0x7A,0x77,0xF9,0xA3,0x77,	/* 2030: $zww */
	0xDB,0x02,0x7A,0xDB,0x77,0x7B,0x2F,0x4F,	/* 2038: .zw{.O */
	0x24,0xF6,0xFC,0x2F,0x4F,0x24,0xF6,0xD7,	/* 2040: $.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x41,0xF4,0xDB,	/* 2048: {.O$A */
	0x41,0x22,0x40,0x7B,0x24,0xFF,0xF0,0xC0,	/* 2050: A"@{$ */
	0x23,0x2A,0xA3,0x7B,0x42,0x21,0xFB,0x28,	/* 2058: #*{B!( */
	0xF1,0xF6,0x23,0x28,0x00,0x20,0x23,0x26,	/* 2060: #(. #& */
	0x03,0x20,0x23,0x24,0x06,0x20,0x23,0x22,	/* 2068: . #$. #" */
	0x09,0x20,0x23,0x20,0x0C,0x20,0x22,0x2E,	/* 2070: . # . ". */
	0x0F,0x20,0x22,0x2D,0x02,0x20,0x22,0x2B,	/* 2078: . "-. "+ */
	0x05,0x20,0x22,0x29,0x08,0x20,0x22,0x27,	/* 2080: . "). "' */
	0x0B,0x20,0x22,0x25,0x0E,0x20,0x22,0x24,	/* 2088: . "%. "$ */
	0x01,0x20,0x22,0x22,0x04,0x20,0x22,0x20,	/* 2090: . "". "  */
	0x07,0x20,0x21,0x2E,0x0A,0x20,0x21,0x2C,	/* 2098: . !.. !, */
	0x0D,0x20,0x21,0x2B,0x00,0x20,0x21,0x29,	/* 20A0: . !+. !) */
	0x03,0x20,0x21,0x27,0x06,0x20,0x21,0x25,	/* 20A8: . !'. !% */
	0x09,0x20,0x21,0x23,0x0C,0x20,0x21,0x21,	/* 20B0: . !#. !! */
	0x0F,0x20,0x21,0x20,0x02,0x20,0x2E,0x06,	/* 20B8: . ! . .. */
	0x20,0x20,0x2C,0x09,0x20,0x20,0x2A,0x0C,	/* 20C0:   ,.  *. */
	0x20,0x20,0x28,0x0F,0x20,0x20,0x27,0x02,	/* 20C8:   (.  '. */
	0x20,0x20,0x25,0x05,0x20,0x20,0x23,0x08,	/* 20D0:   %.  #. */
	0x20,0x20,0x21,0x0B,0x20,0x20,0x78,0xDB,	/* 20D8:   !.  x */
	0x78,0x81,0xD8,0x70,0x23,0x28,0x26,0x32,	/* 20E0: xp#(&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 20E8: .O${.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,	/* 20F0: u+P#x */
	0xDB,0x78,0x81,0xD8,0x70,0x23,0x28,0x26,	/* 20F8: xp#(& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 2100: 2.O${.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 2108: $u+P# */
	0x78,0xDB,0x78,0x81,0xD8,0x70,0x23,0x28,	/* 2110: xxp#( */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 2118: &2.O${. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 2120: O$u+P# */
	0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,0x23,	/* 2128: xxp# */
	0x28,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 2130: (&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 2138: .O$u+P */
	0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,	/* 2140: #xxp */
	0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 2148: #(&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 2150: {.O$u+P */
	0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,	/* 2158: #xx */
	0x70,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 2160: p#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 2168: {.O$u+ */
	0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,	/* 2170: P#xx */
	0xD8,0x70,0x23,0x28,0x26,0x32,0x2F,0x4F,	/* 2178: p#(&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,	/* 2180: ${.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,	/* 2188: +P#xx */
	0x81,0xD8,0x70,0x23,0x28,0x26,0x32,0x2F,	/* 2190: p#(&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 2198: O${.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,	/* 21A0: u+P#x */
	0x78,0x81,0xD8,0x70,0x23,0x28,0x26,0x32,	/* 21A8: xp#(&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 21B0: .O${.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,	/* 21B8: u+P#x */
	0xDB,0x78,0x81,0xD8,0x70,0x23,0x28,0x26,	/* 21C0: xp#(& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 21C8: 2.O${.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 21D0: $u+P# */
	0x78,0xDB,0x78,0x81,0xD8,0x70,0x23,0x28,	/* 21D8: xxp#( */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 21E0: &2.O${. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 21E8: O$u+P# */
	0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,0x23,	/* 21F0: xxp# */
	0x28,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 21F8: (&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 2200: .O$u+P */
	0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,	/* 2208: #xxp */
	0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 2210: #(&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 2218: {.O$u+P */
	0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,	/* 2220: #xx */
	0x70,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 2228: p#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 2230: {.O$u+ */
	0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,	/* 2238: P#xx */
	0xD8,0x70,0x23,0x28,0x26,0x32,0x2F,0x4F,	/* 2240: p#(&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,	/* 2248: ${.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,	/* 2250: +P#xx */
	0x81,0xD8,0x70,0x23,0x28,0x26,0x32,0x2F,	/* 2258: p#(&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 2260: O${.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,	/* 2268: u+P#x */
	0x78,0x81,0xD8,0x70,0x23,0x28,0x26,0x32,	/* 2270: xp#(&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 2278: .O${.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,	/* 2280: u+P#x */
	0xDB,0x78,0x81,0xD8,0x70,0x23,0x28,0x26,	/* 2288: xp#(& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 2290: 2.O${.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 2298: $u+P# */
	0x78,0xDB,0x78,0x81,0xD8,0x70,0x23,0x28,	/* 22A0: xxp#( */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 22A8: &2.O${. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 22B0: O$u+P# */
	0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,0x23,	/* 22B8: xxp# */
	0x28,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 22C0: (&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 22C8: .O$u+P */
	0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,	/* 22D0: #xxp */
	0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 22D8: #(&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 22E0: {.O$u+P */
	0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,	/* 22E8: #xx */
	0x70,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 22F0: p#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 22F8: {.O$u+ */
	0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,	/* 2300: P#xx */
	0xD8,0x70,0x23,0x28,0x26,0x32,0x2F,0x4F,	/* 2308: p#(&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,	/* 2310: ${.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,	/* 2318: +P#xx */
	0x81,0xD8,0x70,0x23,0x28,0x26,0x32,0x2F,	/* 2320: p#(&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 2328: O${.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,	/* 2330: u+P#x */
	0x78,0x81,0xD8,0x70,0x23,0x28,0x26,0x32,	/* 2338: xp#(&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 2340: .O${.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,	/* 2348: u+P#x */
	0xDB,0x78,0x81,0xD8,0x70,0x23,0x28,0x26,	/* 2350: xp#(& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 2358: 2.O${.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 2360: $u+P# */
	0x78,0xDB,0x78,0x81,0xD8,0x70,0x23,0x28,	/* 2368: xxp#( */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 2370: &2.O${. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 2378: O$u+P# */
	0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,0x23,	/* 2380: xxp# */
	0x28,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 2388: (&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 2390: .O$u+P */
	0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,	/* 2398: #xxp */
	0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 23A0: #(&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 23A8: {.O$u+P */
	0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,	/* 23B0: #xx */
	0x70,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 23B8: p#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 23C0: {.O$u+ */
	0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,	/* 23C8: P#xx */
	0xD8,0x70,0x23,0x28,0x26,0x32,0x2F,0x4F,	/* 23D0: p#(&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,	/* 23D8: ${.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,	/* 23E0: +P#xx */
	0x81,0xD8,0x70,0x23,0x28,0x26,0x32,0x2F,	/* 23E8: p#(&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 23F0: O${.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,0x75,	/* 23F8: u+P#xu */
	0x55,0x23,0xFB,0x77,0x75,0x21,0x3F,0xF2,	/* 2400: U#wu!? */
	0x75,0x21,0xEF,0x77,0x77,0x60,0x8F,0xD7,	/* 2408: u!ww` */
	0x2F,0x4F,0x24,0xF6,0x21,0xA2,0x70,0x23,	/* 2410: .O$!p# */
	0x28,0x26,0x32,0x77,0x77,0x60,0x8F,0xD7,	/* 2418: (&2ww` */
	0x2F,0x4F,0x24,0xF6,0xA3,0x20,0x61,0x0E,	/* 2420: .O$ a. */
	0x79,0x78,0x81,0xFC,0x2F,0x4F,0x24,0xF6,	/* 2428: yx.O$ */
	0xD7,0x75,0x34,0x48,0x24,0xF6,0x21,0xA2,	/* 2430: u4H$! */
	0x7A,0x21,0x4F,0xF9,0xAD,0x22,0x40,0x77,	/* 2438: z!O"@w */
	0xF9,0xA8,0x75,0x34,0x21,0x40,0x24,0xFB,	/* 2440: u4!@$ */
	0x75,0xE4,0x41,0x76,0x22,0xE5,0x72,0x23,	/* 2448: uAv"r# */
	0x4F,0x24,0xF6,0x70,0x23,0x28,0x26,0xEB,	/* 2450: O$p#(& */
	0x21,0x02,0x77,0x75,0x21,0x3F,0xF2,0x75,	/* 2458: !.wu!?u */
	0x21,0xEF,0x72,0x23,0x4F,0x24,0xF6,0x70,	/* 2460: !r#O$p */
	0x23,0x28,0x26,0xEB,0x73,0x42,0x24,0xF6,	/* 2468: #(&sB$ */
	0x24,0x23,0xA6,0x70,0x23,0x28,0x26,0x3A,	/* 2470: $#p#(&: */
	0x2F,0x4F,0x24,0xF6,0x25,0xFA,0xD2,0x43,	/* 2478: .O$%C */
	0x24,0xF6,0x70,0x23,0x28,0x26,0xE8,0x71,	/* 2480: $p#(&q */
	0x72,0x43,0x24,0xF6,0x28,0xF1,0x74,0x55,	/* 2488: rC$(tU */
	0xFA,0x30,0x25,0xFA,0xD5,0x22,0x87,0xF1,	/* 2490: 0%" */
	0xC0,0xAC,0x75,0x21,0x54,0xF1,0x42,0x24,	/* 2498: u!TB$ */
	0xFB,0x75,0x21,0x54,0x23,0xFB,0x75,0x23,	/* 24A0: u!T#u# */
	0x85,0xF1,0xA9,0x75,0x7D,0x21,0x2D,0x20,	/* 24A8: u}!-  */
	0x9D,0x23,0x2E,0x0B,0x75,0x8D,0xF1,0xD9,	/* 24B0: #..u */
	0x75,0x56,0xF1,0xD8,0x75,0x34,0x21,0x20,	/* 24B8: uVu4!  */
	0x40,0x24,0xF6,0x22,0xA8,0x75,0x34,0x61,	/* 24C0: @$"u4a */
	0x2F,0x4F,0x24,0xF6,0x75,0xE4,0x75,0x34,	/* 24C8: .O$uu4 */
	0x22,0x20,0x40,0x24,0xFB,0x75,0xE4,0x75,	/* 24D0: " @$uu */
	0x34,0x60,0x4E,0x24,0xF6,0x75,0xE4,0x70,	/* 24D8: 4`N$up */
	0x23,0x28,0x20,0x36,0x2F,0x49,0x24,0xF6,	/* 24E0: #( 6.I$ */
	0x70,0x23,0x28,0x20,0xE6,0x79,0x78,0xFC,	/* 24E8: p#( yx */
	0x2F,0x4F,0x24,0xF6,0x25,0xFA,0xD7,0x75,	/* 24F0: .O$%u */
	0x21,0x55,0xF1,0xF9,0xA6,0x75,0x21,0x55,	/* 24F8: !Uu!U */
	0xF1,0xDA,0x02,0x77,0xDA,0x7A,0x2F,0x4F,	/* 2500: .wz.O */
	0x24,0xF6,0x41,0xF4,0xDA,0x41,0x22,0x40,	/* 2508: $AA"@ */
	0x7A,0x24,0xFF,0xF0,0xC0,0x23,0x20,0xA3,	/* 2510: z$#  */
	0x7A,0x42,0x21,0xFB,0x28,0xF1,0xF6,0x22,	/* 2518: zB!(" */
	0x2E,0x05,0x20,0x22,0x2C,0x0D,0x20,0x22,	/* 2520: .. ",. " */
	0x2B,0x05,0x20,0x22,0x29,0x0D,0x20,0x22,	/* 2528: +. "). " */
	0x28,0x05,0x20,0x22,0x26,0x0D,0x20,0x22,	/* 2530: (. "&. " */
	0x25,0x05,0x20,0x22,0x23,0x0D,0x20,0x22,	/* 2538: %. "#. " */
	0x22,0x05,0x20,0x22,0x20,0x0D,0x20,0x21,	/* 2540: ". " . ! */
	0x2F,0x05,0x20,0x21,0x2D,0x0D,0x20,0x21,	/* 2548: .. !-. ! */
	0x2C,0x05,0x20,0x21,0x2A,0x0D,0x20,0x21,	/* 2550: ,. !*. ! */
	0x29,0x05,0x20,0x21,0x27,0x0D,0x20,0x21,	/* 2558: ). !'. ! */
	0x26,0x05,0x20,0x21,0x24,0x0D,0x20,0x21,	/* 2560: &. !$. ! */
	0x23,0x05,0x20,0x21,0x21,0x0D,0x20,0x21,	/* 2568: #. !!. ! */
	0x20,0x05,0x20,0x2E,0x0E,0x20,0x20,0x2D,	/* 2570:  . ..  - */
	0x06,0x20,0x20,0x2B,0x0E,0x20,0x20,0x2A,	/* 2578: .  +.  * */
	0x06,0x20,0x20,0x28,0x0E,0x20,0x20,0x27,	/* 2580: .  (.  ' */
	0x06,0x20,0x20,0x25,0x0E,0x20,0x20,0x24,	/* 2588: .  %.  $ */
	0x06,0x20,0x20,0x22,0x0E,0x20,0x20,0x21,	/* 2590: .  ".  ! */
	0x06,0x20,0x20,0x78,0xDA,0x78,0x81,0xD8,	/* 2598: .  xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 25A0: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 25A8: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 25B0: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 25B8: .O$p# */
	0x28,0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,	/* 25C0: (&xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 25C8: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 25D0: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 25D8: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 25E0: .O$p# */
	0x28,0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,	/* 25E8: (&xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 25F0: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 25F8: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 2600: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 2608: .O$p# */
	0x28,0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,	/* 2610: (&xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 2618: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 2620: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 2628: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 2630: .O$p# */
	0x28,0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,	/* 2638: (&xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 2640: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 2648: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 2650: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 2658: .O$p# */
	0x28,0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,	/* 2660: (&xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 2668: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 2670: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 2678: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 2680: .O$p# */
	0x28,0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,	/* 2688: (&xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 2690: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 2698: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 26A0: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 26A8: .O$p# */
	0x28,0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,	/* 26B0: (&xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 26B8: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 26C0: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 26C8: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 26D0: .O$p# */
	0x28,0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,	/* 26D8: (&xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 26E0: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 26E8: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 26F0: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 26F8: .O$p# */
	0x28,0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,	/* 2700: (&xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 2708: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 2710: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 2718: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 2720: .O$p# */
	0x28,0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,	/* 2728: (&xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 2730: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 2738: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 2740: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 2748: .O$p# */
	0x28,0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,	/* 2750: (&xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 2758: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 2760: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 2768: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 2770: .O$p# */
	0x28,0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,	/* 2778: (&xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 2780: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 2788: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 2790: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 2798: .O$p# */
	0x28,0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,	/* 27A0: (&xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 27A8: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 27B0: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 27B8: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 27C0: .O$p# */
	0x28,0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,	/* 27C8: (&xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 27D0: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 27D8: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 27E0: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 27E8: .O$p# */
	0x28,0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,	/* 27F0: (&xx */
	0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,	/* 27F8: u#Pz.O$ */
	0xF2,0xF1,0x70,0x23,0x28,0x26,0xE3,0x78,	/* 2800: p#(&x */
	0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,	/* 2808: xu#Pz */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x23,	/* 2810: .O$p# */
	0x28,0x26,0xE3,0x79,0x78,0xFC,0x2F,0x4F,	/* 2818: (&yx.O */
	0x24,0xF6,0xD9,0x78,0x75,0x56,0x23,0xFB,	/* 2820: $xuV# */
	0x77,0x2C,0x40,0xF9,0x21,0xA0,0x2C,0x41,	/* 2828: w,@!,A */
	0x79,0xF9,0xAB,0x75,0x34,0x28,0x20,0x40,	/* 2830: yu4( @ */
	0x24,0xFB,0x75,0xE4,0x22,0x01,0x77,0x24,	/* 2838: $u".w$ */
	0x40,0xF9,0x21,0xAB,0x24,0x41,0x79,0xF9,	/* 2840: @!$Ay */
	0x21,0xA5,0x75,0x34,0x28,0x20,0x40,0x24,	/* 2848: !u4( @$ */
	0xF6,0xAD,0x75,0x34,0x68,0x2F,0x4F,0x24,	/* 2850: u4h.O$ */
	0xF6,0x75,0xE4,0x41,0x76,0x22,0xE4,0x79,	/* 2858: uAv"y */
	0xAE,0x75,0x24,0x81,0xF1,0x41,0x24,0xFB,	/* 2860: u$A$ */
	0x75,0x24,0x81,0x23,0xFB,0x23,0x00,0x75,	/* 2868: u$##.u */
	0x34,0x60,0x4E,0x24,0xF6,0x75,0xE4,0x70,	/* 2870: 4`N$up */
	0x23,0x28,0x20,0x36,0x2F,0x49,0x24,0xF6,	/* 2878: #( 6.I$ */
	0x70,0x23,0x28,0x20,0xE6,0x75,0x24,0x81,	/* 2880: p#( u$ */
	0xF1,0x41,0x24,0xF6,0x21,0xA1,0x41,0x76,	/* 2888: A$!Av */
	0x22,0xE4,0x75,0x24,0x81,0xF1,0x60,0x4E,	/* 2890: "u$`N */
	0x24,0xF6,0x75,0x24,0x81,0x23,0xFB,0x72,	/* 2898: $u$#r */
	0x23,0x4F,0x24,0xF6,0x70,0x23,0x28,0x26,	/* 28A0: #O$p#(& */
	0xEA,0x73,0x44,0x24,0xF6,0x25,0xA9,0x70,	/* 28A8: sD$%p */
	0x23,0x28,0x26,0x39,0x2F,0x4F,0x24,0xF6,	/* 28B0: #(&9.O$ */
	0x25,0xFA,0xD2,0x43,0x24,0xF6,0x70,0x23,	/* 28B8: %C$p# */
	0x28,0x26,0xE8,0x71,0x72,0x43,0x24,0xF6,	/* 28C0: (&qrC$ */
	0x28,0xF1,0x74,0x55,0xFA,0x30,0x25,0xFA,	/* 28C8: (tU0% */
	0xD5,0x7D,0x21,0x29,0x2F,0x9C,0x75,0x7D,	/* 28D0: }!).u} */
	0x62,0x2F,0x2E,0x9F,0x75,0x22,0x87,0xF1,	/* 28D8: b..u" */
	0xC0,0xAC,0x75,0x21,0x54,0xF1,0x44,0x24,	/* 28E0: u!TD$ */
	0xFB,0x75,0x21,0x54,0x23,0xFB,0x41,0x76,	/* 28E8: u!T#Av */
	0x22,0xE4,0x75,0x21,0x89,0xF1,0x42,0x24,	/* 28F0: "u!B$ */
	0xFB,0x75,0x21,0x89,0x23,0xFB,0x72,0x23,	/* 28F8: u!#r# */
	0x4F,0x24,0xF6,0x70,0x23,0x28,0x26,0xE9,	/* 2900: O$p#(& */
	0x71,0x81,0x2F,0x4F,0x24,0xF6,0x25,0xFA,	/* 2908: q.O$% */
	0xD1,0x41,0xF9,0x21,0xA2,0x40,0xD1,0x74,	/* 2910: A!@t */
	0x30,0xAA,0x74,0x30,0x27,0x2F,0x2F,0x4F,	/* 2918: 0t0'..O */
	0x24,0xF6,0xD4,0x03,0x28,0x40,0xD4,0x73,	/* 2920: $.(@s */
	0xC0,0x21,0xA0,0x74,0x76,0x30,0xF4,0xC0,	/* 2928: !tv0 */
	0x6A,0x2B,0xA0,0x71,0x76,0x31,0xF4,0xA3,	/* 2930: j+qv1 */
	0x6A,0x2A,0x08,0x74,0x76,0xE0,0x71,0x76,	/* 2938: j*.tvqv */
	0xE1,0xBC,0x22,0xF0,0x76,0xF6,0x80,0x3C,	/* 2940: "v< */
	0x08,0x71,0x26,0x50,0xD2,0x60,0x45,0x21,	/* 2948: .q&P`E! */
	0xFB,0x72,0x41,0x24,0xFA,0x22,0xF0,0x60,	/* 2950: rA$"` */
	0xBF,0x73,0x31,0x25,0xFA,0xD0,0x21,0x40,	/* 2958: s1%!@ */
	0x24,0xF6,0x21,0xA5,0x70,0x61,0x4F,0x24,	/* 2960: $!paO$ */
	0xF6,0x23,0x28,0x20,0x3D,0x2F,0x4F,0x24,	/* 2968: #( =.O$ */
	0xF6,0x23,0xF2,0x41,0x24,0xF0,0xB1,0x22,	/* 2970: #A$" */
	0xF0,0x70,0x61,0x4F,0x24,0xF6,0x23,0x28,	/* 2978: paO$#( */
	0x20,0x3D,0x2F,0x4F,0x24,0xF6,0x23,0xF2,	/* 2980:  =.O$# */
	0x41,0x24,0xF1,0xB1,0x22,0xF0,0x60,0xBE,	/* 2988: A$"` */
	0x74,0x31,0xD1,0x74,0x32,0x27,0x2F,0x2F,	/* 2990: t1t2'.. */
	0x4F,0x24,0xF6,0xD0,0x75,0x41,0xF4,0xAF,	/* 2998: O$uA */
	0x74,0x8F,0xF1,0x23,0xF2,0x70,0x52,0xF1,	/* 29A0: t#pR */
	0x24,0xF6,0x70,0x52,0x23,0xFB,0x0C,0x70,	/* 29A8: $pR#.p */
	0x52,0xF1,0x74,0x8F,0xF1,0x24,0xFB,0x70,	/* 29B0: Rt$p */
	0x52,0x23,0xFB,0x70,0x52,0xF1,0x23,0xF2,	/* 29B8: R#pR# */
	0x71,0x6F,0x40,0x24,0xF6,0x28,0x40,0x24,	/* 29C0: qo@$(@$ */
	0xFB,0x23,0x28,0x20,0xE0,0xB2,0x22,0xF0,	/* 29C8: #( " */
	0x60,0xB8,0x7A,0x31,0xD2,0x7A,0x55,0xF1,	/* 29D0: `z1zU */
	0xD4,0x7A,0x8B,0xF1,0xD6,0x74,0x76,0xFC,	/* 29D8: ztv */
	0x2F,0x4F,0x24,0xF6,0xD7,0x7C,0x30,0xD3,	/* 29E0: .O$|0 */
	0x7A,0x22,0x81,0xF1,0xD5,0x40,0xD1,0x24,	/* 29E8: z"@$ */
	0x40,0x72,0x23,0x28,0x20,0xE2,0x72,0x23,	/* 29F0: @r#( r# */
	0x28,0x20,0x33,0x2F,0x4F,0x24,0xF6,0x7A,	/* 29F8: ( 3.O$z */
	0x22,0x83,0xF1,0x24,0xF6,0x25,0xFA,0xD0,	/* 2A00: "$% */
	0xC0,0x23,0xAD,0x7B,0x28,0x40,0x24,0xF6,	/* 2A08: #{(@$ */
	0x23,0xA6,0x75,0x41,0x24,0xF6,0xA4,0x41,	/* 2A10: #uA$A */
	0xD1,0x22,0x0D,0x75,0x42,0x24,0xF6,0x21,	/* 2A18: ".uB$! */
	0xA4,0x7A,0x21,0x89,0xF1,0x41,0x24,0xFB,	/* 2A20: z!A$ */
	0x7A,0x21,0x89,0x23,0xFB,0x41,0x79,0x28,	/* 2A28: z!#Ay( */
	0xE4,0x41,0xD1,0x21,0x03,0x74,0xD1,0x74,	/* 2A30: A!.tt */
	0x81,0xD4,0x40,0x71,0x2F,0x4F,0x24,0xF6,	/* 2A38: @q.O$ */
	0x7A,0x2B,0x50,0xF2,0x23,0xFB,0x41,0xD1,	/* 2A40: z+P#A */
	0x73,0x42,0x24,0xF6,0x25,0xA1,0x73,0x44,	/* 2A48: sB$%sD */
	0x24,0xF6,0xAE,0x73,0x41,0x24,0xF6,0xC0,	/* 2A50: $sA$ */
	0x21,0xAB,0x7A,0x58,0xF1,0x70,0xF4,0x21,	/* 2A58: !zXp! */
	0xA4,0x7A,0x58,0xF1,0x70,0xF4,0xC0,0x22,	/* 2A60: zXp" */
	0xA3,0x7A,0x21,0x81,0xF1,0x70,0xF4,0x21,	/* 2A68: z!p! */
	0xAB,0x41,0xD1,0x21,0x07,0x73,0x60,0x4B,	/* 2A70: A!.s`K */
	0x24,0xF6,0xD3,0x7A,0x58,0xF1,0x70,0xF4,	/* 2A78: $zXp */
	0xA9,0x7A,0x21,0x81,0xF1,0x70,0xF4,0xC0,	/* 2A80: z!p */
	0xA3,0x20,0x41,0xD1,0x7A,0x21,0x81,0xF1,	/* 2A88:  Az! */
	0x70,0xF4,0xC0,0xAB,0x71,0xC0,0xA8,0x20,	/* 2A90: pq  */
	0x73,0x44,0x24,0xFB,0xD3,0x41,0xD1,0x7B,	/* 2A98: sD$A{ */
	0x27,0x40,0x24,0xF6,0x26,0xA4,0x71,0xC0,	/* 2AA0: '@$&q */
	0x26,0xA0,0x73,0x67,0x20,0x20,0x40,0x24,	/* 2AA8: &sg  @$ */
	0xF6,0x25,0xA7,0x75,0x48,0x24,0xF6,0xA5,	/* 2AB0: %uH$ */
	0x20,0x41,0xD1,0x27,0x0D,0x75,0x44,0x24,	/* 2AB8:  A'.uD$ */
	0xF6,0x23,0xA2,0x2F,0x4F,0x74,0x2F,0x4F,	/* 2AC0: #.Ot.O */
	0x24,0xF6,0x7A,0x2B,0x50,0xF2,0x23,0xFB,	/* 2AC8: $z+P# */
	0x40,0x74,0x81,0x2F,0x4F,0x24,0xF6,0x7A,	/* 2AD0: @t.O$z */
	0x2B,0x50,0xF2,0x23,0xFB,0x74,0x81,0x81,	/* 2AD8: +P#t */
	0x25,0xFA,0xD1,0x81,0xD4,0x70,0x71,0x2F,	/* 2AE0: %сpq. */
	0x4F,0x24,0xF6,0x7A,0x2B,0x50,0xF2,0x23,	/* 2AE8: O$z+P# */
	0xFB,0x41,0xD1,0x24,0x05,0x74,0xD1,0x74,	/* 2AF0: A$.tt */
	0x81,0xD4,0x40,0x71,0x2F,0x4F,0x24,0xF6,	/* 2AF8: @q.O$ */
	0x7A,0x2B,0x50,0xF2,0x23,0xFB,0x41,0xD1,	/* 2B00: z+P#A */
	0x23,0x00,0x70,0x2F,0x4F,0xF4,0xC0,0x22,	/* 2B08: #.p.O" */
	0xA9,0x75,0x44,0x24,0xF6,0x22,0xA3,0x2F,	/* 2B10: uD$". */
	0x4F,0x74,0x2F,0x4F,0x24,0xF6,0x7A,0x2B,	/* 2B18: Ot.O$z+ */
	0x50,0xF2,0x23,0xFB,0x74,0x81,0x25,0xFA,	/* 2B20: P#t% */
	0xD1,0x81,0xD4,0x2F,0x4F,0x71,0x2F,0x4F,	/* 2B28: с.Oq.O */
	0x24,0xF6,0x7A,0x2B,0x50,0xF2,0x23,0xFB,	/* 2B30: $z+P# */
	0x41,0xD1,0x71,0xC0,0x22,0xA6,0x41,0x74,	/* 2B38: Aq"At */
	0x76,0xFC,0x2F,0x4F,0x24,0xF6,0x2F,0x4E,	/* 2B40: v.O$.N */
	0xF0,0x24,0xFF,0xF0,0xC0,0x21,0xA5,0x74,	/* 2B48: $!t */
	0xD1,0x74,0x81,0xD4,0x70,0x71,0x2F,0x4F,	/* 2B50: tpq.O */
	0x24,0xF6,0x7A,0x2B,0x50,0xF2,0x23,0xFB,	/* 2B58: $z+P# */
	0x41,0x79,0x28,0xE5,0x72,0x23,0x28,0x20,	/* 2B60: Ay(r#(  */
	0x31,0x2F,0x4F,0x24,0xF6,0x25,0xFA,0xDB,	/* 2B68: 1.O$% */
	0x41,0x24,0xF6,0xA3,0x61,0x27,0x06,0x2C,	/* 2B70: A$a'., */
	0x40,0x77,0xF9,0x24,0xA8,0x41,0x74,0x76,	/* 2B78: @w$Atv */
	0xFC,0x2F,0x4F,0x24,0xF6,0x2B,0x4F,0x24,	/* 2B80: .O$+O$ */
	0xFF,0xF0,0xC0,0x23,0xA8,0x73,0x48,0x24,	/* 2B88: #sH$ */
	0xF6,0x23,0xA2,0x7A,0x21,0x58,0xF1,0x48,	/* 2B90: #z!XH */
	0x24,0xF6,0x21,0xA3,0x73,0x22,0x40,0x24,	/* 2B98: $!s"@$ */
	0xF6,0xA7,0x73,0x64,0x4F,0x24,0xF6,0xD3,	/* 2BA0: sdO$ */
	0x06,0x73,0x2D,0x40,0x24,0xFB,0xD3,0x7A,	/* 2BA8: .s-@$z */
	0x23,0x81,0xF1,0x28,0x40,0x24,0xF6,0xAD,	/* 2BB0: #(@$ */
	0x29,0x40,0x72,0x23,0x28,0x20,0xE2,0x73,	/* 2BB8: )@r#( s */
	0x21,0x40,0x24,0xFB,0xD3,0x74,0x7A,0x55,	/* 2BC0: !@$tzU */
	0x23,0xFB,0x73,0x7C,0xE0,0xB8,0x22,0xF0,	/* 2BC8: #s|" */
	0x60,0xB7,0x7A,0x26,0x52,0xD5,0x21,0x28,	/* 2BD0: `z&R!( */
	0x40,0xD1,0x71,0x21,0x37,0x25,0xFA,0xD1,	/* 2BD8: @q!7% */
	0x57,0xF1,0x25,0xFA,0xD0,0xAC,0x70,0x75,	/* 2BE0: W%Ьpu */
	0xFA,0x30,0xD0,0x71,0x7A,0x25,0x27,0x90,	/* 2BE8: 0qz%' */
	0x61,0xA8,0x71,0x31,0x25,0xFA,0xD3,0x21,	/* 2BF0: aq1%! */
	0x20,0x20,0x40,0x24,0xF6,0x2A,0xA3,0x73,	/* 2BF8:   @$*s */
	0x23,0x28,0x20,0x31,0x2F,0x4F,0x24,0xF6,	/* 2C00: #( 1.O$ */
	0x25,0xFA,0xD2,0x44,0x24,0xF6,0x27,0xAA,	/* 2C08: %D$' */
	0x71,0x56,0xF1,0xD0,0x71,0x8D,0xF1,0x70,	/* 2C10: qVqp */
	0xFC,0x2F,0x4F,0x24,0xF6,0x25,0xFA,0xD7,	/* 2C18: .O$% */
	0x24,0xAE,0x71,0x23,0x50,0x70,0x2F,0x4F,	/* 2C20: $q#Pp.O */
	0x24,0xF6,0xF2,0xF1,0x73,0x23,0x28,0x20,	/* 2C28: $s#(  */
	0xE3,0x70,0x81,0x71,0x56,0x23,0xFB,0x71,	/* 2C30: pqV#q */
	0x34,0x28,0x20,0x40,0x24,0xF6,0x21,0xA4,	/* 2C38: 4( @$! */
	0x24,0x41,0x77,0xF9,0x21,0xAC,0x71,0x34,	/* 2C40: $Aw!q4 */
	0x68,0x2F,0x4F,0x24,0xF6,0x71,0xE4,0x41,	/* 2C48: h.O$qA */
	0x75,0x22,0xE2,0x0E,0x77,0x2B,0x4F,0xF9,	/* 2C50: u".w+O */
	0xA9,0x71,0x34,0x28,0x20,0x40,0x24,0xFB,	/* 2C58: q4( @$ */
	0x71,0xE4,0x71,0x24,0x81,0xF1,0x41,0x24,	/* 2C60: qq$A$ */
	0xFB,0x71,0x24,0x81,0x23,0xFB,0x21,0x0A,	/* 2C68: q$#!. */
	0x71,0x24,0x81,0xF1,0x41,0x24,0xF6,0x21,	/* 2C70: q$A$! */
	0xA1,0x41,0x75,0x22,0xE2,0x71,0x24,0x81,	/* 2C78: Au"q$ */
	0xF1,0x60,0x4E,0x24,0xF6,0x71,0x24,0x81,	/* 2C80: `N$q$ */
	0x23,0xFB,0x72,0x41,0x24,0xF6,0x21,0x26,	/* 2C88: #rA$!& */
	0xAD,0x71,0x34,0xD6,0x16,0xD0,0x72,0x71,	/* 2C90: q4.rq */
	0x7A,0x62,0x23,0x94,0x76,0x71,0xE4,0x21,	/* 2C98: zb#vq! */
	0x25,0x0C,0x71,0x34,0xD4,0x73,0x23,0x28,	/* 2CA0: %.q4s#( */
	0x20,0x31,0x2F,0x4F,0x24,0xF6,0x25,0xFA,	/* 2CA8:  1.O$% */
	0xD2,0x44,0x24,0xF6,0x2E,0xAE,0x74,0x24,	/* 2CB0: D$.t$ */
	0x40,0x24,0xF6,0x22,0xAF,0x74,0x28,0x40,	/* 2CB8: @$"t(@ */
	0x24,0xF6,0x21,0xA8,0x71,0x21,0x83,0xF1,	/* 2CC0: $!q! */
	0x73,0x23,0x28,0x20,0xE3,0x74,0x22,0x40,	/* 2CC8: s#( t"@ */
	0x24,0xFB,0x25,0xFA,0xD4,0x6C,0x4F,0x24,	/* 2CD0: $%lO$ */
	0xF6,0xD4,0x2C,0x08,0x71,0x59,0xF1,0x73,	/* 2CD8: ,.qYs */
	0x23,0x28,0x20,0xE3,0x74,0x67,0x4F,0x24,	/* 2CE0: #( tgO$ */
	0xF6,0xD4,0x2B,0x08,0x74,0x44,0x24,0xF6,	/* 2CE8: +.tD$ */
	0xC0,0x2B,0xA1,0x71,0x56,0xF1,0xD0,0x71,	/* 2CF0: +qVq */
	0x8D,0xF1,0x70,0xFC,0x2F,0x4F,0x24,0xF6,	/* 2CF8: p.O$ */
	0x25,0xFA,0xD7,0x28,0xA5,0x70,0x71,0x23,	/* 2D00: %(pq# */
	0x50,0xF2,0xF1,0x25,0xFA,0xD8,0x4A,0xF4,	/* 2D08: P%J */
	0xC0,0x23,0xA0,0x74,0x24,0x20,0x40,0x24,	/* 2D10: #t$ @$ */
	0xF6,0x22,0xA8,0x74,0x21,0x20,0x40,0x24,	/* 2D18: "t! @$ */
	0xF6,0x21,0xA2,0x78,0x73,0x23,0x28,0x20,	/* 2D20: !xs#(  */
	0xE3,0x74,0x61,0x2F,0x4F,0x24,0xF6,0xD4,	/* 2D28: ta.O$ */
	0x70,0x81,0xD0,0x21,0x07,0x4D,0x73,0x23,	/* 2D30: p!.Ms# */
	0x28,0x20,0xE3,0x74,0x21,0x20,0x40,0x24,	/* 2D38: ( t! @$ */
	0xFB,0xD4,0x09,0x78,0x73,0x23,0x28,0x20,	/* 2D40: .xs#(  */
	0xE3,0x70,0x81,0xD0,0x70,0x71,0x56,0x23,	/* 2D48: ppqV# */
	0xFB,0x71,0x34,0x28,0x20,0x40,0x24,0xF6,	/* 2D50: q4( @$ */
	0x21,0xA4,0x24,0x41,0x77,0xF9,0x21,0xAC,	/* 2D58: !$Aw! */
	0x71,0x34,0x68,0x2F,0x4F,0x24,0xF6,0x71,	/* 2D60: q4h.O$q */
	0xE4,0x41,0x75,0x22,0xE2,0x0E,0x77,0x2B,	/* 2D68: Au".w+ */
	0x4F,0xF9,0xA9,0x71,0x34,0x28,0x20,0x40,	/* 2D70: Oq4( @ */
	0x24,0xFB,0x71,0xE4,0x71,0x24,0x81,0xF1,	/* 2D78: $qq$ */
	0x41,0x24,0xFB,0x71,0x24,0x81,0x23,0xFB,	/* 2D80: A$q$# */
	0x21,0x0A,0x71,0x24,0x81,0xF1,0x41,0x24,	/* 2D88: !.q$A$ */
	0xF6,0x21,0xA1,0x41,0x75,0x22,0xE2,0x71,	/* 2D90: !Au"q */
	0x24,0x81,0xF1,0x60,0x4E,0x24,0xF6,0x71,	/* 2D98: $`N$q */
	0x24,0x81,0x23,0xFB,0x72,0x41,0x24,0xF6,	/* 2DA0: $#rA$ */
	0xA8,0x14,0xD0,0x72,0x71,0x7A,0x63,0x21,	/* 2DA8: .rqzc! */
	0x9F,0x74,0x21,0x40,0x24,0xF6,0x24,0xA3,	/* 2DB0: t!@$$ */
	0x41,0x71,0x55,0xF1,0x71,0x8B,0xF1,0xFC,	/* 2DB8: AqUq */
	0x2F,0x4F,0x24,0xF6,0x24,0x40,0xF0,0x24,	/* 2DC0: .O$$@$ */
	0xFF,0xF0,0xC0,0x22,0xAE,0x74,0x28,0x40,	/* 2DC8: "t(@ */
	0x24,0xF6,0xA6,0x74,0x6C,0x4F,0x24,0xF6,	/* 2DD0: $tlO$ */
	0xD4,0x74,0x22,0x40,0x24,0xF6,0xA6,0x74,	/* 2DD8: t"@$t */
	0x24,0x40,0x24,0xFB,0xD4,0x71,0x23,0x81,	/* 2DE0: $@$q# */
	0xF1,0x28,0x40,0x24,0xF6,0xA7,0x28,0x40,	/* 2DE8: (@$(@ */
	0x73,0x23,0x28,0x20,0xE2,0x74,0x61,0x4F,	/* 2DF0: s#( taO */
	0x24,0xF6,0xD4,0x74,0x71,0xE4,0x62,0x2D,	/* 2DF8: $tqb- */
	0x09,0x60,0xBD,0x75,0x31,0xD1,0x75,0x34,	/* 2E00: .`u1u4 */
	0x25,0xFA,0xD2,0xD0,0x75,0x21,0x8F,0xF1,	/* 2E08: %u! */
	0xA7,0x40,0x75,0x21,0x8F,0x23,0xFB,0x0A,	/* 2E10: @u!#. */
	0x71,0x23,0x28,0x20,0x31,0x48,0x24,0xF6,	/* 2E18: q#( 1H$ */
	0x28,0xA6,0x75,0x57,0xF1,0x48,0xF4,0xC0,	/* 2E20: (uWH */
	0x22,0xA0,0x75,0x5A,0xF1,0x75,0x23,0x81,	/* 2E28: "uZu# */
	0xF1,0xF4,0xC0,0x21,0xA5,0x75,0x21,0x85,	/* 2E30: !u! */
	0xF1,0x75,0x21,0x59,0xF1,0xF4,0xC0,0xAA,	/* 2E38: u!Y */
	0x75,0x5B,0xF1,0x75,0x22,0x8D,0xF1,0xF4,	/* 2E40: u[u" */
	0x23,0xAF,0x21,0x4A,0x71,0x23,0x28,0x20,	/* 2E48: #!Jq#(  */
	0xE2,0x75,0x5A,0xF1,0x71,0x23,0x28,0x20,	/* 2E50: uZq#(  */
	0xE0,0x75,0x21,0x85,0xF1,0x71,0x23,0x28,	/* 2E58: u!q#( */
	0x20,0xE0,0x75,0x5B,0xF1,0x71,0x23,0x28,	/* 2E60:  u[q#( */
	0x20,0xE1,0x75,0x5A,0xF1,0x75,0x23,0x81,	/* 2E68:  uZu# */
	0x23,0xFB,0x75,0x21,0x85,0xF1,0x75,0x21,	/* 2E70: #u!u! */
	0x59,0x23,0xFB,0x75,0x5B,0xF1,0x75,0x22,	/* 2E78: Y#u[u" */
	0x8D,0x23,0xFB,0x45,0x71,0x23,0x28,0x20,	/* 2E80: #Eq#(  */
	0xE2,0x75,0x21,0x87,0xF1,0x41,0x24,0xF6,	/* 2E88: u!A$ */
	0xAF,0x70,0x21,0x40,0x24,0xF6,0x21,0xA4,	/* 2E90: p!@$! */
	0x75,0x5A,0xF1,0x28,0x40,0x24,0xF6,0xAC,	/* 2E98: uZ(@$ */
	0x29,0x40,0x71,0x23,0x28,0x20,0xE2,0x0B,	/* 2EA0: )@q#( . */
	0x40,0xB3,0x22,0xF0,0x28,0x40,0x71,0x23,	/* 2EA8: @"(@q# */
	0x28,0x20,0xE2,0x75,0x21,0x87,0xF1,0x42,	/* 2EB0: ( u!B */
	0x24,0xF6,0xA7,0x41,0x75,0x74,0x65,0x2C,	/* 2EB8: $Aute, */
	0x9D,0x06,0x40,0x75,0x74,0x65,0x2C,0x96,	/* 2EC0: .@ute, */
	0x40,0x75,0x21,0x89,0x23,0xFB,0x75,0x21,	/* 2EC8: @u!#u! */
	0x8B,0xF1,0x75,0x58,0x23,0xFB,0x75,0x21,	/* 2ED0: uX#u! */
	0x8D,0xF1,0x75,0x59,0x23,0xFB,0x75,0x5E,	/* 2ED8: uY#u^ */
	0xF1,0x75,0x21,0x81,0x23,0xFB,0x75,0x5F,	/* 2EE0: u!#u_ */
	0xF1,0x75,0x21,0x83,0x23,0xFB,0x75,0x21,	/* 2EE8: u!#u! */
	0x50,0xF1,0x75,0x22,0x81,0x23,0xFB,0x75,	/* 2EF0: Pu"#u */
	0x21,0x51,0xF1,0x75,0x22,0x83,0x23,0xFB,	/* 2EF8: !Qu"# */
	0x75,0x5D,0xF1,0x75,0x21,0x58,0x23,0xFB,	/* 2F00: u]u!X# */
	0x70,0x60,0x44,0x24,0xF6,0xD0,0x75,0x5D,	/* 2F08: p`D$u] */
	0xF1,0x42,0x24,0xF6,0xA5,0x70,0x42,0x24,	/* 2F10: B$pB$ */
	0xFB,0xD0,0x75,0x5D,0xF1,0x48,0x24,0xF6,	/* 2F18: u]H$ */
	0xA5,0x70,0x48,0x24,0xFB,0xD0,0x75,0x5D,	/* 2F20: pH$u] */
	0xF1,0x41,0x24,0xF6,0xA5,0x70,0x41,0x24,	/* 2F28: A$pA$ */
	0xFB,0xD0,0x70,0x25,0x2B,0x2F,0x4F,0x24,	/* 2F30: p%+.O$ */
	0xF6,0xD0,0x75,0x5D,0xF1,0x44,0x24,0xF6,	/* 2F38: u]D$ */
	0xA7,0x70,0x24,0x20,0x40,0x24,0xFB,0xD0,	/* 2F40: p$ @$ */
	0x75,0x5D,0xF1,0x22,0x40,0x24,0xF6,0xA8,	/* 2F48: u]"@$ */
	0x70,0x22,0x20,0x20,0x40,0x24,0xFB,0xD0,	/* 2F50: p"  @$ */
	0x75,0x5D,0xF1,0x28,0x40,0x24,0xF6,0xA8,	/* 2F58: u](@$ */
	0x70,0x67,0x20,0x20,0x40,0x24,0xFB,0xD0,	/* 2F60: pg  @$ */
	0x75,0x5A,0xF1,0x28,0x40,0x24,0xF6,0xA5,	/* 2F68: uZ(@$ */
	0x70,0x48,0x24,0xFB,0xD0,0x75,0x5D,0xF1,	/* 2F70: pH$u] */
	0x24,0x40,0x24,0xF6,0xA5,0x70,0x48,0x24,	/* 2F78: $@$pH$ */
	0xFB,0xD0,0x72,0x24,0x20,0x40,0x24,0xF6,	/* 2F80: r$ @$ */
	0xAF,0x70,0x24,0x20,0x40,0x24,0xF6,0xC0,	/* 2F88: p$ @$ */
	0xA7,0x70,0x61,0x2F,0x4F,0x24,0xF6,0xD0,	/* 2F90: pa.O$ */
	0x72,0x42,0x24,0xF6,0xAC,0x70,0x42,0x24,	/* 2F98: rB$pB$ */
	0xF6,0xC0,0xA6,0x70,0x60,0x4B,0x24,0xF6,	/* 2FA0: p`K$ */
	0xD0,0x75,0x23,0x81,0xF1,0x28,0x40,0x24,	/* 2FA8: u#(@$ */
	0xF6,0xA5,0x70,0x48,0x24,0xFB,0xD0,0x70,	/* 2FB0: pH$p */
	0x22,0x20,0x20,0x40,0x24,0xF6,0xAA,0x75,	/* 2FB8: "  @$u */
	0x74,0x66,0x29,0x93,0x75,0x5C,0x23,0xFB,	/* 2FC0: tf)u\# */
	0x06,0x22,0x44,0x75,0x5C,0x23,0xFB,0x75,	/* 2FC8: ."Du\#u */
	0x57,0xF1,0x44,0xF4,0xA6,0x40,0x75,0x57,	/* 2FD0: WD@uW */
	0x23,0xFB,0x03,0x75,0x74,0x9B,0x70,0x75,	/* 2FD8: #.utpu */
	0xE4,0x41,0x74,0x28,0xE4,0x40,0xB3,0x22,	/* 2FE0: At(@" */
	0xF0,0x72,0x71,0x66,0x26,0x99,0x44,0x24,	/* 2FE8: rqf&D$ */
	0xF6,0xAA,0x40,0x72,0x57,0x23,0xFB,0x41,	/* 2FF0: @rW#A */
	0x71,0x28,0xE4,0x05,0x46,0x72,0x57,0x23,	/* 2FF8: q(.FrW# */
	0xFB,0x40,0x22,0xF0,0x60,0xBF,0x73,0x31,	/* 3000: @"`s1 */
	0xD0,0x73,0x8D,0xF1,0x73,0x56,0xF1,0xF4,	/* 3008: ssV */
	0xC0,0x21,0xA2,0x70,0x23,0x28,0x20,0x30,	/* 3010: !p#( 0 */
	0x2F,0x4F,0x24,0xF6,0xA8,0x73,0x72,0x22,	/* 3018: .O$sr" */
	0x9F,0x40,0xB1,0x22,0xF0,0x41,0xB1,0x22,	/* 3020: @"A" */
	0xF0,0x26,0x40,0x72,0x31,0x23,0x28,0x20,	/* 3028: &@r1#(  */
	0xE2,0x21,0x42,0x72,0x57,0x23,0xFB,0x40,	/* 3030: !BrW#@ */
	0x22,0xF0,0x27,0x45,0x72,0x31,0x23,0x28,	/* 3038: "'Er1#( */
	0x20,0xE2,0x40,0x72,0x57,0x23,0xFB,0x40,	/* 3040:  @rW#@ */
	0x22,0xF0,0x40,0x22,0xF0,0x40,0x22,0xF0,	/* 3048: "@"@" */
	0x60,0xBF,0x73,0x31,0xD0,0x40,0x73,0x56,	/* 3050: `s1@sV */
	0x23,0xFB,0x40,0x73,0x8D,0x23,0xFB,0x40,	/* 3058: #@s#@ */
	0x73,0x8B,0x23,0xFB,0x40,0x73,0x55,0x23,	/* 3060: s#@sU# */
	0xFB,0x73,0x21,0x59,0xF1,0x21,0x40,0x24,	/* 3068: s!Y!@$ */
	0xF6,0xAD,0x73,0x21,0x59,0xF1,0x61,0x4F,	/* 3070: s!YaO */
	0x24,0xF6,0x70,0x23,0x28,0x20,0xE0,0x70,	/* 3078: $p#( p */
	0x23,0x28,0x20,0x31,0x48,0x24,0xF6,0x24,	/* 3080: #( 1H$$ */
	0xA4,0x73,0x21,0x87,0xF1,0x41,0x24,0xF6,	/* 3088: s!A$ */
	0xC0,0xA7,0x29,0x40,0x70,0x23,0x28,0x20,	/* 3090: )@p#(  */
	0xE2,0x73,0x21,0x87,0xF1,0x42,0x24,0xF6,	/* 3098: s!B$ */
	0xC0,0xA6,0x40,0x73,0x72,0x67,0x2E,0x96,	/* 30A0: @srg. */
	0x40,0x73,0xE4,0x23,0x40,0x70,0x23,0x28,	/* 30A8: @s#@p#( */
	0x20,0xE2,0x22,0x40,0x70,0x23,0x28,0x20,	/* 30B0:  "@p#(  */
	0xE2,0x41,0x73,0x21,0x8F,0x23,0xFB,0x21,	/* 30B8: As!#! */
	0x40,0x73,0x57,0x23,0xFB,0x41,0x72,0x28,	/* 30C0: @sW#Ar( */
	0xE4,0x40,0xB1,0x22,0xF0,0x40,0xB1,0x22,	/* 30C8: @"@" */
	0xF0,0x72,0x34,0x46,0x24,0xF6,0x46,0xF4,	/* 30D0: r4F$F */
	0xC0,0xA8,0x72,0x34,0x60,0x4B,0x24,0xF6,	/* 30D8: r4`K$ */
	0x72,0xE4,0x40,0x72,0x57,0x23,0xFB,0x41,	/* 30E0: r@rW#A */
	0x71,0x28,0xE4,0x40,0x22,0xF0,0x60,0xBF,	/* 30E8: q(@"` */
	0x73,0x31,0xD0,0x73,0x8D,0xF1,0x73,0x56,	/* 30F0: s1ssV */
	0x23,0xFB,0x73,0x34,0x68,0x2F,0x4F,0x24,	/* 30F8: #s4h.O$ */
	0xF6,0x73,0xE4,0x73,0x21,0x59,0xF1,0x21,	/* 3100: ss!Y! */
	0x40,0x24,0xF6,0x21,0xA7,0x73,0x72,0x67,	/* 3108: @$!srg */
	0x24,0x95,0x42,0x24,0xF6,0xC0,0xAD,0x23,	/* 3110: $B$# */
	0x40,0x70,0x23,0x28,0x20,0xE2,0x44,0x70,	/* 3118: @p#( Dp */
	0x23,0x28,0x20,0xE2,0x73,0x72,0x65,0x99,	/* 3120: #( sre */
	0x40,0xB1,0x22,0xF0,0x72,0x8B,0xF1,0x72,	/* 3128: @"rr */
	0x55,0x23,0xFB,0x40,0x72,0x57,0x23,0xFB,	/* 3130: U#@rW# */
	0x41,0x71,0x28,0xE4,0x40,0x22,0xF0,0x72,	/* 3138: Aq(@"r */
	0x34,0x42,0x24,0xF6,0xA7,0x72,0x34,0x44,	/* 3140: 4B$r4D */
	0x24,0xFB,0x72,0xE4,0x40,0x72,0x57,0x23,	/* 3148: $r@rW# */
	0xFB,0x41,0x71,0x28,0xE4,0x40,0x22,0xF0,	/* 3150: Aq(@" */
	0x40,0x72,0x57,0x23,0xFB,0x40,0x22,0xF0,	/* 3158: @rW#@" */
	0x74,0xF6,0x20,0x1D,0x00,0x1B,0x00,0x19,	/* 3160: t ..... */
	0x00,0x17,0x00,0x15,0x00,0x13,0x00,0x11,	/* 3168: ........ */
	0x00,0x0F,0x00,0x0D,0x00,0x0B,0x00,0x09,	/* 3170: ........ */
	0x00,0x07,0x00,0x05,0x00,0x03,0x00,0x01,	/* 3178: ........ */
	0x00,0x00,0x00,0x6A,0x12,0x71,0x26,0x52,	/* 3180: ...j.q&R */
	0xD2,0x63,0x4B,0x21,0xFB,0x72,0x21,0xEE,	/* 3188: cK!r! */
	0x65,0x4B,0x21,0xFB,0x72,0x21,0xEC,0x66,	/* 3190: eK!r!f */
	0x41,0x21,0xFB,0x72,0x21,0xEA,0x6B,0x4C,	/* 3198: A!r!kL */
	0x21,0xFB,0x72,0x21,0xE8,0x6D,0x48,0x21,	/* 31A0: !r!mH! */
	0xFB,0x72,0x21,0xE6,0x61,0x29,0x4F,0x21,	/* 31A8: r!a)O! */
	0xFB,0x72,0x21,0xE4,0x61,0x29,0x44,0x21,	/* 31B0: r!a)D! */
	0xFB,0x72,0x21,0xE2,0x61,0x28,0x49,0x21,	/* 31B8: r!a(I! */
	0xFB,0x72,0x21,0xE0,0x61,0x27,0x41,0x21,	/* 31C0: r!a'A! */
	0xFB,0x72,0xEE,0x61,0x25,0x49,0x21,0xFB,	/* 31C8: ra%I! */
	0x72,0xEC,0x61,0x22,0x4D,0x21,0xFB,0x72,	/* 31D0: ra"M!r */
	0xEA,0x63,0x22,0x43,0x21,0xFB,0x72,0xE8,	/* 31D8: c"C!r */
	0x61,0x20,0x44,0x21,0xFB,0x72,0xE6,0x63,	/* 31E0: a D!rc */
	0x21,0x45,0x21,0xFB,0x72,0xE4,0x63,0x20,	/* 31E8: !E!rc  */
	0x4E,0x21,0xFB,0x72,0xE2,0x72,0x69,0x49,	/* 31F0: N!rriI */
	0x21,0xFB,0x21,0x40,0x21,0x28,0x28,0x99,	/* 31F8: !!@!(( */
	0x22,0xF0,0x20,0x61,0xBD,0x21,0x74,0x28,	/* 3200: " a!t( */
	0x51,0xD9,0x40,0xDA,0x40,0xD8,0x28,0x40,	/* 3208: Q@@(@ */
	0xD7,0x28,0x40,0xD2,0x40,0xD6,0x76,0x48,	/* 3210: (@@vH */
	0x24,0xF1,0xD4,0x40,0xD3,0x40,0xD1,0x71,	/* 3218: $@@q */
	0x44,0x24,0xF1,0x76,0x48,0x24,0xF1,0xFA,	/* 3220: D$vH$ */
	0x23,0x28,0x20,0x3D,0x2A,0x40,0x24,0xF6,	/* 3228: #( =*@$ */
	0x2A,0x40,0xF4,0xC0,0xAE,0x71,0x41,0xF2,	/* 3230: *@qA */
	0xD1,0x41,0x44,0x71,0x24,0xFF,0xF0,0xC0,	/* 3238: ADq$ */
	0xAB,0x62,0x0C,0x41,0xD8,0x41,0xD3,0x7A,	/* 3240: b.AAz */
	0x41,0xF4,0x28,0xAA,0x73,0xC0,0x21,0xA5,	/* 3248: A(s! */
	0x74,0x23,0x28,0x20,0x31,0x2F,0x4F,0x24,	/* 3250: t#( 1.O$ */
	0xF6,0x2F,0x4F,0xF4,0x28,0xA4,0x41,0xDA,	/* 3258: .O(A */
	0x78,0x41,0xF4,0x27,0xA7,0x76,0x21,0xA8,	/* 3260: xA'v! */
	0x72,0x51,0xF1,0x21,0x28,0x40,0xF8,0x77,	/* 3268: rQ!(@w */
	0x28,0x50,0xFA,0x25,0xFA,0xD7,0x67,0x20,	/* 3270: (P%g  */
	0x20,0x40,0x24,0xFB,0x72,0xE0,0x77,0xD2,	/* 3278:  @$rw */
	0x76,0x48,0x24,0xF1,0xD4,0x40,0x72,0xE0,	/* 3280: vH$@r */
	0x76,0x72,0x83,0x23,0xFB,0x74,0x72,0xE3,	/* 3288: vr#tr */
	0x78,0x2D,0xA0,0x48,0x72,0x51,0x23,0xFB,	/* 3290: x-HrQ# */
	0x40,0x74,0x23,0x28,0x27,0xEF,0x40,0x74,	/* 3298: @t#('@t */
	0x23,0x28,0x26,0xE8,0x40,0x74,0x23,0x28,	/* 32A0: #(&@t#( */
	0x21,0xE8,0x44,0x74,0x23,0x28,0x27,0xEF,	/* 32A8: !Dt#(' */
	0x40,0x74,0x23,0x28,0x26,0xE8,0x25,0x45,	/* 32B0: @t#(&%E */
	0x74,0x23,0x28,0x21,0xE8,0x40,0x74,0x23,	/* 32B8: t#(!@t# */
	0x28,0x27,0xEF,0x74,0x23,0x28,0x21,0x38,	/* 32C0: ('t#(!8 */
	0x2F,0x4F,0x24,0xF6,0x25,0x45,0xF4,0x22,	/* 32C8: .O$%E" */
	0xAF,0x22,0x48,0xD1,0x22,0x0D,0x2F,0x4F,	/* 32D0: "H"..O */
	0x21,0xB3,0x22,0xF0,0x2F,0x4F,0x21,0xB3,	/* 32D8: !".O! */
	0x22,0xF0,0x78,0xC0,0xA4,0x20,0x7A,0x21,	/* 32E0: "x z! */
	0xA1,0x67,0x21,0x2E,0x40,0x70,0xE0,0x21,	/* 32E8: g!.@p! */
	0x28,0x40,0x70,0x21,0xE7,0x41,0x21,0xB3,	/* 32F0: (@p!A! */
	0x22,0xF0,0x2F,0x4F,0x21,0xB3,0x22,0xF0,	/* 32F8: ".O!" */
	0x24,0x48,0xD1,0x71,0x72,0x54,0x23,0xFB,	/* 3300: $HqrT# */
	0x74,0x23,0x28,0x27,0x3F,0x2F,0x4F,0x24,	/* 3308: t#('?.O$ */
	0xF6,0x72,0x5F,0x23,0xFB,0x74,0x23,0x28,	/* 3310: r_#t#( */
	0x24,0x30,0x2F,0x4F,0x24,0xF6,0x72,0x21,	/* 3318: $0.O$r! */
	0x8F,0x23,0xFB,0x44,0x74,0x23,0x28,0x27,	/* 3320: #Dt#(' */
	0xEF,0x74,0x23,0x28,0x24,0x30,0x2F,0x4F,	/* 3328: t#($0.O */
	0x24,0xF6,0x72,0x21,0x50,0x23,0xFB,0x72,	/* 3330: $r!P#r */
	0x54,0xF1,0x24,0x48,0xF4,0xA8,0x79,0x31,	/* 3338: T$Hy1 */
	0x41,0xF2,0x79,0xE1,0x21,0x04,0x74,0x23,	/* 3340: Ay!.t# */
	0x28,0x23,0x39,0x43,0x24,0xF6,0x81,0x72,	/* 3348: (#9C$r */
	0x22,0x81,0x23,0xFB,0x79,0x32,0x41,0xF2,	/* 3350: "#y2A */
	0x79,0xE2,0x74,0x21,0x74,0x62,0x25,0x2D,	/* 3358: yt!tb%- */
	0x99,0x25,0x03,0x74,0x23,0x28,0x24,0x30,	/* 3360: %.t#($0 */
	0x2F,0x4F,0x24,0xF6,0xD1,0x79,0x30,0x41,	/* 3368: .O$y0A */
	0xF2,0x79,0xE0,0x71,0x41,0x24,0xF6,0x21,	/* 3370: yqA$! */
	0xA8,0x71,0x2A,0x4B,0xF4,0xA5,0x20,0x44,	/* 3378: q*K D */
	0xD1,0x03,0x20,0x4A,0xD1,0x71,0x72,0x54,	/* 3380: . JqrT */
	0x23,0xFB,0x44,0x72,0x51,0x23,0xFB,0x21,	/* 3388: #DrQ#! */
	0x06,0x71,0x2A,0x4A,0xF4,0xA5,0x20,0x48,	/* 3390: .q*J H */
	0xD1,0x03,0x20,0x4B,0xD1,0x71,0x72,0x54,	/* 3398: . KqrT */
	0x23,0xFB,0x48,0x72,0x51,0x23,0xFB,0x2F,	/* 33A0: #HrQ#. */
	0x4F,0x74,0x6F,0x40,0x24,0xF6,0x28,0x40,	/* 33A8: Oto@$(@ */
	0x24,0xFB,0x23,0x28,0x20,0xE0,0x77,0x28,	/* 33B0: $#( w( */
	0x50,0xD3,0x76,0xAF,0x73,0x23,0x50,0x67,	/* 33B8: Pvs#Pg */
	0x20,0x20,0x40,0x24,0xFB,0x70,0xE0,0x73,	/* 33C0:   @$ps */
	0x70,0x21,0xE7,0x40,0xD1,0x41,0x72,0x51,	/* 33C8: p!@ArQ */
	0xF1,0x40,0x24,0xFF,0xF0,0xC0,0x21,0x24,	/* 33D0: @$!$ */
	0xAB,0x73,0xD0,0x73,0x71,0x72,0x55,0xFA,	/* 33D8: ssqrU */
	0xE0,0x72,0x54,0xF1,0x70,0x53,0x23,0xFB,	/* 33E0: rTpS# */
	0x21,0x40,0x70,0x57,0x23,0xFB,0x41,0x70,	/* 33E8: !@pW#Ap */
	0x21,0x8F,0x23,0xFB,0x71,0x70,0x87,0x23,	/* 33F0: !#qp# */
	0xFB,0x2F,0x4F,0x70,0x21,0x51,0x23,0xFB,	/* 33F8: .Op!Q# */
	0x78,0x26,0xA4,0x21,0x23,0x4D,0x21,0xFB,	/* 3400: x&!#M! */
	0x1B,0x21,0x40,0x24,0xFA,0x74,0x70,0xE1,	/* 3408: .!@$tp */
	0x41,0x71,0x43,0x24,0xFF,0xF0,0xAA,0x74,	/* 3410: AqC$t */
	0x23,0x28,0x27,0x3F,0x4F,0x24,0xF6,0xD5,	/* 3418: #('?O$ */
	0x0D,0x74,0x23,0x28,0x27,0x3F,0x2F,0x4F,	/* 3420: .t#('?.O */
	0x24,0xF6,0x44,0x24,0xF0,0xD5,0x75,0x2F,	/* 3428: $D$u. */
	0x4F,0x24,0xF6,0x25,0xFA,0xD5,0x70,0x21,	/* 3430: O$%p! */
	0x52,0x23,0xFB,0x75,0x1B,0xF2,0xF1,0x70,	/* 3438: R#u.p */
	0x21,0x53,0x23,0xFB,0x75,0x47,0x24,0xF6,	/* 3440: !S#uG$ */
	0x45,0xF4,0xC0,0xAD,0x71,0xA5,0x71,0x44,	/* 3448: EqqD */
	0xF4,0xC0,0xA6,0x41,0x70,0x22,0x87,0x23,	/* 3450: Ap"# */
	0xFB,0x4B,0x70,0x21,0x5B,0x23,0xFB,0x4B,	/* 3458: Kp![#K */
	0x70,0x23,0x87,0x23,0xFB,0x28,0x0E,0x2E,	/* 3460: p##(.. */
	0x4A,0x21,0xFB,0x1B,0x48,0x24,0xFA,0x72,	/* 3468: J!.H$r */
	0x54,0xF1,0x48,0xF4,0x21,0xAD,0x72,0x54,	/* 3470: TH!rT */
	0xF1,0x4B,0xF4,0x21,0xA6,0x71,0x1B,0xFA,	/* 3478: K!q. */
	0x30,0x48,0xF8,0x74,0xFA,0x70,0xE1,0x41,	/* 3480: 0HtpA */
	0x71,0x1B,0xFA,0x30,0x24,0xF1,0x70,0x8F,	/* 3488: q.0$p */
	0x23,0xFB,0x0F,0x71,0x48,0xF8,0x74,0xFA,	/* 3490: #.qHt */
	0x70,0xE1,0x41,0x71,0x24,0xF1,0x70,0x8F,	/* 3498: pAq$p */
	0x23,0xFB,0x71,0x41,0x24,0xF6,0xC0,0xAE,	/* 34A0: #qA$ */
	0x72,0x54,0xF1,0x44,0xF4,0xA8,0x72,0x54,	/* 34A8: rTDrT */
	0xF1,0x4A,0xF4,0xC0,0x23,0xAF,0x70,0x31,	/* 34B0: J#p1 */
	0xD5,0x2E,0x40,0x75,0x61,0x4F,0x24,0xF6,	/* 34B8: .@uaO$ */
	0x23,0x28,0x20,0xE4,0x40,0x75,0x61,0x4F,	/* 34C0: #( @uaO */
	0x24,0xF6,0x23,0x28,0x20,0xE5,0x40,0x75,	/* 34C8: $#( @u */
	0x61,0x4F,0x24,0xF6,0x23,0x28,0x20,0xE6,	/* 34D0: aO$#(  */
	0x42,0x75,0x61,0x4F,0x24,0xF6,0x23,0x28,	/* 34D8: BuaO$#( */
	0x20,0xE7,0x75,0x61,0x4F,0x24,0xF6,0x23,	/* 34E0:  uaO$# */
	0x28,0x20,0x3E,0x40,0x75,0x61,0x4F,0x24,	/* 34E8: ( >@uaO$ */
	0xF6,0x23,0x28,0x20,0xED,0x77,0x67,0x20,	/* 34F0: #( wg  */
	0x20,0x40,0x24,0xFB,0x70,0xE2,0x73,0x21,	/* 34F8:  @$ps! */
	0x28,0x50,0x25,0xFA,0xD3,0x23,0x50,0x67,	/* 3500: (P%#Pg */
	0x20,0x20,0x40,0x24,0xFB,0x70,0xE0,0x73,	/* 3508:   @$ps */
	0x70,0x21,0xE7,0x71,0x41,0xF2,0xD1,0x41,	/* 3510: p!qAA */
	0x72,0x51,0xF1,0x71,0x24,0xFF,0xF0,0xC0,	/* 3518: rQq$ */
	0xA3,0x61,0x2B,0x05,0x76,0x41,0xF2,0xD6,	/* 3520: a+.vA */
	0x41,0x44,0x76,0x24,0xFF,0xF0,0xC0,0xA3,	/* 3528: ADv$ */
	0x63,0x2E,0x03,0x67,0x21,0x2E,0x40,0x70,	/* 3530: c..g!.@p */
	0xE0,0x21,0x28,0x40,0x70,0x21,0xE7,0x41,	/* 3538: !(@p!A */
	0x21,0xB3,0x22,0xF0,0x20,0xF0,0xD0,0x00,	/* 3540: !" . */
	0xF0,0x00,0xC0,0x00,0x00,0xF0,0xD0,0xF0,	/* 3548: ... */
	0xF0,0x00,0xC0,0x00,0x00,0x00,0x00,0x03,	/* 3550: ...... */
	0x00,0x04,0x00,0x07,0x00,0x60,0xBC,0x75,	/* 3558: .....`u */
	0x28,0x54,0xD1,0x71,0x67,0x38,0x35,0x41,	/* 3560: (Tqg85A */
	0xF2,0x71,0x67,0x38,0xE5,0x21,0x28,0x40,	/* 3568: qg8!(@ */
	0x25,0xFA,0xD0,0x53,0xF1,0x2F,0x40,0x24,	/* 3570: %S.@$ */
	0xF6,0xC0,0x24,0xA5,0x70,0x57,0xF1,0xC0,	/* 3578: $pW */
	0x23,0xA2,0x70,0x34,0x22,0x20,0x20,0x40,	/* 3580: #p4"  @ */
	0x24,0xF6,0x22,0xA8,0x70,0x5C,0xF1,0xD3,	/* 3588: $"p\ */
	0x70,0x75,0x6C,0x2C,0x92,0x2F,0x4F,0x24,	/* 3590: pul,.O$ */
	0xF6,0x25,0xFA,0xD2,0x73,0xF4,0x21,0xA4,	/* 3598: %s! */
	0x72,0x70,0x5C,0x23,0xFB,0x70,0x21,0x89,	/* 35A0: rp\#p! */
	0xF1,0x42,0x24,0xFB,0x70,0x21,0x89,0x23,	/* 35A8: B$p!# */
	0xFB,0x41,0x71,0xE0,0x70,0x21,0x37,0x25,	/* 35B0: Aqp!7% */
	0xFA,0xD0,0x21,0x28,0x40,0xF4,0xA2,0x64,	/* 35B8: !(@d */
	0x0B,0x71,0x30,0x71,0x31,0x24,0xFB,0x21,	/* 35C0: .q0q1$! */
	0xAE,0x41,0x71,0x67,0x38,0xE4,0x71,0x30,	/* 35C8: Aqg8q0 */
	0x27,0x2C,0x28,0x40,0xE0,0x71,0x67,0x38,	/* 35D0: ',(@qg8 */
	0x56,0xF1,0x81,0x71,0x67,0x38,0x56,0x23,	/* 35D8: Vqg8V# */
	0xFB,0x40,0x71,0xE0,0x40,0x71,0xE1,0xB4,	/* 35E0: @q@q */
	0x22,0xF0,0x20,0x61,0xBF,0x21,0x72,0x28,	/* 35E8: " a!r( */
	0x56,0xD9,0x28,0x40,0xD3,0x40,0xD2,0x79,	/* 35F0: V(@@y */
	0x67,0x36,0x53,0xF1,0x81,0x79,0x67,0x36,	/* 35F8: g6Syg6 */
	0x53,0x23,0xFB,0x28,0x40,0xDA,0x40,0xDF,	/* 3600: S#(@@ */
	0x73,0x33,0xD1,0x72,0x44,0xF8,0x71,0x23,	/* 3608: s3rDq# */
	0x28,0x27,0xEF,0x71,0x23,0x28,0x26,0x37,	/* 3610: ('q#(&7 */
	0x2F,0x4F,0x24,0xF6,0x25,0xFA,0xD5,0x41,	/* 3618: .O$%A */
	0x24,0xF6,0x26,0x24,0xA8,0x71,0x23,0x28,	/* 3620: $&$q#( */
	0x26,0x3B,0x2F,0x4F,0x24,0xF6,0xD4,0x71,	/* 3628: &;.O$q */
	0x23,0x28,0x26,0x38,0x2F,0x4F,0x24,0xF6,	/* 3630: #(&8.O$ */
	0xD7,0x74,0x43,0x24,0xF6,0x71,0x23,0x28,	/* 3638: tC$q#( */
	0x26,0xE8,0x71,0x23,0x28,0x24,0x33,0x47,	/* 3640: &q#($3G */
	0x24,0xF6,0x25,0xFA,0xD6,0x43,0xF4,0x21,	/* 3648: $%C! */
	0x24,0xAE,0x76,0x47,0xF4,0xC0,0x26,0x21,	/* 3650: $vG&! */
	0xA4,0x40,0xDB,0x72,0x74,0x43,0x24,0xF6,	/* 3658: @rtC$ */
	0x28,0xF1,0x73,0x55,0xFA,0x30,0xD6,0x71,	/* 3660: (sU0q */
	0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 3668: #(&2.O$ */
	0xD8,0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,	/* 3670: q#(&2.O */
	0x24,0xF6,0x21,0xD0,0x78,0x48,0x24,0xF6,	/* 3678: $!xH$ */
	0x21,0xA0,0x76,0x21,0x89,0xF1,0x41,0x24,	/* 3680: !v!A$ */
	0xFB,0x76,0x21,0x89,0x23,0xFB,0x41,0x79,	/* 3688: v!#Ay */
	0x60,0xEE,0x78,0x47,0x24,0xF6,0xAD,0x76,	/* 3690: `xG$v */
	0x21,0x50,0xF1,0x28,0x40,0x24,0xF6,0xA4,	/* 3698: !P(@$ */
	0x41,0x79,0x60,0xEE,0x78,0x41,0x24,0xF6,	/* 36A0: Ay`xA$ */
	0xA8,0x76,0x21,0x3E,0x41,0xF2,0x76,0x21,	/* 36A8: v!>Av! */
	0xEE,0x78,0x42,0x24,0xF6,0xAA,0x76,0x21,	/* 36B0: xB$v! */
	0x3C,0x41,0xF2,0x76,0x21,0xEC,0x41,0xDB,	/* 36B8: <Av!A */
	0x78,0x44,0x24,0xF6,0xAA,0x76,0x21,0x3D,	/* 36C0: xD$v!= */
	0x41,0xF2,0x76,0x21,0xED,0x41,0xDB,0x7B,	/* 36C8: Av!A{ */
	0x25,0x28,0xAA,0x76,0x21,0x50,0xF1,0x24,	/* 36D0: %(v!P$ */
	0x40,0x24,0xF6,0xA6,0x76,0x22,0x8B,0xF1,	/* 36D8: @$v" */
	0x21,0xD0,0x76,0x55,0xF1,0xDB,0x76,0x8B,	/* 36E0: !vUv */
	0xF1,0xDD,0x76,0x34,0xDE,0x7D,0x7B,0x41,	/* 36E8: v4}{A */
	0xF2,0xF4,0x2F,0x4F,0x24,0xF6,0x25,0xFA,	/* 36F0: .O$% */
	0xDC,0x25,0x25,0xA9,0x21,0x70,0x7B,0x2F,	/* 36F8: %%!p{. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 3700: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0x76,0x55,0x23,0xFB,	/* 3708: {AvU# */
	0x7D,0x7B,0x41,0xF2,0x41,0xF2,0xF4,0x2F,	/* 3710: }{AA. */
	0x4F,0x24,0xF6,0xD0,0x7E,0x48,0x24,0xF6,	/* 3718: O$~H$ */
	0x25,0x23,0xAA,0x41,0x7C,0x23,0x4F,0x24,	/* 3720: %#A|#O$ */
	0xFF,0xF0,0xC0,0x25,0x22,0xAF,0x41,0x24,	/* 3728: %"A$ */
	0x40,0x70,0x24,0xFF,0xF0,0xC0,0x25,0x22,	/* 3730: @p$%" */
	0xA4,0x7E,0x21,0x40,0x24,0xFB,0xDE,0x76,	/* 3738: ~!@$v */
	0x21,0x58,0xF1,0x48,0x24,0xF6,0x22,0xA7,	/* 3740: !XH$" */
	0x7E,0x22,0x40,0x24,0xF6,0xC0,0x21,0xAF,	/* 3748: ~"@$! */
	0x71,0x23,0x28,0x20,0x35,0x2F,0x4F,0x24,	/* 3750: q#( 5.O$ */
	0xF6,0xC0,0x21,0xA3,0x40,0xD0,0x21,0x20,	/* 3758: !@!  */
	0x40,0x76,0x21,0x72,0x61,0x21,0x20,0x92,	/* 3760: @v!ra!  */
	0x22,0x42,0x71,0x23,0x28,0x20,0xE5,0x76,	/* 3768: "Bq#( v */
	0x23,0x81,0xF1,0x28,0x40,0x24,0xF6,0xAD,	/* 3770: #(@$ */
	0x40,0xD0,0x21,0x20,0x20,0x40,0x76,0x21,	/* 3778: @!  @v! */
	0x72,0x61,0x20,0x2E,0x95,0x76,0x21,0x58,	/* 3780: ra .v!X */
	0xF1,0x24,0x40,0x24,0xF6,0x24,0x2C,0xAD,	/* 3788: $@$$, */
	0x40,0xD0,0x22,0x20,0x20,0x40,0x76,0x21,	/* 3790: @"  @v! */
	0x72,0x61,0x20,0x2C,0x9D,0x24,0x2B,0x0D,	/* 3798: ra ,$+. */
	0x72,0x74,0x43,0x24,0xF6,0x28,0xF1,0x73,	/* 37A0: rtC$(s */
	0x55,0xFA,0x30,0x25,0xFA,0xD6,0x22,0x87,	/* 37A8: U0%" */
	0xF1,0xC0,0xAC,0x76,0x21,0x54,0xF1,0x41,	/* 37B0: v!TA */
	0x24,0xFB,0x76,0x21,0x54,0x23,0xFB,0x76,	/* 37B8: $v!T#v */
	0x55,0xF1,0xDB,0x76,0x8B,0xF1,0xDD,0x76,	/* 37C0: Uvv */
	0x34,0xDE,0x7D,0x7B,0x41,0xF2,0xF4,0x2F,	/* 37C8: 4}{A. */
	0x4F,0x24,0xF6,0xDC,0x41,0x79,0x60,0xEF,	/* 37D0: O$Ay` */
	0x71,0x23,0x28,0x20,0x3E,0x2F,0x4F,0x24,	/* 37D8: q#( >.O$ */
	0xF6,0xD0,0x41,0x7C,0x70,0x24,0xFF,0xF0,	/* 37E0: A|p$ */
	0xA3,0x7C,0xD8,0x02,0x70,0xD8,0x78,0x23,	/* 37E8: |.px# */
	0x29,0xAB,0x70,0x78,0xF4,0xD0,0x78,0x41,	/* 37F0: )pxxA */
	0xF4,0xD8,0x41,0x22,0x40,0x78,0x24,0xFF,	/* 37F8: A"@x$ */
	0xF0,0xC0,0x23,0x28,0xA3,0x78,0x42,0x21,	/* 3800: #(xB! */
	0xFB,0x28,0xF1,0xF6,0x23,0x26,0x01,0x20,	/* 3808: (#&.  */
	0x23,0x24,0x05,0x20,0x23,0x22,0x09,0x20,	/* 3810: #$. #".  */
	0x23,0x20,0x0D,0x20,0x22,0x2F,0x01,0x20,	/* 3818: # . "..  */
	0x22,0x2D,0x05,0x20,0x22,0x2B,0x09,0x20,	/* 3820: "-. "+.  */
	0x22,0x29,0x0D,0x20,0x22,0x28,0x01,0x20,	/* 3828: "). "(.  */
	0x22,0x26,0x05,0x20,0x22,0x24,0x09,0x20,	/* 3830: "&. "$.  */
	0x22,0x22,0x0D,0x20,0x22,0x21,0x01,0x20,	/* 3838: "". "!.  */
	0x21,0x2F,0x05,0x20,0x21,0x2D,0x09,0x20,	/* 3840: !.. !-.  */
	0x21,0x2B,0x0D,0x20,0x21,0x2A,0x01,0x20,	/* 3848: !+. !*.  */
	0x21,0x28,0x05,0x20,0x21,0x26,0x09,0x20,	/* 3850: !(. !&.  */
	0x21,0x24,0x0D,0x20,0x21,0x23,0x01,0x20,	/* 3858: !$. !#.  */
	0x21,0x21,0x05,0x20,0x2F,0x0A,0x20,0x20,	/* 3860: !!. ..   */
	0x2D,0x0E,0x20,0x20,0x2C,0x02,0x20,0x20,	/* 3868: -.  ,.   */
	0x2A,0x06,0x20,0x20,0x28,0x0A,0x20,0x20,	/* 3870: *.  (.   */
	0x26,0x0E,0x20,0x20,0x25,0x02,0x20,0x20,	/* 3878: &.  %.   */
	0x23,0x06,0x20,0x20,0x21,0x0A,0x20,0x20,	/* 3880: #.  !.   */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3888: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3890: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3898: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 38A0: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 38A8: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 38B0: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 38B8: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 38C0: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 38C8: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 38D0: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 38D8: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 38E0: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 38E8: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 38F0: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 38F8: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3900: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3908: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3910: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3918: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3920: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3928: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3930: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3938: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3940: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3948: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3950: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3958: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3960: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3968: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3970: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3978: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3980: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3988: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3990: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3998: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 39A0: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 39A8: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 39B0: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 39B8: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 39C0: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 39C8: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 39D0: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 39D8: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 39E0: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 39E8: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 39F0: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 39F8: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3A00: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3A08: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3A10: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3A18: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3A20: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3A28: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3A30: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3A38: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3A40: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3A48: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3A50: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3A58: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3A60: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3A68: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3A70: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3A78: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3A80: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3A88: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3A90: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3A98: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3AA0: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3AA8: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3AB0: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3AB8: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3AC0: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3AC8: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3AD0: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3AD8: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3AE0: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3AE8: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3AF0: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3AF8: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3B00: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3B08: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3B10: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3B18: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3B20: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3B28: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3B30: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3B38: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3B40: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3B48: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3B50: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3B58: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3B60: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3B68: P#{A */
	0x71,0x23,0x28,0x26,0x32,0x2F,0x4F,0x24,	/* 3B70: q#(&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,	/* 3B78: {.O$v+ */
	0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,	/* 3B80: P#{A */
	0x7B,0x76,0x55,0x23,0xFB,0x70,0x76,0x21,	/* 3B88: {vU#pv! */
	0x3F,0xF2,0x76,0x21,0xEF,0x70,0x25,0xFA,	/* 3B90: ?v!p% */
	0x60,0x4F,0xF2,0xD0,0x21,0xA0,0x71,0x23,	/* 3B98: `O!q# */
	0x28,0x26,0x32,0x70,0x25,0xFA,0x60,0x4F,	/* 3BA0: (&2p%`O */
	0xF2,0xD0,0xA3,0x20,0x60,0x00,0x7D,0x7B,	/* 3BA8: У `.}{ */
	0x41,0xF2,0xF4,0x2F,0x4F,0x24,0xF6,0xD0,	/* 3BB0: A.O$ */
	0x7E,0x48,0x24,0xF6,0x28,0xA2,0x41,0x7C,	/* 3BB8: ~H$(A| */
	0x23,0x4F,0x24,0xFF,0xF0,0xC0,0x27,0xA8,	/* 3BC0: #O$' */
	0x41,0x24,0x40,0x70,0x24,0xFF,0xF0,0xC0,	/* 3BC8: A$@p$ */
	0x26,0xAE,0x7E,0x21,0x40,0x24,0xFB,0xDE,	/* 3BD0: &~!@$ */
	0x76,0x21,0x58,0xF1,0x48,0x24,0xF6,0x23,	/* 3BD8: v!XH$# */
	0xA3,0x7E,0x22,0x40,0x24,0xF6,0xC0,0x22,	/* 3BE0: ~"@$" */
	0xAB,0x71,0x23,0x28,0x20,0x35,0x2F,0x4F,	/* 3BE8: q#( 5.O */
	0x24,0xF6,0xA8,0x7E,0x2C,0x40,0x24,0xFB,	/* 3BF0: $~,@$ */
	0xDE,0x21,0x09,0x40,0xD0,0x21,0x20,0x40,	/* 3BF8: !.@! @ */
	0x76,0x21,0x72,0x62,0x2C,0x26,0x93,0x22,	/* 3C00: v!rb,&" */
	0x42,0x71,0x23,0x28,0x20,0xE5,0x7E,0x22,	/* 3C08: Bq#( ~" */
	0x40,0x24,0xFB,0xDE,0x76,0x23,0x81,0xF1,	/* 3C10: @$v# */
	0x28,0x40,0x24,0xF6,0xAD,0x40,0xD0,0x21,	/* 3C18: (@$@! */
	0x20,0x20,0x40,0x76,0x21,0x72,0x62,0x2C,	/* 3C20:   @v!rb, */
	0x24,0x90,0x76,0x21,0x58,0xF1,0x24,0x40,	/* 3C28: $v!X$@ */
	0x24,0xF6,0xAD,0x40,0xD0,0x22,0x20,0x20,	/* 3C30: $@"   */
	0x40,0x76,0x21,0x72,0x62,0x2C,0x22,0x9A,	/* 3C38: @v!rb," */
	0x74,0x23,0x4F,0x24,0xF6,0x71,0x23,0x28,	/* 3C40: t#O$q#( */
	0x26,0xEB,0x77,0x71,0x23,0x28,0x26,0xE8,	/* 3C48: &wq#(& */
	0x7E,0x76,0xE4,0x21,0x08,0x70,0x76,0x21,	/* 3C50: ~v!.pv! */
	0x3F,0xF2,0x76,0x21,0xEF,0x74,0x23,0x4F,	/* 3C58: ?v!t#O */
	0x24,0xF6,0x71,0x23,0x28,0x26,0xEB,0x77,	/* 3C60: $q#(&w */
	0x71,0x23,0x28,0x26,0xE8,0x75,0x42,0x24,	/* 3C68: q#(&uB$ */
	0xF6,0x24,0x29,0xAF,0x71,0x23,0x28,0x26,	/* 3C70: $)q#(& */
	0x3A,0x2F,0x4F,0x24,0xF6,0xD4,0x71,0x23,	/* 3C78: :.O$q# */
	0x28,0x26,0x38,0x2F,0x4F,0x24,0xF6,0xD7,	/* 3C80: (&8.O$ */
	0x74,0x43,0x24,0xF6,0x71,0x23,0x28,0x26,	/* 3C88: tC$q#(& */
	0xE8,0x72,0x74,0x43,0x24,0xF6,0x28,0xF1,	/* 3C90: rtC$( */
	0x73,0x55,0xFA,0x30,0x25,0xFA,0xD0,0x22,	/* 3C98: sU0%" */
	0x87,0xF1,0xC0,0xAC,0x70,0x21,0x54,0xF1,	/* 3CA0: p!T */
	0x42,0x24,0xFB,0x70,0x21,0x54,0x23,0xFB,	/* 3CA8: B$p!T# */
	0x70,0x23,0x85,0xF1,0xAC,0x70,0x21,0x72,	/* 3CB0: p#p!r */
	0x25,0x20,0x93,0x70,0x34,0xD6,0x24,0x23,	/* 3CB8: % p4$# */
	0x0F,0x70,0x8D,0xF1,0xDE,0x70,0x56,0xF1,	/* 3CC0: .ppV */
	0xD8,0x70,0x34,0x25,0xFA,0xD6,0x21,0x20,	/* 3CC8: p4%!  */
	0x40,0x24,0xF6,0x21,0xAE,0x76,0x61,0x2F,	/* 3CD0: @$!va. */
	0x4F,0x24,0xF6,0x22,0x20,0x40,0x24,0xFB,	/* 3CD8: O$" @$ */
	0x60,0x4E,0x24,0xF6,0xD6,0x71,0x23,0x28,	/* 3CE0: `N$q#( */
	0x20,0x36,0x2F,0x49,0x24,0xF6,0x71,0x23,	/* 3CE8:  6.I$q# */
	0x28,0x20,0xE6,0x7E,0x78,0xF4,0x2F,0x4F,	/* 3CF0: ( ~x.O */
	0x24,0xF6,0x25,0xFA,0xDC,0x23,0x2D,0xA2,	/* 3CF8: $%#- */
	0x70,0x53,0xF1,0x24,0x48,0xF4,0xA3,0x4C,	/* 3D00: pS$HL */
	0xDB,0x03,0x22,0x40,0xDB,0x7B,0xDD,0x41,	/* 3D08: ."@{A */
	0x7C,0x7D,0x24,0xFF,0xF0,0xA3,0x7C,0xDB,	/* 3D10: |}$| */
	0x02,0x7D,0xDB,0x76,0x24,0x20,0x40,0x24,	/* 3D18: .}v$ @$ */
	0xF6,0x25,0xA9,0x7B,0x23,0x24,0xA7,0x70,	/* 3D20: %{#$p */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 3D28: #Px.O$ */
	0xF1,0x4A,0xF4,0x21,0xAF,0x70,0x23,0x50,	/* 3D30: J!p#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 3D38: x.O$q */
	0x23,0x28,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 3D40: #(&xA */
	0x7B,0x60,0x4F,0xF2,0xDB,0x7D,0x60,0x4F,	/* 3D48: {`O}`O */
	0xF2,0xDD,0x22,0x02,0x41,0x42,0x7D,0x24,	/* 3D50: ".AB}$ */
	0xFF,0xF0,0x23,0x21,0xA1,0x4D,0x71,0x23,	/* 3D58: #!Mq# */
	0x28,0x26,0xE3,0x4A,0x71,0x23,0x28,0x26,	/* 3D60: (&Jq#(& */
	0xE3,0x78,0x41,0xF2,0xD8,0x7B,0x60,0x4F,	/* 3D68: xA{`O */
	0xF2,0xDB,0x7D,0x42,0xF4,0xDD,0x7B,0x22,	/* 3D70: }B{" */
	0x2F,0xA4,0x65,0x0B,0x7B,0x41,0xF4,0xDB,	/* 3D78: .e.{A */
	0x41,0x22,0x40,0x7B,0x24,0xFF,0xF0,0xC0,	/* 3D80: A"@{$ */
	0x22,0x2E,0xA3,0x7B,0x42,0x21,0xFB,0x28,	/* 3D88: ".{B!( */
	0xF1,0xF6,0x22,0x2C,0x06,0x20,0x22,0x2A,	/* 3D90: ",. "* */
	0x0F,0x20,0x22,0x29,0x08,0x20,0x22,0x28,	/* 3D98: . "). "( */
	0x01,0x20,0x22,0x26,0x0A,0x20,0x22,0x25,	/* 3DA0: . "&. "% */
	0x03,0x20,0x22,0x23,0x0C,0x20,0x22,0x22,	/* 3DA8: . "#. "" */
	0x05,0x20,0x22,0x20,0x0E,0x20,0x21,0x2F,	/* 3DB0: . " . !. */
	0x07,0x20,0x21,0x2E,0x00,0x20,0x21,0x2C,	/* 3DB8: . !.. !, */
	0x09,0x20,0x21,0x2B,0x02,0x20,0x21,0x29,	/* 3DC0: . !+. !) */
	0x0B,0x20,0x21,0x28,0x04,0x20,0x21,0x26,	/* 3DC8: . !(. !& */
	0x0D,0x20,0x21,0x25,0x06,0x20,0x21,0x23,	/* 3DD0: . !%. !# */
	0x0F,0x20,0x21,0x22,0x08,0x20,0x21,0x21,	/* 3DD8: . !". !! */
	0x01,0x20,0x2F,0x0B,0x20,0x20,0x2E,0x04,	/* 3DE0: . ..  .. */
	0x20,0x20,0x2C,0x0D,0x20,0x20,0x2B,0x06,	/* 3DE8:   ,.  +. */
	0x20,0x20,0x29,0x0F,0x20,0x20,0x28,0x08,	/* 3DF0:   ).  (. */
	0x20,0x20,0x27,0x01,0x20,0x20,0x25,0x0A,	/* 3DF8:   '.  %. */
	0x20,0x20,0x24,0x03,0x20,0x20,0x22,0x0C,	/* 3E00:   $.  ". */
	0x20,0x20,0x21,0x05,0x20,0x20,0x70,0x23,	/* 3E08:   !.  p# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 3E10: Px.O$ */
	0x71,0x23,0x28,0x26,0xE3,0x78,0x41,0xF2,	/* 3E18: q#(&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 3E20: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x23,0x28,0x26,0xE3,	/* 3E28: q#(& */
	0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,	/* 3E30: xAp#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x23,	/* 3E38: .O$q# */
	0x28,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 3E40: (&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 3E48: #Px.O$ */
	0xF1,0x71,0x23,0x28,0x26,0xE3,0x78,0x41,	/* 3E50: q#(&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 3E58: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x23,0x28,0x26,	/* 3E60: $q#(& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 3E68: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 3E70: x.O$q */
	0x23,0x28,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 3E78: #(&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 3E80: p#Px.O$ */
	0xF2,0xF1,0x71,0x23,0x28,0x26,0xE3,0x78,	/* 3E88: q#(&x */
	0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,	/* 3E90: Ap#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x23,0x28,	/* 3E98: O$q#( */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,	/* 3EA0: &xAp# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 3EA8: Px.O$ */
	0x71,0x23,0x28,0x26,0xE3,0x78,0x41,0xF2,	/* 3EB0: q#(&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 3EB8: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x23,0x28,0x26,0xE3,	/* 3EC0: q#(& */
	0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,	/* 3EC8: xAp#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x23,	/* 3ED0: .O$q# */
	0x28,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 3ED8: (&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 3EE0: #Px.O$ */
	0xF1,0x71,0x23,0x28,0x26,0xE3,0x78,0x41,	/* 3EE8: q#(&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 3EF0: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x23,0x28,0x26,	/* 3EF8: $q#(& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 3F00: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 3F08: x.O$q */
	0x23,0x28,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 3F10: #(&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 3F18: p#Px.O$ */
	0xF2,0xF1,0x71,0x23,0x28,0x26,0xE3,0x78,	/* 3F20: q#(&x */
	0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,	/* 3F28: Ap#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x23,0x28,	/* 3F30: O$q#( */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,	/* 3F38: &xAp# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 3F40: Px.O$ */
	0x71,0x23,0x28,0x26,0xE3,0x78,0x41,0xF2,	/* 3F48: q#(&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 3F50: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x23,0x28,0x26,0xE3,	/* 3F58: q#(& */
	0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,	/* 3F60: xAp#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x23,	/* 3F68: .O$q# */
	0x28,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 3F70: (&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 3F78: #Px.O$ */
	0xF1,0x71,0x23,0x28,0x26,0xE3,0x78,0x41,	/* 3F80: q#(&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 3F88: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x23,0x28,0x26,	/* 3F90: $q#(& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 3F98: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 3FA0: x.O$q */
	0x23,0x28,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 3FA8: #(&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 3FB0: p#Px.O$ */
	0xF2,0xF1,0x71,0x23,0x28,0x26,0xE3,0x78,	/* 3FB8: q#(&x */
	0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,	/* 3FC0: Ap#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x23,0x28,	/* 3FC8: O$q#( */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,	/* 3FD0: &xAp# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 3FD8: Px.O$ */
	0x71,0x23,0x28,0x26,0xE3,0x78,0x41,0xF2,	/* 3FE0: q#(&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 3FE8: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x23,0x28,0x26,0xE3,	/* 3FF0: q#(& */
	0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,	/* 3FF8: xAp#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x23,	/* 4000: .O$q# */
	0x28,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 4008: (&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 4010: #Px.O$ */
	0xF1,0x71,0x23,0x28,0x26,0xE3,0x78,0x41,	/* 4018: q#(&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 4020: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x23,0x28,0x26,	/* 4028: $q#(& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 4030: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 4038: x.O$q */
	0x23,0x28,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 4040: #(&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 4048: p#Px.O$ */
	0xF2,0xF1,0x71,0x23,0x28,0x26,0xE3,0x78,	/* 4050: q#(&x */
	0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,	/* 4058: Ap#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x23,0x28,	/* 4060: O$q#( */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x7E,0x78,	/* 4068: &xA~x */
	0x2F,0x4F,0x24,0xF6,0xF4,0x2F,0x4F,0x24,	/* 4070: .O$.O$ */
	0xF6,0xDB,0x78,0x2F,0x4F,0x24,0xF6,0x70,	/* 4078: x.O$p */
	0x56,0x23,0xFB,0x41,0x7C,0x2C,0x40,0x24,	/* 4080: V#A|,@$ */
	0xFF,0xF0,0xC0,0xA9,0x41,0x2C,0x41,0x7B,	/* 4088: A,A{ */
	0x24,0xFF,0xF0,0x22,0xA8,0x41,0x7C,0x24,	/* 4090: $"A|$ */
	0x40,0x24,0xFF,0xF0,0xC0,0x22,0xA5,0x41,	/* 4098: @$"A */
	0x24,0x41,0x7B,0x24,0xFF,0xF0,0xC0,0x21,	/* 40A0: $A{$! */
	0xAB,0x76,0x28,0x20,0x40,0x24,0xF6,0x21,	/* 40A8: v( @$! */
	0xA3,0x76,0x68,0x2F,0x4F,0x24,0xF6,0xD6,	/* 40B0: vh.O$ */
	0x41,0x79,0x60,0xEE,0x07,0x76,0x28,0x20,	/* 40B8: Ay`.v(  */
	0x40,0x24,0xFB,0xD6,0x70,0x24,0x81,0xF1,	/* 40C0: @$p$ */
	0x41,0x24,0xFB,0x70,0x24,0x81,0x23,0xFB,	/* 40C8: A$p$# */
	0x22,0x0E,0x76,0x60,0x4E,0x24,0xF6,0xD6,	/* 40D0: ".v`N$ */
	0x71,0x23,0x28,0x20,0x36,0x2F,0x49,0x24,	/* 40D8: q#( 6.I$ */
	0xF6,0x71,0x23,0x28,0x20,0xE6,0x70,0x24,	/* 40E0: q#( p$ */
	0x81,0xF1,0x41,0x24,0xF6,0x21,0xA1,0x41,	/* 40E8: A$!A */
	0x79,0x60,0xEE,0x70,0x24,0x81,0xF1,0x60,	/* 40F0: y`p$` */
	0x4E,0x24,0xF6,0x70,0x24,0x81,0x23,0xFB,	/* 40F8: N$p$# */
	0x74,0x23,0x4F,0x24,0xF6,0x71,0x23,0x28,	/* 4100: t#O$q#( */
	0x26,0xEA,0x77,0x71,0x23,0x28,0x26,0xE8,	/* 4108: &wq#(& */
	0x76,0x70,0xE4,0x75,0x44,0x24,0xF6,0x26,	/* 4110: vpuD$& */
	0xA9,0x71,0x23,0x28,0x26,0x39,0x2F,0x4F,	/* 4118: q#(&9.O */
	0x24,0xF6,0xD4,0x71,0x23,0x28,0x26,0x38,	/* 4120: $q#(&8 */
	0x2F,0x4F,0x24,0xF6,0xD7,0x74,0x43,0x24,	/* 4128: .O$tC$ */
	0xF6,0x71,0x23,0x28,0x26,0xE8,0x72,0x74,	/* 4130: q#(&rt */
	0x43,0x24,0xF6,0x28,0xF1,0x73,0x55,0xFA,	/* 4138: C$(sU */
	0x30,0x25,0xFA,0xD0,0x21,0x72,0x21,0x28,	/* 4140: 0%!r!( */
	0x99,0x70,0x21,0x72,0x63,0x27,0x27,0x9B,	/* 4148: p!rc'' */
	0x70,0x22,0x87,0xF1,0xC0,0xAC,0x70,0x21,	/* 4150: p"p! */
	0x54,0xF1,0x44,0x24,0xFB,0x70,0x21,0x54,	/* 4158: TD$p!T */
	0x23,0xFB,0x41,0x79,0x60,0xEE,0x70,0x21,	/* 4160: #Ay`p! */
	0x89,0xF1,0x42,0x24,0xFB,0x70,0x21,0x89,	/* 4168: B$p! */
	0x23,0xFB,0x74,0x23,0x4F,0x24,0xF6,0x71,	/* 4170: #t#O$q */
	0x23,0x28,0x26,0xE9,0x77,0x71,0x23,0x28,	/* 4178: #(&wq#( */
	0x26,0xE8,0x73,0x89,0xF1,0x71,0x23,0x28,	/* 4180: &sq#( */
	0x27,0xEF,0x72,0x41,0xF2,0xD2,0x41,0x72,	/* 4188: 'rAAr */
	0x41,0x24,0xFF,0xF0,0xC0,0x21,0xA2,0x40,	/* 4190: A$!@ */
	0xD2,0x73,0x30,0xAA,0x73,0x30,0x27,0x2F,	/* 4198: s0s0'. */
	0x2F,0x4F,0x24,0xF6,0xD3,0x03,0x28,0x40,	/* 41A0: .O$.(@ */
	0xD3,0x75,0xC0,0xAE,0x73,0x7A,0xF4,0xC0,	/* 41A8: usz */
	0x6B,0x25,0xA5,0x72,0x7F,0xF4,0xA3,0x6B,	/* 41B0: k%rk */
	0x24,0x0E,0x21,0xB1,0x22,0xF0,0x60,0xBE,	/* 41B8: $.!"` */
	0x74,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 41C0: t2'..O$ */
	0x33,0xD1,0x74,0x23,0x85,0xF1,0xD0,0x43,	/* 41C8: 3t#C */
	0x70,0xF9,0x21,0xA0,0x70,0x2F,0xA8,0x70,	/* 41D0: p!p.p */
	0x41,0xF4,0x21,0xAA,0x70,0x42,0xF4,0xC0,	/* 41D8: A!pB */
	0x2E,0xAD,0x24,0x09,0x70,0x43,0xF4,0x2E,	/* 41E0: .$.pC. */
	0xA6,0x70,0x44,0xF4,0x27,0xA6,0x70,0x45,	/* 41E8: pD'pE */
	0xF4,0xC0,0x2D,0xAB,0x2A,0x05,0x71,0x23,	/* 41F0: -*.q# */
	0x28,0x20,0x35,0x2F,0x4F,0x24,0xF6,0xC0,	/* 41F8: ( 5.O$ */
	0x2C,0xAD,0x71,0x23,0x28,0x20,0x39,0x22,	/* 4200: ,q#( 9" */
	0x40,0x24,0xF6,0xC0,0x21,0xA9,0x71,0x23,	/* 4208: @$!q# */
	0x28,0x20,0x39,0x2F,0x4F,0x24,0xF6,0x22,	/* 4210: ( 9.O$" */
	0x40,0x24,0xFB,0x71,0x23,0x28,0x20,0xE9,	/* 4218: @$q#(  */
	0x24,0x4E,0x71,0x23,0x28,0x20,0xE5,0x42,	/* 4220: $Nq#( B */
	0x74,0x23,0x85,0x23,0xFB,0x71,0x23,0x28,	/* 4228: t##q#( */
	0x20,0x35,0x2F,0x4F,0x24,0xF6,0xC0,0x29,	/* 4230:  5.O$) */
	0xA6,0x40,0x71,0x23,0x28,0x26,0xE3,0x28,	/* 4238: @q#(&( */
	0x41,0x71,0x23,0x28,0x26,0xE3,0x74,0x34,	/* 4240: Aq#(&t4 */
	0x60,0x4E,0x24,0xF6,0x74,0xE4,0x71,0x23,	/* 4248: `N$tq# */
	0x28,0x20,0x36,0x2F,0x49,0x24,0xF6,0x71,	/* 4250: ( 6.I$q */
	0x23,0x28,0x20,0xE6,0x43,0x74,0x23,0x85,	/* 4258: #( Ct# */
	0x23,0xFB,0x26,0x0B,0x71,0x23,0x28,0x20,	/* 4260: #&.q#(  */
	0x35,0x2F,0x4F,0x24,0xF6,0xC0,0x25,0xAF,	/* 4268: 5.O$% */
	0x71,0x23,0x28,0x20,0x39,0x22,0x40,0x24,	/* 4270: q#( 9"@$ */
	0xF6,0xC0,0x21,0xA9,0x71,0x23,0x28,0x20,	/* 4278: !q#(  */
	0x39,0x2F,0x4F,0x24,0xF6,0x22,0x40,0x24,	/* 4280: 9.O$"@$ */
	0xFB,0x71,0x23,0x28,0x20,0xE9,0x24,0x4E,	/* 4288: q#( $N */
	0x71,0x23,0x28,0x20,0xE5,0x45,0x74,0x23,	/* 4290: q#( Et# */
	0x85,0x23,0xFB,0x71,0x23,0x28,0x20,0x35,	/* 4298: #q#( 5 */
	0x2F,0x4F,0x24,0xF6,0xC0,0x22,0xA8,0x40,	/* 42A0: .O$"@ */
	0x71,0x23,0x28,0x26,0xE3,0x28,0x43,0x71,	/* 42A8: q#(&(Cq */
	0x23,0x28,0x26,0xE3,0x71,0x23,0x28,0x20,	/* 42B0: #(&q#(  */
	0x39,0x2D,0x4F,0x24,0xF6,0x71,0x23,0x28,	/* 42B8: 9-O$q#( */
	0x20,0xE9,0x24,0x4E,0x71,0x23,0x28,0x20,	/* 42C0:  $Nq#(  */
	0xE5,0x40,0x74,0x23,0x85,0x23,0xFB,0xB2,	/* 42C8: @t## */
	0x22,0xF0,0x60,0xBF,0x73,0x31,0x25,0xFA,	/* 42D0: "`s1% */
	0xD0,0x23,0x28,0x20,0x35,0x2F,0x4F,0x24,	/* 42D8: #( 5.O$ */
	0xF6,0x21,0xA0,0x73,0x22,0x50,0xF1,0x21,	/* 42E0: !s"P! */
	0x40,0x24,0xFB,0x73,0x22,0x50,0x23,0xFB,	/* 42E8: @$s"P# */
	0xB1,0x22,0xF0,0x73,0x22,0x50,0xF1,0x61,	/* 42F0: "s"Pa */
	0x4F,0x24,0xF6,0x73,0x22,0x50,0x23,0xFB,	/* 42F8: O$s"P# */
	0x73,0x21,0x58,0xF1,0x21,0x40,0x24,0xF6,	/* 4300: s!X!@$ */
	0x24,0xAC,0x70,0x23,0x28,0x26,0x3C,0x21,	/* 4308: $p#(&<! */
	0x40,0x24,0xF6,0x22,0xA0,0x73,0x22,0x50,	/* 4310: @$"s"P */
	0xF1,0x41,0x24,0xF6,0x25,0xA5,0x21,0x48,	/* 4318: A$%!H */
	0x70,0x23,0x28,0x20,0xE5,0x73,0x22,0x50,	/* 4320: p#( s"P */
	0xF1,0x60,0x4E,0x24,0xF6,0x73,0x22,0x50,	/* 4328: `N$s"P */
	0x23,0xFB,0xB1,0x22,0xF0,0x73,0x22,0x50,	/* 4330: #"s"P */
	0xF1,0x41,0x24,0xF6,0x23,0xF2,0x23,0xA3,	/* 4338: A$## */
	0x21,0x44,0x70,0x23,0x28,0x20,0xE5,0x73,	/* 4340: !Dp#( s */
	0x22,0x50,0xF1,0x41,0x24,0xFB,0x73,0x22,	/* 4348: "PA$s" */
	0x50,0x23,0xFB,0xB1,0x22,0xF0,0x73,0x22,	/* 4350: P#"s" */
	0x50,0xF1,0x41,0x24,0xF6,0x21,0xA4,0x21,	/* 4358: PA$!! */
	0x48,0x70,0x23,0x28,0x20,0xE5,0x73,0x22,	/* 4360: Hp#( s" */
	0x50,0xF1,0x60,0x4E,0x24,0xF6,0x73,0x22,	/* 4368: P`N$s" */
	0x50,0x23,0xFB,0xB1,0x22,0xF0,0x20,0x60,	/* 4370: P#" ` */
	0xBF,0x72,0x3A,0xD0,0x72,0x3A,0x72,0x3B,	/* 4378: r:r:r; */
	0x72,0x3B,0x26,0x2B,0x96,0x72,0x72,0x3B,	/* 4380: r;&+rr; */
	0xD2,0xD3,0xB1,0x60,0xB8,0x79,0x28,0x56,	/* 4388: ӱ`y(V */
	0xD5,0x7A,0x37,0x7A,0x35,0xF4,0x75,0x21,	/* 4390: z7z5u! */
	0xEB,0x7A,0x37,0x75,0x21,0xEC,0x7A,0x3D,	/* 4398: z7u!z= */
	0x75,0x21,0xEF,0x7A,0x3C,0x75,0x22,0xE0,	/* 43A0: u!z<u" */
	0x41,0x75,0x22,0xE3,0x24,0x20,0x40,0x75,	/* 43A8: Au"$ @u */
	0x22,0xE4,0x7A,0x75,0x21,0xEE,0x75,0x21,	/* 43B0: "zu!u! */
	0x55,0x79,0x2B,0x26,0x9E,0xC0,0x22,0xA5,	/* 43B8: Uy+&" */
	0x21,0xFE,0x75,0xEE,0x22,0xF2,0x75,0xED,	/* 43C0: !u"u */
	0x75,0x16,0x44,0x24,0xFA,0x24,0xF2,0xD0,	/* 43C8: u.D$$ */
	0x24,0xF2,0xD1,0x40,0xD2,0x24,0xF2,0xD3,	/* 43D0: $@$ */
	0x40,0xD4,0x16,0x41,0x79,0x63,0x21,0x22,	/* 43D8: @.Ayc!" */
	0x9A,0x79,0x2C,0x20,0x98,0xB8,0x22,0xF0,	/* 43E0: y, " */
	0x20,0x00,0x20,0x01,0x00,0xD4,0x01,0x71,	/* 43E8:  . ...q */
	0x28,0x56,0xD2,0x60,0x42,0x21,0xFB,0x72,	/* 43F0: (V`B!r */
	0xE0,0x72,0x61,0x4D,0x21,0xFB,0x41,0x26,	/* 43F8: raM!A& */
	0x28,0x97,0x22,0xF0,0x20,0x74,0xD1,0x23,	/* 4400: (" t# */
	0x2F,0x05,0x74,0xD1,0x24,0x21,0x0C,0x11,	/* 4408: ..t$!.. */
	0x72,0x42,0x23,0x2E,0x9A,0x71,0x22,0xF0,	/* 4410: rB#.q" */
	0x40,0xD1,0x11,0x72,0x41,0x23,0x2D,0x9F,	/* 4418: @.rA#- */
	0x71,0x2F,0x4F,0x24,0xF6,0x22,0xF0,0x13,	/* 4420: q.O$". */
	0x72,0x42,0x23,0x2F,0x9E,0x22,0xF0,0x13,	/* 4428: rB#.". */
	0x72,0x41,0x23,0x2F,0x96,0x22,0xF0,0x60,	/* 4430: rA#."` */
	0xBE,0x73,0x29,0x39,0xD0,0x40,0xD1,0x73,	/* 4438: s)9@s */
	0x2A,0x31,0x24,0xF2,0xF4,0x21,0xA4,0x73,	/* 4440: *1$!s */
	0x2A,0x31,0x74,0xF9,0xC0,0xAD,0x74,0x73,	/* 4448: *1tts */
	0x2A,0x32,0xF9,0xC0,0xA6,0x41,0x47,0x73,	/* 4450: *2AGs */
	0x2B,0x2B,0x9A,0x70,0x24,0xF2,0xF4,0x21,	/* 4458: ++p$! */
	0xAB,0x70,0x32,0x74,0xF9,0xC0,0xA9,0x70,	/* 4460: p2tp */
	0x33,0x70,0x32,0xF2,0x74,0xF9,0xC0,0xAA,	/* 4468: 3p2t */
	0x70,0x30,0xD0,0x70,0x24,0xF2,0xF4,0xA4,	/* 4470: p0p$ */
	0x61,0x07,0x41,0xD1,0x71,0xA6,0x41,0x47,	/* 4478: a.AqAG */
	0x73,0x2B,0x29,0x91,0xB2,0x22,0xF0,0x60,	/* 4480: s+)"` */
	0xBF,0x11,0xD0,0x72,0x29,0x39,0x24,0xF2,	/* 4488: .r)9$ */
	0xF4,0xC0,0x21,0xA0,0x21,0x25,0x46,0x21,	/* 4490: !!%F! */
	0xFB,0x72,0x2A,0xEB,0x22,0x26,0x45,0x21,	/* 4498: r*"&E! */
	0xFB,0x72,0x2A,0xEC,0x75,0x72,0x67,0x9F,	/* 44A0: r*urg */
	0x76,0xA8,0x77,0x23,0xF4,0x21,0x50,0x76,	/* 44A8: vw#!Pv */
	0xF9,0xA4,0x41,0xB1,0x22,0xF0,0x77,0x81,	/* 44B0: A"w */
	0xD7,0x73,0x24,0xF2,0xF4,0x26,0xAB,0x75,	/* 44B8: s$&u */
	0x73,0xE2,0x76,0x73,0xE3,0x76,0x73,0x32,	/* 44C0: svsvs2 */
	0xF5,0x60,0x5D,0x77,0x23,0xF4,0xFC,0x73,	/* 44C8: `]w#s */
	0xE4,0x74,0x73,0x34,0x60,0xEF,0x74,0x73,	/* 44D0: ts4`ts */
	0xE6,0x2A,0x27,0x4B,0x21,0xFB,0x73,0x34,	/* 44D8: *'K!s4 */
	0xE0,0x70,0x31,0x73,0x34,0xE1,0x73,0x73,	/* 44E0: p1s4ss */
	0x34,0xE2,0x40,0xD0,0x77,0x60,0x8F,0x40,	/* 44E8: 4@w`@ */
	0xF9,0x21,0xA5,0x70,0x18,0xFA,0x30,0x70,	/* 44F0: !p.0p */
	0x83,0x73,0x34,0xFA,0xE0,0x70,0x81,0xD0,	/* 44F8: s4p */
	0x77,0x60,0x8F,0x70,0xF9,0xA2,0x61,0x0B,	/* 4500: w`pa. */
	0x77,0x73,0xE5,0x24,0xF2,0x81,0x73,0xE7,	/* 4508: ws$s */
	0x72,0x28,0x58,0x72,0x2D,0x99,0x72,0x29,	/* 4510: r(Xr-r) */
	0x39,0x73,0xE0,0x73,0x72,0x29,0xE9,0x72,	/* 4518: 9ssr)r */
	0x28,0x58,0x72,0x21,0x2E,0x90,0x40,0xB1,	/* 4520: (Xr!.@ */
	0x22,0xF0,0x41,0xB1,0x22,0xF0,0x60,0xBE,	/* 4528: "A"` */
	0x73,0x28,0x58,0xD1,0x71,0x73,0x2B,0x97,	/* 4530: s(Xqs+ */
	0x74,0x71,0x21,0x31,0xF4,0xAD,0x71,0x21,	/* 4538: tq!1q! */
	0x31,0xD0,0x70,0x30,0x24,0xF2,0xF4,0x22,	/* 4540: 1p0$" */
	0xA2,0x21,0x00,0x71,0x21,0x31,0x30,0x71,	/* 4548: !.q!10q */
	0x21,0xE1,0x71,0x73,0x21,0x2A,0x9F,0x40,	/* 4550: !qs!*@ */
	0xB2,0x22,0xF0,0x70,0x30,0x74,0xF4,0xAB,	/* 4558: "p0t */
	0x70,0x30,0xD0,0x70,0x30,0x24,0xF2,0xF4,	/* 4560: p0p0$ */
	0xA2,0x60,0x00,0x70,0x30,0x24,0xF2,0xF4,	/* 4568: `.p0$ */
	0xAD,0x74,0x30,0x70,0xE0,0x71,0x73,0x21,	/* 4570: t0pqs! */
	0x28,0x9C,0x40,0xB2,0x22,0xF0,0x71,0x73,	/* 4578: (@"qs */
	0x21,0x28,0x93,0x41,0xB2,0x22,0xF0,0x72,	/* 4580: !(A"r */
	0x71,0x65,0x93,0xA6,0x41,0x48,0x71,0x2A,	/* 4588: qeAHq* */
	0x28,0x93,0x22,0xF0,0x72,0x71,0x66,0x96,	/* 4590: ("rqf */
	0xA6,0x41,0x48,0x71,0x2A,0x27,0x96,0x72,	/* 4598: AHq*'r */
	0x71,0x23,0x2F,0x9D,0x22,0xF0,0x01,0x00,	/* 45A0: q#.".. */
	0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,	/* 45A8: ........ */
	0x00,0x00,0x01,0x0A,0x00,0x08,0x00,0x07,	/* 45B0: ........ */
	0x00,0x05,0x00,0x04,0x00,0x02,0x00,0x01,	/* 45B8: ........ */
	0x00,0xAE,0x02,0x71,0x28,0x58,0xD2,0x62,	/* 45C0: ..q(Xb */
	0x4B,0x21,0xFB,0x72,0x4D,0x24,0xFA,0x72,	/* 45C8: K!rM$r */
	0x62,0x4F,0x21,0xFB,0x47,0x24,0x2B,0x91,	/* 45D0: bO!G$+ */
	0x22,0xF0,0x20,0x72,0x22,0xFB,0x22,0xF0,	/* 45D8: " r"" */
	0x22,0xF2,0x72,0xF2,0xD2,0x72,0x22,0xFB,	/* 45E0: "rr" */
	0x22,0xF0,0x21,0xF5,0x22,0xF0,0x20,0x60,	/* 45E8: "!" ` */
	0xB8,0x40,0xD3,0x24,0xF2,0xD0,0x24,0xF2,	/* 45F0: @$$ */
	0xD1,0x21,0xFE,0x41,0xF4,0xA2,0x28,0x01,	/* 45F8: !A(. */
	0x41,0xD4,0x7A,0x33,0xC1,0xA6,0x40,0x7A,	/* 4600: Az3@z */
	0xE3,0x40,0x22,0xA0,0x24,0xF2,0x24,0xF2,	/* 4608: @"$$ */
	0xD6,0xD7,0x7A,0x34,0x24,0xF2,0xF4,0xC0,	/* 4610: z4$ */
	0xA8,0x16,0x16,0x7A,0xE4,0x7A,0xE5,0x40,	/* 4618: ..zz@ */
	0xA7,0x16,0x7A,0x35,0xE1,0x16,0x7A,0xE5,	/* 4620: .z5.z */
	0x15,0x16,0x42,0xF7,0x41,0x7A,0xE9,0x41,	/* 4628: ..BAzA */
	0x7A,0x30,0x40,0x24,0xFF,0xF0,0x21,0xA1,	/* 4630: z0@$! */
	0x41,0xD3,0x7A,0x31,0x24,0xF2,0xF4,0x21,	/* 4638: Az1$! */
	0xA0,0x10,0x7A,0x32,0xE1,0x10,0x7A,0xE2,	/* 4640: .z2.z */
	0x0E,0x7A,0x30,0x60,0x4F,0xF2,0x7A,0xE0,	/* 4648: .z0`Oz */
	0x06,0x10,0x7A,0xE1,0x10,0x7A,0xE2,0x40,	/* 4650: ..z.z@ */
	0x7A,0xE9,0x7A,0x3A,0x24,0xF2,0xF4,0xA5,	/* 4658: zz:$ */
	0x14,0x7A,0x5A,0x42,0xFB,0x41,0xD5,0x7A,	/* 4660: .zZBAz */
	0x34,0x24,0xF2,0xF4,0xC0,0xA5,0x41,0x7A,	/* 4668: 4$Az */
	0xE3,0x40,0xAC,0x7A,0x34,0x31,0x7A,0x34,	/* 4670: @z41z4 */
	0xD6,0x7A,0xE4,0x15,0x76,0x42,0xFB,0x27,	/* 4678: z.vB' */
	0x0B,0x7A,0x36,0xC1,0xA7,0x20,0x40,0x7A,	/* 4680: .z6 @z */
	0xE6,0x40,0x22,0xA2,0x24,0xF2,0x24,0xF2,	/* 4688: @"$$ */
	0xD6,0xD7,0x7A,0x37,0x24,0xF2,0xF4,0xC0,	/* 4690: z7$ */
	0xAA,0x20,0x16,0x16,0x7A,0xE7,0x7A,0xE8,	/* 4698:  ..zz */
	0x40,0xA8,0x20,0x16,0x7A,0x38,0xE1,0x16,	/* 46A0: @ .z8. */
	0x7A,0xE8,0x15,0x16,0x42,0xF7,0x7A,0x39,	/* 46A8: z..Bz9 */
	0xA6,0x20,0x14,0x7A,0x5A,0x42,0xF7,0x41,	/* 46B0:  .zZBA */
	0x7A,0x30,0x40,0x24,0xFF,0xF0,0x21,0xA1,	/* 46B8: z0@$! */
	0x41,0xD3,0x7A,0x31,0x24,0xF2,0xF4,0x21,	/* 46C0: Az1$! */
	0xA1,0x10,0x7A,0x32,0xE1,0x10,0x7A,0xE2,	/* 46C8: .z2.z */
	0x0F,0x7A,0x30,0x60,0x4F,0xF2,0x7A,0xE0,	/* 46D0: .z0`Oz */
	0x07,0x20,0x10,0x7A,0xE1,0x10,0x7A,0xE2,	/* 46D8: . .z.z */
	0x41,0xD5,0x7A,0x37,0x24,0xF2,0xF4,0xC0,	/* 46E0: Az7$ */
	0xA7,0x20,0x41,0x7A,0xE6,0x40,0xAD,0x20,	/* 46E8:  Az@  */
	0x7A,0x37,0x31,0x7A,0x37,0xD6,0x7A,0xE7,	/* 46F0: z71z7z */
	0x15,0x76,0x42,0xFB,0x73,0xA5,0x20,0x12,	/* 46F8: .vBs . */
	0x10,0x42,0xF7,0xB8,0x22,0xF0,0x60,0xBB,	/* 4700: .B"` */
	0x41,0xD0,0x21,0xFE,0x41,0xF4,0xA3,0x20,	/* 4708: A!A  */
	0x27,0x0B,0x77,0x33,0xC1,0xA7,0x20,0x40,	/* 4710: '.w3 @ */
	0x77,0xE3,0x40,0x22,0xA2,0x24,0xF2,0x24,	/* 4718: w@"$$ */
	0xF2,0xD2,0xD3,0x77,0x34,0x24,0xF2,0xF4,	/* 4720: w4$ */
	0xC0,0xAA,0x20,0x12,0x12,0x77,0xE4,0x77,	/* 4728:  ..ww */
	0xE5,0x40,0xA8,0x20,0x12,0x77,0x35,0xE1,	/* 4730: @ .w5 */
	0x12,0x77,0xE5,0x11,0x12,0x42,0xF7,0x41,	/* 4738: .w..BA */
	0x77,0xE9,0x77,0x31,0x24,0xF2,0xF4,0xAB,	/* 4740: ww1$ */
	0x20,0x77,0x31,0xD1,0x77,0x31,0x31,0x77,	/* 4748:  w1w11w */
	0xE1,0x09,0x20,0x77,0x30,0x41,0xF2,0x77,	/* 4750: . w0Aw */
	0xE0,0x05,0x20,0x10,0x71,0x42,0xFB,0x40,	/* 4758: . .qB@ */
	0x77,0xE9,0x77,0x3A,0x24,0xF2,0xF4,0xA6,	/* 4760: ww:$ */
	0x20,0x10,0x77,0x5A,0x42,0xFB,0x41,0xD1,	/* 4768:  .wZBA */
	0x77,0x34,0x24,0xF2,0xF4,0xC0,0xA7,0x20,	/* 4770: w4$  */
	0x41,0x77,0xE3,0x40,0xAD,0x20,0x77,0x34,	/* 4778: Aw@ w4 */
	0x31,0x77,0x34,0xD2,0x77,0xE4,0x11,0x72,	/* 4780: 1w4w.r */
	0x42,0xFB,0xB5,0x22,0xF0,0x77,0x36,0xC1,	/* 4788: B"w6 */
	0xA7,0x20,0x40,0x77,0xE6,0x40,0x22,0xA2,	/* 4790:  @w@" */
	0x24,0xF2,0x24,0xF2,0xD3,0xD4,0x77,0x37,	/* 4798: $$w7 */
	0x24,0xF2,0xF4,0xC0,0xAA,0x20,0x13,0x13,	/* 47A0: $ .. */
	0x77,0xE7,0x77,0xE8,0x40,0xA8,0x20,0x13,	/* 47A8: ww@ . */
	0x77,0x38,0xE1,0x13,0x77,0xE8,0x12,0x13,	/* 47B0: w8.w.. */
	0x42,0xF7,0x77,0x39,0xA6,0x20,0x11,0x77,	/* 47B8: Bw9 .w */
	0x5A,0x42,0xF7,0x77,0x31,0x24,0xF2,0xF4,	/* 47C0: ZBw1$ */
	0xAB,0x20,0x77,0x31,0xD2,0x77,0x31,0x31,	/* 47C8:  w1w11 */
	0x77,0xE1,0x09,0x20,0x77,0x30,0x41,0xF2,	/* 47D0: w. w0A */
	0x77,0xE0,0x05,0x20,0x10,0x72,0x42,0xFB,	/* 47D8: w. .rB */
	0x41,0xD2,0x77,0x37,0x24,0xF2,0xF4,0xC0,	/* 47E0: Aw7$ */
	0xA7,0x20,0x41,0x77,0xE6,0x40,0xAD,0x20,	/* 47E8:  Aw@  */
	0x77,0x37,0x31,0x77,0x37,0xD3,0x77,0xE7,	/* 47F0: w71w7w */
	0x12,0x73,0x42,0xFB,0xB5,0x22,0xF0,0x60,	/* 47F8: .sB"` */
	0xBF,0x22,0xF9,0x41,0x73,0x24,0xF6,0x21,	/* 4800: "As$! */
	0xA5,0x72,0xD0,0x74,0x73,0x60,0x8F,0x10,	/* 4808: rts`. */
	0x25,0xF5,0x21,0x93,0x70,0x72,0xF4,0xC0,	/* 4810: %!pr */
	0x41,0x24,0xFD,0x25,0xF5,0x04,0x74,0x73,	/* 4818: A$%.ts */
	0x72,0xF7,0x22,0xF9,0xB1,0x22,0xF0,0x27,	/* 4820: r""' */
	0x22,0x06,0x20,0x22,0xF9,0x41,0x72,0x24,	/* 4828: ". "Ar$ */
	0xF6,0xA9,0x73,0x72,0x60,0x8F,0x71,0x25,	/* 4830: sr`q% */
	0xF5,0x99,0x04,0x73,0x72,0x71,0xFB,0x22,	/* 4838: .srq" */
	0xF9,0x22,0xF0,0x27,0x20,0x03,0x20,0x01,	/* 4840: "' . . */
	0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEF,	/* 4848: . */
	0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 4850: ....... */
	0x00,0x0F,0x27,0x02,0x04,0x15,0x00,0x14,	/* 4858: ..'..... */
	0x00,0x12,0x00,0x11,0x00,0x10,0x00,0x0F,	/* 4860: ........ */
	0x00,0x0E,0x00,0x0C,0x00,0x06,0x00,0x66,	/* 4868: .......f */
	0x00,0x71,0x29,0x53,0xD2,0x61,0x43,0x21,	/* 4870: .q)SaC! */
	0xFB,0x72,0x22,0x8F,0x41,0x24,0xFA,0x63,	/* 4878: r"A$c */
	0x44,0x21,0xFB,0x72,0x82,0x21,0x45,0x24,	/* 4880: D!r!E$ */
	0xFA,0x72,0x63,0x4F,0x21,0xFB,0x49,0x21,	/* 4888: rcO!I! */
	0x2F,0x97,0x22,0xF0,0x20,0x73,0x72,0xE0,	/* 4890: ." sr */
	0x24,0xF2,0x72,0xE1,0x41,0x72,0xE3,0x24,	/* 4898: $rAr$ */
	0xF2,0x72,0xE4,0x41,0x72,0xE6,0x24,0xF2,	/* 48A0: rAr$ */
	0x72,0xE7,0x40,0x72,0xE9,0x24,0xF2,0x72,	/* 48A8: r@r$r */
	0xEA,0x22,0xF0,0x41,0x72,0x30,0x40,0x24,	/* 48B0: "Ar0@$ */
	0xFF,0xF0,0xA8,0x40,0x21,0x4B,0xD2,0xD3,	/* 48B8: @!K */
	0x27,0x25,0x02,0x72,0x30,0x60,0x4F,0xF2,	/* 48C0: '%.r0`O */
	0x72,0xE0,0x22,0xF0,0x72,0x30,0x41,0xF2,	/* 48C8: r"r0A */
	0x72,0xE0,0x22,0xF0,0x20,0x46,0x01,0x71,	/* 48D0: r" F.q */
	0x2A,0x5B,0xD2,0x61,0x4D,0x21,0xFB,0x72,	/* 48D8: *[aM!r */
	0xE1,0x63,0x4E,0x21,0xFB,0x72,0xE0,0x22,	/* 48E0: cN!r" */
	0xF0,0x60,0xBA,0x78,0x24,0xF2,0xF4,0x24,	/* 48E8: `x$$ */
	0xA2,0x78,0x60,0x5E,0xD1,0x78,0x41,0x24,	/* 48F0: x`^xA$ */
	0xF6,0xC0,0x22,0xA1,0x77,0x2A,0x35,0x71,	/* 48F8: "w*5q */
	0xF9,0xC0,0x21,0xA9,0x77,0x2A,0x37,0x71,	/* 4900: !w*7q */
	0xF9,0x21,0xA2,0x71,0x30,0x24,0xF2,0x81,	/* 4908: !q0$ */
	0xF4,0xC0,0xAA,0x71,0x31,0x60,0x4C,0x24,	/* 4910: q1`L$ */
	0xF6,0x71,0x31,0xF4,0xA6,0x41,0x44,0x77,	/* 4918: q1ADw */
	0x26,0x2F,0x92,0x77,0x2A,0x5D,0x25,0xFA,	/* 4920: &.w*]% */
	0xD4,0x30,0x25,0xFA,0xD5,0xD0,0x77,0x2A,	/* 4928: 0%w* */
	0x3E,0xD2,0x06,0xB6,0x22,0xF0,0x70,0x30,	/* 4930: >."p0 */
	0xD0,0x70,0x72,0xF4,0xA7,0x71,0x70,0x30,	/* 4938: prqp0 */
	0xF9,0xA2,0x60,0x02,0x70,0x30,0x25,0xFA,	/* 4940: `.p0% */
	0xD3,0x75,0xF4,0xA7,0x71,0x71,0x31,0xF2,	/* 4948: uqq1 */
	0x73,0xF4,0xA5,0x73,0x71,0xE0,0x21,0x06,	/* 4950: ssq!. */
	0x73,0x72,0xF4,0xC0,0xA4,0x20,0x71,0x74,	/* 4958: sr qt */
	0xE1,0x70,0x30,0x31,0x71,0x31,0xF2,0x71,	/* 4960: p01q1q */
	0xE1,0x70,0x30,0x30,0x71,0xE0,0x70,0x70,	/* 4968: p00qpp */
	0x31,0xF2,0x71,0xF4,0x21,0xA0,0x71,0x70,	/* 4970: 1q!qp */
	0xE0,0x71,0x30,0x74,0x30,0xF4,0xC0,0x21,	/* 4978: q0t0! */
	0xA7,0x71,0x74,0xE1,0x21,0x02,0x71,0x31,	/* 4980: qt!.q1 */
	0x70,0x31,0xF2,0x70,0xE1,0x71,0x30,0x70,	/* 4988: p1pq0p */
	0xE0,0x70,0x30,0x74,0x30,0xF4,0xA4,0x20,	/* 4990: p0t0  */
	0xB6,0x22,0xF0,0x70,0x74,0xE1,0xB6,0x22,	/* 4998: "pt" */
	0xF0,0x60,0xBE,0x73,0x2A,0x5D,0xD0,0x70,	/* 49A0: `s*]p */
	0x32,0x21,0xA8,0x70,0x60,0x3E,0xD1,0x70,	/* 49A8: 2!p`>p */
	0x53,0x73,0x21,0x92,0x74,0x73,0x6C,0x91,	/* 49B0: Ss!tsl */
	0x70,0x60,0x3F,0xD1,0x70,0x53,0x73,0x96,	/* 49B8: p`?pSs */
	0xB2,0x22,0xF0,0xB2,0x22,0xF0,0x75,0xF6,	/* 49C0: ""u */
	0x20,0x60,0xBE,0x73,0x2A,0x5D,0xD0,0x70,	/* 49C8:  `s*]p */
	0x5E,0x25,0xFA,0x25,0xFA,0xD1,0xE0,0x71,	/* 49D0: ^%%q */
	0x70,0xE0,0x71,0x70,0xE1,0x40,0x71,0xE1,	/* 49D8: pqp@q */
	0x41,0x70,0x53,0x73,0x61,0x2A,0x9E,0x74,	/* 49E0: ApSsa*t */
	0x70,0x60,0xEA,0x75,0x74,0xF2,0x70,0x60,	/* 49E8: p`utp` */
	0xEB,0x41,0x70,0xE2,0x76,0xA8,0x40,0x70,	/* 49F0: Apv@p */
	0x60,0xE3,0x74,0x70,0x60,0xE8,0xB2,0x22,	/* 49F8: `tp`" */
	0xF0,0x40,0x71,0x2A,0xEF,0x22,0xF0,0x0E,	/* 4A00: @q*". */
	0x00,0x0D,0x00,0x0B,0x00,0x0A,0x00,0x08,	/* 4A08: ........ */
	0x00,0x07,0x00,0x05,0x00,0x04,0x00,0x01,	/* 4A10: ........ */
	0x00,0x00,0x00,0x6A,0x00,0x71,0x2A,0x5D,	/* 4A18: ...j.q*] */
	0xD2,0x72,0x61,0x41,0x21,0xFB,0x4A,0x26,	/* 4A20: raA!J& */
	0x90,0x22,0xF0,0x00,0x00,0x00,0x00,0x00,	/* 4A28: "..... */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 4A30: ........ */
	0x00,0x00,0x00,0x60,0xBE,0x41,0x75,0x76,	/* 4A38: ...`Auv */
	0x24,0xFF,0xF0,0x21,0xA7,0x74,0xD0,0x75,	/* 4A40: $!tu */
	0x74,0xF2,0xD1,0x71,0x70,0xF9,0x21,0xA0,	/* 4A48: tqp! */
	0x40,0x70,0xE0,0x70,0x51,0xD0,0x71,0x70,	/* 4A50: @ppQqp */
	0xF9,0xA6,0x60,0x04,0x41,0xB2,0x22,0xF0,	/* 4A58: `.A" */
	0x73,0x21,0x9C,0xD0,0x70,0x30,0xAF,0x70,	/* 4A60: s!p0p */
	0x30,0x70,0xF2,0xD0,0x70,0x51,0xD1,0x73,	/* 4A68: 0ppQs */
	0x99,0x70,0x30,0xA2,0x60,0x01,0x40,0xB2,	/* 4A70: p0`.@ */
	0x22,0xF0,0x75,0xF6,0x20,0x04,0xBB,0x60,	/* 4A78: "u .` */
	0x4A,0x21,0xFB,0x22,0xF0,0x7E,0x02,0x22,	/* 4A80: J!"~." */
	0xF0,0x71,0x60,0x8F,0xD1,0x71,0x60,0x4F,	/* 4A88: q`q`O */
	0xF9,0x21,0xA4,0x24,0xF2,0x71,0x72,0xFA,	/* 4A90: !$qr */
	0x30,0x73,0xFA,0xE0,0x71,0x60,0x8F,0xD1,	/* 4A98: 0sq` */
	0x71,0x60,0x4F,0xF9,0xA2,0x61,0x0C,0x22,	/* 4AA0: q`Oa." */
	0xF0,0x60,0xB4,0x7D,0x2B,0x5D,0xD0,0x7E,	/* 4AA8: `}+]~ */
	0x7F,0x24,0xFB,0xAE,0x1E,0x2E,0x44,0x21,	/* 4AB0: $..D! */
	0xFB,0x23,0x2F,0x92,0xAB,0x60,0x4F,0xBC,	/* 4AB8: #.`O */
	0x22,0xF0,0x70,0x61,0x3A,0xBC,0x22,0xF0,	/* 4AC0: "pa:" */
	0x40,0x7E,0x41,0x23,0xF7,0xD8,0x7F,0x40,	/* 4AC8: @~A#@ */
	0x23,0xF7,0xD9,0x78,0x60,0x4E,0x24,0xF6,	/* 4AD0: #x`N$ */
	0xD6,0x79,0xD7,0x2C,0x42,0x21,0xFB,0x16,	/* 4AD8: y,B!. */
	0x14,0x22,0x24,0x9B,0x70,0x61,0x3E,0xDA,	/* 4AE0: ."$pa> */
	0x70,0x7D,0x21,0x2F,0x92,0x10,0xD3,0x70,	/* 4AE8: p}!..p */
	0x61,0x33,0x21,0xA8,0x70,0x61,0x34,0x73,	/* 4AF0: a3!pa4s */
	0xF9,0xC0,0xA6,0x73,0x70,0x61,0x35,0xF9,	/* 4AF8: spa5 */
	0xA5,0x70,0x61,0x32,0xD1,0x02,0x73,0xD1,	/* 4B00: pa2.s */
	0x71,0x69,0x5A,0xD1,0x70,0x61,0x3A,0xD2,	/* 4B08: qiZpa: */
	0x70,0x61,0x3B,0x21,0xFD,0xDA,0xDB,0x70,	/* 4B10: pa;!p */
	0x61,0x3A,0x21,0xFD,0xD8,0xD9,0x40,0x7A,	/* 4B18: a:!@z */
	0x78,0x24,0xFF,0xD6,0x7B,0x79,0x24,0xFF,	/* 4B20: x${y$ */
	0xD7,0x16,0x1E,0x23,0x28,0x90,0xC0,0x22,	/* 4B28: ..#(" */
	0xAA,0x70,0x61,0x3B,0x24,0xF2,0xF4,0x22,	/* 4B30: pa;$" */
	0xA2,0x70,0x61,0x33,0x22,0xAB,0x71,0x21,	/* 4B38: pa3"q! */
	0xFD,0xD8,0xD9,0x70,0x61,0x3A,0x21,0xFD,	/* 4B40: pa:! */
	0xD6,0xD7,0x40,0x78,0x76,0x24,0xFF,0xDA,	/* 4B48: @xv$ */
	0x79,0x77,0x24,0xFF,0xDB,0x1A,0x1E,0x23,	/* 4B50: yw$..# */
	0x25,0x94,0xAE,0x70,0x61,0x3F,0xD6,0x70,	/* 4B58: %pa?p */
	0x7D,0x21,0x27,0x9D,0x60,0x4F,0xBC,0x22,	/* 4B60: }!'`O" */
	0xF0,0x75,0x74,0x41,0x23,0xF6,0xDA,0xDB,	/* 4B68: utA# */
	0x70,0x61,0x3A,0x21,0xFD,0xD6,0xD7,0x40,	/* 4B70: pa:!@ */
	0x7A,0x76,0x23,0xF7,0xD8,0x7B,0x77,0x23,	/* 4B78: zv#{w# */
	0xF7,0xD9,0x78,0x70,0x61,0xEA,0x70,0x61,	/* 4B80: xpapa */
	0x33,0xA6,0x70,0x61,0x3A,0x70,0x61,0xE4,	/* 4B88: 3pa:pa */
	0x70,0x61,0x3F,0xD6,0x70,0x7D,0x21,0x24,	/* 4B90: pa?p}!$ */
	0x98,0x72,0xBC,0x22,0xF0,0x00,0x00,0x00,	/* 4B98: r"... */
	0x00,0x02,0x00,0x00,0x00,0x60,0xBD,0x75,	/* 4BA0: .....`u */
	0xD2,0x41,0x74,0x2A,0x3A,0x75,0x24,0xFF,	/* 4BA8: At*:u$ */
	0xF0,0xC0,0xA4,0x74,0x2A,0x3A,0xD5,0x75,	/* 4BB0: t*:u */
	0xD0,0x40,0x25,0xFA,0xD1,0x70,0x74,0x61,	/* 4BB8: @%pta */
	0x2E,0x97,0x25,0xFA,0xD0,0x60,0x4F,0xF4,	/* 4BC0: .%`O */
	0xC0,0x22,0xA2,0x41,0x75,0x72,0x24,0xFF,	/* 4BC8: "Aur$ */
	0xF0,0xA5,0x24,0xF2,0xB3,0x22,0xF0,0x72,	/* 4BD0: $"r */
	0x25,0xFA,0xD5,0xD0,0x40,0x25,0xFA,0xD1,	/* 4BD8: %@% */
	0x70,0x74,0x61,0x2C,0x94,0x25,0xFA,0xD0,	/* 4BE0: pta,% */
	0x60,0x4F,0xF4,0x22,0xA4,0x75,0x70,0xE1,	/* 4BE8: `O"up */
	0x74,0x2A,0x5D,0x25,0xFA,0xD2,0x31,0x25,	/* 4BF0: t*]%1% */
	0xFA,0x25,0xFA,0xD1,0x31,0xF2,0x70,0xF4,	/* 4BF8: %1p */
	0x21,0xA4,0x70,0x71,0xE0,0x70,0x72,0xE1,	/* 4C00: !pqpr */
	0x72,0x30,0x72,0x31,0xE0,0x70,0xB3,0x22,	/* 4C08: r0r1p" */
	0xF0,0x24,0xF2,0xB3,0x22,0xF0,0x75,0x71,	/* 4C10: $"uq */
	0x31,0xF2,0x71,0xE1,0x72,0x31,0xB3,0x22,	/* 4C18: 1qr1" */
	0xF0,0x60,0xBB,0x40,0xD1,0x77,0x21,0xAB,	/* 4C20: `@w! */
	0x77,0x52,0x60,0x4D,0xF4,0x60,0x4C,0x24,	/* 4C28: wR`M`L$ */
	0xF6,0xD7,0x76,0x2A,0x5D,0x25,0xFA,0xD2,	/* 4C30: v*]% */
	0x30,0x25,0xFA,0xD3,0x30,0xD0,0x71,0xC0,	/* 4C38: 0%0q */
	0x25,0xAB,0x05,0x24,0xF2,0xB5,0x22,0xF0,	/* 4C40: %.$" */
	0x70,0x72,0x30,0xF4,0x23,0xAA,0x41,0x77,	/* 4C48: pr0#Aw */
	0x70,0x31,0x24,0xFF,0xF0,0x22,0xAB,0x70,	/* 4C50: p1$"p */
	0x31,0x77,0xF4,0xAF,0x70,0x31,0x77,0xF4,	/* 4C58: 1wp1w */
	0x70,0xE1,0x70,0x70,0x31,0xF2,0xD0,0x77,	/* 4C60: ppp1w */
	0x70,0xE1,0x04,0x70,0x30,0x73,0xE0,0x24,	/* 4C68: p.p0s$ */
	0xF2,0x81,0x70,0xE0,0x70,0x72,0x31,0xF4,	/* 4C70: ppr1 */
	0xC0,0xA3,0x73,0x72,0xE1,0x70,0x52,0xD4,	/* 4C78: srpR */
	0x41,0xD1,0x70,0xD3,0x70,0x30,0xD0,0x0B,	/* 4C80: App0. */
	0x77,0x76,0x6E,0x99,0x25,0xFA,0xD0,0x24,	/* 4C88: wvn%$ */
	0xF2,0xF4,0xA5,0x71,0xC0,0xA7,0x64,0x00,	/* 4C90: qd. */
	0x24,0xF2,0xB5,0x22,0xF0,0x74,0xB5,0x22,	/* 4C98: $"t" */
	0xF0,0x60,0xBD,0x74,0x2B,0x5D,0xD1,0x71,	/* 4CA0: `t+]q */
	0x60,0x32,0xC0,0x21,0xA1,0x71,0x61,0x3C,	/* 4CA8: `2!qa< */
	0x22,0xA8,0x40,0xD0,0x71,0x61,0x39,0x71,	/* 4CB0: "@qa9q */
	0x61,0x38,0x74,0x62,0x20,0x9B,0x71,0x61,	/* 4CB8: a8tb qa */
	0x3E,0xD0,0x71,0x60,0x53,0x74,0x21,0x9B,	/* 4CC0: >q`St! */
	0x75,0x74,0x6A,0x95,0xD0,0x71,0x61,0x3F,	/* 4CC8: utjqa? */
	0xD2,0x71,0x60,0x53,0x74,0x9F,0x70,0xB3,	/* 4CD0: q`Stp */
	0x22,0xF0,0x24,0xF2,0xB3,0x22,0xF0,0x7E,	/* 4CD8: "$"~ */
	0xF6,0x7A,0xF6,0x74,0xF6,0x76,0xF6,0x01,	/* 4CE0: ztv. */
	0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,	/* 4CE8: ........ */
	0x00,0x00,0x00,0x01,0x20,0x0A,0x00,0x08,	/* 4CF0: .... ... */
	0x00,0x07,0x00,0x05,0x00,0x04,0x00,0x02,	/* 4CF8: ........ */
	0x00,0x01,0x00,0xFE,0x02,0x71,0x2B,0x5D,	/* 4D00: ....q+] */
	0xD2,0x62,0x4A,0x21,0xFB,0x72,0x4D,0x24,	/* 4D08: bJ!rM$ */
	0xFA,0x72,0x62,0x4F,0x21,0xFB,0x47,0x62,	/* 4D10: rbO!Gb */
	0x26,0x9F,0x22,0xF0,0x20,0x20,0x60,0xBB,	/* 4D18: &"  ` */
	0x78,0xD0,0x77,0x11,0x13,0x23,0x94,0x11,	/* 4D20: xw..#. */
	0x76,0x44,0x24,0xFA,0xB5,0x22,0xF0,0x60,	/* 4D28: vD$"` */
	0xBB,0x77,0x30,0x77,0x31,0x24,0xF2,0xF4,	/* 4D30: w0w1$ */
	0x24,0xFB,0xC0,0x21,0xA0,0x78,0x30,0x60,	/* 4D38: $!x0` */
	0x4F,0xF4,0x78,0x31,0x60,0x4F,0xF4,0x24,	/* 4D40: Ox1`O$ */
	0xFB,0xC0,0xA2,0x21,0xF0,0x78,0xD0,0x77,	/* 4D48: !xw */
	0x13,0x11,0x98,0x11,0x76,0x44,0x24,0xFA,	/* 4D50: ...vD$ */
	0xB5,0x22,0xF0,0x60,0xB4,0x40,0xDA,0x40,	/* 4D58: "`@@ */
	0xDB,0x24,0xF2,0x7F,0x31,0x24,0xF6,0x21,	/* 4D60: $1$! */
	0xA3,0x41,0xDA,0x40,0x40,0x7F,0x30,0x24,	/* 4D68: A@@0$ */
	0xFF,0xD8,0xD1,0x71,0x40,0x7F,0x31,0x24,	/* 4D70: q@1$ */
	0xFF,0xD9,0xD1,0x08,0x40,0xDA,0x7F,0x30,	/* 4D78: .@0 */
	0xD8,0x7F,0x31,0xD9,0x24,0xF2,0x21,0x70,	/* 4D80: 1$!p */
	0x31,0x24,0xF6,0x21,0xA6,0x7A,0xC0,0xDB,	/* 4D88: 1$!z */
	0x40,0x40,0x21,0x70,0x30,0x24,0xFF,0xD6,	/* 4D90: @@!p0$ */
	0xD1,0x71,0x40,0x21,0x70,0x31,0x24,0xFF,	/* 4D98: q@!p1$ */
	0xD7,0xD1,0x0A,0x7A,0xDB,0x21,0x70,0x30,	/* 4DA0: .z!p0 */
	0xD6,0x21,0x70,0x31,0xD7,0x16,0xD0,0x18,	/* 4DA8: !p1.. */
	0x12,0x14,0x22,0x9D,0x7B,0xAE,0x40,0x40,	/* 4DB0: .."{@@ */
	0x74,0x24,0xFF,0xD4,0xD1,0x71,0x40,0x75,	/* 4DB8: t$q@u */
	0x24,0xFF,0xD5,0xD1,0x7A,0xAE,0x40,0x40,	/* 4DC0: $z@@ */
	0x72,0x24,0xFF,0xD2,0xD1,0x71,0x40,0x73,	/* 4DC8: r$q@s */
	0x24,0xFF,0xD3,0xD1,0x14,0x7D,0x44,0x24,	/* 4DD0: $.}D$ */
	0xFA,0x12,0x7E,0x44,0x24,0xFA,0xBC,0x22,	/* 4DD8: .~D$" */
	0xF0,0x60,0xB6,0x7E,0x30,0xC0,0xA8,0x7E,	/* 4DE0: `~0~ */
	0x31,0xC0,0xA4,0x21,0xF0,0x2B,0x0B,0x7E,	/* 4DE8: 1!+.~ */
	0x31,0xC0,0x21,0xAA,0x40,0x7D,0x31,0x7E,	/* 4DF0: 1!@}1~ */
	0x30,0x21,0xFA,0x7B,0xE1,0xD2,0x72,0x7D,	/* 4DF8: 0!{r} */
	0x30,0x7E,0x30,0x21,0xFA,0x7B,0xE0,0x7C,	/* 4E00: 0~0!{| */
	0xE0,0x40,0x7C,0xE1,0x29,0x0C,0x7E,0x31,	/* 4E08: @|).~1 */
	0x7E,0x30,0x21,0xF9,0xD4,0xD5,0xD6,0x76,	/* 4E10: ~0!v */
	0xC0,0xAA,0x40,0xD3,0x7D,0x31,0xD2,0x7D,	/* 4E18: @}1} */
	0x30,0xD1,0x21,0x01,0x40,0x7D,0x31,0x76,	/* 4E20: 0!.@}1v */
	0x23,0xF6,0xD0,0xD3,0x7D,0x31,0x7D,0x30,	/* 4E28: #}1}0 */
	0x76,0x23,0xF6,0xD1,0xD2,0x40,0x7B,0xE1,	/* 4E30: v#@{ */
	0x73,0x75,0xF4,0xC0,0xA5,0x60,0x4F,0x7B,	/* 4E38: su`O{ */
	0xE0,0x08,0x73,0x72,0x75,0x21,0xFA,0x7B,	/* 4E40: .sru!{ */
	0xE0,0xD0,0x7B,0x30,0x24,0xA9,0x40,0x74,	/* 4E48: {0$@t */
	0x7B,0x30,0x23,0xF1,0xD7,0xD8,0x78,0x75,	/* 4E50: {0#xu */
	0x7B,0x30,0x23,0xF1,0xD8,0xD9,0x40,0x71,	/* 4E58: {0#@q */
	0x77,0x24,0xFF,0xD1,0xD0,0x70,0x72,0x78,	/* 4E60: w$prx */
	0x24,0xFF,0xD2,0xD0,0x70,0x73,0x79,0x24,	/* 4E68: $psy$ */
	0xFF,0xD3,0xD0,0x24,0xF2,0x73,0x24,0xF6,	/* 4E70: $s$ */
	0x21,0xAD,0x7B,0x30,0x60,0x8F,0x7B,0xE0,	/* 4E78: !{0`{ */
	0x40,0x74,0x71,0x23,0xF7,0xD1,0xD0,0x70,	/* 4E80: @tq#p */
	0x75,0x72,0x23,0xF7,0xD2,0xD0,0x70,0x40,	/* 4E88: ur#p@ */
	0x73,0x23,0xF7,0xD3,0xD0,0x62,0x0C,0x76,	/* 4E90: s#b.v */
	0xC0,0xA7,0x71,0x7C,0xE0,0x72,0x7C,0xE1,	/* 4E98: q|r| */
	0x09,0x72,0x71,0x76,0x23,0xF5,0x7C,0xE0,	/* 4EA0: .rqv#| */
	0x7C,0xE1,0xBA,0x22,0xF0,0x20,0x40,0xD3,	/* 4EA8: |" @ */
	0x71,0x31,0x72,0x31,0xF4,0xC0,0xAF,0x24,	/* 4EB0: q1r1$ */
	0xF2,0x71,0x30,0x23,0xF3,0x24,0xF2,0x72,	/* 4EB8: q0#$r */
	0x30,0x23,0xF3,0xF9,0xD3,0x06,0x71,0x31,	/* 4EC0: 0#.q1 */
	0x72,0x31,0xF9,0xD3,0x73,0x22,0xF0,0x60,	/* 4EC8: r1s"` */
	0xBE,0x74,0xD1,0x76,0x25,0xA0,0x41,0x21,	/* 4ED0: tv%A! */
	0x40,0x76,0x24,0xFF,0xF0,0xA4,0x21,0x40,	/* 4ED8: @v$!@ */
	0xD3,0x02,0x76,0xD3,0x40,0xD0,0x73,0x40,	/* 4EE0: .v@s@ */
	0xF9,0x21,0xA0,0x75,0x70,0x74,0xF2,0x23,	/* 4EE8: !upt# */
	0xFB,0x70,0x81,0xD0,0x73,0x70,0xF9,0xA3,	/* 4EF0: psp */
	0x20,0x60,0x00,0x73,0xD5,0x76,0x73,0xF4,	/* 4EF8:  `.svs */
	0xD6,0x76,0x22,0xA2,0x41,0x75,0x76,0x24,	/* 4F00: v"Auv$ */
	0xFF,0xF0,0xA5,0x20,0x75,0xD3,0x03,0x20,	/* 4F08:  u.  */
	0x76,0xD3,0x74,0x75,0x74,0xF2,0x73,0x24,	/* 4F10: vtuts$ */
	0xFA,0x73,0x75,0xF5,0xD5,0x76,0x73,0xF4,	/* 4F18: suvs */
	0xD6,0x76,0xA3,0x20,0x62,0x0E,0x71,0xB2,	/* 4F20: v b.q */
	0x22,0xF0,0x20,0x70,0x72,0xE0,0x10,0x72,	/* 4F28: " pr.r */
	0xE1,0x40,0x22,0xF0,0x72,0x30,0x72,0x31,	/* 4F30: @"r0r1 */
	0xE0,0x73,0xC0,0xA2,0x41,0xD3,0x73,0x72,	/* 4F38: sAsr */
	0x31,0xE1,0x72,0x31,0x23,0xFC,0x71,0x22,	/* 4F40: 1r1#q" */
	0xF0,0x22,0xF9,0x72,0x31,0xF6,0x22,0xF0,	/* 4F48: "r1" */
	0x22,0xF9,0x72,0x31,0xF6,0x22,0xF0,0x40,	/* 4F50: "r1"@ */
	0x40,0x60,0xBB,0x73,0x36,0x73,0x34,0x60,	/* 4F58: @`s6s4` */
	0xEF,0x10,0x73,0x57,0x41,0xFB,0x21,0xF5,	/* 4F60: .sWA! */
	0x20,0x60,0xBF,0x73,0x57,0x21,0xF2,0xD0,	/* 4F68:  `sW! */
	0x70,0x24,0xF2,0xF4,0xA4,0x40,0xB1,0x22,	/* 4F70: p$@" */
	0xF0,0x41,0xB1,0x22,0xF0,0x72,0x71,0x61,	/* 4F78: A"rqa */
	0x98,0xA5,0x41,0x4B,0x71,0x28,0x9E,0x63,	/* 4F80: AKq(c */
	0x4E,0x21,0xFB,0x72,0x34,0xE0,0x70,0x72,	/* 4F88: N!r4pr */
	0xE1,0x72,0x34,0x21,0xFE,0x24,0xFB,0x23,	/* 4F90: r4!$# */
	0xF9,0x22,0xF0,0x72,0x71,0x63,0x9A,0xA5,	/* 4F98: "rqc */
	0x41,0x4B,0x71,0x27,0x90,0x64,0x40,0x21,	/* 4FA0: AKq'd@! */
	0xFB,0x72,0x34,0xE0,0x70,0x72,0xE1,0x72,	/* 4FA8: r4prr */
	0x34,0x60,0x4E,0x24,0xF6,0x23,0xF9,0x22,	/* 4FB0: 4`N$#" */
	0xF0,0x72,0x71,0x65,0x9C,0xA5,0x41,0x4B,	/* 4FB8: rqeAK */
	0x71,0x25,0x92,0x66,0x42,0x21,0xFB,0x72,	/* 4FC0: q%fB!r */
	0x34,0xE0,0x70,0x72,0xE1,0x72,0x34,0x41,	/* 4FC8: 4prr4A */
	0x24,0xFB,0x23,0xF9,0x22,0xF0,0x20,0x72,	/* 4FD0: $#" r */
	0xA5,0x72,0x71,0x29,0xED,0x07,0x22,0x27,	/* 4FD8: rq)."' */
	0x20,0x4F,0x71,0x29,0xED,0x72,0x71,0x29,	/* 4FE0:  Oq)rq) */
	0x5B,0xD2,0xD3,0x6B,0x07,0x71,0x2C,0x38,	/* 4FE8: [k.q,8 */
	0x24,0xF2,0xF4,0xA6,0x71,0x2C,0x38,0xD3,	/* 4FF0: $q,8 */
	0x71,0x92,0x62,0x0B,0x77,0xF6,0x20,0x00,	/* 4FF8: qb.w . */
	0x00,0x00,0x00,0x71,0x2C,0x58,0xD2,0x72,	/* 5000: ...q,Xr */
	0x60,0x43,0x21,0xFB,0x41,0x65,0x27,0x99,	/* 5008: `C!Ae' */
	0x22,0xF0,0x20,0x21,0x02,0x60,0xBE,0x24,	/* 5010: " !.`$ */
	0xF2,0xD0,0x75,0xD1,0x24,0xF2,0x24,0xF2,	/* 5018: u$$ */
	0x73,0x60,0x90,0xB2,0x22,0xF0,0x20,0x25,	/* 5020: s`" % */
	0xF8,0x21,0xF0,0x22,0xF0,0x60,0xBA,0x40,	/* 5028: !"`@ */
	0x21,0xFE,0xF4,0x21,0xAE,0x24,0xF2,0xD4,	/* 5030: !!$ */
	0x10,0xD5,0x4B,0x21,0xFB,0xD2,0x40,0x13,	/* 5038: .K!@. */
	0x25,0xF2,0x23,0xF9,0x10,0x14,0x41,0xFB,	/* 5040: %#..A */
	0x24,0xF3,0x11,0x41,0x24,0xF8,0x24,0xF4,	/* 5048: $.A$$ */
	0x72,0x23,0xFC,0x79,0x7C,0x33,0xF2,0x7C,	/* 5050: r#y|3| */
	0xE3,0x77,0x7C,0xE6,0x78,0x7C,0xE7,0x40,	/* 5058: w|x|@ */
	0xD4,0x42,0xD5,0x74,0xC0,0xA4,0x7C,0x39,	/* 5060: Bt|9 */
	0xD1,0x03,0x7C,0x3A,0xD1,0x71,0x7A,0xF9,	/* 5068: .|:qz */
	0x25,0xAB,0x24,0xF2,0x71,0x23,0xF3,0xD0,	/* 5070: %$q# */
	0x70,0x41,0x24,0xF0,0xD2,0x72,0x24,0xF2,	/* 5078: pA$r$ */
	0xFA,0xD0,0x79,0x70,0x33,0xF2,0x70,0xE3,	/* 5080: yp3p */
	0x79,0x70,0x34,0xF2,0x70,0xE4,0x74,0x23,	/* 5088: yp4pt# */
	0xA5,0x22,0x40,0x70,0x31,0x24,0xF6,0xC0,	/* 5090: "@p1$ */
	0x22,0xAC,0x42,0x70,0x31,0x24,0xF6,0x21,	/* 5098: "Bp1$! */
	0xA4,0x70,0x37,0x4A,0x21,0xFB,0xF0,0xE0,	/* 50A0: p7J! */
	0x70,0x34,0x70,0x37,0x23,0xFC,0xD4,0xF6,	/* 50A8: p4p7# */
	0x70,0x23,0xFC,0x21,0x01,0x70,0x34,0x70,	/* 50B0: p#!.p4p */
	0x37,0x60,0xEF,0x41,0x70,0x31,0x24,0xF6,	/* 50B8: 7`Ap1$ */
	0xC0,0x70,0x37,0xF2,0x23,0xF9,0x70,0x3E,	/* 50C0: p7#p> */
	0xD3,0x73,0xD1,0x65,0x00,0x14,0x26,0x4F,	/* 50C8: se..&O */
	0x22,0xF1,0x21,0xF5,0xB6,0x22,0xF0,0x20,	/* 50D0: "!"  */
	0x60,0xBA,0x77,0x3F,0xD0,0x24,0xF2,0x70,	/* 50D8: `w?$p */
	0x23,0xF3,0xD1,0x71,0x41,0x24,0xF0,0xD5,	/* 50E0: #qA$ */
	0x75,0x24,0xF2,0xFA,0xD4,0x74,0x39,0xD1,	/* 50E8: u$t9 */
	0x71,0x74,0x34,0xF9,0x24,0xAC,0x24,0xF2,	/* 50F0: qt4$$ */
	0x71,0x23,0xF3,0xD0,0x70,0x41,0x24,0xF0,	/* 50F8: q#pA$ */
	0xD2,0x72,0x24,0xF2,0xFA,0xD0,0x22,0x40,	/* 5100: r$"@ */
	0x70,0x31,0x24,0xF6,0xC0,0x22,0xAC,0x42,	/* 5108: p1$"B */
	0x70,0x31,0x24,0xF6,0x21,0xA4,0x70,0x37,	/* 5110: p1$!p7 */
	0x4A,0x21,0xFB,0xF0,0xE0,0x70,0x34,0x70,	/* 5118: J!p4p */
	0x37,0x23,0xFC,0xD4,0xF6,0x70,0x23,0xFC,	/* 5120: 7#p# */
	0x21,0x01,0x70,0x34,0x70,0x37,0x60,0xEF,	/* 5128: !.p4p7` */
	0x41,0x70,0x31,0x24,0xF6,0xC0,0x70,0x37,	/* 5130: Ap1$p7 */
	0xF2,0x23,0xF9,0x70,0x3E,0xD3,0x73,0xD1,	/* 5138: #p>s */
	0x65,0x0E,0xB6,0x22,0xF0,0x20,0x20,0x65,	/* 5140: e."  e */
	0x2E,0x2F,0x00,0x20,0x20,0x60,0x08      	/* 5148: ...  `.  */

};
int si3_t225_dsize = sizeof(si3_t225_download);		/* 0x514F (20815) */

unsigned short si3_t225_downloadaddr = 0x0000;

/* End of SI3_T225.C */
