/*-
 * Copyright (c) 2007 Ariff Abdullah <ariff@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/7/sys/dev/sound/unit.h 170159 2007-05-31 18:35:24Z ariff $
 */

#ifndef _SND_UNIT_H_
#define _SND_UNIT_H_

#define SND_UNIT_UMIN	16
#define SND_UNIT_UMAX	2048

int snd_max_u(void);
int snd_max_d(void);
int snd_max_c(void);
int snd_unit2u(int);
int snd_unit2d(int);
int snd_unit2c(int);
int snd_u2unit(int);
int snd_d2unit(int);
int snd_c2unit(int);
int snd_mkunit(int, int, int);

void snd_unit_init(void);

#define SND_U_MASK	(snd_u2unit(snd_max_u()))
#define SND_D_MASK	(snd_d2unit(snd_max_d()))
#define SND_C_MASK	(snd_c2unit(snd_max_c()))

#endif /* !_SND_UNIT_H_ */
