/*-
 * Copyright (C) 2005 TAKAHASHI Yoshihiro. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/8/sys/mips/include/ppireg.h 215938 2010-11-27 12:26:40Z jchandra $
 */

#ifndef _MACHINE_PPIREG_H_
#define _MACHINE_PPIREG_H_

#ifdef _KERNEL

#define	IO_PPI		0x61	/* Programmable Peripheral Interface */

/*
 * PPI speaker control values
 */

#define	PIT_ENABLETMR2	0x01	/* Enable timer/counter 2 */
#define	PIT_SPKRDATA	0x02	/* Direct to speaker */

#define	PIT_SPKR	(PIT_ENABLETMR2 | PIT_SPKRDATA)

#define	ppi_spkr_on()	outb(IO_PPI, inb(IO_PPI) | PIT_SPKR)
#define	ppi_spkr_off()	outb(IO_PPI, inb(IO_PPI) & ~PIT_SPKR)

#endif /* _KERNEL */

#endif /* _MACHINE_PPIREG_H_ */
