/* key_data.h
 *
 * Copyright (C) 2006-2021 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */
#include "key_data.h"
#include "wolfssl_demo.h"

/*******************************************************************************
 * SCE Key Information
 *******************************************************************************/
const st_user_key_block_data_t g_key_block_data =
{
    /* uint8_t encrypted_provisioning_key[R_TSIP_AES_CBC_IV_BYTE_SIZE * 2]; */
    {
        0xE7, 0x1C, 0xEB, 0xCA, 0x3A, 0x64, 0x0B, 0xD2, 0xC5, 0xB8, 0xF2, 0xD0, 
        0xF7, 0x1B, 0xA9, 0x4A, 0x98, 0xFF, 0xF3, 0x48, 0x81, 0xAD, 0xAF, 0x63, 
        0x19, 0x24, 0x4B, 0x2B, 0xC0, 0x8B, 0x9C, 0x6B
    },
    /* uint8_t iv[R_TSIP_AES_CBC_IV_BYTE_SIZE]; */
    {
        0xD7, 0x97, 0x56, 0x82, 0x5B, 0x4B, 0x7F, 0xB2, 0x1C, 0x1F, 0xEE, 0x85, 
        0x02, 0xC5, 0xD0, 0xBA
    },
    /* uint8_t encrypted_user_rsa2048_ne_key[R_TSIP_RSA2048_NE_KEY_BYTE_SIZE + 16]; */
    {
        0x3F, 0xA5, 0xBE, 0xBF, 0x86, 0xEC, 0x23, 0x37, 0x82, 0x37, 0x71, 0x0C, 
        0x83, 0xA7, 0x8E, 0x86, 0xF0, 0x16, 0xD3, 0x7B, 0xF1, 0x25, 0xA4, 0x37, 
        0x7A, 0x2D, 0x16, 0xF2, 0xFF, 0x3D, 0xEE, 0x46, 0xE0, 0x05, 0x58, 0x56, 
        0xC2, 0xE7, 0x9D, 0x2C, 0x01, 0x84, 0x59, 0x8E, 0xA8, 0x9E, 0xEE, 0x3F,
        0x22, 0x83, 0x68, 0xDA, 0x9E, 0xCE, 0xEA, 0x99, 0xFD, 0xAF, 0xDF, 0x67,
        0x1E, 0x73, 0x25, 0x68, 0xBF, 0x0A, 0xDF, 0xAF, 0xC4, 0x3D, 0xF1, 0xBD, 
        0x41, 0xF5, 0xAC, 0xAC, 0xA4, 0x36, 0xF8, 0x96, 0xC0, 0x8C, 0x2F, 0x1A, 
        0x79, 0x75, 0x28, 0xAE, 0x67, 0xC9, 0x5A, 0xDE, 0x2A, 0xB4, 0x99, 0xDB,
        0x8C, 0x25, 0x53, 0x58, 0x8C, 0xDC, 0xA8, 0x0D, 0xFE, 0xEE, 0x0F, 0x6C, 
        0x61, 0xE6, 0x43, 0x66, 0xE8, 0x4A, 0xE3, 0xEB, 0xAB, 0xA2, 0x52, 0xE4, 
        0x67, 0xC2, 0x9A, 0x57, 0xA4, 0x1F, 0xE0, 0xFC, 0x2B, 0xBE, 0x25, 0xBF, 
        0xF0, 0x70, 0x18, 0x88, 0x93, 0xB7, 0x2F, 0x74, 0xF8, 0xF3, 0x88, 0xB8,
        0xFA, 0x18, 0xBE, 0xC1, 0xB2, 0x24, 0x4B, 0xBC, 0x89, 0x2D, 0xC4, 0x02, 
        0xB3, 0x82, 0xEC, 0xDB, 0xC9, 0xF0, 0xA9, 0xC3, 0x30, 0x7C, 0xF5, 0x15, 
        0xEB, 0x9B, 0x16, 0x8C, 0x9D, 0xEF, 0x42, 0x8A, 0xCA, 0x5D, 0x28, 0xDF, 
        0x68, 0xEA, 0xE0, 0xB8, 0x76, 0x7C, 0xBB, 0x4A, 0x51, 0xDD, 0x55, 0x14,
        0xB7, 0xAB, 0xD2, 0xF1, 0xB9, 0x51, 0x19, 0x05, 0x26, 0x87, 0xF7, 0x5C, 
        0x69, 0x45, 0x3C, 0x82, 0xE8, 0x82, 0x05, 0x5D, 0x33, 0x8E, 0xD1, 0x42, 
        0x71, 0xD6, 0x96, 0xDA, 0xAB, 0xB8, 0xC0, 0x0F, 0xF7, 0x85, 0x8A, 0x12, 
        0xEF, 0xB9, 0x53, 0xFF, 0xD2, 0x95, 0x18, 0x2F, 0x0C, 0xA6, 0x72, 0x98,
        0xC3, 0xC6, 0x9B, 0x95, 0x70, 0x69, 0xC5, 0xB7, 0xD5, 0x24, 0x77, 0x05, 
        0xD0, 0x68, 0x85, 0x36, 0xB8, 0x57, 0xE3, 0xED, 0x2E, 0x4D, 0x95, 0xD3, 
        0xFC, 0x24, 0x1B, 0x22, 0xFA, 0x43, 0xD8, 0x62, 0x28, 0x57, 0x6B, 0x34, 
        0xBF, 0xD1, 0x63, 0x4B, 0xB5, 0xF5, 0x88, 0xBC, 0xB8, 0x69, 0xF3, 0xB5
    },
};

#ifndef USE_CERT_BUFFERS_256
/* ca-cert.der.sign,  
 * ca-cert.der signed by RSA2048 PSS with SHA256 
 * This is used for Root Certificate verify by SCE */
const unsigned char ca_cert_der_sign[] =
{
        0x7C, 0xD5, 0x00, 0x40, 0x1A, 0x97, 0xAE, 0x31, 0xC0, 0x6B,
        0x5E, 0x65, 0x9B, 0x95, 0xB8, 0xC0, 0xC9, 0xC9, 0xF7, 0xC9,
        0xA2, 0x28, 0x39, 0xE7, 0x02, 0xF0, 0x4C, 0x3C, 0xE7, 0x8C,
        0x8E, 0x9C, 0xFC, 0x96, 0x74, 0xCD, 0xDE, 0xE8, 0x08, 0x9A,
        0x40, 0xD6, 0xE0, 0xC5, 0x20, 0x5B, 0xD8, 0xA6, 0x03, 0xA3,
        0x60, 0x37, 0xD8, 0x8B, 0x17, 0x6D, 0x47, 0x7E, 0x5D, 0x1C,
        0x75, 0x02, 0x08, 0x97, 0x14, 0x1E, 0x96, 0x3C, 0xEF, 0x76,
        0x63, 0x40, 0x99, 0x47, 0xFD, 0xDC, 0xF4, 0xB2, 0xA2, 0xDA,
        0x40, 0x75, 0x3C, 0x2C, 0x6A, 0xAC, 0x11, 0xE3, 0xE8, 0xDC,
        0x8F, 0xCB, 0xD1, 0xC5, 0x35, 0x57, 0x8C, 0x4A, 0x4C, 0xFB,
        0xAE, 0xF4, 0x5F, 0x32, 0xCE, 0xD2, 0x67, 0x69, 0x9D, 0x08,
        0x0A, 0x1A, 0x34, 0xB7, 0x27, 0x7D, 0xFB, 0xED, 0xE4, 0x84,
        0x18, 0xAD, 0xCA, 0xBA, 0xE1, 0x45, 0xAA, 0x15, 0xC8, 0x08,
        0x2B, 0x2F, 0x64, 0x83, 0x3A, 0xC3, 0x5B, 0x6F, 0xA6, 0xEB,
        0x07, 0x14, 0xCA, 0x0B, 0x5B, 0x64, 0x6F, 0x75, 0xE5, 0xDF,
        0x53, 0x33, 0xFD, 0xC3, 0xC2, 0x75, 0xA9, 0xA4, 0x3B, 0x4E,
        0x8E, 0xFC, 0x43, 0xB9, 0x03, 0x56, 0xBB, 0x12, 0xD3, 0x64,
        0x65, 0x1E, 0x79, 0x18, 0xC8, 0x29, 0x3C, 0xB2, 0x9F, 0x5B,
        0x3B, 0x0B, 0x7A, 0x59, 0x43, 0xBB, 0x2A, 0xEF, 0xF0, 0x2C,
        0x50, 0xCD, 0x0C, 0xC5, 0x0E, 0x08, 0x5C, 0xB0, 0x31, 0xD4,
        0x9C, 0xF4, 0xE2, 0x45, 0xC3, 0x4C, 0xBB, 0x29, 0x44, 0x13,
        0x89, 0xE2, 0x7F, 0xD7, 0xE5, 0x7C, 0x2D, 0x89, 0xCA, 0xD4,
        0xB0, 0x2E, 0xAF, 0x2C, 0x8D, 0x84, 0x87, 0x30, 0x40, 0x4D,
        0xC5, 0x42, 0x6A, 0x1C, 0xF3, 0x6A, 0x24, 0xE5, 0x48, 0xA5,
        0x53, 0x74, 0x87, 0xA0, 0xE5, 0x69, 0xF1, 0xD1, 0x7A, 0x85,
        0x5E, 0x14, 0xD1, 0x00, 0x8A, 0xD2
};

const int sizeof_ca_cert_der_sign = sizeof(ca_cert_der_sign);
#else
/* ca-ecc-cert.der.sign,  
 * ca-ecc-cert.der signed by RSA2048 PSS with SHA256 
 * This is used for Root Certificate verify by SCE
 */
const unsigned char ca_ecc_cert_der_sign[] =
{
        0x6B, 0x56, 0xCA, 0x33, 0x2A, 0x87, 0xEC, 0x82, 0x64, 0x8A,
        0xFF, 0x64, 0x5B, 0xAF, 0x10, 0xEB, 0x0A, 0xC1, 0x6F, 0xDF,
        0x22, 0xC7, 0x90, 0xE5, 0xAB, 0x13, 0xB4, 0xC5, 0xA4, 0x95,
        0x48, 0x52, 0x58, 0xE3, 0xF9, 0x00, 0xD6, 0x0E, 0xCC, 0xB2,
        0xAB, 0xCC, 0x3A, 0x0D, 0x75, 0x27, 0x1F, 0xBB, 0x33, 0xC2,
        0x04, 0xB3, 0x0D, 0x4D, 0xAF, 0x53, 0x2D, 0xF9, 0x1F, 0x3A,
        0x4D, 0xBC, 0x68, 0x91, 0xF9, 0x50, 0x73, 0xE2, 0x67, 0x65,
        0xF0, 0xB0, 0xCF, 0xF9, 0xDB, 0xA8, 0x6B, 0x97, 0x31, 0x86,
        0x36, 0x67, 0x25, 0xF4, 0x59, 0xA2, 0x87, 0xF7, 0x86, 0x09,
        0x13, 0x0C, 0x8B, 0x3F, 0x3C, 0x10, 0xCE, 0x37, 0x26, 0x6C,
        0xED, 0x1F, 0x8B, 0x23, 0x9B, 0x07, 0x5A, 0x56, 0xA9, 0xDB,
        0xB1, 0x81, 0xA2, 0xDC, 0x82, 0xE6, 0xC7, 0x8F, 0x97, 0xDF,
        0x3E, 0x11, 0x4C, 0x74, 0x2C, 0xC3, 0xF9, 0x83, 0x58, 0x5C,
        0x37, 0xCD, 0xEB, 0x63, 0xD6, 0x9A, 0xFD, 0x6D, 0x68, 0xC3,
        0x73, 0x39, 0x08, 0x9C, 0x9A, 0x3C, 0x4E, 0x33, 0x88, 0xFF,
        0x80, 0x00, 0xBA, 0xB2, 0x76, 0xE1, 0x55, 0x7A, 0xB1, 0x52,
        0xF1, 0x6F, 0x33, 0x79, 0x5A, 0xBD, 0x33, 0x95, 0xA1, 0x02,
        0x51, 0x1C, 0x48, 0x9D, 0x09, 0x96, 0x34, 0xF6, 0x4A, 0x10,
        0x7F, 0xEF, 0x5C, 0xF0, 0x61, 0xFE, 0xA4, 0xE4, 0x39, 0xAA,
        0xE8, 0x30, 0x11, 0x9E, 0x1D, 0x08, 0x5D, 0x05, 0x78, 0x27,
        0x82, 0x5E, 0xAC, 0x73, 0x0F, 0xE9, 0xC3, 0xDA, 0x57, 0x41,
        0x26, 0x02, 0x7B, 0xBA, 0x10, 0x97, 0x5D, 0x6F, 0x3E, 0xFA,
        0xEE, 0x9C, 0x34, 0x7C, 0x09, 0x32, 0xB7, 0x49, 0xC9, 0x75,
        0xA1, 0x2E, 0x94, 0x4A, 0x4F, 0xC4, 0xAF, 0xDE, 0x6C, 0x07,
        0xFE, 0x2B, 0x1D, 0x59, 0xD1, 0x7E, 0x20, 0xDF, 0x4E, 0x6D,
        0x3D, 0x2C, 0xDA, 0xFB, 0xF3, 0x88
};
static const int sizeof_ca_ecc_cert_der_sign = sizeof(ca_ecc_cert_der_sign);
#endif /*  USE_CERT_BUFFERS_256 */
