# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from keystone.common.validation import parameter_types

# Schema for Identity v2 API

_role_properties_v2 = {
    'name': parameter_types.name,
    'id': parameter_types.id_string,
    'description': parameter_types.description
}

role_create_v2 = {
    'type': 'object',
    'properties': _role_properties_v2,
    'required': ['name'],
    'additionalProperties': True
}

# Schema for Identity v3 API

_role_properties = {
    'name': parameter_types.name
}

role_create = {
    'type': 'object',
    'properties': _role_properties,
    'required': ['name'],
    'additionalProperties': True
}

role_update = {
    'type': 'object',
    'properties': _role_properties,
    'minProperties': 1,
    'additionalProperties': True
}
