# vim: tabstop=4 shiftwidth=4 softtabstop=4

# Copyright 2013 OpenStack Foundation
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.


ADMIN_EXTENSIONS = {}
PUBLIC_EXTENSIONS = {}


def register_admin_extension(url_prefix, extension_data):
    """Register extension with collection of admin extensions.

    Extensions register the information here that will show
    up in the /extensions page as a way to indicate that the extension is
    active.

    url_prefix:  unique key for the extension that will appear in the
                urls generated by the extension.

    extension_data is a dictionary.  The expected fields are:
        'name':  short, human readable name of the extnsion
        'namespace':  xml namespace
        'alias':  identifier for the extension
        'updated':  date the extension was last updated
        'description':  text description of the extension
        'links':  hyperlinks to documents describing the extension

    """
    ADMIN_EXTENSIONS[url_prefix] = extension_data


def register_public_extension(url_prefix, extension_data):
    """Same as register_admin_extension but for public extensions."""

    PUBLIC_EXTENSIONS[url_prefix] = extension_data
