# This file is dual licensed under the terms of the Apache License, Version
# 2.0, and the BSD License. See the LICENSE file in the root of this repository
# for complete details.

import datetime
import typing

from cryptography import x509
from cryptography.hazmat.primitives import hashes
from cryptography.hazmat.primitives.asymmetric.padding import PSS, PKCS1v15
from cryptography.hazmat.primitives.asymmetric.types import PrivateKeyTypes

def load_pem_x509_certificate(
    data: bytes, backend: typing.Any = None
) -> x509.Certificate: ...
def load_der_x509_certificate(
    data: bytes, backend: typing.Any = None
) -> x509.Certificate: ...
def load_pem_x509_certificates(
    data: bytes,
) -> list[x509.Certificate]: ...
def load_pem_x509_crl(
    data: bytes, backend: typing.Any = None
) -> x509.CertificateRevocationList: ...
def load_der_x509_crl(
    data: bytes, backend: typing.Any = None
) -> x509.CertificateRevocationList: ...
def load_pem_x509_csr(
    data: bytes, backend: typing.Any = None
) -> x509.CertificateSigningRequest: ...
def load_der_x509_csr(
    data: bytes, backend: typing.Any = None
) -> x509.CertificateSigningRequest: ...
def encode_name_bytes(name: x509.Name) -> bytes: ...
def encode_extension_value(extension: x509.ExtensionType) -> bytes: ...
def create_x509_certificate(
    builder: x509.CertificateBuilder,
    private_key: PrivateKeyTypes,
    hash_algorithm: hashes.HashAlgorithm | None,
    rsa_padding: PKCS1v15 | PSS | None,
) -> x509.Certificate: ...
def create_x509_csr(
    builder: x509.CertificateSigningRequestBuilder,
    private_key: PrivateKeyTypes,
    hash_algorithm: hashes.HashAlgorithm | None,
    rsa_padding: PKCS1v15 | PSS | None,
) -> x509.CertificateSigningRequest: ...
def create_x509_crl(
    builder: x509.CertificateRevocationListBuilder,
    private_key: PrivateKeyTypes,
    hash_algorithm: hashes.HashAlgorithm | None,
    rsa_padding: PKCS1v15 | PSS | None,
) -> x509.CertificateRevocationList: ...

class Sct: ...
class Certificate: ...
class RevokedCertificate: ...
class CertificateRevocationList: ...
class CertificateSigningRequest: ...

class PolicyBuilder:
    def time(self, new_time: datetime.datetime) -> PolicyBuilder: ...
    def store(self, new_store: Store) -> PolicyBuilder: ...
    def max_chain_depth(self, new_max_chain_depth: int) -> PolicyBuilder: ...
    def build_client_verifier(self) -> ClientVerifier: ...
    def build_server_verifier(
        self, subject: x509.verification.Subject
    ) -> ServerVerifier: ...

class VerifiedClient:
    @property
    def subjects(self) -> list[x509.GeneralName]: ...
    @property
    def chain(self) -> list[x509.Certificate]: ...

class ClientVerifier:
    @property
    def validation_time(self) -> datetime.datetime: ...
    @property
    def store(self) -> Store: ...
    @property
    def max_chain_depth(self) -> int: ...
    def verify(
        self,
        leaf: x509.Certificate,
        intermediates: list[x509.Certificate],
    ) -> VerifiedClient: ...

class ServerVerifier:
    @property
    def subject(self) -> x509.verification.Subject: ...
    @property
    def validation_time(self) -> datetime.datetime: ...
    @property
    def store(self) -> Store: ...
    @property
    def max_chain_depth(self) -> int: ...
    def verify(
        self,
        leaf: x509.Certificate,
        intermediates: list[x509.Certificate],
    ) -> list[x509.Certificate]: ...

class Store:
    def __init__(self, certs: list[x509.Certificate]) -> None: ...

class VerificationError(Exception):
    pass
