" Vim syntax file
" Language:    XS (Perl extension interface language)
" Author:      Autogenerated from perl headers, on an original basis of Michael W. Dodge <sarge@pobox.com>
" Maintainer:  vim-perl <vim-perl@googlegroups.com>
" Previous:    Vincent Pit <perl@profvince.com>
" Last Change: 2013-05-12

" For version 5.x: Clear all syntax items
" For version 6.x: Quit when a syntax file was already loaded
if version < 600
  syntax clear
elseif exists("b:current_syntax")
  finish
endif

" Read the C syntax to start with
if version < 600
  source <sfile>:p:h/c.vim
else
  runtime! syntax/c.vim
endif

let xs_superseded = 1 " mark C functions superseded by Perl replacements
let xs_not_core   = 1 " mark private core functions

if exists("xs_superseded") && xs_superseded
syn keyword xsSuperseded atof atol calloc clearerr exit fclose feof ferror
syn keyword xsSuperseded fflush fgetc fgetpos fgets fopen fprintf fputc fputs
syn keyword xsSuperseded fread free freopen fseek fsetpos fwrite getc getenv
syn keyword xsSuperseded isalnum isalpha iscntrl isdigit isgraph islower
syn keyword xsSuperseded isprint ispunct isspace isupper isxdigit malloc
syn keyword xsSuperseded memcpy memmove memset printf putc rand realloc
syn keyword xsSuperseded rewind setenv sprintf srand stderr stdin stdout
syn keyword xsSuperseded strcat strcmp strcpy strdup strlen strncat strncmp
syn keyword xsSuperseded strncpy strstr strtod strtol strtoul system tolower
syn keyword xsSuperseded toupper ungetc
endif
if exists("xs_not_core") && xs_not_core
syn keyword xsPrivate F0convert Perl__add_range_to_invlist
syn keyword xsPrivate Perl__core_swash_init Perl__invlist_contents
syn keyword xsPrivate Perl__invlist_intersection_maybe_complement_2nd
syn keyword xsPrivate Perl__invlist_invert Perl__invlist_invert_prop
syn keyword xsPrivate Perl__invlist_populate_swatch
syn keyword xsPrivate Perl__invlist_union_maybe_complement_2nd
syn keyword xsPrivate Perl__is_utf8__perl_idstart Perl__new_invlist
syn keyword xsPrivate Perl__swash_inversion_hash Perl__swash_to_invlist
syn keyword xsPrivate Perl__to_fold_latin1 Perl_av_reify Perl_emulate_cop_io
syn keyword xsPrivate Perl_find_rundefsvoffset Perl_get_re_arg
syn keyword xsPrivate Perl_is_utf8_X_L Perl_is_utf8_X_LV Perl_is_utf8_X_LVT
syn keyword xsPrivate Perl_is_utf8_X_LV_LVT_V Perl_is_utf8_X_T
syn keyword xsPrivate Perl_is_utf8_X_V Perl_is_utf8_X_begin
syn keyword xsPrivate Perl_is_utf8_X_extend Perl_is_utf8_X_non_hangul
syn keyword xsPrivate Perl_is_utf8_X_prepend Perl_is_utf8_char
syn keyword xsPrivate Perl_new_warnings_bitfield Perl_op_clear
syn keyword xsPrivate Perl_ptr_table_clear Perl_qerror Perl_reg_named_buff
syn keyword xsPrivate Perl_reg_named_buff_iter Perl_reg_numbered_buff_fetch
syn keyword xsPrivate Perl_reg_numbered_buff_length
syn keyword xsPrivate Perl_reg_numbered_buff_store Perl_reg_qr_package
syn keyword xsPrivate Perl_reg_temp_copy Perl_regprop Perl_report_uninit
syn keyword xsPrivate Perl_sv_compile_2op Perl_sv_setsv_cow
syn keyword xsPrivate Perl_try_amagic_bin Perl_try_amagic_un
syn keyword xsPrivate Perl_utf8_to_uvchr Perl_utf8_to_uvuni
syn keyword xsPrivate Perl_vivify_defelem Perl_yylex S_F0convert S_Slab_to_rw
syn keyword xsPrivate S__append_range_to_invlist S__new_invlist_C_array
syn keyword xsPrivate S_add_alternate S_add_data S_add_utf16_textfilter
syn keyword xsPrivate S_adjust_stack_on_leave S_amagic_cmp
syn keyword xsPrivate S_amagic_cmp_locale S_amagic_i_ncmp S_amagic_ncmp
syn keyword xsPrivate S_anonymise_cv_maybe S_ao S_apply_attrs
syn keyword xsPrivate S_apply_attrs_my S_assert_uft8_cache_coherent
syn keyword xsPrivate S_bad_type_pv S_bad_type_sv S_bytes_to_uni
syn keyword xsPrivate S_check_locale_boundary_crossing S_check_type_and_open
syn keyword xsPrivate S_check_uni S_checkcomma S_checkposixcc S_ckwarn_common
syn keyword xsPrivate S_cl_and S_cl_anything S_cl_init S_cl_is_anything
syn keyword xsPrivate S_cl_or S_clear_placeholders S_closest_cop S_cop_free
syn keyword xsPrivate S_core_regclass_swash S_cr_textfilter S_curmad S_curse
syn keyword xsPrivate S_cv_dump S_deb_curcv S_deb_stack_n S_debprof
syn keyword xsPrivate S_debug_start_match S_del_sv
syn keyword xsPrivate S_deprecate_commaless_var_list S_destroy_matcher
syn keyword xsPrivate S_div128 S_do_chomp S_do_delete_local S_do_oddball
syn keyword xsPrivate S_do_smartmatch S_do_trans_complex
syn keyword xsPrivate S_do_trans_complex_utf8 S_do_trans_count
syn keyword xsPrivate S_do_trans_count_utf8 S_do_trans_simple
syn keyword xsPrivate S_do_trans_simple_utf8 S_docatch S_doeval S_dofindlabel
syn keyword xsPrivate S_doform S_dooneliner S_doopen_pm S_doparseform
syn keyword xsPrivate S_dopoptoeval S_dopoptogiven S_dopoptolabel
syn keyword xsPrivate S_dopoptoloop S_dopoptosub_at S_dopoptowhen
syn keyword xsPrivate S_dump_exec_pos S_dump_trie S_dump_trie_interim_list
syn keyword xsPrivate S_dump_trie_interim_table S_dumpuntil S_dup_attrlist
syn keyword xsPrivate S_exec_failed S_expect_number S_filter_gets
syn keyword xsPrivate S_finalize_op S_find_and_forget_pmops
syn keyword xsPrivate S_find_array_subscript S_find_beginning S_find_byclass
syn keyword xsPrivate S_find_hash_subscript S_find_in_my_stash
syn keyword xsPrivate S_find_uninit_var S_first_symbol S_fold_constants
syn keyword xsPrivate S_forbid_setid S_force_ident S_force_list S_force_next
syn keyword xsPrivate S_force_strict_version S_force_version S_force_word
syn keyword xsPrivate S_forget_pmop S_gen_constant_list S_get_aux_mg
syn keyword xsPrivate S_get_num S_glob_2number S_glob_assign_glob
syn keyword xsPrivate S_glob_assign_ref S_grok_bslash_c S_grok_bslash_o
syn keyword xsPrivate S_group_end S_gv_ename S_gv_get_super_pkg
syn keyword xsPrivate S_gv_init_svtype S_gv_magicalize_isa
syn keyword xsPrivate S_gv_magicalize_overload S_hfreeentries S_hsplit
syn keyword xsPrivate S_hv_auxinit S_hv_delete_common S_hv_free_ent_ret
syn keyword xsPrivate S_hv_magic_check S_hv_notallowed S_incline S_incpush
syn keyword xsPrivate S_incpush_if_exists S_incpush_use_sep S_ingroup
syn keyword xsPrivate S_init_ids S_init_interp S_init_main_stash
syn keyword xsPrivate S_init_perllib S_init_postdump_symbols
syn keyword xsPrivate S_init_predump_symbols S_inplace_aassign
syn keyword xsPrivate S_intuit_method S_intuit_more S_invlist_extend
syn keyword xsPrivate S_invlist_iternext S_invlist_search
syn keyword xsPrivate S_invoke_exception_hook S_is_an_int
syn keyword xsPrivate S_is_handle_constructor S_is_list_assignment
syn keyword xsPrivate S_is_utf8_char_slow S_is_utf8_common S_isa_lookup
syn keyword xsPrivate S_join_exact S_listkids S_looks_like_bool
syn keyword xsPrivate S_magic_methcall1 S_make_matcher S_make_trie
syn keyword xsPrivate S_make_trie_failtable S_matcher_matches_sv
syn keyword xsPrivate S_mayberelocate S_measure_struct S_mem_log_common
syn keyword xsPrivate S_mess_alloc S_method_common S_minus_v S_missingterm
syn keyword xsPrivate S_modkids S_more_sv S_mro_clean_isarev
syn keyword xsPrivate S_mro_gather_and_rename S_mro_get_linear_isa_dfs
syn keyword xsPrivate S_mul128 S_mulexp10 S_my_exit_jump S_my_kid S_need_utf8
syn keyword xsPrivate S_newDEFSVOP S_newGIVWHENOP S_new_constant S_new_he
syn keyword xsPrivate S_new_logop S_next_symbol S_nextchar
syn keyword xsPrivate S_no_bareword_allowed S_no_fh_allowed S_no_op
syn keyword xsPrivate S_not_a_number S_nuke_stacks S_num_overflow
syn keyword xsPrivate S_open_script S_opt_scalarhv S_pack_rec
syn keyword xsPrivate S_pad_alloc_name S_pad_check_dup S_pad_findlex
syn keyword xsPrivate S_pad_reset S_parse_body S_path_is_absolute S_pidgone
syn keyword xsPrivate S_pm_description S_pmtrans S_printbuf
syn keyword xsPrivate S_process_special_blocks S_ptr_table_find S_put_byte
syn keyword xsPrivate S_qsortsvu S_re_croak2 S_readpipe_override
syn keyword xsPrivate S_ref_array_or_hash S_refcounted_he_value S_refkids
syn keyword xsPrivate S_refto S_reg S_reg_check_named_buff_matched
syn keyword xsPrivate S_reg_namedseq S_reg_node S_reg_recode S_reg_scan_name
syn keyword xsPrivate S_reg_skipcomment S_reganode S_regatom S_regbranch
syn keyword xsPrivate S_regclass S_regcppop S_regcppush S_regdump_extflags
syn keyword xsPrivate S_reghop3 S_reghop4 S_reghopmaybe3 S_reginclass
syn keyword xsPrivate S_reginsert S_regmatch S_regpiece S_regpposixcc
syn keyword xsPrivate S_regrepeat S_regtail S_regtail_study S_regtry S_reguni
syn keyword xsPrivate S_regwhite S_require_tie_mod S_restore_magic S_run_body
syn keyword xsPrivate S_run_user_filter S_rxres_free S_rxres_restore
syn keyword xsPrivate S_save_hek_flags S_save_lines S_save_magic
syn keyword xsPrivate S_save_pushptri32ptr S_save_scalar_at S_scalar_mod_type
syn keyword xsPrivate S_scalarboolean S_scalarkids S_scalarseq S_scan_commit
syn keyword xsPrivate S_scan_const S_scan_formline S_scan_heredoc
syn keyword xsPrivate S_scan_ident S_scan_inputsymbol S_scan_pat S_scan_str
syn keyword xsPrivate S_scan_subst S_scan_trans S_scan_word S_search_const
syn keyword xsPrivate S_sequence_num S_set_regclass_bit_fold
syn keyword xsPrivate S_share_hek_flags S_simplify_sort S_skipspace
syn keyword xsPrivate S_skipspace0 S_skipspace1 S_skipspace2 S_sortcv
syn keyword xsPrivate S_sortcv_stacked S_sortcv_xsub
syn keyword xsPrivate S_space_join_names_mortal S_start_force S_stdize_locale
syn keyword xsPrivate S_strip_return S_study_chunk S_sublex_done
syn keyword xsPrivate S_sublex_push S_sublex_start S_sv_2iuv_common
syn keyword xsPrivate S_sv_2iuv_non_preserve S_sv_add_arena S_sv_dup_common
syn keyword xsPrivate S_sv_dup_inc_multiple S_sv_exp_grow S_sv_i_ncmp
syn keyword xsPrivate S_sv_ncmp S_sv_pos_b2u_midway S_sv_pos_u2b_cached
syn keyword xsPrivate S_sv_pos_u2b_forwards S_sv_pos_u2b_midway
syn keyword xsPrivate S_sv_release_COW S_swallow_bom S_swatch_get
syn keyword xsPrivate S_to_byte_substr S_to_lower_latin1 S_to_utf8_substr
syn keyword xsPrivate S_tokenize_use S_tokeq S_tokereport
syn keyword xsPrivate S_too_few_arguments_pv S_too_few_arguments_sv
syn keyword xsPrivate S_too_many_arguments_pv S_too_many_arguments_sv
syn keyword xsPrivate S_uiv_2buf S_unpack_rec S_unreferenced_to_tmp_stack
syn keyword xsPrivate S_unshare_hek_or_pvn S_unwind_handler_stack
syn keyword xsPrivate S_update_debugger_info S_usage S_utf16_textfilter
syn keyword xsPrivate S_utf8_mg_len_cache_update S_utf8_mg_pos_cache_update
syn keyword xsPrivate S_validate_suid S_visit S_with_queued_errors
syn keyword xsPrivate S_write_no_mem S_xmldump_attr S_yywarn Slab_to_rw
syn keyword xsPrivate _add_range_to_invlist _append_range_to_invlist
syn keyword xsPrivate _core_swash_init _invlist_array_init _invlist_contents
syn keyword xsPrivate _invlist_intersection
syn keyword xsPrivate _invlist_intersection_maybe_complement_2nd
syn keyword xsPrivate _invlist_invert _invlist_invert_prop
syn keyword xsPrivate _invlist_populate_swatch _invlist_subtract
syn keyword xsPrivate _invlist_union _invlist_union_maybe_complement_2nd
syn keyword xsPrivate _is_utf8__perl_idstart _new_invlist
syn keyword xsPrivate _new_invlist_C_array _swash_inversion_hash
syn keyword xsPrivate _swash_to_invlist _to_fold_latin1 add_alternate
syn keyword xsPrivate add_cp_to_invlist add_data add_utf16_textfilter
syn keyword xsPrivate adjust_stack_on_leave amagic_cmp amagic_cmp_locale
syn keyword xsPrivate amagic_i_ncmp amagic_ncmp anonymise_cv_maybe ao
syn keyword xsPrivate apply_attrs apply_attrs_my assert_uft8_cache_coherent
syn keyword xsPrivate av_reify bad_type_pv bad_type_sv bytes_to_uni
syn keyword xsPrivate check_locale_boundary_crossing check_type_and_open
syn keyword xsPrivate check_uni checkcomma checkposixcc ckwarn_common cl_and
syn keyword xsPrivate cl_anything cl_init cl_is_anything cl_or
syn keyword xsPrivate clear_placeholders closest_cop cop_free
syn keyword xsPrivate core_regclass_swash cr_textfilter curmad curse cv_dump
syn keyword xsPrivate deb_curcv deb_stack_n debprof debug_start_match del_sv
syn keyword xsPrivate deprecate_commaless_var_list destroy_matcher div128
syn keyword xsPrivate do_aexec do_chomp do_delete_local do_exec do_oddball
syn keyword xsPrivate do_smartmatch do_trans_complex do_trans_complex_utf8
syn keyword xsPrivate do_trans_count do_trans_count_utf8 do_trans_simple
syn keyword xsPrivate do_trans_simple_utf8 docatch doeval dofindlabel doform
syn keyword xsPrivate dooneliner doopen_pm doparseform dopoptoeval
syn keyword xsPrivate dopoptogiven dopoptolabel dopoptoloop dopoptosub_at
syn keyword xsPrivate dopoptowhen dump_exec_pos dump_trie
syn keyword xsPrivate dump_trie_interim_list dump_trie_interim_table
syn keyword xsPrivate dumpuntil dup_attrlist exec_failed expect_number
syn keyword xsPrivate filter_gets finalize_op find_and_forget_pmops
syn keyword xsPrivate find_array_subscript find_beginning find_byclass
syn keyword xsPrivate find_hash_subscript find_in_my_stash
syn keyword xsPrivate find_rundefsvoffset find_uninit_var first_symbol
syn keyword xsPrivate fold_constants forbid_setid force_ident force_list
syn keyword xsPrivate force_next force_strict_version force_version
syn keyword xsPrivate force_word gen_constant_list get_aux_mg
syn keyword xsPrivate get_invlist_iter_addr get_invlist_len_addr
syn keyword xsPrivate get_invlist_version_id_addr get_invlist_zero_addr
syn keyword xsPrivate get_num glob_2number glob_assign_glob glob_assign_ref
syn keyword xsPrivate grok_bslash_c grok_bslash_o group_end gv_ename
syn keyword xsPrivate gv_get_super_pkg gv_init_svtype gv_magicalize_isa
syn keyword xsPrivate gv_magicalize_overload hfreeentries hsplit hv_auxinit
syn keyword xsPrivate hv_delete_common hv_free_ent_ret hv_magic_check
syn keyword xsPrivate hv_notallowed incline incpush incpush_if_exists
syn keyword xsPrivate incpush_use_sep ingroup init_ids init_interp
syn keyword xsPrivate init_main_stash init_perllib init_postdump_symbols
syn keyword xsPrivate init_predump_symbols inplace_aassign intuit_method
syn keyword xsPrivate intuit_more invlist_array invlist_clone invlist_extend
syn keyword xsPrivate invlist_iterinit invlist_iternext invlist_len
syn keyword xsPrivate invlist_max invlist_search invlist_set_len invlist_trim
syn keyword xsPrivate invoke_exception_hook is_an_int is_handle_constructor
syn keyword xsPrivate is_list_assignment is_utf8_X_L is_utf8_X_LV
syn keyword xsPrivate is_utf8_X_LVT is_utf8_X_LV_LVT_V is_utf8_X_T
syn keyword xsPrivate is_utf8_X_V is_utf8_X_begin is_utf8_X_extend
syn keyword xsPrivate is_utf8_X_non_hangul is_utf8_X_prepend is_utf8_char
syn keyword xsPrivate is_utf8_char_slow is_utf8_common isa_lookup join_exact
syn keyword xsPrivate listkids looks_like_bool magic_methcall1 make_matcher
syn keyword xsPrivate make_trie make_trie_failtable matcher_matches_sv
syn keyword xsPrivate mayberelocate measure_struct mem_log_common mess_alloc
syn keyword xsPrivate method_common minus_v missingterm modkids more_sv
syn keyword xsPrivate mro_clean_isarev mro_gather_and_rename
syn keyword xsPrivate mro_get_linear_isa_dfs mul128 mulexp10 my_exit_jump
syn keyword xsPrivate my_kid need_utf8 newDEFSVOP newGIVWHENOP new_he
syn keyword xsPrivate new_logop next_symbol nextchar no_bareword_allowed
syn keyword xsPrivate no_fh_allowed no_op not_a_number nuke_stacks
syn keyword xsPrivate num_overflow op_clear open_script opt_scalarhv pack_rec
syn keyword xsPrivate pad_alloc_name pad_check_dup pad_findlex pad_reset
syn keyword xsPrivate parse_body path_is_absolute pidgone pm_description
syn keyword xsPrivate pmtrans printbuf process_special_blocks ptr_table_clear
syn keyword xsPrivate ptr_table_find put_byte qerror qsortsvu re_croak2
syn keyword xsPrivate readpipe_override ref_array_or_hash refcounted_he_value
syn keyword xsPrivate refkids refto reg reg_check_named_buff_matched
syn keyword xsPrivate reg_named_buff reg_named_buff_iter reg_namedseq
syn keyword xsPrivate reg_node reg_numbered_buff_fetch
syn keyword xsPrivate reg_numbered_buff_length reg_numbered_buff_store
syn keyword xsPrivate reg_qr_package reg_recode reg_scan_name reg_skipcomment
syn keyword xsPrivate reg_temp_copy reganode regatom regbranch regclass
syn keyword xsPrivate regcppop regcppush regcurly regdump_extflags reghop3
syn keyword xsPrivate reghop4 reghopmaybe3 reginclass reginsert regmatch
syn keyword xsPrivate regpiece regpposixcc regprop regrepeat regtail
syn keyword xsPrivate regtail_study regtry reguni regwhite report_uninit
syn keyword xsPrivate require_tie_mod restore_magic run_body run_user_filter
syn keyword xsPrivate rxres_free rxres_restore save_hek_flags save_lines
syn keyword xsPrivate save_magic save_pushptri32ptr save_scalar_at
syn keyword xsPrivate scalar_mod_type scalarboolean scalarkids scalarseq
syn keyword xsPrivate scan_commit scan_const scan_formline scan_heredoc
syn keyword xsPrivate scan_ident scan_inputsymbol scan_pat scan_str
syn keyword xsPrivate scan_subst scan_trans scan_word search_const
syn keyword xsPrivate sequence_num set_regclass_bit set_regclass_bit_fold
syn keyword xsPrivate share_hek_flags simplify_sort skipspace skipspace0
syn keyword xsPrivate skipspace1 skipspace2 sortcv sortcv_stacked sortcv_xsub
syn keyword xsPrivate space_join_names_mortal start_force stdize_locale
syn keyword xsPrivate strip_return study_chunk sublex_done sublex_push
syn keyword xsPrivate sublex_start sv_2iuv_common sv_2iuv_non_preserve
syn keyword xsPrivate sv_add_arena sv_compile_2op sv_dup_common
syn keyword xsPrivate sv_dup_inc_multiple sv_exp_grow sv_i_ncmp sv_ncmp
syn keyword xsPrivate sv_pos_b2u_midway sv_pos_u2b_cached sv_pos_u2b_forwards
syn keyword xsPrivate sv_pos_u2b_midway sv_release_COW sv_setsv_cow
syn keyword xsPrivate swallow_bom swatch_get to_byte_substr to_lower_latin1
syn keyword xsPrivate to_utf8_substr tokenize_use tokeq tokereport
syn keyword xsPrivate too_few_arguments_pv too_few_arguments_sv
syn keyword xsPrivate too_many_arguments_pv too_many_arguments_sv uiv_2buf
syn keyword xsPrivate unpack_rec unreferenced_to_tmp_stack unshare_hek_or_pvn
syn keyword xsPrivate unwind_handler_stack update_debugger_info usage
syn keyword xsPrivate utf16_textfilter utf8_mg_len_cache_update
syn keyword xsPrivate utf8_mg_pos_cache_update utf8_to_uvchr utf8_to_uvuni
syn keyword xsPrivate visit vivify_defelem with_queued_errors write_no_mem
syn keyword xsPrivate xmldump_attr yylex yywarn
endif
syn keyword xsType AMT AMTS ANY AV BHK BINOP BLOCK CHECKPOINT CLONE_PARAMS
syn keyword xsType COP COPHH CV DB_Hash_t DB_Prefix_t DEBUG_t Direntry_t
syn keyword xsType Fpos_t Free_t GP GV Gid_t Groups_t HE HEK HV I16 I32 I64
syn keyword xsType I8 IO IV Int64 JMPENV LISTOP LOGOP LOOP MADPROP MAGIC MGS
syn keyword xsType MGVTBL Malloc_t Mmap_t Mode_t NEXTTOKE NV Netdb_hlen_t
syn keyword xsType Netdb_host_t Netdb_name_t Netdb_net_t OP OPCODE OP_4tree
syn keyword xsType Off_t Optype PAD PADLIST PADOFFSET PADOP PERL_CONTEXT
syn keyword xsType PERL_SI PMOP PTR_TBL_ENT_t PTR_TBL_t PVOP PerlIO
syn keyword xsType PerlIO_funcs PerlIO_list_s PerlIO_list_t PerlIOl
syn keyword xsType PerlInterpreter Pid_t Quad_t REGEXP Rand_seed_t SSize_t
syn keyword xsType STRLEN STRUCT_SV SUBLEXINFO SV SVOP Select_fd_set_t
syn keyword xsType Shmat_t Signal_t Sigsave_t Size_t Sock_size_t Stat_t TM64
syn keyword xsType TOKEN Time64_T Time_t U16 U32 U64 U8 UNOP UV Uid_t Uquad_t
syn keyword xsType XOP XPV XPVAV XPVBM XPVCV XPVFM XPVGV XPVHV XPVIO XPVIV
syn keyword xsType XPVLV XPVMG XPVNV XPVUV Year _PerlIO _PerlIO_funcs
syn keyword xsType _pMY_CXT _pTHX _reg_ac_data _reg_trie_data _reg_trie_state
syn keyword xsType _reg_trie_trans _reg_trie_trans_list_elem _sublex_info
syn keyword xsType _xhvnameu _xivu _xmgu _xnvu am_table am_table_short
syn keyword xsType block_eval block_format block_givwhen block_hooks
syn keyword xsType block_loop block_sub bool clone_params custom_op
syn keyword xsType cv_flags_t expectation gccbug_semun line_t madprop magic
syn keyword xsType mem_log_type mgvtbl mro_alg mro_meta my_cxt_t opcode p5rx
syn keyword xsType pMY_CXT pMY_CXT_ pTHX pTHX_ padtidy_type perl_cond
syn keyword xsType perl_debug_pad perl_key perl_memory_debug_header
syn keyword xsType perl_mstats perl_mstats_t perl_mutex perl_os_thread
syn keyword xsType perl_phase perl_vars perl_wait_queue pthread_addr_t
syn keyword xsType ptr_tbl ptr_tbl_ent re_save_state refcounted_he
syn keyword xsType reg_ac_data reg_data reg_substr_data reg_substr_datum
syn keyword xsType reg_trie_data reg_trie_state reg_trie_trans
syn keyword xsType reg_trie_trans_le regex_charset regnode regnode_1
syn keyword xsType regnode_2 regnode_2L regnode_charclass
syn keyword xsType regnode_charclass_class regnode_string semun shared_he
syn keyword xsType svtype thread_intern ufuncs xpv xpvav xpvcv xpvfm xpvgv
syn keyword xsType xpvhv xpvhv_aux xpvio xpviv xpvlv xpvmg xpvnv xpvuv
syn keyword xsType yytokentype
syn keyword xsString IVdf NVef NVff NVgf SVf SVf256 SVf32 SVf_ UVof UVuf UVxf
syn keyword xsConstant CXt_BLOCK CXt_EVAL CXt_FORMAT CXt_GIVEN CXt_LOOP_FOR
syn keyword xsConstant CXt_LOOP_LAZYIV CXt_LOOP_LAZYSV CXt_LOOP_PLAIN
syn keyword xsConstant CXt_NULL CXt_SUB CXt_SUBST CXt_WHEN FALSE G_ARRAY
syn keyword xsConstant G_DISCARD G_EVAL G_FAKINGEVAL G_KEEPERR G_METHOD
syn keyword xsConstant G_NOARGS G_NODEBUG G_SCALAR G_UNDEF_FILL G_VOID G_WANT
syn keyword xsConstant G_WARN_ALL_MASK G_WARN_ALL_OFF G_WARN_ALL_ON
syn keyword xsConstant G_WARN_OFF G_WARN_ON G_WARN_ONCE G_WRITING_TO_STDERR
syn keyword xsConstant OA_AVREF OA_BASEOP OA_BASEOP_OR_UNOP OA_BINOP
syn keyword xsConstant OA_CLASS_MASK OA_COP OA_CVREF OA_DANGEROUS OA_DEFGV
syn keyword xsConstant OA_FILEREF OA_FILESTATOP OA_FOLDCONST OA_HVREF OA_LIST
syn keyword xsConstant OA_LISTOP OA_LOGOP OA_LOOP OA_LOOPEXOP OA_MARK
syn keyword xsConstant OA_OPTIONAL OA_OTHERINT OA_PADOP OA_PMOP
syn keyword xsConstant OA_PVOP_OR_SVOP OA_RETSCALAR OA_SCALAR OA_SCALARREF
syn keyword xsConstant OA_SVOP OA_TARGET OA_TARGLEX OA_UNOP OP_AASSIGN OP_ABS
syn keyword xsConstant OP_ACCEPT OP_ADD OP_AEACH OP_AELEM OP_AELEMFAST
syn keyword xsConstant OP_AELEMFAST_LEX OP_AKEYS OP_ALARM OP_AND OP_ANDASSIGN
syn keyword xsConstant OP_ANONCODE OP_ANONHASH OP_ANONLIST OP_ASLICE OP_ATAN2
syn keyword xsConstant OP_AV2ARYLEN OP_AVALUES OP_BACKTICK OP_BIND OP_BINMODE
syn keyword xsConstant OP_BIT_AND OP_BIT_OR OP_BIT_XOR OP_BLESS OP_BOOLKEYS
syn keyword xsConstant OP_BREAK OP_CALLER OP_CHDIR OP_CHMOD OP_CHOMP OP_CHOP
syn keyword xsConstant OP_CHOWN OP_CHR OP_CHROOT OP_CLOSE OP_CLOSEDIR
syn keyword xsConstant OP_COMPLEMENT OP_CONCAT OP_COND_EXPR OP_CONNECT
syn keyword xsConstant OP_CONST OP_CONTINUE OP_COREARGS OP_COS OP_CRYPT
syn keyword xsConstant OP_CUSTOM OP_DBMCLOSE OP_DBMOPEN OP_DBSTATE OP_DEFINED
syn keyword xsConstant OP_DELETE OP_DIE OP_DIVIDE OP_DOFILE OP_DOR
syn keyword xsConstant OP_DORASSIGN OP_DUMP OP_EACH OP_EGRENT OP_EHOSTENT
syn keyword xsConstant OP_ENETENT OP_ENTER OP_ENTEREVAL OP_ENTERGIVEN
syn keyword xsConstant OP_ENTERITER OP_ENTERLOOP OP_ENTERSUB OP_ENTERTRY
syn keyword xsConstant OP_ENTERWHEN OP_ENTERWRITE OP_EOF OP_EPROTOENT
syn keyword xsConstant OP_EPWENT OP_EQ OP_ESERVENT OP_EXEC OP_EXISTS OP_EXIT
syn keyword xsConstant OP_EXP OP_FC OP_FCNTL OP_FILENO OP_FLIP OP_FLOCK
syn keyword xsConstant OP_FLOP OP_FORK OP_FORMLINE OP_FTATIME OP_FTBINARY
syn keyword xsConstant OP_FTBLK OP_FTCHR OP_FTCTIME OP_FTDIR OP_FTEEXEC
syn keyword xsConstant OP_FTEOWNED OP_FTEREAD OP_FTEWRITE OP_FTFILE OP_FTIS
syn keyword xsConstant OP_FTLINK OP_FTMTIME OP_FTPIPE OP_FTREXEC OP_FTROWNED
syn keyword xsConstant OP_FTRREAD OP_FTRWRITE OP_FTSGID OP_FTSIZE OP_FTSOCK
syn keyword xsConstant OP_FTSUID OP_FTSVTX OP_FTTEXT OP_FTTTY OP_FTZERO OP_GE
syn keyword xsConstant OP_GELEM OP_GETC OP_GETLOGIN OP_GETPEERNAME OP_GETPGRP
syn keyword xsConstant OP_GETPPID OP_GETPRIORITY OP_GETSOCKNAME OP_GGRENT
syn keyword xsConstant OP_GGRGID OP_GGRNAM OP_GHBYADDR OP_GHBYNAME
syn keyword xsConstant OP_GHOSTENT OP_GLOB OP_GMTIME OP_GNBYADDR OP_GNBYNAME
syn keyword xsConstant OP_GNETENT OP_GOTO OP_GPBYNAME OP_GPBYNUMBER
syn keyword xsConstant OP_GPROTOENT OP_GPWENT OP_GPWNAM OP_GPWUID
syn keyword xsConstant OP_GREPSTART OP_GREPWHILE OP_GSBYNAME OP_GSBYPORT
syn keyword xsConstant OP_GSERVENT OP_GSOCKOPT OP_GT OP_GV OP_GVSV OP_HELEM
syn keyword xsConstant OP_HEX OP_HINTSEVAL OP_HSLICE OP_INDEX OP_INT OP_IOCTL
syn keyword xsConstant OP_ITER OP_I_ADD OP_I_DIVIDE OP_I_EQ OP_I_GE OP_I_GT
syn keyword xsConstant OP_I_LE OP_I_LT OP_I_MODULO OP_I_MULTIPLY OP_I_NCMP
syn keyword xsConstant OP_I_NE OP_I_NEGATE OP_I_POSTDEC OP_I_POSTINC
syn keyword xsConstant OP_I_PREDEC OP_I_PREINC OP_I_SUBTRACT OP_JOIN OP_KEYS
syn keyword xsConstant OP_KILL OP_LAST OP_LC OP_LCFIRST OP_LE OP_LEAVE
syn keyword xsConstant OP_LEAVEEVAL OP_LEAVEGIVEN OP_LEAVELOOP OP_LEAVESUB
syn keyword xsConstant OP_LEAVESUBLV OP_LEAVETRY OP_LEAVEWHEN OP_LEAVEWRITE
syn keyword xsConstant OP_LEFT_SHIFT OP_LENGTH OP_LINESEQ OP_LINK OP_LIST
syn keyword xsConstant OP_LISTEN OP_LOCALTIME OP_LOCK OP_LOG OP_LSLICE
syn keyword xsConstant OP_LSTAT OP_LT OP_MAPSTART OP_MAPWHILE OP_MATCH
syn keyword xsConstant OP_METHOD OP_METHOD_NAMED OP_MKDIR OP_MODULO OP_MSGCTL
syn keyword xsConstant OP_MSGGET OP_MSGRCV OP_MSGSND OP_MULTIPLY OP_NCMP
syn keyword xsConstant OP_NE OP_NEGATE OP_NEXT OP_NEXTSTATE OP_NOT OP_NULL
syn keyword xsConstant OP_OCT OP_ONCE OP_OPEN OP_OPEN_DIR OP_OR OP_ORASSIGN
syn keyword xsConstant OP_ORD OP_PACK OP_PADANY OP_PADAV OP_PADHV OP_PADSV
syn keyword xsConstant OP_PIPE_OP OP_POP OP_POS OP_POSTDEC OP_POSTINC OP_POW
syn keyword xsConstant OP_PREDEC OP_PREINC OP_PRINT OP_PROTOTYPE OP_PRTF
syn keyword xsConstant OP_PUSH OP_PUSHMARK OP_PUSHRE OP_QR OP_QUOTEMETA
syn keyword xsConstant OP_RAND OP_RANGE OP_RCATLINE OP_REACH OP_READ
syn keyword xsConstant OP_READDIR OP_READLINE OP_READLINK OP_RECV OP_REDO
syn keyword xsConstant OP_REF OP_REFGEN OP_REGCMAYBE OP_REGCOMP OP_REGCRESET
syn keyword xsConstant OP_RENAME OP_REPEAT OP_REQUIRE OP_RESET OP_RETURN
syn keyword xsConstant OP_REVERSE OP_REWINDDIR OP_RIGHT_SHIFT OP_RINDEX
syn keyword xsConstant OP_RKEYS OP_RMDIR OP_RUNCV OP_RV2AV OP_RV2CV OP_RV2GV
syn keyword xsConstant OP_RV2HV OP_RV2SV OP_RVALUES OP_SASSIGN OP_SAY
syn keyword xsConstant OP_SCALAR OP_SCHOMP OP_SCHOP OP_SCMP OP_SCOPE OP_SEEK
syn keyword xsConstant OP_SEEKDIR OP_SELECT OP_SEMCTL OP_SEMGET OP_SEMOP
syn keyword xsConstant OP_SEND OP_SEQ OP_SETPGRP OP_SETPRIORITY OP_SGE
syn keyword xsConstant OP_SGRENT OP_SGT OP_SHIFT OP_SHMCTL OP_SHMGET
syn keyword xsConstant OP_SHMREAD OP_SHMWRITE OP_SHOSTENT OP_SHUTDOWN OP_SIN
syn keyword xsConstant OP_SLE OP_SLEEP OP_SLT OP_SMARTMATCH OP_SNE OP_SNETENT
syn keyword xsConstant OP_SOCKET OP_SOCKPAIR OP_SORT OP_SPLICE OP_SPLIT
syn keyword xsConstant OP_SPRINTF OP_SPROTOENT OP_SPWENT OP_SQRT OP_SRAND
syn keyword xsConstant OP_SREFGEN OP_SSELECT OP_SSERVENT OP_SSOCKOPT OP_STAT
syn keyword xsConstant OP_STRINGIFY OP_STUB OP_STUDY OP_SUBST OP_SUBSTCONT
syn keyword xsConstant OP_SUBSTR OP_SUBTRACT OP_SYMLINK OP_SYSCALL OP_SYSOPEN
syn keyword xsConstant OP_SYSREAD OP_SYSSEEK OP_SYSTEM OP_SYSWRITE OP_TELL
syn keyword xsConstant OP_TELLDIR OP_TIE OP_TIED OP_TIME OP_TMS OP_TRANS
syn keyword xsConstant OP_TRANSR OP_TRUNCATE OP_UC OP_UCFIRST OP_UMASK
syn keyword xsConstant OP_UNDEF OP_UNLINK OP_UNPACK OP_UNSHIFT OP_UNSTACK
syn keyword xsConstant OP_UNTIE OP_UTIME OP_VALUES OP_VEC OP_WAIT OP_WAITPID
syn keyword xsConstant OP_WANTARRAY OP_WARN OP_XOR OP_max OPf_KIDS OPf_KNOW
syn keyword xsConstant OPf_LIST OPf_MOD OPf_PARENS OPf_REF OPf_SPECIAL
syn keyword xsConstant OPf_STACKED OPf_WANT OPf_WANT_LIST OPf_WANT_SCALAR
syn keyword xsConstant OPf_WANT_VOID OPpALLOW_FAKE OPpASSIGN_BACKWARDS
syn keyword xsConstant OPpASSIGN_COMMON OPpASSIGN_CV_TO_GV OPpCONST_BARE
syn keyword xsConstant OPpCONST_ENTERED OPpCONST_NOVER OPpCONST_SHORTCIRCUIT
syn keyword xsConstant OPpCONST_STRICT OPpCONST_WARNING OPpCOREARGS_DEREF1
syn keyword xsConstant OPpCOREARGS_DEREF2 OPpCOREARGS_PUSHMARK
syn keyword xsConstant OPpCOREARGS_SCALARMOD OPpDEREF OPpDEREF_AV OPpDEREF_HV
syn keyword xsConstant OPpDEREF_SV OPpDONT_INIT_GV OPpEARLY_CV
syn keyword xsConstant OPpENTERSUB_AMPER OPpENTERSUB_DB OPpENTERSUB_HASTARG
syn keyword xsConstant OPpENTERSUB_INARGS OPpENTERSUB_LVAL_MASK
syn keyword xsConstant OPpENTERSUB_NOPAREN OPpEVAL_BYTES OPpEVAL_COPHH
syn keyword xsConstant OPpEVAL_HAS_HH OPpEVAL_UNICODE OPpEXISTS_SUB
syn keyword xsConstant OPpEXIT_VMSISH OPpFLIP_LINENUM OPpFT_ACCESS
syn keyword xsConstant OPpFT_AFTER_t OPpFT_STACKED OPpFT_STACKING OPpGREP_LEX
syn keyword xsConstant OPpHUSH_VMSISH OPpITER_DEF OPpITER_REVERSED
syn keyword xsConstant OPpLIST_GUESSED OPpLVAL_DEFER OPpLVAL_INTRO
syn keyword xsConstant OPpMAYBE_LVSUB OPpMAY_RETURN_CONSTANT OPpOFFBYONE
syn keyword xsConstant OPpOPEN_IN_CRLF OPpOPEN_IN_RAW OPpOPEN_OUT_CRLF
syn keyword xsConstant OPpOPEN_OUT_RAW OPpOUR_INTRO OPpPAD_STATE
syn keyword xsConstant OPpPV_IS_UTF8 OPpREFCOUNTED OPpREPEAT_DOLIST
syn keyword xsConstant OPpREVERSE_INPLACE OPpRUNTIME OPpSLICE OPpSORT_DESCEND
syn keyword xsConstant OPpSORT_INPLACE OPpSORT_INTEGER OPpSORT_NUMERIC
syn keyword xsConstant OPpSORT_QSORT OPpSORT_REVERSE OPpSORT_STABLE
syn keyword xsConstant OPpSUBSTR_REPL_FIRST OPpTARGET_MY OPpTRANS_ALL
syn keyword xsConstant OPpTRANS_COMPLEMENT OPpTRANS_DELETE OPpTRANS_FROM_UTF
syn keyword xsConstant OPpTRANS_GROWS OPpTRANS_IDENTICAL OPpTRANS_SQUASH
syn keyword xsConstant OPpTRANS_TO_UTF PERL_MAGIC_READONLY_ACCEPTABLE
syn keyword xsConstant PERL_MAGIC_TYPE_IS_VALUE_MAGIC
syn keyword xsConstant PERL_MAGIC_TYPE_READONLY_ACCEPTABLE
syn keyword xsConstant PERL_MAGIC_UTF8_CACHESIZE PERL_MAGIC_VALUE_MAGIC
syn keyword xsConstant PERL_MAGIC_VTABLE_MASK PERL_MAGIC_arylen
syn keyword xsConstant PERL_MAGIC_arylen_p PERL_MAGIC_backref PERL_MAGIC_bm
syn keyword xsConstant PERL_MAGIC_checkcall PERL_MAGIC_collxfrm
syn keyword xsConstant PERL_MAGIC_dbfile PERL_MAGIC_dbline PERL_MAGIC_defelem
syn keyword xsConstant PERL_MAGIC_env PERL_MAGIC_envelem PERL_MAGIC_ext
syn keyword xsConstant PERL_MAGIC_fm PERL_MAGIC_hints PERL_MAGIC_hintselem
syn keyword xsConstant PERL_MAGIC_isa PERL_MAGIC_isaelem PERL_MAGIC_nkeys
syn keyword xsConstant PERL_MAGIC_overload PERL_MAGIC_overload_elem
syn keyword xsConstant PERL_MAGIC_overload_table PERL_MAGIC_pos PERL_MAGIC_qr
syn keyword xsConstant PERL_MAGIC_regdata PERL_MAGIC_regdatum
syn keyword xsConstant PERL_MAGIC_regex_global PERL_MAGIC_rhash
syn keyword xsConstant PERL_MAGIC_shared PERL_MAGIC_shared_scalar
syn keyword xsConstant PERL_MAGIC_sig PERL_MAGIC_sigelem PERL_MAGIC_study
syn keyword xsConstant PERL_MAGIC_substr PERL_MAGIC_sv PERL_MAGIC_symtab
syn keyword xsConstant PERL_MAGIC_taint PERL_MAGIC_tied PERL_MAGIC_tiedelem
syn keyword xsConstant PERL_MAGIC_tiedscalar PERL_MAGIC_utf8 PERL_MAGIC_uvar
syn keyword xsConstant PERL_MAGIC_uvar_elem PERL_MAGIC_vec PERL_MAGIC_vstring
syn keyword xsConstant REGEX_ASCII_MORE_RESTRICTED_CHARSET
syn keyword xsConstant REGEX_ASCII_RESTRICTED_CHARSET REGEX_DEPENDS_CHARSET
syn keyword xsConstant REGEX_LOCALE_CHARSET REGEX_UNICODE_CHARSET SVfARG
syn keyword xsConstant SVf_AMAGIC SVf_BREAK SVf_FAKE SVf_IOK SVf_IVisUV
syn keyword xsConstant SVf_NOK SVf_OK SVf_OOK SVf_POK SVf_READONLY SVf_ROK
syn keyword xsConstant SVf_THINKFIRST SVf_UTF8 SVp_IOK SVp_NOK SVp_POK
syn keyword xsConstant SVp_SCREAM SVpad_NAME SVpad_OUR SVpad_STATE
syn keyword xsConstant SVpad_TYPED SVpav_REAL SVpav_REIFY SVpbm_TAIL
syn keyword xsConstant SVpbm_VALID SVpgv_GP SVphv_CLONEABLE SVphv_HASKFLAGS
syn keyword xsConstant SVphv_LAZYDEL SVphv_REHASH SVphv_SHAREKEYS
syn keyword xsConstant SVprv_PCS_IMPORTED SVprv_WEAKREF SVs_GMG SVs_OBJECT
syn keyword xsConstant SVs_PADMY SVs_PADSTALE SVs_PADTMP SVs_RMG SVs_SMG
syn keyword xsConstant SVs_TEMP SVt_BIND SVt_IV SVt_LAST SVt_NULL SVt_NV
syn keyword xsConstant SVt_PV SVt_PVAV SVt_PVBM SVt_PVCV SVt_PVFM SVt_PVGV
syn keyword xsConstant SVt_PVHV SVt_PVIO SVt_PVIV SVt_PVLV SVt_PVMG SVt_PVNV
syn keyword xsConstant SVt_REGEXP SVt_RV TRUE XATTRBLOCK XATTRTERM XBLOCK
syn keyword xsConstant XOPERATOR XREF XSTATE XTERM XTERMBLOCK XTERMORDORDOR
syn keyword xsConstant padtidy_FORMAT padtidy_SUB padtidy_SUBCLONE
syn keyword xsException XCPT_CATCH XCPT_RETHROW XCPT_TRY_END XCPT_TRY_START
syn keyword xsException dXCPT
syn keyword xsKeyword ALIAS: BOOT: CASE: CLEANUP: CODE: C_ARGS: DISABLE
syn keyword xsKeyword ENABLE FALLBACK: IN INCLUDE: INIT: INPUT: INTERFACE:
syn keyword xsKeyword INTERFACE_MACRO: IN_OUT IN_OUTLIST MODULE NO_INIT:
syn keyword xsKeyword NO_OUTPUT: OUT OUTLIST OUTPUT: OVERLOAD: PACKAGE
syn keyword xsKeyword POSTCALL: PPCODE: PREFIX PREINIT: PROTOTYPE:
syn keyword xsKeyword PROTOTYPES: REQUIRE: SCOPE: VERSIONCHECK: length
syn keyword xsFunction GetVars Gv_AMupdate PerlIO_clearerr PerlIO_close
syn keyword xsFunction PerlIO_eof PerlIO_error PerlIO_fileno PerlIO_fill
syn keyword xsFunction PerlIO_flush PerlIO_get_base PerlIO_get_bufsiz
syn keyword xsFunction PerlIO_get_cnt PerlIO_get_ptr PerlIO_read PerlIO_seek
syn keyword xsFunction PerlIO_set_cnt PerlIO_set_ptrcnt PerlIO_setlinebuf
syn keyword xsFunction PerlIO_stderr PerlIO_stdin PerlIO_stdout PerlIO_tell
syn keyword xsFunction PerlIO_unread PerlIO_write Perl_GetVars
syn keyword xsFunction Perl_Gv_AMupdate Perl_PerlIO_clearerr
syn keyword xsFunction Perl_PerlIO_close Perl_PerlIO_context_layers
syn keyword xsFunction Perl_PerlIO_eof Perl_PerlIO_error Perl_PerlIO_fileno
syn keyword xsFunction Perl_PerlIO_fill Perl_PerlIO_flush
syn keyword xsFunction Perl_PerlIO_get_base Perl_PerlIO_get_bufsiz
syn keyword xsFunction Perl_PerlIO_get_cnt Perl_PerlIO_get_ptr
syn keyword xsFunction Perl_PerlIO_read Perl_PerlIO_seek Perl_PerlIO_set_cnt
syn keyword xsFunction Perl_PerlIO_set_ptrcnt Perl_PerlIO_setlinebuf
syn keyword xsFunction Perl_PerlIO_stderr Perl_PerlIO_stdin
syn keyword xsFunction Perl_PerlIO_stdout Perl_PerlIO_tell Perl_PerlIO_unread
syn keyword xsFunction Perl_PerlIO_write Perl_Slab_Alloc Perl_Slab_Free
syn keyword xsFunction Perl__is_utf8_quotemeta Perl__to_uni_fold_flags
syn keyword xsFunction Perl__to_utf8_fold_flags Perl__to_utf8_lower_flags
syn keyword xsFunction Perl__to_utf8_title_flags Perl__to_utf8_upper_flags
syn keyword xsFunction Perl_amagic_call Perl_amagic_deref_call Perl_any_dup
syn keyword xsFunction Perl_apply_attrs_string Perl_atfork_lock
syn keyword xsFunction Perl_atfork_unlock Perl_av_arylen_p Perl_av_clear
syn keyword xsFunction Perl_av_create_and_push Perl_av_create_and_unshift_one
syn keyword xsFunction Perl_av_delete Perl_av_exists Perl_av_extend
syn keyword xsFunction Perl_av_fetch Perl_av_fill Perl_av_iter_p Perl_av_len
syn keyword xsFunction Perl_av_make Perl_av_pop Perl_av_push Perl_av_shift
syn keyword xsFunction Perl_av_store Perl_av_undef Perl_av_unshift
syn keyword xsFunction Perl_block_gimme Perl_blockhook_register
syn keyword xsFunction Perl_bytes_cmp_utf8 Perl_bytes_from_utf8
syn keyword xsFunction Perl_bytes_to_utf8 Perl_call_argv Perl_call_atexit
syn keyword xsFunction Perl_call_list Perl_call_method Perl_call_pv
syn keyword xsFunction Perl_call_sv Perl_caller_cx Perl_calloc Perl_cast_i32
syn keyword xsFunction Perl_cast_iv Perl_cast_ulong Perl_cast_uv
syn keyword xsFunction Perl_ck_entersub_args_list Perl_ck_entersub_args_proto
syn keyword xsFunction Perl_ck_entersub_args_proto_or_list Perl_ck_warner
syn keyword xsFunction Perl_ck_warner_d Perl_ckwarn Perl_ckwarn_d
syn keyword xsFunction Perl_clone_params_del Perl_clone_params_new
syn keyword xsFunction Perl_cop_fetch_label Perl_cop_store_label Perl_croak
syn keyword xsFunction Perl_croak_no_modify Perl_croak_nocontext
syn keyword xsFunction Perl_croak_sv Perl_croak_xs_usage Perl_csighandler
syn keyword xsFunction Perl_custom_op_desc Perl_custom_op_name
syn keyword xsFunction Perl_custom_op_register Perl_custom_op_xop
syn keyword xsFunction Perl_cv_clone Perl_cv_const_sv
syn keyword xsFunction Perl_cv_get_call_checker Perl_cv_set_call_checker
syn keyword xsFunction Perl_cv_undef Perl_cx_dump Perl_cx_dup Perl_cxinc
syn keyword xsFunction Perl_deb Perl_deb_nocontext Perl_debop
syn keyword xsFunction Perl_debprofdump Perl_debstack Perl_debstackptrs
syn keyword xsFunction Perl_delimcpy Perl_despatch_signals Perl_die
syn keyword xsFunction Perl_die_nocontext Perl_die_sv Perl_dirp_dup
syn keyword xsFunction Perl_do_aspawn Perl_do_binmode Perl_do_close
syn keyword xsFunction Perl_do_gv_dump Perl_do_gvgv_dump Perl_do_hv_dump
syn keyword xsFunction Perl_do_join Perl_do_magic_dump Perl_do_op_dump
syn keyword xsFunction Perl_do_open9 Perl_do_openn Perl_do_pmop_dump
syn keyword xsFunction Perl_do_spawn Perl_do_spawn_nowait Perl_do_sprintf
syn keyword xsFunction Perl_do_sv_dump Perl_doing_taint Perl_doref
syn keyword xsFunction Perl_dounwind Perl_dowantarray Perl_dump_all
syn keyword xsFunction Perl_dump_eval Perl_dump_fds Perl_dump_form
syn keyword xsFunction Perl_dump_indent Perl_dump_mstats Perl_dump_packsubs
syn keyword xsFunction Perl_dump_sub Perl_dump_vindent Perl_eval_pv
syn keyword xsFunction Perl_eval_sv Perl_fbm_compile Perl_fbm_instr
syn keyword xsFunction Perl_filter_add Perl_filter_del Perl_filter_read
syn keyword xsFunction Perl_find_runcv Perl_find_rundefsv Perl_foldEQ
syn keyword xsFunction Perl_foldEQ_latin1 Perl_foldEQ_locale
syn keyword xsFunction Perl_foldEQ_utf8_flags Perl_form Perl_form_nocontext
syn keyword xsFunction Perl_fp_dup Perl_fprintf_nocontext
syn keyword xsFunction Perl_free_global_struct Perl_free_tmps Perl_get_av
syn keyword xsFunction Perl_get_context Perl_get_cv Perl_get_cvn_flags
syn keyword xsFunction Perl_get_hv Perl_get_mstats Perl_get_op_descs
syn keyword xsFunction Perl_get_op_names Perl_get_ppaddr Perl_get_sv
syn keyword xsFunction Perl_get_vtbl Perl_getcwd_sv Perl_gp_dup Perl_gp_free
syn keyword xsFunction Perl_gp_ref Perl_grok_bin Perl_grok_hex
syn keyword xsFunction Perl_grok_number Perl_grok_numeric_radix Perl_grok_oct
syn keyword xsFunction Perl_gv_add_by_type Perl_gv_autoload_pv
syn keyword xsFunction Perl_gv_autoload_pvn Perl_gv_autoload_sv Perl_gv_check
syn keyword xsFunction Perl_gv_const_sv Perl_gv_dump Perl_gv_efullname
syn keyword xsFunction Perl_gv_efullname4 Perl_gv_fetchfile
syn keyword xsFunction Perl_gv_fetchfile_flags Perl_gv_fetchmeth_pv
syn keyword xsFunction Perl_gv_fetchmeth_pv_autoload Perl_gv_fetchmeth_pvn
syn keyword xsFunction Perl_gv_fetchmeth_pvn_autoload Perl_gv_fetchmeth_sv
syn keyword xsFunction Perl_gv_fetchmeth_sv_autoload
syn keyword xsFunction Perl_gv_fetchmethod_autoload
syn keyword xsFunction Perl_gv_fetchmethod_pv_flags
syn keyword xsFunction Perl_gv_fetchmethod_pvn_flags
syn keyword xsFunction Perl_gv_fetchmethod_sv_flags Perl_gv_fetchpv
syn keyword xsFunction Perl_gv_fetchpvn_flags Perl_gv_fetchsv
syn keyword xsFunction Perl_gv_fullname Perl_gv_fullname4 Perl_gv_handler
syn keyword xsFunction Perl_gv_init_pv Perl_gv_init_pvn Perl_gv_init_sv
syn keyword xsFunction Perl_gv_name_set Perl_gv_stashpv Perl_gv_stashpvn
syn keyword xsFunction Perl_gv_stashsv Perl_he_dup Perl_hek_dup
syn keyword xsFunction Perl_hv_assert Perl_hv_clear
syn keyword xsFunction Perl_hv_clear_placeholders Perl_hv_common
syn keyword xsFunction Perl_hv_common_key_len Perl_hv_copy_hints_hv
syn keyword xsFunction Perl_hv_delayfree_ent Perl_hv_eiter_p
syn keyword xsFunction Perl_hv_eiter_set Perl_hv_fill Perl_hv_free_ent
syn keyword xsFunction Perl_hv_iterinit Perl_hv_iterkey Perl_hv_iterkeysv
syn keyword xsFunction Perl_hv_iternext_flags Perl_hv_iternextsv
syn keyword xsFunction Perl_hv_iterval Perl_hv_ksplit Perl_hv_name_set
syn keyword xsFunction Perl_hv_placeholders_get Perl_hv_placeholders_p
syn keyword xsFunction Perl_hv_placeholders_set Perl_hv_riter_p
syn keyword xsFunction Perl_hv_riter_set Perl_hv_scalar
syn keyword xsFunction Perl_init_global_struct Perl_init_i18nl10n
syn keyword xsFunction Perl_init_i18nl14n Perl_init_stacks Perl_init_tm
syn keyword xsFunction Perl_instr Perl_is_ascii_string Perl_is_lvalue_sub
syn keyword xsFunction Perl_is_uni_alnum Perl_is_uni_alnum_lc
syn keyword xsFunction Perl_is_uni_alpha Perl_is_uni_alpha_lc
syn keyword xsFunction Perl_is_uni_ascii Perl_is_uni_ascii_lc
syn keyword xsFunction Perl_is_uni_cntrl Perl_is_uni_cntrl_lc
syn keyword xsFunction Perl_is_uni_digit Perl_is_uni_digit_lc
syn keyword xsFunction Perl_is_uni_graph Perl_is_uni_graph_lc
syn keyword xsFunction Perl_is_uni_idfirst Perl_is_uni_idfirst_lc
syn keyword xsFunction Perl_is_uni_lower Perl_is_uni_lower_lc
syn keyword xsFunction Perl_is_uni_print Perl_is_uni_print_lc
syn keyword xsFunction Perl_is_uni_punct Perl_is_uni_punct_lc
syn keyword xsFunction Perl_is_uni_space Perl_is_uni_space_lc
syn keyword xsFunction Perl_is_uni_upper Perl_is_uni_upper_lc
syn keyword xsFunction Perl_is_uni_xdigit Perl_is_uni_xdigit_lc
syn keyword xsFunction Perl_is_utf8_alnum Perl_is_utf8_alpha
syn keyword xsFunction Perl_is_utf8_ascii Perl_is_utf8_char_buf
syn keyword xsFunction Perl_is_utf8_cntrl Perl_is_utf8_digit
syn keyword xsFunction Perl_is_utf8_graph Perl_is_utf8_idcont
syn keyword xsFunction Perl_is_utf8_idfirst Perl_is_utf8_lower
syn keyword xsFunction Perl_is_utf8_mark Perl_is_utf8_perl_space
syn keyword xsFunction Perl_is_utf8_perl_word Perl_is_utf8_posix_digit
syn keyword xsFunction Perl_is_utf8_print Perl_is_utf8_punct
syn keyword xsFunction Perl_is_utf8_space Perl_is_utf8_string
syn keyword xsFunction Perl_is_utf8_string_loclen Perl_is_utf8_upper
syn keyword xsFunction Perl_is_utf8_xdigit Perl_is_utf8_xidcont
syn keyword xsFunction Perl_is_utf8_xidfirst Perl_leave_scope
syn keyword xsFunction Perl_lex_bufutf8 Perl_lex_discard_to
syn keyword xsFunction Perl_lex_grow_linestr Perl_lex_next_chunk
syn keyword xsFunction Perl_lex_peek_unichar Perl_lex_read_space
syn keyword xsFunction Perl_lex_read_to Perl_lex_read_unichar Perl_lex_start
syn keyword xsFunction Perl_lex_stuff_pv Perl_lex_stuff_pvn Perl_lex_stuff_sv
syn keyword xsFunction Perl_lex_unstuff Perl_load_module
syn keyword xsFunction Perl_load_module_nocontext Perl_looks_like_number
syn keyword xsFunction Perl_magic_dump Perl_malloc Perl_markstack_grow
syn keyword xsFunction Perl_mess Perl_mess_nocontext Perl_mess_sv Perl_mfree
syn keyword xsFunction Perl_mg_clear Perl_mg_copy Perl_mg_dup Perl_mg_find
syn keyword xsFunction Perl_mg_findext Perl_mg_free Perl_mg_free_type
syn keyword xsFunction Perl_mg_get Perl_mg_length Perl_mg_magical Perl_mg_set
syn keyword xsFunction Perl_mg_size Perl_mini_mktime Perl_moreswitches
syn keyword xsFunction Perl_mro_get_from_name Perl_mro_get_linear_isa
syn keyword xsFunction Perl_mro_get_private_data Perl_mro_method_changed_in
syn keyword xsFunction Perl_mro_register Perl_mro_set_mro
syn keyword xsFunction Perl_mro_set_private_data Perl_my_atof Perl_my_atof2
syn keyword xsFunction Perl_my_bcopy Perl_my_bzero Perl_my_chsize
syn keyword xsFunction Perl_my_cxt_index Perl_my_cxt_init Perl_my_dirfd
syn keyword xsFunction Perl_my_exit Perl_my_failure_exit Perl_my_fflush_all
syn keyword xsFunction Perl_my_fork Perl_my_htonl Perl_my_memcmp
syn keyword xsFunction Perl_my_memset Perl_my_ntohl Perl_my_pclose
syn keyword xsFunction Perl_my_popen Perl_my_popen_list Perl_my_setenv
syn keyword xsFunction Perl_my_snprintf Perl_my_socketpair Perl_my_sprintf
syn keyword xsFunction Perl_my_strftime Perl_my_strlcat Perl_my_strlcpy
syn keyword xsFunction Perl_my_swap Perl_my_vsnprintf Perl_newANONATTRSUB
syn keyword xsFunction Perl_newANONHASH Perl_newANONLIST Perl_newANONSUB
syn keyword xsFunction Perl_newASSIGNOP Perl_newATTRSUB Perl_newAVREF
syn keyword xsFunction Perl_newBINOP Perl_newCONDOP Perl_newCONSTSUB
syn keyword xsFunction Perl_newCONSTSUB_flags Perl_newCVREF Perl_newFORM
syn keyword xsFunction Perl_newFOROP Perl_newGIVENOP Perl_newGVOP
syn keyword xsFunction Perl_newGVREF Perl_newGVgen_flags Perl_newHVREF
syn keyword xsFunction Perl_newHVhv Perl_newLISTOP Perl_newLOGOP
syn keyword xsFunction Perl_newLOOPEX Perl_newLOOPOP Perl_newMYSUB
syn keyword xsFunction Perl_newNULLLIST Perl_newOP Perl_newPADOP Perl_newPMOP
syn keyword xsFunction Perl_newPROG Perl_newPVOP Perl_newRANGE Perl_newRV
syn keyword xsFunction Perl_newRV_noinc Perl_newSLICEOP Perl_newSTATEOP
syn keyword xsFunction Perl_newSV Perl_newSVOP Perl_newSVREF Perl_newSV_type
syn keyword xsFunction Perl_newSVhek Perl_newSViv Perl_newSVnv Perl_newSVpv
syn keyword xsFunction Perl_newSVpv_share Perl_newSVpvf
syn keyword xsFunction Perl_newSVpvf_nocontext Perl_newSVpvn
syn keyword xsFunction Perl_newSVpvn_flags Perl_newSVpvn_share Perl_newSVrv
syn keyword xsFunction Perl_newSVsv Perl_newSVuv Perl_newUNOP Perl_newWHENOP
syn keyword xsFunction Perl_newWHILEOP Perl_newXS Perl_newXS_flags
syn keyword xsFunction Perl_new_collate Perl_new_ctype Perl_new_numeric
syn keyword xsFunction Perl_new_stackinfo Perl_new_version Perl_ninstr
syn keyword xsFunction Perl_nothreadhook Perl_op_append_elem
syn keyword xsFunction Perl_op_append_list Perl_op_contextualize Perl_op_dump
syn keyword xsFunction Perl_op_free Perl_op_linklist Perl_op_null
syn keyword xsFunction Perl_op_prepend_elem Perl_op_refcnt_lock
syn keyword xsFunction Perl_op_refcnt_unlock Perl_op_scope Perl_pack_cat
syn keyword xsFunction Perl_packlist Perl_pad_add_anon Perl_pad_add_name_pv
syn keyword xsFunction Perl_pad_add_name_pvn Perl_pad_add_name_sv
syn keyword xsFunction Perl_pad_alloc Perl_pad_compname_type
syn keyword xsFunction Perl_pad_findmy_pv Perl_pad_findmy_pvn
syn keyword xsFunction Perl_pad_findmy_sv Perl_pad_new Perl_pad_setsv
syn keyword xsFunction Perl_pad_sv Perl_pad_tidy Perl_parse_arithexpr
syn keyword xsFunction Perl_parse_barestmt Perl_parse_block
syn keyword xsFunction Perl_parse_fullexpr Perl_parse_fullstmt
syn keyword xsFunction Perl_parse_label Perl_parse_listexpr
syn keyword xsFunction Perl_parse_stmtseq Perl_parse_termexpr Perl_parser_dup
syn keyword xsFunction Perl_pmop_dump Perl_pop_scope Perl_pregcomp
syn keyword xsFunction Perl_pregexec Perl_pregfree Perl_pregfree2
syn keyword xsFunction Perl_prescan_version Perl_printf_nocontext
syn keyword xsFunction Perl_ptr_table_fetch Perl_ptr_table_free
syn keyword xsFunction Perl_ptr_table_new Perl_ptr_table_split
syn keyword xsFunction Perl_ptr_table_store Perl_push_scope Perl_pv_display
syn keyword xsFunction Perl_pv_escape Perl_pv_pretty Perl_pv_uni_display
syn keyword xsFunction Perl_re_compile Perl_re_dup_guts Perl_re_intuit_start
syn keyword xsFunction Perl_re_intuit_string Perl_realloc Perl_reentrant_free
syn keyword xsFunction Perl_reentrant_init Perl_reentrant_retry
syn keyword xsFunction Perl_reentrant_size Perl_reg_named_buff_all
syn keyword xsFunction Perl_reg_named_buff_exists Perl_reg_named_buff_fetch
syn keyword xsFunction Perl_reg_named_buff_firstkey
syn keyword xsFunction Perl_reg_named_buff_nextkey Perl_reg_named_buff_scalar
syn keyword xsFunction Perl_regclass_swash Perl_regdump Perl_regdupe_internal
syn keyword xsFunction Perl_regexec_flags Perl_regfree_internal
syn keyword xsFunction Perl_reginitcolors Perl_regnext Perl_repeatcpy
syn keyword xsFunction Perl_require_pv Perl_rninstr Perl_rsignal
syn keyword xsFunction Perl_rsignal_state Perl_runops_debug
syn keyword xsFunction Perl_runops_standard Perl_rv2cv_op_cv Perl_rvpv_dup
syn keyword xsFunction Perl_safesyscalloc Perl_safesysfree Perl_safesysmalloc
syn keyword xsFunction Perl_safesysrealloc Perl_save_I16 Perl_save_I32
syn keyword xsFunction Perl_save_I8 Perl_save_adelete Perl_save_aelem_flags
syn keyword xsFunction Perl_save_alloc Perl_save_aptr Perl_save_ary
syn keyword xsFunction Perl_save_bool Perl_save_clearsv Perl_save_delete
syn keyword xsFunction Perl_save_destructor Perl_save_destructor_x
syn keyword xsFunction Perl_save_generic_pvref Perl_save_generic_svref
syn keyword xsFunction Perl_save_gp Perl_save_hash Perl_save_hdelete
syn keyword xsFunction Perl_save_helem_flags Perl_save_hints Perl_save_hptr
syn keyword xsFunction Perl_save_int Perl_save_item Perl_save_iv
syn keyword xsFunction Perl_save_list Perl_save_long Perl_save_nogv
syn keyword xsFunction Perl_save_padsv_and_mortalize Perl_save_pptr
syn keyword xsFunction Perl_save_pushi32ptr Perl_save_pushptr
syn keyword xsFunction Perl_save_pushptrptr Perl_save_re_context
syn keyword xsFunction Perl_save_scalar Perl_save_set_svflags
syn keyword xsFunction Perl_save_shared_pvref Perl_save_sptr Perl_save_svref
syn keyword xsFunction Perl_save_vptr Perl_savepv Perl_savepvn
syn keyword xsFunction Perl_savesharedpv Perl_savesharedpvn
syn keyword xsFunction Perl_savesharedsvpv Perl_savestack_grow
syn keyword xsFunction Perl_savestack_grow_cnt Perl_savesvpv Perl_scan_bin
syn keyword xsFunction Perl_scan_hex Perl_scan_num Perl_scan_oct
syn keyword xsFunction Perl_scan_version Perl_scan_vstring Perl_screaminstr
syn keyword xsFunction Perl_seed Perl_set_context Perl_set_numeric_local
syn keyword xsFunction Perl_set_numeric_radix Perl_set_numeric_standard
syn keyword xsFunction Perl_setdefout Perl_share_hek Perl_si_dup Perl_sortsv
syn keyword xsFunction Perl_sortsv_flags Perl_ss_dup Perl_stack_grow
syn keyword xsFunction Perl_start_subparse Perl_stashpv_hvname_match
syn keyword xsFunction Perl_str_to_version Perl_sv_2bool_flags Perl_sv_2cv
syn keyword xsFunction Perl_sv_2io Perl_sv_2iv_flags Perl_sv_2mortal
syn keyword xsFunction Perl_sv_2nv_flags Perl_sv_2pv_flags Perl_sv_2pvbyte
syn keyword xsFunction Perl_sv_2pvutf8 Perl_sv_2uv_flags Perl_sv_backoff
syn keyword xsFunction Perl_sv_bless Perl_sv_cat_decode Perl_sv_catpv
syn keyword xsFunction Perl_sv_catpv_flags Perl_sv_catpv_mg Perl_sv_catpvf
syn keyword xsFunction Perl_sv_catpvf_mg Perl_sv_catpvf_mg_nocontext
syn keyword xsFunction Perl_sv_catpvf_nocontext Perl_sv_catpvn_flags
syn keyword xsFunction Perl_sv_catsv_flags Perl_sv_chop Perl_sv_clear
syn keyword xsFunction Perl_sv_cmp Perl_sv_cmp_flags Perl_sv_cmp_locale
syn keyword xsFunction Perl_sv_cmp_locale_flags Perl_sv_collxfrm_flags
syn keyword xsFunction Perl_sv_copypv Perl_sv_dec Perl_sv_dec_nomg
syn keyword xsFunction Perl_sv_derived_from Perl_sv_derived_from_pv
syn keyword xsFunction Perl_sv_derived_from_pvn Perl_sv_derived_from_sv
syn keyword xsFunction Perl_sv_destroyable Perl_sv_does Perl_sv_does_pv
syn keyword xsFunction Perl_sv_does_pvn Perl_sv_does_sv Perl_sv_dump
syn keyword xsFunction Perl_sv_dup Perl_sv_dup_inc Perl_sv_eq_flags
syn keyword xsFunction Perl_sv_force_normal_flags Perl_sv_free Perl_sv_gets
syn keyword xsFunction Perl_sv_grow Perl_sv_inc Perl_sv_inc_nomg
syn keyword xsFunction Perl_sv_insert_flags Perl_sv_isa Perl_sv_isobject
syn keyword xsFunction Perl_sv_iv Perl_sv_len Perl_sv_len_utf8 Perl_sv_magic
syn keyword xsFunction Perl_sv_magicext Perl_sv_mortalcopy Perl_sv_newmortal
syn keyword xsFunction Perl_sv_newref Perl_sv_nosharing Perl_sv_nounlocking
syn keyword xsFunction Perl_sv_nv Perl_sv_peek Perl_sv_pos_b2u
syn keyword xsFunction Perl_sv_pos_u2b Perl_sv_pos_u2b_flags Perl_sv_pvbyten
syn keyword xsFunction Perl_sv_pvbyten_force Perl_sv_pvn
syn keyword xsFunction Perl_sv_pvn_force_flags Perl_sv_pvn_nomg
syn keyword xsFunction Perl_sv_pvutf8n Perl_sv_pvutf8n_force
syn keyword xsFunction Perl_sv_recode_to_utf8 Perl_sv_reftype Perl_sv_replace
syn keyword xsFunction Perl_sv_report_used Perl_sv_reset Perl_sv_rvweaken
syn keyword xsFunction Perl_sv_setiv Perl_sv_setiv_mg Perl_sv_setnv
syn keyword xsFunction Perl_sv_setnv_mg Perl_sv_setpv Perl_sv_setpv_mg
syn keyword xsFunction Perl_sv_setpvf Perl_sv_setpvf_mg
syn keyword xsFunction Perl_sv_setpvf_mg_nocontext Perl_sv_setpvf_nocontext
syn keyword xsFunction Perl_sv_setpviv Perl_sv_setpviv_mg Perl_sv_setpvn
syn keyword xsFunction Perl_sv_setpvn_mg Perl_sv_setref_iv Perl_sv_setref_nv
syn keyword xsFunction Perl_sv_setref_pv Perl_sv_setref_pvn Perl_sv_setref_uv
syn keyword xsFunction Perl_sv_setsv_flags Perl_sv_setsv_mg Perl_sv_setuv
syn keyword xsFunction Perl_sv_setuv_mg Perl_sv_tainted Perl_sv_true
syn keyword xsFunction Perl_sv_uni_display Perl_sv_unmagic Perl_sv_unmagicext
syn keyword xsFunction Perl_sv_unref_flags Perl_sv_untaint Perl_sv_upgrade
syn keyword xsFunction Perl_sv_usepvn_flags Perl_sv_utf8_decode
syn keyword xsFunction Perl_sv_utf8_downgrade Perl_sv_utf8_encode
syn keyword xsFunction Perl_sv_utf8_upgrade_flags_grow Perl_sv_uv
syn keyword xsFunction Perl_sv_vcatpvf Perl_sv_vcatpvf_mg Perl_sv_vcatpvfn
syn keyword xsFunction Perl_sv_vsetpvf Perl_sv_vsetpvf_mg Perl_sv_vsetpvfn
syn keyword xsFunction Perl_swash_fetch Perl_swash_init Perl_sys_init
syn keyword xsFunction Perl_sys_init3 Perl_sys_intern_clear
syn keyword xsFunction Perl_sys_intern_dup Perl_sys_intern_init Perl_sys_term
syn keyword xsFunction Perl_taint_env Perl_taint_proper Perl_tmps_grow
syn keyword xsFunction Perl_to_uni_lower Perl_to_uni_lower_lc
syn keyword xsFunction Perl_to_uni_title Perl_to_uni_title_lc
syn keyword xsFunction Perl_to_uni_upper Perl_to_uni_upper_lc
syn keyword xsFunction Perl_to_utf8_case Perl_unlnk Perl_unpack_str
syn keyword xsFunction Perl_unpackstring Perl_unsharepvn Perl_upg_version
syn keyword xsFunction Perl_utf16_to_utf8 Perl_utf16_to_utf8_reversed
syn keyword xsFunction Perl_utf8_distance Perl_utf8_hop Perl_utf8_length
syn keyword xsFunction Perl_utf8_to_bytes Perl_utf8_to_uvchr_buf
syn keyword xsFunction Perl_utf8_to_uvuni_buf Perl_utf8n_to_uvchr
syn keyword xsFunction Perl_utf8n_to_uvuni Perl_uvchr_to_utf8
syn keyword xsFunction Perl_uvchr_to_utf8_flags Perl_uvuni_to_utf8_flags
syn keyword xsFunction Perl_valid_utf8_to_uvchr Perl_valid_utf8_to_uvuni
syn keyword xsFunction Perl_vcmp Perl_vcroak Perl_vdeb Perl_vform
syn keyword xsFunction Perl_vload_module Perl_vmess Perl_vnewSVpvf
syn keyword xsFunction Perl_vnormal Perl_vnumify Perl_vstringify Perl_vverify
syn keyword xsFunction Perl_vwarn Perl_vwarner Perl_warn Perl_warn_nocontext
syn keyword xsFunction Perl_warn_sv Perl_warner Perl_warner_nocontext
syn keyword xsFunction Perl_whichsig_pv Perl_whichsig_pvn Perl_whichsig_sv
syn keyword xsFunction Perl_wrap_op_checker Slab_Alloc Slab_Free
syn keyword xsFunction _is_utf8_quotemeta _to_uni_fold_flags
syn keyword xsFunction _to_utf8_fold_flags _to_utf8_lower_flags
syn keyword xsFunction _to_utf8_title_flags _to_utf8_upper_flags amagic_call
syn keyword xsFunction amagic_deref_call any_dup apply_attrs_string
syn keyword xsFunction atfork_lock atfork_unlock av_clear av_delete av_exists
syn keyword xsFunction av_extend av_fetch av_fill av_len av_make av_pop
syn keyword xsFunction av_push av_shift av_store av_undef av_unshift
syn keyword xsFunction block_gimme bytes_cmp_utf8 bytes_from_utf8
syn keyword xsFunction bytes_to_utf8 call_argv call_atexit call_list
syn keyword xsFunction call_method call_pv call_sv caller_cx cast_i32 cast_iv
syn keyword xsFunction cast_ulong cast_uv ck_entersub_args_list
syn keyword xsFunction ck_entersub_args_proto ck_entersub_args_proto_or_list
syn keyword xsFunction ck_warner ck_warner_d croak croak_no_modify
syn keyword xsFunction croak_nocontext croak_sv croak_xs_usage csighandler
syn keyword xsFunction custom_op_desc custom_op_name cv_clone cv_const_sv
syn keyword xsFunction cv_get_call_checker cv_set_call_checker cv_undef
syn keyword xsFunction cx_dump cx_dup cxinc deb deb_nocontext debop
syn keyword xsFunction debprofdump debstack debstackptrs delimcpy
syn keyword xsFunction despatch_signals die die_nocontext die_sv dirp_dup
syn keyword xsFunction do_aspawn do_binmode do_close do_gv_dump do_gvgv_dump
syn keyword xsFunction do_hv_dump do_join do_magic_dump do_op_dump do_open9
syn keyword xsFunction do_openn do_pmop_dump do_spawn do_spawn_nowait
syn keyword xsFunction do_sprintf do_sv_dump doing_taint doref dounwind
syn keyword xsFunction dowantarray dump_all dump_eval dump_fds dump_form
syn keyword xsFunction dump_indent dump_mstats dump_packsubs dump_sub
syn keyword xsFunction dump_vindent eval_pv eval_sv fbm_compile fbm_instr
syn keyword xsFunction filter_add filter_del filter_read find_runcv
syn keyword xsFunction find_rundefsv foldEQ foldEQ_latin1 foldEQ_locale
syn keyword xsFunction foldEQ_utf8_flags form form_nocontext fp_dup
syn keyword xsFunction fprintf_nocontext free_global_struct free_tmps get_av
syn keyword xsFunction get_context get_cv get_cvn_flags get_hv get_mstats
syn keyword xsFunction get_op_descs get_op_names get_ppaddr get_sv get_vtbl
syn keyword xsFunction getcwd_sv gp_dup gp_free gp_ref grok_bin grok_hex
syn keyword xsFunction grok_number grok_numeric_radix grok_oct gv_add_by_type
syn keyword xsFunction gv_autoload_pv gv_autoload_pvn gv_autoload_sv gv_check
syn keyword xsFunction gv_const_sv gv_dump gv_efullname gv_efullname4
syn keyword xsFunction gv_fetchfile gv_fetchfile_flags gv_fetchmeth_pv
syn keyword xsFunction gv_fetchmeth_pv_autoload gv_fetchmeth_pvn
syn keyword xsFunction gv_fetchmeth_pvn_autoload gv_fetchmeth_sv
syn keyword xsFunction gv_fetchmeth_sv_autoload gv_fetchmethod_autoload
syn keyword xsFunction gv_fetchmethod_pv_flags gv_fetchmethod_pvn_flags
syn keyword xsFunction gv_fetchmethod_sv_flags gv_fetchpv gv_fetchpvn_flags
syn keyword xsFunction gv_fetchsv gv_fullname gv_fullname4 gv_handler
syn keyword xsFunction gv_init_pv gv_init_pvn gv_init_sv gv_name_set
syn keyword xsFunction gv_stashpv gv_stashpvn gv_stashsv he_dup hek_dup
syn keyword xsFunction hv_clear hv_clear_placeholders hv_common
syn keyword xsFunction hv_common_key_len hv_copy_hints_hv hv_delayfree_ent
syn keyword xsFunction hv_free_ent hv_iterinit hv_iterkey hv_iterkeysv
syn keyword xsFunction hv_iternext_flags hv_iternextsv hv_iterval hv_ksplit
syn keyword xsFunction hv_name_set hv_scalar init_global_struct init_i18nl10n
syn keyword xsFunction init_i18nl14n init_stacks init_tm instr
syn keyword xsFunction is_ascii_string is_lvalue_sub is_uni_alnum
syn keyword xsFunction is_uni_alnum_lc is_uni_alpha is_uni_alpha_lc
syn keyword xsFunction is_uni_ascii is_uni_ascii_lc is_uni_cntrl
syn keyword xsFunction is_uni_cntrl_lc is_uni_digit is_uni_digit_lc
syn keyword xsFunction is_uni_graph is_uni_graph_lc is_uni_idfirst
syn keyword xsFunction is_uni_idfirst_lc is_uni_lower is_uni_lower_lc
syn keyword xsFunction is_uni_print is_uni_print_lc is_uni_punct
syn keyword xsFunction is_uni_punct_lc is_uni_space is_uni_space_lc
syn keyword xsFunction is_uni_upper is_uni_upper_lc is_uni_xdigit
syn keyword xsFunction is_uni_xdigit_lc is_utf8_alnum is_utf8_alpha
syn keyword xsFunction is_utf8_ascii is_utf8_char_buf is_utf8_cntrl
syn keyword xsFunction is_utf8_digit is_utf8_graph is_utf8_idcont
syn keyword xsFunction is_utf8_idfirst is_utf8_lower is_utf8_mark
syn keyword xsFunction is_utf8_perl_space is_utf8_perl_word
syn keyword xsFunction is_utf8_posix_digit is_utf8_print is_utf8_punct
syn keyword xsFunction is_utf8_space is_utf8_string is_utf8_string_loclen
syn keyword xsFunction is_utf8_upper is_utf8_xdigit is_utf8_xidcont
syn keyword xsFunction is_utf8_xidfirst leave_scope lex_bufutf8
syn keyword xsFunction lex_discard_to lex_grow_linestr lex_next_chunk
syn keyword xsFunction lex_peek_unichar lex_read_space lex_read_to
syn keyword xsFunction lex_read_unichar lex_start lex_stuff_pv lex_stuff_pvn
syn keyword xsFunction lex_stuff_sv lex_unstuff load_module
syn keyword xsFunction load_module_nocontext looks_like_number magic_dump
syn keyword xsFunction markstack_grow mess mess_nocontext mess_sv mg_clear
syn keyword xsFunction mg_copy mg_dup mg_find mg_findext mg_free mg_free_type
syn keyword xsFunction mg_get mg_length mg_magical mg_set mg_size mini_mktime
syn keyword xsFunction moreswitches mro_get_linear_isa mro_method_changed_in
syn keyword xsFunction my_atof my_atof2 my_bcopy my_bzero my_chsize my_dirfd
syn keyword xsFunction my_exit my_failure_exit my_fflush_all my_fork my_htonl
syn keyword xsFunction my_memcmp my_memset my_ntohl my_pclose my_popen
syn keyword xsFunction my_popen_list my_setenv my_socketpair my_strftime
syn keyword xsFunction my_swap newANONATTRSUB newANONHASH newANONLIST
syn keyword xsFunction newANONSUB newASSIGNOP newATTRSUB newAVREF newBINOP
syn keyword xsFunction newCONDOP newCONSTSUB newCONSTSUB_flags newCVREF
syn keyword xsFunction newFORM newFOROP newGIVENOP newGVOP newGVREF
syn keyword xsFunction newGVgen_flags newHVREF newHVhv newLISTOP newLOGOP
syn keyword xsFunction newLOOPEX newLOOPOP newMYSUB newNULLLIST newOP
syn keyword xsFunction newPADOP newPMOP newPROG newPVOP newRANGE newRV
syn keyword xsFunction newRV_noinc newSLICEOP newSTATEOP newSV newSVOP
syn keyword xsFunction newSVREF newSV_type newSVhek newSViv newSVnv newSVpv
syn keyword xsFunction newSVpv_share newSVpvf newSVpvf_nocontext newSVpvn
syn keyword xsFunction newSVpvn_flags newSVpvn_share newSVrv newSVsv newSVuv
syn keyword xsFunction newUNOP newWHENOP newWHILEOP newXS newXS_flags
syn keyword xsFunction new_collate new_ctype new_numeric new_stackinfo
syn keyword xsFunction new_version ninstr nothreadhook op_append_elem
syn keyword xsFunction op_append_list op_contextualize op_dump op_free
syn keyword xsFunction op_linklist op_null op_prepend_elem op_refcnt_lock
syn keyword xsFunction op_refcnt_unlock op_scope pack_cat packlist
syn keyword xsFunction pad_add_anon pad_add_name_pv pad_add_name_pvn
syn keyword xsFunction pad_add_name_sv pad_alloc pad_compname_type
syn keyword xsFunction pad_findmy_pv pad_findmy_pvn pad_findmy_sv pad_new
syn keyword xsFunction pad_setsv pad_sv pad_tidy parse_arithexpr
syn keyword xsFunction parse_barestmt parse_block parse_fullexpr
syn keyword xsFunction parse_fullstmt parse_label parse_listexpr
syn keyword xsFunction parse_stmtseq parse_termexpr parser_dup pmop_dump
syn keyword xsFunction pop_scope pregcomp pregexec pregfree pregfree2
syn keyword xsFunction prescan_version printf_nocontext ptr_table_fetch
syn keyword xsFunction ptr_table_free ptr_table_new ptr_table_split
syn keyword xsFunction ptr_table_store push_scope pv_display pv_escape
syn keyword xsFunction pv_pretty pv_uni_display re_compile re_dup_guts
syn keyword xsFunction re_intuit_start re_intuit_string reentrant_free
syn keyword xsFunction reentrant_init reentrant_retry reentrant_size
syn keyword xsFunction reg_named_buff_all reg_named_buff_exists
syn keyword xsFunction reg_named_buff_fetch reg_named_buff_firstkey
syn keyword xsFunction reg_named_buff_nextkey reg_named_buff_scalar
syn keyword xsFunction regclass_swash regdump regdupe_internal regexec_flags
syn keyword xsFunction regfree_internal reginitcolors regnext repeatcpy
syn keyword xsFunction require_pv rninstr rsignal rsignal_state runops_debug
syn keyword xsFunction runops_standard rv2cv_op_cv rvpv_dup safesyscalloc
syn keyword xsFunction safesysfree safesysmalloc safesysrealloc save_I16
syn keyword xsFunction save_I32 save_I8 save_adelete save_aelem_flags
syn keyword xsFunction save_alloc save_aptr save_ary save_bool save_clearsv
syn keyword xsFunction save_delete save_destructor save_destructor_x
syn keyword xsFunction save_generic_pvref save_generic_svref save_gp
syn keyword xsFunction save_hash save_hdelete save_helem_flags save_hints
syn keyword xsFunction save_hptr save_int save_item save_iv save_list
syn keyword xsFunction save_long save_nogv save_padsv_and_mortalize save_pptr
syn keyword xsFunction save_pushi32ptr save_pushptr save_pushptrptr
syn keyword xsFunction save_re_context save_scalar save_set_svflags
syn keyword xsFunction save_shared_pvref save_sptr save_svref save_vptr
syn keyword xsFunction savepv savepvn savesharedpv savesharedpvn
syn keyword xsFunction savesharedsvpv savestack_grow savestack_grow_cnt
syn keyword xsFunction savesvpv scan_bin scan_hex scan_num scan_oct
syn keyword xsFunction scan_version scan_vstring screaminstr seed set_context
syn keyword xsFunction set_numeric_local set_numeric_radix
syn keyword xsFunction set_numeric_standard setdefout share_hek si_dup sortsv
syn keyword xsFunction sortsv_flags ss_dup stack_grow start_subparse
syn keyword xsFunction stashpv_hvname_match str_to_version sv_2bool_flags
syn keyword xsFunction sv_2cv sv_2io sv_2iv_flags sv_2mortal sv_2nv_flags
syn keyword xsFunction sv_2pv_flags sv_2pvbyte sv_2pvutf8 sv_2uv_flags
syn keyword xsFunction sv_backoff sv_bless sv_cat_decode sv_catpv
syn keyword xsFunction sv_catpv_flags sv_catpv_mg sv_catpvf sv_catpvf_mg
syn keyword xsFunction sv_catpvf_mg_nocontext sv_catpvf_nocontext
syn keyword xsFunction sv_catpvn_flags sv_catsv_flags sv_chop sv_clear
syn keyword xsFunction sv_cmp_flags sv_cmp_locale_flags sv_collxfrm_flags
syn keyword xsFunction sv_copypv sv_dec sv_dec_nomg sv_derived_from
syn keyword xsFunction sv_derived_from_pv sv_derived_from_pvn
syn keyword xsFunction sv_derived_from_sv sv_destroyable sv_does sv_does_pv
syn keyword xsFunction sv_does_pvn sv_does_sv sv_dump sv_dup sv_dup_inc
syn keyword xsFunction sv_eq_flags sv_force_normal_flags sv_free sv_gets
syn keyword xsFunction sv_grow sv_inc sv_inc_nomg sv_insert_flags sv_isa
syn keyword xsFunction sv_isobject sv_iv sv_len sv_len_utf8 sv_magic
syn keyword xsFunction sv_magicext sv_mortalcopy sv_newmortal sv_newref
syn keyword xsFunction sv_nosharing sv_nounlocking sv_nv sv_peek sv_pos_b2u
syn keyword xsFunction sv_pos_u2b sv_pos_u2b_flags sv_pvbyten
syn keyword xsFunction sv_pvbyten_force sv_pvn sv_pvn_force_flags sv_pvn_nomg
syn keyword xsFunction sv_pvutf8n sv_pvutf8n_force sv_recode_to_utf8
syn keyword xsFunction sv_reftype sv_replace sv_report_used sv_reset
syn keyword xsFunction sv_rvweaken sv_setiv sv_setiv_mg sv_setnv sv_setnv_mg
syn keyword xsFunction sv_setpv sv_setpv_mg sv_setpvf sv_setpvf_mg
syn keyword xsFunction sv_setpvf_mg_nocontext sv_setpvf_nocontext sv_setpviv
syn keyword xsFunction sv_setpviv_mg sv_setpvn sv_setpvn_mg sv_setref_iv
syn keyword xsFunction sv_setref_nv sv_setref_pv sv_setref_pvn sv_setref_uv
syn keyword xsFunction sv_setsv_flags sv_setsv_mg sv_setuv sv_setuv_mg
syn keyword xsFunction sv_tainted sv_true sv_uni_display sv_unmagic
syn keyword xsFunction sv_unmagicext sv_unref_flags sv_untaint sv_upgrade
syn keyword xsFunction sv_usepvn_flags sv_utf8_decode sv_utf8_downgrade
syn keyword xsFunction sv_utf8_encode sv_utf8_upgrade_flags_grow sv_uv
syn keyword xsFunction sv_vcatpvf sv_vcatpvf_mg sv_vcatpvfn sv_vsetpvf
syn keyword xsFunction sv_vsetpvf_mg sv_vsetpvfn swash_fetch swash_init
syn keyword xsFunction sys_intern_clear sys_intern_dup sys_intern_init
syn keyword xsFunction taint_env taint_proper tmps_grow to_uni_lower
syn keyword xsFunction to_uni_lower_lc to_uni_title to_uni_title_lc
syn keyword xsFunction to_uni_upper to_uni_upper_lc to_utf8_case unlnk
syn keyword xsFunction unpack_str unpackstring unsharepvn upg_version
syn keyword xsFunction utf16_to_utf8 utf16_to_utf8_reversed utf8_distance
syn keyword xsFunction utf8_hop utf8_length utf8_to_bytes utf8_to_uvchr_buf
syn keyword xsFunction utf8_to_uvuni_buf utf8n_to_uvchr utf8n_to_uvuni
syn keyword xsFunction uvchr_to_utf8 uvchr_to_utf8_flags uvuni_to_utf8_flags
syn keyword xsFunction valid_utf8_to_uvchr valid_utf8_to_uvuni vcmp vcroak
syn keyword xsFunction vdeb vform vload_module vmess vnewSVpvf vnormal
syn keyword xsFunction vnumify vstringify vverify vwarn vwarner warn
syn keyword xsFunction warn_nocontext warn_sv warner warner_nocontext
syn keyword xsFunction whichsig_pv whichsig_pvn whichsig_sv wrap_op_checker
syn keyword xsVariable MARK MY_CXT ORIGMARK PL_I PL_No PL_Vars PL_VarsPtr
syn keyword xsVariable PL_Yes PL_a2e PL_bincompat_options PL_bitcount
syn keyword xsVariable PL_block_type PL_bufend PL_bufptr PL_charclass
syn keyword xsVariable PL_check PL_copline PL_core_reg_engine PL_cshname
syn keyword xsVariable PL_curforce PL_e2a PL_e2utf PL_endwhite PL_error_count
syn keyword xsVariable PL_expect PL_faketokens PL_fold PL_fold_latin1
syn keyword xsVariable PL_fold_locale PL_force_link_funcs PL_freq
syn keyword xsVariable PL_global_struct_size PL_hexdigit PL_in_my
syn keyword xsVariable PL_in_my_stash PL_interp_size PL_interp_size_5_16_0
syn keyword xsVariable PL_last_lop PL_last_lop_op PL_last_uni PL_lasttoke
syn keyword xsVariable PL_latin1_lc PL_lex_allbrackets PL_lex_brackets
syn keyword xsVariable PL_lex_brackstack PL_lex_casemods PL_lex_casestack
syn keyword xsVariable PL_lex_defer PL_lex_dojoin PL_lex_expect
syn keyword xsVariable PL_lex_fakeeof PL_lex_formbrack PL_lex_inpat
syn keyword xsVariable PL_lex_inwhat PL_lex_op PL_lex_repl PL_lex_starts
syn keyword xsVariable PL_lex_state PL_lex_stuff PL_linestart PL_linestr
syn keyword xsVariable PL_magic_data PL_magic_vtable_names PL_memory_wrap
syn keyword xsVariable PL_mod_latin1_uc PL_multi_close PL_multi_end
syn keyword xsVariable PL_multi_open PL_multi_start PL_nexttoke PL_nexttype
syn keyword xsVariable PL_nextval PL_nextwhite PL_no_aelem PL_no_dir_func
syn keyword xsVariable PL_no_func PL_no_helem_sv PL_no_localize_ref PL_no_mem
syn keyword xsVariable PL_no_modify PL_no_myglob PL_no_security
syn keyword xsVariable PL_no_sock_func PL_no_symref PL_no_symref_sv
syn keyword xsVariable PL_no_usym PL_no_wrongref PL_oldbufptr PL_oldoldbufptr
syn keyword xsVariable PL_op_desc PL_op_name PL_opargs PL_pending_ident
syn keyword xsVariable PL_phase_names PL_ppaddr PL_preambled
syn keyword xsVariable PL_realtokenstart PL_reg_extflags_name PL_reg_name
syn keyword xsVariable PL_regkind PL_revision PL_rsfp PL_rsfp_filters
syn keyword xsVariable PL_runops_dbg PL_runops_std PL_sh_path PL_sig_name
syn keyword xsVariable PL_sig_num PL_simple PL_simple_bitmask PL_skipwhite
syn keyword xsVariable PL_sublex_info PL_subversion PL_thisclose PL_thismad
syn keyword xsVariable PL_thisopen PL_thisstuff PL_thistoken PL_thiswhite
syn keyword xsVariable PL_tokenbuf PL_utf2e PL_utf8skip PL_uudmap PL_uuemap
syn keyword xsVariable PL_valid_types_IVX PL_valid_types_IV_set
syn keyword xsVariable PL_valid_types_NVX PL_valid_types_NV_set
syn keyword xsVariable PL_valid_types_PVX PL_valid_types_RV PL_varies
syn keyword xsVariable PL_varies_bitmask PL_version PL_warn_nl PL_warn_nosemi
syn keyword xsVariable PL_warn_reserved PL_warn_uninit PL_warn_uninit_sv
syn keyword xsVariable RETVAL SP TARG _aMY_CXT _aTHX aMY_CXT aMY_CXT_ aTHX
syn keyword xsVariable aTHX_ items
syn keyword xsMacro ABORT ACCEPT ADDOP AHOCORASICK AHOCORASICKC
syn keyword xsMacro ALLOC_THREAD_KEY ALNUM ALNUMA ALNUML ALNUMU AMG_CALLun
syn keyword xsMacro AMG_CALLunary AMGf_assign AMGf_noleft AMGf_noright
syn keyword xsMacro AMGf_numeric AMGf_set AMGf_unary AMGfallNEVER AMGfallNO
syn keyword xsMacro AMGfallYES AMT_AMAGIC AMT_AMAGIC_off AMT_AMAGIC_on
syn keyword xsMacro AMT_OVERLOADED AMT_OVERLOADED_off AMT_OVERLOADED_on
syn keyword xsMacro AMTf_AMAGIC AMTf_OVERLOADED ANDAND ANDOP ANONSUB ANYOF
syn keyword xsMacro ANYOFV ANYOF_ALNUM ANYOF_ALNUMC ANYOF_ALNUML ANYOF_ALPHA
syn keyword xsMacro ANYOF_ASCII ANYOF_BIT ANYOF_BITMAP ANYOF_BITMAP_BYTE
syn keyword xsMacro ANYOF_BITMAP_CLEAR ANYOF_BITMAP_CLEARALL ANYOF_BITMAP_SET
syn keyword xsMacro ANYOF_BITMAP_SETALL ANYOF_BITMAP_SIZE ANYOF_BITMAP_TEST
syn keyword xsMacro ANYOF_BITMAP_TESTALLSET ANYOF_BITMAP_ZERO ANYOF_BLANK
syn keyword xsMacro ANYOF_CLASS ANYOF_CLASSBITMAP_SIZE ANYOF_CLASS_BYTE
syn keyword xsMacro ANYOF_CLASS_CLEAR ANYOF_CLASS_SET ANYOF_CLASS_SETALL
syn keyword xsMacro ANYOF_CLASS_SIZE ANYOF_CLASS_SKIP ANYOF_CLASS_TEST
syn keyword xsMacro ANYOF_CLASS_TEST_ANY_SET ANYOF_CLASS_ZERO ANYOF_CNTRL
syn keyword xsMacro ANYOF_DIGIT ANYOF_EOS ANYOF_FLAGS ANYOF_FLAGS_ALL
syn keyword xsMacro ANYOF_FOLD_SHARP_S ANYOF_GRAPH ANYOF_HORIZWS ANYOF_INVERT
syn keyword xsMacro ANYOF_IS_SYNTHETIC ANYOF_LARGE ANYOF_LOCALE
syn keyword xsMacro ANYOF_LOC_NONBITMAP_FOLD ANYOF_LOWER ANYOF_MAX
syn keyword xsMacro ANYOF_NALNUM ANYOF_NALNUMC ANYOF_NALNUML ANYOF_NALPHA
syn keyword xsMacro ANYOF_NASCII ANYOF_NBLANK ANYOF_NCNTRL ANYOF_NDIGIT
syn keyword xsMacro ANYOF_NGRAPH ANYOF_NHORIZWS ANYOF_NLOWER ANYOF_NONBITMAP
syn keyword xsMacro ANYOF_NONBITMAP_EMPTY ANYOF_NONBITMAP_NON_UTF8
syn keyword xsMacro ANYOF_NON_UTF8_LATIN1_ALL ANYOF_NPRINT ANYOF_NPSXSPC
syn keyword xsMacro ANYOF_NPUNCT ANYOF_NSPACE ANYOF_NSPACEL ANYOF_NUPPER
syn keyword xsMacro ANYOF_NVERTWS ANYOF_NXDIGIT ANYOF_PRINT ANYOF_PSXSPC
syn keyword xsMacro ANYOF_PUNCT ANYOF_SIZE ANYOF_SKIP ANYOF_SPACE
syn keyword xsMacro ANYOF_SPACEL ANYOF_UNICODE_ALL ANYOF_UPPER ANYOF_VERTWS
syn keyword xsMacro ANYOF_XDIGIT ARCHLIB ARCHLIB_EXP ARCHNAME ARG ARG1
syn keyword xsMacro ARG1_LOC ARG1_SET ARG2 ARG2L ARG2L_LOC ARG2L_SET ARG2_LOC
syn keyword xsMacro ARG2_SET ARGTARG ARG_LOC ARG_SET ARG_VALUE ARG__SET ARROW
syn keyword xsMacro ASCII_MORE_RESTRICT_PAT_MODS ASCII_RESTRICT_PAT_MOD
syn keyword xsMacro ASCII_RESTRICT_PAT_MODS ASCII_TO_NATIVE ASCII_TO_NEED
syn keyword xsMacro ASCTIME_R_PROTO ASSERT_CURPAD_ACTIVE ASSERT_CURPAD_LEGAL
syn keyword xsMacro ASSIGNOP Atof Atol Atoul AvALLOC AvARRAY AvARYLEN AvFILL
syn keyword xsMacro AvFILLp AvMAX AvREAL AvREALISH AvREAL_off AvREAL_on
syn keyword xsMacro AvREAL_only AvREIFY AvREIFY_off AvREIFY_on AvREIFY_only
syn keyword xsMacro BACK BADVERSION BASEOP BHKf_bhk_eval BHKf_bhk_post_end
syn keyword xsMacro BHKf_bhk_pre_end BHKf_bhk_start BIN BIN_EXP BITANDOP
syn keyword xsMacro BITMAP_BYTE BITMAP_TEST BITOROP BIT_BUCKET BIT_DIGITS BOL
syn keyword xsMacro BOUND BOUNDA BOUNDL BOUNDU BRANCH BRANCHJ BRANCH_next
syn keyword xsMacro BRANCH_next_fail BSD_GETPGRP BSD_SETPGRP BSDish BUFSIZ
syn keyword xsMacro BYTEORDER BhkDISABLE BhkENABLE BhkENTRY BhkENTRY_set
syn keyword xsMacro BhkFLAGS Bit BmFLAGS BmPREVIOUS BmRARE BmUSEFUL
syn keyword xsMacro CALLREGCOMP CALLREGCOMP_ENG CALLREGDUPE CALLREGDUPE_PVT
syn keyword xsMacro CALLREGEXEC CALLREGFREE CALLREGFREE_PVT
syn keyword xsMacro CALLREG_INTUIT_START CALLREG_INTUIT_STRING
syn keyword xsMacro CALLREG_NAMED_BUFF_ALL CALLREG_NAMED_BUFF_CLEAR
syn keyword xsMacro CALLREG_NAMED_BUFF_COUNT CALLREG_NAMED_BUFF_DELETE
syn keyword xsMacro CALLREG_NAMED_BUFF_EXISTS CALLREG_NAMED_BUFF_FETCH
syn keyword xsMacro CALLREG_NAMED_BUFF_FIRSTKEY CALLREG_NAMED_BUFF_NEXTKEY
syn keyword xsMacro CALLREG_NAMED_BUFF_SCALAR CALLREG_NAMED_BUFF_STORE
syn keyword xsMacro CALLREG_NUMBUF_FETCH CALLREG_NUMBUF_LENGTH
syn keyword xsMacro CALLREG_NUMBUF_STORE CALLREG_PACKAGE CALLRUNOPS
syn keyword xsMacro CALL_BLOCK_HOOKS CALL_FPTR CANY CAN_COW_FLAGS
syn keyword xsMacro CAN_COW_MASK CAN_PROTOTYPE CAN_VAPROTO
syn keyword xsMacro CASE_STD_PMMOD_FLAGS_PARSE_SET CASTFLAGS CASTNEGFLOAT
syn keyword xsMacro CAT2 CATCH_GET CATCH_SET CHARBITS CHARSET_PAT_MODS
syn keyword xsMacro CHECK_MALLOC_TAINT CHECK_MALLOC_TOO_LATE_FOR
syn keyword xsMacro CHECK_MALLOC_TOO_LATE_FOR_ CLEAR_ARGARRAY CLEAR_ERRSV
syn keyword xsMacro CLONEf_CLONE_HOST CLONEf_COPY_STACKS CLONEf_JOIN_IN
syn keyword xsMacro CLONEf_KEEP_PTR_TABLE CLOSE CLUMP CLUMP_2IV CLUMP_2UV
syn keyword xsMacro COLONATTR COMMIT COMMIT_next COMMIT_next_fail
syn keyword xsMacro COND_BROADCAST COND_DESTROY COND_INIT COND_SIGNAL
syn keyword xsMacro COND_WAIT CONTINUE CONTINUE_PAT_MOD COPHH_KEY_UTF8
syn keyword xsMacro COP_SEQ_RANGE_HIGH COP_SEQ_RANGE_LOW CPERLarg CPERLarg_
syn keyword xsMacro CPERLscope CPPLAST CPPMINUS CPPRUN CPPSTDIN CRYPT_R_PROTO
syn keyword xsMacro CSH CTERMID_R_PROTO CTIME_R_PROTO CTYPE256 CURLY CURLYM
syn keyword xsMacro CURLYM_A CURLYM_A_fail CURLYM_B CURLYM_B_fail CURLYN
syn keyword xsMacro CURLYX CURLYX_end CURLYX_end_fail CURLY_B_max
syn keyword xsMacro CURLY_B_max_fail CURLY_B_min CURLY_B_min_fail
syn keyword xsMacro CURLY_B_min_known CURLY_B_min_known_fail
syn keyword xsMacro CURRENT_FEATURE_BUNDLE CURRENT_HINTS CUTGROUP
syn keyword xsMacro CUTGROUP_next CUTGROUP_next_fail CVf_ANON CVf_AUTOLOAD
syn keyword xsMacro CVf_BUILTIN_ATTRS CVf_CLONE CVf_CLONED CVf_CONST
syn keyword xsMacro CVf_CVGV_RC CVf_DYNFILE CVf_ISXSUB CVf_LVALUE CVf_METHOD
syn keyword xsMacro CVf_NODEBUG CVf_UNIQUE CVf_WEAKOUTSIDE CXINC CXTYPEMASK
syn keyword xsMacro CX_CURPAD_SAVE CX_CURPAD_SV CXp_FOR_DEF CXp_HASARGS
syn keyword xsMacro CXp_MULTICALL CXp_ONCE CXp_REAL CXp_TRYBLOCK C_ARRAY_END
syn keyword xsMacro C_ARRAY_LENGTH C_FAC_POSIX CopFILE CopFILEAV CopFILEAVx
syn keyword xsMacro CopFILEGV CopFILEGV_set CopFILESV CopFILE_free
syn keyword xsMacro CopFILE_set CopFILE_setn CopHINTHASH_get CopHINTHASH_set
syn keyword xsMacro CopHINTS_get CopHINTS_set CopLABEL CopLABEL_alloc
syn keyword xsMacro CopLABEL_len CopLABEL_len_flags CopLINE CopLINE_dec
syn keyword xsMacro CopLINE_inc CopLINE_set CopSTASH CopSTASHPV
syn keyword xsMacro CopSTASHPV_set CopSTASH_eq CopSTASH_free CopSTASH_len
syn keyword xsMacro CopSTASH_len_set CopSTASH_ne CopSTASH_set Copy CopyD Ctl
syn keyword xsMacro CvANON CvANON_off CvANON_on CvAUTOLOAD CvAUTOLOAD_off
syn keyword xsMacro CvAUTOLOAD_on CvCLONE CvCLONED CvCLONED_off CvCLONED_on
syn keyword xsMacro CvCLONE_off CvCLONE_on CvCONST CvCONST_off CvCONST_on
syn keyword xsMacro CvCVGV_RC CvCVGV_RC_off CvCVGV_RC_on CvDEPTH CvDYNFILE
syn keyword xsMacro CvDYNFILE_off CvDYNFILE_on CvEVAL CvEVAL_off CvEVAL_on
syn keyword xsMacro CvFILE CvFILEGV CvFILE_set_from_cop CvFLAGS CvGV CvGV_set
syn keyword xsMacro CvISXSUB CvISXSUB_off CvISXSUB_on CvLVALUE CvLVALUE_off
syn keyword xsMacro CvLVALUE_on CvMETHOD CvMETHOD_off CvMETHOD_on CvNODEBUG
syn keyword xsMacro CvNODEBUG_off CvNODEBUG_on CvOUTSIDE CvOUTSIDE_SEQ
syn keyword xsMacro CvPADLIST CvPROTO CvPROTOLEN CvROOT CvSPECIAL
syn keyword xsMacro CvSPECIAL_off CvSPECIAL_on CvSTART CvSTASH CvSTASH_set
syn keyword xsMacro CvUNIQUE CvUNIQUE_off CvUNIQUE_on CvWEAKOUTSIDE
syn keyword xsMacro CvWEAKOUTSIDE_off CvWEAKOUTSIDE_on CvXSUB CvXSUBANY
syn keyword xsMacro CxFOREACH CxFOREACHDEF CxHASARGS CxITERVAR
syn keyword xsMacro CxITERVAR_PADSV CxLABEL CxLABEL_len CxLABEL_len_flags
syn keyword xsMacro CxLVAL CxMULTICALL CxOLD_IN_EVAL CxOLD_OP_TYPE CxONCE
syn keyword xsMacro CxPADLOOP CxREALEVAL CxTRYBLOCK CxTYPE CxTYPE_is_LOOP
syn keyword xsMacro DBL_DIG DBL_MAX DBL_MIN DBM_ckFilter DBM_setFilter
syn keyword xsMacro DB_VERSION_MAJOR_CFG DB_VERSION_MINOR_CFG
syn keyword xsMacro DB_VERSION_PATCH_CFG DEBUG_A DEBUG_A_FLAG DEBUG_A_TEST
syn keyword xsMacro DEBUG_A_TEST_ DEBUG_B DEBUG_BUFFERS_r DEBUG_B_FLAG
syn keyword xsMacro DEBUG_B_TEST DEBUG_B_TEST_ DEBUG_C DEBUG_COMPILE_r
syn keyword xsMacro DEBUG_CX DEBUG_C_FLAG DEBUG_C_TEST DEBUG_C_TEST_ DEBUG_D
syn keyword xsMacro DEBUG_DB_RECURSE_FLAG DEBUG_DUMP_r DEBUG_D_FLAG
syn keyword xsMacro DEBUG_D_TEST DEBUG_D_TEST_ DEBUG_EXECUTE_r DEBUG_EXTRA_r
syn keyword xsMacro DEBUG_FLAGS_r DEBUG_GPOS_r DEBUG_H DEBUG_H_FLAG
syn keyword xsMacro DEBUG_H_TEST DEBUG_H_TEST_ DEBUG_INTUIT_r DEBUG_J_FLAG
syn keyword xsMacro DEBUG_J_TEST DEBUG_J_TEST_ DEBUG_M DEBUG_MASK
syn keyword xsMacro DEBUG_MATCH_r DEBUG_M_FLAG DEBUG_M_TEST DEBUG_M_TEST_
syn keyword xsMacro DEBUG_OFFSETS_r DEBUG_OPTIMISE_MORE_r DEBUG_OPTIMISE_r
syn keyword xsMacro DEBUG_P DEBUG_PARSE_r DEBUG_P_FLAG DEBUG_P_TEST
syn keyword xsMacro DEBUG_P_TEST_ DEBUG_Pv DEBUG_Pv_TEST DEBUG_Pv_TEST_
syn keyword xsMacro DEBUG_R DEBUG_R_FLAG DEBUG_R_TEST DEBUG_R_TEST_
syn keyword xsMacro DEBUG_SCOPE DEBUG_STACK_r DEBUG_STATE_r DEBUG_T
syn keyword xsMacro DEBUG_TOP_FLAG DEBUG_TRIE_COMPILE_MORE_r
syn keyword xsMacro DEBUG_TRIE_COMPILE_r DEBUG_TRIE_EXECUTE_MORE_r
syn keyword xsMacro DEBUG_TRIE_EXECUTE_r DEBUG_TRIE_r DEBUG_T_FLAG
syn keyword xsMacro DEBUG_T_TEST DEBUG_T_TEST_ DEBUG_U DEBUG_U_FLAG
syn keyword xsMacro DEBUG_U_TEST DEBUG_U_TEST_ DEBUG_Uv DEBUG_Uv_TEST
syn keyword xsMacro DEBUG_Uv_TEST_ DEBUG_X DEBUG_X_FLAG DEBUG_X_TEST
syn keyword xsMacro DEBUG_X_TEST_ DEBUG_Xv DEBUG_Xv_TEST DEBUG_Xv_TEST_
syn keyword xsMacro DEBUG__ DEBUG_c DEBUG_c_FLAG DEBUG_c_TEST DEBUG_c_TEST_
syn keyword xsMacro DEBUG_f DEBUG_f_FLAG DEBUG_f_TEST DEBUG_f_TEST_ DEBUG_l
syn keyword xsMacro DEBUG_l_FLAG DEBUG_l_TEST DEBUG_l_TEST_ DEBUG_m
syn keyword xsMacro DEBUG_m_FLAG DEBUG_m_TEST DEBUG_m_TEST_ DEBUG_o
syn keyword xsMacro DEBUG_o_FLAG DEBUG_o_TEST DEBUG_o_TEST_ DEBUG_p
syn keyword xsMacro DEBUG_p_FLAG DEBUG_p_TEST DEBUG_p_TEST_ DEBUG_q
syn keyword xsMacro DEBUG_q_FLAG DEBUG_q_TEST DEBUG_q_TEST_ DEBUG_r
syn keyword xsMacro DEBUG_r_FLAG DEBUG_r_TEST DEBUG_r_TEST_ DEBUG_s
syn keyword xsMacro DEBUG_s_FLAG DEBUG_s_TEST DEBUG_s_TEST_ DEBUG_t_FLAG
syn keyword xsMacro DEBUG_t_TEST DEBUG_t_TEST_ DEBUG_u DEBUG_u_FLAG
syn keyword xsMacro DEBUG_u_TEST DEBUG_u_TEST_ DEBUG_v DEBUG_v_FLAG
syn keyword xsMacro DEBUG_v_TEST DEBUG_v_TEST_ DEBUG_x DEBUG_x_FLAG
syn keyword xsMacro DEBUG_x_TEST DEBUG_x_TEST_ DEFAULT DEFAULT_PAT_MOD
syn keyword xsMacro DEFINEP DEFSV DEFSV_set DEPENDS_PAT_MOD DEPENDS_PAT_MODS
syn keyword xsMacro DETACH DIE DIGIT DIGITA DIGITL DIR DM_ARRAY_ISA DM_DELAY
syn keyword xsMacro DM_EGID DM_EUID DM_GID DM_RGID DM_RUID DM_UID DO DOINIT
syn keyword xsMacro DOLSHARP DONT_DECLARE_STD DORDOR DOROP DOSISH DOTDOT
syn keyword xsMacro DOUBLESIZE DO_UTF8 DPTR2FPTR DRAND48_R_PROTO DUP_WARNINGS
syn keyword xsMacro Drand01 ELSE ELSIF EMBEDMYMALLOC END ENDGRENT_R_PROTO
syn keyword xsMacro ENDHOSTENT_R_PROTO ENDLIKE ENDNETENT_R_PROTO
syn keyword xsMacro ENDPROTOENT_R_PROTO ENDPWENT_R_PROTO ENDSERVENT_R_PROTO
syn keyword xsMacro END_EXTERN_C ENTER ENTER_with_name ENTRY_PROBE ENUM_BOOL
syn keyword xsMacro EOF EOL EOS EQOP ERRHV ERRSV EVAL EVAL_AB EVAL_AB_fail
syn keyword xsMacro EVAL_INEVAL EVAL_INREQUIRE EVAL_KEEPERR EVAL_NULL
syn keyword xsMacro EVAL_WARNONLY EXACT EXACTF EXACTFA EXACTFL EXACTFU
syn keyword xsMacro EXACTFU_SS EXACTFU_TRICKYFOLD EXEC_ARGV_CAST EXEC_PAT_MOD
syn keyword xsMacro EXEC_PAT_MODS EXPECT EXT EXTCONST EXTEND EXTEND_MORTAL
syn keyword xsMacro EXTERN_C EXTPERLIO EXTRA_SIZE EXTRA_STEP_2ARGS EXT_MGVTBL
syn keyword xsMacro EXT_PAT_MODS FAKE_BIT_BUCKET FAKE_DEFAULT_SIGNAL_HANDLERS
syn keyword xsMacro FAKE_PERSISTENT_SIGNAL_HANDLERS FBMcf_TAIL
syn keyword xsMacro FBMcf_TAIL_DOLLAR FBMcf_TAIL_DOLLARM FBMcf_TAIL_Z
syn keyword xsMacro FBMcf_TAIL_z FBMrf_MULTILINE FCNTL_CAN_LOCK FD_CLR
syn keyword xsMacro FD_ISSET FD_SET FD_ZERO FEATURE_ARYBASE_IS_ENABLED
syn keyword xsMacro FEATURE_BUNDLE_510 FEATURE_BUNDLE_511 FEATURE_BUNDLE_515
syn keyword xsMacro FEATURE_BUNDLE_CUSTOM FEATURE_BUNDLE_DEFAULT
syn keyword xsMacro FEATURE_EVALBYTES_IS_ENABLED FEATURE_FC_IS_ENABLED
syn keyword xsMacro FEATURE_IS_ENABLED FEATURE_SAY_IS_ENABLED
syn keyword xsMacro FEATURE_STATE_IS_ENABLED FEATURE_SWITCH_IS_ENABLED
syn keyword xsMacro FEATURE_UNICODE_IS_ENABLED FEATURE_UNIEVAL_IS_ENABLED
syn keyword xsMacro FEATURE___SUB___IS_ENABLED FFLUSH_NULL FF_0DECIMAL
syn keyword xsMacro FF_BLANK FF_CHECKCHOP FF_CHECKNL FF_CHOP FF_DECIMAL
syn keyword xsMacro FF_END FF_FETCH FF_HALFSPACE FF_ITEM FF_LINEGLOB
syn keyword xsMacro FF_LINEMARK FF_LINESNGL FF_LITERAL FF_MORE FF_NEWLINE
syn keyword xsMacro FF_SKIP FF_SPACE FILE FILE_base FILE_bufsiz FILE_cnt
syn keyword xsMacro FILE_ptr FILL_ADVANCE_NODE FILL_ADVANCE_NODE_ARG
syn keyword xsMacro FILTER_DATA FILTER_ISREADER FILTER_READ FITS_IN_8_BITS
syn keyword xsMacro FLAGS FLEXFILENAMES FOLDEQ_S1_ALREADY_FOLDED
syn keyword xsMacro FOLDEQ_S2_ALREADY_FOLDED FOLDEQ_UTF8_LOCALE
syn keyword xsMacro FOLDEQ_UTF8_NOMIX_ASCII FOLD_FLAGS_FULL FOLD_FLAGS_LOCALE
syn keyword xsMacro FOR FORMAT FPTR2DPTR FREETMPS FREE_THREAD_KEY FSEEKSIZE
syn keyword xsMacro FUNC FUNC0 FUNC0OP FUNC0SUB FUNC1 FUNCMETH FUNCTION__
syn keyword xsMacro F_atan2_amg F_cos_amg F_exp_amg F_log_amg F_pow_amg
syn keyword xsMacro F_sin_amg F_sqrt_amg Fflush FmLINES FreeOp Fstat
syn keyword xsMacro GDBMNDBM_H_USES_PROTOTYPES GETATARGET GETGRENT_R_PROTO
syn keyword xsMacro GETGRGID_R_PROTO GETGRNAM_R_PROTO GETHOSTBYADDR_R_PROTO
syn keyword xsMacro GETHOSTBYNAME_R_PROTO GETHOSTENT_R_PROTO GETLOGIN_R_PROTO
syn keyword xsMacro GETNETBYADDR_R_PROTO GETNETBYNAME_R_PROTO
syn keyword xsMacro GETNETENT_R_PROTO GETPROTOBYNAME_R_PROTO
syn keyword xsMacro GETPROTOBYNUMBER_R_PROTO GETPROTOENT_R_PROTO
syn keyword xsMacro GETPWENT_R_PROTO GETPWNAM_R_PROTO GETPWUID_R_PROTO
syn keyword xsMacro GETSERVBYNAME_R_PROTO GETSERVBYPORT_R_PROTO
syn keyword xsMacro GETSERVENT_R_PROTO GETSPNAM_R_PROTO GETTARGET
syn keyword xsMacro GETTARGETSTACKED GET_RE_DEBUG_FLAGS
syn keyword xsMacro GET_RE_DEBUG_FLAGS_DECL GIMME GIMME_V GIVEN
syn keyword xsMacro GLOBAL_PAT_MOD GMTIME_MAX GMTIME_MIN GMTIME_R
syn keyword xsMacro GMTIME_R_PROTO GOSTART GOSUB GPOS GRAMBARESTMT GRAMBLOCK
syn keyword xsMacro GRAMEXPR GRAMFULLSTMT GRAMPROG GRAMSTMTSEQ
syn keyword xsMacro GREEK_CAPITAL_LETTER_MU GREEK_SMALL_LETTER_MU
syn keyword xsMacro GROK_NUMERIC_RADIX GROUPP GRPASSWD GV_ADD GV_ADDINEVAL
syn keyword xsMacro GV_ADDMG GV_ADDMULTI GV_ADDWARN GV_AUTOLOAD
syn keyword xsMacro GV_AUTOLOAD_ISMETHOD GV_CROAK GV_NOADD_MASK
syn keyword xsMacro GV_NOADD_NOINIT GV_NOEXPAND GV_NOINIT GV_NOTQUAL
syn keyword xsMacro GV_NO_SVGMAGIC GVf_ASSUMECV GVf_IMPORTED GVf_IMPORTED_AV
syn keyword xsMacro GVf_IMPORTED_CV GVf_IMPORTED_HV GVf_IMPORTED_SV GVf_INTRO
syn keyword xsMacro GVf_IN_PAD GVf_MULTI Gconvert Gid_t_f Gid_t_sign
syn keyword xsMacro Gid_t_size GvASSIGN_GENERATION GvASSIGN_GENERATION_set
syn keyword xsMacro GvASSUMECV GvASSUMECV_off GvASSUMECV_on GvAV GvAVn GvCV
syn keyword xsMacro GvCVGEN GvCV_set GvCVu GvEGV GvEGVx GvENAME GvENAMELEN
syn keyword xsMacro GvENAMEUTF8 GvENAME_HEK GvESTASH GvFILE GvFILEGV
syn keyword xsMacro GvFILE_HEK GvFLAGS GvFORM GvGP GvGP_set GvHV GvHVn
syn keyword xsMacro GvIMPORTED GvIMPORTED_AV GvIMPORTED_AV_off
syn keyword xsMacro GvIMPORTED_AV_on GvIMPORTED_CV GvIMPORTED_CV_off
syn keyword xsMacro GvIMPORTED_CV_on GvIMPORTED_HV GvIMPORTED_HV_off
syn keyword xsMacro GvIMPORTED_HV_on GvIMPORTED_SV GvIMPORTED_SV_off
syn keyword xsMacro GvIMPORTED_SV_on GvIMPORTED_off GvIMPORTED_on GvINTRO
syn keyword xsMacro GvINTRO_off GvINTRO_on GvIN_PAD GvIN_PAD_off GvIN_PAD_on
syn keyword xsMacro GvIO GvIOn GvIOp GvLINE GvMULTI GvMULTI_off GvMULTI_on
syn keyword xsMacro GvNAME GvNAMELEN GvNAMELEN_get GvNAMEUTF8 GvNAME_HEK
syn keyword xsMacro GvNAME_get GvREFCNT GvSTASH GvSV GvSVn GvXPVGV Gv_AMG
syn keyword xsMacro HASATTRIBUTE_DEPRECATED HASATTRIBUTE_FORMAT
syn keyword xsMacro HASATTRIBUTE_MALLOC HASATTRIBUTE_NONNULL
syn keyword xsMacro HASATTRIBUTE_NORETURN HASATTRIBUTE_PURE
syn keyword xsMacro HASATTRIBUTE_UNUSED HASATTRIBUTE_WARN_UNUSED_RESULT
syn keyword xsMacro HASCONST HASHBRACK HASVOLATILE HAS_64K_LIMIT HAS_ACCESS
syn keyword xsMacro HAS_ALARM HAS_ATOLL HAS_BCMP HAS_BCOPY HAS_BOOL
syn keyword xsMacro HAS_BUILTIN_CHOOSE_EXPR HAS_BUILTIN_EXPECT HAS_BZERO
syn keyword xsMacro HAS_C99_VARIADIC_MACROS HAS_CHOWN HAS_CHROOT HAS_CLEARENV
syn keyword xsMacro HAS_COPYSIGNL HAS_CRYPT HAS_CTERMID HAS_CUSERID
syn keyword xsMacro HAS_DBL_DIG HAS_DBMINIT_PROTO HAS_DIFFTIME HAS_DIRFD
syn keyword xsMacro HAS_DLERROR HAS_DRAND48_PROTO HAS_DUP2 HAS_EACCESS
syn keyword xsMacro HAS_ENDGRENT HAS_ENDHOSTENT HAS_ENDNETENT HAS_ENDPROTOENT
syn keyword xsMacro HAS_ENDPWENT HAS_ENDSERVENT HAS_FAST_STDIO HAS_FCHDIR
syn keyword xsMacro HAS_FCHMOD HAS_FCHOWN HAS_FCNTL HAS_FD_SET HAS_FGETPOS
syn keyword xsMacro HAS_FINITE HAS_FINITEL HAS_FLOCK HAS_FLOCK_PROTO HAS_FORK
syn keyword xsMacro HAS_FPATHCONF HAS_FREXPL HAS_FSEEKO HAS_FSETPOS
syn keyword xsMacro HAS_FSTATFS HAS_FSTATVFS HAS_FSYNC HAS_FTELLO HAS_FUTIMES
syn keyword xsMacro HAS_GETADDRINFO HAS_GETCWD HAS_GETGRENT HAS_GETGROUPS
syn keyword xsMacro HAS_GETHOSTBYADDR HAS_GETHOSTBYNAME HAS_GETHOSTENT
syn keyword xsMacro HAS_GETHOSTNAME HAS_GETHOST_PROTOS HAS_GETITIMER
syn keyword xsMacro HAS_GETLOGIN HAS_GETMNTENT HAS_GETNAMEINFO
syn keyword xsMacro HAS_GETNETBYADDR HAS_GETNETBYNAME HAS_GETNETENT
syn keyword xsMacro HAS_GETNET_PROTOS HAS_GETPAGESIZE HAS_GETPGID HAS_GETPGRP
syn keyword xsMacro HAS_GETPPID HAS_GETPRIORITY HAS_GETPROTOBYNAME
syn keyword xsMacro HAS_GETPROTOBYNUMBER HAS_GETPROTOENT HAS_GETPROTO_PROTOS
syn keyword xsMacro HAS_GETPWENT HAS_GETSERVBYNAME HAS_GETSERVBYPORT
syn keyword xsMacro HAS_GETSERVENT HAS_GETSERV_PROTOS HAS_GETSPNAM
syn keyword xsMacro HAS_GETTIMEOFDAY HAS_GNULIBC HAS_GROUP HAS_HASMNTOPT
syn keyword xsMacro HAS_HTOVL HAS_HTOVS HAS_ILOGBL HAS_INETNTOP HAS_INETPTON
syn keyword xsMacro HAS_INET_ATON HAS_INT64_T HAS_IOCTL HAS_IPV6_MREQ
syn keyword xsMacro HAS_ISASCII HAS_ISBLANK HAS_ISINF HAS_ISNAN HAS_ISNANL
syn keyword xsMacro HAS_KILL HAS_KILLPG HAS_LCHOWN HAS_LDBL_DIG HAS_LINK
syn keyword xsMacro HAS_LOCALECONV HAS_LOCKF HAS_LONG_DOUBLE HAS_LONG_LONG
syn keyword xsMacro HAS_LSEEK_PROTO HAS_LSTAT HAS_MADVISE HAS_MBLEN
syn keyword xsMacro HAS_MBSTOWCS HAS_MBTOWC HAS_MEMCHR HAS_MEMCMP HAS_MEMCPY
syn keyword xsMacro HAS_MEMMOVE HAS_MEMSET HAS_MKDIR HAS_MKDTEMP HAS_MKFIFO
syn keyword xsMacro HAS_MKSTEMP HAS_MKSTEMPS HAS_MKTIME HAS_MMAP HAS_MODFL
syn keyword xsMacro HAS_MODFL_PROTO HAS_MPROTECT HAS_MSG HAS_MSG_CTRUNC
syn keyword xsMacro HAS_MSG_DONTROUTE HAS_MSG_OOB HAS_MSG_PEEK HAS_MSG_PROXY
syn keyword xsMacro HAS_MSYNC HAS_MUNMAP HAS_NICE HAS_NL_LANGINFO HAS_OPEN3
syn keyword xsMacro HAS_PASSWD HAS_PATHCONF HAS_PAUSE HAS_PIPE HAS_POLL
syn keyword xsMacro HAS_PRCTL HAS_PRCTL_SET_NAME HAS_PROCSELFEXE
syn keyword xsMacro HAS_PTHREAD_ATTR_SETSCOPE
syn keyword xsMacro HAS_PTHREAD_UNCHECKED_GETSPECIFIC_NP HAS_READDIR
syn keyword xsMacro HAS_READLINK HAS_READV HAS_RECVMSG HAS_RENAME
syn keyword xsMacro HAS_REWINDDIR HAS_RMDIR HAS_SANE_MEMCMP HAS_SBRK_PROTO
syn keyword xsMacro HAS_SCALBNL HAS_SCHED_YIELD HAS_SCM_RIGHTS HAS_SEEKDIR
syn keyword xsMacro HAS_SELECT HAS_SEM HAS_SENDMSG HAS_SETEGID HAS_SETEUID
syn keyword xsMacro HAS_SETGRENT HAS_SETGROUPS HAS_SETHOSTENT HAS_SETITIMER
syn keyword xsMacro HAS_SETLINEBUF HAS_SETLOCALE HAS_SETNETENT HAS_SETPGID
syn keyword xsMacro HAS_SETPGRP HAS_SETPRIORITY HAS_SETPROTOENT HAS_SETPWENT
syn keyword xsMacro HAS_SETREGID HAS_SETRESGID HAS_SETRESUID HAS_SETREUID
syn keyword xsMacro HAS_SETSERVENT HAS_SETSID HAS_SETVBUF HAS_SHM
syn keyword xsMacro HAS_SHMAT_PROTOTYPE HAS_SIGACTION HAS_SIGNBIT
syn keyword xsMacro HAS_SIGPROCMASK HAS_SIGSETJMP HAS_SIN6_SCOPE_ID
syn keyword xsMacro HAS_SNPRINTF HAS_SOCKADDR_IN6 HAS_SOCKATMARK
syn keyword xsMacro HAS_SOCKATMARK_PROTO HAS_SOCKET HAS_SQRTL
syn keyword xsMacro HAS_STATIC_INLINE HAS_STRCHR HAS_STRCOLL HAS_STRFTIME
syn keyword xsMacro HAS_STRTOD HAS_STRTOL HAS_STRTOLD HAS_STRTOLL HAS_STRTOQ
syn keyword xsMacro HAS_STRTOUL HAS_STRTOULL HAS_STRTOUQ HAS_STRUCT_CMSGHDR
syn keyword xsMacro HAS_STRUCT_MSGHDR HAS_STRUCT_STATFS
syn keyword xsMacro HAS_STRUCT_STATFS_F_FLAGS HAS_STRXFRM HAS_SYMLINK
syn keyword xsMacro HAS_SYSCALL HAS_SYSCALL_PROTO HAS_SYSCONF HAS_SYSTEM
syn keyword xsMacro HAS_SYS_ERRLIST HAS_TCGETPGRP HAS_TCSETPGRP HAS_TELLDIR
syn keyword xsMacro HAS_TELLDIR_PROTO HAS_TIME HAS_TIMEGM HAS_TIMES
syn keyword xsMacro HAS_TM_TM_GMTOFF HAS_TM_TM_ZONE HAS_TRUNCATE HAS_TZNAME
syn keyword xsMacro HAS_UALARM HAS_UMASK HAS_UNAME HAS_UNSETENV HAS_USLEEP
syn keyword xsMacro HAS_USLEEP_PROTO HAS_USTAT HAS_UTIME HAS_VPRINTF
syn keyword xsMacro HAS_VSNPRINTF HAS_VTOHL HAS_VTOHS HAS_WAIT HAS_WAIT4
syn keyword xsMacro HAS_WAITPID HAS_WCSTOMBS HAS_WCTOMB HAS_WRITEV
syn keyword xsMacro HAVE_THREAD_INTERN HEK_BASESIZE HEK_FLAGS HEK_HASH
syn keyword xsMacro HEK_KEY HEK_LEN HEK_REHASH HEK_REHASH_on HEK_UTF8
syn keyword xsMacro HEK_UTF8_off HEK_UTF8_on HEK_WASUTF8 HEK_WASUTF8_off
syn keyword xsMacro HEK_WASUTF8_on HEKf HEKf256 HEKfARG HE_SVSLOT HEf_SVKEY
syn keyword xsMacro HINTS_REFCNT_INIT HINTS_REFCNT_LOCK HINTS_REFCNT_TERM
syn keyword xsMacro HINTS_REFCNT_UNLOCK HINT_BLOCK_SCOPE HINT_BYTES
syn keyword xsMacro HINT_EXPLICIT_STRICT_REFS HINT_EXPLICIT_STRICT_SUBS
syn keyword xsMacro HINT_EXPLICIT_STRICT_VARS HINT_FEATURE_MASK
syn keyword xsMacro HINT_FEATURE_SHIFT HINT_FILETEST_ACCESS HINT_INTEGER
syn keyword xsMacro HINT_LEXICAL_IO_IN HINT_LEXICAL_IO_OUT HINT_LOCALE
syn keyword xsMacro HINT_LOCALE_NOT_CHARS HINT_LOCALIZE_HH HINT_NEW_BINARY
syn keyword xsMacro HINT_NEW_FLOAT HINT_NEW_INTEGER HINT_NEW_RE
syn keyword xsMacro HINT_NEW_STRING HINT_NO_AMAGIC HINT_RE_EVAL HINT_RE_FLAGS
syn keyword xsMacro HINT_RE_TAINT HINT_SORT_MERGESORT HINT_SORT_QUICKSORT
syn keyword xsMacro HINT_SORT_SORT_BITS HINT_SORT_STABLE HINT_STRICT_REFS
syn keyword xsMacro HINT_STRICT_SUBS HINT_STRICT_VARS HINT_UNI_8_BIT
syn keyword xsMacro HINT_UTF8 HORIZWS HV_DELETE HV_DISABLE_UVAR_XKEY
syn keyword xsMacro HV_FETCH_EMPTY_HE HV_FETCH_ISEXISTS HV_FETCH_ISSTORE
syn keyword xsMacro HV_FETCH_JUST_SV HV_FETCH_LVALUE
syn keyword xsMacro HV_ITERNEXT_WANTPLACEHOLDERS HV_NAME_SETALL
syn keyword xsMacro HVhek_ENABLEHVKFLAGS HVhek_FREEKEY HVhek_KEYCANONICAL
syn keyword xsMacro HVhek_MASK HVhek_PLACEHOLD HVhek_REHASH HVhek_UNSHARED
syn keyword xsMacro HVhek_UTF8 HVhek_WASUTF8 HVrhek_IV HVrhek_PV
syn keyword xsMacro HVrhek_PV_UTF8 HVrhek_UV HVrhek_delete HVrhek_typemask
syn keyword xsMacro HVrhek_undef H_PERL HeHASH HeKEY HeKEY_hek HeKEY_sv
syn keyword xsMacro HeKFLAGS HeKLEN HeKLEN_UTF8 HeKREHASH HeKUTF8 HeKWASUTF8
syn keyword xsMacro HeNEXT HePV HeSVKEY HeSVKEY_force HeSVKEY_set HeUTF8
syn keyword xsMacro HeVAL HvARRAY HvAUX HvEITER HvEITER_get HvEITER_set
syn keyword xsMacro HvENAME HvENAMELEN HvENAMELEN_get HvENAMEUTF8 HvENAME_HEK
syn keyword xsMacro HvENAME_HEK_NN HvENAME_get HvFILL HvHASKFLAGS
syn keyword xsMacro HvHASKFLAGS_off HvHASKFLAGS_on HvKEYS HvLAZYDEL
syn keyword xsMacro HvLAZYDEL_off HvLAZYDEL_on HvMAX HvMROMETA HvNAME
syn keyword xsMacro HvNAMELEN HvNAMELEN_get HvNAMEUTF8 HvNAME_HEK
syn keyword xsMacro HvNAME_HEK_NN HvNAME_get HvPLACEHOLDERS
syn keyword xsMacro HvPLACEHOLDERS_get HvPLACEHOLDERS_set HvREHASH
syn keyword xsMacro HvREHASH_off HvREHASH_on HvRITER HvRITER_get HvRITER_set
syn keyword xsMacro HvSHAREKEYS HvSHAREKEYS_off HvSHAREKEYS_on HvTOTALKEYS
syn keyword xsMacro HvUSEDKEYS I16SIZE I16TYPE I16_MAX I16_MIN I286 I32SIZE
syn keyword xsMacro I32TYPE I32_MAX I32_MAX_P1 I32_MIN I64SIZE I64TYPE I8SIZE
syn keyword xsMacro I8TYPE I8_TO_NATIVE IF IFMATCH IFMATCH_A IFMATCH_A_fail
syn keyword xsMacro IFTHEN IGNORE_PAT_MOD INIT INIT_THREADS
syn keyword xsMacro INIT_TRACK_MEMPOOL INSUBP INT2PTR INT32_MIN INT64_C
syn keyword xsMacro INT64_MIN INTSIZE INT_64_T INT_PAT_MODS
syn keyword xsMacro INVERSION_UNAFFECTED_FLAGS IN_BYTES IN_LOCALE
syn keyword xsMacro IN_LOCALE_COMPILETIME IN_LOCALE_RUNTIME
syn keyword xsMacro IN_PERL_COMPILETIME IN_PERL_RUNTIME IN_SOME_LOCALE_FORM
syn keyword xsMacro IN_SOME_LOCALE_FORM_COMPILETIME
syn keyword xsMacro IN_SOME_LOCALE_FORM_RUNTIME IN_UNI_8_BIT IOCPARM_LEN
syn keyword xsMacro IOf_ARGV IOf_DIDTOP IOf_FAKE_DIRP IOf_FLUSH IOf_NOLINE
syn keyword xsMacro IOf_START IOf_UNTAINT ISHISH IS_ANYOF_TRIE
syn keyword xsMacro IS_NUMBER_GREATER_THAN_UV_MAX IS_NUMBER_INFINITY
syn keyword xsMacro IS_NUMBER_IN_UV IS_NUMBER_NAN IS_NUMBER_NEG
syn keyword xsMacro IS_NUMBER_NOT_INT IS_NUMERIC_RADIX IS_PADCONST IS_PADGV
syn keyword xsMacro IS_TRIE_AC IS_UTF8_CHAR IS_UTF8_CHAR_1 IS_UTF8_CHAR_2
syn keyword xsMacro IS_UTF8_CHAR_3 IS_UTF8_CHAR_3a IS_UTF8_CHAR_3b
syn keyword xsMacro IS_UTF8_CHAR_3c IS_UTF8_CHAR_3d IS_UTF8_CHAR_4
syn keyword xsMacro IS_UTF8_CHAR_4a IS_UTF8_CHAR_4b IS_UTF8_CHAR_4c
syn keyword xsMacro IS_UTF8_CHAR_5 IS_UTF8_CHAR_5a IS_UTF8_CHAR_5b
syn keyword xsMacro IS_UTF8_CHAR_FAST IVSIZE IVTYPE IV_DIG IV_MAX IV_MAX_P1
syn keyword xsMacro IV_MIN I_32 I_ARPA_INET I_ASSERT I_CRYPT I_DBM I_DIRENT
syn keyword xsMacro I_DLFCN I_FLOAT I_GDBM I_GDBMNDBM I_GRP I_INTTYPES
syn keyword xsMacro I_LANGINFO I_LIMITS I_LOCALE I_MATH I_MNTENT I_NETDB
syn keyword xsMacro I_NETINET_IN I_NETINET_TCP I_POLL I_PTHREAD I_PWD
syn keyword xsMacro I_SHADOW I_STDARG I_STDBOOL I_STDDEF I_STDLIB I_STRING
syn keyword xsMacro I_SYSLOG I_SYSUIO I_SYSUTSNAME I_SYS_DIR I_SYS_FILE
syn keyword xsMacro I_SYS_IOCTL I_SYS_MOUNT I_SYS_PARAM I_SYS_POLL
syn keyword xsMacro I_SYS_RESOURCE I_SYS_SELECT I_SYS_STAT I_SYS_STATFS
syn keyword xsMacro I_SYS_STATVFS I_SYS_TIME I_SYS_TIMES I_SYS_TYPES I_SYS_UN
syn keyword xsMacro I_SYS_VFS I_SYS_WAIT I_TERMIOS I_TIME I_UNISTD I_USTAT
syn keyword xsMacro I_UTIME I_V I_VALUES IoANY IoBOTTOM_GV IoBOTTOM_NAME
syn keyword xsMacro IoDIRP IoFLAGS IoFMT_GV IoFMT_NAME IoIFP IoLINES
syn keyword xsMacro IoLINES_LEFT IoOFP IoPAGE IoPAGE_LEN IoTOP_GV IoTOP_NAME
syn keyword xsMacro IoTYPE IoTYPE_APPEND IoTYPE_CLOSED IoTYPE_IMPLICIT
syn keyword xsMacro IoTYPE_NUMERIC IoTYPE_PIPE IoTYPE_RDONLY IoTYPE_RDWR
syn keyword xsMacro IoTYPE_SOCKET IoTYPE_STD IoTYPE_WRONLY IsSet
syn keyword xsMacro JMPENV_BOOTSTRAP JMPENV_JUMP JMPENV_POP JMPENV_PUSH JOIN
syn keyword xsMacro KEEPCOPY_PAT_MOD KEEPCOPY_PAT_MODS KEEPS KEEPS_next
syn keyword xsMacro KEEPS_next_fail KEYWORD_PLUGIN_DECLINE
syn keyword xsMacro KEYWORD_PLUGIN_EXPR KEYWORD_PLUGIN_STMT KEY_AUTOLOAD
syn keyword xsMacro KEY_BEGIN KEY_CHECK KEY_CORE KEY_DESTROY KEY_END KEY_INIT
syn keyword xsMacro KEY_NULL KEY_UNITCHECK KEY___DATA__ KEY___END__
syn keyword xsMacro KEY___FILE__ KEY___LINE__ KEY___PACKAGE__ KEY___SUB__
syn keyword xsMacro KEY_abs KEY_accept KEY_alarm KEY_and KEY_atan2 KEY_bind
syn keyword xsMacro KEY_binmode KEY_bless KEY_break KEY_caller KEY_chdir
syn keyword xsMacro KEY_chmod KEY_chomp KEY_chop KEY_chown KEY_chr KEY_chroot
syn keyword xsMacro KEY_close KEY_closedir KEY_cmp KEY_connect KEY_continue
syn keyword xsMacro KEY_cos KEY_crypt KEY_dbmclose KEY_dbmopen KEY_default
syn keyword xsMacro KEY_defined KEY_delete KEY_die KEY_do KEY_dump KEY_each
syn keyword xsMacro KEY_else KEY_elsif KEY_endgrent KEY_endhostent
syn keyword xsMacro KEY_endnetent KEY_endprotoent KEY_endpwent KEY_endservent
syn keyword xsMacro KEY_eof KEY_eq KEY_eval KEY_evalbytes KEY_exec KEY_exists
syn keyword xsMacro KEY_exit KEY_exp KEY_fc KEY_fcntl KEY_fileno KEY_flock
syn keyword xsMacro KEY_for KEY_foreach KEY_fork KEY_format KEY_formline
syn keyword xsMacro KEY_ge KEY_getc KEY_getgrent KEY_getgrgid KEY_getgrnam
syn keyword xsMacro KEY_gethostbyaddr KEY_gethostbyname KEY_gethostent
syn keyword xsMacro KEY_getlogin KEY_getnetbyaddr KEY_getnetbyname
syn keyword xsMacro KEY_getnetent KEY_getpeername KEY_getpgrp KEY_getppid
syn keyword xsMacro KEY_getpriority KEY_getprotobyname KEY_getprotobynumber
syn keyword xsMacro KEY_getprotoent KEY_getpwent KEY_getpwnam KEY_getpwuid
syn keyword xsMacro KEY_getservbyname KEY_getservbyport KEY_getservent
syn keyword xsMacro KEY_getsockname KEY_getsockopt KEY_given KEY_glob
syn keyword xsMacro KEY_gmtime KEY_goto KEY_grep KEY_gt KEY_hex KEY_if
syn keyword xsMacro KEY_index KEY_int KEY_ioctl KEY_join KEY_keys KEY_kill
syn keyword xsMacro KEY_last KEY_lc KEY_lcfirst KEY_le KEY_length KEY_link
syn keyword xsMacro KEY_listen KEY_local KEY_localtime KEY_lock KEY_log
syn keyword xsMacro KEY_lstat KEY_lt KEY_m KEY_map KEY_mkdir KEY_msgctl
syn keyword xsMacro KEY_msgget KEY_msgrcv KEY_msgsnd KEY_my KEY_ne KEY_next
syn keyword xsMacro KEY_no KEY_not KEY_oct KEY_open KEY_opendir KEY_or
syn keyword xsMacro KEY_ord KEY_our KEY_pack KEY_package KEY_pipe KEY_pop
syn keyword xsMacro KEY_pos KEY_print KEY_printf KEY_prototype KEY_push KEY_q
syn keyword xsMacro KEY_qq KEY_qr KEY_quotemeta KEY_qw KEY_qx KEY_rand
syn keyword xsMacro KEY_read KEY_readdir KEY_readline KEY_readlink
syn keyword xsMacro KEY_readpipe KEY_recv KEY_redo KEY_ref KEY_rename
syn keyword xsMacro KEY_require KEY_reset KEY_return KEY_reverse
syn keyword xsMacro KEY_rewinddir KEY_rindex KEY_rmdir KEY_s KEY_say
syn keyword xsMacro KEY_scalar KEY_seek KEY_seekdir KEY_select KEY_semctl
syn keyword xsMacro KEY_semget KEY_semop KEY_send KEY_setgrent KEY_sethostent
syn keyword xsMacro KEY_setnetent KEY_setpgrp KEY_setpriority KEY_setprotoent
syn keyword xsMacro KEY_setpwent KEY_setservent KEY_setsockopt KEY_shift
syn keyword xsMacro KEY_shmctl KEY_shmget KEY_shmread KEY_shmwrite
syn keyword xsMacro KEY_shutdown KEY_sin KEY_sleep KEY_socket KEY_socketpair
syn keyword xsMacro KEY_sort KEY_splice KEY_split KEY_sprintf KEY_sqrt
syn keyword xsMacro KEY_srand KEY_stat KEY_state KEY_study KEY_sub KEY_substr
syn keyword xsMacro KEY_symlink KEY_syscall KEY_sysopen KEY_sysread
syn keyword xsMacro KEY_sysseek KEY_system KEY_syswrite KEY_tell KEY_telldir
syn keyword xsMacro KEY_tie KEY_tied KEY_time KEY_times KEY_tr KEY_truncate
syn keyword xsMacro KEY_uc KEY_ucfirst KEY_umask KEY_undef KEY_unless
syn keyword xsMacro KEY_unlink KEY_unpack KEY_unshift KEY_untie KEY_until
syn keyword xsMacro KEY_use KEY_utime KEY_values KEY_vec KEY_wait KEY_waitpid
syn keyword xsMacro KEY_wantarray KEY_warn KEY_when KEY_while KEY_write KEY_x
syn keyword xsMacro KEY_xor KEY_y LABEL
syn keyword xsMacro LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE
syn keyword xsMacro LATIN_CAPITAL_LETTER_SHARP_S
syn keyword xsMacro LATIN_CAPITAL_LETTER_Y_WITH_DIAERESIS
syn keyword xsMacro LATIN_SMALL_LETTER_A_WITH_RING_ABOVE
syn keyword xsMacro LATIN_SMALL_LETTER_SHARP_S
syn keyword xsMacro LATIN_SMALL_LETTER_Y_WITH_DIAERESIS LDBL_DIG LEAVE
syn keyword xsMacro LEAVESUB LEAVE_SCOPE LEAVE_with_name LEX_DONT_CLOSE_RSFP
syn keyword xsMacro LEX_EVALBYTES LEX_IGNORE_UTF8_HINTS LEX_KEEP_PREVIOUS
syn keyword xsMacro LEX_NOTPARSING LEX_START_COPIED LEX_START_FLAGS
syn keyword xsMacro LEX_START_SAME_FILTER LEX_STUFF_UTF8 LIBERAL
syn keyword xsMacro LIBM_LIB_VERSION LIB_INVARG LIKELY LINKLIST LNBREAK LOCAL
syn keyword xsMacro LOCALE_PAT_MOD LOCALE_PAT_MODS LOCALTIME_MAX
syn keyword xsMacro LOCALTIME_MIN LOCALTIME_R LOCALTIME_R_PROTO
syn keyword xsMacro LOCAL_PATCH_COUNT LOCK_DOLLARZERO_MUTEX LOC_SED LOGICAL
syn keyword xsMacro LONGJMP LONGLONGSIZE LONGSIZE LONG_DOUBLESIZE
syn keyword xsMacro LONG_DOUBLE_EQUALS_DOUBLE LOOPEX LOOP_PAT_MODS LSEEKSIZE
syn keyword xsMacro LSTOP LSTOPSUB LVRET L_R_TZSET LvFLAGS LvTARG LvTARGLEN
syn keyword xsMacro LvTARGOFF LvTYPE MADPROP_IN_BASEOP MAD_NULL MAD_OP MAD_PV
syn keyword xsMacro MAD_SV MALLOC_CHECK_TAINT MALLOC_CHECK_TAINT2
syn keyword xsMacro MALLOC_CTL_H MALLOC_INIT MALLOC_OVERHEAD MALLOC_TERM
syn keyword xsMacro MALLOC_TOO_LATE_FOR MARKPOINT MARKPOINT_next
syn keyword xsMacro MARKPOINT_next_fail MASK MATCHOP MAXARG MAXO MAXPATHLEN
syn keyword xsMacro MAXSYSFD MAX_CHARSET_NAME_LENGTH MAX_FEATURE_LEN
syn keyword xsMacro MAX_PORTABLE_UTF8_TWO_BYTE
syn keyword xsMacro MAX_RECURSE_EVAL_NOCHANGE_DEPTH MAYBE_DEREF_GV
syn keyword xsMacro MAYBE_DEREF_GV_flags MAYBE_DEREF_GV_nomg MBOL
syn keyword xsMacro MEMBER_TO_FPTR MEM_ALIGNBYTES MEM_LOG_ALLOC MEM_LOG_FREE
syn keyword xsMacro MEM_LOG_REALLOC MEM_SIZE MEM_SIZE_MAX MEM_WRAP_CHECK
syn keyword xsMacro MEM_WRAP_CHECK_ MEM_WRAP_CHECK_1 MEM_WRAP_CHECK_2 MEOL
syn keyword xsMacro METHOD MEXTEND MGf_COPY MGf_DUP MGf_GSKIP MGf_LOCAL
syn keyword xsMacro MGf_MINMATCH MGf_REFCOUNTED MGf_TAINTEDDIR MICRO_SIGN
syn keyword xsMacro MINMOD MJD_OFFSET_DEBUG MRO_GET_PRIVATE_DATA MSPAGAIN
syn keyword xsMacro MULOP MULTICALL MULTILINE_PAT_MOD MULTIPLICITY MUTABLE_AV
syn keyword xsMacro MUTABLE_CV MUTABLE_GV MUTABLE_HV MUTABLE_IO MUTABLE_PTR
syn keyword xsMacro MUTABLE_SV MUTEX_DESTROY MUTEX_INIT
syn keyword xsMacro MUTEX_INIT_CALLS_MALLOC MUTEX_INIT_NEEDS_MUTEX_ZEROED
syn keyword xsMacro MUTEX_LOCK MUTEX_UNLOCK MY MYSUB MYSWAP MY_CXT_CLONE
syn keyword xsMacro MY_CXT_INDEX MY_CXT_INIT MY_CXT_INIT_ARG
syn keyword xsMacro MY_CXT_INIT_INTERP M_PAT_MODS M_VOID MgPV MgPV_const
syn keyword xsMacro MgPV_nolen_const MgTAINTEDDIR MgTAINTEDDIR_off
syn keyword xsMacro MgTAINTEDDIR_on Mkdir Move MoveD NALNUM NALNUMA NALNUML
syn keyword xsMacro NALNUMU NATIVE8_TO_UNI NATIVE_IS_INVARIANT
syn keyword xsMacro NATIVE_TO_ASCII NATIVE_TO_I8 NATIVE_TO_NEED NATIVE_TO_UNI
syn keyword xsMacro NATIVE_TO_UTF NBOUND NBOUNDA NBOUNDL NBOUNDU
syn keyword xsMacro NDBM_H_USES_PROTOTYPES NDIGIT NDIGITA NDIGITL
syn keyword xsMacro NEED_PTHREAD_INIT NEED_VA_COPY NEGATIVE_INDICES_VAR
syn keyword xsMacro NETDB_R_OBSOLETE NEWSV NEXTOPER NEXT_LINE_CHAR NEXT_OFF
syn keyword xsMacro NGROUPP NHORIZWS NOAMP NODE_ALIGN NODE_ALIGN_FILL
syn keyword xsMacro NODE_STEP_B NODE_STEP_REGNODE NODE_SZ_STR NOLINE
syn keyword xsMacro NONDESTRUCT_PAT_MOD NONDESTRUCT_PAT_MODS NOOP
syn keyword xsMacro NORETURN_FUNCTION_END NORMAL NOTHING NOTOP NOT_IN_PAD
syn keyword xsMacro NO_ENV_ARRAY_IN_MAIN NO_LOCALE
syn keyword xsMacro NO_LOCALECONV_MON_THOUSANDS_SEP NREF NREFF NREFFA NREFFL
syn keyword xsMacro NREFFU NSIG NSPACE NSPACEA NSPACEL NSPACEU NUM2PTR
syn keyword xsMacro NVERTWS NVSIZE NVTYPE NV_DIG NV_EPSILON NV_INF
syn keyword xsMacro NV_MANT_DIG NV_MAX NV_MAX_10_EXP NV_MIN NV_MIN_10_EXP
syn keyword xsMacro NV_NAN NV_OVERFLOWS_INTEGERS_AT NV_PRESERVES_UV_BITS
syn keyword xsMacro NV_WITHIN_IV NV_WITHIN_UV New NewOp NewOpSz Newc Newx
syn keyword xsMacro Newxc Newxz Newz NofAMmeth Null Nullav Nullch Nullcv
syn keyword xsMacro Nullfp Nullgv Nullhe Nullhek Nullhv Nullop Nullsv OASHIFT
syn keyword xsMacro OCSHIFT ONCE_PAT_MOD ONCE_PAT_MODS OPEN OPERAND OPFAIL
syn keyword xsMacro OPTIMIZED OP_BINARY OP_CHECK_MUTEX_INIT
syn keyword xsMacro OP_CHECK_MUTEX_LOCK OP_CHECK_MUTEX_TERM
syn keyword xsMacro OP_CHECK_MUTEX_UNLOCK OP_CLASS OP_DESC OP_GIMME
syn keyword xsMacro OP_GIMME_REVERSE OP_IS_DIRHOP OP_IS_FILETEST
syn keyword xsMacro OP_IS_FILETEST_ACCESS OP_IS_NUMCOMPARE OP_IS_SOCKET
syn keyword xsMacro OP_LVALUE_NO_CROAK OP_MEM_TO_REG OP_NAME OP_REFCNT_INIT
syn keyword xsMacro OP_REFCNT_LOCK OP_REFCNT_TERM OP_REFCNT_UNLOCK
syn keyword xsMacro OP_REG_TO_MEM OROP OROR OSNAME OSVERS O_CREAT O_RDONLY
syn keyword xsMacro O_RDWR O_TEXT O_WRONLY Off Off_t_size OpREFCNT_dec
syn keyword xsMacro OpREFCNT_inc OpREFCNT_set OutCopFILE PAD_BASE_SV
syn keyword xsMacro PAD_CLONE_VARS PAD_COMPNAME_FLAGS
syn keyword xsMacro PAD_COMPNAME_FLAGS_isOUR PAD_COMPNAME_GEN
syn keyword xsMacro PAD_COMPNAME_GEN_set PAD_COMPNAME_OURSTASH
syn keyword xsMacro PAD_COMPNAME_PV PAD_COMPNAME_SV PAD_COMPNAME_TYPE
syn keyword xsMacro PAD_FAKELEX_ANON PAD_FAKELEX_MULTI PAD_RESTORE_LOCAL
syn keyword xsMacro PAD_SAVE_LOCAL PAD_SAVE_SETNULLPAD PAD_SETSV PAD_SET_CUR
syn keyword xsMacro PAD_SET_CUR_NOSAVE PAD_SV PAD_SVl PARENT_FAKELEX_FLAGS
syn keyword xsMacro PARENT_PAD_INDEX PARSE_OPTIONAL PATCHLEVEL PEG PERLDB_ALL
syn keyword xsMacro PERLDB_GOTO PERLDB_INTER PERLDB_LINE PERLDB_NAMEANON
syn keyword xsMacro PERLDB_NAMEEVAL PERLDB_NOOPT PERLDB_SAVESRC
syn keyword xsMacro PERLDB_SAVESRC_INVALID PERLDB_SAVESRC_NOSUBS
syn keyword xsMacro PERLDB_SINGLE PERLDB_SUB PERLDB_SUBLINE PERLDB_SUB_NN
syn keyword xsMacro PERLDBf_GOTO PERLDBf_INTER PERLDBf_LINE PERLDBf_NAMEANON
syn keyword xsMacro PERLDBf_NAMEEVAL PERLDBf_NONAME PERLDBf_NOOPT
syn keyword xsMacro PERLDBf_SAVESRC PERLDBf_SAVESRC_INVALID
syn keyword xsMacro PERLDBf_SAVESRC_NOSUBS PERLDBf_SINGLE PERLDBf_SUB
syn keyword xsMacro PERLDBf_SUBLINE PERLIOBUF_DEFAULT_BUFSIZ PERLIO_DUP_CLONE
syn keyword xsMacro PERLIO_DUP_FD PERLIO_FUNCS_CAST PERLIO_FUNCS_CONST
syn keyword xsMacro PERLIO_FUNCS_DECL PERLIO_F_APPEND PERLIO_F_CANREAD
syn keyword xsMacro PERLIO_F_CANWRITE PERLIO_F_CLEARED PERLIO_F_CRLF
syn keyword xsMacro PERLIO_F_EOF PERLIO_F_ERROR PERLIO_F_FASTGETS
syn keyword xsMacro PERLIO_F_LINEBUF PERLIO_F_NOTREG PERLIO_F_OPEN
syn keyword xsMacro PERLIO_F_RDBUF PERLIO_F_TEMP PERLIO_F_TRUNCATE
syn keyword xsMacro PERLIO_F_TTY PERLIO_F_UNBUF PERLIO_F_UTF8 PERLIO_F_WRBUF
syn keyword xsMacro PERLIO_INIT PERLIO_IS_STDIO PERLIO_K_BUFFERED
syn keyword xsMacro PERLIO_K_CANCRLF PERLIO_K_DESTRUCT PERLIO_K_DUMMY
syn keyword xsMacro PERLIO_K_FASTGETS PERLIO_K_MULTIARG PERLIO_K_RAW
syn keyword xsMacro PERLIO_K_UTF8 PERLIO_LAYERS PERLIO_NOT_STDIO
syn keyword xsMacro PERLIO_STDTEXT PERLIO_TERM PERLIO_USING_CRLF
syn keyword xsMacro PERLSI_DESTROY PERLSI_DIEHOOK PERLSI_MAGIC PERLSI_MAIN
syn keyword xsMacro PERLSI_OVERLOAD PERLSI_REQUIRE PERLSI_SIGNAL PERLSI_SORT
syn keyword xsMacro PERLSI_UNDEF PERLSI_UNKNOWN PERLSI_WARNHOOK PERL_ABS
syn keyword xsMacro PERL_ALLOC_CHECK PERL_API_REVISION PERL_API_SUBVERSION
syn keyword xsMacro PERL_API_VERSION PERL_API_VERSION_STRING
syn keyword xsMacro PERL_ARENA_ROOTS_SIZE PERL_ARENA_SIZE
syn keyword xsMacro PERL_ARGS_ASSERT_ADD_ALTERNATE PERL_ARGS_ASSERT_ADD_DATA
syn keyword xsMacro PERL_ARGS_ASSERT_ADD_UTF16_TEXTFILTER
syn keyword xsMacro PERL_ARGS_ASSERT_ADJUST_STACK_ON_LEAVE
syn keyword xsMacro PERL_ARGS_ASSERT_ALLOCMY PERL_ARGS_ASSERT_AMAGIC_CALL
syn keyword xsMacro PERL_ARGS_ASSERT_AMAGIC_CMP
syn keyword xsMacro PERL_ARGS_ASSERT_AMAGIC_CMP_LOCALE
syn keyword xsMacro PERL_ARGS_ASSERT_AMAGIC_DEREF_CALL
syn keyword xsMacro PERL_ARGS_ASSERT_AMAGIC_I_NCMP
syn keyword xsMacro PERL_ARGS_ASSERT_AMAGIC_NCMP
syn keyword xsMacro PERL_ARGS_ASSERT_ANONYMISE_CV_MAYBE
syn keyword xsMacro PERL_ARGS_ASSERT_ANY_DUP PERL_ARGS_ASSERT_APPLY
syn keyword xsMacro PERL_ARGS_ASSERT_APPLY_ATTRS
syn keyword xsMacro PERL_ARGS_ASSERT_APPLY_ATTRS_MY
syn keyword xsMacro PERL_ARGS_ASSERT_APPLY_ATTRS_STRING
syn keyword xsMacro PERL_ARGS_ASSERT_ASSERT_UFT8_CACHE_COHERENT
syn keyword xsMacro PERL_ARGS_ASSERT_AV_ARYLEN_P PERL_ARGS_ASSERT_AV_CLEAR
syn keyword xsMacro PERL_ARGS_ASSERT_AV_CREATE_AND_PUSH
syn keyword xsMacro PERL_ARGS_ASSERT_AV_CREATE_AND_UNSHIFT_ONE
syn keyword xsMacro PERL_ARGS_ASSERT_AV_DELETE PERL_ARGS_ASSERT_AV_EXISTS
syn keyword xsMacro PERL_ARGS_ASSERT_AV_EXTEND PERL_ARGS_ASSERT_AV_FETCH
syn keyword xsMacro PERL_ARGS_ASSERT_AV_FILL PERL_ARGS_ASSERT_AV_ITER_P
syn keyword xsMacro PERL_ARGS_ASSERT_AV_LEN PERL_ARGS_ASSERT_AV_MAKE
syn keyword xsMacro PERL_ARGS_ASSERT_AV_POP PERL_ARGS_ASSERT_AV_PUSH
syn keyword xsMacro PERL_ARGS_ASSERT_AV_REIFY PERL_ARGS_ASSERT_AV_SHIFT
syn keyword xsMacro PERL_ARGS_ASSERT_AV_STORE PERL_ARGS_ASSERT_AV_UNDEF
syn keyword xsMacro PERL_ARGS_ASSERT_AV_UNSHIFT PERL_ARGS_ASSERT_BAD_TYPE_PV
syn keyword xsMacro PERL_ARGS_ASSERT_BAD_TYPE_SV PERL_ARGS_ASSERT_BIND_MATCH
syn keyword xsMacro PERL_ARGS_ASSERT_BLOCKHOOK_REGISTER
syn keyword xsMacro PERL_ARGS_ASSERT_BYTES_CMP_UTF8
syn keyword xsMacro PERL_ARGS_ASSERT_BYTES_FROM_UTF8
syn keyword xsMacro PERL_ARGS_ASSERT_BYTES_TO_UNI
syn keyword xsMacro PERL_ARGS_ASSERT_BYTES_TO_UTF8 PERL_ARGS_ASSERT_CALL_ARGV
syn keyword xsMacro PERL_ARGS_ASSERT_CALL_LIST PERL_ARGS_ASSERT_CALL_METHOD
syn keyword xsMacro PERL_ARGS_ASSERT_CALL_PV PERL_ARGS_ASSERT_CALL_SV
syn keyword xsMacro PERL_ARGS_ASSERT_CANDO PERL_ARGS_ASSERT_CHECKCOMMA
syn keyword xsMacro PERL_ARGS_ASSERT_CHECKPOSIXCC
syn keyword xsMacro PERL_ARGS_ASSERT_CHECK_LOCALE_BOUNDARY_CROSSING
syn keyword xsMacro PERL_ARGS_ASSERT_CHECK_TYPE_AND_OPEN
syn keyword xsMacro PERL_ARGS_ASSERT_CHECK_UTF8_PRINT
syn keyword xsMacro PERL_ARGS_ASSERT_CK_ANONCODE PERL_ARGS_ASSERT_CK_BITOP
syn keyword xsMacro PERL_ARGS_ASSERT_CK_CHDIR PERL_ARGS_ASSERT_CK_CMP
syn keyword xsMacro PERL_ARGS_ASSERT_CK_CONCAT PERL_ARGS_ASSERT_CK_DEFINED
syn keyword xsMacro PERL_ARGS_ASSERT_CK_DELETE PERL_ARGS_ASSERT_CK_DIE
syn keyword xsMacro PERL_ARGS_ASSERT_CK_EACH
syn keyword xsMacro PERL_ARGS_ASSERT_CK_ENTERSUB_ARGS_CORE
syn keyword xsMacro PERL_ARGS_ASSERT_CK_ENTERSUB_ARGS_LIST
syn keyword xsMacro PERL_ARGS_ASSERT_CK_ENTERSUB_ARGS_PROTO
syn keyword xsMacro PERL_ARGS_ASSERT_CK_ENTERSUB_ARGS_PROTO_OR_LIST
syn keyword xsMacro PERL_ARGS_ASSERT_CK_EOF PERL_ARGS_ASSERT_CK_EVAL
syn keyword xsMacro PERL_ARGS_ASSERT_CK_EXEC PERL_ARGS_ASSERT_CK_EXISTS
syn keyword xsMacro PERL_ARGS_ASSERT_CK_EXIT PERL_ARGS_ASSERT_CK_FTST
syn keyword xsMacro PERL_ARGS_ASSERT_CK_FUN PERL_ARGS_ASSERT_CK_GLOB
syn keyword xsMacro PERL_ARGS_ASSERT_CK_GREP PERL_ARGS_ASSERT_CK_INDEX
syn keyword xsMacro PERL_ARGS_ASSERT_CK_JOIN PERL_ARGS_ASSERT_CK_LENGTH
syn keyword xsMacro PERL_ARGS_ASSERT_CK_LFUN PERL_ARGS_ASSERT_CK_LISTIOB
syn keyword xsMacro PERL_ARGS_ASSERT_CK_MATCH PERL_ARGS_ASSERT_CK_METHOD
syn keyword xsMacro PERL_ARGS_ASSERT_CK_NULL PERL_ARGS_ASSERT_CK_OPEN
syn keyword xsMacro PERL_ARGS_ASSERT_CK_READLINE PERL_ARGS_ASSERT_CK_REPEAT
syn keyword xsMacro PERL_ARGS_ASSERT_CK_REQUIRE PERL_ARGS_ASSERT_CK_RETURN
syn keyword xsMacro PERL_ARGS_ASSERT_CK_RFUN PERL_ARGS_ASSERT_CK_RVCONST
syn keyword xsMacro PERL_ARGS_ASSERT_CK_SASSIGN PERL_ARGS_ASSERT_CK_SELECT
syn keyword xsMacro PERL_ARGS_ASSERT_CK_SHIFT PERL_ARGS_ASSERT_CK_SMARTMATCH
syn keyword xsMacro PERL_ARGS_ASSERT_CK_SORT PERL_ARGS_ASSERT_CK_SPAIR
syn keyword xsMacro PERL_ARGS_ASSERT_CK_SPLIT PERL_ARGS_ASSERT_CK_SUBR
syn keyword xsMacro PERL_ARGS_ASSERT_CK_SUBSTR PERL_ARGS_ASSERT_CK_SVCONST
syn keyword xsMacro PERL_ARGS_ASSERT_CK_TELL PERL_ARGS_ASSERT_CK_TRUNC
syn keyword xsMacro PERL_ARGS_ASSERT_CK_WARNER PERL_ARGS_ASSERT_CK_WARNER_D
syn keyword xsMacro PERL_ARGS_ASSERT_CLEAR_PLACEHOLDERS
syn keyword xsMacro PERL_ARGS_ASSERT_CLONE_PARAMS_DEL
syn keyword xsMacro PERL_ARGS_ASSERT_CLONE_PARAMS_NEW
syn keyword xsMacro PERL_ARGS_ASSERT_CLOSEST_COP PERL_ARGS_ASSERT_CL_AND
syn keyword xsMacro PERL_ARGS_ASSERT_CL_ANYTHING PERL_ARGS_ASSERT_CL_INIT
syn keyword xsMacro PERL_ARGS_ASSERT_CL_IS_ANYTHING PERL_ARGS_ASSERT_CL_OR
syn keyword xsMacro PERL_ARGS_ASSERT_COP_FETCH_LABEL
syn keyword xsMacro PERL_ARGS_ASSERT_COP_FREE
syn keyword xsMacro PERL_ARGS_ASSERT_COP_STORE_LABEL
syn keyword xsMacro PERL_ARGS_ASSERT_CORESUB_OP
syn keyword xsMacro PERL_ARGS_ASSERT_CORE_PROTOTYPE
syn keyword xsMacro PERL_ARGS_ASSERT_CORE_REGCLASS_SWASH
syn keyword xsMacro PERL_ARGS_ASSERT_CROAK_SV PERL_ARGS_ASSERT_CROAK_XS_USAGE
syn keyword xsMacro PERL_ARGS_ASSERT_CURSE PERL_ARGS_ASSERT_CUSTOM_OP_DESC
syn keyword xsMacro PERL_ARGS_ASSERT_CUSTOM_OP_NAME
syn keyword xsMacro PERL_ARGS_ASSERT_CUSTOM_OP_REGISTER
syn keyword xsMacro PERL_ARGS_ASSERT_CUSTOM_OP_XOP PERL_ARGS_ASSERT_CVGV_SET
syn keyword xsMacro PERL_ARGS_ASSERT_CVSTASH_SET
syn keyword xsMacro PERL_ARGS_ASSERT_CV_CKPROTO_LEN_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_CV_CLONE PERL_ARGS_ASSERT_CV_DUMP
syn keyword xsMacro PERL_ARGS_ASSERT_CV_GET_CALL_CHECKER
syn keyword xsMacro PERL_ARGS_ASSERT_CV_SET_CALL_CHECKER
syn keyword xsMacro PERL_ARGS_ASSERT_CV_UNDEF PERL_ARGS_ASSERT_CX_DUMP
syn keyword xsMacro PERL_ARGS_ASSERT_CX_DUP PERL_ARGS_ASSERT_DEB
syn keyword xsMacro PERL_ARGS_ASSERT_DEBOP PERL_ARGS_ASSERT_DEBPROF
syn keyword xsMacro PERL_ARGS_ASSERT_DEBUG_START_MATCH
syn keyword xsMacro PERL_ARGS_ASSERT_DEB_NOCONTEXT
syn keyword xsMacro PERL_ARGS_ASSERT_DEB_STACK_N PERL_ARGS_ASSERT_DELIMCPY
syn keyword xsMacro PERL_ARGS_ASSERT_DEL_SV PERL_ARGS_ASSERT_DESTROY_MATCHER
syn keyword xsMacro PERL_ARGS_ASSERT_DIE_SV PERL_ARGS_ASSERT_DIE_UNWIND
syn keyword xsMacro PERL_ARGS_ASSERT_DIRP_DUP PERL_ARGS_ASSERT_DIV128
syn keyword xsMacro PERL_ARGS_ASSERT_DOFILE PERL_ARGS_ASSERT_DOFINDLABEL
syn keyword xsMacro PERL_ARGS_ASSERT_DOFORM PERL_ARGS_ASSERT_DOONELINER
syn keyword xsMacro PERL_ARGS_ASSERT_DOOPEN_PM PERL_ARGS_ASSERT_DOPARSEFORM
syn keyword xsMacro PERL_ARGS_ASSERT_DOPOPTOLABEL
syn keyword xsMacro PERL_ARGS_ASSERT_DOPOPTOSUB_AT PERL_ARGS_ASSERT_DOREF
syn keyword xsMacro PERL_ARGS_ASSERT_DO_AEXEC PERL_ARGS_ASSERT_DO_AEXEC5
syn keyword xsMacro PERL_ARGS_ASSERT_DO_ASPAWN PERL_ARGS_ASSERT_DO_BINMODE
syn keyword xsMacro PERL_ARGS_ASSERT_DO_CHOMP PERL_ARGS_ASSERT_DO_DUMP_PAD
syn keyword xsMacro PERL_ARGS_ASSERT_DO_EOF PERL_ARGS_ASSERT_DO_EXEC
syn keyword xsMacro PERL_ARGS_ASSERT_DO_EXEC3 PERL_ARGS_ASSERT_DO_GVGV_DUMP
syn keyword xsMacro PERL_ARGS_ASSERT_DO_GV_DUMP PERL_ARGS_ASSERT_DO_HV_DUMP
syn keyword xsMacro PERL_ARGS_ASSERT_DO_IPCCTL PERL_ARGS_ASSERT_DO_IPCGET
syn keyword xsMacro PERL_ARGS_ASSERT_DO_JOIN PERL_ARGS_ASSERT_DO_MAGIC_DUMP
syn keyword xsMacro PERL_ARGS_ASSERT_DO_MSGRCV PERL_ARGS_ASSERT_DO_MSGSND
syn keyword xsMacro PERL_ARGS_ASSERT_DO_NCMP PERL_ARGS_ASSERT_DO_ODDBALL
syn keyword xsMacro PERL_ARGS_ASSERT_DO_OPEN PERL_ARGS_ASSERT_DO_OPEN9
syn keyword xsMacro PERL_ARGS_ASSERT_DO_OPENN PERL_ARGS_ASSERT_DO_OP_DUMP
syn keyword xsMacro PERL_ARGS_ASSERT_DO_OP_XMLDUMP
syn keyword xsMacro PERL_ARGS_ASSERT_DO_PMOP_DUMP
syn keyword xsMacro PERL_ARGS_ASSERT_DO_PMOP_XMLDUMP
syn keyword xsMacro PERL_ARGS_ASSERT_DO_PRINT PERL_ARGS_ASSERT_DO_SEMOP
syn keyword xsMacro PERL_ARGS_ASSERT_DO_SHMIO PERL_ARGS_ASSERT_DO_SPAWN
syn keyword xsMacro PERL_ARGS_ASSERT_DO_SPAWN_NOWAIT
syn keyword xsMacro PERL_ARGS_ASSERT_DO_SPRINTF PERL_ARGS_ASSERT_DO_SV_DUMP
syn keyword xsMacro PERL_ARGS_ASSERT_DO_SYSSEEK PERL_ARGS_ASSERT_DO_TELL
syn keyword xsMacro PERL_ARGS_ASSERT_DO_TRANS
syn keyword xsMacro PERL_ARGS_ASSERT_DO_TRANS_COMPLEX
syn keyword xsMacro PERL_ARGS_ASSERT_DO_TRANS_COMPLEX_UTF8
syn keyword xsMacro PERL_ARGS_ASSERT_DO_TRANS_COUNT
syn keyword xsMacro PERL_ARGS_ASSERT_DO_TRANS_COUNT_UTF8
syn keyword xsMacro PERL_ARGS_ASSERT_DO_TRANS_SIMPLE
syn keyword xsMacro PERL_ARGS_ASSERT_DO_TRANS_SIMPLE_UTF8
syn keyword xsMacro PERL_ARGS_ASSERT_DO_VECGET PERL_ARGS_ASSERT_DO_VECSET
syn keyword xsMacro PERL_ARGS_ASSERT_DO_VOP PERL_ARGS_ASSERT_DUMPUNTIL
syn keyword xsMacro PERL_ARGS_ASSERT_DUMP_EXEC_POS PERL_ARGS_ASSERT_DUMP_FDS
syn keyword xsMacro PERL_ARGS_ASSERT_DUMP_FORM PERL_ARGS_ASSERT_DUMP_INDENT
syn keyword xsMacro PERL_ARGS_ASSERT_DUMP_MSTATS
syn keyword xsMacro PERL_ARGS_ASSERT_DUMP_PACKSUBS
syn keyword xsMacro PERL_ARGS_ASSERT_DUMP_PACKSUBS_PERL
syn keyword xsMacro PERL_ARGS_ASSERT_DUMP_SUB PERL_ARGS_ASSERT_DUMP_SUB_PERL
syn keyword xsMacro PERL_ARGS_ASSERT_DUMP_SV_CHILD PERL_ARGS_ASSERT_DUMP_TRIE
syn keyword xsMacro PERL_ARGS_ASSERT_DUMP_TRIE_INTERIM_LIST
syn keyword xsMacro PERL_ARGS_ASSERT_DUMP_TRIE_INTERIM_TABLE
syn keyword xsMacro PERL_ARGS_ASSERT_DUMP_VINDENT
syn keyword xsMacro PERL_ARGS_ASSERT_DUP_ATTRLIST
syn keyword xsMacro PERL_ARGS_ASSERT_EMULATE_COP_IO PERL_ARGS_ASSERT_EVAL_PV
syn keyword xsMacro PERL_ARGS_ASSERT_EVAL_SV PERL_ARGS_ASSERT_EXEC_FAILED
syn keyword xsMacro PERL_ARGS_ASSERT_EXPECT_NUMBER PERL_ARGS_ASSERT_F0CONVERT
syn keyword xsMacro PERL_ARGS_ASSERT_FBM_COMPILE PERL_ARGS_ASSERT_FBM_INSTR
syn keyword xsMacro PERL_ARGS_ASSERT_FEATURE_IS_ENABLED
syn keyword xsMacro PERL_ARGS_ASSERT_FILTER_DEL PERL_ARGS_ASSERT_FILTER_GETS
syn keyword xsMacro PERL_ARGS_ASSERT_FILTER_READ PERL_ARGS_ASSERT_FINALIZE_OP
syn keyword xsMacro PERL_ARGS_ASSERT_FINALIZE_OPTREE
syn keyword xsMacro PERL_ARGS_ASSERT_FIND_AND_FORGET_PMOPS
syn keyword xsMacro PERL_ARGS_ASSERT_FIND_ARRAY_SUBSCRIPT
syn keyword xsMacro PERL_ARGS_ASSERT_FIND_BEGINNING
syn keyword xsMacro PERL_ARGS_ASSERT_FIND_BYCLASS
syn keyword xsMacro PERL_ARGS_ASSERT_FIND_HASH_SUBSCRIPT
syn keyword xsMacro PERL_ARGS_ASSERT_FIND_IN_MY_STASH
syn keyword xsMacro PERL_ARGS_ASSERT_FIND_RUNDEFSV2
syn keyword xsMacro PERL_ARGS_ASSERT_FIND_SCRIPT
syn keyword xsMacro PERL_ARGS_ASSERT_FIRST_SYMBOL PERL_ARGS_ASSERT_FOLDEQ
syn keyword xsMacro PERL_ARGS_ASSERT_FOLDEQ_LATIN1
syn keyword xsMacro PERL_ARGS_ASSERT_FOLDEQ_LOCALE
syn keyword xsMacro PERL_ARGS_ASSERT_FOLDEQ_UTF8_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_FOLD_CONSTANTS
syn keyword xsMacro PERL_ARGS_ASSERT_FORCE_IDENT
syn keyword xsMacro PERL_ARGS_ASSERT_FORCE_STRICT_VERSION
syn keyword xsMacro PERL_ARGS_ASSERT_FORCE_VERSION
syn keyword xsMacro PERL_ARGS_ASSERT_FORCE_WORD PERL_ARGS_ASSERT_FORGET_PMOP
syn keyword xsMacro PERL_ARGS_ASSERT_FORM PERL_ARGS_ASSERT_FORM_NOCONTEXT
syn keyword xsMacro PERL_ARGS_ASSERT_FPRINTF_NOCONTEXT
syn keyword xsMacro PERL_ARGS_ASSERT_FP_DUP
syn keyword xsMacro PERL_ARGS_ASSERT_FREE_GLOBAL_STRUCT
syn keyword xsMacro PERL_ARGS_ASSERT_GETCWD_SV PERL_ARGS_ASSERT_GETENV_LEN
syn keyword xsMacro PERL_ARGS_ASSERT_GET_AUX_MG PERL_ARGS_ASSERT_GET_AV
syn keyword xsMacro PERL_ARGS_ASSERT_GET_CV PERL_ARGS_ASSERT_GET_CVN_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_GET_DB_SUB
syn keyword xsMacro PERL_ARGS_ASSERT_GET_DEBUG_OPTS PERL_ARGS_ASSERT_GET_HV
syn keyword xsMacro PERL_ARGS_ASSERT_GET_INVLIST_ITER_ADDR
syn keyword xsMacro PERL_ARGS_ASSERT_GET_INVLIST_LEN_ADDR
syn keyword xsMacro PERL_ARGS_ASSERT_GET_INVLIST_VERSION_ID_ADDR
syn keyword xsMacro PERL_ARGS_ASSERT_GET_INVLIST_ZERO_ADDR
syn keyword xsMacro PERL_ARGS_ASSERT_GET_MSTATS PERL_ARGS_ASSERT_GET_NUM
syn keyword xsMacro PERL_ARGS_ASSERT_GET_SV PERL_ARGS_ASSERT_GLOB_2NUMBER
syn keyword xsMacro PERL_ARGS_ASSERT_GLOB_ASSIGN_GLOB
syn keyword xsMacro PERL_ARGS_ASSERT_GLOB_ASSIGN_REF PERL_ARGS_ASSERT_GP_DUP
syn keyword xsMacro PERL_ARGS_ASSERT_GROK_BIN PERL_ARGS_ASSERT_GROK_BSLASH_O
syn keyword xsMacro PERL_ARGS_ASSERT_GROK_HEX PERL_ARGS_ASSERT_GROK_NUMBER
syn keyword xsMacro PERL_ARGS_ASSERT_GROK_NUMERIC_RADIX
syn keyword xsMacro PERL_ARGS_ASSERT_GROK_OCT PERL_ARGS_ASSERT_GROUP_END
syn keyword xsMacro PERL_ARGS_ASSERT_GV_AMUPDATE
syn keyword xsMacro PERL_ARGS_ASSERT_GV_AUTOLOAD_PV
syn keyword xsMacro PERL_ARGS_ASSERT_GV_AUTOLOAD_PVN
syn keyword xsMacro PERL_ARGS_ASSERT_GV_AUTOLOAD_SV PERL_ARGS_ASSERT_GV_CHECK
syn keyword xsMacro PERL_ARGS_ASSERT_GV_CONST_SV PERL_ARGS_ASSERT_GV_DUMP
syn keyword xsMacro PERL_ARGS_ASSERT_GV_EFULLNAME
syn keyword xsMacro PERL_ARGS_ASSERT_GV_EFULLNAME3
syn keyword xsMacro PERL_ARGS_ASSERT_GV_EFULLNAME4 PERL_ARGS_ASSERT_GV_ENAME
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHFILE
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHFILE_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHMETHOD
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHMETHOD_AUTOLOAD
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHMETHOD_PVN_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHMETHOD_PV_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHMETHOD_SV_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHMETH_PV
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHMETH_PVN
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHMETH_PVN_AUTOLOAD
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHMETH_PV_AUTOLOAD
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHMETH_SV
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHMETH_SV_AUTOLOAD
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHPV
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHPVN_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FETCHSV PERL_ARGS_ASSERT_GV_FULLNAME
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FULLNAME3
syn keyword xsMacro PERL_ARGS_ASSERT_GV_FULLNAME4
syn keyword xsMacro PERL_ARGS_ASSERT_GV_GET_SUPER_PKG
syn keyword xsMacro PERL_ARGS_ASSERT_GV_INIT_PV PERL_ARGS_ASSERT_GV_INIT_PVN
syn keyword xsMacro PERL_ARGS_ASSERT_GV_INIT_SV
syn keyword xsMacro PERL_ARGS_ASSERT_GV_INIT_SVTYPE
syn keyword xsMacro PERL_ARGS_ASSERT_GV_MAGICALIZE_ISA
syn keyword xsMacro PERL_ARGS_ASSERT_GV_MAGICALIZE_OVERLOAD
syn keyword xsMacro PERL_ARGS_ASSERT_GV_NAME_SET PERL_ARGS_ASSERT_GV_STASHPV
syn keyword xsMacro PERL_ARGS_ASSERT_GV_STASHPVN PERL_ARGS_ASSERT_GV_STASHSV
syn keyword xsMacro PERL_ARGS_ASSERT_GV_TRY_DOWNGRADE
syn keyword xsMacro PERL_ARGS_ASSERT_HEK_DUP PERL_ARGS_ASSERT_HE_DUP
syn keyword xsMacro PERL_ARGS_ASSERT_HFREEENTRIES
syn keyword xsMacro PERL_ARGS_ASSERT_HFREE_NEXT_ENTRY PERL_ARGS_ASSERT_HSPLIT
syn keyword xsMacro PERL_ARGS_ASSERT_HV_ASSERT PERL_ARGS_ASSERT_HV_AUXINIT
syn keyword xsMacro PERL_ARGS_ASSERT_HV_BACKREFERENCES_P
syn keyword xsMacro PERL_ARGS_ASSERT_HV_CLEAR_PLACEHOLDERS
syn keyword xsMacro PERL_ARGS_ASSERT_HV_COMMON_KEY_LEN
syn keyword xsMacro PERL_ARGS_ASSERT_HV_DELAYFREE_ENT
syn keyword xsMacro PERL_ARGS_ASSERT_HV_DELETE PERL_ARGS_ASSERT_HV_DELETE_ENT
syn keyword xsMacro PERL_ARGS_ASSERT_HV_EITER_P PERL_ARGS_ASSERT_HV_EITER_SET
syn keyword xsMacro PERL_ARGS_ASSERT_HV_ENAME_ADD
syn keyword xsMacro PERL_ARGS_ASSERT_HV_ENAME_DELETE
syn keyword xsMacro PERL_ARGS_ASSERT_HV_EXISTS PERL_ARGS_ASSERT_HV_EXISTS_ENT
syn keyword xsMacro PERL_ARGS_ASSERT_HV_FETCH PERL_ARGS_ASSERT_HV_FETCH_ENT
syn keyword xsMacro PERL_ARGS_ASSERT_HV_FILL PERL_ARGS_ASSERT_HV_FREE_ENT
syn keyword xsMacro PERL_ARGS_ASSERT_HV_FREE_ENT_RET
syn keyword xsMacro PERL_ARGS_ASSERT_HV_ITERINIT PERL_ARGS_ASSERT_HV_ITERKEY
syn keyword xsMacro PERL_ARGS_ASSERT_HV_ITERKEYSV
syn keyword xsMacro PERL_ARGS_ASSERT_HV_ITERNEXT
syn keyword xsMacro PERL_ARGS_ASSERT_HV_ITERNEXTSV
syn keyword xsMacro PERL_ARGS_ASSERT_HV_ITERNEXT_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_HV_ITERVAL
syn keyword xsMacro PERL_ARGS_ASSERT_HV_KILL_BACKREFS
syn keyword xsMacro PERL_ARGS_ASSERT_HV_KSPLIT PERL_ARGS_ASSERT_HV_MAGIC
syn keyword xsMacro PERL_ARGS_ASSERT_HV_MAGIC_CHECK
syn keyword xsMacro PERL_ARGS_ASSERT_HV_NAME_SET
syn keyword xsMacro PERL_ARGS_ASSERT_HV_NOTALLOWED
syn keyword xsMacro PERL_ARGS_ASSERT_HV_PLACEHOLDERS_GET
syn keyword xsMacro PERL_ARGS_ASSERT_HV_PLACEHOLDERS_P
syn keyword xsMacro PERL_ARGS_ASSERT_HV_PLACEHOLDERS_SET
syn keyword xsMacro PERL_ARGS_ASSERT_HV_RITER_P PERL_ARGS_ASSERT_HV_RITER_SET
syn keyword xsMacro PERL_ARGS_ASSERT_HV_SCALAR PERL_ARGS_ASSERT_INCLINE
syn keyword xsMacro PERL_ARGS_ASSERT_INCPUSH
syn keyword xsMacro PERL_ARGS_ASSERT_INCPUSH_IF_EXISTS
syn keyword xsMacro PERL_ARGS_ASSERT_INCPUSH_USE_SEP
syn keyword xsMacro PERL_ARGS_ASSERT_INIT_ARGV_SYMBOLS
syn keyword xsMacro PERL_ARGS_ASSERT_INIT_POSTDUMP_SYMBOLS
syn keyword xsMacro PERL_ARGS_ASSERT_INIT_TM PERL_ARGS_ASSERT_INPLACE_AASSIGN
syn keyword xsMacro PERL_ARGS_ASSERT_INSTR PERL_ARGS_ASSERT_INTUIT_METHOD
syn keyword xsMacro PERL_ARGS_ASSERT_INTUIT_MORE
syn keyword xsMacro PERL_ARGS_ASSERT_INVLIST_ARRAY
syn keyword xsMacro PERL_ARGS_ASSERT_INVLIST_CLONE
syn keyword xsMacro PERL_ARGS_ASSERT_INVLIST_EXTEND
syn keyword xsMacro PERL_ARGS_ASSERT_INVLIST_ITERINIT
syn keyword xsMacro PERL_ARGS_ASSERT_INVLIST_ITERNEXT
syn keyword xsMacro PERL_ARGS_ASSERT_INVLIST_LEN PERL_ARGS_ASSERT_INVLIST_MAX
syn keyword xsMacro PERL_ARGS_ASSERT_INVLIST_SEARCH
syn keyword xsMacro PERL_ARGS_ASSERT_INVLIST_SET_LEN
syn keyword xsMacro PERL_ARGS_ASSERT_INVLIST_TRIM PERL_ARGS_ASSERT_IO_CLOSE
syn keyword xsMacro PERL_ARGS_ASSERT_ISA_LOOKUP PERL_ARGS_ASSERT_IS_AN_INT
syn keyword xsMacro PERL_ARGS_ASSERT_IS_ASCII_STRING
syn keyword xsMacro PERL_ARGS_ASSERT_IS_HANDLE_CONSTRUCTOR
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_ALNUM
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_ALPHA
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_ASCII
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_CHAR
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_CHAR_BUF
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_CHAR_SLOW
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_CNTRL
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_COMMON
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_DIGIT
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_GRAPH
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_IDCONT
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_IDFIRST
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_LOWER
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_MARK
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_PERL_SPACE
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_PERL_WORD
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_POSIX_DIGIT
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_PRINT
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_PUNCT
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_SPACE
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_STRING
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_STRING_LOC
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_STRING_LOCLEN
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_UPPER
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_XDIGIT
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_XIDCONT
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_XIDFIRST
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_X_BEGIN
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_X_EXTEND
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_X_L
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_X_LV
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_X_LVT
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_X_LV_LVT_V
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_X_NON_HANGUL
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_X_PREPEND
syn keyword xsMacro PERL_ARGS_ASSERT_IS_UTF8_X_T PERL_ARGS_ASSERT_IS_UTF8_X_V
syn keyword xsMacro PERL_ARGS_ASSERT_JMAYBE PERL_ARGS_ASSERT_JOIN_EXACT
syn keyword xsMacro PERL_ARGS_ASSERT_KEYWORD
syn keyword xsMacro PERL_ARGS_ASSERT_KEYWORD_PLUGIN_STANDARD
syn keyword xsMacro PERL_ARGS_ASSERT_LEX_DISCARD_TO
syn keyword xsMacro PERL_ARGS_ASSERT_LEX_READ_TO
syn keyword xsMacro PERL_ARGS_ASSERT_LEX_STUFF_PV
syn keyword xsMacro PERL_ARGS_ASSERT_LEX_STUFF_PVN
syn keyword xsMacro PERL_ARGS_ASSERT_LEX_STUFF_SV
syn keyword xsMacro PERL_ARGS_ASSERT_LEX_UNSTUFF PERL_ARGS_ASSERT_LOAD_MODULE
syn keyword xsMacro PERL_ARGS_ASSERT_LOAD_MODULE_NOCONTEXT
syn keyword xsMacro PERL_ARGS_ASSERT_LOCALIZE
syn keyword xsMacro PERL_ARGS_ASSERT_LOOKS_LIKE_BOOL
syn keyword xsMacro PERL_ARGS_ASSERT_LOOKS_LIKE_NUMBER PERL_ARGS_ASSERT_LOP
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_CLEARENV
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_CLEARHINT
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_CLEARHINTS
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_CLEARISA
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_CLEARPACK
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_CLEARSIG
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_CLEAR_ALL_ENV
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_EXISTSPACK
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_FREEARYLEN_P
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_FREEOVRLD
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_GET
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_GETARYLEN
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_GETDEFELEM
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_GETNKEYS
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_GETPACK
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_GETPOS
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_GETSIG
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_GETSUBSTR
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_GETTAINT
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_GETUVAR
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_GETVEC
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_KILLBACKREFS
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_LEN
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_METHCALL
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_METHCALL1
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_METHPACK
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_NEXTPACK
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_REGDATA_CNT
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_REGDATUM_GET
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_REGDATUM_SET
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SCALARPACK
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SET
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETAMAGIC
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETARYLEN
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETCOLLXFRM
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETDBLINE
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETDEFELEM
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETENV
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETHINT
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETISA
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETMGLOB
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETNKEYS
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETPACK
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETPOS
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETREGEXP
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETSIG
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETSUBSTR
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETTAINT
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETUTF8
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETUVAR
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETVEC
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SETVSTRING
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SET_ALL_ENV
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_SIZEPACK
syn keyword xsMacro PERL_ARGS_ASSERT_MAGIC_WIPEPACK
syn keyword xsMacro PERL_ARGS_ASSERT_MAKE_MATCHER PERL_ARGS_ASSERT_MAKE_TRIE
syn keyword xsMacro PERL_ARGS_ASSERT_MAKE_TRIE_FAILTABLE
syn keyword xsMacro PERL_ARGS_ASSERT_MALLOCED_SIZE
syn keyword xsMacro PERL_ARGS_ASSERT_MATCHER_MATCHES_SV
syn keyword xsMacro PERL_ARGS_ASSERT_MAYBERELOCATE
syn keyword xsMacro PERL_ARGS_ASSERT_MEASURE_STRUCT
syn keyword xsMacro PERL_ARGS_ASSERT_MEM_COLLXFRM
syn keyword xsMacro PERL_ARGS_ASSERT_MEM_LOG_COMMON PERL_ARGS_ASSERT_MESS
syn keyword xsMacro PERL_ARGS_ASSERT_MESS_NOCONTEXT PERL_ARGS_ASSERT_MESS_SV
syn keyword xsMacro PERL_ARGS_ASSERT_METHOD_COMMON PERL_ARGS_ASSERT_MG_CLEAR
syn keyword xsMacro PERL_ARGS_ASSERT_MG_COPY PERL_ARGS_ASSERT_MG_DUP
syn keyword xsMacro PERL_ARGS_ASSERT_MG_FREE PERL_ARGS_ASSERT_MG_FREE_TYPE
syn keyword xsMacro PERL_ARGS_ASSERT_MG_GET PERL_ARGS_ASSERT_MG_LENGTH
syn keyword xsMacro PERL_ARGS_ASSERT_MG_LOCALIZE PERL_ARGS_ASSERT_MG_MAGICAL
syn keyword xsMacro PERL_ARGS_ASSERT_MG_SET PERL_ARGS_ASSERT_MG_SIZE
syn keyword xsMacro PERL_ARGS_ASSERT_MINI_MKTIME
syn keyword xsMacro PERL_ARGS_ASSERT_MORESWITCHES
syn keyword xsMacro PERL_ARGS_ASSERT_MRO_CLEAN_ISAREV
syn keyword xsMacro PERL_ARGS_ASSERT_MRO_GATHER_AND_RENAME
syn keyword xsMacro PERL_ARGS_ASSERT_MRO_GET_FROM_NAME
syn keyword xsMacro PERL_ARGS_ASSERT_MRO_GET_LINEAR_ISA
syn keyword xsMacro PERL_ARGS_ASSERT_MRO_GET_LINEAR_ISA_DFS
syn keyword xsMacro PERL_ARGS_ASSERT_MRO_GET_PRIVATE_DATA
syn keyword xsMacro PERL_ARGS_ASSERT_MRO_ISA_CHANGED_IN
syn keyword xsMacro PERL_ARGS_ASSERT_MRO_META_DUP
syn keyword xsMacro PERL_ARGS_ASSERT_MRO_META_INIT
syn keyword xsMacro PERL_ARGS_ASSERT_MRO_METHOD_CHANGED_IN
syn keyword xsMacro PERL_ARGS_ASSERT_MRO_PACKAGE_MOVED
syn keyword xsMacro PERL_ARGS_ASSERT_MRO_REGISTER
syn keyword xsMacro PERL_ARGS_ASSERT_MRO_SET_MRO
syn keyword xsMacro PERL_ARGS_ASSERT_MRO_SET_PRIVATE_DATA
syn keyword xsMacro PERL_ARGS_ASSERT_MUL128
syn keyword xsMacro PERL_ARGS_ASSERT_MUNGE_QWLIST_TO_PAREN_LIST
syn keyword xsMacro PERL_ARGS_ASSERT_MY_ATOF PERL_ARGS_ASSERT_MY_ATOF2
syn keyword xsMacro PERL_ARGS_ASSERT_MY_ATTRS PERL_ARGS_ASSERT_MY_BCOPY
syn keyword xsMacro PERL_ARGS_ASSERT_MY_BZERO PERL_ARGS_ASSERT_MY_CXT_INDEX
syn keyword xsMacro PERL_ARGS_ASSERT_MY_CXT_INIT PERL_ARGS_ASSERT_MY_KID
syn keyword xsMacro PERL_ARGS_ASSERT_MY_MEMCMP PERL_ARGS_ASSERT_MY_MEMSET
syn keyword xsMacro PERL_ARGS_ASSERT_MY_POPEN PERL_ARGS_ASSERT_MY_POPEN_LIST
syn keyword xsMacro PERL_ARGS_ASSERT_MY_SNPRINTF PERL_ARGS_ASSERT_MY_SPRINTF
syn keyword xsMacro PERL_ARGS_ASSERT_MY_STRFTIME PERL_ARGS_ASSERT_MY_SWABN
syn keyword xsMacro PERL_ARGS_ASSERT_MY_VSNPRINTF PERL_ARGS_ASSERT_NEED_UTF8
syn keyword xsMacro PERL_ARGS_ASSERT_NEWAVREF PERL_ARGS_ASSERT_NEWCONDOP
syn keyword xsMacro PERL_ARGS_ASSERT_NEWFOROP PERL_ARGS_ASSERT_NEWGIVENOP
syn keyword xsMacro PERL_ARGS_ASSERT_NEWGIVWHENOP PERL_ARGS_ASSERT_NEWGP
syn keyword xsMacro PERL_ARGS_ASSERT_NEWGVGEN_FLAGS PERL_ARGS_ASSERT_NEWGVOP
syn keyword xsMacro PERL_ARGS_ASSERT_NEWHVREF PERL_ARGS_ASSERT_NEWLOGOP
syn keyword xsMacro PERL_ARGS_ASSERT_NEWLOOPEX PERL_ARGS_ASSERT_NEWMADSV
syn keyword xsMacro PERL_ARGS_ASSERT_NEWPADOP PERL_ARGS_ASSERT_NEWPROG
syn keyword xsMacro PERL_ARGS_ASSERT_NEWRANGE PERL_ARGS_ASSERT_NEWRV
syn keyword xsMacro PERL_ARGS_ASSERT_NEWRV_NOINC PERL_ARGS_ASSERT_NEWSVOP
syn keyword xsMacro PERL_ARGS_ASSERT_NEWSVPVF
syn keyword xsMacro PERL_ARGS_ASSERT_NEWSVPVF_NOCONTEXT
syn keyword xsMacro PERL_ARGS_ASSERT_NEWSVREF PERL_ARGS_ASSERT_NEWSVRV
syn keyword xsMacro PERL_ARGS_ASSERT_NEWWHENOP PERL_ARGS_ASSERT_NEWXS
syn keyword xsMacro PERL_ARGS_ASSERT_NEWXS_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_NEWXS_LEN_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_NEW_CONSTANT PERL_ARGS_ASSERT_NEW_CTYPE
syn keyword xsMacro PERL_ARGS_ASSERT_NEW_LOGOP PERL_ARGS_ASSERT_NEW_VERSION
syn keyword xsMacro PERL_ARGS_ASSERT_NEW_WARNINGS_BITFIELD
syn keyword xsMacro PERL_ARGS_ASSERT_NEXTARGV PERL_ARGS_ASSERT_NEXTCHAR
syn keyword xsMacro PERL_ARGS_ASSERT_NEXT_SYMBOL PERL_ARGS_ASSERT_NINSTR
syn keyword xsMacro PERL_ARGS_ASSERT_NOT_A_NUMBER
syn keyword xsMacro PERL_ARGS_ASSERT_NO_BAREWORD_ALLOWED
syn keyword xsMacro PERL_ARGS_ASSERT_NO_FH_ALLOWED PERL_ARGS_ASSERT_NO_OP
syn keyword xsMacro PERL_ARGS_ASSERT_OOPSAV PERL_ARGS_ASSERT_OOPSHV
syn keyword xsMacro PERL_ARGS_ASSERT_OPEN_SCRIPT
syn keyword xsMacro PERL_ARGS_ASSERT_OPT_SCALARHV PERL_ARGS_ASSERT_OP_CLEAR
syn keyword xsMacro PERL_ARGS_ASSERT_OP_CONTEXTUALIZE
syn keyword xsMacro PERL_ARGS_ASSERT_OP_DUMP PERL_ARGS_ASSERT_OP_INTEGERIZE
syn keyword xsMacro PERL_ARGS_ASSERT_OP_LINKLIST PERL_ARGS_ASSERT_OP_NULL
syn keyword xsMacro PERL_ARGS_ASSERT_OP_REFCNT_DEC
syn keyword xsMacro PERL_ARGS_ASSERT_OP_STD_INIT PERL_ARGS_ASSERT_OP_XMLDUMP
syn keyword xsMacro PERL_ARGS_ASSERT_PACKAGE PERL_ARGS_ASSERT_PACKAGE_VERSION
syn keyword xsMacro PERL_ARGS_ASSERT_PACKLIST PERL_ARGS_ASSERT_PACK_CAT
syn keyword xsMacro PERL_ARGS_ASSERT_PACK_REC PERL_ARGS_ASSERT_PADLIST_DUP
syn keyword xsMacro PERL_ARGS_ASSERT_PAD_ADD_ANON
syn keyword xsMacro PERL_ARGS_ASSERT_PAD_ADD_NAME_PV
syn keyword xsMacro PERL_ARGS_ASSERT_PAD_ADD_NAME_PVN
syn keyword xsMacro PERL_ARGS_ASSERT_PAD_ADD_NAME_SV
syn keyword xsMacro PERL_ARGS_ASSERT_PAD_ALLOC_NAME
syn keyword xsMacro PERL_ARGS_ASSERT_PAD_CHECK_DUP
syn keyword xsMacro PERL_ARGS_ASSERT_PAD_FINDLEX
syn keyword xsMacro PERL_ARGS_ASSERT_PAD_FINDMY_PV
syn keyword xsMacro PERL_ARGS_ASSERT_PAD_FINDMY_PVN
syn keyword xsMacro PERL_ARGS_ASSERT_PAD_FINDMY_SV
syn keyword xsMacro PERL_ARGS_ASSERT_PAD_FIXUP_INNER_ANONS
syn keyword xsMacro PERL_ARGS_ASSERT_PAD_PEG PERL_ARGS_ASSERT_PAD_PUSH
syn keyword xsMacro PERL_ARGS_ASSERT_PAD_SETSV PERL_ARGS_ASSERT_PARSER_DUP
syn keyword xsMacro PERL_ARGS_ASSERT_PARSER_FREE
syn keyword xsMacro PERL_ARGS_ASSERT_PARSE_UNICODE_OPTS
syn keyword xsMacro PERL_ARGS_ASSERT_PATH_IS_ABSOLUTE
syn keyword xsMacro PERL_ARGS_ASSERT_PERLIO_READ
syn keyword xsMacro PERL_ARGS_ASSERT_PERLIO_UNREAD
syn keyword xsMacro PERL_ARGS_ASSERT_PERLIO_WRITE
syn keyword xsMacro PERL_ARGS_ASSERT_PERL_ALLOC_USING
syn keyword xsMacro PERL_ARGS_ASSERT_PERL_CLONE
syn keyword xsMacro PERL_ARGS_ASSERT_PERL_CLONE_USING
syn keyword xsMacro PERL_ARGS_ASSERT_PERL_CONSTRUCT
syn keyword xsMacro PERL_ARGS_ASSERT_PERL_DESTRUCT PERL_ARGS_ASSERT_PERL_FREE
syn keyword xsMacro PERL_ARGS_ASSERT_PERL_PARSE PERL_ARGS_ASSERT_PERL_RUN
syn keyword xsMacro PERL_ARGS_ASSERT_PMRUNTIME PERL_ARGS_ASSERT_PMTRANS
syn keyword xsMacro PERL_ARGS_ASSERT_PM_DESCRIPTION
syn keyword xsMacro PERL_ARGS_ASSERT_POPULATE_ISA PERL_ARGS_ASSERT_PREGCOMP
syn keyword xsMacro PERL_ARGS_ASSERT_PREGEXEC PERL_ARGS_ASSERT_PREGFREE2
syn keyword xsMacro PERL_ARGS_ASSERT_PRESCAN_VERSION
syn keyword xsMacro PERL_ARGS_ASSERT_PRINTBUF
syn keyword xsMacro PERL_ARGS_ASSERT_PRINTF_NOCONTEXT
syn keyword xsMacro PERL_ARGS_ASSERT_PROCESS_SPECIAL_BLOCKS
syn keyword xsMacro PERL_ARGS_ASSERT_PTR_TABLE_FETCH
syn keyword xsMacro PERL_ARGS_ASSERT_PTR_TABLE_FIND
syn keyword xsMacro PERL_ARGS_ASSERT_PTR_TABLE_SPLIT
syn keyword xsMacro PERL_ARGS_ASSERT_PTR_TABLE_STORE
syn keyword xsMacro PERL_ARGS_ASSERT_PUT_BYTE PERL_ARGS_ASSERT_PV_DISPLAY
syn keyword xsMacro PERL_ARGS_ASSERT_PV_ESCAPE PERL_ARGS_ASSERT_PV_PRETTY
syn keyword xsMacro PERL_ARGS_ASSERT_PV_UNI_DISPLAY PERL_ARGS_ASSERT_QERROR
syn keyword xsMacro PERL_ARGS_ASSERT_QSORTSVU
syn keyword xsMacro PERL_ARGS_ASSERT_REENTRANT_RETRY
syn keyword xsMacro PERL_ARGS_ASSERT_REFCOUNTED_HE_FETCH_PV
syn keyword xsMacro PERL_ARGS_ASSERT_REFCOUNTED_HE_FETCH_PVN
syn keyword xsMacro PERL_ARGS_ASSERT_REFCOUNTED_HE_FETCH_SV
syn keyword xsMacro PERL_ARGS_ASSERT_REFCOUNTED_HE_NEW_PV
syn keyword xsMacro PERL_ARGS_ASSERT_REFCOUNTED_HE_NEW_PVN
syn keyword xsMacro PERL_ARGS_ASSERT_REFCOUNTED_HE_NEW_SV
syn keyword xsMacro PERL_ARGS_ASSERT_REFCOUNTED_HE_VALUE
syn keyword xsMacro PERL_ARGS_ASSERT_REFTO PERL_ARGS_ASSERT_REG
syn keyword xsMacro PERL_ARGS_ASSERT_REGANODE PERL_ARGS_ASSERT_REGATOM
syn keyword xsMacro PERL_ARGS_ASSERT_REGBRANCH PERL_ARGS_ASSERT_REGCLASS
syn keyword xsMacro PERL_ARGS_ASSERT_REGCLASS_SWASH PERL_ARGS_ASSERT_REGCPPOP
syn keyword xsMacro PERL_ARGS_ASSERT_REGCURLY PERL_ARGS_ASSERT_REGDUMP
syn keyword xsMacro PERL_ARGS_ASSERT_REGDUPE_INTERNAL
syn keyword xsMacro PERL_ARGS_ASSERT_REGEXEC_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_REGFREE_INTERNAL
syn keyword xsMacro PERL_ARGS_ASSERT_REGHOP3 PERL_ARGS_ASSERT_REGHOP4
syn keyword xsMacro PERL_ARGS_ASSERT_REGHOPMAYBE3 PERL_ARGS_ASSERT_REGINCLASS
syn keyword xsMacro PERL_ARGS_ASSERT_REGINSERT PERL_ARGS_ASSERT_REGMATCH
syn keyword xsMacro PERL_ARGS_ASSERT_REGPIECE PERL_ARGS_ASSERT_REGPPOSIXCC
syn keyword xsMacro PERL_ARGS_ASSERT_REGPROP PERL_ARGS_ASSERT_REGREPEAT
syn keyword xsMacro PERL_ARGS_ASSERT_REGTAIL PERL_ARGS_ASSERT_REGTAIL_STUDY
syn keyword xsMacro PERL_ARGS_ASSERT_REGTRY PERL_ARGS_ASSERT_REGUNI
syn keyword xsMacro PERL_ARGS_ASSERT_REGWHITE
syn keyword xsMacro PERL_ARGS_ASSERT_REG_CHECK_NAMED_BUFF_MATCHED
syn keyword xsMacro PERL_ARGS_ASSERT_REG_NAMEDSEQ
syn keyword xsMacro PERL_ARGS_ASSERT_REG_NAMED_BUFF
syn keyword xsMacro PERL_ARGS_ASSERT_REG_NAMED_BUFF_ALL
syn keyword xsMacro PERL_ARGS_ASSERT_REG_NAMED_BUFF_EXISTS
syn keyword xsMacro PERL_ARGS_ASSERT_REG_NAMED_BUFF_FETCH
syn keyword xsMacro PERL_ARGS_ASSERT_REG_NAMED_BUFF_FIRSTKEY
syn keyword xsMacro PERL_ARGS_ASSERT_REG_NAMED_BUFF_ITER
syn keyword xsMacro PERL_ARGS_ASSERT_REG_NAMED_BUFF_NEXTKEY
syn keyword xsMacro PERL_ARGS_ASSERT_REG_NAMED_BUFF_SCALAR
syn keyword xsMacro PERL_ARGS_ASSERT_REG_NODE
syn keyword xsMacro PERL_ARGS_ASSERT_REG_NUMBERED_BUFF_FETCH
syn keyword xsMacro PERL_ARGS_ASSERT_REG_NUMBERED_BUFF_LENGTH
syn keyword xsMacro PERL_ARGS_ASSERT_REG_NUMBERED_BUFF_STORE
syn keyword xsMacro PERL_ARGS_ASSERT_REG_QR_PACKAGE
syn keyword xsMacro PERL_ARGS_ASSERT_REG_RECODE
syn keyword xsMacro PERL_ARGS_ASSERT_REG_SCAN_NAME
syn keyword xsMacro PERL_ARGS_ASSERT_REG_SKIPCOMMENT
syn keyword xsMacro PERL_ARGS_ASSERT_REG_TEMP_COPY PERL_ARGS_ASSERT_REPEATCPY
syn keyword xsMacro PERL_ARGS_ASSERT_REPORT_REDEFINED_CV
syn keyword xsMacro PERL_ARGS_ASSERT_REQUIRE_PV
syn keyword xsMacro PERL_ARGS_ASSERT_REQUIRE_TIE_MOD
syn keyword xsMacro PERL_ARGS_ASSERT_RE_COMPILE PERL_ARGS_ASSERT_RE_CROAK2
syn keyword xsMacro PERL_ARGS_ASSERT_RE_DUP_GUTS
syn keyword xsMacro PERL_ARGS_ASSERT_RE_INTUIT_START
syn keyword xsMacro PERL_ARGS_ASSERT_RE_INTUIT_STRING
syn keyword xsMacro PERL_ARGS_ASSERT_RNINSTR PERL_ARGS_ASSERT_RSIGNAL_SAVE
syn keyword xsMacro PERL_ARGS_ASSERT_RUN_USER_FILTER
syn keyword xsMacro PERL_ARGS_ASSERT_RV2CV_OP_CV PERL_ARGS_ASSERT_RVPV_DUP
syn keyword xsMacro PERL_ARGS_ASSERT_RXRES_FREE
syn keyword xsMacro PERL_ARGS_ASSERT_RXRES_RESTORE
syn keyword xsMacro PERL_ARGS_ASSERT_RXRES_SAVE PERL_ARGS_ASSERT_SAME_DIRENT
syn keyword xsMacro PERL_ARGS_ASSERT_SAVESHAREDSVPV PERL_ARGS_ASSERT_SAVESVPV
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_ADELETE
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_AELEM_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_APTR PERL_ARGS_ASSERT_SAVE_ARY
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_BOOL PERL_ARGS_ASSERT_SAVE_CLEARSV
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_DELETE
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_DESTRUCTOR
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_GENERIC_PVREF
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_GENERIC_SVREF
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_GP PERL_ARGS_ASSERT_SAVE_HASH
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_HDELETE
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_HEK_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_HELEM_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_HPTR PERL_ARGS_ASSERT_SAVE_I16
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_I32 PERL_ARGS_ASSERT_SAVE_I8
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_INT PERL_ARGS_ASSERT_SAVE_ITEM
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_IV PERL_ARGS_ASSERT_SAVE_LINES
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_LIST PERL_ARGS_ASSERT_SAVE_LONG
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_MAGIC
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_MORTALIZESV
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_NOGV PERL_ARGS_ASSERT_SAVE_PPTR
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_SCALAR
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_SCALAR_AT
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_SET_SVFLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_SHARED_PVREF
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_SPTR PERL_ARGS_ASSERT_SAVE_SVREF
syn keyword xsMacro PERL_ARGS_ASSERT_SAVE_VPTR PERL_ARGS_ASSERT_SCALARBOOLEAN
syn keyword xsMacro PERL_ARGS_ASSERT_SCALARVOID PERL_ARGS_ASSERT_SCAN_BIN
syn keyword xsMacro PERL_ARGS_ASSERT_SCAN_COMMIT PERL_ARGS_ASSERT_SCAN_CONST
syn keyword xsMacro PERL_ARGS_ASSERT_SCAN_FORMLINE
syn keyword xsMacro PERL_ARGS_ASSERT_SCAN_HEREDOC PERL_ARGS_ASSERT_SCAN_HEX
syn keyword xsMacro PERL_ARGS_ASSERT_SCAN_IDENT
syn keyword xsMacro PERL_ARGS_ASSERT_SCAN_INPUTSYMBOL
syn keyword xsMacro PERL_ARGS_ASSERT_SCAN_NUM PERL_ARGS_ASSERT_SCAN_OCT
syn keyword xsMacro PERL_ARGS_ASSERT_SCAN_PAT PERL_ARGS_ASSERT_SCAN_STR
syn keyword xsMacro PERL_ARGS_ASSERT_SCAN_SUBST PERL_ARGS_ASSERT_SCAN_TRANS
syn keyword xsMacro PERL_ARGS_ASSERT_SCAN_VERSION
syn keyword xsMacro PERL_ARGS_ASSERT_SCAN_VSTRING PERL_ARGS_ASSERT_SCAN_WORD
syn keyword xsMacro PERL_ARGS_ASSERT_SCREAMINSTR
syn keyword xsMacro PERL_ARGS_ASSERT_SEARCH_CONST
syn keyword xsMacro PERL_ARGS_ASSERT_SET_CONTEXT
syn keyword xsMacro PERL_ARGS_ASSERT_SET_REGCLASS_BIT
syn keyword xsMacro PERL_ARGS_ASSERT_SET_REGCLASS_BIT_FOLD
syn keyword xsMacro PERL_ARGS_ASSERT_SHARE_HEK
syn keyword xsMacro PERL_ARGS_ASSERT_SHARE_HEK_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SIMPLIFY_SORT PERL_ARGS_ASSERT_SI_DUP
syn keyword xsMacro PERL_ARGS_ASSERT_SKIPSPACE PERL_ARGS_ASSERT_SKIPSPACE0
syn keyword xsMacro PERL_ARGS_ASSERT_SKIPSPACE1 PERL_ARGS_ASSERT_SKIPSPACE2
syn keyword xsMacro PERL_ARGS_ASSERT_SLAB_FREE PERL_ARGS_ASSERT_SLAB_TO_RW
syn keyword xsMacro PERL_ARGS_ASSERT_SOFTREF2XV PERL_ARGS_ASSERT_SORTCV
syn keyword xsMacro PERL_ARGS_ASSERT_SORTCV_STACKED
syn keyword xsMacro PERL_ARGS_ASSERT_SORTCV_XSUB PERL_ARGS_ASSERT_SORTSV
syn keyword xsMacro PERL_ARGS_ASSERT_SORTSV_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SPACE_JOIN_NAMES_MORTAL
syn keyword xsMacro PERL_ARGS_ASSERT_SS_DUP PERL_ARGS_ASSERT_STACK_GROW
syn keyword xsMacro PERL_ARGS_ASSERT_START_GLOB
syn keyword xsMacro PERL_ARGS_ASSERT_STASHPV_HVNAME_MATCH
syn keyword xsMacro PERL_ARGS_ASSERT_STDIZE_LOCALE
syn keyword xsMacro PERL_ARGS_ASSERT_STRIP_RETURN
syn keyword xsMacro PERL_ARGS_ASSERT_STR_TO_VERSION
syn keyword xsMacro PERL_ARGS_ASSERT_STUDY_CHUNK
syn keyword xsMacro PERL_ARGS_ASSERT_SUB_CRUSH_DEPTH
syn keyword xsMacro PERL_ARGS_ASSERT_SV_2BOOL_FLAGS PERL_ARGS_ASSERT_SV_2CV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_2IO PERL_ARGS_ASSERT_SV_2IUV_COMMON
syn keyword xsMacro PERL_ARGS_ASSERT_SV_2IUV_NON_PRESERVE
syn keyword xsMacro PERL_ARGS_ASSERT_SV_2NUM PERL_ARGS_ASSERT_SV_2PVBYTE
syn keyword xsMacro PERL_ARGS_ASSERT_SV_2PVBYTE_NOLEN
syn keyword xsMacro PERL_ARGS_ASSERT_SV_2PVUTF8
syn keyword xsMacro PERL_ARGS_ASSERT_SV_2PVUTF8_NOLEN
syn keyword xsMacro PERL_ARGS_ASSERT_SV_2PV_NOLEN
syn keyword xsMacro PERL_ARGS_ASSERT_SV_ADD_ARENA
syn keyword xsMacro PERL_ARGS_ASSERT_SV_ADD_BACKREF
syn keyword xsMacro PERL_ARGS_ASSERT_SV_BACKOFF PERL_ARGS_ASSERT_SV_BLESS
syn keyword xsMacro PERL_ARGS_ASSERT_SV_CATPV PERL_ARGS_ASSERT_SV_CATPVF
syn keyword xsMacro PERL_ARGS_ASSERT_SV_CATPVF_MG
syn keyword xsMacro PERL_ARGS_ASSERT_SV_CATPVF_MG_NOCONTEXT
syn keyword xsMacro PERL_ARGS_ASSERT_SV_CATPVF_NOCONTEXT
syn keyword xsMacro PERL_ARGS_ASSERT_SV_CATPVN
syn keyword xsMacro PERL_ARGS_ASSERT_SV_CATPVN_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SV_CATPVN_MG
syn keyword xsMacro PERL_ARGS_ASSERT_SV_CATPV_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SV_CATPV_MG PERL_ARGS_ASSERT_SV_CATSV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_CATSV_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SV_CATSV_MG PERL_ARGS_ASSERT_SV_CATXMLPV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_CATXMLPVN
syn keyword xsMacro PERL_ARGS_ASSERT_SV_CATXMLSV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_CAT_DECODE PERL_ARGS_ASSERT_SV_CHOP
syn keyword xsMacro PERL_ARGS_ASSERT_SV_CLEAR
syn keyword xsMacro PERL_ARGS_ASSERT_SV_COLLXFRM_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SV_COMPILE_2OP
syn keyword xsMacro PERL_ARGS_ASSERT_SV_COMPILE_2OP_IS_BROKEN
syn keyword xsMacro PERL_ARGS_ASSERT_SV_COPYPV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_DEL_BACKREF
syn keyword xsMacro PERL_ARGS_ASSERT_SV_DERIVED_FROM
syn keyword xsMacro PERL_ARGS_ASSERT_SV_DERIVED_FROM_PV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_DERIVED_FROM_PVN
syn keyword xsMacro PERL_ARGS_ASSERT_SV_DERIVED_FROM_SV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_DOES PERL_ARGS_ASSERT_SV_DOES_PV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_DOES_PVN PERL_ARGS_ASSERT_SV_DOES_SV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_DUMP PERL_ARGS_ASSERT_SV_DUP
syn keyword xsMacro PERL_ARGS_ASSERT_SV_DUP_COMMON
syn keyword xsMacro PERL_ARGS_ASSERT_SV_DUP_INC
syn keyword xsMacro PERL_ARGS_ASSERT_SV_DUP_INC_MULTIPLE
syn keyword xsMacro PERL_ARGS_ASSERT_SV_EXP_GROW
syn keyword xsMacro PERL_ARGS_ASSERT_SV_FORCE_NORMAL
syn keyword xsMacro PERL_ARGS_ASSERT_SV_FORCE_NORMAL_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SV_FREE2 PERL_ARGS_ASSERT_SV_GETS
syn keyword xsMacro PERL_ARGS_ASSERT_SV_GROW PERL_ARGS_ASSERT_SV_INSERT
syn keyword xsMacro PERL_ARGS_ASSERT_SV_INSERT_FLAGS PERL_ARGS_ASSERT_SV_ISA
syn keyword xsMacro PERL_ARGS_ASSERT_SV_IV PERL_ARGS_ASSERT_SV_I_NCMP
syn keyword xsMacro PERL_ARGS_ASSERT_SV_KILL_BACKREFS
syn keyword xsMacro PERL_ARGS_ASSERT_SV_MAGIC PERL_ARGS_ASSERT_SV_MAGICEXT
syn keyword xsMacro PERL_ARGS_ASSERT_SV_NCMP PERL_ARGS_ASSERT_SV_NV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_POS_B2U
syn keyword xsMacro PERL_ARGS_ASSERT_SV_POS_B2U_MIDWAY
syn keyword xsMacro PERL_ARGS_ASSERT_SV_POS_U2B
syn keyword xsMacro PERL_ARGS_ASSERT_SV_POS_U2B_CACHED
syn keyword xsMacro PERL_ARGS_ASSERT_SV_POS_U2B_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SV_POS_U2B_FORWARDS
syn keyword xsMacro PERL_ARGS_ASSERT_SV_POS_U2B_MIDWAY PERL_ARGS_ASSERT_SV_PV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_PVBYTE PERL_ARGS_ASSERT_SV_PVBYTEN
syn keyword xsMacro PERL_ARGS_ASSERT_SV_PVBYTEN_FORCE PERL_ARGS_ASSERT_SV_PVN
syn keyword xsMacro PERL_ARGS_ASSERT_SV_PVN_FORCE
syn keyword xsMacro PERL_ARGS_ASSERT_SV_PVN_FORCE_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SV_PVN_NOMG PERL_ARGS_ASSERT_SV_PVUTF8
syn keyword xsMacro PERL_ARGS_ASSERT_SV_PVUTF8N
syn keyword xsMacro PERL_ARGS_ASSERT_SV_PVUTF8N_FORCE
syn keyword xsMacro PERL_ARGS_ASSERT_SV_RECODE_TO_UTF8
syn keyword xsMacro PERL_ARGS_ASSERT_SV_REF PERL_ARGS_ASSERT_SV_REFTYPE
syn keyword xsMacro PERL_ARGS_ASSERT_SV_RELEASE_COW
syn keyword xsMacro PERL_ARGS_ASSERT_SV_REPLACE PERL_ARGS_ASSERT_SV_RESET
syn keyword xsMacro PERL_ARGS_ASSERT_SV_RVWEAKEN PERL_ARGS_ASSERT_SV_SETHEK
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETIV PERL_ARGS_ASSERT_SV_SETIV_MG
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETNV PERL_ARGS_ASSERT_SV_SETNV_MG
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETPV PERL_ARGS_ASSERT_SV_SETPVF
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETPVF_MG
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETPVF_MG_NOCONTEXT
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETPVF_NOCONTEXT
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETPVIV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETPVIV_MG PERL_ARGS_ASSERT_SV_SETPVN
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETPVN_MG
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETPV_MG
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETREF_IV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETREF_NV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETREF_PV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETREF_PVN
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETREF_UV PERL_ARGS_ASSERT_SV_SETSV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETSV_COW
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETSV_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETSV_MG PERL_ARGS_ASSERT_SV_SETUV
syn keyword xsMacro PERL_ARGS_ASSERT_SV_SETUV_MG PERL_ARGS_ASSERT_SV_TAINT
syn keyword xsMacro PERL_ARGS_ASSERT_SV_TAINTED PERL_ARGS_ASSERT_SV_UNGLOB
syn keyword xsMacro PERL_ARGS_ASSERT_SV_UNI_DISPLAY
syn keyword xsMacro PERL_ARGS_ASSERT_SV_UNMAGIC
syn keyword xsMacro PERL_ARGS_ASSERT_SV_UNMAGICEXT PERL_ARGS_ASSERT_SV_UNREF
syn keyword xsMacro PERL_ARGS_ASSERT_SV_UNREF_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SV_UNTAINT PERL_ARGS_ASSERT_SV_UPGRADE
syn keyword xsMacro PERL_ARGS_ASSERT_SV_USEPVN
syn keyword xsMacro PERL_ARGS_ASSERT_SV_USEPVN_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_SV_USEPVN_MG
syn keyword xsMacro PERL_ARGS_ASSERT_SV_UTF8_DECODE
syn keyword xsMacro PERL_ARGS_ASSERT_SV_UTF8_DOWNGRADE
syn keyword xsMacro PERL_ARGS_ASSERT_SV_UTF8_ENCODE
syn keyword xsMacro PERL_ARGS_ASSERT_SV_UTF8_UPGRADE
syn keyword xsMacro PERL_ARGS_ASSERT_SV_UTF8_UPGRADE_FLAGS_GROW
syn keyword xsMacro PERL_ARGS_ASSERT_SV_UV PERL_ARGS_ASSERT_SV_VCATPVF
syn keyword xsMacro PERL_ARGS_ASSERT_SV_VCATPVFN
syn keyword xsMacro PERL_ARGS_ASSERT_SV_VCATPVF_MG
syn keyword xsMacro PERL_ARGS_ASSERT_SV_VSETPVF PERL_ARGS_ASSERT_SV_VSETPVFN
syn keyword xsMacro PERL_ARGS_ASSERT_SV_VSETPVF_MG
syn keyword xsMacro PERL_ARGS_ASSERT_SV_XMLPEEK PERL_ARGS_ASSERT_SWALLOW_BOM
syn keyword xsMacro PERL_ARGS_ASSERT_SWASH_FETCH PERL_ARGS_ASSERT_SWASH_INIT
syn keyword xsMacro PERL_ARGS_ASSERT_SWATCH_GET PERL_ARGS_ASSERT_SYS_INIT
syn keyword xsMacro PERL_ARGS_ASSERT_SYS_INIT3
syn keyword xsMacro PERL_ARGS_ASSERT_SYS_INTERN_DUP
syn keyword xsMacro PERL_ARGS_ASSERT_TAINT_PROPER
syn keyword xsMacro PERL_ARGS_ASSERT_TIED_METHOD
syn keyword xsMacro PERL_ARGS_ASSERT_TOKENIZE_USE PERL_ARGS_ASSERT_TOKEN_FREE
syn keyword xsMacro PERL_ARGS_ASSERT_TOKEN_GETMAD PERL_ARGS_ASSERT_TOKEQ
syn keyword xsMacro PERL_ARGS_ASSERT_TOKEREPORT
syn keyword xsMacro PERL_ARGS_ASSERT_TOO_FEW_ARGUMENTS_PV
syn keyword xsMacro PERL_ARGS_ASSERT_TOO_FEW_ARGUMENTS_SV
syn keyword xsMacro PERL_ARGS_ASSERT_TOO_MANY_ARGUMENTS_PV
syn keyword xsMacro PERL_ARGS_ASSERT_TOO_MANY_ARGUMENTS_SV
syn keyword xsMacro PERL_ARGS_ASSERT_TO_BYTE_SUBSTR
syn keyword xsMacro PERL_ARGS_ASSERT_TO_UNI_LOWER
syn keyword xsMacro PERL_ARGS_ASSERT_TO_UNI_TITLE
syn keyword xsMacro PERL_ARGS_ASSERT_TO_UNI_UPPER
syn keyword xsMacro PERL_ARGS_ASSERT_TO_UTF8_CASE
syn keyword xsMacro PERL_ARGS_ASSERT_TO_UTF8_FOLD
syn keyword xsMacro PERL_ARGS_ASSERT_TO_UTF8_LOWER
syn keyword xsMacro PERL_ARGS_ASSERT_TO_UTF8_SUBSTR
syn keyword xsMacro PERL_ARGS_ASSERT_TO_UTF8_TITLE
syn keyword xsMacro PERL_ARGS_ASSERT_TO_UTF8_UPPER
syn keyword xsMacro PERL_ARGS_ASSERT_TRANSLATE_SUBSTR_OFFSETS
syn keyword xsMacro PERL_ARGS_ASSERT_UIV_2BUF PERL_ARGS_ASSERT_UNLNK
syn keyword xsMacro PERL_ARGS_ASSERT_UNPACKSTRING PERL_ARGS_ASSERT_UNPACK_REC
syn keyword xsMacro PERL_ARGS_ASSERT_UNPACK_STR
syn keyword xsMacro PERL_ARGS_ASSERT_UNREFERENCED_TO_TMP_STACK
syn keyword xsMacro PERL_ARGS_ASSERT_UPG_VERSION
syn keyword xsMacro PERL_ARGS_ASSERT_UTF16_TEXTFILTER
syn keyword xsMacro PERL_ARGS_ASSERT_UTF16_TO_UTF8
syn keyword xsMacro PERL_ARGS_ASSERT_UTF16_TO_UTF8_REVERSED
syn keyword xsMacro PERL_ARGS_ASSERT_UTF8N_TO_UVCHR
syn keyword xsMacro PERL_ARGS_ASSERT_UTF8N_TO_UVUNI
syn keyword xsMacro PERL_ARGS_ASSERT_UTF8_DISTANCE PERL_ARGS_ASSERT_UTF8_HOP
syn keyword xsMacro PERL_ARGS_ASSERT_UTF8_LENGTH
syn keyword xsMacro PERL_ARGS_ASSERT_UTF8_MG_LEN_CACHE_UPDATE
syn keyword xsMacro PERL_ARGS_ASSERT_UTF8_MG_POS_CACHE_UPDATE
syn keyword xsMacro PERL_ARGS_ASSERT_UTF8_TO_BYTES
syn keyword xsMacro PERL_ARGS_ASSERT_UTF8_TO_UVCHR
syn keyword xsMacro PERL_ARGS_ASSERT_UTF8_TO_UVCHR_BUF
syn keyword xsMacro PERL_ARGS_ASSERT_UTF8_TO_UVUNI
syn keyword xsMacro PERL_ARGS_ASSERT_UTF8_TO_UVUNI_BUF
syn keyword xsMacro PERL_ARGS_ASSERT_UTILIZE PERL_ARGS_ASSERT_UVCHR_TO_UTF8
syn keyword xsMacro PERL_ARGS_ASSERT_UVCHR_TO_UTF8_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_UVUNI_TO_UTF8
syn keyword xsMacro PERL_ARGS_ASSERT_UVUNI_TO_UTF8_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT_VALIDATE_SUID
syn keyword xsMacro PERL_ARGS_ASSERT_VALID_UTF8_TO_UVCHR
syn keyword xsMacro PERL_ARGS_ASSERT_VALID_UTF8_TO_UVUNI
syn keyword xsMacro PERL_ARGS_ASSERT_VCMP PERL_ARGS_ASSERT_VDEB
syn keyword xsMacro PERL_ARGS_ASSERT_VFORM PERL_ARGS_ASSERT_VISIT
syn keyword xsMacro PERL_ARGS_ASSERT_VIVIFY_DEFELEM
syn keyword xsMacro PERL_ARGS_ASSERT_VIVIFY_REF PERL_ARGS_ASSERT_VLOAD_MODULE
syn keyword xsMacro PERL_ARGS_ASSERT_VMESS PERL_ARGS_ASSERT_VNEWSVPVF
syn keyword xsMacro PERL_ARGS_ASSERT_VNORMAL PERL_ARGS_ASSERT_VNUMIFY
syn keyword xsMacro PERL_ARGS_ASSERT_VSTRINGIFY PERL_ARGS_ASSERT_VVERIFY
syn keyword xsMacro PERL_ARGS_ASSERT_VWARN PERL_ARGS_ASSERT_VWARNER
syn keyword xsMacro PERL_ARGS_ASSERT_WAIT4PID PERL_ARGS_ASSERT_WARN
syn keyword xsMacro PERL_ARGS_ASSERT_WARNER PERL_ARGS_ASSERT_WARNER_NOCONTEXT
syn keyword xsMacro PERL_ARGS_ASSERT_WARN_NOCONTEXT PERL_ARGS_ASSERT_WARN_SV
syn keyword xsMacro PERL_ARGS_ASSERT_WATCH PERL_ARGS_ASSERT_WHICHSIG_PV
syn keyword xsMacro PERL_ARGS_ASSERT_WHICHSIG_PVN
syn keyword xsMacro PERL_ARGS_ASSERT_WHICHSIG_SV
syn keyword xsMacro PERL_ARGS_ASSERT_WITH_QUEUED_ERRORS
syn keyword xsMacro PERL_ARGS_ASSERT_WRAP_OP_CHECKER
syn keyword xsMacro PERL_ARGS_ASSERT_WRITE_TO_STDERR
syn keyword xsMacro PERL_ARGS_ASSERT_XMLDUMP_ATTR
syn keyword xsMacro PERL_ARGS_ASSERT_XMLDUMP_FORM
syn keyword xsMacro PERL_ARGS_ASSERT_XMLDUMP_INDENT
syn keyword xsMacro PERL_ARGS_ASSERT_XMLDUMP_PACKSUBS
syn keyword xsMacro PERL_ARGS_ASSERT_XMLDUMP_PACKSUBS_PERL
syn keyword xsMacro PERL_ARGS_ASSERT_XMLDUMP_SUB
syn keyword xsMacro PERL_ARGS_ASSERT_XMLDUMP_SUB_PERL
syn keyword xsMacro PERL_ARGS_ASSERT_XMLDUMP_VINDENT
syn keyword xsMacro PERL_ARGS_ASSERT_XS_APIVERSION_BOOTCHECK
syn keyword xsMacro PERL_ARGS_ASSERT_XS_VERSION_BOOTCHECK
syn keyword xsMacro PERL_ARGS_ASSERT_YYERROR PERL_ARGS_ASSERT_YYERROR_PV
syn keyword xsMacro PERL_ARGS_ASSERT_YYERROR_PVN PERL_ARGS_ASSERT_YYWARN
syn keyword xsMacro PERL_ARGS_ASSERT__APPEND_RANGE_TO_INVLIST
syn keyword xsMacro PERL_ARGS_ASSERT__CORE_SWASH_INIT
syn keyword xsMacro PERL_ARGS_ASSERT__INVLIST_ARRAY_INIT
syn keyword xsMacro PERL_ARGS_ASSERT__INVLIST_CONTENTS
syn keyword xsMacro PERL_ARGS_ASSERT__INVLIST_INTERSECTION_MAYBE_COMPLEMENT_2ND
syn keyword xsMacro PERL_ARGS_ASSERT__INVLIST_INVERT
syn keyword xsMacro PERL_ARGS_ASSERT__INVLIST_INVERT_PROP
syn keyword xsMacro PERL_ARGS_ASSERT__INVLIST_POPULATE_SWATCH
syn keyword xsMacro PERL_ARGS_ASSERT__INVLIST_UNION_MAYBE_COMPLEMENT_2ND
syn keyword xsMacro PERL_ARGS_ASSERT__IS_UTF8_QUOTEMETA
syn keyword xsMacro PERL_ARGS_ASSERT__IS_UTF8__PERL_IDSTART
syn keyword xsMacro PERL_ARGS_ASSERT__NEW_INVLIST_C_ARRAY
syn keyword xsMacro PERL_ARGS_ASSERT__SWASH_INVERSION_HASH
syn keyword xsMacro PERL_ARGS_ASSERT__SWASH_TO_INVLIST
syn keyword xsMacro PERL_ARGS_ASSERT__TO_FOLD_LATIN1
syn keyword xsMacro PERL_ARGS_ASSERT__TO_UNI_FOLD_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT__TO_UPPER_TITLE_LATIN1
syn keyword xsMacro PERL_ARGS_ASSERT__TO_UTF8_FOLD_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT__TO_UTF8_LOWER_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT__TO_UTF8_TITLE_FLAGS
syn keyword xsMacro PERL_ARGS_ASSERT__TO_UTF8_UPPER_FLAGS PERL_ASYNC_CHECK
syn keyword xsMacro PERL_BITFIELD16 PERL_BITFIELD32 PERL_BITFIELD8
syn keyword xsMacro PERL_CALLCONV PERL_CHECK_INITED PERL_CKDEF PERL_DEB
syn keyword xsMacro PERL_DEBUG PERL_DEBUG_PAD PERL_DEBUG_PAD_ZERO
syn keyword xsMacro PERL_DEFAULT_DO_EXEC3_IMPLEMENTATION
syn keyword xsMacro PERL_DONT_CREATE_GVSV
syn keyword xsMacro PERL_ENABLE_EXPERIMENTAL_REGEX_OPTIMISATIONS
syn keyword xsMacro PERL_ENABLE_EXTENDED_TRIE_OPTIMISATION
syn keyword xsMacro PERL_ENABLE_POSITIVE_ASSERTION_STUDY
syn keyword xsMacro PERL_ENABLE_TRIE_OPTIMISATION PERL_EXIT_DESTRUCT_END
syn keyword xsMacro PERL_EXIT_EXPECTED PERL_EXPORT_C PERL_FILE_IS_ABSOLUTE
syn keyword xsMacro PERL_FILTER_EXISTS PERL_FLUSHALL_FOR_CHILD PERL_FPU_INIT
syn keyword xsMacro PERL_FPU_POST_EXEC PERL_FPU_PRE_EXEC PERL_FS_VERSION
syn keyword xsMacro PERL_FS_VER_FMT PERL_GCC_BRACE_GROUPS_FORBIDDEN
syn keyword xsMacro PERL_GET_CONTEXT PERL_GET_INTERP PERL_GET_THX
syn keyword xsMacro PERL_GET_VARS PERL_GIT_UNPUSHED_COMMITS
syn keyword xsMacro PERL_GLOBAL_STRUCT PERL_GPROF_MONCONTROL PERL_HASH
syn keyword xsMacro PERL_HASH_INTERNAL PERL_HASH_INTERNAL_ PERL_HASH_SEED
syn keyword xsMacro PERL_HV_ARRAY_ALLOC_BYTES PERL_IMPLICIT_CONTEXT
syn keyword xsMacro PERL_INTERPRETER_SIZE_UPTO_MEMBER PERL_INT_MAX
syn keyword xsMacro PERL_INT_MIN PERL_LOADMOD_DENY PERL_LOADMOD_IMPORT_OPS
syn keyword xsMacro PERL_LOADMOD_NOIMPORT PERL_LONG_MAX PERL_LONG_MIN
syn keyword xsMacro PERL_MALLOC_WRAP PERL_MG_UFUNC PERL_MY_SNPRINTF_GUARDED
syn keyword xsMacro PERL_MY_VSNPRINTF_GUARDED PERL_NEED_MY_BETOH16
syn keyword xsMacro PERL_NEED_MY_BETOH32 PERL_NEED_MY_BETOHI
syn keyword xsMacro PERL_NEED_MY_BETOHL PERL_NEED_MY_BETOHS
syn keyword xsMacro PERL_NEED_MY_HTOBE16 PERL_NEED_MY_HTOBE32
syn keyword xsMacro PERL_NEED_MY_HTOBEI PERL_NEED_MY_HTOBEL
syn keyword xsMacro PERL_NEED_MY_HTOBES PERL_NEED_MY_HTOLE16
syn keyword xsMacro PERL_NEED_MY_HTOLE32 PERL_NEED_MY_HTOLEI
syn keyword xsMacro PERL_NEED_MY_HTOLEL PERL_NEED_MY_HTOLES
syn keyword xsMacro PERL_NEED_MY_LETOH16 PERL_NEED_MY_LETOH32
syn keyword xsMacro PERL_NEED_MY_LETOHI PERL_NEED_MY_LETOHL
syn keyword xsMacro PERL_NEED_MY_LETOHS PERL_NO_DEV_RANDOM PERL_OBJECT_THIS
syn keyword xsMacro PERL_OBJECT_THIS_ PERL_PADSEQ_INTRO PERL_PATCHNUM
syn keyword xsMacro PERL_PPADDR_INITED PERL_PPDEF PERL_PRESERVE_IVUV
syn keyword xsMacro PERL_PRIeldbl PERL_PRIfldbl PERL_PRIgldbl
syn keyword xsMacro PERL_PV_ESCAPE_ALL PERL_PV_ESCAPE_FIRSTCHAR
syn keyword xsMacro PERL_PV_ESCAPE_NOBACKSLASH PERL_PV_ESCAPE_NOCLEAR
syn keyword xsMacro PERL_PV_ESCAPE_NONASCII PERL_PV_ESCAPE_QUOTE
syn keyword xsMacro PERL_PV_ESCAPE_RE PERL_PV_ESCAPE_UNI
syn keyword xsMacro PERL_PV_ESCAPE_UNI_DETECT PERL_PV_PRETTY_DUMP
syn keyword xsMacro PERL_PV_PRETTY_ELLIPSES PERL_PV_PRETTY_LTGT
syn keyword xsMacro PERL_PV_PRETTY_NOCLEAR PERL_PV_PRETTY_QUOTE
syn keyword xsMacro PERL_PV_PRETTY_REGPROP PERL_QUAD_MAX PERL_QUAD_MIN
syn keyword xsMacro PERL_REENTR_API PERL_REGMATCH_SLAB_SLOTS PERL_REVISION
syn keyword xsMacro PERL_SCAN_ALLOW_UNDERSCORES PERL_SCAN_DISALLOW_PREFIX
syn keyword xsMacro PERL_SCAN_GREATER_THAN_UV_MAX PERL_SCAN_SILENT_ILLDIGIT
syn keyword xsMacro PERL_SCAN_SILENT_NON_PORTABLE PERL_SCNfldbl
syn keyword xsMacro PERL_SCRIPT_MODE PERL_SET_CONTEXT PERL_SET_INTERP
syn keyword xsMacro PERL_SET_PHASE PERL_SET_THX PERL_SHORT_MAX PERL_SHORT_MIN
syn keyword xsMacro PERL_SIGNALS_UNSAFE_FLAG PERL_STACK_OVERFLOW_CHECK
syn keyword xsMacro PERL_STATIC_INLINE PERL_STRLEN_EXPAND_SHIFT
syn keyword xsMacro PERL_STRLEN_ROUNDUP PERL_STRLEN_ROUNDUP_QUANTUM
syn keyword xsMacro PERL_SUBVERSION PERL_SUB_DEPTH_WARN PERL_SYS_INIT
syn keyword xsMacro PERL_SYS_INIT3 PERL_SYS_INIT3_BODY PERL_SYS_INIT_BODY
syn keyword xsMacro PERL_SYS_TERM PERL_SYS_TERM_BODY PERL_TARGETARCH
syn keyword xsMacro PERL_UCHAR_MAX PERL_UCHAR_MIN PERL_UINT_MAX PERL_UINT_MIN
syn keyword xsMacro PERL_ULONG_MAX PERL_ULONG_MIN PERL_UNICODE_ALL_FLAGS
syn keyword xsMacro PERL_UNICODE_ARGV PERL_UNICODE_ARGV_FLAG
syn keyword xsMacro PERL_UNICODE_DEFAULT_FLAGS PERL_UNICODE_IN
syn keyword xsMacro PERL_UNICODE_INOUT PERL_UNICODE_INOUT_FLAG
syn keyword xsMacro PERL_UNICODE_IN_FLAG PERL_UNICODE_LOCALE
syn keyword xsMacro PERL_UNICODE_LOCALE_FLAG PERL_UNICODE_MAX
syn keyword xsMacro PERL_UNICODE_OUT PERL_UNICODE_OUT_FLAG PERL_UNICODE_STD
syn keyword xsMacro PERL_UNICODE_STDERR PERL_UNICODE_STDERR_FLAG
syn keyword xsMacro PERL_UNICODE_STDIN PERL_UNICODE_STDIN_FLAG
syn keyword xsMacro PERL_UNICODE_STDOUT PERL_UNICODE_STDOUT_FLAG
syn keyword xsMacro PERL_UNICODE_STD_FLAG PERL_UNICODE_UTF8CACHEASSERT
syn keyword xsMacro PERL_UNICODE_UTF8CACHEASSERT_FLAG
syn keyword xsMacro PERL_UNICODE_WIDESYSCALLS PERL_UNICODE_WIDESYSCALLS_FLAG
syn keyword xsMacro PERL_UNUSED_ARG PERL_UNUSED_CONTEXT PERL_UNUSED_DECL
syn keyword xsMacro PERL_UNUSED_VAR PERL_UQUAD_MAX PERL_UQUAD_MIN
syn keyword xsMacro PERL_USES_PL_PIDSTATUS PERL_USE_GCC_BRACE_GROUPS
syn keyword xsMacro PERL_USHORT_MAX PERL_USHORT_MIN PERL_VERSION
syn keyword xsMacro PERL_VERSION_STRING PERL_WAIT_FOR_CHILDREN
syn keyword xsMacro PERL_WARNHOOK_FATAL PERL_WRITE_MSG_TO_CONSOLE
syn keyword xsMacro PERL_XS_EXPORT_C PHASE_CHANGE_PROBE PHOSTNAME
syn keyword xsMacro PIPESOCK_MODE PIPE_OPEN_MODE PLUGEXPR PLUGSTMT PLUS
syn keyword xsMacro PL_ASCII PL_AboveLatin1 PL_Argv PL_Cmd PL_DBcv PL_DBgv
syn keyword xsMacro PL_DBline PL_DBsignal PL_DBsingle PL_DBsub PL_DBtrace
syn keyword xsMacro PL_Dir PL_Env PL_Gappctx PL_Gcheck PL_Gcheck_mutex
syn keyword xsMacro PL_Gcsighandlerp PL_Gcurinterp PL_Gdo_undump
syn keyword xsMacro PL_Gdollarzero_mutex PL_Gfold_locale PL_Ghints_mutex
syn keyword xsMacro PL_Gkeyword_plugin PL_Gmalloc_mutex PL_Gmmap_page_size
syn keyword xsMacro PL_Gmy_ctx_mutex PL_Gmy_cxt_index PL_Gop_mutex PL_Gop_seq
syn keyword xsMacro PL_Gop_sequence PL_Gperlio_debug_fd PL_Gperlio_fd_refcnt
syn keyword xsMacro PL_Gperlio_fd_refcnt_size PL_Gperlio_mutex PL_Gppaddr
syn keyword xsMacro PL_Gsh_path PL_Gsig_defaulting PL_Gsig_handlers_initted
syn keyword xsMacro PL_Gsig_ignoring PL_Gsig_trapped PL_Gsigfpe_saved
syn keyword xsMacro PL_Gsv_placeholder PL_Gthr_key PL_Gtimesbase
syn keyword xsMacro PL_Guse_safe_putenv PL_Gveto_cleanup PL_Gwatch_pvx
syn keyword xsMacro PL_L1Cased PL_L1PosixAlnum PL_L1PosixAlpha
syn keyword xsMacro PL_L1PosixGraph PL_L1PosixLower PL_L1PosixPrint
syn keyword xsMacro PL_L1PosixPunct PL_L1PosixUpper PL_L1PosixWord PL_LIO
syn keyword xsMacro PL_Latin1 PL_Mem PL_MemParse PL_MemShared
syn keyword xsMacro PL_OP_SLAB_ALLOC PL_OpPtr PL_OpSlab PL_OpSpace
syn keyword xsMacro PL_PerlSpace PL_PosixAlnum PL_PosixAlpha PL_PosixBlank
syn keyword xsMacro PL_PosixCntrl PL_PosixDigit PL_PosixGraph PL_PosixLower
syn keyword xsMacro PL_PosixPrint PL_PosixPunct PL_PosixSpace PL_PosixUpper
syn keyword xsMacro PL_PosixWord PL_PosixXDigit PL_Proc PL_Sock PL_StdIO
syn keyword xsMacro PL_Sv PL_VertSpace PL_XPerlSpace PL_XPosixBlank
syn keyword xsMacro PL_XPosixCntrl PL_XPosixSpace PL_XPosixXDigit PL_Xpv
syn keyword xsMacro PL_amagic_generation PL_an PL_apiversion PL_appctx
syn keyword xsMacro PL_argvgv PL_argvout_stack PL_argvoutgv PL_basetime
syn keyword xsMacro PL_beginav PL_beginav_save PL_blockhooks PL_body_arenas
syn keyword xsMacro PL_body_roots PL_bodytarget PL_bostr PL_breakable_sub_gen
syn keyword xsMacro PL_check_mutex PL_checkav PL_checkav_save PL_chopset
syn keyword xsMacro PL_clocktick PL_collation_ix PL_collation_name
syn keyword xsMacro PL_collation_standard PL_collxfrm_base PL_collxfrm_mult
syn keyword xsMacro PL_colors PL_colorset PL_compcv PL_compiling PL_comppad
syn keyword xsMacro PL_comppad_name PL_comppad_name_fill
syn keyword xsMacro PL_comppad_name_floor PL_cop_seqmax PL_cryptseen
syn keyword xsMacro PL_cshlen PL_csighandlerp PL_curcop PL_curcopdb
syn keyword xsMacro PL_curinterp PL_curpad PL_curpm PL_curstack
syn keyword xsMacro PL_curstackinfo PL_curstash PL_curstname
syn keyword xsMacro PL_custom_op_descs PL_custom_op_names PL_custom_ops
syn keyword xsMacro PL_cv_has_eval PL_dbargs PL_debstash PL_debug
syn keyword xsMacro PL_debug_pad PL_def_layerlist PL_defgv PL_defoutgv
syn keyword xsMacro PL_defstash PL_delaymagic PL_delaymagic_egid
syn keyword xsMacro PL_delaymagic_euid PL_delaymagic_gid PL_delaymagic_uid
syn keyword xsMacro PL_destroyhook PL_diehook PL_dirty PL_do_undump
syn keyword xsMacro PL_dollarzero_mutex PL_doswitches PL_dowarn PL_dumper_fd
syn keyword xsMacro PL_dumpindent PL_e_script PL_efloatbuf PL_efloatsize
syn keyword xsMacro PL_encoding PL_endav PL_envgv PL_errgv PL_errors
syn keyword xsMacro PL_eval_root PL_eval_start PL_evalseq PL_exit_flags
syn keyword xsMacro PL_exitlist PL_exitlistlen PL_fdpid PL_filemode
syn keyword xsMacro PL_firstgv PL_forkprocess PL_formfeed PL_formtarget
syn keyword xsMacro PL_generation PL_gensym PL_glob_index PL_globalstash
syn keyword xsMacro PL_globhook PL_hash_seed PL_hintgv PL_hints
syn keyword xsMacro PL_hints_mutex PL_hv_fetch_ent_mh PL_in_clean_all
syn keyword xsMacro PL_in_clean_objs PL_in_eval PL_in_load_module PL_incgv
syn keyword xsMacro PL_initav PL_inplace PL_isarev PL_keyword_plugin
syn keyword xsMacro PL_known_layers PL_last_in_gv PL_last_swash_hv
syn keyword xsMacro PL_last_swash_key PL_last_swash_klen PL_last_swash_slen
syn keyword xsMacro PL_last_swash_tmps PL_lastfd PL_lastgotoprobe
syn keyword xsMacro PL_laststatval PL_laststype PL_localizing PL_localpatches
syn keyword xsMacro PL_lockhook PL_madskills PL_main_cv PL_main_root
syn keyword xsMacro PL_main_start PL_mainstack PL_malloc_mutex PL_markstack
syn keyword xsMacro PL_markstack_max PL_markstack_ptr PL_max_intro_pending
syn keyword xsMacro PL_maxo PL_maxsysfd PL_memory_debug_header PL_mess_sv
syn keyword xsMacro PL_min_intro_pending PL_minus_E PL_minus_F PL_minus_a
syn keyword xsMacro PL_minus_c PL_minus_l PL_minus_n PL_minus_p
syn keyword xsMacro PL_mmap_page_size PL_modcount PL_modglobal
syn keyword xsMacro PL_my_ctx_mutex PL_my_cxt_index PL_my_cxt_keys
syn keyword xsMacro PL_my_cxt_list PL_my_cxt_size PL_nomemok PL_nrs
syn keyword xsMacro PL_numeric_local PL_numeric_name PL_numeric_radix_sv
syn keyword xsMacro PL_numeric_standard PL_ofsgv PL_oldname PL_op PL_op_mask
syn keyword xsMacro PL_op_mutex PL_op_seq PL_op_sequence PL_opfreehook
syn keyword xsMacro PL_opsave PL_origalen PL_origargc PL_origargv
syn keyword xsMacro PL_origenviron PL_origfilename PL_ors_sv PL_osname
syn keyword xsMacro PL_pad_reset_pending PL_padix PL_padix_floor PL_parser
syn keyword xsMacro PL_patchlevel PL_peepp PL_perl_destruct_level PL_perldb
syn keyword xsMacro PL_perlio PL_perlio_debug_fd PL_perlio_fd_refcnt
syn keyword xsMacro PL_perlio_fd_refcnt_size PL_perlio_mutex PL_phase
syn keyword xsMacro PL_pidstatus PL_preambleav PL_profiledata PL_psig_name
syn keyword xsMacro PL_psig_pend PL_psig_ptr PL_ptr_table PL_reentrant_buffer
syn keyword xsMacro PL_reentrant_retint PL_reg_curpm PL_reg_eval_set
syn keyword xsMacro PL_reg_flags PL_reg_leftiter PL_reg_magic
syn keyword xsMacro PL_reg_match_utf8 PL_reg_maxiter PL_reg_oldcurpm
syn keyword xsMacro PL_reg_oldpos PL_reg_oldsaved PL_reg_oldsavedlen
syn keyword xsMacro PL_reg_poscache PL_reg_poscache_size PL_reg_start_tmp
syn keyword xsMacro PL_reg_start_tmpl PL_reg_starttry PL_reg_state
syn keyword xsMacro PL_regdummy PL_regeol PL_regex_pad PL_regex_padav
syn keyword xsMacro PL_reginput PL_reginterp_cnt PL_registered_mros
syn keyword xsMacro PL_reglastcloseparen PL_reglastparen PL_regmatch_slab
syn keyword xsMacro PL_regmatch_state PL_regoffs PL_regsize PL_rehash_seed
syn keyword xsMacro PL_rehash_seed_set PL_replgv PL_restartjmpenv
syn keyword xsMacro PL_restartop PL_rpeepp PL_rs PL_runops PL_savebegin
syn keyword xsMacro PL_savestack PL_savestack_ix PL_savestack_max
syn keyword xsMacro PL_sawampersand PL_scopestack PL_scopestack_ix
syn keyword xsMacro PL_scopestack_max PL_scopestack_name PL_secondgv
syn keyword xsMacro PL_sharehook PL_sig_defaulting PL_sig_handlers_initted
syn keyword xsMacro PL_sig_ignoring PL_sig_pending PL_sig_trapped
syn keyword xsMacro PL_sigfpe_saved PL_sighandlerp PL_signalhook PL_signals
syn keyword xsMacro PL_slab_count PL_slabs PL_sort_RealCmp PL_sortcop
syn keyword xsMacro PL_sortstash PL_splitstr PL_srand_called PL_stack_base
syn keyword xsMacro PL_stack_max PL_stack_sp PL_start_env PL_stashcache
syn keyword xsMacro PL_statbuf PL_statcache PL_statgv PL_statname
syn keyword xsMacro PL_statusvalue PL_statusvalue_posix PL_statusvalue_vms
syn keyword xsMacro PL_stderrgv PL_stdingv PL_strtab PL_sub_generation
syn keyword xsMacro PL_subline PL_subname PL_sv_arenaroot PL_sv_count
syn keyword xsMacro PL_sv_no PL_sv_objcount PL_sv_placeholder PL_sv_root
syn keyword xsMacro PL_sv_serial PL_sv_undef PL_sv_yes PL_sys_intern
syn keyword xsMacro PL_taint_warn PL_tainted PL_tainting PL_thr_key
syn keyword xsMacro PL_threadhook PL_timesbase PL_timesbuf PL_tmps_floor
syn keyword xsMacro PL_tmps_ix PL_tmps_max PL_tmps_stack PL_top_env
syn keyword xsMacro PL_toptarget PL_unicode PL_unitcheckav
syn keyword xsMacro PL_unitcheckav_save PL_unlockhook PL_unsafe
syn keyword xsMacro PL_use_safe_putenv PL_utf8_X_L PL_utf8_X_LV PL_utf8_X_LVT
syn keyword xsMacro PL_utf8_X_LV_LVT_V PL_utf8_X_T PL_utf8_X_V
syn keyword xsMacro PL_utf8_X_begin PL_utf8_X_extend PL_utf8_X_non_hangul
syn keyword xsMacro PL_utf8_X_prepend PL_utf8_alnum PL_utf8_alpha
syn keyword xsMacro PL_utf8_digit PL_utf8_foldable PL_utf8_foldclosures
syn keyword xsMacro PL_utf8_graph PL_utf8_idcont PL_utf8_idstart
syn keyword xsMacro PL_utf8_lower PL_utf8_mark PL_utf8_perl_idstart
syn keyword xsMacro PL_utf8_print PL_utf8_punct PL_utf8_quotemeta
syn keyword xsMacro PL_utf8_space PL_utf8_tofold PL_utf8_tolower
syn keyword xsMacro PL_utf8_totitle PL_utf8_toupper PL_utf8_upper
syn keyword xsMacro PL_utf8_xdigit PL_utf8_xidcont PL_utf8_xidstart
syn keyword xsMacro PL_utf8cache PL_utf8locale PL_veto_cleanup PL_vtbl_amagic
syn keyword xsMacro PL_vtbl_amagicelem PL_vtbl_arylen PL_vtbl_arylen_p
syn keyword xsMacro PL_vtbl_backref PL_vtbl_bm PL_vtbl_collxfrm
syn keyword xsMacro PL_vtbl_dbline PL_vtbl_defelem PL_vtbl_env
syn keyword xsMacro PL_vtbl_envelem PL_vtbl_fm PL_vtbl_hints
syn keyword xsMacro PL_vtbl_hintselem PL_vtbl_isa PL_vtbl_isaelem
syn keyword xsMacro PL_vtbl_mglob PL_vtbl_nkeys PL_vtbl_ovrld PL_vtbl_pack
syn keyword xsMacro PL_vtbl_packelem PL_vtbl_pos PL_vtbl_regdata
syn keyword xsMacro PL_vtbl_regdatum PL_vtbl_regexp PL_vtbl_sigelem
syn keyword xsMacro PL_vtbl_substr PL_vtbl_sv PL_vtbl_taint PL_vtbl_utf8
syn keyword xsMacro PL_vtbl_uvar PL_vtbl_vec PL_vtbl_vstring PL_warnhook
syn keyword xsMacro PL_watch_pvx PL_watchaddr PL_watchok PL_xmlfp PMFUNC
syn keyword xsMacro PM_GETRE PM_SETRE PMf_BASE_SHIFT PMf_COMPILETIME
syn keyword xsMacro PMf_CONST PMf_CONTINUE PMf_EVAL PMf_EXTENDED PMf_FOLD
syn keyword xsMacro PMf_GLOBAL PMf_KEEP PMf_KEEPCOPY PMf_MAYBE_CONST
syn keyword xsMacro PMf_MULTILINE PMf_NONDESTRUCT PMf_ONCE PMf_RETAINT
syn keyword xsMacro PMf_SINGLELINE PMf_USED POPBLOCK POPEVAL POPFORMAT
syn keyword xsMacro POPLOOP POPMARK POPSTACK POPSTACK_TO POPSUB POPSUBST
syn keyword xsMacro POP_MULTICALL POP_SAVEARRAY POPi POPl POPn POPp POPpbytex
syn keyword xsMacro POPpconstx POPpx POPq POPs POPu POPul POPuq POSTDEC
syn keyword xsMacro POSTINC POWOP PP PREC_LOW PREDEC PREGf_CUTGROUP_SEEN
syn keyword xsMacro PREGf_IMPLICIT PREGf_NAUGHTY PREGf_SKIP
syn keyword xsMacro PREGf_VERBARG_SEEN PREINC PREVOPER PRINTF_FORMAT_NULL_OK
syn keyword xsMacro PRIVATEREF PRIVLIB PRIVLIB_EXP PRIVSHIFT PROCSELFEXE_PATH
syn keyword xsMacro PRUNE PSEUDO PTHREAD_ATFORK PTHREAD_ATTR_SETDETACHSTATE
syn keyword xsMacro PTHREAD_CREATE PTHREAD_CREATE_JOINABLE
syn keyword xsMacro PTHREAD_GETSPECIFIC PTHREAD_GETSPECIFIC_INT PTR2IV PTR2NV
syn keyword xsMacro PTR2UV PTR2nat PTR2ul PTRSIZE PTRV PUSHBLOCK PUSHEVAL
syn keyword xsMacro PUSHFORMAT PUSHGIVEN PUSHLOOP_FOR PUSHLOOP_PLAIN PUSHMARK
syn keyword xsMacro PUSHSTACK PUSHSTACKi PUSHSUB PUSHSUBST PUSHSUB_BASE
syn keyword xsMacro PUSHSUB_DB PUSHTARG PUSHWHEN PUSH_MULTICALL PUSHi
syn keyword xsMacro PUSHmortal PUSHn PUSHp PUSHs PUSHu PUTBACK PWGECOS
syn keyword xsMacro PWPASSWD Pause PeRl_CaTiFy PeRl_StGiFy PerlDir_chdir
syn keyword xsMacro PerlDir_close PerlDir_mapA PerlDir_mapW PerlDir_mkdir
syn keyword xsMacro PerlDir_open PerlDir_read PerlDir_rewind PerlDir_rmdir
syn keyword xsMacro PerlDir_seek PerlDir_tell PerlEnv_ENVgetenv
syn keyword xsMacro PerlEnv_ENVgetenv_len PerlEnv_clearenv
syn keyword xsMacro PerlEnv_free_childdir PerlEnv_free_childenv
syn keyword xsMacro PerlEnv_get_child_IO PerlEnv_get_childdir
syn keyword xsMacro PerlEnv_get_childenv PerlEnv_getenv PerlEnv_getenv_len
syn keyword xsMacro PerlEnv_lib_path PerlEnv_os_id PerlEnv_putenv
syn keyword xsMacro PerlEnv_sitelib_path PerlEnv_uname PerlEnv_vendorlib_path
syn keyword xsMacro PerlIOArg PerlIOBase PerlIONext PerlIOSelf PerlIOValid
syn keyword xsMacro PerlIO_canset_cnt PerlIO_exportFILE PerlIO_fast_gets
syn keyword xsMacro PerlIO_fdopen PerlIO_findFILE PerlIO_getc PerlIO_getname
syn keyword xsMacro PerlIO_has_base PerlIO_has_cntptr PerlIO_importFILE
syn keyword xsMacro PerlIO_isutf8 PerlIO_open PerlIO_printf PerlIO_putc
syn keyword xsMacro PerlIO_puts PerlIO_releaseFILE PerlIO_reopen
syn keyword xsMacro PerlIO_rewind PerlIO_sprintf PerlIO_stdoutf
syn keyword xsMacro PerlIO_tmpfile PerlIO_ungetc PerlIO_vprintf
syn keyword xsMacro PerlLIO_access PerlLIO_chmod PerlLIO_chown PerlLIO_chsize
syn keyword xsMacro PerlLIO_close PerlLIO_dup PerlLIO_dup2 PerlLIO_flock
syn keyword xsMacro PerlLIO_fstat PerlLIO_ioctl PerlLIO_isatty PerlLIO_link
syn keyword xsMacro PerlLIO_lseek PerlLIO_lstat PerlLIO_mkstemp
syn keyword xsMacro PerlLIO_mktemp PerlLIO_open PerlLIO_open3 PerlLIO_read
syn keyword xsMacro PerlLIO_rename PerlLIO_setmode PerlLIO_stat
syn keyword xsMacro PerlLIO_tmpnam PerlLIO_umask PerlLIO_unlink PerlLIO_utime
syn keyword xsMacro PerlLIO_write PerlMemParse_calloc PerlMemParse_free
syn keyword xsMacro PerlMemParse_free_lock PerlMemParse_get_lock
syn keyword xsMacro PerlMemParse_is_locked PerlMemParse_malloc
syn keyword xsMacro PerlMemParse_realloc PerlMemShared_calloc
syn keyword xsMacro PerlMemShared_free PerlMemShared_free_lock
syn keyword xsMacro PerlMemShared_get_lock PerlMemShared_is_locked
syn keyword xsMacro PerlMemShared_malloc PerlMemShared_realloc PerlMem_calloc
syn keyword xsMacro PerlMem_free PerlMem_free_lock PerlMem_get_lock
syn keyword xsMacro PerlMem_is_locked PerlMem_malloc PerlMem_realloc
syn keyword xsMacro PerlProc_DynaLoad PerlProc_GetOSError PerlProc__exit
syn keyword xsMacro PerlProc_abort PerlProc_crypt PerlProc_execl
syn keyword xsMacro PerlProc_execv PerlProc_execvp PerlProc_exit
syn keyword xsMacro PerlProc_fork PerlProc_getegid PerlProc_geteuid
syn keyword xsMacro PerlProc_getgid PerlProc_getlogin PerlProc_getpid
syn keyword xsMacro PerlProc_gettimeofday PerlProc_getuid PerlProc_kill
syn keyword xsMacro PerlProc_killpg PerlProc_lasthost PerlProc_longjmp
syn keyword xsMacro PerlProc_pause PerlProc_pclose PerlProc_pipe
syn keyword xsMacro PerlProc_popen PerlProc_popen_list PerlProc_setgid
syn keyword xsMacro PerlProc_setjmp PerlProc_setuid PerlProc_signal
syn keyword xsMacro PerlProc_sleep PerlProc_spawnvp PerlProc_times
syn keyword xsMacro PerlProc_wait PerlProc_waitpid PerlSIO_canset_cnt
syn keyword xsMacro PerlSIO_clearerr PerlSIO_fast_gets PerlSIO_fclose
syn keyword xsMacro PerlSIO_fdopen PerlSIO_fdupopen PerlSIO_feof
syn keyword xsMacro PerlSIO_ferror PerlSIO_fflush PerlSIO_fgetc
syn keyword xsMacro PerlSIO_fgetpos PerlSIO_fgets PerlSIO_fileno
syn keyword xsMacro PerlSIO_fopen PerlSIO_fputc PerlSIO_fputs PerlSIO_fread
syn keyword xsMacro PerlSIO_freopen PerlSIO_fseek PerlSIO_fsetpos
syn keyword xsMacro PerlSIO_ftell PerlSIO_fwrite PerlSIO_get_base
syn keyword xsMacro PerlSIO_get_bufsiz PerlSIO_get_cnt PerlSIO_get_ptr
syn keyword xsMacro PerlSIO_has_base PerlSIO_has_cntptr PerlSIO_init
syn keyword xsMacro PerlSIO_printf PerlSIO_rewind PerlSIO_set_cnt
syn keyword xsMacro PerlSIO_set_ptr PerlSIO_setbuf PerlSIO_setlinebuf
syn keyword xsMacro PerlSIO_setvbuf PerlSIO_stderr PerlSIO_stdin
syn keyword xsMacro PerlSIO_stdout PerlSIO_stdoutf PerlSIO_tmpfile
syn keyword xsMacro PerlSIO_ungetc PerlSIO_vprintf PerlSock_accept
syn keyword xsMacro PerlSock_bind PerlSock_closesocket PerlSock_connect
syn keyword xsMacro PerlSock_endhostent PerlSock_endnetent
syn keyword xsMacro PerlSock_endprotoent PerlSock_endservent
syn keyword xsMacro PerlSock_gethostbyaddr PerlSock_gethostbyname
syn keyword xsMacro PerlSock_gethostent PerlSock_gethostname
syn keyword xsMacro PerlSock_getnetbyaddr PerlSock_getnetbyname
syn keyword xsMacro PerlSock_getnetent PerlSock_getpeername
syn keyword xsMacro PerlSock_getprotobyname PerlSock_getprotobynumber
syn keyword xsMacro PerlSock_getprotoent PerlSock_getservbyname
syn keyword xsMacro PerlSock_getservbyport PerlSock_getservent
syn keyword xsMacro PerlSock_getsockname PerlSock_getsockopt PerlSock_htonl
syn keyword xsMacro PerlSock_htons PerlSock_inet_addr PerlSock_inet_ntoa
syn keyword xsMacro PerlSock_listen PerlSock_ntohl PerlSock_ntohs
syn keyword xsMacro PerlSock_recv PerlSock_recvfrom PerlSock_select
syn keyword xsMacro PerlSock_send PerlSock_sendto PerlSock_sethostent
syn keyword xsMacro PerlSock_setnetent PerlSock_setprotoent
syn keyword xsMacro PerlSock_setservent PerlSock_setsockopt PerlSock_shutdown
syn keyword xsMacro PerlSock_socket PerlSock_socketpair Perl_assert
syn keyword xsMacro Perl_atan2 Perl_atof Perl_atof2 Perl_ceil Perl_cos
syn keyword xsMacro Perl_debug_log Perl_error_log Perl_exp Perl_floor
syn keyword xsMacro Perl_fmod Perl_fp_class Perl_fp_class_denorm
syn keyword xsMacro Perl_fp_class_inf Perl_fp_class_nan Perl_fp_class_ndenorm
syn keyword xsMacro Perl_fp_class_ninf Perl_fp_class_nnorm Perl_fp_class_norm
syn keyword xsMacro Perl_fp_class_nzero Perl_fp_class_pdenorm
syn keyword xsMacro Perl_fp_class_pinf Perl_fp_class_pnorm
syn keyword xsMacro Perl_fp_class_pzero Perl_fp_class_qnan Perl_fp_class_snan
syn keyword xsMacro Perl_fp_class_zero Perl_frexp Perl_isfinite Perl_isinf
syn keyword xsMacro Perl_isnan Perl_log Perl_malloc_good_size Perl_modf
syn keyword xsMacro Perl_pow Perl_pp_accept Perl_pp_aelemfast_lex
syn keyword xsMacro Perl_pp_andassign Perl_pp_avalues Perl_pp_bind
syn keyword xsMacro Perl_pp_bit_xor Perl_pp_chmod Perl_pp_chomp
syn keyword xsMacro Perl_pp_connect Perl_pp_cos Perl_pp_custom
syn keyword xsMacro Perl_pp_dbmclose Perl_pp_dofile Perl_pp_dor
syn keyword xsMacro Perl_pp_dorassign Perl_pp_dump Perl_pp_egrent
syn keyword xsMacro Perl_pp_enetent Perl_pp_eprotoent Perl_pp_epwent
syn keyword xsMacro Perl_pp_eservent Perl_pp_exp Perl_pp_fcntl
syn keyword xsMacro Perl_pp_ftatime Perl_pp_ftbinary Perl_pp_ftblk
syn keyword xsMacro Perl_pp_ftchr Perl_pp_ftctime Perl_pp_ftdir
syn keyword xsMacro Perl_pp_fteexec Perl_pp_fteowned Perl_pp_fteread
syn keyword xsMacro Perl_pp_ftewrite Perl_pp_ftfile Perl_pp_ftmtime
syn keyword xsMacro Perl_pp_ftpipe Perl_pp_ftrexec Perl_pp_ftrwrite
syn keyword xsMacro Perl_pp_ftsgid Perl_pp_ftsize Perl_pp_ftsock
syn keyword xsMacro Perl_pp_ftsuid Perl_pp_ftsvtx Perl_pp_ftzero
syn keyword xsMacro Perl_pp_getpeername Perl_pp_getsockname Perl_pp_ggrgid
syn keyword xsMacro Perl_pp_ggrnam Perl_pp_ghbyaddr Perl_pp_ghbyname
syn keyword xsMacro Perl_pp_gnbyaddr Perl_pp_gnbyname Perl_pp_gpbyname
syn keyword xsMacro Perl_pp_gpbynumber Perl_pp_gpwnam Perl_pp_gpwuid
syn keyword xsMacro Perl_pp_gsbyname Perl_pp_gsbyport Perl_pp_gsockopt
syn keyword xsMacro Perl_pp_hex Perl_pp_i_postdec Perl_pp_i_postinc
syn keyword xsMacro Perl_pp_i_predec Perl_pp_i_preinc Perl_pp_keys
syn keyword xsMacro Perl_pp_kill Perl_pp_lcfirst Perl_pp_lineseq
syn keyword xsMacro Perl_pp_listen Perl_pp_localtime Perl_pp_log
syn keyword xsMacro Perl_pp_lstat Perl_pp_mapstart Perl_pp_msgctl
syn keyword xsMacro Perl_pp_msgget Perl_pp_msgrcv Perl_pp_msgsnd
syn keyword xsMacro Perl_pp_orassign Perl_pp_padany Perl_pp_pop
syn keyword xsMacro Perl_pp_postdec Perl_pp_predec Perl_pp_reach Perl_pp_read
syn keyword xsMacro Perl_pp_recv Perl_pp_regcmaybe Perl_pp_rindex
syn keyword xsMacro Perl_pp_rv2hv Perl_pp_rvalues Perl_pp_say Perl_pp_scalar
syn keyword xsMacro Perl_pp_schomp Perl_pp_scope Perl_pp_seek Perl_pp_semop
syn keyword xsMacro Perl_pp_send Perl_pp_sge Perl_pp_sgrent Perl_pp_sgt
syn keyword xsMacro Perl_pp_shmctl Perl_pp_shmget Perl_pp_shmread
syn keyword xsMacro Perl_pp_shutdown Perl_pp_slt Perl_pp_snetent
syn keyword xsMacro Perl_pp_socket Perl_pp_sprotoent Perl_pp_spwent
syn keyword xsMacro Perl_pp_sqrt Perl_pp_sservent Perl_pp_ssockopt
syn keyword xsMacro Perl_pp_symlink Perl_pp_transr Perl_pp_unlink
syn keyword xsMacro Perl_pp_utime Perl_pp_values Perl_safesysmalloc_size
syn keyword xsMacro Perl_sharepvn Perl_signbit Perl_sin Perl_sqrt
syn keyword xsMacro Perl_va_copy PmopSTASH PmopSTASHPV PmopSTASHPV_set
syn keyword xsMacro PmopSTASH_flags PmopSTASH_flags_set PmopSTASH_free
syn keyword xsMacro PmopSTASH_set Poison PoisonFree PoisonNew PoisonWith
syn keyword xsMacro QR_PAT_MODS QUADKIND QUAD_IS_INT QUAD_IS_INT64_T
syn keyword xsMacro QUAD_IS_LONG QUAD_IS_LONG_LONG QUAD_IS___INT64 QWLIST
syn keyword xsMacro RANDBITS RANDOM_R_PROTO RD_NODATA READDIR64_R_PROTO
syn keyword xsMacro READDIR_R_PROTO REENTRANT_PROTO_B_B REENTRANT_PROTO_B_BI
syn keyword xsMacro REENTRANT_PROTO_B_BW REENTRANT_PROTO_B_CCD
syn keyword xsMacro REENTRANT_PROTO_B_CCS REENTRANT_PROTO_B_IBI
syn keyword xsMacro REENTRANT_PROTO_B_IBW REENTRANT_PROTO_B_SB
syn keyword xsMacro REENTRANT_PROTO_B_SBI REENTRANT_PROTO_I_BI
syn keyword xsMacro REENTRANT_PROTO_I_BW REENTRANT_PROTO_I_CCSBWR
syn keyword xsMacro REENTRANT_PROTO_I_CCSD REENTRANT_PROTO_I_CII
syn keyword xsMacro REENTRANT_PROTO_I_CIISD REENTRANT_PROTO_I_CSBI
syn keyword xsMacro REENTRANT_PROTO_I_CSBIR REENTRANT_PROTO_I_CSBWR
syn keyword xsMacro REENTRANT_PROTO_I_CSBWRE REENTRANT_PROTO_I_CSD
syn keyword xsMacro REENTRANT_PROTO_I_CWISBWRE REENTRANT_PROTO_I_CWISD
syn keyword xsMacro REENTRANT_PROTO_I_D REENTRANT_PROTO_I_H
syn keyword xsMacro REENTRANT_PROTO_I_IBI REENTRANT_PROTO_I_IBW
syn keyword xsMacro REENTRANT_PROTO_I_ICBI REENTRANT_PROTO_I_ICSBWR
syn keyword xsMacro REENTRANT_PROTO_I_ICSD REENTRANT_PROTO_I_ID
syn keyword xsMacro REENTRANT_PROTO_I_IISD REENTRANT_PROTO_I_ISBWR
syn keyword xsMacro REENTRANT_PROTO_I_ISD REENTRANT_PROTO_I_LISBI
syn keyword xsMacro REENTRANT_PROTO_I_LISD REENTRANT_PROTO_I_LS
syn keyword xsMacro REENTRANT_PROTO_I_SB REENTRANT_PROTO_I_SBI
syn keyword xsMacro REENTRANT_PROTO_I_SBIE REENTRANT_PROTO_I_SBIH
syn keyword xsMacro REENTRANT_PROTO_I_SBIR REENTRANT_PROTO_I_SBWR
syn keyword xsMacro REENTRANT_PROTO_I_SBWRE REENTRANT_PROTO_I_SD
syn keyword xsMacro REENTRANT_PROTO_I_ST REENTRANT_PROTO_I_St
syn keyword xsMacro REENTRANT_PROTO_I_TISD REENTRANT_PROTO_I_TS
syn keyword xsMacro REENTRANT_PROTO_I_TSBI REENTRANT_PROTO_I_TSBIR
syn keyword xsMacro REENTRANT_PROTO_I_TSBWR REENTRANT_PROTO_I_TSR
syn keyword xsMacro REENTRANT_PROTO_I_TsISBWRE REENTRANT_PROTO_I_UISBWRE
syn keyword xsMacro REENTRANT_PROTO_I_iS REENTRANT_PROTO_I_lS
syn keyword xsMacro REENTRANT_PROTO_I_uISBWRE REENTRANT_PROTO_S_CBI
syn keyword xsMacro REENTRANT_PROTO_S_CCSBI REENTRANT_PROTO_S_CIISBIE
syn keyword xsMacro REENTRANT_PROTO_S_CSBI REENTRANT_PROTO_S_CSBIE
syn keyword xsMacro REENTRANT_PROTO_S_CWISBIE REENTRANT_PROTO_S_CWISBWIE
syn keyword xsMacro REENTRANT_PROTO_S_ICSBI REENTRANT_PROTO_S_ISBI
syn keyword xsMacro REENTRANT_PROTO_S_LISBI REENTRANT_PROTO_S_SBI
syn keyword xsMacro REENTRANT_PROTO_S_SBIE REENTRANT_PROTO_S_SBW
syn keyword xsMacro REENTRANT_PROTO_S_TISBI REENTRANT_PROTO_S_TSBI
syn keyword xsMacro REENTRANT_PROTO_S_TSBIE REENTRANT_PROTO_S_TWISBIE
syn keyword xsMacro REENTRANT_PROTO_V_D REENTRANT_PROTO_V_H
syn keyword xsMacro REENTRANT_PROTO_V_ID REENTR_H REENTR_MEMZERO REF
syn keyword xsMacro REFCOUNTED_HE_EXISTS REFCOUNTED_HE_KEY_UTF8 REFF REFFA
syn keyword xsMacro REFFL REFFU REFGEN REF_HE_KEY REGMATCH_STATE_MAX
syn keyword xsMacro REGNODE_MAX REGNODE_SIMPLE REGNODE_VARIES REG_ANY
syn keyword xsMacro REG_INFTY REG_MAGIC REG_SEEN_CANY REG_SEEN_CUTGROUP
syn keyword xsMacro REG_SEEN_EVAL REG_SEEN_EXACTF_SHARP_S REG_SEEN_GPOS
syn keyword xsMacro REG_SEEN_LOOKBEHIND REG_SEEN_RECURSE
syn keyword xsMacro REG_SEEN_RUN_ON_COMMENT REG_SEEN_SANY REG_SEEN_VERBARG
syn keyword xsMacro REG_SEEN_ZERO_LEN REG_TOP_LEVEL_BRANCHES RELOP RENUM
syn keyword xsMacro REQUIRE RESTORE_ERRNO RESTORE_NUMERIC_LOCAL
syn keyword xsMacro RESTORE_NUMERIC_STANDARD RETPUSHNO RETPUSHUNDEF
syn keyword xsMacro RETPUSHYES RETSETNO RETSETUNDEF RETSETYES RETURN RETURNOP
syn keyword xsMacro RETURNX RETURN_PROBE REXEC_CHECKED REXEC_COPY_STR
syn keyword xsMacro REXEC_IGNOREPOS REXEC_NOT_FIRST REXEC_SCREAM
syn keyword xsMacro RE_DEBUG_COMPILE_DUMP RE_DEBUG_COMPILE_FLAGS
syn keyword xsMacro RE_DEBUG_COMPILE_MASK RE_DEBUG_COMPILE_OPTIMISE
syn keyword xsMacro RE_DEBUG_COMPILE_PARSE RE_DEBUG_COMPILE_TRIE
syn keyword xsMacro RE_DEBUG_EXECUTE_INTUIT RE_DEBUG_EXECUTE_MASK
syn keyword xsMacro RE_DEBUG_EXECUTE_MATCH RE_DEBUG_EXECUTE_TRIE
syn keyword xsMacro RE_DEBUG_EXTRA_BUFFERS RE_DEBUG_EXTRA_GPOS
syn keyword xsMacro RE_DEBUG_EXTRA_MASK RE_DEBUG_EXTRA_OFFDEBUG
syn keyword xsMacro RE_DEBUG_EXTRA_OFFSETS RE_DEBUG_EXTRA_OPTIMISE
syn keyword xsMacro RE_DEBUG_EXTRA_STACK RE_DEBUG_EXTRA_STATE
syn keyword xsMacro RE_DEBUG_EXTRA_TRIE RE_DEBUG_FLAG RE_DEBUG_FLAGS
syn keyword xsMacro RE_PV_COLOR_DECL RE_PV_QUOTED_DECL RE_SV_DUMPLEN
syn keyword xsMacro RE_SV_ESCAPE RE_SV_TAIL RE_TRACK_PATTERN_OFFSETS
syn keyword xsMacro RE_TRIE_MAXBUF_INIT RE_TRIE_MAXBUF_NAME RMS_DIR RMS_FAC
syn keyword xsMacro RMS_FEX RMS_FNF RMS_IFI RMS_ISI RMS_PRV RUNOPS_DEFAULT
syn keyword xsMacro RV2CVOPCV_MARK_EARLY RV2CVOPCV_RETURN_NAME_GV
syn keyword xsMacro RX_ANCHORED_SUBSTR RX_ANCHORED_UTF8 RX_BUFF_IDX_FULLMATCH
syn keyword xsMacro RX_BUFF_IDX_POSTMATCH RX_BUFF_IDX_PREMATCH
syn keyword xsMacro RX_CHECK_SUBSTR RX_ENGINE RX_EXTFLAGS RX_FLOAT_SUBSTR
syn keyword xsMacro RX_FLOAT_UTF8 RX_GOFS RX_HAS_CUTGROUP RX_LASTCLOSEPAREN
syn keyword xsMacro RX_LASTPAREN RX_MATCH_COPIED RX_MATCH_COPIED_off
syn keyword xsMacro RX_MATCH_COPIED_on RX_MATCH_COPIED_set RX_MATCH_COPY_FREE
syn keyword xsMacro RX_MATCH_TAINTED RX_MATCH_TAINTED_off RX_MATCH_TAINTED_on
syn keyword xsMacro RX_MATCH_TAINTED_set RX_MATCH_UTF8 RX_MATCH_UTF8_off
syn keyword xsMacro RX_MATCH_UTF8_on RX_MATCH_UTF8_set RX_MINLEN RX_MINLENRET
syn keyword xsMacro RX_NPARENS RX_OFFS RX_PRECOMP RX_PRECOMP_const RX_PRELEN
syn keyword xsMacro RX_REFCNT RX_SAVED_COPY RX_SEEN_EVALS RX_SUBBEG RX_SUBLEN
syn keyword xsMacro RX_UTF8 RX_WRAPLEN RX_WRAPPED RX_WRAPPED_const RXapif_ALL
syn keyword xsMacro RXapif_CLEAR RXapif_DELETE RXapif_EXISTS RXapif_FETCH
syn keyword xsMacro RXapif_FIRSTKEY RXapif_NEXTKEY RXapif_ONE RXapif_REGNAME
syn keyword xsMacro RXapif_REGNAMES RXapif_REGNAMES_COUNT RXapif_SCALAR
syn keyword xsMacro RXapif_STORE RXf_ANCH RXf_ANCH_BOL RXf_ANCH_GPOS
syn keyword xsMacro RXf_ANCH_MBOL RXf_ANCH_SBOL RXf_ANCH_SINGLE
syn keyword xsMacro RXf_BASE_SHIFT RXf_CANY_SEEN RXf_CHECK_ALL RXf_COPY_DONE
syn keyword xsMacro RXf_EVAL_SEEN RXf_GPOS_CHECK RXf_GPOS_FLOAT RXf_GPOS_SEEN
syn keyword xsMacro RXf_INTUIT_TAIL RXf_LOOKBEHIND_SEEN RXf_MATCH_UTF8
syn keyword xsMacro RXf_NOSCAN RXf_NULL RXf_PMf_CHARSET RXf_PMf_COMPILETIME
syn keyword xsMacro RXf_PMf_EXTENDED RXf_PMf_FOLD RXf_PMf_KEEPCOPY
syn keyword xsMacro RXf_PMf_MULTILINE RXf_PMf_SINGLELINE RXf_PMf_STD_PMMOD
syn keyword xsMacro RXf_PMf_STD_PMMOD_SHIFT RXf_SKIPWHITE RXf_SPLIT
syn keyword xsMacro RXf_START_ONLY RXf_TAINTED RXf_TAINTED_SEEN
syn keyword xsMacro RXf_USE_INTUIT RXf_USE_INTUIT_ML RXf_USE_INTUIT_NOML
syn keyword xsMacro RXf_WHITE RXi_GET RXi_GET_DECL RXi_SET RXp_EXTFLAGS
syn keyword xsMacro RXp_MATCH_COPIED RXp_MATCH_COPIED_off RXp_MATCH_COPIED_on
syn keyword xsMacro RXp_MATCH_TAINTED RXp_MATCH_UTF8 RXp_PAREN_NAMES
syn keyword xsMacro ReREFCNT_dec ReREFCNT_inc Renew Renewc RsPARA RsRECORD
syn keyword xsMacro RsSIMPLE RsSNARF SAFE_TRIE_NODENUM SANY SAVEADELETE
syn keyword xsMacro SAVEBOOL SAVECLEARSV SAVECOMPILEWARNINGS SAVECOMPPAD
syn keyword xsMacro SAVECOPFILE SAVECOPFILE_FREE SAVECOPLINE SAVECOPSTASH
syn keyword xsMacro SAVECOPSTASH_FREE SAVEDELETE SAVEDESTRUCTOR
syn keyword xsMacro SAVEDESTRUCTOR_X SAVEFREECOPHH SAVEFREEOP SAVEFREEPV
syn keyword xsMacro SAVEFREESV SAVEGENERICPV SAVEGENERICSV SAVEHDELETE
syn keyword xsMacro SAVEHINTS SAVEI16 SAVEI32 SAVEI8 SAVEINT SAVEIV SAVELONG
syn keyword xsMacro SAVEMORTALIZESV SAVEOP SAVEPADSVANDMORTALIZE SAVEPARSER
syn keyword xsMacro SAVEPPTR SAVESETSVFLAGS SAVESHAREDPV SAVESPTR
syn keyword xsMacro SAVESTACK_ALLOC_FOR_RE_SAVE_STATE SAVESTACK_CXPOS
syn keyword xsMacro SAVESTACK_POS SAVESWITCHSTACK SAVETMPS SAVEVPTR
syn keyword xsMacro SAVE_DEFSV SAVE_ERRNO SAVE_MASK SAVE_TIGHT_SHIFT
syn keyword xsMacro SAVEf_KEEPOLDELEM SAVEf_SETMAGIC SAVEt_ADELETE
syn keyword xsMacro SAVEt_AELEM SAVEt_ALLOC SAVEt_APTR SAVEt_AV SAVEt_BOOL
syn keyword xsMacro SAVEt_CLEARSV SAVEt_COMPILE_WARNINGS SAVEt_COMPPAD
syn keyword xsMacro SAVEt_DELETE SAVEt_DESTRUCTOR SAVEt_DESTRUCTOR_X
syn keyword xsMacro SAVEt_FREECOPHH SAVEt_FREEOP SAVEt_FREEPV SAVEt_FREESV
syn keyword xsMacro SAVEt_GENERIC_PVREF SAVEt_GENERIC_SVREF SAVEt_GP
syn keyword xsMacro SAVEt_GVSV SAVEt_HELEM SAVEt_HINTS SAVEt_HPTR SAVEt_HV
syn keyword xsMacro SAVEt_I16 SAVEt_I32 SAVEt_I32_SMALL SAVEt_I8 SAVEt_INT
syn keyword xsMacro SAVEt_INT_SMALL SAVEt_ITEM SAVEt_IV SAVEt_LONG
syn keyword xsMacro SAVEt_MORTALIZESV SAVEt_NSTAB SAVEt_OP
syn keyword xsMacro SAVEt_PADSV_AND_MORTALIZE SAVEt_PARSER SAVEt_PPTR
syn keyword xsMacro SAVEt_REGCONTEXT SAVEt_RE_STATE SAVEt_SAVESWITCHSTACK
syn keyword xsMacro SAVEt_SET_SVFLAGS SAVEt_SHARED_PVREF SAVEt_SPTR
syn keyword xsMacro SAVEt_STACK_CXPOS SAVEt_STACK_POS SAVEt_SV SAVEt_SVREF
syn keyword xsMacro SAVEt_VPTR SBOL SCAN_DEF SCAN_REPL SCAN_TR SCHEDULE
syn keyword xsMacro SCHED_YIELD SCOPE_SAVES_SIGNAL_MASK SEEK_CUR SEEK_END
syn keyword xsMacro SEEK_SET SELECT_MIN_BITS SEOL SETERRNO SETGRENT_R_PROTO
syn keyword xsMacro SETHOSTENT_R_PROTO SETLOCALE_R_PROTO SETNETENT_R_PROTO
syn keyword xsMacro SETPROTOENT_R_PROTO SETPWENT_R_PROTO SETSERVENT_R_PROTO
syn keyword xsMacro SETTARG SET_MARK_OFFSET SET_NUMERIC_LOCAL
syn keyword xsMacro SET_NUMERIC_STANDARD SET_THR SET_THREAD_SELF SETi SETn
syn keyword xsMacro SETp SETs SETsv SETsvUN SETu SHARP_S_SKIP SHIFTOP
syn keyword xsMacro SHORTSIZE SH_PATH SIGABRT SIGILL SIG_NAME SIG_NUM
syn keyword xsMacro SIG_SIZE SINGLE_PAT_MOD SITEARCH SITEARCH_EXP SITELIB
syn keyword xsMacro SITELIB_EXP SITELIB_STEM SIZE_ALIGN SIZE_ONLY SKIP
syn keyword xsMacro SKIP_next SKIP_next_fail SLOPPYDIVIDE SOCKET_OPEN_MODE
syn keyword xsMacro SPACE SPACEA SPACEL SPACEU SPAGAIN SPRINTF_RETURNS_STRLEN
syn keyword xsMacro SRAND48_R_PROTO SRANDOM_R_PROTO SSCHECK SSGROW SSNEW
syn keyword xsMacro SSNEWa SSNEWat SSNEWt SSPOPBOOL SSPOPDPTR SSPOPDXPTR
syn keyword xsMacro SSPOPINT SSPOPIV SSPOPLONG SSPOPPTR SSPOPUV SSPTR SSPTRt
syn keyword xsMacro SSPUSHBOOL SSPUSHDPTR SSPUSHDXPTR SSPUSHINT SSPUSHIV
syn keyword xsMacro SSPUSHLONG SSPUSHPTR SSPUSHUV SS_ACCVIO SS_DEVOFFLINE
syn keyword xsMacro SS_IVCHAN SS_NORMAL ST STANDARD_C STAR STARTPERL
syn keyword xsMacro START_EXTERN_C START_MY_CXT STATIC STATUS_ALL_FAILURE
syn keyword xsMacro STATUS_ALL_SUCCESS STATUS_CURRENT STATUS_EXIT
syn keyword xsMacro STATUS_EXIT_SET STATUS_NATIVE STATUS_NATIVE_CHILD_SET
syn keyword xsMacro STATUS_UNIX STATUS_UNIX_EXIT_SET STATUS_UNIX_SET STDCHAR
syn keyword xsMacro STDIO_PTR_LVALUE STDIO_PTR_LVAL_SETS_CNT
syn keyword xsMacro STDIO_STREAM_ARRAY STD_PAT_MODS STD_PMMOD_FLAGS_CLEAR
syn keyword xsMacro STMT_END STMT_START STORE_NUMERIC_LOCAL_SET_STANDARD
syn keyword xsMacro STORE_NUMERIC_STANDARD_SET_LOCAL STRERROR_R_PROTO STRING
syn keyword xsMacro STRINGIFY STRUCT_OFFSET STRUCT_SV STR_LEN STR_SZ
syn keyword xsMacro STR_WITH_LEN ST_INO_SIGN ST_INO_SIZE SUB
syn keyword xsMacro SUBST_TAINT_BOOLRET SUBST_TAINT_PAT SUBST_TAINT_REPL
syn keyword xsMacro SUBST_TAINT_RETAINT SUBST_TAINT_STR SUBVERSION SUCCEED
syn keyword xsMacro SUSPEND SVTYPEMASK SV_CATBYTES SV_CATUTF8
syn keyword xsMacro SV_CHECK_THINKFIRST SV_CHECK_THINKFIRST_COW_DROP
syn keyword xsMacro SV_CONST_RETURN SV_COW_DROP_PV SV_COW_OTHER_PVS
syn keyword xsMacro SV_COW_SHARED_HASH_KEYS SV_DO_COW_SVSETSV
syn keyword xsMacro SV_FORCE_UTF8_UPGRADE SV_GMAGIC SV_HAS_TRAILING_NUL
syn keyword xsMacro SV_IMMEDIATE_UNREF SV_MUTABLE_RETURN SV_NOSTEAL
syn keyword xsMacro SV_SAVED_COPY SV_SKIP_OVERLOAD SV_SMAGIC
syn keyword xsMacro SV_UNDEF_RETURNS_NULL SV_UTF8_NO_ENCODING SVrepl_EVAL
syn keyword xsMacro SVt_MASK SWITCHSTACK SYMBIAN SYSTEM_GMTIME_MAX
syn keyword xsMacro SYSTEM_GMTIME_MIN SYSTEM_LOCALTIME_MAX
syn keyword xsMacro SYSTEM_LOCALTIME_MIN S_IEXEC S_IFIFO S_IFMT S_IREAD
syn keyword xsMacro S_IRGRP S_IROTH S_IRUSR S_IRWXG S_IRWXO S_IRWXU S_ISBLK
syn keyword xsMacro S_ISCHR S_ISDIR S_ISFIFO S_ISGID S_ISLNK S_ISREG S_ISSOCK
syn keyword xsMacro S_ISUID S_IWGRP S_IWOTH S_IWRITE S_IWUSR S_IXGRP S_IXOTH
syn keyword xsMacro S_IXUSR S_PAT_MODS Safefree Semctl Sigjmp_buf Siglongjmp
syn keyword xsMacro Sigsetjmp Size_t_size StGiFy StashHANDLER Stat Strerror
syn keyword xsMacro Strtol Strtoul StructCopy SvAMAGIC SvAMAGIC_off
syn keyword xsMacro SvAMAGIC_on SvANY SvCANEXISTDELETE SvCOMPILED
syn keyword xsMacro SvCOMPILED_off SvCOMPILED_on SvCUR SvCUR_set
syn keyword xsMacro SvDESTROYABLE SvEND SvEND_set SvENDx SvEVALED
syn keyword xsMacro SvEVALED_off SvEVALED_on SvFAKE SvFAKE_off SvFAKE_on
syn keyword xsMacro SvFLAGS SvGAMAGIC SvGETMAGIC SvGMAGICAL SvGMAGICAL_off
syn keyword xsMacro SvGMAGICAL_on SvGROW SvGROW_mutable SvIMMORTAL SvIOK
syn keyword xsMacro SvIOK_UV SvIOK_notUV SvIOK_off SvIOK_on SvIOK_only
syn keyword xsMacro SvIOK_only_UV SvIOKp SvIOKp_on SvIS_FREED SvIV SvIVX
syn keyword xsMacro SvIVXx SvIV_nomg SvIV_please SvIV_please_nomg SvIV_set
syn keyword xsMacro SvIVx SvIsCOW SvIsCOW_normal SvIsCOW_shared_hash SvIsUV
syn keyword xsMacro SvIsUV_off SvIsUV_on SvLEN SvLEN_set SvLENx SvLOCK
syn keyword xsMacro SvMAGIC SvMAGICAL SvMAGICAL_off SvMAGICAL_on SvMAGIC_set
syn keyword xsMacro SvNIOK SvNIOK_off SvNIOKp SvNOK SvNOK_off SvNOK_on
syn keyword xsMacro SvNOK_only SvNOKp SvNOKp_on SvNV SvNVX SvNVXx SvNV_nomg
syn keyword xsMacro SvNV_set SvNVx SvOBJECT SvOBJECT_off SvOBJECT_on SvOK
syn keyword xsMacro SvOK_off SvOK_off_exc_UV SvOKp SvOOK SvOOK_off
syn keyword xsMacro SvOOK_offset SvOOK_on SvOURSTASH SvOURSTASH_set SvPADMY
syn keyword xsMacro SvPADMY_on SvPADSTALE SvPADSTALE_off SvPADSTALE_on
syn keyword xsMacro SvPADTMP SvPADTMP_off SvPADTMP_on SvPAD_OUR SvPAD_OUR_on
syn keyword xsMacro SvPAD_STATE SvPAD_STATE_on SvPAD_TYPED SvPAD_TYPED_on
syn keyword xsMacro SvPCS_IMPORTED SvPCS_IMPORTED_off SvPCS_IMPORTED_on
syn keyword xsMacro SvPEEK SvPOK SvPOK_off SvPOK_on SvPOK_only
syn keyword xsMacro SvPOK_only_UTF8 SvPOKp SvPOKp_on SvPV SvPVX SvPVX_const
syn keyword xsMacro SvPVX_mutable SvPVXx SvPV_const SvPV_flags
syn keyword xsMacro SvPV_flags_const SvPV_flags_const_nolen
syn keyword xsMacro SvPV_flags_mutable SvPV_force SvPV_force_flags
syn keyword xsMacro SvPV_force_flags_mutable SvPV_force_flags_nolen
syn keyword xsMacro SvPV_force_mutable SvPV_force_nolen SvPV_force_nomg
syn keyword xsMacro SvPV_force_nomg_nolen SvPV_free SvPV_mutable SvPV_nolen
syn keyword xsMacro SvPV_nolen_const SvPV_nomg SvPV_nomg_const
syn keyword xsMacro SvPV_nomg_const_nolen SvPV_nomg_nolen SvPV_renew SvPV_set
syn keyword xsMacro SvPV_shrink_to_cur SvPVbyte SvPVbyte_force SvPVbyte_nolen
syn keyword xsMacro SvPVbytex SvPVbytex_force SvPVbytex_nolen SvPVutf8
syn keyword xsMacro SvPVutf8_force SvPVutf8_nolen SvPVutf8x SvPVutf8x_force
syn keyword xsMacro SvPVx SvPVx_const SvPVx_force SvPVx_nolen
syn keyword xsMacro SvPVx_nolen_const SvREADONLY SvREADONLY_off SvREADONLY_on
syn keyword xsMacro SvREFCNT SvREFCNT_dec SvREFCNT_inc SvREFCNT_inc_NN
syn keyword xsMacro SvREFCNT_inc_simple SvREFCNT_inc_simple_NN
syn keyword xsMacro SvREFCNT_inc_simple_void SvREFCNT_inc_simple_void_NN
syn keyword xsMacro SvREFCNT_inc_void SvREFCNT_inc_void_NN SvRELEASE_IVX
syn keyword xsMacro SvRELEASE_IVX_ SvRMAGICAL SvRMAGICAL_off SvRMAGICAL_on
syn keyword xsMacro SvROK SvROK_off SvROK_on SvRV SvRV_const SvRV_set SvRVx
syn keyword xsMacro SvRX SvRXOK SvSCREAM SvSCREAM_off SvSCREAM_on SvSETMAGIC
syn keyword xsMacro SvSHARE SvSHARED_HASH SvSHARED_HEK_FROM_PV SvSMAGICAL
syn keyword xsMacro SvSMAGICAL_off SvSMAGICAL_on SvSTASH SvSTASH_set
syn keyword xsMacro SvSetMagicSV SvSetMagicSV_nosteal SvSetSV SvSetSV_and
syn keyword xsMacro SvSetSV_nosteal SvSetSV_nosteal_and SvTAIL SvTAIL_off
syn keyword xsMacro SvTAIL_on SvTAINT SvTAINTED SvTAINTED_off SvTAINTED_on
syn keyword xsMacro SvTEMP SvTEMP_off SvTEMP_on SvTHINKFIRST SvTIED_mg
syn keyword xsMacro SvTIED_obj SvTRUE SvTRUE_nomg SvTRUEx SvTYPE SvUNLOCK
syn keyword xsMacro SvUOK SvUPGRADE SvUTF8 SvUTF8_off SvUTF8_on SvUV SvUVX
syn keyword xsMacro SvUVXx SvUV_nomg SvUV_set SvUVx SvVALID SvVALID_off
syn keyword xsMacro SvVALID_on SvVOK SvVSTRING_mg SvWEAKREF SvWEAKREF_off
syn keyword xsMacro SvWEAKREF_on Sv_Grow TAIL TAINT TAINT_ENV TAINT_IF
syn keyword xsMacro TAINT_NOT TAINT_PROPER THING THR THREAD_CREATE
syn keyword xsMacro THREAD_CREATE_NEEDS_STACK THREAD_POST_CREATE
syn keyword xsMacro THREAD_RET_CAST THREAD_RET_TYPE
syn keyword xsMacro TIED_METHOD_ARGUMENTS_ON_STACK
syn keyword xsMacro TIED_METHOD_MORTALIZE_NOT_NEEDED TIED_METHOD_SAY
syn keyword xsMacro TIME64_CONFIG_H TIME64_H TM TMPNAM_R_PROTO TOO_LATE_FOR
syn keyword xsMacro TOO_LATE_FOR_ TOPBLOCK TOPMARK TOPi TOPl TOPm1s TOPn TOPp
syn keyword xsMacro TOPp1s TOPpx TOPq TOPs TOPu TOPul TOPuq TRIE TRIEC
syn keyword xsMacro TRIE_BITMAP TRIE_BITMAP_BYTE TRIE_BITMAP_CLEAR
syn keyword xsMacro TRIE_BITMAP_SET TRIE_BITMAP_TEST TRIE_CHARCOUNT
syn keyword xsMacro TRIE_NODEIDX TRIE_NODENUM TRIE_WORDS_OFFSET TRIE_next
syn keyword xsMacro TRIE_next_fail TTYNAME_R_PROTO TWO_BYTE_UTF8_TO_UNI
syn keyword xsMacro TYPE_CHARS TYPE_DIGITS Timeval U16SIZE U16TYPE U16_CONST
syn keyword xsMacro U16_MAX U16_MIN U32SIZE U32TYPE U32_ALIGNMENT_REQUIRED
syn keyword xsMacro U32_CONST U32_MAX U32_MAX_P1 U32_MAX_P1_HALF U32_MIN
syn keyword xsMacro U64SIZE U64TYPE U64_CONST U8SIZE U8TYPE U8_MAX U8_MIN
syn keyword xsMacro UCHARAT UINT32_MIN UINT64_C UINT64_MIN UMINUS UNDERBAR
syn keyword xsMacro UNICODE_ALLOW_ANY UNICODE_ALLOW_SUPER
syn keyword xsMacro UNICODE_ALLOW_SURROGATE UNICODE_BYTE_ORDER_MARK
syn keyword xsMacro UNICODE_DISALLOW_FE_FF
syn keyword xsMacro UNICODE_DISALLOW_ILLEGAL_INTERCHANGE
syn keyword xsMacro UNICODE_DISALLOW_NONCHAR UNICODE_DISALLOW_SUPER
syn keyword xsMacro UNICODE_DISALLOW_SURROGATE
syn keyword xsMacro UNICODE_GREEK_CAPITAL_LETTER_SIGMA
syn keyword xsMacro UNICODE_GREEK_SMALL_LETTER_FINAL_SIGMA
syn keyword xsMacro UNICODE_GREEK_SMALL_LETTER_SIGMA
syn keyword xsMacro UNICODE_IS_BYTE_ORDER_MARK UNICODE_IS_FE_FF
syn keyword xsMacro UNICODE_IS_NONCHAR UNICODE_IS_REPLACEMENT
syn keyword xsMacro UNICODE_IS_SUPER UNICODE_IS_SURROGATE UNICODE_LINE_SEPA_0
syn keyword xsMacro UNICODE_LINE_SEPA_1 UNICODE_LINE_SEPA_2
syn keyword xsMacro UNICODE_PARA_SEPA_0 UNICODE_PARA_SEPA_1
syn keyword xsMacro UNICODE_PARA_SEPA_2 UNICODE_PAT_MOD UNICODE_PAT_MODS
syn keyword xsMacro UNICODE_REPLACEMENT UNICODE_SURROGATE_FIRST
syn keyword xsMacro UNICODE_SURROGATE_LAST UNICODE_WARN_FE_FF
syn keyword xsMacro UNICODE_WARN_ILLEGAL_INTERCHANGE UNICODE_WARN_NONCHAR
syn keyword xsMacro UNICODE_WARN_SUPER UNICODE_WARN_SURROGATE UNIOP UNIOPSUB
syn keyword xsMacro UNISKIP UNI_DISPLAY_BACKSLASH UNI_DISPLAY_ISPRINT
syn keyword xsMacro UNI_DISPLAY_QQ UNI_DISPLAY_REGEX UNI_IS_INVARIANT
syn keyword xsMacro UNI_TO_NATIVE UNLESS UNLESSM UNLIKELY UNLINK
syn keyword xsMacro UNLOCK_DOLLARZERO_MUTEX UNTIL USE USE_64_BIT_ALL
syn keyword xsMacro USE_64_BIT_INT USE_64_BIT_RAWIO USE_64_BIT_STDIO
syn keyword xsMacro USE_BSDPGRP USE_DYNAMIC_LOADING USE_ENVIRON_ARRAY
syn keyword xsMacro USE_HASH_SEED USE_HEAP_INSTEAD_OF_STACK USE_LARGE_FILES
syn keyword xsMacro USE_LEFT USE_LOCALE USE_LOCALE_COLLATE USE_LOCALE_CTYPE
syn keyword xsMacro USE_LOCALE_NUMERIC USE_PERLIO USE_REENTRANT_API
syn keyword xsMacro USE_SEMCTL_SEMID_DS USE_SEMCTL_SEMUN USE_STAT_BLOCKS
syn keyword xsMacro USE_STAT_RDEV USE_STDIO USE_STDIO_BASE USE_STDIO_PTR
syn keyword xsMacro USE_STRUCT_COPY USE_SYSTEM_GMTIME USE_SYSTEM_LOCALTIME
syn keyword xsMacro USE_THREADS USE_TM64 USE_UTF8_IN_NAMES UTF8SKIP
syn keyword xsMacro UTF8_ACCUMULATE UTF8_ALLOW_ANY UTF8_ALLOW_ANYUV
syn keyword xsMacro UTF8_ALLOW_CONTINUATION UTF8_ALLOW_DEFAULT
syn keyword xsMacro UTF8_ALLOW_EMPTY UTF8_ALLOW_FFFF UTF8_ALLOW_LONG
syn keyword xsMacro UTF8_ALLOW_NON_CONTINUATION UTF8_ALLOW_SHORT
syn keyword xsMacro UTF8_ALLOW_SURROGATE UTF8_CHECK_ONLY UTF8_DISALLOW_FE_FF
syn keyword xsMacro UTF8_DISALLOW_ILLEGAL_INTERCHANGE UTF8_DISALLOW_NONCHAR
syn keyword xsMacro UTF8_DISALLOW_SUPER UTF8_DISALLOW_SURROGATE
syn keyword xsMacro UTF8_EIGHT_BIT_HI UTF8_EIGHT_BIT_LO
syn keyword xsMacro UTF8_FIRST_PROBLEMATIC_CODE_POINT_FIRST_BYTE
syn keyword xsMacro UTF8_IS_CONTINUATION UTF8_IS_CONTINUED
syn keyword xsMacro UTF8_IS_DOWNGRADEABLE_START UTF8_IS_INVARIANT
syn keyword xsMacro UTF8_IS_NONCHAR_
syn keyword xsMacro UTF8_IS_NONCHAR_GIVEN_THAT_NON_SUPER_AND_GE_PROBLEMATIC
syn keyword xsMacro UTF8_IS_START UTF8_IS_SUPER UTF8_IS_SURROGATE
syn keyword xsMacro UTF8_MAXBYTES UTF8_MAXBYTES_CASE UTF8_MAXLEN
syn keyword xsMacro UTF8_MAX_FOLD_CHAR_EXPAND UTF8_QUAD_MAX UTF8_TWO_BYTE_HI
syn keyword xsMacro UTF8_TWO_BYTE_HI_nocast UTF8_TWO_BYTE_LO
syn keyword xsMacro UTF8_TWO_BYTE_LO_nocast UTF8_WARN_FE_FF
syn keyword xsMacro UTF8_WARN_ILLEGAL_INTERCHANGE UTF8_WARN_NONCHAR
syn keyword xsMacro UTF8_WARN_SUPER UTF8_WARN_SURROGATE
syn keyword xsMacro UTF_ACCUMULATION_OVERFLOW_MASK UTF_ACCUMULATION_SHIFT
syn keyword xsMacro UTF_CONTINUATION_MARK UTF_CONTINUATION_MASK
syn keyword xsMacro UTF_START_MARK UTF_START_MASK UTF_TO_NATIVE UVSIZE UVTYPE
syn keyword xsMacro UVXf UV_DIG UV_MAX UV_MAX_P1 UV_MAX_P1_HALF UV_MIN UVf
syn keyword xsMacro U_32 U_I U_L U_S U_V Uid_t_f Uid_t_sign Uid_t_size
syn keyword xsMacro VAL_EAGAIN VAL_O_NONBLOCK VDf VERB VERTWS VOIDFLAGS
syn keyword xsMacro VOIDUSED VOL VTBL_amagic VTBL_amagicelem VTBL_arylen
syn keyword xsMacro VTBL_bm VTBL_collxfrm VTBL_dbline VTBL_defelem VTBL_env
syn keyword xsMacro VTBL_envelem VTBL_fm VTBL_glob VTBL_isa VTBL_isaelem
syn keyword xsMacro VTBL_mglob VTBL_nkeys VTBL_pack VTBL_packelem VTBL_pos
syn keyword xsMacro VTBL_regdata VTBL_regdatum VTBL_regexp VTBL_sigelem
syn keyword xsMacro VTBL_substr VTBL_sv VTBL_taint VTBL_uvar VTBL_vec
syn keyword xsMacro WARN_ALL WARN_ALLstring WARN_AMBIGUOUS WARN_BAREWORD
syn keyword xsMacro WARN_CLOSED WARN_CLOSURE WARN_DEBUGGING WARN_DEPRECATED
syn keyword xsMacro WARN_DIGIT WARN_EXEC WARN_EXITING WARN_GLOB
syn keyword xsMacro WARN_ILLEGALPROTO WARN_IMPRECISION WARN_INPLACE
syn keyword xsMacro WARN_INTERNAL WARN_IO WARN_LAYER WARN_MALLOC WARN_MISC
syn keyword xsMacro WARN_NEWLINE WARN_NONCHAR WARN_NONEstring
syn keyword xsMacro WARN_NON_UNICODE WARN_NUMERIC WARN_ONCE WARN_OVERFLOW
syn keyword xsMacro WARN_PACK WARN_PARENTHESIS WARN_PIPE WARN_PORTABLE
syn keyword xsMacro WARN_PRECEDENCE WARN_PRINTF WARN_PROTOTYPE WARN_QW
syn keyword xsMacro WARN_RECURSION WARN_REDEFINE WARN_REGEXP WARN_RESERVED
syn keyword xsMacro WARN_SEMICOLON WARN_SEVERE WARN_SIGNAL WARN_SUBSTR
syn keyword xsMacro WARN_SURROGATE WARN_SYNTAX WARN_TAINT WARN_THREADS
syn keyword xsMacro WARN_UNINITIALIZED WARN_UNOPENED WARN_UNPACK WARN_UNTIE
syn keyword xsMacro WARN_UTF8 WARN_VOID WARNshift WARNsize WEXITSTATUS WHEN
syn keyword xsMacro WHILE WHILEM WHILEM_A_max WHILEM_A_max_fail WHILEM_A_min
syn keyword xsMacro WHILEM_A_min_fail WHILEM_A_pre WHILEM_A_pre_fail
syn keyword xsMacro WHILEM_B_max WHILEM_B_max_fail WHILEM_B_min
syn keyword xsMacro WHILEM_B_min_fail WIDEST_UTYPE WIFEXITED WIFSIGNALED
syn keyword xsMacro WIFSTOPPED WIN32SCK_IS_STDSCK WNOHANG WORD WSTOPSIG
syn keyword xsMacro WTERMSIG WUNTRACED XHvTOTALKEYS XOPd_xop_class
syn keyword xsMacro XOPd_xop_desc XOPd_xop_name XOPd_xop_peep XOPf_xop_class
syn keyword xsMacro XOPf_xop_desc XOPf_xop_name XOPf_xop_peep XPUSHTARG
syn keyword xsMacro XPUSHi XPUSHmortal XPUSHn XPUSHp XPUSHs XPUSHu XPUSHundef
syn keyword xsMacro XS XSANY XSINTERFACE_CVT XSINTERFACE_CVT_ANON
syn keyword xsMacro XSINTERFACE_FUNC XSINTERFACE_FUNC_SET XSPROTO XSRETURN
syn keyword xsMacro XSRETURN_EMPTY XSRETURN_IV XSRETURN_NO XSRETURN_NV
syn keyword xsMacro XSRETURN_PV XSRETURN_PVN XSRETURN_UNDEF XSRETURN_UV
syn keyword xsMacro XSRETURN_YES XST_mIV XST_mNO XST_mNV XST_mPV XST_mPVN
syn keyword xsMacro XST_mUNDEF XST_mUV XST_mYES XS_APIVERSION_BOOTCHECK
syn keyword xsMacro XS_DYNAMIC_FILENAME XS_EXTERNAL XS_INTERNAL
syn keyword xsMacro XS_VERSION_BOOTCHECK XSprePUSH XTENDED_PAT_MOD XopDISABLE
syn keyword xsMacro XopENABLE XopENTRY XopENTRY_set XopFLAGS YADAYADA YIELD
syn keyword xsMacro YYEMPTY YYSTYPE_IS_DECLARED YYSTYPE_IS_TRIVIAL
syn keyword xsMacro YYTOKENTYPE Zero ZeroD _ _CANNOT _CC_ALNUMC_A
syn keyword xsMacro _CC_ALNUMC_L1 _CC_ALPHA_A _CC_ALPHA_L1 _CC_BLANK_A
syn keyword xsMacro _CC_BLANK_L1 _CC_CHARNAME_CONT _CC_CNTRL_A _CC_CNTRL_L1
syn keyword xsMacro _CC_DIGIT_A _CC_GRAPH_A _CC_GRAPH_L1 _CC_IDFIRST_A
syn keyword xsMacro _CC_IDFIRST_L1 _CC_LOWER_A _CC_LOWER_L1
syn keyword xsMacro _CC_NONLATIN1_FOLD _CC_OCTAL_A _CC_PRINT_A _CC_PRINT_L1
syn keyword xsMacro _CC_PSXSPC_A _CC_PSXSPC_L1 _CC_PUNCT_A _CC_PUNCT_L1
syn keyword xsMacro _CC_QUOTEMETA _CC_SPACE_A _CC_SPACE_L1 _CC_UPPER_A
syn keyword xsMacro _CC_UPPER_L1 _CC_WORDCHAR_A _CC_WORDCHAR_L1 _CC_XDIGIT_A
syn keyword xsMacro _CPERLarg _GNU_SOURCE
syn keyword xsMacro _HAS_NONLATIN1_FOLD_CLOSURE_ONLY_FOR_USE_BY_REGCOMP_DOT_C_AND_REGEXEC_DOT_C
syn keyword xsMacro _INC_PERL_XSUB_H _PERLIOL_H _PERLIO_H _PERL_OBJECT_THIS
syn keyword xsMacro _REGEXP_COMMON _RXf_PMf_CHARSET_SHIFT _RXf_PMf_SHIFT_NEXT
syn keyword xsMacro _SOCKADDR_LEN _STDIO_H _STDIO_INCLUDED _V _XPVCV_COMMON
syn keyword xsMacro _XPV_HEAD __Inc__IPerl___ __PATCHLEVEL_H_INCLUDED__
syn keyword xsMacro __STDIO_LOADED __attribute__deprecated__
syn keyword xsMacro __attribute__format__ __attribute__format__null_ok__
syn keyword xsMacro __attribute__malloc__ __attribute__nonnull__
syn keyword xsMacro __attribute__noreturn__ __attribute__pure__
syn keyword xsMacro __attribute__unused__ __attribute__warn_unused_result__
syn keyword xsMacro __filbuf __flsbuf __perlapi_h__ _config_h_ _exit _filbuf
syn keyword xsMacro _flsbuf _isQUOTEMETA _stdopen _swab_16_ _swab_32_
syn keyword xsMacro _swab_64_ aTHXo aTHXo_ aTHXx aTHXx_ abort accept access
syn keyword xsMacro anchored_end_shift anchored_offset anchored_substr
syn keyword xsMacro anchored_utf8 asctime assert assert_not_ROK
syn keyword xsMacro assert_not_glob atoll bcmp bind blk_eval blk_format
syn keyword xsMacro blk_gimme blk_givwhen blk_loop blk_oldcop blk_oldmarksp
syn keyword xsMacro blk_oldpm blk_oldscopesp blk_oldsp blk_sub blk_u16 boolSV
syn keyword xsMacro cBINOP cBINOPo cBINOPx cBOOL cCOP cCOPo cCOPx cGVOP_gv
syn keyword xsMacro cGVOPo_gv cGVOPx_gv cLISTOP cLISTOPo cLISTOPx cLOGOP
syn keyword xsMacro cLOGOPo cLOGOPx cLOOP cLOOPo cLOOPx cPADOP cPADOPo
syn keyword xsMacro cPADOPx cPMOP cPMOPo cPMOPx cPVOP cPVOPo cPVOPx cSVOP
syn keyword xsMacro cSVOP_sv cSVOPo cSVOPo_sv cSVOPx cSVOPx_sv cSVOPx_svp
syn keyword xsMacro cUNOP cUNOPo cUNOPx chdir check_end_shift
syn keyword xsMacro check_offset_max check_offset_min check_substr check_utf8
syn keyword xsMacro child_offset_bits chmod chsize ckDEAD ckWARN ckWARN2
syn keyword xsMacro ckWARN2_d ckWARN3 ckWARN3_d ckWARN4 ckWARN4_d ckWARN_d
syn keyword xsMacro close closedir connect cop_hints_2hv cop_hints_fetch_pv
syn keyword xsMacro cop_hints_fetch_pvn cop_hints_fetch_pvs
syn keyword xsMacro cop_hints_fetch_sv cophh_2hv cophh_copy cophh_delete_pv
syn keyword xsMacro cophh_delete_pvn cophh_delete_pvs cophh_delete_sv
syn keyword xsMacro cophh_fetch_pv cophh_fetch_pvn cophh_fetch_pvs
syn keyword xsMacro cophh_fetch_sv cophh_free cophh_new_empty cophh_store_pv
syn keyword xsMacro cophh_store_pvn cophh_store_pvs cophh_store_sv crypt
syn keyword xsMacro ctermid ctime cv_ckproto cx_type cxstack cxstack_ix
syn keyword xsMacro cxstack_max dATARGET dAX dAXMARK dEXT dEXTCONST dITEMS
syn keyword xsMacro dJMPENV dMARK dMULTICALL dMY_CXT dMY_CXT_INTERP
syn keyword xsMacro dMY_CXT_SV dNOOP dORIGMARK dPOPPOPiirl dPOPPOPnnrl
syn keyword xsMacro dPOPPOPssrl dPOPTOPiirl dPOPTOPiirl_nomg
syn keyword xsMacro dPOPTOPiirl_ul_nomg dPOPTOPnnrl dPOPTOPnnrl_nomg
syn keyword xsMacro dPOPTOPssrl dPOPXiirl dPOPXiirl_ul_nomg dPOPXnnrl
syn keyword xsMacro dPOPXssrl dPOPiv dPOPnv dPOPnv_nomg dPOPqv dPOPss dPOPuqv
syn keyword xsMacro dPOPuv dSAVEDERRNO dSAVE_ERRNO dSP dTARG dTARGET
syn keyword xsMacro dTARGETSTACKED dTHR dTHX dTHXa dTHXo dTHXoa dTHXs dTHXx
syn keyword xsMacro dTOPiv dTOPnv dTOPqv dTOPss dTOPuqv dTOPuv dUNDERBAR dVAR
syn keyword xsMacro dXSARGS dXSFUNCTION dXSI32 dXSTARG dXSUB_SYS deprecate
syn keyword xsMacro djSP do_open drand48 dup dup2 endgrent endhostent
syn keyword xsMacro endnetent endprotoent endpwent endservent environ execl
syn keyword xsMacro execv execvp fcntl fd_set fdopen fileno float_end_shift
syn keyword xsMacro float_max_offset float_min_offset float_substr float_utf8
syn keyword xsMacro flock flockfile foldEQ_utf8 frewind fscanf fstat ftell
syn keyword xsMacro ftruncate ftrylockfile funlockfile fwrite1 generic_uni
syn keyword xsMacro generic_utf8 get_cvs getc_unlocked getegid geteuid getgid
syn keyword xsMacro getgrent getgrgid getgrnam gethostbyaddr gethostbyname
syn keyword xsMacro gethostent gethostname getlogin getnetbyaddr getnetbyname
syn keyword xsMacro getnetent getpeername getpid getprotobyname
syn keyword xsMacro getprotobynumber getprotoent getpwent getpwnam getpwuid
syn keyword xsMacro getservbyname getservbyport getservent getsockname
syn keyword xsMacro getsockopt getspnam gettimeofday getuid getw gv_AVadd
syn keyword xsMacro gv_HVadd gv_IOadd gv_SVadd gv_autoload4 gv_efullname3
syn keyword xsMacro gv_fetchmeth gv_fetchmeth_autoload gv_fetchmethod
syn keyword xsMacro gv_fetchmethod_flags gv_fetchpvn gv_fetchpvs
syn keyword xsMacro gv_fetchsv_nomg gv_fullname3 gv_init gv_stashpvs htoni
syn keyword xsMacro htonl htons htovl htovs hv_delete hv_delete_ent hv_exists
syn keyword xsMacro hv_exists_ent hv_fetch hv_fetch_ent hv_fetchs hv_iternext
syn keyword xsMacro hv_magic hv_store hv_store_ent hv_store_flags hv_stores
syn keyword xsMacro hv_undef ibcmp ibcmp_locale ibcmp_utf8 inet_addr
syn keyword xsMacro inet_ntoa init_os_extras init_thread_intern ioctl isALNUM
syn keyword xsMacro isALNUMC isALNUMC_A isALNUMC_L1 isALNUMC_LC
syn keyword xsMacro isALNUMC_LC_utf8 isALNUMU isALNUM_LC isALNUM_LC_utf8
syn keyword xsMacro isALNUM_LC_uvchr isALNUM_lazy isALNUM_lazy_if isALNUM_uni
syn keyword xsMacro isALNUM_utf8 isALPHA isALPHAU isALPHA_A isALPHA_L1
syn keyword xsMacro isALPHA_LC isALPHA_LC_utf8 isALPHA_LC_uvchr isALPHA_uni
syn keyword xsMacro isALPHA_utf8 isASCII isASCII_A isASCII_L1 isASCII_LC
syn keyword xsMacro isASCII_uni isASCII_utf8 isBLANK isBLANK_A isBLANK_L1
syn keyword xsMacro isBLANK_LC isBLANK_LC_uni isBLANK_LC_utf8 isBLANK_uni
syn keyword xsMacro isBLANK_utf8 isCHARNAME_CONT isCNTRL isCNTRL_A isCNTRL_L1
syn keyword xsMacro isCNTRL_LC isCNTRL_LC_utf8 isCNTRL_LC_uvchr isCNTRL_uni
syn keyword xsMacro isCNTRL_utf8 isDIGIT isDIGIT_A isDIGIT_L1 isDIGIT_LC
syn keyword xsMacro isDIGIT_LC_utf8 isDIGIT_LC_uvchr isDIGIT_uni isDIGIT_utf8
syn keyword xsMacro isGRAPH isGRAPH_A isGRAPH_L1 isGRAPH_LC isGRAPH_LC_utf8
syn keyword xsMacro isGRAPH_LC_uvchr isGRAPH_uni isGRAPH_utf8 isGV
syn keyword xsMacro isGV_with_GP isGV_with_GP_off isGV_with_GP_on
syn keyword xsMacro isIDCONT_utf8 isIDFIRST isIDFIRST_A isIDFIRST_L1
syn keyword xsMacro isIDFIRST_LC isIDFIRST_LC_utf8 isIDFIRST_LC_uvchr
syn keyword xsMacro isIDFIRST_lazy isIDFIRST_lazy_if isIDFIRST_uni
syn keyword xsMacro isIDFIRST_utf8 isLEXWARN_off isLEXWARN_on isLOWER
syn keyword xsMacro isLOWER_A isLOWER_L1 isLOWER_LC isLOWER_LC_utf8
syn keyword xsMacro isLOWER_LC_uvchr isLOWER_uni isLOWER_utf8 isOCTAL
syn keyword xsMacro isOCTAL_A isOCTAL_L1 isPRINT isPRINT_A isPRINT_L1
syn keyword xsMacro isPRINT_LC isPRINT_LC_utf8 isPRINT_LC_uvchr isPRINT_uni
syn keyword xsMacro isPRINT_utf8 isPSXSPC isPSXSPC_A isPSXSPC_L1 isPSXSPC_LC
syn keyword xsMacro isPSXSPC_LC_uni isPSXSPC_LC_utf8 isPSXSPC_uni
syn keyword xsMacro isPSXSPC_utf8 isPUNCT isPUNCT_A isPUNCT_L1 isPUNCT_LC
syn keyword xsMacro isPUNCT_LC_utf8 isPUNCT_LC_uvchr isPUNCT_uni isPUNCT_utf8
syn keyword xsMacro isSPACE isSPACE_A isSPACE_L1 isSPACE_LC isSPACE_LC_utf8
syn keyword xsMacro isSPACE_LC_uvchr isSPACE_uni isSPACE_utf8 isUPPER
syn keyword xsMacro isUPPER_A isUPPER_L1 isUPPER_LC isUPPER_LC_utf8
syn keyword xsMacro isUPPER_LC_uvchr isUPPER_uni isUPPER_utf8 isWARN_ONCE
syn keyword xsMacro isWARN_on isWARNf_on isWORDCHAR isWORDCHAR_A
syn keyword xsMacro isWORDCHAR_L1 isXDIGIT isXDIGIT_A isXDIGIT_L1
syn keyword xsMacro isXDIGIT_uni isXDIGIT_utf8 is_HORIZWS is_HORIZWS_cp
syn keyword xsMacro is_HORIZWS_latin1 is_HORIZWS_latin1_safe is_HORIZWS_safe
syn keyword xsMacro is_HORIZWS_utf8 is_HORIZWS_utf8_safe is_LAX_VERSION
syn keyword xsMacro is_LNBREAK is_LNBREAK_latin1 is_LNBREAK_latin1_safe
syn keyword xsMacro is_LNBREAK_safe is_LNBREAK_utf8 is_LNBREAK_utf8_safe
syn keyword xsMacro is_STRICT_VERSION is_TRICKYFOLD is_TRICKYFOLD_cp
syn keyword xsMacro is_TRICKYFOLD_safe is_VERTWS is_VERTWS_cp
syn keyword xsMacro is_VERTWS_latin1 is_VERTWS_latin1_safe is_VERTWS_safe
syn keyword xsMacro is_VERTWS_utf8 is_VERTWS_utf8_safe is_utf8_string_loc
syn keyword xsMacro isatty kBINOP kCOP kGVOP_gv kLISTOP kLOGOP kLOOP kPADOP
syn keyword xsMacro kPMOP kPVOP kSVOP kSVOP_sv kUNOP kill killpg
syn keyword xsMacro lex_stuff_pvs link listen lockf longjmp lseek lstat
syn keyword xsMacro mPUSHi mPUSHn mPUSHp mPUSHs mPUSHu mXPUSHi mXPUSHn
syn keyword xsMacro mXPUSHp mXPUSHs mXPUSHu memEQ memEQs memNE memNEs memchr
syn keyword xsMacro memcmp memzero mkdir mktemp my my_betoh16 my_betoh32
syn keyword xsMacro my_betoh64 my_betohi my_betohl my_betohn my_betohs
syn keyword xsMacro my_binmode my_htobe16 my_htobe32 my_htobe64 my_htobei
syn keyword xsMacro my_htobel my_htoben my_htobes my_htole16 my_htole32
syn keyword xsMacro my_htole64 my_htolei my_htolel my_htolen my_htoles
syn keyword xsMacro my_letoh16 my_letoh32 my_letoh64 my_letohi my_letohl
syn keyword xsMacro my_letohn my_letohs my_lstat my_snprintf my_sprintf
syn keyword xsMacro my_stat my_strlcat my_strlcpy my_vsnprintf newAV newGVgen
syn keyword xsMacro newHV newIO newRV_inc newSUB newSVpvn_utf8 newSVpvs
syn keyword xsMacro newSVpvs_flags newSVpvs_share newXSproto ntohi ntohl
syn keyword xsMacro ntohs opASSIGN op_getmad op_lvalue open opendir pTHX_1
syn keyword xsMacro pTHX_2 pTHX_3 pTHX_4 pTHX_5 pTHX_6 pTHX_7 pTHX_8 pTHX_9
syn keyword xsMacro pTHX_FORMAT pTHX_VALUE pTHX_VALUE_ pTHX__FORMAT
syn keyword xsMacro pTHX__VALUE pTHX__VALUE_ pTHXo pTHXo_ pTHXx pTHXx_ pVAR
syn keyword xsMacro pWARN_ALL pWARN_NONE pWARN_STD packWARN packWARN2
syn keyword xsMacro packWARN3 packWARN4 pad_add_name_pvs pad_findmy_pvs
syn keyword xsMacro pad_peg padadd_NO_DUP_CHECK padadd_OUR padadd_STATE
syn keyword xsMacro padadd_UTF8_NAME padnew_CLONE padnew_SAVE padnew_SAVESUB
syn keyword xsMacro panic_write2 pause pclose pipe popen prepare_SV_for_RV
syn keyword xsMacro pthread_attr_init pthread_condattr_default pthread_create
syn keyword xsMacro pthread_key_create pthread_keycreate
syn keyword xsMacro pthread_mutexattr_default pthread_mutexattr_init
syn keyword xsMacro pthread_mutexattr_settype putc_unlocked putenv putw
syn keyword xsMacro random read readdir readdir64 recv recvfrom ref
syn keyword xsMacro refcounted_he_fetch_pvs refcounted_he_new_pvs rename
syn keyword xsMacro rewinddir rmdir sTHX safecalloc safefree safemalloc
syn keyword xsMacro saferealloc save_aelem save_freeop save_freepv
syn keyword xsMacro save_freesv save_helem save_mortalizesv save_op savepvs
syn keyword xsMacro savesharedpvs sb_dstr sb_iters sb_m sb_maxiters
syn keyword xsMacro sb_oldsave sb_orig sb_rflags sb_rx sb_rxres sb_rxtainted
syn keyword xsMacro sb_s sb_strend sb_targ seedDrand01 seekdir select send
syn keyword xsMacro sendto setbuf setgid setgrent sethostent setjmp
syn keyword xsMacro setlinebuf setlocale setmode setnetent setprotoent
syn keyword xsMacro setpwent setregid setreuid setservent setsockopt setuid
syn keyword xsMacro setvbuf share_hek_hek sharepvn shutdown signal sleep
syn keyword xsMacro socket socketpair specialWARN srand48 srandom stat
syn keyword xsMacro stdoutf strEQ strGE strGT strLE strLT strNE strchr
syn keyword xsMacro strerror stringify stringify_immed strnEQ strnNE strrchr
syn keyword xsMacro strtoll strtoull sv_2bool sv_2iv sv_2nv sv_2pv
syn keyword xsMacro sv_2pv_nolen sv_2pv_nomg sv_2pvbyte_nolen
syn keyword xsMacro sv_2pvutf8_nolen sv_2uv sv_catpv_nomg sv_catpvn
syn keyword xsMacro sv_catpvn_mg sv_catpvn_nomg sv_catpvn_utf8_upgrade
syn keyword xsMacro sv_catpvs sv_catpvs_flags sv_catpvs_mg sv_catpvs_nomg
syn keyword xsMacro sv_catsv sv_catsv_mg sv_catsv_nomg sv_catxmlpvs sv_cmp
syn keyword xsMacro sv_cmp_locale sv_collxfrm sv_eq sv_force_normal sv_insert
syn keyword xsMacro sv_nolocking sv_nounlocking sv_pv sv_pvbyte sv_pvn_force
syn keyword xsMacro sv_pvn_force_nomg sv_pvutf8 sv_setpvs sv_setpvs_mg
syn keyword xsMacro sv_setref_pvs sv_setsv sv_setsv_nomg sv_taint sv_unref
syn keyword xsMacro sv_usepvn sv_usepvn_mg sv_utf8_upgrade
syn keyword xsMacro sv_utf8_upgrade_flags sv_utf8_upgrade_nomg tTHX telldir
syn keyword xsMacro times tmpfile tmpnam toCTRL toFOLD_uni toLOWER
syn keyword xsMacro toLOWER_LATIN1 toLOWER_LC toLOWER_uni toLOWER_utf8
syn keyword xsMacro toTITLE_uni toTITLE_utf8 toUPPER toUPPER_LATIN1_MOD
syn keyword xsMacro toUPPER_LC toUPPER_uni toUPPER_utf8 to_uni_fold
syn keyword xsMacro to_utf8_fold to_utf8_lower to_utf8_title to_utf8_upper
syn keyword xsMacro truncate tryAMAGICbin_MG tryAMAGICunDEREF
syn keyword xsMacro tryAMAGICunTARGET tryAMAGICun_MG ttyname umask uname
syn keyword xsMacro unlink unpackWARN1 unpackWARN2 unpackWARN3 unpackWARN4
syn keyword xsMacro utf8n_to_uvchr utime uvchr_to_utf8 uvuni_to_utf8 vTHX
syn keyword xsMacro vfprintf vtohl vtohs wait want_vtbl_bm want_vtbl_fm
syn keyword xsMacro what_TRICKYFOLD what_TRICKYFOLD_safe what_len_TRICKYFOLD
syn keyword xsMacro what_len_TRICKYFOLD_safe whichsig write xio_any xio_dirp
syn keyword xsMacro xiv_iv xuv_uv yystype

" Define the default highlighting.
" For version 5.7 and earlier: only when not done already
" For version 5.8 and later: only when an item doesn't have highlighting yet
if version >= 508 || !exists("did_xs_syntax_inits")
  if version < 508
    let did_xs_syntax_inits = 1
    command -nargs=+ HiLink hi link <args>
  else
    command -nargs=+ HiLink hi def link <args>
  endif

  HiLink xsPrivate    Error
  HiLink xsSuperseded Error
  HiLink xsType       Type
  HiLink xsString     String
  HiLink xsConstant   Constant
  HiLink xsException  Exception
  HiLink xsKeyword    Keyword
  HiLink xsFunction   Function
  HiLink xsVariable   Identifier
  HiLink xsMacro      Macro

  delcommand HiLink
endif

let b:current_syntax = "xs"

" vim: ts=8
