/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sun Oct 29 08:17:48 EDT 2017 */

#include "rdft/codelet-rdft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_r2cf.native -fma -compact -variables 4 -pipeline-latency 4 -n 128 -name r2cf_128 -include rdft/scalar/r2cf.h */

/*
 * This function contains 956 FP additions, 516 FP multiplications,
 * (or, 440 additions, 0 multiplications, 516 fused multiply/add),
 * 186 stack variables, 31 constants, and 256 memory accesses
 */
#include "rdft/scalar/r2cf.h"

static void r2cf_128(R *R0, R *R1, R *Cr, R *Ci, stride rs, stride csr, stride csi, INT v, INT ivs, INT ovs)
{
     DK(KP803207531, +0.803207531480644909806676512963141923879569427);
     DK(KP989176509, +0.989176509964780973451673738016243063983689533);
     DK(KP741650546, +0.741650546272035369581266691172079863842265220);
     DK(KP148335987, +0.148335987538347428753676511486911367000625355);
     DK(KP740951125, +0.740951125354959091175616897495162729728955309);
     DK(KP998795456, +0.998795456205172392714771604759100694443203615);
     DK(KP906347169, +0.906347169019147157946142717268914412664134293);
     DK(KP049126849, +0.049126849769467254105343321271313617079695752);
     DK(KP970031253, +0.970031253194543992603984207286100251456865962);
     DK(KP857728610, +0.857728610000272069902269984284770137042490799);
     DK(KP250486960, +0.250486960191305461595702160124721208578685568);
     DK(KP599376933, +0.599376933681923766271389869014404232837890546);
     DK(KP941544065, +0.941544065183020778412509402599502357185589796);
     DK(KP903989293, +0.903989293123443331586200297230537048710132025);
     DK(KP357805721, +0.357805721314524104672487743774474392487532769);
     DK(KP472964775, +0.472964775891319928124438237972992463904131113);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  for (i = v; i > 0; i = i - 1, R0 = R0 + ivs, R1 = R1 + ivs, Cr = Cr + ovs, Ci = Ci + ovs, MAKE_VOLATILE_STRIDE(512, rs), MAKE_VOLATILE_STRIDE(512, csr), MAKE_VOLATILE_STRIDE(512, csi)) {
	       E TcD, TdR, T27, T7r, T5P, T8v, Tf, Ta5, Tu, Tbn, TcG, TdS, T2e, T8w, T5S;
	       E T7s, TK, Ta6, TcK, TdU, T2o, T5U, T7w, T8y, TZ, Ta7, TcN, TdV, T2x, T5V;
	       E T7z, T8z, T1g, Taa, TcU, Tex, TcX, Tew, T1v, Tab, T2M, T6A, T7E, T9b, T7H;
	       E T9a, T2T, T6z, T4X, T6L, Tdz, TeL, TdK, TeO, T5G, T6O, T8d, T9p, TaV, Tc3;
	       E Tbi, Tc4, T8o, T9s, T3I, T6E, Tde, TeE, Tdp, TeH, T4r, T6H, T7U, T9i, Tao;
	       E TbW, TaL, TbX, T85, T9l, T1L, Tad, Td3, TeA, Td6, Tez, T20, Tae, T37, T6x;
	       E T7L, T9e, T7O, T9d, T3e, T6w, TbZ, Tc0, T3Z, T4s, Tds, TeF, T4g, T4t, T80;
	       E T87, Tdl, TeI, T7X, T86, TaD, TaM, Tc6, Tc7, T5e, T5H, TdN, TeM, T5v, T5I;
	       E T8j, T8q, TdG, TeP, T8g, T8p, Tba, Tbj;
	       {
		    E T3, T23, Td, T25, T6, T5N, Ta, T24;
		    {
			 E T1, T2, Tb, Tc;
			 T1 = R0[0];
			 T2 = R0[WS(rs, 32)];
			 T3 = T1 + T2;
			 T23 = T1 - T2;
			 Tb = R0[WS(rs, 56)];
			 Tc = R0[WS(rs, 24)];
			 Td = Tb + Tc;
			 T25 = Tb - Tc;
		    }
		    {
			 E T4, T5, T8, T9;
			 T4 = R0[WS(rs, 16)];
			 T5 = R0[WS(rs, 48)];
			 T6 = T4 + T5;
			 T5N = T4 - T5;
			 T8 = R0[WS(rs, 8)];
			 T9 = R0[WS(rs, 40)];
			 Ta = T8 + T9;
			 T24 = T8 - T9;
		    }
		    TcD = T3 - T6;
		    TdR = Td - Ta;
		    {
			 E T26, T5O, T7, Te;
			 T26 = T24 + T25;
			 T27 = FMA(KP707106781, T26, T23);
			 T7r = FNMS(KP707106781, T26, T23);
			 T5O = T25 - T24;
			 T5P = FNMS(KP707106781, T5O, T5N);
			 T8v = FMA(KP707106781, T5O, T5N);
			 T7 = T3 + T6;
			 Te = Ta + Td;
			 Tf = T7 + Te;
			 Ta5 = T7 - Te;
		    }
	       }
	       {
		    E Ti, T28, Ts, T2c, Tl, T29, Tp, T2b;
		    {
			 E Tg, Th, Tq, Tr;
			 Tg = R0[WS(rs, 4)];
			 Th = R0[WS(rs, 36)];
			 Ti = Tg + Th;
			 T28 = Tg - Th;
			 Tq = R0[WS(rs, 12)];
			 Tr = R0[WS(rs, 44)];
			 Ts = Tq + Tr;
			 T2c = Tq - Tr;
		    }
		    {
			 E Tj, Tk, Tn, To;
			 Tj = R0[WS(rs, 20)];
			 Tk = R0[WS(rs, 52)];
			 Tl = Tj + Tk;
			 T29 = Tj - Tk;
			 Tn = R0[WS(rs, 60)];
			 To = R0[WS(rs, 28)];
			 Tp = Tn + To;
			 T2b = Tn - To;
		    }
		    {
			 E Tm, Tt, TcE, TcF;
			 Tm = Ti + Tl;
			 Tt = Tp + Ts;
			 Tu = Tm + Tt;
			 Tbn = Tt - Tm;
			 TcE = Ti - Tl;
			 TcF = Tp - Ts;
			 TcG = TcE + TcF;
			 TdS = TcF - TcE;
		    }
		    {
			 E T2a, T2d, T5Q, T5R;
			 T2a = FNMS(KP414213562, T29, T28);
			 T2d = FMA(KP414213562, T2c, T2b);
			 T2e = T2a + T2d;
			 T8w = T2d - T2a;
			 T5Q = FMA(KP414213562, T28, T29);
			 T5R = FNMS(KP414213562, T2b, T2c);
			 T5S = T5Q + T5R;
			 T7s = T5Q - T5R;
		    }
	       }
	       {
		    E Ty, T2g, TB, T2l, TF, T2m, TI, T2j;
		    {
			 E Tw, Tx, Tz, TA;
			 Tw = R0[WS(rs, 2)];
			 Tx = R0[WS(rs, 34)];
			 Ty = Tw + Tx;
			 T2g = Tw - Tx;
			 Tz = R0[WS(rs, 18)];
			 TA = R0[WS(rs, 50)];
			 TB = Tz + TA;
			 T2l = Tz - TA;
			 {
			      E TD, TE, T2h, TG, TH, T2i;
			      TD = R0[WS(rs, 10)];
			      TE = R0[WS(rs, 42)];
			      T2h = TD - TE;
			      TG = R0[WS(rs, 58)];
			      TH = R0[WS(rs, 26)];
			      T2i = TG - TH;
			      TF = TD + TE;
			      T2m = T2h - T2i;
			      TI = TG + TH;
			      T2j = T2h + T2i;
			 }
		    }
		    {
			 E TC, TJ, TcI, TcJ;
			 TC = Ty + TB;
			 TJ = TF + TI;
			 TK = TC + TJ;
			 Ta6 = TC - TJ;
			 TcI = Ty - TB;
			 TcJ = TI - TF;
			 TcK = FMA(KP414213562, TcJ, TcI);
			 TdU = FNMS(KP414213562, TcI, TcJ);
		    }
		    {
			 E T2k, T2n, T7u, T7v;
			 T2k = FMA(KP707106781, T2j, T2g);
			 T2n = FMA(KP707106781, T2m, T2l);
			 T2o = FNMS(KP198912367, T2n, T2k);
			 T5U = FMA(KP198912367, T2k, T2n);
			 T7u = FNMS(KP707106781, T2j, T2g);
			 T7v = FNMS(KP707106781, T2m, T2l);
			 T7w = FMA(KP668178637, T7v, T7u);
			 T8y = FNMS(KP668178637, T7u, T7v);
		    }
	       }
	       {
		    E TN, T2p, TQ, T2u, TU, T2v, TX, T2s;
		    {
			 E TL, TM, TO, TP;
			 TL = R0[WS(rs, 62)];
			 TM = R0[WS(rs, 30)];
			 TN = TL + TM;
			 T2p = TL - TM;
			 TO = R0[WS(rs, 14)];
			 TP = R0[WS(rs, 46)];
			 TQ = TO + TP;
			 T2u = TO - TP;
			 {
			      E TS, TT, T2q, TV, TW, T2r;
			      TS = R0[WS(rs, 6)];
			      TT = R0[WS(rs, 38)];
			      T2q = TS - TT;
			      TV = R0[WS(rs, 54)];
			      TW = R0[WS(rs, 22)];
			      T2r = TV - TW;
			      TU = TS + TT;
			      T2v = T2q - T2r;
			      TX = TV + TW;
			      T2s = T2q + T2r;
			 }
		    }
		    {
			 E TR, TY, TcL, TcM;
			 TR = TN + TQ;
			 TY = TU + TX;
			 TZ = TR + TY;
			 Ta7 = TR - TY;
			 TcL = TN - TQ;
			 TcM = TX - TU;
			 TcN = FNMS(KP414213562, TcM, TcL);
			 TdV = FMA(KP414213562, TcL, TcM);
		    }
		    {
			 E T2t, T2w, T7x, T7y;
			 T2t = FMA(KP707106781, T2s, T2p);
			 T2w = FMA(KP707106781, T2v, T2u);
			 T2x = FMA(KP198912367, T2w, T2t);
			 T5V = FNMS(KP198912367, T2t, T2w);
			 T7x = FNMS(KP707106781, T2s, T2p);
			 T7y = FNMS(KP707106781, T2v, T2u);
			 T7z = FNMS(KP668178637, T7y, T7x);
			 T8z = FMA(KP668178637, T7x, T7y);
		    }
	       }
	       {
		    E T14, T2A, T17, T2N, T1b, T2O, T1e, T2D, T1j, T1m, T2H, TcR, T2Q, T1q, T1t;
		    E T2K, TcS, T2R;
		    {
			 E T12, T13, T15, T16;
			 T12 = R0[WS(rs, 1)];
			 T13 = R0[WS(rs, 33)];
			 T14 = T12 + T13;
			 T2A = T12 - T13;
			 T15 = R0[WS(rs, 17)];
			 T16 = R0[WS(rs, 49)];
			 T17 = T15 + T16;
			 T2N = T15 - T16;
		    }
		    {
			 E T19, T1a, T2B, T1c, T1d, T2C;
			 T19 = R0[WS(rs, 9)];
			 T1a = R0[WS(rs, 41)];
			 T2B = T19 - T1a;
			 T1c = R0[WS(rs, 57)];
			 T1d = R0[WS(rs, 25)];
			 T2C = T1c - T1d;
			 T1b = T19 + T1a;
			 T2O = T2B - T2C;
			 T1e = T1c + T1d;
			 T2D = T2B + T2C;
		    }
		    {
			 E T2F, T2G, T2I, T2J;
			 {
			      E T1h, T1i, T1k, T1l;
			      T1h = R0[WS(rs, 5)];
			      T1i = R0[WS(rs, 37)];
			      T1j = T1h + T1i;
			      T2F = T1h - T1i;
			      T1k = R0[WS(rs, 21)];
			      T1l = R0[WS(rs, 53)];
			      T1m = T1k + T1l;
			      T2G = T1k - T1l;
			 }
			 T2H = FNMS(KP414213562, T2G, T2F);
			 TcR = T1j - T1m;
			 T2Q = FMA(KP414213562, T2F, T2G);
			 {
			      E T1o, T1p, T1r, T1s;
			      T1o = R0[WS(rs, 61)];
			      T1p = R0[WS(rs, 29)];
			      T1q = T1o + T1p;
			      T2I = T1o - T1p;
			      T1r = R0[WS(rs, 13)];
			      T1s = R0[WS(rs, 45)];
			      T1t = T1r + T1s;
			      T2J = T1r - T1s;
			 }
			 T2K = FMA(KP414213562, T2J, T2I);
			 TcS = T1q - T1t;
			 T2R = FNMS(KP414213562, T2I, T2J);
		    }
		    {
			 E T18, T1f, TcQ, TcT;
			 T18 = T14 + T17;
			 T1f = T1b + T1e;
			 T1g = T18 + T1f;
			 Taa = T18 - T1f;
			 TcQ = T14 - T17;
			 TcT = TcR + TcS;
			 TcU = FMA(KP707106781, TcT, TcQ);
			 Tex = FNMS(KP707106781, TcT, TcQ);
		    }
		    {
			 E TcV, TcW, T1n, T1u;
			 TcV = T1e - T1b;
			 TcW = TcS - TcR;
			 TcX = FMA(KP707106781, TcW, TcV);
			 Tew = FNMS(KP707106781, TcW, TcV);
			 T1n = T1j + T1m;
			 T1u = T1q + T1t;
			 T1v = T1n + T1u;
			 Tab = T1u - T1n;
		    }
		    {
			 E T2E, T2L, T7C, T7D;
			 T2E = FMA(KP707106781, T2D, T2A);
			 T2L = T2H + T2K;
			 T2M = FMA(KP923879532, T2L, T2E);
			 T6A = FNMS(KP923879532, T2L, T2E);
			 T7C = FNMS(KP707106781, T2D, T2A);
			 T7D = T2Q - T2R;
			 T7E = FMA(KP923879532, T7D, T7C);
			 T9b = FNMS(KP923879532, T7D, T7C);
		    }
		    {
			 E T7F, T7G, T2P, T2S;
			 T7F = FNMS(KP707106781, T2O, T2N);
			 T7G = T2K - T2H;
			 T7H = FMA(KP923879532, T7G, T7F);
			 T9a = FNMS(KP923879532, T7G, T7F);
			 T2P = FMA(KP707106781, T2O, T2N);
			 T2S = T2Q + T2R;
			 T2T = FMA(KP923879532, T2S, T2P);
			 T6z = FNMS(KP923879532, T2S, T2P);
		    }
	       }
	       {
		    E T4z, TaP, T5A, TaQ, T4G, TaT, T5B, TaS, Tbf, Tbg, T4O, Tdw, T5D, Tbc, Tbd;
		    E T4V, Tdx, T5E;
		    {
			 E T4x, T4y, T5y, T5z;
			 T4x = R1[WS(rs, 63)];
			 T4y = R1[WS(rs, 31)];
			 T4z = T4x - T4y;
			 TaP = T4x + T4y;
			 T5y = R1[WS(rs, 47)];
			 T5z = R1[WS(rs, 15)];
			 T5A = T5y - T5z;
			 TaQ = T5z + T5y;
		    }
		    {
			 E T4A, T4B, T4C, T4D, T4E, T4F;
			 T4A = R1[WS(rs, 7)];
			 T4B = R1[WS(rs, 39)];
			 T4C = T4A - T4B;
			 T4D = R1[WS(rs, 55)];
			 T4E = R1[WS(rs, 23)];
			 T4F = T4D - T4E;
			 T4G = T4C + T4F;
			 TaT = T4D + T4E;
			 T5B = T4F - T4C;
			 TaS = T4A + T4B;
		    }
		    {
			 E T4K, T4N, T4R, T4U;
			 {
			      E T4I, T4J, T4L, T4M;
			      T4I = R1[WS(rs, 3)];
			      T4J = R1[WS(rs, 35)];
			      T4K = T4I - T4J;
			      Tbf = T4I + T4J;
			      T4L = R1[WS(rs, 51)];
			      T4M = R1[WS(rs, 19)];
			      T4N = T4L - T4M;
			      Tbg = T4M + T4L;
			 }
			 T4O = FMA(KP414213562, T4N, T4K);
			 Tdw = Tbf - Tbg;
			 T5D = FNMS(KP414213562, T4K, T4N);
			 {
			      E T4P, T4Q, T4S, T4T;
			      T4P = R1[WS(rs, 59)];
			      T4Q = R1[WS(rs, 27)];
			      T4R = T4P - T4Q;
			      Tbc = T4P + T4Q;
			      T4S = R1[WS(rs, 43)];
			      T4T = R1[WS(rs, 11)];
			      T4U = T4S - T4T;
			      Tbd = T4T + T4S;
			 }
			 T4V = FNMS(KP414213562, T4U, T4R);
			 Tdx = Tbc - Tbd;
			 T5E = FMA(KP414213562, T4R, T4U);
		    }
		    {
			 E T4H, T4W, Tdv, Tdy;
			 T4H = FMA(KP707106781, T4G, T4z);
			 T4W = T4O + T4V;
			 T4X = FMA(KP923879532, T4W, T4H);
			 T6L = FNMS(KP923879532, T4W, T4H);
			 Tdv = TaP - TaQ;
			 Tdy = Tdw + Tdx;
			 Tdz = FMA(KP707106781, Tdy, Tdv);
			 TeL = FNMS(KP707106781, Tdy, Tdv);
		    }
		    {
			 E TdI, TdJ, T5C, T5F;
			 TdI = TaT - TaS;
			 TdJ = Tdx - Tdw;
			 TdK = FMA(KP707106781, TdJ, TdI);
			 TeO = FNMS(KP707106781, TdJ, TdI);
			 T5C = FMA(KP707106781, T5B, T5A);
			 T5F = T5D + T5E;
			 T5G = FMA(KP923879532, T5F, T5C);
			 T6O = FNMS(KP923879532, T5F, T5C);
		    }
		    {
			 E T8b, T8c, TaR, TaU;
			 T8b = FNMS(KP707106781, T4G, T4z);
			 T8c = T5E - T5D;
			 T8d = FMA(KP923879532, T8c, T8b);
			 T9p = FNMS(KP923879532, T8c, T8b);
			 TaR = TaP + TaQ;
			 TaU = TaS + TaT;
			 TaV = TaR - TaU;
			 Tc3 = TaR + TaU;
		    }
		    {
			 E Tbe, Tbh, T8m, T8n;
			 Tbe = Tbc + Tbd;
			 Tbh = Tbf + Tbg;
			 Tbi = Tbe - Tbh;
			 Tc4 = Tbh + Tbe;
			 T8m = FNMS(KP707106781, T5B, T5A);
			 T8n = T4V - T4O;
			 T8o = FNMS(KP923879532, T8n, T8m);
			 T9s = FMA(KP923879532, T8n, T8m);
		    }
	       }
	       {
		    E T3k, Tai, T4l, Taj, T3r, Tam, T4m, Tal, TaI, TaJ, T3z, Tdb, T4o, TaF, TaG;
		    E T3G, Tdc, T4p;
		    {
			 E T3i, T3j, T4j, T4k;
			 T3i = R1[0];
			 T3j = R1[WS(rs, 32)];
			 T3k = T3i - T3j;
			 Tai = T3i + T3j;
			 T4j = R1[WS(rs, 16)];
			 T4k = R1[WS(rs, 48)];
			 T4l = T4j - T4k;
			 Taj = T4j + T4k;
		    }
		    {
			 E T3l, T3m, T3n, T3o, T3p, T3q;
			 T3l = R1[WS(rs, 8)];
			 T3m = R1[WS(rs, 40)];
			 T3n = T3l - T3m;
			 T3o = R1[WS(rs, 56)];
			 T3p = R1[WS(rs, 24)];
			 T3q = T3o - T3p;
			 T3r = T3n + T3q;
			 Tam = T3o + T3p;
			 T4m = T3n - T3q;
			 Tal = T3l + T3m;
		    }
		    {
			 E T3v, T3y, T3C, T3F;
			 {
			      E T3t, T3u, T3w, T3x;
			      T3t = R1[WS(rs, 4)];
			      T3u = R1[WS(rs, 36)];
			      T3v = T3t - T3u;
			      TaI = T3t + T3u;
			      T3w = R1[WS(rs, 20)];
			      T3x = R1[WS(rs, 52)];
			      T3y = T3w - T3x;
			      TaJ = T3w + T3x;
			 }
			 T3z = FNMS(KP414213562, T3y, T3v);
			 Tdb = TaI - TaJ;
			 T4o = FMA(KP414213562, T3v, T3y);
			 {
			      E T3A, T3B, T3D, T3E;
			      T3A = R1[WS(rs, 60)];
			      T3B = R1[WS(rs, 28)];
			      T3C = T3A - T3B;
			      TaF = T3A + T3B;
			      T3D = R1[WS(rs, 12)];
			      T3E = R1[WS(rs, 44)];
			      T3F = T3D - T3E;
			      TaG = T3D + T3E;
			 }
			 T3G = FMA(KP414213562, T3F, T3C);
			 Tdc = TaF - TaG;
			 T4p = FNMS(KP414213562, T3C, T3F);
		    }
		    {
			 E T3s, T3H, Tda, Tdd;
			 T3s = FMA(KP707106781, T3r, T3k);
			 T3H = T3z + T3G;
			 T3I = FMA(KP923879532, T3H, T3s);
			 T6E = FNMS(KP923879532, T3H, T3s);
			 Tda = Tai - Taj;
			 Tdd = Tdb + Tdc;
			 Tde = FMA(KP707106781, Tdd, Tda);
			 TeE = FNMS(KP707106781, Tdd, Tda);
		    }
		    {
			 E Tdn, Tdo, T4n, T4q;
			 Tdn = Tam - Tal;
			 Tdo = Tdc - Tdb;
			 Tdp = FMA(KP707106781, Tdo, Tdn);
			 TeH = FNMS(KP707106781, Tdo, Tdn);
			 T4n = FMA(KP707106781, T4m, T4l);
			 T4q = T4o + T4p;
			 T4r = FMA(KP923879532, T4q, T4n);
			 T6H = FNMS(KP923879532, T4q, T4n);
		    }
		    {
			 E T7S, T7T, Tak, Tan;
			 T7S = FNMS(KP707106781, T3r, T3k);
			 T7T = T4o - T4p;
			 T7U = FMA(KP923879532, T7T, T7S);
			 T9i = FNMS(KP923879532, T7T, T7S);
			 Tak = Tai + Taj;
			 Tan = Tal + Tam;
			 Tao = Tak - Tan;
			 TbW = Tak + Tan;
		    }
		    {
			 E TaH, TaK, T83, T84;
			 TaH = TaF + TaG;
			 TaK = TaI + TaJ;
			 TaL = TaH - TaK;
			 TbX = TaK + TaH;
			 T83 = FNMS(KP707106781, T4m, T4l);
			 T84 = T3G - T3z;
			 T85 = FMA(KP923879532, T84, T83);
			 T9l = FNMS(KP923879532, T84, T83);
		    }
	       }
	       {
		    E T1z, T2V, T1C, T38, T1G, T39, T1J, T2Y, T1O, T1R, T32, Td0, T3b, T1V, T1Y;
		    E T35, Td1, T3c;
		    {
			 E T1x, T1y, T1A, T1B;
			 T1x = R0[WS(rs, 63)];
			 T1y = R0[WS(rs, 31)];
			 T1z = T1x + T1y;
			 T2V = T1x - T1y;
			 T1A = R0[WS(rs, 15)];
			 T1B = R0[WS(rs, 47)];
			 T1C = T1A + T1B;
			 T38 = T1A - T1B;
		    }
		    {
			 E T1E, T1F, T2W, T1H, T1I, T2X;
			 T1E = R0[WS(rs, 7)];
			 T1F = R0[WS(rs, 39)];
			 T2W = T1E - T1F;
			 T1H = R0[WS(rs, 55)];
			 T1I = R0[WS(rs, 23)];
			 T2X = T1H - T1I;
			 T1G = T1E + T1F;
			 T39 = T2W - T2X;
			 T1J = T1H + T1I;
			 T2Y = T2W + T2X;
		    }
		    {
			 E T30, T31, T33, T34;
			 {
			      E T1M, T1N, T1P, T1Q;
			      T1M = R0[WS(rs, 3)];
			      T1N = R0[WS(rs, 35)];
			      T1O = T1M + T1N;
			      T30 = T1M - T1N;
			      T1P = R0[WS(rs, 19)];
			      T1Q = R0[WS(rs, 51)];
			      T1R = T1P + T1Q;
			      T31 = T1P - T1Q;
			 }
			 T32 = FNMS(KP414213562, T31, T30);
			 Td0 = T1O - T1R;
			 T3b = FMA(KP414213562, T30, T31);
			 {
			      E T1T, T1U, T1W, T1X;
			      T1T = R0[WS(rs, 59)];
			      T1U = R0[WS(rs, 27)];
			      T1V = T1T + T1U;
			      T33 = T1T - T1U;
			      T1W = R0[WS(rs, 11)];
			      T1X = R0[WS(rs, 43)];
			      T1Y = T1W + T1X;
			      T34 = T1W - T1X;
			 }
			 T35 = FMA(KP414213562, T34, T33);
			 Td1 = T1V - T1Y;
			 T3c = FNMS(KP414213562, T33, T34);
		    }
		    {
			 E T1D, T1K, TcZ, Td2;
			 T1D = T1z + T1C;
			 T1K = T1G + T1J;
			 T1L = T1D + T1K;
			 Tad = T1D - T1K;
			 TcZ = T1z - T1C;
			 Td2 = Td0 + Td1;
			 Td3 = FMA(KP707106781, Td2, TcZ);
			 TeA = FNMS(KP707106781, Td2, TcZ);
		    }
		    {
			 E Td4, Td5, T1S, T1Z;
			 Td4 = T1J - T1G;
			 Td5 = Td1 - Td0;
			 Td6 = FMA(KP707106781, Td5, Td4);
			 Tez = FNMS(KP707106781, Td5, Td4);
			 T1S = T1O + T1R;
			 T1Z = T1V + T1Y;
			 T20 = T1S + T1Z;
			 Tae = T1Z - T1S;
		    }
		    {
			 E T2Z, T36, T7J, T7K;
			 T2Z = FMA(KP707106781, T2Y, T2V);
			 T36 = T32 + T35;
			 T37 = FMA(KP923879532, T36, T2Z);
			 T6x = FNMS(KP923879532, T36, T2Z);
			 T7J = FNMS(KP707106781, T2Y, T2V);
			 T7K = T3b - T3c;
			 T7L = FMA(KP923879532, T7K, T7J);
			 T9e = FNMS(KP923879532, T7K, T7J);
		    }
		    {
			 E T7M, T7N, T3a, T3d;
			 T7M = FNMS(KP707106781, T39, T38);
			 T7N = T35 - T32;
			 T7O = FMA(KP923879532, T7N, T7M);
			 T9d = FNMS(KP923879532, T7N, T7M);
			 T3a = FMA(KP707106781, T39, T38);
			 T3d = T3b + T3c;
			 T3e = FMA(KP923879532, T3d, T3a);
			 T6w = FNMS(KP923879532, T3d, T3a);
		    }
	       }
	       {
		    E T3L, Tdf, T3W, Tar, T42, Tdi, T4d, Tay, T3S, Tdg, T3X, Tau, T49, Tdj, T4e;
		    E TaB, Tdh, Tdk;
		    {
			 E T3J, T3K, Tap, T3U, T3V, Taq;
			 T3J = R1[WS(rs, 2)];
			 T3K = R1[WS(rs, 34)];
			 Tap = T3J + T3K;
			 T3U = R1[WS(rs, 18)];
			 T3V = R1[WS(rs, 50)];
			 Taq = T3U + T3V;
			 T3L = T3J - T3K;
			 Tdf = Tap - Taq;
			 T3W = T3U - T3V;
			 Tar = Tap + Taq;
		    }
		    {
			 E T40, T41, Taw, T4b, T4c, Tax;
			 T40 = R1[WS(rs, 62)];
			 T41 = R1[WS(rs, 30)];
			 Taw = T40 + T41;
			 T4b = R1[WS(rs, 14)];
			 T4c = R1[WS(rs, 46)];
			 Tax = T4b + T4c;
			 T42 = T40 - T41;
			 Tdi = Taw - Tax;
			 T4d = T4b - T4c;
			 Tay = Taw + Tax;
		    }
		    {
			 E T3O, Tas, T3R, Tat;
			 {
			      E T3M, T3N, T3P, T3Q;
			      T3M = R1[WS(rs, 10)];
			      T3N = R1[WS(rs, 42)];
			      T3O = T3M - T3N;
			      Tas = T3M + T3N;
			      T3P = R1[WS(rs, 58)];
			      T3Q = R1[WS(rs, 26)];
			      T3R = T3P - T3Q;
			      Tat = T3P + T3Q;
			 }
			 T3S = T3O + T3R;
			 Tdg = Tat - Tas;
			 T3X = T3O - T3R;
			 Tau = Tas + Tat;
		    }
		    {
			 E T45, Taz, T48, TaA;
			 {
			      E T43, T44, T46, T47;
			      T43 = R1[WS(rs, 6)];
			      T44 = R1[WS(rs, 38)];
			      T45 = T43 - T44;
			      Taz = T43 + T44;
			      T46 = R1[WS(rs, 54)];
			      T47 = R1[WS(rs, 22)];
			      T48 = T46 - T47;
			      TaA = T46 + T47;
			 }
			 T49 = T45 + T48;
			 Tdj = TaA - Taz;
			 T4e = T45 - T48;
			 TaB = Taz + TaA;
		    }
		    TbZ = Tar + Tau;
		    Tc0 = Tay + TaB;
		    {
			 E T3T, T3Y, Tdq, Tdr;
			 T3T = FMA(KP707106781, T3S, T3L);
			 T3Y = FMA(KP707106781, T3X, T3W);
			 T3Z = FNMS(KP198912367, T3Y, T3T);
			 T4s = FMA(KP198912367, T3T, T3Y);
			 Tdq = FNMS(KP414213562, Tdf, Tdg);
			 Tdr = FMA(KP414213562, Tdi, Tdj);
			 Tds = Tdq + Tdr;
			 TeF = Tdr - Tdq;
		    }
		    {
			 E T4a, T4f, T7Y, T7Z;
			 T4a = FMA(KP707106781, T49, T42);
			 T4f = FMA(KP707106781, T4e, T4d);
			 T4g = FMA(KP198912367, T4f, T4a);
			 T4t = FNMS(KP198912367, T4a, T4f);
			 T7Y = FNMS(KP707106781, T49, T42);
			 T7Z = FNMS(KP707106781, T4e, T4d);
			 T80 = FNMS(KP668178637, T7Z, T7Y);
			 T87 = FMA(KP668178637, T7Y, T7Z);
		    }
		    Tdh = FMA(KP414213562, Tdg, Tdf);
		    Tdk = FNMS(KP414213562, Tdj, Tdi);
		    Tdl = Tdh + Tdk;
		    TeI = Tdh - Tdk;
		    {
			 E T7V, T7W, Tav, TaC;
			 T7V = FNMS(KP707106781, T3S, T3L);
			 T7W = FNMS(KP707106781, T3X, T3W);
			 T7X = FMA(KP668178637, T7W, T7V);
			 T86 = FNMS(KP668178637, T7V, T7W);
			 Tav = Tar - Tau;
			 TaC = Tay - TaB;
			 TaD = Tav + TaC;
			 TaM = TaC - Tav;
		    }
	       }
	       {
		    E T50, TdA, T5b, TaY, T5h, TdD, T5s, Tb5, T57, TdB, T5c, Tb1, T5o, TdE, T5t;
		    E Tb8, TdC, TdF;
		    {
			 E T4Y, T4Z, TaW, T59, T5a, TaX;
			 T4Y = R1[WS(rs, 1)];
			 T4Z = R1[WS(rs, 33)];
			 TaW = T4Y + T4Z;
			 T59 = R1[WS(rs, 49)];
			 T5a = R1[WS(rs, 17)];
			 TaX = T5a + T59;
			 T50 = T4Y - T4Z;
			 TdA = TaW - TaX;
			 T5b = T59 - T5a;
			 TaY = TaW + TaX;
		    }
		    {
			 E T5f, T5g, Tb3, T5q, T5r, Tb4;
			 T5f = R1[WS(rs, 61)];
			 T5g = R1[WS(rs, 29)];
			 Tb3 = T5f + T5g;
			 T5q = R1[WS(rs, 45)];
			 T5r = R1[WS(rs, 13)];
			 Tb4 = T5r + T5q;
			 T5h = T5f - T5g;
			 TdD = Tb3 - Tb4;
			 T5s = T5q - T5r;
			 Tb5 = Tb3 + Tb4;
		    }
		    {
			 E T53, TaZ, T56, Tb0;
			 {
			      E T51, T52, T54, T55;
			      T51 = R1[WS(rs, 9)];
			      T52 = R1[WS(rs, 41)];
			      T53 = T51 - T52;
			      TaZ = T51 + T52;
			      T54 = R1[WS(rs, 57)];
			      T55 = R1[WS(rs, 25)];
			      T56 = T54 - T55;
			      Tb0 = T54 + T55;
			 }
			 T57 = T53 + T56;
			 TdB = Tb0 - TaZ;
			 T5c = T56 - T53;
			 Tb1 = TaZ + Tb0;
		    }
		    {
			 E T5k, Tb6, T5n, Tb7;
			 {
			      E T5i, T5j, T5l, T5m;
			      T5i = R1[WS(rs, 5)];
			      T5j = R1[WS(rs, 37)];
			      T5k = T5i - T5j;
			      Tb6 = T5i + T5j;
			      T5l = R1[WS(rs, 53)];
			      T5m = R1[WS(rs, 21)];
			      T5n = T5l - T5m;
			      Tb7 = T5l + T5m;
			 }
			 T5o = T5k + T5n;
			 TdE = Tb7 - Tb6;
			 T5t = T5n - T5k;
			 Tb8 = Tb6 + Tb7;
		    }
		    Tc6 = TaY + Tb1;
		    Tc7 = Tb5 + Tb8;
		    {
			 E T58, T5d, TdL, TdM;
			 T58 = FMA(KP707106781, T57, T50);
			 T5d = FMA(KP707106781, T5c, T5b);
			 T5e = FMA(KP198912367, T5d, T58);
			 T5H = FNMS(KP198912367, T58, T5d);
			 TdL = FNMS(KP414213562, TdA, TdB);
			 TdM = FMA(KP414213562, TdD, TdE);
			 TdN = TdL + TdM;
			 TeM = TdM - TdL;
		    }
		    {
			 E T5p, T5u, T8h, T8i;
			 T5p = FMA(KP707106781, T5o, T5h);
			 T5u = FMA(KP707106781, T5t, T5s);
			 T5v = FNMS(KP198912367, T5u, T5p);
			 T5I = FMA(KP198912367, T5p, T5u);
			 T8h = FNMS(KP707106781, T5o, T5h);
			 T8i = FNMS(KP707106781, T5t, T5s);
			 T8j = FMA(KP668178637, T8i, T8h);
			 T8q = FNMS(KP668178637, T8h, T8i);
		    }
		    TdC = FMA(KP414213562, TdB, TdA);
		    TdF = FNMS(KP414213562, TdE, TdD);
		    TdG = TdC + TdF;
		    TeP = TdF - TdC;
		    {
			 E T8e, T8f, Tb2, Tb9;
			 T8e = FNMS(KP707106781, T57, T50);
			 T8f = FNMS(KP707106781, T5c, T5b);
			 T8g = FNMS(KP668178637, T8f, T8e);
			 T8p = FMA(KP668178637, T8e, T8f);
			 Tb2 = TaY - Tb1;
			 Tb9 = Tb5 - Tb8;
			 Tba = Tb2 + Tb9;
			 Tbj = Tb9 - Tb2;
		    }
	       }
	       {
		    E T11, TbV, Tc9, Tcf, T22, Tcb, Tc2, Tce;
		    {
			 E Tv, T10, Tc5, Tc8;
			 Tv = Tf + Tu;
			 T10 = TK + TZ;
			 T11 = Tv + T10;
			 TbV = Tv - T10;
			 Tc5 = Tc3 + Tc4;
			 Tc8 = Tc6 + Tc7;
			 Tc9 = Tc5 - Tc8;
			 Tcf = Tc5 + Tc8;
		    }
		    {
			 E T1w, T21, TbY, Tc1;
			 T1w = T1g + T1v;
			 T21 = T1L + T20;
			 T22 = T1w + T21;
			 Tcb = T21 - T1w;
			 TbY = TbW + TbX;
			 Tc1 = TbZ + Tc0;
			 Tc2 = TbY - Tc1;
			 Tce = TbY + Tc1;
		    }
		    Cr[WS(csr, 32)] = T11 - T22;
		    Ci[WS(csi, 32)] = Tcf - Tce;
		    {
			 E Tca, Tcc, Tcd, Tcg;
			 Tca = Tc2 + Tc9;
			 Cr[WS(csr, 48)] = FNMS(KP707106781, Tca, TbV);
			 Cr[WS(csr, 16)] = FMA(KP707106781, Tca, TbV);
			 Tcc = Tc9 - Tc2;
			 Ci[WS(csi, 16)] = FMA(KP707106781, Tcc, Tcb);
			 Ci[WS(csi, 48)] = FMS(KP707106781, Tcc, Tcb);
			 Tcd = T11 + T22;
			 Tcg = Tce + Tcf;
			 Cr[WS(csr, 64)] = Tcd - Tcg;
			 Cr[0] = Tcd + Tcg;
		    }
	       }
	       {
		    E Tch, Tct, Tck, Tcu, Tco, Tcy, Tcr, Tcz, Tci, Tcj;
		    Tch = Tf - Tu;
		    Tct = TZ - TK;
		    Tci = T1g - T1v;
		    Tcj = T1L - T20;
		    Tck = Tci + Tcj;
		    Tcu = Tcj - Tci;
		    {
			 E Tcm, Tcn, Tcp, Tcq;
			 Tcm = TbW - TbX;
			 Tcn = Tc0 - TbZ;
			 Tco = FMA(KP414213562, Tcn, Tcm);
			 Tcy = FNMS(KP414213562, Tcm, Tcn);
			 Tcp = Tc3 - Tc4;
			 Tcq = Tc7 - Tc6;
			 Tcr = FNMS(KP414213562, Tcq, Tcp);
			 Tcz = FMA(KP414213562, Tcp, Tcq);
		    }
		    {
			 E Tcl, Tcs, Tcx, TcA;
			 Tcl = FMA(KP707106781, Tck, Tch);
			 Tcs = Tco + Tcr;
			 Cr[WS(csr, 56)] = FNMS(KP923879532, Tcs, Tcl);
			 Cr[WS(csr, 8)] = FMA(KP923879532, Tcs, Tcl);
			 Tcx = FMA(KP707106781, Tcu, Tct);
			 TcA = Tcy + Tcz;
			 Ci[WS(csi, 8)] = FMA(KP923879532, TcA, Tcx);
			 Ci[WS(csi, 56)] = FMS(KP923879532, TcA, Tcx);
		    }
		    {
			 E Tcv, Tcw, TcB, TcC;
			 Tcv = FNMS(KP707106781, Tcu, Tct);
			 Tcw = Tcr - Tco;
			 Ci[WS(csi, 24)] = FMS(KP923879532, Tcw, Tcv);
			 Ci[WS(csi, 40)] = FMA(KP923879532, Tcw, Tcv);
			 TcB = FNMS(KP707106781, Tck, Tch);
			 TcC = Tcz - Tcy;
			 Cr[WS(csr, 40)] = FNMS(KP923879532, TcC, TcB);
			 Cr[WS(csr, 24)] = FMA(KP923879532, TcC, TcB);
		    }
	       }
	       {
		    E Ta9, TbB, Tbp, TbL, Tag, TbM, TbJ, TbR, TaO, Tbw, Tbs, TbC, TbG, TbQ, Tbl;
		    E Tbx, Ta8, Tbo;
		    Ta8 = Ta6 + Ta7;
		    Ta9 = FMA(KP707106781, Ta8, Ta5);
		    TbB = FNMS(KP707106781, Ta8, Ta5);
		    Tbo = Ta7 - Ta6;
		    Tbp = FMA(KP707106781, Tbo, Tbn);
		    TbL = FNMS(KP707106781, Tbo, Tbn);
		    {
			 E Tac, Taf, TbH, TbI;
			 Tac = FMA(KP414213562, Tab, Taa);
			 Taf = FNMS(KP414213562, Tae, Tad);
			 Tag = Tac + Taf;
			 TbM = Taf - Tac;
			 TbH = FNMS(KP707106781, Tba, TaV);
			 TbI = FNMS(KP707106781, Tbj, Tbi);
			 TbJ = FMA(KP668178637, TbI, TbH);
			 TbR = FNMS(KP668178637, TbH, TbI);
		    }
		    {
			 E TaE, TaN, Tbq, Tbr;
			 TaE = FMA(KP707106781, TaD, Tao);
			 TaN = FMA(KP707106781, TaM, TaL);
			 TaO = FMA(KP198912367, TaN, TaE);
			 Tbw = FNMS(KP198912367, TaE, TaN);
			 Tbq = FNMS(KP414213562, Taa, Tab);
			 Tbr = FMA(KP414213562, Tad, Tae);
			 Tbs = Tbq + Tbr;
			 TbC = Tbr - Tbq;
		    }
		    {
			 E TbE, TbF, Tbb, Tbk;
			 TbE = FNMS(KP707106781, TaD, Tao);
			 TbF = FNMS(KP707106781, TaM, TaL);
			 TbG = FNMS(KP668178637, TbF, TbE);
			 TbQ = FMA(KP668178637, TbE, TbF);
			 Tbb = FMA(KP707106781, Tba, TaV);
			 Tbk = FMA(KP707106781, Tbj, Tbi);
			 Tbl = FNMS(KP198912367, Tbk, Tbb);
			 Tbx = FMA(KP198912367, Tbb, Tbk);
		    }
		    {
			 E Tah, Tbm, Tbv, Tby;
			 Tah = FMA(KP923879532, Tag, Ta9);
			 Tbm = TaO + Tbl;
			 Cr[WS(csr, 60)] = FNMS(KP980785280, Tbm, Tah);
			 Cr[WS(csr, 4)] = FMA(KP980785280, Tbm, Tah);
			 Tbv = FMA(KP923879532, Tbs, Tbp);
			 Tby = Tbw + Tbx;
			 Ci[WS(csi, 4)] = FMA(KP980785280, Tby, Tbv);
			 Ci[WS(csi, 60)] = FMS(KP980785280, Tby, Tbv);
		    }
		    {
			 E Tbt, Tbu, Tbz, TbA;
			 Tbt = FNMS(KP923879532, Tbs, Tbp);
			 Tbu = Tbl - TaO;
			 Ci[WS(csi, 28)] = FMS(KP980785280, Tbu, Tbt);
			 Ci[WS(csi, 36)] = FMA(KP980785280, Tbu, Tbt);
			 Tbz = FNMS(KP923879532, Tag, Ta9);
			 TbA = Tbx - Tbw;
			 Cr[WS(csr, 36)] = FNMS(KP980785280, TbA, Tbz);
			 Cr[WS(csr, 28)] = FMA(KP980785280, TbA, Tbz);
		    }
		    {
			 E TbD, TbK, TbP, TbS;
			 TbD = FMA(KP923879532, TbC, TbB);
			 TbK = TbG + TbJ;
			 Cr[WS(csr, 52)] = FNMS(KP831469612, TbK, TbD);
			 Cr[WS(csr, 12)] = FMA(KP831469612, TbK, TbD);
			 TbP = FNMS(KP923879532, TbM, TbL);
			 TbS = TbQ + TbR;
			 Ci[WS(csi, 12)] = -(FMA(KP831469612, TbS, TbP));
			 Ci[WS(csi, 52)] = FNMS(KP831469612, TbS, TbP);
		    }
		    {
			 E TbN, TbO, TbT, TbU;
			 TbN = FMA(KP923879532, TbM, TbL);
			 TbO = TbJ - TbG;
			 Ci[WS(csi, 20)] = FMA(KP831469612, TbO, TbN);
			 Ci[WS(csi, 44)] = FMS(KP831469612, TbO, TbN);
			 TbT = FNMS(KP923879532, TbC, TbB);
			 TbU = TbQ - TbR;
			 Cr[WS(csr, 44)] = FNMS(KP831469612, TbU, TbT);
			 Cr[WS(csr, 20)] = FMA(KP831469612, TbU, TbT);
		    }
	       }
	       {
		    E Tev, Tf7, Tfc, Tfm, Tff, Tfn, TeC, Tfi, TeK, Tf2, TeV, Tfh, TeY, Tf8, TeR;
		    E Tf3;
		    {
			 E Tet, Teu, Tfa, Tfb;
			 Tet = FNMS(KP707106781, TcG, TcD);
			 Teu = TdV - TdU;
			 Tev = FNMS(KP923879532, Teu, Tet);
			 Tf7 = FMA(KP923879532, Teu, Tet);
			 Tfa = FMA(KP923879532, TeF, TeE);
			 Tfb = FMA(KP923879532, TeI, TeH);
			 Tfc = FNMS(KP303346683, Tfb, Tfa);
			 Tfm = FMA(KP303346683, Tfa, Tfb);
		    }
		    {
			 E Tfd, Tfe, Tey, TeB;
			 Tfd = FMA(KP923879532, TeM, TeL);
			 Tfe = FNMS(KP923879532, TeP, TeO);
			 Tff = FMA(KP303346683, Tfe, Tfd);
			 Tfn = FNMS(KP303346683, Tfd, Tfe);
			 Tey = FMA(KP668178637, Tex, Tew);
			 TeB = FNMS(KP668178637, TeA, Tez);
			 TeC = Tey - TeB;
			 Tfi = Tey + TeB;
		    }
		    {
			 E TeG, TeJ, TeT, TeU;
			 TeG = FNMS(KP923879532, TeF, TeE);
			 TeJ = FNMS(KP923879532, TeI, TeH);
			 TeK = FMA(KP534511135, TeJ, TeG);
			 Tf2 = FNMS(KP534511135, TeG, TeJ);
			 TeT = FNMS(KP707106781, TdS, TdR);
			 TeU = TcN - TcK;
			 TeV = FMA(KP923879532, TeU, TeT);
			 Tfh = FNMS(KP923879532, TeU, TeT);
		    }
		    {
			 E TeW, TeX, TeN, TeQ;
			 TeW = FMA(KP668178637, Tez, TeA);
			 TeX = FNMS(KP668178637, Tew, Tex);
			 TeY = TeW - TeX;
			 Tf8 = TeX + TeW;
			 TeN = FNMS(KP923879532, TeM, TeL);
			 TeQ = FMA(KP923879532, TeP, TeO);
			 TeR = FNMS(KP534511135, TeQ, TeN);
			 Tf3 = FMA(KP534511135, TeN, TeQ);
		    }
		    {
			 E TeD, TeS, Tf1, Tf4;
			 TeD = FMA(KP831469612, TeC, Tev);
			 TeS = TeK + TeR;
			 Cr[WS(csr, 54)] = FNMS(KP881921264, TeS, TeD);
			 Cr[WS(csr, 10)] = FMA(KP881921264, TeS, TeD);
			 Tf1 = FMA(KP831469612, TeY, TeV);
			 Tf4 = Tf2 + Tf3;
			 Ci[WS(csi, 10)] = FMA(KP881921264, Tf4, Tf1);
			 Ci[WS(csi, 54)] = FMS(KP881921264, Tf4, Tf1);
		    }
		    {
			 E TeZ, Tf0, Tf5, Tf6;
			 TeZ = FNMS(KP831469612, TeY, TeV);
			 Tf0 = TeR - TeK;
			 Ci[WS(csi, 22)] = FMS(KP881921264, Tf0, TeZ);
			 Ci[WS(csi, 42)] = FMA(KP881921264, Tf0, TeZ);
			 Tf5 = FNMS(KP831469612, TeC, Tev);
			 Tf6 = Tf3 - Tf2;
			 Cr[WS(csr, 42)] = FNMS(KP881921264, Tf6, Tf5);
			 Cr[WS(csr, 22)] = FMA(KP881921264, Tf6, Tf5);
		    }
		    {
			 E Tf9, Tfg, Tfl, Tfo;
			 Tf9 = FMA(KP831469612, Tf8, Tf7);
			 Tfg = Tfc + Tff;
			 Cr[WS(csr, 58)] = FNMS(KP956940335, Tfg, Tf9);
			 Cr[WS(csr, 6)] = FMA(KP956940335, Tfg, Tf9);
			 Tfl = FMA(KP831469612, Tfi, Tfh);
			 Tfo = Tfm + Tfn;
			 Ci[WS(csi, 6)] = -(FMA(KP956940335, Tfo, Tfl));
			 Ci[WS(csi, 58)] = FNMS(KP956940335, Tfo, Tfl);
		    }
		    {
			 E Tfj, Tfk, Tfp, Tfq;
			 Tfj = FNMS(KP831469612, Tfi, Tfh);
			 Tfk = Tff - Tfc;
			 Ci[WS(csi, 26)] = FMA(KP956940335, Tfk, Tfj);
			 Ci[WS(csi, 38)] = FMS(KP956940335, Tfk, Tfj);
			 Tfp = FNMS(KP831469612, Tf8, Tf7);
			 Tfq = Tfm - Tfn;
			 Cr[WS(csr, 38)] = FNMS(KP956940335, Tfq, Tfp);
			 Cr[WS(csr, 26)] = FMA(KP956940335, Tfq, Tfp);
		    }
	       }
	       {
		    E TcP, Te9, Tee, Teo, Teh, Tep, Td8, Tek, Tdu, Te4, TdX, Tej, Te0, Tea, TdP;
		    E Te5;
		    {
			 E TcH, TcO, Tec, Ted;
			 TcH = FMA(KP707106781, TcG, TcD);
			 TcO = TcK + TcN;
			 TcP = FMA(KP923879532, TcO, TcH);
			 Te9 = FNMS(KP923879532, TcO, TcH);
			 Tec = FNMS(KP923879532, Tdl, Tde);
			 Ted = FNMS(KP923879532, Tds, Tdp);
			 Tee = FNMS(KP820678790, Ted, Tec);
			 Teo = FMA(KP820678790, Tec, Ted);
		    }
		    {
			 E Tef, Teg, TcY, Td7;
			 Tef = FNMS(KP923879532, TdG, Tdz);
			 Teg = FNMS(KP923879532, TdN, TdK);
			 Teh = FMA(KP820678790, Teg, Tef);
			 Tep = FNMS(KP820678790, Tef, Teg);
			 TcY = FMA(KP198912367, TcX, TcU);
			 Td7 = FNMS(KP198912367, Td6, Td3);
			 Td8 = TcY + Td7;
			 Tek = Td7 - TcY;
		    }
		    {
			 E Tdm, Tdt, TdT, TdW;
			 Tdm = FMA(KP923879532, Tdl, Tde);
			 Tdt = FMA(KP923879532, Tds, Tdp);
			 Tdu = FMA(KP098491403, Tdt, Tdm);
			 Te4 = FNMS(KP098491403, Tdm, Tdt);
			 TdT = FMA(KP707106781, TdS, TdR);
			 TdW = TdU + TdV;
			 TdX = FMA(KP923879532, TdW, TdT);
			 Tej = FNMS(KP923879532, TdW, TdT);
		    }
		    {
			 E TdY, TdZ, TdH, TdO;
			 TdY = FNMS(KP198912367, TcU, TcX);
			 TdZ = FMA(KP198912367, Td3, Td6);
			 Te0 = TdY + TdZ;
			 Tea = TdZ - TdY;
			 TdH = FMA(KP923879532, TdG, Tdz);
			 TdO = FMA(KP923879532, TdN, TdK);
			 TdP = FNMS(KP098491403, TdO, TdH);
			 Te5 = FMA(KP098491403, TdH, TdO);
		    }
		    {
			 E Td9, TdQ, Te3, Te6;
			 Td9 = FMA(KP980785280, Td8, TcP);
			 TdQ = Tdu + TdP;
			 Cr[WS(csr, 62)] = FNMS(KP995184726, TdQ, Td9);
			 Cr[WS(csr, 2)] = FMA(KP995184726, TdQ, Td9);
			 Te3 = FMA(KP980785280, Te0, TdX);
			 Te6 = Te4 + Te5;
			 Ci[WS(csi, 2)] = FMA(KP995184726, Te6, Te3);
			 Ci[WS(csi, 62)] = FMS(KP995184726, Te6, Te3);
		    }
		    {
			 E Te1, Te2, Te7, Te8;
			 Te1 = FNMS(KP980785280, Te0, TdX);
			 Te2 = TdP - Tdu;
			 Ci[WS(csi, 30)] = FMS(KP995184726, Te2, Te1);
			 Ci[WS(csi, 34)] = FMA(KP995184726, Te2, Te1);
			 Te7 = FNMS(KP980785280, Td8, TcP);
			 Te8 = Te5 - Te4;
			 Cr[WS(csr, 34)] = FNMS(KP995184726, Te8, Te7);
			 Cr[WS(csr, 30)] = FMA(KP995184726, Te8, Te7);
		    }
		    {
			 E Teb, Tei, Ten, Teq;
			 Teb = FMA(KP980785280, Tea, Te9);
			 Tei = Tee + Teh;
			 Cr[WS(csr, 50)] = FNMS(KP773010453, Tei, Teb);
			 Cr[WS(csr, 14)] = FMA(KP773010453, Tei, Teb);
			 Ten = FNMS(KP980785280, Tek, Tej);
			 Teq = Teo + Tep;
			 Ci[WS(csi, 14)] = -(FMA(KP773010453, Teq, Ten));
			 Ci[WS(csi, 50)] = FNMS(KP773010453, Teq, Ten);
		    }
		    {
			 E Tel, Tem, Ter, Tes;
			 Tel = FMA(KP980785280, Tek, Tej);
			 Tem = Teh - Tee;
			 Ci[WS(csi, 18)] = FMA(KP773010453, Tem, Tel);
			 Ci[WS(csi, 46)] = FMS(KP773010453, Tem, Tel);
			 Ter = FNMS(KP980785280, Tea, Te9);
			 Tes = Teo - Tep;
			 Cr[WS(csr, 46)] = FNMS(KP773010453, Tes, Ter);
			 Cr[WS(csr, 18)] = FMA(KP773010453, Tes, Ter);
		    }
	       }
	       {
		    E T6v, T77, T6C, T7i, T6Y, T78, T6V, T7h, T6R, T7n, T72, T7f, T6K, T7m, T73;
		    E T7c;
		    {
			 E T6t, T6u, T6T, T6U;
			 T6t = FNMS(KP923879532, T2e, T27);
			 T6u = T5U - T5V;
			 T6v = FNMS(KP980785280, T6u, T6t);
			 T77 = FMA(KP980785280, T6u, T6t);
			 {
			      E T6y, T6B, T6W, T6X;
			      T6y = FMA(KP820678790, T6x, T6w);
			      T6B = FNMS(KP820678790, T6A, T6z);
			      T6C = T6y - T6B;
			      T7i = T6B + T6y;
			      T6W = FNMS(KP820678790, T6w, T6x);
			      T6X = FMA(KP820678790, T6z, T6A);
			      T6Y = T6W - T6X;
			      T78 = T6X + T6W;
			 }
			 T6T = FNMS(KP923879532, T5S, T5P);
			 T6U = T2x - T2o;
			 T6V = FNMS(KP980785280, T6U, T6T);
			 T7h = FMA(KP980785280, T6U, T6T);
			 {
			      E T6N, T7d, T6Q, T7e, T6M, T6P;
			      T6M = T5I - T5H;
			      T6N = FNMS(KP980785280, T6M, T6L);
			      T7d = FMA(KP980785280, T6M, T6L);
			      T6P = T5v - T5e;
			      T6Q = FMA(KP980785280, T6P, T6O);
			      T7e = FNMS(KP980785280, T6P, T6O);
			      T6R = FNMS(KP472964775, T6Q, T6N);
			      T7n = FNMS(KP357805721, T7d, T7e);
			      T72 = FMA(KP472964775, T6N, T6Q);
			      T7f = FMA(KP357805721, T7e, T7d);
			 }
			 {
			      E T6G, T7a, T6J, T7b, T6F, T6I;
			      T6F = T4s - T4t;
			      T6G = FNMS(KP980785280, T6F, T6E);
			      T7a = FMA(KP980785280, T6F, T6E);
			      T6I = T4g - T3Z;
			      T6J = FNMS(KP980785280, T6I, T6H);
			      T7b = FMA(KP980785280, T6I, T6H);
			      T6K = FNMS(KP472964775, T6J, T6G);
			      T7m = FNMS(KP357805721, T7a, T7b);
			      T73 = FMA(KP472964775, T6G, T6J);
			      T7c = FMA(KP357805721, T7b, T7a);
			 }
		    }
		    {
			 E T6D, T6S, T71, T74;
			 T6D = FMA(KP773010453, T6C, T6v);
			 T6S = T6K + T6R;
			 Cr[WS(csr, 55)] = FNMS(KP903989293, T6S, T6D);
			 Cr[WS(csr, 9)] = FMA(KP903989293, T6S, T6D);
			 T71 = FNMS(KP773010453, T6Y, T6V);
			 T74 = T72 - T73;
			 Ci[WS(csi, 9)] = FMS(KP903989293, T74, T71);
			 Ci[WS(csi, 55)] = FMA(KP903989293, T74, T71);
		    }
		    {
			 E T6Z, T70, T75, T76;
			 T6Z = FMA(KP773010453, T6Y, T6V);
			 T70 = T6R - T6K;
			 Ci[WS(csi, 23)] = FMA(KP903989293, T70, T6Z);
			 Ci[WS(csi, 41)] = FMS(KP903989293, T70, T6Z);
			 T75 = FNMS(KP773010453, T6C, T6v);
			 T76 = T73 + T72;
			 Cr[WS(csr, 41)] = FNMS(KP903989293, T76, T75);
			 Cr[WS(csr, 23)] = FMA(KP903989293, T76, T75);
		    }
		    {
			 E T79, T7g, T7l, T7o;
			 T79 = FMA(KP773010453, T78, T77);
			 T7g = T7c + T7f;
			 Cr[WS(csr, 57)] = FNMS(KP941544065, T7g, T79);
			 Cr[WS(csr, 7)] = FMA(KP941544065, T7g, T79);
			 T7l = FMA(KP773010453, T7i, T7h);
			 T7o = T7m - T7n;
			 Ci[WS(csi, 7)] = FMA(KP941544065, T7o, T7l);
			 Ci[WS(csi, 57)] = FMS(KP941544065, T7o, T7l);
		    }
		    {
			 E T7j, T7k, T7p, T7q;
			 T7j = FNMS(KP773010453, T7i, T7h);
			 T7k = T7f - T7c;
			 Ci[WS(csi, 25)] = FMS(KP941544065, T7k, T7j);
			 Ci[WS(csi, 39)] = FMA(KP941544065, T7k, T7j);
			 T7p = FNMS(KP773010453, T78, T77);
			 T7q = T7m + T7n;
			 Cr[WS(csr, 39)] = FMA(KP941544065, T7q, T7p);
			 Cr[WS(csr, 25)] = FNMS(KP941544065, T7q, T7p);
		    }
	       }
	       {
		    E T99, T9L, T9g, T9W, T9C, T9M, T9z, T9V, T9v, Ta0, T9H, T9T, T9o, Ta1, T9G;
		    E T9Q;
		    {
			 E T97, T98, T9x, T9y;
			 T97 = FNMS(KP923879532, T7s, T7r);
			 T98 = T8z - T8y;
			 T99 = FNMS(KP831469612, T98, T97);
			 T9L = FMA(KP831469612, T98, T97);
			 {
			      E T9c, T9f, T9A, T9B;
			      T9c = FMA(KP534511135, T9b, T9a);
			      T9f = FNMS(KP534511135, T9e, T9d);
			      T9g = T9c - T9f;
			      T9W = T9c + T9f;
			      T9A = FMA(KP534511135, T9d, T9e);
			      T9B = FNMS(KP534511135, T9a, T9b);
			      T9C = T9A - T9B;
			      T9M = T9B + T9A;
			 }
			 T9x = FNMS(KP923879532, T8w, T8v);
			 T9y = T7z - T7w;
			 T9z = FMA(KP831469612, T9y, T9x);
			 T9V = FNMS(KP831469612, T9y, T9x);
			 {
			      E T9r, T9R, T9u, T9S, T9q, T9t;
			      T9q = T8p - T8q;
			      T9r = FNMS(KP831469612, T9q, T9p);
			      T9R = FMA(KP831469612, T9q, T9p);
			      T9t = T8j - T8g;
			      T9u = FNMS(KP831469612, T9t, T9s);
			      T9S = FMA(KP831469612, T9t, T9s);
			      T9v = FMA(KP599376933, T9u, T9r);
			      Ta0 = FMA(KP250486960, T9R, T9S);
			      T9H = FNMS(KP599376933, T9r, T9u);
			      T9T = FNMS(KP250486960, T9S, T9R);
			 }
			 {
			      E T9k, T9O, T9n, T9P, T9j, T9m;
			      T9j = T87 - T86;
			      T9k = FNMS(KP831469612, T9j, T9i);
			      T9O = FMA(KP831469612, T9j, T9i);
			      T9m = T7X - T80;
			      T9n = FNMS(KP831469612, T9m, T9l);
			      T9P = FMA(KP831469612, T9m, T9l);
			      T9o = FMA(KP599376933, T9n, T9k);
			      Ta1 = FMA(KP250486960, T9O, T9P);
			      T9G = FNMS(KP599376933, T9k, T9n);
			      T9Q = FNMS(KP250486960, T9P, T9O);
			 }
		    }
		    {
			 E T9h, T9w, T9F, T9I;
			 T9h = FMA(KP881921264, T9g, T99);
			 T9w = T9o + T9v;
			 Cr[WS(csr, 53)] = FNMS(KP857728610, T9w, T9h);
			 Cr[WS(csr, 11)] = FMA(KP857728610, T9w, T9h);
			 T9F = FMA(KP881921264, T9C, T9z);
			 T9I = T9G - T9H;
			 Ci[WS(csi, 11)] = FMA(KP857728610, T9I, T9F);
			 Ci[WS(csi, 53)] = FMS(KP857728610, T9I, T9F);
		    }
		    {
			 E T9D, T9E, T9J, T9K;
			 T9D = FNMS(KP881921264, T9C, T9z);
			 T9E = T9v - T9o;
			 Ci[WS(csi, 21)] = FMS(KP857728610, T9E, T9D);
			 Ci[WS(csi, 43)] = FMA(KP857728610, T9E, T9D);
			 T9J = FNMS(KP881921264, T9g, T99);
			 T9K = T9G + T9H;
			 Cr[WS(csr, 43)] = FMA(KP857728610, T9K, T9J);
			 Cr[WS(csr, 21)] = FNMS(KP857728610, T9K, T9J);
		    }
		    {
			 E T9N, T9U, T9Z, Ta2;
			 T9N = FMA(KP881921264, T9M, T9L);
			 T9U = T9Q + T9T;
			 Cr[WS(csr, 59)] = FNMS(KP970031253, T9U, T9N);
			 Cr[WS(csr, 5)] = FMA(KP970031253, T9U, T9N);
			 T9Z = FMA(KP881921264, T9W, T9V);
			 Ta2 = Ta0 - Ta1;
			 Ci[WS(csi, 5)] = FMS(KP970031253, Ta2, T9Z);
			 Ci[WS(csi, 59)] = FMA(KP970031253, Ta2, T9Z);
		    }
		    {
			 E T9X, T9Y, Ta3, Ta4;
			 T9X = FNMS(KP881921264, T9W, T9V);
			 T9Y = T9T - T9Q;
			 Ci[WS(csi, 27)] = FMA(KP970031253, T9Y, T9X);
			 Ci[WS(csi, 37)] = FMS(KP970031253, T9Y, T9X);
			 Ta3 = FNMS(KP881921264, T9M, T9L);
			 Ta4 = Ta1 + Ta0;
			 Cr[WS(csr, 37)] = FNMS(KP970031253, Ta4, Ta3);
			 Cr[WS(csr, 27)] = FMA(KP970031253, Ta4, Ta3);
		    }
	       }
	       {
		    E T2z, T69, T3g, T6k, T60, T6a, T5X, T6j, T5L, T6p, T64, T6h, T4w, T6o, T65;
		    E T6e;
		    {
			 E T2f, T2y, T5T, T5W;
			 T2f = FMA(KP923879532, T2e, T27);
			 T2y = T2o + T2x;
			 T2z = FMA(KP980785280, T2y, T2f);
			 T69 = FNMS(KP980785280, T2y, T2f);
			 {
			      E T2U, T3f, T5Y, T5Z;
			      T2U = FNMS(KP098491403, T2T, T2M);
			      T3f = FMA(KP098491403, T3e, T37);
			      T3g = T2U + T3f;
			      T6k = T3f - T2U;
			      T5Y = FMA(KP098491403, T2M, T2T);
			      T5Z = FNMS(KP098491403, T37, T3e);
			      T60 = T5Y + T5Z;
			      T6a = T5Y - T5Z;
			 }
			 T5T = FMA(KP923879532, T5S, T5P);
			 T5W = T5U + T5V;
			 T5X = FMA(KP980785280, T5W, T5T);
			 T6j = FNMS(KP980785280, T5W, T5T);
			 {
			      E T5x, T6f, T5K, T6g, T5w, T5J;
			      T5w = T5e + T5v;
			      T5x = FMA(KP980785280, T5w, T4X);
			      T6f = FNMS(KP980785280, T5w, T4X);
			      T5J = T5H + T5I;
			      T5K = FMA(KP980785280, T5J, T5G);
			      T6g = FNMS(KP980785280, T5J, T5G);
			      T5L = FNMS(KP049126849, T5K, T5x);
			      T6p = FNMS(KP906347169, T6f, T6g);
			      T64 = FMA(KP049126849, T5x, T5K);
			      T6h = FMA(KP906347169, T6g, T6f);
			 }
			 {
			      E T4i, T6c, T4v, T6d, T4h, T4u;
			      T4h = T3Z + T4g;
			      T4i = FMA(KP980785280, T4h, T3I);
			      T6c = FNMS(KP980785280, T4h, T3I);
			      T4u = T4s + T4t;
			      T4v = FMA(KP980785280, T4u, T4r);
			      T6d = FNMS(KP980785280, T4u, T4r);
			      T4w = FNMS(KP049126849, T4v, T4i);
			      T6o = FNMS(KP906347169, T6c, T6d);
			      T65 = FMA(KP049126849, T4i, T4v);
			      T6e = FMA(KP906347169, T6d, T6c);
			 }
		    }
		    {
			 E T3h, T5M, T63, T66;
			 T3h = FMA(KP995184726, T3g, T2z);
			 T5M = T4w + T5L;
			 Cr[WS(csr, 63)] = FNMS(KP998795456, T5M, T3h);
			 Cr[WS(csr, 1)] = FMA(KP998795456, T5M, T3h);
			 T63 = FMA(KP995184726, T60, T5X);
			 T66 = T64 - T65;
			 Ci[WS(csi, 1)] = FMS(KP998795456, T66, T63);
			 Ci[WS(csi, 63)] = FMA(KP998795456, T66, T63);
		    }
		    {
			 E T61, T62, T67, T68;
			 T61 = FNMS(KP995184726, T60, T5X);
			 T62 = T5L - T4w;
			 Ci[WS(csi, 31)] = FMA(KP998795456, T62, T61);
			 Ci[WS(csi, 33)] = FMS(KP998795456, T62, T61);
			 T67 = FNMS(KP995184726, T3g, T2z);
			 T68 = T65 + T64;
			 Cr[WS(csr, 33)] = FNMS(KP998795456, T68, T67);
			 Cr[WS(csr, 31)] = FMA(KP998795456, T68, T67);
		    }
		    {
			 E T6b, T6i, T6n, T6q;
			 T6b = FMA(KP995184726, T6a, T69);
			 T6i = T6e + T6h;
			 Cr[WS(csr, 49)] = FNMS(KP740951125, T6i, T6b);
			 Cr[WS(csr, 15)] = FMA(KP740951125, T6i, T6b);
			 T6n = FMA(KP995184726, T6k, T6j);
			 T6q = T6o - T6p;
			 Ci[WS(csi, 15)] = FMA(KP740951125, T6q, T6n);
			 Ci[WS(csi, 49)] = FMS(KP740951125, T6q, T6n);
		    }
		    {
			 E T6l, T6m, T6r, T6s;
			 T6l = FNMS(KP995184726, T6k, T6j);
			 T6m = T6h - T6e;
			 Ci[WS(csi, 17)] = FMS(KP740951125, T6m, T6l);
			 Ci[WS(csi, 47)] = FMA(KP740951125, T6m, T6l);
			 T6r = FNMS(KP995184726, T6a, T69);
			 T6s = T6o + T6p;
			 Cr[WS(csr, 47)] = FMA(KP740951125, T6s, T6r);
			 Cr[WS(csr, 17)] = FNMS(KP740951125, T6s, T6r);
		    }
	       }
	       {
		    E T7B, T8N, T7Q, T8Y, T8E, T8O, T8B, T8X, T8t, T92, T8J, T8V, T8a, T93, T8I;
		    E T8S;
		    {
			 E T7t, T7A, T8x, T8A;
			 T7t = FMA(KP923879532, T7s, T7r);
			 T7A = T7w + T7z;
			 T7B = FMA(KP831469612, T7A, T7t);
			 T8N = FNMS(KP831469612, T7A, T7t);
			 {
			      E T7I, T7P, T8C, T8D;
			      T7I = FMA(KP303346683, T7H, T7E);
			      T7P = FNMS(KP303346683, T7O, T7L);
			      T7Q = T7I + T7P;
			      T8Y = T7P - T7I;
			      T8C = FNMS(KP303346683, T7E, T7H);
			      T8D = FMA(KP303346683, T7L, T7O);
			      T8E = T8C + T8D;
			      T8O = T8D - T8C;
			 }
			 T8x = FMA(KP923879532, T8w, T8v);
			 T8A = T8y + T8z;
			 T8B = FMA(KP831469612, T8A, T8x);
			 T8X = FNMS(KP831469612, T8A, T8x);
			 {
			      E T8l, T8T, T8s, T8U, T8k, T8r;
			      T8k = T8g + T8j;
			      T8l = FMA(KP831469612, T8k, T8d);
			      T8T = FNMS(KP831469612, T8k, T8d);
			      T8r = T8p + T8q;
			      T8s = FMA(KP831469612, T8r, T8o);
			      T8U = FNMS(KP831469612, T8r, T8o);
			      T8t = FMA(KP148335987, T8s, T8l);
			      T92 = FMA(KP741650546, T8T, T8U);
			      T8J = FNMS(KP148335987, T8l, T8s);
			      T8V = FNMS(KP741650546, T8U, T8T);
			 }
			 {
			      E T82, T8Q, T89, T8R, T81, T88;
			      T81 = T7X + T80;
			      T82 = FMA(KP831469612, T81, T7U);
			      T8Q = FNMS(KP831469612, T81, T7U);
			      T88 = T86 + T87;
			      T89 = FMA(KP831469612, T88, T85);
			      T8R = FNMS(KP831469612, T88, T85);
			      T8a = FMA(KP148335987, T89, T82);
			      T93 = FMA(KP741650546, T8Q, T8R);
			      T8I = FNMS(KP148335987, T82, T89);
			      T8S = FNMS(KP741650546, T8R, T8Q);
			 }
		    }
		    {
			 E T7R, T8u, T8H, T8K;
			 T7R = FMA(KP956940335, T7Q, T7B);
			 T8u = T8a + T8t;
			 Cr[WS(csr, 61)] = FNMS(KP989176509, T8u, T7R);
			 Cr[WS(csr, 3)] = FMA(KP989176509, T8u, T7R);
			 T8H = FMA(KP956940335, T8E, T8B);
			 T8K = T8I - T8J;
			 Ci[WS(csi, 3)] = FMA(KP989176509, T8K, T8H);
			 Ci[WS(csi, 61)] = FMS(KP989176509, T8K, T8H);
		    }
		    {
			 E T8F, T8G, T8L, T8M;
			 T8F = FNMS(KP956940335, T8E, T8B);
			 T8G = T8t - T8a;
			 Ci[WS(csi, 29)] = FMS(KP989176509, T8G, T8F);
			 Ci[WS(csi, 35)] = FMA(KP989176509, T8G, T8F);
			 T8L = FNMS(KP956940335, T7Q, T7B);
			 T8M = T8I + T8J;
			 Cr[WS(csr, 35)] = FMA(KP989176509, T8M, T8L);
			 Cr[WS(csr, 29)] = FNMS(KP989176509, T8M, T8L);
		    }
		    {
			 E T8P, T8W, T91, T94;
			 T8P = FMA(KP956940335, T8O, T8N);
			 T8W = T8S + T8V;
			 Cr[WS(csr, 51)] = FNMS(KP803207531, T8W, T8P);
			 Cr[WS(csr, 13)] = FMA(KP803207531, T8W, T8P);
			 T91 = FNMS(KP956940335, T8Y, T8X);
			 T94 = T92 - T93;
			 Ci[WS(csi, 13)] = FMS(KP803207531, T94, T91);
			 Ci[WS(csi, 51)] = FMA(KP803207531, T94, T91);
		    }
		    {
			 E T8Z, T90, T95, T96;
			 T8Z = FMA(KP956940335, T8Y, T8X);
			 T90 = T8V - T8S;
			 Ci[WS(csi, 19)] = FMA(KP803207531, T90, T8Z);
			 Ci[WS(csi, 45)] = FMS(KP803207531, T90, T8Z);
			 T95 = FNMS(KP956940335, T8O, T8N);
			 T96 = T93 + T92;
			 Cr[WS(csr, 45)] = FNMS(KP803207531, T96, T95);
			 Cr[WS(csr, 19)] = FMA(KP803207531, T96, T95);
		    }
	       }
	  }
     }
}

static const kr2c_desc desc = { 128, "r2cf_128", {440, 0, 516, 0}, &GENUS };

void X(codelet_r2cf_128) (planner *p) {
     X(kr2c_register) (p, r2cf_128, &desc);
}

#else

/* Generated by: ../../../genfft/gen_r2cf.native -compact -variables 4 -pipeline-latency 4 -n 128 -name r2cf_128 -include rdft/scalar/r2cf.h */

/*
 * This function contains 956 FP additions, 330 FP multiplications,
 * (or, 812 additions, 186 multiplications, 144 fused multiply/add),
 * 186 stack variables, 31 constants, and 256 memory accesses
 */
#include "rdft/scalar/r2cf.h"

static void r2cf_128(R *R0, R *R1, R *Cr, R *Ci, stride rs, stride csr, stride csi, INT v, INT ivs, INT ovs)
{
     DK(KP803207531, +0.803207531480644909806676512963141923879569427);
     DK(KP595699304, +0.595699304492433343467036528829969889511926338);
     DK(KP146730474, +0.146730474455361751658850129646717819706215317);
     DK(KP989176509, +0.989176509964780973451673738016243063983689533);
     DK(KP740951125, +0.740951125354959091175616897495162729728955309);
     DK(KP671558954, +0.671558954847018400625376850427421803228750632);
     DK(KP049067674, +0.049067674327418014254954976942682658314745363);
     DK(KP998795456, +0.998795456205172392714771604759100694443203615);
     DK(KP242980179, +0.242980179903263889948274162077471118320990783);
     DK(KP970031253, +0.970031253194543992603984207286100251456865962);
     DK(KP514102744, +0.514102744193221726593693838968815772608049120);
     DK(KP857728610, +0.857728610000272069902269984284770137042490799);
     DK(KP336889853, +0.336889853392220050689253212619147570477766780);
     DK(KP941544065, +0.941544065183020778412509402599502357185589796);
     DK(KP427555093, +0.427555093430282094320966856888798534304578629);
     DK(KP903989293, +0.903989293123443331586200297230537048710132025);
     DK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  for (i = v; i > 0; i = i - 1, R0 = R0 + ivs, R1 = R1 + ivs, Cr = Cr + ovs, Ci = Ci + ovs, MAKE_VOLATILE_STRIDE(512, rs), MAKE_VOLATILE_STRIDE(512, csr), MAKE_VOLATILE_STRIDE(512, csi)) {
	       E TcD, TdU, T27, T7r, T5S, T8y, Tf, Ta5, Tu, Tbq, TcG, TdV, T2e, T8z, T5V;
	       E T7s, TK, Ta6, TcK, TdX, T2o, T5X, T7w, T8B, TZ, Ta7, TcN, TdY, T2x, T5Y;
	       E T7z, T8C, T1g, Taa, TcU, TeA, TcX, Tez, T1v, Tab, T2M, T6z, T7E, T9e, T7H;
	       E T9d, T2T, T6A, T4X, T6L, Tdz, TeL, TdK, TeP, T5G, T6P, T8d, T9p, TaV, Tc3;
	       E Tbi, Tc4, T8o, T9t, T3I, T6H, Tde, TeH, Tdp, TeF, T4r, T6F, T7U, T9l, Tao;
	       E TbW, TaL, TbX, T85, T9j, T1L, Tad, Td3, Tew, Td6, Tex, T20, Tae, T37, T6x;
	       E T7L, T9a, T7O, T9b, T3e, T6w, TbZ, Tc0, T3Z, T4s, Tds, TeI, T4g, T4t, T80;
	       E T87, Tdl, TeE, T7X, T86, TaD, TaM, Tc6, Tc7, T5e, T5H, TdN, TeM, T5v, T5I;
	       E T8j, T8q, TdG, TeO, T8g, T8p, Tba, Tbj;
	       {
		    E T3, T23, Td, T25, T6, T5R, Ta, T24;
		    {
			 E T1, T2, Tb, Tc;
			 T1 = R0[0];
			 T2 = R0[WS(rs, 32)];
			 T3 = T1 + T2;
			 T23 = T1 - T2;
			 Tb = R0[WS(rs, 56)];
			 Tc = R0[WS(rs, 24)];
			 Td = Tb + Tc;
			 T25 = Tb - Tc;
		    }
		    {
			 E T4, T5, T8, T9;
			 T4 = R0[WS(rs, 16)];
			 T5 = R0[WS(rs, 48)];
			 T6 = T4 + T5;
			 T5R = T4 - T5;
			 T8 = R0[WS(rs, 8)];
			 T9 = R0[WS(rs, 40)];
			 Ta = T8 + T9;
			 T24 = T8 - T9;
		    }
		    TcD = T3 - T6;
		    TdU = Td - Ta;
		    {
			 E T26, T5Q, T7, Te;
			 T26 = KP707106781 * (T24 + T25);
			 T27 = T23 + T26;
			 T7r = T23 - T26;
			 T5Q = KP707106781 * (T25 - T24);
			 T5S = T5Q - T5R;
			 T8y = T5R + T5Q;
			 T7 = T3 + T6;
			 Te = Ta + Td;
			 Tf = T7 + Te;
			 Ta5 = T7 - Te;
		    }
	       }
	       {
		    E Ti, T28, Ts, T2c, Tl, T29, Tp, T2b;
		    {
			 E Tg, Th, Tq, Tr;
			 Tg = R0[WS(rs, 4)];
			 Th = R0[WS(rs, 36)];
			 Ti = Tg + Th;
			 T28 = Tg - Th;
			 Tq = R0[WS(rs, 12)];
			 Tr = R0[WS(rs, 44)];
			 Ts = Tq + Tr;
			 T2c = Tq - Tr;
		    }
		    {
			 E Tj, Tk, Tn, To;
			 Tj = R0[WS(rs, 20)];
			 Tk = R0[WS(rs, 52)];
			 Tl = Tj + Tk;
			 T29 = Tj - Tk;
			 Tn = R0[WS(rs, 60)];
			 To = R0[WS(rs, 28)];
			 Tp = Tn + To;
			 T2b = Tn - To;
		    }
		    {
			 E Tm, Tt, TcE, TcF;
			 Tm = Ti + Tl;
			 Tt = Tp + Ts;
			 Tu = Tm + Tt;
			 Tbq = Tt - Tm;
			 TcE = Ti - Tl;
			 TcF = Tp - Ts;
			 TcG = KP707106781 * (TcE + TcF);
			 TdV = KP707106781 * (TcF - TcE);
		    }
		    {
			 E T2a, T2d, T5T, T5U;
			 T2a = FNMS(KP382683432, T29, KP923879532 * T28);
			 T2d = FMA(KP923879532, T2b, KP382683432 * T2c);
			 T2e = T2a + T2d;
			 T8z = T2d - T2a;
			 T5T = FNMS(KP923879532, T2c, KP382683432 * T2b);
			 T5U = FMA(KP382683432, T28, KP923879532 * T29);
			 T5V = T5T - T5U;
			 T7s = T5U + T5T;
		    }
	       }
	       {
		    E Ty, T2g, TB, T2m, TF, T2l, TI, T2j;
		    {
			 E Tw, Tx, Tz, TA;
			 Tw = R0[WS(rs, 2)];
			 Tx = R0[WS(rs, 34)];
			 Ty = Tw + Tx;
			 T2g = Tw - Tx;
			 Tz = R0[WS(rs, 18)];
			 TA = R0[WS(rs, 50)];
			 TB = Tz + TA;
			 T2m = Tz - TA;
			 {
			      E TD, TE, T2h, TG, TH, T2i;
			      TD = R0[WS(rs, 10)];
			      TE = R0[WS(rs, 42)];
			      T2h = TD - TE;
			      TG = R0[WS(rs, 58)];
			      TH = R0[WS(rs, 26)];
			      T2i = TG - TH;
			      TF = TD + TE;
			      T2l = KP707106781 * (T2i - T2h);
			      TI = TG + TH;
			      T2j = KP707106781 * (T2h + T2i);
			 }
		    }
		    {
			 E TC, TJ, TcI, TcJ;
			 TC = Ty + TB;
			 TJ = TF + TI;
			 TK = TC + TJ;
			 Ta6 = TC - TJ;
			 TcI = Ty - TB;
			 TcJ = TI - TF;
			 TcK = FMA(KP923879532, TcI, KP382683432 * TcJ);
			 TdX = FNMS(KP382683432, TcI, KP923879532 * TcJ);
		    }
		    {
			 E T2k, T2n, T7u, T7v;
			 T2k = T2g + T2j;
			 T2n = T2l - T2m;
			 T2o = FMA(KP980785280, T2k, KP195090322 * T2n);
			 T5X = FNMS(KP195090322, T2k, KP980785280 * T2n);
			 T7u = T2g - T2j;
			 T7v = T2m + T2l;
			 T7w = FMA(KP831469612, T7u, KP555570233 * T7v);
			 T8B = FNMS(KP555570233, T7u, KP831469612 * T7v);
		    }
	       }
	       {
		    E TN, T2p, TQ, T2v, TU, T2u, TX, T2s;
		    {
			 E TL, TM, TO, TP;
			 TL = R0[WS(rs, 62)];
			 TM = R0[WS(rs, 30)];
			 TN = TL + TM;
			 T2p = TL - TM;
			 TO = R0[WS(rs, 14)];
			 TP = R0[WS(rs, 46)];
			 TQ = TO + TP;
			 T2v = TO - TP;
			 {
			      E TS, TT, T2q, TV, TW, T2r;
			      TS = R0[WS(rs, 6)];
			      TT = R0[WS(rs, 38)];
			      T2q = TS - TT;
			      TV = R0[WS(rs, 54)];
			      TW = R0[WS(rs, 22)];
			      T2r = TV - TW;
			      TU = TS + TT;
			      T2u = KP707106781 * (T2r - T2q);
			      TX = TV + TW;
			      T2s = KP707106781 * (T2q + T2r);
			 }
		    }
		    {
			 E TR, TY, TcL, TcM;
			 TR = TN + TQ;
			 TY = TU + TX;
			 TZ = TR + TY;
			 Ta7 = TR - TY;
			 TcL = TN - TQ;
			 TcM = TX - TU;
			 TcN = FNMS(KP382683432, TcM, KP923879532 * TcL);
			 TdY = FMA(KP382683432, TcL, KP923879532 * TcM);
		    }
		    {
			 E T2t, T2w, T7x, T7y;
			 T2t = T2p + T2s;
			 T2w = T2u - T2v;
			 T2x = FNMS(KP195090322, T2w, KP980785280 * T2t);
			 T5Y = FMA(KP195090322, T2t, KP980785280 * T2w);
			 T7x = T2p - T2s;
			 T7y = T2v + T2u;
			 T7z = FNMS(KP555570233, T7y, KP831469612 * T7x);
			 T8C = FMA(KP555570233, T7x, KP831469612 * T7y);
		    }
	       }
	       {
		    E T14, T2N, T17, T2D, T1b, T2O, T1e, T2C, T1j, T1m, T2K, TcR, T2Q, T1q, T1t;
		    E T2H, TcS, T2R;
		    {
			 E T12, T13, T15, T16;
			 T12 = R0[WS(rs, 1)];
			 T13 = R0[WS(rs, 33)];
			 T14 = T12 + T13;
			 T2N = T12 - T13;
			 T15 = R0[WS(rs, 17)];
			 T16 = R0[WS(rs, 49)];
			 T17 = T15 + T16;
			 T2D = T15 - T16;
		    }
		    {
			 E T19, T1a, T2B, T1c, T1d, T2A;
			 T19 = R0[WS(rs, 9)];
			 T1a = R0[WS(rs, 41)];
			 T2B = T19 - T1a;
			 T1c = R0[WS(rs, 57)];
			 T1d = R0[WS(rs, 25)];
			 T2A = T1c - T1d;
			 T1b = T19 + T1a;
			 T2O = KP707106781 * (T2B + T2A);
			 T1e = T1c + T1d;
			 T2C = KP707106781 * (T2A - T2B);
		    }
		    {
			 E T2I, T2J, T2F, T2G;
			 {
			      E T1h, T1i, T1k, T1l;
			      T1h = R0[WS(rs, 5)];
			      T1i = R0[WS(rs, 37)];
			      T1j = T1h + T1i;
			      T2I = T1h - T1i;
			      T1k = R0[WS(rs, 21)];
			      T1l = R0[WS(rs, 53)];
			      T1m = T1k + T1l;
			      T2J = T1k - T1l;
			 }
			 T2K = FMA(KP382683432, T2I, KP923879532 * T2J);
			 TcR = T1j - T1m;
			 T2Q = FNMS(KP382683432, T2J, KP923879532 * T2I);
			 {
			      E T1o, T1p, T1r, T1s;
			      T1o = R0[WS(rs, 61)];
			      T1p = R0[WS(rs, 29)];
			      T1q = T1o + T1p;
			      T2F = T1o - T1p;
			      T1r = R0[WS(rs, 13)];
			      T1s = R0[WS(rs, 45)];
			      T1t = T1r + T1s;
			      T2G = T1r - T1s;
			 }
			 T2H = FNMS(KP923879532, T2G, KP382683432 * T2F);
			 TcS = T1q - T1t;
			 T2R = FMA(KP923879532, T2F, KP382683432 * T2G);
		    }
		    {
			 E T18, T1f, TcQ, TcT;
			 T18 = T14 + T17;
			 T1f = T1b + T1e;
			 T1g = T18 + T1f;
			 Taa = T18 - T1f;
			 TcQ = T14 - T17;
			 TcT = KP707106781 * (TcR + TcS);
			 TcU = TcQ + TcT;
			 TeA = TcQ - TcT;
		    }
		    {
			 E TcV, TcW, T1n, T1u;
			 TcV = T1e - T1b;
			 TcW = KP707106781 * (TcS - TcR);
			 TcX = TcV + TcW;
			 Tez = TcW - TcV;
			 T1n = T1j + T1m;
			 T1u = T1q + T1t;
			 T1v = T1n + T1u;
			 Tab = T1u - T1n;
		    }
		    {
			 E T2E, T2L, T7C, T7D;
			 T2E = T2C - T2D;
			 T2L = T2H - T2K;
			 T2M = T2E + T2L;
			 T6z = T2L - T2E;
			 T7C = T2N - T2O;
			 T7D = T2K + T2H;
			 T7E = T7C + T7D;
			 T9e = T7C - T7D;
		    }
		    {
			 E T7F, T7G, T2P, T2S;
			 T7F = T2D + T2C;
			 T7G = T2R - T2Q;
			 T7H = T7F + T7G;
			 T9d = T7G - T7F;
			 T2P = T2N + T2O;
			 T2S = T2Q + T2R;
			 T2T = T2P + T2S;
			 T6A = T2P - T2S;
		    }
	       }
	       {
		    E T4z, TaP, T5B, TaQ, T4G, TaT, T5y, TaS, Tbf, Tbg, T4O, Tdw, T5E, Tbc, Tbd;
		    E T4V, Tdx, T5D;
		    {
			 E T4x, T4y, T5z, T5A;
			 T4x = R1[WS(rs, 63)];
			 T4y = R1[WS(rs, 31)];
			 T4z = T4x - T4y;
			 TaP = T4x + T4y;
			 T5z = R1[WS(rs, 15)];
			 T5A = R1[WS(rs, 47)];
			 T5B = T5z - T5A;
			 TaQ = T5z + T5A;
		    }
		    {
			 E T4A, T4B, T4C, T4D, T4E, T4F;
			 T4A = R1[WS(rs, 7)];
			 T4B = R1[WS(rs, 39)];
			 T4C = T4A - T4B;
			 T4D = R1[WS(rs, 55)];
			 T4E = R1[WS(rs, 23)];
			 T4F = T4D - T4E;
			 T4G = KP707106781 * (T4C + T4F);
			 TaT = T4D + T4E;
			 T5y = KP707106781 * (T4F - T4C);
			 TaS = T4A + T4B;
		    }
		    {
			 E T4K, T4N, T4R, T4U;
			 {
			      E T4I, T4J, T4L, T4M;
			      T4I = R1[WS(rs, 3)];
			      T4J = R1[WS(rs, 35)];
			      T4K = T4I - T4J;
			      Tbf = T4I + T4J;
			      T4L = R1[WS(rs, 19)];
			      T4M = R1[WS(rs, 51)];
			      T4N = T4L - T4M;
			      Tbg = T4L + T4M;
			 }
			 T4O = FNMS(KP382683432, T4N, KP923879532 * T4K);
			 Tdw = Tbf - Tbg;
			 T5E = FMA(KP382683432, T4K, KP923879532 * T4N);
			 {
			      E T4P, T4Q, T4S, T4T;
			      T4P = R1[WS(rs, 59)];
			      T4Q = R1[WS(rs, 27)];
			      T4R = T4P - T4Q;
			      Tbc = T4P + T4Q;
			      T4S = R1[WS(rs, 11)];
			      T4T = R1[WS(rs, 43)];
			      T4U = T4S - T4T;
			      Tbd = T4S + T4T;
			 }
			 T4V = FMA(KP923879532, T4R, KP382683432 * T4U);
			 Tdx = Tbc - Tbd;
			 T5D = FNMS(KP923879532, T4U, KP382683432 * T4R);
		    }
		    {
			 E T4H, T4W, Tdv, Tdy;
			 T4H = T4z + T4G;
			 T4W = T4O + T4V;
			 T4X = T4H + T4W;
			 T6L = T4H - T4W;
			 Tdv = TaP - TaQ;
			 Tdy = KP707106781 * (Tdw + Tdx);
			 Tdz = Tdv + Tdy;
			 TeL = Tdv - Tdy;
		    }
		    {
			 E TdI, TdJ, T5C, T5F;
			 TdI = TaT - TaS;
			 TdJ = KP707106781 * (Tdx - Tdw);
			 TdK = TdI + TdJ;
			 TeP = TdJ - TdI;
			 T5C = T5y - T5B;
			 T5F = T5D - T5E;
			 T5G = T5C + T5F;
			 T6P = T5F - T5C;
		    }
		    {
			 E T8b, T8c, TaR, TaU;
			 T8b = T4z - T4G;
			 T8c = T5E + T5D;
			 T8d = T8b + T8c;
			 T9p = T8b - T8c;
			 TaR = TaP + TaQ;
			 TaU = TaS + TaT;
			 TaV = TaR - TaU;
			 Tc3 = TaR + TaU;
		    }
		    {
			 E Tbe, Tbh, T8m, T8n;
			 Tbe = Tbc + Tbd;
			 Tbh = Tbf + Tbg;
			 Tbi = Tbe - Tbh;
			 Tc4 = Tbh + Tbe;
			 T8m = T5B + T5y;
			 T8n = T4V - T4O;
			 T8o = T8m + T8n;
			 T9t = T8n - T8m;
		    }
	       }
	       {
		    E T3k, Tai, T4m, Taj, T3r, Tam, T4j, Tal, TaI, TaJ, T3z, Tdb, T4p, TaF, TaG;
		    E T3G, Tdc, T4o;
		    {
			 E T3i, T3j, T4k, T4l;
			 T3i = R1[0];
			 T3j = R1[WS(rs, 32)];
			 T3k = T3i - T3j;
			 Tai = T3i + T3j;
			 T4k = R1[WS(rs, 16)];
			 T4l = R1[WS(rs, 48)];
			 T4m = T4k - T4l;
			 Taj = T4k + T4l;
		    }
		    {
			 E T3l, T3m, T3n, T3o, T3p, T3q;
			 T3l = R1[WS(rs, 8)];
			 T3m = R1[WS(rs, 40)];
			 T3n = T3l - T3m;
			 T3o = R1[WS(rs, 56)];
			 T3p = R1[WS(rs, 24)];
			 T3q = T3o - T3p;
			 T3r = KP707106781 * (T3n + T3q);
			 Tam = T3o + T3p;
			 T4j = KP707106781 * (T3q - T3n);
			 Tal = T3l + T3m;
		    }
		    {
			 E T3v, T3y, T3C, T3F;
			 {
			      E T3t, T3u, T3w, T3x;
			      T3t = R1[WS(rs, 4)];
			      T3u = R1[WS(rs, 36)];
			      T3v = T3t - T3u;
			      TaI = T3t + T3u;
			      T3w = R1[WS(rs, 20)];
			      T3x = R1[WS(rs, 52)];
			      T3y = T3w - T3x;
			      TaJ = T3w + T3x;
			 }
			 T3z = FNMS(KP382683432, T3y, KP923879532 * T3v);
			 Tdb = TaI - TaJ;
			 T4p = FMA(KP382683432, T3v, KP923879532 * T3y);
			 {
			      E T3A, T3B, T3D, T3E;
			      T3A = R1[WS(rs, 60)];
			      T3B = R1[WS(rs, 28)];
			      T3C = T3A - T3B;
			      TaF = T3A + T3B;
			      T3D = R1[WS(rs, 12)];
			      T3E = R1[WS(rs, 44)];
			      T3F = T3D - T3E;
			      TaG = T3D + T3E;
			 }
			 T3G = FMA(KP923879532, T3C, KP382683432 * T3F);
			 Tdc = TaF - TaG;
			 T4o = FNMS(KP923879532, T3F, KP382683432 * T3C);
		    }
		    {
			 E T3s, T3H, Tda, Tdd;
			 T3s = T3k + T3r;
			 T3H = T3z + T3G;
			 T3I = T3s + T3H;
			 T6H = T3s - T3H;
			 Tda = Tai - Taj;
			 Tdd = KP707106781 * (Tdb + Tdc);
			 Tde = Tda + Tdd;
			 TeH = Tda - Tdd;
		    }
		    {
			 E Tdn, Tdo, T4n, T4q;
			 Tdn = Tam - Tal;
			 Tdo = KP707106781 * (Tdc - Tdb);
			 Tdp = Tdn + Tdo;
			 TeF = Tdo - Tdn;
			 T4n = T4j - T4m;
			 T4q = T4o - T4p;
			 T4r = T4n + T4q;
			 T6F = T4q - T4n;
		    }
		    {
			 E T7S, T7T, Tak, Tan;
			 T7S = T3k - T3r;
			 T7T = T4p + T4o;
			 T7U = T7S + T7T;
			 T9l = T7S - T7T;
			 Tak = Tai + Taj;
			 Tan = Tal + Tam;
			 Tao = Tak - Tan;
			 TbW = Tak + Tan;
		    }
		    {
			 E TaH, TaK, T83, T84;
			 TaH = TaF + TaG;
			 TaK = TaI + TaJ;
			 TaL = TaH - TaK;
			 TbX = TaK + TaH;
			 T83 = T4m + T4j;
			 T84 = T3G - T3z;
			 T85 = T83 + T84;
			 T9j = T84 - T83;
		    }
	       }
	       {
		    E T1z, T2V, T1C, T39, T1G, T38, T1J, T2Y, T1O, T1R, T32, Td0, T3c, T1V, T1Y;
		    E T35, Td1, T3b;
		    {
			 E T1x, T1y, T1A, T1B;
			 T1x = R0[WS(rs, 63)];
			 T1y = R0[WS(rs, 31)];
			 T1z = T1x + T1y;
			 T2V = T1x - T1y;
			 T1A = R0[WS(rs, 15)];
			 T1B = R0[WS(rs, 47)];
			 T1C = T1A + T1B;
			 T39 = T1A - T1B;
		    }
		    {
			 E T1E, T1F, T2W, T1H, T1I, T2X;
			 T1E = R0[WS(rs, 7)];
			 T1F = R0[WS(rs, 39)];
			 T2W = T1E - T1F;
			 T1H = R0[WS(rs, 55)];
			 T1I = R0[WS(rs, 23)];
			 T2X = T1H - T1I;
			 T1G = T1E + T1F;
			 T38 = KP707106781 * (T2X - T2W);
			 T1J = T1H + T1I;
			 T2Y = KP707106781 * (T2W + T2X);
		    }
		    {
			 E T30, T31, T33, T34;
			 {
			      E T1M, T1N, T1P, T1Q;
			      T1M = R0[WS(rs, 3)];
			      T1N = R0[WS(rs, 35)];
			      T1O = T1M + T1N;
			      T30 = T1M - T1N;
			      T1P = R0[WS(rs, 19)];
			      T1Q = R0[WS(rs, 51)];
			      T1R = T1P + T1Q;
			      T31 = T1P - T1Q;
			 }
			 T32 = FNMS(KP382683432, T31, KP923879532 * T30);
			 Td0 = T1O - T1R;
			 T3c = FMA(KP382683432, T30, KP923879532 * T31);
			 {
			      E T1T, T1U, T1W, T1X;
			      T1T = R0[WS(rs, 59)];
			      T1U = R0[WS(rs, 27)];
			      T1V = T1T + T1U;
			      T33 = T1T - T1U;
			      T1W = R0[WS(rs, 11)];
			      T1X = R0[WS(rs, 43)];
			      T1Y = T1W + T1X;
			      T34 = T1W - T1X;
			 }
			 T35 = FMA(KP923879532, T33, KP382683432 * T34);
			 Td1 = T1V - T1Y;
			 T3b = FNMS(KP923879532, T34, KP382683432 * T33);
		    }
		    {
			 E T1D, T1K, TcZ, Td2;
			 T1D = T1z + T1C;
			 T1K = T1G + T1J;
			 T1L = T1D + T1K;
			 Tad = T1D - T1K;
			 TcZ = T1z - T1C;
			 Td2 = KP707106781 * (Td0 + Td1);
			 Td3 = TcZ + Td2;
			 Tew = TcZ - Td2;
		    }
		    {
			 E Td4, Td5, T1S, T1Z;
			 Td4 = T1J - T1G;
			 Td5 = KP707106781 * (Td1 - Td0);
			 Td6 = Td4 + Td5;
			 Tex = Td5 - Td4;
			 T1S = T1O + T1R;
			 T1Z = T1V + T1Y;
			 T20 = T1S + T1Z;
			 Tae = T1Z - T1S;
		    }
		    {
			 E T2Z, T36, T7J, T7K;
			 T2Z = T2V + T2Y;
			 T36 = T32 + T35;
			 T37 = T2Z + T36;
			 T6x = T2Z - T36;
			 T7J = T2V - T2Y;
			 T7K = T3c + T3b;
			 T7L = T7J + T7K;
			 T9a = T7J - T7K;
		    }
		    {
			 E T7M, T7N, T3a, T3d;
			 T7M = T39 + T38;
			 T7N = T35 - T32;
			 T7O = T7M + T7N;
			 T9b = T7N - T7M;
			 T3a = T38 - T39;
			 T3d = T3b - T3c;
			 T3e = T3a + T3d;
			 T6w = T3d - T3a;
		    }
	       }
	       {
		    E T3L, Tdf, T3X, Tar, T42, Tdi, T4e, Tay, T3S, Tdg, T3U, Tau, T49, Tdj, T4b;
		    E TaB, Tdh, Tdk;
		    {
			 E T3J, T3K, Tap, T3V, T3W, Taq;
			 T3J = R1[WS(rs, 2)];
			 T3K = R1[WS(rs, 34)];
			 Tap = T3J + T3K;
			 T3V = R1[WS(rs, 18)];
			 T3W = R1[WS(rs, 50)];
			 Taq = T3V + T3W;
			 T3L = T3J - T3K;
			 Tdf = Tap - Taq;
			 T3X = T3V - T3W;
			 Tar = Tap + Taq;
		    }
		    {
			 E T40, T41, Taw, T4c, T4d, Tax;
			 T40 = R1[WS(rs, 62)];
			 T41 = R1[WS(rs, 30)];
			 Taw = T40 + T41;
			 T4c = R1[WS(rs, 14)];
			 T4d = R1[WS(rs, 46)];
			 Tax = T4c + T4d;
			 T42 = T40 - T41;
			 Tdi = Taw - Tax;
			 T4e = T4c - T4d;
			 Tay = Taw + Tax;
		    }
		    {
			 E T3O, Tas, T3R, Tat;
			 {
			      E T3M, T3N, T3P, T3Q;
			      T3M = R1[WS(rs, 10)];
			      T3N = R1[WS(rs, 42)];
			      T3O = T3M - T3N;
			      Tas = T3M + T3N;
			      T3P = R1[WS(rs, 58)];
			      T3Q = R1[WS(rs, 26)];
			      T3R = T3P - T3Q;
			      Tat = T3P + T3Q;
			 }
			 T3S = KP707106781 * (T3O + T3R);
			 Tdg = Tat - Tas;
			 T3U = KP707106781 * (T3R - T3O);
			 Tau = Tas + Tat;
		    }
		    {
			 E T45, Taz, T48, TaA;
			 {
			      E T43, T44, T46, T47;
			      T43 = R1[WS(rs, 6)];
			      T44 = R1[WS(rs, 38)];
			      T45 = T43 - T44;
			      Taz = T43 + T44;
			      T46 = R1[WS(rs, 54)];
			      T47 = R1[WS(rs, 22)];
			      T48 = T46 - T47;
			      TaA = T46 + T47;
			 }
			 T49 = KP707106781 * (T45 + T48);
			 Tdj = TaA - Taz;
			 T4b = KP707106781 * (T48 - T45);
			 TaB = Taz + TaA;
		    }
		    TbZ = Tar + Tau;
		    Tc0 = Tay + TaB;
		    {
			 E T3T, T3Y, Tdq, Tdr;
			 T3T = T3L + T3S;
			 T3Y = T3U - T3X;
			 T3Z = FMA(KP980785280, T3T, KP195090322 * T3Y);
			 T4s = FNMS(KP195090322, T3T, KP980785280 * T3Y);
			 Tdq = FNMS(KP382683432, Tdf, KP923879532 * Tdg);
			 Tdr = FMA(KP382683432, Tdi, KP923879532 * Tdj);
			 Tds = Tdq + Tdr;
			 TeI = Tdr - Tdq;
		    }
		    {
			 E T4a, T4f, T7Y, T7Z;
			 T4a = T42 + T49;
			 T4f = T4b - T4e;
			 T4g = FNMS(KP195090322, T4f, KP980785280 * T4a);
			 T4t = FMA(KP195090322, T4a, KP980785280 * T4f);
			 T7Y = T42 - T49;
			 T7Z = T4e + T4b;
			 T80 = FNMS(KP555570233, T7Z, KP831469612 * T7Y);
			 T87 = FMA(KP555570233, T7Y, KP831469612 * T7Z);
		    }
		    Tdh = FMA(KP923879532, Tdf, KP382683432 * Tdg);
		    Tdk = FNMS(KP382683432, Tdj, KP923879532 * Tdi);
		    Tdl = Tdh + Tdk;
		    TeE = Tdk - Tdh;
		    {
			 E T7V, T7W, Tav, TaC;
			 T7V = T3L - T3S;
			 T7W = T3X + T3U;
			 T7X = FMA(KP831469612, T7V, KP555570233 * T7W);
			 T86 = FNMS(KP555570233, T7V, KP831469612 * T7W);
			 Tav = Tar - Tau;
			 TaC = Tay - TaB;
			 TaD = KP707106781 * (Tav + TaC);
			 TaM = KP707106781 * (TaC - Tav);
		    }
	       }
	       {
		    E T50, TdA, T5c, TaY, T5h, TdD, T5t, Tb5, T57, TdB, T59, Tb1, T5o, TdE, T5q;
		    E Tb8, TdC, TdF;
		    {
			 E T4Y, T4Z, TaW, T5a, T5b, TaX;
			 T4Y = R1[WS(rs, 1)];
			 T4Z = R1[WS(rs, 33)];
			 TaW = T4Y + T4Z;
			 T5a = R1[WS(rs, 17)];
			 T5b = R1[WS(rs, 49)];
			 TaX = T5a + T5b;
			 T50 = T4Y - T4Z;
			 TdA = TaW - TaX;
			 T5c = T5a - T5b;
			 TaY = TaW + TaX;
		    }
		    {
			 E T5f, T5g, Tb3, T5r, T5s, Tb4;
			 T5f = R1[WS(rs, 61)];
			 T5g = R1[WS(rs, 29)];
			 Tb3 = T5f + T5g;
			 T5r = R1[WS(rs, 13)];
			 T5s = R1[WS(rs, 45)];
			 Tb4 = T5r + T5s;
			 T5h = T5f - T5g;
			 TdD = Tb3 - Tb4;
			 T5t = T5r - T5s;
			 Tb5 = Tb3 + Tb4;
		    }
		    {
			 E T53, TaZ, T56, Tb0;
			 {
			      E T51, T52, T54, T55;
			      T51 = R1[WS(rs, 9)];
			      T52 = R1[WS(rs, 41)];
			      T53 = T51 - T52;
			      TaZ = T51 + T52;
			      T54 = R1[WS(rs, 57)];
			      T55 = R1[WS(rs, 25)];
			      T56 = T54 - T55;
			      Tb0 = T54 + T55;
			 }
			 T57 = KP707106781 * (T53 + T56);
			 TdB = Tb0 - TaZ;
			 T59 = KP707106781 * (T56 - T53);
			 Tb1 = TaZ + Tb0;
		    }
		    {
			 E T5k, Tb6, T5n, Tb7;
			 {
			      E T5i, T5j, T5l, T5m;
			      T5i = R1[WS(rs, 5)];
			      T5j = R1[WS(rs, 37)];
			      T5k = T5i - T5j;
			      Tb6 = T5i + T5j;
			      T5l = R1[WS(rs, 53)];
			      T5m = R1[WS(rs, 21)];
			      T5n = T5l - T5m;
			      Tb7 = T5l + T5m;
			 }
			 T5o = KP707106781 * (T5k + T5n);
			 TdE = Tb7 - Tb6;
			 T5q = KP707106781 * (T5n - T5k);
			 Tb8 = Tb6 + Tb7;
		    }
		    Tc6 = TaY + Tb1;
		    Tc7 = Tb5 + Tb8;
		    {
			 E T58, T5d, TdL, TdM;
			 T58 = T50 + T57;
			 T5d = T59 - T5c;
			 T5e = FMA(KP980785280, T58, KP195090322 * T5d);
			 T5H = FNMS(KP195090322, T58, KP980785280 * T5d);
			 TdL = FNMS(KP382683432, TdA, KP923879532 * TdB);
			 TdM = FMA(KP382683432, TdD, KP923879532 * TdE);
			 TdN = TdL + TdM;
			 TeM = TdM - TdL;
		    }
		    {
			 E T5p, T5u, T8h, T8i;
			 T5p = T5h + T5o;
			 T5u = T5q - T5t;
			 T5v = FNMS(KP195090322, T5u, KP980785280 * T5p);
			 T5I = FMA(KP195090322, T5p, KP980785280 * T5u);
			 T8h = T5h - T5o;
			 T8i = T5t + T5q;
			 T8j = FNMS(KP555570233, T8i, KP831469612 * T8h);
			 T8q = FMA(KP555570233, T8h, KP831469612 * T8i);
		    }
		    TdC = FMA(KP923879532, TdA, KP382683432 * TdB);
		    TdF = FNMS(KP382683432, TdE, KP923879532 * TdD);
		    TdG = TdC + TdF;
		    TeO = TdF - TdC;
		    {
			 E T8e, T8f, Tb2, Tb9;
			 T8e = T50 - T57;
			 T8f = T5c + T59;
			 T8g = FMA(KP831469612, T8e, KP555570233 * T8f);
			 T8p = FNMS(KP555570233, T8e, KP831469612 * T8f);
			 Tb2 = TaY - Tb1;
			 Tb9 = Tb5 - Tb8;
			 Tba = KP707106781 * (Tb2 + Tb9);
			 Tbj = KP707106781 * (Tb9 - Tb2);
		    }
	       }
	       {
		    E T11, TbV, Tc9, Tcf, T22, Tcb, Tc2, Tce;
		    {
			 E Tv, T10, Tc5, Tc8;
			 Tv = Tf + Tu;
			 T10 = TK + TZ;
			 T11 = Tv + T10;
			 TbV = Tv - T10;
			 Tc5 = Tc3 + Tc4;
			 Tc8 = Tc6 + Tc7;
			 Tc9 = Tc5 - Tc8;
			 Tcf = Tc5 + Tc8;
		    }
		    {
			 E T1w, T21, TbY, Tc1;
			 T1w = T1g + T1v;
			 T21 = T1L + T20;
			 T22 = T1w + T21;
			 Tcb = T21 - T1w;
			 TbY = TbW + TbX;
			 Tc1 = TbZ + Tc0;
			 Tc2 = TbY - Tc1;
			 Tce = TbY + Tc1;
		    }
		    Cr[WS(csr, 32)] = T11 - T22;
		    Ci[WS(csi, 32)] = Tcf - Tce;
		    {
			 E Tca, Tcc, Tcd, Tcg;
			 Tca = KP707106781 * (Tc2 + Tc9);
			 Cr[WS(csr, 48)] = TbV - Tca;
			 Cr[WS(csr, 16)] = TbV + Tca;
			 Tcc = KP707106781 * (Tc9 - Tc2);
			 Ci[WS(csi, 16)] = Tcb + Tcc;
			 Ci[WS(csi, 48)] = Tcc - Tcb;
			 Tcd = T11 + T22;
			 Tcg = Tce + Tcf;
			 Cr[WS(csr, 64)] = Tcd - Tcg;
			 Cr[0] = Tcd + Tcg;
		    }
	       }
	       {
		    E Tch, Tcu, Tck, Tct, Tco, Tcy, Tcr, Tcz, Tci, Tcj;
		    Tch = Tf - Tu;
		    Tcu = TZ - TK;
		    Tci = T1g - T1v;
		    Tcj = T1L - T20;
		    Tck = KP707106781 * (Tci + Tcj);
		    Tct = KP707106781 * (Tcj - Tci);
		    {
			 E Tcm, Tcn, Tcp, Tcq;
			 Tcm = TbW - TbX;
			 Tcn = Tc0 - TbZ;
			 Tco = FMA(KP923879532, Tcm, KP382683432 * Tcn);
			 Tcy = FNMS(KP382683432, Tcm, KP923879532 * Tcn);
			 Tcp = Tc3 - Tc4;
			 Tcq = Tc7 - Tc6;
			 Tcr = FNMS(KP382683432, Tcq, KP923879532 * Tcp);
			 Tcz = FMA(KP382683432, Tcp, KP923879532 * Tcq);
		    }
		    {
			 E Tcl, Tcs, Tcx, TcA;
			 Tcl = Tch + Tck;
			 Tcs = Tco + Tcr;
			 Cr[WS(csr, 56)] = Tcl - Tcs;
			 Cr[WS(csr, 8)] = Tcl + Tcs;
			 Tcx = Tcu + Tct;
			 TcA = Tcy + Tcz;
			 Ci[WS(csi, 8)] = Tcx + TcA;
			 Ci[WS(csi, 56)] = TcA - Tcx;
		    }
		    {
			 E Tcv, Tcw, TcB, TcC;
			 Tcv = Tct - Tcu;
			 Tcw = Tcr - Tco;
			 Ci[WS(csi, 24)] = Tcv + Tcw;
			 Ci[WS(csi, 40)] = Tcw - Tcv;
			 TcB = Tch - Tck;
			 TcC = Tcz - Tcy;
			 Cr[WS(csr, 40)] = TcB - TcC;
			 Cr[WS(csr, 24)] = TcB + TcC;
		    }
	       }
	       {
		    E Ta9, TbB, Tbs, TbM, Tag, TbL, TbJ, TbR, TaO, Tbw, Tbp, TbC, TbG, TbQ, Tbl;
		    E Tbx, Ta8, Tbr;
		    Ta8 = KP707106781 * (Ta6 + Ta7);
		    Ta9 = Ta5 + Ta8;
		    TbB = Ta5 - Ta8;
		    Tbr = KP707106781 * (Ta7 - Ta6);
		    Tbs = Tbq + Tbr;
		    TbM = Tbr - Tbq;
		    {
			 E Tac, Taf, TbH, TbI;
			 Tac = FMA(KP923879532, Taa, KP382683432 * Tab);
			 Taf = FNMS(KP382683432, Tae, KP923879532 * Tad);
			 Tag = Tac + Taf;
			 TbL = Taf - Tac;
			 TbH = TaV - Tba;
			 TbI = Tbj - Tbi;
			 TbJ = FNMS(KP555570233, TbI, KP831469612 * TbH);
			 TbR = FMA(KP555570233, TbH, KP831469612 * TbI);
		    }
		    {
			 E TaE, TaN, Tbn, Tbo;
			 TaE = Tao + TaD;
			 TaN = TaL + TaM;
			 TaO = FMA(KP980785280, TaE, KP195090322 * TaN);
			 Tbw = FNMS(KP195090322, TaE, KP980785280 * TaN);
			 Tbn = FNMS(KP382683432, Taa, KP923879532 * Tab);
			 Tbo = FMA(KP382683432, Tad, KP923879532 * Tae);
			 Tbp = Tbn + Tbo;
			 TbC = Tbo - Tbn;
		    }
		    {
			 E TbE, TbF, Tbb, Tbk;
			 TbE = Tao - TaD;
			 TbF = TaM - TaL;
			 TbG = FMA(KP831469612, TbE, KP555570233 * TbF);
			 TbQ = FNMS(KP555570233, TbE, KP831469612 * TbF);
			 Tbb = TaV + Tba;
			 Tbk = Tbi + Tbj;
			 Tbl = FNMS(KP195090322, Tbk, KP980785280 * Tbb);
			 Tbx = FMA(KP195090322, Tbb, KP980785280 * Tbk);
		    }
		    {
			 E Tah, Tbm, Tbv, Tby;
			 Tah = Ta9 + Tag;
			 Tbm = TaO + Tbl;
			 Cr[WS(csr, 60)] = Tah - Tbm;
			 Cr[WS(csr, 4)] = Tah + Tbm;
			 Tbv = Tbs + Tbp;
			 Tby = Tbw + Tbx;
			 Ci[WS(csi, 4)] = Tbv + Tby;
			 Ci[WS(csi, 60)] = Tby - Tbv;
		    }
		    {
			 E Tbt, Tbu, Tbz, TbA;
			 Tbt = Tbp - Tbs;
			 Tbu = Tbl - TaO;
			 Ci[WS(csi, 28)] = Tbt + Tbu;
			 Ci[WS(csi, 36)] = Tbu - Tbt;
			 Tbz = Ta9 - Tag;
			 TbA = Tbx - Tbw;
			 Cr[WS(csr, 36)] = Tbz - TbA;
			 Cr[WS(csr, 28)] = Tbz + TbA;
		    }
		    {
			 E TbD, TbK, TbP, TbS;
			 TbD = TbB + TbC;
			 TbK = TbG + TbJ;
			 Cr[WS(csr, 52)] = TbD - TbK;
			 Cr[WS(csr, 12)] = TbD + TbK;
			 TbP = TbM + TbL;
			 TbS = TbQ + TbR;
			 Ci[WS(csi, 12)] = TbP + TbS;
			 Ci[WS(csi, 52)] = TbS - TbP;
		    }
		    {
			 E TbN, TbO, TbT, TbU;
			 TbN = TbL - TbM;
			 TbO = TbJ - TbG;
			 Ci[WS(csi, 20)] = TbN + TbO;
			 Ci[WS(csi, 44)] = TbO - TbN;
			 TbT = TbB - TbC;
			 TbU = TbR - TbQ;
			 Cr[WS(csr, 44)] = TbT - TbU;
			 Cr[WS(csr, 20)] = TbT + TbU;
		    }
	       }
	       {
		    E Tev, Tf7, Tfc, Tfm, Tff, Tfn, TeC, Tfh, TeK, Tf2, TeV, Tf8, TeY, Tfi, TeR;
		    E Tf3;
		    {
			 E Tet, Teu, Tfa, Tfb;
			 Tet = TcD - TcG;
			 Teu = TdY - TdX;
			 Tev = Tet - Teu;
			 Tf7 = Tet + Teu;
			 Tfa = TeF + TeE;
			 Tfb = TeH + TeI;
			 Tfc = FMA(KP290284677, Tfa, KP956940335 * Tfb);
			 Tfm = FNMS(KP290284677, Tfb, KP956940335 * Tfa);
		    }
		    {
			 E Tfd, Tfe, Tey, TeB;
			 Tfd = TeL + TeM;
			 Tfe = TeP + TeO;
			 Tff = FNMS(KP290284677, Tfe, KP956940335 * Tfd);
			 Tfn = FMA(KP956940335, Tfe, KP290284677 * Tfd);
			 Tey = FMA(KP555570233, Tew, KP831469612 * Tex);
			 TeB = FNMS(KP555570233, TeA, KP831469612 * Tez);
			 TeC = Tey - TeB;
			 Tfh = TeB + Tey;
		    }
		    {
			 E TeG, TeJ, TeT, TeU;
			 TeG = TeE - TeF;
			 TeJ = TeH - TeI;
			 TeK = FMA(KP471396736, TeG, KP881921264 * TeJ);
			 Tf2 = FNMS(KP471396736, TeJ, KP881921264 * TeG);
			 TeT = FNMS(KP555570233, Tex, KP831469612 * Tew);
			 TeU = FMA(KP831469612, TeA, KP555570233 * Tez);
			 TeV = TeT - TeU;
			 Tf8 = TeU + TeT;
		    }
		    {
			 E TeW, TeX, TeN, TeQ;
			 TeW = TcN - TcK;
			 TeX = TdV - TdU;
			 TeY = TeW - TeX;
			 Tfi = TeX + TeW;
			 TeN = TeL - TeM;
			 TeQ = TeO - TeP;
			 TeR = FNMS(KP471396736, TeQ, KP881921264 * TeN);
			 Tf3 = FMA(KP881921264, TeQ, KP471396736 * TeN);
		    }
		    {
			 E TeD, TeS, Tf1, Tf4;
			 TeD = Tev + TeC;
			 TeS = TeK + TeR;
			 Cr[WS(csr, 54)] = TeD - TeS;
			 Cr[WS(csr, 10)] = TeD + TeS;
			 Tf1 = TeY + TeV;
			 Tf4 = Tf2 + Tf3;
			 Ci[WS(csi, 10)] = Tf1 + Tf4;
			 Ci[WS(csi, 54)] = Tf4 - Tf1;
		    }
		    {
			 E TeZ, Tf0, Tf5, Tf6;
			 TeZ = TeV - TeY;
			 Tf0 = TeR - TeK;
			 Ci[WS(csi, 22)] = TeZ + Tf0;
			 Ci[WS(csi, 42)] = Tf0 - TeZ;
			 Tf5 = Tev - TeC;
			 Tf6 = Tf3 - Tf2;
			 Cr[WS(csr, 42)] = Tf5 - Tf6;
			 Cr[WS(csr, 22)] = Tf5 + Tf6;
		    }
		    {
			 E Tf9, Tfg, Tfl, Tfo;
			 Tf9 = Tf7 + Tf8;
			 Tfg = Tfc + Tff;
			 Cr[WS(csr, 58)] = Tf9 - Tfg;
			 Cr[WS(csr, 6)] = Tf9 + Tfg;
			 Tfl = Tfi + Tfh;
			 Tfo = Tfm + Tfn;
			 Ci[WS(csi, 6)] = Tfl + Tfo;
			 Ci[WS(csi, 58)] = Tfo - Tfl;
		    }
		    {
			 E Tfj, Tfk, Tfp, Tfq;
			 Tfj = Tfh - Tfi;
			 Tfk = Tff - Tfc;
			 Ci[WS(csi, 26)] = Tfj + Tfk;
			 Ci[WS(csi, 38)] = Tfk - Tfj;
			 Tfp = Tf7 - Tf8;
			 Tfq = Tfn - Tfm;
			 Cr[WS(csr, 38)] = Tfp - Tfq;
			 Cr[WS(csr, 26)] = Tfp + Tfq;
		    }
	       }
	       {
		    E TcP, Te9, Tee, Teo, Teh, Tep, Td8, Tej, Tdu, Te4, TdT, Tea, Te0, Tek, TdP;
		    E Te5;
		    {
			 E TcH, TcO, Tec, Ted;
			 TcH = TcD + TcG;
			 TcO = TcK + TcN;
			 TcP = TcH + TcO;
			 Te9 = TcH - TcO;
			 Tec = Tde - Tdl;
			 Ted = Tds - Tdp;
			 Tee = FMA(KP773010453, Tec, KP634393284 * Ted);
			 Teo = FNMS(KP634393284, Tec, KP773010453 * Ted);
		    }
		    {
			 E Tef, Teg, TcY, Td7;
			 Tef = Tdz - TdG;
			 Teg = TdN - TdK;
			 Teh = FNMS(KP634393284, Teg, KP773010453 * Tef);
			 Tep = FMA(KP634393284, Tef, KP773010453 * Teg);
			 TcY = FMA(KP980785280, TcU, KP195090322 * TcX);
			 Td7 = FNMS(KP195090322, Td6, KP980785280 * Td3);
			 Td8 = TcY + Td7;
			 Tej = Td7 - TcY;
		    }
		    {
			 E Tdm, Tdt, TdR, TdS;
			 Tdm = Tde + Tdl;
			 Tdt = Tdp + Tds;
			 Tdu = FMA(KP995184726, Tdm, KP098017140 * Tdt);
			 Te4 = FNMS(KP098017140, Tdm, KP995184726 * Tdt);
			 TdR = FNMS(KP195090322, TcU, KP980785280 * TcX);
			 TdS = FMA(KP195090322, Td3, KP980785280 * Td6);
			 TdT = TdR + TdS;
			 Tea = TdS - TdR;
		    }
		    {
			 E TdW, TdZ, TdH, TdO;
			 TdW = TdU + TdV;
			 TdZ = TdX + TdY;
			 Te0 = TdW + TdZ;
			 Tek = TdZ - TdW;
			 TdH = Tdz + TdG;
			 TdO = TdK + TdN;
			 TdP = FNMS(KP098017140, TdO, KP995184726 * TdH);
			 Te5 = FMA(KP098017140, TdH, KP995184726 * TdO);
		    }
		    {
			 E Td9, TdQ, Te3, Te6;
			 Td9 = TcP + Td8;
			 TdQ = Tdu + TdP;
			 Cr[WS(csr, 62)] = Td9 - TdQ;
			 Cr[WS(csr, 2)] = Td9 + TdQ;
			 Te3 = Te0 + TdT;
			 Te6 = Te4 + Te5;
			 Ci[WS(csi, 2)] = Te3 + Te6;
			 Ci[WS(csi, 62)] = Te6 - Te3;
		    }
		    {
			 E Te1, Te2, Te7, Te8;
			 Te1 = TdT - Te0;
			 Te2 = TdP - Tdu;
			 Ci[WS(csi, 30)] = Te1 + Te2;
			 Ci[WS(csi, 34)] = Te2 - Te1;
			 Te7 = TcP - Td8;
			 Te8 = Te5 - Te4;
			 Cr[WS(csr, 34)] = Te7 - Te8;
			 Cr[WS(csr, 30)] = Te7 + Te8;
		    }
		    {
			 E Teb, Tei, Ten, Teq;
			 Teb = Te9 + Tea;
			 Tei = Tee + Teh;
			 Cr[WS(csr, 50)] = Teb - Tei;
			 Cr[WS(csr, 14)] = Teb + Tei;
			 Ten = Tek + Tej;
			 Teq = Teo + Tep;
			 Ci[WS(csi, 14)] = Ten + Teq;
			 Ci[WS(csi, 50)] = Teq - Ten;
		    }
		    {
			 E Tel, Tem, Ter, Tes;
			 Tel = Tej - Tek;
			 Tem = Teh - Tee;
			 Ci[WS(csi, 18)] = Tel + Tem;
			 Ci[WS(csi, 46)] = Tem - Tel;
			 Ter = Te9 - Tea;
			 Tes = Tep - Teo;
			 Cr[WS(csr, 46)] = Ter - Tes;
			 Cr[WS(csr, 18)] = Ter + Tes;
		    }
	       }
	       {
		    E T6v, T77, T6C, T7h, T6Y, T7i, T6V, T78, T6R, T7n, T73, T7f, T6K, T7m, T72;
		    E T7c;
		    {
			 E T6t, T6u, T6T, T6U;
			 T6t = T27 - T2e;
			 T6u = T5Y - T5X;
			 T6v = T6t - T6u;
			 T77 = T6t + T6u;
			 {
			      E T6y, T6B, T6W, T6X;
			      T6y = FMA(KP773010453, T6w, KP634393284 * T6x);
			      T6B = FNMS(KP634393284, T6A, KP773010453 * T6z);
			      T6C = T6y - T6B;
			      T7h = T6B + T6y;
			      T6W = T2x - T2o;
			      T6X = T5V - T5S;
			      T6Y = T6W - T6X;
			      T7i = T6X + T6W;
			 }
			 T6T = FNMS(KP634393284, T6w, KP773010453 * T6x);
			 T6U = FMA(KP634393284, T6z, KP773010453 * T6A);
			 T6V = T6T - T6U;
			 T78 = T6U + T6T;
			 {
			      E T6N, T7d, T6Q, T7e, T6M, T6O;
			      T6M = T5I - T5H;
			      T6N = T6L - T6M;
			      T7d = T6L + T6M;
			      T6O = T5v - T5e;
			      T6Q = T6O - T6P;
			      T7e = T6P + T6O;
			      T6R = FNMS(KP427555093, T6Q, KP903989293 * T6N);
			      T7n = FMA(KP941544065, T7e, KP336889853 * T7d);
			      T73 = FMA(KP903989293, T6Q, KP427555093 * T6N);
			      T7f = FNMS(KP336889853, T7e, KP941544065 * T7d);
			 }
			 {
			      E T6G, T7a, T6J, T7b, T6E, T6I;
			      T6E = T4g - T3Z;
			      T6G = T6E - T6F;
			      T7a = T6F + T6E;
			      T6I = T4t - T4s;
			      T6J = T6H - T6I;
			      T7b = T6H + T6I;
			      T6K = FMA(KP427555093, T6G, KP903989293 * T6J);
			      T7m = FNMS(KP336889853, T7b, KP941544065 * T7a);
			      T72 = FNMS(KP427555093, T6J, KP903989293 * T6G);
			      T7c = FMA(KP336889853, T7a, KP941544065 * T7b);
			 }
		    }
		    {
			 E T6D, T6S, T71, T74;
			 T6D = T6v + T6C;
			 T6S = T6K + T6R;
			 Cr[WS(csr, 55)] = T6D - T6S;
			 Cr[WS(csr, 9)] = T6D + T6S;
			 T71 = T6Y + T6V;
			 T74 = T72 + T73;
			 Ci[WS(csi, 9)] = T71 + T74;
			 Ci[WS(csi, 55)] = T74 - T71;
		    }
		    {
			 E T6Z, T70, T75, T76;
			 T6Z = T6V - T6Y;
			 T70 = T6R - T6K;
			 Ci[WS(csi, 23)] = T6Z + T70;
			 Ci[WS(csi, 41)] = T70 - T6Z;
			 T75 = T6v - T6C;
			 T76 = T73 - T72;
			 Cr[WS(csr, 41)] = T75 - T76;
			 Cr[WS(csr, 23)] = T75 + T76;
		    }
		    {
			 E T79, T7g, T7l, T7o;
			 T79 = T77 + T78;
			 T7g = T7c + T7f;
			 Cr[WS(csr, 57)] = T79 - T7g;
			 Cr[WS(csr, 7)] = T79 + T7g;
			 T7l = T7i + T7h;
			 T7o = T7m + T7n;
			 Ci[WS(csi, 7)] = T7l + T7o;
			 Ci[WS(csi, 57)] = T7o - T7l;
		    }
		    {
			 E T7j, T7k, T7p, T7q;
			 T7j = T7h - T7i;
			 T7k = T7f - T7c;
			 Ci[WS(csi, 25)] = T7j + T7k;
			 Ci[WS(csi, 39)] = T7k - T7j;
			 T7p = T77 - T78;
			 T7q = T7n - T7m;
			 Cr[WS(csr, 39)] = T7p - T7q;
			 Cr[WS(csr, 25)] = T7p + T7q;
		    }
	       }
	       {
		    E T99, T9L, T9g, T9V, T9C, T9W, T9z, T9M, T9v, Ta1, T9H, T9T, T9o, Ta0, T9G;
		    E T9Q;
		    {
			 E T97, T98, T9x, T9y;
			 T97 = T7r - T7s;
			 T98 = T8C - T8B;
			 T99 = T97 - T98;
			 T9L = T97 + T98;
			 {
			      E T9c, T9f, T9A, T9B;
			      T9c = FMA(KP471396736, T9a, KP881921264 * T9b);
			      T9f = FNMS(KP471396736, T9e, KP881921264 * T9d);
			      T9g = T9c - T9f;
			      T9V = T9f + T9c;
			      T9A = T7z - T7w;
			      T9B = T8z - T8y;
			      T9C = T9A - T9B;
			      T9W = T9B + T9A;
			 }
			 T9x = FNMS(KP471396736, T9b, KP881921264 * T9a);
			 T9y = FMA(KP881921264, T9e, KP471396736 * T9d);
			 T9z = T9x - T9y;
			 T9M = T9y + T9x;
			 {
			      E T9r, T9R, T9u, T9S, T9q, T9s;
			      T9q = T8q - T8p;
			      T9r = T9p - T9q;
			      T9R = T9p + T9q;
			      T9s = T8j - T8g;
			      T9u = T9s - T9t;
			      T9S = T9t + T9s;
			      T9v = FNMS(KP514102744, T9u, KP857728610 * T9r);
			      Ta1 = FMA(KP970031253, T9S, KP242980179 * T9R);
			      T9H = FMA(KP857728610, T9u, KP514102744 * T9r);
			      T9T = FNMS(KP242980179, T9S, KP970031253 * T9R);
			 }
			 {
			      E T9k, T9O, T9n, T9P, T9i, T9m;
			      T9i = T80 - T7X;
			      T9k = T9i - T9j;
			      T9O = T9j + T9i;
			      T9m = T87 - T86;
			      T9n = T9l - T9m;
			      T9P = T9l + T9m;
			      T9o = FMA(KP514102744, T9k, KP857728610 * T9n);
			      Ta0 = FNMS(KP242980179, T9P, KP970031253 * T9O);
			      T9G = FNMS(KP514102744, T9n, KP857728610 * T9k);
			      T9Q = FMA(KP242980179, T9O, KP970031253 * T9P);
			 }
		    }
		    {
			 E T9h, T9w, T9F, T9I;
			 T9h = T99 + T9g;
			 T9w = T9o + T9v;
			 Cr[WS(csr, 53)] = T9h - T9w;
			 Cr[WS(csr, 11)] = T9h + T9w;
			 T9F = T9C + T9z;
			 T9I = T9G + T9H;
			 Ci[WS(csi, 11)] = T9F + T9I;
			 Ci[WS(csi, 53)] = T9I - T9F;
		    }
		    {
			 E T9D, T9E, T9J, T9K;
			 T9D = T9z - T9C;
			 T9E = T9v - T9o;
			 Ci[WS(csi, 21)] = T9D + T9E;
			 Ci[WS(csi, 43)] = T9E - T9D;
			 T9J = T99 - T9g;
			 T9K = T9H - T9G;
			 Cr[WS(csr, 43)] = T9J - T9K;
			 Cr[WS(csr, 21)] = T9J + T9K;
		    }
		    {
			 E T9N, T9U, T9Z, Ta2;
			 T9N = T9L + T9M;
			 T9U = T9Q + T9T;
			 Cr[WS(csr, 59)] = T9N - T9U;
			 Cr[WS(csr, 5)] = T9N + T9U;
			 T9Z = T9W + T9V;
			 Ta2 = Ta0 + Ta1;
			 Ci[WS(csi, 5)] = T9Z + Ta2;
			 Ci[WS(csi, 59)] = Ta2 - T9Z;
		    }
		    {
			 E T9X, T9Y, Ta3, Ta4;
			 T9X = T9V - T9W;
			 T9Y = T9T - T9Q;
			 Ci[WS(csi, 27)] = T9X + T9Y;
			 Ci[WS(csi, 37)] = T9Y - T9X;
			 Ta3 = T9L - T9M;
			 Ta4 = Ta1 - Ta0;
			 Cr[WS(csr, 37)] = Ta3 - Ta4;
			 Cr[WS(csr, 27)] = Ta3 + Ta4;
		    }
	       }
	       {
		    E T2z, T69, T3g, T6j, T60, T6k, T5P, T6a, T5L, T6p, T65, T6h, T4w, T6o, T64;
		    E T6e;
		    {
			 E T2f, T2y, T5N, T5O;
			 T2f = T27 + T2e;
			 T2y = T2o + T2x;
			 T2z = T2f + T2y;
			 T69 = T2f - T2y;
			 {
			      E T2U, T3f, T5W, T5Z;
			      T2U = FMA(KP098017140, T2M, KP995184726 * T2T);
			      T3f = FNMS(KP098017140, T3e, KP995184726 * T37);
			      T3g = T2U + T3f;
			      T6j = T3f - T2U;
			      T5W = T5S + T5V;
			      T5Z = T5X + T5Y;
			      T60 = T5W + T5Z;
			      T6k = T5Z - T5W;
			 }
			 T5N = FNMS(KP098017140, T2T, KP995184726 * T2M);
			 T5O = FMA(KP995184726, T3e, KP098017140 * T37);
			 T5P = T5N + T5O;
			 T6a = T5O - T5N;
			 {
			      E T5x, T6f, T5K, T6g, T5w, T5J;
			      T5w = T5e + T5v;
			      T5x = T4X + T5w;
			      T6f = T4X - T5w;
			      T5J = T5H + T5I;
			      T5K = T5G + T5J;
			      T6g = T5J - T5G;
			      T5L = FNMS(KP049067674, T5K, KP998795456 * T5x);
			      T6p = FMA(KP671558954, T6f, KP740951125 * T6g);
			      T65 = FMA(KP049067674, T5x, KP998795456 * T5K);
			      T6h = FNMS(KP671558954, T6g, KP740951125 * T6f);
			 }
			 {
			      E T4i, T6c, T4v, T6d, T4h, T4u;
			      T4h = T3Z + T4g;
			      T4i = T3I + T4h;
			      T6c = T3I - T4h;
			      T4u = T4s + T4t;
			      T4v = T4r + T4u;
			      T6d = T4u - T4r;
			      T4w = FMA(KP998795456, T4i, KP049067674 * T4v);
			      T6o = FNMS(KP671558954, T6c, KP740951125 * T6d);
			      T64 = FNMS(KP049067674, T4i, KP998795456 * T4v);
			      T6e = FMA(KP740951125, T6c, KP671558954 * T6d);
			 }
		    }
		    {
			 E T3h, T5M, T63, T66;
			 T3h = T2z + T3g;
			 T5M = T4w + T5L;
			 Cr[WS(csr, 63)] = T3h - T5M;
			 Cr[WS(csr, 1)] = T3h + T5M;
			 T63 = T60 + T5P;
			 T66 = T64 + T65;
			 Ci[WS(csi, 1)] = T63 + T66;
			 Ci[WS(csi, 63)] = T66 - T63;
		    }
		    {
			 E T61, T62, T67, T68;
			 T61 = T5P - T60;
			 T62 = T5L - T4w;
			 Ci[WS(csi, 31)] = T61 + T62;
			 Ci[WS(csi, 33)] = T62 - T61;
			 T67 = T2z - T3g;
			 T68 = T65 - T64;
			 Cr[WS(csr, 33)] = T67 - T68;
			 Cr[WS(csr, 31)] = T67 + T68;
		    }
		    {
			 E T6b, T6i, T6n, T6q;
			 T6b = T69 + T6a;
			 T6i = T6e + T6h;
			 Cr[WS(csr, 49)] = T6b - T6i;
			 Cr[WS(csr, 15)] = T6b + T6i;
			 T6n = T6k + T6j;
			 T6q = T6o + T6p;
			 Ci[WS(csi, 15)] = T6n + T6q;
			 Ci[WS(csi, 49)] = T6q - T6n;
		    }
		    {
			 E T6l, T6m, T6r, T6s;
			 T6l = T6j - T6k;
			 T6m = T6h - T6e;
			 Ci[WS(csi, 17)] = T6l + T6m;
			 Ci[WS(csi, 47)] = T6m - T6l;
			 T6r = T69 - T6a;
			 T6s = T6p - T6o;
			 Cr[WS(csr, 47)] = T6r - T6s;
			 Cr[WS(csr, 17)] = T6r + T6s;
		    }
	       }
	       {
		    E T7B, T8N, T7Q, T8X, T8E, T8Y, T8x, T8O, T8t, T93, T8J, T8V, T8a, T92, T8I;
		    E T8S;
		    {
			 E T7t, T7A, T8v, T8w;
			 T7t = T7r + T7s;
			 T7A = T7w + T7z;
			 T7B = T7t + T7A;
			 T8N = T7t - T7A;
			 {
			      E T7I, T7P, T8A, T8D;
			      T7I = FMA(KP956940335, T7E, KP290284677 * T7H);
			      T7P = FNMS(KP290284677, T7O, KP956940335 * T7L);
			      T7Q = T7I + T7P;
			      T8X = T7P - T7I;
			      T8A = T8y + T8z;
			      T8D = T8B + T8C;
			      T8E = T8A + T8D;
			      T8Y = T8D - T8A;
			 }
			 T8v = FNMS(KP290284677, T7E, KP956940335 * T7H);
			 T8w = FMA(KP290284677, T7L, KP956940335 * T7O);
			 T8x = T8v + T8w;
			 T8O = T8w - T8v;
			 {
			      E T8l, T8T, T8s, T8U, T8k, T8r;
			      T8k = T8g + T8j;
			      T8l = T8d + T8k;
			      T8T = T8d - T8k;
			      T8r = T8p + T8q;
			      T8s = T8o + T8r;
			      T8U = T8r - T8o;
			      T8t = FNMS(KP146730474, T8s, KP989176509 * T8l);
			      T93 = FMA(KP595699304, T8T, KP803207531 * T8U);
			      T8J = FMA(KP146730474, T8l, KP989176509 * T8s);
			      T8V = FNMS(KP595699304, T8U, KP803207531 * T8T);
			 }
			 {
			      E T82, T8Q, T89, T8R, T81, T88;
			      T81 = T7X + T80;
			      T82 = T7U + T81;
			      T8Q = T7U - T81;
			      T88 = T86 + T87;
			      T89 = T85 + T88;
			      T8R = T88 - T85;
			      T8a = FMA(KP989176509, T82, KP146730474 * T89);
			      T92 = FNMS(KP595699304, T8Q, KP803207531 * T8R);
			      T8I = FNMS(KP146730474, T82, KP989176509 * T89);
			      T8S = FMA(KP803207531, T8Q, KP595699304 * T8R);
			 }
		    }
		    {
			 E T7R, T8u, T8H, T8K;
			 T7R = T7B + T7Q;
			 T8u = T8a + T8t;
			 Cr[WS(csr, 61)] = T7R - T8u;
			 Cr[WS(csr, 3)] = T7R + T8u;
			 T8H = T8E + T8x;
			 T8K = T8I + T8J;
			 Ci[WS(csi, 3)] = T8H + T8K;
			 Ci[WS(csi, 61)] = T8K - T8H;
		    }
		    {
			 E T8F, T8G, T8L, T8M;
			 T8F = T8x - T8E;
			 T8G = T8t - T8a;
			 Ci[WS(csi, 29)] = T8F + T8G;
			 Ci[WS(csi, 35)] = T8G - T8F;
			 T8L = T7B - T7Q;
			 T8M = T8J - T8I;
			 Cr[WS(csr, 35)] = T8L - T8M;
			 Cr[WS(csr, 29)] = T8L + T8M;
		    }
		    {
			 E T8P, T8W, T91, T94;
			 T8P = T8N + T8O;
			 T8W = T8S + T8V;
			 Cr[WS(csr, 51)] = T8P - T8W;
			 Cr[WS(csr, 13)] = T8P + T8W;
			 T91 = T8Y + T8X;
			 T94 = T92 + T93;
			 Ci[WS(csi, 13)] = T91 + T94;
			 Ci[WS(csi, 51)] = T94 - T91;
		    }
		    {
			 E T8Z, T90, T95, T96;
			 T8Z = T8X - T8Y;
			 T90 = T8V - T8S;
			 Ci[WS(csi, 19)] = T8Z + T90;
			 Ci[WS(csi, 45)] = T90 - T8Z;
			 T95 = T8N - T8O;
			 T96 = T93 - T92;
			 Cr[WS(csr, 45)] = T95 - T96;
			 Cr[WS(csr, 19)] = T95 + T96;
		    }
	       }
	  }
     }
}

static const kr2c_desc desc = { 128, "r2cf_128", {812, 186, 144, 0}, &GENUS };

void X(codelet_r2cf_128) (planner *p) {
     X(kr2c_register) (p, r2cf_128, &desc);
}

#endif
