###########################################################
# file: nl80211.py
# ---------------------------------------------------------
# This file is generated using extract.py using pycparser
###########################################################
NL80211_GENL_FAMILY = "nl80211"

NL80211_CMD_UNSPEC = 0
NL80211_CMD_GET_WIPHY = 1
NL80211_CMD_SET_WIPHY = 2
NL80211_CMD_NEW_WIPHY = 3
NL80211_CMD_DEL_WIPHY = 4
NL80211_CMD_GET_INTERFACE = 5
NL80211_CMD_SET_INTERFACE = 6
NL80211_CMD_NEW_INTERFACE = 7
NL80211_CMD_DEL_INTERFACE = 8
NL80211_CMD_GET_KEY = 9
NL80211_CMD_SET_KEY = 10
NL80211_CMD_NEW_KEY = 11
NL80211_CMD_DEL_KEY = 12
NL80211_CMD_GET_BEACON = 13
NL80211_CMD_SET_BEACON = 14
NL80211_CMD_START_AP = 15
NL80211_CMD_NEW_BEACON = NL80211_CMD_START_AP
NL80211_CMD_STOP_AP = 16
NL80211_CMD_DEL_BEACON = NL80211_CMD_STOP_AP
NL80211_CMD_GET_STATION = 17
NL80211_CMD_SET_STATION = 18
NL80211_CMD_NEW_STATION = 19
NL80211_CMD_DEL_STATION = 20
NL80211_CMD_GET_MPATH = 21
NL80211_CMD_SET_MPATH = 22
NL80211_CMD_NEW_MPATH = 23
NL80211_CMD_DEL_MPATH = 24
NL80211_CMD_SET_BSS = 25
NL80211_CMD_SET_REG = 26
NL80211_CMD_REQ_SET_REG = 27
NL80211_CMD_GET_MESH_CONFIG = 28
NL80211_CMD_SET_MESH_CONFIG = 29
NL80211_CMD_SET_MGMT_EXTRA_IE = 30
NL80211_CMD_GET_REG = 31
NL80211_CMD_GET_SCAN = 32
NL80211_CMD_TRIGGER_SCAN = 33
NL80211_CMD_NEW_SCAN_RESULTS = 34
NL80211_CMD_SCAN_ABORTED = 35
NL80211_CMD_REG_CHANGE = 36
NL80211_CMD_AUTHENTICATE = 37
NL80211_CMD_ASSOCIATE = 38
NL80211_CMD_DEAUTHENTICATE = 39
NL80211_CMD_DISASSOCIATE = 40
NL80211_CMD_MICHAEL_MIC_FAILURE = 41
NL80211_CMD_REG_BEACON_HINT = 42
NL80211_CMD_JOIN_IBSS = 43
NL80211_CMD_LEAVE_IBSS = 44
NL80211_CMD_TESTMODE = 45
NL80211_CMD_CONNECT = 46
NL80211_CMD_ROAM = 47
NL80211_CMD_DISCONNECT = 48
NL80211_CMD_SET_WIPHY_NETNS = 49
NL80211_CMD_GET_SURVEY = 50
NL80211_CMD_NEW_SURVEY_RESULTS = 51
NL80211_CMD_SET_PMKSA = 52
NL80211_CMD_DEL_PMKSA = 53
NL80211_CMD_FLUSH_PMKSA = 54
NL80211_CMD_REMAIN_ON_CHANNEL = 55
NL80211_CMD_CANCEL_REMAIN_ON_CHANNEL = 56
NL80211_CMD_SET_TX_BITRATE_MASK = 57
NL80211_CMD_REGISTER_FRAME = 58
NL80211_CMD_REGISTER_ACTION = NL80211_CMD_REGISTER_FRAME
NL80211_CMD_FRAME = 59
NL80211_CMD_ACTION = NL80211_CMD_FRAME
NL80211_CMD_FRAME_TX_STATUS = 60
NL80211_CMD_ACTION_TX_STATUS = NL80211_CMD_FRAME_TX_STATUS
NL80211_CMD_SET_POWER_SAVE = 61
NL80211_CMD_GET_POWER_SAVE = 62
NL80211_CMD_SET_CQM = 63
NL80211_CMD_NOTIFY_CQM = 64
NL80211_CMD_SET_CHANNEL = 65
NL80211_CMD_SET_WDS_PEER = 66
NL80211_CMD_FRAME_WAIT_CANCEL = 67
NL80211_CMD_JOIN_MESH = 68
NL80211_CMD_LEAVE_MESH = 69
NL80211_CMD_UNPROT_DEAUTHENTICATE = 70
NL80211_CMD_UNPROT_DISASSOCIATE = 71
NL80211_CMD_NEW_PEER_CANDIDATE = 72
NL80211_CMD_GET_WOWLAN = 73
NL80211_CMD_SET_WOWLAN = 74
NL80211_CMD_START_SCHED_SCAN = 75
NL80211_CMD_STOP_SCHED_SCAN = 76
NL80211_CMD_SCHED_SCAN_RESULTS = 77
NL80211_CMD_SCHED_SCAN_STOPPED = 78
NL80211_CMD_SET_REKEY_OFFLOAD = 79
NL80211_CMD_PMKSA_CANDIDATE = 80
NL80211_CMD_TDLS_OPER = 81
NL80211_CMD_TDLS_MGMT = 82
NL80211_CMD_UNEXPECTED_FRAME = 83
NL80211_CMD_PROBE_CLIENT = 84
NL80211_CMD_REGISTER_BEACONS = 85
NL80211_CMD_UNEXPECTED_4ADDR_FRAME = 86
NL80211_CMD_SET_NOACK_MAP = 87
NL80211_CMD_CH_SWITCH_NOTIFY = 88
NL80211_CMD_START_P2P_DEVICE = 89
NL80211_CMD_STOP_P2P_DEVICE = 90
NL80211_CMD_CONN_FAILED = 91
NL80211_CMD_SET_MCAST_RATE = 92
NL80211_CMD_SET_MAC_ACL = 93
NL80211_CMD_RADAR_DETECT = 94
NL80211_CMD_GET_PROTOCOL_FEATURES = 95
NL80211_CMD_UPDATE_FT_IES = 96
NL80211_CMD_FT_EVENT = 97
NL80211_CMD_CRIT_PROTOCOL_START = 98
NL80211_CMD_CRIT_PROTOCOL_STOP = 99
__NL80211_CMD_AFTER_LAST = 100
NL80211_CMD_MAX = __NL80211_CMD_AFTER_LAST - 1
NL80211_ATTR_UNSPEC = 0
NL80211_ATTR_WIPHY = 1
NL80211_ATTR_WIPHY_NAME = 2
NL80211_ATTR_IFINDEX = 3
NL80211_ATTR_IFNAME = 4
NL80211_ATTR_IFTYPE = 5
NL80211_ATTR_MAC = 6
NL80211_ATTR_KEY_DATA = 7
NL80211_ATTR_KEY_IDX = 8
NL80211_ATTR_KEY_CIPHER = 9
NL80211_ATTR_KEY_SEQ = 10
NL80211_ATTR_KEY_DEFAULT = 11
NL80211_ATTR_BEACON_INTERVAL = 12
NL80211_ATTR_DTIM_PERIOD = 13
NL80211_ATTR_BEACON_HEAD = 14
NL80211_ATTR_BEACON_TAIL = 15
NL80211_ATTR_STA_AID = 16
NL80211_ATTR_STA_FLAGS = 17
NL80211_ATTR_STA_LISTEN_INTERVAL = 18
NL80211_ATTR_STA_SUPPORTED_RATES = 19
NL80211_ATTR_STA_VLAN = 20
NL80211_ATTR_STA_INFO = 21
NL80211_ATTR_WIPHY_BANDS = 22
NL80211_ATTR_MNTR_FLAGS = 23
NL80211_ATTR_MESH_ID = 24
NL80211_ATTR_STA_PLINK_ACTION = 25
NL80211_ATTR_MPATH_NEXT_HOP = 26
NL80211_ATTR_MPATH_INFO = 27
NL80211_ATTR_BSS_CTS_PROT = 28
NL80211_ATTR_BSS_SHORT_PREAMBLE = 29
NL80211_ATTR_BSS_SHORT_SLOT_TIME = 30
NL80211_ATTR_HT_CAPABILITY = 31
NL80211_ATTR_SUPPORTED_IFTYPES = 32
NL80211_ATTR_REG_ALPHA2 = 33
NL80211_ATTR_REG_RULES = 34
NL80211_ATTR_MESH_CONFIG = 35
NL80211_ATTR_BSS_BASIC_RATES = 36
NL80211_ATTR_WIPHY_TXQ_PARAMS = 37
NL80211_ATTR_WIPHY_FREQ = 38
NL80211_ATTR_WIPHY_CHANNEL_TYPE = 39
NL80211_ATTR_KEY_DEFAULT_MGMT = 40
NL80211_ATTR_MGMT_SUBTYPE = 41
NL80211_ATTR_IE = 42
NL80211_ATTR_MAX_NUM_SCAN_SSIDS = 43
NL80211_ATTR_SCAN_FREQUENCIES = 44
NL80211_ATTR_SCAN_SSIDS = 45
NL80211_ATTR_GENERATION = 46
NL80211_ATTR_BSS = 47
NL80211_ATTR_REG_INITIATOR = 48
NL80211_ATTR_REG_TYPE = 49
NL80211_ATTR_SUPPORTED_COMMANDS = 50
NL80211_ATTR_FRAME = 51
NL80211_ATTR_SSID = 52
NL80211_ATTR_AUTH_TYPE = 53
NL80211_ATTR_REASON_CODE = 54
NL80211_ATTR_KEY_TYPE = 55
NL80211_ATTR_MAX_SCAN_IE_LEN = 56
NL80211_ATTR_CIPHER_SUITES = 57
NL80211_ATTR_FREQ_BEFORE = 58
NL80211_ATTR_FREQ_AFTER = 59
NL80211_ATTR_FREQ_FIXED = 60
NL80211_ATTR_WIPHY_RETRY_SHORT = 61
NL80211_ATTR_WIPHY_RETRY_LONG = 62
NL80211_ATTR_WIPHY_FRAG_THRESHOLD = 63
NL80211_ATTR_WIPHY_RTS_THRESHOLD = 64
NL80211_ATTR_TIMED_OUT = 65
NL80211_ATTR_USE_MFP = 66
NL80211_ATTR_STA_FLAGS2 = 67
NL80211_ATTR_CONTROL_PORT = 68
NL80211_ATTR_TESTDATA = 69
NL80211_ATTR_PRIVACY = 70
NL80211_ATTR_DISCONNECTED_BY_AP = 71
NL80211_ATTR_STATUS_CODE = 72
NL80211_ATTR_CIPHER_SUITES_PAIRWISE = 73
NL80211_ATTR_CIPHER_SUITE_GROUP = 74
NL80211_ATTR_WPA_VERSIONS = 75
NL80211_ATTR_AKM_SUITES = 76
NL80211_ATTR_REQ_IE = 77
NL80211_ATTR_RESP_IE = 78
NL80211_ATTR_PREV_BSSID = 79
NL80211_ATTR_KEY = 80
NL80211_ATTR_KEYS = 81
NL80211_ATTR_PID = 82
NL80211_ATTR_4ADDR = 83
NL80211_ATTR_SURVEY_INFO = 84
NL80211_ATTR_PMKID = 85
NL80211_ATTR_MAX_NUM_PMKIDS = 86
NL80211_ATTR_DURATION = 87
NL80211_ATTR_COOKIE = 88
NL80211_ATTR_WIPHY_COVERAGE_CLASS = 89
NL80211_ATTR_TX_RATES = 90
NL80211_ATTR_FRAME_MATCH = 91
NL80211_ATTR_ACK = 92
NL80211_ATTR_PS_STATE = 93
NL80211_ATTR_CQM = 94
NL80211_ATTR_LOCAL_STATE_CHANGE = 95
NL80211_ATTR_AP_ISOLATE = 96
NL80211_ATTR_WIPHY_TX_POWER_SETTING = 97
NL80211_ATTR_WIPHY_TX_POWER_LEVEL = 98
NL80211_ATTR_TX_FRAME_TYPES = 99
NL80211_ATTR_RX_FRAME_TYPES = 100
NL80211_ATTR_FRAME_TYPE = 101
NL80211_ATTR_CONTROL_PORT_ETHERTYPE = 102
NL80211_ATTR_CONTROL_PORT_NO_ENCRYPT = 103
NL80211_ATTR_SUPPORT_IBSS_RSN = 104
NL80211_ATTR_WIPHY_ANTENNA_TX = 105
NL80211_ATTR_WIPHY_ANTENNA_RX = 106
NL80211_ATTR_MCAST_RATE = 107
NL80211_ATTR_OFFCHANNEL_TX_OK = 108
NL80211_ATTR_BSS_HT_OPMODE = 109
NL80211_ATTR_KEY_DEFAULT_TYPES = 110
NL80211_ATTR_MAX_REMAIN_ON_CHANNEL_DURATION = 111
NL80211_ATTR_MESH_SETUP = 112
NL80211_ATTR_WIPHY_ANTENNA_AVAIL_TX = 113
NL80211_ATTR_WIPHY_ANTENNA_AVAIL_RX = 114
NL80211_ATTR_SUPPORT_MESH_AUTH = 115
NL80211_ATTR_STA_PLINK_STATE = 116
NL80211_ATTR_WOWLAN_TRIGGERS = 117
NL80211_ATTR_WOWLAN_TRIGGERS_SUPPORTED = 118
NL80211_ATTR_SCHED_SCAN_INTERVAL = 119
NL80211_ATTR_INTERFACE_COMBINATIONS = 120
NL80211_ATTR_SOFTWARE_IFTYPES = 121
NL80211_ATTR_REKEY_DATA = 122
NL80211_ATTR_MAX_NUM_SCHED_SCAN_SSIDS = 123
NL80211_ATTR_MAX_SCHED_SCAN_IE_LEN = 124
NL80211_ATTR_SCAN_SUPP_RATES = 125
NL80211_ATTR_HIDDEN_SSID = 126
NL80211_ATTR_IE_PROBE_RESP = 127
NL80211_ATTR_IE_ASSOC_RESP = 128
NL80211_ATTR_STA_WME = 129
NL80211_ATTR_SUPPORT_AP_UAPSD = 130
NL80211_ATTR_ROAM_SUPPORT = 131
NL80211_ATTR_SCHED_SCAN_MATCH = 132
NL80211_ATTR_MAX_MATCH_SETS = 133
NL80211_ATTR_PMKSA_CANDIDATE = 134
NL80211_ATTR_TX_NO_CCK_RATE = 135
NL80211_ATTR_TDLS_ACTION = 136
NL80211_ATTR_TDLS_DIALOG_TOKEN = 137
NL80211_ATTR_TDLS_OPERATION = 138
NL80211_ATTR_TDLS_SUPPORT = 139
NL80211_ATTR_TDLS_EXTERNAL_SETUP = 140
NL80211_ATTR_DEVICE_AP_SME = 141
NL80211_ATTR_DONT_WAIT_FOR_ACK = 142
NL80211_ATTR_FEATURE_FLAGS = 143
NL80211_ATTR_PROBE_RESP_OFFLOAD = 144
NL80211_ATTR_PROBE_RESP = 145
NL80211_ATTR_DFS_REGION = 146
NL80211_ATTR_DISABLE_HT = 147
NL80211_ATTR_HT_CAPABILITY_MASK = 148
NL80211_ATTR_NOACK_MAP = 149
NL80211_ATTR_INACTIVITY_TIMEOUT = 150
NL80211_ATTR_RX_SIGNAL_DBM = 151
NL80211_ATTR_BG_SCAN_PERIOD = 152
NL80211_ATTR_WDEV = 153
NL80211_ATTR_USER_REG_HINT_TYPE = 154
NL80211_ATTR_CONN_FAILED_REASON = 155
NL80211_ATTR_SAE_DATA = 156
NL80211_ATTR_VHT_CAPABILITY = 157
NL80211_ATTR_SCAN_FLAGS = 158
NL80211_ATTR_CHANNEL_WIDTH = 159
NL80211_ATTR_CENTER_FREQ1 = 160
NL80211_ATTR_CENTER_FREQ2 = 161
NL80211_ATTR_P2P_CTWINDOW = 162
NL80211_ATTR_P2P_OPPPS = 163
NL80211_ATTR_LOCAL_MESH_POWER_MODE = 164
NL80211_ATTR_ACL_POLICY = 165
NL80211_ATTR_MAC_ADDRS = 166
NL80211_ATTR_MAC_ACL_MAX = 167
NL80211_ATTR_RADAR_EVENT = 168
NL80211_ATTR_EXT_CAPA = 169
NL80211_ATTR_EXT_CAPA_MASK = 170
NL80211_ATTR_STA_CAPABILITY = 171
NL80211_ATTR_STA_EXT_CAPABILITY = 172
NL80211_ATTR_PROTOCOL_FEATURES = 173
NL80211_ATTR_SPLIT_WIPHY_DUMP = 174
NL80211_ATTR_DISABLE_VHT = 175
NL80211_ATTR_VHT_CAPABILITY_MASK = 176
NL80211_ATTR_MDID = 177
NL80211_ATTR_IE_RIC = 178
NL80211_ATTR_CRIT_PROT_ID = 179
NL80211_ATTR_MAX_CRIT_PROT_DURATION = 180
NL80211_ATTR_PEER_AID = 181
__NL80211_ATTR_AFTER_LAST = 182
NL80211_ATTR_MAX = __NL80211_ATTR_AFTER_LAST - 1
NL80211_IFTYPE_UNSPECIFIED = 0
NL80211_IFTYPE_ADHOC = 1
NL80211_IFTYPE_STATION = 2
NL80211_IFTYPE_AP = 3
NL80211_IFTYPE_AP_VLAN = 4
NL80211_IFTYPE_WDS = 5
NL80211_IFTYPE_MONITOR = 6
NL80211_IFTYPE_MESH_POINT = 7
NL80211_IFTYPE_P2P_CLIENT = 8
NL80211_IFTYPE_P2P_GO = 9
NL80211_IFTYPE_P2P_DEVICE = 10
NUM_NL80211_IFTYPES = 11
NL80211_IFTYPE_MAX = NUM_NL80211_IFTYPES - 1
__NL80211_STA_FLAG_INVALID = 0
NL80211_STA_FLAG_AUTHORIZED = 1
NL80211_STA_FLAG_SHORT_PREAMBLE = 2
NL80211_STA_FLAG_WME = 3
NL80211_STA_FLAG_MFP = 4
NL80211_STA_FLAG_AUTHENTICATED = 5
NL80211_STA_FLAG_TDLS_PEER = 6
NL80211_STA_FLAG_ASSOCIATED = 7
__NL80211_STA_FLAG_AFTER_LAST = 8
NL80211_STA_FLAG_MAX = __NL80211_STA_FLAG_AFTER_LAST - 1
__NL80211_RATE_INFO_INVALID = 0
NL80211_RATE_INFO_BITRATE = 1
NL80211_RATE_INFO_MCS = 2
NL80211_RATE_INFO_40_MHZ_WIDTH = 3
NL80211_RATE_INFO_SHORT_GI = 4
NL80211_RATE_INFO_BITRATE32 = 5
NL80211_RATE_INFO_VHT_MCS = 6
NL80211_RATE_INFO_VHT_NSS = 7
NL80211_RATE_INFO_80_MHZ_WIDTH = 8
NL80211_RATE_INFO_80P80_MHZ_WIDTH = 9
NL80211_RATE_INFO_160_MHZ_WIDTH = 10
__NL80211_RATE_INFO_AFTER_LAST = 11
NL80211_RATE_INFO_MAX = __NL80211_RATE_INFO_AFTER_LAST - 1
__NL80211_STA_BSS_PARAM_INVALID = 0
NL80211_STA_BSS_PARAM_CTS_PROT = 1
NL80211_STA_BSS_PARAM_SHORT_PREAMBLE = 2
NL80211_STA_BSS_PARAM_SHORT_SLOT_TIME = 3
NL80211_STA_BSS_PARAM_DTIM_PERIOD = 4
NL80211_STA_BSS_PARAM_BEACON_INTERVAL = 5
__NL80211_STA_BSS_PARAM_AFTER_LAST = 6
NL80211_STA_BSS_PARAM_MAX = __NL80211_STA_BSS_PARAM_AFTER_LAST - 1
__NL80211_STA_INFO_INVALID = 0
NL80211_STA_INFO_INACTIVE_TIME = 1
NL80211_STA_INFO_RX_BYTES = 2
NL80211_STA_INFO_TX_BYTES = 3
NL80211_STA_INFO_LLID = 4
NL80211_STA_INFO_PLID = 5
NL80211_STA_INFO_PLINK_STATE = 6
NL80211_STA_INFO_SIGNAL = 7
NL80211_STA_INFO_TX_BITRATE = 8
NL80211_STA_INFO_RX_PACKETS = 9
NL80211_STA_INFO_TX_PACKETS = 10
NL80211_STA_INFO_TX_RETRIES = 11
NL80211_STA_INFO_TX_FAILED = 12
NL80211_STA_INFO_SIGNAL_AVG = 13
NL80211_STA_INFO_RX_BITRATE = 14
NL80211_STA_INFO_BSS_PARAM = 15
NL80211_STA_INFO_CONNECTED_TIME = 16
NL80211_STA_INFO_STA_FLAGS = 17
NL80211_STA_INFO_BEACON_LOSS = 18
NL80211_STA_INFO_T_OFFSET = 19
NL80211_STA_INFO_LOCAL_PM = 20
NL80211_STA_INFO_PEER_PM = 21
NL80211_STA_INFO_NONPEER_PM = 22
NL80211_STA_INFO_RX_BYTES64 = 23
NL80211_STA_INFO_TX_BYTES64 = 24
NL80211_STA_INFO_CHAIN_SIGNAL = 25
NL80211_STA_INFO_CHAIN_SIGNAL_AVG = 26
__NL80211_STA_INFO_AFTER_LAST = 27
NL80211_STA_INFO_MAX = __NL80211_STA_INFO_AFTER_LAST - 1
NL80211_MPATH_FLAG_ACTIVE = 1 << 0
NL80211_MPATH_FLAG_RESOLVING = 1 << 1
NL80211_MPATH_FLAG_SN_VALID = 1 << 2
NL80211_MPATH_FLAG_FIXED = 1 << 3
NL80211_MPATH_FLAG_RESOLVED = 1 << 4
__NL80211_MPATH_INFO_INVALID = 0
NL80211_MPATH_INFO_FRAME_QLEN = 1
NL80211_MPATH_INFO_SN = 2
NL80211_MPATH_INFO_METRIC = 3
NL80211_MPATH_INFO_EXPTIME = 4
NL80211_MPATH_INFO_FLAGS = 5
NL80211_MPATH_INFO_DISCOVERY_TIMEOUT = 6
NL80211_MPATH_INFO_DISCOVERY_RETRIES = 7
__NL80211_MPATH_INFO_AFTER_LAST = 8
NL80211_MPATH_INFO_MAX = __NL80211_MPATH_INFO_AFTER_LAST - 1
__NL80211_BAND_ATTR_INVALID = 0
NL80211_BAND_ATTR_FREQS = 1
NL80211_BAND_ATTR_RATES = 2
NL80211_BAND_ATTR_HT_MCS_SET = 3
NL80211_BAND_ATTR_HT_CAPA = 4
NL80211_BAND_ATTR_HT_AMPDU_FACTOR = 5
NL80211_BAND_ATTR_HT_AMPDU_DENSITY = 6
NL80211_BAND_ATTR_VHT_MCS_SET = 7
NL80211_BAND_ATTR_VHT_CAPA = 8
__NL80211_BAND_ATTR_AFTER_LAST = 9
NL80211_BAND_ATTR_MAX = __NL80211_BAND_ATTR_AFTER_LAST - 1
__NL80211_FREQUENCY_ATTR_INVALID = 0
NL80211_FREQUENCY_ATTR_FREQ = 1
NL80211_FREQUENCY_ATTR_DISABLED = 2
NL80211_FREQUENCY_ATTR_PASSIVE_SCAN = 3
NL80211_FREQUENCY_ATTR_NO_IBSS = 4
NL80211_FREQUENCY_ATTR_RADAR = 5
NL80211_FREQUENCY_ATTR_MAX_TX_POWER = 6
NL80211_FREQUENCY_ATTR_DFS_STATE = 7
NL80211_FREQUENCY_ATTR_DFS_TIME = 8
NL80211_FREQUENCY_ATTR_NO_HT40_MINUS = 9
NL80211_FREQUENCY_ATTR_NO_HT40_PLUS = 10
NL80211_FREQUENCY_ATTR_NO_80MHZ = 11
NL80211_FREQUENCY_ATTR_NO_160MHZ = 12
__NL80211_FREQUENCY_ATTR_AFTER_LAST = 13
NL80211_FREQUENCY_ATTR_MAX = __NL80211_FREQUENCY_ATTR_AFTER_LAST - 1
__NL80211_BITRATE_ATTR_INVALID = 0
NL80211_BITRATE_ATTR_RATE = 1
NL80211_BITRATE_ATTR_2GHZ_SHORTPREAMBLE = 2
__NL80211_BITRATE_ATTR_AFTER_LAST = 3
NL80211_BITRATE_ATTR_MAX = __NL80211_BITRATE_ATTR_AFTER_LAST - 1
NL80211_REGDOM_SET_BY_CORE = 0
NL80211_REGDOM_SET_BY_USER = 1
NL80211_REGDOM_SET_BY_DRIVER = 2
NL80211_REGDOM_SET_BY_COUNTRY_IE = 3
NL80211_REGDOM_TYPE_COUNTRY = 0
NL80211_REGDOM_TYPE_WORLD = 1
NL80211_REGDOM_TYPE_CUSTOM_WORLD = 2
NL80211_REGDOM_TYPE_INTERSECTION = 3
__NL80211_REG_RULE_ATTR_INVALID = 0
NL80211_ATTR_REG_RULE_FLAGS = 1
NL80211_ATTR_FREQ_RANGE_START = 2
NL80211_ATTR_FREQ_RANGE_END = 3
NL80211_ATTR_FREQ_RANGE_MAX_BW = 4
NL80211_ATTR_POWER_RULE_MAX_ANT_GAIN = 5
NL80211_ATTR_POWER_RULE_MAX_EIRP = 6
__NL80211_REG_RULE_ATTR_AFTER_LAST = 7
NL80211_REG_RULE_ATTR_MAX = __NL80211_REG_RULE_ATTR_AFTER_LAST - 1
__NL80211_SCHED_SCAN_MATCH_ATTR_INVALID = 0
NL80211_SCHED_SCAN_MATCH_ATTR_SSID = 1
NL80211_SCHED_SCAN_MATCH_ATTR_RSSI = 2
__NL80211_SCHED_SCAN_MATCH_ATTR_AFTER_LAST = 3
NL80211_SCHED_SCAN_MATCH_ATTR_MAX = __NL80211_SCHED_SCAN_MATCH_ATTR_AFTER_LAST - 1
NL80211_RRF_NO_OFDM = 1 << 0
NL80211_RRF_NO_CCK = 1 << 1
NL80211_RRF_NO_INDOOR = 1 << 2
NL80211_RRF_NO_OUTDOOR = 1 << 3
NL80211_RRF_DFS = 1 << 4
NL80211_RRF_PTP_ONLY = 1 << 5
NL80211_RRF_PTMP_ONLY = 1 << 6
NL80211_RRF_PASSIVE_SCAN = 1 << 7
NL80211_RRF_NO_IBSS = 1 << 8
NL80211_DFS_UNSET = 0
NL80211_DFS_FCC = 1
NL80211_DFS_ETSI = 2
NL80211_DFS_JP = 3
NL80211_USER_REG_HINT_USER = 0
NL80211_USER_REG_HINT_CELL_BASE = 1
__NL80211_SURVEY_INFO_INVALID = 0
NL80211_SURVEY_INFO_FREQUENCY = 1
NL80211_SURVEY_INFO_NOISE = 2
NL80211_SURVEY_INFO_IN_USE = 3
NL80211_SURVEY_INFO_CHANNEL_TIME = 4
NL80211_SURVEY_INFO_CHANNEL_TIME_BUSY = 5
NL80211_SURVEY_INFO_CHANNEL_TIME_EXT_BUSY = 6
NL80211_SURVEY_INFO_CHANNEL_TIME_RX = 7
NL80211_SURVEY_INFO_CHANNEL_TIME_TX = 8
__NL80211_SURVEY_INFO_AFTER_LAST = 9
NL80211_SURVEY_INFO_MAX = __NL80211_SURVEY_INFO_AFTER_LAST - 1
__NL80211_MNTR_FLAG_INVALID = 0
NL80211_MNTR_FLAG_FCSFAIL = 1
NL80211_MNTR_FLAG_PLCPFAIL = 2
NL80211_MNTR_FLAG_CONTROL = 3
NL80211_MNTR_FLAG_OTHER_BSS = 4
NL80211_MNTR_FLAG_COOK_FRAMES = 5
NL80211_MNTR_FLAG_ACTIVE = 6
__NL80211_MNTR_FLAG_AFTER_LAST = 7
NL80211_MNTR_FLAG_MAX = __NL80211_MNTR_FLAG_AFTER_LAST - 1
NL80211_MESH_POWER_UNKNOWN = 0
NL80211_MESH_POWER_ACTIVE = 1
NL80211_MESH_POWER_LIGHT_SLEEP = 2
NL80211_MESH_POWER_DEEP_SLEEP = 3
__NL80211_MESH_POWER_AFTER_LAST = 4
NL80211_MESH_POWER_MAX = __NL80211_MESH_POWER_AFTER_LAST - 1
__NL80211_MESHCONF_INVALID = 0
NL80211_MESHCONF_RETRY_TIMEOUT = 1
NL80211_MESHCONF_CONFIRM_TIMEOUT = 2
NL80211_MESHCONF_HOLDING_TIMEOUT = 3
NL80211_MESHCONF_MAX_PEER_LINKS = 4
NL80211_MESHCONF_MAX_RETRIES = 5
NL80211_MESHCONF_TTL = 6
NL80211_MESHCONF_AUTO_OPEN_PLINKS = 7
NL80211_MESHCONF_HWMP_MAX_PREQ_RETRIES = 8
NL80211_MESHCONF_PATH_REFRESH_TIME = 9
NL80211_MESHCONF_MIN_DISCOVERY_TIMEOUT = 10
NL80211_MESHCONF_HWMP_ACTIVE_PATH_TIMEOUT = 11
NL80211_MESHCONF_HWMP_PREQ_MIN_INTERVAL = 12
NL80211_MESHCONF_HWMP_NET_DIAM_TRVS_TIME = 13
NL80211_MESHCONF_HWMP_ROOTMODE = 14
NL80211_MESHCONF_ELEMENT_TTL = 15
NL80211_MESHCONF_HWMP_RANN_INTERVAL = 16
NL80211_MESHCONF_GATE_ANNOUNCEMENTS = 17
NL80211_MESHCONF_HWMP_PERR_MIN_INTERVAL = 18
NL80211_MESHCONF_FORWARDING = 19
NL80211_MESHCONF_RSSI_THRESHOLD = 20
NL80211_MESHCONF_SYNC_OFFSET_MAX_NEIGHBOR = 21
NL80211_MESHCONF_HT_OPMODE = 22
NL80211_MESHCONF_HWMP_PATH_TO_ROOT_TIMEOUT = 23
NL80211_MESHCONF_HWMP_ROOT_INTERVAL = 24
NL80211_MESHCONF_HWMP_CONFIRMATION_INTERVAL = 25
NL80211_MESHCONF_POWER_MODE = 26
NL80211_MESHCONF_AWAKE_WINDOW = 27
NL80211_MESHCONF_PLINK_TIMEOUT = 28
__NL80211_MESHCONF_ATTR_AFTER_LAST = 29
NL80211_MESHCONF_ATTR_MAX = __NL80211_MESHCONF_ATTR_AFTER_LAST - 1
__NL80211_MESH_SETUP_INVALID = 0
NL80211_MESH_SETUP_ENABLE_VENDOR_PATH_SEL = 1
NL80211_MESH_SETUP_ENABLE_VENDOR_METRIC = 2
NL80211_MESH_SETUP_IE = 3
NL80211_MESH_SETUP_USERSPACE_AUTH = 4
NL80211_MESH_SETUP_USERSPACE_AMPE = 5
NL80211_MESH_SETUP_ENABLE_VENDOR_SYNC = 6
NL80211_MESH_SETUP_USERSPACE_MPM = 7
NL80211_MESH_SETUP_AUTH_PROTOCOL = 8
__NL80211_MESH_SETUP_ATTR_AFTER_LAST = 9
NL80211_MESH_SETUP_ATTR_MAX = __NL80211_MESH_SETUP_ATTR_AFTER_LAST - 1
__NL80211_TXQ_ATTR_INVALID = 0
NL80211_TXQ_ATTR_AC = 1
NL80211_TXQ_ATTR_TXOP = 2
NL80211_TXQ_ATTR_CWMIN = 3
NL80211_TXQ_ATTR_CWMAX = 4
NL80211_TXQ_ATTR_AIFS = 5
__NL80211_TXQ_ATTR_AFTER_LAST = 6
NL80211_TXQ_ATTR_MAX = __NL80211_TXQ_ATTR_AFTER_LAST - 1
NL80211_AC_VO = 0
NL80211_AC_VI = 1
NL80211_AC_BE = 2
NL80211_AC_BK = 3
NL80211_NUM_ACS = 4
NL80211_CHAN_NO_HT = 0
NL80211_CHAN_HT20 = 1
NL80211_CHAN_HT40MINUS = 2
NL80211_CHAN_HT40PLUS = 3
NL80211_CHAN_WIDTH_20_NOHT = 0
NL80211_CHAN_WIDTH_20 = 1
NL80211_CHAN_WIDTH_40 = 2
NL80211_CHAN_WIDTH_80 = 3
NL80211_CHAN_WIDTH_80P80 = 4
NL80211_CHAN_WIDTH_160 = 5
__NL80211_BSS_INVALID = 0
NL80211_BSS_BSSID = 1
NL80211_BSS_FREQUENCY = 2
NL80211_BSS_TSF = 3
NL80211_BSS_BEACON_INTERVAL = 4
NL80211_BSS_CAPABILITY = 5
NL80211_BSS_INFORMATION_ELEMENTS = 6
NL80211_BSS_SIGNAL_MBM = 7
NL80211_BSS_SIGNAL_UNSPEC = 8
NL80211_BSS_STATUS = 9
NL80211_BSS_SEEN_MS_AGO = 10
NL80211_BSS_BEACON_IES = 11
__NL80211_BSS_AFTER_LAST = 12
NL80211_BSS_MAX = __NL80211_BSS_AFTER_LAST - 1
NL80211_BSS_STATUS_AUTHENTICATED = 0
NL80211_BSS_STATUS_ASSOCIATED = 1
NL80211_BSS_STATUS_IBSS_JOINED = 2
NL80211_AUTHTYPE_OPEN_SYSTEM = 0
NL80211_AUTHTYPE_SHARED_KEY = 1
NL80211_AUTHTYPE_FT = 2
NL80211_AUTHTYPE_NETWORK_EAP = 3
NL80211_AUTHTYPE_SAE = 4
__NL80211_AUTHTYPE_NUM = 5
NL80211_AUTHTYPE_MAX = __NL80211_AUTHTYPE_NUM - 1
NL80211_AUTHTYPE_AUTOMATIC = 6
NL80211_KEYTYPE_GROUP = 0
NL80211_KEYTYPE_PAIRWISE = 1
NL80211_KEYTYPE_PEERKEY = 2
NUM_NL80211_KEYTYPES = 3
NL80211_MFP_NO = 0
NL80211_MFP_REQUIRED = 1
NL80211_WPA_VERSION_1 = 1 << 0
NL80211_WPA_VERSION_2 = 1 << 1
__NL80211_KEY_DEFAULT_TYPE_INVALID = 0
NL80211_KEY_DEFAULT_TYPE_UNICAST = 1
NL80211_KEY_DEFAULT_TYPE_MULTICAST = 2
NUM_NL80211_KEY_DEFAULT_TYPES = 3
__NL80211_KEY_INVALID = 0
NL80211_KEY_DATA = 1
NL80211_KEY_IDX = 2
NL80211_KEY_CIPHER = 3
NL80211_KEY_SEQ = 4
NL80211_KEY_DEFAULT = 5
NL80211_KEY_DEFAULT_MGMT = 6
NL80211_KEY_TYPE = 7
NL80211_KEY_DEFAULT_TYPES = 8
__NL80211_KEY_AFTER_LAST = 9
NL80211_KEY_MAX = __NL80211_KEY_AFTER_LAST - 1
__NL80211_TXRATE_INVALID = 0
NL80211_TXRATE_LEGACY = 1
NL80211_TXRATE_MCS = 2
__NL80211_TXRATE_AFTER_LAST = 3
NL80211_TXRATE_MAX = __NL80211_TXRATE_AFTER_LAST - 1
NL80211_BAND_2GHZ = 0
NL80211_BAND_5GHZ = 1
NL80211_BAND_60GHZ = 2
NL80211_PS_DISABLED = 0
NL80211_PS_ENABLED = 1
__NL80211_ATTR_CQM_INVALID = 0
NL80211_ATTR_CQM_RSSI_THOLD = 1
NL80211_ATTR_CQM_RSSI_HYST = 2
NL80211_ATTR_CQM_RSSI_THRESHOLD_EVENT = 3
NL80211_ATTR_CQM_PKT_LOSS_EVENT = 4
NL80211_ATTR_CQM_TXE_RATE = 5
NL80211_ATTR_CQM_TXE_PKTS = 6
NL80211_ATTR_CQM_TXE_INTVL = 7
__NL80211_ATTR_CQM_AFTER_LAST = 8
NL80211_ATTR_CQM_MAX = __NL80211_ATTR_CQM_AFTER_LAST - 1
NL80211_CQM_RSSI_THRESHOLD_EVENT_LOW = 0
NL80211_CQM_RSSI_THRESHOLD_EVENT_HIGH = 1
NL80211_CQM_RSSI_BEACON_LOSS_EVENT = 2
NL80211_TX_POWER_AUTOMATIC = 0
NL80211_TX_POWER_LIMITED = 1
NL80211_TX_POWER_FIXED = 2
__NL80211_WOWLAN_PKTPAT_INVALID = 0
NL80211_WOWLAN_PKTPAT_MASK = 1
NL80211_WOWLAN_PKTPAT_PATTERN = 2
NL80211_WOWLAN_PKTPAT_OFFSET = 3
NUM_NL80211_WOWLAN_PKTPAT = 4
MAX_NL80211_WOWLAN_PKTPAT = NUM_NL80211_WOWLAN_PKTPAT - 1
__NL80211_WOWLAN_TRIG_INVALID = 0
NL80211_WOWLAN_TRIG_ANY = 1
NL80211_WOWLAN_TRIG_DISCONNECT = 2
NL80211_WOWLAN_TRIG_MAGIC_PKT = 3
NL80211_WOWLAN_TRIG_PKT_PATTERN = 4
NL80211_WOWLAN_TRIG_GTK_REKEY_SUPPORTED = 5
NL80211_WOWLAN_TRIG_GTK_REKEY_FAILURE = 6
NL80211_WOWLAN_TRIG_EAP_IDENT_REQUEST = 7
NL80211_WOWLAN_TRIG_4WAY_HANDSHAKE = 8
NL80211_WOWLAN_TRIG_RFKILL_RELEASE = 9
NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211 = 10
NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211_LEN = 11
NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023 = 12
NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023_LEN = 13
NL80211_WOWLAN_TRIG_TCP_CONNECTION = 14
NL80211_WOWLAN_TRIG_WAKEUP_TCP_MATCH = 15
NL80211_WOWLAN_TRIG_WAKEUP_TCP_CONNLOST = 16
NL80211_WOWLAN_TRIG_WAKEUP_TCP_NOMORETOKENS = 17
NUM_NL80211_WOWLAN_TRIG = 18
MAX_NL80211_WOWLAN_TRIG = NUM_NL80211_WOWLAN_TRIG - 1
__NL80211_WOWLAN_TCP_INVALID = 0
NL80211_WOWLAN_TCP_SRC_IPV4 = 1
NL80211_WOWLAN_TCP_DST_IPV4 = 2
NL80211_WOWLAN_TCP_DST_MAC = 3
NL80211_WOWLAN_TCP_SRC_PORT = 4
NL80211_WOWLAN_TCP_DST_PORT = 5
NL80211_WOWLAN_TCP_DATA_PAYLOAD = 6
NL80211_WOWLAN_TCP_DATA_PAYLOAD_SEQ = 7
NL80211_WOWLAN_TCP_DATA_PAYLOAD_TOKEN = 8
NL80211_WOWLAN_TCP_DATA_INTERVAL = 9
NL80211_WOWLAN_TCP_WAKE_PAYLOAD = 10
NL80211_WOWLAN_TCP_WAKE_MASK = 11
NUM_NL80211_WOWLAN_TCP = 12
MAX_NL80211_WOWLAN_TCP = NUM_NL80211_WOWLAN_TCP - 1
NL80211_IFACE_LIMIT_UNSPEC = 0
NL80211_IFACE_LIMIT_MAX = 1
NL80211_IFACE_LIMIT_TYPES = 2
NUM_NL80211_IFACE_LIMIT = 3
MAX_NL80211_IFACE_LIMIT = NUM_NL80211_IFACE_LIMIT - 1
NL80211_IFACE_COMB_UNSPEC = 0
NL80211_IFACE_COMB_LIMITS = 1
NL80211_IFACE_COMB_MAXNUM = 2
NL80211_IFACE_COMB_STA_AP_BI_MATCH = 3
NL80211_IFACE_COMB_NUM_CHANNELS = 4
NL80211_IFACE_COMB_RADAR_DETECT_WIDTHS = 5
NUM_NL80211_IFACE_COMB = 6
MAX_NL80211_IFACE_COMB = NUM_NL80211_IFACE_COMB - 1
NL80211_PLINK_LISTEN = 0
NL80211_PLINK_OPN_SNT = 1
NL80211_PLINK_OPN_RCVD = 2
NL80211_PLINK_CNF_RCVD = 3
NL80211_PLINK_ESTAB = 4
NL80211_PLINK_HOLDING = 5
NL80211_PLINK_BLOCKED = 6
NUM_NL80211_PLINK_STATES = 7
MAX_NL80211_PLINK_STATES = NUM_NL80211_PLINK_STATES - 1
NL80211_PLINK_ACTION_NO_ACTION = 0
NL80211_PLINK_ACTION_OPEN = 1
NL80211_PLINK_ACTION_BLOCK = 2
NUM_NL80211_PLINK_ACTIONS = 3
__NL80211_REKEY_DATA_INVALID = 0
NL80211_REKEY_DATA_KEK = 1
NL80211_REKEY_DATA_KCK = 2
NL80211_REKEY_DATA_REPLAY_CTR = 3
NUM_NL80211_REKEY_DATA = 4
MAX_NL80211_REKEY_DATA = NUM_NL80211_REKEY_DATA - 1
NL80211_HIDDEN_SSID_NOT_IN_USE = 0
NL80211_HIDDEN_SSID_ZERO_LEN = 1
NL80211_HIDDEN_SSID_ZERO_CONTENTS = 2
__NL80211_STA_WME_INVALID = 0
NL80211_STA_WME_UAPSD_QUEUES = 1
NL80211_STA_WME_MAX_SP = 2
__NL80211_STA_WME_AFTER_LAST = 3
NL80211_STA_WME_MAX = __NL80211_STA_WME_AFTER_LAST - 1
__NL80211_PMKSA_CANDIDATE_INVALID = 0
NL80211_PMKSA_CANDIDATE_INDEX = 1
NL80211_PMKSA_CANDIDATE_BSSID = 2
NL80211_PMKSA_CANDIDATE_PREAUTH = 3
NUM_NL80211_PMKSA_CANDIDATE = 4
MAX_NL80211_PMKSA_CANDIDATE = NUM_NL80211_PMKSA_CANDIDATE - 1
NL80211_TDLS_DISCOVERY_REQ = 0
NL80211_TDLS_SETUP = 1
NL80211_TDLS_TEARDOWN = 2
NL80211_TDLS_ENABLE_LINK = 3
NL80211_TDLS_DISABLE_LINK = 4
NL80211_FEATURE_SK_TX_STATUS = 1 << 0
NL80211_FEATURE_HT_IBSS = 1 << 1
NL80211_FEATURE_INACTIVITY_TIMER = 1 << 2
NL80211_FEATURE_CELL_BASE_REG_HINTS = 1 << 3
NL80211_FEATURE_P2P_DEVICE_NEEDS_CHANNEL = 1 << 4
NL80211_FEATURE_SAE = 1 << 5
NL80211_FEATURE_LOW_PRIORITY_SCAN = 1 << 6
NL80211_FEATURE_SCAN_FLUSH = 1 << 7
NL80211_FEATURE_AP_SCAN = 1 << 8
NL80211_FEATURE_VIF_TXPOWER = 1 << 9
NL80211_FEATURE_NEED_OBSS_SCAN = 1 << 10
NL80211_FEATURE_P2P_GO_CTWIN = 1 << 11
NL80211_FEATURE_P2P_GO_OPPPS = 1 << 12
NL80211_FEATURE_ADVERTISE_CHAN_LIMITS = 1 << 14
NL80211_FEATURE_FULL_AP_CLIENT_STATE = 1 << 15
NL80211_FEATURE_USERSPACE_MPM = 1 << 16
NL80211_FEATURE_ACTIVE_MONITOR = 1 << 17
NL80211_PROBE_RESP_OFFLOAD_SUPPORT_WPS = 1 << 0
NL80211_PROBE_RESP_OFFLOAD_SUPPORT_WPS2 = 1 << 1
NL80211_PROBE_RESP_OFFLOAD_SUPPORT_P2P = 1 << 2
NL80211_PROBE_RESP_OFFLOAD_SUPPORT_80211U = 1 << 3
NL80211_CONN_FAIL_MAX_CLIENTS = 0
NL80211_CONN_FAIL_BLOCKED_CLIENT = 1
NL80211_SCAN_FLAG_LOW_PRIORITY = 1 << 0
NL80211_SCAN_FLAG_FLUSH = 1 << 1
NL80211_SCAN_FLAG_AP = 1 << 2
NL80211_ACL_POLICY_ACCEPT_UNLESS_LISTED = 0
NL80211_ACL_POLICY_DENY_UNLESS_LISTED = 1
NL80211_RADAR_DETECTED = 0
NL80211_RADAR_CAC_FINISHED = 1
NL80211_RADAR_CAC_ABORTED = 2
NL80211_RADAR_NOP_FINISHED = 3
NL80211_DFS_USABLE = 0
NL80211_DFS_UNAVAILABLE = 1
NL80211_DFS_AVAILABLE = 2
NL80211_PROTOCOL_FEATURE_SPLIT_WIPHY_DUMP = 1 << 0
NL80211_CRIT_PROTO_UNSPEC = 0
NL80211_CRIT_PROTO_DHCP = 1
NL80211_CRIT_PROTO_EAPOL = 2
NL80211_CRIT_PROTO_APIPA = 3
NUM_NL80211_CRIT_PROTO = 4
nl80211_commands2str = {
    NL80211_CMD_UNSPEC: "NL80211_CMD_UNSPEC",
    NL80211_CMD_GET_WIPHY: "NL80211_CMD_GET_WIPHY",
    NL80211_CMD_SET_WIPHY: "NL80211_CMD_SET_WIPHY",
    NL80211_CMD_NEW_WIPHY: "NL80211_CMD_NEW_WIPHY",
    NL80211_CMD_DEL_WIPHY: "NL80211_CMD_DEL_WIPHY",
    NL80211_CMD_GET_INTERFACE: "NL80211_CMD_GET_INTERFACE",
    NL80211_CMD_SET_INTERFACE: "NL80211_CMD_SET_INTERFACE",
    NL80211_CMD_NEW_INTERFACE: "NL80211_CMD_NEW_INTERFACE",
    NL80211_CMD_DEL_INTERFACE: "NL80211_CMD_DEL_INTERFACE",
    NL80211_CMD_GET_KEY: "NL80211_CMD_GET_KEY",
    NL80211_CMD_SET_KEY: "NL80211_CMD_SET_KEY",
    NL80211_CMD_NEW_KEY: "NL80211_CMD_NEW_KEY",
    NL80211_CMD_DEL_KEY: "NL80211_CMD_DEL_KEY",
    NL80211_CMD_GET_BEACON: "NL80211_CMD_GET_BEACON",
    NL80211_CMD_SET_BEACON: "NL80211_CMD_SET_BEACON",
    NL80211_CMD_START_AP: "NL80211_CMD_START_AP",
    NL80211_CMD_STOP_AP: "NL80211_CMD_STOP_AP",
    NL80211_CMD_GET_STATION: "NL80211_CMD_GET_STATION",
    NL80211_CMD_SET_STATION: "NL80211_CMD_SET_STATION",
    NL80211_CMD_NEW_STATION: "NL80211_CMD_NEW_STATION",
    NL80211_CMD_DEL_STATION: "NL80211_CMD_DEL_STATION",
    NL80211_CMD_GET_MPATH: "NL80211_CMD_GET_MPATH",
    NL80211_CMD_SET_MPATH: "NL80211_CMD_SET_MPATH",
    NL80211_CMD_NEW_MPATH: "NL80211_CMD_NEW_MPATH",
    NL80211_CMD_DEL_MPATH: "NL80211_CMD_DEL_MPATH",
    NL80211_CMD_SET_BSS: "NL80211_CMD_SET_BSS",
    NL80211_CMD_SET_REG: "NL80211_CMD_SET_REG",
    NL80211_CMD_REQ_SET_REG: "NL80211_CMD_REQ_SET_REG",
    NL80211_CMD_GET_MESH_CONFIG: "NL80211_CMD_GET_MESH_CONFIG",
    NL80211_CMD_SET_MESH_CONFIG: "NL80211_CMD_SET_MESH_CONFIG",
    NL80211_CMD_SET_MGMT_EXTRA_IE: "NL80211_CMD_SET_MGMT_EXTRA_IE",
    NL80211_CMD_GET_REG: "NL80211_CMD_GET_REG",
    NL80211_CMD_GET_SCAN: "NL80211_CMD_GET_SCAN",
    NL80211_CMD_TRIGGER_SCAN: "NL80211_CMD_TRIGGER_SCAN",
    NL80211_CMD_NEW_SCAN_RESULTS: "NL80211_CMD_NEW_SCAN_RESULTS",
    NL80211_CMD_SCAN_ABORTED: "NL80211_CMD_SCAN_ABORTED",
    NL80211_CMD_REG_CHANGE: "NL80211_CMD_REG_CHANGE",
    NL80211_CMD_AUTHENTICATE: "NL80211_CMD_AUTHENTICATE",
    NL80211_CMD_ASSOCIATE: "NL80211_CMD_ASSOCIATE",
    NL80211_CMD_DEAUTHENTICATE: "NL80211_CMD_DEAUTHENTICATE",
    NL80211_CMD_DISASSOCIATE: "NL80211_CMD_DISASSOCIATE",
    NL80211_CMD_MICHAEL_MIC_FAILURE: "NL80211_CMD_MICHAEL_MIC_FAILURE",
    NL80211_CMD_REG_BEACON_HINT: "NL80211_CMD_REG_BEACON_HINT",
    NL80211_CMD_JOIN_IBSS: "NL80211_CMD_JOIN_IBSS",
    NL80211_CMD_LEAVE_IBSS: "NL80211_CMD_LEAVE_IBSS",
    NL80211_CMD_TESTMODE: "NL80211_CMD_TESTMODE",
    NL80211_CMD_CONNECT: "NL80211_CMD_CONNECT",
    NL80211_CMD_ROAM: "NL80211_CMD_ROAM",
    NL80211_CMD_DISCONNECT: "NL80211_CMD_DISCONNECT",
    NL80211_CMD_SET_WIPHY_NETNS: "NL80211_CMD_SET_WIPHY_NETNS",
    NL80211_CMD_GET_SURVEY: "NL80211_CMD_GET_SURVEY",
    NL80211_CMD_NEW_SURVEY_RESULTS: "NL80211_CMD_NEW_SURVEY_RESULTS",
    NL80211_CMD_SET_PMKSA: "NL80211_CMD_SET_PMKSA",
    NL80211_CMD_DEL_PMKSA: "NL80211_CMD_DEL_PMKSA",
    NL80211_CMD_FLUSH_PMKSA: "NL80211_CMD_FLUSH_PMKSA",
    NL80211_CMD_REMAIN_ON_CHANNEL: "NL80211_CMD_REMAIN_ON_CHANNEL",
    NL80211_CMD_CANCEL_REMAIN_ON_CHANNEL: "NL80211_CMD_CANCEL_REMAIN_ON_CHANNEL",
    NL80211_CMD_SET_TX_BITRATE_MASK: "NL80211_CMD_SET_TX_BITRATE_MASK",
    NL80211_CMD_REGISTER_FRAME: "NL80211_CMD_REGISTER_FRAME",
    NL80211_CMD_FRAME: "NL80211_CMD_FRAME",
    NL80211_CMD_FRAME_TX_STATUS: "NL80211_CMD_FRAME_TX_STATUS",
    NL80211_CMD_SET_POWER_SAVE: "NL80211_CMD_SET_POWER_SAVE",
    NL80211_CMD_GET_POWER_SAVE: "NL80211_CMD_GET_POWER_SAVE",
    NL80211_CMD_SET_CQM: "NL80211_CMD_SET_CQM",
    NL80211_CMD_NOTIFY_CQM: "NL80211_CMD_NOTIFY_CQM",
    NL80211_CMD_SET_CHANNEL: "NL80211_CMD_SET_CHANNEL",
    NL80211_CMD_SET_WDS_PEER: "NL80211_CMD_SET_WDS_PEER",
    NL80211_CMD_FRAME_WAIT_CANCEL: "NL80211_CMD_FRAME_WAIT_CANCEL",
    NL80211_CMD_JOIN_MESH: "NL80211_CMD_JOIN_MESH",
    NL80211_CMD_LEAVE_MESH: "NL80211_CMD_LEAVE_MESH",
    NL80211_CMD_UNPROT_DEAUTHENTICATE: "NL80211_CMD_UNPROT_DEAUTHENTICATE",
    NL80211_CMD_UNPROT_DISASSOCIATE: "NL80211_CMD_UNPROT_DISASSOCIATE",
    NL80211_CMD_NEW_PEER_CANDIDATE: "NL80211_CMD_NEW_PEER_CANDIDATE",
    NL80211_CMD_GET_WOWLAN: "NL80211_CMD_GET_WOWLAN",
    NL80211_CMD_SET_WOWLAN: "NL80211_CMD_SET_WOWLAN",
    NL80211_CMD_START_SCHED_SCAN: "NL80211_CMD_START_SCHED_SCAN",
    NL80211_CMD_STOP_SCHED_SCAN: "NL80211_CMD_STOP_SCHED_SCAN",
    NL80211_CMD_SCHED_SCAN_RESULTS: "NL80211_CMD_SCHED_SCAN_RESULTS",
    NL80211_CMD_SCHED_SCAN_STOPPED: "NL80211_CMD_SCHED_SCAN_STOPPED",
    NL80211_CMD_SET_REKEY_OFFLOAD: "NL80211_CMD_SET_REKEY_OFFLOAD",
    NL80211_CMD_PMKSA_CANDIDATE: "NL80211_CMD_PMKSA_CANDIDATE",
    NL80211_CMD_TDLS_OPER: "NL80211_CMD_TDLS_OPER",
    NL80211_CMD_TDLS_MGMT: "NL80211_CMD_TDLS_MGMT",
    NL80211_CMD_UNEXPECTED_FRAME: "NL80211_CMD_UNEXPECTED_FRAME",
    NL80211_CMD_PROBE_CLIENT: "NL80211_CMD_PROBE_CLIENT",
    NL80211_CMD_REGISTER_BEACONS: "NL80211_CMD_REGISTER_BEACONS",
    NL80211_CMD_UNEXPECTED_4ADDR_FRAME: "NL80211_CMD_UNEXPECTED_4ADDR_FRAME",
    NL80211_CMD_SET_NOACK_MAP: "NL80211_CMD_SET_NOACK_MAP",
    NL80211_CMD_CH_SWITCH_NOTIFY: "NL80211_CMD_CH_SWITCH_NOTIFY",
    NL80211_CMD_START_P2P_DEVICE: "NL80211_CMD_START_P2P_DEVICE",
    NL80211_CMD_STOP_P2P_DEVICE: "NL80211_CMD_STOP_P2P_DEVICE",
    NL80211_CMD_CONN_FAILED: "NL80211_CMD_CONN_FAILED",
    NL80211_CMD_SET_MCAST_RATE: "NL80211_CMD_SET_MCAST_RATE",
    NL80211_CMD_SET_MAC_ACL: "NL80211_CMD_SET_MAC_ACL",
    NL80211_CMD_RADAR_DETECT: "NL80211_CMD_RADAR_DETECT",
    NL80211_CMD_GET_PROTOCOL_FEATURES: "NL80211_CMD_GET_PROTOCOL_FEATURES",
    NL80211_CMD_UPDATE_FT_IES: "NL80211_CMD_UPDATE_FT_IES",
    NL80211_CMD_FT_EVENT: "NL80211_CMD_FT_EVENT",
    NL80211_CMD_CRIT_PROTOCOL_START: "NL80211_CMD_CRIT_PROTOCOL_START",
    NL80211_CMD_CRIT_PROTOCOL_STOP: "NL80211_CMD_CRIT_PROTOCOL_STOP",
    __NL80211_CMD_AFTER_LAST: "__NL80211_CMD_AFTER_LAST",
}
nl80211_attrs2str = {
    NL80211_ATTR_UNSPEC: "NL80211_ATTR_UNSPEC",
    NL80211_ATTR_WIPHY: "NL80211_ATTR_WIPHY",
    NL80211_ATTR_WIPHY_NAME: "NL80211_ATTR_WIPHY_NAME",
    NL80211_ATTR_IFINDEX: "NL80211_ATTR_IFINDEX",
    NL80211_ATTR_IFNAME: "NL80211_ATTR_IFNAME",
    NL80211_ATTR_IFTYPE: "NL80211_ATTR_IFTYPE",
    NL80211_ATTR_MAC: "NL80211_ATTR_MAC",
    NL80211_ATTR_KEY_DATA: "NL80211_ATTR_KEY_DATA",
    NL80211_ATTR_KEY_IDX: "NL80211_ATTR_KEY_IDX",
    NL80211_ATTR_KEY_CIPHER: "NL80211_ATTR_KEY_CIPHER",
    NL80211_ATTR_KEY_SEQ: "NL80211_ATTR_KEY_SEQ",
    NL80211_ATTR_KEY_DEFAULT: "NL80211_ATTR_KEY_DEFAULT",
    NL80211_ATTR_BEACON_INTERVAL: "NL80211_ATTR_BEACON_INTERVAL",
    NL80211_ATTR_DTIM_PERIOD: "NL80211_ATTR_DTIM_PERIOD",
    NL80211_ATTR_BEACON_HEAD: "NL80211_ATTR_BEACON_HEAD",
    NL80211_ATTR_BEACON_TAIL: "NL80211_ATTR_BEACON_TAIL",
    NL80211_ATTR_STA_AID: "NL80211_ATTR_STA_AID",
    NL80211_ATTR_STA_FLAGS: "NL80211_ATTR_STA_FLAGS",
    NL80211_ATTR_STA_LISTEN_INTERVAL: "NL80211_ATTR_STA_LISTEN_INTERVAL",
    NL80211_ATTR_STA_SUPPORTED_RATES: "NL80211_ATTR_STA_SUPPORTED_RATES",
    NL80211_ATTR_STA_VLAN: "NL80211_ATTR_STA_VLAN",
    NL80211_ATTR_STA_INFO: "NL80211_ATTR_STA_INFO",
    NL80211_ATTR_WIPHY_BANDS: "NL80211_ATTR_WIPHY_BANDS",
    NL80211_ATTR_MNTR_FLAGS: "NL80211_ATTR_MNTR_FLAGS",
    NL80211_ATTR_MESH_ID: "NL80211_ATTR_MESH_ID",
    NL80211_ATTR_STA_PLINK_ACTION: "NL80211_ATTR_STA_PLINK_ACTION",
    NL80211_ATTR_MPATH_NEXT_HOP: "NL80211_ATTR_MPATH_NEXT_HOP",
    NL80211_ATTR_MPATH_INFO: "NL80211_ATTR_MPATH_INFO",
    NL80211_ATTR_BSS_CTS_PROT: "NL80211_ATTR_BSS_CTS_PROT",
    NL80211_ATTR_BSS_SHORT_PREAMBLE: "NL80211_ATTR_BSS_SHORT_PREAMBLE",
    NL80211_ATTR_BSS_SHORT_SLOT_TIME: "NL80211_ATTR_BSS_SHORT_SLOT_TIME",
    NL80211_ATTR_HT_CAPABILITY: "NL80211_ATTR_HT_CAPABILITY",
    NL80211_ATTR_SUPPORTED_IFTYPES: "NL80211_ATTR_SUPPORTED_IFTYPES",
    NL80211_ATTR_REG_ALPHA2: "NL80211_ATTR_REG_ALPHA2",
    NL80211_ATTR_REG_RULES: "NL80211_ATTR_REG_RULES",
    NL80211_ATTR_MESH_CONFIG: "NL80211_ATTR_MESH_CONFIG",
    NL80211_ATTR_BSS_BASIC_RATES: "NL80211_ATTR_BSS_BASIC_RATES",
    NL80211_ATTR_WIPHY_TXQ_PARAMS: "NL80211_ATTR_WIPHY_TXQ_PARAMS",
    NL80211_ATTR_WIPHY_FREQ: "NL80211_ATTR_WIPHY_FREQ",
    NL80211_ATTR_WIPHY_CHANNEL_TYPE: "NL80211_ATTR_WIPHY_CHANNEL_TYPE",
    NL80211_ATTR_KEY_DEFAULT_MGMT: "NL80211_ATTR_KEY_DEFAULT_MGMT",
    NL80211_ATTR_MGMT_SUBTYPE: "NL80211_ATTR_MGMT_SUBTYPE",
    NL80211_ATTR_IE: "NL80211_ATTR_IE",
    NL80211_ATTR_MAX_NUM_SCAN_SSIDS: "NL80211_ATTR_MAX_NUM_SCAN_SSIDS",
    NL80211_ATTR_SCAN_FREQUENCIES: "NL80211_ATTR_SCAN_FREQUENCIES",
    NL80211_ATTR_SCAN_SSIDS: "NL80211_ATTR_SCAN_SSIDS",
    NL80211_ATTR_GENERATION: "NL80211_ATTR_GENERATION",
    NL80211_ATTR_BSS: "NL80211_ATTR_BSS",
    NL80211_ATTR_REG_INITIATOR: "NL80211_ATTR_REG_INITIATOR",
    NL80211_ATTR_REG_TYPE: "NL80211_ATTR_REG_TYPE",
    NL80211_ATTR_SUPPORTED_COMMANDS: "NL80211_ATTR_SUPPORTED_COMMANDS",
    NL80211_ATTR_FRAME: "NL80211_ATTR_FRAME",
    NL80211_ATTR_SSID: "NL80211_ATTR_SSID",
    NL80211_ATTR_AUTH_TYPE: "NL80211_ATTR_AUTH_TYPE",
    NL80211_ATTR_REASON_CODE: "NL80211_ATTR_REASON_CODE",
    NL80211_ATTR_KEY_TYPE: "NL80211_ATTR_KEY_TYPE",
    NL80211_ATTR_MAX_SCAN_IE_LEN: "NL80211_ATTR_MAX_SCAN_IE_LEN",
    NL80211_ATTR_CIPHER_SUITES: "NL80211_ATTR_CIPHER_SUITES",
    NL80211_ATTR_FREQ_BEFORE: "NL80211_ATTR_FREQ_BEFORE",
    NL80211_ATTR_FREQ_AFTER: "NL80211_ATTR_FREQ_AFTER",
    NL80211_ATTR_FREQ_FIXED: "NL80211_ATTR_FREQ_FIXED",
    NL80211_ATTR_WIPHY_RETRY_SHORT: "NL80211_ATTR_WIPHY_RETRY_SHORT",
    NL80211_ATTR_WIPHY_RETRY_LONG: "NL80211_ATTR_WIPHY_RETRY_LONG",
    NL80211_ATTR_WIPHY_FRAG_THRESHOLD: "NL80211_ATTR_WIPHY_FRAG_THRESHOLD",
    NL80211_ATTR_WIPHY_RTS_THRESHOLD: "NL80211_ATTR_WIPHY_RTS_THRESHOLD",
    NL80211_ATTR_TIMED_OUT: "NL80211_ATTR_TIMED_OUT",
    NL80211_ATTR_USE_MFP: "NL80211_ATTR_USE_MFP",
    NL80211_ATTR_STA_FLAGS2: "NL80211_ATTR_STA_FLAGS2",
    NL80211_ATTR_CONTROL_PORT: "NL80211_ATTR_CONTROL_PORT",
    NL80211_ATTR_TESTDATA: "NL80211_ATTR_TESTDATA",
    NL80211_ATTR_PRIVACY: "NL80211_ATTR_PRIVACY",
    NL80211_ATTR_DISCONNECTED_BY_AP: "NL80211_ATTR_DISCONNECTED_BY_AP",
    NL80211_ATTR_STATUS_CODE: "NL80211_ATTR_STATUS_CODE",
    NL80211_ATTR_CIPHER_SUITES_PAIRWISE: "NL80211_ATTR_CIPHER_SUITES_PAIRWISE",
    NL80211_ATTR_CIPHER_SUITE_GROUP: "NL80211_ATTR_CIPHER_SUITE_GROUP",
    NL80211_ATTR_WPA_VERSIONS: "NL80211_ATTR_WPA_VERSIONS",
    NL80211_ATTR_AKM_SUITES: "NL80211_ATTR_AKM_SUITES",
    NL80211_ATTR_REQ_IE: "NL80211_ATTR_REQ_IE",
    NL80211_ATTR_RESP_IE: "NL80211_ATTR_RESP_IE",
    NL80211_ATTR_PREV_BSSID: "NL80211_ATTR_PREV_BSSID",
    NL80211_ATTR_KEY: "NL80211_ATTR_KEY",
    NL80211_ATTR_KEYS: "NL80211_ATTR_KEYS",
    NL80211_ATTR_PID: "NL80211_ATTR_PID",
    NL80211_ATTR_4ADDR: "NL80211_ATTR_4ADDR",
    NL80211_ATTR_SURVEY_INFO: "NL80211_ATTR_SURVEY_INFO",
    NL80211_ATTR_PMKID: "NL80211_ATTR_PMKID",
    NL80211_ATTR_MAX_NUM_PMKIDS: "NL80211_ATTR_MAX_NUM_PMKIDS",
    NL80211_ATTR_DURATION: "NL80211_ATTR_DURATION",
    NL80211_ATTR_COOKIE: "NL80211_ATTR_COOKIE",
    NL80211_ATTR_WIPHY_COVERAGE_CLASS: "NL80211_ATTR_WIPHY_COVERAGE_CLASS",
    NL80211_ATTR_TX_RATES: "NL80211_ATTR_TX_RATES",
    NL80211_ATTR_FRAME_MATCH: "NL80211_ATTR_FRAME_MATCH",
    NL80211_ATTR_ACK: "NL80211_ATTR_ACK",
    NL80211_ATTR_PS_STATE: "NL80211_ATTR_PS_STATE",
    NL80211_ATTR_CQM: "NL80211_ATTR_CQM",
    NL80211_ATTR_LOCAL_STATE_CHANGE: "NL80211_ATTR_LOCAL_STATE_CHANGE",
    NL80211_ATTR_AP_ISOLATE: "NL80211_ATTR_AP_ISOLATE",
    NL80211_ATTR_WIPHY_TX_POWER_SETTING: "NL80211_ATTR_WIPHY_TX_POWER_SETTING",
    NL80211_ATTR_WIPHY_TX_POWER_LEVEL: "NL80211_ATTR_WIPHY_TX_POWER_LEVEL",
    NL80211_ATTR_TX_FRAME_TYPES: "NL80211_ATTR_TX_FRAME_TYPES",
    NL80211_ATTR_RX_FRAME_TYPES: "NL80211_ATTR_RX_FRAME_TYPES",
    NL80211_ATTR_FRAME_TYPE: "NL80211_ATTR_FRAME_TYPE",
    NL80211_ATTR_CONTROL_PORT_ETHERTYPE: "NL80211_ATTR_CONTROL_PORT_ETHERTYPE",
    NL80211_ATTR_CONTROL_PORT_NO_ENCRYPT: "NL80211_ATTR_CONTROL_PORT_NO_ENCRYPT",
    NL80211_ATTR_SUPPORT_IBSS_RSN: "NL80211_ATTR_SUPPORT_IBSS_RSN",
    NL80211_ATTR_WIPHY_ANTENNA_TX: "NL80211_ATTR_WIPHY_ANTENNA_TX",
    NL80211_ATTR_WIPHY_ANTENNA_RX: "NL80211_ATTR_WIPHY_ANTENNA_RX",
    NL80211_ATTR_MCAST_RATE: "NL80211_ATTR_MCAST_RATE",
    NL80211_ATTR_OFFCHANNEL_TX_OK: "NL80211_ATTR_OFFCHANNEL_TX_OK",
    NL80211_ATTR_BSS_HT_OPMODE: "NL80211_ATTR_BSS_HT_OPMODE",
    NL80211_ATTR_KEY_DEFAULT_TYPES: "NL80211_ATTR_KEY_DEFAULT_TYPES",
    NL80211_ATTR_MAX_REMAIN_ON_CHANNEL_DURATION: "NL80211_ATTR_MAX_REMAIN_ON_CHANNEL_DURATION",
    NL80211_ATTR_MESH_SETUP: "NL80211_ATTR_MESH_SETUP",
    NL80211_ATTR_WIPHY_ANTENNA_AVAIL_TX: "NL80211_ATTR_WIPHY_ANTENNA_AVAIL_TX",
    NL80211_ATTR_WIPHY_ANTENNA_AVAIL_RX: "NL80211_ATTR_WIPHY_ANTENNA_AVAIL_RX",
    NL80211_ATTR_SUPPORT_MESH_AUTH: "NL80211_ATTR_SUPPORT_MESH_AUTH",
    NL80211_ATTR_STA_PLINK_STATE: "NL80211_ATTR_STA_PLINK_STATE",
    NL80211_ATTR_WOWLAN_TRIGGERS: "NL80211_ATTR_WOWLAN_TRIGGERS",
    NL80211_ATTR_WOWLAN_TRIGGERS_SUPPORTED: "NL80211_ATTR_WOWLAN_TRIGGERS_SUPPORTED",
    NL80211_ATTR_SCHED_SCAN_INTERVAL: "NL80211_ATTR_SCHED_SCAN_INTERVAL",
    NL80211_ATTR_INTERFACE_COMBINATIONS: "NL80211_ATTR_INTERFACE_COMBINATIONS",
    NL80211_ATTR_SOFTWARE_IFTYPES: "NL80211_ATTR_SOFTWARE_IFTYPES",
    NL80211_ATTR_REKEY_DATA: "NL80211_ATTR_REKEY_DATA",
    NL80211_ATTR_MAX_NUM_SCHED_SCAN_SSIDS: "NL80211_ATTR_MAX_NUM_SCHED_SCAN_SSIDS",
    NL80211_ATTR_MAX_SCHED_SCAN_IE_LEN: "NL80211_ATTR_MAX_SCHED_SCAN_IE_LEN",
    NL80211_ATTR_SCAN_SUPP_RATES: "NL80211_ATTR_SCAN_SUPP_RATES",
    NL80211_ATTR_HIDDEN_SSID: "NL80211_ATTR_HIDDEN_SSID",
    NL80211_ATTR_IE_PROBE_RESP: "NL80211_ATTR_IE_PROBE_RESP",
    NL80211_ATTR_IE_ASSOC_RESP: "NL80211_ATTR_IE_ASSOC_RESP",
    NL80211_ATTR_STA_WME: "NL80211_ATTR_STA_WME",
    NL80211_ATTR_SUPPORT_AP_UAPSD: "NL80211_ATTR_SUPPORT_AP_UAPSD",
    NL80211_ATTR_ROAM_SUPPORT: "NL80211_ATTR_ROAM_SUPPORT",
    NL80211_ATTR_SCHED_SCAN_MATCH: "NL80211_ATTR_SCHED_SCAN_MATCH",
    NL80211_ATTR_MAX_MATCH_SETS: "NL80211_ATTR_MAX_MATCH_SETS",
    NL80211_ATTR_PMKSA_CANDIDATE: "NL80211_ATTR_PMKSA_CANDIDATE",
    NL80211_ATTR_TX_NO_CCK_RATE: "NL80211_ATTR_TX_NO_CCK_RATE",
    NL80211_ATTR_TDLS_ACTION: "NL80211_ATTR_TDLS_ACTION",
    NL80211_ATTR_TDLS_DIALOG_TOKEN: "NL80211_ATTR_TDLS_DIALOG_TOKEN",
    NL80211_ATTR_TDLS_OPERATION: "NL80211_ATTR_TDLS_OPERATION",
    NL80211_ATTR_TDLS_SUPPORT: "NL80211_ATTR_TDLS_SUPPORT",
    NL80211_ATTR_TDLS_EXTERNAL_SETUP: "NL80211_ATTR_TDLS_EXTERNAL_SETUP",
    NL80211_ATTR_DEVICE_AP_SME: "NL80211_ATTR_DEVICE_AP_SME",
    NL80211_ATTR_DONT_WAIT_FOR_ACK: "NL80211_ATTR_DONT_WAIT_FOR_ACK",
    NL80211_ATTR_FEATURE_FLAGS: "NL80211_ATTR_FEATURE_FLAGS",
    NL80211_ATTR_PROBE_RESP_OFFLOAD: "NL80211_ATTR_PROBE_RESP_OFFLOAD",
    NL80211_ATTR_PROBE_RESP: "NL80211_ATTR_PROBE_RESP",
    NL80211_ATTR_DFS_REGION: "NL80211_ATTR_DFS_REGION",
    NL80211_ATTR_DISABLE_HT: "NL80211_ATTR_DISABLE_HT",
    NL80211_ATTR_HT_CAPABILITY_MASK: "NL80211_ATTR_HT_CAPABILITY_MASK",
    NL80211_ATTR_NOACK_MAP: "NL80211_ATTR_NOACK_MAP",
    NL80211_ATTR_INACTIVITY_TIMEOUT: "NL80211_ATTR_INACTIVITY_TIMEOUT",
    NL80211_ATTR_RX_SIGNAL_DBM: "NL80211_ATTR_RX_SIGNAL_DBM",
    NL80211_ATTR_BG_SCAN_PERIOD: "NL80211_ATTR_BG_SCAN_PERIOD",
    NL80211_ATTR_WDEV: "NL80211_ATTR_WDEV",
    NL80211_ATTR_USER_REG_HINT_TYPE: "NL80211_ATTR_USER_REG_HINT_TYPE",
    NL80211_ATTR_CONN_FAILED_REASON: "NL80211_ATTR_CONN_FAILED_REASON",
    NL80211_ATTR_SAE_DATA: "NL80211_ATTR_SAE_DATA",
    NL80211_ATTR_VHT_CAPABILITY: "NL80211_ATTR_VHT_CAPABILITY",
    NL80211_ATTR_SCAN_FLAGS: "NL80211_ATTR_SCAN_FLAGS",
    NL80211_ATTR_CHANNEL_WIDTH: "NL80211_ATTR_CHANNEL_WIDTH",
    NL80211_ATTR_CENTER_FREQ1: "NL80211_ATTR_CENTER_FREQ1",
    NL80211_ATTR_CENTER_FREQ2: "NL80211_ATTR_CENTER_FREQ2",
    NL80211_ATTR_P2P_CTWINDOW: "NL80211_ATTR_P2P_CTWINDOW",
    NL80211_ATTR_P2P_OPPPS: "NL80211_ATTR_P2P_OPPPS",
    NL80211_ATTR_LOCAL_MESH_POWER_MODE: "NL80211_ATTR_LOCAL_MESH_POWER_MODE",
    NL80211_ATTR_ACL_POLICY: "NL80211_ATTR_ACL_POLICY",
    NL80211_ATTR_MAC_ADDRS: "NL80211_ATTR_MAC_ADDRS",
    NL80211_ATTR_MAC_ACL_MAX: "NL80211_ATTR_MAC_ACL_MAX",
    NL80211_ATTR_RADAR_EVENT: "NL80211_ATTR_RADAR_EVENT",
    NL80211_ATTR_EXT_CAPA: "NL80211_ATTR_EXT_CAPA",
    NL80211_ATTR_EXT_CAPA_MASK: "NL80211_ATTR_EXT_CAPA_MASK",
    NL80211_ATTR_STA_CAPABILITY: "NL80211_ATTR_STA_CAPABILITY",
    NL80211_ATTR_STA_EXT_CAPABILITY: "NL80211_ATTR_STA_EXT_CAPABILITY",
    NL80211_ATTR_PROTOCOL_FEATURES: "NL80211_ATTR_PROTOCOL_FEATURES",
    NL80211_ATTR_SPLIT_WIPHY_DUMP: "NL80211_ATTR_SPLIT_WIPHY_DUMP",
    NL80211_ATTR_DISABLE_VHT: "NL80211_ATTR_DISABLE_VHT",
    NL80211_ATTR_VHT_CAPABILITY_MASK: "NL80211_ATTR_VHT_CAPABILITY_MASK",
    NL80211_ATTR_MDID: "NL80211_ATTR_MDID",
    NL80211_ATTR_IE_RIC: "NL80211_ATTR_IE_RIC",
    NL80211_ATTR_CRIT_PROT_ID: "NL80211_ATTR_CRIT_PROT_ID",
    NL80211_ATTR_MAX_CRIT_PROT_DURATION: "NL80211_ATTR_MAX_CRIT_PROT_DURATION",
    NL80211_ATTR_PEER_AID: "NL80211_ATTR_PEER_AID",
    __NL80211_ATTR_AFTER_LAST: "__NL80211_ATTR_AFTER_LAST",
}
nl80211_iftype2str = {
    NL80211_IFTYPE_UNSPECIFIED: "NL80211_IFTYPE_UNSPECIFIED",
    NL80211_IFTYPE_ADHOC: "NL80211_IFTYPE_ADHOC",
    NL80211_IFTYPE_STATION: "NL80211_IFTYPE_STATION",
    NL80211_IFTYPE_AP: "NL80211_IFTYPE_AP",
    NL80211_IFTYPE_AP_VLAN: "NL80211_IFTYPE_AP_VLAN",
    NL80211_IFTYPE_WDS: "NL80211_IFTYPE_WDS",
    NL80211_IFTYPE_MONITOR: "NL80211_IFTYPE_MONITOR",
    NL80211_IFTYPE_MESH_POINT: "NL80211_IFTYPE_MESH_POINT",
    NL80211_IFTYPE_P2P_CLIENT: "NL80211_IFTYPE_P2P_CLIENT",
    NL80211_IFTYPE_P2P_GO: "NL80211_IFTYPE_P2P_GO",
    NL80211_IFTYPE_P2P_DEVICE: "NL80211_IFTYPE_P2P_DEVICE",
    NUM_NL80211_IFTYPES: "NUM_NL80211_IFTYPES",
}
nl80211_sta_flags2str = {
    __NL80211_STA_FLAG_INVALID: "__NL80211_STA_FLAG_INVALID",
    NL80211_STA_FLAG_AUTHORIZED: "NL80211_STA_FLAG_AUTHORIZED",
    NL80211_STA_FLAG_SHORT_PREAMBLE: "NL80211_STA_FLAG_SHORT_PREAMBLE",
    NL80211_STA_FLAG_WME: "NL80211_STA_FLAG_WME",
    NL80211_STA_FLAG_MFP: "NL80211_STA_FLAG_MFP",
    NL80211_STA_FLAG_AUTHENTICATED: "NL80211_STA_FLAG_AUTHENTICATED",
    NL80211_STA_FLAG_TDLS_PEER: "NL80211_STA_FLAG_TDLS_PEER",
    NL80211_STA_FLAG_ASSOCIATED: "NL80211_STA_FLAG_ASSOCIATED",
    __NL80211_STA_FLAG_AFTER_LAST: "__NL80211_STA_FLAG_AFTER_LAST",
}
nl80211_rate_info2str = {
    __NL80211_RATE_INFO_INVALID: "__NL80211_RATE_INFO_INVALID",
    NL80211_RATE_INFO_BITRATE: "NL80211_RATE_INFO_BITRATE",
    NL80211_RATE_INFO_MCS: "NL80211_RATE_INFO_MCS",
    NL80211_RATE_INFO_40_MHZ_WIDTH: "NL80211_RATE_INFO_40_MHZ_WIDTH",
    NL80211_RATE_INFO_SHORT_GI: "NL80211_RATE_INFO_SHORT_GI",
    NL80211_RATE_INFO_BITRATE32: "NL80211_RATE_INFO_BITRATE32",
    NL80211_RATE_INFO_VHT_MCS: "NL80211_RATE_INFO_VHT_MCS",
    NL80211_RATE_INFO_VHT_NSS: "NL80211_RATE_INFO_VHT_NSS",
    NL80211_RATE_INFO_80_MHZ_WIDTH: "NL80211_RATE_INFO_80_MHZ_WIDTH",
    NL80211_RATE_INFO_80P80_MHZ_WIDTH: "NL80211_RATE_INFO_80P80_MHZ_WIDTH",
    NL80211_RATE_INFO_160_MHZ_WIDTH: "NL80211_RATE_INFO_160_MHZ_WIDTH",
    __NL80211_RATE_INFO_AFTER_LAST: "__NL80211_RATE_INFO_AFTER_LAST",
}
nl80211_sta_bss_param2str = {
    __NL80211_STA_BSS_PARAM_INVALID: "__NL80211_STA_BSS_PARAM_INVALID",
    NL80211_STA_BSS_PARAM_CTS_PROT: "NL80211_STA_BSS_PARAM_CTS_PROT",
    NL80211_STA_BSS_PARAM_SHORT_PREAMBLE: "NL80211_STA_BSS_PARAM_SHORT_PREAMBLE",
    NL80211_STA_BSS_PARAM_SHORT_SLOT_TIME: "NL80211_STA_BSS_PARAM_SHORT_SLOT_TIME",
    NL80211_STA_BSS_PARAM_DTIM_PERIOD: "NL80211_STA_BSS_PARAM_DTIM_PERIOD",
    NL80211_STA_BSS_PARAM_BEACON_INTERVAL: "NL80211_STA_BSS_PARAM_BEACON_INTERVAL",
    __NL80211_STA_BSS_PARAM_AFTER_LAST: "__NL80211_STA_BSS_PARAM_AFTER_LAST",
}
nl80211_sta_info2str = {
    __NL80211_STA_INFO_INVALID: "__NL80211_STA_INFO_INVALID",
    NL80211_STA_INFO_INACTIVE_TIME: "NL80211_STA_INFO_INACTIVE_TIME",
    NL80211_STA_INFO_RX_BYTES: "NL80211_STA_INFO_RX_BYTES",
    NL80211_STA_INFO_TX_BYTES: "NL80211_STA_INFO_TX_BYTES",
    NL80211_STA_INFO_LLID: "NL80211_STA_INFO_LLID",
    NL80211_STA_INFO_PLID: "NL80211_STA_INFO_PLID",
    NL80211_STA_INFO_PLINK_STATE: "NL80211_STA_INFO_PLINK_STATE",
    NL80211_STA_INFO_SIGNAL: "NL80211_STA_INFO_SIGNAL",
    NL80211_STA_INFO_TX_BITRATE: "NL80211_STA_INFO_TX_BITRATE",
    NL80211_STA_INFO_RX_PACKETS: "NL80211_STA_INFO_RX_PACKETS",
    NL80211_STA_INFO_TX_PACKETS: "NL80211_STA_INFO_TX_PACKETS",
    NL80211_STA_INFO_TX_RETRIES: "NL80211_STA_INFO_TX_RETRIES",
    NL80211_STA_INFO_TX_FAILED: "NL80211_STA_INFO_TX_FAILED",
    NL80211_STA_INFO_SIGNAL_AVG: "NL80211_STA_INFO_SIGNAL_AVG",
    NL80211_STA_INFO_RX_BITRATE: "NL80211_STA_INFO_RX_BITRATE",
    NL80211_STA_INFO_BSS_PARAM: "NL80211_STA_INFO_BSS_PARAM",
    NL80211_STA_INFO_CONNECTED_TIME: "NL80211_STA_INFO_CONNECTED_TIME",
    NL80211_STA_INFO_STA_FLAGS: "NL80211_STA_INFO_STA_FLAGS",
    NL80211_STA_INFO_BEACON_LOSS: "NL80211_STA_INFO_BEACON_LOSS",
    NL80211_STA_INFO_T_OFFSET: "NL80211_STA_INFO_T_OFFSET",
    NL80211_STA_INFO_LOCAL_PM: "NL80211_STA_INFO_LOCAL_PM",
    NL80211_STA_INFO_PEER_PM: "NL80211_STA_INFO_PEER_PM",
    NL80211_STA_INFO_NONPEER_PM: "NL80211_STA_INFO_NONPEER_PM",
    NL80211_STA_INFO_RX_BYTES64: "NL80211_STA_INFO_RX_BYTES64",
    NL80211_STA_INFO_TX_BYTES64: "NL80211_STA_INFO_TX_BYTES64",
    NL80211_STA_INFO_CHAIN_SIGNAL: "NL80211_STA_INFO_CHAIN_SIGNAL",
    NL80211_STA_INFO_CHAIN_SIGNAL_AVG: "NL80211_STA_INFO_CHAIN_SIGNAL_AVG",
    __NL80211_STA_INFO_AFTER_LAST: "__NL80211_STA_INFO_AFTER_LAST",
}
nl80211_mpath_flags2str = {
    NL80211_MPATH_FLAG_ACTIVE: "NL80211_MPATH_FLAG_ACTIVE",
    NL80211_MPATH_FLAG_RESOLVING: "NL80211_MPATH_FLAG_RESOLVING",
    NL80211_MPATH_FLAG_SN_VALID: "NL80211_MPATH_FLAG_SN_VALID",
    NL80211_MPATH_FLAG_FIXED: "NL80211_MPATH_FLAG_FIXED",
    NL80211_MPATH_FLAG_RESOLVED: "NL80211_MPATH_FLAG_RESOLVED",
}
nl80211_mpath_info2str = {
    __NL80211_MPATH_INFO_INVALID: "__NL80211_MPATH_INFO_INVALID",
    NL80211_MPATH_INFO_FRAME_QLEN: "NL80211_MPATH_INFO_FRAME_QLEN",
    NL80211_MPATH_INFO_SN: "NL80211_MPATH_INFO_SN",
    NL80211_MPATH_INFO_METRIC: "NL80211_MPATH_INFO_METRIC",
    NL80211_MPATH_INFO_EXPTIME: "NL80211_MPATH_INFO_EXPTIME",
    NL80211_MPATH_INFO_FLAGS: "NL80211_MPATH_INFO_FLAGS",
    NL80211_MPATH_INFO_DISCOVERY_TIMEOUT: "NL80211_MPATH_INFO_DISCOVERY_TIMEOUT",
    NL80211_MPATH_INFO_DISCOVERY_RETRIES: "NL80211_MPATH_INFO_DISCOVERY_RETRIES",
    __NL80211_MPATH_INFO_AFTER_LAST: "__NL80211_MPATH_INFO_AFTER_LAST",
}
nl80211_band_attr2str = {
    __NL80211_BAND_ATTR_INVALID: "__NL80211_BAND_ATTR_INVALID",
    NL80211_BAND_ATTR_FREQS: "NL80211_BAND_ATTR_FREQS",
    NL80211_BAND_ATTR_RATES: "NL80211_BAND_ATTR_RATES",
    NL80211_BAND_ATTR_HT_MCS_SET: "NL80211_BAND_ATTR_HT_MCS_SET",
    NL80211_BAND_ATTR_HT_CAPA: "NL80211_BAND_ATTR_HT_CAPA",
    NL80211_BAND_ATTR_HT_AMPDU_FACTOR: "NL80211_BAND_ATTR_HT_AMPDU_FACTOR",
    NL80211_BAND_ATTR_HT_AMPDU_DENSITY: "NL80211_BAND_ATTR_HT_AMPDU_DENSITY",
    NL80211_BAND_ATTR_VHT_MCS_SET: "NL80211_BAND_ATTR_VHT_MCS_SET",
    NL80211_BAND_ATTR_VHT_CAPA: "NL80211_BAND_ATTR_VHT_CAPA",
    __NL80211_BAND_ATTR_AFTER_LAST: "__NL80211_BAND_ATTR_AFTER_LAST",
}
nl80211_frequency_attr2str = {
    __NL80211_FREQUENCY_ATTR_INVALID: "__NL80211_FREQUENCY_ATTR_INVALID",
    NL80211_FREQUENCY_ATTR_FREQ: "NL80211_FREQUENCY_ATTR_FREQ",
    NL80211_FREQUENCY_ATTR_DISABLED: "NL80211_FREQUENCY_ATTR_DISABLED",
    NL80211_FREQUENCY_ATTR_PASSIVE_SCAN: "NL80211_FREQUENCY_ATTR_PASSIVE_SCAN",
    NL80211_FREQUENCY_ATTR_NO_IBSS: "NL80211_FREQUENCY_ATTR_NO_IBSS",
    NL80211_FREQUENCY_ATTR_RADAR: "NL80211_FREQUENCY_ATTR_RADAR",
    NL80211_FREQUENCY_ATTR_MAX_TX_POWER: "NL80211_FREQUENCY_ATTR_MAX_TX_POWER",
    NL80211_FREQUENCY_ATTR_DFS_STATE: "NL80211_FREQUENCY_ATTR_DFS_STATE",
    NL80211_FREQUENCY_ATTR_DFS_TIME: "NL80211_FREQUENCY_ATTR_DFS_TIME",
    NL80211_FREQUENCY_ATTR_NO_HT40_MINUS: "NL80211_FREQUENCY_ATTR_NO_HT40_MINUS",
    NL80211_FREQUENCY_ATTR_NO_HT40_PLUS: "NL80211_FREQUENCY_ATTR_NO_HT40_PLUS",
    NL80211_FREQUENCY_ATTR_NO_80MHZ: "NL80211_FREQUENCY_ATTR_NO_80MHZ",
    NL80211_FREQUENCY_ATTR_NO_160MHZ: "NL80211_FREQUENCY_ATTR_NO_160MHZ",
    __NL80211_FREQUENCY_ATTR_AFTER_LAST: "__NL80211_FREQUENCY_ATTR_AFTER_LAST",
}
nl80211_bitrate_attr2str = {
    __NL80211_BITRATE_ATTR_INVALID: "__NL80211_BITRATE_ATTR_INVALID",
    NL80211_BITRATE_ATTR_RATE: "NL80211_BITRATE_ATTR_RATE",
    NL80211_BITRATE_ATTR_2GHZ_SHORTPREAMBLE: "NL80211_BITRATE_ATTR_2GHZ_SHORTPREAMBLE",
    __NL80211_BITRATE_ATTR_AFTER_LAST: "__NL80211_BITRATE_ATTR_AFTER_LAST",
}
nl80211_reg_initiator2str = {
    NL80211_REGDOM_SET_BY_CORE: "NL80211_REGDOM_SET_BY_CORE",
    NL80211_REGDOM_SET_BY_USER: "NL80211_REGDOM_SET_BY_USER",
    NL80211_REGDOM_SET_BY_DRIVER: "NL80211_REGDOM_SET_BY_DRIVER",
    NL80211_REGDOM_SET_BY_COUNTRY_IE: "NL80211_REGDOM_SET_BY_COUNTRY_IE",
}
nl80211_reg_type2str = {
    NL80211_REGDOM_TYPE_COUNTRY: "NL80211_REGDOM_TYPE_COUNTRY",
    NL80211_REGDOM_TYPE_WORLD: "NL80211_REGDOM_TYPE_WORLD",
    NL80211_REGDOM_TYPE_CUSTOM_WORLD: "NL80211_REGDOM_TYPE_CUSTOM_WORLD",
    NL80211_REGDOM_TYPE_INTERSECTION: "NL80211_REGDOM_TYPE_INTERSECTION",
}
nl80211_reg_rule_attr2str = {
    __NL80211_REG_RULE_ATTR_INVALID: "__NL80211_REG_RULE_ATTR_INVALID",
    NL80211_ATTR_REG_RULE_FLAGS: "NL80211_ATTR_REG_RULE_FLAGS",
    NL80211_ATTR_FREQ_RANGE_START: "NL80211_ATTR_FREQ_RANGE_START",
    NL80211_ATTR_FREQ_RANGE_END: "NL80211_ATTR_FREQ_RANGE_END",
    NL80211_ATTR_FREQ_RANGE_MAX_BW: "NL80211_ATTR_FREQ_RANGE_MAX_BW",
    NL80211_ATTR_POWER_RULE_MAX_ANT_GAIN: "NL80211_ATTR_POWER_RULE_MAX_ANT_GAIN",
    NL80211_ATTR_POWER_RULE_MAX_EIRP: "NL80211_ATTR_POWER_RULE_MAX_EIRP",
    __NL80211_REG_RULE_ATTR_AFTER_LAST: "__NL80211_REG_RULE_ATTR_AFTER_LAST",
}
nl80211_sched_scan_match_attr2str = {
    __NL80211_SCHED_SCAN_MATCH_ATTR_INVALID: "__NL80211_SCHED_SCAN_MATCH_ATTR_INVALID",
    NL80211_SCHED_SCAN_MATCH_ATTR_SSID: "NL80211_SCHED_SCAN_MATCH_ATTR_SSID",
    NL80211_SCHED_SCAN_MATCH_ATTR_RSSI: "NL80211_SCHED_SCAN_MATCH_ATTR_RSSI",
    __NL80211_SCHED_SCAN_MATCH_ATTR_AFTER_LAST: "__NL80211_SCHED_SCAN_MATCH_ATTR_AFTER_LAST",
}
nl80211_reg_rule_flags2str = {
    NL80211_RRF_NO_OFDM: "NL80211_RRF_NO_OFDM",
    NL80211_RRF_NO_CCK: "NL80211_RRF_NO_CCK",
    NL80211_RRF_NO_INDOOR: "NL80211_RRF_NO_INDOOR",
    NL80211_RRF_NO_OUTDOOR: "NL80211_RRF_NO_OUTDOOR",
    NL80211_RRF_DFS: "NL80211_RRF_DFS",
    NL80211_RRF_PTP_ONLY: "NL80211_RRF_PTP_ONLY",
    NL80211_RRF_PTMP_ONLY: "NL80211_RRF_PTMP_ONLY",
    NL80211_RRF_PASSIVE_SCAN: "NL80211_RRF_PASSIVE_SCAN",
    NL80211_RRF_NO_IBSS: "NL80211_RRF_NO_IBSS",
}
nl80211_dfs_regions2str = {}
nl80211_user_reg_hint_type2str = {}
nl80211_survey_info2str = {
    __NL80211_SURVEY_INFO_INVALID: "__NL80211_SURVEY_INFO_INVALID",
    NL80211_SURVEY_INFO_FREQUENCY: "NL80211_SURVEY_INFO_FREQUENCY",
    NL80211_SURVEY_INFO_NOISE: "NL80211_SURVEY_INFO_NOISE",
    NL80211_SURVEY_INFO_IN_USE: "NL80211_SURVEY_INFO_IN_USE",
    NL80211_SURVEY_INFO_CHANNEL_TIME: "NL80211_SURVEY_INFO_CHANNEL_TIME",
    NL80211_SURVEY_INFO_CHANNEL_TIME_BUSY: "NL80211_SURVEY_INFO_CHANNEL_TIME_BUSY",
    NL80211_SURVEY_INFO_CHANNEL_TIME_EXT_BUSY: "NL80211_SURVEY_INFO_CHANNEL_TIME_EXT_BUSY",
    NL80211_SURVEY_INFO_CHANNEL_TIME_RX: "NL80211_SURVEY_INFO_CHANNEL_TIME_RX",
    NL80211_SURVEY_INFO_CHANNEL_TIME_TX: "NL80211_SURVEY_INFO_CHANNEL_TIME_TX",
    __NL80211_SURVEY_INFO_AFTER_LAST: "__NL80211_SURVEY_INFO_AFTER_LAST",
}
nl80211_mntr_flags2str = {
    __NL80211_MNTR_FLAG_INVALID: "__NL80211_MNTR_FLAG_INVALID",
    NL80211_MNTR_FLAG_FCSFAIL: "NL80211_MNTR_FLAG_FCSFAIL",
    NL80211_MNTR_FLAG_PLCPFAIL: "NL80211_MNTR_FLAG_PLCPFAIL",
    NL80211_MNTR_FLAG_CONTROL: "NL80211_MNTR_FLAG_CONTROL",
    NL80211_MNTR_FLAG_OTHER_BSS: "NL80211_MNTR_FLAG_OTHER_BSS",
    NL80211_MNTR_FLAG_COOK_FRAMES: "NL80211_MNTR_FLAG_COOK_FRAMES",
    NL80211_MNTR_FLAG_ACTIVE: "NL80211_MNTR_FLAG_ACTIVE",
    __NL80211_MNTR_FLAG_AFTER_LAST: "__NL80211_MNTR_FLAG_AFTER_LAST",
}
nl80211_mesh_power_mode2str = {
    NL80211_MESH_POWER_UNKNOWN: "NL80211_MESH_POWER_UNKNOWN",
    NL80211_MESH_POWER_ACTIVE: "NL80211_MESH_POWER_ACTIVE",
    NL80211_MESH_POWER_LIGHT_SLEEP: "NL80211_MESH_POWER_LIGHT_SLEEP",
    NL80211_MESH_POWER_DEEP_SLEEP: "NL80211_MESH_POWER_DEEP_SLEEP",
    __NL80211_MESH_POWER_AFTER_LAST: "__NL80211_MESH_POWER_AFTER_LAST",
}
nl80211_meshconf_params2str = {
    __NL80211_MESHCONF_INVALID: "__NL80211_MESHCONF_INVALID",
    NL80211_MESHCONF_RETRY_TIMEOUT: "NL80211_MESHCONF_RETRY_TIMEOUT",
    NL80211_MESHCONF_CONFIRM_TIMEOUT: "NL80211_MESHCONF_CONFIRM_TIMEOUT",
    NL80211_MESHCONF_HOLDING_TIMEOUT: "NL80211_MESHCONF_HOLDING_TIMEOUT",
    NL80211_MESHCONF_MAX_PEER_LINKS: "NL80211_MESHCONF_MAX_PEER_LINKS",
    NL80211_MESHCONF_MAX_RETRIES: "NL80211_MESHCONF_MAX_RETRIES",
    NL80211_MESHCONF_TTL: "NL80211_MESHCONF_TTL",
    NL80211_MESHCONF_AUTO_OPEN_PLINKS: "NL80211_MESHCONF_AUTO_OPEN_PLINKS",
    NL80211_MESHCONF_HWMP_MAX_PREQ_RETRIES: "NL80211_MESHCONF_HWMP_MAX_PREQ_RETRIES",
    NL80211_MESHCONF_PATH_REFRESH_TIME: "NL80211_MESHCONF_PATH_REFRESH_TIME",
    NL80211_MESHCONF_MIN_DISCOVERY_TIMEOUT: "NL80211_MESHCONF_MIN_DISCOVERY_TIMEOUT",
    NL80211_MESHCONF_HWMP_ACTIVE_PATH_TIMEOUT: "NL80211_MESHCONF_HWMP_ACTIVE_PATH_TIMEOUT",
    NL80211_MESHCONF_HWMP_PREQ_MIN_INTERVAL: "NL80211_MESHCONF_HWMP_PREQ_MIN_INTERVAL",
    NL80211_MESHCONF_HWMP_NET_DIAM_TRVS_TIME: "NL80211_MESHCONF_HWMP_NET_DIAM_TRVS_TIME",
    NL80211_MESHCONF_HWMP_ROOTMODE: "NL80211_MESHCONF_HWMP_ROOTMODE",
    NL80211_MESHCONF_ELEMENT_TTL: "NL80211_MESHCONF_ELEMENT_TTL",
    NL80211_MESHCONF_HWMP_RANN_INTERVAL: "NL80211_MESHCONF_HWMP_RANN_INTERVAL",
    NL80211_MESHCONF_GATE_ANNOUNCEMENTS: "NL80211_MESHCONF_GATE_ANNOUNCEMENTS",
    NL80211_MESHCONF_HWMP_PERR_MIN_INTERVAL: "NL80211_MESHCONF_HWMP_PERR_MIN_INTERVAL",
    NL80211_MESHCONF_FORWARDING: "NL80211_MESHCONF_FORWARDING",
    NL80211_MESHCONF_RSSI_THRESHOLD: "NL80211_MESHCONF_RSSI_THRESHOLD",
    NL80211_MESHCONF_SYNC_OFFSET_MAX_NEIGHBOR: "NL80211_MESHCONF_SYNC_OFFSET_MAX_NEIGHBOR",
    NL80211_MESHCONF_HT_OPMODE: "NL80211_MESHCONF_HT_OPMODE",
    NL80211_MESHCONF_HWMP_PATH_TO_ROOT_TIMEOUT: "NL80211_MESHCONF_HWMP_PATH_TO_ROOT_TIMEOUT",
    NL80211_MESHCONF_HWMP_ROOT_INTERVAL: "NL80211_MESHCONF_HWMP_ROOT_INTERVAL",
    NL80211_MESHCONF_HWMP_CONFIRMATION_INTERVAL: "NL80211_MESHCONF_HWMP_CONFIRMATION_INTERVAL",
    NL80211_MESHCONF_POWER_MODE: "NL80211_MESHCONF_POWER_MODE",
    NL80211_MESHCONF_AWAKE_WINDOW: "NL80211_MESHCONF_AWAKE_WINDOW",
    NL80211_MESHCONF_PLINK_TIMEOUT: "NL80211_MESHCONF_PLINK_TIMEOUT",
    __NL80211_MESHCONF_ATTR_AFTER_LAST: "__NL80211_MESHCONF_ATTR_AFTER_LAST",
}
nl80211_mesh_setup_params2str = {
    __NL80211_MESH_SETUP_INVALID: "__NL80211_MESH_SETUP_INVALID",
    NL80211_MESH_SETUP_ENABLE_VENDOR_PATH_SEL: "NL80211_MESH_SETUP_ENABLE_VENDOR_PATH_SEL",
    NL80211_MESH_SETUP_ENABLE_VENDOR_METRIC: "NL80211_MESH_SETUP_ENABLE_VENDOR_METRIC",
    NL80211_MESH_SETUP_IE: "NL80211_MESH_SETUP_IE",
    NL80211_MESH_SETUP_USERSPACE_AUTH: "NL80211_MESH_SETUP_USERSPACE_AUTH",
    NL80211_MESH_SETUP_USERSPACE_AMPE: "NL80211_MESH_SETUP_USERSPACE_AMPE",
    NL80211_MESH_SETUP_ENABLE_VENDOR_SYNC: "NL80211_MESH_SETUP_ENABLE_VENDOR_SYNC",
    NL80211_MESH_SETUP_USERSPACE_MPM: "NL80211_MESH_SETUP_USERSPACE_MPM",
    NL80211_MESH_SETUP_AUTH_PROTOCOL: "NL80211_MESH_SETUP_AUTH_PROTOCOL",
    __NL80211_MESH_SETUP_ATTR_AFTER_LAST: "__NL80211_MESH_SETUP_ATTR_AFTER_LAST",
}
nl80211_txq_attr2str = {
    __NL80211_TXQ_ATTR_INVALID: "__NL80211_TXQ_ATTR_INVALID",
    NL80211_TXQ_ATTR_AC: "NL80211_TXQ_ATTR_AC",
    NL80211_TXQ_ATTR_TXOP: "NL80211_TXQ_ATTR_TXOP",
    NL80211_TXQ_ATTR_CWMIN: "NL80211_TXQ_ATTR_CWMIN",
    NL80211_TXQ_ATTR_CWMAX: "NL80211_TXQ_ATTR_CWMAX",
    NL80211_TXQ_ATTR_AIFS: "NL80211_TXQ_ATTR_AIFS",
    __NL80211_TXQ_ATTR_AFTER_LAST: "__NL80211_TXQ_ATTR_AFTER_LAST",
}
nl80211_ac2str = {
    NL80211_AC_VO: "NL80211_AC_VO",
    NL80211_AC_VI: "NL80211_AC_VI",
    NL80211_AC_BE: "NL80211_AC_BE",
    NL80211_AC_BK: "NL80211_AC_BK",
    NL80211_NUM_ACS: "NL80211_NUM_ACS",
}
nl80211_channel_type2str = {
    NL80211_CHAN_NO_HT: "NL80211_CHAN_NO_HT",
    NL80211_CHAN_HT20: "NL80211_CHAN_HT20",
    NL80211_CHAN_HT40MINUS: "NL80211_CHAN_HT40MINUS",
    NL80211_CHAN_HT40PLUS: "NL80211_CHAN_HT40PLUS",
}
nl80211_chan_width2str = {
    NL80211_CHAN_WIDTH_20_NOHT: "NL80211_CHAN_WIDTH_20_NOHT",
    NL80211_CHAN_WIDTH_20: "NL80211_CHAN_WIDTH_20",
    NL80211_CHAN_WIDTH_40: "NL80211_CHAN_WIDTH_40",
    NL80211_CHAN_WIDTH_80: "NL80211_CHAN_WIDTH_80",
    NL80211_CHAN_WIDTH_80P80: "NL80211_CHAN_WIDTH_80P80",
    NL80211_CHAN_WIDTH_160: "NL80211_CHAN_WIDTH_160",
}
nl80211_bss2str = {
    __NL80211_BSS_INVALID: "__NL80211_BSS_INVALID",
    NL80211_BSS_BSSID: "NL80211_BSS_BSSID",
    NL80211_BSS_FREQUENCY: "NL80211_BSS_FREQUENCY",
    NL80211_BSS_TSF: "NL80211_BSS_TSF",
    NL80211_BSS_BEACON_INTERVAL: "NL80211_BSS_BEACON_INTERVAL",
    NL80211_BSS_CAPABILITY: "NL80211_BSS_CAPABILITY",
    NL80211_BSS_INFORMATION_ELEMENTS: "NL80211_BSS_INFORMATION_ELEMENTS",
    NL80211_BSS_SIGNAL_MBM: "NL80211_BSS_SIGNAL_MBM",
    NL80211_BSS_SIGNAL_UNSPEC: "NL80211_BSS_SIGNAL_UNSPEC",
    NL80211_BSS_STATUS: "NL80211_BSS_STATUS",
    NL80211_BSS_SEEN_MS_AGO: "NL80211_BSS_SEEN_MS_AGO",
    NL80211_BSS_BEACON_IES: "NL80211_BSS_BEACON_IES",
    __NL80211_BSS_AFTER_LAST: "__NL80211_BSS_AFTER_LAST",
}
nl80211_bss_status2str = {
    NL80211_BSS_STATUS_AUTHENTICATED: "NL80211_BSS_STATUS_AUTHENTICATED",
    NL80211_BSS_STATUS_ASSOCIATED: "NL80211_BSS_STATUS_ASSOCIATED",
    NL80211_BSS_STATUS_IBSS_JOINED: "NL80211_BSS_STATUS_IBSS_JOINED",
}
nl80211_auth_type2str = {
    NL80211_AUTHTYPE_OPEN_SYSTEM: "NL80211_AUTHTYPE_OPEN_SYSTEM",
    NL80211_AUTHTYPE_SHARED_KEY: "NL80211_AUTHTYPE_SHARED_KEY",
    NL80211_AUTHTYPE_FT: "NL80211_AUTHTYPE_FT",
    NL80211_AUTHTYPE_NETWORK_EAP: "NL80211_AUTHTYPE_NETWORK_EAP",
    NL80211_AUTHTYPE_SAE: "NL80211_AUTHTYPE_SAE",
    __NL80211_AUTHTYPE_NUM: "__NL80211_AUTHTYPE_NUM",
    NL80211_AUTHTYPE_AUTOMATIC: "NL80211_AUTHTYPE_AUTOMATIC",
}
nl80211_key_type2str = {
    NL80211_KEYTYPE_GROUP: "NL80211_KEYTYPE_GROUP",
    NL80211_KEYTYPE_PAIRWISE: "NL80211_KEYTYPE_PAIRWISE",
    NL80211_KEYTYPE_PEERKEY: "NL80211_KEYTYPE_PEERKEY",
    NUM_NL80211_KEYTYPES: "NUM_NL80211_KEYTYPES",
}
nl80211_mfp2str = {
    NL80211_MFP_NO: "NL80211_MFP_NO",
    NL80211_MFP_REQUIRED: "NL80211_MFP_REQUIRED",
}
nl80211_wpa_versions2str = {
    NL80211_WPA_VERSION_1: "NL80211_WPA_VERSION_1",
    NL80211_WPA_VERSION_2: "NL80211_WPA_VERSION_2",
}
nl80211_key_default_types2str = {
    __NL80211_KEY_DEFAULT_TYPE_INVALID: "__NL80211_KEY_DEFAULT_TYPE_INVALID",
    NL80211_KEY_DEFAULT_TYPE_UNICAST: "NL80211_KEY_DEFAULT_TYPE_UNICAST",
    NL80211_KEY_DEFAULT_TYPE_MULTICAST: "NL80211_KEY_DEFAULT_TYPE_MULTICAST",
    NUM_NL80211_KEY_DEFAULT_TYPES: "NUM_NL80211_KEY_DEFAULT_TYPES",
}
nl80211_key_attributes2str = {
    __NL80211_KEY_INVALID: "__NL80211_KEY_INVALID",
    NL80211_KEY_DATA: "NL80211_KEY_DATA",
    NL80211_KEY_IDX: "NL80211_KEY_IDX",
    NL80211_KEY_CIPHER: "NL80211_KEY_CIPHER",
    NL80211_KEY_SEQ: "NL80211_KEY_SEQ",
    NL80211_KEY_DEFAULT: "NL80211_KEY_DEFAULT",
    NL80211_KEY_DEFAULT_MGMT: "NL80211_KEY_DEFAULT_MGMT",
    NL80211_KEY_TYPE: "NL80211_KEY_TYPE",
    NL80211_KEY_DEFAULT_TYPES: "NL80211_KEY_DEFAULT_TYPES",
    __NL80211_KEY_AFTER_LAST: "__NL80211_KEY_AFTER_LAST",
}
nl80211_tx_rate_attributes2str = {
    __NL80211_TXRATE_INVALID: "__NL80211_TXRATE_INVALID",
    NL80211_TXRATE_LEGACY: "NL80211_TXRATE_LEGACY",
    NL80211_TXRATE_MCS: "NL80211_TXRATE_MCS",
    __NL80211_TXRATE_AFTER_LAST: "__NL80211_TXRATE_AFTER_LAST",
}
nl80211_band2str = {
    NL80211_BAND_2GHZ: "NL80211_BAND_2GHZ",
    NL80211_BAND_5GHZ: "NL80211_BAND_5GHZ",
    NL80211_BAND_60GHZ: "NL80211_BAND_60GHZ",
}
nl80211_ps_state2str = {
    NL80211_PS_DISABLED: "NL80211_PS_DISABLED",
    NL80211_PS_ENABLED: "NL80211_PS_ENABLED",
}
nl80211_attr_cqm2str = {
    __NL80211_ATTR_CQM_INVALID: "__NL80211_ATTR_CQM_INVALID",
    NL80211_ATTR_CQM_RSSI_THOLD: "NL80211_ATTR_CQM_RSSI_THOLD",
    NL80211_ATTR_CQM_RSSI_HYST: "NL80211_ATTR_CQM_RSSI_HYST",
    NL80211_ATTR_CQM_RSSI_THRESHOLD_EVENT: "NL80211_ATTR_CQM_RSSI_THRESHOLD_EVENT",
    NL80211_ATTR_CQM_PKT_LOSS_EVENT: "NL80211_ATTR_CQM_PKT_LOSS_EVENT",
    NL80211_ATTR_CQM_TXE_RATE: "NL80211_ATTR_CQM_TXE_RATE",
    NL80211_ATTR_CQM_TXE_PKTS: "NL80211_ATTR_CQM_TXE_PKTS",
    NL80211_ATTR_CQM_TXE_INTVL: "NL80211_ATTR_CQM_TXE_INTVL",
    __NL80211_ATTR_CQM_AFTER_LAST: "__NL80211_ATTR_CQM_AFTER_LAST",
}
nl80211_cqm_rssi_threshold_event2str = {
    NL80211_CQM_RSSI_THRESHOLD_EVENT_LOW: "NL80211_CQM_RSSI_THRESHOLD_EVENT_LOW",
    NL80211_CQM_RSSI_THRESHOLD_EVENT_HIGH: "NL80211_CQM_RSSI_THRESHOLD_EVENT_HIGH",
    NL80211_CQM_RSSI_BEACON_LOSS_EVENT: "NL80211_CQM_RSSI_BEACON_LOSS_EVENT",
}
nl80211_tx_power_setting2str = {
    NL80211_TX_POWER_AUTOMATIC: "NL80211_TX_POWER_AUTOMATIC",
    NL80211_TX_POWER_LIMITED: "NL80211_TX_POWER_LIMITED",
    NL80211_TX_POWER_FIXED: "NL80211_TX_POWER_FIXED",
}
nl80211_wowlan_packet_pattern_attr2str = {
    __NL80211_WOWLAN_PKTPAT_INVALID: "__NL80211_WOWLAN_PKTPAT_INVALID",
    NL80211_WOWLAN_PKTPAT_MASK: "NL80211_WOWLAN_PKTPAT_MASK",
    NL80211_WOWLAN_PKTPAT_PATTERN: "NL80211_WOWLAN_PKTPAT_PATTERN",
    NL80211_WOWLAN_PKTPAT_OFFSET: "NL80211_WOWLAN_PKTPAT_OFFSET",
    NUM_NL80211_WOWLAN_PKTPAT: "NUM_NL80211_WOWLAN_PKTPAT",
}
nl80211_wowlan_triggers2str = {
    __NL80211_WOWLAN_TRIG_INVALID: "__NL80211_WOWLAN_TRIG_INVALID",
    NL80211_WOWLAN_TRIG_ANY: "NL80211_WOWLAN_TRIG_ANY",
    NL80211_WOWLAN_TRIG_DISCONNECT: "NL80211_WOWLAN_TRIG_DISCONNECT",
    NL80211_WOWLAN_TRIG_MAGIC_PKT: "NL80211_WOWLAN_TRIG_MAGIC_PKT",
    NL80211_WOWLAN_TRIG_PKT_PATTERN: "NL80211_WOWLAN_TRIG_PKT_PATTERN",
    NL80211_WOWLAN_TRIG_GTK_REKEY_SUPPORTED: "NL80211_WOWLAN_TRIG_GTK_REKEY_SUPPORTED",
    NL80211_WOWLAN_TRIG_GTK_REKEY_FAILURE: "NL80211_WOWLAN_TRIG_GTK_REKEY_FAILURE",
    NL80211_WOWLAN_TRIG_EAP_IDENT_REQUEST: "NL80211_WOWLAN_TRIG_EAP_IDENT_REQUEST",
    NL80211_WOWLAN_TRIG_4WAY_HANDSHAKE: "NL80211_WOWLAN_TRIG_4WAY_HANDSHAKE",
    NL80211_WOWLAN_TRIG_RFKILL_RELEASE: "NL80211_WOWLAN_TRIG_RFKILL_RELEASE",
    NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211: "NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211",
    NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211_LEN: "NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211_LEN",
    NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023: "NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023",
    NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023_LEN: "NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023_LEN",
    NL80211_WOWLAN_TRIG_TCP_CONNECTION: "NL80211_WOWLAN_TRIG_TCP_CONNECTION",
    NL80211_WOWLAN_TRIG_WAKEUP_TCP_MATCH: "NL80211_WOWLAN_TRIG_WAKEUP_TCP_MATCH",
    NL80211_WOWLAN_TRIG_WAKEUP_TCP_CONNLOST: "NL80211_WOWLAN_TRIG_WAKEUP_TCP_CONNLOST",
    NL80211_WOWLAN_TRIG_WAKEUP_TCP_NOMORETOKENS: "NL80211_WOWLAN_TRIG_WAKEUP_TCP_NOMORETOKENS",
    NUM_NL80211_WOWLAN_TRIG: "NUM_NL80211_WOWLAN_TRIG",
}
nl80211_wowlan_tcp_attrs2str = {
    __NL80211_WOWLAN_TCP_INVALID: "__NL80211_WOWLAN_TCP_INVALID",
    NL80211_WOWLAN_TCP_SRC_IPV4: "NL80211_WOWLAN_TCP_SRC_IPV4",
    NL80211_WOWLAN_TCP_DST_IPV4: "NL80211_WOWLAN_TCP_DST_IPV4",
    NL80211_WOWLAN_TCP_DST_MAC: "NL80211_WOWLAN_TCP_DST_MAC",
    NL80211_WOWLAN_TCP_SRC_PORT: "NL80211_WOWLAN_TCP_SRC_PORT",
    NL80211_WOWLAN_TCP_DST_PORT: "NL80211_WOWLAN_TCP_DST_PORT",
    NL80211_WOWLAN_TCP_DATA_PAYLOAD: "NL80211_WOWLAN_TCP_DATA_PAYLOAD",
    NL80211_WOWLAN_TCP_DATA_PAYLOAD_SEQ: "NL80211_WOWLAN_TCP_DATA_PAYLOAD_SEQ",
    NL80211_WOWLAN_TCP_DATA_PAYLOAD_TOKEN: "NL80211_WOWLAN_TCP_DATA_PAYLOAD_TOKEN",
    NL80211_WOWLAN_TCP_DATA_INTERVAL: "NL80211_WOWLAN_TCP_DATA_INTERVAL",
    NL80211_WOWLAN_TCP_WAKE_PAYLOAD: "NL80211_WOWLAN_TCP_WAKE_PAYLOAD",
    NL80211_WOWLAN_TCP_WAKE_MASK: "NL80211_WOWLAN_TCP_WAKE_MASK",
    NUM_NL80211_WOWLAN_TCP: "NUM_NL80211_WOWLAN_TCP",
}
nl80211_iface_limit_attrs2str = {
    NL80211_IFACE_LIMIT_UNSPEC: "NL80211_IFACE_LIMIT_UNSPEC",
    NL80211_IFACE_LIMIT_MAX: "NL80211_IFACE_LIMIT_MAX",
    NL80211_IFACE_LIMIT_TYPES: "NL80211_IFACE_LIMIT_TYPES",
    NUM_NL80211_IFACE_LIMIT: "NUM_NL80211_IFACE_LIMIT",
}
nl80211_if_combination_attrs2str = {
    NL80211_IFACE_COMB_UNSPEC: "NL80211_IFACE_COMB_UNSPEC",
    NL80211_IFACE_COMB_LIMITS: "NL80211_IFACE_COMB_LIMITS",
    NL80211_IFACE_COMB_MAXNUM: "NL80211_IFACE_COMB_MAXNUM",
    NL80211_IFACE_COMB_STA_AP_BI_MATCH: "NL80211_IFACE_COMB_STA_AP_BI_MATCH",
    NL80211_IFACE_COMB_NUM_CHANNELS: "NL80211_IFACE_COMB_NUM_CHANNELS",
    NL80211_IFACE_COMB_RADAR_DETECT_WIDTHS: "NL80211_IFACE_COMB_RADAR_DETECT_WIDTHS",
    NUM_NL80211_IFACE_COMB: "NUM_NL80211_IFACE_COMB",
}
nl80211_plink_state2str = {
    NL80211_PLINK_LISTEN: "NL80211_PLINK_LISTEN",
    NL80211_PLINK_OPN_SNT: "NL80211_PLINK_OPN_SNT",
    NL80211_PLINK_OPN_RCVD: "NL80211_PLINK_OPN_RCVD",
    NL80211_PLINK_CNF_RCVD: "NL80211_PLINK_CNF_RCVD",
    NL80211_PLINK_ESTAB: "NL80211_PLINK_ESTAB",
    NL80211_PLINK_HOLDING: "NL80211_PLINK_HOLDING",
    NL80211_PLINK_BLOCKED: "NL80211_PLINK_BLOCKED",
    NUM_NL80211_PLINK_STATES: "NUM_NL80211_PLINK_STATES",
}
plink_actions2str = {
    NL80211_PLINK_ACTION_NO_ACTION: "NL80211_PLINK_ACTION_NO_ACTION",
    NL80211_PLINK_ACTION_OPEN: "NL80211_PLINK_ACTION_OPEN",
    NL80211_PLINK_ACTION_BLOCK: "NL80211_PLINK_ACTION_BLOCK",
    NUM_NL80211_PLINK_ACTIONS: "NUM_NL80211_PLINK_ACTIONS",
}
nl80211_rekey_data2str = {
    __NL80211_REKEY_DATA_INVALID: "__NL80211_REKEY_DATA_INVALID",
    NL80211_REKEY_DATA_KEK: "NL80211_REKEY_DATA_KEK",
    NL80211_REKEY_DATA_KCK: "NL80211_REKEY_DATA_KCK",
    NL80211_REKEY_DATA_REPLAY_CTR: "NL80211_REKEY_DATA_REPLAY_CTR",
    NUM_NL80211_REKEY_DATA: "NUM_NL80211_REKEY_DATA",
}
nl80211_hidden_ssid2str = {
    NL80211_HIDDEN_SSID_NOT_IN_USE: "NL80211_HIDDEN_SSID_NOT_IN_USE",
    NL80211_HIDDEN_SSID_ZERO_LEN: "NL80211_HIDDEN_SSID_ZERO_LEN",
    NL80211_HIDDEN_SSID_ZERO_CONTENTS: "NL80211_HIDDEN_SSID_ZERO_CONTENTS",
}
nl80211_sta_wme_attr2str = {
    __NL80211_STA_WME_INVALID: "__NL80211_STA_WME_INVALID",
    NL80211_STA_WME_UAPSD_QUEUES: "NL80211_STA_WME_UAPSD_QUEUES",
    NL80211_STA_WME_MAX_SP: "NL80211_STA_WME_MAX_SP",
    __NL80211_STA_WME_AFTER_LAST: "__NL80211_STA_WME_AFTER_LAST",
}
nl80211_pmksa_candidate_attr2str = {
    __NL80211_PMKSA_CANDIDATE_INVALID: "__NL80211_PMKSA_CANDIDATE_INVALID",
    NL80211_PMKSA_CANDIDATE_INDEX: "NL80211_PMKSA_CANDIDATE_INDEX",
    NL80211_PMKSA_CANDIDATE_BSSID: "NL80211_PMKSA_CANDIDATE_BSSID",
    NL80211_PMKSA_CANDIDATE_PREAUTH: "NL80211_PMKSA_CANDIDATE_PREAUTH",
    NUM_NL80211_PMKSA_CANDIDATE: "NUM_NL80211_PMKSA_CANDIDATE",
}
nl80211_tdls_operation2str = {
    NL80211_TDLS_DISCOVERY_REQ: "NL80211_TDLS_DISCOVERY_REQ",
    NL80211_TDLS_SETUP: "NL80211_TDLS_SETUP",
    NL80211_TDLS_TEARDOWN: "NL80211_TDLS_TEARDOWN",
    NL80211_TDLS_ENABLE_LINK: "NL80211_TDLS_ENABLE_LINK",
    NL80211_TDLS_DISABLE_LINK: "NL80211_TDLS_DISABLE_LINK",
}
nl80211_feature_flags2str = {
    NL80211_FEATURE_SK_TX_STATUS: "NL80211_FEATURE_SK_TX_STATUS",
    NL80211_FEATURE_HT_IBSS: "NL80211_FEATURE_HT_IBSS",
    NL80211_FEATURE_INACTIVITY_TIMER: "NL80211_FEATURE_INACTIVITY_TIMER",
    NL80211_FEATURE_CELL_BASE_REG_HINTS: "NL80211_FEATURE_CELL_BASE_REG_HINTS",
    NL80211_FEATURE_P2P_DEVICE_NEEDS_CHANNEL: "NL80211_FEATURE_P2P_DEVICE_NEEDS_CHANNEL",
    NL80211_FEATURE_SAE: "NL80211_FEATURE_SAE",
    NL80211_FEATURE_LOW_PRIORITY_SCAN: "NL80211_FEATURE_LOW_PRIORITY_SCAN",
    NL80211_FEATURE_SCAN_FLUSH: "NL80211_FEATURE_SCAN_FLUSH",
    NL80211_FEATURE_AP_SCAN: "NL80211_FEATURE_AP_SCAN",
    NL80211_FEATURE_VIF_TXPOWER: "NL80211_FEATURE_VIF_TXPOWER",
    NL80211_FEATURE_NEED_OBSS_SCAN: "NL80211_FEATURE_NEED_OBSS_SCAN",
    NL80211_FEATURE_P2P_GO_CTWIN: "NL80211_FEATURE_P2P_GO_CTWIN",
    NL80211_FEATURE_P2P_GO_OPPPS: "NL80211_FEATURE_P2P_GO_OPPPS",
    NL80211_FEATURE_ADVERTISE_CHAN_LIMITS: "NL80211_FEATURE_ADVERTISE_CHAN_LIMITS",
    NL80211_FEATURE_FULL_AP_CLIENT_STATE: "NL80211_FEATURE_FULL_AP_CLIENT_STATE",
    NL80211_FEATURE_USERSPACE_MPM: "NL80211_FEATURE_USERSPACE_MPM",
    NL80211_FEATURE_ACTIVE_MONITOR: "NL80211_FEATURE_ACTIVE_MONITOR",
}
nl80211_probe_resp_offload_support_attr2str = {
    NL80211_PROBE_RESP_OFFLOAD_SUPPORT_WPS: "NL80211_PROBE_RESP_OFFLOAD_SUPPORT_WPS",
    NL80211_PROBE_RESP_OFFLOAD_SUPPORT_WPS2: "NL80211_PROBE_RESP_OFFLOAD_SUPPORT_WPS2",
    NL80211_PROBE_RESP_OFFLOAD_SUPPORT_P2P: "NL80211_PROBE_RESP_OFFLOAD_SUPPORT_P2P",
    NL80211_PROBE_RESP_OFFLOAD_SUPPORT_80211U: "NL80211_PROBE_RESP_OFFLOAD_SUPPORT_80211U",
}
nl80211_connect_failed_reason2str = {
    NL80211_CONN_FAIL_MAX_CLIENTS: "NL80211_CONN_FAIL_MAX_CLIENTS",
    NL80211_CONN_FAIL_BLOCKED_CLIENT: "NL80211_CONN_FAIL_BLOCKED_CLIENT",
}
nl80211_scan_flags2str = {
    NL80211_SCAN_FLAG_LOW_PRIORITY: "NL80211_SCAN_FLAG_LOW_PRIORITY",
    NL80211_SCAN_FLAG_FLUSH: "NL80211_SCAN_FLAG_FLUSH",
    NL80211_SCAN_FLAG_AP: "NL80211_SCAN_FLAG_AP",
}
nl80211_acl_policy2str = {
    NL80211_ACL_POLICY_ACCEPT_UNLESS_LISTED: "NL80211_ACL_POLICY_ACCEPT_UNLESS_LISTED",
    NL80211_ACL_POLICY_DENY_UNLESS_LISTED: "NL80211_ACL_POLICY_DENY_UNLESS_LISTED",
}
nl80211_radar_event2str = {
    NL80211_RADAR_DETECTED: "NL80211_RADAR_DETECTED",
    NL80211_RADAR_CAC_FINISHED: "NL80211_RADAR_CAC_FINISHED",
    NL80211_RADAR_CAC_ABORTED: "NL80211_RADAR_CAC_ABORTED",
    NL80211_RADAR_NOP_FINISHED: "NL80211_RADAR_NOP_FINISHED",
}
nl80211_dfs_state2str = {
    NL80211_DFS_USABLE: "NL80211_DFS_USABLE",
    NL80211_DFS_UNAVAILABLE: "NL80211_DFS_UNAVAILABLE",
    NL80211_DFS_AVAILABLE: "NL80211_DFS_AVAILABLE",
}
nl80211_protocol_features2str = {
    NL80211_PROTOCOL_FEATURE_SPLIT_WIPHY_DUMP: "NL80211_PROTOCOL_FEATURE_SPLIT_WIPHY_DUMP",
}
nl80211_crit_proto_id2str = {
    NL80211_CRIT_PROTO_UNSPEC: "NL80211_CRIT_PROTO_UNSPEC",
    NL80211_CRIT_PROTO_DHCP: "NL80211_CRIT_PROTO_DHCP",
    NL80211_CRIT_PROTO_EAPOL: "NL80211_CRIT_PROTO_EAPOL",
    NL80211_CRIT_PROTO_APIPA: "NL80211_CRIT_PROTO_APIPA",
    NUM_NL80211_CRIT_PROTO: "NUM_NL80211_CRIT_PROTO",
}
