/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include "attriblistmerge.hxx"

#include <osl/diagnose.h>

namespace xmloff
{

    using namespace ::com::sun::star::uno;
    using namespace ::com::sun::star;

    //= OAttribListMerger
    void OAttribListMerger::addList(const Reference< xml::sax::XAttributeList >& _rxList)
    {
        OSL_ENSURE(_rxList.is(), "OAttribListMerger::addList: invalid list!");
        if (_rxList.is())
            m_aLists.push_back(_rxList);
    }

    bool OAttribListMerger::seekToIndex(sal_Int16 _nGlobalIndex, Reference< xml::sax::XAttributeList >& _rSubList, sal_Int16& _rLocalIndex)
    {
        sal_Int16 nLeftOver = _nGlobalIndex;
        AttributeListArray::const_iterator aLookupSublist = m_aLists.begin();

        for ( ; (aLookupSublist != m_aLists.end()) && (nLeftOver >= (*aLookupSublist)->getLength());
                ++aLookupSublist
            )
            nLeftOver = nLeftOver - (*aLookupSublist)->getLength();

        if (aLookupSublist == m_aLists.end())
        {
            OSL_FAIL("OAttribListMerger::seekToIndex: invalid index!");
            return false;
        }
        _rSubList = *aLookupSublist;
        _rLocalIndex = nLeftOver;
        return true;
    }

    bool OAttribListMerger::seekToName(const OUString& _rName, Reference< xml::sax::XAttributeList >& _rSubList, sal_Int16& _rLocalIndex)
    {
        for (   AttributeListArray::const_iterator aLookupSublist = m_aLists.begin();
                aLookupSublist != m_aLists.end();
                ++aLookupSublist
            )
            for (sal_Int16 i=0; i<(*aLookupSublist)->getLength(); ++i)
                if ((*aLookupSublist)->getNameByIndex(i) == _rName)
                {
                    _rSubList = *aLookupSublist;
                    _rLocalIndex = i;
                    return true;
                }

        OSL_FAIL("OAttribListMerger::seekToName: did not find the name!");
        return false;
    }

    sal_Int16 SAL_CALL OAttribListMerger::getLength(  )
    {
        sal_Int16 nCount = 0;
        for (   AttributeListArray::const_iterator aAccumulate = m_aLists.begin();
                aAccumulate != m_aLists.end();
                ++aAccumulate
            )
            nCount = nCount + (*aAccumulate)->getLength();
        return nCount;
    }

    OUString SAL_CALL OAttribListMerger::getNameByIndex( sal_Int16 i )
    {
        Reference< xml::sax::XAttributeList > xSubList;
        sal_Int16 nLocalIndex;

        if (!seekToIndex(i, xSubList, nLocalIndex))
            return OUString();

        return xSubList->getNameByIndex(nLocalIndex);
    }

    OUString SAL_CALL OAttribListMerger::getTypeByIndex( sal_Int16 i )
    {
        Reference< xml::sax::XAttributeList > xSubList;
        sal_Int16 nLocalIndex;

        if (!seekToIndex(i, xSubList, nLocalIndex))
            return OUString();

        return xSubList->getTypeByIndex(nLocalIndex);
    }

    OUString SAL_CALL OAttribListMerger::getTypeByName( const OUString& _rName )
    {
        Reference< xml::sax::XAttributeList > xSubList;
        sal_Int16 nLocalIndex;

        if (!seekToName(_rName, xSubList, nLocalIndex))
            return OUString();

        // though we're in getTypeByName here, we reroute this to the getTypeByIndex of the sub list,
        // assuming that this is faster
        return xSubList->getTypeByIndex(nLocalIndex);
    }

    OUString SAL_CALL OAttribListMerger::getValueByIndex( sal_Int16 i )
    {
        Reference< xml::sax::XAttributeList > xSubList;
        sal_Int16 nLocalIndex;

        if (!seekToIndex(i, xSubList, nLocalIndex))
            return OUString();

        return xSubList->getValueByIndex(nLocalIndex);
    }

    OUString SAL_CALL OAttribListMerger::getValueByName( const OUString& _rName )
    {
        Reference< xml::sax::XAttributeList > xSubList;
        sal_Int16 nLocalIndex;

        if (!seekToName(_rName, xSubList, nLocalIndex))
            return OUString();

        // though we're in getValueByName here, we reroute this to the getValueByIndex of the sub list,
        // assuming that this is faster
        return xSubList->getValueByIndex(nLocalIndex);
    }

}   // namespace xmloff

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
