/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Painter;

public class FastBufferedUpdateStrategy
implements Painter {
    private BufferedImage _doubleBufferedImage;
    private BufferedImage _scratchPadBufferedImage;
    private int _nImageWidth = 0;
    private int _nImageHeight = 0;
    private boolean _bRedrawAll = true;

    public void draw(Graphics graphics, DrawingView drawingView) {
        this._checkCaches(drawingView);
        if (this._bRedrawAll) {
            Graphics graphics2 = this._doubleBufferedImage.getGraphics();
            drawingView.drawAll(graphics2);
        } else {
            Rectangle rectangle = graphics.getClipBounds();
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = rectangle.x + rectangle.width;
            int n4 = rectangle.y + rectangle.height;
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            Rectangle rectangle2 = new Rectangle(n, n2, n3 - n, n4 - n2);
            Drawing drawing = drawingView.drawing();
            FigureEnumeration figureEnumeration = drawing.figures(rectangle2);
            Graphics graphics3 = this._scratchPadBufferedImage.getGraphics();
            graphics3.setColor(drawingView.getBackground());
            graphics3.fillRect(n, n2, n3 - n, n4 - n2);
            drawingView.draw(graphics3, figureEnumeration);
            Graphics graphics4 = this._doubleBufferedImage.getGraphics();
            graphics4.drawImage(this._scratchPadBufferedImage, n, n2, n3, n4, n, n2, n3, n4, drawingView);
        }
        graphics.drawImage(this._doubleBufferedImage, 0, 0, drawingView);
        this._bRedrawAll = false;
    }

    private void _checkCaches(DrawingView drawingView) {
        Dimension dimension = drawingView.getSize();
        if (this._doubleBufferedImage == null || this._nImageWidth != dimension.width || this._nImageHeight != dimension.height) {
            this._doubleBufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
            this._bRedrawAll = true;
        }
        if (this._scratchPadBufferedImage == null || this._nImageWidth != dimension.width || this._nImageHeight != dimension.height) {
            this._scratchPadBufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
            Graphics graphics = this._scratchPadBufferedImage.getGraphics();
            drawingView.drawBackground(graphics);
            this._bRedrawAll = true;
        }
        this._nImageWidth = dimension.width;
        this._nImageHeight = dimension.height;
    }
}

