/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001          */
/* Modified for S390 by Robert Burroughs                             */


#include <pthread.h>
#include <string.h>            // for memcmp() et al
#include <strings.h>
#include <stdlib.h>

#ifndef NOAES
#include <openssl/aes.h>
#endif
#ifndef NODH
#include <openssl/dh.h>
#endif

#include "pkcs11types.h"
#include "defs.h"
#include "host_defs.h"
#include "h_extern.h"

#include "tok_specific.h"
#include "tok_struct.h"

#include "ica_api.h"
// declare the adapter open handle localy
ICA_ADAPTER_HANDLE adapter_handle;

// Linux really does not need these so we just dummy them up
// so the common code across platforms is usable...
#define KEYTYPE_MODEXPO   1
#define KEYTYPE_PKCSCRT   2

CK_CHAR manuf[] = "IBM Corp.";
CK_CHAR model[] = "IBM ICA     ";
CK_CHAR descr[] = "IBM PKCS#11 ICA token ";
CK_CHAR label[] = "IBM ICA  PKCS #11";



pthread_mutex_t  rngmtx = PTHREAD_MUTEX_INITIALIZER;
unsigned int  rnginitialized=0;



CK_RV
token_rng(CK_BYTE *output, CK_ULONG bytes)
{
   unsigned int  rc;

      pthread_mutex_lock(&rngmtx);

      rc = ica_random_number_generate( (unsigned int) bytes, output);

      if (rc != 0) {
         pthread_mutex_unlock(&rngmtx);
         return CKR_GENERAL_ERROR;
         /* report error */
      }

      pthread_mutex_unlock(&rngmtx);
      return CKR_OK;

}

int
tok_slot2local(CK_SLOT_ID snum)
{
   return 1;
}

CK_RV
token_specific_init(char * Correlator,CK_SLOT_ID  SlotNumber)
{

   return ica_open_adapter(&adapter_handle);
}

CK_RV
token_specific_final()
{
   ica_close_adapter(adapter_handle);
   return CKR_OK;
}

// count_ones_in_byte: for use in adjust_des_key_parity_bits below
CK_BYTE 
count_ones_in_byte(CK_BYTE byte)
{  
   CK_BYTE and_mask,   // bit selector
           number_of_ones = 0;

   for (and_mask = 1; and_mask != 0; and_mask <<= 1) // for each bit,
      if (byte & and_mask) // if it's a one,                         
         ++number_of_ones; // count it

   return number_of_ones;
}

#define EVEN_PARITY TRUE
#define ODD_PARITY FALSE
 // adjust_des_key_parity_bits: to conform to NIST spec for DES and 3DES keys
void adjust_des_key_parity_bits(CK_BYTE *des_key, CK_ULONG key_size, CK_BBOOL parity)
{
   CK_BYTE *des_key_byte;

   for (des_key_byte = des_key; des_key_byte - des_key < key_size; ++des_key_byte)
         // look at each byte in the key
   {
      if ((count_ones_in_byte(*des_key_byte) % 2) ^ (parity == ODD_PARITY))
      {
         // if parity for this byte isn't what it should be,
         // flip the parity (least significant) bit
         *des_key_byte ^= 1;
      }
   }
}







CK_RV
token_specific_des_key_gen(CK_BYTE  *des_key,CK_ULONG len)
{
      
   // Nothing different to do for DES or TDES here as this is just
   // random data...  Validation handles the rest
        rng_generate(des_key,len);
        adjust_des_key_parity_bits(des_key, len, ODD_PARITY);

        
   // we really need to validate the key for parity etc...
   // we should do that here... The caller validates the single des keys
   // against the known and suspected poor keys..<<
        return CKR_OK;

}

CK_RV
token_specific_des_ecb(CK_BYTE * in_data,
                       CK_ULONG in_data_len,
                       CK_BYTE *out_data,
                       CK_ULONG *out_data_len,
                       CK_BYTE  *key_value,
                       CK_BYTE  encrypt)
{
   CK_RV rc;

   /*
    * checks for input and output data length and block sizes
    * are already being carried out in mech_des.c
    * so we skip those
    */

   if ( encrypt) {
      rc = ica_des_encrypt(MODE_DES_ECB, (unsigned int) in_data_len, in_data,
                           NULL, (ica_des_key_single_t *) key_value, out_data);
   } else {
      rc = ica_des_decrypt(MODE_DES_ECB, (unsigned int) in_data_len, in_data,
                           NULL, (ica_des_key_single_t *) key_value, out_data);
   }

   if (rc != 0) {
      rc = CKR_FUNCTION_FAILED;
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
   }else {
      *out_data_len = in_data_len;
      rc = CKR_OK;
   }

   return rc;


}

CK_RV
token_specific_des_cbc(CK_BYTE * in_data,
                       CK_ULONG in_data_len,
                       CK_BYTE *out_data,
                       CK_ULONG *out_data_len,
                       CK_BYTE  *key_value, 
                       CK_BYTE *init_v,
                       CK_BYTE  encrypt)
{

   CK_RV rc;

   /*
    * checks for input and output data length and block sizes
    * are already being carried out in mech_des.c
    * so we skip those
    */

   if ( encrypt ){
      rc = ica_des_encrypt(MODE_DES_CBC, (unsigned int) in_data_len, in_data,
                           (ica_des_vector_t *) init_v, (ica_des_key_single_t *) key_value,
                           out_data);
   } else {
      rc = ica_des_decrypt(MODE_DES_CBC, (unsigned int) in_data_len, in_data,
                           (ica_des_vector_t *) init_v, (ica_des_key_single_t *) key_value,
                           out_data);
   }
   if (rc != 0) {
         st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
         rc = CKR_FUNCTION_FAILED;
   }else {
         *out_data_len = in_data_len;
         rc = CKR_OK;
   }

   return rc;
}

CK_RV
token_specific_tdes_ecb(CK_BYTE * in_data,
                       CK_ULONG in_data_len,
                       CK_BYTE *out_data,
                       CK_ULONG *out_data_len,
                       CK_BYTE  *key_value,
                       CK_BYTE  encrypt)
{
   CK_RV rc;

   /*
    * checks for input and output data length and block sizes
    * are already being carried out in mech_des3.c
    * so we skip those
    */

   if ( encrypt) {
      rc = ica_3des_encrypt(MODE_DES_ECB, (unsigned int) in_data_len, in_data,
                            NULL, (ica_des_key_triple_t *) key_value, out_data);
   } else {
      rc = ica_3des_decrypt(MODE_DES_ECB, (unsigned int) in_data_len, in_data,
                            NULL, (ica_des_key_triple_t *) key_value, out_data);
   }

   if (rc != 0) {
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
      rc = CKR_FUNCTION_FAILED;
   }else {
      *out_data_len = in_data_len;
      rc = CKR_OK;
   }

   return rc;


}

CK_RV
token_specific_tdes_cbc(CK_BYTE * in_data,
                       CK_ULONG in_data_len,
                       CK_BYTE *out_data,
                       CK_ULONG *out_data_len,
                       CK_BYTE  *key_value, 
                       CK_BYTE *init_v,
                       CK_BYTE  encrypt)
{

   CK_RV rc;

   /*
    * checks for input and output data length and block sizes
    * are already being carried out in mech_des3.c
    * so we skip those
    */

   if ( encrypt ){
   rc = ica_3des_encrypt(MODE_DES_CBC, (unsigned int) in_data_len, in_data,
                         (ica_des_vector_t  *) init_v, (ica_des_key_triple_t *) key_value,
                         out_data);
   } else {
   rc = ica_3des_decrypt(MODE_DES_CBC, (unsigned int) in_data_len, in_data,
                         (ica_des_vector_t *) init_v, (ica_des_key_triple_t *) key_value,
                         out_data);
   }
   if (rc != 0) {
         st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
         rc = CKR_FUNCTION_FAILED;
   }else {
         *out_data_len = in_data_len;
         rc = CKR_OK;
   }

   return rc;
}

/**
 * Init SHA data structures
 */
CK_RV token_specific_sha_generic_init(DIGEST_CONTEXT *ctx,
				      CK_MECHANISM_TYPE sha_type)
{
	unsigned int dev_ctx_size;
	struct oc_sha_ctx *sc;

	/* For the C_DigestInit, C_Digest case, we may have already 
	 * created ctx->context... - KEY */
	if (ctx->context) {
		sc = (struct oc_sha_ctx *)ctx->context;
		if(sc->dev_ctx)
			free(sc->dev_ctx);
		free(ctx->context);
	}
	/* The caller will check to see if ctx->context == NULL */
	ctx->context_len = sizeof(struct oc_sha_ctx);
	ctx->context = malloc(sizeof(struct oc_sha_ctx));
	if(ctx->context == NULL) {
                st_err_log(1, __FILE__, __LINE__);
		return CKR_HOST_MEMORY;
	}
	memset(ctx->context, 0, ctx->context_len);
	sc = (struct oc_sha_ctx *)ctx->context;
	switch (sha_type) {
	case CKM_SHA_1:
		sc->hash_len = SHA1_HASH_SIZE;
                dev_ctx_size = sizeof(sha_context_t);
		break;
	case CKM_SHA256:
		sc->hash_len = SHA2_HASH_SIZE;
                dev_ctx_size = sizeof(sha256_context_t);
		break;
	case CKM_SHA384:
		sc->hash_len = SHA3_HASH_SIZE;
                dev_ctx_size = sizeof(sha512_context_t);
		break;
	case CKM_SHA512:
		sc->hash_len = SHA5_HASH_SIZE;
                dev_ctx_size = sizeof(sha512_context_t);
		break;
	default:
		free(ctx->context);
		return CKR_MECHANISM_INVALID;
	}	
	sc->dev_ctx = malloc(dev_ctx_size);
	if(sc->dev_ctx == NULL){
		free(ctx->context);
                st_err_log(1, __FILE__, __LINE__);
		return CKR_HOST_MEMORY;
	}
	memset(sc->dev_ctx, 0, dev_ctx_size);
	sc->message_part = SHA_MSG_PART_ONLY;
	return CKR_OK;
}

CK_RV
token_specific_sha_init(DIGEST_CONTEXT *ctx)
{
	return token_specific_sha_generic_init(ctx, CKM_SHA_1);
}

CK_RV token_specific_sha2_init(DIGEST_CONTEXT *ctx)
{
	return token_specific_sha_generic_init(ctx, CKM_SHA256);
}

CK_RV token_specific_sha3_init(DIGEST_CONTEXT *ctx)
{
	return token_specific_sha_generic_init(ctx, CKM_SHA384);
}

CK_RV token_specific_sha5_init(DIGEST_CONTEXT *ctx)
{
	return token_specific_sha_generic_init(ctx, CKM_SHA512);
}

CK_RV
token_specific_sha_update(	DIGEST_CONTEXT	*ctx,
				CK_BYTE		*in_data,
				CK_ULONG	in_data_len )
{
	unsigned int fill_size = 0;
	struct oc_sha_ctx *oc_sha_ctx = (struct oc_sha_ctx *)ctx->context;
        sha_context_t *ica_sha_ctx = (sha_context_t *) oc_sha_ctx->dev_ctx;

        oc_sha_ctx->hash_len = SHA_HASH_LENGTH;

	if( !ctx )
		return CKR_OPERATION_NOT_INITIALIZED;
	
	if( !in_data )
		return CKR_FUNCTION_FAILED;
	
	if( ctx->multi == TRUE ){
		if (oc_sha_ctx->tail_len == 64) {
                        /* Submit the filled out save buffer */
                        if (ica_sha1( (ica_sha_ctx->runningLength == 0 ?
                                     SHA_MSG_PART_FIRST : SHA_MSG_PART_MIDDLE),
                                     64, oc_sha_ctx->tail, ica_sha_ctx,
                                     oc_sha_ctx->hash))
                                return CKR_FUNCTION_FAILED;
                        oc_sha_ctx->tail_len = 0;
                }

		/* libICA (and SHA1) demands that if this is a PART_FIRST or a 
		 * PART_MIDDLE operation, the amount of data passed in
		 * must be a multiple of 64 bytes. - KEY
		 */
		if( ica_sha_ctx->runningLength == 0 && 
			oc_sha_ctx->tail_len == 0) {
			oc_sha_ctx->message_part = SHA_MSG_PART_FIRST;

                        /* Just copying the last <64 bytes will not work in the case
                         * of a user who SHA's a large chunk of data in 64 byte
                         * pieces because we need to cache the last 64 bytes so that
                         * we're not stuck with 0 bytes when the MSG_PART_FINAL
                         * comes in. - KEY
                         */
                        if (!(in_data_len % 64)) {
                                oc_sha_ctx->tail_len = 64;
                                memcpy(oc_sha_ctx->tail, in_data + in_data_len - 64, 64);
                                in_data_len -= 64;
                        } else
                                oc_sha_ctx->tail_len = in_data_len & 0x3f;
		
			if(oc_sha_ctx->tail_len < 64) {
				in_data_len &= ~0x3f;	
				memcpy(oc_sha_ctx->tail, in_data + in_data_len, oc_sha_ctx->tail_len);
			}
		}
		else if( ica_sha_ctx->runningLength == 0 &&
				oc_sha_ctx->tail_len > 0 ) {

			/* Here we need to fill out the temporary tail buffer until
                         * it has 64 bytes in it, then call ica_sha1 on that buffer.
			 * If there weren't enough bytes passed in to fill it out,
			 * just copy in what we can and return success without calling
                         * ica_sha1. - KEY
			 */

			fill_size = 64 - oc_sha_ctx->tail_len;
			if(fill_size < in_data_len) {
				memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len, in_data, fill_size);
			
				/* Submit the filled out save buffer */
                                if (ica_sha1(SHA_MSG_PART_FIRST, 64, oc_sha_ctx->tail,
                                             ica_sha_ctx, oc_sha_ctx->hash))
					return CKR_FUNCTION_FAILED;
			} else {
				memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len,
					in_data, in_data_len);
				oc_sha_ctx->tail_len += in_data_len;

				return CKR_OK;
			}
			
                        /* We had to use 'fill_size' bytes from in_data to fill out the
                         * empty part of save data, so adjust in_data_len
                         */
                        in_data_len -= fill_size;

                        oc_sha_ctx->tail_len = in_data_len & 0x3f;
                        if(oc_sha_ctx->tail_len) {
                                memcpy(oc_sha_ctx->tail, 
					in_data + fill_size, 
					oc_sha_ctx->tail_len);
                                in_data_len &= ~0x3f;
                        }
		}
		else if( ica_sha_ctx->runningLength > 0 ) {
			oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;

			if(oc_sha_ctx->tail_len) {
	                        fill_size = 64 - oc_sha_ctx->tail_len;
        	                if(fill_size < in_data_len) {
                	                memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len, 
							in_data, fill_size);

                        	        /* Submit the filled out save buffer */
                                        if (ica_sha1(oc_sha_ctx->message_part, 64,
                                                     oc_sha_ctx->tail, ica_sha_ctx,
                                                     oc_sha_ctx->hash))
        	                                return CKR_FUNCTION_FAILED;
                	        } else {
                        	        memcpy(oc_sha_ctx->tail + oc_sha_ctx->tail_len,
                                               in_data, in_data_len);
	                                oc_sha_ctx->tail_len += in_data_len;
	
        	                        return CKR_OK;
                	        }

				/* We had to use some of the data from in_data to fill out the
				 * empty part of save data, so adjust in_data_len
				 */
				in_data_len -= fill_size;
				
				/* Save the _last_ oc_sha_ctx->tail_len bytes from in_data
				 * Rajiv - 2009 */
				
				oc_sha_ctx->tail_len = in_data_len & 0x3f;
				if(oc_sha_ctx->tail_len) {
					in_data_len &= ~0x3f;	
					memcpy(oc_sha_ctx->tail, in_data + in_data_len + fill_size, 
							oc_sha_ctx->tail_len);
				}
			} else {
				/* This is the odd case, where we need to go ahead and
				 * send the first X * 64 byte chunks in to be processed
				 * and copy the last <64 byte area into the tail. -KEY
				 */
                                /* Just copying the last <64 bytes will not work in the case
                                 * of a user who SHA's a large chunk of data in 64 byte
                                 * pieces because we need to cache the last 64 bytes so that
                                 * we're not stuck with 0 bytes when the MSG_PART_FINAL
                                 * comes in. - KEY
                                 */
                                if (!(in_data_len % 64)) {
                                        oc_sha_ctx->tail_len = 64;
                                        memcpy(oc_sha_ctx->tail, in_data + in_data_len - 64, 64);
                                        in_data_len -= 64;
                                } else
                                        oc_sha_ctx->tail_len = in_data_len & 0x3f;

				if( oc_sha_ctx->tail_len < 64) {
					in_data_len &= ~0x3f;
					memcpy(oc_sha_ctx->tail, in_data + in_data_len,
							oc_sha_ctx->tail_len);
				}
			}
		}
	} else {
		/* ctx->multi == FALSE, but we've run previously. That's
		 * our signal that this is the last part -KEY
		 */
		if( ica_sha_ctx->runningLength > 0 )
			oc_sha_ctx->message_part = SHA_MSG_PART_FINAL;
		else
			oc_sha_ctx->message_part = SHA_MSG_PART_ONLY;
	}
	
	if( in_data_len || oc_sha_ctx->message_part == SHA_MSG_PART_FINAL ) {
                if (ica_sha1(oc_sha_ctx->message_part, in_data_len,
                             in_data + fill_size,ica_sha_ctx,
                             oc_sha_ctx->hash))
			return CKR_FUNCTION_FAILED;
	}
	
	return CKR_OK;
}

CK_RV token_specific_sha2_update(DIGEST_CONTEXT *ctx, CK_BYTE *in_data,
				 CK_ULONG in_data_len)
{
	unsigned int fill_size = 0;
	CK_RV rv = CKR_OK;
	struct oc_sha_ctx *oc_sha_ctx = (struct oc_sha_ctx *)ctx->context;
        sha256_context_t *ica_sha2_ctx = (sha256_context_t *) oc_sha_ctx->dev_ctx;

        oc_sha_ctx->hash_len = SHA256_HASH_LENGTH;

	if (!ctx) {
		rv = CKR_OPERATION_NOT_INITIALIZED;
		goto out;
	}
	if (!in_data) {
		rv = CKR_FUNCTION_FAILED;
		goto out;
	}
	if (ctx->multi == TRUE) {
		if (oc_sha_ctx->tail_len == 64) {
			/* Submit the filled out save buffer */
                        if ((ica_sha256( (ica_sha2_ctx->runningLength == 0 ?
                                        SHA_MSG_PART_FIRST : SHA_MSG_PART_MIDDLE),
                                        64, oc_sha_ctx->tail, ica_sha2_ctx,
                                        oc_sha_ctx->hash))) {
				rv = CKR_FUNCTION_FAILED;
				goto out;
			}
			oc_sha_ctx->tail_len = 0;
		}
		/* libICA and SHA256 demand that if this is a
		 * PART_FIRST or a PART_MIDDLE operation, the amount
		 * of data passed in must be a multiple of 64 bytes. -
		 * KEY */
		if (ica_sha2_ctx->runningLength == 0 && 
		    oc_sha_ctx->tail_len == 0) {
			oc_sha_ctx->message_part = SHA_MSG_PART_FIRST;
			/* Just copying the last <64 bytes will not
			 * work in the case of a user who SHA's a
			 * large chunk of data in 64 byte pieces
			 * because we need to cache the last 64 bytes
			 * so that we're not stuck with 0 bytes when
			 * the MSG_PART_FINAL comes in. - KEY
			 */
			if (!(in_data_len % 64)) {
				oc_sha_ctx->tail_len = 64;
				memcpy(oc_sha_ctx->tail,
				       (in_data + in_data_len - 64), 64);
				in_data_len -= 64;
			} else {
				oc_sha_ctx->tail_len = in_data_len & 0x3f;
			}
			if (oc_sha_ctx->tail_len < 64) {
				in_data_len &= ~0x3f;	
				memcpy(oc_sha_ctx->tail,
				       (in_data + in_data_len),
				       oc_sha_ctx->tail_len);
			}
		} else if (ica_sha2_ctx->runningLength == 0 &&
			   oc_sha_ctx->tail_len > 0) {
			/* Here we need to fill out the temporary tail
			 * buffer until it has 64 bytes in it, then
                         * call ica_sha256 on that buffer.  If there
			 * weren't enough bytes passed in to fill it
			 * out, just copy in what we can and return
                         * success without calling ica_sha256. - KEY */
			fill_size = 64 - oc_sha_ctx->tail_len;
			if (fill_size < in_data_len) {
				int rc;
				memcpy((oc_sha_ctx->tail
					+ oc_sha_ctx->tail_len),
				       in_data, fill_size);
				/* Submit the filled out save buffer */
                                if ((rc = ica_sha256(SHA_MSG_PART_FIRST, 64,
                                                     oc_sha_ctx->tail,ica_sha2_ctx,
                                                     oc_sha_ctx->hash))) {
					rv = CKR_FUNCTION_FAILED;
					goto out;
				}
			} else {
				memcpy((oc_sha_ctx->tail
					+ oc_sha_ctx->tail_len),
				       in_data, in_data_len);
				oc_sha_ctx->tail_len += in_data_len;
				goto out;
			}
                        /* We had to use 'fill_size' bytes from
                         * in_data to fill out the empty part of save
                         * data, so adjust in_data_len */
                        in_data_len -= fill_size;
                        oc_sha_ctx->tail_len = in_data_len & 0x3f;
                        if (oc_sha_ctx->tail_len) {
                                memcpy(oc_sha_ctx->tail,
				       in_data + fill_size,
				       oc_sha_ctx->tail_len);
                                in_data_len &= ~0x3f;
                        }
		} else if (ica_sha2_ctx->runningLength > 0) {
			oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;
			if(oc_sha_ctx->tail_len) {
	                        fill_size = (64 - oc_sha_ctx->tail_len);
        	                if (fill_size < in_data_len) {
					int rc;
                	                memcpy(oc_sha_ctx->tail
					       + oc_sha_ctx->tail_len, 
					       in_data, fill_size);
                        	        /* Submit the filled out save
					 * buffer */
                                        rc = ica_sha256(oc_sha_ctx->message_part,
                                                        64, oc_sha_ctx->tail,
                                                        ica_sha2_ctx,
                                                        oc_sha_ctx->hash);
                                	if (rc) {
						rv = CKR_FUNCTION_FAILED;
						goto out;
					}
                	        } else {
                        	        memcpy((oc_sha_ctx->tail
						+ oc_sha_ctx->tail_len),
					       in_data, in_data_len);
	                                oc_sha_ctx->tail_len += in_data_len;
					goto out;
                	        }
				/* We had to use some of the data from
				 * in_data to fill out the empty part
				 * of save data, so adjust in_data_len
				 */
				in_data_len -= fill_size;
				oc_sha_ctx->tail_len = in_data_len & 0x3f;
				if(oc_sha_ctx->tail_len) {
					memcpy(oc_sha_ctx->tail,
					       (in_data + fill_size),
					       oc_sha_ctx->tail_len);
					in_data_len &= ~0x3f;	
				}
			} else {
				/* This is the odd case, where we need
				 * to go ahead and send the first X *
				 * 64 byte chunks in to be processed
				 * and copy the last <64 byte area
				 * into the tail. -KEY */
				/* Just copying the last <64 bytes
				 * will not work in the case of a user
				 * who SHA's a large chunk of data in
				 * 64 byte pieces because we need to
				 * cache the last 64 bytes so that
				 * we're not stuck with 0 bytes when
				 * the MSG_PART_FINAL comes in. - KEY
				 */
                        	if (!(in_data_len % 64)) {
                                	oc_sha_ctx->tail_len = 64;
	                                memcpy(oc_sha_ctx->tail,
					       (in_data + in_data_len - 64),
					       64);
        	                        in_data_len -= 64;
                	        } else {
                        	        oc_sha_ctx->tail_len =
						in_data_len & 0x3f;
				}
				if (oc_sha_ctx->tail_len < 64) {
					in_data_len &= ~0x3f;
					memcpy(oc_sha_ctx->tail,
					       (in_data + in_data_len),
					       oc_sha_ctx->tail_len);
				}
			}
		}
	} else {
		/* ctx->multi == FALSE, but we've run
		 * previously. That's our signal that this is the last
		 * part -KEY */
		if (ica_sha2_ctx->runningLength > 0) {
			oc_sha_ctx->message_part = SHA_MSG_PART_FINAL;
		} else {
			oc_sha_ctx->message_part = SHA_MSG_PART_ONLY;
		}
	}
	if (in_data_len 
	    || (oc_sha_ctx->message_part == SHA_MSG_PART_FINAL)) {
		int rc;
                if ((rc = ica_sha256(oc_sha_ctx->message_part,
                                     in_data_len, (in_data + fill_size),
                                     ica_sha2_ctx, oc_sha_ctx->hash))) {
			rv = CKR_FUNCTION_FAILED;
			goto out;
		}
	}
 out:
	return rv;
}

CK_RV token_specific_sha3_update(DIGEST_CONTEXT *ctx, CK_BYTE *in_data,
				 CK_ULONG in_data_len)
{
	unsigned int fill_size = 0;
	CK_RV rv = CKR_OK;
	struct oc_sha_ctx *oc_sha_ctx = (struct oc_sha_ctx *)ctx->context;
        sha512_context_t *ica_sha3_ctx = (sha512_context_t *) oc_sha_ctx->dev_ctx;

        oc_sha_ctx->hash_len = SHA384_HASH_LENGTH;

	if (!ctx) {
		rv = CKR_OPERATION_NOT_INITIALIZED;
		goto out;
	}
	if (!in_data) {
		rv = CKR_FUNCTION_FAILED;
		goto out;
	}
	if (ctx->multi == TRUE) {
		if (oc_sha_ctx->tail_len == SHA3_BLOCK_SIZE) {
			int rc;

			/* Submit the filled out save buffer */
                        if ((rc = ica_sha384(((ica_sha3_ctx->runningLengthLow == 0 && ica_sha3_ctx->runningLengthHigh == 0) ?
                                             SHA_MSG_PART_FIRST : SHA_MSG_PART_MIDDLE),
                                             SHA3_BLOCK_SIZE, oc_sha_ctx->tail,
                                             ica_sha3_ctx, oc_sha_ctx->hash))) {
				rv = CKR_FUNCTION_FAILED;
				goto out;
			}
			oc_sha_ctx->tail_len = 0;
		}

		/* libICA and SHA384 demand that if this is a
		 * PART_FIRST or a PART_MIDDLE operation, the amount
		 * of data passed in must be a multiple of
		 * SHA3_BLOCK_SIZE bytes. */
		if (ica_sha3_ctx->runningLengthLow == 0
		    && ica_sha3_ctx->runningLengthHigh == 0
		    && oc_sha_ctx->tail_len == 0) {
			oc_sha_ctx->message_part = SHA_MSG_PART_FIRST;
			/* Just copying the last <SHA3_BLOCK_SIZE
			 * bytes will not work in the case of a user
			 * who SHA's a large chunk of data in
			 * SHA3_BLOCK_SIZE byte pieces because we need
			 * to cache the last SHA3_BLOCK_SIZE bytes so
			 * that we're not stuck with 0 bytes when the
			 * MSG_PART_FINAL comes in. */
			if (!(in_data_len % SHA3_BLOCK_SIZE)) {
				oc_sha_ctx->tail_len = SHA3_BLOCK_SIZE;
				memcpy(oc_sha_ctx->tail,
				       (in_data + in_data_len
					- SHA3_BLOCK_SIZE), SHA3_BLOCK_SIZE);
				in_data_len -= SHA3_BLOCK_SIZE;
			} else {
				oc_sha_ctx->tail_len = (in_data_len
							& SHA3_BLOCK_SIZE_MASK);
			}
			if (oc_sha_ctx->tail_len < SHA3_BLOCK_SIZE) {
				in_data_len &= ~(SHA3_BLOCK_SIZE_MASK);	
				memcpy(oc_sha_ctx->tail,
				       (in_data + in_data_len),
				       oc_sha_ctx->tail_len);
			}
		} else if (ica_sha3_ctx->runningLengthLow == 0
			   && ica_sha3_ctx->runningLengthHigh == 0
			   && oc_sha_ctx->tail_len > 0) {
			/* Here we need to fill out the temporary tail
			 * buffer until it has SHA3_BLOCK_SIZE bytes
                         * in it, then call ica_sha384 on that buffer.
			 * If there weren't enough bytes passed in to
			 * fill it out, just copy in what we can and
			 * return success without calling
                         * ica_sha384. */
			fill_size = (SHA3_BLOCK_SIZE - oc_sha_ctx->tail_len);
			if (fill_size < in_data_len) {
				int rc;
				memcpy((oc_sha_ctx->tail
					+ oc_sha_ctx->tail_len),
				       in_data, fill_size);
				/* Submit the filled out save buffer */
                                if ((rc = ica_sha384(SHA_MSG_PART_FIRST, SHA3_BLOCK_SIZE,
                                                     oc_sha_ctx->tail,
                                                     ica_sha3_ctx, oc_sha_ctx->hash))) {
					rv = CKR_FUNCTION_FAILED;
					goto out;
				}
			} else {
				memcpy((oc_sha_ctx->tail
					+ oc_sha_ctx->tail_len),
				       in_data, in_data_len);
				oc_sha_ctx->tail_len += in_data_len;
				goto out;
			}
                        /* We had to use 'fill_size' bytes from
                         * in_data to fill out the empty part of save
                         * data, so adjust in_data_len */
                        in_data_len -= fill_size;
                        oc_sha_ctx->tail_len = (in_data_len
						& SHA3_BLOCK_SIZE_MASK);
                        if (oc_sha_ctx->tail_len) {
                                memcpy(oc_sha_ctx->tail,
				       in_data + fill_size,
				       oc_sha_ctx->tail_len);
                                in_data_len &= ~(SHA3_BLOCK_SIZE_MASK);
                        }
		} else if (ica_sha3_ctx->runningLengthLow > 0
			   || ica_sha3_ctx->runningLengthHigh > 0) {
			oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;
			if(oc_sha_ctx->tail_len) {
	                        fill_size = (SHA3_BLOCK_SIZE
					     - oc_sha_ctx->tail_len);
        	                if (fill_size < in_data_len) {
					int rc;

                	                memcpy((oc_sha_ctx->tail
						+ oc_sha_ctx->tail_len),
					       in_data, fill_size);
                        	        /* Submit the filled out save
					 * buffer */
                                        rc = ica_sha384(oc_sha_ctx->message_part,
                                                        SHA3_BLOCK_SIZE, oc_sha_ctx->tail,
                                                        ica_sha3_ctx, oc_sha_ctx->hash);
                                	if (rc) {
						rv = CKR_FUNCTION_FAILED;
						goto out;
					}
                	        } else {
                        	        memcpy((oc_sha_ctx->tail
						+ oc_sha_ctx->tail_len),
					       in_data, in_data_len);
	                                oc_sha_ctx->tail_len += in_data_len;
					goto out;
                	        }
				/* We had to use some of the data from
				 * in_data to fill out the empty part
				 * of save data, so adjust in_data_len */
				in_data_len -= fill_size;
				oc_sha_ctx->tail_len = (in_data_len
							& SHA3_BLOCK_SIZE_MASK);
				if(oc_sha_ctx->tail_len) {
					memcpy(oc_sha_ctx->tail,
					       (in_data + fill_size),
					       oc_sha_ctx->tail_len);
					in_data_len &= ~(SHA3_BLOCK_SIZE_MASK);
				}
			} else {
				/* This is the odd case, where we need
				 * to go ahead and send the first X *
				 * SHA3_BLOCK_SIZE byte chunks in to
				 * be processed and copy the last
				 * <SHA3_BLOCK_SIZE byte area into the
				 * tail.
				 *
				 * Just copying the last
				 * <SHA3_BLOCK_SIZE bytes will not
				 * work in the case of a user who
				 * SHA's a large chunk of data in
				 * SHA3_BLOCK_SIZE byte pieces because
				 * we need to cache the last
				 * SHA3_BLOCK_SIZE bytes so that we're
				 * not stuck with 0 bytes when the
				 * MSG_PART_FINAL comes in. */
                        	if (!(in_data_len % SHA3_BLOCK_SIZE)) {
                                	oc_sha_ctx->tail_len = SHA3_BLOCK_SIZE;
	                                memcpy(oc_sha_ctx->tail,
					       (in_data + in_data_len
						- SHA3_BLOCK_SIZE),
					       SHA3_BLOCK_SIZE);
        	                        in_data_len -= SHA3_BLOCK_SIZE;
                	        } else {
                        	        oc_sha_ctx->tail_len =
						(in_data_len
						 & SHA3_BLOCK_SIZE_MASK);
				}
				if (oc_sha_ctx->tail_len < SHA3_BLOCK_SIZE) {
					in_data_len &= ~(SHA3_BLOCK_SIZE_MASK);
					memcpy(oc_sha_ctx->tail,
					       (in_data + in_data_len),
					       oc_sha_ctx->tail_len);
				}
			}
		}
	} else {
		/* ctx->multi == FALSE, but we've run
		 * previously. That's our signal that this is the last
		 * part -KEY */
		if (ica_sha3_ctx->runningLengthLow > 0
		    || ica_sha3_ctx->runningLengthHigh > 0) {
			oc_sha_ctx->message_part = SHA_MSG_PART_FINAL;
		} else {
			oc_sha_ctx->message_part = SHA_MSG_PART_ONLY;
		}
	}
	if (in_data_len 
	    || (oc_sha_ctx->message_part == SHA_MSG_PART_FINAL)) {
		int rc;

                if ((rc = ica_sha384(oc_sha_ctx->message_part, in_data_len,
                                     (in_data + fill_size),
                                     ica_sha3_ctx, oc_sha_ctx->hash))) {
			rv = CKR_FUNCTION_FAILED;
			goto out;
		}
	}
 out:
	return rv;
}

CK_RV token_specific_sha5_update(DIGEST_CONTEXT *ctx, CK_BYTE *in_data,
				 CK_ULONG in_data_len)
{
	unsigned int fill_size = 0;
	CK_RV rv = CKR_OK;
	struct oc_sha_ctx *oc_sha_ctx = (struct oc_sha_ctx *)ctx->context;
	SHA512_CONTEXT *ica_sha5_ctx=(SHA512_CONTEXT *)oc_sha_ctx->dev_ctx;

        oc_sha_ctx->hash_len = SHA512_HASH_LENGTH;

	if (!ctx) {
		rv = CKR_OPERATION_NOT_INITIALIZED;
		goto out;
	}
	if (!in_data) {
		rv = CKR_FUNCTION_FAILED;
		goto out;
	}
	if (ctx->multi == TRUE) {
		if (oc_sha_ctx->tail_len == SHA5_BLOCK_SIZE) {
			int rc;
			/* Submit the filled out save buffer */
                        if ((rc = ica_sha512(((ica_sha5_ctx->runningLengthLow == 0
                                             && ica_sha5_ctx->runningLengthHigh == 0) ?
                                             SHA_MSG_PART_FIRST : SHA_MSG_PART_MIDDLE),
                                             SHA5_BLOCK_SIZE, oc_sha_ctx->tail,
                                             ica_sha5_ctx, oc_sha_ctx->hash))) {
				rv = CKR_FUNCTION_FAILED;
				goto out;
			}
			oc_sha_ctx->tail_len = 0;
		}

		/* libICA and SHA512 demand that if this is a
		 * PART_FIRST or a PART_MIDDLE operation, the amount
		 * of data passed in must be a multiple of
		 * SHA5_BLOCK_SIZE bytes. */
		if (ica_sha5_ctx->runningLengthLow == 0
		    && ica_sha5_ctx->runningLengthHigh == 0
		    && oc_sha_ctx->tail_len == 0) {
			oc_sha_ctx->message_part = SHA_MSG_PART_FIRST;
			/* Just copying the last <SHA5_BLOCK_SIZE
			 * bytes will not work in the case of a user
			 * who SHA's a large chunk of data in
			 * SHA5_BLOCK_SIZE byte pieces because we need
			 * to cache the last SHA5_BLOCK_SIZE bytes so
			 * that we're not stuck with 0 bytes when the
			 * MSG_PART_FINAL comes in. */
			if (!(in_data_len % SHA5_BLOCK_SIZE)) {
				oc_sha_ctx->tail_len = SHA5_BLOCK_SIZE;
				memcpy(oc_sha_ctx->tail,
				       (in_data + in_data_len
					- SHA5_BLOCK_SIZE), SHA5_BLOCK_SIZE);
				in_data_len -= SHA5_BLOCK_SIZE;
			} else {
				oc_sha_ctx->tail_len = (in_data_len
							& SHA5_BLOCK_SIZE_MASK);
			}
			if (oc_sha_ctx->tail_len < SHA5_BLOCK_SIZE) {
				in_data_len &= ~(SHA5_BLOCK_SIZE_MASK);	
				memcpy(oc_sha_ctx->tail,
				       (in_data + in_data_len),
				       oc_sha_ctx->tail_len);
			}
		} else if (ica_sha5_ctx->runningLengthLow == 0
			   && ica_sha5_ctx->runningLengthHigh == 0
			   && oc_sha_ctx->tail_len > 0) {
			/* Here we need to fill out the temporary tail
			 * buffer until it has SHA5_BLOCK_SIZE bytes
                         * in it, then call ica_sha512 on that buffer.
			 * If there weren't enough bytes passed in to
			 * fill it out, just copy in what we can and
			 * return success without calling
                         * ica_sha512. */
			fill_size = (SHA5_BLOCK_SIZE - oc_sha_ctx->tail_len);
			if (fill_size < in_data_len) {
				int rc;
				memcpy((oc_sha_ctx->tail
					+ oc_sha_ctx->tail_len),
				       in_data, fill_size);
				/* Submit the filled out save buffer */
                                if ((rc = ica_sha512(SHA_MSG_PART_FIRST, SHA5_BLOCK_SIZE,
                                                     oc_sha_ctx->tail, ica_sha5_ctx,
                                                     oc_sha_ctx->hash))) {
					rv = CKR_FUNCTION_FAILED;
					goto out;
				}
			} else {
				memcpy((oc_sha_ctx->tail
					+ oc_sha_ctx->tail_len),
				       in_data, in_data_len);
				oc_sha_ctx->tail_len += in_data_len;
				goto out;
			}
                        /* We had to use 'fill_size' bytes from
                         * in_data to fill out the empty part of save
                         * data, so adjust in_data_len */
                        in_data_len -= fill_size;
                        oc_sha_ctx->tail_len = (in_data_len
						& SHA5_BLOCK_SIZE_MASK);
                        if (oc_sha_ctx->tail_len) {
                                memcpy(oc_sha_ctx->tail,
				       in_data + fill_size,
				       oc_sha_ctx->tail_len);
                                in_data_len &= ~(SHA5_BLOCK_SIZE_MASK);
                        }
		} else if (ica_sha5_ctx->runningLengthLow > 0
			   || ica_sha5_ctx->runningLengthHigh > 0) {
			oc_sha_ctx->message_part = SHA_MSG_PART_MIDDLE;
			if(oc_sha_ctx->tail_len) {
	                        fill_size = (SHA5_BLOCK_SIZE
					     - oc_sha_ctx->tail_len);
        	                if (fill_size < in_data_len) {
					int rc;

                	                memcpy((oc_sha_ctx->tail
						+ oc_sha_ctx->tail_len),
					       in_data, fill_size);
                        	        /* Submit the filled out save
					 * buffer */
                                        rc = ica_sha512(oc_sha_ctx->message_part, SHA5_BLOCK_SIZE,
                                                        oc_sha_ctx->tail, ica_sha5_ctx,
                                                        oc_sha_ctx->hash);
                                	if (rc) {
						rv = CKR_FUNCTION_FAILED;
						goto out;
					}
                	        } else {
                        	        memcpy((oc_sha_ctx->tail
						+ oc_sha_ctx->tail_len),
					       in_data, in_data_len);
	                                oc_sha_ctx->tail_len += in_data_len;
					goto out;
                	        }
				/* We had to use some of the data from
				 * in_data to fill out the empty part
				 * of save data, so adjust in_data_len */
				in_data_len -= fill_size;
				oc_sha_ctx->tail_len = (in_data_len
							& SHA5_BLOCK_SIZE_MASK);
				if(oc_sha_ctx->tail_len) {
					memcpy(oc_sha_ctx->tail,
					       (in_data + fill_size),
					       oc_sha_ctx->tail_len);
					in_data_len &= ~(SHA5_BLOCK_SIZE_MASK);
				}
			} else {
				/* This is the odd case, where we need
				 * to go ahead and send the first X *
				 * SHA5_BLOCK_SIZE byte chunks in to
				 * be processed and copy the last
				 * <SHA5_BLOCK_SIZE byte area into the
				 * tail.
				 *
				 * Just copying the last
				 * <SHA5_BLOCK_SIZE bytes will not
				 * work in the case of a user who
				 * SHA's a large chunk of data in
				 * SHA5_BLOCK_SIZE byte pieces because
				 * we need to cache the last
				 * SHA5_BLOCK_SIZE bytes so that we're
				 * not stuck with 0 bytes when the
				 * MSG_PART_FINAL comes in. */
                        	if (!(in_data_len % SHA5_BLOCK_SIZE)) {
                                	oc_sha_ctx->tail_len = SHA5_BLOCK_SIZE;
	                                memcpy(oc_sha_ctx->tail,
					       (in_data + in_data_len
						- SHA5_BLOCK_SIZE),
					       SHA5_BLOCK_SIZE);
        	                        in_data_len -= SHA5_BLOCK_SIZE;
                	        } else {
                        	        oc_sha_ctx->tail_len =
						(in_data_len
						 & SHA5_BLOCK_SIZE_MASK);
				}
				if (oc_sha_ctx->tail_len < SHA5_BLOCK_SIZE) {
					in_data_len &= ~(SHA5_BLOCK_SIZE_MASK);
					memcpy(oc_sha_ctx->tail,
					       (in_data + in_data_len),
					       oc_sha_ctx->tail_len);
				}
			}
		}
	} else {
		/* ctx->multi == FALSE, but we've run
		 * previously. That's our signal that this is the last
		 * part -KEY */
		if (ica_sha5_ctx->runningLengthLow > 0
		    || ica_sha5_ctx->runningLengthHigh > 0) {
			oc_sha_ctx->message_part = SHA_MSG_PART_FINAL;
		} else {
			oc_sha_ctx->message_part = SHA_MSG_PART_ONLY;
		}
	}
	if (in_data_len 
	    || (oc_sha_ctx->message_part == SHA_MSG_PART_FINAL)) {
		int rc;

                if ((rc = ica_sha512(oc_sha_ctx->message_part, in_data_len,
                                     (in_data + fill_size), ica_sha5_ctx, oc_sha_ctx->hash))) {
			rv = CKR_FUNCTION_FAILED;
			goto out;
		}
	}
 out:
	return rv;
}

/**
 * The update functions have too much type-specific code for it to
 * make sense to collapse them into a single function.
 */
CK_RV token_specific_sha_generic_update(DIGEST_CONTEXT *ctx, CK_BYTE *in_data,
					CK_ULONG in_data_len,
					CK_MECHANISM_TYPE sha_type)
{
	switch (sha_type) {
	case CKM_SHA_1:
		return token_specific_sha_update(ctx, in_data, in_data_len);
	case CKM_SHA256:
		return token_specific_sha2_update(ctx, in_data, in_data_len);
	case CKM_SHA384:
		return token_specific_sha3_update(ctx, in_data, in_data_len);
	case CKM_SHA512:
		return token_specific_sha5_update(ctx, in_data, in_data_len);
	default:
		return CKR_MECHANISM_INVALID;
	}
}

CK_RV
token_specific_sha_generic_final(DIGEST_CONTEXT	*ctx, CK_BYTE *out_data,
				 CK_ULONG *out_data_len,
				 CK_MECHANISM_TYPE sha_type)
{
	struct oc_sha_ctx *oc_sha_ctx = (struct oc_sha_ctx *)ctx->context;
	unsigned int copy_len, hash_len;

	if (!ctx)
		return CKR_OPERATION_NOT_INITIALIZED;
	switch (sha_type) {
	case CKM_SHA_1:
                hash_len = SHA_HASH_LENGTH;
		break;
	case CKM_SHA256:
                hash_len = SHA256_HASH_LENGTH;
		break;
	case CKM_SHA384:
                hash_len = SHA384_HASH_LENGTH;
		break;
	case CKM_SHA512:
                hash_len = SHA512_HASH_LENGTH;
		break;
	default:
		return CKR_MECHANISM_INVALID;
	}
	if(!out_data || (*out_data_len < hash_len))
		return CKR_FUNCTION_FAILED;
	if ((oc_sha_ctx->message_part != SHA_MSG_PART_FINAL)
	    && (oc_sha_ctx->message_part != SHA_MSG_PART_ONLY)) {
		/* Finalize the SHA operation; tell update that this
		 * multi-part operation is done. -KEY */
		ctx->multi = FALSE;
		token_specific_sha_generic_update(ctx, oc_sha_ctx->tail,
						  oc_sha_ctx->tail_len,
						  sha_type);
	}
	copy_len = MIN(*out_data_len, hash_len);
	memcpy(out_data, oc_sha_ctx->hash, copy_len);
	*out_data_len = copy_len;
	/* ctx->context is freed inside digest_mgr_cleanup - KEY */
	free(oc_sha_ctx->dev_ctx);
	return CKR_OK;
}

CK_RV
token_specific_sha_final(	DIGEST_CONTEXT	*ctx,
				CK_BYTE		*out_data,
				CK_ULONG	*out_data_len )
{
	return token_specific_sha_generic_final(ctx, out_data, out_data_len,
						CKM_SHA_1);
}

CK_RV token_specific_sha2_final(DIGEST_CONTEXT *ctx, CK_BYTE *out_data,
				CK_ULONG *out_data_len)
{
	return token_specific_sha_generic_final(ctx, out_data, out_data_len,
						CKM_SHA256);
}

CK_RV token_specific_sha3_final(DIGEST_CONTEXT *ctx, CK_BYTE *out_data,
				CK_ULONG *out_data_len)
{
	return token_specific_sha_generic_final(ctx, out_data, out_data_len,
						CKM_SHA384);
}

CK_RV token_specific_sha5_final(DIGEST_CONTEXT *ctx, CK_BYTE *out_data,
				CK_ULONG *out_data_len)
{
	return token_specific_sha_generic_final(ctx, out_data, out_data_len,
						CKM_SHA512);
}

#ifndef LITE
#define LITE
#endif

/* Creates a libICA modulus+exponent key representation using
 * PKCS#11 attributes
 */
ica_rsa_key_mod_expo_t *
rsa_convert_mod_expo_key( CK_ATTRIBUTE * modulus,
                          CK_ATTRIBUTE * mod_bits,
                          CK_ATTRIBUTE * exponent)
{
   CK_BYTE                * ptr     = NULL;
   ica_rsa_key_mod_expo_t * modexpokey = NULL;

   /* We need at least the modulus and a (public|private) exponent */
   if (!modulus || !exponent) {
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
      return NULL;
   }

   modexpokey = (ica_rsa_key_mod_expo_t *) calloc(1, sizeof(ica_rsa_key_mod_expo_t));
   if (modexpokey == NULL) {
      st_err_log(1, __FILE__, __LINE__);
      goto err;
   }

   /* We can't rely solely on CKA_MODULUS_BITS here since Private Keys
    * using the modulus + private exponent representation may also go
    * through this path. Use modulus length in bytes as key_length if
    * no mod_bits is present */
   if (mod_bits != NULL) {
      modexpokey->key_length = ((* (CK_ULONG *) mod_bits->pValue) + 7 ) / 8;
   }
   else {
      modexpokey->key_length = modulus->ulValueLen;
   }

   /* maybe I'm over-cautious here */
   if ( (modulus->ulValueLen > modexpokey->key_length) ||
        (exponent->ulValueLen > modexpokey->key_length)) {
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
      goto err;
   }

   modexpokey->modulus = (unsigned char *) calloc(1, modexpokey->key_length);

   if (modexpokey->modulus == NULL) {
      st_err_log(1, __FILE__, __LINE__);
      goto err;
   }

   /* right-justified fields */
   ptr = modexpokey->modulus + modexpokey->key_length - modulus->ulValueLen;
   memcpy(ptr, modulus->pValue, modexpokey->key_length);

   modexpokey->exponent = (unsigned char *) calloc(1, modexpokey->key_length);
   if (modexpokey->exponent == NULL) {
      st_err_log(1, __FILE__, __LINE__);
      goto err;
   }

   ptr = modexpokey->exponent + modexpokey->key_length - exponent->ulValueLen;
   memcpy(ptr, exponent->pValue, exponent->ulValueLen);
   return modexpokey;

 err:
   free(modexpokey->modulus);
   free(modexpokey->exponent);
   free(modexpokey);
   return NULL;

}

/* Creates a libICA CRT key representation using
 * PKCS#11 attributes
 */
ica_rsa_key_crt_t *
rsa_convert_crt_key( CK_ATTRIBUTE * modulus,
                     CK_ATTRIBUTE * prime1,
                     CK_ATTRIBUTE * prime2,
                     CK_ATTRIBUTE * exp1,
                     CK_ATTRIBUTE * exp2,
                     CK_ATTRIBUTE * coeff)
{
   CK_BYTE           * ptr      = NULL;
   ica_rsa_key_crt_t * crtkey  = NULL;

   /* All the above params are required to build a CRT key
    * that can be used by libICA. Private Keys with modulus
    * and private exponent should use rsa_convert_mod_expo_key() */
   if (!modulus || !prime1 || !prime2 || !exp1 || !exp2 || !coeff ) {
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
      return NULL;
   }
   else {
      crtkey = (ica_rsa_key_crt_t *) calloc(1, sizeof(ica_rsa_key_crt_t));
      if (crtkey == NULL) {
         st_err_log(1, __FILE__, __LINE__);
         return NULL;
      }
      /* use modulus length in bytes as key_length */
      crtkey->key_length = modulus->ulValueLen;

      /* buffers pointed by p, q, dp, dq and qInverse in struct
       * ica_rsa_key_crt_t must be of size key_legth/2 or larger.
       * p, dp and qInverse have an additional 8-byte padding. */

      /* need to allocate the buffers. Also, all fields are
       * right-aligned, thus the use for ptr */

      /* FIXME: if individual components lengths are bigger then
       * what we support in libICA then we're in trouble,
       * but maybe explicitly checking them is being over-zealous? */
      if ( (prime1->ulValueLen > (crtkey->key_length/2)) ||
           (prime2->ulValueLen > (crtkey->key_length/2)) ||
           (exp1->ulValueLen   > (crtkey->key_length/2)) ||
           (exp2->ulValueLen   > (crtkey->key_length/2)) ||
           (coeff->ulValueLen  > (crtkey->key_length/2)) ) {
         st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
         goto err_crtkey;
      }
      crtkey->p = (unsigned char *) calloc(1, (crtkey->key_length/2) + 8);
      if (crtkey->p == NULL) {
         st_err_log(1, __FILE__, __LINE__);
         goto err_crtkey;
      }
      ptr = crtkey->p + (crtkey->key_length/2) + 8 - prime1->ulValueLen;
      memcpy(ptr, prime1->pValue, prime1->ulValueLen);

      crtkey->q = (unsigned char *) calloc(1, crtkey->key_length/2);

      if (crtkey->q == NULL) {
         st_err_log(1, __FILE__, __LINE__);
         goto err_crtkey;
      }
      ptr = crtkey->q + (crtkey->key_length/2) - prime2->ulValueLen;
      memcpy(ptr, prime2->pValue, prime2->ulValueLen);

      crtkey->dp = (unsigned char *) calloc(1, (crtkey->key_length/2) + 8);
      if (crtkey->dp == NULL) {
         st_err_log(1, __FILE__, __LINE__);
         goto err_crtkey;
      }
      ptr = crtkey->dp + (crtkey->key_length/2) + 8 - exp1->ulValueLen;
      memcpy(ptr, exp1->pValue, exp1->ulValueLen);

      crtkey->dq = (unsigned char *) calloc(1, crtkey->key_length/2);
      if (crtkey->dq == NULL) {
         st_err_log(1, __FILE__, __FILE__);
         goto err_crtkey;
      }
      ptr = crtkey->dq + (crtkey->key_length/2) - exp2->ulValueLen;
      memcpy(ptr, exp2->pValue, exp2->ulValueLen);

      crtkey->qInverse = (unsigned char *) calloc(1, (crtkey->key_length/2) + 8);
      if (crtkey->qInverse == NULL) {
         st_err_log(1, __FILE__, __LINE__);
         goto err_crtkey;
      }
      ptr = crtkey->qInverse + (crtkey->key_length/2) + 8 - coeff->ulValueLen;
      memcpy(ptr, coeff->pValue, coeff->ulValueLen);

      return crtkey;
   }

 err_crtkey:
   free(crtkey->p);
   free(crtkey->q);
   free(crtkey->dp);
   free(crtkey->dq);
   free(crtkey->qInverse);
   free(crtkey);
   return NULL;

}



//
CK_RV
os_specific_rsa_keygen(TEMPLATE *publ_tmpl,  TEMPLATE *priv_tmpl)
{
   CK_ATTRIBUTE       * publ_exp = NULL;
   CK_ATTRIBUTE       * attr     = NULL;
   CK_BYTE            * ptr      = NULL;
   CK_ULONG             mod_bits;
   CK_BBOOL             flag;
   CK_RV                rc;
   ica_rsa_key_mod_expo_t * publKey = NULL;
   ica_rsa_key_crt_t      * privKey = NULL;

   flag = template_attribute_find( publ_tmpl, CKA_MODULUS_BITS, &attr );
   if (!flag) {
       st_err_log(48, __FILE__, __LINE__);
       return CKR_TEMPLATE_INCOMPLETE;  // should never happen
   }
   mod_bits = *(CK_ULONG *)attr->pValue;

   flag = template_attribute_find( publ_tmpl, CKA_PUBLIC_EXPONENT, &publ_exp );
   if (!flag) {
        st_err_log(48, __FILE__, __LINE__);
	return CKR_TEMPLATE_INCOMPLETE;
   }


   // FIXME: is this check really necessary?
   if (mod_bits < 512 || mod_bits > 4096) {
      st_err_log(19, __FILE__, __LINE__);
     return CKR_KEY_SIZE_RANGE;
   }

   /* libICA replicates the openSSL requirement that the public exponent
    * can't be larger than the size of an unsigned long
    */
   if (publ_exp->ulValueLen > sizeof (unsigned long)) {
      st_err_log(19, __FILE__, __LINE__);
     return CKR_KEY_SIZE_RANGE;
   }

   /* Build publKey:
    * The buffers in ica_rsa_key_mod_expo_t must be
    * allocated by the caller, with key_length size
    * use calloc() so that memory is zeroed (right alignment) */
   publKey = (ica_rsa_key_mod_expo_t *) calloc(1, sizeof(ica_rsa_key_mod_expo_t));
   if (publKey == NULL) {
      st_err_log(1, __FILE__, __LINE__);
      return CKR_HOST_MEMORY;
   }

   /* key_length is in terms of bytes */
   publKey->key_length = ((mod_bits + 7) / 8);

   publKey->modulus = (unsigned char *) calloc(1, publKey->key_length);
   if (publKey->modulus == NULL) {
      st_err_log(1, __FILE, __LINE__);
      rc = CKR_HOST_MEMORY;
      goto pubkey_cleanup;
   }

   publKey->exponent = (unsigned char *) calloc(1, publKey->key_length);
   if (publKey->exponent == NULL) {
      st_err_log(1, __FILE, __LINE___);
      rc = CKR_HOST_MEMORY;
      goto pubkey_cleanup;
   }

   /* Use the provided public exponent:
    * all fields must be right-aligned, so make
    * sure we only use the rightmost part */
   ptr = publKey->exponent + publKey->key_length - publ_exp->ulValueLen;
   memcpy(ptr, publ_exp->pValue, publ_exp->ulValueLen);

   /* Build privKey:
    * buffers pointed by p, q, dp, dq and qInverse in struct
    * ica_rsa_key_crt_t must be of size key_legth/2 or larger.
    * p, dp and qInverse have an additional 8-byte padding */
   privKey = (ica_rsa_key_crt_t *) calloc(1, sizeof(ica_rsa_key_crt_t));
   if (privKey == NULL) {
     st_err_log(1, __FILE__, __LINE__);
     rc = CKR_HOST_MEMORY;
     goto pubkey_cleanup;
   }

   /* modexpo and crt key lengths are always the same */
   privKey->key_length = publKey->key_length;

   privKey->p = (unsigned char *) calloc(1, (privKey->key_length/2) + 8);
   if (privKey->p == NULL) {
      st_err_log(1, __FILE__, __LINE__);
      rc = CKR_HOST_MEMORY;
      goto privkey_cleanup;
   }

   privKey->q = (unsigned char *) calloc(1, privKey->key_length/2);
   if (privKey->q == NULL) {
      st_err_log(1, __FILE__, __LINE__);
      rc = CKR_HOST_MEMORY;
      goto privkey_cleanup;
   }

   privKey->dp = (unsigned char *) calloc(1, (privKey->key_length/2) + 8);
   if (privKey->dp == NULL) {
      st_err_log(1, __FILE__, __LINE__);
      rc = CKR_HOST_MEMORY;
      goto privkey_cleanup;
   }

   privKey->dq = (unsigned char *) calloc(1, privKey->key_length/2);
   if (privKey->dq == NULL) {
      st_err_log(1, __FILE__, __LINE__);
      rc = CKR_HOST_MEMORY;
      goto privkey_cleanup;
   }

   privKey->qInverse = (unsigned char *) calloc(1, (privKey->key_length/2) + 8);
   if (privKey->qInverse == NULL) {
      st_err_log(1, __FILE__, __LINE__);
      rc = CKR_HOST_MEMORY;
      goto privkey_cleanup;
   }

   rc = ica_rsa_key_generate_crt(adapter_handle,
                                 (unsigned int)mod_bits,
                                 publKey,
                                 privKey);

   
   if(rc){
     st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
     rc = CKR_FUNCTION_FAILED;
     goto privkey_cleanup;
   }
   

   // modulus: n
   //
   rc = build_attribute( CKA_MODULUS, publKey->modulus,
                        publKey->key_length, &attr );
   if (rc != CKR_OK){
      st_err_log(84, __FILE__, __LINE__);
      goto privkey_cleanup;
   }
   template_update_attribute( publ_tmpl, attr );

  
   // local = TRUE
   //
   flag = TRUE;
   rc = build_attribute( CKA_LOCAL, &flag, sizeof(CK_BBOOL), &attr );
   if (rc != CKR_OK){
      st_err_log(84, __FILE__, __LINE__);
      goto privkey_cleanup;
   }
   template_update_attribute( publ_tmpl, attr );

   //
   // now, do the private key
   //

   // public exponent: e
   //
   rc = build_attribute( CKA_PUBLIC_EXPONENT, publ_exp->pValue, publ_exp->ulValueLen, &attr );
   if (rc != CKR_OK) {
      st_err_log(84, __FILE__, __LINE__);
      goto privkey_cleanup;
   }
   template_update_attribute( priv_tmpl, attr );

   // modulus: n
   //
   rc = build_attribute( CKA_MODULUS, publKey->modulus,
                        publKey->key_length, &attr );
   if (rc != CKR_OK){
      st_err_log(84, __FILE__, __LINE__);
      return rc;
   }
   template_update_attribute( priv_tmpl, attr );

   // exponent 1: d mod(p-1)
   //
   rc = build_attribute( CKA_EXPONENT_1, privKey->dp + 8,
                        privKey->key_length/2, &attr );
   if (rc != CKR_OK){
      st_err_log(84, __FILE__, __LINE__);
      goto privkey_cleanup;
   }
   template_update_attribute( priv_tmpl, attr );

   // exponent 2: d mod(q-1)
   //
   rc = build_attribute( CKA_EXPONENT_2, privKey->dq,
                        privKey->key_length/2, &attr );
   if (rc != CKR_OK){
      st_err_log(84, __FILE__, __LINE__);
      goto privkey_cleanup;
   }
   template_update_attribute( priv_tmpl, attr );

   // prime #1: p
   //
   rc = build_attribute( CKA_PRIME_1, privKey->p + 8,
                        privKey->key_length/2, &attr );
   if (rc != CKR_OK){
      st_err_log(84, __FILE__, __LINE__);
      goto privkey_cleanup;
   }
   template_update_attribute( priv_tmpl, attr );

   
   // prime #2: q
   //
   rc = build_attribute( CKA_PRIME_2, privKey->q,
                        privKey->key_length/2, &attr );
   if (rc != CKR_OK){
      st_err_log(84, __FILE__, __LINE__);
      goto privkey_cleanup;
   }
   template_update_attribute( priv_tmpl, attr );


   // CRT coefficient:  q_inverse mod(p)
   //
   rc = build_attribute( CKA_COEFFICIENT, privKey->qInverse + 8,
                        privKey->key_length/2, &attr );
   if (rc != CKR_OK){
      st_err_log(84, __FILE__, __LINE__);
      goto privkey_cleanup;
   }
   template_update_attribute( priv_tmpl, attr );

 privkey_cleanup:
   free(privKey->p);
   free(privKey->q);
   free(privKey->dp);
   free(privKey->dq);
   free(privKey->qInverse);
   free(privKey);
 pubkey_cleanup:
   free(publKey->modulus);
   free(publKey->exponent);
   free(publKey);
   return rc;

}

CK_RV
token_specific_rsa_generate_keypair( TEMPLATE  * publ_tmpl,
                      TEMPLATE  * priv_tmpl )
{
   CK_RV                rc;

   rc = os_specific_rsa_keygen(publ_tmpl,priv_tmpl);
   if (rc != CKR_OK)
         st_err_log(91, __FILE__, __LINE__);
   return rc;
}


//
//
CK_RV
token_specific_rsa_encrypt( CK_BYTE   * in_data,
                 CK_ULONG    in_data_len,
                 CK_BYTE   * out_data,
                 OBJECT    * key_obj )
{
   CK_ATTRIBUTE      * modulus = NULL;
   CK_ATTRIBUTE      * pub_exp = NULL;
   CK_ATTRIBUTE      * mod_bits = NULL;
   ica_rsa_key_mod_expo_t * publKey  = NULL;
   CK_RV               rc;

   /* mech_sra.c:ckm_rsa_encrypt accepts only CKO_PUBLIC_KEY */
   template_attribute_find( key_obj->template, CKA_MODULUS,          &modulus  );
   template_attribute_find( key_obj->template, CKA_MODULUS_BITS,     &mod_bits );
   template_attribute_find( key_obj->template, CKA_PUBLIC_EXPONENT,  &pub_exp  );

   publKey = rsa_convert_mod_expo_key(modulus, mod_bits, pub_exp);
   if (publKey == NULL) {
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
      rc = CKR_FUNCTION_FAILED;
      goto done;
   }

   /* in_data must be in big endian format. 'in_data' size in bits must not
    * exceed the bit length of the key, and size in bytes must
    * be of the same length of the key */
   // FIXME: we're not cheking the size in bits of in_data - but how could we?
   if (publKey->key_length != in_data_len) {
      st_err_log(11, __FILE__, __LINE__);
      rc = CKR_DATA_LEN_RANGE;
      goto cleanup_pubkey;
   }
   rc = ica_rsa_mod_expo(adapter_handle, in_data,
                         publKey, out_data);

   if (rc != 0) {
      st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
      rc = CKR_FUNCTION_FAILED;
   } else {
      rc = CKR_OK;
   }

cleanup_pubkey:
   free(publKey->modulus);
   free(publKey->exponent);
   free(publKey);


done:
   return rc;
}


//
//
CK_RV
token_specific_rsa_decrypt( CK_BYTE   * in_data,
                 CK_ULONG    in_data_len,
                 CK_BYTE   * out_data,
                 OBJECT    * key_obj )
{
   CK_ATTRIBUTE      * modulus  = NULL;
   CK_ATTRIBUTE      * prime1   = NULL;
   CK_ATTRIBUTE      * prime2   = NULL;
   CK_ATTRIBUTE      * exp1     = NULL;
   CK_ATTRIBUTE      * exp2     = NULL;
   CK_ATTRIBUTE      * coeff    = NULL;
   CK_ATTRIBUTE           * priv_exp   = NULL;
   ica_rsa_key_crt_t      * crtKey     = NULL;
   ica_rsa_key_mod_expo_t * modexpoKey = NULL;
   CK_RV               rc;

   /* mech_rsa.c:ckm_rsa_decrypt accepts only CKO_PRIVATE_KEY,
    * but Private Key can have 2 representations (see PKCS#1):
    *  - Modulus + private exponent
    *  - p, q, dp, dq and qInv (CRT format)
    * The former should use ica_rsa_key_mod_expo_t and the latter
    * ica_rsa_key_crt_t. Detect what representation this
    * key_obj has and use the proper convert function */

   template_attribute_find( key_obj->template, CKA_MODULUS,          &modulus );
   template_attribute_find( key_obj->template, CKA_PRIVATE_EXPONENT, &priv_exp );
   template_attribute_find( key_obj->template, CKA_PRIME_1,          &prime1  );
   template_attribute_find( key_obj->template, CKA_PRIME_2,          &prime2  );
   template_attribute_find( key_obj->template, CKA_EXPONENT_1,       &exp1    );
   template_attribute_find( key_obj->template, CKA_EXPONENT_2,       &exp2    );
   template_attribute_find( key_obj->template, CKA_COEFFICIENT,      &coeff   );

   /* Need to check for CRT Key format *BEFORE* check for mod_expo key,
    * that's because opencryptoki *HAS* a CKA_PRIVATE_EXPONENT attribute
    * even in CRT keys (but with zero length) */
   // FIXME: Checking for non-zero lengths anyway (might be overkill)

   if (modulus && modulus->ulValueLen &&
       prime1  && prime1->ulValueLen  &&
       prime2  && prime2->ulValueLen  &&
       exp1    && exp1->ulValueLen    &&
       exp2    && exp2->ulValueLen    &&
       coeff   && coeff->ulValueLen     ) {
      /* ica_rsa_key_crt_t representation */
      crtKey = rsa_convert_crt_key(modulus, prime1, prime2, exp1, exp2, coeff);
      if (crtKey == NULL) {
         st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
         rc = CKR_FUNCTION_FAILED;
         goto done;
      }
      /* same check as above */
      if (crtKey->key_length != in_data_len) {
         st_err_log(11, __FILE__, __LINE__);
         rc = CKR_ENCRYPTED_DATA_LEN_RANGE;
         goto crt_cleanup;
      }

      rc = ica_rsa_crt(adapter_handle, in_data,
                       crtKey, out_data);

      if (rc != 0) {
         st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
         rc = CKR_FUNCTION_FAILED;
      } else {
         rc = CKR_OK;
      }
      goto crt_cleanup;
   }
   else if (modulus  && modulus->ulValueLen &&
            priv_exp && priv_exp->ulValueLen  ) {
      /* ica_rsa_key_mod_expo_t representation */
      modexpoKey = rsa_convert_mod_expo_key(modulus, NULL, priv_exp);
      if (modexpoKey == NULL) {
         st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
         rc = CKR_FUNCTION_FAILED;
         goto done;
      }
      /* in_data must be in big endian format. Size in bits must not
       * exceed the bit length of the key, and size in bytes must
       * be the same */
      // FIXME: we're not cheking the size in bits of in_data - but how could we?
      if (modexpoKey->key_length != in_data_len) {
         st_err_log(11, __FILE__, __LINE__);
         rc = CKR_ENCRYPTED_DATA_LEN_RANGE;
         goto modexpo_cleanup;
      }

      rc = ica_rsa_mod_expo(adapter_handle, in_data,
                            modexpoKey, out_data);

      if (rc != 0) {
         st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
         rc = CKR_FUNCTION_FAILED;
      } else {
         rc = CKR_OK;
      }
      goto modexpo_cleanup;
   }
   else {
      /* should never happen */
      st_err_log(165, __FILE__, __LINE__);
      rc = CKR_MECHANISM_PARAM_INVALID;
      goto done;
   }

crt_cleanup:
   free(crtKey->p);
   free(crtKey->q);
   free(crtKey->dp);
   free(crtKey->dq);
   free(crtKey->qInverse);
   free(crtKey);
   goto done;

modexpo_cleanup:
   free(modexpoKey->modulus);
   free(modexpoKey->exponent);
   free(modexpoKey);

done:
   return rc;
}


CK_RV
token_specific_session(CK_SLOT_ID  slotid)
{
       return CKR_OK;

}

#ifndef NOAES

CK_RV
token_specific_aes_key_gen(CK_BYTE *key, CK_ULONG len)
{
        return rng_generate(key, len);
}

CK_RV
token_specific_aes_ecb(CK_BYTE *in_data, CK_ULONG in_data_len,
		       CK_BYTE *out_data, CK_ULONG *out_data_len,
		       CK_BYTE *key_value, CK_ULONG key_len, CK_BYTE encrypt)
{
	int rc = CKR_OK;

   /* 
    * checks for input and output data length and block sizes
    * are already being carried out in mech_aes.c
    * so we skip those
    */

        if (encrypt) {
        rc = ica_aes_encrypt(MODE_AES_ECB, (unsigned int) in_data_len,
                             in_data, NULL, (unsigned  int) key_len,
                             key_value, out_data);
        } else {
        rc = ica_aes_decrypt(MODE_AES_ECB, (unsigned int) in_data_len,
                             in_data, NULL, (unsigned int) key_len,
                             key_value, out_data);
        }
	if (rc != 0) {
        (*out_data_len) = 0;
		rc = CKR_FUNCTION_FAILED;
	} else {
		(*out_data_len) = in_data_len;
		rc = CKR_OK;
	}
        return rc;
}

CK_RV
token_specific_aes_cbc(CK_BYTE         *in_data,
		       CK_ULONG        in_data_len,
		       CK_BYTE         *out_data,
		       CK_ULONG        *out_data_len,
		       CK_BYTE         *key_value,
		       CK_ULONG        key_len,
		       CK_BYTE         *init_v,
		       CK_BYTE         encrypt)
{
	CK_RV rc;

   /* 
    * checks for input and output data length and block sizes
    * are already being carried out in mech_aes.c
    * so we skip those
    */

	if (encrypt) {
        rc = ica_aes_encrypt(MODE_AES_CBC, (unsigned int) in_data_len,
                             in_data, (ica_aes_vector_t *) init_v,
                             (unsigned int) key_len, key_value,
                             out_data);
	} else {
        rc = ica_aes_decrypt(MODE_AES_CBC, (unsigned int) in_data_len,
                             in_data, (ica_aes_vector_t *) init_v,
                             (unsigned int) key_len, key_value,
                             out_data);
	}
	if (rc != 0) {
        (*out_data_len) = 0;
		rc = CKR_FUNCTION_FAILED;
	} else {
		(*out_data_len) = in_data_len;
		rc = CKR_OK;
	}
	return rc;
}
#endif

#ifndef NODH 
// This computes DH shared secret, where:
//     Output: z is computed shared secret
//     Input:  y is other party's public key
//             x is private key
//             p is prime
// All length's are in number of bytes. All data comes in as Big Endian.
 
CK_RV
token_specific_dh_pkcs_derive( CK_BYTE   *z,
                               CK_ULONG  *z_len,
                               CK_BYTE   *y,
                               CK_ULONG  y_len,
                               CK_BYTE   *x,
                               CK_ULONG  x_len,
                               CK_BYTE   *p,
                               CK_ULONG  p_len)
{
     CK_RV  rc ;
     BIGNUM *bn_z, *bn_y, *bn_x, *bn_p ;
     BN_CTX *ctx;
 
     //  Create and Init the BIGNUM structures.
     bn_y = BN_new() ;
     bn_x = BN_new() ;
     bn_p = BN_new() ;
     bn_z = BN_new() ;

     if (bn_z == NULL || bn_p == NULL || bn_x == NULL || bn_y == NULL) {
	     if (bn_y) BN_free(bn_y);
	     if (bn_x) BN_free(bn_x);
	     if (bn_p) BN_free(bn_p);
	     if (bn_z) BN_free(bn_z);
	     st_err_log(1, __FILE__, __LINE__);
	     return CKR_HOST_MEMORY;
     }
     
     BN_init(bn_y) ;
     BN_init(bn_x) ;
     BN_init(bn_p) ;
 
     // Initialize context
     ctx=BN_CTX_new();
     if (ctx == NULL)
     {
        st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
        return CKR_FUNCTION_FAILED;
     }
 
     // Add data into these new BN structures
 
     BN_bin2bn((char *)y, y_len, bn_y);
     BN_bin2bn((char *)x, x_len, bn_x);
     BN_bin2bn((char *)p, p_len, bn_p);
 
     rc = BN_mod_exp(bn_z,bn_y,bn_x,bn_p,ctx);
     if (rc == 0)
     {
        BN_free(bn_z);
        BN_free(bn_y);
        BN_free(bn_x);
        BN_free(bn_p);
        BN_CTX_free(ctx);
 
        st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
        return CKR_FUNCTION_FAILED;
     }
 
     *z_len = BN_num_bytes(bn_z);
     BN_bn2bin(bn_z, z);
 
     BN_free(bn_z);
     BN_free(bn_y);
     BN_free(bn_x);
     BN_free(bn_p);
     BN_CTX_free(ctx);
 
     return CKR_OK;
 
} /* end token_specific_dh_pkcs_derive() */
 
// This computes DH key pair, where:
//     Output: priv_tmpl is generated private key
//             pub_tmpl is computed public key
//     Input:  pub_tmpl is public key (prime and generator)
// All length's are in number of bytes. All data comes in as Big Endian.

CK_RV
token_specific_dh_pkcs_key_pair_gen( TEMPLATE  * publ_tmpl,
                                     TEMPLATE  * priv_tmpl )
{
    CK_BBOOL           rc;
    CK_ATTRIBUTE       *prime_attr = NULL;
    CK_ATTRIBUTE       *base_attr = NULL;
    CK_ATTRIBUTE       *temp_attr = NULL ;
    CK_ATTRIBUTE       *value_bits_attr = NULL;
    CK_BYTE            *temp_byte;
    CK_ULONG           temp_bn_len ;
 
    DH                 *dh ;
    BIGNUM             *bn_p ;
    BIGNUM             *bn_g ;
    BIGNUM             *temp_bn ;
 
    rc  = template_attribute_find( publ_tmpl, CKA_PRIME, &prime_attr );
    rc &= template_attribute_find( publ_tmpl, CKA_BASE, &base_attr );
 
    if (rc == FALSE) {
        st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
        return CKR_FUNCTION_FAILED;
    }
 
    if ((prime_attr->ulValueLen > 256) || (prime_attr->ulValueLen < 64))
    {
        st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
        return CKR_FUNCTION_FAILED;
    }
 
    dh = DH_new() ;
    if (dh == NULL)
    {
        st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
        return CKR_FUNCTION_FAILED;
    }

    // Create and init BIGNUM structs to stick in the DH struct
    bn_p = BN_new();
    bn_g = BN_new();
    if (bn_g == NULL || bn_p == NULL) {
	if (bn_g) BN_free(bn_g);
	if (bn_p) BN_free(bn_p);
	st_err_log(1, __FILE__, __LINE__);
	return CKR_HOST_MEMORY;
    }
    BN_init(bn_p);
    BN_init(bn_g);
 
    // Convert from strings to BIGNUMs and stick them in the DH struct
    BN_bin2bn((char *)prime_attr->pValue, prime_attr->ulValueLen, bn_p);
    dh->p = bn_p;
    BN_bin2bn((char *)base_attr->pValue, base_attr->ulValueLen, bn_g);
    dh->g = bn_g;
 
    // Generate the DH Key
    if (!DH_generate_key(dh))
    {
        st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
        return CKR_FUNCTION_FAILED;
    }
 
    // Extract the public and private key components from the DH struct,
    // and insert them in the publ_tmpl and priv_tmpl
 
    //
    // pub_key
    //
    //temp_bn = BN_new();
    temp_bn = dh->pub_key;
    temp_bn_len = BN_num_bytes(temp_bn);
    temp_byte = malloc(temp_bn_len);
    temp_bn_len = BN_bn2bin(temp_bn, temp_byte);
    rc = build_attribute( CKA_VALUE, temp_byte, temp_bn_len, &temp_attr ); // in bytes
    if (rc != CKR_OK)
    {
        st_err_log(84, __FILE__, __LINE__);
        return CKR_FUNCTION_FAILED;
    }
    template_update_attribute( publ_tmpl, temp_attr );
    free(temp_byte);

    //
    // priv_key
    //
    //temp_bn = BN_new();
    temp_bn = dh->priv_key;
    temp_bn_len = BN_num_bytes(temp_bn);
    temp_byte = malloc(temp_bn_len);
    temp_bn_len = BN_bn2bin(temp_bn, temp_byte);
    rc = build_attribute( CKA_VALUE, temp_byte, temp_bn_len, &temp_attr ); // in bytes
    if (rc != CKR_OK)
    {
        st_err_log(84, __FILE__, __LINE__);
        return CKR_FUNCTION_FAILED;
    }
    template_update_attribute( priv_tmpl, temp_attr );
    free(temp_byte);
 
    // Update CKA_VALUE_BITS attribute in the private key
    value_bits_attr = (CK_ATTRIBUTE *)malloc( sizeof(CK_ATTRIBUTE) + sizeof(CK_ULONG) );
    value_bits_attr->type       = CKA_VALUE_BITS;
    value_bits_attr->ulValueLen = sizeof(CK_ULONG);
    value_bits_attr->pValue     = (CK_BYTE *)value_bits_attr + sizeof(CK_ATTRIBUTE);
    *(CK_ULONG *)value_bits_attr->pValue = 8*temp_bn_len;
    template_update_attribute( priv_tmpl, value_bits_attr );
 
    // Add prime and base to the private key template
    rc = build_attribute( CKA_PRIME,(char *)prime_attr->pValue,
                          prime_attr->ulValueLen, &temp_attr ); // in bytes
    if (rc != CKR_OK)
    {
        st_err_log(84, __FILE__, __LINE__);
        return CKR_FUNCTION_FAILED;
    }
    template_update_attribute( priv_tmpl, temp_attr );
 
    rc = build_attribute( CKA_BASE,(char *)base_attr->pValue,
                          base_attr->ulValueLen, &temp_attr ); // in bytes
    if (rc != CKR_OK)
    {
        st_err_log(84, __FILE__, __LINE__);
        return CKR_FUNCTION_FAILED;
    }
    template_update_attribute( priv_tmpl, temp_attr );

    // Cleanup DH key
    DH_free(dh) ;
 
    return CKR_OK ;
 
} /* end token_specific_dh_key_pair_gen() */

#endif /* #ifndef NODH */

MECH_LIST_ELEMENT mech_list[] = {
   { CKM_RSA_PKCS_KEY_PAIR_GEN,     512, 4096, CKF_HW | CKF_GENERATE_KEY_PAIR },
#if !(NODSA)
   { CKM_DSA_KEY_PAIR_GEN,          512, 1024, CKF_HW | CKF_GENERATE_KEY_PAIR },
#endif
   { CKM_DES_KEY_GEN,                 8,    8, CKF_HW | CKF_GENERATE },
   { CKM_DES3_KEY_GEN,                24,    24, CKF_HW | CKF_GENERATE },
#if !(NOCDMF)
   { CKM_CDMF_KEY_GEN,                0,    0, CKF_HW | CKF_GENERATE },
#endif

   { CKM_RSA_PKCS,                  512, 4096, CKF_HW           |
                                               CKF_ENCRYPT      | CKF_DECRYPT |
                                               CKF_WRAP         | CKF_UNWRAP  |
                                               CKF_SIGN         | CKF_VERIFY  |
                                               CKF_SIGN_RECOVER | CKF_VERIFY_RECOVER },
#if !(NOX509)
   { CKM_RSA_X_509,                 512, 4096, CKF_HW           |
                                               CKF_ENCRYPT      | CKF_DECRYPT |
                                               CKF_WRAP         | CKF_UNWRAP  |
                                               CKF_SIGN         | CKF_VERIFY  |
                                               CKF_SIGN_RECOVER | CKF_VERIFY_RECOVER },
#endif
#if !(NOMD2)
   { CKM_MD2_RSA_PKCS,              512, 4096, CKF_HW      |
                                               CKF_SIGN    | CKF_VERIFY },

#endif
#if !(NOMD5)
   { CKM_MD5_RSA_PKCS,              512, 4096, CKF_HW      |
                                               CKF_SIGN    | CKF_VERIFY },
#endif
#if !(NOSHA1)
   { CKM_SHA1_RSA_PKCS,             512, 4096, CKF_HW      |
                                               CKF_SIGN    | CKF_VERIFY },
#endif


#if !(NODSA)
   { CKM_DSA,                       512, 1024, CKF_HW      |
                                               CKF_SIGN    | CKF_VERIFY },
#endif

/* Begin code contributed by Corrent corp. */
#if !(NODH)
   { CKM_DH_PKCS_DERIVE,            512, 2048, CKF_HW | CKF_DERIVE },
   { CKM_DH_PKCS_KEY_PAIR_GEN,      512, 2048, CKF_HW | CKF_GENERATE_KEY_PAIR },
#endif
/* End code contributed by Corrent corp. */

   { CKM_DES_ECB,                     8,    8, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },

   { CKM_DES_CBC,                     8,    8, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },

   { CKM_DES_CBC_PAD,                 8,    8, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },

#if !(NOCDMF)
   { CKM_CDMF_ECB,                    0,    0, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },

   { CKM_CDMF_CBC,                    0,    0, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },
#endif

   { CKM_DES3_ECB,                    24,    24, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },

   { CKM_DES3_CBC,                    24,    24, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },

   { CKM_DES3_CBC_PAD,                24,    24, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },

#if !(NOSHA1)
   { CKM_SHA_1,                       0,    0, CKF_HW | CKF_DIGEST },
   { CKM_SHA_1_HMAC,                  0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_SHA_1_HMAC_GENERAL,          0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_SHA256,                       0,    0, CKF_HW | CKF_DIGEST },
   { CKM_SHA256_HMAC,                  0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_SHA256_HMAC_GENERAL,          0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_SHA384,                       0,    0, CKF_HW | CKF_DIGEST },
   { CKM_SHA384_HMAC,                  0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_SHA384_HMAC_GENERAL,          0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_SHA512,                       0,    0, CKF_HW | CKF_DIGEST },
   { CKM_SHA512_HMAC,                  0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_SHA512_HMAC_GENERAL,          0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
#endif

#if !(NOMD2)
   { CKM_MD2,                         0,    0, CKF_HW | CKF_DIGEST },
   { CKM_MD2_HMAC,                    0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_MD2_HMAC_GENERAL,            0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
#endif

#if !(NOMD5)
   { CKM_MD5,                         0,    0, CKF_HW | CKF_DIGEST },
   { CKM_MD5_HMAC,                    0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_MD5_HMAC_GENERAL,            0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
#endif

   { CKM_SSL3_PRE_MASTER_KEY_GEN,    48,   48, CKF_HW | CKF_GENERATE },
   { CKM_SSL3_MASTER_KEY_DERIVE,     48,   48, CKF_HW | CKF_DERIVE },
   { CKM_SSL3_KEY_AND_MAC_DERIVE,    48,   48, CKF_HW | CKF_DERIVE },
   { CKM_SSL3_MD5_MAC,              384,  384, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_SSL3_SHA1_MAC,             384,  384, CKF_HW | CKF_SIGN | CKF_VERIFY },

#if !(NOAES)
   { CKM_AES_KEY_GEN,                16,   32, CKF_HW },
   { CKM_AES_ECB,                    16,   32, CKF_HW      |
   					       CKF_ENCRYPT | CKF_DECRYPT |
   					       CKF_WRAP    | CKF_UNWRAP },
   { CKM_AES_CBC,                    16,   32, CKF_HW      |
   					       CKF_ENCRYPT | CKF_DECRYPT |
   					       CKF_WRAP    | CKF_UNWRAP },
   { CKM_AES_MAC,                    16,   32, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_AES_MAC_GENERAL,            16,   32, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_AES_CBC_PAD,                16,   32, CKF_HW      |
   					       CKF_ENCRYPT | CKF_DECRYPT |
   					       CKF_WRAP    | CKF_UNWRAP },
#endif
	
#if !(NORIPE)
   { CKM_RIPEMD128,			0,   0, CKF_HW | CKF_DIGEST },
   { CKM_RIPEMD128_HMAC,		0,   0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_RIPEMD128_HMAC_GENERAL,	0,   0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_RIPEMD160,			0,   0, CKF_HW | CKF_DIGEST },
   { CKM_RIPEMD160_HMAC,		0,   0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_RIPEMD160_HMAC_GENERAL,	0,   0, CKF_HW | CKF_SIGN | CKF_VERIFY },
#endif
};

CK_ULONG mech_list_len = (sizeof(mech_list) / sizeof(MECH_LIST_ELEMENT));

/**
 * Remove/alter mechanisms for whatever reason.
 */
static void scrub_list(struct mech_list_item *head)
{
	struct mech_list_item *walker;
	walker = head;
	while (walker->next) {
		struct mech_list_item *current;
		current = walker->next;
		if (/* remove condition */0) {
			walker->next = current->next;
			free(current);
		} else if (/* alter condition */0) {
			/* current->element.mech_info.flags = ...; */
		}
		walker = walker->next;
	}
}

CK_RV
token_specific_get_mechanism_list(CK_MECHANISM_TYPE_PTR pMechanismList,
				  CK_ULONG_PTR pulCount)
{
	int rc = CKR_OK;
	struct mech_list_item head;
	struct mech_list_item *walker;
	head.next = NULL;
#if 1
	rc = ock_generic_get_mechanism_list(pMechanismList, pulCount);	
	if (rc != CKR_OK) {
		goto out;
	}
#endif
	/* TODO: Cache this data */
	generate_pkcs11_mech_list(&head);
	scrub_list(&head);
#if 1
	walker = find_mech_list_item_for_type(CKM_SHA256, &head);
	if (walker) {
		if (NULL != pMechanismList) {
			pMechanismList[(*pulCount)] = CKM_SHA256;
		}
		(*pulCount)++;
	}
	goto out;
#else
	(*pulCount) = 0;
	walker = head.next;
	if (NULL == pMechanismList) {
		while (walker) {
			struct mech_list_item *next;
			next = walker->next;
			(*pulCount)++;
			free(walker);
			walker = next;
		}
		goto out;
	}
	while (walker) {
		struct mech_list_item *next;
		next = walker->next;
		pMechanismList[(*pulCount)] = walker->element.mech_type;
		(*pulCount)++;
		free(walker);
		walker = next;
	}
#endif
out:
	free_mech_list(&head);
	return rc;
}

/* TODO: Remove once proper behavior is determined for duplicate
 * mechanisms. */
#ifndef OCK_FAIL_ON_DUPLICATE_MECH
#define OCK_FAIL_ON_DUPLICATE_MECH 0
#endif

CK_RV
token_specific_get_mechanism_info(CK_MECHANISM_TYPE type, 
				  CK_MECHANISM_INFO_PTR pInfo)
{
	int rc = CKR_MECHANISM_INVALID;
	struct mech_list_item head;
	struct mech_list_item *walker;
	head.next = NULL;
#if 1
	rc = ock_generic_get_mechanism_info(type, pInfo);
	if (rc == CKR_OK) {
		/* Match made; info copiedl. We're done. */
		goto out;
	}
	/* TODO: Remove this hack when the time is right. */
	if (type != CKM_SHA256) {
		goto out;
	}
#endif
	generate_pkcs11_mech_list(&head);
	scrub_list(&head);
	walker = find_mech_list_item_for_type(type, &head);
	if (walker) {
		memcpy(pInfo, &walker->element.mech_info, 
		       sizeof(CK_MECHANISM_INFO));
		rc = CKR_OK;
	}
 out:
	free_mech_list(&head);
	return rc;
}
