# Copyright 2014 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      'target_name': 'libelf',
      'toolsets': ['host'],
      'type': 'static_library',
      'defines': [
        '_GNU_SOURCE',
        'HAVE_CONFIG_H',
      ],
      'cflags': [
        '-std=gnu99',
        '-Wall',
        '-Wshadow',
        '-Werror',
        '-Wunused',
        '-Wextra',
        '-Wformat=2',
      ],
      'include_dirs': [
        '.',
        './src/libelf',
        './src/lib',
      ],
      'sources': [
        'config.h',

        'src/libelf/abstract.h',
        'src/libelf/common.h',
        'src/libelf/dl-hash.h',
        'src/libelf/elf.h',
        'src/libelf/elf-knowledge.h',
        'src/libelf/exttypes.h',
        'src/libelf/gelf.h',
        'src/libelf/gelf_xlate.h',
        'src/libelf/gnuhash_xlate.h',
        'src/libelf/libelf.h',
        'src/libelf/libelfP.h',
        'src/libelf/nlist.h',
        'src/libelf/note_xlate.h',
        'src/libelf/version_xlate.h',

        'src/libelf/elf32_checksum.c',
        'src/libelf/elf32_fsize.c',
        'src/libelf/elf32_getehdr.c',
        'src/libelf/elf32_getphdr.c',
        'src/libelf/elf32_getshdr.c',
        'src/libelf/elf32_newehdr.c',
        'src/libelf/elf32_newphdr.c',
        'src/libelf/elf32_offscn.c',
        'src/libelf/elf32_updatefile.c',
        'src/libelf/elf32_updatenull.c',
        'src/libelf/elf32_xlatetof.c',
        'src/libelf/elf32_xlatetom.c',
        'src/libelf/elf64_checksum.c',
        'src/libelf/elf64_fsize.c',
        'src/libelf/elf64_getehdr.c',
        'src/libelf/elf64_getphdr.c',
        'src/libelf/elf64_getshdr.c',
        'src/libelf/elf64_newehdr.c',
        'src/libelf/elf64_newphdr.c',
        'src/libelf/elf64_offscn.c',
        'src/libelf/elf64_updatefile.c',
        'src/libelf/elf64_updatenull.c',
        'src/libelf/elf64_xlatetof.c',
        'src/libelf/elf64_xlatetom.c',
        'src/libelf/elf_begin.c',
        'src/libelf/elf_clone.c',
        'src/libelf/elf_cntl.c',
        'src/libelf/elf_end.c',
        'src/libelf/elf_error.c',
        'src/libelf/elf_fill.c',
        'src/libelf/elf_flagdata.c',
        'src/libelf/elf_flagehdr.c',
        'src/libelf/elf_flagelf.c',
        'src/libelf/elf_flagphdr.c',
        'src/libelf/elf_flagscn.c',
        'src/libelf/elf_flagshdr.c',
        'src/libelf/elf_getarhdr.c',
        'src/libelf/elf_getaroff.c',
        'src/libelf/elf_getarsym.c',
        'src/libelf/elf_getbase.c',
        'src/libelf/elf_getdata.c',
        'src/libelf/elf_getdata_rawchunk.c',
        'src/libelf/elf_getident.c',
        'src/libelf/elf_getphdrnum.c',
        'src/libelf/elf_getscn.c',
        'src/libelf/elf_getshdrnum.c',
        'src/libelf/elf_getshdrstrndx.c',
        'src/libelf/elf_gnu_hash.c',
        'src/libelf/elf_hash.c',
        'src/libelf/elf_kind.c',
        'src/libelf/elf_memory.c',
        'src/libelf/elf_ndxscn.c',
        'src/libelf/elf_newdata.c',
        'src/libelf/elf_newscn.c',
        'src/libelf/elf_next.c',
        'src/libelf/elf_nextscn.c',
        'src/libelf/elf_rand.c',
        'src/libelf/elf_rawdata.c',
        'src/libelf/elf_rawfile.c',
        'src/libelf/elf_readall.c',
        'src/libelf/elf_scnshndx.c',
        'src/libelf/elf_strptr.c',
        'src/libelf/elf_update.c',
        'src/libelf/elf_version.c',
        'src/libelf/gelf_checksum.c',
        'src/libelf/gelf_fsize.c',
        'src/libelf/gelf_getauxv.c',
        'src/libelf/gelf_getclass.c',
        'src/libelf/gelf_getdyn.c',
        'src/libelf/gelf_getehdr.c',
        'src/libelf/gelf_getlib.c',
        'src/libelf/gelf_getmove.c',
        'src/libelf/gelf_getnote.c',
        'src/libelf/gelf_getphdr.c',
        'src/libelf/gelf_getrela.c',
        'src/libelf/gelf_getrel.c',
        'src/libelf/gelf_getshdr.c',
        'src/libelf/gelf_getsym.c',
        'src/libelf/gelf_getsyminfo.c',
        'src/libelf/gelf_getsymshndx.c',
        'src/libelf/gelf_getverdaux.c',
        'src/libelf/gelf_getverdef.c',
        'src/libelf/gelf_getvernaux.c',
        'src/libelf/gelf_getverneed.c',
        'src/libelf/gelf_getversym.c',
        'src/libelf/gelf_newehdr.c',
        'src/libelf/gelf_newphdr.c',
        'src/libelf/gelf_offscn.c',
        'src/libelf/gelf_update_auxv.c',
        'src/libelf/gelf_update_dyn.c',
        'src/libelf/gelf_update_ehdr.c',
        'src/libelf/gelf_update_lib.c',
        'src/libelf/gelf_update_move.c',
        'src/libelf/gelf_update_phdr.c',
        'src/libelf/gelf_update_rela.c',
        'src/libelf/gelf_update_rel.c',
        'src/libelf/gelf_update_shdr.c',
        'src/libelf/gelf_update_sym.c',
        'src/libelf/gelf_update_syminfo.c',
        'src/libelf/gelf_update_symshndx.c',
        'src/libelf/gelf_update_verdaux.c',
        'src/libelf/gelf_update_verdef.c',
        'src/libelf/gelf_update_vernaux.c',
        'src/libelf/gelf_update_verneed.c',
        'src/libelf/gelf_update_versym.c',
        'src/libelf/gelf_xlate.c',
        'src/libelf/gelf_xlatetof.c',
        'src/libelf/gelf_xlatetom.c',
        'src/libelf/libelf_crc32.c',
        'src/libelf/libelf_next_prime.c',
        'src/libelf/nlist.c',
      ],
      'direct_dependent_settings': {
        'include_dirs': [
	  './src/libelf',
	],
      },
    }],
}
