#ifndef INCLUDE_MODULE_ALSAMIXER_H
#define INCLUDE_MODULE_ALSAMIXER_H
/* ----------------------------------------------------------------------------
 * module_alsamixer.h
 * prototypes and definitions for the ALSA mixer module.
 *
 * Copyright 2004 John Steele Scott
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <pbbtaglist.h>

enum alsainc { ALSAMIXER_REL, ALSAMIXER_REL_PERCENT, ALSAMIXER_ABS, ALSAMIXER_ABS_PERCENT };

/* public prototypes */
int alsamixer_init ();
int alsamixer_open (struct tagitem *taglist);
int alsamixer_close ();
int alsamixer_exit ();

/* private prototypes */
void alsamixer_keyboard (struct tagitem *taglist);
void alsamixer_query (struct tagitem *taglist);
void alsamixer_configure (struct tagitem *taglist);

#endif    /* INCLUDE_MODULE_ALSAMIXER_H */
