/* gstreamer-rtsp-server-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gst", gir_namespace = "GstRtspServer", gir_version = "1.0", lower_case_cprefix = "gst_")]
namespace Gst {
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", type_id = "gst_rtsp_auth_get_type ()")]
	public class RTSPAuth : GLib.Object {
		[CCode (has_construct_function = false)]
		public RTSPAuth ();
		public bool check (Gst.RTSPClient client, GLib.Quark hint, Gst.RTSPClientState state);
		[NoWrapper]
		public virtual bool check_method (Gst.RTSPClient client, GLib.Quark hint, Gst.RTSPClientState state);
		public static string make_basic (string user, string pass);
		public void set_basic (string basic);
		public virtual bool setup_auth (Gst.RTSPClient client, GLib.Quark hint, Gst.RTSPClientState state);
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", type_id = "gst_rtsp_client_get_type ()")]
	public class RTSPClient : GLib.Object {
		public weak Gst.RTSPAuth auth;
		public weak Gst.RTSP.Connection connection;
		public bool is_ipv6;
		public weak Gst.RTSPMedia media;
		public weak Gst.RTSPServer server;
		public weak string server_ip;
		public weak GLib.List<void*> sessions;
		public weak GLib.List<void*> transports;
		public weak Gst.RTSP.Url uri;
		public weak Gst.RTSP.Watch watch;
		public uint watchid;
		[CCode (has_construct_function = false)]
		public RTSPClient ();
		public bool accept (GLib.Socket socket, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool create_from_socket (GLib.Socket socket, string ip, int port, string initial_buffer) throws GLib.Error;
		public Gst.RTSPAuth get_auth ();
		public Gst.RTSPMediaMapping get_media_mapping ();
		public Gst.RTSPServer get_server ();
		public Gst.RTSPSessionPool get_session_pool ();
		public bool get_use_client_settings ();
		public void set_auth (Gst.RTSPAuth auth);
		public void set_media_mapping (Gst.RTSPMediaMapping mapping);
		public void set_server (Gst.RTSPServer server);
		public void set_session_pool (Gst.RTSPSessionPool pool);
		public void set_use_client_settings (bool use_client_settings);
		public Gst.RTSPMediaMapping media_mapping { owned get; set; }
		public Gst.RTSPSessionPool session_pool { owned get; set; }
		public bool use_client_settings { get; set; }
		public virtual signal void closed ();
		public virtual signal void describe_request (void* state);
		public virtual signal void get_parameter_request (void* state);
		public virtual signal void new_session (Gst.RTSPSession session);
		public virtual signal void options_request (void* state);
		public virtual signal void pause_request (void* state);
		public virtual signal void play_request (void* state);
		public virtual signal void set_parameter_request (void* state);
		public virtual signal void setup_request (void* state);
		public virtual signal void teardown_request (void* state);
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", type_id = "gst_rtsp_media_get_type ()")]
	public class RTSPMedia : GLib.Object {
		public bool adding;
		public weak Gst.RTSPAuth auth;
		public bool buffering;
		public weak GLib.Cond cond;
		public weak GLib.List<void*> @dynamic;
		public weak Gst.Element element;
		public weak Gst.Element fakesink;
		public uint id;
		public bool is_ipv6;
		public bool is_live;
		public weak GLib.Mutex @lock;
		public int n_active;
		public Gst.Element pipeline;
		public Gst.RTSP.TimeRange range;
		public bool reused;
		public weak Gst.Element rtpbin;
		public bool seekable;
		public weak GLib.Source source;
		public Gst.RTSPMediaStatus status;
		public weak GLib.GenericArray<void*> streams;
		public Gst.State target_state;
		[CCode (has_construct_function = false)]
		public RTSPMedia ();
		public void collect_streams ();
		public unowned Gst.RTSPStream create_stream (Gst.Element payloader, Gst.Pad srcpad);
		[CCode (vfunc_name = "new_state")]
		[NoWrapper]
		public virtual bool emit_new_state (Gst.State state);
		public Gst.RTSPAuth get_auth ();
		public uint get_buffer_size ();
		public uint get_mtu ();
		public string get_multicast_group ();
		public Gst.RTSP.LowerTrans get_protocols ();
		public string get_range_string (bool play);
		public unowned Gst.RTSPStream get_stream (uint idx);
		[NoWrapper]
		public virtual bool handle_message (Gst.Message message);
		public bool is_eos_shutdown ();
		public bool is_reusable ();
		public bool is_shared ();
		public uint n_streams ();
		public bool prepare ();
		public bool seek (Gst.RTSP.TimeRange range);
		public void set_auth (Gst.RTSPAuth auth);
		public void set_buffer_size (uint size);
		public void set_eos_shutdown (bool eos_shutdown);
		public void set_mtu (uint mtu);
		public void set_multicast_group (string mc);
		public void set_protocols (Gst.RTSP.LowerTrans protocols);
		public void set_reusable (bool reusable);
		public void set_shared (bool shared);
		public bool set_state (Gst.State state, GLib.GenericArray<void*> transports);
		public virtual bool unprepare ();
		public uint buffer_size { get; set; }
		[NoAccessorMethod]
		public bool eos_shutdown { get; set; }
		public uint mtu { get; set; }
		public string multicast_group { owned get; set; }
		public Gst.RTSP.LowerTrans protocols { get; set; }
		[NoAccessorMethod]
		public bool reusable { get; set; }
		[NoAccessorMethod]
		public bool shared { get; set; }
		public virtual signal void new_state ();
		public virtual signal void prepared ();
		public virtual signal void unprepared ();
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", type_id = "gst_rtsp_media_factory_get_type ()")]
	public class RTSPMediaFactory : GLib.Object {
		public weak Gst.RTSPAuth auth;
		public weak GLib.Mutex @lock;
		public weak GLib.HashTable<void*,void*> medias;
		public weak GLib.Mutex medias_lock;
		[CCode (has_construct_function = false)]
		public RTSPMediaFactory ();
		[NoWrapper]
		public virtual void configure (Gst.RTSPMedia media);
		public virtual Gst.RTSPMedia? @construct (Gst.RTSP.Url url);
		public virtual unowned Gst.Element create_element (Gst.RTSP.Url url);
		[NoWrapper]
		public virtual string gen_key (Gst.RTSP.Url url);
		public Gst.RTSPAuth get_auth ();
		public uint get_buffer_size ();
		public string get_launch ();
		public string get_multicast_group ();
		public Gst.RTSP.LowerTrans get_protocols ();
		public bool is_eos_shutdown ();
		public bool is_shared ();
		public void set_auth (Gst.RTSPAuth auth);
		public void set_buffer_size (uint size);
		public void set_eos_shutdown (bool eos_shutdown);
		public void set_launch (string launch);
		public void set_multicast_group (string mc);
		public void set_protocols (Gst.RTSP.LowerTrans protocols);
		public void set_shared (bool shared);
		public uint buffer_size { get; set; }
		[NoAccessorMethod]
		public bool eos_shutdown { get; set; }
		public string launch { owned get; set; }
		public string multicast_group { owned get; set; }
		public Gst.RTSP.LowerTrans protocols { get; set; }
		[NoAccessorMethod]
		public bool shared { get; set; }
		public virtual signal void media_configure (Gst.RTSPMedia media);
		public virtual signal void media_constructed (Gst.RTSPMedia media);
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", type_id = "gst_rtsp_media_factory_uri_get_type ()")]
	public class RTSPMediaFactoryURI : Gst.RTSPMediaFactory {
		public weak GLib.List<void*> decoders;
		public weak GLib.List<void*> demuxers;
		public weak GLib.List<void*> payloaders;
		public weak Gst.Caps raw_acaps;
		public weak Gst.Caps raw_vcaps;
		[CCode (has_construct_function = false)]
		public RTSPMediaFactoryURI ();
		public string get_uri ();
		public void set_uri (string uri);
		public string uri { owned get; set; }
		[NoAccessorMethod]
		public bool use_gstpay { get; set; }
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", type_id = "gst_rtsp_media_mapping_get_type ()")]
	public class RTSPMediaMapping : GLib.Object {
		public weak GLib.HashTable<void*,void*> mappings;
		[CCode (has_construct_function = false)]
		public RTSPMediaMapping ();
		public void add_factory (string path, owned Gst.RTSPMediaFactory factory);
		public virtual Gst.RTSPMediaFactory? find_factory (Gst.RTSP.Url url);
		public void remove_factory (string path);
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", type_id = "gst_rtsp_server_get_type ()")]
	public class RTSPServer : GLib.Object {
		public weak Gst.RTSPAuth auth;
		public weak GLib.List<void*> clients;
		public weak GLib.Mutex @lock;
		public weak GLib.Socket socket;
		[CCode (has_construct_function = false)]
		public RTSPServer ();
		[NoWrapper]
		public virtual bool accept_client (Gst.RTSPClient client, GLib.Socket socket) throws GLib.Error;
		public uint attach (GLib.MainContext? context);
		public GLib.Socket create_socket (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public GLib.Source create_source (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public string get_address ();
		public Gst.RTSPAuth get_auth ();
		public int get_backlog ();
		public int get_bound_port ();
		public Gst.RTSPMediaMapping get_media_mapping ();
		public string get_service ();
		public Gst.RTSPSessionPool get_session_pool ();
		public static bool io_func (GLib.Socket socket, GLib.IOCondition condition, Gst.RTSPServer server);
		public void set_address (string address);
		public void set_auth (Gst.RTSPAuth auth);
		public void set_backlog (int backlog);
		public void set_media_mapping (Gst.RTSPMediaMapping mapping);
		public void set_service (string service);
		public void set_session_pool (Gst.RTSPSessionPool pool);
		public bool transfer_connection (GLib.Socket socket, string ip, int port, string initial_buffer);
		public string address { owned get; set; }
		public int backlog { get; set; }
		public int bound_port { get; }
		public Gst.RTSPMediaMapping media_mapping { owned get; set; }
		public string service { owned get; set; }
		public Gst.RTSPSessionPool session_pool { owned get; set; }
		public virtual signal void client_connected (Gst.RTSPClient client);
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", type_id = "gst_rtsp_session_get_type ()")]
	public class RTSPSession : GLib.Object {
		public GLib.TimeVal create_time;
		public int expire_count;
		public GLib.TimeVal last_access;
		public weak GLib.List<void*> medias;
		[CCode (has_construct_function = false)]
		public RTSPSession (string sessionid);
		public void allow_expire ();
		public unowned Gst.RTSPSessionMedia get_media (Gst.RTSP.Url url);
		public unowned string get_sessionid ();
		public uint get_timeout ();
		public bool is_expired (GLib.TimeVal now);
		public unowned Gst.RTSPSessionMedia manage_media (Gst.RTSP.Url uri, owned Gst.RTSPMedia media);
		public int next_timeout (GLib.TimeVal now);
		public void prevent_expire ();
		public bool release_media (Gst.RTSPSessionMedia media);
		public void set_timeout (uint timeout);
		public void touch ();
		public string sessionid { get; construct; }
		public uint timeout { get; set; }
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", type_id = "gst_rtsp_session_media_get_type ()")]
	public class RTSPSessionMedia : GLib.Object {
		public uint counter;
		public weak Gst.RTSPMedia media;
		public Gst.RTSP.State state;
		public weak GLib.GenericArray<void*> transports;
		public weak Gst.RTSP.Url url;
		[CCode (has_construct_function = false)]
		public RTSPSessionMedia (Gst.RTSP.Url url, Gst.RTSPMedia media);
		public bool alloc_channels (Gst.RTSP.Range range);
		public unowned Gst.RTSPStreamTransport get_transport (uint idx);
		public bool set_state (Gst.State state);
		public unowned Gst.RTSPStreamTransport set_transport (Gst.RTSPStream stream, Gst.RTSP.Transport tr);
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", type_id = "gst_rtsp_session_pool_get_type ()")]
	public class RTSPSessionPool : GLib.Object {
		public weak GLib.Mutex @lock;
		public weak GLib.HashTable<void*,void*> sessions;
		[CCode (has_construct_function = false)]
		public RTSPSessionPool ();
		public uint cleanup ();
		public unowned Gst.RTSPSession create ();
		[NoWrapper]
		public virtual string create_session_id ();
		public GLib.Source create_watch ();
		public GLib.List<Gst.RTSPSession> filter (Gst.RTSPSessionFilterFunc func);
		public Gst.RTSPSession find (string sessionid);
		public uint get_max_sessions ();
		public uint get_n_sessions ();
		public bool remove (Gst.RTSPSession sess);
		public void set_max_sessions (uint max);
		public uint max_sessions { get; set; }
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", type_id = "gst_rtsp_stream_get_type ()")]
	public class RTSPStream : GLib.Object {
		[CCode (array_length = false, array_null_terminated = true)]
		public weak Gst.Element[] appqueue;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak Gst.Element[] appsink;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak Gst.Element[] appsrc;
		public uint buffer_size;
		public weak Gst.Caps caps;
		public ulong caps_sig;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak Gst.Element[] funnel;
		public uint idx;
		public bool is_ipv6;
		public bool is_joined;
		public uint n_active;
		public weak Gst.Element payloader;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak Gst.Pad[] recv_sink;
		public weak Gst.Pad send_rtp_sink;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak Gst.Pad[] send_src;
		public Gst.RTSP.Range server_port;
		public weak GLib.Object session;
		public weak Gst.Pad srcpad;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak Gst.Element[] tee;
		public weak GLib.List<void*> transports;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak Gst.Element[] udpsink;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak Gst.Element[] udpsrc;
		[CCode (has_construct_function = false)]
		public RTSPStream (uint idx, Gst.Element payloader, Gst.Pad srcpad);
		public bool add_transport (Gst.RTSPStreamTransport trans);
		public uint get_mtu ();
		public bool get_rtpinfo (uint rtptime, uint seq);
		public bool join_bin (Gst.Bin bin, Gst.Element rtpbin, Gst.State state);
		public bool leave_bin (Gst.Bin bin, Gst.Element rtpbin);
		public Gst.FlowReturn recv_rtcp (owned Gst.Buffer buffer);
		public Gst.FlowReturn recv_rtp (owned Gst.Buffer buffer);
		public bool remove_transport (Gst.RTSPStreamTransport trans);
		public void set_mtu (uint mtu);
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", type_id = "gst_rtsp_stream_transport_get_type ()")]
	public class RTSPStreamTransport : GLib.Object {
		public bool active;
		public weak GLib.DestroyNotify ka_notify;
		public void* ka_user_data;
		public weak Gst.RTSPKeepAliveFunc keep_alive;
		public weak GLib.DestroyNotify notify;
		public weak GLib.Object rtpsource;
		public weak Gst.RTSPSendFunc send_rtcp;
		public weak Gst.RTSPSendFunc send_rtp;
		public weak Gst.RTSPStream stream;
		public bool timeout;
		public Gst.RTSP.Transport transport;
		public void* user_data;
		[CCode (has_construct_function = false)]
		public RTSPStreamTransport (Gst.RTSPStream stream, owned Gst.RTSP.Transport tr);
		public void set_callbacks (Gst.RTSPSendFunc send_rtp, owned Gst.RTSPSendFunc send_rtcp);
		public void set_keepalive (owned Gst.RTSPKeepAliveFunc keep_alive);
		public void set_transport (owned Gst.RTSP.Transport tr);
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", has_type_id = false)]
	public struct RTSPClientState {
		public Gst.RTSP.Message request;
		public weak Gst.RTSP.Url uri;
		public Gst.RTSP.Method method;
		public weak Gst.RTSPSession session;
		public weak Gst.RTSPSessionMedia sessmedia;
		public weak Gst.RTSPMediaFactory factory;
		public weak Gst.RTSPMedia media;
		public weak Gst.RTSPStream stream;
		public Gst.RTSP.Message response;
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", has_type_id = false)]
	public struct SDPInfo {
		public weak string server_proto;
		public weak string server_ip;
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", cprefix = "GST_RTSP_FILTER_", has_type_id = false)]
	public enum RTSPFilterResult {
		REMOVE,
		KEEP,
		REF
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", cprefix = "GST_RTSP_MEDIA_STATUS_", has_type_id = false)]
	public enum RTSPMediaStatus {
		UNPREPARED,
		UNPREPARING,
		PREPARING,
		PREPARED,
		ERROR
	}
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", instance_pos = 0.9)]
	public delegate void RTSPKeepAliveFunc ();
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", instance_pos = 2.9)]
	public delegate bool RTSPSendFunc (Gst.Buffer buffer, uint8 channel);
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", instance_pos = 2.9)]
	public delegate Gst.RTSPFilterResult RTSPSessionFilterFunc (Gst.RTSPSessionPool pool, Gst.RTSPSession session);
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h", instance_pos = 1.9)]
	public delegate bool RTSPSessionPoolFunc (Gst.RTSPSessionPool pool);
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h")]
	public static Gst.RTSP.Result rtsp_params_get (Gst.RTSPClient client, Gst.RTSPClientState state);
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h")]
	public static Gst.RTSP.Result rtsp_params_set (Gst.RTSPClient client, Gst.RTSPClientState state);
	[CCode (cheader_filename = "gst/rtsp-server/rtsp-server.h")]
	public static bool rtsp_sdp_from_media (Gst.SDP.Message sdp, Gst.SDPInfo info, Gst.RTSPMedia media);
}
