/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentMatches;
import org.broadinstitute.sting.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.CommandLineUtils;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.MultiplexArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ArgumentSource {
    public final Field[] parentFields;
    public final Field field;
    private final ArgumentTypeDescriptor typeDescriptor;

    protected ArgumentSource(Field[] parentFields, Field field, ArgumentTypeDescriptor typeDescriptor) {
        this.parentFields = parentFields;
        this.field = field;
        this.typeDescriptor = typeDescriptor;
    }

    public ArgumentSource copyWithCustomTypeDescriptor(ArgumentTypeDescriptor typeDescriptor) {
        return new ArgumentSource(this.parentFields, this.field, typeDescriptor);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ArgumentSource)) {
            return false;
        }
        ArgumentSource otherArgumentSource = (ArgumentSource)other;
        return this.field == otherArgumentSource.field && Arrays.equals(this.parentFields, otherArgumentSource.parentFields);
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public List<ArgumentDefinition> createArgumentDefinitions() {
        return this.typeDescriptor.createArgumentDefinitions(this);
    }

    public Object parse(ParsingEngine parsingEngine, ArgumentMatches values) {
        return this.typeDescriptor.parse(parsingEngine, this, values);
    }

    public boolean isRequired() {
        return (Boolean)CommandLineUtils.getValue(ArgumentTypeDescriptor.getArgumentAnnotation(this), "required");
    }

    public boolean isFlag() {
        return this.field.getType() == Boolean.class || this.field.getType() == Boolean.TYPE;
    }

    public boolean isMultiValued() {
        return this.typeDescriptor.isMultiValued(this);
    }

    public boolean isHidden() {
        return this.field.isAnnotationPresent(Hidden.class) || this.field.isAnnotationPresent(Deprecated.class);
    }

    public boolean isAdvanced() {
        return this.field.isAnnotationPresent(Advanced.class);
    }

    public boolean isDependent() {
        return this.typeDescriptor instanceof MultiplexArgumentTypeDescriptor;
    }

    public boolean isDeprecated() {
        return this.field.isAnnotationPresent(Deprecated.class);
    }

    public boolean createsTypeDefault() {
        return this.typeDescriptor.createsTypeDefault(this);
    }

    public String typeDefaultDocString() {
        return this.typeDescriptor.typeDefaultDocString(this);
    }

    public Object createTypeDefault(ParsingEngine parsingEngine) {
        return this.typeDescriptor.createTypeDefault(parsingEngine, this, this.field.getGenericType());
    }

    public MultiplexArgumentTypeDescriptor createDependentTypeDescriptor(ParsingEngine parsingEngine, Object containingObject) {
        if (!this.isDependent()) {
            throw new ReviewedStingException("Field " + this.field.getName() + " is independent; no dependent type descriptor can be derived.");
        }
        return ((MultiplexArgumentTypeDescriptor)this.typeDescriptor).createCustomTypeDescriptor(parsingEngine, this, containingObject);
    }

    public String toString() {
        return this.field.getDeclaringClass().getSimpleName() + ": " + this.field.getName();
    }
}

