/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.help;

import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.gatk.utils.help.GATKDocWorkUnit;

class ForumDiscussion {
    private static final String POST_TEMPLATE = "<p>A new tool has been released!</p><p>Check out the documentation at <a href='%s'>%s</a>.</p>";
    final int Announce;
    final String Body;
    final String Category;
    final int Closed;
    final String Format;
    final String Name;
    final int Sink;
    final String Tags;
    final String Type;

    public ForumDiscussion(String name, String body, String format, String category, String tagsCSV, String type, int closed, int announce, int sink) {
        this.Name = name;
        this.Body = body;
        this.Format = format;
        this.Category = category;
        this.Tags = tagsCSV;
        this.Type = type;
        this.Closed = closed;
        this.Announce = announce;
        this.Sink = sink;
    }

    public ForumDiscussion(GATKDocWorkUnit tool) {
        this(tool.name, String.format(POST_TEMPLATE, "http://www.broadinstitute.org/gatk/gatkdocs/" + tool.filename, tool.name), "Html", "tool-bulletin", tool.name + "," + tool.group + ",gatkdocs", "Discussion", 0, -1, -1);
    }

    public Map<String, String> getPostData() {
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("Name", this.Name);
        output.put("Body", this.Body);
        output.put("Format", this.Format);
        output.put("Category", this.Category);
        if (this.Tags != null) {
            output.put("Tags", this.Tags);
        }
        if (this.Type != null) {
            output.put("Type", this.Type);
        }
        if (this.Closed != -1) {
            output.put("Closed", this.Closed == 1 ? "1" : "0");
        }
        if (this.Announce != -1) {
            output.put("Announce", this.Announce == 1 ? "1" : "0");
        }
        if (this.Sink != -1) {
            output.put("Sink", this.Sink == 1 ? "1" : "0");
        }
        return output;
    }
}

