/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.ForwardOnlyResultSet;
import oracle.jdbc.driver.GeneratedResultSet;
import oracle.jdbc.driver.InsensitiveScrollableResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SensitiveScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.internal.OracleConnection;

abstract class OracleResultSet
extends GeneratedResultSet {
    static final boolean DEBUG = false;
    boolean closed = false;
    SQLWarning sqlWarning = null;
    protected boolean closeStatementOnClose = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    static OracleResultSet createResultSet(OracleStatement oracleStatement) throws SQLException {
        if (!oracleStatement.sqlKind.isSELECT()) {
            oracleStatement.realRsetType = ResultSetType.FORWARD_READ_ONLY;
            oracleStatement.described = true;
        }
        if (oracleStatement.realRsetType == ResultSetType.UNKNOWN) {
            return oracleStatement.userRsetType.createResultSet(oracleStatement);
        }
        return oracleStatement.realRsetType.createResultSet(oracleStatement);
    }

    protected OracleResultSet(PhysicalConnection physicalConnection) {
        super(physicalConnection);
    }

    protected abstract void doneFetchingRows(boolean var1) throws SQLException;

    @Override
    public void closeStatementOnClose() {
        this.closeStatementOnClose = true;
    }

    @Override
    public abstract OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int var1) throws SQLException;

    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(String string) throws SQLException {
        return this.getAuthorizationIndicator(this.findColumn(string));
    }

    boolean isValidRow() throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "isValidRow");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
    }

    @Override
    public abstract String getCursorName() throws SQLException;

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @Override
    public abstract boolean next() throws SQLException;

    @Override
    public abstract boolean wasNull() throws SQLException;

    @Override
    public abstract boolean isBeforeFirst() throws SQLException;

    @Override
    public abstract boolean isAfterLast() throws SQLException;

    @Override
    public abstract boolean isFirst() throws SQLException;

    @Override
    public abstract boolean isLast() throws SQLException;

    @Override
    public abstract void beforeFirst() throws SQLException;

    @Override
    public abstract void afterLast() throws SQLException;

    @Override
    public abstract boolean first() throws SQLException;

    @Override
    public abstract boolean last() throws SQLException;

    @Override
    public abstract int getRow() throws SQLException;

    @Override
    public abstract boolean absolute(int var1) throws SQLException;

    @Override
    public abstract boolean relative(int var1) throws SQLException;

    @Override
    public abstract boolean previous() throws SQLException;

    @Override
    public void setFetchDirection(int n2) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public abstract void setFetchSize(int var1) throws SQLException;

    @Override
    public abstract int getFetchSize() throws SQLException;

    @Override
    public abstract int getType() throws SQLException;

    @Override
    public abstract int getConcurrency() throws SQLException;

    @Override
    public int getHoldability() throws SQLException {
        if (this.isClosed()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10, null);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return 1;
    }

    @Override
    public void insertRow() throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "insertRow");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public void updateRow() throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "updateRow");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public void deleteRow() throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "deleteRow");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public void refreshRow() throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, null);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "moveToInsertRow");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "cancelRowUpdates");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "moveToCurrentRow");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public abstract Statement getStatement() throws SQLException;

    @Override
    public void updateNull(int n2) throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "updateNull");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isInterface()) {
            return clazz.isInstance(this);
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return (T)this;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    abstract OracleStatement getOracleStatement() throws SQLException;

    abstract int refreshRows(int var1, int var2) throws SQLException;

    abstract void removeCurrentRowFromCache() throws SQLException;

    abstract int getColumnCount() throws SQLException;

    static enum ResultSetType {
        UNKNOWN(-1, -1, false){

            @Override
            OracleResultSet createResultSet(OracleStatement oracleStatement) throws SQLException {
                SQLException sQLException = DatabaseError.createSqlException(null, 23, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }

            @Override
            ResultSetType downgrade() {
                return UNKNOWN;
            }
        }
        ,
        FORWARD_READ_ONLY(1003, 1007, false){

            @Override
            OracleResultSet createResultSet(OracleStatement oracleStatement) throws SQLException {
                return new ForwardOnlyResultSet(oracleStatement.connection, oracleStatement);
            }

            @Override
            ResultSetType downgrade() {
                return FORWARD_READ_ONLY;
            }
        }
        ,
        FORWARD_UPDATABLE(1003, 1008, true){

            @Override
            OracleResultSet createResultSet(OracleStatement oracleStatement) throws SQLException {
                ForwardOnlyResultSet forwardOnlyResultSet = new ForwardOnlyResultSet(oracleStatement.connection, oracleStatement);
                return new UpdatableResultSet(oracleStatement, forwardOnlyResultSet);
            }

            @Override
            ResultSetType downgrade() {
                return FORWARD_READ_ONLY;
            }
        }
        ,
        INSENSITIVE_READ_ONLY(1004, 1007, false){

            @Override
            OracleResultSet createResultSet(OracleStatement oracleStatement) throws SQLException {
                return new InsensitiveScrollableResultSet(oracleStatement.connection, oracleStatement);
            }

            @Override
            ResultSetType downgrade() {
                return FORWARD_READ_ONLY;
            }
        }
        ,
        INSENSITIVE_UPDATABLE(1004, 1008, true){

            @Override
            OracleResultSet createResultSet(OracleStatement oracleStatement) throws SQLException {
                InsensitiveScrollableResultSet insensitiveScrollableResultSet = new InsensitiveScrollableResultSet(oracleStatement.connection, oracleStatement);
                return new UpdatableResultSet(oracleStatement, insensitiveScrollableResultSet);
            }

            @Override
            ResultSetType downgrade() {
                return INSENSITIVE_READ_ONLY;
            }
        }
        ,
        SENSITIVE_READ_ONLY(1005, 1007, true){

            @Override
            OracleResultSet createResultSet(OracleStatement oracleStatement) throws SQLException {
                return new SensitiveScrollableResultSet(oracleStatement.connection, oracleStatement);
            }

            @Override
            ResultSetType downgrade() {
                return INSENSITIVE_READ_ONLY;
            }
        }
        ,
        SENSITIVE_UPDATABLE(1005, 1008, true){

            @Override
            OracleResultSet createResultSet(OracleStatement oracleStatement) throws SQLException {
                SensitiveScrollableResultSet sensitiveScrollableResultSet = new SensitiveScrollableResultSet(oracleStatement.connection, oracleStatement);
                return new UpdatableResultSet(oracleStatement, sensitiveScrollableResultSet);
            }

            @Override
            ResultSetType downgrade() {
                return INSENSITIVE_READ_ONLY;
            }
        };

        private final int type;
        private final int concur;
        private final boolean isIdentifierRequired;

        static ResultSetType typeFor(int n2, int n3) throws SQLException {
            for (ResultSetType resultSetType : (ResultSetType[])ResultSetType.class.getEnumConstants()) {
                if (resultSetType.getType() != n2 || resultSetType.getConcur() != n3) continue;
                return resultSetType;
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 68, "type: " + n2 + " concurency: " + n3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }

        private ResultSetType(int n3, int n4, boolean bl) {
            this.type = n3;
            this.concur = n4;
            this.isIdentifierRequired = bl;
        }

        int getType() {
            return this.type;
        }

        int getConcur() {
            return this.concur;
        }

        boolean isIdentifierRequired() {
            return this.isIdentifierRequired;
        }

        boolean isForwardOnly() {
            return this.type == 1003;
        }

        boolean isScrollable() {
            return this.type != 1003;
        }

        boolean isUpdatable() {
            return this.concur == 1008;
        }

        abstract OracleResultSet createResultSet(OracleStatement var1) throws SQLException;

        abstract ResultSetType downgrade();
    }
}

