package org.basex.query.func.util;

import static org.basex.query.QueryError.*;

import org.basex.query.*;
import org.basex.query.expr.*;
import org.basex.query.func.*;
import org.basex.query.iter.*;
import org.basex.query.value.*;
import org.basex.query.value.seq.*;
import org.basex.query.value.type.*;

/**
 * Function implementation.
 *
 * @author BaseX Team 2005-18, BSD License
 * @author Christian Gruen
 */
public final class UtilReplicate extends StandardFunc {
  @Override
  public Value value(final QueryContext qc) throws QueryException {
    final Value value = exprs[0].value(qc);
    final long mult = toLong(exprs[1], qc);
    if(mult < 0) throw UTIL_NEGATIVE_X.get(info, mult);
    return SingletonSeq.get(value, mult);
  }

  @Override
  public Iter iter(final QueryContext qc) throws QueryException {
    return value(qc).iter();
  }

  @Override
  protected Expr opt(final CompileContext cc) throws QueryException {
    final Expr expr = exprs[0], mult = exprs[1];
    final SeqType st = expr.seqType();

    // pre-evaluate static multipliers
    final long m = mult instanceof Value ? toLong(mult, cc.qc) : -1;
    if(m == 0) return Empty.SEQ;
    if(m == 1 || st.zero()) return expr;

    // adopt sequence type
    exprType.assign(st.type, st.occ.union(m > 1 ? Occ.ONE_MORE : Occ.ZERO_MORE));
    return this;
  }
}
