# THIS FILE IS AUTOMATICALLY GENERATED.  EDIT THE SOURCE FILE NOT THIS ONE

"""Various descriptions of data used in Brew Protocol"""

from prototypes import *

# We use LSB for all integer like fields
UINT=UINTlsb
BOOL=BOOLlsb

new_fileopen_mode_read=0
new_fileopen_mode_write=0x41
new_fileopen_flag_existing=0
new_fileopen_flag_create=1

import com_brew

DEFAULT_PHONE_ENCODING='ascii'
PHONE_ENCODING=DEFAULT_PHONE_ENCODING

# These parameters only work with BREW2 at the moment.
# Note about read block size:
#  - Largest successful read size: 1KB
#  - The LG VX-8700 returns 1KB of data if req.bytes >= 1KB.
#  - If all phones behave in this way it would be safe to change the default read size to 1KB.
BREW_READ_SIZE=0xEB

# Note about write block size:
#  - Largest successful write size: 7.9kB
#  - Too large a write block will cause a timeout error.
BREW_WRITE_SIZE=0xEA

class requestheader(BaseProtogenClass):
    "The bit in front on all Brew request packets"
    __fields=['commandmode', 'command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(requestheader,self).__init__(**dict)
        if self.__class__ is requestheader:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(requestheader,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(requestheader,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_commandmode
        except:
            self.__field_commandmode=UINT(**{'sizeinbytes': 1, 'constant': 0x59})
        self.__field_commandmode.writetobuffer(buf)
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_commandmode=UINT(**{'sizeinbytes': 1, 'constant': 0x59})
        self.__field_commandmode.readfrombuffer(buf)
        self.__field_command=UINT(**{'sizeinbytes': 1})
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_commandmode(self):
        try: self.__field_commandmode
        except:
            self.__field_commandmode=UINT(**{'sizeinbytes': 1, 'constant': 0x59})
        return self.__field_commandmode.getvalue()

    def __setfield_commandmode(self, value):
        if isinstance(value,UINT):
            self.__field_commandmode=value
        else:
            self.__field_commandmode=UINT(value,**{'sizeinbytes': 1, 'constant': 0x59})

    def __delfield_commandmode(self): del self.__field_commandmode

    commandmode=property(__getfield_commandmode, __setfield_commandmode, __delfield_commandmode, None)

    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('commandmode', self.__field_commandmode, None)
        yield ('command', self.__field_command, None)




class responseheader(BaseProtogenClass):
    "The bit in front on all Brew response packets"
    __fields=['commandmode', 'command', 'errorcode']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(responseheader,self).__init__(**dict)
        if self.__class__ is responseheader:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(responseheader,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(responseheader,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_commandmode.writetobuffer(buf)
        self.__field_command.writetobuffer(buf)
        self.__field_errorcode.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_commandmode=UINT(**{'sizeinbytes': 1, 'constant': 0x59})
        self.__field_commandmode.readfrombuffer(buf)
        self.__field_command=UINT(**{'sizeinbytes': 1})
        self.__field_command.readfrombuffer(buf)
        self.__field_errorcode=UINT(**{'sizeinbytes': 1})
        self.__field_errorcode.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_commandmode(self):
        return self.__field_commandmode.getvalue()

    def __setfield_commandmode(self, value):
        if isinstance(value,UINT):
            self.__field_commandmode=value
        else:
            self.__field_commandmode=UINT(value,**{'sizeinbytes': 1, 'constant': 0x59})

    def __delfield_commandmode(self): del self.__field_commandmode

    commandmode=property(__getfield_commandmode, __setfield_commandmode, __delfield_commandmode, None)

    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_errorcode(self):
        return self.__field_errorcode.getvalue()

    def __setfield_errorcode(self, value):
        if isinstance(value,UINT):
            self.__field_errorcode=value
        else:
            self.__field_errorcode=UINT(value,**{'sizeinbytes': 1})

    def __delfield_errorcode(self): del self.__field_errorcode

    errorcode=property(__getfield_errorcode, __setfield_errorcode, __delfield_errorcode, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('commandmode', self.__field_commandmode, None)
        yield ('command', self.__field_command, None)
        yield ('errorcode', self.__field_errorcode, None)




class readfilerequest(BaseProtogenClass):
    __fields=['header', 'blocknumber', 'filename']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(readfilerequest,self).__init__(**dict)
        if self.__class__ is readfilerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(readfilerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(readfilerequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x04})
        self.__field_header.writetobuffer(buf)
        try: self.__field_blocknumber
        except:
            self.__field_blocknumber=UINT(**{'sizeinbytes': 1, 'constant': 0})
        self.__field_blocknumber.writetobuffer(buf)
        self.__field_filename.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=requestheader(**{'command': 0x04})
        self.__field_header.readfrombuffer(buf)
        self.__field_blocknumber=UINT(**{'sizeinbytes': 1, 'constant': 0})
        self.__field_blocknumber.readfrombuffer(buf)
        self.__field_filename=USTRING(**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })
        self.__field_filename.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x04})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,requestheader):
            self.__field_header=value
        else:
            self.__field_header=requestheader(value,**{'command': 0x04})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_blocknumber(self):
        try: self.__field_blocknumber
        except:
            self.__field_blocknumber=UINT(**{'sizeinbytes': 1, 'constant': 0})
        return self.__field_blocknumber.getvalue()

    def __setfield_blocknumber(self, value):
        if isinstance(value,UINT):
            self.__field_blocknumber=value
        else:
            self.__field_blocknumber=UINT(value,**{'sizeinbytes': 1, 'constant': 0})

    def __delfield_blocknumber(self): del self.__field_blocknumber

    blocknumber=property(__getfield_blocknumber, __setfield_blocknumber, __delfield_blocknumber, None)

    def __getfield_filename(self):
        return self.__field_filename.getvalue()

    def __setfield_filename(self, value):
        if isinstance(value,USTRING):
            self.__field_filename=value
        else:
            self.__field_filename=USTRING(value,**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })

    def __delfield_filename(self): del self.__field_filename

    filename=property(__getfield_filename, __setfield_filename, __delfield_filename, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('blocknumber', self.__field_blocknumber, None)
        yield ('filename', self.__field_filename, None)




class readfileresponse(BaseProtogenClass):
    __fields=['header', 'blockcounter', 'thereismore', 'filesize', 'datasize', 'data']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(readfileresponse,self).__init__(**dict)
        if self.__class__ is readfileresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(readfileresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(readfileresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_blockcounter.writetobuffer(buf)
        self.__field_thereismore.writetobuffer(buf)
        self.__field_filesize.writetobuffer(buf)
        self.__field_datasize.writetobuffer(buf)
        self.__field_data.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_blockcounter=UINT(**{'sizeinbytes': 1})
        self.__field_blockcounter.readfrombuffer(buf)
        self.__field_thereismore=BOOL(**{'sizeinbytes': 1})
        self.__field_thereismore.readfrombuffer(buf)
        self.__field_filesize=UINT(**{'sizeinbytes': 4})
        self.__field_filesize.readfrombuffer(buf)
        self.__field_datasize=UINT(**{'sizeinbytes': 2})
        self.__field_datasize.readfrombuffer(buf)
        self.__field_data=DATA(**{'sizeinbytes': self.datasize})
        self.__field_data.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,responseheader):
            self.__field_header=value
        else:
            self.__field_header=responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_blockcounter(self):
        return self.__field_blockcounter.getvalue()

    def __setfield_blockcounter(self, value):
        if isinstance(value,UINT):
            self.__field_blockcounter=value
        else:
            self.__field_blockcounter=UINT(value,**{'sizeinbytes': 1})

    def __delfield_blockcounter(self): del self.__field_blockcounter

    blockcounter=property(__getfield_blockcounter, __setfield_blockcounter, __delfield_blockcounter, None)

    def __getfield_thereismore(self):
        return self.__field_thereismore.getvalue()

    def __setfield_thereismore(self, value):
        if isinstance(value,BOOL):
            self.__field_thereismore=value
        else:
            self.__field_thereismore=BOOL(value,**{'sizeinbytes': 1})

    def __delfield_thereismore(self): del self.__field_thereismore

    thereismore=property(__getfield_thereismore, __setfield_thereismore, __delfield_thereismore, "true if there is more data available after this block")

    def __getfield_filesize(self):
        return self.__field_filesize.getvalue()

    def __setfield_filesize(self, value):
        if isinstance(value,UINT):
            self.__field_filesize=value
        else:
            self.__field_filesize=UINT(value,**{'sizeinbytes': 4})

    def __delfield_filesize(self): del self.__field_filesize

    filesize=property(__getfield_filesize, __setfield_filesize, __delfield_filesize, None)

    def __getfield_datasize(self):
        return self.__field_datasize.getvalue()

    def __setfield_datasize(self, value):
        if isinstance(value,UINT):
            self.__field_datasize=value
        else:
            self.__field_datasize=UINT(value,**{'sizeinbytes': 2})

    def __delfield_datasize(self): del self.__field_datasize

    datasize=property(__getfield_datasize, __setfield_datasize, __delfield_datasize, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,**{'sizeinbytes': self.datasize})

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('blockcounter', self.__field_blockcounter, None)
        yield ('thereismore', self.__field_thereismore, "true if there is more data available after this block")
        yield ('filesize', self.__field_filesize, None)
        yield ('datasize', self.__field_datasize, None)
        yield ('data', self.__field_data, None)




class readfileblockrequest(BaseProtogenClass):
    __fields=['header', 'blockcounter']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(readfileblockrequest,self).__init__(**dict)
        if self.__class__ is readfileblockrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(readfileblockrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(readfileblockrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x04})
        self.__field_header.writetobuffer(buf)
        self.__field_blockcounter.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=requestheader(**{'command': 0x04})
        self.__field_header.readfrombuffer(buf)
        self.__field_blockcounter=UINT(**{'sizeinbytes': 1})
        self.__field_blockcounter.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x04})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,requestheader):
            self.__field_header=value
        else:
            self.__field_header=requestheader(value,**{'command': 0x04})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_blockcounter(self):
        return self.__field_blockcounter.getvalue()

    def __setfield_blockcounter(self, value):
        if isinstance(value,UINT):
            self.__field_blockcounter=value
        else:
            self.__field_blockcounter=UINT(value,**{'sizeinbytes': 1})

    def __delfield_blockcounter(self): del self.__field_blockcounter

    blockcounter=property(__getfield_blockcounter, __setfield_blockcounter, __delfield_blockcounter, "always greater than zero, increment with each request, loop to 0x01 from 0xff")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('blockcounter', self.__field_blockcounter, "always greater than zero, increment with each request, loop to 0x01 from 0xff")




class readfileblockresponse(BaseProtogenClass):
    __fields=['header', 'blockcounter', 'thereismore', 'datasize', 'data']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(readfileblockresponse,self).__init__(**dict)
        if self.__class__ is readfileblockresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(readfileblockresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(readfileblockresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_blockcounter.writetobuffer(buf)
        self.__field_thereismore.writetobuffer(buf)
        self.__field_datasize.writetobuffer(buf)
        self.__field_data.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_blockcounter=UINT(**{'sizeinbytes': 1})
        self.__field_blockcounter.readfrombuffer(buf)
        self.__field_thereismore=BOOL(**{'sizeinbytes': 1})
        self.__field_thereismore.readfrombuffer(buf)
        self.__field_datasize=UINT(**{'sizeinbytes': 2})
        self.__field_datasize.readfrombuffer(buf)
        self.__field_data=DATA(**{'sizeinbytes': self.datasize})
        self.__field_data.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,responseheader):
            self.__field_header=value
        else:
            self.__field_header=responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_blockcounter(self):
        return self.__field_blockcounter.getvalue()

    def __setfield_blockcounter(self, value):
        if isinstance(value,UINT):
            self.__field_blockcounter=value
        else:
            self.__field_blockcounter=UINT(value,**{'sizeinbytes': 1})

    def __delfield_blockcounter(self): del self.__field_blockcounter

    blockcounter=property(__getfield_blockcounter, __setfield_blockcounter, __delfield_blockcounter, None)

    def __getfield_thereismore(self):
        return self.__field_thereismore.getvalue()

    def __setfield_thereismore(self, value):
        if isinstance(value,BOOL):
            self.__field_thereismore=value
        else:
            self.__field_thereismore=BOOL(value,**{'sizeinbytes': 1})

    def __delfield_thereismore(self): del self.__field_thereismore

    thereismore=property(__getfield_thereismore, __setfield_thereismore, __delfield_thereismore, "true if there is more data available after this block")

    def __getfield_datasize(self):
        return self.__field_datasize.getvalue()

    def __setfield_datasize(self, value):
        if isinstance(value,UINT):
            self.__field_datasize=value
        else:
            self.__field_datasize=UINT(value,**{'sizeinbytes': 2})

    def __delfield_datasize(self): del self.__field_datasize

    datasize=property(__getfield_datasize, __setfield_datasize, __delfield_datasize, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,**{'sizeinbytes': self.datasize})

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('blockcounter', self.__field_blockcounter, None)
        yield ('thereismore', self.__field_thereismore, "true if there is more data available after this block")
        yield ('datasize', self.__field_datasize, None)
        yield ('data', self.__field_data, None)




class writefilerequest(BaseProtogenClass):
    __fields=['header', 'blockcounter', 'thereismore', 'unknown1', 'filesize', 'unknown2', 'filename', 'datalen', 'data']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(writefilerequest,self).__init__(**dict)
        if self.__class__ is writefilerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(writefilerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(writefilerequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x05})
        self.__field_header.writetobuffer(buf)
        try: self.__field_blockcounter
        except:
            self.__field_blockcounter=UINT(**{'sizeinbytes': 1, 'value': 0})
        self.__field_blockcounter.writetobuffer(buf)
        try: self.__field_thereismore
        except:
            self.__field_thereismore=BOOL(**{'sizeinbytes': 1, 'value': self.filesize>0x100})
        self.__field_thereismore.writetobuffer(buf)
        try: self.__field_unknown1
        except:
            self.__field_unknown1=UINT(**{'sizeinbytes': 1, 'constant': 1})
        self.__field_unknown1.writetobuffer(buf)
        self.__field_filesize.writetobuffer(buf)
        try: self.__field_unknown2
        except:
            self.__field_unknown2=UINT(**{'sizeinbytes': 4, 'constant': 0x000100ff})
        self.__field_unknown2.writetobuffer(buf)
        self.__field_filename.writetobuffer(buf)
        try: self.__field_datalen
        except:
            self.__field_datalen=UINT(**{'sizeinbytes': 2, 'value': len(self.data)})
        self.__field_datalen.writetobuffer(buf)
        self.__field_data.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=requestheader(**{'command': 0x05})
        self.__field_header.readfrombuffer(buf)
        self.__field_blockcounter=UINT(**{'sizeinbytes': 1, 'value': 0})
        self.__field_blockcounter.readfrombuffer(buf)
        self.__field_thereismore=BOOL(**{'sizeinbytes': 1})
        self.__field_thereismore.readfrombuffer(buf)
        self.__field_unknown1=UINT(**{'sizeinbytes': 1, 'constant': 1})
        self.__field_unknown1.readfrombuffer(buf)
        self.__field_filesize=UINT(**{'sizeinbytes': 4})
        self.__field_filesize.readfrombuffer(buf)
        self.__field_unknown2=UINT(**{'sizeinbytes': 4, 'constant': 0x000100ff})
        self.__field_unknown2.readfrombuffer(buf)
        self.__field_filename=USTRING(**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })
        self.__field_filename.readfrombuffer(buf)
        self.__field_datalen=UINT(**{'sizeinbytes': 2})
        self.__field_datalen.readfrombuffer(buf)
        self.__field_data=DATA()
        self.__field_data.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x05})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,requestheader):
            self.__field_header=value
        else:
            self.__field_header=requestheader(value,**{'command': 0x05})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_blockcounter(self):
        try: self.__field_blockcounter
        except:
            self.__field_blockcounter=UINT(**{'sizeinbytes': 1, 'value': 0})
        return self.__field_blockcounter.getvalue()

    def __setfield_blockcounter(self, value):
        if isinstance(value,UINT):
            self.__field_blockcounter=value
        else:
            self.__field_blockcounter=UINT(value,**{'sizeinbytes': 1, 'value': 0})

    def __delfield_blockcounter(self): del self.__field_blockcounter

    blockcounter=property(__getfield_blockcounter, __setfield_blockcounter, __delfield_blockcounter, None)

    def __getfield_thereismore(self):
        try: self.__field_thereismore
        except:
            self.__field_thereismore=BOOL(**{'sizeinbytes': 1})
        return self.__field_thereismore.getvalue()

    def __setfield_thereismore(self, value):
        if isinstance(value,BOOL):
            self.__field_thereismore=value
        else:
            self.__field_thereismore=BOOL(value,**{'sizeinbytes': 1, 'value': self.filesize>0x100})

    def __delfield_thereismore(self): del self.__field_thereismore

    thereismore=property(__getfield_thereismore, __setfield_thereismore, __delfield_thereismore, None)

    def __getfield_unknown1(self):
        try: self.__field_unknown1
        except:
            self.__field_unknown1=UINT(**{'sizeinbytes': 1, 'constant': 1})
        return self.__field_unknown1.getvalue()

    def __setfield_unknown1(self, value):
        if isinstance(value,UINT):
            self.__field_unknown1=value
        else:
            self.__field_unknown1=UINT(value,**{'sizeinbytes': 1, 'constant': 1})

    def __delfield_unknown1(self): del self.__field_unknown1

    unknown1=property(__getfield_unknown1, __setfield_unknown1, __delfield_unknown1, None)

    def __getfield_filesize(self):
        return self.__field_filesize.getvalue()

    def __setfield_filesize(self, value):
        if isinstance(value,UINT):
            self.__field_filesize=value
        else:
            self.__field_filesize=UINT(value,**{'sizeinbytes': 4})

    def __delfield_filesize(self): del self.__field_filesize

    filesize=property(__getfield_filesize, __setfield_filesize, __delfield_filesize, None)

    def __getfield_unknown2(self):
        try: self.__field_unknown2
        except:
            self.__field_unknown2=UINT(**{'sizeinbytes': 4, 'constant': 0x000100ff})
        return self.__field_unknown2.getvalue()

    def __setfield_unknown2(self, value):
        if isinstance(value,UINT):
            self.__field_unknown2=value
        else:
            self.__field_unknown2=UINT(value,**{'sizeinbytes': 4, 'constant': 0x000100ff})

    def __delfield_unknown2(self): del self.__field_unknown2

    unknown2=property(__getfield_unknown2, __setfield_unknown2, __delfield_unknown2, "probably file attributes")

    def __getfield_filename(self):
        return self.__field_filename.getvalue()

    def __setfield_filename(self, value):
        if isinstance(value,USTRING):
            self.__field_filename=value
        else:
            self.__field_filename=USTRING(value,**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })

    def __delfield_filename(self): del self.__field_filename

    filename=property(__getfield_filename, __setfield_filename, __delfield_filename, None)

    def __getfield_datalen(self):
        try: self.__field_datalen
        except:
            self.__field_datalen=UINT(**{'sizeinbytes': 2})
        return self.__field_datalen.getvalue()

    def __setfield_datalen(self, value):
        if isinstance(value,UINT):
            self.__field_datalen=value
        else:
            self.__field_datalen=UINT(value,**{'sizeinbytes': 2, 'value': len(self.data)})

    def __delfield_datalen(self): del self.__field_datalen

    datalen=property(__getfield_datalen, __setfield_datalen, __delfield_datalen, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,)

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('blockcounter', self.__field_blockcounter, None)
        yield ('thereismore', self.__field_thereismore, None)
        yield ('unknown1', self.__field_unknown1, None)
        yield ('filesize', self.__field_filesize, None)
        yield ('unknown2', self.__field_unknown2, "probably file attributes")
        yield ('filename', self.__field_filename, None)
        yield ('datalen', self.__field_datalen, None)
        yield ('data', self.__field_data, None)




class writefileblockrequest(BaseProtogenClass):
    __fields=['header', 'blockcounter', 'thereismore', 'datalen', 'data']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(writefileblockrequest,self).__init__(**dict)
        if self.__class__ is writefileblockrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(writefileblockrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(writefileblockrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x05})
        self.__field_header.writetobuffer(buf)
        self.__field_blockcounter.writetobuffer(buf)
        self.__field_thereismore.writetobuffer(buf)
        try: self.__field_datalen
        except:
            self.__field_datalen=UINT(**{'sizeinbytes': 2, 'value': len(self.data)})
        self.__field_datalen.writetobuffer(buf)
        self.__field_data.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=requestheader(**{'command': 0x05})
        self.__field_header.readfrombuffer(buf)
        self.__field_blockcounter=UINT(**{'sizeinbytes': 1})
        self.__field_blockcounter.readfrombuffer(buf)
        self.__field_thereismore=BOOL(**{'sizeinbytes': 1})
        self.__field_thereismore.readfrombuffer(buf)
        self.__field_datalen=UINT(**{'sizeinbytes': 2})
        self.__field_datalen.readfrombuffer(buf)
        self.__field_data=DATA()
        self.__field_data.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x05})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,requestheader):
            self.__field_header=value
        else:
            self.__field_header=requestheader(value,**{'command': 0x05})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_blockcounter(self):
        return self.__field_blockcounter.getvalue()

    def __setfield_blockcounter(self, value):
        if isinstance(value,UINT):
            self.__field_blockcounter=value
        else:
            self.__field_blockcounter=UINT(value,**{'sizeinbytes': 1})

    def __delfield_blockcounter(self): del self.__field_blockcounter

    blockcounter=property(__getfield_blockcounter, __setfield_blockcounter, __delfield_blockcounter, None)

    def __getfield_thereismore(self):
        return self.__field_thereismore.getvalue()

    def __setfield_thereismore(self, value):
        if isinstance(value,BOOL):
            self.__field_thereismore=value
        else:
            self.__field_thereismore=BOOL(value,**{'sizeinbytes': 1})

    def __delfield_thereismore(self): del self.__field_thereismore

    thereismore=property(__getfield_thereismore, __setfield_thereismore, __delfield_thereismore, None)

    def __getfield_datalen(self):
        try: self.__field_datalen
        except:
            self.__field_datalen=UINT(**{'sizeinbytes': 2})
        return self.__field_datalen.getvalue()

    def __setfield_datalen(self, value):
        if isinstance(value,UINT):
            self.__field_datalen=value
        else:
            self.__field_datalen=UINT(value,**{'sizeinbytes': 2, 'value': len(self.data)})

    def __delfield_datalen(self): del self.__field_datalen

    datalen=property(__getfield_datalen, __setfield_datalen, __delfield_datalen, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,)

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('blockcounter', self.__field_blockcounter, None)
        yield ('thereismore', self.__field_thereismore, None)
        yield ('datalen', self.__field_datalen, None)
        yield ('data', self.__field_data, None)




class listdirectoriesrequest(BaseProtogenClass):
    "Lists the subdirectories of dirname"
    __fields=['header', 'dirname']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(listdirectoriesrequest,self).__init__(**dict)
        if self.__class__ is listdirectoriesrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(listdirectoriesrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(listdirectoriesrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x02})
        self.__field_header.writetobuffer(buf)
        self.__field_dirname.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=requestheader(**{'command': 0x02})
        self.__field_header.readfrombuffer(buf)
        self.__field_dirname=USTRING(**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })
        self.__field_dirname.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x02})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,requestheader):
            self.__field_header=value
        else:
            self.__field_header=requestheader(value,**{'command': 0x02})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_dirname(self):
        return self.__field_dirname.getvalue()

    def __setfield_dirname(self, value):
        if isinstance(value,USTRING):
            self.__field_dirname=value
        else:
            self.__field_dirname=USTRING(value,**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })

    def __delfield_dirname(self): del self.__field_dirname

    dirname=property(__getfield_dirname, __setfield_dirname, __delfield_dirname, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('dirname', self.__field_dirname, None)




class listdirectoriesresponse(BaseProtogenClass):
    __fields=['header', 'numentries', 'datalen', 'items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(listdirectoriesresponse,self).__init__(**dict)
        if self.__class__ is listdirectoriesresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(listdirectoriesresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(listdirectoriesresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_numentries.writetobuffer(buf)
        if self.numentries>0:
            self.__field_datalen.writetobuffer(buf)
            self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_numentries=UINT(**{'sizeinbytes': 2})
        self.__field_numentries.readfrombuffer(buf)
        if self.numentries>0:
            self.__field_datalen=UINT(**{'sizeinbytes': 2})
            self.__field_datalen.readfrombuffer(buf)
            self.__field_items=LIST(**{'elementclass': _gen_p_brew_114, 'length': self.numentries})
            self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,responseheader):
            self.__field_header=value
        else:
            self.__field_header=responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_numentries(self):
        return self.__field_numentries.getvalue()

    def __setfield_numentries(self, value):
        if isinstance(value,UINT):
            self.__field_numentries=value
        else:
            self.__field_numentries=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numentries(self): del self.__field_numentries

    numentries=property(__getfield_numentries, __setfield_numentries, __delfield_numentries, None)

    def __getfield_datalen(self):
        return self.__field_datalen.getvalue()

    def __setfield_datalen(self, value):
        if isinstance(value,UINT):
            self.__field_datalen=value
        else:
            self.__field_datalen=UINT(value,**{'sizeinbytes': 2})

    def __delfield_datalen(self): del self.__field_datalen

    datalen=property(__getfield_datalen, __setfield_datalen, __delfield_datalen, None)

    def __getfield_items(self):
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{'elementclass': _gen_p_brew_114, 'length': self.numentries})

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('numentries', self.__field_numentries, None)
        if self.numentries>0:
            yield ('datalen', self.__field_datalen, None)
            yield ('items', self.__field_items, None)




class _gen_p_brew_114(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['subdir']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_brew_114,self).__init__(**dict)
        if self.__class__ is _gen_p_brew_114:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_brew_114,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_brew_114,kwargs)
        if len(args):
            dict2={ 'encoding': PHONE_ENCODING }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_subdir=USTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_subdir.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_subdir=USTRING(**{ 'encoding': PHONE_ENCODING })
        self.__field_subdir.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_subdir(self):
        return self.__field_subdir.getvalue()

    def __setfield_subdir(self, value):
        if isinstance(value,USTRING):
            self.__field_subdir=value
        else:
            self.__field_subdir=USTRING(value,**{ 'encoding': PHONE_ENCODING })

    def __delfield_subdir(self): del self.__field_subdir

    subdir=property(__getfield_subdir, __setfield_subdir, __delfield_subdir, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('subdir', self.__field_subdir, None)




class listfilerequest(BaseProtogenClass):
    "This gets one directory entry (files only) at a time"
    __fields=['header', 'entrynumber', 'dirname']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(listfilerequest,self).__init__(**dict)
        if self.__class__ is listfilerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(listfilerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(listfilerequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x0b})
        self.__field_header.writetobuffer(buf)
        self.__field_entrynumber.writetobuffer(buf)
        self.__field_dirname.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=requestheader(**{'command': 0x0b})
        self.__field_header.readfrombuffer(buf)
        self.__field_entrynumber=UINT(**{'sizeinbytes': 4})
        self.__field_entrynumber.readfrombuffer(buf)
        self.__field_dirname=USTRING(**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })
        self.__field_dirname.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x0b})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,requestheader):
            self.__field_header=value
        else:
            self.__field_header=requestheader(value,**{'command': 0x0b})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entrynumber(self):
        return self.__field_entrynumber.getvalue()

    def __setfield_entrynumber(self, value):
        if isinstance(value,UINT):
            self.__field_entrynumber=value
        else:
            self.__field_entrynumber=UINT(value,**{'sizeinbytes': 4})

    def __delfield_entrynumber(self): del self.__field_entrynumber

    entrynumber=property(__getfield_entrynumber, __setfield_entrynumber, __delfield_entrynumber, None)

    def __getfield_dirname(self):
        return self.__field_dirname.getvalue()

    def __setfield_dirname(self, value):
        if isinstance(value,USTRING):
            self.__field_dirname=value
        else:
            self.__field_dirname=USTRING(value,**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })

    def __delfield_dirname(self): del self.__field_dirname

    dirname=property(__getfield_dirname, __setfield_dirname, __delfield_dirname, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entrynumber', self.__field_entrynumber, None)
        yield ('dirname', self.__field_dirname, None)




class listfileresponse(BaseProtogenClass):
    __fields=['header', 'entrynumber', 'unknown1', 'date', 'size', 'unknown2', 'spuriouszero', 'dirnamelen', 'extrazero', 'filename']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(listfileresponse,self).__init__(**dict)
        if self.__class__ is listfileresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(listfileresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(listfileresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entrynumber.writetobuffer(buf)
        self.__field_unknown1.writetobuffer(buf)
        self.__field_date.writetobuffer(buf)
        self.__field_size.writetobuffer(buf)
        self.__field_unknown2.writetobuffer(buf)
        self.__field_spuriouszero.writetobuffer(buf)
        self.__field_dirnamelen.writetobuffer(buf)
        self.__field_extrazero.writetobuffer(buf)
        self.__field_filename.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entrynumber=UINT(**{'sizeinbytes': 4})
        self.__field_entrynumber.readfrombuffer(buf)
        self.__field_unknown1=UNKNOWN(**{'sizeinbytes': 4})
        self.__field_unknown1.readfrombuffer(buf)
        self.__field_date=UINT(**{'sizeinbytes': 4})
        self.__field_date.readfrombuffer(buf)
        self.__field_size=UINT(**{'sizeinbytes': 4})
        self.__field_size.readfrombuffer(buf)
        self.__field_unknown2=UNKNOWN(**{'sizeinbytes': 4})
        self.__field_unknown2.readfrombuffer(buf)
        self.__field_spuriouszero=com_brew.SPURIOUSZERO()
        self.__field_spuriouszero.readfrombuffer(buf)
        self.__field_dirnamelen=UINT(**{'sizeinbytes': 1})
        self.__field_dirnamelen.readfrombuffer(buf)
        self.__field_extrazero=com_brew.EXTRAZERO()
        self.__field_extrazero.readfrombuffer(buf)
        self.__field_filename=USTRING(**{'terminator': None, 'pascal': True,               'encoding': PHONE_ENCODING })
        self.__field_filename.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,responseheader):
            self.__field_header=value
        else:
            self.__field_header=responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entrynumber(self):
        return self.__field_entrynumber.getvalue()

    def __setfield_entrynumber(self, value):
        if isinstance(value,UINT):
            self.__field_entrynumber=value
        else:
            self.__field_entrynumber=UINT(value,**{'sizeinbytes': 4})

    def __delfield_entrynumber(self): del self.__field_entrynumber

    entrynumber=property(__getfield_entrynumber, __setfield_entrynumber, __delfield_entrynumber, None)

    def __getfield_unknown1(self):
        return self.__field_unknown1.getvalue()

    def __setfield_unknown1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown1=value
        else:
            self.__field_unknown1=UNKNOWN(value,**{'sizeinbytes': 4})

    def __delfield_unknown1(self): del self.__field_unknown1

    unknown1=property(__getfield_unknown1, __setfield_unknown1, __delfield_unknown1, "probably the file attributes")

    def __getfield_date(self):
        return self.__field_date.getvalue()

    def __setfield_date(self, value):
        if isinstance(value,UINT):
            self.__field_date=value
        else:
            self.__field_date=UINT(value,**{'sizeinbytes': 4})

    def __delfield_date(self): del self.__field_date

    date=property(__getfield_date, __setfield_date, __delfield_date, None)

    def __getfield_size(self):
        return self.__field_size.getvalue()

    def __setfield_size(self, value):
        if isinstance(value,UINT):
            self.__field_size=value
        else:
            self.__field_size=UINT(value,**{'sizeinbytes': 4})

    def __delfield_size(self): del self.__field_size

    size=property(__getfield_size, __setfield_size, __delfield_size, None)

    def __getfield_unknown2(self):
        return self.__field_unknown2.getvalue()

    def __setfield_unknown2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown2=value
        else:
            self.__field_unknown2=UNKNOWN(value,**{'sizeinbytes': 4})

    def __delfield_unknown2(self): del self.__field_unknown2

    unknown2=property(__getfield_unknown2, __setfield_unknown2, __delfield_unknown2, None)

    def __getfield_spuriouszero(self):
        return self.__field_spuriouszero.getvalue()

    def __setfield_spuriouszero(self, value):
        if isinstance(value,com_brew.SPURIOUSZERO):
            self.__field_spuriouszero=value
        else:
            self.__field_spuriouszero=com_brew.SPURIOUSZERO(value,)

    def __delfield_spuriouszero(self): del self.__field_spuriouszero

    spuriouszero=property(__getfield_spuriouszero, __setfield_spuriouszero, __delfield_spuriouszero, "on some models there is a zero here")

    def __getfield_dirnamelen(self):
        return self.__field_dirnamelen.getvalue()

    def __setfield_dirnamelen(self, value):
        if isinstance(value,UINT):
            self.__field_dirnamelen=value
        else:
            self.__field_dirnamelen=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dirnamelen(self): del self.__field_dirnamelen

    dirnamelen=property(__getfield_dirnamelen, __setfield_dirnamelen, __delfield_dirnamelen, "which portion of the filename is the directory, including the last /")

    def __getfield_extrazero(self):
        return self.__field_extrazero.getvalue()

    def __setfield_extrazero(self, value):
        if isinstance(value,com_brew.EXTRAZERO):
            self.__field_extrazero=value
        else:
            self.__field_extrazero=com_brew.EXTRAZERO(value,)

    def __delfield_extrazero(self): del self.__field_extrazero

    extrazero=property(__getfield_extrazero, __setfield_extrazero, __delfield_extrazero, "on some models there is a zero here")

    def __getfield_filename(self):
        return self.__field_filename.getvalue()

    def __setfield_filename(self, value):
        if isinstance(value,USTRING):
            self.__field_filename=value
        else:
            self.__field_filename=USTRING(value,**{'terminator': None, 'pascal': True,               'encoding': PHONE_ENCODING })

    def __delfield_filename(self): del self.__field_filename

    filename=property(__getfield_filename, __setfield_filename, __delfield_filename, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entrynumber', self.__field_entrynumber, None)
        yield ('unknown1', self.__field_unknown1, "probably the file attributes")
        yield ('date', self.__field_date, None)
        yield ('size', self.__field_size, None)
        yield ('unknown2', self.__field_unknown2, None)
        yield ('spuriouszero', self.__field_spuriouszero, "on some models there is a zero here")
        yield ('dirnamelen', self.__field_dirnamelen, "which portion of the filename is the directory, including the last /")
        yield ('extrazero', self.__field_extrazero, "on some models there is a zero here")
        yield ('filename', self.__field_filename, None)




class listdirectoryrequest(BaseProtogenClass):
    "This gets one directory entry (directory only) at a time"
    __fields=['header', 'entrynumber', 'dirname']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(listdirectoryrequest,self).__init__(**dict)
        if self.__class__ is listdirectoryrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(listdirectoryrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(listdirectoryrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x0a})
        self.__field_header.writetobuffer(buf)
        self.__field_entrynumber.writetobuffer(buf)
        self.__field_dirname.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=requestheader(**{'command': 0x0a})
        self.__field_header.readfrombuffer(buf)
        self.__field_entrynumber=UINT(**{'sizeinbytes': 4})
        self.__field_entrynumber.readfrombuffer(buf)
        self.__field_dirname=USTRING(**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })
        self.__field_dirname.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x0a})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,requestheader):
            self.__field_header=value
        else:
            self.__field_header=requestheader(value,**{'command': 0x0a})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entrynumber(self):
        return self.__field_entrynumber.getvalue()

    def __setfield_entrynumber(self, value):
        if isinstance(value,UINT):
            self.__field_entrynumber=value
        else:
            self.__field_entrynumber=UINT(value,**{'sizeinbytes': 4})

    def __delfield_entrynumber(self): del self.__field_entrynumber

    entrynumber=property(__getfield_entrynumber, __setfield_entrynumber, __delfield_entrynumber, None)

    def __getfield_dirname(self):
        return self.__field_dirname.getvalue()

    def __setfield_dirname(self, value):
        if isinstance(value,USTRING):
            self.__field_dirname=value
        else:
            self.__field_dirname=USTRING(value,**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })

    def __delfield_dirname(self): del self.__field_dirname

    dirname=property(__getfield_dirname, __setfield_dirname, __delfield_dirname, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entrynumber', self.__field_entrynumber, None)
        yield ('dirname', self.__field_dirname, None)




class listdirectoryresponse(BaseProtogenClass):
    __fields=['header', 'entrynumber', 'unknown1', 'extrazero', 'subdir']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(listdirectoryresponse,self).__init__(**dict)
        if self.__class__ is listdirectoryresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(listdirectoryresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(listdirectoryresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entrynumber.writetobuffer(buf)
        self.__field_unknown1.writetobuffer(buf)
        self.__field_extrazero.writetobuffer(buf)
        self.__field_subdir.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entrynumber=UINT(**{'sizeinbytes': 4})
        self.__field_entrynumber.readfrombuffer(buf)
        self.__field_unknown1=UNKNOWN(**{'sizeinbytes': 17})
        self.__field_unknown1.readfrombuffer(buf)
        self.__field_extrazero=com_brew.EXTRAZERO()
        self.__field_extrazero.readfrombuffer(buf)
        self.__field_subdir=USTRING(**{'terminator': None, 'pascal': True,               'encoding': PHONE_ENCODING })
        self.__field_subdir.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,responseheader):
            self.__field_header=value
        else:
            self.__field_header=responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entrynumber(self):
        return self.__field_entrynumber.getvalue()

    def __setfield_entrynumber(self, value):
        if isinstance(value,UINT):
            self.__field_entrynumber=value
        else:
            self.__field_entrynumber=UINT(value,**{'sizeinbytes': 4})

    def __delfield_entrynumber(self): del self.__field_entrynumber

    entrynumber=property(__getfield_entrynumber, __setfield_entrynumber, __delfield_entrynumber, None)

    def __getfield_unknown1(self):
        return self.__field_unknown1.getvalue()

    def __setfield_unknown1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown1=value
        else:
            self.__field_unknown1=UNKNOWN(value,**{'sizeinbytes': 17})

    def __delfield_unknown1(self): del self.__field_unknown1

    unknown1=property(__getfield_unknown1, __setfield_unknown1, __delfield_unknown1, "probably the directory attributes")

    def __getfield_extrazero(self):
        return self.__field_extrazero.getvalue()

    def __setfield_extrazero(self, value):
        if isinstance(value,com_brew.EXTRAZERO):
            self.__field_extrazero=value
        else:
            self.__field_extrazero=com_brew.EXTRAZERO(value,)

    def __delfield_extrazero(self): del self.__field_extrazero

    extrazero=property(__getfield_extrazero, __setfield_extrazero, __delfield_extrazero, "on some models there is a zero here")

    def __getfield_subdir(self):
        return self.__field_subdir.getvalue()

    def __setfield_subdir(self, value):
        if isinstance(value,USTRING):
            self.__field_subdir=value
        else:
            self.__field_subdir=USTRING(value,**{'terminator': None, 'pascal': True,               'encoding': PHONE_ENCODING })

    def __delfield_subdir(self): del self.__field_subdir

    subdir=property(__getfield_subdir, __setfield_subdir, __delfield_subdir, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entrynumber', self.__field_entrynumber, None)
        yield ('unknown1', self.__field_unknown1, "probably the directory attributes")
        yield ('extrazero', self.__field_extrazero, "on some models there is a zero here")
        yield ('subdir', self.__field_subdir, None)




class statfilerequest(BaseProtogenClass):
    "Get the status of the file"
    __fields=['header', 'filename']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(statfilerequest,self).__init__(**dict)
        if self.__class__ is statfilerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(statfilerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(statfilerequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{ 'command': 7 })
        self.__field_header.writetobuffer(buf)
        self.__field_filename.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=requestheader(**{ 'command': 7 })
        self.__field_header.readfrombuffer(buf)
        self.__field_filename=USTRING(**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })
        self.__field_filename.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{ 'command': 7 })
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,requestheader):
            self.__field_header=value
        else:
            self.__field_header=requestheader(value,**{ 'command': 7 })

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_filename(self):
        return self.__field_filename.getvalue()

    def __setfield_filename(self, value):
        if isinstance(value,USTRING):
            self.__field_filename=value
        else:
            self.__field_filename=USTRING(value,**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })

    def __delfield_filename(self): del self.__field_filename

    filename=property(__getfield_filename, __setfield_filename, __delfield_filename, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('filename', self.__field_filename, None)




class statfileresponse(BaseProtogenClass):
    __fields=['header', 'unknown1', 'date', 'size']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(statfileresponse,self).__init__(**dict)
        if self.__class__ is statfileresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(statfileresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(statfileresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_unknown1.writetobuffer(buf)
        self.__field_date.writetobuffer(buf)
        self.__field_size.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_unknown1=UNKNOWN(**{'sizeinbytes': 4})
        self.__field_unknown1.readfrombuffer(buf)
        self.__field_date=UINT(**{'sizeinbytes': 4})
        self.__field_date.readfrombuffer(buf)
        self.__field_size=UINT(**{'sizeinbytes': 4})
        self.__field_size.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,responseheader):
            self.__field_header=value
        else:
            self.__field_header=responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_unknown1(self):
        return self.__field_unknown1.getvalue()

    def __setfield_unknown1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown1=value
        else:
            self.__field_unknown1=UNKNOWN(value,**{'sizeinbytes': 4})

    def __delfield_unknown1(self): del self.__field_unknown1

    unknown1=property(__getfield_unknown1, __setfield_unknown1, __delfield_unknown1, "probably the file attributes")

    def __getfield_date(self):
        return self.__field_date.getvalue()

    def __setfield_date(self, value):
        if isinstance(value,UINT):
            self.__field_date=value
        else:
            self.__field_date=UINT(value,**{'sizeinbytes': 4})

    def __delfield_date(self): del self.__field_date

    date=property(__getfield_date, __setfield_date, __delfield_date, None)

    def __getfield_size(self):
        return self.__field_size.getvalue()

    def __setfield_size(self, value):
        if isinstance(value,UINT):
            self.__field_size=value
        else:
            self.__field_size=UINT(value,**{'sizeinbytes': 4})

    def __delfield_size(self): del self.__field_size

    size=property(__getfield_size, __setfield_size, __delfield_size, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('unknown1', self.__field_unknown1, "probably the file attributes")
        yield ('date', self.__field_date, None)
        yield ('size', self.__field_size, None)




class mkdirrequest(BaseProtogenClass):
    __fields=['header', 'dirname']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(mkdirrequest,self).__init__(**dict)
        if self.__class__ is mkdirrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(mkdirrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(mkdirrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x00})
        self.__field_header.writetobuffer(buf)
        self.__field_dirname.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=requestheader(**{'command': 0x00})
        self.__field_header.readfrombuffer(buf)
        self.__field_dirname=USTRING(**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })
        self.__field_dirname.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x00})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,requestheader):
            self.__field_header=value
        else:
            self.__field_header=requestheader(value,**{'command': 0x00})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_dirname(self):
        return self.__field_dirname.getvalue()

    def __setfield_dirname(self, value):
        if isinstance(value,USTRING):
            self.__field_dirname=value
        else:
            self.__field_dirname=USTRING(value,**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })

    def __delfield_dirname(self): del self.__field_dirname

    dirname=property(__getfield_dirname, __setfield_dirname, __delfield_dirname, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('dirname', self.__field_dirname, None)




class rmdirrequest(BaseProtogenClass):
    __fields=['header', 'dirname']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(rmdirrequest,self).__init__(**dict)
        if self.__class__ is rmdirrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(rmdirrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(rmdirrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x01})
        self.__field_header.writetobuffer(buf)
        self.__field_dirname.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=requestheader(**{'command': 0x01})
        self.__field_header.readfrombuffer(buf)
        self.__field_dirname=USTRING(**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })
        self.__field_dirname.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x01})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,requestheader):
            self.__field_header=value
        else:
            self.__field_header=requestheader(value,**{'command': 0x01})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_dirname(self):
        return self.__field_dirname.getvalue()

    def __setfield_dirname(self, value):
        if isinstance(value,USTRING):
            self.__field_dirname=value
        else:
            self.__field_dirname=USTRING(value,**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })

    def __delfield_dirname(self): del self.__field_dirname

    dirname=property(__getfield_dirname, __setfield_dirname, __delfield_dirname, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('dirname', self.__field_dirname, None)




class rmfilerequest(BaseProtogenClass):
    __fields=['header', 'filename']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(rmfilerequest,self).__init__(**dict)
        if self.__class__ is rmfilerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(rmfilerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(rmfilerequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x06})
        self.__field_header.writetobuffer(buf)
        self.__field_filename.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=requestheader(**{'command': 0x06})
        self.__field_header.readfrombuffer(buf)
        self.__field_filename=USTRING(**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })
        self.__field_filename.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x06})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,requestheader):
            self.__field_header=value
        else:
            self.__field_header=requestheader(value,**{'command': 0x06})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_filename(self):
        return self.__field_filename.getvalue()

    def __setfield_filename(self, value):
        if isinstance(value,USTRING):
            self.__field_filename=value
        else:
            self.__field_filename=USTRING(value,**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })

    def __delfield_filename(self): del self.__field_filename

    filename=property(__getfield_filename, __setfield_filename, __delfield_filename, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('filename', self.__field_filename, None)




class memoryconfigrequest(BaseProtogenClass):
    __fields=['header']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(memoryconfigrequest,self).__init__(**dict)
        if self.__class__ is memoryconfigrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(memoryconfigrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(memoryconfigrequest,kwargs)
        if len(args):
            dict2={'command': 0x0c}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_header=requestheader(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x0c})
        self.__field_header.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=requestheader(**{'command': 0x0c})
        self.__field_header.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{'command': 0x0c})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,requestheader):
            self.__field_header=value
        else:
            self.__field_header=requestheader(value,**{'command': 0x0c})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)




class memoryconfigresponse(BaseProtogenClass):
    __fields=['header', 'amountofmemory']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(memoryconfigresponse,self).__init__(**dict)
        if self.__class__ is memoryconfigresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(memoryconfigresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(memoryconfigresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_amountofmemory.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_amountofmemory=UINT(**{'sizeinbytes': 4})
        self.__field_amountofmemory.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,responseheader):
            self.__field_header=value
        else:
            self.__field_header=responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_amountofmemory(self):
        return self.__field_amountofmemory.getvalue()

    def __setfield_amountofmemory(self, value):
        if isinstance(value,UINT):
            self.__field_amountofmemory=value
        else:
            self.__field_amountofmemory=UINT(value,**{'sizeinbytes': 4})

    def __delfield_amountofmemory(self): del self.__field_amountofmemory

    amountofmemory=property(__getfield_amountofmemory, __setfield_amountofmemory, __delfield_amountofmemory, "how much memory the EFS has in bytes")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('amountofmemory', self.__field_amountofmemory, "how much memory the EFS has in bytes")




class firmwarerequest(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(firmwarerequest,self).__init__(**dict)
        if self.__class__ is firmwarerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(firmwarerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(firmwarerequest,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1, 'constant': 0x00}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x00})
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x00})
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x00})
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1, 'constant': 0x00})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class firmwareresponse(BaseProtogenClass):
    __fields=['command', 'date1', 'time1', 'date2', 'time2', 'string1', 'dunno1', 'date3', 'dunno2', 'time3', 'dunno3', 'firmware']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(firmwareresponse,self).__init__(**dict)
        if self.__class__ is firmwareresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(firmwareresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(firmwareresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_date1.writetobuffer(buf)
        self.__field_time1.writetobuffer(buf)
        self.__field_date2.writetobuffer(buf)
        self.__field_time2.writetobuffer(buf)
        self.__field_string1.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self.__field_date3.writetobuffer(buf)
        self.__field_dunno2.writetobuffer(buf)
        self.__field_time3.writetobuffer(buf)
        self.__field_dunno3.writetobuffer(buf)
        self.__field_firmware.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=UINT(**{'sizeinbytes': 1})
        self.__field_command.readfrombuffer(buf)
        self.__field_date1=USTRING(**{'sizeinbytes': 11, 'terminator': None})
        self.__field_date1.readfrombuffer(buf)
        self.__field_time1=USTRING(**{'sizeinbytes': 8, 'terminator': None})
        self.__field_time1.readfrombuffer(buf)
        self.__field_date2=USTRING(**{'sizeinbytes': 11, 'terminator': None})
        self.__field_date2.readfrombuffer(buf)
        self.__field_time2=USTRING(**{'sizeinbytes': 8, 'terminator': None})
        self.__field_time2.readfrombuffer(buf)
        self.__field_string1=USTRING(**{'sizeinbytes': 8, 'terminator': None})
        self.__field_string1.readfrombuffer(buf)
        self.__field_dunno1=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_date3=USTRING(**{'sizeinbytes': 11, 'terminator': None})
        self.__field_date3.readfrombuffer(buf)
        self.__field_dunno2=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_dunno2.readfrombuffer(buf)
        self.__field_time3=USTRING(**{'sizeinbytes': 8, 'terminator': None})
        self.__field_time3.readfrombuffer(buf)
        self.__field_dunno3=UNKNOWN(**{'sizeinbytes': 11})
        self.__field_dunno3.readfrombuffer(buf)
        self.__field_firmware=USTRING(**{'sizeinbytes': 10, 'terminator': None})
        self.__field_firmware.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_date1(self):
        return self.__field_date1.getvalue()

    def __setfield_date1(self, value):
        if isinstance(value,USTRING):
            self.__field_date1=value
        else:
            self.__field_date1=USTRING(value,**{'sizeinbytes': 11, 'terminator': None})

    def __delfield_date1(self): del self.__field_date1

    date1=property(__getfield_date1, __setfield_date1, __delfield_date1, None)

    def __getfield_time1(self):
        return self.__field_time1.getvalue()

    def __setfield_time1(self, value):
        if isinstance(value,USTRING):
            self.__field_time1=value
        else:
            self.__field_time1=USTRING(value,**{'sizeinbytes': 8, 'terminator': None})

    def __delfield_time1(self): del self.__field_time1

    time1=property(__getfield_time1, __setfield_time1, __delfield_time1, None)

    def __getfield_date2(self):
        return self.__field_date2.getvalue()

    def __setfield_date2(self, value):
        if isinstance(value,USTRING):
            self.__field_date2=value
        else:
            self.__field_date2=USTRING(value,**{'sizeinbytes': 11, 'terminator': None})

    def __delfield_date2(self): del self.__field_date2

    date2=property(__getfield_date2, __setfield_date2, __delfield_date2, None)

    def __getfield_time2(self):
        return self.__field_time2.getvalue()

    def __setfield_time2(self, value):
        if isinstance(value,USTRING):
            self.__field_time2=value
        else:
            self.__field_time2=USTRING(value,**{'sizeinbytes': 8, 'terminator': None})

    def __delfield_time2(self): del self.__field_time2

    time2=property(__getfield_time2, __setfield_time2, __delfield_time2, None)

    def __getfield_string1(self):
        return self.__field_string1.getvalue()

    def __setfield_string1(self, value):
        if isinstance(value,USTRING):
            self.__field_string1=value
        else:
            self.__field_string1=USTRING(value,**{'sizeinbytes': 8, 'terminator': None})

    def __delfield_string1(self): del self.__field_string1

    string1=property(__getfield_string1, __setfield_string1, __delfield_string1, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_date3(self):
        return self.__field_date3.getvalue()

    def __setfield_date3(self, value):
        if isinstance(value,USTRING):
            self.__field_date3=value
        else:
            self.__field_date3=USTRING(value,**{'sizeinbytes': 11, 'terminator': None})

    def __delfield_date3(self): del self.__field_date3

    date3=property(__getfield_date3, __setfield_date3, __delfield_date3, None)

    def __getfield_dunno2(self):
        return self.__field_dunno2.getvalue()

    def __setfield_dunno2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno2=value
        else:
            self.__field_dunno2=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_dunno2(self): del self.__field_dunno2

    dunno2=property(__getfield_dunno2, __setfield_dunno2, __delfield_dunno2, None)

    def __getfield_time3(self):
        return self.__field_time3.getvalue()

    def __setfield_time3(self, value):
        if isinstance(value,USTRING):
            self.__field_time3=value
        else:
            self.__field_time3=USTRING(value,**{'sizeinbytes': 8, 'terminator': None})

    def __delfield_time3(self): del self.__field_time3

    time3=property(__getfield_time3, __setfield_time3, __delfield_time3, None)

    def __getfield_dunno3(self):
        return self.__field_dunno3.getvalue()

    def __setfield_dunno3(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno3=value
        else:
            self.__field_dunno3=UNKNOWN(value,**{'sizeinbytes': 11})

    def __delfield_dunno3(self): del self.__field_dunno3

    dunno3=property(__getfield_dunno3, __setfield_dunno3, __delfield_dunno3, None)

    def __getfield_firmware(self):
        return self.__field_firmware.getvalue()

    def __setfield_firmware(self, value):
        if isinstance(value,USTRING):
            self.__field_firmware=value
        else:
            self.__field_firmware=USTRING(value,**{'sizeinbytes': 10, 'terminator': None})

    def __delfield_firmware(self): del self.__field_firmware

    firmware=property(__getfield_firmware, __setfield_firmware, __delfield_firmware, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('date1', self.__field_date1, None)
        yield ('time1', self.__field_time1, None)
        yield ('date2', self.__field_date2, None)
        yield ('time2', self.__field_time2, None)
        yield ('string1', self.__field_string1, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('date3', self.__field_date3, None)
        yield ('dunno2', self.__field_dunno2, None)
        yield ('time3', self.__field_time3, None)
        yield ('dunno3', self.__field_dunno3, None)
        yield ('firmware', self.__field_firmware, None)




class ESN_req(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ESN_req,self).__init__(**dict)
        if self.__class__ is ESN_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ESN_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ESN_req,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1,  'default': 1, 'constant': 1 }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1,  'default': 1, 'constant': 1 })
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=UINT(**{'sizeinbytes': 1,  'default': 1, 'constant': 1 })
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1,  'default': 1, 'constant': 1 })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1,  'default': 1, 'constant': 1 })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class ESN_resp(BaseProtogenClass):
    __fields=['command', 'esn']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ESN_resp,self).__init__(**dict)
        if self.__class__ is ESN_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ESN_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ESN_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_esn.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=UINT(**{'sizeinbytes': 1,  'constant': 1 })
        self.__field_command.readfrombuffer(buf)
        self.__field_esn=UINT(**{'sizeinbytes': 4})
        self.__field_esn.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1,  'constant': 1 })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_esn(self):
        return self.__field_esn.getvalue()

    def __setfield_esn(self, value):
        if isinstance(value,UINT):
            self.__field_esn=value
        else:
            self.__field_esn=UINT(value,**{'sizeinbytes': 4})

    def __delfield_esn(self): del self.__field_esn

    esn=property(__getfield_esn, __setfield_esn, __delfield_esn, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('esn', self.__field_esn, None)




class testing0crequest(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(testing0crequest,self).__init__(**dict)
        if self.__class__ is testing0crequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(testing0crequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(testing0crequest,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1, 'constant': 0x0c}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x0c})
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x0c})
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x0c})
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1, 'constant': 0x0c})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class testing0cresponse(BaseProtogenClass):
    __fields=['pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(testing0cresponse,self).__init__(**dict)
        if self.__class__ is testing0cresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(testing0cresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(testing0cresponse,kwargs)
        if len(args):
            dict2={}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pad=UNKNOWN(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pad=UNKNOWN()
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,)

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pad', self.__field_pad, None)




class setmoderequest(BaseProtogenClass):
    __fields=['command', 'request', 'zero']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(setmoderequest,self).__init__(**dict)
        if self.__class__ is setmoderequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(setmoderequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(setmoderequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x29})
        self.__field_command.writetobuffer(buf)
        self.__field_request.writetobuffer(buf)
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 1, 'constant': 0x00})
        self.__field_zero.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x29})
        self.__field_command.readfrombuffer(buf)
        self.__field_request=UINT(**{'sizeinbytes': 1})
        self.__field_request.readfrombuffer(buf)
        self.__field_zero=UINT(**{'sizeinbytes': 1, 'constant': 0x00})
        self.__field_zero.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x29})
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1, 'constant': 0x29})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_request(self):
        return self.__field_request.getvalue()

    def __setfield_request(self, value):
        if isinstance(value,UINT):
            self.__field_request=value
        else:
            self.__field_request=UINT(value,**{'sizeinbytes': 1})

    def __delfield_request(self): del self.__field_request

    request=property(__getfield_request, __setfield_request, __delfield_request, "1=offline 2-reset.  Reset has no effect unless already offline")

    def __getfield_zero(self):
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 1, 'constant': 0x00})
        return self.__field_zero.getvalue()

    def __setfield_zero(self, value):
        if isinstance(value,UINT):
            self.__field_zero=value
        else:
            self.__field_zero=UINT(value,**{'sizeinbytes': 1, 'constant': 0x00})

    def __delfield_zero(self): del self.__field_zero

    zero=property(__getfield_zero, __setfield_zero, __delfield_zero, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('request', self.__field_request, "1=offline 2-reset.  Reset has no effect unless already offline")
        yield ('zero', self.__field_zero, None)




class setmoderesponse(BaseProtogenClass):
    __fields=['pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(setmoderesponse,self).__init__(**dict)
        if self.__class__ is setmoderesponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(setmoderesponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(setmoderesponse,kwargs)
        if len(args):
            dict2={}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pad=UNKNOWN(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pad=UNKNOWN()
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,)

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pad', self.__field_pad, None)




class setmodemmoderequest(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(setmodemmoderequest,self).__init__(**dict)
        if self.__class__ is setmodemmoderequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(setmodemmoderequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(setmodemmoderequest,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1, 'constant': 0x44}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x44})
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x44})
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x44})
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1, 'constant': 0x44})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class setfileattrrequest(BaseProtogenClass):
    "Set the attributes of the file"
    __fields=['header', 'unknown', 'date', 'filename']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(setfileattrrequest,self).__init__(**dict)
        if self.__class__ is setfileattrrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(setfileattrrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(setfileattrrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{ 'command': 8 })
        self.__field_header.writetobuffer(buf)
        try: self.__field_unknown
        except:
            self.__field_unknown=UINT(**{'sizeinbytes': 4, 'constant': 0x000100ff})
        self.__field_unknown.writetobuffer(buf)
        self.__field_date.writetobuffer(buf)
        self.__field_filename.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=requestheader(**{ 'command': 8 })
        self.__field_header.readfrombuffer(buf)
        self.__field_unknown=UINT(**{'sizeinbytes': 4, 'constant': 0x000100ff})
        self.__field_unknown.readfrombuffer(buf)
        self.__field_date=UINT(**{'sizeinbytes': 4})
        self.__field_date.readfrombuffer(buf)
        self.__field_filename=USTRING(**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })
        self.__field_filename.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=requestheader(**{ 'command': 8 })
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,requestheader):
            self.__field_header=value
        else:
            self.__field_header=requestheader(value,**{ 'command': 8 })

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_unknown(self):
        try: self.__field_unknown
        except:
            self.__field_unknown=UINT(**{'sizeinbytes': 4, 'constant': 0x000100ff})
        return self.__field_unknown.getvalue()

    def __setfield_unknown(self, value):
        if isinstance(value,UINT):
            self.__field_unknown=value
        else:
            self.__field_unknown=UINT(value,**{'sizeinbytes': 4, 'constant': 0x000100ff})

    def __delfield_unknown(self): del self.__field_unknown

    unknown=property(__getfield_unknown, __setfield_unknown, __delfield_unknown, "probably file attributes")

    def __getfield_date(self):
        return self.__field_date.getvalue()

    def __setfield_date(self, value):
        if isinstance(value,UINT):
            self.__field_date=value
        else:
            self.__field_date=UINT(value,**{'sizeinbytes': 4})

    def __delfield_date(self): del self.__field_date

    date=property(__getfield_date, __setfield_date, __delfield_date, None)

    def __getfield_filename(self):
        return self.__field_filename.getvalue()

    def __setfield_filename(self, value):
        if isinstance(value,USTRING):
            self.__field_filename=value
        else:
            self.__field_filename=USTRING(value,**{'terminator': 0, 'pascal': True,               'encoding': PHONE_ENCODING })

    def __delfield_filename(self): del self.__field_filename

    filename=property(__getfield_filename, __setfield_filename, __delfield_filename, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('unknown', self.__field_unknown, "probably file attributes")
        yield ('date', self.__field_date, None)
        yield ('filename', self.__field_filename, None)




class data(BaseProtogenClass):
    __fields=['bytes']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(data,self).__init__(**dict)
        if self.__class__ is data:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(data,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(data,kwargs)
        if len(args):
            dict2={}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_bytes=DATA(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_bytes.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_bytes=DATA()
        self.__field_bytes.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_bytes(self):
        return self.__field_bytes.getvalue()

    def __setfield_bytes(self, value):
        if isinstance(value,DATA):
            self.__field_bytes=value
        else:
            self.__field_bytes=DATA(value,)

    def __delfield_bytes(self): del self.__field_bytes

    bytes=property(__getfield_bytes, __setfield_bytes, __delfield_bytes, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('bytes', self.__field_bytes, None)




class new_requestheader(BaseProtogenClass):
    "The bit in front on all Brew request packets"
    __fields=['commandmode', 'command', 'zero']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_requestheader,self).__init__(**dict)
        if self.__class__ is new_requestheader:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_requestheader,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_requestheader,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_commandmode
        except:
            self.__field_commandmode=UINT(**{'sizeinbytes': 2, 'constant': 0x134B})
        self.__field_commandmode.writetobuffer(buf)
        self.__field_command.writetobuffer(buf)
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 1, 'constant': 0})
        self.__field_zero.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_commandmode=UINT(**{'sizeinbytes': 2, 'constant': 0x134B})
        self.__field_commandmode.readfrombuffer(buf)
        self.__field_command=UINT(**{'sizeinbytes': 1})
        self.__field_command.readfrombuffer(buf)
        self.__field_zero=UINT(**{'sizeinbytes': 1, 'constant': 0})
        self.__field_zero.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_commandmode(self):
        try: self.__field_commandmode
        except:
            self.__field_commandmode=UINT(**{'sizeinbytes': 2, 'constant': 0x134B})
        return self.__field_commandmode.getvalue()

    def __setfield_commandmode(self, value):
        if isinstance(value,UINT):
            self.__field_commandmode=value
        else:
            self.__field_commandmode=UINT(value,**{'sizeinbytes': 2, 'constant': 0x134B})

    def __delfield_commandmode(self): del self.__field_commandmode

    commandmode=property(__getfield_commandmode, __setfield_commandmode, __delfield_commandmode, None)

    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_zero(self):
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 1, 'constant': 0})
        return self.__field_zero.getvalue()

    def __setfield_zero(self, value):
        if isinstance(value,UINT):
            self.__field_zero=value
        else:
            self.__field_zero=UINT(value,**{'sizeinbytes': 1, 'constant': 0})

    def __delfield_zero(self): del self.__field_zero

    zero=property(__getfield_zero, __setfield_zero, __delfield_zero, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('commandmode', self.__field_commandmode, None)
        yield ('command', self.__field_command, None)
        yield ('zero', self.__field_zero, None)




class new_responseheader(BaseProtogenClass):
    "The bit in front on all Brew response packets"
    __fields=['commandmode', 'command', 'zero']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_responseheader,self).__init__(**dict)
        if self.__class__ is new_responseheader:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_responseheader,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_responseheader,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_commandmode.writetobuffer(buf)
        self.__field_command.writetobuffer(buf)
        self.__field_zero.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_commandmode=UINT(**{'sizeinbytes': 2, 'constant': 0x134B})
        self.__field_commandmode.readfrombuffer(buf)
        self.__field_command=UINT(**{'sizeinbytes': 1})
        self.__field_command.readfrombuffer(buf)
        self.__field_zero=UINT(**{'sizeinbytes': 1})
        self.__field_zero.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_commandmode(self):
        return self.__field_commandmode.getvalue()

    def __setfield_commandmode(self, value):
        if isinstance(value,UINT):
            self.__field_commandmode=value
        else:
            self.__field_commandmode=UINT(value,**{'sizeinbytes': 2, 'constant': 0x134B})

    def __delfield_commandmode(self): del self.__field_commandmode

    commandmode=property(__getfield_commandmode, __setfield_commandmode, __delfield_commandmode, None)

    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_zero(self):
        return self.__field_zero.getvalue()

    def __setfield_zero(self, value):
        if isinstance(value,UINT):
            self.__field_zero=value
        else:
            self.__field_zero=UINT(value,**{'sizeinbytes': 1})

    def __delfield_zero(self): del self.__field_zero

    zero=property(__getfield_zero, __setfield_zero, __delfield_zero, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('commandmode', self.__field_commandmode, None)
        yield ('command', self.__field_command, None)
        yield ('zero', self.__field_zero, None)




class new_openfilerequest(BaseProtogenClass):
    __fields=['header', 'mode', 'flags', 'filename']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_openfilerequest,self).__init__(**dict)
        if self.__class__ is new_openfilerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_openfilerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_openfilerequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x02})
        self.__field_header.writetobuffer(buf)
        self.__field_mode.writetobuffer(buf)
        self.__field_flags.writetobuffer(buf)
        self.__field_filename.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_requestheader(**{'command': 0x02})
        self.__field_header.readfrombuffer(buf)
        self.__field_mode=UINT(**{'sizeinbytes': 4})
        self.__field_mode.readfrombuffer(buf)
        self.__field_flags=UINT(**{'sizeinbytes': 4})
        self.__field_flags.readfrombuffer(buf)
        self.__field_filename=USTRING(**{'terminator': 0,               'encoding': PHONE_ENCODING })
        self.__field_filename.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x02})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_requestheader):
            self.__field_header=value
        else:
            self.__field_header=new_requestheader(value,**{'command': 0x02})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_mode(self):
        return self.__field_mode.getvalue()

    def __setfield_mode(self, value):
        if isinstance(value,UINT):
            self.__field_mode=value
        else:
            self.__field_mode=UINT(value,**{'sizeinbytes': 4})

    def __delfield_mode(self): del self.__field_mode

    mode=property(__getfield_mode, __setfield_mode, __delfield_mode, None)

    def __getfield_flags(self):
        return self.__field_flags.getvalue()

    def __setfield_flags(self, value):
        if isinstance(value,UINT):
            self.__field_flags=value
        else:
            self.__field_flags=UINT(value,**{'sizeinbytes': 4})

    def __delfield_flags(self): del self.__field_flags

    flags=property(__getfield_flags, __setfield_flags, __delfield_flags, None)

    def __getfield_filename(self):
        return self.__field_filename.getvalue()

    def __setfield_filename(self, value):
        if isinstance(value,USTRING):
            self.__field_filename=value
        else:
            self.__field_filename=USTRING(value,**{'terminator': 0,               'encoding': PHONE_ENCODING })

    def __delfield_filename(self): del self.__field_filename

    filename=property(__getfield_filename, __setfield_filename, __delfield_filename, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('mode', self.__field_mode, None)
        yield ('flags', self.__field_flags, None)
        yield ('filename', self.__field_filename, None)




class new_openfileresponse(BaseProtogenClass):
    __fields=['header', 'handle', 'error']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_openfileresponse,self).__init__(**dict)
        if self.__class__ is new_openfileresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_openfileresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_openfileresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_handle.writetobuffer(buf)
        self.__field_error.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_handle=UINT(**{'sizeinbytes': 4})
        self.__field_handle.readfrombuffer(buf)
        self.__field_error=UINT(**{'sizeinbytes': 4})
        self.__field_error.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_responseheader):
            self.__field_header=value
        else:
            self.__field_header=new_responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_handle(self):
        return self.__field_handle.getvalue()

    def __setfield_handle(self, value):
        if isinstance(value,UINT):
            self.__field_handle=value
        else:
            self.__field_handle=UINT(value,**{'sizeinbytes': 4})

    def __delfield_handle(self): del self.__field_handle

    handle=property(__getfield_handle, __setfield_handle, __delfield_handle, None)

    def __getfield_error(self):
        return self.__field_error.getvalue()

    def __setfield_error(self, value):
        if isinstance(value,UINT):
            self.__field_error=value
        else:
            self.__field_error=UINT(value,**{'sizeinbytes': 4})

    def __delfield_error(self): del self.__field_error

    error=property(__getfield_error, __setfield_error, __delfield_error, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('handle', self.__field_handle, None)
        yield ('error', self.__field_error, None)




class new_closefilerequest(BaseProtogenClass):
    __fields=['header', 'handle']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_closefilerequest,self).__init__(**dict)
        if self.__class__ is new_closefilerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_closefilerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_closefilerequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x03})
        self.__field_header.writetobuffer(buf)
        self.__field_handle.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_requestheader(**{'command': 0x03})
        self.__field_header.readfrombuffer(buf)
        self.__field_handle=UINT(**{'sizeinbytes': 4})
        self.__field_handle.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x03})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_requestheader):
            self.__field_header=value
        else:
            self.__field_header=new_requestheader(value,**{'command': 0x03})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_handle(self):
        return self.__field_handle.getvalue()

    def __setfield_handle(self, value):
        if isinstance(value,UINT):
            self.__field_handle=value
        else:
            self.__field_handle=UINT(value,**{'sizeinbytes': 4})

    def __delfield_handle(self): del self.__field_handle

    handle=property(__getfield_handle, __setfield_handle, __delfield_handle, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('handle', self.__field_handle, None)




class new_closefileresponse(BaseProtogenClass):
    __fields=['header', 'error']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_closefileresponse,self).__init__(**dict)
        if self.__class__ is new_closefileresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_closefileresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_closefileresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_error.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_error=UINT(**{'sizeinbytes': 4})
        self.__field_error.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_responseheader):
            self.__field_header=value
        else:
            self.__field_header=new_responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_error(self):
        return self.__field_error.getvalue()

    def __setfield_error(self, value):
        if isinstance(value,UINT):
            self.__field_error=value
        else:
            self.__field_error=UINT(value,**{'sizeinbytes': 4})

    def __delfield_error(self): del self.__field_error

    error=property(__getfield_error, __setfield_error, __delfield_error, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('error', self.__field_error, None)




class new_readfilerequest(BaseProtogenClass):
    __fields=['header', 'handle', 'bytes', 'position']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_readfilerequest,self).__init__(**dict)
        if self.__class__ is new_readfilerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_readfilerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_readfilerequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x04})
        self.__field_header.writetobuffer(buf)
        self.__field_handle.writetobuffer(buf)
        self.__field_bytes.writetobuffer(buf)
        self.__field_position.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_requestheader(**{'command': 0x04})
        self.__field_header.readfrombuffer(buf)
        self.__field_handle=UINT(**{'sizeinbytes': 4})
        self.__field_handle.readfrombuffer(buf)
        self.__field_bytes=UINT(**{'sizeinbytes': 4})
        self.__field_bytes.readfrombuffer(buf)
        self.__field_position=UINT(**{'sizeinbytes': 4})
        self.__field_position.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x04})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_requestheader):
            self.__field_header=value
        else:
            self.__field_header=new_requestheader(value,**{'command': 0x04})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_handle(self):
        return self.__field_handle.getvalue()

    def __setfield_handle(self, value):
        if isinstance(value,UINT):
            self.__field_handle=value
        else:
            self.__field_handle=UINT(value,**{'sizeinbytes': 4})

    def __delfield_handle(self): del self.__field_handle

    handle=property(__getfield_handle, __setfield_handle, __delfield_handle, None)

    def __getfield_bytes(self):
        return self.__field_bytes.getvalue()

    def __setfield_bytes(self, value):
        if isinstance(value,UINT):
            self.__field_bytes=value
        else:
            self.__field_bytes=UINT(value,**{'sizeinbytes': 4})

    def __delfield_bytes(self): del self.__field_bytes

    bytes=property(__getfield_bytes, __setfield_bytes, __delfield_bytes, None)

    def __getfield_position(self):
        return self.__field_position.getvalue()

    def __setfield_position(self, value):
        if isinstance(value,UINT):
            self.__field_position=value
        else:
            self.__field_position=UINT(value,**{'sizeinbytes': 4})

    def __delfield_position(self): del self.__field_position

    position=property(__getfield_position, __setfield_position, __delfield_position, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('handle', self.__field_handle, None)
        yield ('bytes', self.__field_bytes, None)
        yield ('position', self.__field_position, None)




class new_readfileresponse(BaseProtogenClass):
    __fields=['header', 'handle', 'position', 'bytes', 'error', 'data']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_readfileresponse,self).__init__(**dict)
        if self.__class__ is new_readfileresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_readfileresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_readfileresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_handle.writetobuffer(buf)
        self.__field_position.writetobuffer(buf)
        self.__field_bytes.writetobuffer(buf)
        self.__field_error.writetobuffer(buf)
        self.__field_data.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_handle=UINT(**{'sizeinbytes': 4})
        self.__field_handle.readfrombuffer(buf)
        self.__field_position=UINT(**{'sizeinbytes': 4})
        self.__field_position.readfrombuffer(buf)
        self.__field_bytes=UINT(**{'sizeinbytes': 4})
        self.__field_bytes.readfrombuffer(buf)
        self.__field_error=UINT(**{'sizeinbytes': 4})
        self.__field_error.readfrombuffer(buf)
        self.__field_data=DATA(**{'sizeinbytes': self.bytes})
        self.__field_data.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_responseheader):
            self.__field_header=value
        else:
            self.__field_header=new_responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_handle(self):
        return self.__field_handle.getvalue()

    def __setfield_handle(self, value):
        if isinstance(value,UINT):
            self.__field_handle=value
        else:
            self.__field_handle=UINT(value,**{'sizeinbytes': 4})

    def __delfield_handle(self): del self.__field_handle

    handle=property(__getfield_handle, __setfield_handle, __delfield_handle, None)

    def __getfield_position(self):
        return self.__field_position.getvalue()

    def __setfield_position(self, value):
        if isinstance(value,UINT):
            self.__field_position=value
        else:
            self.__field_position=UINT(value,**{'sizeinbytes': 4})

    def __delfield_position(self): del self.__field_position

    position=property(__getfield_position, __setfield_position, __delfield_position, None)

    def __getfield_bytes(self):
        return self.__field_bytes.getvalue()

    def __setfield_bytes(self, value):
        if isinstance(value,UINT):
            self.__field_bytes=value
        else:
            self.__field_bytes=UINT(value,**{'sizeinbytes': 4})

    def __delfield_bytes(self): del self.__field_bytes

    bytes=property(__getfield_bytes, __setfield_bytes, __delfield_bytes, None)

    def __getfield_error(self):
        return self.__field_error.getvalue()

    def __setfield_error(self, value):
        if isinstance(value,UINT):
            self.__field_error=value
        else:
            self.__field_error=UINT(value,**{'sizeinbytes': 4})

    def __delfield_error(self): del self.__field_error

    error=property(__getfield_error, __setfield_error, __delfield_error, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,**{'sizeinbytes': self.bytes})

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('handle', self.__field_handle, None)
        yield ('position', self.__field_position, None)
        yield ('bytes', self.__field_bytes, None)
        yield ('error', self.__field_error, None)
        yield ('data', self.__field_data, None)




class new_writefilerequest(BaseProtogenClass):
    __fields=['header', 'handle', 'position', 'bytes', 'data']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_writefilerequest,self).__init__(**dict)
        if self.__class__ is new_writefilerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_writefilerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_writefilerequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_bytes
        except:
            self.__field_bytes=UINT()


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x05})
        self.__field_header.writetobuffer(buf)
        self.__field_handle.writetobuffer(buf)
        self.__field_position.writetobuffer(buf)
        self.__field_data.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_requestheader(**{'command': 0x05})
        self.__field_header.readfrombuffer(buf)
        self.__field_handle=UINT(**{'sizeinbytes': 4})
        self.__field_handle.readfrombuffer(buf)
        self.__field_position=UINT(**{'sizeinbytes': 4})
        self.__field_position.readfrombuffer(buf)
        self.__field_data=DATA(**{'sizeinbytes': self.bytes})
        self.__field_data.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x05})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_requestheader):
            self.__field_header=value
        else:
            self.__field_header=new_requestheader(value,**{'command': 0x05})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_handle(self):
        return self.__field_handle.getvalue()

    def __setfield_handle(self, value):
        if isinstance(value,UINT):
            self.__field_handle=value
        else:
            self.__field_handle=UINT(value,**{'sizeinbytes': 4})

    def __delfield_handle(self): del self.__field_handle

    handle=property(__getfield_handle, __setfield_handle, __delfield_handle, None)

    def __getfield_position(self):
        return self.__field_position.getvalue()

    def __setfield_position(self, value):
        if isinstance(value,UINT):
            self.__field_position=value
        else:
            self.__field_position=UINT(value,**{'sizeinbytes': 4})

    def __delfield_position(self): del self.__field_position

    position=property(__getfield_position, __setfield_position, __delfield_position, None)

    def __getfield_bytes(self):
        return self.__field_bytes.getvalue()

    def __setfield_bytes(self, value):
        if isinstance(value,UINT):
            self.__field_bytes=value
        else:
            self.__field_bytes=UINT(value,)

    def __delfield_bytes(self): del self.__field_bytes

    bytes=property(__getfield_bytes, __setfield_bytes, __delfield_bytes, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,**{'sizeinbytes': self.bytes})

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('handle', self.__field_handle, None)
        yield ('position', self.__field_position, None)
        yield ('bytes', self.__field_bytes, None)
        yield ('data', self.__field_data, None)




class new_writefileresponse(BaseProtogenClass):
    __fields=['header', 'handle', 'position', 'bytes', 'error']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_writefileresponse,self).__init__(**dict)
        if self.__class__ is new_writefileresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_writefileresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_writefileresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_handle.writetobuffer(buf)
        self.__field_position.writetobuffer(buf)
        self.__field_bytes.writetobuffer(buf)
        self.__field_error.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_handle=UINT(**{'sizeinbytes': 4})
        self.__field_handle.readfrombuffer(buf)
        self.__field_position=UINT(**{'sizeinbytes': 4})
        self.__field_position.readfrombuffer(buf)
        self.__field_bytes=UINT(**{'sizeinbytes': 4})
        self.__field_bytes.readfrombuffer(buf)
        self.__field_error=UINT(**{'sizeinbytes': 4})
        self.__field_error.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_responseheader):
            self.__field_header=value
        else:
            self.__field_header=new_responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_handle(self):
        return self.__field_handle.getvalue()

    def __setfield_handle(self, value):
        if isinstance(value,UINT):
            self.__field_handle=value
        else:
            self.__field_handle=UINT(value,**{'sizeinbytes': 4})

    def __delfield_handle(self): del self.__field_handle

    handle=property(__getfield_handle, __setfield_handle, __delfield_handle, None)

    def __getfield_position(self):
        return self.__field_position.getvalue()

    def __setfield_position(self, value):
        if isinstance(value,UINT):
            self.__field_position=value
        else:
            self.__field_position=UINT(value,**{'sizeinbytes': 4})

    def __delfield_position(self): del self.__field_position

    position=property(__getfield_position, __setfield_position, __delfield_position, None)

    def __getfield_bytes(self):
        return self.__field_bytes.getvalue()

    def __setfield_bytes(self, value):
        if isinstance(value,UINT):
            self.__field_bytes=value
        else:
            self.__field_bytes=UINT(value,**{'sizeinbytes': 4})

    def __delfield_bytes(self): del self.__field_bytes

    bytes=property(__getfield_bytes, __setfield_bytes, __delfield_bytes, None)

    def __getfield_error(self):
        return self.__field_error.getvalue()

    def __setfield_error(self, value):
        if isinstance(value,UINT):
            self.__field_error=value
        else:
            self.__field_error=UINT(value,**{'sizeinbytes': 4})

    def __delfield_error(self): del self.__field_error

    error=property(__getfield_error, __setfield_error, __delfield_error, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('handle', self.__field_handle, None)
        yield ('position', self.__field_position, None)
        yield ('bytes', self.__field_bytes, None)
        yield ('error', self.__field_error, None)




class new_rmfilerequest(BaseProtogenClass):
    """Remove file, full path should be provided, 
    but the root character / is not required at the start of the name.
    """
    __fields=['header', 'filename', 'dunno']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_rmfilerequest,self).__init__(**dict)
        if self.__class__ is new_rmfilerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_rmfilerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_rmfilerequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x08})
        self.__field_header.writetobuffer(buf)
        self.__field_filename.writetobuffer(buf)
        try: self.__field_dunno
        except:
            self.__field_dunno=UINT(**{'sizeinbytes': 1, 'constant':1})
        self.__field_dunno.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_requestheader(**{'command': 0x08})
        self.__field_header.readfrombuffer(buf)
        self.__field_filename=USTRING(**{'terminator': 0,               'encoding': PHONE_ENCODING })
        self.__field_filename.readfrombuffer(buf)
        self.__field_dunno=UINT(**{'sizeinbytes': 1, 'constant':1})
        self.__field_dunno.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x08})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_requestheader):
            self.__field_header=value
        else:
            self.__field_header=new_requestheader(value,**{'command': 0x08})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_filename(self):
        return self.__field_filename.getvalue()

    def __setfield_filename(self, value):
        if isinstance(value,USTRING):
            self.__field_filename=value
        else:
            self.__field_filename=USTRING(value,**{'terminator': 0,               'encoding': PHONE_ENCODING })

    def __delfield_filename(self): del self.__field_filename

    filename=property(__getfield_filename, __setfield_filename, __delfield_filename, None)

    def __getfield_dunno(self):
        try: self.__field_dunno
        except:
            self.__field_dunno=UINT(**{'sizeinbytes': 1, 'constant':1})
        return self.__field_dunno.getvalue()

    def __setfield_dunno(self, value):
        if isinstance(value,UINT):
            self.__field_dunno=value
        else:
            self.__field_dunno=UINT(value,**{'sizeinbytes': 1, 'constant':1})

    def __delfield_dunno(self): del self.__field_dunno

    dunno=property(__getfield_dunno, __setfield_dunno, __delfield_dunno, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('filename', self.__field_filename, None)
        yield ('dunno', self.__field_dunno, None)




class new_mkdirrequest(BaseProtogenClass):
    """Make a new directory, full path of the new directory should be
    provided, but the root character / is not required at the start of the name
    """
    __fields=['header', 'mode', 'dirname']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_mkdirrequest,self).__init__(**dict)
        if self.__class__ is new_mkdirrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_mkdirrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_mkdirrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x09})
        self.__field_header.writetobuffer(buf)
        try: self.__field_mode
        except:
            self.__field_mode=UINT(**{'sizeinbytes': 2, 'constant': 0x01ff})
        self.__field_mode.writetobuffer(buf)
        self.__field_dirname.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_requestheader(**{'command': 0x09})
        self.__field_header.readfrombuffer(buf)
        self.__field_mode=UINT(**{'sizeinbytes': 2, 'constant': 0x01ff})
        self.__field_mode.readfrombuffer(buf)
        self.__field_dirname=USTRING(**{'terminator': 0,               'encoding': PHONE_ENCODING })
        self.__field_dirname.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x09})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_requestheader):
            self.__field_header=value
        else:
            self.__field_header=new_requestheader(value,**{'command': 0x09})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_mode(self):
        try: self.__field_mode
        except:
            self.__field_mode=UINT(**{'sizeinbytes': 2, 'constant': 0x01ff})
        return self.__field_mode.getvalue()

    def __setfield_mode(self, value):
        if isinstance(value,UINT):
            self.__field_mode=value
        else:
            self.__field_mode=UINT(value,**{'sizeinbytes': 2, 'constant': 0x01ff})

    def __delfield_mode(self): del self.__field_mode

    mode=property(__getfield_mode, __setfield_mode, __delfield_mode, None)

    def __getfield_dirname(self):
        return self.__field_dirname.getvalue()

    def __setfield_dirname(self, value):
        if isinstance(value,USTRING):
            self.__field_dirname=value
        else:
            self.__field_dirname=USTRING(value,**{'terminator': 0,               'encoding': PHONE_ENCODING })

    def __delfield_dirname(self): del self.__field_dirname

    dirname=property(__getfield_dirname, __setfield_dirname, __delfield_dirname, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('mode', self.__field_mode, None)
        yield ('dirname', self.__field_dirname, None)




class new_rmdirrequest(BaseProtogenClass):
    """Remove directory, full path should be provided, but the
    root character / is not required at the start of the name.
    """
    __fields=['header', 'dirname']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_rmdirrequest,self).__init__(**dict)
        if self.__class__ is new_rmdirrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_rmdirrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_rmdirrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x0a})
        self.__field_header.writetobuffer(buf)
        self.__field_dirname.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_requestheader(**{'command': 0x0a})
        self.__field_header.readfrombuffer(buf)
        self.__field_dirname=USTRING(**{'terminator': 0,               'encoding': PHONE_ENCODING })
        self.__field_dirname.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x0a})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_requestheader):
            self.__field_header=value
        else:
            self.__field_header=new_requestheader(value,**{'command': 0x0a})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_dirname(self):
        return self.__field_dirname.getvalue()

    def __setfield_dirname(self, value):
        if isinstance(value,USTRING):
            self.__field_dirname=value
        else:
            self.__field_dirname=USTRING(value,**{'terminator': 0,               'encoding': PHONE_ENCODING })

    def __delfield_dirname(self): del self.__field_dirname

    dirname=property(__getfield_dirname, __setfield_dirname, __delfield_dirname, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('dirname', self.__field_dirname, None)




class new_opendirectoryrequest(BaseProtogenClass):
    __fields=['header', 'dirname']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_opendirectoryrequest,self).__init__(**dict)
        if self.__class__ is new_opendirectoryrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_opendirectoryrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_opendirectoryrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x0b})
        self.__field_header.writetobuffer(buf)
        self.__field_dirname.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_requestheader(**{'command': 0x0b})
        self.__field_header.readfrombuffer(buf)
        self.__field_dirname=USTRING(**{'terminator': 0,               'encoding': PHONE_ENCODING })
        self.__field_dirname.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x0b})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_requestheader):
            self.__field_header=value
        else:
            self.__field_header=new_requestheader(value,**{'command': 0x0b})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_dirname(self):
        return self.__field_dirname.getvalue()

    def __setfield_dirname(self, value):
        if isinstance(value,USTRING):
            self.__field_dirname=value
        else:
            self.__field_dirname=USTRING(value,**{'terminator': 0,               'encoding': PHONE_ENCODING })

    def __delfield_dirname(self): del self.__field_dirname

    dirname=property(__getfield_dirname, __setfield_dirname, __delfield_dirname, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('dirname', self.__field_dirname, None)




class new_opendirectoryresponse(BaseProtogenClass):
    __fields=['header', 'handle', 'error']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_opendirectoryresponse,self).__init__(**dict)
        if self.__class__ is new_opendirectoryresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_opendirectoryresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_opendirectoryresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_handle.writetobuffer(buf)
        self.__field_error.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_handle=UINT(**{'sizeinbytes': 4})
        self.__field_handle.readfrombuffer(buf)
        self.__field_error=UINT(**{'sizeinbytes': 4})
        self.__field_error.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_responseheader):
            self.__field_header=value
        else:
            self.__field_header=new_responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_handle(self):
        return self.__field_handle.getvalue()

    def __setfield_handle(self, value):
        if isinstance(value,UINT):
            self.__field_handle=value
        else:
            self.__field_handle=UINT(value,**{'sizeinbytes': 4})

    def __delfield_handle(self): del self.__field_handle

    handle=property(__getfield_handle, __setfield_handle, __delfield_handle, None)

    def __getfield_error(self):
        return self.__field_error.getvalue()

    def __setfield_error(self, value):
        if isinstance(value,UINT):
            self.__field_error=value
        else:
            self.__field_error=UINT(value,**{'sizeinbytes': 4})

    def __delfield_error(self): del self.__field_error

    error=property(__getfield_error, __setfield_error, __delfield_error, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('handle', self.__field_handle, None)
        yield ('error', self.__field_error, None)




class new_listentryrequest(BaseProtogenClass):
    __fields=['header', 'handle', 'entrynumber']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_listentryrequest,self).__init__(**dict)
        if self.__class__ is new_listentryrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_listentryrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_listentryrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x0c})
        self.__field_header.writetobuffer(buf)
        self.__field_handle.writetobuffer(buf)
        self.__field_entrynumber.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_requestheader(**{'command': 0x0c})
        self.__field_header.readfrombuffer(buf)
        self.__field_handle=UINT(**{'sizeinbytes': 4})
        self.__field_handle.readfrombuffer(buf)
        self.__field_entrynumber=UINT(**{'sizeinbytes': 4})
        self.__field_entrynumber.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x0c})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_requestheader):
            self.__field_header=value
        else:
            self.__field_header=new_requestheader(value,**{'command': 0x0c})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_handle(self):
        return self.__field_handle.getvalue()

    def __setfield_handle(self, value):
        if isinstance(value,UINT):
            self.__field_handle=value
        else:
            self.__field_handle=UINT(value,**{'sizeinbytes': 4})

    def __delfield_handle(self): del self.__field_handle

    handle=property(__getfield_handle, __setfield_handle, __delfield_handle, None)

    def __getfield_entrynumber(self):
        return self.__field_entrynumber.getvalue()

    def __setfield_entrynumber(self, value):
        if isinstance(value,UINT):
            self.__field_entrynumber=value
        else:
            self.__field_entrynumber=UINT(value,**{'sizeinbytes': 4})

    def __delfield_entrynumber(self): del self.__field_entrynumber

    entrynumber=property(__getfield_entrynumber, __setfield_entrynumber, __delfield_entrynumber, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('handle', self.__field_handle, None)
        yield ('entrynumber', self.__field_entrynumber, None)




class new_listentryresponse(BaseProtogenClass):
    __fields=['header', 'handle', 'entrynumber', 'pad1', 'type', 'mode', 'size', 'pad2', 'date', 'entryname']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_listentryresponse,self).__init__(**dict)
        if self.__class__ is new_listentryresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_listentryresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_listentryresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_handle.writetobuffer(buf)
        self.__field_entrynumber.writetobuffer(buf)
        self.__field_pad1.writetobuffer(buf)
        self.__field_type.writetobuffer(buf)
        self.__field_mode.writetobuffer(buf)
        self.__field_size.writetobuffer(buf)
        self.__field_pad2.writetobuffer(buf)
        self.__field_date.writetobuffer(buf)
        self.__field_entryname.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_handle=UINT(**{'sizeinbytes': 4})
        self.__field_handle.readfrombuffer(buf)
        self.__field_entrynumber=UINT(**{'sizeinbytes': 4})
        self.__field_entrynumber.readfrombuffer(buf)
        self.__field_pad1=UINT(**{'sizeinbytes': 4})
        self.__field_pad1.readfrombuffer(buf)
        self.__field_type=UINT(**{'sizeinbytes': 4})
        self.__field_type.readfrombuffer(buf)
        self.__field_mode=UINT(**{'sizeinbytes': 4})
        self.__field_mode.readfrombuffer(buf)
        self.__field_size=UINT(**{'sizeinbytes': 4})
        self.__field_size.readfrombuffer(buf)
        self.__field_pad2=UINT(**{'sizeinbytes': 8})
        self.__field_pad2.readfrombuffer(buf)
        self.__field_date=UINT(**{'sizeinbytes': 4})
        self.__field_date.readfrombuffer(buf)
        self.__field_entryname=USTRING(**{'terminator': 0,               'encoding': PHONE_ENCODING })
        self.__field_entryname.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_responseheader):
            self.__field_header=value
        else:
            self.__field_header=new_responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_handle(self):
        return self.__field_handle.getvalue()

    def __setfield_handle(self, value):
        if isinstance(value,UINT):
            self.__field_handle=value
        else:
            self.__field_handle=UINT(value,**{'sizeinbytes': 4})

    def __delfield_handle(self): del self.__field_handle

    handle=property(__getfield_handle, __setfield_handle, __delfield_handle, None)

    def __getfield_entrynumber(self):
        return self.__field_entrynumber.getvalue()

    def __setfield_entrynumber(self, value):
        if isinstance(value,UINT):
            self.__field_entrynumber=value
        else:
            self.__field_entrynumber=UINT(value,**{'sizeinbytes': 4})

    def __delfield_entrynumber(self): del self.__field_entrynumber

    entrynumber=property(__getfield_entrynumber, __setfield_entrynumber, __delfield_entrynumber, None)

    def __getfield_pad1(self):
        return self.__field_pad1.getvalue()

    def __setfield_pad1(self, value):
        if isinstance(value,UINT):
            self.__field_pad1=value
        else:
            self.__field_pad1=UINT(value,**{'sizeinbytes': 4})

    def __delfield_pad1(self): del self.__field_pad1

    pad1=property(__getfield_pad1, __setfield_pad1, __delfield_pad1, None)

    def __getfield_type(self):
        return self.__field_type.getvalue()

    def __setfield_type(self, value):
        if isinstance(value,UINT):
            self.__field_type=value
        else:
            self.__field_type=UINT(value,**{'sizeinbytes': 4})

    def __delfield_type(self): del self.__field_type

    type=property(__getfield_type, __setfield_type, __delfield_type, None)

    def __getfield_mode(self):
        return self.__field_mode.getvalue()

    def __setfield_mode(self, value):
        if isinstance(value,UINT):
            self.__field_mode=value
        else:
            self.__field_mode=UINT(value,**{'sizeinbytes': 4})

    def __delfield_mode(self): del self.__field_mode

    mode=property(__getfield_mode, __setfield_mode, __delfield_mode, None)

    def __getfield_size(self):
        return self.__field_size.getvalue()

    def __setfield_size(self, value):
        if isinstance(value,UINT):
            self.__field_size=value
        else:
            self.__field_size=UINT(value,**{'sizeinbytes': 4})

    def __delfield_size(self): del self.__field_size

    size=property(__getfield_size, __setfield_size, __delfield_size, None)

    def __getfield_pad2(self):
        return self.__field_pad2.getvalue()

    def __setfield_pad2(self, value):
        if isinstance(value,UINT):
            self.__field_pad2=value
        else:
            self.__field_pad2=UINT(value,**{'sizeinbytes': 8})

    def __delfield_pad2(self): del self.__field_pad2

    pad2=property(__getfield_pad2, __setfield_pad2, __delfield_pad2, None)

    def __getfield_date(self):
        return self.__field_date.getvalue()

    def __setfield_date(self, value):
        if isinstance(value,UINT):
            self.__field_date=value
        else:
            self.__field_date=UINT(value,**{'sizeinbytes': 4})

    def __delfield_date(self): del self.__field_date

    date=property(__getfield_date, __setfield_date, __delfield_date, None)

    def __getfield_entryname(self):
        return self.__field_entryname.getvalue()

    def __setfield_entryname(self, value):
        if isinstance(value,USTRING):
            self.__field_entryname=value
        else:
            self.__field_entryname=USTRING(value,**{'terminator': 0,               'encoding': PHONE_ENCODING })

    def __delfield_entryname(self): del self.__field_entryname

    entryname=property(__getfield_entryname, __setfield_entryname, __delfield_entryname, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('handle', self.__field_handle, None)
        yield ('entrynumber', self.__field_entrynumber, None)
        yield ('pad1', self.__field_pad1, None)
        yield ('type', self.__field_type, None)
        yield ('mode', self.__field_mode, None)
        yield ('size', self.__field_size, None)
        yield ('pad2', self.__field_pad2, None)
        yield ('date', self.__field_date, None)
        yield ('entryname', self.__field_entryname, None)




class new_closedirectoryrequest(BaseProtogenClass):
    __fields=['header', 'handle']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_closedirectoryrequest,self).__init__(**dict)
        if self.__class__ is new_closedirectoryrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_closedirectoryrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_closedirectoryrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x0d})
        self.__field_header.writetobuffer(buf)
        self.__field_handle.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_requestheader(**{'command': 0x0d})
        self.__field_header.readfrombuffer(buf)
        self.__field_handle=UINT(**{'sizeinbytes': 4})
        self.__field_handle.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x0d})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_requestheader):
            self.__field_header=value
        else:
            self.__field_header=new_requestheader(value,**{'command': 0x0d})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_handle(self):
        return self.__field_handle.getvalue()

    def __setfield_handle(self, value):
        if isinstance(value,UINT):
            self.__field_handle=value
        else:
            self.__field_handle=UINT(value,**{'sizeinbytes': 4})

    def __delfield_handle(self): del self.__field_handle

    handle=property(__getfield_handle, __setfield_handle, __delfield_handle, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('handle', self.__field_handle, None)




class new_closedirectoryresponse(BaseProtogenClass):
    __fields=['header', 'error']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_closedirectoryresponse,self).__init__(**dict)
        if self.__class__ is new_closedirectoryresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_closedirectoryresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_closedirectoryresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_error.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_error=UINT(**{'sizeinbytes': 4})
        self.__field_error.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_responseheader):
            self.__field_header=value
        else:
            self.__field_header=new_responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_error(self):
        return self.__field_error.getvalue()

    def __setfield_error(self, value):
        if isinstance(value,UINT):
            self.__field_error=value
        else:
            self.__field_error=UINT(value,**{'sizeinbytes': 4})

    def __delfield_error(self): del self.__field_error

    error=property(__getfield_error, __setfield_error, __delfield_error, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('error', self.__field_error, None)




class new_statfilerequest(BaseProtogenClass):
    "Get the status of the file"
    __fields=['header', 'filename']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_statfilerequest,self).__init__(**dict)
        if self.__class__ is new_statfilerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_statfilerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_statfilerequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{ 'command': 0x0f })
        self.__field_header.writetobuffer(buf)
        self.__field_filename.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_requestheader(**{ 'command': 0x0f })
        self.__field_header.readfrombuffer(buf)
        self.__field_filename=USTRING(**{'terminator': 0,               'encoding': PHONE_ENCODING })
        self.__field_filename.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{ 'command': 0x0f })
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_requestheader):
            self.__field_header=value
        else:
            self.__field_header=new_requestheader(value,**{ 'command': 0x0f })

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_filename(self):
        return self.__field_filename.getvalue()

    def __setfield_filename(self, value):
        if isinstance(value,USTRING):
            self.__field_filename=value
        else:
            self.__field_filename=USTRING(value,**{'terminator': 0,               'encoding': PHONE_ENCODING })

    def __delfield_filename(self): del self.__field_filename

    filename=property(__getfield_filename, __setfield_filename, __delfield_filename, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('filename', self.__field_filename, None)




class new_statfileresponse(BaseProtogenClass):
    __fields=['header', 'error', 'dunno', 'size', 'type', 'accessed_date', 'modified_date', 'created_date']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_statfileresponse,self).__init__(**dict)
        if self.__class__ is new_statfileresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_statfileresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_statfileresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_error.writetobuffer(buf)
        self.__field_dunno.writetobuffer(buf)
        self.__field_size.writetobuffer(buf)
        self.__field_type.writetobuffer(buf)
        self.__field_accessed_date.writetobuffer(buf)
        self.__field_modified_date.writetobuffer(buf)
        self.__field_created_date.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_error=UINT(**{'sizeinbytes': 4})
        self.__field_error.readfrombuffer(buf)
        self.__field_dunno=UNKNOWN(**{'sizeinbytes': 4})
        self.__field_dunno.readfrombuffer(buf)
        self.__field_size=UINT(**{'sizeinbytes': 4})
        self.__field_size.readfrombuffer(buf)
        self.__field_type=UINT(**{'sizeinbytes': 4})
        self.__field_type.readfrombuffer(buf)
        self.__field_accessed_date=UINT(**{'sizeinbytes': 4})
        self.__field_accessed_date.readfrombuffer(buf)
        self.__field_modified_date=UINT(**{'sizeinbytes': 4})
        self.__field_modified_date.readfrombuffer(buf)
        self.__field_created_date=UINT(**{'sizeinbytes': 4})
        self.__field_created_date.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_responseheader):
            self.__field_header=value
        else:
            self.__field_header=new_responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_error(self):
        return self.__field_error.getvalue()

    def __setfield_error(self, value):
        if isinstance(value,UINT):
            self.__field_error=value
        else:
            self.__field_error=UINT(value,**{'sizeinbytes': 4})

    def __delfield_error(self): del self.__field_error

    error=property(__getfield_error, __setfield_error, __delfield_error, None)

    def __getfield_dunno(self):
        return self.__field_dunno.getvalue()

    def __setfield_dunno(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno=value
        else:
            self.__field_dunno=UNKNOWN(value,**{'sizeinbytes': 4})

    def __delfield_dunno(self): del self.__field_dunno

    dunno=property(__getfield_dunno, __setfield_dunno, __delfield_dunno, None)

    def __getfield_size(self):
        return self.__field_size.getvalue()

    def __setfield_size(self, value):
        if isinstance(value,UINT):
            self.__field_size=value
        else:
            self.__field_size=UINT(value,**{'sizeinbytes': 4})

    def __delfield_size(self): del self.__field_size

    size=property(__getfield_size, __setfield_size, __delfield_size, None)

    def __getfield_type(self):
        return self.__field_type.getvalue()

    def __setfield_type(self, value):
        if isinstance(value,UINT):
            self.__field_type=value
        else:
            self.__field_type=UINT(value,**{'sizeinbytes': 4})

    def __delfield_type(self): del self.__field_type

    type=property(__getfield_type, __setfield_type, __delfield_type, None)

    def __getfield_accessed_date(self):
        return self.__field_accessed_date.getvalue()

    def __setfield_accessed_date(self, value):
        if isinstance(value,UINT):
            self.__field_accessed_date=value
        else:
            self.__field_accessed_date=UINT(value,**{'sizeinbytes': 4})

    def __delfield_accessed_date(self): del self.__field_accessed_date

    accessed_date=property(__getfield_accessed_date, __setfield_accessed_date, __delfield_accessed_date, None)

    def __getfield_modified_date(self):
        return self.__field_modified_date.getvalue()

    def __setfield_modified_date(self, value):
        if isinstance(value,UINT):
            self.__field_modified_date=value
        else:
            self.__field_modified_date=UINT(value,**{'sizeinbytes': 4})

    def __delfield_modified_date(self): del self.__field_modified_date

    modified_date=property(__getfield_modified_date, __setfield_modified_date, __delfield_modified_date, None)

    def __getfield_created_date(self):
        return self.__field_created_date.getvalue()

    def __setfield_created_date(self, value):
        if isinstance(value,UINT):
            self.__field_created_date=value
        else:
            self.__field_created_date=UINT(value,**{'sizeinbytes': 4})

    def __delfield_created_date(self): del self.__field_created_date

    created_date=property(__getfield_created_date, __setfield_created_date, __delfield_created_date, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('error', self.__field_error, None)
        yield ('dunno', self.__field_dunno, None)
        yield ('size', self.__field_size, None)
        yield ('type', self.__field_type, None)
        yield ('accessed_date', self.__field_accessed_date, None)
        yield ('modified_date', self.__field_modified_date, None)
        yield ('created_date', self.__field_created_date, None)




class new_chmodrequest(BaseProtogenClass):
    __fields=['header', 'mode', 'filename']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_chmodrequest,self).__init__(**dict)
        if self.__class__ is new_chmodrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_chmodrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_chmodrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x12})
        self.__field_header.writetobuffer(buf)
        try: self.__field_mode
        except:
            self.__field_mode=UINT(**{'sizeinbytes': 2})
        self.__field_mode.writetobuffer(buf)
        try: self.__field_filename
        except:
            self.__field_filename=USTRING(**{'terminator': 0, 'encoding': PHONE_ENCODING })
        self.__field_filename.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_requestheader(**{'command': 0x12})
        self.__field_header.readfrombuffer(buf)
        self.__field_mode=UINT(**{'sizeinbytes': 2})
        self.__field_mode.readfrombuffer(buf)
        self.__field_filename=USTRING(**{'terminator': 0, 'encoding': PHONE_ENCODING })
        self.__field_filename.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x12})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_requestheader):
            self.__field_header=value
        else:
            self.__field_header=new_requestheader(value,**{'command': 0x12})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_mode(self):
        try: self.__field_mode
        except:
            self.__field_mode=UINT(**{'sizeinbytes': 2})
        return self.__field_mode.getvalue()

    def __setfield_mode(self, value):
        if isinstance(value,UINT):
            self.__field_mode=value
        else:
            self.__field_mode=UINT(value,**{'sizeinbytes': 2})

    def __delfield_mode(self): del self.__field_mode

    mode=property(__getfield_mode, __setfield_mode, __delfield_mode, None)

    def __getfield_filename(self):
        try: self.__field_filename
        except:
            self.__field_filename=USTRING(**{'terminator': 0, 'encoding': PHONE_ENCODING })
        return self.__field_filename.getvalue()

    def __setfield_filename(self, value):
        if isinstance(value,USTRING):
            self.__field_filename=value
        else:
            self.__field_filename=USTRING(value,**{'terminator': 0, 'encoding': PHONE_ENCODING })

    def __delfield_filename(self): del self.__field_filename

    filename=property(__getfield_filename, __setfield_filename, __delfield_filename, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('mode', self.__field_mode, None)
        yield ('filename', self.__field_filename, None)




class new_chmodresponse(BaseProtogenClass):
    __fields=['header', 'error']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_chmodresponse,self).__init__(**dict)
        if self.__class__ is new_chmodresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_chmodresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_chmodresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_error.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_error=UINT(**{'sizeinbytes': 4})
        self.__field_error.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_responseheader):
            self.__field_header=value
        else:
            self.__field_header=new_responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_error(self):
        return self.__field_error.getvalue()

    def __setfield_error(self, value):
        if isinstance(value,UINT):
            self.__field_error=value
        else:
            self.__field_error=UINT(value,**{'sizeinbytes': 4})

    def __delfield_error(self): del self.__field_error

    error=property(__getfield_error, __setfield_error, __delfield_error, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('error', self.__field_error, None)




class new_reconfigfilesystemrequest(BaseProtogenClass):
    """Called after mkdir/rmdir and writing files,
    possibly a filesystem status request with space used/free etc.
    """
    __fields=['header', 'dirname']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_reconfigfilesystemrequest,self).__init__(**dict)
        if self.__class__ is new_reconfigfilesystemrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_reconfigfilesystemrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_reconfigfilesystemrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x13})
        self.__field_header.writetobuffer(buf)
        try: self.__field_dirname
        except:
            self.__field_dirname=UINT(**{'sizeinbytes': 2, 'constant': 0x002f})
        self.__field_dirname.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_requestheader(**{'command': 0x13})
        self.__field_header.readfrombuffer(buf)
        self.__field_dirname=UINT(**{'sizeinbytes': 2, 'constant': 0x002f})
        self.__field_dirname.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=new_requestheader(**{'command': 0x13})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_requestheader):
            self.__field_header=value
        else:
            self.__field_header=new_requestheader(value,**{'command': 0x13})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_dirname(self):
        try: self.__field_dirname
        except:
            self.__field_dirname=UINT(**{'sizeinbytes': 2, 'constant': 0x002f})
        return self.__field_dirname.getvalue()

    def __setfield_dirname(self, value):
        if isinstance(value,UINT):
            self.__field_dirname=value
        else:
            self.__field_dirname=UINT(value,**{'sizeinbytes': 2, 'constant': 0x002f})

    def __delfield_dirname(self): del self.__field_dirname

    dirname=property(__getfield_dirname, __setfield_dirname, __delfield_dirname, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('dirname', self.__field_dirname, None)




class new_reconfigfilesystemresponse(BaseProtogenClass):
    __fields=['header', 'unknown']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(new_reconfigfilesystemresponse,self).__init__(**dict)
        if self.__class__ is new_reconfigfilesystemresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(new_reconfigfilesystemresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(new_reconfigfilesystemresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        try: self.__field_unknown
        except:
            self.__field_unknown=UNKNOWN(**{'sizeinbytes': 44})
        self.__field_unknown.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=new_responseheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_unknown=UNKNOWN(**{'sizeinbytes': 44})
        self.__field_unknown.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,new_responseheader):
            self.__field_header=value
        else:
            self.__field_header=new_responseheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_unknown(self):
        try: self.__field_unknown
        except:
            self.__field_unknown=UNKNOWN(**{'sizeinbytes': 44})
        return self.__field_unknown.getvalue()

    def __setfield_unknown(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown=value
        else:
            self.__field_unknown=UNKNOWN(value,**{'sizeinbytes': 44})

    def __delfield_unknown(self): del self.__field_unknown

    unknown=property(__getfield_unknown, __setfield_unknown, __delfield_unknown, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('unknown', self.__field_unknown, None)




# Several responses are nothing
mkdirresponse=responseheader
rmdirresponse=responseheader
rmfileresponse=responseheader
writefileresponse=responseheader
writefileblockresponse=responseheader
setfileattrresponse=responseheader
new_mkdirresponse=new_responseheader
new_rmdirresponse=new_responseheader
new_rmfileresponse=new_responseheader
