// Copyright John Maddock 2012.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<T, 5>, 300> jacobi_large_phi = {{
      {{ SC_(-1.6098388671875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.1058797357690320086682997888107252211628291495151688601393407863373061954395848396257429511756176811e-01), SC_(-9.9386633915238026812869743952282655015178929533806734450981604274006648191113417152643248132020074274e-01), SC_(9.9990138922139577345821742312959843927086669798900631576940452344894647029651168866543336495621319962e-01) }},
      {{ SC_(-1.6098388671875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.9796027195728077189442848498661232305049387865637023002287165495702857395230146075769449539819678763e-02), SC_(-9.9980403945336507845151345500450800737097833473134761034812701539547907788852267602747381881654129683e-01), SC_(9.9999640368228571150326548705630160155372276544820513372782759452847671460675392468118278515564642670e-01) }},
      {{ SC_(-1.6098388671875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.4524463054363015830543554229266024611315133648646726829860103132985305860006657410579310878453671719e-01), SC_(-3.2636266396209619739852328880763978392918068940083223909131243802010656037702645968281828914985898722e-01), SC_(9.7793033147839850499560648584765033296353170435094191917820984988398156187728059208365609303718763468e-01) }},
      {{ SC_(-1.6098388671875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.8467092829206275416395221453254971947309775360749050985209931262282264520459122402381792953068010283e-02), SC_(9.9925986748656589242807594841179280186636858779886436718703277243900358292074844422479042190466225049e-01), SC_(9.9992973546117087872258976240789404601766963067622683679015332787486976781350082685530756477017893531e-01) }},
      {{ SC_(-1.6098388671875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1828487869642382837142082205368890409594444563859603885036504087100530651689815737374300479572152806e-01), SC_(-5.7481288894454945115324043802657481607935129579981996144467071525751961910351319915758240211691782206e-01), SC_(8.5571342814553735162229894739444873282853333740663537333659164564589208017713251914590680386027272809e-01) }},
      {{ SC_(-1.6098388671875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.0342555778181684908553725700040860110642531214149151205515131896190048290879021057059409802362096946e-01), SC_(5.9540521756445540531188114127706021212880690887199697020660799772318324844598317460087416642725615927e-01), SC_(7.5600167963587697285196939810169457229824831904454088987922148028116675585554507425145383067593756070e-01) }},
      {{ SC_(-1.6098388671875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-5.2923808769191278344096906576129452977508979277324972114028585485897292732749175191104387817153243622e-01), SC_(-8.4847336230208620189522999730668948980498026956351676759653713074643763505826560196595716137493813219e-01), SC_(8.9705533240946393665356057247371866574922627996248245980741140274917656623741748929349898927165638735e-01) }},
      {{ SC_(-1.6098388671875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-4.3588329433998778344118299461470119260462800471832395414994779852496041561445544177910644873466410470e-01), SC_(-9.0000319650283441310099684480078605946721143546738341042331933310537915309970277408204072796535470377e-01), SC_(9.1875870906845118047635806822648200063819834288643294354356983053626866318919800547192402870664676236e-01) }},
      {{ SC_(-1.6098388671875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.5600856122085672092800268968580894468432579079804656774052584258946328842723868281852714693291460848e-01), SC_(2.9333876469438444648579701071867907567539764964724421796135027276816072964646665290023055039395020032e-01), SC_(4.8737075577081420166881282500675564846609614724320216534645035828942396447404446035830276248915799790e-01) }},
      {{ SC_(-1.6098388671875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.7736452897241769061181430418007365494795330898556587924749704567000625360724157676092701517939511727e-01), SC_(-2.1156223081288422793211063644770138572453563413600394268502697586678182945457777132434950354231163677e-01), SC_(3.2141922402480394843964588019150294350276272721151544568588531146246464930473505445135251473893910091e-01) }},
      {{ SC_(-1.5605529785156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9634594511488441239446124536812458462568892642529680265004423990558267843732051305555937342925952892e-01), SC_(-8.5409353428812105256571523319257903922757730296962059795625764794071278796936359904999417711418506963e-02), SC_(9.9196370140536661517806007451248913316445364776565729227577579281057604045077901201671022992954940866e-01) }},
      {{ SC_(-1.5605529785156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.8507961426602883228803019073961981958060099984011753039084360078720386446123667023988475150255949526e-01), SC_(-1.7209925495914224056702706138188187847064943449563917074969927279924070607243598857996086522477531487e-01), SC_(9.9105478803571702730047795909209167869766318761675764394396722003662904738763622827899377822295432355e-01) }},
      {{ SC_(-1.5605529785156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8248612785073414182685509102670101867866606445715181205154091509183064961414026941361152523421096695e-01), SC_(-9.8320842812805745037945796017375413735001762909773273395230181538881053153180460745843274908711290409e-01), SC_(9.9918618660790569357913493985971747365339871345709645144590218630847755475249250020453080799416154091e-01) }},
      {{ SC_(-1.5605529785156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9158838874949604426827150019504117982370531426684233581077142421174586823163566938385360504094435130e-01), SC_(1.2943132270504812677590848413999258821957368076167066407580166536160746634327211207828164566323979708e-01), SC_(9.5216807427332399209612601388142889559348170701718081235058316586516533919961845371369694752105796844e-01) }},
      {{ SC_(-1.5605529785156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.4850849856189024097670989535486539667872022677162829380888596814546374460520548474036175153271561409e-01), SC_(9.3730562061162150476751438595734314944960838837159437927593351031354238223322792887550880643854386618e-01), SC_(9.7541351185979966500632289702714211007616769474888190781321539444569874004850576581698447098984473774e-01) }},
      {{ SC_(-1.5605529785156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9768647828943160251387270175978040354991051978569998213156792178899072069031856957855604912863677927e-01), SC_(-6.7983020221460620602477920740337096785069318374339062937396833159665852445264612438240658448058446372e-02), SC_(5.8248896313210669614394305122189656389869009767463887294045928688078276659240087367291744920068430718e-01) }},
      {{ SC_(-1.5605529785156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1666788045635083193371938920056375449022051643456650047952514782286715843857567412246372159950161759e-01), SC_(3.9964984291209386199380881912105158376718408574530690430179110562688471984148465105325478026822099931e-01), SC_(6.4352467823650631744048456295799149574644278344437481712696368654316089787975896784931564053208489969e-01) }},
      {{ SC_(-1.5605529785156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.6177046252416079555508635934682224965776227840898130220764534668450302789945037304177484207002111431e-01), SC_(7.4970651253044233646081247800563589896058506359539248199555934055757606449113476755285508234546147573e-01), SC_(8.0043000495681302502202318394250860224011843001834972620558908558545445241188040905957841914651309679e-01) }},
      {{ SC_(-1.5605529785156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1162702067722820974181218645132596905845071555268450086333168727109070541904086340801164800949228836e-01), SC_(-4.1101846086418129416964169549534333473677856285816052126950157698922759495871524825487291772477361094e-01), SC_(5.5378739019092779516643345615954795852701624863384590572209755287128537152072227700404247969883944714e-01) }},
      {{ SC_(-1.5605529785156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.7847669401956797520765296060791765953322345138944187516386700694418973456687058302575886514423462073e-01), SC_(4.7778520075913856591407588537681940529299391433582939902608346698041301213222272262365837200005720441e-01), SC_(5.2495859897413680745296958425083017259125722923178059389226618992244314329629094407200132362457267991e-01) }},
      {{ SC_(-1.4920532226562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1215063872819339944338796668283511740964381708479698144676263852216765632126590041646227209364115669e-01), SC_(-5.8344780401796653568237512173126783312676925509867411666724236685734614984177049850333919234571133200e-01), SC_(9.9466763573814396963023807556320926109310668693939583577827334971414158421302798841901269607361008156e-01) }},
      {{ SC_(-1.4920532226562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6054976086331288037125322608257848444816810017465420845629110898722376190810025438323697643864861936e-01), SC_(-6.4927964795668560314267237713980719915991455923114876289126085678131101947480980783506908969590434871e-01), SC_(9.9467752343771017769896939755587427956446894137686630938344801931680613896887371931817915877777484193e-01) }},
      {{ SC_(-1.4920532226562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-2.9941013393828249562468043933256085053746533499014814474287338856196084573838173370275474866710041035e-01), SC_(-9.5412450534249445851367611999737097642434633331272683048477783407499681353395158460974738323907141592e-01), SC_(9.9780771168797610663602334889053920347639015008566581212273270194963843366318308150733275553306657420e-01) }},
      {{ SC_(-1.4920532226562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.6719864943440637930669039110209116098037189939204590982866000932993993709050680857205265739773125776e-01), SC_(4.9796235040326246366335080891937548199238428693661611992997463196657958427036916819693071051983811639e-01), SC_(9.6362945111052285103631254630096889819955734117210904878248366677107871195046059356266384495429961450e-01) }},
      {{ SC_(-1.4920532226562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.8985504234083673157036235273870644307270460421766787483340617817060806864573895864468342499948286678e-02), SC_(9.9508887540336024159212127845081277863814763122092623489898100955575317932908067435902261605351808347e-01), SC_(9.9803904782565583185366933461079009403715133227249391487654897071038775707482277358544512478341156519e-01) }},
      {{ SC_(-1.4920532226562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-5.8814963080461870021198721661557643907886147207612907823072290890103839379488530932608574741256306236e-01), SC_(-8.0875213247594637653736743898670824540865692134900148467304845506829461075322553449605233010395774104e-01), SC_(8.7771702643062584130996897525584161842225801509545905752278792498355736903130315249715375102515055593e-01) }},
      {{ SC_(-1.4920532226562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-7.0647797165225437502393133050150854956535918064874835574837305117427828927548166159140884257318526734e-02), SC_(9.9750132268368504887528599916517127108470497653756483100770737141575727579830791991377153519171149627e-01), SC_(9.9825848485771567319253605085194118133530665792125170554932334683733494030883559231514998309242203181e-01) }},
      {{ SC_(-1.4920532226562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.4863678745531572249028636559361319516603568583034425577174194618149330510689943750459180738951154737e-01), SC_(3.1636726361375973232168587351640093871006061211862209384483272114741165780710793456959697660838176020e-01), SC_(5.1152669663718754175524741758899248228596803941718859906572791569193163612144128245007753346711955247e-01) }},
      {{ SC_(-1.4920532226562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.4264887617918849524643736200134879357956942688935732452170692953333779215082906794972968906473048942e-01), SC_(7.6616083294933972619350563463221611229931649144742889928427228832099686005900491445468128763555483236e-01), SC_(8.0960145690531408107414588244273066133763157040414141546692847015180810061045705598458259819692286426e-01) }},
      {{ SC_(-1.4920532226562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9808546613041965840046196289959536192227486683121205499477166861603034194063370479882797059999240676e-01), SC_(-6.1849836695200036094807404215676478633019573351952667039811041899895716285358240919485590148993900326e-02), SC_(2.5472760086339861464574488543833310778215775408417060266165462021285794335752325951120153764731430374e-01) }},
      {{ SC_(-1.4580920410156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-6.4966422751625379709424397196181327681941954282075505658562757046004101068020104424429975902728224553e-01), SC_(7.6022127797484675684304880700570200971649712806496130046193870193673170608439399816639069149717860146e-01), SC_(9.9659116537599602476710610071061943810469047578048455307986076037531638338445046798426303504069981439e-01) }},
      {{ SC_(-1.4580920410156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-5.8527122143766083756292027906251895281883472862014251117794120182495403410495593978224638064774672771e-01), SC_(8.1083758999991396133952481887026821710265824475035228564313643779820599522746236907050437330283667854e-01), SC_(9.9685152863411531148047481479363860813865057080368610501111700804786901169741084406071234954305564115e-01) }},
      {{ SC_(-1.4580920410156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.9538827467074967652573934953302557590989686257730754974848765103734483247852567868725247631232593914e-01), SC_(8.6867166255078096364011845459175462764804387268554310320993700940771683001694175492879838583450448576e-01), SC_(9.9398705162821011723327363284558688239416916433882209763180017359226303026728259523390928152315921934e-01) }},
      {{ SC_(-1.4580920410156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.7048328267428766474784333531078318770896026368204002097296995252192271271413723596463863226695827103e-01), SC_(-6.3746020355740932296330577441422776097658295318887088267771394052633685044912085868754739357242780931e-01), SC_(9.7140281567457348151725252357144524857351700898211156272574976750639580480487327897129940353683005607e-01) }},
      {{ SC_(-1.4580920410156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.9489707372594851522162473111960554681341178696938108965252527788357394610960023032819629153208393550e-02), SC_(-9.9822891899439731357232788577442478226256087037111989978122214136214806277950413812618956766331896620e-01), SC_(9.9929215987746177668419877415984808839873423991868457088549916849464170470358478898906264042498448571e-01) }},
      {{ SC_(-1.4580920410156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0851380182681319117652189394641323620813495179407348366095225396694877833090395520492439673415179223e-03), SC_(9.9999524095037984164831846244433850921505553954914575039445627703759929148103300390549784963439398411e-01), SC_(9.9999684106737402177671981701005415815285831596948340777546473183770337862144139316364964273172877523e-01) }},
      {{ SC_(-1.4580920410156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.9067609323013551572361341995022783618794770134821860896393101403036375903856969633583145725021127748e-01), SC_(-7.2316425121846084879150209298768261856157120759311107836994617705786544323808748280072879655863662217e-01), SC_(8.1694165255620344793335707939499337284433598036331198420303426473853309551944536616953448811537095885e-01) }},
      {{ SC_(-1.4580920410156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7546719999976571480647441022959095463511134914824399966540457384106652152918665560992425175099232723e-01), SC_(2.2014481989049180224060604764017765374296722270231468131542034314911604006424283862140195613531324256e-01), SC_(4.6829882290167983722222334028974448364279076667095839681946252410377355817182415381228439387619673062e-01) }},
      {{ SC_(-1.4580920410156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.9679357821793608878566721770562817542532923332952225689879141200657530143640913638859995845857944118e-01), SC_(-8.6786873468366137317189975162473721637573361561709287939732505447498002363265356009436117632985589971e-01), SC_(8.9112430943261391741260625400178622381143267221644968928106497721629839677184256638275085668029782343e-01) }},
      {{ SC_(-1.4580920410156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.2604841473383484110815454538167598317378087725571429802232357202786598817111171698646815534161394934e-01), SC_(9.4535307226959030563466339965858036024572995273377325717548123760487162618055101211916878285969874427e-01), SC_(9.4879322185291934602097298863963233459132931492724866343341942129838917174639829517901153806671219550e-01) }},
      {{ SC_(-1.3695477294921875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6679266592224687005766596403861738696646635161342153732503878921356408804357998408702980554657194215e-01), SC_(-2.5556201032030319268686964333638343669743208840209257169143304914489385138714848873138781110669773917e-01), SC_(9.9243516139442863449293295507572212776684557937378777157019686829672851631404581344125216100060832059e-01) }},
      {{ SC_(-1.3695477294921875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.4436952786401087228359454852214153818156498895351298853821939606058886248959206283124032609711216828e-01), SC_(-3.2888629470062323150502147826801265516128081157072185676827735825472334088858771268382651019377747292e-01), SC_(9.9178186369387025552658569796612250849143741666088520750494250796272760587217142147844612718052808777e-01) }},
      {{ SC_(-1.3695477294921875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6852683119135998186604321899328728630442306124456610120456735865485558016176945751839627176871333300e-01), SC_(-9.8569706663284681620158277114715094998418835144194266693406497564380942644485305271731483037269105887e-01), SC_(9.9930597165320143400785328431414092389755937307863813738368078602298452775045285827266604337629338168e-01) }},
      {{ SC_(-1.3695477294921875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9667265230340997902558083161537737304592229444673035488777771965335585032075902639517042038253214156e-01), SC_(-8.1508429935105724808777884092328320492722842484957325849727007569051744497865349195744782503592635215e-02), SC_(9.5166382525040922603460901290767825979689152682109782910879794799251089860940930932155611303709893409e-01) }},
      {{ SC_(-1.3695477294921875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9744285727462213197793960311263891897025658736375251410231894747307705293900224195940999457908933627e-01), SC_(-7.1468499857194309892994410801399890491027111458241372004044734161928593013797504003905308576833797024e-02), SC_(7.7599241943871734623269974680481483840960172368054353337711375201985952667807354560309146762710678552e-01) }},
      {{ SC_(-1.3695477294921875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.5526619006106260593626922816755121180570019226165473357944188731834301894740530723119692219514895347e-01), SC_(7.5539805411641045457078906130708024420030423664322411451427940625749324506387869837439236841230801100e-01), SC_(8.4557240417702400004117854874908314192579129918353173303051582368543818513119348930422378334674088709e-01) }},
      {{ SC_(-1.3695477294921875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.4384712596784374111662430554809504107041358941934813973484915023769008548994469818816931468684770263e-01), SC_(-9.6981368270262229097348110819007011528854590411692135283168224432608650025171671347711260400550905212e-01), SC_(9.7905116231591711362758214132281658644247967852336282509456183688059393419748824682484139444765878994e-01) }},
      {{ SC_(-1.3695477294921875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1678783560459317543397377660816162244973464415921549680600757357160839931905824730909177257224715738e-01), SC_(3.9937459168986381313724963956915557146276369428454223325928850198734107579405267413946981820639352814e-01), SC_(5.5713957482990087532227119519222032446454986242059689202246419729971581151608904793551566813399615194e-01) }},
      {{ SC_(-1.3695477294921875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.0044952299339904090214704958923270624515499525933886945591875854393626748504589957785331115866123540e-01), SC_(-5.9940016778412728445864667073689666520537524308324786922764420683407689097143500179784584268398409582e-01), SC_(6.8225824671036424273297802371212536125383506631922405458040978649784613843293149735321082594995218400e-01) }},
      {{ SC_(-1.3695477294921875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.7890519003520628466161727071848438856389786566729289472282185329815941022688264946015294310188417270e-01), SC_(2.0431502373084723905220065606771815055074202336742934795913998014976054239108824274434006997605689387e-01), SC_(3.1698755441137806688552398545714358809041534238197664562651493320913915457415393615182581372869364608e-01) }},
      {{ SC_(-1.2464721679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9879738230104461723662178882569095641927690173722173792135990837986230054655368840954391078913256969e-01), SC_(4.9028452031253493238329482508886977030900227315936761088531364696873184882005731597620228952876872867e-02), SC_(9.9192394611167131030067256139978635262767034055382711956621461485776769730842620748271212639659160010e-01) }},
      {{ SC_(-1.2464721679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9978255332802656063237323167621244148273546493356613630046232009859670674328042780412684419649963345e-01), SC_(-2.0852962880409258780390635758383724027168151280517321550796305825602785108311361244526682342962848550e-02), SC_(9.9078451839957935302681084333234711449273098927785004966125650755391802610728113270216698432069332803e-01) }},
      {{ SC_(-1.2464721679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.5179266525866102800446944640636430577644791342112350026531952398590475064474209167056780954634161751e-01), SC_(-8.3398132746887280592842404789549479044327239590111906145831907360908089187595772896374220201746952747e-01), SC_(9.9253440579616273007353224956286721646967394471583759531482530944961914735241520005811841789808381028e-01) }},
      {{ SC_(-1.2464721679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.0691753672189982837265036691212770213398628153072239297557403854319029241619325924030711959527488058e-01), SC_(-5.9066410838196478482691189120908021716915692240405535985896627840746994013811549265130742701022000771e-01), SC_(9.6858946318092217836273436882553652438827742802045819049489945959927823480995896505235957120943586040e-01) }},
      {{ SC_(-1.2464721679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2408338415069235492512955138007227012283923558882473332087183772132274418530915890554034362448575928e-01), SC_(-9.7456997539816156513012571990890162040114813490651555468079709133173416640912443464922436021379085131e-01), SC_(9.8990947499010324609701403983930948868778579127450100650921432354866409117975681304840166563537640108e-01) }},
      {{ SC_(-1.2464721679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-7.4653688382334759149576065297871139378077075902420692271822689078787779508990012051811213709588584146e-01), SC_(-6.6534403213023983744362450157458131884489261615212565773770017727493590024999403716771634481078771610e-01), SC_(7.9376762905435952956152431770744300782150889683566241593471593364339622516110703071665956177589056871e-01) }},
      {{ SC_(-1.2464721679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-3.5486882049459328101769458467198935509910482705921002468689789897154957922549956811008940050390156475e-01), SC_(9.3491610331664313018350014542099981017870532341995769406017235839947942123782854828713976868774002777e-01), SC_(9.5508920115948540925362712976247819033616426394873129059405889116994890146609711534156806975536044907e-01) }},
      {{ SC_(-1.2464721679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0137921476126780068509979953018125563425140082397502177669110228977082709376195744843255685968565865e-01), SC_(-9.9484785510870391626603378254891226119802743577178805732878010500879931803599827448239122185302509929e-01), SC_(9.9577484123031221280259485770083233737297287067110735902962100358957344648004760406086550285153557831e-01) }},
      {{ SC_(-1.2464721679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.8097480596285246929912380951072445602963658626082280067918378873467451571375528844384460740285946581e-01), SC_(-1.9413508200771942766094847656099346348318270457689562226877392115097835320354728749559755813858169275e-01), SC_(4.4405667056631014929105786081897391384174619870271543090320682735358269533789104580949129991783423918e-01) }},
      {{ SC_(-1.2464721679687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-7.5994253940936518395008694866306847519766164116479266544525828739631783492289124310044738261433855260e-01), SC_(6.4999025900089106204125214598208331711348814529045339741691114303293201952543201827649916268430074803e-01), SC_(6.7667282103270911452090283865836058840982157039527338885688150144498806536765537964795037113045855779e-01) }},
      {{ SC_(-1.1158639526367187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.2458663041597497496970862450744817675864496347352298175386066711207644610328456616310612623593941776e-01), SC_(-3.8097186622640955754006915831273818651234455027814560978347926558140606525038078248965877842477681009e-01), SC_(9.9308349179903959999925740837139676541972841809767180451116873033341372469264593681350397622586968147e-01) }},
      {{ SC_(-1.1158639526367187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.9900760858062601340235768819420987927395656215907949715411426109651145333309081601206890130327111292e-01), SC_(-4.3793300824914297473775047923715406573714290064121143313888616297537846575019665649621508094158188193e-01), SC_(9.9255529426906875515132437831965722666590878412113728918456689074832627212347647237664818594673094041e-01) }},
      {{ SC_(-1.1158639526367187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.4674315166179601147660858130561434779057837483152562295133366795858369868826401122981843517378230400e-01), SC_(-9.6908091360216352791662299335302510883163599662912451077746429336095195734879327759872349838100448254e-01), SC_(9.9851166089944731454956586397901681012005938655739237720975230257887378774795091030119084197010666698e-01) }},
      {{ SC_(-1.1158639526367187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.9642308925376753164973986370690775512565684453831422643902585418155954147466707897769944820769101337e-01), SC_(-4.4319932880446911809137640273736029147506250627092316185360149075404266225723546676599761449768835449e-01), SC_(9.6108638748947575869191222741918822618519003607026056626199458101526447975420227571645922179441192279e-01) }},
      {{ SC_(-1.1158639526367187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5332321406341946736397825802133114880280380685891393686424182526286690182888426125599300350912849711e-01), SC_(-3.0195173377179291016872877733495317578169748073398251231979470817517159535164416424561923495214443754e-01), SC_(7.9786001081669501669443162466786741446317551780246383296498173998698849864895844573694925325805766797e-01) }},
      {{ SC_(-1.1158639526367187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9308579549856313419632584837436259577267888700323975952265950084874328294886356071687531308782890492e-01), SC_(1.1739081215745141010074950437269020818653284178730641690782816777717877182565017747926862942527502973e-01), SC_(5.8768430557718920532312180976705811115793095102222766644595441419785988408875362308202685335851217793e-01) }},
      {{ SC_(-1.1158639526367187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-2.5941764108678390054896642967046663300493870470968635537224744814510105690887054751713536648774471559e-01), SC_(-9.6576523415008503270245079313840865470289146733714424808456237059829460964973205709799775618684110413e-01), SC_(9.7625690764337963791061921215409324995917470601824851982824163311406470520061729825125834412544972125e-01) }},
      {{ SC_(-1.1158639526367187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-7.1789271757032987471957133863514146644173371790159457750423859006590836353267780111109832129610065583e-01), SC_(6.9615375173842637560681976349382368105760557838144132368986333855459442653856961628704416252272076474e-01), SC_(7.5971062360107373504777684904340244664769747080758550455438067263085943931032239633259392330182655048e-01) }},
      {{ SC_(-1.1158639526367187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.1725327377124420373551392622811331172114849829668827619087524592816779679411601667151905331039904062e-01), SC_(6.9681255819942898872257270427456577285521449865512840338295685280677713298668193402240360393561920654e-01), SC_(7.5552326144050359399622851674388045320375496038309510253890851057308240907555657032321771975209563529e-01) }},
      {{ SC_(-1.1158639526367187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.8653603649129697251767996913777652622300963838669798041696317736625338184528255272332323074034130650e-01), SC_(7.2709577814674495037084049226780045039952147603633524488828677103187342914379832523730318070997659945e-01), SC_(7.4669850412368234654290786941127036886326375126130875199067900470302070260828462367571647126311152877e-01) }},
      {{ SC_(-8.8600708007812500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-2.7460805436427861601940512035713251538208691745959663361824896051912977199324527199932936880279590931e-01), SC_(9.6155624717343779532400889720719484369291783385122993064259326090511623597856779431537165108289069045e-01), SC_(9.9939180085509085621970699960655279608147850865164807487226614116538251985784365741089749932840526318e-01) }},
      {{ SC_(-8.8600708007812500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-2.2625453528379249230952779703077963567875865301935155725695446774716203235842404494158034485952808641e-01), SC_(9.7406821386570001253190403310977408513797112940378542974739937514674786259357533299557948964620219294e-01), SC_(9.9953010824763841668052495960465358099818157688420473355705477670251926417826274018247662581438079560e-01) }},
      {{ SC_(-8.8600708007812500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.5114792305156405267263832787038293281255733948161115585862037802164521884104574378950825862573367922e-01), SC_(8.9244918708364569862110131793773975531083988444436846320134596370695521132914927606721420390900651571e-01), SC_(9.9501563332111073143702617248242562524335961381665118392642381682719152639729959710040198185335505265e-01) }},
      {{ SC_(-8.8600708007812500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9933251285726419812282408692949957339379976226149802898424777395665168881852715193581668427793401696e-01), SC_(3.6531202367098268691542056154865277372425770446790577935249921439471398612664203333233832010559668749e-02), SC_(9.5139889006741544298404242879395075807221348798193096063769335792766191886094118332468769755968822693e-01) }},
      {{ SC_(-8.8600708007812500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-2.6647431249705735698555129562379904793972287612982839360766581622940838765092032464012700022124153842e-01), SC_(-9.6384202065443308897765474316713351337036876835238597129831513256569908965633839189868190802476245585e-01), SC_(9.8570037140937548476521543751991799337658943921284121681842689084547300921731093313430403550326727918e-01) }},
      {{ SC_(-8.8600708007812500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.7346055491117709373736531460466620522884701016878889218338529187579438887966440348403332956111271670e-01), SC_(8.8081502197862194497364820028319166898911753060280338159055759282343041391494521206789443143688782201e-01), SC_(9.2260776452181768915560641500251081638594373436414901449825204127220044028280470094548513749815700808e-01) }},
      {{ SC_(-8.8600708007812500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6569010609394604410347357341297484571135503688690410615541466879584856545922804777538951903448644453e-01), SC_(-2.5969716785568385057094432707970414051306437884294036344295118513036697990529769889458075128679057791e-01), SC_(5.9142592506372479467500257023090587801796464781047506517180191988257622989499147409883515603868235299e-01) }},
      {{ SC_(-8.8600708007812500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5718997248608513101919212297072288631328300903540992483552923667927733247604843898075113014816526960e-01), SC_(-6.5319472254950257081967920429321367834551638374178059514445569356306726324701646148274963699773500264e-01), SC_(7.2773686673988762162487481828952113124535380206751583537574198246618387285187767980849393225399713198e-01) }},
      {{ SC_(-8.8600708007812500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-4.1146520029515465132365714918946546113023466911302293534663414486402733416804678044261887123981149462e-01), SC_(-9.1142547086751326133373624393378458562643449656225271196519961289282863845168612821985953954929553760e-01), SC_(9.2669171762128280507384516334208557933103187414261813394383770023262060270250574568443492644882754356e-01) }},
      {{ SC_(-8.8600708007812500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.7898640097442778948215635392497382088099840307841451280864455889726923430237941647394087824916242328e-01), SC_(4.7684683799100781032824282674864702023316035470112347680491831759947401259639455360918950878955253540e-01), SC_(5.2415708255953801165273149371580273751187656306281884456901286920426399278238929190137545875691076827e-01) }},
      {{ SC_(-8.1188232421875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.3398461882031419352426376154387841473213903979051297495420759734429009215264243706650722713696966748e-01), SC_(6.7916609112587332953543384965478749241364841154231053024066228514790291264589467059353198305971155187e-01), SC_(9.9564681218160801770291662252122987294232647085522471828862261657074629710906600338948015808066040577e-01) }},
      {{ SC_(-8.1188232421875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6442656345440723442376520747150460224183120684672236385855393529691997437676844540712195051330384568e-01), SC_(6.4471081042998271564799780805169839335744214512624621760221558329119978912022394876045495287150124234e-01), SC_(9.9462297685096265831994762069898084719320951157968521331558737582327229938601082054321961436216360832e-01) }},
      {{ SC_(-8.1188232421875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9758243945478900416862834220731038097883133769248721083764385456274447481472682097190028152725140492e-01), SC_(6.9492995988316914521771441496241508820377492961523493334034878965411156804832118890864806694525617434e-02), SC_(9.7538704529318976352432547203124941294897802767160426049233373345157210787554862872576762901414693505e-01) }},
      {{ SC_(-8.1188232421875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.2300259261367537233651978621529896024284384376345626534832947424063961525044574967920159956061903517e-01), SC_(-7.8221977065057543864924322346847889561631838171192582330530743793793179615627830289133595333928638169e-01), SC_(9.8139711123384398450484118586312598430717639266811504526351312610974275501792967262081189917788729301e-01) }},
      {{ SC_(-8.1188232421875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-5.3291855289511259224059701093803733636004290381563810637581172027903849329361213997354317326105551623e-01), SC_(-8.4616654151542714028529374390637173202252238769773059240609303649249873599519600921896563741654585435e-01), SC_(9.4150608390436757966272516175603991276181555020896839104623632501075823967967644418583524563963441774e-01) }},
      {{ SC_(-8.1188232421875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-1.7976708663609609785275619392128443605643753363350636662492291164472421858767505946240081645120441285e-01), SC_(9.8370920223527965111284155902882157740608034538277539380729787521087837104250581090959698124408223890e-01), SC_(9.8921652390336629139805841508358465602860207059944659453944166956478586740973022242830690896686475404e-01) }},
      {{ SC_(-8.1188232421875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7406596981831792115693529117399768824274847667599793225472630855636491960045331417454365352613800520e-01), SC_(2.2626419611131532422030467332915075245091745905094412494656216072014056544319004453725930559711963602e-01), SC_(5.8177013535922915175398487107985700599749481532032717154294868563163057584390473484854398232152193046e-01) }},
      {{ SC_(-8.1188232421875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7956049040709260981391852447592984456082676827515195806088100710634584593697291176141121086288877015e-01), SC_(2.0114980893208978423703631833546196075541513344004912744556891122428076221275759104992204247535987680e-01), SC_(4.6123537364217239341232885896370984248535829243614111488416448946353333761777458128951002931688340049e-01) }},
      {{ SC_(-8.1188232421875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.3438099376096594627607484974212640682236429404661019028991465157747325717966476818012357300252454354e-01), SC_(-3.5627539698703546231613041874184447151041662241357068844073391075635103686681689630989620992572037054e-01), SC_(5.2118940284440796103799332759661876414987076114646584133489059078205276483351970027067775152820633210e-01) }},
      {{ SC_(-8.1188232421875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9682529374564312983735448397649965186289751944028286048803733591954718594670368909323225763768609883e-01), SC_(7.9619933112960398272003190954132055196890594099300574082662706428987542986830662534534018007884296639e-02), SC_(2.5931831807996832276230315068452704320935681596058290796574266644665557575102142750058454481346146417e-01) }},
      {{ SC_(-7.6733184814453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.5515479941978238068968153004330891708450987235809516916675469203753185897237980778835899390485422402e-01), SC_(5.1837271246595510205195409219173919599835612659169751086797917813827808714491195869162013740980879743e-01), SC_(9.9408625348522234892523443144946083659165386829131567123418084604085009500713585191018978613388254537e-01) }},
      {{ SC_(-7.6733184814453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.3214829299811259652456122123480675987795425329957237646619801970745568071198314502174856224817704545e-01), SC_(5.5455317009311861850136268714092733564810188503341691191716350537645333029592450774235396675537952941e-01), SC_(9.9362486780969913490414096989433772335174991276453587832168242154027072909518121647124081598283188655e-01) }},
      {{ SC_(-7.6733184814453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-3.7776866278553617931364854884780586954700000977337279266889366672635890364108297279076279525996251717e-01), SC_(9.2590001480571748209841482341599330200079657656003448827570595505106657178769877573183758502845104676e-01), SC_(9.9650779918595709189093864281159471039591831171149983727801091307907953200362156689325219855742576456e-01) }},
      {{ SC_(-7.6733184814453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.2692217841133371639016113146770870722427995915546792337679428750299837332098023004668514635630164361e-01), SC_(8.4991353554244245862391446120156359092195377672932288207861122096392412063031433985841205571035372951e-01), SC_(9.8672829600732111657707443452512745139081215195548582201431530903642763032573748294297276176762133127e-01) }},
      {{ SC_(-7.6733184814453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7215695449276582364002772331023145835787841128410691615028134463479363374823885685636823839021226544e-01), SC_(2.3433065491170897904716190618297844228411390040062008833488870346658923830099552403068042982278191284e-01), SC_(7.8872011184311689014865013577665535329240109182013691658196836956181766552937672605823141653209982260e-01) }},
      {{ SC_(-7.6733184814453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-2.2026245969318816323900048429817735953187511028338665364857065125396018251498490211623129003869035964e-01), SC_(-9.7544064342732134269263544397815765884452027788448835123900041572934422395765655961955166841580713222e-01), SC_(9.8376654786750615862806680514715166023043073041726673396911589420092163174862039615840185296393018295e-01) }},
      {{ SC_(-7.6733184814453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9864321885499277285005821824193362285243369492708987694599230151323904666332338189943995655193076976e-01), SC_(-5.2074191639803753918982377857825969458277952634325273500602297186541097354408858082615522470704559964e-02), SC_(5.5195264162618707683762275451462859856052051747091579576762221950146446659025132535039979500238940511e-01) }},
      {{ SC_(-7.6733184814453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.6173520263376222417225203132433930020158639661414388962536140577534191934146589680929612360716046120e-01), SC_(-2.7398065627886271312533986005086249300732921710009458238372857330284834944762383046417159347201603530e-01), SC_(4.9104923359825047594988483581906206986376349781286454045254515943890993484473218983195863098394320292e-01) }},
      {{ SC_(-7.6733184814453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.6876502706747336176938105971249579809632560556531447146404180168515874781391827071081850067477253461e-01), SC_(2.4798048780288663010454928350787873573814124527937790450772745751470985552499837159262561843688879190e-01), SC_(4.6588251960749667478876135853289362226179228151605890725700351891881777671975374972872552242975509198e-01) }},
      {{ SC_(-7.6733184814453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7263414612353082951988372657816092235949958327040419652224767412699025730206421252978904297256398769e-01), SC_(2.3234202761134301127000252065925398065619013943739262908537665632336855314220201314657056177117807565e-01), SC_(3.3461792533591229335922391438610650848912792211361148691701681017765688551629925874900993869814530480e-01) }},
      {{ SC_(-5.8497428894042968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.4283285478648180934072585820261468897627781298430446529758900275434234304084785094603318560925771867e-01), SC_(8.9660418397509985904881265093328116626057006959746484780744039807448056536309432744782874916320094215e-01), SC_(9.9841762071529674938316757016824077795958427282821055494362688120819221854580876489459957496431308516e-01) }},
      {{ SC_(-5.8497428894042968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.4599380517687681449749342768939977898304492493076349706510350676846030916007630919913896747011237728e-01), SC_(8.9503604717567104697282754366725208907588157550018243215078822879162747153977705980003073694630857794e-01), SC_(9.9817292756413783087071557062238850304267580651043562169403102739545197053509782885381911896979971627e-01) }},
      {{ SC_(-5.8497428894042968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.8933759554671952548874915735760677799061314202925018341863326536710625155345831694385885512503839698e-01), SC_(8.7209444304189620218399387522104595952377249703951935028093450802923603593607627908031636589483936191e-01), SC_(9.9413346984872887425505732106716161515680994743568744139957446507073719749974811713619406019733833445e-01) }},
      {{ SC_(-5.8497428894042968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.5478672921506516347027682541744109546709912916523451740890583227986638118523607756919159300296023846e-01), SC_(8.3199259917793136690813103418965313961743308089485127178697793186266602331681528774202085234243213218e-01), SC_(9.8527676394179822868290952752033994260881011008632494877286327409390131642621148124045833584818984649e-01) }},
      {{ SC_(-5.8497428894042968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1799357140752219526860506704722448957402512272422772549067151679156012871591730261509333746667222079e-01), SC_(3.9659526327789449311189600830757682833541248315310183150539596731826483056998140567507536514484672607e-01), SC_(8.1425900571444741767204920485612399704114197469939431856156419081113091505202617607199740098915730642e-01) }},
      {{ SC_(-5.8497428894042968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9134676824871192857064604921145011811825948903996343887457170242868809998346628522239993864155828775e-01), SC_(-1.3126913225444374375190930925292674074298823101473055849089345825622859687050630425671299020903476313e-01), SC_(5.8962998280195552322851835399976304610918553779442479979056890809251188215897089062172149700973694637e-01) }},
      {{ SC_(-5.8497428894042968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7937069931383036297239773170693280247178761155492826729080223208573921661515807464143169088762983151e-01), SC_(-2.0207185188823027906335085290030939156535825531732800292023928206585668204736730588003774106487004779e-01), SC_(5.7552704884681087988998331848423083155768418381837960472830884276300874039502122039269356903674506807e-01) }},
      {{ SC_(-5.8497428894042968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.6591720250266955215959300917533494040092012410831766003583703338428741689999663681405546381401590024e-01), SC_(-5.0018736330494273241073223530621068593224893604707915633900351920603968508862254022196068588993628613e-01), SC_(6.2033033053903695950193856035111572317928184028163816830478137052964073342419819569811119740977217587e-01) }},
      {{ SC_(-5.8497428894042968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.4029609437957381749786295577020362002508423780391309495032879927470856010717786318399589393754563918e-01), SC_(-5.4212772828036970959090138334707989672948244698821710990247160789331333242345907571970309522162202727e-01), SC_(6.4104156604963168270389523975316341266732016049448495228524208148781208766615320253197163335003663299e-01) }},
      {{ SC_(-5.8497428894042968750000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2490854246430981792517301774518062249230050754891465494504644046213553402083738381492615840192954591e-01), SC_(-9.7437987844914970176088174583013415816104927125909603347074521101245916946337990617682942104473608059e-01), SC_(9.7596961851222490374512667482061534967199511221064259399182477002855066118239296254312438009767211441e-01) }},
      {{ SC_(1.8752593994140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-1.7276418204535047175579286238286576825993344236959819674136341389771718488328039366191472932664189948e-01), SC_(9.8496321626860817592876771312529830383517977885988720232858617594175188941138811715946005371882399814e-01), SC_(9.9975931620106403333884299836538531844984195741129732288852930292039001540474192401821926333934686586e-01) }},
      {{ SC_(1.8752593994140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-1.8329643830524850857734236616703383213469655874555908018573553817666795636607562741935126129321617038e-01), SC_(9.8305768686512503524859446292331226585989481274930204191617162169124842578084842902964484301117922615e-01), SC_(9.9969162709823992612813248462346238603482361071558613953415070994524163493299626076626535818566296017e-01) }},
      {{ SC_(1.8752593994140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-3.2729999074658063912210263821886349097115711752519613874754260192677790635978801989441783443374782538e-01), SC_(9.4492048134077834052618649260722075067579010295847309262464477063971030471064139310996418579490316796e-01), SC_(9.9737970785307984953465110513108895568993087606158841887753247454780054548274907611363294086990834092e-01) }},
      {{ SC_(1.8752593994140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-5.3739496447281070707419050609164802262890866943056760891901453693501362879257858091672132609464580870e-01), SC_(8.4333068968185102919788971687549759313736719412852889002513335339674797056336633172834314109386912886e-01), SC_(9.8619176354020591276737858274480142807805781336243594762089418819245563225525991822021708420218540197e-01) }},
      {{ SC_(1.8752593994140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-7.9986086348053782858696400278730511016166454172475885850053867946723355708941625884287794064797909010e-01), SC_(-6.0018547056069961665288993046053858725253161588706849985384706851689061175247676309474176360448188099e-01), SC_(8.6265111016478953802119202568278915878167772299353185885246052026054952271832894109489212680592006393e-01) }},
      {{ SC_(1.8752593994140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5101960261736600010347069739472748764464833261247511625748520933326393878544921052900054344887863085e-01), SC_(-3.0913057991325811279794083136465230691536558734485834828969761693665827292281265170919455935738804592e-01), SC_(6.3218434762410693079449924012775405468323660399936773441452047812519405961209003201518041050433569409e-01) }},
      {{ SC_(1.8752593994140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9813776791738231789186333582141984002732116717828506988958023623070003444345379312783076642144678707e-01), SC_(-6.0999969318892559805890910763186389682851550469632358071923254786542232118640407969416797242200409914e-02), SC_(5.5258974326805504805733703376605947230804758695521408472137360033928159038670197655359261526622451489e-01) }},
      {{ SC_(1.8752593994140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9336208932201717735158572296380190780333290065285048972070260377991074246305068233930672700388663188e-01), SC_(9.5600140405159490289313087305021017744600887833588619928530007986333553003417268752129378034560958623e-01), SC_(9.6404888050837590490811253746211038461811844125821268282464247874226971512289144821633993127791776301e-01) }},
      {{ SC_(1.8752593994140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.2325841848046766218991227981012098670747362700260131533668770717195845184596740318180119775363943161e-03), SC_(9.9996611170461176979906884255569334102893016722503713775857431038166928556333207401163578935168183697e-01), SC_(9.9997172858422789189447887250530068110857221956199374516787168292511028086414803902567529091441731911e-01) }},
      {{ SC_(1.8752593994140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.6660893147940226023098523167884871105379461645512659824692486188640890753961669120308151765052623031e-01), SC_(-2.5625607033638876553305288645223683943173356092262882491932070604355800974645470609928610334153595083e-01), SC_(3.5062418128597448697084392163943585267596312089904662734679195833126065663426059344052512267706023587e-01) }},
      {{ SC_(1.8888229370117187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-3.8004673195077557402379394009020774017083935838202742195090554825933116984811311365529406436801352943e-02), SC_(9.9927756144893764616564197015461264671404579141740257258688535178129447182078468698462248893521769749e-01), SC_(9.9998835435069597836690954066969364446749685399046407070586256765975194678255792719457667000555319658e-01) }},
      {{ SC_(1.8888229370117187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-4.8702693389602350119066841000463367956245442740440396026844368057003177113509077328670983128432636170e-02), SC_(9.9881331972325958942546436121280738452918350942627666026308661986017494985595801191111255152694725816e-01), SC_(9.9997823233357199444493719261143316328651967201927889271161145211867294260401394068297398573329824293e-01) }},
      {{ SC_(1.8888229370117187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-1.9675049349943128157221303780653132015488663013268857326052210116396978170494827167818500796579685794e-01), SC_(9.8045359059352230464085006221560445237307017357835812816186708261567859183156423464059505932493059648e-01), SC_(9.9905392511463619545579536010500182750606817500171292996731598023387063361769306528048525485418703020e-01) }},
      {{ SC_(1.8888229370117187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-4.1978231760752493617635929452759351685784633511957324734251669001720650766050698283369880580768711234e-01), SC_(9.0762481556205538773652235504254080344198471632439104150034532802757177483340103136944608014404304277e-01), SC_(9.9159729802647450579108065260807691832646999437607462787332243269064093929988522189434757094096116443e-01) }},
      {{ SC_(1.8888229370117187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.6359204754451058175603525981223289714808055606548708453464647792158073110139526778217975868021699585e-01), SC_(-5.0419120918346025331645545664196611301818918894009648819663737992439361315774251218402179325422954759e-01), SC_(8.3771971235903445559692154901818116063595662468285669581147523811629575622287894155001725268587882780e-01) }},
      {{ SC_(1.8888229370117187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.2029664885938186425638293599601860974139347792289230187946457358004036168191429145804176076907055183e-01), SC_(-3.9122126488496455093506893042046746461294319660398348680331995936494079402590204723878662834131876681e-01), SC_(6.6167892974142638181130820815315433769826749456463967231809805133045134853353389496611779763122563971e-01) }},
      {{ SC_(1.8888229370117187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9069319807677672271394934588456323976740085729985490763120011281814851368488662131152844808912580278e-01), SC_(-1.3611387616407241996511120764544726540261354107025452073468231723695076839328637482627175564337286234e-01), SC_(5.6185295116545624963536826695164333478398128794897210140077445229267799631297162515605360171575161803e-01) }},
      {{ SC_(1.8888229370117187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.1334730398729671138795710848900641263748432264000037893971898932979195610995461458086277869128418804e-01), SC_(9.1057344914423752607049594788282121025575967574905231572476829484173358182098427682309598449132894106e-01), SC_(9.2726463942887743998049743204000606960161876695902299438489210611015920168991361471018080569747989780e-01) }},
      {{ SC_(1.8888229370117187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.4296461103709209954146764741676581431886280550143103306657317073241209880448398168687232794854414082e-01), SC_(9.8972780095893687280221180458297440706211095468343247375994848963508953019225794555596339277604253891e-01), SC_(9.9143772014611744520440889629540354561758382252308845674887458674552175482157874143286841942118202690e-01) }},
      {{ SC_(1.8888229370117187500000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.7727181261448664962104928340754805775927758318889885697679770784778432581047825899786163776197478667e-01), SC_(-2.1199010417751978776553878504438072516989498412555189859805779771910154071368808396686084045201772709e-01), SC_(3.2168375153211850299067931553417111246706912711147818889351071685317428407677118866910416218637421440e-01) }},
      {{ SC_(5.2943695068359375000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.2870661446649418317255408335162808915830922603868822198449739773147711529907925943665280307834869435e-01), SC_(-7.7764258687785293326613988554791801020878097444473931910048110459922453746525009978129555344668610398e-01), SC_(9.9680789665509610182966623944371613993284074495095700553155719677535320863526156312397112209583526036e-01) }},
      {{ SC_(5.2943695068359375000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.5183994054286622465971549525690599199367772313342424036855182609427637147446141177296718975914939758e-01), SC_(-7.5835657306643859872000558043107091520648202288993740546557684908269991953393323946930750377597452592e-01), SC_(9.9609309972838105576006230445332057410076672172036178220300239421250063774462664918489576164219979557e-01) }},
      {{ SC_(5.2943695068359375000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0230286260080753014539819609254972318794381412196911652020254634278662063761258374332667693452049021e-01), SC_(-4.3110270718517675265032810971258407689952284686069475882873333847737088857376067608700549028965113999e-01), SC_(9.7991010995914724250180758980565945978072899610568862229796329843032009279280149442043757706567561648e-01) }},
      {{ SC_(5.2943695068359375000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.8305238341999163638014826321873876426948152755031765855130997205917167067020117867553818740838859412e-01), SC_(1.8332487952341262306928282025887332664446148727956005528901200958136252113071407044267226950237308891e-01), SC_(9.5300826871526771331671696111049128932777115570475820176868495993411626950799114305860178206851698482e-01) }},
      {{ SC_(5.2943695068359375000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.6704197257721722297752033050376754289154607428558811484161477364812441008481369698402585057832621682e-01), SC_(-9.3020438096507872772399640777673117298801234086249364955406552524556628471800269488425333087231366065e-01), SC_(9.7269135876092113047194976061102985132366207401536823423322022206977210405953456052305171152166703067e-01) }},
      {{ SC_(5.2943695068359375000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-2.8272235393587397013485847316681848158436269582743813538467500213963519749601507998708302711634140217e-01), SC_(-9.5920178825154324679225268359581567281751661874247188762702087307377554842480303309562476603678915136e-01), SC_(9.7311008322766574811565171074995874003830086163918054301384857023017066294188196747395323237462088384e-01) }},
      {{ SC_(5.2943695068359375000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4267050712804958653791073190427004794039223847805279041184497423996199986033302408875456361424551597e-01), SC_(-6.6965701507724508289302055962793869128113735625198514735152564278012417239354255516540639328555396886e-01), SC_(7.8449424381754716351707525464787256900099398919141601418288405806428231768447850244597934230481664640e-01) }},
      {{ SC_(5.2943695068359375000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9903623719075898127015002454843599297392336508630990954989291536079818437049954614239280917282462728e-01), SC_(-4.3893015158787637329415345419565927802615678876713953766975732985596430883104367274668712399991165430e-02), SC_(4.2558428254560162704994847571351279437075709335239323328308931166064379966189327683422718623529753402e-01) }},
      {{ SC_(5.2943695068359375000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.0755353087493341271414819770367017126669893985398965695714221254383155649658745313479518700055075402e-01), SC_(-4.1993641018187656644736792691479486186921819565566649236861904343911066318915263639769920951474790574e-01), SC_(5.5934126553733004496414311354457490701004432854938644762103478225832099112363380390891465621028320600e-01) }},
      {{ SC_(5.2943695068359375000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9320281484958677271373822629778840712798571900522984269204724112121718994192367064013413096738115200e-01), SC_(-1.1639660035781739482614862441436638089049083014131875386432121503170129330873537878385674242854881558e-01), SC_(2.7205322594840926568048769266522702592790947125455020991527650196325390765573241187138219003638052411e-01) }},
      {{ SC_(9.0335571289062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0787917417800724552197154696153021609239901990991603385499136338564652483754365894129891447033862077e-01), SC_(-4.1923192279913463420456303318255813851302462835703469706910634884128855684295740269328853604406409988e-01), SC_(9.9333203007473569524816399894674631796370604422579926059478344563189271753994761742717717849712722771e-01) }},
      {{ SC_(9.0335571289062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.2804432983366552937455345650230281894980578519655465412445663625170527338852464166389605804296597853e-01), SC_(-3.7246975966322772693535136489858219662573763855298608240009513299194288629595731675494116513199771736e-01), SC_(9.9206466630566031772364738022689898122402908093741700430053004642649282215357114636976703751064565426e-01) }},
      {{ SC_(9.0335571289062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5025025285040217843761877023684039724443770077816937691147749529103368651752958897867706348750977210e-01), SC_(3.1148749085275756311469887292144124163039223875486872779102836618547891204709204995754225067219663771e-01), SC_(9.7769329576714068201951374917276785005149403207033873238393123017854185791552086709366837367751249444e-01) }},
      {{ SC_(9.0335571289062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6225854405253134833681932414285866537922684505203663215407859514114047959083713864090430651328272542e-01), SC_(9.8674827837800291943523209274219204431958047051642521564336888693218219370588997333181356021631191857e-01), SC_(9.9874908131648461856265780716090548349982589940371979395453444288794880274075280759057334222451669330e-01) }},
      {{ SC_(9.0335571289062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.7025287069971652872804048623955788086415442476703348773888526802539928806924225389088518372361930805e-01), SC_(-2.4209371511660346929527465814805260445936726050341791427676615199279303412821646045642477109884801902e-01), SC_(7.8965712111540107143792359514256194813563872282840778372918846433216267010587768115237777034687147198e-01) }},
      {{ SC_(9.0335571289062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.8050349867574125287362582191473891294696032591875762338459856416422257154020336572691190626073456842e-01), SC_(4.7403964899550219136531905647006642076264756154000221126661053451529339957147549029734541958849126699e-01), SC_(6.9669559528917989885268569257167339257208432803145351496594525106419260166477689224570961747032012316e-01) }},
      {{ SC_(9.0335571289062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-6.8171452275870143602035140647027023775042475764757831529842339189016668491511101313800909677244062264e-01), SC_(7.3161828125045914671928999006073621259290607535169949013564336894092260244453507207432453327949388618e-01), SC_(8.2217324780635253107713681253240173743149123677075135627798057245311790041449025538350665663915921526e-01) }},
      {{ SC_(9.0335571289062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.8610371121166899910319836250306566174087951922684634609716541123541298324104129477887309114826171079e-01), SC_(1.6613088434897741167371337918533314934239609142297313215491395414617026881583800609701851688748210389e-01), SC_(4.4965043604663897555855856991958861776273621595191714382910380150534860010669751208271600431365616383e-01) }},
      {{ SC_(9.0335571289062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.8276487955834167470554956860481640517718200020320601611345663841403471437742777593105889694641906050e-01), SC_(-4.6981503532597433983545423672954203851991443059546839761068563022810960486476771936333706421848622367e-01), SC_(5.9151209362398275998236328248188728643438697160486319975508172545526440501804844632252770281104975942e-01) }},
      {{ SC_(9.0335571289062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.7952267886586993099444779734204320205874646639226293345506271276170963107584110759710218174647568334e-01), SC_(9.2518243402394630918182768617034264219609727072923815438161470618408019535276339486995179405053300869e-01), SC_(9.2994158166002946054820143477193286169264018601817512304550268649577619859642128917774109905812690950e-01) }},
      {{ SC_(1.1924230957031250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-5.8371348170025850467975297201475411589898602944442021124986554162626005479893850755343790403434025438e-01), SC_(8.1195971038060871248884272815187247516746102608797521703042353313780255497921615728296014934403164869e-01), SC_(9.9724903923096289869436454005750683921873311940277011265293695919091693925237191610328290932300982474e-01) }},
      {{ SC_(1.1924230957031250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-6.3715259410681494202797523434340921589406015910124997083200433893549993045703472800129397300408055503e-01), SC_(7.7073768029268967952932782357108681237498413843201864512762179302063927859082691023138828443327723704e-01), SC_(9.9626750394421118891589161882521604690570288718225541314218885326574466552050425010265508177603783089e-01) }},
      {{ SC_(1.1924230957031250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9893695331914233224932388429984677332685527484753931088319098828212051832567548047494122295175996988e-01), SC_(-4.6097324146523440013270387538252440940630343763689272833595712013314223049913087227932988634334445224e-02), SC_(9.7531931492284744673964343232716750125944380142789962242602188857182626334427546275923685625119735921e-01) }},
      {{ SC_(1.1924230957031250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.5645040312450942814307404444776333906500529725716918897669529261761783197171574427728804110077931118e-02), SC_(-9.9632571334372307913802216241225787978787853932989237297918646142892368231622834688250600220517100983e-01), SC_(9.9965164479953860856792429288904374507600615123658417752022126303125043604258326738510331832169463236e-01) }},
      {{ SC_(1.1924230957031250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9285414384256021470812458092265356465028069854435227730363483143942840765524035782898615052594197613e-01), SC_(1.1933419063561268604675133785649450221706075610146239844125815365159051250951142666844227368832897301e-01), SC_(7.7834200969262046798144745190698020923111799006562720963464983185024571221214591836184750873680022992e-01) }},
      {{ SC_(1.1924230957031250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.8998007749475104708483873240522739238675705355558121396572110868253171485103017704437598536606753747e-01), SC_(-1.4120710379965560138293387729629729978428282677816938229474801169000310710433988464347256580536215757e-01), SC_(5.9115220154892639142556202745123861109522004792659601299782058897034682117405586384700971912559871435e-01) }},
      {{ SC_(1.1924230957031250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.3386460201929056058296483511041601432877500004901458619354786536863838466236888969489653613074249724e-01), SC_(-6.7929577203385292148508551337098374448682615555696471242372591430652743779635577613928030308723000604e-01), SC_(7.9025114936029102272210982610143052299680342795743198291208213547769481387134598889276099484625879767e-01) }},
      {{ SC_(1.1924230957031250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-6.0519874419346427915448621334650325988006441340153925697070066706653313113388575798404674895297748699e-01), SC_(7.9607441864856691704142391512283099205692960449698642329036412765158556602985588737486579742068631747e-01), SC_(8.3635773649388638346331680241106729783044557631798194726194164692010642273451765851803649083145401375e-01) }},
      {{ SC_(1.1924230957031250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9460568385494482703656460591434492724578400140243509320548414364693351353061023650962336140267703502e-01), SC_(-1.0372817188901741666050857061563620983915922101575929275489512560181374879782279424109399198329916831e-01), SC_(4.1799611006449300798861457778503488788954493264050318558304812326599346547616283185552057769114661184e-01) }},
      {{ SC_(1.1924230957031250000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.4086474172215898880945219762955964483909050538609485633672591276622515003788422899941136471491309345e-01), SC_(-5.4124531049102573846341160722930775058590128211674697354857659607933985957376991645219039559550960086e-01), SC_(5.7990127775001914607456884584507604097609654643474688975739045063998034704141706812342143317962066202e-01) }},
      {{ SC_(1.2011218261718750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.4346353665329750374238653693476739711858954798669210088668212399228996066416352736047036157140206986e-01), SC_(9.6991005063370101306272477480018720778393787437396480120792368926344858401864363048782010701438802058e-01), SC_(9.9952196593780848918838949078925749789508583911296916116603617795975324282495873961335588967434762335e-01) }},
      {{ SC_(1.2011218261718750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.7719739910620237728214302767124837265845274666291230019688474212550104667505393136313739119234510724e-01), SC_(9.8417533079731135320623754804410672797270539192800515413181318726535301340545683268056486646410909938e-01), SC_(9.9971181029799665321865026976105967339872764365890046115030075747118907477152356453722464204987959537e-01) }},
      {{ SC_(1.2011218261718750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-6.9229412719218491506914485050482655842820601367358900829331508465459740438503894625198082555047695890e-01), SC_(7.2161543875890771781575886713912935217911465816334044935266962534169069466360585663526421274532611019e-01), SC_(9.8822300302794453353387257432326972739624934518936910069008704176861671107163613710577836216426590235e-01) }},
      {{ SC_(1.2011218261718750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.0999880379373052386417021725178214162372845632069764180180885639988180367995420123316343767700656520e-01), SC_(-5.8643152869940889792314971498927329746451324473134829719425702984450926232239510685084657909079384083e-01), SC_(9.6834519093223539240852383407109080071384690362014643089796154987107364070409034994577149084736821452e-01) }},
      {{ SC_(1.2011218261718750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-6.6546849951487797248037609668025737989965468169896738855429810263068560128961893484140920515209975980e-01), SC_(7.4642593480761160895925260449361932946953832259684853927155939166341985615776006419123061585288518459e-01), SC_(9.0714639994979153882457501743479966010498353034381684818140287070520460926490010940326751609348688599e-01) }},
      {{ SC_(1.2011218261718750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.2895458138043534407841206147773996903306355066670699565560481066072549343562016681630589218334339244e-01), SC_(3.7019371379360310194349363535896235740530850136085688791420090617735429266752649754660957291596491850e-01), SC_(6.5359889753526918635060543007986908256231267033208171398140379458231109328206763747216361247658352879e-01) }},
      {{ SC_(1.2011218261718750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.3998458416227392571062207376348139831005353538955063512497002941311608703689834876185551231952599485e-02), SC_(-9.9971199552353306981904102575118588116967671690548076738795399376253743294017733002380869795225773118e-01), SC_(9.9979920080365833589369264297384728917127558878746446029232585255083770796359954551529658214418439853e-01) }},
      {{ SC_(1.2011218261718750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.7772655788738409842388975310502659552257265546968229451090391943528555682290018856885533103264758472e-01), SC_(9.8407991068891468815733262432500660202736345756858188260210946886188815202697177408120861303675598174e-01), SC_(9.8695713823431480292427319445020941930147601233275068596391279098427777408045883897613166784682229554e-01) }},
      {{ SC_(1.2011218261718750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.6523316595667396259231173855000973723127547139287182684480344889643061541954121200743077068316913449e-01), SC_(2.6139038876220353583101795451266063882563474355239223110879037845286901123256887709914041140232359557e-01), SC_(4.7195868274023126845840205457280244944041236165929837845097577900297068067598350463080547590240299518e-01) }},
      {{ SC_(1.2011218261718750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.8020745751100563563526820922809619354395674380616514881604689604787683170481460109658346899301911008e-01), SC_(-1.9797307958358904485409201852755917826551660506917247248841139086369353626037181692165361670138564311e-01), SC_(3.1318716894044719354452028011963390927153443841773754516209256873199333718310498941901941245531990729e-01) }},
      {{ SC_(1.2588946533203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-2.8156891199598271954530845089870114748747364564928811257747363704923113666278595619885202858887007290e-01), SC_(9.5954100891905528738432717913644120337799942267697822648042875905062261530727703028678986808131750729e-01), SC_(9.9936056640034402303786126231038383562631117723150844589931179552156505022242166603536158663165961880e-01) }},
      {{ SC_(1.2588946533203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-3.4922485461942903831002706953256089021032005287377448995399943564212684074479960786346554051112400694e-01), SC_(9.3703895378796214305354715996831321052454659031719040496620841593385967019899654764037512128554532300e-01), SC_(9.9888016325000345297150283507821877694048334682781443186812797644084511929765793063983553845976727719e-01) }},
      {{ SC_(1.2588946533203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.7321154602490444546419973090646215324910682563580176189070355160598330058994586294077549996901560522e-01), SC_(2.2991147575494202863182293633857229646704482938767278055230732263693936706272641714803801545893098825e-01), SC_(9.7658918935521118361021864093937902061812960232858971689724181072298072644007247406802088615747561083e-01) }},
      {{ SC_(1.2588946533203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-2.8751752936545647477729320094439969632151406412443170878016430524586714029102707842261902655413467175e-01), SC_(-9.5777537570538107549426334462286706855097435998204962114649575283709555804537233507695365075690077806e-01), SC_(9.9606698365372693046021085891259293000540240974780008572273920534334226270111883563700257511443151435e-01) }},
      {{ SC_(1.2588946533203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.7123757760566517528120437737587371448016560188130359595205224595741499251217371515130926809672346839e-01), SC_(-2.3811251089911154856578861068354434029578007205192566925156125550564295085446697291667057239840952849e-01), SC_(7.8917291013113622039646747394810866543768921795824789420402391861753742606228278303128064785122278408e-01) }},
      {{ SC_(1.2588946533203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-3.1935077891481002569235035488337500670402541335350183798608054615744514117787918374407014305631093366e-01), SC_(-9.4763657591215005207930094425878720617297240574020282760728916460438399527008435803847180862304447134e-01), SC_(9.6555943587039071369638115118301554123892513603434597570633659348993913099976612175655242318010286896e-01) }},
      {{ SC_(1.2588946533203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6647052610544409962367914196590383306791091878059176054044877478555135590557734263305176967534951982e-01), SC_(2.5677757333822222866149626920839121842282446865369501818405604186385213456083611141008934808367815362e-01), SC_(5.9053641747621718115571135905158050883978797566836363021392117083768326505113827097078971302734515247e-01) }},
      {{ SC_(1.2588946533203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.9630976009294496871505799914209884341653582927639283595200928915154865640073845175606177195776209093e-01), SC_(-4.4342847671538578667552929304761355054682042373445900168592919918492965221032859539524661974472124717e-01), SC_(5.8383825825098083614295141116797741698212853518846467369980358046616665963046575079303996500489184671e-01) }},
      {{ SC_(1.2588946533203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.6671675550315915023953817801439234543039456353563589571148444391655553646360284387501900623603159230e-01), SC_(-8.2391268896162324670832991410037537999769015402074639086978323989475632560572995889553201047695337114e-01), SC_(8.5560735412539100017806440191444430387040877399894322661736784756033952247662856454518037917116186141e-01) }},
      {{ SC_(1.2588946533203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.8840783071654509652831863561732638786012425423153969807806913821255314364988324359382934391940355148e-01), SC_(1.5182213336076374464789245462217358722092272936179630975076025945867377271659007192620739327688004630e-01), SC_(2.8797974733776662740250616030300145105037777155815025913561130710929860845117693292472702407763961732e-01) }},
      {{ SC_(1.3400341796875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9837550517988426641107248112391940630115099900293437529641297967757074011407290345564198153154440315e-01), SC_(5.6976755407893176452807425006892700813906158361891430352264559808537444488608157691921482035943054353e-02), SC_(9.9193079482417282220309056926937738322060635203032443549676096387329952891654611016219347521914322610e-01) }},
      {{ SC_(1.3400341796875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9128732301992783092707597524847462310078418185746351890721426750383360870344136313216937142325014422e-01), SC_(1.3171728519820494179834552146252862996414206794010492518111167243437497768223350382114500573658605566e-01), SC_(9.9094117521805212701620100247149571137882662722712152077457417100085634748654907646133050400729184421e-01) }},
      {{ SC_(1.3400341796875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.8810446975450286376760171968925396030867311220082425699084698694263194832834174360030001863092336056e-01), SC_(9.2161538645824277049218565357760010249394894820025681021566687552479979495602931354154318334419790555e-01), SC_(9.9631373241493230743758991273672305655265555282321101442246209209055721771598124125632880185175016215e-01) }},
      {{ SC_(1.3400341796875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.4333892050194903403063740554726314015304565294347212736919832618163076223416295616143037055970317188e-01), SC_(3.3183080186477186107447470105161365042914489756986084047595634716379181456529189465621414476992078659e-01), SC_(9.5681245584756956464800213400214503675890562005027803738919483239710375876639436329194301025913457347e-01) }},
      {{ SC_(1.3400341796875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.4961226283590226711798039600508896614793345463538559611941214602561424677666948972941781240922065686e-01), SC_(5.2740781454094678909570808989851756453903260160599689021448299955466078522749971891371827638373222285e-01), SC_(8.4341655858962134619872736646751839449661196384473155521977168030804816134740117883522421640388565308e-01) }},
      {{ SC_(1.3400341796875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-3.3144931202440392632578455789555115965996230641557414077868340447332011009066263482295359914224480289e-01), SC_(-9.4347302746742544426728902302895616503157544224013162198602053140295508306413221448628279099005071913e-01), SC_(9.6284923347454600373678773974628372575662718985042065718711905308264644590087722827903877527834152155e-01) }},
      {{ SC_(1.3400341796875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.3459450145287394186088421459803373266558905683078274040976334715045233998482031871400588590256724230e-01), SC_(3.5571493903694009372879955758147040306615163945489197016245740667272221351379700812843311536502574815e-01), SC_(6.2528779384734303133565219942586385009179077459171094562550016536268970634867391227417762565453007943e-01) }},
      {{ SC_(1.3400341796875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-2.2857336304424362310003630425084627984155500510046622774800566088785466516411356191602698389531518692e-01), SC_(-9.7352669080341315701678925411787303440990275242172478972280934179874926627292127734872061028727872051e-01), SC_(9.7833250624471137552103262912237378336551026916532234670210203807220416914118081786423275211873688282e-01) }},
      {{ SC_(1.3400341796875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.8232388517464306143859027763013053675164481592252472684095396114091583347039863881203733145488310476e-01), SC_(-1.8718916799696149557166466943343357435959667090778980006889537676174767549485772666411921488571332670e-01), SC_(4.4156163756363006975380149882769903380585115777905317708174999723854017265889869146583018521778789345e-01) }},
      {{ SC_(1.3400341796875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-7.2138902966448765142295275839520899517638050828758027046017003011981437919933223900785597602176874072e-01), SC_(6.9253004835871847913290001855038986870920417100846458230514023712321205632670316780457839999529429553e-01), SC_(7.1518950972952259998329201633121574881352191219687152262395558854140082597776562280650440174770259311e-01) }},
      {{ SC_(1.6231677246093750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9124677882433138335861501925856894780980206165671381753478059083413907347024975439942215033445157949e-01), SC_(-1.3202205675714592427718254514834324301815345706789496615621376667227690515141082247360474561661240443e-01), SC_(9.9204607726027533602354699502327102937400121831526521421541403184024105940052308003269121340144283988e-01) }},
      {{ SC_(1.6231677246093750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.7516034259541766832150349341872086564396925791399754972267936469741660587204966984616105782367152928e-01), SC_(-2.2150012692815243960071387029603330592398386630537251490301218031879620399465277114845960453761665302e-01), SC_(9.9123482144313188533895847795265470715360518638484288185158750009950362801701609685428704513319459538e-01) }},
      {{ SC_(1.6231677246093750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.2827876637300902422714770563788884954611508243954312478064023204948598577792086805194782518769287677e-02), SC_(-9.9656386792405636732705960759776360639986212735703590448231548901906231554074115893865458338080451794e-01), SC_(9.9983239853184367656672743779286924702272039747960829744989295550498583226501492051628115076416392748e-01) }},
      {{ SC_(1.6231677246093750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5506675897819312444525549935823408506042141456220310967658782559131651991047361038470264508397118216e-01), SC_(2.9639076553578716872711753452900052027236578609447751333708319665997262247754910375915133116162956859e-01), SC_(9.5570691863947236969442424380095058040510410373276837248763187882259455735494554951739465660352624652e-01) }},
      {{ SC_(1.6231677246093750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.0002523398382543681800206047411849418695493214830369734129816803359453528771825114878762031453647359e-01), SC_(4.3583778885310102723058054463900515598713236239557026600910794640200440805482288047647589880611490321e-01), SC_(8.2224112100382522609932455779878309159269999814419709511222542298546446627328878701723889492921451857e-01) }},
      {{ SC_(1.6231677246093750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9561697298690910267695558064077766360534911018655431841027171538674183505569070764570479021159132324e-01), SC_(9.5530655042350518464541898921176605033748943044753169069081873647761174967852998814561576646304970337e-01), SC_(9.7056332084102464505481812088428585524040230132487801319676869202426346362046456969139441494474696356e-01) }},
      {{ SC_(1.6231677246093750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-6.5207431450834327054193903400431942384143242874532857303832484618122297442007668295686196371374135211e-01), SC_(-7.5815505561756575607736141029815029326617238047102909950205264617958329946074883502155662164529332581e-01), SC_(8.3876894425574629158182235563773283602330740702959357350648248997894678722425718913737954796528549306e-01) }},
      {{ SC_(1.6231677246093750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-7.1235982427664551751829001799194987435282300628949215529979833897451333883821902796791274236613513175e-01), SC_(-7.0181442045354605237259676711891065830110305240818315469574742850840925423770807258624692305683915004e-01), SC_(7.6397177830592032370220248458070749718738324548514924173943617772087324512803480619530278060182723295e-01) }},
      {{ SC_(1.6231677246093750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6143844009063285164901165944361377387998032971936818485209064897489619923190307695665020659123500095e-01), SC_(-2.7502022819438315815381856063612385614341352597910556494996103477245179891200648759424635924481328118e-01), SC_(4.7837683766226543752651102357163179377431021481571870226311407495749951960891414569586234247226477022e-01) }},
      {{ SC_(1.6231677246093750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.0266789273367661138943653340328062266389053034094918341344781374557666512309684552029550514807038668e-01), SC_(-7.9799211215897971548175796169872890746829567015373564770946213409418853442707799311232206073901010070e-01), SC_(8.1182163315848315060591347077881003111492572447659943409549571110899856686261789519288489847500494391e-01) }},
      {{ SC_(1.6535034179687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6834778206022232667776599763459462670717771858660232869312528460757136189146070886877283739241268019e-01), SC_(2.4960483364520039491683531768738282821122002471182623021779467285026182210281935636842976195009141303e-01), SC_(9.9241071213550529394758737916398026721245899214078026141721998009371981985448875328424864304589350800e-01) }},
      {{ SC_(1.6535034179687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.4110860151289255582558784137824904166610718063095938521728938906354070405439340019359106455077401611e-01), SC_(3.3810442197411084345948635795737877761548344879618587642887442190626626171688736883665440979677925052e-01), SC_(9.9183875357931180410280312006655259974108990083284570656558808381510663175225169636095650958014122782e-01) }},
      {{ SC_(1.6535034179687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-6.4511913112683175506790955304279732843753796448403736924046364598374533065443802078742116170511576258e-02), SC_(9.9791693695745119193010371907034969522127686619966949408435068833888554016295560514181735261696113761e-01), SC_(9.9989833059380127364456890934680134501751454926026260704239069482460978121277504045656166455476660914e-01) }},
      {{ SC_(1.6535034179687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.8696844379298289875792729444655615929977189927083885338621548972450163795072222780796372670825687639e-01), SC_(-4.6183003336233356781931253849819847590022681001496591696355223648051326746576546312754910540565862449e-01), SC_(9.6191907804053964402661147130676230734290656568476021914117959986635158006242799607579106329825936680e-01) }},
      {{ SC_(1.6535034179687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9928257618481559151783955938799972633315205407706563649481440783518627214257577052518241460730944760e-01), SC_(-3.7872588153415435835623003363094851898490467919779727254736816319134398545924076427382566589812248196e-02), SC_(7.7504536440118123498953772470744025283552550133879670503358671978028372082077949605023853601241743091e-01) }},
      {{ SC_(1.6535034179687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.2701748457183925810591483837991263336296631864552238895285120270469756982676649094531496105201072536e-01), SC_(-7.7900518229418943829725241951262469985498949663752467589718175499918860851165868903660992969029789553e-01), SC_(8.5967231701474797025494928125820473451437092568339296656433455295312147440773913824522518534960757442e-01) }},
      {{ SC_(1.6535034179687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-3.4261806997135142080432084217817036481910267151813067991587668680875384697051150333079049171764852872e-01), SC_(9.3947477780359071320653067162790343753173755477934065305751221895218763201774365209062506405863778349e-01), SC_(9.5820306129043441160291657104543207862445498646223566816834402814866862367349904220865403963413806845e-01) }},
      {{ SC_(1.6535034179687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-6.1832684752345778110700005116411589206453010034043965479722855805407063118426896172154156867923434996e-01), SC_(7.8592105814242093768067301574861285576722214358281880166901660581513496083105636219233740977487403029e-01), SC_(8.2844166214801489908502319091146788454806214710889442411706037645998753938654872393174523203717676420e-01) }},
      {{ SC_(1.6535034179687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.9281425834303854128560218965534040739949827053526532026980592881553542689805409968427049792121981322e-01), SC_(-4.5042502161777162363063775063774245349536708712856153529314394800478070032740873290690225106463543594e-01), SC_(5.7879231769061342055273986699571534037810237382493737586486451127796177514661109865221934707989720140e-01) }},
      {{ SC_(1.6535034179687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9274189011718790992101165193192556513469470047834354289955223536185935578171428750870461445727800937e-01), SC_(-1.2026445695446849530915089795436473519663576508406158584824903552043701790706788571374654865502523133e-01), SC_(2.7362788765992056632769952088614784725057580838408173499315821831555215576980105742320453775245488114e-01) }},
      {{ SC_(1.8286676025390625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.6814236833955854983220539812497431275744279899792857145102095113729857268227212553485268310013986664e-02), SC_(9.9622451700554821393152718469722048875147104735191760070210560484655209249565959152741966686654084835e-01), SC_(9.9993923097425287563884901121392838737572346332737831389382542365496000542740414695585089455418210302e-01) }},
      {{ SC_(1.8286676025390625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-1.8926980088511791775054115782139653136995321885260086536145064658011406616561464849165705079242110845e-01), SC_(9.8192512060386143105993402739811080881564982680268751987488245789702929466675062817196266752291366143e-01), SC_(9.9967119740029564252316520623600610677626005720075388824094627942214462645922884022097976372835783112e-01) }},
      {{ SC_(1.8286676025390625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9908160921638027804641309903616079585634962657310202503129571974422627743160465633137246808486024054e-01), SC_(-4.2847848552850425003613151335319264305350622566652033434342676055731692214494611298524009974991944009e-02), SC_(9.7531207591886081797031316476844555058679596332884233582030283412987144974089095236709109167440508078e-01) }},
      {{ SC_(1.8286676025390625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3949846968910248620911834180432432223320046459018429982223637910184007523777810333423856874567140651e-01), SC_(-7.6879236941146604274253915774939137120928536384549446939674389528157953207327832985257526700918923148e-01), SC_(9.8038895526663558561624544529383519706491281050224577824578214085572675871067443909437967206316317703e-01) }},
      {{ SC_(1.8286676025390625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.8684100118259816529781350234103765528218497055716405339633473465749200405130718517181282062273576671e-01), SC_(-1.6169365598231517048457880534222065567782374760682944377466888287656804160252913942212230871008864738e-01), SC_(7.8139395336157016565072496682697996959068077220382069437819056426590844188813558032018072982044202136e-01) }},
      {{ SC_(1.8286676025390625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-5.4736155475368567110643926243049367559923415013405283766055425467511520678111354390005167442852644665e-01), SC_(-8.3689624708062107733215295615819723432948373918533973635780156166954196362136434252038099532280480058e-01), SC_(8.9505871230937231832559096975716226426776453981901529883728024071814184821390106944922329601865098619e-01) }},
      {{ SC_(1.8286676025390625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.3877348694410033274900433884973824067030882147557348614564799476042158225143966040629487264525528443e-01), SC_(8.4245066904009005498765013613628519161402814224963755819982209776597523499464855395207543982694188032e-01), SC_(8.9308882283123565901599395848425019647117366099204928805947492004286886876233512016485828656546619163e-01) }},
      {{ SC_(1.8286676025390625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.5622745866317164473510845776162533227864947105408759388120253617617194708128735419468767291143248821e-01), SC_(2.9262441336732716880291603154649711851757662763044926572337121778328437735336001951206523652651065465e-01), SC_(4.9979634478165670083559785578402946040666839552446785000065775030919730605309049959839850638072350388e-01) }},
      {{ SC_(1.8286676025390625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-1.0884139299144661305081543115863986602351912235275408677840659838207822677641073965632881185488393433e-01), SC_(-9.9405912860940091871949084763554130076165536813024984390765976546110453818462507570486785694344137641e-01), SC_(9.9504624791174310826968157344550795613553323643820759457294379839988952075868819433018579518780433713e-01) }},
      {{ SC_(1.8286676025390625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9896577690526427353061190792106723138470133261364509629452975240660551334420292102291509649494124385e-01), SC_(-4.5468412904584301042401356289996602467454642509858661666945301740955322667899397226404366996186091581e-02), SC_(2.5146746012339606135081500313033279983223230018276580199581435797368490038637749546416987838098593525e-01) }},
      {{ SC_(1.8300268554687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.8979951751271349361329717104627820415987097137930646656799969180126172044689169375802337094220305816e-02), SC_(9.9879976187744614954249873544202457615165542401598871230463479109573087123698409990993185686299548466e-01), SC_(9.9998065681077067931080474499603903613381832608534725738523891945209206719625867563696512771673607513e-01) }},
      {{ SC_(1.8300268554687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-5.4486642790585155542776713581487226138647244707482988166119521026050605402308789849200261572943295003e-02), SC_(9.9851449952287181331176293601409708390103659481205137027897994507059776058753433488034697191916870103e-01), SC_(9.9997275497548174758836470802361710736532655708682336503401968007411452137919174555365074622647541576e-01) }},
      {{ SC_(1.8300268554687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9597882739369444790852490764334997147464298934933713313240300652642735331085291878503480420894191843e-01), SC_(8.9588924446503999740795961963216399530602456498085254163627013854849586522840203661023390529053311392e-02), SC_(9.7546710656069938493961743706369248807161427889163799129993853637301751204822674448698496973759808748e-01) }},
      {{ SC_(1.8300268554687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.3132547775332199707770094089036878949341154276949639831912312640303453535859877952677246903492168003e-01), SC_(-8.4716777363766861570764719605104081973652612625540980095174656643683330323621069170515474273074371709e-01), SC_(9.8650403203500720655738671549901752119944558110590357816811624326292675349650119563870699134430474348e-01) }},
      {{ SC_(1.8300268554687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9839528997817481164052949113055711838936701984244935881988735387448611544008820426884765706287674810e-01), SC_(-5.6629011552350359936085648130604464999884496312041367561812976698495586874576681035682661679412745815e-02), SC_(7.7550248604888910500163012383755385519854934094306855689157805361893017495261919344494034939879756831e-01) }},
      {{ SC_(1.8300268554687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-6.4266814983295747426951748248127931750574357319496923222075560779808924259089037121008429067813940767e-01), SC_(-7.6614466596738981795385009370194823699145567177231072871413820510140180290580339006369889963816452117e-01), SC_(8.5196616726973012992863191381501468947283658882473777352773459959208927734608382733169681144268824164e-01) }},
      {{ SC_(1.8300268554687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3449628493831019968303272694849759834201827523296311108358912464482695098739554555794390017576443010e-01), SC_(7.7292591132622968447540095207097463874364060674837099643420876759446621119530873028188587152371782855e-01), SC_(8.4811653916691626191498677474568086006124061003301489518270469621840639833868911409638969364375455559e-01) }},
      {{ SC_(1.8300268554687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.3334805261690271834432689443472462276611596647157762442791909523632614252802749096621123226033544577e-01), SC_(3.5897271856818784542872874264322142749670981535366987258319930423211806608978149830807080580477860148e-01), SC_(5.3410369503742296171313876179881503515338796331169614768037317091800794348381699620922898170008376011e-01) }},
      {{ SC_(1.8300268554687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-2.4075523008705922320438722844409241813586605820650395648747697714887618760108705260708526509757587684e-01), SC_(-9.7058586389135462896471244434970122317190236639120266168470853111571792244330672952633435334550593386e-01), SC_(9.7552241585774903305764397599702294819686980712209918664412407818208487885001548746829271486602784027e-01) }},
      {{ SC_(1.8300268554687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9678909746450010311040375609930548786721312829850003347647134553256479376140041895932118885830903296e-01), SC_(-8.0071812617845202072200250641988711220008544976613597003278009183931824267450019017505791443616095667e-02), SC_(2.5944889355661670030422550872723352047505478163143538988216900437521459771871070293328125020884802244e-01) }},
      {{ SC_(1.8595538330078125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.5207439704134228047204314486507313036215735069107666288485527524262340607820974822934711454420003067e-01), SC_(-9.8836904937604768475003980087848052296841413013458059942492381302879300091904145577042917566381678912e-01), SC_(9.9981351672966137538157415232087703857391713918668706141611529154125197261473405488084506842167741899e-01) }},
      {{ SC_(1.8595538330078125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.5507297548929266838110776126540447754029701508059634482467232207081757635991721439676564943915973358e-01), SC_(-9.6692180509855020107420442422105488512896863109637831244811958564662752819194952065452181408818758957e-01), SC_(9.9940274499740405081525070486224662501302066161285266636163919450345102323852538614245194225366979917e-01) }},
      {{ SC_(1.8595538330078125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9116496448216395680569778473816797336045240970718320510410492452111231747211761166684825899197535863e-01), SC_(1.3263488674956774730756775160932939266754190113448551582905188715106923009372092142223815757917442750e-01), SC_(9.7570662857424879310703916044065233309790416766959585948782020563712027422818620743222861003406685510e-01) }},
      {{ SC_(1.8595538330078125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-7.3296807166173634608156367600433463515467772846462367773771766986463615542503764722665281659886648135e-01), SC_(6.8026304171583195922421525609437755912210915325282532525544314907699392347205573933187371998126686315e-01), SC_(9.7415593244374259917082669358443669014956984339319967191486717197343759917825920424497168122299510211e-01) }},
      {{ SC_(1.8595538330078125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.5858961867945546957722266464564314300116355172875799765747547664276392102709696703911424884089935729e-01), SC_(5.1266350240276248028232580428588347284658552374057153955524128288999460718123927917862157558873103170e-01), SC_(8.3977336468050303890920245740943701834120526885539671891745317343059450876963309286548685621665655979e-01) }},
      {{ SC_(1.8595538330078125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-3.4786831662830835288619459510853702112998979463628482224592812784288134582441963022591234798464681327e-01), SC_(9.3754340394788496763185810339149240332042712880445072628303538234352087471220358529188902304696246907e-01), SC_(9.5899692045544795455088644537712764764638130774652803613532908402918146975121904600328379742218781427e-01) }},
      {{ SC_(1.8595538330078125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.3664398508976124433489819513770849928408419855391275723063941119507916803151839449690077933961455663e-01), SC_(-8.9963438700670638612550094664851504241107712315967384818280510560089682637279155416190905753918626557e-01), SC_(9.3116369558706107111120515262068608670685042904105246958990308010240769152306249948165320902364979630e-01) }},
      {{ SC_(1.8595538330078125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1994257429306591371166743540126245348251041008682642294873698861087781440652597306023296119934041787e-01), SC_(3.9205313415791857675346069880731348858647813015156484986873510248261581103755353853398335801658563259e-01), SC_(5.5285661450696736453244663394739894443772884607841333935882639546140967549842413556909504792246626445e-01) }},
      {{ SC_(1.8595538330078125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.2737093158567720094623815297973444655361477154043027640111951812939439309043342217883326967269821849e-01), SC_(3.7414322825612281345021351952554034220264105662542785778147007280874746186635192281544763309082942226e-01), SC_(5.3153199228812447789395563158498134140056283833084915582221514138460597183214768948843778924645944394e-01) }},
      {{ SC_(1.8595538330078125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-4.3163443397645219522190722219967645863302428319090031511398861046534414979904060364684679065227713794e-01), SC_(-9.0204862142005833829530661009090961892600008096400777079514049013928590521866371410268649079387073226e-01), SC_(9.0835649612240474327194980377973022405243119060594877789433604588157398950567201904084032075698643405e-01) }},
      {{ SC_(1.8707794189453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.2367002487005488956061718802856039685537641095930205411285324673161748344812351179966817436513693303e-01), SC_(-5.6706938740383716794475647959940664916417970457614375609639498071373704040320751522900452966972961013e-01), SC_(9.9451487647188136251623321355538719213753690995802495053413195908649709732240653465071682124628696324e-01) }},
      {{ SC_(1.8707794189453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-7.5972005761648125856814150089991111644355252351454782426021072528692811924063835093185222049756352357e-01), SC_(-6.5025028570175222709041509356077459957994257581181453789335834984351850745217027368428920487957916379e-01), SC_(9.9468916094071290584019776796156801457566287910782379977456934050170634093543284893062777847322950414e-01) }},
      {{ SC_(1.8707794189453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.6685221274134811419275621463822311529060337909767344745606376170308421386692333813736268216427916760e-01), SC_(-8.2381950020027895590351187615502918521715200403086409853085040370570353556299231210556864254099650036e-01), SC_(9.9211970230092091979012504414703268649310211292156159220649131309702506231543251837709874809832422966e-01) }},
      {{ SC_(1.8707794189453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.8749669776549004655303231075761381158450485549128692976333652068013487094642648615544422102584689997e-01), SC_(9.5778162896034838828157701538154307711826473973262271911100097171457014469471051639577420070759881409e-01), SC_(9.9606755467824915319061297155199909102240369386931258701377316809421592173473297286730479837180427107e-01) }},
      {{ SC_(1.8707794189453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.3902327548422347645783982456761152740550460220090446256861284200682660472946370304104763253754356071e-01), SC_(-3.4385358526396106980417242922320059655138856582579212585073627833022318425818257437039487776970969063e-01), SC_(8.0461262571161835165093601515758072932904224960149399538595582391483979873324536342421387355644982655e-01) }},
      {{ SC_(1.8707794189453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.5870838869295763466193504065423477892636749596325309113658455373308797510557911097924855923176966014e-01), SC_(7.5239833776100771138451138588635229180020049123202984794447127827063473465933263560868337520582700842e-01), SC_(8.4379527422052420661659836938275190906266850384796024731993225473566323420783157190529314606310941811e-01) }},
      {{ SC_(1.8707794189453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-5.8869959924624129206044846023230558572552834892715334629620983614908332228303103623142427103232749868e-01), SC_(-8.0835189233855010451209116995633974332525172397027045841785405869013526716285166487872840845120503551e-01), SC_(8.7083857264742105033706895401400027767465209209810019295783979575529903431715715639888361192476498265e-01) }},
      {{ SC_(1.8707794189453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9384142348721629211294073012228459212265761357756200919229121291997318295390748622885251418713701905e-01), SC_(-1.1081166437204886887892298046734059397574225779482496551574019906102970305485018892828255524091661493e-01), SC_(4.3544906192189495633440730821800227012996504897697408731292036355672163642648287143881574236288454679e-01) }},
      {{ SC_(1.8707794189453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-3.5141701158840170175070956949465856429665871852421922158031648548813027018774644422170314135413986294e-01), SC_(9.3621903631910686761492990852625497909275626768588240949561585258403009925559571115563759757459972308e-01), SC_(9.4708739159236047917602470340156103422899067349277155221815805037702682448752589111807531338056412109e-01) }},
      {{ SC_(1.8707794189453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.2913541882598566186786820998573145010168952450826920632424672642833020923720860846605090372991938864e-01), SC_(-3.6973960226497270482311003837156717720450939012908135481201117183944446687995541669601570624162471705e-01), SC_(4.3545733568846757433294948816819366923985494205419813603777535204760987825242992021715086158996751478e-01) }},
      {{ SC_(1.8754711914062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9062796376713251718736285660669447000880273852040532467639595228539032539763060039950453270500622329e-01), SC_(-1.3658783768178184578002250622895642216473247310478769692200346045923057756404020275944999977052001840e-01), SC_(9.9205604485160594573033937613719463311394133685054261107286316673579147434317056469910120006375924868e-01) }},
      {{ SC_(1.8754711914062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.7083434330817041651004084793223640321456925602368568038541225876765282144870483030608693448908872782e-01), SC_(-2.3975128331959665073776738916203880428275094384914288453065821249828514683542602862795329383149394840e-01), SC_(9.9131275700277001008148579339108993901364925540699504531657267402620207607735839219600525624974854842e-01) }},
      {{ SC_(1.8754711914062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3474096255842732949637069244137662761106355834411140778862588988774278273364516362683989240966464766e-01), SC_(-9.9088085712099034602030682313662046701200168992760843213934768470683441389842579429193463992239425457e-01), SC_(9.9955640770553631311212590876855542101627638336329905344328232846738996286239562522822156466564457582e-01) }},
      {{ SC_(1.8754711914062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.8526777164605684176032415039634930165954227866088211850213035733348596211563855263674783341663400103e-01), SC_(7.2829120627894972187814905204253466440316419755234404970786913822762271113326363435495756080103894212e-01), SC_(9.7744785887872058261843792954458119009359625493189896106902415786468788495706011670822494637263225625e-01) }},
      {{ SC_(1.8754711914062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.3425438550691758345079464306324722939665834325635045181145666947944295568484156355418095181821482818e-01), SC_(-6.7887443416574383308627052272738770181519848931442932353893946113148339302850990439823547206658063709e-01), SC_(8.8567140772600012339824022172488197034041880085936647000316267224893522703020776203869045551729598922e-01) }},
      {{ SC_(1.8754711914062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.8160839042804485807955841365342438302737238395254132417532611246597049694198514367710445092705531827e-01), SC_(4.7198161608994054489835503244594457061967016821067810362016052496014948689656916945278728972055205256e-01), SC_(6.9576750549829011506379367663608709612802483215688800135986759504888933129590663652175456658299353392e-01) }},
      {{ SC_(1.8754711914062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.4164148193577940051925589526856387854171401748560269724735405434030767542201032627696130195537020058e-01), SC_(-5.4003668012917892634903273341312968327131126584829748758738287315087104064057259359148361155362027010e-01), SC_(7.1140952664856991712787861500873006936037072522081076384831061003683402023160545454033608142439700866e-01) }},
      {{ SC_(1.8754711914062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.4562719246419696499137089508078763002529401055646899406051071462103765423483377320319371419745734241e-01), SC_(-3.2525253707278071085391628832837509266002648060378787788045426159965638277513226354651357962681188204e-01), SC_(5.1607845307528649750638540692042533273401542577058175707962735226183182442326083741720059287764011422e-01) }},
      {{ SC_(1.8754711914062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.0316905432303891462677788789556711108532551099990456110163822755429680776343916476126648779498671891e-01), SC_(9.9466383579081120900298974669536243693390466504092779739929494666047958868333667191484590866304079976e-01), SC_(9.9555025336079627227629985898537362596456522053976829048453787348767200571546664404384150067503193381e-01) }},
      {{ SC_(1.8754711914062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.7909440573623457432062000106770933064703577637930827938425248656161327113763813751881037315656247436e-01), SC_(-2.0340635352911095704136834005554946332812055916099900469135612040726125794635858424269211682591855641e-01), SC_(3.1643851583342783261040015163302268375683741005584660326365000866395922504348103604450994806966484912e-01) }},
      {{ SC_(1.8823712158203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.5365707001719464446941328016841831758604112026417727211428206155639572994385299511858233885755938253e-01), SC_(5.2083548919947692094097221884793397720937918096375660159202046045902682186176610898488385555402042257e-01), SC_(9.9410701151732099827610815983835750178613991370605218139731749308844338315380345039692926351074894727e-01) }},
      {{ SC_(1.8823712158203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.0396936681725516118422818883663971125142315916458330895562879838249162591356149858234902790592955701e-01), SC_(4.2759722152512963154227765838314692113238268405326278442226501115723323566880456842654699046349072429e-01), SC_(9.9247257811105551676032961833530109301561357642796073682346995657833498553574803568079308106951340411e-01) }},
      {{ SC_(1.8823712158203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-5.2568786226302590424593506492178702024964211404123708409749944776111228580762055147353676507021029603e-01), SC_(-8.5067753671372438881123235489582164650713558657256447270082945631736442630479588816823726696894974727e-01), SC_(9.9322642998008133009528199804177239740750503305994904699700389360847991260440161730258955646731209972e-01) }},
      {{ SC_(1.8823712158203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.8856624739233539139097219386784980079347840956131769346210749830607884170935524371651547632042848430e-01), SC_(1.5078718286590521743082284123321138081079422188531375194190861660343004912112274840346366371496361237e-01), SC_(9.5246645751908806298801327509231874287138935339535999431303087823221873398544733549952987060977880679e-01) }},
      {{ SC_(1.8823712158203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.6982412019649632062161542558245232926795203587261883683589570440200208399000756207292159445594423789e-01), SC_(-9.8547438738887880367841314924802942018580840275167984686608260925306449521745703245286770430107782769e-01), SC_(9.9421698779430725721741428430411346809025435127240270398590227071454111152205105255872866556879786519e-01) }},
      {{ SC_(1.8823712158203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9818658961078077578675972970669798376188617073113909162665712241252991578962736820364644887632800864e-01), SC_(6.0195783250977972537029124727429263670797535804255899789568375500003967198833150304623107640441313276e-02), SC_(5.8191996013124072261806101375753588807194976705465340082444646793449392660649632657756152148636183167e-01) }},
      {{ SC_(1.8823712158203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9022828187136105906196471291564661403216999556757961785350022987381939378971005699176778462832894500e-01), SC_(-1.3945590622878728025275854877999384343506864919871791332943482097212062454797896291672769010179047126e-01), SC_(5.6242410128269651318638171879962105108484764950203276397137500430679996064342827157574945687032422251e-01) }},
      {{ SC_(1.8823712158203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2225293676454039847118730433582317542163291424397756014069541407687639646436394282675749314004670213e-01), SC_(-6.9162901568326122999320827132211815197583814088740484133524667749619742473863985710935207989711357306e-01), SC_(7.5631229238157511512726921373977239294597026454840710311514394398122215634666408751297112080708332221e-01) }},
      {{ SC_(1.8823712158203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.6919704659039880874104416778008264328976415154519431700721206335721748887374586283547213989879869821e-01), SC_(7.4308499704588815369829896587146266571422905434113689822016960417977298702809469111464391421393157846e-01), SC_(7.9145423960264861511754592359292301577723424563365416540082864616725536077630976832346945222872767651e-01) }},
      {{ SC_(1.8823712158203125000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9985839569062744995928782846034896099475389962834323200371629156589152732329808666213597004256925246e-01), SC_(-1.6828207479249452270256743531578358888618739675818335576364041725962045072745517542819807243357365933e-02), SC_(2.4811500902814415099421134839814839535952252216355001408696023657939687982338280967593714006707275461e-01) }},
      {{ SC_(1.9244384765625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-2.7036961459445298652770365297301720178848257840545640891758154226512202840739891134316480516791739677e-02), SC_(-9.9963443453846690181960398703795842128843708482823352311391890992732287276687485991931020863560061815e-01), SC_(9.9999410608025568418304767245109278077965678455924012818036381723154626938361519854564227409987215862e-01) }},
      {{ SC_(1.9244384765625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1734915482199356102130036278032201601634483451974860767412689226690706880940935534712712022144078460e-02), SC_(-9.9665410428649604191931323210153286395288532319830878052000669565077331605137318973713012303054678671e-01), SC_(9.9993869022293475410189485316834760785303971582466027682533179798447934328845846384682182793416357727e-01) }},
      {{ SC_(1.9244384765625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9995218373496773263651925578727064401670607131470342952612607571530019811079404407381908664393766975e-01), SC_(9.7790717181812860926422150641412403956874639089016646724060828887361930395181076922422679433611939212e-03), SC_(9.7526848655233394716795552507461466168951466979791086946976388120506542592942753981208637632441756244e-01) }},
      {{ SC_(1.9244384765625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-7.0063055207436460764834115746422976632488080032668076636963831213632189271948763173884625585587269580e-01), SC_(7.1352423189403390000873839748233370773517976931635994639101499750601024513038405989182990240690226540e-01), SC_(9.7641300325014709214627720331871351426028634446146550972861679142906428089751954497725756354213272840e-01) }},
      {{ SC_(1.9244384765625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.5629311263560406562094673001634381052191835088565210424531588861173882757186208678216556508550679430e-01), SC_(8.8982953163025104299147108375948216001789684883235282506986645023899414807723796165371648531014475864e-01), SC_(9.5746748699222340507907981437994911748902154858264449133550586012444476527797310093949750934672288837e-01) }},
      {{ SC_(1.9244384765625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9953404483308624966483176051214847508294522252026131907613636431223482652177643759261486975328029866e-01), SC_(3.0523650168515675894001852148723589874270849466598069951938747857113554940361394490823395543773394233e-02), SC_(5.8038268943952965692251653605728871453525294638209731912241246940641332498081284925022636386294524695e-01) }},
      {{ SC_(1.9244384765625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9459247800658676097860133561593808854776558809024148626279523955355290381658953398402930347507821901e-01), SC_(1.0385471916440403216307539217164608185195547329915757301062076486879434279879750738514700230252212763e-01), SC_(5.5702897854142442809611654478963959324261775797147550071864942887044712808658131231637010349995702522e-01) }},
      {{ SC_(1.9244384765625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.8270115775193423620255579638055734154142840720846053962016385963039891369058232571134438249971299782e-01), SC_(4.6993474664403664402801695571076121740057255160045194624946246537172391662751582864322860663846755794e-01), SC_(6.0060827158178863368404500172080102632076625684813771196020909629280641279574615153270312721676292993e-01) }},
      {{ SC_(1.9244384765625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-3.0499633309357216160837947685508809398255521078686485810289070559124369255099465411452008206591216497e-01), SC_(-9.5235352511526662520363937890584200804697113358196926071621691184261145069006498967839187367230278540e-01), SC_(9.6041410479017780647642546421853134094118233510049076119516206412560578636505769948373386720382050372e-01) }},
      {{ SC_(1.9244384765625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.7703562086186605707652810260085804979481250950420318258041728072494841225884138094911078872313703606e-01), SC_(4.8042535293158825529589641475682597199231357338121232115205565947900759506420661006157314061468657855e-01), SC_(5.2721559756651726382324256487897356272038238081316030704213375897027127034023294653929546320025247369e-01) }},
      {{ SC_(1.9715252685546875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9999149217579438025155419990378050503774435663431440953044152660042130222829826356772642068616800226e-01), SC_(-4.1249940640159451218905143653088260520196509809885200974912119735128876297229127837040396959124726935e-03), SC_(9.9190454510523192870151020257793218111789942952070638913195077330681594450955229828271818098523095175e-01) }},
      {{ SC_(1.9715252685546875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9434482768426277476649034779467733059368058898480629473319245010863119376582776653994755154495576583e-01), SC_(1.0619964057167881835341514888736790094923878910656293614977154420369967365183882337460116321223340636e-01), SC_(9.9088494994688427220084094311943729183292306647285928784964966773416757025282807085924859312912955955e-01) }},
      {{ SC_(1.9715252685546875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-7.2863923780197472375944729124012739432330206691625337430224005433942015077316427862679405956591677094e-02), SC_(9.9734189153537192292701855468804208804195911507161872562581122221034533964836167194345541261731262046e-01), SC_(9.9987029950271100759091086168773309508042475821354228254985342328629376377136953466595469759241932790e-01) }},
      {{ SC_(1.9715252685546875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-6.4438953143877535562212080854310540201100159071875241724085078651193139555040088765595284332588609031e-01), SC_(-7.6469741190363365029329825419758457032026733632510013400465585566734752595369338949010268046961883438e-01), SC_(9.8008476769416633442530577739220493732979907125425643755174397779481355690658870638758907227004465396e-01) }},
      {{ SC_(1.9715252685546875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.9387502689389878225183349526237932217471297287328121519769701617770894461916996339991668619614720106e-01), SC_(-1.1050986796052184360390211918956482356707307302792124668112446870634519675064841811303841609817046435e-01), SC_(7.7782083010783148384110038999967915981917233380252884615756446459464833713263012454253928377642176473e-01) }},
      {{ SC_(1.9715252685546875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0692896438948333078582609551292864727528807834406627454741719659705582459890889300047150852328383914e-01), SC_(-4.2128357854468915494007141925104755456992245674324379641374290838680438635975287956170633686988273788e-01), SC_(6.7381912240981059330307389773430099004172998609294423672920782115012163917779546323448667567467913871e-01) }},
      {{ SC_(1.9715252685546875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.7776321201636010382337424408562096668543234507605495641318225337144791625772419859562530121151790673e-01), SC_(2.0971194822291466346030421849595858014680805590559492690127261632363629066019576649612096090094549878e-01), SC_(5.7742960193439094700348356947016724682361321289632632659151235741183259429995820997477679950807256189e-01) }},
      {{ SC_(1.9715252685546875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.5335552637509468619177212910424271793500604536736315130170091868994872898355573407901286288639274304e-01), SC_(-5.2132940220659440319333211591248886524580006933686352224178661371782672213885596221974167956318085725e-01), SC_(6.3445182831800375269300932933670770833130898600306348885566817247186267453097547880914732346671069865e-01) }},
      {{ SC_(1.9715252685546875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.2552432416186685026934526193128921379766826802420069334155189741447969109871574924231483351424206599e-01), SC_(9.4553366644396106872879025738016398857917167142462917144519103981246913164050418116860896385695109638e-01), SC_(9.5477600273005629053462961893870689852992588659840987337775533495567475431257098929765560217201525781e-01) }},
      {{ SC_(1.9715252685546875000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-3.9412307228568629478091636297546153976117178431143042104414325984436672903094560979335786919432390159e-01), SC_(-9.1905767168991723490423535241594951632963991958559280799910799985557761425472976757206816773545655546e-01), SC_(9.2422301160881704148508838860716761915357124551323944774087944758929470657071593948190980722116431319e-01) }},
      {{ SC_(1.9858453369140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.4054705213152072851451664130651061216499217259757217431721599006205998223273563720851776196554659711e-01), SC_(-9.9007400033388392914671454535086242072251869165129442669867317682364702240378428827847175171458794744e-01), SC_(9.9984071853366842614471458726841084906264079357521344888761890568442619129819452826610841761945249390e-01) }},
      {{ SC_(1.9858453369140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.5070640492058129942565255217740163494695763216559037381456171424195061110398681756028914124819463101e-01), SC_(-9.6806316866813889172199931228900862951312842168003652810485498962347027876607999917857526043808893858e-01), SC_(9.9942302452559713852269084116030636732630369591763149069010267256421389522467628458268739532812633610e-01) }},
      {{ SC_(1.9858453369140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7460959847396629023213294151850600468186754526453359707119955774767291431614264354511495305616871082e-01), SC_(2.2391098803411637082502445867797619686052486034294717623183478584718412642662476193997851593899862294e-01), SC_(9.7652107100176220018304071389988193041833109679443427832086050938061220329457600374867819614433504174e-01) }},
      {{ SC_(1.9858453369140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-8.7591137819560965793227178075846254493991687812511266984816459225474516690755277726181572540400781692e-01), SC_(4.8247202773577212421607049007306835524095045191215664111886203507494519542708812099117851390243407605e-01), SC_(9.6288079930202121551356736451843753542939778244370285463921850847493493915725115345472885123365413983e-01) }},
      {{ SC_(1.9858453369140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-4.6250242396649649980482066020190351615612321919279456557494609907194412689120822625415608757186732226e-01), SC_(8.8661801686245645800217768700725799498166537819118235942894900353237994345457404176820430584219016246e-01), SC_(9.5627540398922768507958728734673192109735702301637317713655951281056100713965361590625156345008848052e-01) }},
      {{ SC_(1.9858453369140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-1.1735531008826291520919245508896005477690524195845718339880048475212741686661323687535843820697763115e-01), SC_(-9.9308999148822744363057759901009520225182513004952136286524553869898571573704761432739426689545184600e-01), SC_(9.9541866617977664359846799474228301142404409511589411389238630589212796142638172458066619231854538725e-01) }},
      {{ SC_(1.9858453369140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-2.5661560264047896550977697577574285271994983541443544067356972715404806414952219948705677776708497000e-01), SC_(9.6651354490325887257750254185816231220218423716636053686841904330333698328423906111679391851744157820e-01), SC_(9.7677311539491902219065627087092296908401907255979252384756489646051968319678552175412452558572875080e-01) }},
      {{ SC_(1.9858453369140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-2.3043688031022365976100265167863985776533246242764453911544714145699594137367180026912374835735577553e-01), SC_(-9.7308727470504497158374043000785726585723147362213332885195842776034698222933783780401814107209214425e-01), SC_(9.7797376965032175821022437157898388837314600109117623736975241337618528076029566654878957935590182792e-01) }},
      {{ SC_(1.9858453369140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7024515945744297738657357466434755079331657796883714801833862664891641843430559561966177382852691399e-01), SC_(2.4212461780950951071551165255952297503000013061390990430320407464582844014750946659296356182356525586e-01), SC_(4.6330574762904332411829744686422163790342838342235753322328220006082956185458756739898418452935999869e-01) }},
      {{ SC_(1.9858453369140625000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(-9.6271921666412527706611162998623278828344436746037642935689292731054871089839252562699168099269047894e-01), SC_(-2.7050269844423550857864806232371501929916695397580524032916105445727409203649388936347088607548210605e-01), SC_(3.6052997174588038100329734639411992177585754440288098151836194079410246809516008674605501002506176314e-01) }}
   }};
//#undef SC_

