//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Device/IO/ReadRefsans.h
//! @brief     Declares functions readRefsans
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2023
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_DEVICE_IO_READREFSANS_H
#define BORNAGAIN_DEVICE_IO_READREFSANS_H

#include <istream>

class Datafield;

namespace Util::RW {

//! Reads Datafield from matrix data file from REFSANS instrument.
Datafield* readRefsans(std::istream& input_stream);

} // namespace Util::RW

#endif // BORNAGAIN_DEVICE_IO_READREFSANS_H
