# Find Libalkimia
#
#  LIBALKIMIA_FOUND - system has Libical with the minimum version needed
#  LIBALKIMIA_INCLUDE_DIRS - the Libical include directories
#  LIBALKIMIA_LIBRARIES - The libraries needed to use Libical
#  LIBALKIMIA_VERSION = The value of ICAL_VERSION defined in ical.h

# Copyright (c) 2010, Carlos da Silva <kaduardo@gmail.com>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.

include(MacroEnsureVersion)

set(LIBALKIMIA_FOUND FALSE)

if(NOT LIBALKIMIA_MIN_VERSION)
  set(LIBALKIMIA_MIN_VERSION "4.3.1")
endif(NOT LIBALKIMIA_MIN_VERSION)

if (WIN32)
  file(TO_CMAKE_PATH "$ENV{PROGRAMFILES}" _program_FILES_DIR)
endif(WIN32)

set(LIBALKIMIA_FIND_REQUIRED ${Libalkimia_FIND_REQUIRED})
if(LIBALKIMIA_INCLUDE_DIR AND LIBALKIMIA_LIBRARY)

  # Already in cache, be silent
  set(LIBALKIMIA_FIND_QUIETLY TRUE)

endif(LIBALKIMIA_INCLUDE_DIR AND LIBALKIMIA_LIBRARY)



IF (NOT WIN32)
   # use pkg-config to get the directories and then use these values
   # in the FIND_PATH() and FIND_LIBRARY() calls
   find_package(PkgConfig)
   pkg_check_modules(PC_ALKIMIA REQUIRED libalkimia>=${LIBALKIMIA_MIN_VERSION})
   SET(LIBALKIMIA_DEFINITIONS ${PC_ALKIMIA_CFLAGS_OTHER})
ENDIF (NOT WIN32)

FIND_PATH(LIBALKIMIA_INCLUDE_DIR alkimia/alkvalue.h
    PATHS
    ${PC_ALKIMIA_INCLUDEDIR}
    ${PC_ALKIMIA_INCLUDE_DIRS}
  )

FIND_LIBRARY(LIBALKIMIA_LIBRARY NAMES alkimia libalkimia
    PATHS
    ${PC_ALKIMIA_LIBDIR}
    ${PC_ALKIMIA_LIBRARY_DIRS}
  )


IF (LIBALKIMIA_INCLUDE_DIR AND LIBALKIMIA_LIBRARY)
   SET(LIBALKIMIA_FOUND TRUE)
ELSE (LIBALKIMIA_INCLUDE_DIR AND LIBALKIMIA_LIBRARY)
   SET(LIBALKIMIA_FOUND FALSE)
ENDIF (LIBALKIMIA_INCLUDE_DIR AND LIBALKIMIA_LIBRARY)


IF (LIBALKIMIA_FOUND)
   IF (NOT LIBALKIMIA_FIND_QUIETLY)
      MESSAGE(STATUS "Found LibAlkimia: ${LIBALKIMIA_LIBRARY}")
   ENDIF (NOT LIBALKIMIA_FIND_QUIETLY)
ELSE (LIBALKIMIA_FOUND)
   IF (LIBALKIMIA_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could NOT find LibAlkimia")
   ENDIF (LIBALKIMIA_FIND_REQUIRED)
ENDIF (LIBALKIMIA_FOUND)


mark_as_advanced(LIBALKIMIA_INCLUDE_DIR LIBALKIMIA_LIBRARY)
