/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import java.util.Hashtable;
import java.util.WeakHashMap;

public abstract class Type {
    String signature;
    String this_name;
    int size;
    ArrayType array_type;
    static WeakHashMap mapClassToType;
    static Hashtable mapNameToType;
    public static final PrimType byte_type;
    public static final PrimType short_type;
    public static final PrimType int_type;
    public static final PrimType long_type;
    public static final PrimType float_type;
    public static final PrimType double_type;
    public static final PrimType boolean_type;
    public static final PrimType char_type;
    public static final PrimType void_type;
    public static final PrimType neverReturnsType;
    public static final ObjectType nullType;
    public static ClassType string_type;
    public static final ClassType tostring_type;
    public static final ClassType pointer_type;
    public static final ClassType boolean_ctype;
    public static final ClassType throwable_type;
    public static final Type[] typeArray0;
    public static final Method toString_method;
    public static final ClassType number_type;
    public static final Method clone_method;
    public static final Method intValue_method;
    public static final Method longValue_method;
    public static final Method floatValue_method;
    public static final Method doubleValue_method;
    public static final Method booleanValue_method;
    public static final ClassType java_lang_Class_type;
    protected Class reflectClass;

    protected Type() {
    }

    public Type getImplementationType() {
        return this;
    }

    public static Type lookupType(String name) {
        return (Type)mapNameToType.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type getType(String name) {
        Hashtable map2;
        Hashtable hashtable = map2 = mapNameToType;
        synchronized (hashtable) {
            Type type = (Type)map2.get(name);
            if (type == null) {
                if (name.endsWith("[]")) {
                    type = ArrayType.make(name);
                } else {
                    ClassType cl = new ClassType(name);
                    cl.flags |= 4;
                    type = cl;
                }
                map2.put(name, type);
            }
            return type;
        }
    }

    public static synchronized void registerTypeForClass(Class clas, Type type) {
        WeakHashMap<Class, Type> map2 = mapClassToType;
        if (map2 == null) {
            mapClassToType = map2 = new WeakHashMap<Class, Type>(100);
        }
        map2.put(clas, type);
        type.reflectClass = clas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Type make(Class reflectClass) {
        Type type;
        Object t;
        if (mapClassToType != null && (t = mapClassToType.get(reflectClass)) != null) {
            return (Type)t;
        }
        if (reflectClass.isArray()) {
            type = ArrayType.make(Type.make(reflectClass.getComponentType()));
        } else {
            Hashtable map2;
            if (reflectClass.isPrimitive()) {
                throw new Error("internal error - primitive type not found");
            }
            String name = reflectClass.getName();
            Hashtable hashtable = map2 = mapNameToType;
            synchronized (hashtable) {
                type = (Type)map2.get(name);
                if (type == null || type.reflectClass != reflectClass && type.reflectClass != null) {
                    ClassType cl = new ClassType(name);
                    cl.flags |= 4;
                    type = cl;
                    mapNameToType.put(name, type);
                }
            }
        }
        Type.registerTypeForClass(reflectClass, type);
        return type;
    }

    public final String getSignature() {
        return this.signature;
    }

    protected void setSignature(String sig) {
        this.signature = sig;
    }

    Type(String nam, String sig) {
        this.this_name = nam;
        this.signature = sig;
    }

    public Type(Type type) {
        this.this_name = type.this_name;
        this.signature = type.signature;
        this.size = type.size;
        this.reflectClass = type.reflectClass;
    }

    public Type promote() {
        return this.size < 4 ? int_type : this;
    }

    public final int getSize() {
        return this.size;
    }

    public int getSizeInWords() {
        return this.size > 4 ? 2 : 1;
    }

    public final boolean isVoid() {
        return this.size == 0;
    }

    public static PrimType signatureToPrimitive(char sig) {
        switch (sig) {
            case 'B': {
                return byte_type;
            }
            case 'C': {
                return char_type;
            }
            case 'D': {
                return double_type;
            }
            case 'F': {
                return float_type;
            }
            case 'S': {
                return short_type;
            }
            case 'I': {
                return int_type;
            }
            case 'J': {
                return long_type;
            }
            case 'Z': {
                return boolean_type;
            }
            case 'V': {
                return void_type;
            }
        }
        return null;
    }

    public static Type signatureToType(String sig, int off, int len) {
        Type type;
        if (len == 0) {
            return null;
        }
        char c = sig.charAt(off);
        if (len == 1 && (type = Type.signatureToPrimitive(c)) != null) {
            return type;
        }
        if (c == '[') {
            type = Type.signatureToType(sig, off + 1, len - 1);
            return type == null ? null : ArrayType.make(type);
        }
        if (c == 'L' && len > 2 && sig.indexOf(59, off) == len - 1 + off) {
            return ClassType.make(sig.substring(off + 1, len - 1 + off).replace('/', '.'));
        }
        return null;
    }

    public static Type signatureToType(String sig) {
        return Type.signatureToType(sig, 0, sig.length());
    }

    public static int signatureLength(String sig, int pos) {
        int end;
        int len = sig.length();
        if (len <= pos) {
            return -1;
        }
        char c = sig.charAt(pos);
        int arrays2 = 0;
        while (c == '[') {
            ++arrays2;
            c = sig.charAt(++pos);
        }
        if (Type.signatureToPrimitive(c) != null) {
            return arrays2 + 1;
        }
        if (c == 'L' && (end = sig.indexOf(59, pos)) > 0) {
            return arrays2 + end + 1 - pos;
        }
        return -1;
    }

    public static int signatureLength(String sig) {
        return Type.signatureLength(sig, 0);
    }

    public static String signatureToName(String sig) {
        PrimType type;
        int len = sig.length();
        if (len == 0) {
            return null;
        }
        char c = sig.charAt(0);
        if (len == 1 && (type = Type.signatureToPrimitive(c)) != null) {
            return type.getName();
        }
        if (c == '[') {
            int arrays2 = 1;
            if (arrays2 < len && sig.charAt(arrays2) == '[') {
                ++arrays2;
            }
            if ((sig = Type.signatureToName(sig.substring(arrays2))) == null) {
                return null;
            }
            StringBuffer buf = new StringBuffer(50);
            buf.append(sig);
            while (--arrays2 >= 0) {
                buf.append("[]");
            }
            return buf.toString();
        }
        if (c == 'L' && len > 2 && sig.indexOf(59) == len - 1) {
            return sig.substring(1, len - 1).replace('/', '.');
        }
        return null;
    }

    public final String getName() {
        return this.this_name;
    }

    protected void setName(String name) {
        this.this_name = name;
    }

    public static boolean isValidJavaTypeName(String name) {
        int i;
        int len;
        boolean in_name = false;
        for (len = name.length(); len > 2 && name.charAt(len - 1) == ']' && name.charAt(len - 2) == '['; len -= 2) {
        }
        for (i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (ch == '.') {
                if (in_name) {
                    in_name = false;
                    continue;
                }
                return false;
            }
            if (in_name ? Character.isJavaIdentifierPart(ch) : Character.isJavaIdentifierStart(ch)) {
                in_name = true;
                continue;
            }
            return false;
        }
        return i == len;
    }

    public boolean isInstance(Object obj) {
        return this.getReflectClass().isInstance(obj);
    }

    public final boolean isSubtype(Type other) {
        int comp = this.compare(other);
        return comp == -1 || comp == 0;
    }

    public static Type lowestCommonSuperType(Type t1, Type t2) {
        if (t1 == neverReturnsType) {
            return t2;
        }
        if (t2 == neverReturnsType) {
            return t1;
        }
        if (t1 == null || t2 == null) {
            return null;
        }
        if (t1.isSubtype(t2)) {
            return t2;
        }
        if (t2.isSubtype(t1)) {
            return t1;
        }
        if (!(t1 instanceof ClassType) || !(t2 instanceof ClassType)) {
            return null;
        }
        ClassType c1 = (ClassType)t1;
        ClassType c2 = (ClassType)t2;
        if (c1.isInterface()) {
            return pointer_type;
        }
        if (c2.isInterface()) {
            return pointer_type;
        }
        return Type.lowestCommonSuperType(c1.getSuperclass(), c2.getSuperclass());
    }

    public abstract int compare(Type var1);

    protected static int swappedCompareResult(int code) {
        return code == 1 ? -1 : (code == -1 ? 1 : code);
    }

    public static boolean isMoreSpecific(Type[] t1, Type[] t2) {
        if (t1.length != t2.length) {
            return false;
        }
        int i = t1.length;
        while (--i >= 0) {
            if (t1[i].isSubtype(t2[i])) continue;
            return false;
        }
        return true;
    }

    public void emitIsInstance(CodeAttr code) {
        code.emitInstanceof(this);
    }

    public abstract Object coerceFromObject(Object var1);

    public Object coerceToObject(Object obj) {
        return obj;
    }

    public void emitCoerceToObject(CodeAttr code) {
    }

    public void emitCoerceFromObject(CodeAttr code) {
        throw new Error("unimplemented emitCoerceFromObject for " + this);
    }

    public Class getReflectClass() {
        return this.reflectClass;
    }

    public void setReflectClass(Class rclass) {
        this.reflectClass = rclass;
    }

    public String toString() {
        return "Type " + this.getName();
    }

    public int hashCode() {
        String name = this.toString();
        return name == null ? 0 : name.hashCode();
    }

    static {
        byte_type = new PrimType("byte", "B", 1, Byte.TYPE);
        short_type = new PrimType("short", "S", 2, Short.TYPE);
        int_type = new PrimType("int", "I", 4, Integer.TYPE);
        long_type = new PrimType("long", "J", 8, Long.TYPE);
        float_type = new PrimType("float", "F", 4, Float.TYPE);
        double_type = new PrimType("double", "D", 8, Double.TYPE);
        boolean_type = new PrimType("boolean", "Z", 1, Boolean.TYPE);
        char_type = new PrimType("char", "C", 2, Character.TYPE);
        void_type = new PrimType("void", "V", 0, Void.TYPE);
        mapNameToType = new Hashtable();
        mapNameToType.put("byte", byte_type);
        mapNameToType.put("short", short_type);
        mapNameToType.put("int", int_type);
        mapNameToType.put("long", long_type);
        mapNameToType.put("float", float_type);
        mapNameToType.put("double", double_type);
        mapNameToType.put("boolean", boolean_type);
        mapNameToType.put("char", char_type);
        mapNameToType.put("void", void_type);
        neverReturnsType = new PrimType(void_type);
        Type.neverReturnsType.this_name = "(never-returns)";
        nullType = new ObjectType("(type of null)");
        string_type = ClassType.make("java.lang.String");
        tostring_type = new ClassType("java.lang.String");
        pointer_type = ClassType.make("java.lang.Object");
        boolean_ctype = ClassType.make("java.lang.Boolean");
        throwable_type = ClassType.make("java.lang.Throwable");
        typeArray0 = new Type[0];
        toString_method = pointer_type.getDeclaredMethod("toString", 0);
        number_type = ClassType.make("java.lang.Number");
        clone_method = Method.makeCloneMethod(pointer_type);
        intValue_method = number_type.addMethod("intValue", typeArray0, int_type, 1);
        longValue_method = number_type.addMethod("longValue", typeArray0, long_type, 1);
        floatValue_method = number_type.addMethod("floatValue", typeArray0, float_type, 1);
        doubleValue_method = number_type.addMethod("doubleValue", typeArray0, double_type, 1);
        booleanValue_method = boolean_ctype.addMethod("booleanValue", typeArray0, boolean_type, 1);
        java_lang_Class_type = ClassType.make("java.lang.Class");
    }
}

