#if   !defined(__COLLEAGUE_HPP)
#define __COLLEAGUE_HPP

/*
   CoreLinux++ 
   Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__VECTOR_HPP)
#include <Vector.hpp>
#endif

#if   !defined(__EVENT_HPP)
#include <Event.hpp>
#endif

namespace corelinux
{
   CORELINUX_VECTOR(  IdentifierPtr ,  EventIdentifiers );

   DECLARE_CLASS( Mediator );

   DECLARE_CLASS( Colleague );

   /**
   Colleague knows its Mediator object, communicates with its mediator 
   whenever it would have otherwise communicated with another Colleague. 
   */

   class Colleague
   {
   public:

      //
      // Constructors and destructor
      //

                        /**
                        Default constructor requires a Mediator
                        @param Mediator pointer 
                        @exception NullPointerException if MediatorPtr 
                        is NULLPTR
                        */

                        Colleague( MediatorPtr )
                           throw ( NullPointerException );

                        /**
                        Copy constructor copies the mediator
                        reference
                        @param Colleague const referencee
                        */

                        Colleague( ColleagueCref );

                        /// Virtual destructor 

      virtual           ~Colleague( void );   

      //
      // Operator overloads
      //

               /// Assignment operator

               ColleagueRef   operator=( ColleagueCref );

               /// Equality operator

               bool operator==( ColleagueCref ) const;

      //
      // Accessors
      //

               /**
               Implementation defined to return the identifiers
               of the events that this Colleague generates
               @param EventIdentifiers vector reference
               */

      virtual  void  getEventsGenerated( EventIdentifiersRef ) = 0;

               /**
               Implementation defined to return the identifiers
               of the events that this Colleague is interested in
               @param EventIdentifiers vector reference
               */

      virtual  void  getInterestedEvents( EventIdentifiersRef ) = 0;

      //
      // Mutators
      //

               /**
               Called by the mediator when another Colleague has
               generated an event that this colleague instance
               is interested in.
               @param Event pointer to event
               */

      virtual  void  action( Event<Identifier> * ) = 0;

   protected:

      //
      // Constructor
      //
                        /// Default constructor not allowed

                        Colleague( void ) throw ( Assertion );

      //
      // Service method
      //               
               /**
               Called by the Colleague implementation to have
               the Mediator::action called with the event type
               @param Event pointer to event
               @exception NullPointerException if EventPtr is NULLPTR
               */

      virtual  void  invokeMediator( Event<Identifier> * ) throw ( NullPointerException );

   private:

            /// The Mediator that this Colleague knows

            MediatorPtr    theMediator;
   };
}

#endif // if !defined(__COLLEAGUE_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.2 $
   $Date: 2000/08/31 22:52:20 $
   $Locker:  $
*/


