find_package(JPEG)
find_package(PNG)
find_package(TIFF)
find_package(X11)
find_package(OpenGL)
find_package(Threads REQUIRED)

include(${CMAKE_CURRENT_LIST_DIR}/CVDFindFFMPEG.cmake)
include(${CMAKE_CURRENT_LIST_DIR}/CVDFindTooN.cmake)
include(${CMAKE_CURRENT_LIST_DIR}/CVDFinddc1394v2.cmake)

SET(CVD_DEP_INCLUDES_PUBLIC)
SET(CVD_DEP_INCLUDES_PRIVATE)
SET(CVD_DEP_LIBS)

if(CVD_FFMPEG_FOUND)
	list(APPEND CVD_DEP_INCLUDES_PRIVATE ${CVD_FFMPEG_INCLUDE_DIRS})
	list(APPEND CVD_DEP_LIBS ${CVD_FFMPEG_LIBRARIES})
endif()

list(APPEND CVD_DEP_LIBS Threads::Threads)
if(JPEG_FOUND)
	list(APPEND CVD_DEP_INCLUDES_PRIVATE ${JPEG_INCLUDE_DIRS})
	list(APPEND CVD_DEP_LIBS ${JPEG_LIBRARIES})
endif()
if(TIFF_FOUND)
	list(APPEND CVD_DEP_INCLUDES_PRIVATE ${TIFF_INCLUDE_DIRS})
	list(APPEND CVD_DEP_LIBS ${TIFF_LIBRARIES})
endif()
if(PNG_FOUND)
	list(APPEND CVD_DEP_INCLUDES_PRIVATE ${PNG_INCLUDE_DIRS})
	list(APPEND CVD_DEP_LIBS ${PNG_LIBRARIES})
endif()
if(CVD_TooN_FOUND)
	list(APPEND CVD_DEP_INCLUDES_PUBLIC ${CVD_TooN_INCLUDE_DIRS})
endif()
if(CVD_dc1394v2_FOUND)
	list(APPEND CVD_DEP_INCLUDES_PRIVATE ${CVD_dc1394v2_INCLUDE_DIRS})
	list(APPEND CVD_DEP_LIBS ${CVD_dc1394v2_LIBRARIES})
endif()
if(X11_FOUND)
	list(APPEND CVD_DEP_INCLUDES_PUBLIC ${X11_INCLUDE_DIR})
	list(APPEND CVD_DEP_LIBS ${X11_LIBRARIES})
endif()
if(OpenGL_OpenGL_FOUND)
	list(APPEND CVD_DEP_LIBS ${OPENGL_gl_LIBRARY})
	list(APPEND CVD_DEP_INCLUDES_PUBLIC ${OPENGL_INCLUDE_DIR})
endif()


