/* ----- core/inv3sntrup953, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_inv3sntrup953_checksums[] = {
  "9237c4567f8c2a46bdd2352fd36246298755505410c350016bc46a91a4b267a3",
  "83d67d2813b5abbb50c0686c4a605c5e85b59adbc04b9b55d1585d6f114303d2",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_inv3sntrup953_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_inv3sntrup953_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_inv3sntrup953_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_inv3sntrup953_CONSTBYTES

static void *storage_core_inv3sntrup953_h;
static unsigned char *test_core_inv3sntrup953_h;
static void *storage_core_inv3sntrup953_n;
static unsigned char *test_core_inv3sntrup953_n;
static void *storage_core_inv3sntrup953_k;
static unsigned char *test_core_inv3sntrup953_k;
static void *storage_core_inv3sntrup953_c;
static unsigned char *test_core_inv3sntrup953_c;
static void *storage_core_inv3sntrup953_h2;
static unsigned char *test_core_inv3sntrup953_h2;
static void *storage_core_inv3sntrup953_n2;
static unsigned char *test_core_inv3sntrup953_n2;
static void *storage_core_inv3sntrup953_k2;
static unsigned char *test_core_inv3sntrup953_k2;
static void *storage_core_inv3sntrup953_c2;
static unsigned char *test_core_inv3sntrup953_c2;

#define precomputed_core_inv3sntrup953_NUM 5

static const unsigned char precomputed_core_inv3sntrup953_h[precomputed_core_inv3sntrup953_NUM][crypto_core_OUTPUTBYTES] = {
  {1,255,1,255,0,0,1,255,255,1,1,1,1,0,0,0,0,0,0,255,0,1,1,1,0,255,255,1,255,255,255,255,255,0,1,255,0,0,0,1,0,0,1,0,0,255,255,255,0,0,0,255,0,0,255,1,0,0,1,0,0,1,255,1,0,0,1,1,0,1,255,255,0,1,255,1,255,255,255,1,255,255,1,255,0,255,0,1,1,255,0,0,1,0,0,255,0,255,255,0,0,255,255,255,1,0,255,0,1,0,1,255,0,1,255,0,255,1,1,255,1,0,1,255,255,1,0,1,0,255,0,1,1,1,0,0,1,1,255,0,0,255,255,0,1,255,255,255,0,0,255,0,1,255,0,1,0,255,0,1,0,0,0,1,0,0,255,1,255,0,255,1,1,0,0,0,255,0,0,255,1,1,255,0,1,255,255,1,1,255,1,0,0,1,255,0,0,255,255,1,255,255,1,255,0,0,1,0,255,255,0,0,1,255,1,255,0,1,1,1,1,1,255,1,255,255,255,0,255,1,1,1,0,0,1,1,255,0,255,0,1,1,1,255,1,255,0,1,1,1,1,255,0,0,255,255,255,0,1,1,1,1,1,0,0,255,1,255,255,1,1,255,0,255,1,255,1,1,0,1,255,0,255,1,255,0,0,1,255,1,255,1,1,1,255,255,0,255,0,0,255,255,255,1,255,1,255,1,0,255,255,1,255,255,1,1,255,0,1,0,1,255,1,0,255,255,255,1,1,255,1,1,0,1,1,1,0,255,1,0,1,1,0,0,255,1,255,255,255,0,1,1,0,0,0,1,0,1,0,1,255,1,0,255,0,1,1,255,1,1,1,255,1,0,255,255,255,1,0,1,0,1,255,255,1,255,1,0,255,1,1,255,255,0,255,255,1,1,0,255,1,0,1,255,0,1,1,1,255,255,0,1,255,1,0,255,0,0,1,255,255,0,1,255,1,0,0,0,0,1,1,1,0,0,1,0,255,255,255,255,255,255,1,255,1,255,255,0,0,0,0,1,1,0,1,0,255,0,0,1,255,0,1,1,0,1,0,255,1,255,0,1,0,255,0,1,255,0,0,0,1,0,255,0,255,0,1,255,1,0,0,255,1,1,0,255,1,1,1,0,0,1,255,0,0,0,0,1,0,255,255,1,0,1,0,0,1,255,1,1,255,0,255,0,1,255,255,255,1,1,255,0,0,0,255,255,1,255,255,1,1,1,1,255,255,0,255,0,255,1,1,255,255,0,1,0,255,255,0,1,255,0,255,255,1,0,255,1,255,1,0,1,0,255,0,1,0,1,1,1,255,0,0,1,1,0,0,0,0,0,1,0,255,255,0,255,255,1,0,0,0,255,1,0,0,1,255,1,0,1,1,255,255,1,0,255,1,1,255,255,0,1,0,1,1,1,1,255,1,1,0,255,255,0,1,0,1,1,1,0,1,0,1,0,1,0,1,0,255,1,0,0,0,255,0,255,255,1,0,0,0,1,1,0,1,1,0,1,255,1,0,1,1,1,1,1,1,255,1,0,0,255,255,1,0,255,255,255,0,1,255,255,1,0,255,1,1,255,255,1,255,0,1,1,0,1,0,255,0,1,255,255,0,255,1,0,0,255,255,255,255,255,1,1,0,0,255,255,0,255,1,1,255,255,0,1,1,1,255,1,1,1,0,255,1,255,255,1,255,0,255,1,255,0,255,1,0,1,255,1,0,1,1,0,0,0,0,0,255,1,1,1,255,255,1,0,0,0,1,1,0,0,0,0,255,1,1,1,255,1,255,1,255,255,255,1,1,0,255,0,1,0,255,255,255,0,255,255,0,255,0,0,1,255,255,1,255,0,0,1,1,1,0,0,0,1,1,255,0,0,0,0,0,1,1,255,1,255,0,1,1,1,0,255,255,1,255,0,1,255,0,1,1,0,255,255,0,0,1,0,255,1,255,0,1,255,255,0,1,255,1,1,1,0,0,0,1,1,255,0,255,1,1,0,255,1,255,0,255,255,0,1,0,1,255,255,0,0,1,255,0,1,1,255,255,0,255,255,1,0,1,0,255,0,1,255,1,1,1,1,0,0,255,0,255,255,1,1,1,1,255,255,0,255,0,0,0,0,0,255,255,255,0,255,1,0,0,1,0,0,0,255,255,0},
  {255,0,255,255,255,255,0,255,0,1,0,0,255,1,255,0,255,1,255,1,0,255,1,1,0,0,1,255,255,0,1,1,255,0,0,255,1,0,1,1,0,1,0,1,1,255,0,1,1,255,0,0,0,1,255,1,0,1,1,1,255,0,255,255,1,1,0,255,0,1,255,1,1,255,1,255,0,255,1,255,255,255,255,0,0,0,0,0,255,255,1,0,1,0,1,0,0,255,0,0,255,255,0,255,1,0,1,1,255,255,0,255,1,255,255,255,1,0,255,1,1,0,1,255,0,255,0,255,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,255,255,1,255,255,255,0,1,1,0,255,1,1,1,1,1,0,0,255,0,255,1,0,255,255,0,255,1,0,0,255,0,0,255,1,255,255,255,1,255,255,1,255,0,0,0,255,255,255,0,0,1,1,0,0,255,0,255,1,255,0,255,255,1,0,1,0,255,255,255,0,1,0,1,0,255,0,255,0,1,0,1,0,0,1,1,0,1,1,1,0,255,255,0,0,0,255,255,1,0,1,0,1,1,255,0,1,0,0,255,0,0,255,255,0,255,1,0,1,255,1,1,1,0,1,1,255,255,1,0,1,0,255,0,1,1,255,0,1,1,1,255,255,255,1,255,255,1,0,0,0,255,1,1,0,0,255,0,0,255,255,1,255,1,255,1,255,255,0,1,0,255,255,1,1,255,1,1,1,255,1,0,255,1,0,0,0,0,1,0,1,255,0,0,0,0,0,1,1,1,255,1,255,255,255,0,255,255,1,1,0,1,1,255,1,255,0,255,1,0,0,255,255,255,1,1,255,1,255,1,0,255,1,0,1,0,0,1,0,255,1,0,255,255,1,255,0,255,255,0,255,0,0,255,255,255,255,1,0,0,1,1,1,0,1,1,1,1,1,1,1,0,255,1,1,255,0,255,255,255,0,255,0,1,255,1,0,1,0,255,255,0,0,1,255,0,1,0,255,1,0,1,0,0,0,255,1,255,1,1,0,1,0,1,255,0,1,1,0,0,255,0,255,255,0,1,1,255,0,255,255,0,0,1,255,0,255,255,255,0,255,255,0,1,255,1,1,0,255,0,0,255,0,1,255,255,0,255,255,0,0,1,255,0,0,0,1,0,1,255,1,1,255,0,255,255,0,0,255,0,0,0,1,0,1,1,0,0,0,1,0,255,0,1,0,255,0,0,255,255,0,255,255,0,255,1,1,255,0,255,255,0,0,0,255,0,255,1,1,255,255,1,1,1,255,255,1,1,255,0,0,0,0,255,0,1,0,1,1,0,0,0,1,255,0,1,1,255,0,0,0,255,1,1,0,1,0,1,255,255,255,255,1,255,255,1,0,1,255,255,255,0,255,255,255,0,255,1,0,1,1,1,1,0,0,1,0,1,0,1,255,255,1,1,0,255,1,0,255,255,255,1,255,0,0,255,1,0,1,1,1,255,255,0,1,255,0,255,1,255,255,255,1,0,1,255,255,0,255,1,255,255,1,0,255,255,255,0,255,0,0,0,1,1,1,1,1,255,1,0,0,0,0,1,255,1,255,255,255,0,255,0,255,1,255,1,0,255,255,0,0,0,0,0,255,0,1,0,255,255,255,1,0,0,1,1,255,255,255,0,1,255,1,255,0,0,0,255,1,255,255,0,1,255,1,0,255,255,0,0,1,255,1,0,255,0,0,1,1,255,255,1,1,255,1,1,0,255,255,0,1,0,0,1,255,255,255,1,255,255,1,1,1,0,1,255,0,1,1,0,255,0,255,255,255,1,0,0,1,0,0,255,1,1,255,255,0,255,0,255,0,255,1,0,0,1,255,255,0,0,255,255,1,255,255,1,255,0,1,255,1,1,0,255,1,255,0,255,1,0,255,255,1,255,255,0,255,255,0,255,1,1,255,255,255,255,0,1,0,1,1,0,255,0,0,1,1,255,0,255,255,0,0,255,1,1,0,255,0,0,255,1,0,255,0,1,0,0,0,0,1,255,0,0,0,1,0,0,1,1,1,255,1,0,1,1,255,255,1,1,255,0,255,1,1,0,0,1,0,1,255,0,255,1,1,0,0,0,1,1,0,0,255,0,0,1,1,1,255,255,255,1,0,1,0,0,0,1,255,255,0},
  {0,0,0,0,255,1,255,255,255,255,0,0,255,1,1,0,0,0,1,255,1,255,255,1,1,0,0,255,0,255,255,255,1,1,0,0,255,255,1,1,1,0,1,0,0,255,0,1,0,255,255,0,255,1,255,255,0,255,0,0,255,1,1,0,0,255,255,255,255,255,0,1,0,255,255,255,1,0,0,1,0,0,0,0,255,1,1,0,255,255,255,1,1,1,1,255,255,255,255,255,1,255,1,0,255,1,1,1,1,255,1,0,1,1,255,0,255,255,1,0,255,255,0,1,255,1,0,0,1,0,255,255,0,1,1,255,1,1,255,1,0,255,1,0,1,1,1,255,0,1,1,0,255,1,0,1,255,0,0,1,1,255,255,0,0,255,255,1,1,1,0,255,255,255,0,255,255,0,255,255,1,0,255,255,255,0,255,255,1,255,0,255,255,1,0,1,0,255,255,0,1,0,0,1,255,1,0,0,1,1,255,255,1,1,1,255,1,255,255,255,0,0,0,0,0,255,255,1,255,1,1,0,255,1,0,255,255,255,0,0,1,0,0,0,1,0,255,255,1,0,0,1,1,1,1,0,0,1,0,0,1,0,255,255,1,255,0,1,1,255,1,0,0,0,255,0,255,1,255,255,0,1,0,0,0,0,0,255,255,0,255,1,0,0,0,1,255,1,255,0,0,255,255,255,0,0,1,255,0,1,1,1,1,255,255,0,0,1,0,0,255,1,1,0,255,0,1,1,0,255,0,255,0,0,1,255,0,255,255,255,255,255,1,255,255,1,1,0,1,0,0,255,0,1,255,1,255,255,0,255,255,255,0,1,1,0,0,1,1,255,1,255,255,0,255,255,1,0,0,0,0,1,0,0,0,255,1,255,0,0,1,0,1,0,255,0,255,1,1,0,0,0,1,1,0,0,255,0,0,0,0,255,1,1,1,0,255,255,255,0,1,0,255,0,0,0,1,1,255,1,0,255,1,255,1,255,255,1,0,1,0,1,255,0,255,1,0,1,255,255,0,0,0,255,1,0,0,1,0,1,0,1,1,1,1,0,0,1,255,255,0,1,255,0,255,0,255,1,255,255,255,0,1,255,0,0,0,0,0,0,255,255,255,0,255,0,0,255,255,255,1,255,255,1,1,1,0,255,255,255,1,1,1,0,255,255,255,255,0,0,255,0,255,0,1,1,255,0,1,0,255,1,0,255,255,1,255,0,255,0,1,255,255,0,1,255,1,1,0,0,0,255,1,255,1,255,1,255,1,1,255,1,255,1,255,255,0,1,0,1,255,1,255,1,255,1,255,1,0,0,1,0,1,255,0,0,1,1,255,255,0,0,0,255,255,0,255,255,0,0,1,0,1,0,1,255,0,0,0,1,255,0,1,1,0,0,0,255,0,1,1,255,1,255,255,0,0,1,0,1,0,1,1,0,1,1,255,255,1,0,0,255,0,0,1,0,0,1,0,0,0,0,0,255,0,1,0,0,255,255,0,0,0,1,0,1,0,1,1,0,0,0,0,1,255,0,1,255,255,0,0,1,255,1,0,0,0,1,0,255,1,1,1,1,0,1,1,1,1,0,0,0,1,255,0,1,255,1,0,0,255,255,0,1,1,1,255,0,255,1,255,0,1,1,1,255,255,0,255,255,255,1,255,255,1,0,1,1,1,0,255,255,1,1,1,255,255,0,255,1,1,1,1,255,255,0,0,255,255,1,255,1,255,255,255,255,0,255,0,255,0,0,255,0,255,1,0,0,0,255,1,255,1,0,0,255,255,255,0,1,1,255,255,1,0,1,0,0,255,0,255,0,0,255,0,0,255,255,1,0,1,0,1,255,0,1,255,0,1,0,1,0,255,255,0,1,0,1,255,1,0,1,0,1,255,1,255,1,255,1,0,1,255,1,0,255,1,1,0,0,255,255,0,1,255,0,1,1,0,0,255,0,255,0,1,0,255,255,0,1,255,0,1,255,0,255,255,0,1,0,1,1,255,255,0,255,255,1,1,0,255,0,255,0,0,255,255,0,1,1,0,1,1,1,0,0,0,1,0,1,0,255,255,0,0,255,1,0,255,1,255,255,1,255,1,1,0,1,255,0,255,1,255,0,0,0,0,1,0,0,1,255,255,0,0,1,1,1,1,1,1,255,0,0},
  {1,0,255,0,0,0,255,255,255,0,1,0,0,0,1,1,255,0,255,1,1,255,1,0,255,0,255,1,255,1,1,1,0,255,0,255,1,1,1,255,255,1,0,0,255,0,1,1,1,0,1,0,0,255,1,255,255,0,1,255,1,255,0,255,0,1,0,255,1,255,255,1,255,255,255,0,255,255,1,1,0,255,0,1,0,255,0,1,1,1,255,0,255,1,0,255,1,1,0,1,1,255,0,255,255,0,1,1,0,0,1,1,255,255,0,1,255,1,255,255,0,255,255,1,1,0,255,0,0,255,255,0,255,255,0,1,0,255,255,0,0,0,255,1,255,255,0,255,0,1,1,0,0,1,255,255,1,0,0,255,0,255,1,0,255,255,0,255,255,255,1,1,255,0,255,255,0,255,1,0,255,255,0,255,0,0,0,255,255,0,0,1,0,0,0,255,255,255,0,1,0,1,0,0,1,1,1,255,0,1,0,1,1,1,1,1,0,255,1,1,255,0,0,1,255,255,1,1,255,255,255,1,1,1,255,0,0,1,1,255,1,255,0,1,255,255,0,1,0,255,0,0,1,1,0,0,1,0,255,0,255,255,0,1,1,255,255,1,0,0,1,0,0,1,1,1,255,255,255,255,1,0,0,1,0,0,1,0,0,0,0,1,255,0,0,1,0,255,1,1,0,1,255,0,255,0,1,0,255,0,255,255,1,0,1,0,255,255,255,0,1,1,0,0,1,0,1,0,1,0,1,255,0,0,1,1,1,1,255,1,0,255,0,0,0,1,0,0,1,255,255,255,1,1,1,0,255,1,255,1,1,0,255,0,255,0,255,255,1,1,1,255,0,1,1,255,255,1,1,255,255,1,255,0,1,0,1,255,1,255,0,1,255,255,0,0,0,255,0,1,255,0,255,255,255,255,1,255,255,1,0,0,255,1,0,255,255,255,0,1,255,0,0,255,1,255,1,1,255,0,1,255,1,0,1,0,0,0,1,1,1,0,1,1,0,0,1,1,1,255,0,1,1,0,0,255,0,0,255,255,0,1,0,1,0,1,0,255,0,0,255,0,255,255,255,0,1,1,255,1,1,0,0,1,255,255,255,0,1,0,0,1,1,1,1,1,0,255,255,0,255,0,0,1,0,255,255,1,0,255,1,255,1,1,255,1,255,255,0,0,255,0,0,0,0,0,255,1,1,1,255,255,1,255,1,255,0,1,1,1,255,255,0,0,255,0,255,1,1,1,1,1,1,1,1,1,255,0,1,1,1,255,0,1,1,1,0,1,1,0,1,1,1,255,1,255,255,255,1,0,1,255,255,255,1,1,1,0,1,255,0,0,255,0,1,0,255,1,255,0,0,0,1,1,0,0,0,0,255,0,1,0,0,1,0,255,1,1,255,255,255,1,0,1,0,0,1,1,255,0,0,1,1,255,0,0,0,255,1,0,255,255,0,0,1,1,0,0,0,255,255,1,1,255,255,1,1,0,1,1,255,255,255,1,255,0,255,0,255,1,0,0,0,255,1,255,255,1,255,255,0,1,1,0,0,1,0,1,255,0,1,255,255,255,0,0,255,1,0,1,0,0,255,255,255,0,0,0,1,1,0,1,0,0,255,1,1,1,255,255,0,0,0,0,0,1,1,255,0,1,255,0,0,1,1,255,0,255,255,1,1,0,0,0,255,255,1,0,0,1,1,255,1,1,255,1,1,0,0,1,1,255,1,255,1,255,1,255,1,1,255,0,1,255,255,0,255,1,0,1,0,255,1,1,1,255,0,0,1,1,1,0,255,1,255,0,0,1,0,255,255,255,0,1,1,0,1,1,0,255,0,1,1,1,0,1,0,1,1,0,0,255,0,0,255,255,1,0,0,1,255,0,255,0,1,0,0,1,255,255,0,1,1,1,255,255,1,0,1,0,0,255,0,0,255,255,255,0,255,0,1,0,0,255,255,1,1,255,1,0,1,255,1,0,0,0,0,0,255,1,1,1,255,255,1,255,0,1,1,1,0,255,255,1,255,0,255,255,0,1,0,0,1,255,1,255,255,255,0,255,255,255,255,255,0,1,255,1,1,1,1,0,255,1,1,255,255,0,0,1,0,0,1,1,255,0,0,1,0,255,1,255,1,255,255,1,1,1,1,0,255,255,1,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255},
} ;

static const unsigned char precomputed_core_inv3sntrup953_n[precomputed_core_inv3sntrup953_NUM][crypto_core_INPUTBYTES] = {
  {121,227,126,104,142,246,103,181,4,39,44,29,202,118,8,90,200,223,158,216,36,3,244,228,117,202,85,24,235,252,246,7,40,202,118,164,180,5,122,42,241,212,36,25,23,104,122,220,99,45,204,193,61,93,77,200,140,53,73,180,107,167,163,222,130,101,179,236,158,132,226,102,4,12,64,150,149,50,169,227,252,205,129,49,234,179,217,203,14,18,174,144,63,149,0,136,195,64,43,38,113,185,141,76,204,168,191,227,250,91,210,186,84,172,247,133,76,241,245,134,92,132,111,31,153,250,130,145,215,172,251,227,62,68,49,8,91,110,70,59,3,88,75,156,127,178,161,90,102,130,228,91,26,202,11,129,155,53,233,125,245,136,246,33,188,19,90,163,112,197,40,209,17,161,181,191,222,98,187,66,131,144,179,52,88,189,159,147,150,135,0,227,197,38,44,245,135,93,28,196,204,93,192,211,229,52,110,81,1,129,65,49,26,106,245,15,189,214,28,65,56,21,25,126,61,128,209,188,70,128,42,85,175,156,37,154,5,244,152,67,18,55,188,28,222,99,157,97,251,161,12,97,129,202,252,110,161,90,122,83,128,164,13,73,49,219,36,247,133,36,199,254,146,223,241,99,178,148,119,165,125,42,92,99,200,107,175,166,73,86,50,179,161,80,244,88,226,33,25,71,252,16,215,186,255,47,182,178,19,113,31,170,73,158,248,187,161,70,175,6,149,95,207,236,73,18,234,9,173,166,86,249,113,237,123,240,155,182,214,151,242,94,242,48,146,247,233,95,243,201,192,5,225,236,3,181,16,248,137,79,4,213,78,69,132,180,35,4,137,149,251,36,115,188,145,13,34,41,47,181,220,29,33,81,243,107,54,204,243,201,219,112,10,160,199,2,30,225,206,113,224,181,210,229,156,163,63,201,88,127,190,1,42,25,226,129,109,130,75,94,201,55,63,166,97,139,246,216,213,255,55,99,98,138,109,252,202,118,172,38,162,72,195,214,119,228,169,104,50,41,254,207,241,84,197,20,214,113,41,8,179,184,114,78,148,247,118,244,157,0,125,69,53,253,232,238,124,127,118,117,168,93,93,94,110,180,42,11,46,159,219,74,99,148,105,219,142,133,45,126,212,61,166,6,95,196,149,50,40,207,108,165,149,216,13,196,61,219,120,114,46,180,12,19,214,159,92,124,121,189,176,154,234,4,111,191,182,234,48,204,94,175,55,103,131,54,113,13,188,0,237,45,99,139,236,193,136,210,146,84,108,254,84,5,160,106,33,30,64,95,207,236,203,115,223,195,166,123,227,5,114,12,50,63,181,46,129,86,2,208,89,81,50,69,128,205,168,103,224,224,136,183,255,177,117,4,195,65,157,11,170,13,116,83,61,243,151,98,8,75,148,74,231,117,146,2,120,24,123,127,64,57,251,71,19,199,209,64,227,142,225,177,11,230,115,111,104,124,187,178,28,25,197,128,252,156,158,57,87,8,87,132,123,207,100,200,163,16,11,253,119,10,242,23,218,14,111,69,251,246,65,152,190,146,216,10,194,59,253,14,244,142,67,201,160,179,85,53,213,168,88,222,77,12,207,246,117,106,51,198,25,174,100,251,240,16,245,97,102,230,200,78,118,96,56,26,194,245,134,200,140,168,216,11,247,162,117,63,254,115,120,184,141,220,137,175,59,193,233,7,6,219,222,180,76,136,44,92,155,90,50,233,185,70,189,136,41,20,210,189,111,94,93,190,61,86,88,65,230,79,57,140,111,237,233,26,57,131,111,120,107,176,246,44,91,166,18,50,157,50,155,18,87,231,185,203,43,120,203,211,193,63,255,189,162,52,75,82,188,51,35,135,102,112,168,243,226,57,151,83,172,28,242,96,183,126,113,239,183,92,159,184,70,241,16,8,140,72,59,75,11,144,79,188,85,70,171,59,64,66,56,118,229,175,98,181,252,2,210,190,122,252,145,108,87,34,202,252,228,134,2,144,165,152,220,180,27,251,167,50,215,35,5,233,214,83,78,153,224,170,55,126,152,163,149,107,91,171,216,61,18,130,57,146,180,252,235,126,57,133,24,32,47,78,37,182,210,161,63,220,143,71,2,182,54,86,86,69,95,49,239,128,127,18,126,178,160,248,87,152,144,243,32},
  {107,203,223,104,252,21,35,83,189,190,97,11,221,173,156,197,23,149,129,115,211,71,43,104,197,167,70,126,181,202,124,127,178,3,19,253,82,149,122,157,0,64,225,67,205,119,88,220,37,154,220,140,150,132,136,171,19,35,134,160,54,110,4,49,75,105,19,244,156,54,74,120,140,208,244,166,249,40,24,237,180,138,6,60,182,178,175,21,228,118,240,168,236,245,159,228,194,184,97,161,168,24,27,121,57,180,184,229,134,227,248,158,31,117,86,33,35,157,98,157,9,111,36,192,137,31,3,244,197,40,12,117,7,40,240,58,168,11,215,62,14,62,25,141,210,176,0,241,212,230,21,84,242,158,184,250,78,2,241,225,197,103,251,147,169,78,204,73,132,62,233,178,181,13,157,32,93,181,68,46,207,86,150,184,106,67,76,227,102,41,69,150,161,199,80,25,86,93,83,151,187,117,68,58,63,222,22,112,134,218,150,12,3,36,121,31,192,68,80,237,220,237,220,218,201,114,54,207,228,245,60,144,12,197,199,207,47,82,16,64,227,44,188,191,243,52,64,230,172,43,157,182,152,153,113,109,6,12,107,242,235,138,112,146,122,145,249,22,16,132,164,60,80,54,103,83,43,236,194,182,107,60,243,98,68,221,126,106,207,164,245,5,227,142,205,144,110,71,116,147,86,223,32,34,139,194,158,195,193,60,207,156,109,67,243,163,157,228,118,243,227,246,42,118,36,45,131,183,221,113,130,170,101,246,143,149,120,41,16,2,113,22,93,195,224,240,50,178,149,168,29,14,34,198,147,253,91,212,216,229,17,147,27,5,68,108,59,195,209,161,75,132,177,185,227,210,108,220,179,149,191,20,60,141,187,80,54,172,217,82,133,203,74,77,26,242,32,176,204,55,84,17,255,57,204,94,159,110,41,63,16,80,250,131,118,47,128,152,175,199,239,237,210,86,98,150,89,128,157,57,90,251,115,222,106,176,70,69,180,41,157,158,22,2,102,177,17,181,209,155,112,155,159,98,167,70,114,142,134,204,49,44,47,176,144,215,71,19,17,255,228,31,209,195,187,6,185,99,173,145,0,100,108,241,23,251,168,54,247,26,50,207,195,55,170,56,40,205,68,196,236,33,140,131,103,165,190,162,196,65,215,63,255,243,182,174,192,251,107,19,78,172,178,35,13,1,28,160,36,48,181,237,131,238,26,142,11,96,156,213,144,24,75,65,199,94,237,30,250,27,180,74,179,9,53,222,70,55,249,246,33,180,27,137,28,235,199,100,161,53,105,195,164,66,237,4,29,85,185,46,220,102,11,227,84,6,35,97,89,143,182,255,229,227,212,2,216,220,222,90,27,14,225,105,178,245,22,205,209,58,193,92,52,169,201,63,145,80,93,231,220,54,207,131,108,250,180,85,125,88,63,249,16,82,79,82,128,186,16,233,223,43,35,111,43,145,19,118,224,166,208,36,157,122,11,48,249,201,132,22,40,194,163,5,54,77,21,197,234,241,199,255,172,211,185,158,141,21,241,191,182,250,228,169,146,162,142,55,29,34,243,25,204,91,108,177,31,58,69,30,155,250,77,238,74,93,192,30,75,44,174,151,63,76,126,53,162,10,220,109,39,76,13,52,94,186,61,2,148,225,164,153,253,166,70,224,100,251,165,104,117,97,27,67,168,196,96,95,112,14,50,191,154,4,242,77,236,39,250,2,84,81,119,74,104,127,200,131,177,134,222,11,62,3,1,215,36,73,241,140,83,207,17,22,211,80,1,11,133,101,106,134,232,221,23,216,24,60,178,99,2,234,102,60,43,177,220,141,127,173,204,124,215,234,132,110,163,154,90,37,61,198,110,82,157,181,81,194,128,206,143,85,113,98,238,20,157,84,163,142,225,73,245,161,176,127,13,87,16,109,179,16,46,186,131,216,138,229,55,189,95,135,34,72,173,114,184,246,253,190,105,184,224,37,29,193,231,212,175,59,72,163,52,237,106,33,192,218,185,160,168,205,116,146,241,208,154,10,214,130,225,234,97,64,57,52,94,24,25,32,196,127,156,69,7,139,156,181,46,149,12,215,83,208,33,158,76,116,72,51,27,204,0,112,124,37,148,61,174,103,77,125,213,144,84,179,171,186,204,231,130,187,230},
  {136,235,202,111,190,219,195,84,35,251,191,174,222,252,130,22,201,247,13,216,116,218,59,193,155,49,221,153,153,119,226,3,237,83,3,14,153,151,98,143,109,177,73,47,218,148,184,161,210,69,234,228,13,157,152,117,37,68,155,131,27,130,58,77,76,12,42,195,57,119,82,247,8,168,180,83,142,94,62,140,129,3,42,86,15,169,152,164,238,208,206,193,203,229,133,55,94,187,87,240,32,52,105,45,194,65,75,245,85,243,96,242,7,85,205,101,56,225,235,104,49,5,229,25,130,200,200,250,9,65,174,48,235,232,160,224,222,168,137,143,40,230,191,181,121,159,172,80,208,181,25,67,129,131,219,140,141,191,96,165,54,67,144,58,191,83,176,198,66,84,247,111,238,142,88,131,100,128,70,222,38,111,94,221,224,105,229,148,53,229,65,44,144,135,140,32,134,188,208,76,217,103,53,217,6,27,211,253,200,232,80,152,22,149,112,30,240,103,80,128,166,101,120,112,151,183,185,30,50,115,116,102,234,225,148,105,13,112,9,40,239,37,83,52,6,131,144,230,8,18,246,159,249,254,182,1,194,4,165,244,239,221,249,51,78,75,80,144,87,124,154,171,118,221,49,110,242,17,146,2,232,148,167,56,22,83,71,35,76,166,155,28,189,177,83,68,221,216,190,240,209,61,128,16,105,127,249,249,214,20,221,177,188,107,14,236,136,84,242,15,62,165,156,3,188,171,49,6,223,38,123,13,215,118,50,52,194,162,240,221,171,8,26,163,251,5,129,141,49,248,146,130,120,188,205,214,231,114,152,93,148,251,223,177,215,71,195,12,68,111,91,92,22,156,17,181,196,126,38,167,240,66,223,169,33,159,252,79,138,35,169,139,224,157,144,103,200,186,50,209,165,132,23,228,193,84,135,139,112,151,56,98,83,197,42,183,59,252,113,220,89,37,179,171,2,14,158,153,102,93,108,45,76,101,132,164,108,42,160,78,184,209,86,40,241,115,43,214,158,61,228,254,83,211,162,21,90,17,198,214,217,20,155,68,229,86,203,8,102,184,160,122,44,130,225,113,225,180,32,186,176,165,207,201,86,231,138,128,105,197,103,168,249,35,54,238,163,113,165,112,47,24,80,215,220,88,249,123,147,158,30,167,119,216,107,86,227,6,152,131,89,115,66,154,87,156,209,64,154,96,145,224,129,255,204,18,156,39,31,153,199,13,47,215,72,146,235,12,56,165,69,150,59,209,230,230,222,132,12,196,15,171,174,129,196,200,206,3,90,50,197,103,85,137,104,48,83,246,106,46,245,24,110,233,210,88,37,143,116,228,31,197,55,17,175,153,183,169,110,117,23,152,248,76,100,119,243,165,142,127,34,72,5,23,5,49,78,179,197,35,146,104,176,18,221,201,64,51,200,223,6,146,186,119,232,210,200,94,161,232,164,43,172,193,195,91,183,49,156,150,33,171,159,1,82,232,10,141,195,16,101,250,232,133,113,97,39,183,106,253,127,182,147,73,112,210,132,93,240,156,117,242,145,103,205,42,54,76,61,129,171,48,74,142,102,167,80,213,57,225,40,120,179,227,116,163,65,186,50,100,248,116,88,11,83,35,237,20,248,198,78,18,248,216,115,28,139,211,79,121,229,147,217,117,48,52,180,153,13,194,189,64,237,19,155,145,221,8,154,223,161,57,252,10,225,29,132,135,174,213,74,236,131,237,152,179,159,168,176,64,235,244,167,78,227,80,153,186,124,73,185,112,42,251,174,105,198,180,67,46,36,64,217,221,1,243,180,103,235,116,56,114,52,95,131,17,23,50,16,113,105,36,105,142,186,1,41,13,17,103,54,246,152,78,20,123,79,7,34,189,242,105,235,143,81,216,198,96,124,131,224,95,109,176,40,211,83,136,36,193,140,163,115,142,6,65,225,220,207,238,60,242,17,67,183,209,231,118,1,105,176,236,102,247,125,63,21,216,44,185,212,102,251,216,105,170,86,81,74,35,89,202,180,76,178,120,218,191,70,142,73,188,236,57,89,208,244,126,99,87,222,229,245,31,80,101,42,89,87,161,72,204,108,34,177,76,132,111,150,153,218,117,160,146,21,0,13,248,59,150,198,131,72,170,138,174,141,64,125,40,100,247,230},
  {203,25,189,229,166,73,29,179,183,217,51,169,240,254,187,212,234,247,212,16,1,245,146,230,240,75,226,117,117,20,27,164,59,163,31,242,107,88,133,63,165,65,239,126,10,85,49,246,96,59,213,144,134,22,61,211,37,203,66,132,174,85,162,67,46,192,193,249,86,84,103,72,18,81,211,231,196,4,104,121,112,67,18,100,86,60,121,62,240,160,59,242,240,12,104,86,179,154,215,107,155,18,167,201,82,156,75,179,185,229,223,205,53,133,149,156,83,32,141,151,36,117,214,137,138,32,193,243,4,105,125,154,102,221,229,37,108,224,5,248,39,154,50,180,168,226,49,131,53,108,251,50,130,186,165,34,192,156,107,48,126,193,91,209,160,21,237,207,108,21,59,46,8,37,5,253,37,120,229,15,101,70,207,151,124,1,103,105,48,165,63,1,251,97,38,180,195,32,133,226,107,115,110,63,74,51,34,145,201,109,74,17,239,83,78,162,212,192,44,64,115,98,228,8,128,21,87,64,81,97,246,142,164,57,169,183,76,104,146,211,103,55,63,212,231,30,186,57,164,159,217,56,202,167,101,195,205,65,171,254,186,18,6,176,180,214,2,112,194,56,177,8,23,214,189,196,53,158,48,254,195,243,158,65,232,166,48,41,219,155,65,29,32,193,160,70,137,152,143,52,227,120,7,79,53,219,149,6,183,255,51,89,76,38,131,117,177,168,243,202,238,38,78,249,57,190,20,193,69,107,132,53,106,221,216,121,98,208,78,216,29,248,43,184,112,120,173,16,213,215,107,34,255,61,157,33,146,137,12,141,221,81,117,169,205,143,166,9,22,189,144,223,80,189,247,69,138,11,32,100,182,11,220,47,48,39,63,140,32,182,54,250,33,102,150,11,182,231,239,23,134,158,112,64,234,97,80,124,209,208,209,94,175,61,51,155,86,20,192,111,101,191,55,70,90,160,182,69,77,247,176,242,126,136,196,10,160,165,4,105,97,19,189,41,142,105,93,185,220,26,194,141,137,163,206,28,45,175,152,181,14,245,206,114,32,242,126,96,132,120,151,121,236,25,108,248,218,204,43,111,187,153,248,130,211,231,124,151,77,35,20,15,5,34,18,37,140,4,60,252,21,206,170,135,17,60,108,168,96,191,219,73,138,192,145,235,237,18,151,217,110,227,201,48,196,80,28,15,119,46,146,237,222,140,208,68,139,10,221,130,8,125,7,10,113,17,134,29,124,8,49,150,219,23,47,115,13,115,202,177,74,162,98,153,149,192,96,83,48,96,100,101,45,129,92,177,235,102,248,70,143,103,170,24,78,120,219,232,255,243,75,62,148,164,212,147,57,230,49,102,56,57,210,156,45,145,61,145,221,56,140,246,169,20,4,149,5,150,76,90,98,93,244,202,185,97,63,55,231,243,216,81,102,31,108,9,91,206,112,15,216,35,119,88,41,89,49,214,85,13,93,177,242,43,12,145,93,134,216,187,53,104,28,112,95,254,50,50,181,141,107,14,8,204,109,96,181,136,66,178,114,51,46,25,235,207,112,62,215,242,138,103,237,239,153,33,29,47,126,133,134,251,57,17,140,163,236,23,89,247,109,247,231,116,147,2,169,225,100,127,100,157,214,138,145,55,123,173,133,90,156,101,147,246,123,21,60,84,9,58,77,150,79,129,172,68,221,24,146,196,193,161,176,254,60,10,53,248,62,80,73,103,76,104,128,5,163,73,235,72,221,243,55,24,104,15,64,233,9,211,132,134,92,169,93,25,92,175,242,237,204,70,109,83,231,93,167,107,143,120,1,17,106,200,121,65,154,32,165,68,94,107,253,140,96,109,252,144,196,136,172,13,125,133,246,242,67,204,175,114,32,69,137,74,206,19,113,105,25,165,14,13,39,6,156,43,10,254,87,233,165,176,121,7,40,238,174,29,253,96,248,138,20,42,136,147,126,21,111,221,221,146,94,190,114,135,183,56,67,155,216,93,237,209,122,90,35,65,156,67,19,31,242,210,214,104,36,46,253,127,40,194,179,5,62,162,250,117,71,110,208,117,120,148,37,117,242,200,212,24,187,179,247,168,105,82,63,180,114,89,42,32,221,52,100,70,74,99,65,252,57,107,29,87,144,104,229,75,150,124,15,152,92},
  {1,0,255,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
} ;

static const unsigned char precomputed_core_inv3sntrup953_k[precomputed_core_inv3sntrup953_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_inv3sntrup953_c[precomputed_core_inv3sntrup953_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
  {},
} ;

static void test_core_inv3sntrup953_impl(long long impl)
{
  unsigned char *h = test_core_inv3sntrup953_h;
  unsigned char *n = test_core_inv3sntrup953_n;
  unsigned char *k = test_core_inv3sntrup953_k;
  unsigned char *c = test_core_inv3sntrup953_c;
  unsigned char *h2 = test_core_inv3sntrup953_h2;
  unsigned char *n2 = test_core_inv3sntrup953_n2;
  unsigned char *k2 = test_core_inv3sntrup953_k2;
  unsigned char *c2 = test_core_inv3sntrup953_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_inv3sntrup953_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_inv3sntrup953(impl);
    printf("core_inv3sntrup953 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_inv3sntrup953_implementation(impl),ntruprime_dispatch_core_inv3sntrup953_compiler(impl));
  } else {
    crypto_core = ntruprime_core_inv3sntrup953;
    printf("core_inv3sntrup953 selected implementation %s compiler %s\n",ntruprime_core_inv3sntrup953_implementation(),ntruprime_core_inv3sntrup953_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");
    }
    checksum_expected(core_inv3sntrup953_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_inv3sntrup953_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_inv3sntrup953_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_inv3sntrup953_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_inv3sntrup953_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_inv3sntrup953_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_inv3sntrup953_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_inv3sntrup953_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_inv3sntrup953_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_inv3sntrup953_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_inv3sntrup953(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"inv3sntrup953")) return;
  storage_core_inv3sntrup953_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_inv3sntrup953_h = aligned(storage_core_inv3sntrup953_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_inv3sntrup953_n = callocplus(crypto_core_INPUTBYTES);
  test_core_inv3sntrup953_n = aligned(storage_core_inv3sntrup953_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_inv3sntrup953_k = callocplus(crypto_core_KEYBYTES);
  test_core_inv3sntrup953_k = aligned(storage_core_inv3sntrup953_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_inv3sntrup953_c = callocplus(crypto_core_CONSTBYTES);
  test_core_inv3sntrup953_c = aligned(storage_core_inv3sntrup953_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_inv3sntrup953_h2 = callocplus(maxalloc);
  test_core_inv3sntrup953_h2 = aligned(storage_core_inv3sntrup953_h2,crypto_core_OUTPUTBYTES);
  storage_core_inv3sntrup953_n2 = callocplus(maxalloc);
  test_core_inv3sntrup953_n2 = aligned(storage_core_inv3sntrup953_n2,crypto_core_INPUTBYTES);
  storage_core_inv3sntrup953_k2 = callocplus(maxalloc);
  test_core_inv3sntrup953_k2 = aligned(storage_core_inv3sntrup953_k2,crypto_core_KEYBYTES);
  storage_core_inv3sntrup953_c2 = callocplus(maxalloc);
  test_core_inv3sntrup953_c2 = aligned(storage_core_inv3sntrup953_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_inv3sntrup953 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_inv3sntrup953();++impl)
      forked(test_core_inv3sntrup953_impl,impl);
    ++test_core_inv3sntrup953_h;
    ++test_core_inv3sntrup953_n;
    ++test_core_inv3sntrup953_k;
    ++test_core_inv3sntrup953_c;
    ++test_core_inv3sntrup953_h2;
    ++test_core_inv3sntrup953_n2;
    ++test_core_inv3sntrup953_k2;
    ++test_core_inv3sntrup953_c2;
  }
  free(storage_core_inv3sntrup953_c2);
  free(storage_core_inv3sntrup953_k2);
  free(storage_core_inv3sntrup953_n2);
  free(storage_core_inv3sntrup953_h2);
  free(storage_core_inv3sntrup953_c);
  free(storage_core_inv3sntrup953_k);
  free(storage_core_inv3sntrup953_n);
  free(storage_core_inv3sntrup953_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

